#-------------------------------------------------------------------------------
MACRO (HDFEOS_SET_LIB_OPTIONS libtarget libname libtype)
  SET (LIB_OUT_NAME "${libname}")
  IF (${libtype} MATCHES "SHARED")
    IF (WIN32)
      SET (LIBHDFEOS_VERSION ${HDFEOS_PACKAGE_VERSION_MAJOR})
    ELSE (WIN32)
      SET (LIBHDFEOS_VERSION ${HDFEOS_PACKAGE_VERSION})
    ENDIF (WIN32)
    SET_TARGET_PROPERTIES (${libtarget} PROPERTIES VERSION ${LIBHDFEOS_VERSION})
#    IF (WIN32)
#      SET (${LIB_OUT_NAME} "${LIB_OUT_NAME}-${HDFEOS_PACKAGE_SOVERSION}")
#    ELSE (WIN32)
#       SET_TARGET_PROPERTIES (${libtarget} PROPERTIES SOVERSION ${HDFEOS_PACKAGE_SOVERSION})
#    ENDIF (WIN32)
    SET_TARGET_PROPERTIES (${libtarget} PROPERTIES SOVERSION ${LIBHDFEOS_VERSION})
  ENDIF (${libtype} MATCHES "SHARED")
  EOS_SET_LIB_OPTIONS (${libtarget} ${LIB_OUT_NAME} ${libtype})

  #-- Apple Specific install_name for libraries
  IF (APPLE)
    OPTION (HDFEOS_BUILD_WITH_INSTALL_NAME "Build with library install_name set to the installation path" OFF)
    IF (HDFEOS_BUILD_WITH_INSTALL_NAME)
      SET_TARGET_PROPERTIES (${libtarget} PROPERTIES
          LINK_FLAGS "-current_version ${HDFEOS_PACKAGE_VERSION} -compatibility_version ${HDFEOS_PACKAGE_VERSION}"
          INSTALL_NAME_DIR "${CMAKE_INSTALL_PREFIX}/lib"
          BUILD_WITH_INSTALL_RPATH ${HDFEOS_BUILD_WITH_INSTALL_NAME}
      )
    ENDIF (HDFEOS_BUILD_WITH_INSTALL_NAME)
  ENDIF (APPLE)

ENDMACRO (HDFEOS_SET_LIB_OPTIONS)

