/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef STANDARDOSD_H
#define STANDARDOSD_H

#include "osd.h"

#include <QGraphicsGridLayout>
#include <QGraphicsLinearLayout>

#include <Plasma/Label>
#include <Plasma/Meter>

class StandardOsd : public Osd
{
public:
    StandardOsd();
    ~StandardOsd();

protected:
    QSize requestedPixmapSize() const;
    void setContents(const QPixmap &pixmap, const QString &text, unsigned char percent);
    
private:
    QGraphicsLinearLayout *m_hlayout;
    QGraphicsLinearLayout *m_vlayout;

    Plasma::Label *m_icon;
    Plasma::Label *m_text;
    Plasma::Meter *m_meter;
};

#endif // STANDARDOSD_H
