# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1SecurityContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capabilities': 'V1Capabilities',
            'privileged': 'bool',
            'se_linux_options': 'V1SELinuxOptions',
            'run_as_user': 'int'
        }

        self.attribute_map = {
            'capabilities': 'capabilities',
            'privileged': 'privileged',
            'se_linux_options': 'seLinuxOptions',
            'run_as_user': 'runAsUser'
        }

        self._capabilities = None
        self._privileged = None
        self._se_linux_options = None
        self._run_as_user = None

    @property
    def capabilities(self):
        """
        Gets the capabilities of this V1SecurityContext.
        the linux capabilites that should be added or removed; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :return: The capabilities of this V1SecurityContext.
        :rtype: V1Capabilities
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this V1SecurityContext.
        the linux capabilites that should be added or removed; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :param capabilities: The capabilities of this V1SecurityContext.
        :type: V1Capabilities
        """
        self._capabilities = capabilities

    @property
    def privileged(self):
        """
        Gets the privileged of this V1SecurityContext.
        run the container in privileged mode; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :return: The privileged of this V1SecurityContext.
        :rtype: bool
        """
        return self._privileged

    @privileged.setter
    def privileged(self, privileged):
        """
        Sets the privileged of this V1SecurityContext.
        run the container in privileged mode; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :param privileged: The privileged of this V1SecurityContext.
        :type: bool
        """
        self._privileged = privileged

    @property
    def se_linux_options(self):
        """
        Gets the se_linux_options of this V1SecurityContext.
        options that control the SELinux labels applied; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :return: The se_linux_options of this V1SecurityContext.
        :rtype: V1SELinuxOptions
        """
        return self._se_linux_options

    @se_linux_options.setter
    def se_linux_options(self, se_linux_options):
        """
        Sets the se_linux_options of this V1SecurityContext.
        options that control the SELinux labels applied; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :param se_linux_options: The se_linux_options of this V1SecurityContext.
        :type: V1SELinuxOptions
        """
        self._se_linux_options = se_linux_options

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this V1SecurityContext.
        the user id that runs the first process in the container; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :return: The run_as_user of this V1SecurityContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this V1SecurityContext.
        the user id that runs the first process in the container; see http://releases.k8s.io/v1.0.4/docs/design/security_context.md#security-context

        :param run_as_user: The run_as_user of this V1SecurityContext.
        :type: int
        """
        self._run_as_user = run_as_user

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
