/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File IconObject.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef IconObject_H
#define IconObject_H

#ifndef Counted_H
#include "Counted.h"
#endif

#include <string>
using std::string;


class IconClass;
class IconInfo;
class FolderObserver;
class Action;
class Queue;
class Folder;
class CommandObserver;
class Editor;
class Action;
class Request;
class Task;
class Log;
class LogWindow;
class Language;

#include "Metview.h"

#ifndef Path_H
#include "Path.h"
#endif

#ifndef Dependancy_H
#include "Dependancy.h"
#endif

#ifndef IconObserver_H
#include "IconObserver.h"
#endif


class IconObject;
class IconObjectH;

class IconObject : public virtual Counted {
public:

// -- Exceptions
	// None

// -- Contructors

	IconObject(Folder*,const IconClass&,const string&,IconInfo*);

// -- Destructor

	virtual ~IconObject();

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual const string& name() const;
	virtual const string& className() const;

	virtual string dotName(const string&) const;
	virtual string embeddedName(const string&) const;
	virtual string fullName() const;

	virtual string relativeName(IconObject*) const;
	virtual string makeFullName(const string&) const;

	virtual Path path()     const;
	// This Path method will only be all by the Shell Task.
	// For all object it will call the path method.
	// For Temporary Objects, it will return the PATH of the attached request.
	// This is done to enable the visualisation of the MAGML Objects 
	// without possible side effects! 
	virtual Path pathForShellTask() const { return path(); }
	virtual Path dotPath()  const;
	virtual Path embeddedPath()  const;

	virtual const IconClass& iconClass() const;
	virtual const IconClass& editorClass() const;

	virtual Folder*    parent()    const;
	virtual Folder*    embeddedFolder(const string&,bool create = true)    const;
	virtual Folder*    embeddedFolder(bool create = true)    const;

	// Info

	virtual IconInfo& info() const;
	virtual void saveInfo();

	virtual bool visible() const;

	// Actions

	virtual void doubleClick();
	virtual void command(const string&);
	virtual Task* action(const Action&);
	virtual set<string> can();

	virtual void toWastebasket();
	virtual void duplicate();
	virtual void removeFiles();
	virtual void edit();
	virtual void edit2();
	virtual void showLog();

	virtual void destroy();
	virtual void empty();

	virtual IconObject* clone(Folder*, bool update = false);

	virtual void editor(Editor*);
	virtual Editor* editor();

	virtual void logWindow(LogWindow*);
	virtual LogWindow* logWindow();

	virtual Request request() const;
	virtual Request fullRequest() const;
	virtual Language& language() const;

	virtual void request(const Request&);

	virtual string dropText() const;

	virtual void drop(IconObject*);


	virtual const set<DependancyH>& dependancies();

	// Find

	virtual IconObject* find(const vector<string>&);
	virtual IconObject* find(const string&);


	// Move

	virtual void reparent(Folder*);
	virtual bool rename(const string&);
	virtual bool renamable() const;
	virtual bool temporary() const;

	void position(int,int);
	virtual bool locked() const;
	virtual bool isLink() const;
	virtual bool isInTimer() const;
	virtual void lock();

	// 

	void addObserver(IconObserver*);
	void removeObserver(IconObserver*);

	//

	virtual void notifyWaiting();
	virtual void notifyError();
	virtual void notifyChanged();
	virtual void notifyReady();
	virtual void notifyOpened();
	virtual void notifyClosed();
	virtual void notifyDestroyed();


	virtual bool sameAs(IconObject*);
	virtual void touch();
	//


	virtual void createFiles();

	// Status

	virtual void created();
	virtual void modified();

	virtual Log& log();
	virtual Path logPath();

	// --- 

	virtual vector<IconObjectH> subObjects(const string&,const Request&);
	virtual void subObjects(const string&,const vector<IconObjectH>&,Request&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	static IconObject* search(const string& fullName);
	static IconObject* search(IconObject&,const string& relativeName);

protected:


// -- Members

	string           name_;
	Folder*          parent_;
	const IconClass& class_;
	IconInfo*        info_;
	Queue*           queue_;
	Log*             log_;
	Editor*          editor_;
	LogWindow*       logWindow_;
	bool             locked_;
	bool             link_;

	set<DependancyH> dependancies_;
	set<IconObserver*> observers_;

// -- Methods
	
	virtual void print(ostream&) const; // Change to virtual if base class	
	virtual void reset();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	IconObject(const IconObject&);
	IconObject& operator=(const IconObject&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	friend ostream& operator<<(ostream& s,const IconObject& p)
		{ p.print(s); return s; }

};

class IconObjectH : public  Handle<IconObject> {
public:
	IconObjectH(IconObject* o = 0) : Handle<IconObject>(o) {}
};

#endif
