/* moonshot-local-flat-file-store.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-local-flat-file-store.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "config.h"
#include <glib/gstdio.h>
#include <gio/gio.h>


#define TYPE_IIDENTITY_CARD_STORE (iidentity_card_store_get_type ())
#define IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStore))
#define IS_IIDENTITY_CARD_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IIDENTITY_CARD_STORE))
#define IIDENTITY_CARD_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IIDENTITY_CARD_STORE, IIdentityCardStoreIface))

typedef struct _IIdentityCardStore IIdentityCardStore;
typedef struct _IIdentityCardStoreIface IIdentityCardStoreIface;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define IIDENTITY_CARD_STORE_TYPE_STORE_TYPE (iidentity_card_store_store_type_get_type ())

#define TYPE_LOCAL_FLAT_FILE_STORE (local_flat_file_store_get_type ())
#define LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore))
#define LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))
#define IS_LOCAL_FLAT_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCAL_FLAT_FILE_STORE))
#define IS_LOCAL_FLAT_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCAL_FLAT_FILE_STORE))
#define LOCAL_FLAT_FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStoreClass))

typedef struct _LocalFlatFileStore LocalFlatFileStore;
typedef struct _LocalFlatFileStoreClass LocalFlatFileStoreClass;
typedef struct _LocalFlatFileStorePrivate LocalFlatFileStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

typedef enum  {
	IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE,
	IIDENTITY_CARD_STORE_STORE_TYPE_KEYRING
} IIdentityCardStoreStoreType;

struct _IIdentityCardStoreIface {
	GTypeInterface parent_iface;
	void (*add_card) (IIdentityCardStore* self, IdCard* card);
	gboolean (*remove_card) (IIdentityCardStore* self, IdCard* card);
	IdCard* (*update_card) (IIdentityCardStore* self, IdCard* card);
	IIdentityCardStoreStoreType (*get_store_type) (IIdentityCardStore* self);
	GeeLinkedList* (*get_card_list) (IIdentityCardStore* self);
};

struct _LocalFlatFileStore {
	GObject parent_instance;
	LocalFlatFileStorePrivate * priv;
};

struct _LocalFlatFileStoreClass {
	GObjectClass parent_class;
};

struct _LocalFlatFileStorePrivate {
	GeeLinkedList* id_card_list;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};


static gpointer local_flat_file_store_parent_class = NULL;
static IIdentityCardStoreIface* local_flat_file_store_iidentity_card_store_parent_iface = NULL;

GType id_card_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_store_type_get_type (void) G_GNUC_CONST;
GType iidentity_card_store_get_type (void) G_GNUC_CONST;
GType local_flat_file_store_get_type (void) G_GNUC_CONST;
#define LOCAL_FLAT_FILE_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStorePrivate))
enum  {
	LOCAL_FLAT_FILE_STORE_DUMMY_PROPERTY
};
#define LOCAL_FLAT_FILE_STORE_FILE_NAME "identities.txt"
static void local_flat_file_store_real_add_card (IIdentityCardStore* base, IdCard* card);
void local_flat_file_store_store_id_cards (LocalFlatFileStore* self);
static IdCard* local_flat_file_store_real_update_card (IIdentityCardStore* base, IdCard* card);
const gchar* id_card_get_display_name (IdCard* self);
static gboolean local_flat_file_store_real_remove_card (IIdentityCardStore* base, IdCard* card);
static GeeLinkedList* local_flat_file_store_real_get_card_list (IIdentityCardStore* base);
static IIdentityCardStoreStoreType local_flat_file_store_real_get_store_type (IIdentityCardStore* base);
static void local_flat_file_store_load_id_cards (LocalFlatFileStore* self);
static gchar* local_flat_file_store_get_data_dir (LocalFlatFileStore* self);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_store_password (IdCard* self, gboolean value);
const gchar* id_card_get_password (IdCard* self);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value);
void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
static Rule* _vala_array_dup1 (Rule* self, int length);
gchar** id_card_get_services (IdCard* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
const gchar* id_card_get_issuer (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
gboolean id_card_get_store_password (IdCard* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
LocalFlatFileStore* local_flat_file_store_new (void);
LocalFlatFileStore* local_flat_file_store_construct (GType object_type);
static void local_flat_file_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void local_flat_file_store_real_add_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_if_fail (card != NULL);
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 39 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_store_id_cards (self);
#line 206 "moonshot-local-flat-file-store.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 213 "moonshot-local-flat-file-store.c"
}


static IdCard* local_flat_file_store_real_update_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	IdCard* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (card != NULL, NULL);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = self->priv->id_card_list;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = card;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_store_id_cards (self);
#line 242 "moonshot-local-flat-file-store.c"
	{
		GeeLinkedList* _idcard_list = NULL;
		GeeLinkedList* _tmp4_ = NULL;
		GeeLinkedList* _tmp5_ = NULL;
		gint _idcard_size = 0;
		GeeLinkedList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _idcard_index = 0;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = self->priv->id_card_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_list = _tmp5_;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp6_ = _idcard_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp8_ = _tmp7_;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_size = _tmp8_;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_idcard_index = -1;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		while (TRUE) {
#line 270 "moonshot-local-flat-file-store.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			IdCard* idcard = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			IdCard* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			IdCard* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp9_ = _idcard_index;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_idcard_index = _tmp9_ + 1;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp10_ = _idcard_index;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp11_ = _idcard_size;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				break;
#line 296 "moonshot-local-flat-file-store.c"
			}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp12_ = _idcard_list;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp13_ = _idcard_index;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			idcard = (IdCard*) _tmp14_;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp15_ = idcard;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp16_ = id_card_get_display_name (_tmp15_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp17_ = _tmp16_;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp18_ = card;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19_ = id_card_get_display_name (_tmp18_);
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp20_ = _tmp19_;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				result = idcard;
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_g_object_unref0 (_idcard_list);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				return result;
#line 326 "moonshot-local-flat-file-store.c"
			}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (idcard);
#line 330 "moonshot-local-flat-file-store.c"
		}
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (_idcard_list);
#line 334 "moonshot-local-flat-file-store.c"
	}
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = NULL;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 340 "moonshot-local-flat-file-store.c"
}


static gboolean local_flat_file_store_real_remove_card (IIdentityCardStore* base, IdCard* card) {
	LocalFlatFileStore * self;
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (card != NULL, FALSE);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = card;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (_tmp2_) {
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		local_flat_file_store_store_id_cards (self);
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		result = TRUE;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return result;
#line 368 "moonshot-local-flat-file-store.c"
	}
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = FALSE;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 374 "moonshot-local-flat-file-store.c"
}


static GeeLinkedList* local_flat_file_store_real_get_card_list (IIdentityCardStore* base) {
	LocalFlatFileStore * self;
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = _tmp1_;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 393 "moonshot-local-flat-file-store.c"
}


static IIdentityCardStoreStoreType local_flat_file_store_real_get_store_type (IIdentityCardStore* base) {
	LocalFlatFileStore * self;
	IIdentityCardStoreStoreType result = 0;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) base;
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = IIDENTITY_CARD_STORE_STORE_TYPE_FLAT_FILE;
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 406 "moonshot-local-flat-file-store.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (array != NULL) {
#line 413 "moonshot-local-flat-file-store.c"
		int i;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rule_destroy (&array[i]);
#line 419 "moonshot-local-flat-file-store.c"
		}
	}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_free (array);
#line 424 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_load_id_cards (LocalFlatFileStore* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp1_ = NULL;
	gchar* path = NULL;
	gchar* _tmp2_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** identities_uris = NULL;
	GKeyFile* _tmp10_ = NULL;
	gsize _tmp11_;
	gchar** _tmp12_ = NULL;
	gint identities_uris_length1 = 0;
	gint _identities_uris_size_ = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	GError * _inner_error_ = NULL;
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = self->priv->id_card_list;
#line 70 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = g_key_file_new ();
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	key_file = _tmp1_;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = local_flat_file_store_get_data_dir (self);
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	path = _tmp2_;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = path;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp4_ = g_build_filename (_tmp3_, LOCAL_FLAT_FILE_STORE_FILE_NAME, NULL);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	filename = _tmp4_;
#line 466 "moonshot-local-flat-file-store.c"
	{
		GKeyFile* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp5_ = key_file;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp6_ = filename;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_key_file_load_from_file (_tmp5_, _tmp6_, G_KEY_FILE_NONE, &_inner_error_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (_inner_error_ != NULL) {
#line 478 "moonshot-local-flat-file-store.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		e = _inner_error_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_inner_error_ = NULL;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp7_ = stdout;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp8_ = e;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp9_ = _tmp8_->message;
#line 79 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		fprintf (_tmp7_, "Error: %s\n", _tmp9_);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_error_free0 (e);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_free0 (key_file);
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 511 "moonshot-local-flat-file-store.c"
	}
	__finally5:
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (_inner_error_ != NULL) {
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_free0 (key_file);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_clear_error (&_inner_error_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 528 "moonshot-local-flat-file-store.c"
	}
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp10_ = key_file;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp12_ = g_key_file_get_groups (_tmp10_, &_tmp11_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris = _tmp12_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris_length1 = _tmp11_;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_identities_uris_size_ = identities_uris_length1;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp13_ = identities_uris;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp13__length1 = identities_uris_length1;
#line 544 "moonshot-local-flat-file-store.c"
	{
		gchar** identity_collection = NULL;
		gint identity_collection_length1 = 0;
		gint _identity_collection_size_ = 0;
		gint identity_it = 0;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		identity_collection = _tmp13_;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		identity_collection_length1 = _tmp13__length1;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		for (identity_it = 0; identity_it < _tmp13__length1; identity_it = identity_it + 1) {
#line 556 "moonshot-local-flat-file-store.c"
			gchar* _tmp14_ = NULL;
			gchar* identity = NULL;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14_ = g_strdup (identity_collection[identity_it]);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			identity = _tmp14_;
#line 563 "moonshot-local-flat-file-store.c"
			{
				{
					IdCard* id_card = NULL;
					IdCard* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					GKeyFile* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					IdCard* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					GKeyFile* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					IdCard* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					GKeyFile* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					IdCard* _tmp30_ = NULL;
					gchar** _tmp31_ = NULL;
					GKeyFile* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gsize _tmp34_;
					gchar** _tmp35_ = NULL;
					gint _tmp31__length1 = 0;
					gint __tmp31__size_ = 0;
					IdCard* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					GKeyFile* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					IdCard* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					GKeyFile* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_ = FALSE;
					GKeyFile* _tmp63_ = NULL;
					const gchar* _tmp64_ = NULL;
					gboolean _tmp65_ = FALSE;
					gchar* _tmp100_ = NULL;
					GKeyFile* _tmp101_ = NULL;
					const gchar* _tmp102_ = NULL;
					gchar* _tmp103_ = NULL;
					IdCard* _tmp104_ = NULL;
					TrustAnchor* _tmp105_ = NULL;
					TrustAnchor* _tmp106_ = NULL;
					gchar* _tmp107_ = NULL;
					GKeyFile* _tmp108_ = NULL;
					const gchar* _tmp109_ = NULL;
					gchar* _tmp110_ = NULL;
					IdCard* _tmp111_ = NULL;
					TrustAnchor* _tmp112_ = NULL;
					TrustAnchor* _tmp113_ = NULL;
					gchar* _tmp114_ = NULL;
					GKeyFile* _tmp115_ = NULL;
					const gchar* _tmp116_ = NULL;
					gchar* _tmp117_ = NULL;
					IdCard* _tmp118_ = NULL;
					TrustAnchor* _tmp119_ = NULL;
					TrustAnchor* _tmp120_ = NULL;
					gchar* _tmp121_ = NULL;
					GKeyFile* _tmp122_ = NULL;
					const gchar* _tmp123_ = NULL;
					gchar* _tmp124_ = NULL;
					IdCard* _tmp125_ = NULL;
					TrustAnchor* _tmp126_ = NULL;
					TrustAnchor* _tmp127_ = NULL;
					GeeLinkedList* _tmp128_ = NULL;
					IdCard* _tmp129_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp15_ = id_card_new ();
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card = _tmp15_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp17_ = key_file;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp18_ = identity;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp19_ = g_key_file_get_string (_tmp17_, _tmp18_, "Issuer", &_inner_error_);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp16_ = _tmp19_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 651 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp20_ = id_card;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_issuer (_tmp20_, _tmp16_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp22_ = key_file;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp23_ = identity;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp24_ = g_key_file_get_string (_tmp22_, _tmp23_, "Username", &_inner_error_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp21_ = _tmp24_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 672 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp25_ = id_card;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_username (_tmp25_, _tmp21_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp27_ = key_file;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp28_ = identity;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp29_ = g_key_file_get_string (_tmp27_, _tmp28_, "Password", &_inner_error_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp26_ = _tmp29_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 695 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp30_ = id_card;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_password (_tmp30_, _tmp26_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp32_ = key_file;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp33_ = identity;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp35_ = g_key_file_get_string_list (_tmp32_, _tmp33_, "Services", &_tmp34_, &_inner_error_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp31_ = _tmp35_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp31__length1 = _tmp34_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					__tmp31__size_ = _tmp31__length1;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 724 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp36_ = id_card;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_services (_tmp36_, _tmp31_, _tmp31__length1);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp38_ = key_file;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp39_ = identity;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp40_ = g_key_file_get_string (_tmp38_, _tmp39_, "DisplayName", &_inner_error_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp37_ = _tmp40_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 751 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp41_ = id_card;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					id_card_set_display_name (_tmp41_, _tmp37_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp43_ = key_file;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp44_ = identity;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp45_ = g_key_file_has_key (_tmp43_, _tmp44_, "StorePassword", &_inner_error_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp42_ = _tmp45_;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 780 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp42_) {
#line 785 "moonshot-local-flat-file-store.c"
						gchar* _tmp46_ = NULL;
						GKeyFile* _tmp47_ = NULL;
						const gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						IdCard* _tmp50_ = NULL;
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp47_ = key_file;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp48_ = identity;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp49_ = g_key_file_get_string (_tmp47_, _tmp48_, "StorePassword", &_inner_error_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp46_ = _tmp49_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_inner_error_ != NULL) {
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp37_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp16_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 815 "moonshot-local-flat-file-store.c"
							goto __catch6_g_error;
						}
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp50_ = id_card;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp51_ = _tmp46_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp46_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp52_ = _tmp51_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						id_card_set_store_password (_tmp50_, g_strcmp0 (_tmp52_, "yes") == 0);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp52_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp46_);
#line 832 "moonshot-local-flat-file-store.c"
					} else {
						gboolean _tmp53_ = FALSE;
						IdCard* _tmp54_ = NULL;
						const gchar* _tmp55_ = NULL;
						const gchar* _tmp56_ = NULL;
						IdCard* _tmp60_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp54_ = id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp55_ = id_card_get_password (_tmp54_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp56_ = _tmp55_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_tmp56_ != NULL) {
#line 847 "moonshot-local-flat-file-store.c"
							IdCard* _tmp57_ = NULL;
							const gchar* _tmp58_ = NULL;
							const gchar* _tmp59_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp57_ = id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp58_ = id_card_get_password (_tmp57_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp59_ = _tmp58_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp53_ = g_strcmp0 (_tmp59_, "") != 0;
#line 859 "moonshot-local-flat-file-store.c"
						} else {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp53_ = FALSE;
#line 863 "moonshot-local-flat-file-store.c"
						}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp60_ = id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						id_card_set_store_password (_tmp60_, _tmp53_);
#line 869 "moonshot-local-flat-file-store.c"
					}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp63_ = key_file;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp64_ = identity;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp65_ = g_key_file_has_key (_tmp63_, _tmp64_, "Rules-Patterns", &_inner_error_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp62_ = _tmp65_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 893 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp62_) {
#line 898 "moonshot-local-flat-file-store.c"
						gboolean _tmp66_ = FALSE;
						GKeyFile* _tmp67_ = NULL;
						const gchar* _tmp68_ = NULL;
						gboolean _tmp69_ = FALSE;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp67_ = key_file;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp68_ = identity;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp69_ = g_key_file_has_key (_tmp67_, _tmp68_, "Rules-AlwaysConfirm", &_inner_error_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp66_ = _tmp69_;
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_inner_error_ != NULL) {
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp37_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp16_);
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 925 "moonshot-local-flat-file-store.c"
							goto __catch6_g_error;
						}
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp61_ = _tmp66_;
#line 930 "moonshot-local-flat-file-store.c"
					} else {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp61_ = FALSE;
#line 934 "moonshot-local-flat-file-store.c"
					}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_tmp61_) {
#line 938 "moonshot-local-flat-file-store.c"
						gchar** rules_patterns = NULL;
						GKeyFile* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gsize _tmp72_;
						gchar** _tmp73_ = NULL;
						gint rules_patterns_length1 = 0;
						gint _rules_patterns_size_ = 0;
						gchar** rules_always_conf = NULL;
						GKeyFile* _tmp74_ = NULL;
						const gchar* _tmp75_ = NULL;
						gsize _tmp76_;
						gchar** _tmp77_ = NULL;
						gint rules_always_conf_length1 = 0;
						gint _rules_always_conf_size_ = 0;
						gchar** _tmp78_ = NULL;
						gint _tmp78__length1 = 0;
						gchar** _tmp79_ = NULL;
						gint _tmp79__length1 = 0;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp70_ = key_file;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp71_ = identity;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp73_ = g_key_file_get_string_list (_tmp70_, _tmp71_, "Rules-Patterns", &_tmp72_, &_inner_error_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns = _tmp73_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns_length1 = _tmp72_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_rules_patterns_size_ = rules_patterns_length1;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_inner_error_ != NULL) {
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp37_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp16_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 983 "moonshot-local-flat-file-store.c"
							goto __catch6_g_error;
						}
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp74_ = key_file;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp75_ = identity;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp77_ = g_key_file_get_string_list (_tmp74_, _tmp75_, "Rules-AlwaysConfirm", &_tmp76_, &_inner_error_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf = _tmp77_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf_length1 = _tmp76_;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_rules_always_conf_size_ = rules_always_conf_length1;
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_inner_error_ != NULL) {
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp37_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp26_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp21_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_free0 (_tmp16_);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_g_object_unref0 (id_card);
#line 1014 "moonshot-local-flat-file-store.c"
							goto __catch6_g_error;
						}
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp78_ = rules_patterns;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp78__length1 = rules_patterns_length1;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp79_ = rules_always_conf;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp79__length1 = rules_always_conf_length1;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (_tmp78__length1 == _tmp79__length1) {
#line 1027 "moonshot-local-flat-file-store.c"
							Rule* rules = NULL;
							gchar** _tmp80_ = NULL;
							gint _tmp80__length1 = 0;
							Rule* _tmp81_ = NULL;
							gint rules_length1 = 0;
							gint _rules_size_ = 0;
							IdCard* _tmp98_ = NULL;
							Rule* _tmp99_ = NULL;
							gint _tmp99__length1 = 0;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp80_ = rules_patterns;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp80__length1 = rules_patterns_length1;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp81_ = g_new0 (Rule, _tmp80__length1);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules = _tmp81_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules_length1 = _tmp80__length1;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_rules_size_ = rules_length1;
#line 1049 "moonshot-local-flat-file-store.c"
							{
								gint i = 0;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
								i = 0;
#line 1054 "moonshot-local-flat-file-store.c"
								{
									gboolean _tmp82_ = FALSE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
									_tmp82_ = TRUE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
									while (TRUE) {
#line 1061 "moonshot-local-flat-file-store.c"
										gint _tmp84_ = 0;
										gchar** _tmp85_ = NULL;
										gint _tmp85__length1 = 0;
										Rule* _tmp86_ = NULL;
										gint _tmp86__length1 = 0;
										gint _tmp87_ = 0;
										gchar** _tmp88_ = NULL;
										gint _tmp88__length1 = 0;
										gint _tmp89_ = 0;
										const gchar* _tmp90_ = NULL;
										gchar* _tmp91_ = NULL;
										gchar** _tmp92_ = NULL;
										gint _tmp92__length1 = 0;
										gint _tmp93_ = 0;
										const gchar* _tmp94_ = NULL;
										gchar* _tmp95_ = NULL;
										Rule _tmp96_ = {0};
										Rule _tmp97_ = {0};
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										if (!_tmp82_) {
#line 1082 "moonshot-local-flat-file-store.c"
											gint _tmp83_ = 0;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											_tmp83_ = i;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											i = _tmp83_ + 1;
#line 1088 "moonshot-local-flat-file-store.c"
										}
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp82_ = FALSE;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp84_ = i;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp85_ = rules_patterns;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp85__length1 = rules_patterns_length1;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										if (!(_tmp84_ < _tmp85__length1)) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
											break;
#line 1102 "moonshot-local-flat-file-store.c"
										}
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp86_ = rules;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp86__length1 = rules_length1;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp87_ = i;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp88_ = rules_patterns;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp88__length1 = rules_patterns_length1;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp89_ = i;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp90_ = _tmp88_[_tmp89_];
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp91_ = g_strdup (_tmp90_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp92_ = rules_always_conf;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp92__length1 = rules_always_conf_length1;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp93_ = i;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp94_ = _tmp92_[_tmp93_];
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp95_ = g_strdup (_tmp94_);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_g_free0 (_tmp96_.pattern);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp96_.pattern = _tmp91_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_g_free0 (_tmp96_.always_confirm);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp96_.always_confirm = _tmp95_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										rule_destroy (&_tmp86_[_tmp87_]);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp86_[_tmp87_] = _tmp96_;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
										_tmp97_ = _tmp86_[_tmp87_];
#line 1144 "moonshot-local-flat-file-store.c"
									}
								}
							}
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp98_ = id_card;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp99_ = rules;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp99__length1 = rules_length1;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							id_card_set_rules (_tmp98_, _tmp99_, _tmp99__length1);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 1158 "moonshot-local-flat-file-store.c"
						}
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 1164 "moonshot-local-flat-file-store.c"
					}
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp101_ = key_file;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp102_ = identity;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp103_ = g_key_file_get_string (_tmp101_, _tmp102_, "CA-Cert", &_inner_error_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp100_ = _tmp103_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1188 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp104_ = id_card;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp105_ = id_card_get_trust_anchor (_tmp104_);
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp106_ = _tmp105_;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					trust_anchor_set_ca_cert (_tmp106_, _tmp100_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp108_ = key_file;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp109_ = identity;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp110_ = g_key_file_get_string (_tmp108_, _tmp109_, "Subject", &_inner_error_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp107_ = _tmp110_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp100_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1223 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp111_ = id_card;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp112_ = id_card_get_trust_anchor (_tmp111_);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp113_ = _tmp112_;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					trust_anchor_set_subject (_tmp113_, _tmp107_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp115_ = key_file;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp116_ = identity;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp117_ = g_key_file_get_string (_tmp115_, _tmp116_, "SubjectAlt", &_inner_error_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp114_ = _tmp117_;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp107_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp100_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1260 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp118_ = id_card;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp119_ = id_card_get_trust_anchor (_tmp118_);
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp120_ = _tmp119_;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					trust_anchor_set_subject_alt (_tmp120_, _tmp114_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp122_ = key_file;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp123_ = identity;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp124_ = g_key_file_get_string (_tmp122_, _tmp123_, "ServerCert", &_inner_error_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp121_ = _tmp124_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					if (_inner_error_ != NULL) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp114_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp107_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp100_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp26_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp21_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp16_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_object_unref0 (id_card);
#line 1299 "moonshot-local-flat-file-store.c"
						goto __catch6_g_error;
					}
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp125_ = id_card;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp126_ = id_card_get_trust_anchor (_tmp125_);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp127_ = _tmp126_;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					trust_anchor_set_server_cert (_tmp127_, _tmp121_);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp128_ = self->priv->id_card_list;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp129_ = id_card;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp128_, _tmp129_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp121_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp114_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp107_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp100_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp37_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp26_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp21_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (_tmp16_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_object_unref0 (id_card);
#line 1336 "moonshot-local-flat-file-store.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					FILE* _tmp130_ = NULL;
					GError* _tmp131_ = NULL;
					const gchar* _tmp132_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					e = _inner_error_;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_inner_error_ = NULL;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp130_ = stdout;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp131_ = e;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp132_ = _tmp131_->message;
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					fprintf (_tmp130_, "Error:  %s\n", _tmp132_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_error_free0 (e);
#line 1359 "moonshot-local-flat-file-store.c"
				}
				__finally6:
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				if (_inner_error_ != NULL) {
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (identity);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					identities_uris = (_vala_array_free (identities_uris, identities_uris_length1, (GDestroyNotify) g_free), NULL);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (filename);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_free0 (path);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_g_key_file_free0 (key_file);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					g_clear_error (&_inner_error_);
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					return;
#line 1380 "moonshot-local-flat-file-store.c"
				}
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_g_free0 (identity);
#line 1384 "moonshot-local-flat-file-store.c"
			}
		}
	}
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	identities_uris = (_vala_array_free (identities_uris, identities_uris_length1, (GDestroyNotify) g_free), NULL);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (filename);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (path);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_key_file_free0 (key_file);
#line 1396 "moonshot-local-flat-file-store.c"
}


static gchar* local_flat_file_store_get_data_dir (LocalFlatFileStore* self) {
	gchar* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (path);
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	path = _tmp1_;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp2_ = path;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (!_tmp3_) {
#line 1423 "moonshot-local-flat-file-store.c"
		const gchar* _tmp4_ = NULL;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = path;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_mkdir_with_parents (_tmp4_, 0700);
#line 1429 "moonshot-local-flat-file-store.c"
	}
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = path;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 1435 "moonshot-local-flat-file-store.c"
}


static Rule* _vala_array_dup1 (Rule* self, int length) {
	Rule* result;
	int i;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = g_new0 (Rule, length);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	for (i = 0; i < length; i++) {
#line 1446 "moonshot-local-flat-file-store.c"
		Rule _tmp0_ = {0};
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		rule_copy (&self[i], &_tmp0_);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		result[i] = _tmp0_;
#line 1452 "moonshot-local-flat-file-store.c"
	}
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 1456 "moonshot-local-flat-file-store.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	result = g_new0 (gchar*, length + 1);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	for (i = 0; i < length; i++) {
#line 1467 "moonshot-local-flat-file-store.c"
		gchar* _tmp0_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp0_ = g_strdup (self[i]);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		result[i] = _tmp0_;
#line 1473 "moonshot-local-flat-file-store.c"
	}
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return result;
#line 1477 "moonshot-local-flat-file-store.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1296 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1297 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1297 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1297 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1298 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1298 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1298 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1298 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1521 "moonshot-local-flat-file-store.c"
	}
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1299 "/usr/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 1527 "moonshot-local-flat-file-store.c"
}


void local_flat_file_store_store_id_cards (LocalFlatFileStore* self) {
	GKeyFile* key_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	gchar* text = NULL;
	GKeyFile* _tmp153_ = NULL;
	gchar* _tmp154_ = NULL;
	GError * _inner_error_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = g_key_file_new ();
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	key_file = _tmp0_;
#line 1544 "moonshot-local-flat-file-store.c"
	{
		GeeLinkedList* _id_card_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _id_card_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _id_card_index = 0;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp1_ = self->priv->id_card_list;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_list = _tmp2_;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp3_ = _id_card_list;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp5_ = _tmp4_;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_size = _tmp5_;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_id_card_index = -1;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		while (TRUE) {
#line 1572 "moonshot-local-flat-file-store.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			IdCard* id_card = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Rule* rules = NULL;
			IdCard* _tmp12_ = NULL;
			Rule* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			Rule* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			Rule* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint rules_length1 = 0;
			gint _rules_size_ = 0;
			gchar** services = NULL;
			IdCard* _tmp16_ = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gchar** _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			gint services_length1 = 0;
			gint _services_size_ = 0;
			gchar** empty = NULL;
			gchar** _tmp20_ = NULL;
			gint empty_length1 = 0;
			gint _empty_size_ = 0;
			gchar** rules_patterns = NULL;
			Rule* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gchar** _tmp22_ = NULL;
			gint rules_patterns_length1 = 0;
			gint _rules_patterns_size_ = 0;
			gchar** rules_always_conf = NULL;
			Rule* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			gchar** _tmp24_ = NULL;
			gint rules_always_conf_length1 = 0;
			gint _rules_always_conf_size_ = 0;
			const gchar* _tmp45_ = NULL;
			IdCard* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			GKeyFile* _tmp49_ = NULL;
			IdCard* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			IdCard* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			GKeyFile* _tmp57_ = NULL;
			IdCard* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			IdCard* _tmp62_ = NULL;
			const gchar* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			GKeyFile* _tmp65_ = NULL;
			IdCard* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
			gboolean _tmp69_ = FALSE;
			IdCard* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			gboolean _tmp72_ = FALSE;
			gchar** _tmp87_ = NULL;
			gchar** _tmp88_ = NULL;
			gint _tmp88__length1 = 0;
			gint _tmp87__length1 = 0;
			gint __tmp87__size_ = 0;
			GKeyFile* _tmp90_ = NULL;
			IdCard* _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			const gchar* _tmp93_ = NULL;
			Rule* _tmp94_ = NULL;
			gint _tmp94__length1 = 0;
			const gchar* _tmp105_ = NULL;
			IdCard* _tmp106_ = NULL;
			gboolean _tmp107_ = FALSE;
			gboolean _tmp108_ = FALSE;
			GKeyFile* _tmp109_ = NULL;
			IdCard* _tmp110_ = NULL;
			const gchar* _tmp111_ = NULL;
			const gchar* _tmp112_ = NULL;
			const gchar* _tmp113_ = NULL;
			IdCard* _tmp114_ = NULL;
			TrustAnchor* _tmp115_ = NULL;
			TrustAnchor* _tmp116_ = NULL;
			const gchar* _tmp117_ = NULL;
			const gchar* _tmp118_ = NULL;
			GKeyFile* _tmp119_ = NULL;
			IdCard* _tmp120_ = NULL;
			const gchar* _tmp121_ = NULL;
			const gchar* _tmp122_ = NULL;
			const gchar* _tmp123_ = NULL;
			IdCard* _tmp124_ = NULL;
			TrustAnchor* _tmp125_ = NULL;
			TrustAnchor* _tmp126_ = NULL;
			const gchar* _tmp127_ = NULL;
			const gchar* _tmp128_ = NULL;
			GKeyFile* _tmp129_ = NULL;
			IdCard* _tmp130_ = NULL;
			const gchar* _tmp131_ = NULL;
			const gchar* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			IdCard* _tmp134_ = NULL;
			TrustAnchor* _tmp135_ = NULL;
			TrustAnchor* _tmp136_ = NULL;
			const gchar* _tmp137_ = NULL;
			const gchar* _tmp138_ = NULL;
			GKeyFile* _tmp139_ = NULL;
			IdCard* _tmp140_ = NULL;
			const gchar* _tmp141_ = NULL;
			const gchar* _tmp142_ = NULL;
			const gchar* _tmp143_ = NULL;
			IdCard* _tmp144_ = NULL;
			TrustAnchor* _tmp145_ = NULL;
			TrustAnchor* _tmp146_ = NULL;
			const gchar* _tmp147_ = NULL;
			const gchar* _tmp148_ = NULL;
			GKeyFile* _tmp149_ = NULL;
			IdCard* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp6_ = _id_card_index;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_id_card_index = _tmp6_ + 1;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp7_ = _id_card_index;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp8_ = _id_card_size;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				break;
#line 1715 "moonshot-local-flat-file-store.c"
			}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp9_ = _id_card_list;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp10_ = _id_card_index;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			id_card = (IdCard*) _tmp11_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp12_ = id_card;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp13_ = id_card_get_rules (_tmp12_, &_tmp13__length1);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14_ = _tmp13_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp14__length1 = _tmp13__length1;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup1 (_tmp14_, _tmp14__length1) : ((gpointer) _tmp14_);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp15__length1 = _tmp14__length1;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules = _tmp15_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_length1 = _tmp15__length1;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_size_ = rules_length1;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp16_ = id_card;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp17_ = id_card_get_services (_tmp16_, &_tmp17__length1);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp18_ = _tmp17_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp18__length1 = _tmp17__length1;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup2 (_tmp18_, _tmp18__length1) : ((gpointer) _tmp18_);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp19__length1 = _tmp18__length1;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			services = _tmp19_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			services_length1 = _tmp19__length1;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_services_size_ = services_length1;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp20_ = g_new0 (gchar*, 0 + 1);
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			empty = _tmp20_;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			empty_length1 = 0;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_empty_size_ = empty_length1;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp21_ = rules;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp21__length1 = rules_length1;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp22_ = g_new0 (gchar*, _tmp21__length1 + 1);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns = _tmp22_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns_length1 = _tmp21__length1;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_patterns_size_ = rules_patterns_length1;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp23_ = rules;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp23__length1 = rules_length1;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp24_ = g_new0 (gchar*, _tmp23__length1 + 1);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf = _tmp24_;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf_length1 = _tmp23__length1;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_rules_always_conf_size_ = rules_always_conf_length1;
#line 1793 "moonshot-local-flat-file-store.c"
			{
				gint i = 0;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				i = 0;
#line 1798 "moonshot-local-flat-file-store.c"
				{
					gboolean _tmp25_ = FALSE;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					_tmp25_ = TRUE;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
					while (TRUE) {
#line 1805 "moonshot-local-flat-file-store.c"
						gint _tmp27_ = 0;
						Rule* _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						gchar** _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						gint _tmp30_ = 0;
						Rule* _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
						gint _tmp32_ = 0;
						Rule _tmp33_ = {0};
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gchar** _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						gint _tmp38_ = 0;
						Rule* _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gint _tmp40_ = 0;
						Rule _tmp41_ = {0};
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!_tmp25_) {
#line 1831 "moonshot-local-flat-file-store.c"
							gint _tmp26_ = 0;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							_tmp26_ = i;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							i = _tmp26_ + 1;
#line 1837 "moonshot-local-flat-file-store.c"
						}
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp25_ = FALSE;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp27_ = i;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp28_ = rules;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp28__length1 = rules_length1;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						if (!(_tmp27_ < _tmp28__length1)) {
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
							break;
#line 1851 "moonshot-local-flat-file-store.c"
						}
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp29_ = rules_patterns;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp29__length1 = rules_patterns_length1;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp30_ = i;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31_ = rules;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp31__length1 = rules_length1;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp32_ = i;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp33_ = _tmp31_[_tmp32_];
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp34_ = _tmp33_.pattern;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp35_ = g_strdup (_tmp34_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp29_[_tmp30_]);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp29_[_tmp30_] = _tmp35_;
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp36_ = _tmp29_[_tmp30_];
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp37_ = rules_always_conf;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp37__length1 = rules_always_conf_length1;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp38_ = i;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp39_ = rules;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp39__length1 = rules_length1;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp40_ = i;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp41_ = _tmp39_[_tmp40_];
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp42_ = _tmp41_.always_confirm;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp43_ = g_strdup (_tmp42_);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_g_free0 (_tmp37_[_tmp38_]);
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp37_[_tmp38_] = _tmp43_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
						_tmp44_ = _tmp37_[_tmp38_];
#line 1901 "moonshot-local-flat-file-store.c"
					}
				}
			}
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp46_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp47_ = id_card_get_issuer (_tmp46_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp48_ = _tmp47_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp45_ = _tmp48_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp45_ == NULL) {
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp45_ = "";
#line 1917 "moonshot-local-flat-file-store.c"
			}
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp49_ = key_file;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp50_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp51_ = id_card_get_display_name (_tmp50_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp52_ = _tmp51_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp49_, _tmp52_, "Issuer", _tmp45_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp54_ = id_card;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp55_ = id_card_get_display_name (_tmp54_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp56_ = _tmp55_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp53_ = _tmp56_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp53_ == NULL) {
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp53_ = "";
#line 1941 "moonshot-local-flat-file-store.c"
			}
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp57_ = key_file;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp58_ = id_card;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp59_ = id_card_get_display_name (_tmp58_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp60_ = _tmp59_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp57_, _tmp60_, "DisplayName", _tmp53_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp62_ = id_card;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp63_ = id_card_get_username (_tmp62_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp64_ = _tmp63_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp61_ = _tmp64_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp61_ == NULL) {
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp61_ = "";
#line 1965 "moonshot-local-flat-file-store.c"
			}
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp65_ = key_file;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp66_ = id_card;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp67_ = id_card_get_display_name (_tmp66_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp68_ = _tmp67_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp65_, _tmp68_, "Username", _tmp61_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp70_ = id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp71_ = id_card_get_store_password (_tmp70_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp72_ = _tmp71_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp72_) {
#line 1985 "moonshot-local-flat-file-store.c"
				IdCard* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp73_ = id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp74_ = id_card_get_password (_tmp73_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp75_ = _tmp74_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp69_ = _tmp75_ != NULL;
#line 1997 "moonshot-local-flat-file-store.c"
			} else {
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp69_ = FALSE;
#line 2001 "moonshot-local-flat-file-store.c"
			}
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp69_) {
#line 2005 "moonshot-local-flat-file-store.c"
				GKeyFile* _tmp76_ = NULL;
				IdCard* _tmp77_ = NULL;
				const gchar* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				IdCard* _tmp80_ = NULL;
				const gchar* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp76_ = key_file;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp77_ = id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp78_ = id_card_get_display_name (_tmp77_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp79_ = _tmp78_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp80_ = id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp81_ = id_card_get_password (_tmp80_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp82_ = _tmp81_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string (_tmp76_, _tmp79_, "Password", _tmp82_);
#line 2029 "moonshot-local-flat-file-store.c"
			} else {
				GKeyFile* _tmp83_ = NULL;
				IdCard* _tmp84_ = NULL;
				const gchar* _tmp85_ = NULL;
				const gchar* _tmp86_ = NULL;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp83_ = key_file;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp84_ = id_card;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp85_ = id_card_get_display_name (_tmp84_);
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp86_ = _tmp85_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string (_tmp83_, _tmp86_, "Password", "");
#line 2045 "moonshot-local-flat-file-store.c"
			}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp88_ = services;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp88__length1 = services_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp87_ = _tmp88_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp87__length1 = _tmp88__length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			__tmp87__size_ = _tmp87__length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp87_ == NULL) {
#line 2059 "moonshot-local-flat-file-store.c"
				gchar** _tmp89_ = NULL;
				gint _tmp89__length1 = 0;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp89_ = empty;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp89__length1 = empty_length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp87_ = _tmp89_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp87__length1 = _tmp89__length1;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				__tmp87__size_ = _tmp87__length1;
#line 2072 "moonshot-local-flat-file-store.c"
			}
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp90_ = key_file;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp91_ = id_card;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp92_ = id_card_get_display_name (_tmp91_);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp93_ = _tmp92_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string_list (_tmp90_, _tmp93_, "Services", (const gchar* const*) _tmp87_, _tmp87__length1);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp94_ = rules;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp94__length1 = rules_length1;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp94__length1 > 0) {
#line 2090 "moonshot-local-flat-file-store.c"
				GKeyFile* _tmp95_ = NULL;
				IdCard* _tmp96_ = NULL;
				const gchar* _tmp97_ = NULL;
				const gchar* _tmp98_ = NULL;
				gchar** _tmp99_ = NULL;
				gint _tmp99__length1 = 0;
				GKeyFile* _tmp100_ = NULL;
				IdCard* _tmp101_ = NULL;
				const gchar* _tmp102_ = NULL;
				const gchar* _tmp103_ = NULL;
				gchar** _tmp104_ = NULL;
				gint _tmp104__length1 = 0;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp95_ = key_file;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp96_ = id_card;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp97_ = id_card_get_display_name (_tmp96_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp98_ = _tmp97_;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp99_ = rules_patterns;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp99__length1 = rules_patterns_length1;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string_list (_tmp95_, _tmp98_, "Rules-Patterns", (const gchar* const*) _tmp99_, _tmp99__length1);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp100_ = key_file;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp101_ = id_card;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp102_ = id_card_get_display_name (_tmp101_);
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp103_ = _tmp102_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp104_ = rules_always_conf;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp104__length1 = rules_always_conf_length1;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				g_key_file_set_string_list (_tmp100_, _tmp103_, "Rules-AlwaysConfirm", (const gchar* const*) _tmp104_, _tmp104__length1);
#line 2131 "moonshot-local-flat-file-store.c"
			}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp106_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp107_ = id_card_get_store_password (_tmp106_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp108_ = _tmp107_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp108_) {
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp105_ = "yes";
#line 2143 "moonshot-local-flat-file-store.c"
			} else {
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp105_ = "no";
#line 2147 "moonshot-local-flat-file-store.c"
			}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp109_ = key_file;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp110_ = id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp111_ = id_card_get_display_name (_tmp110_);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp112_ = _tmp111_;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp109_, _tmp112_, "StorePassword", _tmp105_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp114_ = id_card;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp115_ = id_card_get_trust_anchor (_tmp114_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp116_ = _tmp115_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp117_ = trust_anchor_get_ca_cert (_tmp116_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp118_ = _tmp117_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp113_ = _tmp118_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp113_ == NULL) {
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp113_ = "";
#line 2175 "moonshot-local-flat-file-store.c"
			}
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp119_ = key_file;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp120_ = id_card;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp121_ = id_card_get_display_name (_tmp120_);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp122_ = _tmp121_;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp119_, _tmp122_, "CA-Cert", _tmp113_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp124_ = id_card;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp125_ = id_card_get_trust_anchor (_tmp124_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp126_ = _tmp125_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp127_ = trust_anchor_get_subject (_tmp126_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp128_ = _tmp127_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp123_ = _tmp128_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp123_ == NULL) {
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp123_ = "";
#line 2203 "moonshot-local-flat-file-store.c"
			}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp129_ = key_file;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp130_ = id_card;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp131_ = id_card_get_display_name (_tmp130_);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp132_ = _tmp131_;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp129_, _tmp132_, "Subject", _tmp123_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp134_ = id_card;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp135_ = id_card_get_trust_anchor (_tmp134_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp136_ = _tmp135_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp137_ = trust_anchor_get_subject_alt (_tmp136_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp138_ = _tmp137_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp133_ = _tmp138_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp133_ == NULL) {
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp133_ = "";
#line 2231 "moonshot-local-flat-file-store.c"
			}
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp139_ = key_file;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp140_ = id_card;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp141_ = id_card_get_display_name (_tmp140_);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp142_ = _tmp141_;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp139_, _tmp142_, "SubjectAlt", _tmp133_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp144_ = id_card;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp145_ = id_card_get_trust_anchor (_tmp144_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp146_ = _tmp145_;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp147_ = trust_anchor_get_server_cert (_tmp146_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp148_ = _tmp147_;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp143_ = _tmp148_;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			if (_tmp143_ == NULL) {
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
				_tmp143_ = "";
#line 2259 "moonshot-local-flat-file-store.c"
			}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp149_ = key_file;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp150_ = id_card;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp151_ = id_card_get_display_name (_tmp150_);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_tmp152_ = _tmp151_;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			g_key_file_set_string (_tmp149_, _tmp152_, "ServerCert", _tmp143_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_always_conf = (_vala_array_free (rules_always_conf, rules_always_conf_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			empty = (_vala_array_free (empty, empty_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (id_card);
#line 2283 "moonshot-local-flat-file-store.c"
		}
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (_id_card_list);
#line 2287 "moonshot-local-flat-file-store.c"
	}
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp153_ = key_file;
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp154_ = g_key_file_to_data (_tmp153_, NULL, NULL);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	text = _tmp154_;
#line 2295 "moonshot-local-flat-file-store.c"
	{
		gchar* path = NULL;
		gchar* _tmp155_ = NULL;
		gchar* filename = NULL;
		const gchar* _tmp156_ = NULL;
		gchar* _tmp157_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp158_ = NULL;
		GFile* _tmp159_ = NULL;
		GFileOutputStream* stream = NULL;
		GFile* _tmp160_ = NULL;
		GFileOutputStream* _tmp161_ = NULL;
		GFileOutputStream* _tmp162_ = NULL;
		const gchar* _tmp163_ = NULL;
		guint8* _tmp164_ = NULL;
		gint _tmp164__length1 = 0;
		guint8* _tmp165_ = NULL;
		gint _tmp165__length1 = 0;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp155_ = local_flat_file_store_get_data_dir (self);
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		path = _tmp155_;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp156_ = path;
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp157_ = g_build_filename (_tmp156_, LOCAL_FLAT_FILE_STORE_FILE_NAME, NULL);
#line 179 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		filename = _tmp157_;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp158_ = filename;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp159_ = g_file_new_for_path (_tmp158_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		file = _tmp159_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp160_ = file;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp161_ = g_file_replace (_tmp160_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, &_inner_error_);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		stream = _tmp161_;
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (_inner_error_ != NULL) {
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (file);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (filename);
#line 181 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (path);
#line 2344 "moonshot-local-flat-file-store.c"
			goto __catch7_g_error;
		}
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp162_ = stream;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp163_ = text;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp164_ = string_get_data (_tmp163_, &_tmp164__length1);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp165_ = _tmp164_;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp165__length1 = _tmp164__length1;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_output_stream_write ((GOutputStream*) _tmp162_, _tmp165_, (gsize) _tmp165__length1, NULL, &_inner_error_);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		if (_inner_error_ != NULL) {
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (stream);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_object_unref0 (file);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (filename);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
			_g_free0 (path);
#line 2369 "moonshot-local-flat-file-store.c"
			goto __catch7_g_error;
		}
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (stream);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_object_unref0 (file);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (filename);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (path);
#line 2380 "moonshot-local-flat-file-store.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp166_ = NULL;
		GError* _tmp167_ = NULL;
		const gchar* _tmp168_ = NULL;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		e = _inner_error_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_inner_error_ = NULL;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp166_ = stdout;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp167_ = e;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_tmp168_ = _tmp167_->message;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		fprintf (_tmp166_, "Error:  %s\n", _tmp168_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_error_free0 (e);
#line 2403 "moonshot-local-flat-file-store.c"
	}
	__finally7:
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	if (_inner_error_ != NULL) {
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_free0 (text);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		_g_key_file_free0 (key_file);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		g_clear_error (&_inner_error_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
		return;
#line 2418 "moonshot-local-flat-file-store.c"
	}
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_load_id_cards (self);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_free0 (text);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_key_file_free0 (key_file);
#line 2426 "moonshot-local-flat-file-store.c"
}


LocalFlatFileStore* local_flat_file_store_construct (GType object_type) {
	LocalFlatFileStore * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = (LocalFlatFileStore*) g_object_new (object_type, NULL);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_tmp0_ = gee_linked_list_new (TYPE_ID_CARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self->priv->id_card_list = _tmp0_;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_load_id_cards (self);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return self;
#line 2445 "moonshot-local-flat-file-store.c"
}


LocalFlatFileStore* local_flat_file_store_new (void) {
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	return local_flat_file_store_construct (TYPE_LOCAL_FLAT_FILE_STORE);
#line 2452 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_class_init (LocalFlatFileStoreClass * klass) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	g_type_class_add_private (klass, sizeof (LocalFlatFileStorePrivate));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	G_OBJECT_CLASS (klass)->finalize = local_flat_file_store_finalize;
#line 2463 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_iidentity_card_store_interface_init (IIdentityCardStoreIface * iface) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	local_flat_file_store_iidentity_card_store_parent_iface = g_type_interface_peek_parent (iface);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->add_card = (void (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_add_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->update_card = (IdCard* (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_update_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->remove_card = (gboolean (*)(IIdentityCardStore*, IdCard*)) local_flat_file_store_real_remove_card;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->get_card_list = (GeeLinkedList* (*)(IIdentityCardStore*)) local_flat_file_store_real_get_card_list;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	iface->get_store_type = (IIdentityCardStoreStoreType (*)(IIdentityCardStore*)) local_flat_file_store_real_get_store_type;
#line 2480 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_instance_init (LocalFlatFileStore * self) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self->priv = LOCAL_FLAT_FILE_STORE_GET_PRIVATE (self);
#line 2487 "moonshot-local-flat-file-store.c"
}


static void local_flat_file_store_finalize (GObject* obj) {
	LocalFlatFileStore * self;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOCAL_FLAT_FILE_STORE, LocalFlatFileStore);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	_g_object_unref0 (self->priv->id_card_list);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-local-flat-file-store.vala"
	G_OBJECT_CLASS (local_flat_file_store_parent_class)->finalize (obj);
#line 2499 "moonshot-local-flat-file-store.c"
}


GType local_flat_file_store_get_type (void) {
	static volatile gsize local_flat_file_store_type_id__volatile = 0;
	if (g_once_init_enter (&local_flat_file_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LocalFlatFileStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) local_flat_file_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LocalFlatFileStore), 0, (GInstanceInitFunc) local_flat_file_store_instance_init, NULL };
		static const GInterfaceInfo iidentity_card_store_info = { (GInterfaceInitFunc) local_flat_file_store_iidentity_card_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType local_flat_file_store_type_id;
		local_flat_file_store_type_id = g_type_register_static (G_TYPE_OBJECT, "LocalFlatFileStore", &g_define_type_info, 0);
		g_type_add_interface_static (local_flat_file_store_type_id, TYPE_IIDENTITY_CARD_STORE, &iidentity_card_store_info);
		g_once_init_leave (&local_flat_file_store_type_id__volatile, local_flat_file_store_type_id);
	}
	return local_flat_file_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



