# snapdragon-capture-set [![NPM version](https://img.shields.io/npm/v/snapdragon-capture-set.svg?style=flat)](https://www.npmjs.com/package/snapdragon-capture-set) [![NPM monthly downloads](https://img.shields.io/npm/dm/snapdragon-capture-set.svg?style=flat)](https://npmjs.org/package/snapdragon-capture-set)  [![NPM total downloads](https://img.shields.io/npm/dt/snapdragon-capture-set.svg?style=flat)](https://npmjs.org/package/snapdragon-capture-set) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/snapdragon-capture-set.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/snapdragon-capture-set)

> Plugin that adds a `.captureSet()` method to snapdragon, for matching and capturing substrings that have an `open` and `close`, like braces, brackets, etc

<details>
<summary><strong>Table of Contents</strong></summary>
- [Install](#install)
- [Usage](#usage)
- [API](#api)
- [About](#about)
</details>

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save snapdragon-capture-set
```

## Usage

```js
var Snapdragon = require('snapdragon');
var captureSet = require('snapdragon-capture-set');
var parser = new Snapdragon.Parser()
  .use(captureSet())
  .captureSet('brace', /^\{/, /^\}/) 
  .set('text', function() {
    var pos = this.position();
    var m = this.match(/^[^{}]/);
    if (!m) return;
    return pos({
      type: 'text',
      val: m[0]
    });
  });

var ast = parser.parse('a{b,{c,d},e}f');
console.log(ast.nodes[2]);
// Node {
//   type: 'brace',
//   nodes:
//    [ Node { type: 'brace.open', val: '{', position: [Object] },
//      Node { type: 'text', val: 'b', position: [Object] },
//      Node { type: 'text', val: ',', position: [Object] },
//      Node { type: 'brace', nodes: [Object], position: [Object] },
//      Node { type: 'text', val: ',', position: [Object] },
//      Node { type: 'text', val: 'e', position: [Object] },
//      Node { type: 'brace.close', val: '}', position: [Object] } ],
//   position: Position { start: { line: 1, column: 2 }, end: { line: 1, column: 3 } } }
```

## API

**Example**

```js
var Snapdragon = require('snapdragon');
var captureSet = require('snapdragon-capture-set');

// snapdragon
var snapdragon = new Snapdragon();
snapdragon.use(captureSet());

// parser
snapdragon.parser.use(captureSet());
```

### [captureSet](index.js#L52)

Create a node of the given `type` using the specified regex or function.

**Params**

* `type` **{String}**
* `regex` **{RegExp|Function}**: Pass the regex to use for capturing the `open` and `close` nodes.
* `returns` **{Object}**: Returns the parser instance for chaining

**Example**

```js
parser.captureSet('brace', /^\{/, /^\}/);
```

## About

### Related projects

* [snapdragon-capture](https://www.npmjs.com/package/snapdragon-capture): Snapdragon plugin that adds a capture method to the parser instance. | [homepage](https://github.com/jonschlinkert/snapdragon-capture "Snapdragon plugin that adds a capture method to the parser instance.")
* [snapdragon-node](https://www.npmjs.com/package/snapdragon-node): Snapdragon utility for creating a new AST node in custom code, such as plugins. | [homepage](https://github.com/jonschlinkert/snapdragon-node "Snapdragon utility for creating a new AST node in custom code, such as plugins.")
* [snapdragon-util](https://www.npmjs.com/package/snapdragon-util): Utilities for the snapdragon parser/compiler. | [homepage](https://github.com/jonschlinkert/snapdragon-util "Utilities for the snapdragon parser/compiler.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.1, on January 21, 2017._