/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var isElectron = require( './../../is-electron' );
var proc = require( './process.js' );


// MAIN //

/**
* Returns a boolean indicating if the runtime is the main Electron process.
*
* @returns {boolean} boolean indicating if runtime is the main Electron process
*
* @example
* var bool = isElectronMain();
* // returns <boolean>
*/
function isElectronMain() {
	return (
		isElectron &&
		proc.type === 'browser'
	);
}


// EXPORTS //

module.exports = isElectronMain;
