C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_sogga.F 
C> The nwxcm_c_sogga functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_sogga functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_4} &=& {\it t_3}^4\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_1}^4}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_7} &=& 1.0-{\it t_3}\,{\it t_6}\\\\ 
C>   {\it t_8} &=& {\it t_3}\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& {\it t_8}^{{{4}\over{3}}}+{\it t_7}^{{{4}\over{3}}}
C>    -2.0\\\\ 
C>   {\it t_{10}} &=& -1.923661050931536\,{\it t_4}\,{\it t_5}\,{
C>    \it t_9}\\\\ 
C>   {\it t_{11}} &=& {{1}\over{{\it t_1}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\sqrt{{\it t_1}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_1}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{14}} &=& -0.0598079686361971\,{\it t_4}\,{\it t_5}
C>    \,\left(0.1274696188700087\,{\it t_2}+1.0\right)\,{\it t_9}
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{13}}+3.844746237447211\,{\it t_2}+1.644733775567609
C>    \,{\it t_{12}}+0.2405871291288192\,{\it t_{11}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_2}
C>    +1.0\right)\,\left({\it t_{10}}+1.923661050931536\,{
C>    \it t_9}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{13}}+2.247591863577616\,{
C>    \it t_2}+0.4300972471276643\,{\it t_{12}}+0.1911512595127337
C>    \,{\it t_{11}}}}+1.0\right)-0.0621814\,
C>    \left(0.1325688999052018\,{\it t_2}+1.0\right)\,\left({
C>    \it t_{10}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{13}}+2.225569421150687\,{
C>    \it t_2}+0.8004286349993635\,{\it t_{12}}+0.1897004325747558
C>    \,{\it t_{11}}}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{18}} &=& {\it t_8}^{0.6666666666666667}+{
C>    \it t_7}^{0.6666666666666667}\\\\ 
C>   {\it t_{19}} &=& {\it t_{18}}^3\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({\it t_1}^{1.166666666666667}
C>    \,{\it t_{18}}\right)^{2.0}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& 1.0-{{1.0}\over{1.0-0.002117499953031588\,{
C>    \it t_{19}}\,{\it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{29}} &=& 1.0-e^{0.002117499953031588\,{\it t_{19}}\,{
C>    \it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{38}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{37}}+2.225569421150687\,{\it t_{36}}+0.8004286349993635
C>    \,{\it t_{35}}+0.1897004325747558\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{36}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{37}}+3.844746237447211\,{\it t_{36}}+1.644733775567609
C>    \,{\it t_{35}}+0.2405871291288192\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{36}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{41}} &=& 1.0-{{1.0}\over{1.0-0.003361321652984956\,{
C>    \it t_{39}}\,{\it t_{40}}\,\sigma_{ss}}}\\\\ 
C>   {\it t_{42}} &=& 1.0-e^{0.003361321652984956\,{\it t_{39}}\,{
C>    \it t_{40}}\,\sigma_{ss}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{14}}\,\left({\it t_{33}}\,{
C>    \it t_{29}}+{\it t_{32}}\,{\it t_{29}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{29}}^{4.0}+{\it t_{30}}\,{\it t_{29}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{29}}^{2.0}+{\it t_{27}}\,{\it t_{23}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{23}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{23}}^{3.0}+{\it t_{24}}\,{\it t_{23}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{23}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{38}}\,\rho_s\,\left({\it t_{33}}\,{\it t_{42}}
C>    +{\it t_{32}}\,{\it t_{42}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{42}}^{4.0}+{\it t_{30}}\,{\it t_{42}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{42}}^{2.0}+{\it t_{27}}\,{\it t_{41}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{41}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{41}}^{3.0}+{\it t_{24}}\,{\it t_{41}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{41}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, Y Zhao, DG Truhlar, J.Phys.Chem.Lett. 2
C>    , 1991 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz200616w "> 
C> 10.1021/jz200616w </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_sogga(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = log(1.6081979498692536d+1/(5.329846514438383d+0*t5+1.76
     1         6435620181429d+0*t4+5.659885156639418d-1*t3+1.19503784087
     2         549d-1*t1)+1.0d+0)
            t7 = 1.0522000558389212d-1*t4+1.0d+0
            t8 = param(1)
            t9 = param(7)
            t10 = param(2)
            t11 = rhoa**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = 5.405670591181536d-2*gammaaa*t12/(t6*t7)
            t14 = 1.0d+0-1.0d+0/(t13+1.0d+0)
            t15 = param(3)
            t16 = param(4)
            t17 = param(5)
            t18 = param(6)
            t19 = param(9)
            t20 = 1.0d+0-exp(-t13)
            t21 = param(10)
            t22 = param(11)
            t23 = param(12)
            t24 = param(8)
            t25 = 1.414213562373095d+0
            t26 = 7.937005259840998d-1
            t27 = 5.329846514438382d+0*t5+2.2255694211506874d+0*t26*t4+8
     1         .004286349993635d-1*t3/t25+1.1950378408754898d-1*t1
            t28 = 1.6081979498692536d+1/t27+1.0d+0
            t29 = log(t28)
            t30 = 1.3256889990520176d-1*t26*t4+1.0d+0
            t31 = 1/t29
            t32 = 1/t30
            t33 = 5.405670591181535d-2*gammaaa*t12*t31*t32
            t34 = t33+1.0d+0
            t35 = 1.0d+0-1.0d+0/t34
            t36 = t35**2.0d+0
            t37 = t35**3.0d+0
            t38 = t35**4.0d+0
            t39 = exp(-t33)
            t40 = 1.0d+0-t39
            t41 = t40**2.0d+0
            t42 = t40**3.0d+0
            t43 = t40**4.0d+0
            t44 = t9+t8+t22*t43+t21*t42+t19*t41+t23*t40**5.0d+0+t24*t40+
     1         t17*t38+t16*t37+t15*t36+t18*t35**5.0d+0+t10*t35
            t45 = 3.968502629920499d-1
            t46 = 1/rhoa**1.3333333333333333d+0
            t47 = 1.0d+0*t30*(-7.418564737168958d-1*t45*t46-4.0021431749
     1         96817d-1/(t2**3*t25**3)-4.4415387620319857d-1/rhoa**1.166
     2         6666666666667d+0-3.9834594695849657d-2/rhoa**1.6666666666
     3         666669d+0)/(t27**2*t28)+2.747773264188437d-3*t29*t45*t46
            t48 = rhoa**1.6666666666666674d-1
            t49 = 1/t11**3.0d+0
            t50 = 1/t29**2
            t51 = 1/t30**2
            t52 = 8.69338836240666d-1*gammaaa*t12*t47*t50*t51-6.30661568
     1         9711792d-2*gammaaa*t31*t32*t48*t49
            t53 = 1/t34**2
            t54 = 6.306615689711792d-2*gammaaa*t31*t32*t48*t49-8.6933883
     1         6240666d-1*gammaaa*t12*t47*t50*t51
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*t6*t7*(t9+t8+t20*t24+t20*
     1         *5.0d+0*t23+t20**4.0d+0*t22+t20**3.0d+0*t21+t19*t20**2.0d
     2         +0+t14**5.0d+0*t18+t14**4.0d+0*t17+t14**3.0d+0*t16+t14**2
     3         .0d+0*t15+t10*t14)*wght
            Amat(iq,D1_RA) = -1.243628d-1*rhoa*t29*t30*(-5.0d+0*t23*t39*
     1         t43*t54-4.0d+0*t22*t39*t42*t54-3.0d+0*t21*t39*t41*t54-2.0
     2         d+0*t19*t39*t40*t54-t24*t39*t54+5.0d+0*t18*t38*t52*t53+4.
     3         0d+0*t17*t37*t52*t53+3.0d+0*t16*t36*t52*t53+2.0d+0*t15*t3
     4         5*t52*t53+1.0d+0*t10*t52*t53)*wght+2.0d+0*rhoa*t44*t47*wg
     5         ht-6.21814d-2*t29*t30*t44*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-1.243628d-1*rhoa*t29*t30*(
     1         -7.977672241861109d-1*t12*t31*t32*(-8.469999812126351d-2*
     2         t18*t38-6.775999849701081d-2*t17*t37-5.081999887275811d-2
     3         *t16*t36-3.3879999248505405d-2*t15*t35-1.6939999624252702
     4         d-2*t10)*t53-7.977672241861109d-1*t12*t31*t32*(-8.4699998
     5         12126351d-2*t23*t39*t43-6.775999849701081d-2*t22*t39*t42-
     6         5.081999887275811d-2*t21*t39*t41-3.3879999248505405d-2*t1
     7         9*t39*t40-1.6939999624252702d-2*t24*t39))*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)-1.243628d-1*rhoa*t29*t30*(
     1         -7.977672241861109d-1*t12*t31*t32*(-1.6939999624252702d-1
     2         *t18*t38-1.3551999699402162d-1*t17*t37-1.0163999774551621
     3         d-1*t16*t36-6.775999849701081d-2*t15*t35-3.38799992485054
     4         05d-2*t10)*t53-7.977672241861109d-1*t12*t31*t32*(-1.69399
     5         99624252702d-1*t23*t39*t43-1.3551999699402162d-1*t22*t39*
     6         t42-1.0163999774551621d-1*t21*t39*t41-6.775999849701081d-
     7         2*t19*t39*t40-3.3879999248505405d-2*t24*t39))*wght
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = 1/t1**3.333333333333333d-1
            t3 = 1.3256889990520176d-1*t2+1.0d+0
            t4 = rhoa-rhob
            t5 = t4**4
            t6 = 1/t1**4
            t7 = 1/t1
            t8 = 1.0d+0-t4*t7
            t9 = t4*t7+1.0d+0
            t10 = t9**1.3333333333333333d+0+t8**1.3333333333333333d+0-2.
     1         0d+0
            t11 = -1.923661050931536d+0*t10*t5*t6
            t12 = t11+1.0d+0
            t13 = 1/t1**6.666666666666666d-1
            t14 = t1**5.0d-1
            t15 = 1/t14
            t16 = 1/t1**1.6666666666666666d-1
            t17 = 2.2255694211506874d+0*t2+5.982550435771079d+0*t16+8.00
     1         4286349993635d-1*t15+1.8970043257475583d-1*t13
            t18 = 1.6081979498692536d+1/t17+1.0d+0
            t19 = log(t18)
            t20 = 6.901399211255825d-2*t2+1.0d+0
            t21 = t11+1.923661050931536d+0*t10
            t22 = 2.247591863577616d+0*t2+8.157414703487641d+0*t16+4.300
     1         9724712766434d-1*t15+1.9115125951273373d-1*t13
            t23 = 2.9608813203268075d+1/t22+1.0d+0
            t24 = log(t23)
            t25 = 1.274696188700087d-1*t2+1.0d+0
            t26 = 3.8447462374472113d+0*t2+1.1120374863094686d+1*t16+1.6
     1         44733775567609d+0*t15+2.4058712912881916d-1*t13
            t27 = 3.216395899738507d+1/t26+1.0d+0
            t28 = log(t27)
            t29 = -5.980796863619711d-2*t10*t25*t28*t5*t6-6.21814d-2*t12
     1         *t19*t3+1.9751631321680768d-2*t20*t21*t24
            t30 = param(9)
            t31 = gammabb+2.0d+0*gammaab+gammaaa
            t32 = t9**6.666666666666667d-1+t8**6.666666666666667d-1
            t33 = t32**3
            t34 = t1**1.1666666666666667d+0
            t35 = t32*t34
            t36 = 1/t35**2.0d+0
            t37 = 1/t29
            t38 = exp(2.1174999530315877d-3*t31*t33*t36*t37)
            t39 = 1.0d+0-t38
            t40 = t39**2.0d+0
            t41 = param(10)
            t42 = t39**3.0d+0
            t43 = param(11)
            t44 = t39**4.0d+0
            t45 = param(12)
            t46 = param(8)
            t47 = param(2)
            t48 = 1.0d+0-2.1174999530315877d-3*t31*t33*t36*t37
            t49 = 1.0d+0-1.0d+0/t48
            t50 = param(3)
            t51 = t49**2.0d+0
            t52 = param(4)
            t53 = t49**3.0d+0
            t54 = param(5)
            t55 = t49**4.0d+0
            t56 = param(6)
            t57 = t49**5.0d+0*t56+t54*t55+t52*t53+t50*t51+t47*t49+t39*t4
     1         6+t39**5.0d+0*t45+t43*t44+t41*t42+t30*t40+param(7)+param(
     2         1)
            t58 = 1/t1**1.6666666666666669d+0
            t59 = 1/t14**3
            t60 = 1/t1**1.3333333333333333d+0
            t61 = 1/t1**1.1666666666666667d+0
            t62 = 1.0d+0*t12*t3*(-9.970917392951799d-1*t61-7.41856473716
     1         8958d-1*t60-4.002143174996817d-1*t59-1.264669550498372d-1
     2         *t58)/(t17**2*t18)
            t63 = -5.848223622634647d-1*t20*t21*(-1.3595691172479402d+0*
     1         t61-7.491972878592053d-1*t60-2.1504862356383217d-1*t59-1.
     2         2743417300848914d-1*t58)/(t22**2*t23)
            t64 = 1.923661050931536d+0*t10*t25*t5*t6*(-1.853395810515780
     1         8d+0*t61-1.2815820791490704d+0*t60-8.223668877838045d-1*t
     2         59-1.6039141941921276d-1*t58)/(t26**2*t27)
            t65 = 1/t1**2
            t66 = t4*t65
            t67 = -t7
            t68 = t67+t66
            t69 = t8**3.333333333333333d-1
            t70 = -t4*t65
            t71 = t70+t7
            t72 = t9**3.333333333333333d-1
            t73 = 1.3333333333333333d+0*t71*t72+1.3333333333333333d+0*t6
     1         8*t69
            t74 = -1.923661050931536d+0*t5*t6*t73
            t75 = 1/t1**5
            t76 = 7.694644203726144d+0*t10*t5*t75
            t77 = t4**3
            t78 = -7.694644203726144d+0*t10*t6*t77
            t79 = 2.747773264188437d-3*t12*t19*t60
            t80 = -4.5437964274821163d-4*t21*t24*t60
            t81 = 2.541232989148493d-3*t10*t28*t5/t1**5.333333333333333d
     1         +0
            t82 = 2.3923187454478842d-1*t10*t25*t28*t5*t75
            t83 = t82+t81+t80+t79+1.9751631321680768d-2*t20*t24*(t78+t76
     1         +t74+1.923661050931536d+0*t73)-6.21814d-2*t19*t3*(t78+t76
     2         +t74)-2.3923187454478842d-1*t10*t25*t28*t6*t77-5.98079686
     3         3619711d-2*t25*t28*t5*t6*t73+t64+t63+t62
            t84 = 1/t29**2
            t85 = 1/t35**3.0d+0
            t86 = 1/t8**3.3333333333333326d-1
            t87 = 1/t9**3.3333333333333326d-1
            t88 = 6.666666666666667d-1*t71*t87+6.666666666666667d-1*t68*
     1         t86
            t89 = 1.1666666666666667d+0*t1**1.6666666666666674d-1*t32
            t90 = t89+t34*t88
            t91 = t32**2
            t92 = 6.352499859094763d-3*t31*t36*t37*t88*t91-4.23499990606
     1         31754d-3*t31*t33*t37*t85*t90-2.1174999530315877d-3*t31*t3
     2         3*t36*t83*t84
            t93 = -6.352499859094763d-3*t31*t36*t37*t88*t91+4.2349999060
     1         631754d-3*t31*t33*t37*t85*t90+2.1174999530315877d-3*t31*t
     2         33*t36*t83*t84
            t94 = 1/t48**2
            t95 = 1.0d+0*t29*t57*wght
            t96 = t7+t66
            t97 = t70+t67
            t98 = 1.3333333333333333d+0*t72*t97+1.3333333333333333d+0*t6
     1         9*t96
            t99 = -1.923661050931536d+0*t5*t6*t98
            t100 = 7.694644203726144d+0*t10*t6*t77
            t101 = 1.9751631321680768d-2*t20*t24*(t99+1.923661050931536d
     1         +0*t98+t76+t100)-6.21814d-2*t19*t3*(t99+t76+t100)-5.98079
     2         6863619711d-2*t25*t28*t5*t6*t98+t82+t81+t80+t79+2.3923187
     3         454478842d-1*t10*t25*t28*t6*t77+t64+t63+t62
            t102 = 6.666666666666667d-1*t87*t97+6.666666666666667d-1*t86
     1         *t96
            t103 = t89+t102*t34
            t104 = 6.352499859094763d-3*t102*t31*t36*t37*t91-4.234999906
     1         0631754d-3*t103*t31*t33*t37*t85-2.1174999530315877d-3*t10
     2         1*t31*t33*t36*t84
            t105 = -6.352499859094763d-3*t102*t31*t36*t37*t91+4.23499990
     1         60631754d-3*t103*t31*t33*t37*t85+2.1174999530315877d-3*t1
     2         01*t31*t33*t36*t84
            t106 = 1.0d+0*t1*t29*(t36*t37*(-1.0587499765157939d-2*t33*t5
     1         5*t56-8.469999812126351d-3*t33*t53*t54-6.352499859094763d
     2         -3*t33*t51*t52-4.2349999060631754d-3*t33*t49*t50-2.117499
     3         9530315877d-3*t33*t47)*t94+t36*t37*(-2.1174999530315877d-
     4         3*t33*t38*t46-1.0587499765157939d-2*t33*t38*t44*t45-8.469
     5         999812126351d-3*t33*t38*t42*t43-6.352499859094763d-3*t33*
     6         t38*t40*t41-4.2349999060631754d-3*t30*t33*t38*t39))*wght
            fnc(iq) = 1.0d+0*t1*t29*t57*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t29*(5.0d+0*t55*t56*t93*t94+4.0d+
     1         0*t53*t54*t93*t94+3.0d+0*t51*t52*t93*t94+2.0d+0*t49*t50*t
     2         93*t94+1.0d+0*t47*t93*t94-t38*t46*t92-5.0d+0*t38*t44*t45*
     3         t92-4.0d+0*t38*t42*t43*t92-3.0d+0*t38*t40*t41*t92-2.0d+0*
     4         t30*t38*t39*t92)*wght+1.0d+0*t1*t57*t83*wght+t95+Amat(iq,
     5         D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t29*(5.0d+0*t105*t55*t56*t94+4.0d
     1         +0*t105*t53*t54*t94+3.0d+0*t105*t51*t52*t94+2.0d+0*t105*t
     2         49*t50*t94+1.0d+0*t105*t47*t94-t104*t38*t46-5.0d+0*t104*t
     3         38*t44*t45-4.0d+0*t104*t38*t42*t43-3.0d+0*t104*t38*t40*t4
     4         1-2.0d+0*t104*t30*t38*t39)*wght+1.0d+0*t1*t101*t57*wght+t
     5         95+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t106+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 1.0d+0*t1*t29*(t36*t37*(-2.117499953031587
     1         7d-2*t33*t55*t56-1.6939999624252702d-2*t33*t53*t54-1.2704
     2         999718189527d-2*t33*t51*t52-8.469999812126351d-3*t33*t49*
     3         t50-4.2349999060631754d-3*t33*t47)*t94+t36*t37*(-4.234999
     4         9060631754d-3*t33*t38*t46-2.1174999530315877d-2*t33*t38*t
     5         44*t45-1.6939999624252702d-2*t33*t38*t42*t43-1.2704999718
     6         189527d-2*t33*t38*t40*t41-8.469999812126351d-3*t30*t33*t3
     7         8*t39))*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t106+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhoa**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammaaa*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammaaa*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/rhoa**1.6666666666666669d+0
            t40 = 1/t2**3
            t41 = 1/rhoa**1.3333333333333333d+0
            t42 = 1/rhoa**1.1666666666666667d+0
            t43 = 1.0d+0*(-1.8533958105157808d+0*t42-1.2815820791490704d
     1         +0*t41-8.223668877838045d-1*t40-1.6039141941921276d-1*t39
     2         )*t9/(t6**2*t7)+1.3210398931339265d-3*t41*t8+1.1102230246
     3         251565d-16*t13*(-9.970917392951799d-1*t42-7.4185647371689
     4         58d-1*t41-4.002143174996817d-1*t40-1.264669550498372d-1*t
     5         39)/(t10**2*t11)+3.0506411443514264d-19*t12*t41
            t44 = rhoa**1.6666666666666674d-1
            t45 = 1/t17**3.0d+0
            t46 = 1/t14**2
            t47 = 3.361321652984956d-3*gammaaa*t18*t43*t46+7.84308385696
     1         4898d-3*gammaaa*t16*t44*t45
            t48 = 1/t19**2
            t49 = -3.361321652984956d-3*gammaaa*t18*t43*t46-7.8430838569
     1         64898d-3*gammaaa*t16*t44*t45
            fnc(iq) = 1.0d+0*rhoa*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t14*(-t29*t37*t49-5.0d+0*t29*t3
     1         5*t36*t49-4.0d+0*t29*t33*t34*t49-3.0d+0*t29*t31*t32*t49-2
     2         .0d+0*t28*t29*t30*t49+5.0d+0*t26*t27*t47*t48+4.0d+0*t24*t
     3         25*t47*t48+3.0d+0*t22*t23*t47*t48+2.0d+0*t20*t21*t47*t48+
     4         1.0d+0*t15*t47*t48)*wght+1.0d+0*rhoa*t38*t43*wght+1.0d+0*
     5         t14*t38*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*(t16*t18*(-1.6806608264924
     1         78d-2*t26*t27-1.3445286611939825d-2*t24*t25-1.00839649589
     2         54868d-2*t22*t23-6.722643305969912d-3*t20*t21-3.361321652
     3         984956d-3*t15)*t48+t16*t18*(-3.361321652984956d-3*t29*t37
     4         -1.680660826492478d-2*t29*t35*t36-1.3445286611939825d-2*t
     5         29*t33*t34-1.0083964958954868d-2*t29*t31*t32-6.7226433059
     6         69912d-3*t28*t29*t30))*wght+Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**6.666666666666666d-1
            t2 = rhob**5.0d-1
            t3 = 1/t2
            t4 = 1/rhob**3.333333333333333d-1
            t5 = 1/rhob**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhob**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammabb*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammabb*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/rhob**1.6666666666666669d+0
            t40 = 1/t2**3
            t41 = 1/rhob**1.3333333333333333d+0
            t42 = 1/rhob**1.1666666666666667d+0
            t43 = 1.0d+0*(-1.8533958105157808d+0*t42-1.2815820791490704d
     1         +0*t41-8.223668877838045d-1*t40-1.6039141941921276d-1*t39
     2         )*t9/(t6**2*t7)+1.3210398931339265d-3*t41*t8+1.1102230246
     3         251565d-16*t13*(-9.970917392951799d-1*t42-7.4185647371689
     4         58d-1*t41-4.002143174996817d-1*t40-1.264669550498372d-1*t
     5         39)/(t10**2*t11)+3.0506411443514264d-19*t12*t41
            t44 = rhob**1.6666666666666674d-1
            t45 = 1/t17**3.0d+0
            t46 = 1/t14**2
            t47 = 3.361321652984956d-3*gammabb*t18*t43*t46+7.84308385696
     1         4898d-3*gammabb*t16*t44*t45
            t48 = 1/t19**2
            t49 = -3.361321652984956d-3*gammabb*t18*t43*t46-7.8430838569
     1         64898d-3*gammabb*t16*t44*t45
            fnc(iq) = 1.0d+0*rhob*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t14*(-t29*t37*t49-5.0d+0*t29*t3
     1         5*t36*t49-4.0d+0*t29*t33*t34*t49-3.0d+0*t29*t31*t32*t49-2
     2         .0d+0*t28*t29*t30*t49+5.0d+0*t26*t27*t47*t48+4.0d+0*t24*t
     3         25*t47*t48+3.0d+0*t22*t23*t47*t48+2.0d+0*t20*t21*t47*t48+
     4         1.0d+0*t15*t47*t48)*wght+1.0d+0*rhob*t38*t43*wght+1.0d+0*
     5         t14*t38*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*(t16*t18*(-1.6806608264924
     1         78d-2*t26*t27-1.3445286611939825d-2*t24*t25-1.00839649589
     2         54868d-2*t22*t23-6.722643305969912d-3*t20*t21-3.361321652
     3         984956d-3*t15)*t48+t16*t18*(-3.361321652984956d-3*t29*t37
     4         -1.680660826492478d-2*t29*t35*t36-1.3445286611939825d-2*t
     5         29*t33*t34-1.0083964958954868d-2*t29*t31*t32-6.7226433059
     6         69912d-3*t28*t29*t30))*wght+Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_sogga functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_4} &=& {\it t_3}^4\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_1}^4}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_7} &=& 1.0-{\it t_3}\,{\it t_6}\\\\ 
C>   {\it t_8} &=& {\it t_3}\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& {\it t_8}^{{{4}\over{3}}}+{\it t_7}^{{{4}\over{3}}}
C>    -2.0\\\\ 
C>   {\it t_{10}} &=& -1.923661050931536\,{\it t_4}\,{\it t_5}\,{
C>    \it t_9}\\\\ 
C>   {\it t_{11}} &=& {{1}\over{{\it t_1}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\sqrt{{\it t_1}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_1}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{14}} &=& -0.0598079686361971\,{\it t_4}\,{\it t_5}
C>    \,\left(0.1274696188700087\,{\it t_2}+1.0\right)\,{\it t_9}
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{13}}+3.844746237447211\,{\it t_2}+1.644733775567609
C>    \,{\it t_{12}}+0.2405871291288192\,{\it t_{11}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_2}
C>    +1.0\right)\,\left({\it t_{10}}+1.923661050931536\,{
C>    \it t_9}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{13}}+2.247591863577616\,{
C>    \it t_2}+0.4300972471276643\,{\it t_{12}}+0.1911512595127337
C>    \,{\it t_{11}}}}+1.0\right)-0.0621814\,
C>    \left(0.1325688999052018\,{\it t_2}+1.0\right)\,\left({
C>    \it t_{10}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{13}}+2.225569421150687\,{
C>    \it t_2}+0.8004286349993635\,{\it t_{12}}+0.1897004325747558
C>    \,{\it t_{11}}}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{18}} &=& {\it t_8}^{0.6666666666666667}+{
C>    \it t_7}^{0.6666666666666667}\\\\ 
C>   {\it t_{19}} &=& {\it t_{18}}^3\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({\it t_1}^{1.166666666666667}
C>    \,{\it t_{18}}\right)^{2.0}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& 1.0-{{1.0}\over{1.0-0.002117499953031588\,{
C>    \it t_{19}}\,{\it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{29}} &=& 1.0-e^{0.002117499953031588\,{\it t_{19}}\,{
C>    \it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{38}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{37}}+2.225569421150687\,{\it t_{36}}+0.8004286349993635
C>    \,{\it t_{35}}+0.1897004325747558\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{36}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{37}}+3.844746237447211\,{\it t_{36}}+1.644733775567609
C>    \,{\it t_{35}}+0.2405871291288192\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{36}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{41}} &=& 1.0-{{1.0}\over{1.0-0.003361321652984956\,{
C>    \it t_{39}}\,{\it t_{40}}\,\sigma_{ss}}}\\\\ 
C>   {\it t_{42}} &=& 1.0-e^{0.003361321652984956\,{\it t_{39}}\,{
C>    \it t_{40}}\,\sigma_{ss}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{14}}\,\left({\it t_{33}}\,{
C>    \it t_{29}}+{\it t_{32}}\,{\it t_{29}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{29}}^{4.0}+{\it t_{30}}\,{\it t_{29}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{29}}^{2.0}+{\it t_{27}}\,{\it t_{23}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{23}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{23}}^{3.0}+{\it t_{24}}\,{\it t_{23}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{23}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{38}}\,\rho_s\,\left({\it t_{33}}\,{\it t_{42}}
C>    +{\it t_{32}}\,{\it t_{42}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{42}}^{4.0}+{\it t_{30}}\,{\it t_{42}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{42}}^{2.0}+{\it t_{27}}\,{\it t_{41}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{41}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{41}}^{3.0}+{\it t_{24}}\,{\it t_{41}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{41}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, Y Zhao, DG Truhlar, J.Phys.Chem.Lett. 2
C>    , 1991 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz200616w "> 
C> 10.1021/jz200616w </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_sogga_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = log(1.6081979498692536d+1/(5.329846514438383d+0*t5+1.76
     1         6435620181429d+0*t4+5.659885156639418d-1*t3+1.19503784087
     2         549d-1*t1)+1.0d+0)
            t7 = 1.0522000558389212d-1*t4+1.0d+0
            t8 = param(1)
            t9 = param(7)
            t10 = param(2)
            t11 = rhoa**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = 5.405670591181536d-2*gammaaa*t12/(t6*t7)
            t14 = 1.0d+0-1.0d+0/(t13+1.0d+0)
            t15 = param(3)
            t16 = param(4)
            t17 = param(5)
            t18 = param(6)
            t19 = param(9)
            t20 = 1.0d+0-exp(-t13)
            t21 = param(10)
            t22 = param(11)
            t23 = param(12)
            t24 = param(8)
            t25 = 6.299605249474366d-1
            t26 = 1.414213562373095d+0
            t27 = 1/t26
            t28 = 7.937005259840998d-1
            t29 = 8.908987181403393d-1
            t30 = 5.982550435771079d+0*t29*t5+2.2255694211506874d+0*t28*
     1         t4+8.004286349993635d-1*t27*t3+1.8970043257475583d-1*t1*t
     2         25
            t31 = 1.6081979498692536d+1/t30+1.0d+0
            t32 = log(t31)
            t33 = 1.3256889990520176d-1*t28*t4+1.0d+0
            t34 = 1/t32
            t35 = 1/t33
            t36 = 5.405670591181535d-2*gammaaa*t12*t34*t35
            t37 = t36+1.0d+0
            t38 = 1.0d+0-1.0d+0/t37
            t39 = t38**2.0d+0
            t40 = t38**3.0d+0
            t41 = t38**4.0d+0
            t42 = exp(-t36)
            t43 = 1.0d+0-t42
            t44 = t43**2.0d+0
            t45 = t43**3.0d+0
            t46 = t43**4.0d+0
            t47 = t9+t8+t22*t46+t21*t45+t19*t44+t23*t43**5.0d+0+t24*t43+
     1         t17*t41+t16*t40+t15*t39+t18*t38**5.0d+0+t10*t38
            t48 = 1/t31
            t49 = 3.968502629920499d-1
            t50 = 1/rhoa**1.3333333333333333d+0
            t51 = -7.418564737168958d-1*t49*t50-4.002143174996817d-1/(t2
     1         **3*t26**3)-4.4415387620319857d-1/rhoa**1.166666666666666
     2         7d+0-3.9834594695849657d-2/rhoa**1.6666666666666669d+0
            t52 = 1/t30**2
            t53 = 1.0d+0*t33*t48*t51*t52+2.747773264188437d-3*t32*t49*t5
     1         0
            t54 = rhoa**1.6666666666666674d-1
            t55 = 1/t11**3.0d+0
            t56 = 1/t32**2
            t57 = 1/t33**2
            t58 = 8.69338836240666d-1*gammaaa*t12*t53*t56*t57-6.30661568
     1         9711792d-2*gammaaa*t34*t35*t54*t55
            t59 = 1/t37**2
            t60 = 6.306615689711792d-2*gammaaa*t34*t35*t54*t55-8.6933883
     1         6240666d-1*gammaaa*t12*t53*t56*t57
            t61 = -5.0d+0*t23*t42*t46*t60-4.0d+0*t22*t42*t45*t60-3.0d+0*
     1         t21*t42*t44*t60-2.0d+0*t19*t42*t43*t60-t24*t42*t60+5.0d+0
     2         *t18*t41*t58*t59+4.0d+0*t17*t40*t58*t59+3.0d+0*t16*t39*t5
     3         8*t59+2.0d+0*t15*t38*t58*t59+1.0d+0*t10*t58*t59
            t62 = -8.469999812126351d-2*t18*t41-6.775999849701081d-2*t17
     1         *t40-5.081999887275811d-2*t16*t39-3.3879999248505405d-2*t
     2         15*t38-1.6939999624252702d-2*t10
            t63 = -1.6939999624252702d-1*t18*t41-1.3551999699402162d-1*t
     1         17*t40-1.0163999774551621d-1*t16*t39-6.775999849701081d-2
     2         *t15*t38-3.3879999248505405d-2*t10
            t64 = 2.0d+0*t47*t53*wght
            t65 = t51**2
            t66 = 1.6081979498692536d+1*t33*t65/(t30**4*t31**2)
            t67 = -2.0d+0*t33*t48*t65/t30**3
            t68 = 1.9842513149602492d-1
            t69 = 1/rhoa**2.3333333333333334d+0
            t70 = 1.0d+0*t33*t48*t52*(9.89141964955861d-1*t68*t69+6.0032
     1         14762495226d-1/(t2**5*t26**5)+2.5908976111853255d-1/rhoa*
     2         *2.1666666666666665d+0+3.319549557987472d-2/rhoa**2.66666
     3         66666666666d+0)
            t71 = -3.663697685584583d-3*t32*t68*t69
            t72 = log(2.9608813203268075d+1/(8.157414703487641d+0*t29*t5
     1         +2.247591863577616d+0*t28*t4+4.3009724712766434d-1*t27*t3
     2         +1.9115125951273373d-1*t1*t25)+1.0d+0)
            t73 = 6.901399211255825d-2*t28*t4+1.0d+0
            t74 = 1/rhoa**2
            t75 = -8.837926660346784d-2*t48*t49*t50*t51*t52
            t76 = t75+8.443431970194815d-3*t72*t73*t74+t71+t70+t67+t66
            t77 = -1.243628d-1*t32*t33*t61*wght
            t78 = 4.0d+0*rhoa*t53*t61*wght
            t79 = rhoa**3.333333333333335d-1
            t80 = 1/t11**4.0d+0
            t81 = 1/rhoa**8.333333333333333d-1
            t82 = -2.0284572845615542d+0*gammaaa*t53*t54*t55*t56*t57
            t83 = 1/t32**3
            t84 = t53**2
            t85 = 1/t33**3
            t86 = 2.7961378683679233d+1*gammaaa*t12*t83*t84*t85
            t87 = t86+t82+7.507875821085456d-4*gammaaa*t34*t35*t55*t81+1
     1         .1036577456995636d-1*gammaaa*t34*t35*t79*t80+8.6933883624
     2         0666d-1*gammaaa*t12*t56*t57*t76-9.009450985302561d-3*gamm
     3         aaa*t12*t34*t35*t74
            t88 = t58**2
            t89 = 1/t37**4
            t90 = 2.0d+0*t15*t88*t89
            t91 = 1/t37**3
            t92 = -2.0d+0*t10*t88*t91
            t93 = 6.0d+0*t16*t38*t88*t89
            t94 = -4.0d+0*t15*t38*t88*t91
            t95 = 1.2d+1*t17*t39*t88*t89
            t96 = -6.0d+0*t16*t39*t88*t91
            t97 = 2.0d+1*t18*t40*t88*t89
            t98 = -8.0d+0*t17*t40*t88*t91
            t99 = -1.0d+1*t18*t41*t88*t91
            t100 = t60**2
            t101 = exp(-1.0811341182363071d-1*gammaaa*t12*t34*t35)
            t102 = 2.0d+0*t100*t101*t19
            t103 = 1.2d+1*t100*t101*t22*t44
            t104 = 2.0d+1*t100*t101*t23*t45
            t105 = 6.0d+0*t100*t101*t21*t43
            t106 = 2.0284572845615542d+0*gammaaa*t53*t54*t55*t56*t57
            t107 = -2.7961378683679233d+1*gammaaa*t12*t83*t84*t85
            t108 = -7.507875821085456d-4*gammaaa*t34*t35*t55*t81-1.10365
     1         77456995636d-1*gammaaa*t34*t35*t79*t80-8.69338836240666d-
     2         1*gammaaa*t12*t56*t57*t76+9.009450985302561d-3*gammaaa*t1
     3         2*t34*t35*t74+t107+t106
            t109 = -t100*t24*t42
            t110 = -3.0d+0*t100*t21*t42*t44
            t111 = -4.0d+0*t100*t22*t42*t45
            t112 = -5.0d+0*t100*t23*t42*t46
            t113 = -2.0d+0*t100*t19*t42*t43
            t114 = t75-8.443431970194815d-3*t72*t73*t74+t71+t70+t67+t66
            t115 = t86+t82-1.1261813731628201d-2*gammaaa*t34*t35*t55*t81
     1         +1.1036577456995637d-1*gammaaa*t34*t35*t79*t80+9.00945098
     2         5302558d-3*gammaaa*t12*t34*t35*t74+8.69338836240666d-1*ga
     3         mmaaa*t114*t12*t56*t57
            t116 = 1.1261813731628201d-2*gammaaa*t34*t35*t55*t81-1.10365
     1         77456995637d-1*gammaaa*t34*t35*t79*t80-9.009450985302558d
     2         -3*gammaaa*t12*t34*t35*t74-8.69338836240666d-1*gammaaa*t1
     3         14*t12*t56*t57+t107+t106
            t117 = 6.75708823897692d-2*t12*t18*t34*t35*t41*t59+5.4056705
     1         91181535d-2*t12*t17*t34*t35*t40*t59+4.054252943386152d-2*
     2         t12*t16*t34*t35*t39*t59+2.7028352955907675d-2*t12*t15*t34
     3         *t35*t38*t59+1.3514176477953838d-2*t10*t12*t34*t35*t59+6.
     4         75708823897692d-2*t12*t23*t34*t35*t42*t46+5.4056705911815
     5         35d-2*t12*t22*t34*t35*t42*t45+4.054252943386152d-2*t12*t2
     6         1*t34*t35*t42*t44+2.7028352955907675d-2*t12*t19*t34*t35*t
     7         42*t43+1.3514176477953838d-2*t12*t24*t34*t35*t42
            t118 = 2.173347090601665d-1*t12*t53*t56*t57-1.57665392242794
     1         8d-2*t34*t35*t54*t55
            t119 = 1.576653922427948d-2*t34*t35*t54*t55-2.17334709060166
     1         5d-1*t12*t53*t56*t57
            t120 = -1.243628d-1*rhoa*t32*t33*(-1.351417647795384d-1*t12*
     1         t18*t34*t35*t41*t58*t91-1.0811341182363071d-1*t12*t17*t34
     2         *t35*t40*t58*t91-8.108505886772304d-2*t12*t16*t34*t35*t39
     3         *t58*t91-5.405670591181535d-2*t12*t15*t34*t35*t38*t58*t91
     4         -2.7028352955907675d-2*t10*t12*t34*t35*t58*t91+2.70283529
     5         5590768d-1*t12*t18*t34*t35*t40*t58*t89+1.6217011773544607
     6         d-1*t12*t17*t34*t35*t39*t58*t89+8.108505886772304d-2*t12*
     7         t16*t34*t35*t38*t58*t89+2.7028352955907675d-2*t12*t15*t34
     8         *t35*t58*t89+6.75708823897692d-2*t12*t23*t34*t35*t42*t46*
     9         t60+5.405670591181535d-2*t12*t22*t34*t35*t42*t45*t60-2.70
     :         2835295590768d-1*t101*t12*t23*t34*t35*t45*t60+4.054252943
     ;         386152d-2*t12*t21*t34*t35*t42*t44*t60-1.6217011773544607d
     <         -1*t101*t12*t22*t34*t35*t44*t60+2.7028352955907675d-2*t12
     =         *t19*t34*t35*t42*t43*t60-8.108505886772304d-2*t101*t12*t2
     >         1*t34*t35*t43*t60+1.3514176477953838d-2*t12*t24*t34*t35*t
     ?         42*t60-2.7028352955907675d-2*t101*t12*t19*t34*t35*t60+5.0
     @         d+0*t118*t18*t41*t59+4.0d+0*t118*t17*t40*t59+3.0d+0*t118*
     1         t16*t39*t59+2.0d+0*t118*t15*t38*t59+1.0d+0*t10*t118*t59-5
     2         .0d+0*t119*t23*t42*t46-4.0d+0*t119*t22*t42*t45-3.0d+0*t11
     3         9*t21*t42*t44-2.0d+0*t119*t19*t42*t43-t119*t24*t42)*wght+
     4         2.0d+0*rhoa*t117*t53*wght-6.21814d-2*t117*t32*t33*wght
            t121 = 1.351417647795384d-1*t12*t18*t34*t35*t41*t59+1.081134
     1         1182363071d-1*t12*t17*t34*t35*t40*t59+8.108505886772304d-
     2         2*t12*t16*t34*t35*t39*t59+5.405670591181535d-2*t12*t15*t3
     3         4*t35*t38*t59+2.7028352955907675d-2*t10*t12*t34*t35*t59+1
     4         .351417647795384d-1*t12*t23*t34*t35*t42*t46+1.08113411823
     5         63071d-1*t12*t22*t34*t35*t42*t45+8.108505886772304d-2*t12
     6         *t21*t34*t35*t42*t44+5.405670591181535d-2*t12*t19*t34*t35
     7         *t42*t43+2.7028352955907675d-2*t12*t24*t34*t35*t42
            t122 = 4.34669418120333d-1*t12*t53*t56*t57-3.153307844855896
     1         d-2*t34*t35*t54*t55
            t123 = 3.153307844855896d-2*t34*t35*t54*t55-4.34669418120333
     1         d-1*t12*t53*t56*t57
            t124 = -1.243628d-1*rhoa*t32*t33*(2.156233411195693d-2*t56*t
     1         57*t62*t80*t91-7.977672241861109d-1*t12*t34*t35*t59*(-4.5
     2         786028891724556d-3*t12*t18*t34*t35*t40*t59-2.747161733503
     3         473d-3*t12*t17*t34*t35*t39*t59-1.3735808667517366d-3*t12*
     4         t16*t34*t35*t38*t59-4.578602889172455d-4*t12*t15*t34*t35*
     5         t59)-7.977672241861109d-1*t12*t34*t35*(1.1446507222931139
     6         d-3*t12*t23*t34*t35*t42*t46+9.15720577834491d-4*t12*t22*t
     7         34*t35*t42*t45-4.5786028891724556d-3*t101*t12*t23*t34*t35
     8         *t45+6.867904333758682d-4*t12*t21*t34*t35*t42*t44-2.74716
     9         1733503473d-3*t101*t12*t22*t34*t35*t44+4.578602889172455d
     :         -4*t12*t19*t34*t35*t42*t43-1.3735808667517366d-3*t101*t12
     ;         *t21*t34*t35*t43+2.2893014445862275d-4*t12*t24*t34*t35*t4
     <         2-4.578602889172455d-4*t101*t12*t19*t34*t35))*wght
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*t6*t7*(t9+t8+t20*t24+t20*
     1         *5.0d+0*t23+t20**4.0d+0*t22+t20**3.0d+0*t21+t19*t20**2.0d
     2         +0+t14**5.0d+0*t18+t14**4.0d+0*t17+t14**3.0d+0*t16+t14**2
     3         .0d+0*t15+t10*t14)*wght
            Amat(iq,D1_RA) = -1.243628d-1*rhoa*t32*t33*t61*wght+2.0d+0*r
     1         hoa*t47*t53*wght-6.21814d-2*t32*t33*t47*wght+Amat(iq,D1_R
     2         A)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-1.243628d-1*rhoa*t32*t33*(
     1         -7.977672241861109d-1*t12*t34*t35*t59*t62-7.9776722418611
     2         09d-1*t12*t34*t35*(-8.469999812126351d-2*t23*t42*t46-6.77
     3         5999849701081d-2*t22*t42*t45-5.081999887275811d-2*t21*t42
     4         *t44-3.3879999248505405d-2*t19*t42*t43-1.6939999624252702
     5         d-2*t24*t42))*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)-1.243628d-1*rhoa*t32*t33*(
     1         -7.977672241861109d-1*t12*t34*t35*t59*t63-7.9776722418611
     2         09d-1*t12*t34*t35*(-1.6939999624252702d-1*t23*t42*t46-1.3
     3         551999699402162d-1*t22*t42*t45-1.0163999774551621d-1*t21*
     4         t42*t44-6.775999849701081d-2*t19*t42*t43-3.38799992485054
     5         05d-2*t24*t42))*wght
            Amat2(iq,D2_RA_RA) = -1.243628d-1*rhoa*t32*t33*(t99+t98+t97+
     1         t96+t95+t94+t93+t92+t90+5.0d+0*t18*t41*t59*t87+4.0d+0*t17
     2         *t40*t59*t87+3.0d+0*t16*t39*t59*t87+2.0d+0*t15*t38*t59*t8
     3         7+1.0d+0*t10*t59*t87-5.0d+0*t108*t23*t42*t46-4.0d+0*t108*
     4         t22*t42*t45-3.0d+0*t108*t21*t42*t44-2.0d+0*t108*t19*t42*t
     5         43-t108*t24*t42+t113+t112+t111+t110+t109+t105+t104+t103+t
     6         102)*wght+2.0d+0*rhoa*t47*t76*wght+t78+t77+t64+Amat2(iq,D
     7         2_RA_RA)
            Amat2(iq,D2_RA_RB) = -1.243628d-1*rhoa*t32*t33*(t99+t98+t97+
     1         t96+t95+t94+t93+t92+t90+5.0d+0*t115*t18*t41*t59+4.0d+0*t1
     2         15*t17*t40*t59+3.0d+0*t115*t16*t39*t59+2.0d+0*t115*t15*t3
     3         8*t59+1.0d+0*t10*t115*t59-5.0d+0*t116*t23*t42*t46-4.0d+0*
     4         t116*t22*t42*t45-3.0d+0*t116*t21*t42*t44-2.0d+0*t116*t19*
     5         t42*t43-t116*t24*t42+t113+t112+t111+t110+t109+t105+t104+t
     6         103+t102)*wght+2.0d+0*rhoa*t114*t47*wght+t78+t77+t64+Amat
     7         2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t120+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = -1.243628d-1*rhoa*t32*t33*(-2.70283529
     1         5590768d-1*t12*t18*t34*t35*t41*t58*t91-2.1622682364726142
     2         d-1*t12*t17*t34*t35*t40*t58*t91-1.6217011773544607d-1*t12
     3         *t16*t34*t35*t39*t58*t91-1.0811341182363071d-1*t12*t15*t3
     4         4*t35*t38*t58*t91-5.405670591181535d-2*t10*t12*t34*t35*t5
     5         8*t91+5.405670591181536d-1*t12*t18*t34*t35*t40*t58*t89+3.
     6         2434023547089214d-1*t12*t17*t34*t35*t39*t58*t89+1.6217011
     7         773544607d-1*t12*t16*t34*t35*t38*t58*t89+5.40567059118153
     8         5d-2*t12*t15*t34*t35*t58*t89+1.351417647795384d-1*t12*t23
     9         *t34*t35*t42*t46*t60+1.0811341182363071d-1*t12*t22*t34*t3
     :         5*t42*t45*t60-5.405670591181536d-1*t101*t12*t23*t34*t35*t
     ;         45*t60+8.108505886772304d-2*t12*t21*t34*t35*t42*t44*t60-3
     <         .2434023547089214d-1*t101*t12*t22*t34*t35*t44*t60+5.40567
     =         0591181535d-2*t12*t19*t34*t35*t42*t43*t60-1.6217011773544
     >         607d-1*t101*t12*t21*t34*t35*t43*t60+2.7028352955907675d-2
     ?         *t12*t24*t34*t35*t42*t60-5.405670591181535d-2*t101*t12*t1
     @         9*t34*t35*t60+5.0d+0*t122*t18*t41*t59+4.0d+0*t122*t17*t40
     1         *t59+3.0d+0*t122*t16*t39*t59+2.0d+0*t122*t15*t38*t59+1.0d
     2         +0*t10*t122*t59-5.0d+0*t123*t23*t42*t46-4.0d+0*t123*t22*t
     3         42*t45-3.0d+0*t123*t21*t42*t44-2.0d+0*t123*t19*t42*t43-t1
     4         23*t24*t42)*wght+2.0d+0*rhoa*t121*t53*wght-6.21814d-2*t12
     5         1*t32*t33*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t120+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t124+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)-1.243628d-1*rhoa
     1         *t32*t33*(4.312466822391386d-2*t56*t57*t62*t80*t91-7.9776
     2         72241861109d-1*t12*t34*t35*t59*(-9.157205778344911d-3*t12
     3         *t18*t34*t35*t40*t59-5.494323467006946d-3*t12*t17*t34*t35
     4         *t39*t59-2.747161733503473d-3*t12*t16*t34*t35*t38*t59-9.1
     5         5720577834491d-4*t12*t15*t34*t35*t59)-7.977672241861109d-
     6         1*t12*t34*t35*(2.2893014445862278d-3*t12*t23*t34*t35*t42*
     7         t46+1.8314411556689822d-3*t12*t22*t34*t35*t42*t45-9.15720
     8         5778344911d-3*t101*t12*t23*t34*t35*t45+1.3735808667517366
     9         d-3*t12*t21*t34*t35*t42*t44-5.494323467006946d-3*t101*t12
     :         *t22*t34*t35*t44+9.15720577834491d-4*t12*t19*t34*t35*t42*
     ;         t43-2.747161733503473d-3*t101*t12*t21*t34*t35*t43+4.57860
     <         2889172455d-4*t12*t24*t34*t35*t42-9.15720577834491d-4*t10
     =         1*t12*t19*t34*t35))*wght
            Cmat2(iq,D2_GAA_GBB) = t124+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)-1.243628d-1*rhoa
     1         *t32*t33*(4.312466822391386d-2*t56*t57*t63*t80*t91-7.9776
     2         72241861109d-1*t12*t34*t35*t59*(-1.8314411556689822d-2*t1
     3         2*t18*t34*t35*t40*t59-1.0988646934013892d-2*t12*t17*t34*t
     4         35*t39*t59-5.494323467006946d-3*t12*t16*t34*t35*t38*t59-1
     5         .8314411556689822d-3*t12*t15*t34*t35*t59)-7.9776722418611
     6         09d-1*t12*t34*t35*(4.5786028891724556d-3*t12*t23*t34*t35*
     7         t42*t46+3.6628823113379644d-3*t12*t22*t34*t35*t42*t45-1.8
     8         314411556689822d-2*t101*t12*t23*t34*t35*t45+2.74716173350
     9         3473d-3*t12*t21*t34*t35*t42*t44-1.0988646934013892d-2*t10
     :         1*t12*t22*t34*t35*t44+1.8314411556689822d-3*t12*t19*t34*t
     ;         35*t42*t43-5.494323467006946d-3*t101*t12*t21*t34*t35*t43+
     <         9.15720577834491d-4*t12*t24*t34*t35*t42-1.831441155668982
     =         2d-3*t101*t12*t19*t34*t35))*wght
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = 1/t1**3.333333333333333d-1
            t3 = 1.3256889990520176d-1*t2+1.0d+0
            t4 = rhoa-rhob
            t5 = t4**4
            t6 = 1/t1**4
            t7 = 1/t1
            t8 = 1.0d+0-t4*t7
            t9 = t4*t7+1.0d+0
            t10 = t9**1.3333333333333333d+0+t8**1.3333333333333333d+0-2.
     1         0d+0
            t11 = -1.923661050931536d+0*t10*t5*t6
            t12 = t11+1.0d+0
            t13 = 1/t1**6.666666666666666d-1
            t14 = t1**5.0d-1
            t15 = 1/t14
            t16 = 1/t1**1.6666666666666666d-1
            t17 = 2.2255694211506874d+0*t2+5.982550435771079d+0*t16+8.00
     1         4286349993635d-1*t15+1.8970043257475583d-1*t13
            t18 = 1.6081979498692536d+1/t17+1.0d+0
            t19 = log(t18)
            t20 = 6.901399211255825d-2*t2+1.0d+0
            t21 = t11+1.923661050931536d+0*t10
            t22 = 2.247591863577616d+0*t2+8.157414703487641d+0*t16+4.300
     1         9724712766434d-1*t15+1.9115125951273373d-1*t13
            t23 = 2.9608813203268075d+1/t22+1.0d+0
            t24 = log(t23)
            t25 = 1.274696188700087d-1*t2+1.0d+0
            t26 = 3.8447462374472113d+0*t2+1.1120374863094686d+1*t16+1.6
     1         44733775567609d+0*t15+2.4058712912881916d-1*t13
            t27 = 3.216395899738507d+1/t26+1.0d+0
            t28 = log(t27)
            t29 = -5.980796863619711d-2*t10*t25*t28*t5*t6-6.21814d-2*t12
     1         *t19*t3+1.9751631321680768d-2*t20*t21*t24
            t30 = param(9)
            t31 = gammabb+2.0d+0*gammaab+gammaaa
            t32 = t9**6.666666666666667d-1+t8**6.666666666666667d-1
            t33 = t32**3
            t34 = t1**1.1666666666666667d+0
            t35 = t32*t34
            t36 = 1/t35**2.0d+0
            t37 = 1/t29
            t38 = exp(2.1174999530315877d-3*t31*t33*t36*t37)
            t39 = 1.0d+0-t38
            t40 = t39**2.0d+0
            t41 = param(10)
            t42 = t39**3.0d+0
            t43 = param(11)
            t44 = t39**4.0d+0
            t45 = param(12)
            t46 = param(8)
            t47 = param(2)
            t48 = 1.0d+0-2.1174999530315877d-3*t31*t33*t36*t37
            t49 = 1.0d+0-1.0d+0/t48
            t50 = param(3)
            t51 = t49**2.0d+0
            t52 = param(4)
            t53 = t49**3.0d+0
            t54 = param(5)
            t55 = t49**4.0d+0
            t56 = param(6)
            t57 = t49**5.0d+0*t56+t54*t55+t52*t53+t50*t51+t47*t49+t39*t4
     1         6+t39**5.0d+0*t45+t43*t44+t41*t42+t30*t40+param(7)+param(
     2         1)
            t58 = 1/t1**1.6666666666666669d+0
            t59 = 1/t14**3
            t60 = 1/t1**1.3333333333333333d+0
            t61 = 1/t1**1.1666666666666667d+0
            t62 = -9.970917392951799d-1*t61-7.418564737168958d-1*t60-4.0
     1         02143174996817d-1*t59-1.264669550498372d-1*t58
            t63 = 1/t17**2
            t64 = 1/t18
            t65 = 1.0d+0*t12*t3*t62*t63*t64
            t66 = -1.3595691172479402d+0*t61-7.491972878592053d-1*t60-2.
     1         1504862356383217d-1*t59-1.2743417300848914d-1*t58
            t67 = 1/t22**2
            t68 = 1/t23
            t69 = -5.848223622634647d-1*t20*t21*t66*t67*t68
            t70 = -1.8533958105157808d+0*t61-1.2815820791490704d+0*t60-8
     1         .223668877838045d-1*t59-1.6039141941921276d-1*t58
            t71 = 1/t26**2
            t72 = 1/t27
            t73 = 1.923661050931536d+0*t10*t25*t5*t6*t70*t71*t72
            t74 = 1/t1**2
            t75 = t4*t74
            t76 = -t7
            t77 = t76+t75
            t78 = t8**3.333333333333333d-1
            t79 = -t4*t74
            t80 = t79+t7
            t81 = t9**3.333333333333333d-1
            t82 = 1.3333333333333333d+0*t80*t81+1.3333333333333333d+0*t7
     1         7*t78
            t83 = -1.923661050931536d+0*t5*t6*t82
            t84 = 1/t1**5
            t85 = 7.694644203726144d+0*t10*t5*t84
            t86 = t4**3
            t87 = -7.694644203726144d+0*t10*t6*t86
            t88 = t87+t85+t83
            t89 = 2.747773264188437d-3*t12*t19*t60
            t90 = t87+t85+t83+1.923661050931536d+0*t82
            t91 = -4.5437964274821163d-4*t21*t24*t60
            t92 = 1/t1**5.333333333333333d+0
            t93 = 2.541232989148493d-3*t10*t28*t5*t92
            t94 = 2.3923187454478842d-1*t10*t25*t28*t5*t84
            t95 = t94+t93+t91+1.9751631321680768d-2*t20*t24*t90+t89-6.21
     1         814d-2*t19*t3*t88-2.3923187454478842d-1*t10*t25*t28*t6*t8
     2         6-5.980796863619711d-2*t25*t28*t5*t6*t82+t73+t69+t65
            t96 = 1/t29**2
            t97 = 1/t35**3.0d+0
            t98 = 1/t8**3.3333333333333326d-1
            t99 = 1/t9**3.3333333333333326d-1
            t100 = 6.666666666666667d-1*t80*t99+6.666666666666667d-1*t77
     1         *t98
            t101 = t1**1.6666666666666674d-1
            t102 = 1.1666666666666667d+0*t101*t32
            t103 = t100*t34+t102
            t104 = t32**2
            t105 = -4.2349999060631754d-3*t103*t31*t33*t37*t97-2.1174999
     1         530315877d-3*t31*t33*t36*t95*t96+6.352499859094763d-3*t10
     2         0*t104*t31*t36*t37
            t106 = 4.2349999060631754d-3*t103*t31*t33*t37*t97+2.11749995
     1         30315877d-3*t31*t33*t36*t95*t96-6.352499859094763d-3*t100
     2         *t104*t31*t36*t37
            t107 = 1/t48**2
            t108 = 5.0d+0*t106*t107*t55*t56+4.0d+0*t106*t107*t53*t54+3.0
     1         d+0*t106*t107*t51*t52+2.0d+0*t106*t107*t49*t50+1.0d+0*t10
     2         6*t107*t47-t105*t38*t46-5.0d+0*t105*t38*t44*t45-4.0d+0*t1
     3         05*t38*t42*t43-3.0d+0*t105*t38*t40*t41-2.0d+0*t105*t30*t3
     4         8*t39
            t109 = 1.0d+0*t29*t57*wght
            t110 = t75+t7
            t111 = t79+t76
            t112 = 1.3333333333333333d+0*t111*t81+1.3333333333333333d+0*
     1         t110*t78
            t113 = -1.923661050931536d+0*t112*t5*t6
            t114 = 7.694644203726144d+0*t10*t6*t86
            t115 = t85+t114+t113
            t116 = t85+t114+t113+1.923661050931536d+0*t112
            t117 = t94+t93+t91+t89+2.3923187454478842d-1*t10*t25*t28*t6*
     1         t86+t73+t69+t65-5.980796863619711d-2*t112*t25*t28*t5*t6-6
     2         .21814d-2*t115*t19*t3+1.9751631321680768d-2*t116*t20*t24
            t118 = 6.666666666666667d-1*t111*t99+6.666666666666667d-1*t1
     1         10*t98
            t119 = t118*t34+t102
            t120 = -4.2349999060631754d-3*t119*t31*t33*t37*t97-2.1174999
     1         530315877d-3*t117*t31*t33*t36*t96+6.352499859094763d-3*t1
     2         04*t118*t31*t36*t37
            t121 = 4.2349999060631754d-3*t119*t31*t33*t37*t97+2.11749995
     1         30315877d-3*t117*t31*t33*t36*t96-6.352499859094763d-3*t10
     2         4*t118*t31*t36*t37
            t122 = 5.0d+0*t107*t121*t55*t56+4.0d+0*t107*t121*t53*t54+3.0
     1         d+0*t107*t121*t51*t52+2.0d+0*t107*t121*t49*t50+1.0d+0*t10
     2         7*t121*t47-t120*t38*t46-5.0d+0*t120*t38*t44*t45-4.0d+0*t1
     3         20*t38*t42*t43-3.0d+0*t120*t38*t40*t41-2.0d+0*t120*t30*t3
     4         8*t39
            t123 = -1.0587499765157939d-2*t33*t55*t56-8.469999812126351d
     1         -3*t33*t53*t54-6.352499859094763d-3*t33*t51*t52-4.2349999
     2         060631754d-3*t33*t49*t50-2.1174999530315877d-3*t33*t47
            t124 = 1.0d+0*t1*t29*(t36*t37*(-2.1174999530315877d-3*t33*t3
     1         8*t46-1.0587499765157939d-2*t33*t38*t44*t45-8.46999981212
     2         6351d-3*t33*t38*t42*t43-6.352499859094763d-3*t33*t38*t40*
     3         t41-4.2349999060631754d-3*t30*t33*t38*t39)+t107*t123*t36*
     4         t37)*wght
            t125 = -2.1174999530315877d-2*t33*t55*t56-1.6939999624252702
     1         d-2*t33*t53*t54-1.2704999718189527d-2*t33*t51*t52-8.46999
     2         9812126351d-3*t33*t49*t50-4.2349999060631754d-3*t33*t47
            t126 = t95**2
            t127 = 1/t29**3
            t128 = t62**2
            t129 = 1.6081979498692536d+1*t12*t128*t3/(t17**4*t18**2)
            t130 = -2.0d+0*t12*t128*t3*t64/t17**3
            t131 = -8.837926660346784d-2*t12*t60*t62*t63*t64
            t132 = 1/t1**2.6666666666666666d+0
            t133 = 1/t14**5
            t134 = 1/t1**2.3333333333333334d+0
            t135 = 1/t1**2.1666666666666665d+0
            t136 = 1.0d+0*t12*(1.1632736958443765d+0*t135+9.891419649558
     1         61d-1*t134+6.003214762495226d-1*t133+2.1077825841639536d-
     2         1*t132)*t3*t63*t64
            t137 = t66**2
            t138 = -1.73158960813529d+1*t137*t20*t21/(t22**4*t23**2)
            t139 = 1.1696447245269295d+0*t137*t20*t21*t68/t22**3
            t140 = 2.690728393099896d-2*t21*t60*t66*t67*t68
            t141 = -5.848223622634647d-1*(1.5861639701225969d+0*t135+9.9
     1         8929717145607d-1*t134+3.2257293534574827d-1*t133+2.123902
     2         8834748191d-1*t132)*t20*t21*t67*t68
            t142 = t70**2
            t143 = 6.187255516702861d+1*t10*t142*t25*t5*t6/(t26**4*t27**
     1         2)
            t144 = -3.847322101863072d+0*t10*t142*t25*t5*t6*t72/t26**3
            t145 = -1.6347222733154887d-1*t10*t5*t70*t71*t72*t92
            t146 = 1.923661050931536d+0*t10*(2.1622951122684114d+0*t135+
     1         1.7087761055320938d+0*t134+1.2335503316757068d+0*t133+2.6
     2         73190323653546d-1*t132)*t25*t5*t6*t71*t72
            t147 = -1.538928840745229d+1*t10*t25*t5*t70*t71*t72*t84
            t148 = t77**2
            t149 = 1/t8**6.666666666666666d-1
            t150 = 1/t1**3
            t151 = -2*t150*t4
            t152 = 2*t74
            t153 = t152+t151
            t154 = t80**2
            t155 = 1/t9**6.666666666666666d-1
            t156 = 2*t150*t4
            t157 = -2*t74
            t158 = t157+t156
            t159 = 1.3333333333333333d+0*t158*t81+1.3333333333333333d+0*
     1         t153*t78+4.444444444444444d-1*t154*t155+4.444444444444444
     2         d-1*t148*t149
            t160 = -1.923661050931536d+0*t159*t5*t6
            t161 = 1.5389288407452287d+1*t5*t82*t84
            t162 = -1.5389288407452287d+1*t6*t82*t86
            t163 = 1/t1**6
            t164 = -3.8473221018630716d+1*t10*t163*t5
            t165 = 6.155715362980915d+1*t10*t84*t86
            t166 = t4**2
            t167 = -2.3083932611178434d+1*t10*t166*t6
            t168 = -3.663697685584583d-3*t12*t134*t19
            t169 = 6.058395236642822d-4*t134*t21*t24
            t170 = -2.3718174565385935d-2*t10*t28*t5/t1**6.3333333333333
     1         33d+0
            t171 = -1.1961593727239421d+0*t10*t163*t25*t28*t5
            t172 = -7.176956236343652d-1*t10*t166*t25*t28*t6
            t173 = 2.0329863913187946d-2*t10*t28*t86*t92+5.0824659782969
     1         86d-3*t28*t5*t82*t92-1.1696447245269295d+0*t20*t66*t67*t6
     2         8*t90-9.087592854964233d-4*t24*t60*t90+2.0d+0*t3*t62*t63*
     3         t64*t88+5.495546528376875d-3*t19*t60*t88+1.91385499635830
     4         74d+0*t10*t25*t28*t84*t86-4.7846374908957684d-1*t25*t28*t
     5         6*t82*t86+1.538928840745229d+1*t10*t25*t6*t70*t71*t72*t86
     6         +4.7846374908957684d-1*t25*t28*t5*t82*t84+3.8473221018630
     7         72d+0*t25*t5*t6*t70*t71*t72*t82-5.980796863619711d-2*t159
     8         *t25*t28*t5*t6-6.21814d-2*(t167+t165+t164+t162+t161+t160)
     9         *t19*t3+1.9751631321680768d-2*(t167+t165+t164+t162+t161+t
     :         160+1.923661050931536d+0*t159)*t20*t24+t172+t171+t170+t16
     ;         9+t168+t147+t146+t145+t144+t143+t141+t140+t139+t138+t136+
     <         t131+t130+t129
            t174 = 1/t8**1.3333333333333333d+0
            t175 = 1/t9**1.3333333333333333d+0
            t176 = 6.666666666666667d-1*t158*t99+6.666666666666667d-1*t1
     1         53*t98-2.222222222222222d-1*t154*t175-2.222222222222222d-
     2         1*t148*t174
            t177 = 1.9444444444444453d-1*t32/t1**8.333333333333333d-1
            t178 = t176*t34+t177+2.3333333333333334d+0*t100*t101
            t179 = t100**2
            t180 = 1/t35**4.0d+0
            t181 = t103**2
            t182 = -8.469999812126351d-3*t103*t31*t33*t95*t96*t97+4.2349
     1         999060631754d-3*t178*t31*t33*t37*t97+2.5409999436379055d-
     2         2*t100*t103*t104*t31*t37*t97+1.2704999718189527d-2*t100*t
     3         104*t31*t36*t95*t96+2.1174999530315877d-3*t173*t31*t33*t3
     4         6*t96-1.2704999718189527d-2*t179*t31*t32*t36*t37-6.352499
     5         859094763d-3*t104*t176*t31*t36*t37-1.2704999718189527d-2*
     6         t180*t181*t31*t33*t37-4.2349999060631754d-3*t126*t127*t31
     7         *t33*t36
            t183 = 8.469999812126351d-3*t103*t31*t33*t95*t96*t97-4.23499
     1         99060631754d-3*t178*t31*t33*t37*t97-2.5409999436379055d-2
     2         *t100*t103*t104*t31*t37*t97-1.2704999718189527d-2*t100*t1
     3         04*t31*t36*t95*t96-2.1174999530315877d-3*t173*t31*t33*t36
     4         *t96+1.2704999718189527d-2*t179*t31*t32*t36*t37+6.3524998
     5         59094763d-3*t104*t176*t31*t36*t37+1.2704999718189527d-2*t
     6         180*t181*t31*t33*t37+4.2349999060631754d-3*t126*t127*t31*
     7         t33*t36
            t184 = t105**2
            t185 = exp(4.2349999060631754d-3*t31*t33*t36*t37)
            t186 = t106**2
            t187 = 1/t48**4
            t188 = 1/t48**3
            t189 = 2.6666666666666666d+0*t150*t4*t81+4.444444444444444d-
     1         1*t111*t155*t80-2.6666666666666666d+0*t150*t4*t78+4.44444
     2         4444444444d-1*t110*t149*t77
            t190 = -1.923661050931536d+0*t189*t5*t6
            t191 = 7.694644203726144d+0*t112*t5*t84
            t192 = -7.694644203726144d+0*t112*t6*t86
            t193 = 7.694644203726144d+0*t5*t82*t84
            t194 = 7.694644203726144d+0*t6*t82*t86
            t195 = 2.3083932611178434d+1*t10*t166*t6
            t196 = 2.541232989148493d-3*t28*t5*t82*t92+2.541232989148493
     1         d-3*t112*t28*t5*t92-5.848223622634647d-1*t20*t66*t67*t68*
     2         t90-4.5437964274821163d-4*t24*t60*t90+1.0d+0*t3*t62*t63*t
     3         64*t88+2.747773264188437d-3*t19*t60*t88+2.392318745447884
     4         2d-1*t25*t28*t6*t82*t86-2.3923187454478842d-1*t112*t25*t2
     5         8*t6*t86+2.3923187454478842d-1*t25*t28*t5*t82*t84+2.39231
     6         87454478842d-1*t112*t25*t28*t5*t84+1.923661050931536d+0*t
     7         25*t5*t6*t70*t71*t72*t82+1.923661050931536d+0*t112*t25*t5
     8         *t6*t70*t71*t72-5.848223622634647d-1*t116*t20*t66*t67*t68
     9         +1.0d+0*t115*t3*t62*t63*t64-4.5437964274821163d-4*t116*t2
     :         4*t60+2.747773264188437d-3*t115*t19*t60-5.980796863619711
     ;         d-2*t189*t25*t28*t5*t6+7.176956236343652d-1*t10*t166*t25*
     <         t28*t6-6.21814d-2*t19*(t195+t194+t193+t192+t191+t190+t164
     =         )*t3+1.9751631321680768d-2*(t195+t194+t193+t192+t191+t190
     >         +1.923661050931536d+0*t189+t164)*t20*t24+t171+t170+t169+t
     ?         168+t147+t146+t145+t144+t143+t141+t140+t139+t138+t136+t13
     @         1+t130+t129
            t197 = 1.3333333333333336d+0*t150*t4*t99-1.3333333333333336d
     1         +0*t150*t4*t98-2.222222222222222d-1*t111*t175*t80-2.22222
     2         2222222222d-1*t110*t174*t77
            t198 = t197*t34+t177+1.1666666666666667d+0*t101*t118+1.16666
     1         66666666667d+0*t100*t101
            t199 = 4.2349999060631754d-3*t119*t31*t33*t95*t96*t97+4.2349
     1         999060631754d-3*t103*t117*t31*t33*t96*t97-4.2349999060631
     2         754d-3*t198*t31*t33*t37*t97-1.2704999718189527d-2*t100*t1
     3         04*t119*t31*t37*t97-1.2704999718189527d-2*t103*t104*t118*
     4         t31*t37*t97-6.352499859094763d-3*t104*t118*t31*t36*t95*t9
     5         6-2.1174999530315877d-3*t196*t31*t33*t36*t96-6.3524998590
     6         94763d-3*t100*t104*t117*t31*t36*t96+4.2349999060631754d-3
     7         *t117*t127*t31*t33*t36*t95+1.2704999718189527d-2*t100*t11
     8         8*t31*t32*t36*t37+6.352499859094763d-3*t104*t197*t31*t36*
     9         t37+1.2704999718189527d-2*t103*t119*t180*t31*t33*t37
            t200 = -4.2349999060631754d-3*t119*t31*t33*t95*t96*t97-4.234
     1         9999060631754d-3*t103*t117*t31*t33*t96*t97+4.234999906063
     2         1754d-3*t198*t31*t33*t37*t97+1.2704999718189527d-2*t100*t
     3         104*t119*t31*t37*t97+1.2704999718189527d-2*t103*t104*t118
     4         *t31*t37*t97+6.352499859094763d-3*t104*t118*t31*t36*t95*t
     5         96+2.1174999530315877d-3*t196*t31*t33*t36*t96+6.352499859
     6         094763d-3*t100*t104*t117*t31*t36*t96-4.2349999060631754d-
     7         3*t117*t127*t31*t33*t36*t95-1.2704999718189527d-2*t100*t1
     8         18*t31*t32*t36*t37-6.352499859094763d-3*t104*t197*t31*t36
     9         *t37-1.2704999718189527d-2*t103*t119*t180*t31*t33*t37
            t201 = t117**2
            t202 = t110**2
            t203 = t157+t151
            t204 = t111**2
            t205 = t156+t152
            t206 = 1.3333333333333333d+0*t205*t81+1.3333333333333333d+0*
     1         t203*t78+4.444444444444444d-1*t155*t204+4.444444444444444
     2         d-1*t149*t202
            t207 = -1.923661050931536d+0*t206*t5*t6
            t208 = 1.5389288407452287d+1*t112*t5*t84
            t209 = 1.5389288407452287d+1*t112*t6*t86
            t210 = -6.155715362980915d+1*t10*t84*t86
            t211 = -2.0329863913187946d-2*t10*t28*t86*t92+5.082465978296
     1         986d-3*t112*t28*t5*t92-1.9138549963583074d+0*t10*t25*t28*
     2         t84*t86-1.538928840745229d+1*t10*t25*t6*t70*t71*t72*t86+4
     3         .7846374908957684d-1*t112*t25*t28*t6*t86+4.78463749089576
     4         84d-1*t112*t25*t28*t5*t84+3.847322101863072d+0*t112*t25*t
     5         5*t6*t70*t71*t72-1.1696447245269295d+0*t116*t20*t66*t67*t
     6         68+2.0d+0*t115*t3*t62*t63*t64-9.087592854964233d-4*t116*t
     7         24*t60+5.495546528376875d-3*t115*t19*t60-5.98079686361971
     8         1d-2*t206*t25*t28*t5*t6-6.21814d-2*t19*(t210+t209+t208+t2
     9         07+t167+t164)*t3+1.9751631321680768d-2*t20*(t210+t209+t20
     :         8+t207+1.923661050931536d+0*t206+t167+t164)*t24+t172+t171
     ;         +t170+t169+t168+t147+t146+t145+t144+t143+t141+t140+t139+t
     <         138+t136+t131+t130+t129
            t212 = 6.666666666666667d-1*t205*t99+6.666666666666667d-1*t2
     1         03*t98-2.222222222222222d-1*t175*t204-2.222222222222222d-
     2         1*t174*t202
            t213 = t212*t34+t177+2.3333333333333334d+0*t101*t118
            t214 = t118**2
            t215 = t119**2
            t216 = -8.469999812126351d-3*t117*t119*t31*t33*t96*t97+4.234
     1         9999060631754d-3*t213*t31*t33*t37*t97+2.5409999436379055d
     2         -2*t104*t118*t119*t31*t37*t97+2.1174999530315877d-3*t211*
     3         t31*t33*t36*t96+1.2704999718189527d-2*t104*t117*t118*t31*
     4         t36*t96-1.2704999718189527d-2*t214*t31*t32*t36*t37-6.3524
     5         99859094763d-3*t104*t212*t31*t36*t37-1.2704999718189527d-
     6         2*t180*t215*t31*t33*t37-4.2349999060631754d-3*t127*t201*t
     7         31*t33*t36
            t217 = 8.469999812126351d-3*t117*t119*t31*t33*t96*t97-4.2349
     1         999060631754d-3*t213*t31*t33*t37*t97-2.5409999436379055d-
     2         2*t104*t118*t119*t31*t37*t97-2.1174999530315877d-3*t211*t
     3         31*t33*t36*t96-1.2704999718189527d-2*t104*t117*t118*t31*t
     4         36*t96+1.2704999718189527d-2*t214*t31*t32*t36*t37+6.35249
     5         9859094763d-3*t104*t212*t31*t36*t37+1.2704999718189527d-2
     6         *t180*t215*t31*t33*t37+4.2349999060631754d-3*t127*t201*t3
     7         1*t33*t36
            t218 = t120**2
            t219 = t121**2
            t220 = -1.0587499765157939d-2*t107*t33*t36*t37*t55*t56-8.469
     1         999812126351d-3*t107*t33*t36*t37*t53*t54-6.35249985909476
     2         3d-3*t107*t33*t36*t37*t51*t52-4.2349999060631754d-3*t107*
     3         t33*t36*t37*t49*t50-2.1174999530315877d-3*t107*t33*t36*t3
     4         7*t47-2.1174999530315877d-3*t33*t36*t37*t38*t46-1.0587499
     5         765157939d-2*t33*t36*t37*t38*t44*t45-8.469999812126351d-3
     6         *t33*t36*t37*t38*t42*t43-6.352499859094763d-3*t33*t36*t37
     7         *t38*t40*t41-4.2349999060631754d-3*t30*t33*t36*t37*t38*t3
     8         9
            t221 = 1.0d+0*t220*t29*wght
            t222 = -4.2349999060631754d-3*t103*t33*t37*t97-2.11749995303
     1         15877d-3*t33*t36*t95*t96+6.352499859094763d-3*t100*t104*t
     2         36*t37
            t223 = 4.2349999060631754d-3*t103*t33*t37*t97+2.117499953031
     1         5877d-3*t33*t36*t95*t96-6.352499859094763d-3*t100*t104*t3
     2         6*t37
            t224 = 1.0d+0*t1*t220*t95*wght+1.0d+0*t1*t29*(2.117499953031
     1         5877d-2*t106*t188*t33*t36*t37*t55*t56+5.0d+0*t107*t223*t5
     2         5*t56-4.2349999060631754d-2*t106*t187*t33*t36*t37*t53*t56
     3         +1.6939999624252702d-2*t106*t188*t33*t36*t37*t53*t54+4.0d
     4         +0*t107*t223*t53*t54-2.5409999436379055d-2*t106*t187*t33*
     5         t36*t37*t51*t54+1.2704999718189527d-2*t106*t188*t33*t36*t
     6         37*t51*t52+3.0d+0*t107*t223*t51*t52-1.2704999718189527d-2
     7         *t106*t187*t33*t36*t37*t49*t52+8.469999812126351d-3*t106*
     8         t188*t33*t36*t37*t49*t50+2.0d+0*t107*t223*t49*t50-4.23499
     9         99060631754d-3*t106*t187*t33*t36*t37*t50+4.23499990606317
     :         54d-3*t106*t188*t33*t36*t37*t47+1.0d+0*t107*t223*t47-2.11
     ;         74999530315877d-3*t105*t33*t36*t37*t38*t46-t222*t38*t46-1
     <         .0587499765157939d-2*t105*t33*t36*t37*t38*t44*t45-5.0d+0*
     =         t222*t38*t44*t45+4.2349999060631754d-2*t105*t185*t33*t36*
     >         t37*t42*t45-8.469999812126351d-3*t105*t33*t36*t37*t38*t42
     ?         *t43-4.0d+0*t222*t38*t42*t43+2.5409999436379055d-2*t105*t
     @         185*t33*t36*t37*t40*t43-6.352499859094763d-3*t105*t33*t36
     1         *t37*t38*t40*t41-3.0d+0*t222*t38*t40*t41+1.27049997181895
     2         27d-2*t105*t185*t33*t36*t37*t39*t41-4.2349999060631754d-3
     3         *t105*t30*t33*t36*t37*t38*t39-2.0d+0*t222*t30*t38*t39+4.2
     4         349999060631754d-3*t105*t185*t30*t33*t36*t37)*wght+t221
            t225 = -2.1174999530315877d-2*t107*t33*t36*t37*t55*t56-1.693
     1         9999624252702d-2*t107*t33*t36*t37*t53*t54-1.2704999718189
     2         527d-2*t107*t33*t36*t37*t51*t52-8.469999812126351d-3*t107
     3         *t33*t36*t37*t49*t50-4.2349999060631754d-3*t107*t33*t36*t
     4         37*t47-4.2349999060631754d-3*t33*t36*t37*t38*t46-2.117499
     5         9530315877d-2*t33*t36*t37*t38*t44*t45-1.6939999624252702d
     6         -2*t33*t36*t37*t38*t42*t43-1.2704999718189527d-2*t33*t36*
     7         t37*t38*t40*t41-8.469999812126351d-3*t30*t33*t36*t37*t38*
     8         t39
            t226 = 1.0d+0*t225*t29*wght
            t227 = -8.469999812126351d-3*t103*t33*t37*t97-4.234999906063
     1         1754d-3*t33*t36*t95*t96+1.2704999718189527d-2*t100*t104*t
     2         36*t37
            t228 = 8.469999812126351d-3*t103*t33*t37*t97+4.2349999060631
     1         754d-3*t33*t36*t95*t96-1.2704999718189527d-2*t100*t104*t3
     2         6*t37
            t229 = -4.2349999060631754d-3*t119*t33*t37*t97-2.11749995303
     1         15877d-3*t117*t33*t36*t96+6.352499859094763d-3*t104*t118*
     2         t36*t37
            t230 = 4.2349999060631754d-3*t119*t33*t37*t97+2.117499953031
     1         5877d-3*t117*t33*t36*t96-6.352499859094763d-3*t104*t118*t
     2         36*t37
            t231 = 1.0d+0*t1*t29*(2.1174999530315877d-2*t121*t188*t33*t3
     1         6*t37*t55*t56+5.0d+0*t107*t230*t55*t56-4.2349999060631754
     2         d-2*t121*t187*t33*t36*t37*t53*t56+1.6939999624252702d-2*t
     3         121*t188*t33*t36*t37*t53*t54+4.0d+0*t107*t230*t53*t54-2.5
     4         409999436379055d-2*t121*t187*t33*t36*t37*t51*t54+1.270499
     5         9718189527d-2*t121*t188*t33*t36*t37*t51*t52+3.0d+0*t107*t
     6         230*t51*t52-1.2704999718189527d-2*t121*t187*t33*t36*t37*t
     7         49*t52+8.469999812126351d-3*t121*t188*t33*t36*t37*t49*t50
     8         +2.0d+0*t107*t230*t49*t50-4.2349999060631754d-3*t121*t187
     9         *t33*t36*t37*t50+4.2349999060631754d-3*t121*t188*t33*t36*
     :         t37*t47+1.0d+0*t107*t230*t47-2.1174999530315877d-3*t120*t
     ;         33*t36*t37*t38*t46-t229*t38*t46-1.0587499765157939d-2*t12
     <         0*t33*t36*t37*t38*t44*t45-5.0d+0*t229*t38*t44*t45+4.23499
     =         99060631754d-2*t120*t185*t33*t36*t37*t42*t45-8.4699998121
     >         26351d-3*t120*t33*t36*t37*t38*t42*t43-4.0d+0*t229*t38*t42
     ?         *t43+2.5409999436379055d-2*t120*t185*t33*t36*t37*t40*t43-
     @         6.352499859094763d-3*t120*t33*t36*t37*t38*t40*t41-3.0d+0*
     1         t229*t38*t40*t41+1.2704999718189527d-2*t120*t185*t33*t36*
     2         t37*t39*t41-4.2349999060631754d-3*t120*t30*t33*t36*t37*t3
     3         8*t39-2.0d+0*t229*t30*t38*t39+4.2349999060631754d-3*t120*
     4         t185*t30*t33*t36*t37)*wght+1.0d+0*t1*t117*t220*wght+t221
            t232 = -8.469999812126351d-3*t119*t33*t37*t97-4.234999906063
     1         1754d-3*t117*t33*t36*t96+1.2704999718189527d-2*t104*t118*
     2         t36*t37
            t233 = 8.469999812126351d-3*t119*t33*t37*t97+4.2349999060631
     1         754d-3*t117*t33*t36*t96-1.2704999718189527d-2*t104*t118*t
     2         36*t37
            t234 = t32**6
            t235 = 1.0d+0*t1*t29*(4.2349999060631754d-3*t123*t180*t188*t
     1         33*t96+t107*t36*t37*(8.967612102177552d-5*t107*t234*t36*t
     2         37*t53*t56+5.380567261306531d-5*t107*t234*t36*t37*t51*t54
     3         +2.6902836306532657d-5*t107*t234*t36*t37*t49*t52+8.967612
     4         102177553d-6*t107*t234*t36*t37*t50)+t36*t37*(-4.483806051
     5         088777d-6*t234*t36*t37*t38*t46-2.241903025544388d-5*t234*
     6         t36*t37*t38*t44*t45+8.967612102177552d-5*t185*t234*t36*t3
     7         7*t42*t45-1.7935224204355107d-5*t234*t36*t37*t38*t42*t43+
     8         5.380567261306531d-5*t185*t234*t36*t37*t40*t43-1.34514181
     9         53266329d-5*t234*t36*t37*t38*t40*t41+2.6902836306532657d-
     :         5*t185*t234*t36*t37*t39*t41-8.967612102177553d-6*t234*t30
     ;         *t36*t37*t38*t39+8.967612102177553d-6*t185*t234*t30*t36*t
     <         37))*wght
            t236 = t36*t37*(-8.967612102177553d-6*t234*t36*t37*t38*t46-4
     1         .483806051088776d-5*t234*t36*t37*t38*t44*t45+1.7935224204
     2         355105d-4*t185*t234*t36*t37*t42*t45-3.5870448408710215d-5
     3         *t234*t36*t37*t38*t42*t43+1.0761134522613064d-4*t185*t234
     4         *t36*t37*t40*t43-2.6902836306532657d-5*t234*t36*t37*t38*t
     5         40*t41+5.380567261306531d-5*t185*t234*t36*t37*t39*t41-1.7
     6         935224204355107d-5*t234*t30*t36*t37*t38*t39+1.79352242043
     7         55107d-5*t185*t234*t30*t36*t37)
            t237 = t107*t36*t37*(1.7935224204355105d-4*t107*t234*t36*t37
     1         *t53*t56+1.0761134522613064d-4*t107*t234*t36*t37*t51*t54+
     2         5.380567261306531d-5*t107*t234*t36*t37*t49*t52+1.79352242
     3         04355107d-5*t107*t234*t36*t37*t50)
            fnc(iq) = 1.0d+0*t1*t29*t57*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t57*t95*wght+1.0d+0*t1*t108*t29*w
     1         ght+t109+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t117*t57*wght+1.0d+0*t1*t122*t29*
     1         wght+t109+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t124+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 1.0d+0*t1*t29*(t36*t37*(-4.234999906063175
     1         4d-3*t33*t38*t46-2.1174999530315877d-2*t33*t38*t44*t45-1.
     2         6939999624252702d-2*t33*t38*t42*t43-1.2704999718189527d-2
     3         *t33*t38*t40*t41-8.469999812126351d-3*t30*t33*t38*t39)+t1
     4         07*t125*t36*t37)*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t124+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t57*t95*wght+2.0d+0*t1*t108*t95*
     1         wght+1.0d+0*t1*t173*t57*wght+1.0d+0*t1*t29*(-1.0d+1*t186*
     2         t188*t55*t56+5.0d+0*t107*t182*t55*t56+2.0d+1*t186*t187*t5
     3         3*t56-8.0d+0*t186*t188*t53*t54+4.0d+0*t107*t182*t53*t54+1
     4         .2d+1*t186*t187*t51*t54-6.0d+0*t186*t188*t51*t52+3.0d+0*t
     5         107*t182*t51*t52+6.0d+0*t186*t187*t49*t52-4.0d+0*t186*t18
     6         8*t49*t50+2.0d+0*t107*t182*t49*t50+2.0d+0*t186*t187*t50-2
     7         .0d+0*t186*t188*t47+1.0d+0*t107*t182*t47-t184*t38*t46-t18
     8         3*t38*t46-5.0d+0*t184*t38*t44*t45-5.0d+0*t183*t38*t44*t45
     9         +2.0d+1*t184*t185*t42*t45-4.0d+0*t184*t38*t42*t43-4.0d+0*
     :         t183*t38*t42*t43+1.2d+1*t184*t185*t40*t43-3.0d+0*t184*t38
     ;         *t40*t41-3.0d+0*t183*t38*t40*t41+6.0d+0*t184*t185*t39*t41
     <         -2.0d+0*t184*t30*t38*t39-2.0d+0*t183*t30*t38*t39+2.0d+0*t
     =         184*t185*t30)*wght+2.0d+0*t108*t29*wght+Amat2(iq,D2_RA_RA
     >         )
            Amat2(iq,D2_RA_RB) = 1.0d+0*t57*t95*wght+1.0d+0*t1*t122*t95*
     1         wght+1.0d+0*t1*t196*t57*wght+1.0d+0*t117*t57*wght+1.0d+0*
     2         t1*t29*(5.0d+0*t107*t200*t55*t56-1.0d+1*t106*t121*t188*t5
     3         5*t56+2.0d+1*t106*t121*t187*t53*t56+4.0d+0*t107*t200*t53*
     4         t54-8.0d+0*t106*t121*t188*t53*t54+1.2d+1*t106*t121*t187*t
     5         51*t54+3.0d+0*t107*t200*t51*t52-6.0d+0*t106*t121*t188*t51
     6         *t52+6.0d+0*t106*t121*t187*t49*t52+2.0d+0*t107*t200*t49*t
     7         50-4.0d+0*t106*t121*t188*t49*t50+2.0d+0*t106*t121*t187*t5
     8         0+1.0d+0*t107*t200*t47-2.0d+0*t106*t121*t188*t47-t199*t38
     9         *t46-t105*t120*t38*t46-5.0d+0*t199*t38*t44*t45-5.0d+0*t10
     :         5*t120*t38*t44*t45+2.0d+1*t105*t120*t185*t42*t45-4.0d+0*t
     ;         199*t38*t42*t43-4.0d+0*t105*t120*t38*t42*t43+1.2d+1*t105*
     <         t120*t185*t40*t43-3.0d+0*t199*t38*t40*t41-3.0d+0*t105*t12
     =         0*t38*t40*t41+6.0d+0*t105*t120*t185*t39*t41-2.0d+0*t199*t
     >         30*t38*t39-2.0d+0*t105*t120*t30*t38*t39+2.0d+0*t105*t120*
     ?         t185*t30)*wght+1.0d+0*t122*t29*wght+1.0d+0*t108*t29*wght+
     @         1.0d+0*t1*t108*t117*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t211*t57*wght+2.0d+0*t117*t57
     1         *wght+1.0d+0*t1*t29*(-1.0d+1*t188*t219*t55*t56+5.0d+0*t10
     2         7*t216*t55*t56+2.0d+1*t187*t219*t53*t56-8.0d+0*t188*t219*
     3         t53*t54+4.0d+0*t107*t216*t53*t54+1.2d+1*t187*t219*t51*t54
     4         -6.0d+0*t188*t219*t51*t52+3.0d+0*t107*t216*t51*t52+6.0d+0
     5         *t187*t219*t49*t52-4.0d+0*t188*t219*t49*t50+2.0d+0*t107*t
     6         216*t49*t50+2.0d+0*t187*t219*t50-2.0d+0*t188*t219*t47+1.0
     7         d+0*t107*t216*t47-t218*t38*t46-t217*t38*t46-5.0d+0*t218*t
     8         38*t44*t45-5.0d+0*t217*t38*t44*t45+2.0d+1*t185*t218*t42*t
     9         45-4.0d+0*t218*t38*t42*t43-4.0d+0*t217*t38*t42*t43+1.2d+1
     :         *t185*t218*t40*t43-3.0d+0*t218*t38*t40*t41-3.0d+0*t217*t3
     ;         8*t40*t41+6.0d+0*t185*t218*t39*t41-2.0d+0*t218*t30*t38*t3
     <         9-2.0d+0*t217*t30*t38*t39+2.0d+0*t185*t218*t30)*wght+2.0d
     =         +0*t122*t29*wght+2.0d+0*t1*t117*t122*wght+Amat2(iq,D2_RB_
     >         RB)
            Cmat2(iq,D2_RA_GAA) = t224+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*t1*t225*t95*wght+1.0d+0*t1*t29*
     1         (4.2349999060631754d-2*t106*t188*t33*t36*t37*t55*t56+5.0d
     2         +0*t107*t228*t55*t56-8.469999812126351d-2*t106*t187*t33*t
     3         36*t37*t53*t56+3.3879999248505405d-2*t106*t188*t33*t36*t3
     4         7*t53*t54+4.0d+0*t107*t228*t53*t54-5.081999887275811d-2*t
     5         106*t187*t33*t36*t37*t51*t54+2.5409999436379055d-2*t106*t
     6         188*t33*t36*t37*t51*t52+3.0d+0*t107*t228*t51*t52-2.540999
     7         9436379055d-2*t106*t187*t33*t36*t37*t49*t52+1.69399996242
     8         52702d-2*t106*t188*t33*t36*t37*t49*t50+2.0d+0*t107*t228*t
     9         49*t50-8.469999812126351d-3*t106*t187*t33*t36*t37*t50+8.4
     :         69999812126351d-3*t106*t188*t33*t36*t37*t47+1.0d+0*t107*t
     ;         228*t47-4.2349999060631754d-3*t105*t33*t36*t37*t38*t46-t2
     <         27*t38*t46-2.1174999530315877d-2*t105*t33*t36*t37*t38*t44
     =         *t45-5.0d+0*t227*t38*t44*t45+8.469999812126351d-2*t105*t1
     >         85*t33*t36*t37*t42*t45-1.6939999624252702d-2*t105*t33*t36
     ?         *t37*t38*t42*t43-4.0d+0*t227*t38*t42*t43+5.08199988727581
     @         1d-2*t105*t185*t33*t36*t37*t40*t43-1.2704999718189527d-2*
     1         t105*t33*t36*t37*t38*t40*t41-3.0d+0*t227*t38*t40*t41+2.54
     2         09999436379055d-2*t105*t185*t33*t36*t37*t39*t41-8.4699998
     3         12126351d-3*t105*t30*t33*t36*t37*t38*t39-2.0d+0*t227*t30*
     4         t38*t39+8.469999812126351d-3*t105*t185*t30*t33*t36*t37)*w
     5         ght+t226+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t224+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t231+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = 1.0d+0*t1*t29*(4.2349999060631754d-2*t
     1         121*t188*t33*t36*t37*t55*t56+5.0d+0*t107*t233*t55*t56-8.4
     2         69999812126351d-2*t121*t187*t33*t36*t37*t53*t56+3.3879999
     3         248505405d-2*t121*t188*t33*t36*t37*t53*t54+4.0d+0*t107*t2
     4         33*t53*t54-5.081999887275811d-2*t121*t187*t33*t36*t37*t51
     5         *t54+2.5409999436379055d-2*t121*t188*t33*t36*t37*t51*t52+
     6         3.0d+0*t107*t233*t51*t52-2.5409999436379055d-2*t121*t187*
     7         t33*t36*t37*t49*t52+1.6939999624252702d-2*t121*t188*t33*t
     8         36*t37*t49*t50+2.0d+0*t107*t233*t49*t50-8.469999812126351
     9         d-3*t121*t187*t33*t36*t37*t50+8.469999812126351d-3*t121*t
     :         188*t33*t36*t37*t47+1.0d+0*t107*t233*t47-4.23499990606317
     ;         54d-3*t120*t33*t36*t37*t38*t46-t232*t38*t46-2.11749995303
     <         15877d-2*t120*t33*t36*t37*t38*t44*t45-5.0d+0*t232*t38*t44
     =         *t45+8.469999812126351d-2*t120*t185*t33*t36*t37*t42*t45-1
     >         .6939999624252702d-2*t120*t33*t36*t37*t38*t42*t43-4.0d+0*
     ?         t232*t38*t42*t43+5.081999887275811d-2*t120*t185*t33*t36*t
     @         37*t40*t43-1.2704999718189527d-2*t120*t33*t36*t37*t38*t40
     1         *t41-3.0d+0*t232*t38*t40*t41+2.5409999436379055d-2*t120*t
     2         185*t33*t36*t37*t39*t41-8.469999812126351d-3*t120*t30*t33
     3         *t36*t37*t38*t39-2.0d+0*t232*t30*t38*t39+8.46999981212635
     4         1d-3*t120*t185*t30*t33*t36*t37)*wght+1.0d+0*t1*t117*t225*
     5         wght+t226+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t231+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t235+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 1.0d+0*t1*t29*(8.469999812126351d-3*t
     1         123*t180*t188*t33*t96+t237+t236)*wght+Cmat2(iq,D2_GAA_GAB
     2         )
            Cmat2(iq,D2_GAA_GBB) = t235+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 1.0d+0*t1*t29*(8.469999812126351d-3*t
     1         125*t180*t188*t33*t96+t107*t36*t37*(3.587044840871021d-4*
     2         t107*t234*t36*t37*t53*t56+2.1522269045226128d-4*t107*t234
     3         *t36*t37*t51*t54+1.0761134522613064d-4*t107*t234*t36*t37*
     4         t49*t52+3.5870448408710215d-5*t107*t234*t36*t37*t50)+t36*
     5         t37*(-1.7935224204355107d-5*t234*t36*t37*t38*t46-8.967612
     6         102177552d-5*t234*t36*t37*t38*t44*t45+3.587044840871021d-
     7         4*t185*t234*t36*t37*t42*t45-7.174089681742043d-5*t234*t36
     8         *t37*t38*t42*t43+2.1522269045226128d-4*t185*t234*t36*t37*
     9         t40*t43-5.380567261306531d-5*t234*t36*t37*t38*t40*t41+1.0
     :         761134522613064d-4*t185*t234*t36*t37*t39*t41-3.5870448408
     ;         710215d-5*t234*t30*t36*t37*t38*t39+3.5870448408710215d-5*
     <         t185*t234*t30*t36*t37))*wght+Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = 1.0d+0*t1*t29*(4.2349999060631754d-3*
     1         t125*t180*t188*t33*t96+t237+t236)*wght+Cmat2(iq,D2_GAB_GB
     2         B)
            Cmat2(iq,D2_GBB_GBB) = t235+Cmat2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhoa**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammaaa*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammaaa*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/t11
            t40 = 1/rhoa**1.6666666666666669d+0
            t41 = 1/t2**3
            t42 = 1/rhoa**1.3333333333333333d+0
            t43 = 1/rhoa**1.1666666666666667d+0
            t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4.0
     1         02143174996817d-1*t41-1.264669550498372d-1*t40
            t45 = 1/t10**2
            t46 = 1/t7
            t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42-8
     1         .223668877838045d-1*t41-1.6039141941921276d-1*t40
            t48 = 1/t6**2
            t49 = 1.0d+0*t46*t47*t48*t9+1.3210398931339265d-3*t42*t8+1.1
     1         102230246251565d-16*t13*t39*t44*t45+3.0506411443514264d-1
     2         9*t12*t42
            t50 = rhoa**1.6666666666666674d-1
            t51 = 1/t17**3.0d+0
            t52 = 1/t14**2
            t53 = 3.361321652984956d-3*gammaaa*t18*t49*t52+7.84308385696
     1         4898d-3*gammaaa*t16*t50*t51
            t54 = 1/t19**2
            t55 = -3.361321652984956d-3*gammaaa*t18*t49*t52-7.8430838569
     1         64898d-3*gammaaa*t16*t50*t51
            t56 = -t29*t37*t55-5.0d+0*t29*t35*t36*t55-4.0d+0*t29*t33*t34
     1         *t55-3.0d+0*t29*t31*t32*t55-2.0d+0*t28*t29*t30*t55+5.0d+0
     2         *t26*t27*t53*t54+4.0d+0*t24*t25*t53*t54+3.0d+0*t22*t23*t5
     3         3*t54+2.0d+0*t20*t21*t53*t54+1.0d+0*t15*t53*t54
            t57 = -1.680660826492478d-2*t26*t27-1.3445286611939825d-2*t2
     1         4*t25-1.0083964958954868d-2*t22*t23-6.722643305969912d-3*
     2         t20*t21-3.361321652984956d-3*t15
            t58 = t44**2
            t59 = 1/rhoa**2.6666666666666666d+0
            t60 = 1/t2**5
            t61 = 1/rhoa**2.3333333333333334d+0
            t62 = 1/rhoa**2.1666666666666665d+0
            t63 = t47**2
            t64 = 3.216395899738507d+1*t63*t9/(t6**4*t7**2)-2.0d+0*t46*t
     1         63*t9/t6**3+1.0d+0*t46*t48*(2.1622951122684114d+0*t62+1.7
     2         087761055320938d+0*t61+1.2335503316757068d+0*t60+2.673190
     3         323653546d-1*t59)*t9-1.7613865241785684d-3*t61*t8+1.11022
     4         30246251565d-16*t13*t39*t45*(1.1632736958443765d+0*t62+9.
     5         89141964955861d-1*t61+6.003214762495226d-1*t60+2.10778258
     6         41639536d-1*t59)-4.0675215258019015d-19*t12*t61-2.2204460
     7         49250313d-16*t13*t39*t58/t10**3+1.7854583920998188d-15*t1
     8         3*t58/(t10**4*t11**2)-8.497974591333913d-2*t42*t46*t47*t4
     9         8-9.812069668265515d-18*t39*t42*t44*t45
            t65 = t53**2
            t66 = 1/t19**4
            t67 = 1/t19**3
            t68 = rhoa**3.333333333333335d-1
            t69 = 1/t17**4.0d+0
            t70 = 1/rhoa**8.333333333333333d-1
            t71 = t49**2
            t72 = 1/t14**3
            t73 = -6.722643305969912d-3*gammaaa*t18*t71*t72+1.3071806428
     1         274835d-3*gammaaa*t16*t51*t70-2.745079349937714d-2*gammaa
     2         a*t16*t68*t69+3.361321652984956d-3*gammaaa*t18*t52*t64-1.
     3         5686167713929794d-2*gammaaa*t49*t50*t51*t52
            t74 = 6.722643305969912d-3*gammaaa*t18*t71*t72-1.30718064282
     1         74835d-3*gammaaa*t16*t51*t70+2.745079349937714d-2*gammaaa
     2         *t16*t68*t69-3.361321652984956d-3*gammaaa*t18*t52*t64+1.5
     3         686167713929794d-2*gammaaa*t49*t50*t51*t52
            t75 = t55**2
            t76 = exp(6.722643305969912d-3*gammaaa*t16*t18)
            t77 = -1.680660826492478d-2*t16*t18*t26*t27*t54-1.3445286611
     1         939825d-2*t16*t18*t24*t25*t54-1.0083964958954868d-2*t16*t
     2         18*t22*t23*t54-6.722643305969912d-3*t16*t18*t20*t21*t54-3
     3         .361321652984956d-3*t15*t16*t18*t54-3.361321652984956d-3*
     4         t16*t18*t29*t37-1.680660826492478d-2*t16*t18*t29*t35*t36-
     5         1.3445286611939825d-2*t16*t18*t29*t33*t34-1.0083964958954
     6         868d-2*t16*t18*t29*t31*t32-6.722643305969912d-3*t16*t18*t
     7         28*t29*t30
            t78 = 3.361321652984956d-3*t18*t49*t52+7.843083856964898d-3*
     1         t16*t50*t51
            t79 = -3.361321652984956d-3*t18*t49*t52-7.843083856964898d-3
     1         *t16*t50*t51
            fnc(iq) = 1.0d+0*rhoa*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t14*t56*wght+1.0d+0*rhoa*t38*t4
     1         9*wght+1.0d+0*t14*t38*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*(t16*t18*t54*t57+t16*t18*(
     1         -3.361321652984956d-3*t29*t37-1.680660826492478d-2*t29*t3
     2         5*t36-1.3445286611939825d-2*t29*t33*t34-1.008396495895486
     3         8d-2*t29*t31*t32-6.722643305969912d-3*t28*t29*t30))*wght+
     4         Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t14*(2.0d+1*t33*t36*t75*t76
     1         +1.2d+1*t31*t34*t75*t76+6.0d+0*t30*t32*t75*t76+2.0d+0*t28
     2         *t75*t76-t29*t37*t75-5.0d+0*t29*t35*t36*t75-4.0d+0*t29*t3
     3         3*t34*t75-3.0d+0*t29*t31*t32*t75-2.0d+0*t28*t29*t30*t75-t
     4         29*t37*t74-5.0d+0*t29*t35*t36*t74-4.0d+0*t29*t33*t34*t74-
     5         3.0d+0*t29*t31*t32*t74-2.0d+0*t28*t29*t30*t74+5.0d+0*t26*
     6         t27*t54*t73+4.0d+0*t24*t25*t54*t73+3.0d+0*t22*t23*t54*t73
     7         +2.0d+0*t20*t21*t54*t73+1.0d+0*t15*t54*t73-1.0d+1*t26*t27
     8         *t65*t67-8.0d+0*t24*t25*t65*t67-6.0d+0*t22*t23*t65*t67-4.
     9         0d+0*t20*t21*t65*t67-2.0d+0*t15*t65*t67+2.0d+1*t24*t27*t6
     :         5*t66+1.2d+1*t22*t25*t65*t66+6.0d+0*t20*t23*t65*t66+2.0d+
     ;         0*t21*t65*t66)*wght+1.0d+0*rhoa*t38*t64*wght+2.0d+0*rhoa*
     <         t49*t56*wght+2.0d+0*t14*t56*wght+2.0d+0*t38*t49*wght+Amat
     =         2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t14*(-t29*t37*t79-5.0d+0*t
     1         29*t35*t36*t79-4.0d+0*t29*t33*t34*t79-3.0d+0*t29*t31*t32*
     2         t79-2.0d+0*t28*t29*t30*t79+5.0d+0*t26*t27*t54*t78+4.0d+0*
     3         t24*t25*t54*t78+3.0d+0*t22*t23*t54*t78+2.0d+0*t20*t21*t54
     4         *t78+1.0d+0*t15*t54*t78+6.722643305969912d-2*t16*t18*t33*
     5         t36*t55*t76+4.033585983581947d-2*t16*t18*t31*t34*t55*t76+
     6         2.0167929917909735d-2*t16*t18*t30*t32*t55*t76+6.722643305
     7         969912d-3*t16*t18*t28*t55*t76+3.361321652984956d-2*t16*t1
     8         8*t26*t27*t53*t67+2.689057322387965d-2*t16*t18*t24*t25*t5
     9         3*t67+2.0167929917909735d-2*t16*t18*t22*t23*t53*t67+1.344
     :         5286611939825d-2*t16*t18*t20*t21*t53*t67+6.72264330596991
     ;         2d-3*t15*t16*t18*t53*t67-6.722643305969912d-2*t16*t18*t24
     <         *t27*t53*t66-4.033585983581947d-2*t16*t18*t22*t25*t53*t66
     =         -2.0167929917909735d-2*t16*t18*t20*t23*t53*t66-6.72264330
     >         5969912d-3*t16*t18*t21*t53*t66-3.361321652984956d-3*t16*t
     ?         18*t29*t37*t55-1.680660826492478d-2*t16*t18*t29*t35*t36*t
     @         55-1.3445286611939825d-2*t16*t18*t29*t33*t34*t55-1.008396
     1         4958954868d-2*t16*t18*t29*t31*t32*t55-6.722643305969912d-
     2         3*t16*t18*t28*t29*t30*t55)*wght+1.0d+0*rhoa*t49*t77*wght+
     3         1.0d+0*t14*t77*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t14*(t16*t18*(2.259696650
     1         9651034d-4*t16*t18*t33*t36*t76+1.355817990579062d-4*t16*t
     2         18*t31*t34*t76+6.77908995289531d-5*t16*t18*t30*t32*t76+2.
     3         2596966509651034d-5*t16*t18*t28*t76-1.1298483254825517d-5
     4         *t16*t18*t29*t37-5.649241627412759d-5*t16*t18*t29*t35*t36
     5         -4.519393301930207d-5*t16*t18*t29*t33*t34-3.3895449764476
     6         55d-5*t16*t18*t29*t31*t32-2.2596966509651034d-5*t16*t18*t
     7         28*t29*t30)+6.722643305969912d-3*t52*t57*t67*t69+t16*t18*
     8         t54*(2.2596966509651034d-4*t16*t18*t24*t27*t54+1.35581799
     9         0579062d-4*t16*t18*t22*t25*t54+6.77908995289531d-5*t16*t1
     :         8*t20*t23*t54+2.2596966509651034d-5*t16*t18*t21*t54))*wgh
     ;         t+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**6.666666666666666d-1
            t2 = rhob**5.0d-1
            t3 = 1/t2
            t4 = 1/rhob**3.333333333333333d-1
            t5 = 1/rhob**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhob**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammabb*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammabb*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/t11
            t40 = 1/rhob**1.6666666666666669d+0
            t41 = 1/t2**3
            t42 = 1/rhob**1.3333333333333333d+0
            t43 = 1/rhob**1.1666666666666667d+0
            t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4.0
     1         02143174996817d-1*t41-1.264669550498372d-1*t40
            t45 = 1/t10**2
            t46 = 1/t7
            t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42-8
     1         .223668877838045d-1*t41-1.6039141941921276d-1*t40
            t48 = 1/t6**2
            t49 = 1.0d+0*t46*t47*t48*t9+1.3210398931339265d-3*t42*t8+1.1
     1         102230246251565d-16*t13*t39*t44*t45+3.0506411443514264d-1
     2         9*t12*t42
            t50 = rhob**1.6666666666666674d-1
            t51 = 1/t17**3.0d+0
            t52 = 1/t14**2
            t53 = 3.361321652984956d-3*gammabb*t18*t49*t52+7.84308385696
     1         4898d-3*gammabb*t16*t50*t51
            t54 = 1/t19**2
            t55 = -3.361321652984956d-3*gammabb*t18*t49*t52-7.8430838569
     1         64898d-3*gammabb*t16*t50*t51
            t56 = -t29*t37*t55-5.0d+0*t29*t35*t36*t55-4.0d+0*t29*t33*t34
     1         *t55-3.0d+0*t29*t31*t32*t55-2.0d+0*t28*t29*t30*t55+5.0d+0
     2         *t26*t27*t53*t54+4.0d+0*t24*t25*t53*t54+3.0d+0*t22*t23*t5
     3         3*t54+2.0d+0*t20*t21*t53*t54+1.0d+0*t15*t53*t54
            t57 = -1.680660826492478d-2*t26*t27-1.3445286611939825d-2*t2
     1         4*t25-1.0083964958954868d-2*t22*t23-6.722643305969912d-3*
     2         t20*t21-3.361321652984956d-3*t15
            t58 = t44**2
            t59 = 1/rhob**2.6666666666666666d+0
            t60 = 1/t2**5
            t61 = 1/rhob**2.3333333333333334d+0
            t62 = 1/rhob**2.1666666666666665d+0
            t63 = t47**2
            t64 = 3.216395899738507d+1*t63*t9/(t6**4*t7**2)-2.0d+0*t46*t
     1         63*t9/t6**3+1.0d+0*t46*t48*(2.1622951122684114d+0*t62+1.7
     2         087761055320938d+0*t61+1.2335503316757068d+0*t60+2.673190
     3         323653546d-1*t59)*t9-1.7613865241785684d-3*t61*t8+1.11022
     4         30246251565d-16*t13*t39*t45*(1.1632736958443765d+0*t62+9.
     5         89141964955861d-1*t61+6.003214762495226d-1*t60+2.10778258
     6         41639536d-1*t59)-4.0675215258019015d-19*t12*t61-2.2204460
     7         49250313d-16*t13*t39*t58/t10**3+1.7854583920998188d-15*t1
     8         3*t58/(t10**4*t11**2)-8.497974591333913d-2*t42*t46*t47*t4
     9         8-9.812069668265515d-18*t39*t42*t44*t45
            t65 = t53**2
            t66 = 1/t19**4
            t67 = 1/t19**3
            t68 = rhob**3.333333333333335d-1
            t69 = 1/t17**4.0d+0
            t70 = 1/rhob**8.333333333333333d-1
            t71 = t49**2
            t72 = 1/t14**3
            t73 = -6.722643305969912d-3*gammabb*t18*t71*t72+1.3071806428
     1         274835d-3*gammabb*t16*t51*t70-2.745079349937714d-2*gammab
     2         b*t16*t68*t69+3.361321652984956d-3*gammabb*t18*t52*t64-1.
     3         5686167713929794d-2*gammabb*t49*t50*t51*t52
            t74 = 6.722643305969912d-3*gammabb*t18*t71*t72-1.30718064282
     1         74835d-3*gammabb*t16*t51*t70+2.745079349937714d-2*gammabb
     2         *t16*t68*t69-3.361321652984956d-3*gammabb*t18*t52*t64+1.5
     3         686167713929794d-2*gammabb*t49*t50*t51*t52
            t75 = t55**2
            t76 = exp(6.722643305969912d-3*gammabb*t16*t18)
            t77 = -1.680660826492478d-2*t16*t18*t26*t27*t54-1.3445286611
     1         939825d-2*t16*t18*t24*t25*t54-1.0083964958954868d-2*t16*t
     2         18*t22*t23*t54-6.722643305969912d-3*t16*t18*t20*t21*t54-3
     3         .361321652984956d-3*t15*t16*t18*t54-3.361321652984956d-3*
     4         t16*t18*t29*t37-1.680660826492478d-2*t16*t18*t29*t35*t36-
     5         1.3445286611939825d-2*t16*t18*t29*t33*t34-1.0083964958954
     6         868d-2*t16*t18*t29*t31*t32-6.722643305969912d-3*t16*t18*t
     7         28*t29*t30
            t78 = 3.361321652984956d-3*t18*t49*t52+7.843083856964898d-3*
     1         t16*t50*t51
            t79 = -3.361321652984956d-3*t18*t49*t52-7.843083856964898d-3
     1         *t16*t50*t51
            fnc(iq) = 1.0d+0*rhob*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t14*t56*wght+1.0d+0*rhob*t38*t4
     1         9*wght+1.0d+0*t14*t38*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*(t16*t18*t54*t57+t16*t18*(
     1         -3.361321652984956d-3*t29*t37-1.680660826492478d-2*t29*t3
     2         5*t36-1.3445286611939825d-2*t29*t33*t34-1.008396495895486
     3         8d-2*t29*t31*t32-6.722643305969912d-3*t28*t29*t30))*wght+
     4         Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t14*(2.0d+1*t33*t36*t75*t76
     1         +1.2d+1*t31*t34*t75*t76+6.0d+0*t30*t32*t75*t76+2.0d+0*t28
     2         *t75*t76-t29*t37*t75-5.0d+0*t29*t35*t36*t75-4.0d+0*t29*t3
     3         3*t34*t75-3.0d+0*t29*t31*t32*t75-2.0d+0*t28*t29*t30*t75-t
     4         29*t37*t74-5.0d+0*t29*t35*t36*t74-4.0d+0*t29*t33*t34*t74-
     5         3.0d+0*t29*t31*t32*t74-2.0d+0*t28*t29*t30*t74+5.0d+0*t26*
     6         t27*t54*t73+4.0d+0*t24*t25*t54*t73+3.0d+0*t22*t23*t54*t73
     7         +2.0d+0*t20*t21*t54*t73+1.0d+0*t15*t54*t73-1.0d+1*t26*t27
     8         *t65*t67-8.0d+0*t24*t25*t65*t67-6.0d+0*t22*t23*t65*t67-4.
     9         0d+0*t20*t21*t65*t67-2.0d+0*t15*t65*t67+2.0d+1*t24*t27*t6
     :         5*t66+1.2d+1*t22*t25*t65*t66+6.0d+0*t20*t23*t65*t66+2.0d+
     ;         0*t21*t65*t66)*wght+1.0d+0*rhob*t38*t64*wght+2.0d+0*rhob*
     <         t49*t56*wght+2.0d+0*t14*t56*wght+2.0d+0*t38*t49*wght+Amat
     =         2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t14*(-t29*t37*t79-5.0d+0*t
     1         29*t35*t36*t79-4.0d+0*t29*t33*t34*t79-3.0d+0*t29*t31*t32*
     2         t79-2.0d+0*t28*t29*t30*t79+5.0d+0*t26*t27*t54*t78+4.0d+0*
     3         t24*t25*t54*t78+3.0d+0*t22*t23*t54*t78+2.0d+0*t20*t21*t54
     4         *t78+1.0d+0*t15*t54*t78+6.722643305969912d-2*t16*t18*t33*
     5         t36*t55*t76+4.033585983581947d-2*t16*t18*t31*t34*t55*t76+
     6         2.0167929917909735d-2*t16*t18*t30*t32*t55*t76+6.722643305
     7         969912d-3*t16*t18*t28*t55*t76+3.361321652984956d-2*t16*t1
     8         8*t26*t27*t53*t67+2.689057322387965d-2*t16*t18*t24*t25*t5
     9         3*t67+2.0167929917909735d-2*t16*t18*t22*t23*t53*t67+1.344
     :         5286611939825d-2*t16*t18*t20*t21*t53*t67+6.72264330596991
     ;         2d-3*t15*t16*t18*t53*t67-6.722643305969912d-2*t16*t18*t24
     <         *t27*t53*t66-4.033585983581947d-2*t16*t18*t22*t25*t53*t66
     =         -2.0167929917909735d-2*t16*t18*t20*t23*t53*t66-6.72264330
     >         5969912d-3*t16*t18*t21*t53*t66-3.361321652984956d-3*t16*t
     ?         18*t29*t37*t55-1.680660826492478d-2*t16*t18*t29*t35*t36*t
     @         55-1.3445286611939825d-2*t16*t18*t29*t33*t34*t55-1.008396
     1         4958954868d-2*t16*t18*t29*t31*t32*t55-6.722643305969912d-
     2         3*t16*t18*t28*t29*t30*t55)*wght+1.0d+0*rhob*t49*t77*wght+
     3         1.0d+0*t14*t77*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t14*(t16*t18*(2.259696650
     1         9651034d-4*t16*t18*t33*t36*t76+1.355817990579062d-4*t16*t
     2         18*t31*t34*t76+6.77908995289531d-5*t16*t18*t30*t32*t76+2.
     3         2596966509651034d-5*t16*t18*t28*t76-1.1298483254825517d-5
     4         *t16*t18*t29*t37-5.649241627412759d-5*t16*t18*t29*t35*t36
     5         -4.519393301930207d-5*t16*t18*t29*t33*t34-3.3895449764476
     6         55d-5*t16*t18*t29*t31*t32-2.2596966509651034d-5*t16*t18*t
     7         28*t29*t30)+6.722643305969912d-3*t52*t57*t67*t69+t16*t18*
     8         t54*(2.2596966509651034d-4*t16*t18*t24*t27*t54+1.35581799
     9         0579062d-4*t16*t18*t22*t25*t54+6.77908995289531d-5*t16*t1
     :         8*t20*t23*t54+2.2596966509651034d-5*t16*t18*t21*t54))*wgh
     ;         t+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_sogga functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_4} &=& {\it t_3}^4\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_1}^4}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_7} &=& 1.0-{\it t_3}\,{\it t_6}\\\\ 
C>   {\it t_8} &=& {\it t_3}\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& {\it t_8}^{{{4}\over{3}}}+{\it t_7}^{{{4}\over{3}}}
C>    -2.0\\\\ 
C>   {\it t_{10}} &=& -1.923661050931536\,{\it t_4}\,{\it t_5}\,{
C>    \it t_9}\\\\ 
C>   {\it t_{11}} &=& {{1}\over{{\it t_1}^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\sqrt{{\it t_1}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{{\it t_1}^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{14}} &=& -0.0598079686361971\,{\it t_4}\,{\it t_5}
C>    \,\left(0.1274696188700087\,{\it t_2}+1.0\right)\,{\it t_9}
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{13}}+3.844746237447211\,{\it t_2}+1.644733775567609
C>    \,{\it t_{12}}+0.2405871291288192\,{\it t_{11}}}}+1.0\right)
C>    +0.01975163132168077\,\left(0.06901399211255825\,{\it t_2}
C>    +1.0\right)\,\left({\it t_{10}}+1.923661050931536\,{
C>    \it t_9}\right)\,\log \left({{29.60881320326807}
C>    \over{8.15741470348764\,{\it t_{13}}+2.247591863577616\,{
C>    \it t_2}+0.4300972471276643\,{\it t_{12}}+0.1911512595127337
C>    \,{\it t_{11}}}}+1.0\right)-0.0621814\,
C>    \left(0.1325688999052018\,{\it t_2}+1.0\right)\,\left({
C>    \it t_{10}}+1.0\right)\,\log \left({{16.08197949869254}
C>    \over{5.98255043577108\,{\it t_{13}}+2.225569421150687\,{
C>    \it t_2}+0.8004286349993635\,{\it t_{12}}+0.1897004325747558
C>    \,{\it t_{11}}}}+1.0\right)\\\\ 
C>   {\it t_{15}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{16}} &=& {\it param}\left(7\right)\\\\ 
C>   {\it t_{17}} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_{18}} &=& {\it t_8}^{0.6666666666666667}+{
C>    \it t_7}^{0.6666666666666667}\\\\ 
C>   {\it t_{19}} &=& {\it t_{18}}^3\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({\it t_1}^{1.166666666666667}
C>    \,{\it t_{18}}\right)^{2.0}}}\\\\ 
C>   {\it t_{21}} &=& {{1}\over{{\it t_{14}}}}\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& 1.0-{{1.0}\over{1.0-0.002117499953031588\,{
C>    \it t_{19}}\,{\it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}}\\\\ 
C>   {\it t_{24}} &=& {\it param}\left(3\right)\\\\ 
C>   {\it t_{25}} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_{26}} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_{27}} &=& {\it param}\left(6\right)\\\\ 
C>   {\it t_{28}} &=& {\it param}\left(9\right)\\\\ 
C>   {\it t_{29}} &=& 1.0-e^{0.002117499953031588\,{\it t_{19}}\,{
C>    \it t_{20}}\,{\it t_{21}}\,{\it t_{22}}}\\\\ 
C>   {\it t_{30}} &=& {\it param}\left(10\right)\\\\ 
C>   {\it t_{31}} &=& {\it param}\left(11\right)\\\\ 
C>   {\it t_{32}} &=& {\it param}\left(12\right)\\\\ 
C>   {\it t_{33}} &=& {\it param}\left(8\right)\\\\ 
C>   {\it t_{34}} &=& {{1}\over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{\sqrt{\rho_s}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_s^{{{1}\over{6}}}}}\\\\ 
C>   {\it t_{38}} &=& -6.903522198342671 \times 10^{-18}
C>    \,\log \left({{16.08197949869254}\over{5.98255043577108\,{
C>    \it t_{37}}+2.225569421150687\,{\it t_{36}}+0.8004286349993635
C>    \,{\it t_{35}}+0.1897004325747558\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1325688999052018\,{\it t_{36}}+1.0\right)-0.0310907
C>    \,\log \left({{32.16395899738507}\over{11.12037486309469\,{
C>    \it t_{37}}+3.844746237447211\,{\it t_{36}}+1.644733775567609
C>    \,{\it t_{35}}+0.2405871291288192\,{\it t_{34}}}}+1.0\right)
C>    \,\left(0.1274696188700087\,{\it t_{36}}+1.0\right)\\\\ 
C>   {\it t_{39}} &=& {{1}\over{{\it t_{38}}}}\\\\ 
C>   {\it t_{40}} &=& {{1}\over{
C>    \left(\rho_s^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{41}} &=& 1.0-{{1.0}\over{1.0-0.003361321652984956\,{
C>    \it t_{39}}\,{\it t_{40}}\,\sigma_{ss}}}\\\\ 
C>   {\it t_{42}} &=& 1.0-e^{0.003361321652984956\,{\it t_{39}}\,{
C>    \it t_{40}}\,\sigma_{ss}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{14}}\,\left({\it t_{33}}\,{
C>    \it t_{29}}+{\it t_{32}}\,{\it t_{29}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{29}}^{4.0}+{\it t_{30}}\,{\it t_{29}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{29}}^{2.0}+{\it t_{27}}\,{\it t_{23}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{23}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{23}}^{3.0}+{\it t_{24}}\,{\it t_{23}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{23}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,{\it t_{38}}\,\rho_s\,\left({\it t_{33}}\,{\it t_{42}}
C>    +{\it t_{32}}\,{\it t_{42}}^{5.0}+{\it t_{31}}\,{
C>    \it t_{42}}^{4.0}+{\it t_{30}}\,{\it t_{42}}^{3.0}+{
C>    \it t_{28}}\,{\it t_{42}}^{2.0}+{\it t_{27}}\,{\it t_{41}}^{5.0}
C>    +{\it t_{26}}\,{\it t_{41}}^{4.0}+{\it t_{25}}\,{
C>    \it t_{41}}^{3.0}+{\it t_{24}}\,{\it t_{41}}^{2.0}+{
C>    \it t_{17}}\,{\it t_{41}}+{\it t_{16}}+{\it t_{15}}\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] R Peverati, Y Zhao, DG Truhlar, J.Phys.Chem.Lett. 2
C>    , 1991 (2011)  , DOI: 
C> <a href="http://dx.doi.org/10.1021/jz200616w "> 
C> 10.1021/jz200616w </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_sogga_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = log(1.6081979498692536d+1/(5.329846514438383d+0*t5+1.76
     1         6435620181429d+0*t4+5.659885156639418d-1*t3+1.19503784087
     2         549d-1*t1)+1.0d+0)
            t7 = 1.0522000558389212d-1*t4+1.0d+0
            t8 = param(1)
            t9 = param(7)
            t10 = param(2)
            t11 = rhoa**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = 5.405670591181536d-2*gammaaa*t12/(t6*t7)
            t14 = 1.0d+0-1.0d+0/(t13+1.0d+0)
            t15 = param(3)
            t16 = param(4)
            t17 = param(5)
            t18 = param(6)
            t19 = param(9)
            t20 = 1.0d+0-exp(-t13)
            t21 = param(10)
            t22 = param(11)
            t23 = param(12)
            t24 = param(8)
            t25 = 6.299605249474366d-1
            t26 = 1.414213562373095d+0
            t27 = 1/t26
            t28 = 7.937005259840998d-1
            t29 = 8.908987181403393d-1
            t30 = 5.982550435771079d+0*t29*t5+2.2255694211506874d+0*t28*
     1         t4+8.004286349993635d-1*t27*t3+1.8970043257475583d-1*t1*t
     2         25
            t31 = 1.6081979498692536d+1/t30+1.0d+0
            t32 = log(t31)
            t33 = 1.3256889990520176d-1*t28*t4+1.0d+0
            t34 = 1/t32
            t35 = 1/t33
            t36 = 5.405670591181535d-2*gammaaa*t12*t34*t35
            t37 = t36+1.0d+0
            t38 = 1.0d+0-1.0d+0/t37
            t39 = t38**2.0d+0
            t40 = t38**3.0d+0
            t41 = t38**4.0d+0
            t42 = exp(-t36)
            t43 = 1.0d+0-t42
            t44 = t43**2.0d+0
            t45 = t43**3.0d+0
            t46 = t43**4.0d+0
            t47 = t9+t8+t22*t46+t21*t45+t19*t44+t23*t43**5.0d+0+t24*t43+
     1         t17*t41+t16*t40+t15*t39+t18*t38**5.0d+0+t10*t38
            t48 = 1/t31
            t49 = 3.149802624737183d-1
            t50 = 1/rhoa**1.6666666666666669d+0
            t51 = 1/t26**3
            t52 = 1/t2**3
            t53 = 3.968502629920499d-1
            t54 = 1/rhoa**1.3333333333333333d+0
            t55 = 4.4544935907016964d-1
            t56 = 1/rhoa**1.1666666666666667d+0
            t57 = -9.970917392951799d-1*t55*t56-7.418564737168958d-1*t53
     1         *t54-4.002143174996817d-1*t51*t52-1.264669550498372d-1*t4
     2         9*t50
            t58 = 1/t30**2
            t59 = 1.0d+0*t33*t48*t57*t58+2.747773264188437d-3*t32*t53*t5
     1         4
            t60 = rhoa**1.6666666666666674d-1
            t61 = 1/t11**3.0d+0
            t62 = 1/t32**2
            t63 = 1/t33**2
            t64 = 8.69338836240666d-1*gammaaa*t12*t59*t62*t63-6.30661568
     1         9711792d-2*gammaaa*t34*t35*t60*t61
            t65 = 1/t37**2
            t66 = 6.306615689711792d-2*gammaaa*t34*t35*t60*t61-8.6933883
     1         6240666d-1*gammaaa*t12*t59*t62*t63
            t67 = -5.0d+0*t23*t42*t46*t66-4.0d+0*t22*t42*t45*t66-3.0d+0*
     1         t21*t42*t44*t66-2.0d+0*t19*t42*t43*t66-t24*t42*t66+5.0d+0
     2         *t18*t41*t64*t65+4.0d+0*t17*t40*t64*t65+3.0d+0*t16*t39*t6
     3         4*t65+2.0d+0*t15*t38*t64*t65+1.0d+0*t10*t64*t65
            t68 = -8.469999812126351d-2*t18*t41-6.775999849701081d-2*t17
     1         *t40-5.081999887275811d-2*t16*t39-3.3879999248505405d-2*t
     2         15*t38-1.6939999624252702d-2*t10
            t69 = -1.6939999624252702d-1*t18*t41-1.3551999699402162d-1*t
     1         17*t40-1.0163999774551621d-1*t16*t39-6.775999849701081d-2
     2         *t15*t38-3.3879999248505405d-2*t10
            t70 = 2.0d+0*t47*t59*wght
            t71 = 1/t31**2
            t72 = t57**2
            t73 = 1/t30**4
            t74 = 1.6081979498692536d+1*t33*t71*t72*t73
            t75 = 1/t30**3
            t76 = -2.0d+0*t33*t48*t72*t75
            t77 = 1.9842513149602492d-1
            t78 = 1/rhoa**2.3333333333333334d+0
            t79 = 9.89141964955861d-1*t77*t78+6.003214762495226d-1/(t2**
     1         5*t26**5)+2.5908976111853255d-1/rhoa**2.1666666666666665d
     2         +0+3.319549557987472d-2/rhoa**2.6666666666666666d+0
            t80 = 1.0d+0*t33*t48*t58*t79
            t81 = -3.663697685584583d-3*t32*t77*t78
            t82 = 8.157414703487641d+0*t29*t5+2.247591863577616d+0*t28*t
     1         4+4.3009724712766434d-1*t27*t3+1.9115125951273373d-1*t1*t
     2         25
            t83 = 2.9608813203268075d+1/t82+1.0d+0
            t84 = log(t83)
            t85 = 6.901399211255825d-2*t28*t4+1.0d+0
            t86 = 1/rhoa**2
            t87 = -8.837926660346784d-2*t48*t53*t54*t57*t58
            t88 = t87+8.443431970194815d-3*t84*t85*t86+t81+t80+t76+t74
            t89 = -1.243628d-1*t32*t33*t67*wght
            t90 = 4.0d+0*rhoa*t59*t67*wght
            t91 = rhoa**3.333333333333335d-1
            t92 = 1/t11**4.0d+0
            t93 = 1/rhoa**8.333333333333333d-1
            t94 = -2.0284572845615542d+0*gammaaa*t59*t60*t61*t62*t63
            t95 = 1/t32**3
            t96 = t59**2
            t97 = 1/t33**3
            t98 = 2.7961378683679233d+1*gammaaa*t12*t95*t96*t97
            t99 = t98+t94+7.507875821085456d-4*gammaaa*t34*t35*t61*t93+1
     1         .1036577456995636d-1*gammaaa*t34*t35*t91*t92+8.6933883624
     2         0666d-1*gammaaa*t12*t62*t63*t88-9.009450985302561d-3*gamm
     3         aaa*t12*t34*t35*t86
            t100 = t64**2
            t101 = 1/t37**4
            t102 = 2.0d+0*t100*t101*t15
            t103 = 1/t37**3
            t104 = -2.0d+0*t10*t100*t103
            t105 = 6.0d+0*t100*t101*t16*t38
            t106 = -4.0d+0*t100*t103*t15*t38
            t107 = 1.2d+1*t100*t101*t17*t39
            t108 = -6.0d+0*t100*t103*t16*t39
            t109 = 2.0d+1*t100*t101*t18*t40
            t110 = -8.0d+0*t100*t103*t17*t40
            t111 = -1.0d+1*t100*t103*t18*t41
            t112 = t66**2
            t113 = exp(-1.0811341182363071d-1*gammaaa*t12*t34*t35)
            t114 = 2.0d+0*t112*t113*t19
            t115 = 1.2d+1*t112*t113*t22*t44
            t116 = 2.0d+1*t112*t113*t23*t45
            t117 = 6.0d+0*t112*t113*t21*t43
            t118 = 2.0284572845615542d+0*gammaaa*t59*t60*t61*t62*t63
            t119 = -2.7961378683679233d+1*gammaaa*t12*t95*t96*t97
            t120 = -7.507875821085456d-4*gammaaa*t34*t35*t61*t93-1.10365
     1         77456995636d-1*gammaaa*t34*t35*t91*t92-8.69338836240666d-
     2         1*gammaaa*t12*t62*t63*t88+9.009450985302561d-3*gammaaa*t1
     3         2*t34*t35*t86+t119+t118
            t121 = -t112*t24*t42
            t122 = -3.0d+0*t112*t21*t42*t44
            t123 = -4.0d+0*t112*t22*t42*t45
            t124 = -5.0d+0*t112*t23*t42*t46
            t125 = -2.0d+0*t112*t19*t42*t43
            t126 = 5.0d+0*t18*t41*t65*t99+4.0d+0*t17*t40*t65*t99+3.0d+0*
     1         t16*t39*t65*t99+2.0d+0*t15*t38*t65*t99+1.0d+0*t10*t65*t99
     2         -5.0d+0*t120*t23*t42*t46-4.0d+0*t120*t22*t42*t45-3.0d+0*t
     3         120*t21*t42*t44-2.0d+0*t120*t19*t42*t43-t120*t24*t42+t125
     4         +t124+t123+t122+t121+t117+t116+t115+t114+t111+t110+t109+t
     5         108+t107+t106+t105+t104+t102
            t127 = t87-8.443431970194815d-3*t84*t85*t86+t81+t80+t76+t74
            t128 = t98+t94-1.1261813731628201d-2*gammaaa*t34*t35*t61*t93
     1         +1.1036577456995637d-1*gammaaa*t34*t35*t91*t92+9.00945098
     2         5302558d-3*gammaaa*t12*t34*t35*t86+8.69338836240666d-1*ga
     3         mmaaa*t12*t127*t62*t63
            t129 = 1.1261813731628201d-2*gammaaa*t34*t35*t61*t93-1.10365
     1         77456995637d-1*gammaaa*t34*t35*t91*t92-9.009450985302558d
     2         -3*gammaaa*t12*t34*t35*t86-8.69338836240666d-1*gammaaa*t1
     3         2*t127*t62*t63+t119+t118
            t130 = 5.0d+0*t128*t18*t41*t65+4.0d+0*t128*t17*t40*t65+3.0d+
     1         0*t128*t16*t39*t65+2.0d+0*t128*t15*t38*t65+1.0d+0*t10*t12
     2         8*t65-5.0d+0*t129*t23*t42*t46-4.0d+0*t129*t22*t42*t45-3.0
     3         d+0*t129*t21*t42*t44-2.0d+0*t129*t19*t42*t43-t129*t24*t42
     4         +t125+t124+t123+t122+t121+t117+t116+t115+t114+t111+t110+t
     5         109+t108+t107+t106+t105+t104+t102
            t131 = 6.75708823897692d-2*t12*t18*t34*t35*t41*t65+5.4056705
     1         91181535d-2*t12*t17*t34*t35*t40*t65+4.054252943386152d-2*
     2         t12*t16*t34*t35*t39*t65+2.7028352955907675d-2*t12*t15*t34
     3         *t35*t38*t65+1.3514176477953838d-2*t10*t12*t34*t35*t65+6.
     4         75708823897692d-2*t12*t23*t34*t35*t42*t46+5.4056705911815
     5         35d-2*t12*t22*t34*t35*t42*t45+4.054252943386152d-2*t12*t2
     6         1*t34*t35*t42*t44+2.7028352955907675d-2*t12*t19*t34*t35*t
     7         42*t43+1.3514176477953838d-2*t12*t24*t34*t35*t42
            t132 = 2.173347090601665d-1*t12*t59*t62*t63-1.57665392242794
     1         8d-2*t34*t35*t60*t61
            t133 = 1.576653922427948d-2*t34*t35*t60*t61-2.17334709060166
     1         5d-1*t12*t59*t62*t63
            t134 = 6.75708823897692d-2*t12*t23*t34*t35*t42*t46*t66+5.405
     1         670591181535d-2*t12*t22*t34*t35*t42*t45*t66-2.70283529559
     2         0768d-1*t113*t12*t23*t34*t35*t45*t66+4.054252943386152d-2
     3         *t12*t21*t34*t35*t42*t44*t66-1.6217011773544607d-1*t113*t
     4         12*t22*t34*t35*t44*t66+2.7028352955907675d-2*t12*t19*t34*
     5         t35*t42*t43*t66-8.108505886772304d-2*t113*t12*t21*t34*t35
     6         *t43*t66+1.3514176477953838d-2*t12*t24*t34*t35*t42*t66-2.
     7         7028352955907675d-2*t113*t12*t19*t34*t35*t66+5.0d+0*t132*
     8         t18*t41*t65+4.0d+0*t132*t17*t40*t65+3.0d+0*t132*t16*t39*t
     9         65+2.0d+0*t132*t15*t38*t65+1.0d+0*t10*t132*t65-1.35141764
     :         7795384d-1*t103*t12*t18*t34*t35*t41*t64+2.702835295590768
     ;         d-1*t101*t12*t18*t34*t35*t40*t64-1.0811341182363071d-1*t1
     <         03*t12*t17*t34*t35*t40*t64+1.6217011773544607d-1*t101*t12
     =         *t17*t34*t35*t39*t64-8.108505886772304d-2*t103*t12*t16*t3
     >         4*t35*t39*t64+8.108505886772304d-2*t101*t12*t16*t34*t35*t
     ?         38*t64-5.405670591181535d-2*t103*t12*t15*t34*t35*t38*t64+
     @         2.7028352955907675d-2*t101*t12*t15*t34*t35*t64-2.70283529
     1         55907675d-2*t10*t103*t12*t34*t35*t64-5.0d+0*t133*t23*t42*
     2         t46-4.0d+0*t133*t22*t42*t45-3.0d+0*t133*t21*t42*t44-2.0d+
     3         0*t133*t19*t42*t43-t133*t24*t42
            t135 = 2.0d+0*rhoa*t131*t59*wght-1.243628d-1*rhoa*t134*t32*t
     1         33*wght-6.21814d-2*t131*t32*t33*wght
            t136 = 1.351417647795384d-1*t12*t18*t34*t35*t41*t65+1.081134
     1         1182363071d-1*t12*t17*t34*t35*t40*t65+8.108505886772304d-
     2         2*t12*t16*t34*t35*t39*t65+5.405670591181535d-2*t12*t15*t3
     3         4*t35*t38*t65+2.7028352955907675d-2*t10*t12*t34*t35*t65+1
     4         .351417647795384d-1*t12*t23*t34*t35*t42*t46+1.08113411823
     5         63071d-1*t12*t22*t34*t35*t42*t45+8.108505886772304d-2*t12
     6         *t21*t34*t35*t42*t44+5.405670591181535d-2*t12*t19*t34*t35
     7         *t42*t43+2.7028352955907675d-2*t12*t24*t34*t35*t42
            t137 = 4.34669418120333d-1*t12*t59*t62*t63-3.153307844855896
     1         d-2*t34*t35*t60*t61
            t138 = 3.153307844855896d-2*t34*t35*t60*t61-4.34669418120333
     1         d-1*t12*t59*t62*t63
            t139 = 1.351417647795384d-1*t12*t23*t34*t35*t42*t46*t66+1.08
     1         11341182363071d-1*t12*t22*t34*t35*t42*t45*t66-5.405670591
     2         181536d-1*t113*t12*t23*t34*t35*t45*t66+8.108505886772304d
     3         -2*t12*t21*t34*t35*t42*t44*t66-3.2434023547089214d-1*t113
     4         *t12*t22*t34*t35*t44*t66+5.405670591181535d-2*t12*t19*t34
     5         *t35*t42*t43*t66-1.6217011773544607d-1*t113*t12*t21*t34*t
     6         35*t43*t66+2.7028352955907675d-2*t12*t24*t34*t35*t42*t66-
     7         5.405670591181535d-2*t113*t12*t19*t34*t35*t66+5.0d+0*t137
     8         *t18*t41*t65+4.0d+0*t137*t17*t40*t65+3.0d+0*t137*t16*t39*
     9         t65+2.0d+0*t137*t15*t38*t65+1.0d+0*t10*t137*t65-2.7028352
     :         95590768d-1*t103*t12*t18*t34*t35*t41*t64+5.40567059118153
     ;         6d-1*t101*t12*t18*t34*t35*t40*t64-2.1622682364726142d-1*t
     <         103*t12*t17*t34*t35*t40*t64+3.2434023547089214d-1*t101*t1
     =         2*t17*t34*t35*t39*t64-1.6217011773544607d-1*t103*t12*t16*
     >         t34*t35*t39*t64+1.6217011773544607d-1*t101*t12*t16*t34*t3
     ?         5*t38*t64-1.0811341182363071d-1*t103*t12*t15*t34*t35*t38*
     @         t64+5.405670591181535d-2*t101*t12*t15*t34*t35*t64-5.40567
     1         0591181535d-2*t10*t103*t12*t34*t35*t64-5.0d+0*t138*t23*t4
     2         2*t46-4.0d+0*t138*t22*t42*t45-3.0d+0*t138*t21*t42*t44-2.0
     3         d+0*t138*t19*t42*t43-t138*t24*t42
            t140 = -4.5786028891724556d-3*t12*t18*t34*t35*t40*t65-2.7471
     1         61733503473d-3*t12*t17*t34*t35*t39*t65-1.3735808667517366
     2         d-3*t12*t16*t34*t35*t38*t65-4.578602889172455d-4*t12*t15*
     3         t34*t35*t65
            t141 = -1.243628d-1*rhoa*t32*t33*(2.156233411195693d-2*t103*
     1         t62*t63*t68*t92-7.977672241861109d-1*t12*t140*t34*t35*t65
     2         -7.977672241861109d-1*t12*t34*t35*(1.1446507222931139d-3*
     3         t12*t23*t34*t35*t42*t46+9.15720577834491d-4*t12*t22*t34*t
     4         35*t42*t45-4.5786028891724556d-3*t113*t12*t23*t34*t35*t45
     5         +6.867904333758682d-4*t12*t21*t34*t35*t42*t44-2.747161733
     6         503473d-3*t113*t12*t22*t34*t35*t44+4.578602889172455d-4*t
     7         12*t19*t34*t35*t42*t43-1.3735808667517366d-3*t113*t12*t21
     8         *t34*t35*t43+2.2893014445862275d-4*t12*t24*t34*t35*t42-4.
     9         578602889172455d-4*t113*t12*t19*t34*t35))*wght
            t142 = -9.157205778344911d-3*t12*t18*t34*t35*t40*t65-5.49432
     1         3467006946d-3*t12*t17*t34*t35*t39*t65-2.747161733503473d-
     2         3*t12*t16*t34*t35*t38*t65-9.15720577834491d-4*t12*t15*t34
     3         *t35*t65
            t143 = -1.8314411556689822d-2*t12*t18*t34*t35*t40*t65-1.0988
     1         646934013892d-2*t12*t17*t34*t35*t39*t65-5.494323467006946
     2         d-3*t12*t16*t34*t35*t38*t65-1.8314411556689822d-3*t12*t15
     3         *t34*t35*t65
            t144 = t57**3
            t145 = 5.172601291927341d+2*t144*t33/(t30**6*t31**3)
            t146 = -9.649187699215522d+1*t144*t33*t71/t30**5
            t147 = 6.0d+0*t144*t33*t48*t73
            t148 = 4.824593849607761d+1*t33*t57*t71*t73*t79
            t149 = -6.0d+0*t33*t48*t57*t75*t79
            t150 = 9.921256574801247d-2
            t151 = 1/rhoa**3.3333333333333337d+0
            t152 = 1.0d+0*(-1.5008036906238065d+0/(t2**7*t26**7)-2.30799
     1         79182303428d+0*t150*t151-2.8068057454507694d-1/rhoa**3.16
     2         66666666666665d+0-4.4260660773166294d-2/rhoa**3.666666666
     3         6666664d+0)*t33*t48*t58
            t153 = 8.548627933030694d-3*t150*t151*t32
            t154 = 1/rhoa**3
            t155 = 1.767585332069357d-1*t48*t57*t58*t77*t78
            t156 = 1/t83
            t157 = -1.3595691172479402d+0*t55*t56-7.491972878592053d-1*t
     1         53*t54-2.1504862356383217d-1*t51*t52-1.2743417300848914d-
     2         1*t49*t50
            t158 = 1/t82**2
            t159 = -2.1319703304396778d+0*t53*t54*t71*t72*t73
            t160 = 2.6513779981040353d-1*t48*t53*t54*t72*t75
            t161 = -1.3256889990520176d-1*t48*t53*t54*t58*t79
            t162 = -7.5d-1*t156*t157*t158*t85*t86-2.533029591058444d-2*t
     1         154*t84*t85-5.82714947393947d-4*t151*t53*t84+t161+t160+t1
     2         59+t155+t153+t152+t149+t148+t147+t146+t145
            t163 = 6.0d+0*t59*t67*wght
            t164 = rhoa**5.000000000000002d-1
            t165 = 1/t11**5.0d+0
            t166 = -2.575201406632316d-1*gammaaa*t164*t165*t34*t35
            t167 = 1/rhoa**6.666666666666665d-1
            t168 = 5.32470037197408d+0*gammaaa*t59*t62*t63*t91*t92
            t169 = 1/rhoa**1.8333333333333332d+0
            t170 = 1/t32**4
            t171 = t59**3
            t172 = 1/t33**4
            t173 = 1.349022956238324d+3*gammaaa*t12*t170*t171*t172
            t174 = -9.786482539287735d+1*gammaaa*t60*t61*t95*t96*t97+8.3
     1         88413605103772d+1*gammaaa*t12*t59*t88*t95*t97+3.622245151
     2         0027703d-2*gammaaa*t59*t61*t62*t63*t93-3.9416348060698647
     3         d-3*gammaaa*t167*t34*t35*t92-3.042685926842331d+0*gammaaa
     4         *t60*t61*t62*t63*t88-4.346694181203331d-1*gammaaa*t12*t59
     5         *t62*t63*t86+8.69338836240666d-1*gammaaa*t12*t162*t62*t63
     6         +2.621499974195676d-2*gammaaa*t169*t34*t35*t61+2.70283529
     7         55907686d-2*gammaaa*t12*t154*t34*t35+t173+t168+t166
            t175 = t64**3
            t176 = 1/t37**6
            t177 = 6.0d+0*t16*t175*t176
            t178 = 1/t37**5
            t179 = -1.2d+1*t15*t175*t178
            t180 = 6.0d+0*t10*t101*t175
            t181 = 2.4d+1*t17*t175*t176*t38
            t182 = -3.6d+1*t16*t175*t178*t38
            t183 = 1.2d+1*t101*t15*t175*t38
            t184 = 6.0d+1*t175*t176*t18*t39
            t185 = -7.2d+1*t17*t175*t178*t39
            t186 = 1.8d+1*t101*t16*t175*t39
            t187 = -1.2d+2*t175*t178*t18*t40
            t188 = 2.4d+1*t101*t17*t175*t40
            t189 = 3.0d+1*t101*t175*t18*t41
            t190 = t66**3
            t191 = exp(-1.6217011773544607d-1*gammaaa*t12*t34*t35)
            t192 = -6.0d+0*t190*t191*t21
            t193 = 1.2613231379423584d-1*gammaaa*t34*t35*t60*t61-1.73867
     1         7672481332d+0*gammaaa*t12*t59*t62*t63
            t194 = 2.0d+0*t112*t113*t19*t193
            t195 = 2.0d+0*t113*t19*t190
            t196 = -6.0d+1*t190*t191*t23*t44
            t197 = 1.2d+1*t112*t113*t193*t22*t44
            t198 = 1.2d+1*t113*t190*t22*t44
            t199 = 2.0d+1*t112*t113*t193*t23*t45
            t200 = 2.0d+1*t113*t190*t23*t45
            t201 = -2.4d+1*t190*t191*t22*t43
            t202 = 6.0d+0*t112*t113*t193*t21*t43
            t203 = 6.0d+0*t113*t190*t21*t43
            t204 = 2.575201406632316d-1*gammaaa*t164*t165*t34*t35
            t205 = -5.32470037197408d+0*gammaaa*t59*t62*t63*t91*t92
            t206 = -1.349022956238324d+3*gammaaa*t12*t170*t171*t172
            t207 = 9.786482539287735d+1*gammaaa*t60*t61*t95*t96*t97-8.38
     1         8413605103772d+1*gammaaa*t12*t59*t88*t95*t97-3.6222451510
     2         027703d-2*gammaaa*t59*t61*t62*t63*t93+3.9416348060698647d
     3         -3*gammaaa*t167*t34*t35*t92+3.042685926842331d+0*gammaaa*
     4         t60*t61*t62*t63*t88+4.346694181203331d-1*gammaaa*t12*t59*
     5         t62*t63*t86-8.69338836240666d-1*gammaaa*t12*t162*t62*t63-
     6         2.621499974195676d-2*gammaaa*t169*t34*t35*t61-2.702835295
     7         5907686d-2*gammaaa*t12*t154*t34*t35+t206+t205+t204
            t208 = -t190*t24*t42
            t209 = -3.0d+0*t190*t21*t42*t44
            t210 = -4.0d+0*t190*t22*t42*t45
            t211 = -5.0d+0*t190*t23*t42*t46
            t212 = -2.0d+0*t19*t190*t42*t43
            t213 = 2.5d-1*t156*t157*t158*t85*t86+8.443431970194815d-3*t1
     1         54*t84*t85+1.9423831579798237d-4*t151*t53*t84+t161+t160+t
     2         159+t155+t153+t152+t149+t148+t147+t146+t145
            t214 = -9.786482539287732d+1*gammaaa*t60*t61*t95*t96*t97+2.7
     1         961378683679233d+1*gammaaa*t12*t59*t88*t95*t97+5.59227573
     2         6735847d+1*gammaaa*t12*t127*t59*t95*t97-3.501503645969350
     3         5d-1*gammaaa*t59*t61*t62*t63*t93+3.810246979200874d-2*gam
     4         maaa*t167*t34*t35*t92-1.0142286422807771d+0*gammaaa*t60*t
     5         61*t62*t63*t88+1.4488980604011098d-1*gammaaa*t12*t59*t62*
     6         t63*t86-2.0284572845615542d+0*gammaaa*t127*t60*t61*t62*t6
     7         3+8.69338836240666d-1*gammaaa*t12*t213*t62*t63-5.81860376
     8         134123d-3*gammaaa*t169*t34*t35*t61-9.009450985302558d-3*g
     9         ammaaa*t12*t154*t34*t35+t173+t168+t166
            t215 = 9.786482539287732d+1*gammaaa*t60*t61*t95*t96*t97-2.79
     1         61378683679233d+1*gammaaa*t12*t59*t88*t95*t97-5.592275736
     2         735847d+1*gammaaa*t12*t127*t59*t95*t97+3.5015036459693505
     3         d-1*gammaaa*t59*t61*t62*t63*t93-3.810246979200874d-2*gamm
     4         aaa*t167*t34*t35*t92+1.0142286422807771d+0*gammaaa*t60*t6
     5         1*t62*t63*t88-1.4488980604011098d-1*gammaaa*t12*t59*t62*t
     6         63*t86+2.0284572845615542d+0*gammaaa*t127*t60*t61*t62*t63
     7         -8.69338836240666d-1*gammaaa*t12*t213*t62*t63+5.818603761
     8         34123d-3*gammaaa*t169*t34*t35*t61+9.009450985302558d-3*ga
     9         mmaaa*t12*t154*t34*t35+t206+t205+t204
            t216 = 2.0d+0*t131*t59*wght
            t217 = -1.243628d-1*t134*t32*t33*wght
            t218 = 4.0d+0*rhoa*t134*t59*wght
            t219 = -5.071143211403886d-1*t59*t60*t61*t62*t63
            t220 = 6.990344670919809d+0*t12*t95*t96*t97
            t221 = 1.876968955271364d-4*t34*t35*t61*t93+2.75914436424890
     1         9d-2*t34*t35*t91*t92+2.173347090601665d-1*t12*t62*t63*t88
     2         -2.2523627463256402d-3*t12*t34*t35*t86+t220+t219
            t222 = 8.108505886772304d-2*t100*t12*t16*t176*t34*t35
            t223 = -1.6217011773544607d-1*t100*t12*t15*t178*t34*t35
            t224 = 4.0d+0*t101*t132*t15*t64
            t225 = 8.108505886772304d-2*t10*t100*t101*t12*t34*t35
            t226 = -4.0d+0*t10*t103*t132*t64
            t227 = 3.2434023547089214d-1*t100*t12*t17*t176*t34*t35*t38
            t228 = -4.865103532063382d-1*t100*t12*t16*t178*t34*t35*t38
            t229 = 1.2d+1*t101*t132*t16*t38*t64
            t230 = 1.6217011773544607d-1*t100*t101*t12*t15*t34*t35*t38
            t231 = -8.0d+0*t103*t132*t15*t38*t64
            t232 = 8.108505886772305d-1*t100*t12*t176*t18*t34*t35*t39
            t233 = -9.730207064126764d-1*t100*t12*t17*t178*t34*t35*t39
            t234 = 2.4d+1*t101*t132*t17*t39*t64
            t235 = 2.432551766031691d-1*t100*t101*t12*t16*t34*t35*t39
            t236 = -1.2d+1*t103*t132*t16*t39*t64
            t237 = -1.621701177354461d+0*t100*t12*t178*t18*t34*t35*t40
            t238 = 4.0d+1*t101*t132*t18*t40*t64
            t239 = 3.2434023547089214d-1*t100*t101*t12*t17*t34*t35*t40
            t240 = -1.6d+1*t103*t132*t17*t40*t64
            t241 = 4.0542529433861524d-1*t100*t101*t12*t18*t34*t35*t41
            t242 = -2.0d+1*t103*t132*t18*t41*t64
            t243 = 8.108505886772304d-2*t112*t12*t191*t21*t34*t35
            t244 = 4.0d+0*t113*t133*t19*t66
            t245 = -8.108505886772304d-2*t112*t113*t12*t19*t34*t35
            t246 = 8.108505886772305d-1*t112*t12*t191*t23*t34*t35*t44
            t247 = 2.4d+1*t113*t133*t22*t44*t66
            t248 = -4.865103532063382d-1*t112*t113*t12*t22*t34*t35*t44
            t249 = 4.0d+1*t113*t133*t23*t45*t66
            t250 = -8.108505886772305d-1*t112*t113*t12*t23*t34*t35*t45
            t251 = 3.2434023547089214d-1*t112*t12*t191*t22*t34*t35*t43
            t252 = 1.2d+1*t113*t133*t21*t43*t66
            t253 = -2.432551766031691d-1*t112*t113*t12*t21*t34*t35*t43
            t254 = -2*t133*t24*t42*t66
            t255 = 5.071143211403886d-1*t59*t60*t61*t62*t63
            t256 = -6.990344670919809d+0*t12*t95*t96*t97
            t257 = -1.876968955271364d-4*t34*t35*t61*t93-2.7591443642489
     1         09d-2*t34*t35*t91*t92-2.173347090601665d-1*t12*t62*t63*t8
     2         8+2.2523627463256402d-3*t12*t34*t35*t86+t256+t255
            t258 = 1.3514176477953838d-2*t112*t12*t24*t34*t35*t42
            t259 = -6.0d+0*t133*t21*t42*t44*t66
            t260 = 4.054252943386152d-2*t112*t12*t21*t34*t35*t42*t44
            t261 = -8.0d+0*t133*t22*t42*t45*t66
            t262 = 5.405670591181535d-2*t112*t12*t22*t34*t35*t42*t45
            t263 = -1.0d+1*t133*t23*t42*t46*t66
            t264 = 6.75708823897692d-2*t112*t12*t23*t34*t35*t42*t46
            t265 = -4.0d+0*t133*t19*t42*t43*t66
            t266 = 2.7028352955907675d-2*t112*t12*t19*t34*t35*t42*t43
            t267 = -1.243628d-1*rhoa*t32*t33*(-1.351417647795384d-1*t103
     1         *t12*t18*t34*t35*t41*t99+2.702835295590768d-1*t101*t12*t1
     2         8*t34*t35*t40*t99-1.0811341182363071d-1*t103*t12*t17*t34*
     3         t35*t40*t99+1.6217011773544607d-1*t101*t12*t17*t34*t35*t3
     4         9*t99-8.108505886772304d-2*t103*t12*t16*t34*t35*t39*t99+8
     5         .108505886772304d-2*t101*t12*t16*t34*t35*t38*t99-5.405670
     6         591181535d-2*t103*t12*t15*t34*t35*t38*t99+2.7028352955907
     7         675d-2*t101*t12*t15*t34*t35*t99-2.7028352955907675d-2*t10
     8         *t103*t12*t34*t35*t99+5.0d+0*t18*t221*t41*t65+4.0d+0*t17*
     9         t221*t40*t65+3.0d+0*t16*t221*t39*t65+2.0d+0*t15*t221*t38*
     :         t65+1.0d+0*t10*t221*t65+6.75708823897692d-2*t12*t120*t23*
     ;         t34*t35*t42*t46-5.0d+0*t23*t257*t42*t46+5.405670591181535
     <         d-2*t12*t120*t22*t34*t35*t42*t45-4.0d+0*t22*t257*t42*t45-
     =         2.702835295590768d-1*t113*t12*t120*t23*t34*t35*t45+4.0542
     >         52943386152d-2*t12*t120*t21*t34*t35*t42*t44-3.0d+0*t21*t2
     ?         57*t42*t44-1.6217011773544607d-1*t113*t12*t120*t22*t34*t3
     @         5*t44+2.7028352955907675d-2*t12*t120*t19*t34*t35*t42*t43-
     1         2.0d+0*t19*t257*t42*t43-8.108505886772304d-2*t113*t12*t12
     2         0*t21*t34*t35*t43+1.3514176477953838d-2*t12*t120*t24*t34*
     3         t35*t42-t24*t257*t42-2.7028352955907675d-2*t113*t12*t120*
     4         t19*t34*t35+t266+t265+t264+t263+t262+t261+t260+t259+t258+
     5         t254+t253+t252+t251+t250+t249+t248+t247+t246+t245+t244+t2
     6         43+t242+t241+t240+t239+t238+t237+t236+t235+t234+t233+t232
     7         +t231+t230+t229+t228+t227+t226+t225+t224+t223+t222)*wght+
     8         2.0d+0*rhoa*t131*t88*wght+t218+t217+t216
            t268 = 2.0d+0*t136*t59*wght
            t269 = -1.243628d-1*t139*t32*t33*wght
            t270 = 4.0d+0*rhoa*t139*t59*wght
            t271 = -1.0142286422807771d+0*t59*t60*t61*t62*t63
            t272 = 1.3980689341839617d+1*t12*t95*t96*t97
            t273 = 3.753937910542728d-4*t34*t35*t61*t93+5.51828872849781
     1         8d-2*t34*t35*t91*t92+4.34669418120333d-1*t12*t62*t63*t88-
     2         4.5047254926512803d-3*t12*t34*t35*t86+t272+t271
            t274 = 1.6217011773544607d-1*t100*t12*t16*t176*t34*t35
            t275 = -3.2434023547089214d-1*t100*t12*t15*t178*t34*t35
            t276 = 4.0d+0*t101*t137*t15*t64
            t277 = 1.6217011773544607d-1*t10*t100*t101*t12*t34*t35
            t278 = -4.0d+0*t10*t103*t137*t64
            t279 = 6.486804709417843d-1*t100*t12*t17*t176*t34*t35*t38
            t280 = -9.730207064126764d-1*t100*t12*t16*t178*t34*t35*t38
            t281 = 1.2d+1*t101*t137*t16*t38*t64
            t282 = 3.2434023547089214d-1*t100*t101*t12*t15*t34*t35*t38
            t283 = -8.0d+0*t103*t137*t15*t38*t64
            t284 = 1.621701177354461d+0*t100*t12*t176*t18*t34*t35*t39
            t285 = -1.9460414128253528d+0*t100*t12*t17*t178*t34*t35*t39
            t286 = 2.4d+1*t101*t137*t17*t39*t64
            t287 = 4.865103532063382d-1*t100*t101*t12*t16*t34*t35*t39
            t288 = -1.2d+1*t103*t137*t16*t39*t64
            t289 = -3.243402354708922d+0*t100*t12*t178*t18*t34*t35*t40
            t290 = 4.0d+1*t101*t137*t18*t40*t64
            t291 = 6.486804709417843d-1*t100*t101*t12*t17*t34*t35*t40
            t292 = -1.6d+1*t103*t137*t17*t40*t64
            t293 = 8.108505886772305d-1*t100*t101*t12*t18*t34*t35*t41
            t294 = -2.0d+1*t103*t137*t18*t41*t64
            t295 = 1.6217011773544607d-1*t112*t12*t191*t21*t34*t35
            t296 = 4.0d+0*t113*t138*t19*t66
            t297 = -1.6217011773544607d-1*t112*t113*t12*t19*t34*t35
            t298 = 1.621701177354461d+0*t112*t12*t191*t23*t34*t35*t44
            t299 = 2.4d+1*t113*t138*t22*t44*t66
            t300 = -9.730207064126764d-1*t112*t113*t12*t22*t34*t35*t44
            t301 = 4.0d+1*t113*t138*t23*t45*t66
            t302 = -1.621701177354461d+0*t112*t113*t12*t23*t34*t35*t45
            t303 = 6.486804709417843d-1*t112*t12*t191*t22*t34*t35*t43
            t304 = 1.2d+1*t113*t138*t21*t43*t66
            t305 = -4.865103532063382d-1*t112*t113*t12*t21*t34*t35*t43
            t306 = -2*t138*t24*t42*t66
            t307 = 1.0142286422807771d+0*t59*t60*t61*t62*t63
            t308 = -1.3980689341839617d+1*t12*t95*t96*t97
            t309 = -3.753937910542728d-4*t34*t35*t61*t93-5.5182887284978
     1         18d-2*t34*t35*t91*t92-4.34669418120333d-1*t12*t62*t63*t88
     2         +4.5047254926512803d-3*t12*t34*t35*t86+t308+t307
            t310 = 2.7028352955907675d-2*t112*t12*t24*t34*t35*t42
            t311 = -6.0d+0*t138*t21*t42*t44*t66
            t312 = 8.108505886772304d-2*t112*t12*t21*t34*t35*t42*t44
            t313 = -8.0d+0*t138*t22*t42*t45*t66
            t314 = 1.0811341182363071d-1*t112*t12*t22*t34*t35*t42*t45
            t315 = -1.0d+1*t138*t23*t42*t46*t66
            t316 = 1.351417647795384d-1*t112*t12*t23*t34*t35*t42*t46
            t317 = -4.0d+0*t138*t19*t42*t43*t66
            t318 = 5.405670591181535d-2*t112*t12*t19*t34*t35*t42*t43
            t319 = -2.81545343290705d-3*t34*t35*t61*t93+2.75914436424890
     1         94d-2*t34*t35*t91*t92+2.2523627463256396d-3*t12*t34*t35*t
     2         86+2.173347090601665d-1*t12*t127*t62*t63+t220+t219
            t320 = 2.81545343290705d-3*t34*t35*t61*t93-2.759144364248909
     1         4d-2*t34*t35*t91*t92-2.2523627463256396d-3*t12*t34*t35*t8
     2         6-2.173347090601665d-1*t12*t127*t62*t63+t256+t255
            t321 = -5.6309068658141d-3*t34*t35*t61*t93+5.518288728497819
     1         d-2*t34*t35*t91*t92+4.504725492651279d-3*t12*t34*t35*t86+
     2         4.34669418120333d-1*t12*t127*t62*t63+t272+t271
            t322 = 5.6309068658141d-3*t34*t35*t61*t93-5.518288728497819d
     1         -2*t34*t35*t91*t92-4.504725492651279d-3*t12*t34*t35*t86-4
     2         .34669418120333d-1*t12*t127*t62*t63+t308+t307
            t323 = -9.13164829386404d-4*t23*t42*t46*t62*t63*t92-7.305318
     1         635091232d-4*t22*t42*t45*t62*t63*t92+3.652659317545616d-3
     2         *t113*t23*t45*t62*t63*t92-5.478988976318424d-4*t21*t42*t4
     3         4*t62*t63*t92+2.1915955905273699d-3*t113*t22*t44*t62*t63*
     4         t92-3.652659317545616d-4*t19*t42*t43*t62*t63*t92+1.095797
     5         7952636849d-3*t113*t21*t43*t62*t63*t92-1.826329658772808d
     6         -4*t24*t42*t62*t63*t92-1.826329658772808d-3*t103*t18*t41*
     7         t62*t63*t92+3.652659317545616d-3*t101*t18*t40*t62*t63*t92
     8         -1.4610637270182464d-3*t103*t17*t40*t62*t63*t92+2.1915955
     9         905273699d-3*t101*t17*t39*t62*t63*t92-1.0957977952636849d
     :         -3*t103*t16*t39*t62*t63*t92+1.0957977952636849d-3*t101*t1
     ;         6*t38*t62*t63*t92-7.305318635091232d-4*t103*t15*t38*t62*t
     <         63*t92+3.652659317545616d-4*t113*t19*t62*t63*t92+3.652659
     =         317545616d-4*t101*t15*t62*t63*t92-3.652659317545616d-4*t1
     >         0*t103*t62*t63*t92
            t324 = 5.405670591181535d-2*t101*t12*t132*t15*t34*t35
            t325 = -5.405670591181535d-2*t10*t103*t12*t132*t34*t35
            t326 = 1.6217011773544607d-1*t101*t12*t132*t16*t34*t35*t38
            t327 = -1.0811341182363071d-1*t103*t12*t132*t15*t34*t35*t38
            t328 = 3.2434023547089214d-1*t101*t12*t132*t17*t34*t35*t39
            t329 = -1.6217011773544607d-1*t103*t12*t132*t16*t34*t35*t39
            t330 = 5.405670591181536d-1*t101*t12*t132*t18*t34*t35*t40
            t331 = -2.1622682364726142d-1*t103*t12*t132*t17*t34*t35*t40
            t332 = -2.702835295590768d-1*t103*t12*t132*t18*t34*t35*t41
            t333 = -5.405670591181535d-2*t113*t12*t133*t19*t34*t35
            t334 = -3.2434023547089214d-1*t113*t12*t133*t22*t34*t35*t44
            t335 = -5.405670591181536d-1*t113*t12*t133*t23*t34*t35*t45
            t336 = -1.6217011773544607d-1*t113*t12*t133*t21*t34*t35*t43
            t337 = 2.7028352955907675d-2*t12*t133*t24*t34*t35*t42
            t338 = 8.108505886772304d-2*t12*t133*t21*t34*t35*t42*t44
            t339 = 1.0811341182363071d-1*t12*t133*t22*t34*t35*t42*t45
            t340 = 1.351417647795384d-1*t12*t133*t23*t34*t35*t42*t46
            t341 = 5.405670591181535d-2*t12*t133*t19*t34*t35*t42*t43
            t342 = -1.243628d-1*rhoa*t32*t33*(-9.13164829386404d-4*t23*t
     1         42*t46*t62*t63*t66*t92-7.305318635091232d-4*t22*t42*t45*t
     2         62*t63*t66*t92+1.0957977952636846d-2*t113*t23*t45*t62*t63
     3         *t66*t92-5.478988976318424d-4*t21*t42*t44*t62*t63*t66*t92
     4         -1.0957977952636846d-2*t191*t23*t44*t62*t63*t66*t92+6.574
     5         786771582108d-3*t113*t22*t44*t62*t63*t66*t92-3.6526593175
     6         45616d-4*t19*t42*t43*t62*t63*t66*t92-4.3831911810547397d-
     7         3*t191*t22*t43*t62*t63*t66*t92+3.287393385791054d-3*t113*
     8         t21*t43*t62*t63*t66*t92-1.826329658772808d-4*t24*t42*t62*
     9         t63*t66*t92-1.0957977952636849d-3*t191*t21*t62*t63*t66*t9
     :         2+1.0957977952636849d-3*t113*t19*t62*t63*t66*t92+5.478988
     ;         976318423d-3*t101*t18*t41*t62*t63*t64*t92-2.1915955905273
     <         693d-2*t178*t18*t40*t62*t63*t64*t92+4.3831911810547397d-3
     =         *t101*t17*t40*t62*t63*t64*t92+1.0957977952636846d-2*t176*
     >         t18*t39*t62*t63*t64*t92-1.3149573543164217d-2*t17*t178*t3
     ?         9*t62*t63*t64*t92+3.287393385791054d-3*t101*t16*t39*t62*t
     @         63*t64*t92-6.574786771582108d-3*t16*t178*t38*t62*t63*t64*
     1         t92+4.3831911810547397d-3*t17*t176*t38*t62*t63*t64*t92+2.
     2         1915955905273699d-3*t101*t15*t38*t62*t63*t64*t92-2.191595
     3         5905273699d-3*t15*t178*t62*t63*t64*t92+1.0957977952636849
     4         d-3*t16*t176*t62*t63*t64*t92+1.0957977952636849d-3*t10*t1
     5         01*t62*t63*t64*t92+t341+t340+t339+t338+t337+t336+t335+t33
     6         4+t333+t332+t331+t330+t329+t328+t327+t326+t325+t324)*wght
     7         +2.0d+0*rhoa*t323*t59*wght-6.21814d-2*t32*t323*t33*wght
            t343 = -1.826329658772808d-3*t23*t42*t46*t62*t63*t92-1.46106
     1         37270182464d-3*t22*t42*t45*t62*t63*t92+7.305318635091232d
     2         -3*t113*t23*t45*t62*t63*t92-1.0957977952636849d-3*t21*t42
     3         *t44*t62*t63*t92+4.3831911810547397d-3*t113*t22*t44*t62*t
     4         63*t92-7.305318635091232d-4*t19*t42*t43*t62*t63*t92+2.191
     5         5955905273699d-3*t113*t21*t43*t62*t63*t92-3.6526593175456
     6         16d-4*t24*t42*t62*t63*t92-3.652659317545616d-3*t103*t18*t
     7         41*t62*t63*t92+7.305318635091232d-3*t101*t18*t40*t62*t63*
     8         t92-2.922127454036493d-3*t103*t17*t40*t62*t63*t92+4.38319
     9         11810547397d-3*t101*t17*t39*t62*t63*t92-2.191595590527369
     :         9d-3*t103*t16*t39*t62*t63*t92+2.1915955905273699d-3*t101*
     ;         t16*t38*t62*t63*t92-1.4610637270182464d-3*t103*t15*t38*t6
     <         2*t63*t92+7.305318635091232d-4*t113*t19*t62*t63*t92+7.305
     =         318635091232d-4*t101*t15*t62*t63*t92-7.305318635091232d-4
     >         *t10*t103*t62*t63*t92
            t344 = -1.243628d-1*rhoa*t32*t33*(-1.826329658772808d-3*t23*
     1         t42*t46*t62*t63*t66*t92-1.4610637270182464d-3*t22*t42*t45
     2         *t62*t63*t66*t92+2.1915955905273693d-2*t113*t23*t45*t62*t
     3         63*t66*t92-1.0957977952636849d-3*t21*t42*t44*t62*t63*t66*
     4         t92-2.1915955905273693d-2*t191*t23*t44*t62*t63*t66*t92+1.
     5         3149573543164217d-2*t113*t22*t44*t62*t63*t66*t92-7.305318
     6         635091232d-4*t19*t42*t43*t62*t63*t66*t92-8.76638236210947
     7         9d-3*t191*t22*t43*t62*t63*t66*t92+6.574786771582108d-3*t1
     8         13*t21*t43*t62*t63*t66*t92-3.652659317545616d-4*t24*t42*t
     9         62*t63*t66*t92-2.1915955905273699d-3*t191*t21*t62*t63*t66
     :         *t92+2.1915955905273699d-3*t113*t19*t62*t63*t66*t92+1.095
     ;         7977952636846d-2*t101*t18*t41*t62*t63*t64*t92-4.383191181
     <         0547386d-2*t178*t18*t40*t62*t63*t64*t92+8.766382362109479
     =         d-3*t101*t17*t40*t62*t63*t64*t92+2.1915955905273693d-2*t1
     >         76*t18*t39*t62*t63*t64*t92-2.6299147086328434d-2*t17*t178
     ?         *t39*t62*t63*t64*t92+6.574786771582108d-3*t101*t16*t39*t6
     @         2*t63*t64*t92-1.3149573543164217d-2*t16*t178*t38*t62*t63*
     1         t64*t92+8.766382362109479d-3*t17*t176*t38*t62*t63*t64*t92
     2         +4.3831911810547397d-3*t101*t15*t38*t62*t63*t64*t92-4.383
     3         1911810547397d-3*t15*t178*t62*t63*t64*t92+2.1915955905273
     4         699d-3*t16*t176*t62*t63*t64*t92+2.1915955905273699d-3*t10
     5         *t101*t62*t63*t64*t92+6.75708823897692d-2*t12*t138*t23*t3
     6         4*t35*t42*t46+5.405670591181535d-2*t12*t138*t22*t34*t35*t
     7         42*t45-2.702835295590768d-1*t113*t12*t138*t23*t34*t35*t45
     8         +4.054252943386152d-2*t12*t138*t21*t34*t35*t42*t44-1.6217
     9         011773544607d-1*t113*t12*t138*t22*t34*t35*t44+2.702835295
     :         5907675d-2*t12*t138*t19*t34*t35*t42*t43-8.108505886772304
     ;         d-2*t113*t12*t138*t21*t34*t35*t43+1.3514176477953838d-2*t
     <         12*t138*t24*t34*t35*t42-1.351417647795384d-1*t103*t12*t13
     =         7*t18*t34*t35*t41+2.702835295590768d-1*t101*t12*t137*t18*
     >         t34*t35*t40-1.0811341182363071d-1*t103*t12*t137*t17*t34*t
     ?         35*t40+1.6217011773544607d-1*t101*t12*t137*t17*t34*t35*t3
     @         9-8.108505886772304d-2*t103*t12*t137*t16*t34*t35*t39+8.10
     1         8505886772304d-2*t101*t12*t137*t16*t34*t35*t38-5.40567059
     2         1181535d-2*t103*t12*t137*t15*t34*t35*t38-2.70283529559076
     3         75d-2*t113*t12*t138*t19*t34*t35+2.7028352955907675d-2*t10
     4         1*t12*t137*t15*t34*t35-2.7028352955907675d-2*t10*t103*t12
     5         *t137*t34*t35+t341+t340+t339+t338+t337+t336+t335+t334+t33
     6         3+t332+t331+t330+t329+t328+t327+t326+t325+t324)*wght+2.0d
     7         +0*rhoa*t343*t59*wght-6.21814d-2*t32*t33*t343*wght
            t345 = -3.652659317545616d-3*t23*t42*t46*t62*t63*t92-2.92212
     1         7454036493d-3*t22*t42*t45*t62*t63*t92+1.4610637270182464d
     2         -2*t113*t23*t45*t62*t63*t92-2.1915955905273699d-3*t21*t42
     3         *t44*t62*t63*t92+8.766382362109479d-3*t113*t22*t44*t62*t6
     4         3*t92-1.4610637270182464d-3*t19*t42*t43*t62*t63*t92+4.383
     5         1911810547397d-3*t113*t21*t43*t62*t63*t92-7.3053186350912
     6         32d-4*t24*t42*t62*t63*t92-7.305318635091232d-3*t103*t18*t
     7         41*t62*t63*t92+1.4610637270182464d-2*t101*t18*t40*t62*t63
     8         *t92-5.844254908072986d-3*t103*t17*t40*t62*t63*t92+8.7663
     9         82362109479d-3*t101*t17*t39*t62*t63*t92-4.383191181054739
     :         7d-3*t103*t16*t39*t62*t63*t92+4.3831911810547397d-3*t101*
     ;         t16*t38*t62*t63*t92-2.922127454036493d-3*t103*t15*t38*t62
     <         *t63*t92+1.4610637270182464d-3*t113*t19*t62*t63*t92+1.461
     =         0637270182464d-3*t101*t15*t62*t63*t92-1.4610637270182464d
     >         -3*t10*t103*t62*t63*t92
            t346 = 1/t11**6.0d+0
            t347 = -1.243628d-1*rhoa*t32*t33*(-8.741915653967701d-4*t101
     1         *t346*t68*t95*t97-7.977672241861109d-1*t12*t34*t35*(-1.54
     2         69011866686466d-5*t23*t42*t46*t62*t63*t92-1.2375209493349
     3         175d-5*t22*t42*t45*t62*t63*t92+1.856281424002376d-4*t113*
     4         t23*t45*t62*t63*t92-9.28140712001188d-6*t21*t42*t44*t62*t
     5         63*t92-1.856281424002376d-4*t191*t23*t44*t62*t63*t92+1.11
     6         37688544014257d-4*t113*t22*t44*t62*t63*t92-6.187604746674
     7         588d-6*t19*t42*t43*t62*t63*t92-7.425125696009504d-5*t191*
     8         t22*t43*t62*t63*t92+5.568844272007129d-5*t113*t21*t43*t62
     9         *t63*t92-3.093802373337294d-6*t24*t42*t62*t63*t92-1.85628
     :         1424002376d-5*t191*t21*t62*t63*t92+1.856281424002376d-5*t
     ;         113*t19*t62*t63*t92)-7.977672241861109d-1*t12*t34*t35*t65
     <         *(1.2375209493349174d-4*t103*t18*t40*t62*t63*t92-1.856281
     =         424002376d-4*t101*t18*t39*t62*t63*t92+7.425125696009504d-
     >         5*t103*t17*t39*t62*t63*t92-7.425125696009504d-5*t101*t17*
     ?         t38*t62*t63*t92+3.712562848004752d-5*t103*t16*t38*t62*t63
     @         *t92-1.856281424002376d-5*t101*t16*t62*t63*t92+1.23752094
     1         93349175d-5*t103*t15*t62*t63*t92)+4.312466822391386d-2*t1
     2         03*t140*t62*t63*t92)*wght
            t348 = -1.243628d-1*rhoa*t32*t33*(-1.7483831307935405d-3*t10
     1         1*t346*t68*t95*t97-7.977672241861109d-1*t12*t34*t35*(-3.0
     2         93802373337293d-5*t23*t42*t46*t62*t63*t92-2.4750418986698
     3         35d-5*t22*t42*t45*t62*t63*t92+3.712562848004752d-4*t113*t
     4         23*t45*t62*t63*t92-1.856281424002376d-5*t21*t42*t44*t62*t
     5         63*t92-3.712562848004752d-4*t191*t23*t44*t62*t63*t92+2.22
     6         75377088028514d-4*t113*t22*t44*t62*t63*t92-1.237520949334
     7         9175d-5*t19*t42*t43*t62*t63*t92-1.4850251392019007d-4*t19
     8         1*t22*t43*t62*t63*t92+1.1137688544014257d-4*t113*t21*t43*
     9         t62*t63*t92-6.187604746674588d-6*t24*t42*t62*t63*t92-3.71
     :         2562848004752d-5*t191*t21*t62*t63*t92+3.712562848004752d-
     ;         5*t113*t19*t62*t63*t92)-7.977672241861109d-1*t12*t34*t35*
     <         t65*(2.4750418986698347d-4*t103*t18*t40*t62*t63*t92-3.712
     =         562848004752d-4*t101*t18*t39*t62*t63*t92+1.48502513920190
     >         07d-4*t103*t17*t39*t62*t63*t92-1.4850251392019007d-4*t101
     ?         *t17*t38*t62*t63*t92+7.425125696009504d-5*t103*t16*t38*t6
     @         2*t63*t92-3.712562848004752d-5*t101*t16*t62*t63*t92+2.475
     1         041898669835d-5*t103*t15*t62*t63*t92)+6.364325439856123d-
     2         1*t103*(3.3879999248505405d-2*t142+6.775999849701081d-2*t
     3         140)*t62*t63*t92)*wght
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*t6*t7*(t9+t8+t20*t24+t20*
     1         *5.0d+0*t23+t20**4.0d+0*t22+t20**3.0d+0*t21+t19*t20**2.0d
     2         +0+t14**5.0d+0*t18+t14**4.0d+0*t17+t14**3.0d+0*t16+t14**2
     3         .0d+0*t15+t10*t14)*wght
            Amat(iq,D1_RA) = -1.243628d-1*rhoa*t32*t33*t67*wght+2.0d+0*r
     1         hoa*t47*t59*wght-6.21814d-2*t32*t33*t47*wght+Amat(iq,D1_R
     2         A)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-1.243628d-1*rhoa*t32*t33*(
     1         -7.977672241861109d-1*t12*t34*t35*t65*t68-7.9776722418611
     2         09d-1*t12*t34*t35*(-8.469999812126351d-2*t23*t42*t46-6.77
     3         5999849701081d-2*t22*t42*t45-5.081999887275811d-2*t21*t42
     4         *t44-3.3879999248505405d-2*t19*t42*t43-1.6939999624252702
     5         d-2*t24*t42))*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)-1.243628d-1*rhoa*t32*t33*(
     1         -7.977672241861109d-1*t12*t34*t35*t65*t69-7.9776722418611
     2         09d-1*t12*t34*t35*(-1.6939999624252702d-1*t23*t42*t46-1.3
     3         551999699402162d-1*t22*t42*t45-1.0163999774551621d-1*t21*
     4         t42*t44-6.775999849701081d-2*t19*t42*t43-3.38799992485054
     5         05d-2*t24*t42))*wght
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t47*t88*wght-1.243628d-1*rh
     1         oa*t126*t32*t33*wght+t90+t89+t70+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t127*t47*wght-1.243628d-1*r
     1         hoa*t130*t32*t33*wght+t90+t89+t70+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t135+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 2.0d+0*rhoa*t136*t59*wght-1.243628d-1*
     1         rhoa*t139*t32*t33*wght-6.21814d-2*t136*t32*t33*wght+Cmat2
     2         (iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t135+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t141+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)-1.243628d-1*rhoa
     1         *t32*t33*(4.312466822391386d-2*t103*t62*t63*t68*t92-7.977
     2         672241861109d-1*t12*t142*t34*t35*t65-7.977672241861109d-1
     3         *t12*t34*t35*(2.2893014445862278d-3*t12*t23*t34*t35*t42*t
     4         46+1.8314411556689822d-3*t12*t22*t34*t35*t42*t45-9.157205
     5         778344911d-3*t113*t12*t23*t34*t35*t45+1.3735808667517366d
     6         -3*t12*t21*t34*t35*t42*t44-5.494323467006946d-3*t113*t12*
     7         t22*t34*t35*t44+9.15720577834491d-4*t12*t19*t34*t35*t42*t
     8         43-2.747161733503473d-3*t113*t12*t21*t34*t35*t43+4.578602
     9         889172455d-4*t12*t24*t34*t35*t42-9.15720577834491d-4*t113
     :         *t12*t19*t34*t35))*wght
            Cmat2(iq,D2_GAA_GBB) = t141+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)-1.243628d-1*rhoa
     1         *t32*t33*(4.312466822391386d-2*t103*t62*t63*t69*t92-7.977
     2         672241861109d-1*t12*t143*t34*t35*t65-7.977672241861109d-1
     3         *t12*t34*t35*(4.5786028891724556d-3*t12*t23*t34*t35*t42*t
     4         46+3.6628823113379644d-3*t12*t22*t34*t35*t42*t45-1.831441
     5         1556689822d-2*t113*t12*t23*t34*t35*t45+2.747161733503473d
     6         -3*t12*t21*t34*t35*t42*t44-1.0988646934013892d-2*t113*t12
     7         *t22*t34*t35*t44+1.8314411556689822d-3*t12*t19*t34*t35*t4
     8         2*t43-5.494323467006946d-3*t113*t12*t21*t34*t35*t43+9.157
     9         20577834491d-4*t12*t24*t34*t35*t42-1.8314411556689822d-3*
     :         t113*t12*t19*t34*t35))*wght
            Amat3(iq,D3_RA_RA_RA) = -1.243628d-1*rhoa*t32*t33*(-3.0d+1*t
     1         103*t18*t41*t64*t99+6.0d+1*t101*t18*t40*t64*t99-2.4d+1*t1
     2         03*t17*t40*t64*t99+3.6d+1*t101*t17*t39*t64*t99-1.8d+1*t10
     3         3*t16*t39*t64*t99+1.8d+1*t101*t16*t38*t64*t99-1.2d+1*t103
     4         *t15*t38*t64*t99+6.0d+0*t101*t15*t64*t99-6.0d+0*t10*t103*
     5         t64*t99-1.5d+1*t120*t23*t42*t46*t66-1.2d+1*t120*t22*t42*t
     6         45*t66+6.0d+1*t113*t120*t23*t45*t66-9.0d+0*t120*t21*t42*t
     7         44*t66+3.6d+1*t113*t120*t22*t44*t66-6.0d+0*t120*t19*t42*t
     8         43*t66+1.8d+1*t113*t120*t21*t43*t66-3*t120*t24*t42*t66+6.
     9         0d+0*t113*t120*t19*t66+5.0d+0*t174*t18*t41*t65+4.0d+0*t17
     :         *t174*t40*t65+3.0d+0*t16*t174*t39*t65+2.0d+0*t15*t174*t38
     ;         *t65+1.0d+0*t10*t174*t65-5.0d+0*t207*t23*t42*t46-4.0d+0*t
     <         207*t22*t42*t45-3.0d+0*t207*t21*t42*t44-2.0d+0*t19*t207*t
     =         42*t43-t207*t24*t42+t212+t211+t210+t209+t208+t203+t202+t2
     >         01+t200+t199+t198+t197+t196+t195+t194+t192+t189+t188+t187
     ?         +t186+t185+t184+t183+t182+t181+t180+t179+t177)*wght+6.0d+
     @         0*rhoa*t67*t88*wght+3.0d+0*t47*t88*wght+6.0d+0*rhoa*t126*
     1         t59*wght+2.0d+0*rhoa*t162*t47*wght-1.865442d-1*t126*t32*t
     2         33*wght+t163+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = -1.243628d-1*rhoa*t32*t33*(-1.0d+1*t
     1         103*t18*t41*t64*t99+2.0d+1*t101*t18*t40*t64*t99-8.0d+0*t1
     2         03*t17*t40*t64*t99+1.2d+1*t101*t17*t39*t64*t99-6.0d+0*t10
     3         3*t16*t39*t64*t99+6.0d+0*t101*t16*t38*t64*t99-4.0d+0*t103
     4         *t15*t38*t64*t99+2.0d+0*t101*t15*t64*t99-2.0d+0*t10*t103*
     5         t64*t99-1.0d+1*t129*t23*t42*t46*t66-5.0d+0*t120*t23*t42*t
     6         46*t66-8.0d+0*t129*t22*t42*t45*t66-4.0d+0*t120*t22*t42*t4
     7         5*t66+4.0d+1*t113*t129*t23*t45*t66+2.0d+1*t113*t120*t23*t
     8         45*t66-6.0d+0*t129*t21*t42*t44*t66-3.0d+0*t120*t21*t42*t4
     9         4*t66+2.4d+1*t113*t129*t22*t44*t66+1.2d+1*t113*t120*t22*t
     :         44*t66-4.0d+0*t129*t19*t42*t43*t66-2.0d+0*t120*t19*t42*t4
     ;         3*t66+1.2d+1*t113*t129*t21*t43*t66+6.0d+0*t113*t120*t21*t
     <         43*t66-2*t129*t24*t42*t66-t120*t24*t42*t66+4.0d+0*t113*t1
     =         29*t19*t66+2.0d+0*t113*t120*t19*t66+5.0d+0*t18*t214*t41*t
     >         65+4.0d+0*t17*t214*t40*t65+3.0d+0*t16*t214*t39*t65+2.0d+0
     ?         *t15*t214*t38*t65+1.0d+0*t10*t214*t65-2.0d+1*t103*t128*t1
     @         8*t41*t64+4.0d+1*t101*t128*t18*t40*t64-1.6d+1*t103*t128*t
     1         17*t40*t64+2.4d+1*t101*t128*t17*t39*t64-1.2d+1*t103*t128*
     2         t16*t39*t64+1.2d+1*t101*t128*t16*t38*t64-8.0d+0*t103*t128
     3         *t15*t38*t64+4.0d+0*t101*t128*t15*t64-4.0d+0*t10*t103*t12
     4         8*t64-5.0d+0*t215*t23*t42*t46-4.0d+0*t215*t22*t42*t45-3.0
     5         d+0*t21*t215*t42*t44-2.0d+0*t19*t215*t42*t43-t215*t24*t42
     6         +t212+t211+t210+t209+t208+t203+t202+t201+t200+t199+t198+t
     7         197+t196+t195+t194+t192+t189+t188+t187+t186+t185+t184+t18
     8         3+t182+t181+t180+t179+t177)*wght+2.0d+0*rhoa*t67*t88*wght
     9         +1.0d+0*t47*t88*wght+4.0d+0*rhoa*t127*t67*wght+4.0d+0*rho
     :         a*t130*t59*wght+2.0d+0*rhoa*t126*t59*wght+2.0d+0*rhoa*t21
     ;         3*t47*wght+2.0d+0*t127*t47*wght-1.243628d-1*t130*t32*t33*
     <         wght-6.21814d-2*t126*t32*t33*wght+t163+Amat3(iq,D3_RA_RA_
     =         RB)
            Cmat3(iq,D3_RA_RA_GAA) = t267+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = -1.243628d-1*rhoa*t32*t33*(-2.70283
     1         5295590768d-1*t103*t12*t18*t34*t35*t41*t99+5.405670591181
     2         536d-1*t101*t12*t18*t34*t35*t40*t99-2.1622682364726142d-1
     3         *t103*t12*t17*t34*t35*t40*t99+3.2434023547089214d-1*t101*
     4         t12*t17*t34*t35*t39*t99-1.6217011773544607d-1*t103*t12*t1
     5         6*t34*t35*t39*t99+1.6217011773544607d-1*t101*t12*t16*t34*
     6         t35*t38*t99-1.0811341182363071d-1*t103*t12*t15*t34*t35*t3
     7         8*t99+5.405670591181535d-2*t101*t12*t15*t34*t35*t99-5.405
     8         670591181535d-2*t10*t103*t12*t34*t35*t99+5.0d+0*t18*t273*
     9         t41*t65+4.0d+0*t17*t273*t40*t65+3.0d+0*t16*t273*t39*t65+2
     :         .0d+0*t15*t273*t38*t65+1.0d+0*t10*t273*t65+1.351417647795
     ;         384d-1*t12*t120*t23*t34*t35*t42*t46-5.0d+0*t23*t309*t42*t
     <         46+1.0811341182363071d-1*t12*t120*t22*t34*t35*t42*t45-4.0
     =         d+0*t22*t309*t42*t45-5.405670591181536d-1*t113*t12*t120*t
     >         23*t34*t35*t45+8.108505886772304d-2*t12*t120*t21*t34*t35*
     ?         t42*t44-3.0d+0*t21*t309*t42*t44-3.2434023547089214d-1*t11
     @         3*t12*t120*t22*t34*t35*t44+5.405670591181535d-2*t12*t120*
     1         t19*t34*t35*t42*t43-2.0d+0*t19*t309*t42*t43-1.62170117735
     2         44607d-1*t113*t12*t120*t21*t34*t35*t43+2.7028352955907675
     3         d-2*t12*t120*t24*t34*t35*t42-t24*t309*t42-5.4056705911815
     4         35d-2*t113*t12*t120*t19*t34*t35+t318+t317+t316+t315+t314+
     5         t313+t312+t311+t310+t306+t305+t304+t303+t302+t301+t300+t2
     6         99+t298+t297+t296+t295+t294+t293+t292+t291+t290+t289+t288
     7         +t287+t286+t285+t284+t283+t282+t281+t280+t279+t278+t277+t
     8         276+t275+t274)*wght+2.0d+0*rhoa*t136*t88*wght+t270+t269+t
     9         268+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t267+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = -1.243628d-1*rhoa*t32*t33*(5.0d+0*t
     1         18*t319*t41*t65+4.0d+0*t17*t319*t40*t65+3.0d+0*t16*t319*t
     2         39*t65+2.0d+0*t15*t319*t38*t65+1.0d+0*t10*t319*t65+6.7570
     3         8823897692d-2*t12*t129*t23*t34*t35*t42*t46-5.0d+0*t23*t32
     4         0*t42*t46+5.405670591181535d-2*t12*t129*t22*t34*t35*t42*t
     5         45-4.0d+0*t22*t320*t42*t45-2.702835295590768d-1*t113*t12*
     6         t129*t23*t34*t35*t45+4.054252943386152d-2*t12*t129*t21*t3
     7         4*t35*t42*t44-3.0d+0*t21*t320*t42*t44-1.6217011773544607d
     8         -1*t113*t12*t129*t22*t34*t35*t44+2.7028352955907675d-2*t1
     9         2*t129*t19*t34*t35*t42*t43-2.0d+0*t19*t320*t42*t43-8.1085
     :         05886772304d-2*t113*t12*t129*t21*t34*t35*t43+1.3514176477
     ;         953838d-2*t12*t129*t24*t34*t35*t42-t24*t320*t42-1.3514176
     <         47795384d-1*t103*t12*t128*t18*t34*t35*t41+2.7028352955907
     =         68d-1*t101*t12*t128*t18*t34*t35*t40-1.0811341182363071d-1
     >         *t103*t12*t128*t17*t34*t35*t40+1.6217011773544607d-1*t101
     ?         *t12*t128*t17*t34*t35*t39-8.108505886772304d-2*t103*t12*t
     @         128*t16*t34*t35*t39+8.108505886772304d-2*t101*t12*t128*t1
     1         6*t34*t35*t38-5.405670591181535d-2*t103*t12*t128*t15*t34*
     2         t35*t38-2.7028352955907675d-2*t113*t12*t129*t19*t34*t35+2
     3         .7028352955907675d-2*t101*t12*t128*t15*t34*t35-2.70283529
     4         55907675d-2*t10*t103*t12*t128*t34*t35+t266+t265+t264+t263
     5         +t262+t261+t260+t259+t258+t254+t253+t252+t251+t250+t249+t
     6         248+t247+t246+t245+t244+t243+t242+t241+t240+t239+t238+t23
     7         7+t236+t235+t234+t233+t232+t231+t230+t229+t228+t227+t226+
     8         t225+t224+t223+t222)*wght+2.0d+0*rhoa*t127*t131*wght+t218
     9         +t217+t216+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = -1.243628d-1*rhoa*t32*t33*(5.0d+0*t
     1         18*t321*t41*t65+4.0d+0*t17*t321*t40*t65+3.0d+0*t16*t321*t
     2         39*t65+2.0d+0*t15*t321*t38*t65+1.0d+0*t10*t321*t65+1.3514
     3         17647795384d-1*t12*t129*t23*t34*t35*t42*t46-5.0d+0*t23*t3
     4         22*t42*t46+1.0811341182363071d-1*t12*t129*t22*t34*t35*t42
     5         *t45-4.0d+0*t22*t322*t42*t45-5.405670591181536d-1*t113*t1
     6         2*t129*t23*t34*t35*t45+8.108505886772304d-2*t12*t129*t21*
     7         t34*t35*t42*t44-3.0d+0*t21*t322*t42*t44-3.243402354708921
     8         4d-1*t113*t12*t129*t22*t34*t35*t44+5.405670591181535d-2*t
     9         12*t129*t19*t34*t35*t42*t43-2.0d+0*t19*t322*t42*t43-1.621
     :         7011773544607d-1*t113*t12*t129*t21*t34*t35*t43+2.70283529
     ;         55907675d-2*t12*t129*t24*t34*t35*t42-t24*t322*t42-2.70283
     <         5295590768d-1*t103*t12*t128*t18*t34*t35*t41+5.40567059118
     =         1536d-1*t101*t12*t128*t18*t34*t35*t40-2.1622682364726142d
     >         -1*t103*t12*t128*t17*t34*t35*t40+3.2434023547089214d-1*t1
     ?         01*t12*t128*t17*t34*t35*t39-1.6217011773544607d-1*t103*t1
     @         2*t128*t16*t34*t35*t39+1.6217011773544607d-1*t101*t12*t12
     1         8*t16*t34*t35*t38-1.0811341182363071d-1*t103*t12*t128*t15
     2         *t34*t35*t38-5.405670591181535d-2*t113*t12*t129*t19*t34*t
     3         35+5.405670591181535d-2*t101*t12*t128*t15*t34*t35-5.40567
     4         0591181535d-2*t10*t103*t12*t128*t34*t35+t318+t317+t316+t3
     5         15+t314+t313+t312+t311+t310+t306+t305+t304+t303+t302+t301
     6         +t300+t299+t298+t297+t296+t295+t294+t293+t292+t291+t290+t
     7         289+t288+t287+t286+t285+t284+t283+t282+t281+t280+t279+t27
     8         8+t277+t276+t275+t274)*wght+2.0d+0*rhoa*t127*t136*wght+t2
     9         70+t269+t268+Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = t342+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t344+Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t342+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = -1.243628d-1*rhoa*t32*t33*(-3.6526
     1         59317545616d-3*t23*t42*t46*t62*t63*t66*t92-2.922127454036
     2         493d-3*t22*t42*t45*t62*t63*t66*t92+4.3831911810547386d-2*
     3         t113*t23*t45*t62*t63*t66*t92-2.1915955905273699d-3*t21*t4
     4         2*t44*t62*t63*t66*t92-4.3831911810547386d-2*t191*t23*t44*
     5         t62*t63*t66*t92+2.6299147086328434d-2*t113*t22*t44*t62*t6
     6         3*t66*t92-1.4610637270182464d-3*t19*t42*t43*t62*t63*t66*t
     7         92-1.7532764724218958d-2*t191*t22*t43*t62*t63*t66*t92+1.3
     8         149573543164217d-2*t113*t21*t43*t62*t63*t66*t92-7.3053186
     9         35091232d-4*t24*t42*t62*t63*t66*t92-4.3831911810547397d-3
     :         *t191*t21*t62*t63*t66*t92+4.3831911810547397d-3*t113*t19*
     ;         t62*t63*t66*t92+2.1915955905273693d-2*t101*t18*t41*t62*t6
     <         3*t64*t92-8.766382362109477d-2*t178*t18*t40*t62*t63*t64*t
     =         92+1.7532764724218958d-2*t101*t17*t40*t62*t63*t64*t92+4.3
     >         831911810547386d-2*t176*t18*t39*t62*t63*t64*t92-5.2598294
     ?         17265687d-2*t17*t178*t39*t62*t63*t64*t92+1.31495735431642
     @         17d-2*t101*t16*t39*t62*t63*t64*t92-2.6299147086328434d-2*
     1         t16*t178*t38*t62*t63*t64*t92+1.7532764724218958d-2*t17*t1
     2         76*t38*t62*t63*t64*t92+8.766382362109479d-3*t101*t15*t38*
     3         t62*t63*t64*t92-8.766382362109479d-3*t15*t178*t62*t63*t64
     4         *t92+4.3831911810547397d-3*t16*t176*t62*t63*t64*t92+4.383
     5         1911810547397d-3*t10*t101*t62*t63*t64*t92+2.7028352955907
     6         68d-1*t12*t138*t23*t34*t35*t42*t46+2.1622682364726142d-1*
     7         t12*t138*t22*t34*t35*t42*t45-1.0811341182363073d+0*t113*t
     8         12*t138*t23*t34*t35*t45+1.6217011773544607d-1*t12*t138*t2
     9         1*t34*t35*t42*t44-6.486804709417843d-1*t113*t12*t138*t22*
     :         t34*t35*t44+1.0811341182363071d-1*t12*t138*t19*t34*t35*t4
     ;         2*t43-3.2434023547089214d-1*t113*t12*t138*t21*t34*t35*t43
     <         +5.405670591181535d-2*t12*t138*t24*t34*t35*t42-5.40567059
     =         1181536d-1*t103*t12*t137*t18*t34*t35*t41+1.08113411823630
     >         73d+0*t101*t12*t137*t18*t34*t35*t40-4.3245364729452285d-1
     ?         *t103*t12*t137*t17*t34*t35*t40+6.486804709417843d-1*t101*
     @         t12*t137*t17*t34*t35*t39-3.2434023547089214d-1*t103*t12*t
     1         137*t16*t34*t35*t39+3.2434023547089214d-1*t101*t12*t137*t
     2         16*t34*t35*t38-2.1622682364726142d-1*t103*t12*t137*t15*t3
     3         4*t35*t38-1.0811341182363071d-1*t113*t12*t138*t19*t34*t35
     4         +1.0811341182363071d-1*t101*t12*t137*t15*t34*t35-1.081134
     5         1182363071d-1*t10*t103*t12*t137*t34*t35)*wght+2.0d+0*rhoa
     6         *t345*t59*wght-6.21814d-2*t32*t33*t345*wght+Cmat3(iq,D3_R
     7         A_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t344+Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t342+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t347+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t348+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t347+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)-1.243628
     1         d-1*rhoa*t32*t33*(-3.496766261587081d-3*t101*t346*t68*t95
     2         *t97-7.977672241861109d-1*t12*t34*t35*(-6.187604746674586
     3         d-5*t23*t42*t46*t62*t63*t92-4.95008379733967d-5*t22*t42*t
     4         45*t62*t63*t92+7.425125696009504d-4*t113*t23*t45*t62*t63*
     5         t92-3.712562848004752d-5*t21*t42*t44*t62*t63*t92-7.425125
     6         696009504d-4*t191*t23*t44*t62*t63*t92+4.455075417605703d-
     7         4*t113*t22*t44*t62*t63*t92-2.475041898669835d-5*t19*t42*t
     8         43*t62*t63*t92-2.9700502784038013d-4*t191*t22*t43*t62*t63
     9         *t92+2.2275377088028514d-4*t113*t21*t43*t62*t63*t92-1.237
     :         5209493349175d-5*t24*t42*t62*t63*t92-7.425125696009504d-5
     ;         *t191*t21*t62*t63*t92+7.425125696009504d-5*t113*t19*t62*t
     <         63*t92)-7.977672241861109d-1*t12*t34*t35*t65*(4.950083797
     =         3396694d-4*t103*t18*t40*t62*t63*t92-7.425125696009504d-4*
     >         t101*t18*t39*t62*t63*t92+2.9700502784038013d-4*t103*t17*t
     ?         39*t62*t63*t92-2.9700502784038013d-4*t101*t17*t38*t62*t63
     @         *t92+1.4850251392019007d-4*t103*t16*t38*t62*t63*t92-7.425
     1         125696009504d-5*t101*t16*t62*t63*t92+4.95008379733967d-5*
     2         t103*t15*t62*t63*t92)+8.624933644782772d-2*t103*t142*t62*
     3         t63*t92)*wght
            Cmat3(iq,D3_GAA_GAB_GBB) = t348+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)-1.243628
     1         d-1*rhoa*t32*t33*(-3.496766261587081d-3*t101*t346*t69*t95
     2         *t97-7.977672241861109d-1*t12*t34*t35*(-1.237520949334917
     3         4d-4*t23*t42*t46*t62*t63*t92-9.90016759467934d-5*t22*t42*
     4         t45*t62*t63*t92+1.4850251392019007d-3*t113*t23*t45*t62*t6
     5         3*t92-7.425125696009504d-5*t21*t42*t44*t62*t63*t92-1.4850
     6         251392019007d-3*t191*t23*t44*t62*t63*t92+8.91015083521140
     7         6d-4*t113*t22*t44*t62*t63*t92-4.95008379733967d-5*t19*t42
     8         *t43*t62*t63*t92-5.940100556807603d-4*t191*t22*t43*t62*t6
     9         3*t92+4.455075417605703d-4*t113*t21*t43*t62*t63*t92-2.475
     :         041898669835d-5*t24*t42*t62*t63*t92-1.4850251392019007d-4
     ;         *t191*t21*t62*t63*t92+1.4850251392019007d-4*t113*t19*t62*
     <         t63*t92)-7.977672241861109d-1*t12*t34*t35*t65*(9.90016759
     =         4679339d-4*t103*t18*t40*t62*t63*t92-1.4850251392019007d-3
     >         *t101*t18*t39*t62*t63*t92+5.940100556807603d-4*t103*t17*t
     ?         39*t62*t63*t92-5.940100556807603d-4*t101*t17*t38*t62*t63*
     @         t92+2.9700502784038013d-4*t103*t16*t38*t62*t63*t92-1.4850
     1         251392019007d-4*t101*t16*t62*t63*t92+9.90016759467934d-5*
     2         t103*t15*t62*t63*t92)+8.624933644782772d-2*t103*t143*t62*
     3         t63*t92)*wght
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = 1/t1**3.333333333333333d-1
            t3 = 1.3256889990520176d-1*t2+1.0d+0
            t4 = rhoa-rhob
            t5 = t4**4
            t6 = 1/t1**4
            t7 = 1/t1
            t8 = 1.0d+0-t4*t7
            t9 = t4*t7+1.0d+0
            t10 = t9**1.3333333333333333d+0+t8**1.3333333333333333d+0-2.
     1         0d+0
            t11 = -1.923661050931536d+0*t10*t5*t6
            t12 = t11+1.0d+0
            t13 = 1/t1**6.666666666666666d-1
            t14 = t1**5.0d-1
            t15 = 1/t14
            t16 = 1/t1**1.6666666666666666d-1
            t17 = 2.2255694211506874d+0*t2+5.982550435771079d+0*t16+8.00
     1         4286349993635d-1*t15+1.8970043257475583d-1*t13
            t18 = 1.6081979498692536d+1/t17+1.0d+0
            t19 = log(t18)
            t20 = 6.901399211255825d-2*t2+1.0d+0
            t21 = t11+1.923661050931536d+0*t10
            t22 = 2.247591863577616d+0*t2+8.157414703487641d+0*t16+4.300
     1         9724712766434d-1*t15+1.9115125951273373d-1*t13
            t23 = 2.9608813203268075d+1/t22+1.0d+0
            t24 = log(t23)
            t25 = 1.274696188700087d-1*t2+1.0d+0
            t26 = 3.8447462374472113d+0*t2+1.1120374863094686d+1*t16+1.6
     1         44733775567609d+0*t15+2.4058712912881916d-1*t13
            t27 = 3.216395899738507d+1/t26+1.0d+0
            t28 = log(t27)
            t29 = -5.980796863619711d-2*t10*t25*t28*t5*t6-6.21814d-2*t12
     1         *t19*t3+1.9751631321680768d-2*t20*t21*t24
            t30 = param(9)
            t31 = gammabb+2.0d+0*gammaab+gammaaa
            t32 = t9**6.666666666666667d-1+t8**6.666666666666667d-1
            t33 = t32**3
            t34 = t1**1.1666666666666667d+0
            t35 = t32*t34
            t36 = 1/t35**2.0d+0
            t37 = 1/t29
            t38 = exp(2.1174999530315877d-3*t31*t33*t36*t37)
            t39 = 1.0d+0-t38
            t40 = t39**2.0d+0
            t41 = param(10)
            t42 = t39**3.0d+0
            t43 = param(11)
            t44 = t39**4.0d+0
            t45 = param(12)
            t46 = param(8)
            t47 = param(2)
            t48 = 1.0d+0-2.1174999530315877d-3*t31*t33*t36*t37
            t49 = 1.0d+0-1.0d+0/t48
            t50 = param(3)
            t51 = t49**2.0d+0
            t52 = param(4)
            t53 = t49**3.0d+0
            t54 = param(5)
            t55 = t49**4.0d+0
            t56 = param(6)
            t57 = t49**5.0d+0*t56+t54*t55+t52*t53+t50*t51+t47*t49+t39*t4
     1         6+t39**5.0d+0*t45+t43*t44+t41*t42+t30*t40+param(7)+param(
     2         1)
            t58 = 1/t1**1.6666666666666669d+0
            t59 = 1/t14**3
            t60 = 1/t1**1.3333333333333333d+0
            t61 = 1/t1**1.1666666666666667d+0
            t62 = -9.970917392951799d-1*t61-7.418564737168958d-1*t60-4.0
     1         02143174996817d-1*t59-1.264669550498372d-1*t58
            t63 = 1/t17**2
            t64 = 1/t18
            t65 = 1.0d+0*t12*t3*t62*t63*t64
            t66 = -1.3595691172479402d+0*t61-7.491972878592053d-1*t60-2.
     1         1504862356383217d-1*t59-1.2743417300848914d-1*t58
            t67 = 1/t22**2
            t68 = 1/t23
            t69 = -5.848223622634647d-1*t20*t21*t66*t67*t68
            t70 = -1.8533958105157808d+0*t61-1.2815820791490704d+0*t60-8
     1         .223668877838045d-1*t59-1.6039141941921276d-1*t58
            t71 = 1/t26**2
            t72 = 1/t27
            t73 = 1.923661050931536d+0*t10*t25*t5*t6*t70*t71*t72
            t74 = 1/t1**2
            t75 = t4*t74
            t76 = -t7
            t77 = t76+t75
            t78 = t8**3.333333333333333d-1
            t79 = -t4*t74
            t80 = t79+t7
            t81 = t9**3.333333333333333d-1
            t82 = 1.3333333333333333d+0*t80*t81+1.3333333333333333d+0*t7
     1         7*t78
            t83 = -1.923661050931536d+0*t5*t6*t82
            t84 = 1/t1**5
            t85 = 7.694644203726144d+0*t10*t5*t84
            t86 = t4**3
            t87 = -7.694644203726144d+0*t10*t6*t86
            t88 = t87+t85+t83
            t89 = 2.747773264188437d-3*t12*t19*t60
            t90 = t87+t85+t83+1.923661050931536d+0*t82
            t91 = -4.5437964274821163d-4*t21*t24*t60
            t92 = 1/t1**5.333333333333333d+0
            t93 = 2.541232989148493d-3*t10*t28*t5*t92
            t94 = 2.3923187454478842d-1*t10*t25*t28*t5*t84
            t95 = t94+t93+t91+1.9751631321680768d-2*t20*t24*t90+t89-6.21
     1         814d-2*t19*t3*t88-2.3923187454478842d-1*t10*t25*t28*t6*t8
     2         6-5.980796863619711d-2*t25*t28*t5*t6*t82+t73+t69+t65
            t96 = 1/t29**2
            t97 = 1/t35**3.0d+0
            t98 = 1/t8**3.3333333333333326d-1
            t99 = 1/t9**3.3333333333333326d-1
            t100 = 6.666666666666667d-1*t80*t99+6.666666666666667d-1*t77
     1         *t98
            t101 = t1**1.6666666666666674d-1
            t102 = 1.1666666666666667d+0*t101*t32
            t103 = t100*t34+t102
            t104 = t32**2
            t105 = -4.2349999060631754d-3*t103*t31*t33*t37*t97-2.1174999
     1         530315877d-3*t31*t33*t36*t95*t96+6.352499859094763d-3*t10
     2         0*t104*t31*t36*t37
            t106 = 4.2349999060631754d-3*t103*t31*t33*t37*t97+2.11749995
     1         30315877d-3*t31*t33*t36*t95*t96-6.352499859094763d-3*t100
     2         *t104*t31*t36*t37
            t107 = 1/t48**2
            t108 = 5.0d+0*t106*t107*t55*t56+4.0d+0*t106*t107*t53*t54+3.0
     1         d+0*t106*t107*t51*t52+2.0d+0*t106*t107*t49*t50+1.0d+0*t10
     2         6*t107*t47-t105*t38*t46-5.0d+0*t105*t38*t44*t45-4.0d+0*t1
     3         05*t38*t42*t43-3.0d+0*t105*t38*t40*t41-2.0d+0*t105*t30*t3
     4         8*t39
            t109 = 1.0d+0*t29*t57*wght
            t110 = t75+t7
            t111 = t79+t76
            t112 = 1.3333333333333333d+0*t111*t81+1.3333333333333333d+0*
     1         t110*t78
            t113 = -1.923661050931536d+0*t112*t5*t6
            t114 = 7.694644203726144d+0*t10*t6*t86
            t115 = t85+t114+t113
            t116 = t85+t114+t113+1.923661050931536d+0*t112
            t117 = t94+t93+t91+t89+2.3923187454478842d-1*t10*t25*t28*t6*
     1         t86+t73+t69+t65-5.980796863619711d-2*t112*t25*t28*t5*t6-6
     2         .21814d-2*t115*t19*t3+1.9751631321680768d-2*t116*t20*t24
            t118 = 6.666666666666667d-1*t111*t99+6.666666666666667d-1*t1
     1         10*t98
            t119 = t118*t34+t102
            t120 = -4.2349999060631754d-3*t119*t31*t33*t37*t97-2.1174999
     1         530315877d-3*t117*t31*t33*t36*t96+6.352499859094763d-3*t1
     2         04*t118*t31*t36*t37
            t121 = 4.2349999060631754d-3*t119*t31*t33*t37*t97+2.11749995
     1         30315877d-3*t117*t31*t33*t36*t96-6.352499859094763d-3*t10
     2         4*t118*t31*t36*t37
            t122 = 5.0d+0*t107*t121*t55*t56+4.0d+0*t107*t121*t53*t54+3.0
     1         d+0*t107*t121*t51*t52+2.0d+0*t107*t121*t49*t50+1.0d+0*t10
     2         7*t121*t47-t120*t38*t46-5.0d+0*t120*t38*t44*t45-4.0d+0*t1
     3         20*t38*t42*t43-3.0d+0*t120*t38*t40*t41-2.0d+0*t120*t30*t3
     4         8*t39
            t123 = -1.0587499765157939d-2*t33*t55*t56-8.469999812126351d
     1         -3*t33*t53*t54-6.352499859094763d-3*t33*t51*t52-4.2349999
     2         060631754d-3*t33*t49*t50-2.1174999530315877d-3*t33*t47
            t124 = 1.0d+0*t1*t29*(t36*t37*(-2.1174999530315877d-3*t33*t3
     1         8*t46-1.0587499765157939d-2*t33*t38*t44*t45-8.46999981212
     2         6351d-3*t33*t38*t42*t43-6.352499859094763d-3*t33*t38*t40*
     3         t41-4.2349999060631754d-3*t30*t33*t38*t39)+t107*t123*t36*
     4         t37)*wght
            t125 = -2.1174999530315877d-2*t33*t55*t56-1.6939999624252702
     1         d-2*t33*t53*t54-1.2704999718189527d-2*t33*t51*t52-8.46999
     2         9812126351d-3*t33*t49*t50-4.2349999060631754d-3*t33*t47
            t126 = t95**2
            t127 = 1/t29**3
            t128 = t62**2
            t129 = 1/t17**4
            t130 = 1/t18**2
            t131 = 1.6081979498692536d+1*t12*t128*t129*t130*t3
            t132 = 1/t17**3
            t133 = -2.0d+0*t12*t128*t132*t3*t64
            t134 = -8.837926660346784d-2*t12*t60*t62*t63*t64
            t135 = 1/t1**2.6666666666666666d+0
            t136 = 1/t14**5
            t137 = 1/t1**2.3333333333333334d+0
            t138 = 1/t1**2.1666666666666665d+0
            t139 = 1.1632736958443765d+0*t138+9.89141964955861d-1*t137+6
     1         .003214762495226d-1*t136+2.1077825841639536d-1*t135
            t140 = 1.0d+0*t12*t139*t3*t63*t64
            t141 = t66**2
            t142 = 1/t22**4
            t143 = 1/t23**2
            t144 = -1.73158960813529d+1*t141*t142*t143*t20*t21
            t145 = 1/t22**3
            t146 = 1.1696447245269295d+0*t141*t145*t20*t21*t68
            t147 = 2.690728393099896d-2*t21*t60*t66*t67*t68
            t148 = 1.5861639701225969d+0*t138+9.98929717145607d-1*t137+3
     1         .2257293534574827d-1*t136+2.1239028834748191d-1*t135
            t149 = -5.848223622634647d-1*t148*t20*t21*t67*t68
            t150 = t70**2
            t151 = 1/t26**4
            t152 = 1/t27**2
            t153 = 6.187255516702861d+1*t10*t150*t151*t152*t25*t5*t6
            t154 = 1/t26**3
            t155 = -3.847322101863072d+0*t10*t150*t154*t25*t5*t6*t72
            t156 = -1.6347222733154887d-1*t10*t5*t70*t71*t72*t92
            t157 = 2.1622951122684114d+0*t138+1.7087761055320938d+0*t137
     1         +1.2335503316757068d+0*t136+2.673190323653546d-1*t135
            t158 = 1.923661050931536d+0*t10*t157*t25*t5*t6*t71*t72
            t159 = -1.538928840745229d+1*t10*t25*t5*t70*t71*t72*t84
            t160 = t77**2
            t161 = 1/t8**6.666666666666666d-1
            t162 = 1/t1**3
            t163 = -2*t162*t4
            t164 = 2*t74
            t165 = t164+t163
            t166 = t80**2
            t167 = 1/t9**6.666666666666666d-1
            t168 = 2*t162*t4
            t169 = -2*t74
            t170 = t169+t168
            t171 = 1.3333333333333333d+0*t170*t81+1.3333333333333333d+0*
     1         t165*t78+4.444444444444444d-1*t166*t167+4.444444444444444
     2         d-1*t160*t161
            t172 = -1.923661050931536d+0*t171*t5*t6
            t173 = 1.5389288407452287d+1*t5*t82*t84
            t174 = -1.5389288407452287d+1*t6*t82*t86
            t175 = 1/t1**6
            t176 = -3.8473221018630716d+1*t10*t175*t5
            t177 = 6.155715362980915d+1*t10*t84*t86
            t178 = t4**2
            t179 = -2.3083932611178434d+1*t10*t178*t6
            t180 = t179+t177+t176+t174+t173+t172
            t181 = -3.663697685584583d-3*t12*t137*t19
            t182 = t179+t177+t176+t174+t173+t172+1.923661050931536d+0*t1
     1         71
            t183 = 6.058395236642822d-4*t137*t21*t24
            t184 = 1/t1**6.333333333333333d+0
            t185 = -2.3718174565385935d-2*t10*t184*t28*t5
            t186 = -1.1961593727239421d+0*t10*t175*t25*t28*t5
            t187 = -7.176956236343652d-1*t10*t178*t25*t28*t6
            t188 = 2.0329863913187946d-2*t10*t28*t86*t92+5.0824659782969
     1         86d-3*t28*t5*t82*t92-1.1696447245269295d+0*t20*t66*t67*t6
     2         8*t90-9.087592854964233d-4*t24*t60*t90+2.0d+0*t3*t62*t63*
     3         t64*t88+5.495546528376875d-3*t19*t60*t88+1.91385499635830
     4         74d+0*t10*t25*t28*t84*t86-4.7846374908957684d-1*t25*t28*t
     5         6*t82*t86+1.538928840745229d+1*t10*t25*t6*t70*t71*t72*t86
     6         +4.7846374908957684d-1*t25*t28*t5*t82*t84+3.8473221018630
     7         72d+0*t25*t5*t6*t70*t71*t72*t82-5.980796863619711d-2*t171
     8         *t25*t28*t5*t6-6.21814d-2*t180*t19*t3+1.9751631321680768d
     9         -2*t182*t20*t24+t187+t186+t185+t183+t181+t159+t158+t156+t
     :         155+t153+t149+t147+t146+t144+t140+t134+t133+t131
            t189 = 1/t8**1.3333333333333333d+0
            t190 = 1/t9**1.3333333333333333d+0
            t191 = 6.666666666666667d-1*t170*t99+6.666666666666667d-1*t1
     1         65*t98-2.222222222222222d-1*t166*t190-2.222222222222222d-
     2         1*t160*t189
            t192 = 1/t1**8.333333333333333d-1
            t193 = 1.9444444444444453d-1*t192*t32
            t194 = t191*t34+t193+2.3333333333333334d+0*t100*t101
            t195 = t100**2
            t196 = 1/t35**4.0d+0
            t197 = t103**2
            t198 = -8.469999812126351d-3*t103*t31*t33*t95*t96*t97+4.2349
     1         999060631754d-3*t194*t31*t33*t37*t97+2.5409999436379055d-
     2         2*t100*t103*t104*t31*t37*t97+1.2704999718189527d-2*t100*t
     3         104*t31*t36*t95*t96+2.1174999530315877d-3*t188*t31*t33*t3
     4         6*t96-1.2704999718189527d-2*t195*t31*t32*t36*t37-6.352499
     5         859094763d-3*t104*t191*t31*t36*t37-1.2704999718189527d-2*
     6         t196*t197*t31*t33*t37-4.2349999060631754d-3*t126*t127*t31
     7         *t33*t36
            t199 = 8.469999812126351d-3*t103*t31*t33*t95*t96*t97-4.23499
     1         99060631754d-3*t194*t31*t33*t37*t97-2.5409999436379055d-2
     2         *t100*t103*t104*t31*t37*t97-1.2704999718189527d-2*t100*t1
     3         04*t31*t36*t95*t96-2.1174999530315877d-3*t188*t31*t33*t36
     4         *t96+1.2704999718189527d-2*t195*t31*t32*t36*t37+6.3524998
     5         59094763d-3*t104*t191*t31*t36*t37+1.2704999718189527d-2*t
     6         196*t197*t31*t33*t37+4.2349999060631754d-3*t126*t127*t31*
     7         t33*t36
            t200 = t105**2
            t201 = exp(4.2349999060631754d-3*t31*t33*t36*t37)
            t202 = t106**2
            t203 = 1/t48**4
            t204 = 1/t48**3
            t205 = -1.0d+1*t202*t204*t55*t56+5.0d+0*t107*t198*t55*t56+2.
     1         0d+1*t202*t203*t53*t56-8.0d+0*t202*t204*t53*t54+4.0d+0*t1
     2         07*t198*t53*t54+1.2d+1*t202*t203*t51*t54-6.0d+0*t202*t204
     3         *t51*t52+3.0d+0*t107*t198*t51*t52+6.0d+0*t202*t203*t49*t5
     4         2-4.0d+0*t202*t204*t49*t50+2.0d+0*t107*t198*t49*t50+2.0d+
     5         0*t202*t203*t50-2.0d+0*t202*t204*t47+1.0d+0*t107*t198*t47
     6         -t200*t38*t46-t199*t38*t46-5.0d+0*t200*t38*t44*t45-5.0d+0
     7         *t199*t38*t44*t45+2.0d+1*t200*t201*t42*t45-4.0d+0*t200*t3
     8         8*t42*t43-4.0d+0*t199*t38*t42*t43+1.2d+1*t200*t201*t40*t4
     9         3-3.0d+0*t200*t38*t40*t41-3.0d+0*t199*t38*t40*t41+6.0d+0*
     :         t200*t201*t39*t41-2.0d+0*t200*t30*t38*t39-2.0d+0*t199*t30
     ;         *t38*t39+2.0d+0*t200*t201*t30
            t206 = 2.6666666666666666d+0*t162*t4*t81+4.444444444444444d-
     1         1*t111*t167*t80-2.6666666666666666d+0*t162*t4*t78+4.44444
     2         4444444444d-1*t110*t161*t77
            t207 = -1.923661050931536d+0*t206*t5*t6
            t208 = 7.694644203726144d+0*t112*t5*t84
            t209 = -7.694644203726144d+0*t112*t6*t86
            t210 = 7.694644203726144d+0*t5*t82*t84
            t211 = 7.694644203726144d+0*t6*t82*t86
            t212 = 2.3083932611178434d+1*t10*t178*t6
            t213 = t212+t211+t210+t209+t208+t207+t176
            t214 = t212+t211+t210+t209+t208+t207+1.923661050931536d+0*t2
     1         06+t176
            t215 = 2.541232989148493d-3*t28*t5*t82*t92+2.541232989148493
     1         d-3*t112*t28*t5*t92-5.848223622634647d-1*t20*t66*t67*t68*
     2         t90-4.5437964274821163d-4*t24*t60*t90+1.0d+0*t3*t62*t63*t
     3         64*t88+2.747773264188437d-3*t19*t60*t88+2.392318745447884
     4         2d-1*t25*t28*t6*t82*t86-2.3923187454478842d-1*t112*t25*t2
     5         8*t6*t86+2.3923187454478842d-1*t25*t28*t5*t82*t84+2.39231
     6         87454478842d-1*t112*t25*t28*t5*t84+1.923661050931536d+0*t
     7         25*t5*t6*t70*t71*t72*t82+1.923661050931536d+0*t112*t25*t5
     8         *t6*t70*t71*t72-5.848223622634647d-1*t116*t20*t66*t67*t68
     9         +1.0d+0*t115*t3*t62*t63*t64-4.5437964274821163d-4*t116*t2
     :         4*t60+2.747773264188437d-3*t115*t19*t60-5.980796863619711
     ;         d-2*t206*t25*t28*t5*t6+7.176956236343652d-1*t10*t178*t25*
     <         t28*t6-6.21814d-2*t19*t213*t3+1.9751631321680768d-2*t20*t
     =         214*t24+t186+t185+t183+t181+t159+t158+t156+t155+t153+t149
     >         +t147+t146+t144+t140+t134+t133+t131
            t216 = 1.3333333333333336d+0*t162*t4*t99-1.3333333333333336d
     1         +0*t162*t4*t98-2.222222222222222d-1*t111*t190*t80-2.22222
     2         2222222222d-1*t110*t189*t77
            t217 = t216*t34+t193+1.1666666666666667d+0*t101*t118+1.16666
     1         66666666667d+0*t100*t101
            t218 = 4.2349999060631754d-3*t119*t31*t33*t95*t96*t97+4.2349
     1         999060631754d-3*t103*t117*t31*t33*t96*t97-4.2349999060631
     2         754d-3*t217*t31*t33*t37*t97-1.2704999718189527d-2*t100*t1
     3         04*t119*t31*t37*t97-1.2704999718189527d-2*t103*t104*t118*
     4         t31*t37*t97-6.352499859094763d-3*t104*t118*t31*t36*t95*t9
     5         6-2.1174999530315877d-3*t215*t31*t33*t36*t96-6.3524998590
     6         94763d-3*t100*t104*t117*t31*t36*t96+4.2349999060631754d-3
     7         *t117*t127*t31*t33*t36*t95+1.2704999718189527d-2*t100*t11
     8         8*t31*t32*t36*t37+6.352499859094763d-3*t104*t216*t31*t36*
     9         t37+1.2704999718189527d-2*t103*t119*t196*t31*t33*t37
            t219 = -4.2349999060631754d-3*t119*t31*t33*t95*t96*t97-4.234
     1         9999060631754d-3*t103*t117*t31*t33*t96*t97+4.234999906063
     2         1754d-3*t217*t31*t33*t37*t97+1.2704999718189527d-2*t100*t
     3         104*t119*t31*t37*t97+1.2704999718189527d-2*t103*t104*t118
     4         *t31*t37*t97+6.352499859094763d-3*t104*t118*t31*t36*t95*t
     5         96+2.1174999530315877d-3*t215*t31*t33*t36*t96+6.352499859
     6         094763d-3*t100*t104*t117*t31*t36*t96-4.2349999060631754d-
     7         3*t117*t127*t31*t33*t36*t95-1.2704999718189527d-2*t100*t1
     8         18*t31*t32*t36*t37-6.352499859094763d-3*t104*t216*t31*t36
     9         *t37-1.2704999718189527d-2*t103*t119*t196*t31*t33*t37
            t220 = 5.0d+0*t107*t219*t55*t56-1.0d+1*t106*t121*t204*t55*t5
     1         6+2.0d+1*t106*t121*t203*t53*t56+4.0d+0*t107*t219*t53*t54-
     2         8.0d+0*t106*t121*t204*t53*t54+1.2d+1*t106*t121*t203*t51*t
     3         54+3.0d+0*t107*t219*t51*t52-6.0d+0*t106*t121*t204*t51*t52
     4         +6.0d+0*t106*t121*t203*t49*t52+2.0d+0*t107*t219*t49*t50-4
     5         .0d+0*t106*t121*t204*t49*t50+2.0d+0*t106*t121*t203*t50+1.
     6         0d+0*t107*t219*t47-2.0d+0*t106*t121*t204*t47-t218*t38*t46
     7         -t105*t120*t38*t46-5.0d+0*t218*t38*t44*t45-5.0d+0*t105*t1
     8         20*t38*t44*t45+2.0d+1*t105*t120*t201*t42*t45-4.0d+0*t218*
     9         t38*t42*t43-4.0d+0*t105*t120*t38*t42*t43+1.2d+1*t105*t120
     :         *t201*t40*t43-3.0d+0*t218*t38*t40*t41-3.0d+0*t105*t120*t3
     ;         8*t40*t41+6.0d+0*t105*t120*t201*t39*t41-2.0d+0*t218*t30*t
     <         38*t39-2.0d+0*t105*t120*t30*t38*t39+2.0d+0*t105*t120*t201
     =         *t30
            t221 = t117**2
            t222 = t110**2
            t223 = t169+t163
            t224 = t111**2
            t225 = t168+t164
            t226 = 1.3333333333333333d+0*t225*t81+1.3333333333333333d+0*
     1         t223*t78+4.444444444444444d-1*t167*t224+4.444444444444444
     2         d-1*t161*t222
            t227 = -1.923661050931536d+0*t226*t5*t6
            t228 = 1.5389288407452287d+1*t112*t5*t84
            t229 = 1.5389288407452287d+1*t112*t6*t86
            t230 = -6.155715362980915d+1*t10*t84*t86
            t231 = t230+t229+t228+t227+t179+t176
            t232 = t230+t229+t228+t227+1.923661050931536d+0*t226+t179+t1
     1         76
            t233 = -2.0329863913187946d-2*t10*t28*t86*t92+5.082465978296
     1         986d-3*t112*t28*t5*t92-1.9138549963583074d+0*t10*t25*t28*
     2         t84*t86-1.538928840745229d+1*t10*t25*t6*t70*t71*t72*t86+4
     3         .7846374908957684d-1*t112*t25*t28*t6*t86+4.78463749089576
     4         84d-1*t112*t25*t28*t5*t84+3.847322101863072d+0*t112*t25*t
     5         5*t6*t70*t71*t72-1.1696447245269295d+0*t116*t20*t66*t67*t
     6         68+2.0d+0*t115*t3*t62*t63*t64-9.087592854964233d-4*t116*t
     7         24*t60+5.495546528376875d-3*t115*t19*t60-5.98079686361971
     8         1d-2*t226*t25*t28*t5*t6-6.21814d-2*t19*t231*t3+1.97516313
     9         21680768d-2*t20*t232*t24+t187+t186+t185+t183+t181+t159+t1
     :         58+t156+t155+t153+t149+t147+t146+t144+t140+t134+t133+t131
            t234 = 6.666666666666667d-1*t225*t99+6.666666666666667d-1*t2
     1         23*t98-2.222222222222222d-1*t190*t224-2.222222222222222d-
     2         1*t189*t222
            t235 = t234*t34+t193+2.3333333333333334d+0*t101*t118
            t236 = t118**2
            t237 = t119**2
            t238 = -8.469999812126351d-3*t117*t119*t31*t33*t96*t97+4.234
     1         9999060631754d-3*t235*t31*t33*t37*t97+2.5409999436379055d
     2         -2*t104*t118*t119*t31*t37*t97+2.1174999530315877d-3*t233*
     3         t31*t33*t36*t96+1.2704999718189527d-2*t104*t117*t118*t31*
     4         t36*t96-1.2704999718189527d-2*t236*t31*t32*t36*t37-6.3524
     5         99859094763d-3*t104*t234*t31*t36*t37-1.2704999718189527d-
     6         2*t196*t237*t31*t33*t37-4.2349999060631754d-3*t127*t221*t
     7         31*t33*t36
            t239 = 8.469999812126351d-3*t117*t119*t31*t33*t96*t97-4.2349
     1         999060631754d-3*t235*t31*t33*t37*t97-2.5409999436379055d-
     2         2*t104*t118*t119*t31*t37*t97-2.1174999530315877d-3*t233*t
     3         31*t33*t36*t96-1.2704999718189527d-2*t104*t117*t118*t31*t
     4         36*t96+1.2704999718189527d-2*t236*t31*t32*t36*t37+6.35249
     5         9859094763d-3*t104*t234*t31*t36*t37+1.2704999718189527d-2
     6         *t196*t237*t31*t33*t37+4.2349999060631754d-3*t127*t221*t3
     7         1*t33*t36
            t240 = t120**2
            t241 = t121**2
            t242 = -1.0d+1*t204*t241*t55*t56+5.0d+0*t107*t238*t55*t56+2.
     1         0d+1*t203*t241*t53*t56-8.0d+0*t204*t241*t53*t54+4.0d+0*t1
     2         07*t238*t53*t54+1.2d+1*t203*t241*t51*t54-6.0d+0*t204*t241
     3         *t51*t52+3.0d+0*t107*t238*t51*t52+6.0d+0*t203*t241*t49*t5
     4         2-4.0d+0*t204*t241*t49*t50+2.0d+0*t107*t238*t49*t50+2.0d+
     5         0*t203*t241*t50-2.0d+0*t204*t241*t47+1.0d+0*t107*t238*t47
     6         -t240*t38*t46-t239*t38*t46-5.0d+0*t240*t38*t44*t45-5.0d+0
     7         *t239*t38*t44*t45+2.0d+1*t201*t240*t42*t45-4.0d+0*t240*t3
     8         8*t42*t43-4.0d+0*t239*t38*t42*t43+1.2d+1*t201*t240*t40*t4
     9         3-3.0d+0*t240*t38*t40*t41-3.0d+0*t239*t38*t40*t41+6.0d+0*
     :         t201*t240*t39*t41-2.0d+0*t240*t30*t38*t39-2.0d+0*t239*t30
     ;         *t38*t39+2.0d+0*t201*t240*t30
            t243 = -1.0587499765157939d-2*t107*t33*t36*t37*t55*t56-8.469
     1         999812126351d-3*t107*t33*t36*t37*t53*t54-6.35249985909476
     2         3d-3*t107*t33*t36*t37*t51*t52-4.2349999060631754d-3*t107*
     3         t33*t36*t37*t49*t50-2.1174999530315877d-3*t107*t33*t36*t3
     4         7*t47-2.1174999530315877d-3*t33*t36*t37*t38*t46-1.0587499
     5         765157939d-2*t33*t36*t37*t38*t44*t45-8.469999812126351d-3
     6         *t33*t36*t37*t38*t42*t43-6.352499859094763d-3*t33*t36*t37
     7         *t38*t40*t41-4.2349999060631754d-3*t30*t33*t36*t37*t38*t3
     8         9
            t244 = 1.0d+0*t243*t29*wght
            t245 = -4.2349999060631754d-3*t103*t33*t37*t97-2.11749995303
     1         15877d-3*t33*t36*t95*t96+6.352499859094763d-3*t100*t104*t
     2         36*t37
            t246 = 4.2349999060631754d-3*t103*t33*t37*t97+2.117499953031
     1         5877d-3*t33*t36*t95*t96-6.352499859094763d-3*t100*t104*t3
     2         6*t37
            t247 = 2.1174999530315877d-2*t106*t204*t33*t36*t37*t55*t56+5
     1         .0d+0*t107*t246*t55*t56-4.2349999060631754d-2*t106*t203*t
     2         33*t36*t37*t53*t56+1.6939999624252702d-2*t106*t204*t33*t3
     3         6*t37*t53*t54+4.0d+0*t107*t246*t53*t54-2.5409999436379055
     4         d-2*t106*t203*t33*t36*t37*t51*t54+1.2704999718189527d-2*t
     5         106*t204*t33*t36*t37*t51*t52+3.0d+0*t107*t246*t51*t52-1.2
     6         704999718189527d-2*t106*t203*t33*t36*t37*t49*t52+8.469999
     7         812126351d-3*t106*t204*t33*t36*t37*t49*t50+2.0d+0*t107*t2
     8         46*t49*t50-4.2349999060631754d-3*t106*t203*t33*t36*t37*t5
     9         0+4.2349999060631754d-3*t106*t204*t33*t36*t37*t47+1.0d+0*
     :         t107*t246*t47-2.1174999530315877d-3*t105*t33*t36*t37*t38*
     ;         t46-t245*t38*t46-1.0587499765157939d-2*t105*t33*t36*t37*t
     <         38*t44*t45-5.0d+0*t245*t38*t44*t45+4.2349999060631754d-2*
     =         t105*t201*t33*t36*t37*t42*t45-8.469999812126351d-3*t105*t
     >         33*t36*t37*t38*t42*t43-4.0d+0*t245*t38*t42*t43+2.54099994
     ?         36379055d-2*t105*t201*t33*t36*t37*t40*t43-6.3524998590947
     @         63d-3*t105*t33*t36*t37*t38*t40*t41-3.0d+0*t245*t38*t40*t4
     1         1+1.2704999718189527d-2*t105*t201*t33*t36*t37*t39*t41-4.2
     2         349999060631754d-3*t105*t30*t33*t36*t37*t38*t39-2.0d+0*t2
     3         45*t30*t38*t39+4.2349999060631754d-3*t105*t201*t30*t33*t3
     4         6*t37
            t248 = 1.0d+0*t1*t243*t95*wght+1.0d+0*t1*t247*t29*wght+t244
            t249 = -2.1174999530315877d-2*t107*t33*t36*t37*t55*t56-1.693
     1         9999624252702d-2*t107*t33*t36*t37*t53*t54-1.2704999718189
     2         527d-2*t107*t33*t36*t37*t51*t52-8.469999812126351d-3*t107
     3         *t33*t36*t37*t49*t50-4.2349999060631754d-3*t107*t33*t36*t
     4         37*t47-4.2349999060631754d-3*t33*t36*t37*t38*t46-2.117499
     5         9530315877d-2*t33*t36*t37*t38*t44*t45-1.6939999624252702d
     6         -2*t33*t36*t37*t38*t42*t43-1.2704999718189527d-2*t33*t36*
     7         t37*t38*t40*t41-8.469999812126351d-3*t30*t33*t36*t37*t38*
     8         t39
            t250 = 1.0d+0*t249*t29*wght
            t251 = -8.469999812126351d-3*t103*t33*t37*t97-4.234999906063
     1         1754d-3*t33*t36*t95*t96+1.2704999718189527d-2*t100*t104*t
     2         36*t37
            t252 = 8.469999812126351d-3*t103*t33*t37*t97+4.2349999060631
     1         754d-3*t33*t36*t95*t96-1.2704999718189527d-2*t100*t104*t3
     2         6*t37
            t253 = 4.2349999060631754d-2*t106*t204*t33*t36*t37*t55*t56+5
     1         .0d+0*t107*t252*t55*t56-8.469999812126351d-2*t106*t203*t3
     2         3*t36*t37*t53*t56+3.3879999248505405d-2*t106*t204*t33*t36
     3         *t37*t53*t54+4.0d+0*t107*t252*t53*t54-5.081999887275811d-
     4         2*t106*t203*t33*t36*t37*t51*t54+2.5409999436379055d-2*t10
     5         6*t204*t33*t36*t37*t51*t52+3.0d+0*t107*t252*t51*t52-2.540
     6         9999436379055d-2*t106*t203*t33*t36*t37*t49*t52+1.69399996
     7         24252702d-2*t106*t204*t33*t36*t37*t49*t50+2.0d+0*t107*t25
     8         2*t49*t50-8.469999812126351d-3*t106*t203*t33*t36*t37*t50+
     9         8.469999812126351d-3*t106*t204*t33*t36*t37*t47+1.0d+0*t10
     :         7*t252*t47-4.2349999060631754d-3*t105*t33*t36*t37*t38*t46
     ;         -t251*t38*t46-2.1174999530315877d-2*t105*t33*t36*t37*t38*
     <         t44*t45-5.0d+0*t251*t38*t44*t45+8.469999812126351d-2*t105
     =         *t201*t33*t36*t37*t42*t45-1.6939999624252702d-2*t105*t33*
     >         t36*t37*t38*t42*t43-4.0d+0*t251*t38*t42*t43+5.08199988727
     ?         5811d-2*t105*t201*t33*t36*t37*t40*t43-1.2704999718189527d
     @         -2*t105*t33*t36*t37*t38*t40*t41-3.0d+0*t251*t38*t40*t41+2
     1         .5409999436379055d-2*t105*t201*t33*t36*t37*t39*t41-8.4699
     2         99812126351d-3*t105*t30*t33*t36*t37*t38*t39-2.0d+0*t251*t
     3         30*t38*t39+8.469999812126351d-3*t105*t201*t30*t33*t36*t37
            t254 = -4.2349999060631754d-3*t119*t33*t37*t97-2.11749995303
     1         15877d-3*t117*t33*t36*t96+6.352499859094763d-3*t104*t118*
     2         t36*t37
            t255 = 4.2349999060631754d-3*t119*t33*t37*t97+2.117499953031
     1         5877d-3*t117*t33*t36*t96-6.352499859094763d-3*t104*t118*t
     2         36*t37
            t256 = 2.1174999530315877d-2*t121*t204*t33*t36*t37*t55*t56+5
     1         .0d+0*t107*t255*t55*t56-4.2349999060631754d-2*t121*t203*t
     2         33*t36*t37*t53*t56+1.6939999624252702d-2*t121*t204*t33*t3
     3         6*t37*t53*t54+4.0d+0*t107*t255*t53*t54-2.5409999436379055
     4         d-2*t121*t203*t33*t36*t37*t51*t54+1.2704999718189527d-2*t
     5         121*t204*t33*t36*t37*t51*t52+3.0d+0*t107*t255*t51*t52-1.2
     6         704999718189527d-2*t121*t203*t33*t36*t37*t49*t52+8.469999
     7         812126351d-3*t121*t204*t33*t36*t37*t49*t50+2.0d+0*t107*t2
     8         55*t49*t50-4.2349999060631754d-3*t121*t203*t33*t36*t37*t5
     9         0+4.2349999060631754d-3*t121*t204*t33*t36*t37*t47+1.0d+0*
     :         t107*t255*t47-2.1174999530315877d-3*t120*t33*t36*t37*t38*
     ;         t46-t254*t38*t46-1.0587499765157939d-2*t120*t33*t36*t37*t
     <         38*t44*t45-5.0d+0*t254*t38*t44*t45+4.2349999060631754d-2*
     =         t120*t201*t33*t36*t37*t42*t45-8.469999812126351d-3*t120*t
     >         33*t36*t37*t38*t42*t43-4.0d+0*t254*t38*t42*t43+2.54099994
     ?         36379055d-2*t120*t201*t33*t36*t37*t40*t43-6.3524998590947
     @         63d-3*t120*t33*t36*t37*t38*t40*t41-3.0d+0*t254*t38*t40*t4
     1         1+1.2704999718189527d-2*t120*t201*t33*t36*t37*t39*t41-4.2
     2         349999060631754d-3*t120*t30*t33*t36*t37*t38*t39-2.0d+0*t2
     3         54*t30*t38*t39+4.2349999060631754d-3*t120*t201*t30*t33*t3
     4         6*t37
            t257 = 1.0d+0*t1*t256*t29*wght+1.0d+0*t1*t117*t243*wght+t244
            t258 = -8.469999812126351d-3*t119*t33*t37*t97-4.234999906063
     1         1754d-3*t117*t33*t36*t96+1.2704999718189527d-2*t104*t118*
     2         t36*t37
            t259 = 8.469999812126351d-3*t119*t33*t37*t97+4.2349999060631
     1         754d-3*t117*t33*t36*t96-1.2704999718189527d-2*t104*t118*t
     2         36*t37
            t260 = 4.2349999060631754d-2*t121*t204*t33*t36*t37*t55*t56+5
     1         .0d+0*t107*t259*t55*t56-8.469999812126351d-2*t121*t203*t3
     2         3*t36*t37*t53*t56+3.3879999248505405d-2*t121*t204*t33*t36
     3         *t37*t53*t54+4.0d+0*t107*t259*t53*t54-5.081999887275811d-
     4         2*t121*t203*t33*t36*t37*t51*t54+2.5409999436379055d-2*t12
     5         1*t204*t33*t36*t37*t51*t52+3.0d+0*t107*t259*t51*t52-2.540
     6         9999436379055d-2*t121*t203*t33*t36*t37*t49*t52+1.69399996
     7         24252702d-2*t121*t204*t33*t36*t37*t49*t50+2.0d+0*t107*t25
     8         9*t49*t50-8.469999812126351d-3*t121*t203*t33*t36*t37*t50+
     9         8.469999812126351d-3*t121*t204*t33*t36*t37*t47+1.0d+0*t10
     :         7*t259*t47-4.2349999060631754d-3*t120*t33*t36*t37*t38*t46
     ;         -t258*t38*t46-2.1174999530315877d-2*t120*t33*t36*t37*t38*
     <         t44*t45-5.0d+0*t258*t38*t44*t45+8.469999812126351d-2*t120
     =         *t201*t33*t36*t37*t42*t45-1.6939999624252702d-2*t120*t33*
     >         t36*t37*t38*t42*t43-4.0d+0*t258*t38*t42*t43+5.08199988727
     ?         5811d-2*t120*t201*t33*t36*t37*t40*t43-1.2704999718189527d
     @         -2*t120*t33*t36*t37*t38*t40*t41-3.0d+0*t258*t38*t40*t41+2
     1         .5409999436379055d-2*t120*t201*t33*t36*t37*t39*t41-8.4699
     2         99812126351d-3*t120*t30*t33*t36*t37*t38*t39-2.0d+0*t258*t
     3         30*t38*t39+8.469999812126351d-3*t120*t201*t30*t33*t36*t37
            t261 = t32**6
            t262 = 8.967612102177552d-5*t107*t261*t36*t37*t53*t56+5.3805
     1         67261306531d-5*t107*t261*t36*t37*t51*t54+2.69028363065326
     2         57d-5*t107*t261*t36*t37*t49*t52+8.967612102177553d-6*t107
     3         *t261*t36*t37*t50
            t263 = 1.0d+0*t1*t29*(4.2349999060631754d-3*t123*t196*t204*t
     1         33*t96+t36*t37*(-4.483806051088777d-6*t261*t36*t37*t38*t4
     2         6-2.241903025544388d-5*t261*t36*t37*t38*t44*t45+8.9676121
     3         02177552d-5*t201*t261*t36*t37*t42*t45-1.7935224204355107d
     4         -5*t261*t36*t37*t38*t42*t43+5.380567261306531d-5*t201*t26
     5         1*t36*t37*t40*t43-1.3451418153266329d-5*t261*t36*t37*t38*
     6         t40*t41+2.6902836306532657d-5*t201*t261*t36*t37*t39*t41-8
     7         .967612102177553d-6*t261*t30*t36*t37*t38*t39+8.9676121021
     8         77553d-6*t201*t261*t30*t36*t37)+t107*t262*t36*t37)*wght
            t264 = t36*t37*(-8.967612102177553d-6*t261*t36*t37*t38*t46-4
     1         .483806051088776d-5*t261*t36*t37*t38*t44*t45+1.7935224204
     2         355105d-4*t201*t261*t36*t37*t42*t45-3.5870448408710215d-5
     3         *t261*t36*t37*t38*t42*t43+1.0761134522613064d-4*t201*t261
     4         *t36*t37*t40*t43-2.6902836306532657d-5*t261*t36*t37*t38*t
     5         40*t41+5.380567261306531d-5*t201*t261*t36*t37*t39*t41-1.7
     6         935224204355107d-5*t261*t30*t36*t37*t38*t39+1.79352242043
     7         55107d-5*t201*t261*t30*t36*t37)
            t265 = 1.7935224204355105d-4*t107*t261*t36*t37*t53*t56+1.076
     1         1134522613064d-4*t107*t261*t36*t37*t51*t54+5.380567261306
     2         531d-5*t107*t261*t36*t37*t49*t52+1.7935224204355107d-5*t1
     3         07*t261*t36*t37*t50
            t266 = t107*t265*t36*t37
            t267 = 3.587044840871021d-4*t107*t261*t36*t37*t53*t56+2.1522
     1         269045226128d-4*t107*t261*t36*t37*t51*t54+1.0761134522613
     2         064d-4*t107*t261*t36*t37*t49*t52+3.5870448408710215d-5*t1
     3         07*t261*t36*t37*t50
            t268 = -8.469999812126351d-3*t103*t31*t33*t37*t97-4.23499990
     1         60631754d-3*t31*t33*t36*t95*t96+1.2704999718189527d-2*t10
     2         0*t104*t31*t36*t37
            t269 = t62**3
            t270 = 5.172601291927341d+2*t12*t269*t3/(t17**6*t18**3)
            t271 = -9.649187699215522d+1*t12*t130*t269*t3/t17**5
            t272 = 4.824593849607761d+1*t12*t129*t130*t139*t3*t62
            t273 = -2.1319703304396778d+0*t12*t128*t129*t130*t60
            t274 = 6.0d+0*t12*t129*t269*t3*t64
            t275 = -6.0d+0*t12*t132*t139*t3*t62*t64
            t276 = 2.6513779981040353d-1*t12*t128*t132*t60*t64
            t277 = -1.3256889990520176d-1*t12*t139*t60*t63*t64
            t278 = 1.767585332069357d-1*t12*t137*t62*t63*t64
            t279 = 1/t1**3.6666666666666664d+0
            t280 = 1/t14**7
            t281 = 1/t1**3.3333333333333337d+0
            t282 = 1/t1**3.1666666666666665d+0
            t283 = 1.0d+0*t12*(-2.520426340996149d+0*t282-2.307997918230
     1         3428d+0*t281-1.5008036906238065d+0*t280-5.620753557770543
     2         d-1*t279)*t3*t63*t64
            t284 = t66**3
            t285 = -1.0254062650399592d+3*t20*t21*t284/(t22**6*t23**3)
            t286 = 1.0389537648811739d+2*t143*t20*t21*t284/t22**5
            t287 = -5.19476882440587d+1*t142*t143*t148*t20*t21*t66
            t288 = 1.1950391155803675d+0*t141*t142*t143*t21*t60
            t289 = -3.5089341735807883d+0*t142*t20*t21*t284*t68
            t290 = 3.5089341735807883d+0*t145*t148*t20*t21*t66*t68
            t291 = -8.072185179299687d-2*t141*t145*t21*t60*t68
            t292 = 4.0360925896498434d-2*t148*t21*t60*t67*t68
            t293 = -5.381456786199791d-2*t137*t21*t66*t67*t68
            t294 = -5.848223622634647d-1*t20*t21*(-3.436688601932293d+0*
     1         t282-2.3308360066730832d+0*t281-8.064323383643707d-1*t280
     2         -5.663741022599518d-1*t279)*t67*t68
            t295 = t70**3
            t296 = 3.9801326549115085d+3*t10*t25*t295*t5*t6/(t26**6*t27*
     1         *3)
            t297 = -3.712353310021716d+2*t10*t152*t25*t295*t5*t6/t26**5
            t298 = 1.856176655010858d+2*t10*t151*t152*t157*t25*t5*t6*t70
            t299 = -7.424706620043432d+2*t10*t150*t151*t152*t25*t5*t84
            t300 = -7.886871025654724d+0*t10*t150*t151*t152*t5*t92
            t301 = 1.1541966305589217d+1*t10*t151*t25*t295*t5*t6*t72
            t302 = -1.1541966305589217d+1*t10*t154*t157*t25*t5*t6*t70*t7
     1         2
            t303 = 4.616786522235687d+1*t10*t150*t154*t25*t5*t72*t84
            t304 = 4.904166819946466d-1*t10*t150*t154*t5*t72*t92
            t305 = -2.452083409973233d-1*t10*t157*t5*t71*t72*t92
            t306 = 2.2886111826416838d+0*t10*t184*t5*t70*t71*t72
            t307 = 1.923661050931536d+0*t10*t25*(-4.684972743248224d+0*t
     1         282-3.9871442462415524d+0*t281-3.083875829189267d+0*t280-
     2         7.128507529742789d-1*t279)*t5*t6*t71*t72
            t308 = -2.3083932611178434d+1*t10*t157*t25*t5*t71*t72*t84
            t309 = 1.1541966305589217d+2*t10*t175*t25*t5*t70*t71*t72
            t310 = 6.925179783353531d+1*t10*t178*t25*t6*t70*t71*t72
            t311 = 8.548627933030694d-3*t12*t19*t281
            t312 = t77**3
            t313 = 1/t8**1.6666666666666669d+0
            t314 = 6*t4*t6
            t315 = -6*t162
            t316 = t315+t314
            t317 = t80**3
            t318 = 1/t9**1.6666666666666669d+0
            t319 = -6*t4*t6
            t320 = 6*t162
            t321 = t320+t319
            t322 = 1.3333333333333333d+0*t321*t81+1.3333333333333333d+0*
     1         t167*t170*t80+1.3333333333333333d+0*t316*t78+1.3333333333
     2         333333d+0*t161*t165*t77-2.962962962962963d-1*t317*t318-2.
     3         962962962962963d-1*t312*t313
            t323 = -1.923661050931536d+0*t322*t5*t6
            t324 = 2.3083932611178434d+1*t171*t5*t84
            t325 = -2.3083932611178434d+1*t171*t6*t86
            t326 = -1.1541966305589216d+2*t175*t5*t82
            t327 = 1.8467146088942746d+2*t82*t84*t86
            t328 = -6.925179783353531d+1*t178*t6*t82
            t329 = 1/t1**7
            t330 = 2.3083932611178432d+2*t10*t329*t5
            t331 = -4.6167865222356863d+2*t10*t175*t86
            t332 = 2.770071913341412d+2*t10*t178*t84
            t333 = -4.616786522235687d+1*t10*t4*t6
            t334 = -1.4136255552166585d-3*t21*t24*t281
            t335 = 2.0103976536374746d-1*t10*t28*t5/t1**7.33333333333333
     1         3d+0
            t336 = 9.148438760934575d-2*t10*t178*t28*t92
            t337 = 7.176956236343652d+0*t10*t25*t28*t329*t5
            t338 = 8.612347483612381d+0*t10*t178*t25*t28*t84
            t339 = -1.4353912472687305d+0*t10*t25*t28*t4*t6
            t340 = 6.098959173956384d-2*t28*t82*t86*t92-1.96166672797858
     1         65d+0*t10*t70*t71*t72*t86*t92-4.904166819946466d-1*t5*t70
     2         *t71*t72*t82*t92+7.623698967445479d-3*t171*t28*t5*t92+8.0
     3         72185179299687d-2*t60*t66*t67*t68*t90-1.7544670867903941d
     4         +0*t148*t20*t67*t68*t90+3.5089341735807883d+0*t141*t145*t
     5         20*t68*t90+1.8175185709928465d-3*t137*t24*t90-5.194768824
     6         40587d+1*t141*t142*t143*t20*t90-2.6513779981040353d-1*t60
     7         *t62*t63*t64*t88+3.0d+0*t139*t3*t63*t64*t88-6.0d+0*t128*t
     8         132*t3*t64*t88+4.824593849607761d+1*t128*t129*t130*t3*t88
     9         -1.099109305675375d-2*t137*t19*t88+5.741564989074922d+0*t
     :         25*t28*t82*t84*t86-1.8467146088942746d+2*t10*t25*t70*t71*
     ;         t72*t84*t86+4.616786522235687d+1*t25*t6*t70*t71*t72*t82*t
     <         86+2.3083932611178434d+1*t10*t157*t25*t6*t71*t72*t86-4.61
     =         6786522235687d+1*t10*t150*t154*t25*t6*t72*t86-7.176956236
     >         343652d-1*t171*t25*t28*t6*t86+7.424706620043432d+2*t10*t1
     ?         50*t151*t152*t25*t6*t86-1.4353912472687305d+1*t10*t175*t2
     @         5*t28*t86-2.8461809478463124d-1*t10*t184*t28*t86-4.616786
     1         522235687d+1*t25*t5*t70*t71*t72*t82*t84+7.176956236343652
     2         d-1*t171*t25*t28*t5*t84+5.770983152794609d+0*t157*t25*t5*
     3         t6*t71*t72*t82-1.1541966305589217d+1*t150*t154*t25*t5*t6*
     4         t72*t82+1.856176655010858d+2*t150*t151*t152*t25*t5*t6*t82
     5         -2.1530868709030954d+0*t178*t25*t28*t6*t82-3.588478118171
     6         826d+0*t175*t25*t28*t5*t82-7.11545236961578d-2*t184*t28*t
     7         5*t82+5.770983152794609d+0*t171*t25*t5*t6*t70*t71*t72-1.7
     8         544670867903941d+0*t182*t20*t66*t67*t68+3.0d+0*t180*t3*t6
     9         2*t63*t64-1.363138928244635d-3*t182*t24*t60+8.24331979256
     :         5312d-3*t180*t19*t60-5.980796863619711d-2*t25*t28*t322*t5
     ;         *t6+t339+t338+t337+t336+t335+t334+1.9751631321680768d-2*t
     <         20*t24*(t333+t332+t331+t330+t328+t327+t326+t325+t324+t323
     =         +1.923661050931536d+0*t322)-6.21814d-2*t19*t3*(t333+t332+
     >         t331+t330+t328+t327+t326+t325+t324+t323)+t311+t310+t309+t
     ?         308+t307+t306+t305+t304+t303+t302+t301+t300+t299+t298+t29
     @         7+t296+t294+t293+t292+t291+t290+t289+t288+t287+t286+t285+
     1         t283+t278+t277+t276+t275+t274+t273+t272+t271+t270
            t341 = t95**3
            t342 = 1/t29**4
            t343 = 1/t8**2.333333333333333d+0
            t344 = 1/t9**2.333333333333333d+0
            t345 = 6.666666666666667d-1*t321*t99+6.666666666666667d-1*t3
     1         16*t98-6.666666666666666d-1*t170*t190*t80-6.6666666666666
     2         66d-1*t165*t189*t77+2.962962962962963d-1*t317*t344+2.9629
     3         62962962963d-1*t312*t343
            t346 = -1.620370370370371d-1*t32/t1**1.8333333333333332d+0
            t347 = t346+t34*t345+5.833333333333336d-1*t100*t192+3.5d+0*t
     1         101*t191
            t348 = t100**3
            t349 = 1/t35**5.0d+0
            t350 = t103**3
            t351 = 1.2704999718189527d-2*t194*t31*t33*t95*t96*t97+7.6229
     1         99830913715d-2*t100*t103*t104*t31*t95*t96*t97+1.270499971
     2         8189527d-2*t103*t188*t31*t33*t96*t97-4.2349999060631754d-
     3         3*t31*t33*t347*t37*t97-7.622999830913715d-2*t103*t195*t31
     4         *t32*t37*t97-3.8114999154568574d-2*t100*t104*t194*t31*t37
     5         *t97-3.8114999154568574d-2*t103*t104*t191*t31*t37*t97-2.5
     6         409999436379055d-2*t103*t126*t127*t31*t33*t97-3.811499915
     7         4568574d-2*t195*t31*t32*t36*t95*t96-1.9057499577284287d-2
     8         *t104*t191*t31*t36*t95*t96-3.8114999154568574d-2*t196*t19
     9         7*t31*t33*t95*t96-2.1174999530315877d-3*t31*t33*t340*t36*
     :         t96-1.9057499577284287d-2*t100*t104*t188*t31*t36*t96+1.27
     ;         04999718189527d-2*t127*t188*t31*t33*t36*t95+1.27049997181
     <         89527d-2*t31*t348*t36*t37+6.352499859094763d-3*t104*t31*t
     =         345*t36*t37+3.8114999154568574d-2*t100*t191*t31*t32*t36*t
     >         37-5.081999887275811d-2*t31*t33*t349*t350*t37+3.811499915
     ?         4568574d-2*t103*t194*t196*t31*t33*t37+1.1434499746370573d
     @         -1*t100*t104*t196*t197*t31*t37-1.2704999718189527d-2*t31*
     1         t33*t341*t342*t36+3.8114999154568574d-2*t100*t104*t126*t1
     2         27*t31*t36
            t352 = -1.2704999718189527d-2*t194*t31*t33*t95*t96*t97-7.622
     1         999830913715d-2*t100*t103*t104*t31*t95*t96*t97-1.27049997
     2         18189527d-2*t103*t188*t31*t33*t96*t97+4.2349999060631754d
     3         -3*t31*t33*t347*t37*t97+7.622999830913715d-2*t103*t195*t3
     4         1*t32*t37*t97+3.8114999154568574d-2*t100*t104*t194*t31*t3
     5         7*t97+3.8114999154568574d-2*t103*t104*t191*t31*t37*t97+2.
     6         5409999436379055d-2*t103*t126*t127*t31*t33*t97+3.81149991
     7         54568574d-2*t195*t31*t32*t36*t95*t96+1.9057499577284287d-
     8         2*t104*t191*t31*t36*t95*t96+3.8114999154568574d-2*t196*t1
     9         97*t31*t33*t95*t96+2.1174999530315877d-3*t31*t33*t340*t36
     :         *t96+1.9057499577284287d-2*t100*t104*t188*t31*t36*t96-1.2
     ;         704999718189527d-2*t127*t188*t31*t33*t36*t95-1.2704999718
     <         189527d-2*t31*t348*t36*t37-6.352499859094763d-3*t104*t31*
     =         t345*t36*t37-3.8114999154568574d-2*t100*t191*t31*t32*t36*
     >         t37+5.081999887275811d-2*t31*t33*t349*t350*t37-3.81149991
     ?         54568574d-2*t103*t194*t196*t31*t33*t37-1.1434499746370573
     @         d-1*t100*t104*t196*t197*t31*t37+1.2704999718189527d-2*t31
     1         *t33*t341*t342*t36-3.8114999154568574d-2*t100*t104*t126*t
     2         127*t31*t36
            t353 = t105**3
            t354 = exp(6.352499859094763d-3*t31*t33*t36*t37)
            t355 = t106**3
            t356 = 1/t48**6
            t357 = 1/t48**5
            t358 = 2.0d+0*t213*t3*t62*t63*t64
            t359 = -1.1696447245269295d+0*t20*t214*t66*t67*t68
            t360 = 3.847322101863072d+0*t206*t25*t5*t6*t70*t71*t72
            t361 = -2.3083932611178434d+1*t10*t178*t25*t6*t70*t71*t72
            t362 = 5.495546528376875d-3*t19*t213*t60
            t363 = 1.5389288407452287d+1*t206*t5*t84
            t364 = -1.5389288407452287d+1*t206*t6*t86
            t365 = t314-2*t162
            t366 = t319+2*t162
            t367 = 1.3333333333333333d+0*t366*t81+1.7777777777777776d+0*
     1         t162*t167*t4*t80+1.3333333333333333d+0*t365*t78-1.7777777
     2         777777776d+0*t161*t162*t4*t77-2.962962962962963d-1*t111*t
     3         166*t318-2.962962962962963d-1*t110*t160*t313+4.4444444444
     4         44444d-1*t111*t167*t170+4.444444444444444d-1*t110*t161*t1
     5         65
            t368 = -1.923661050931536d+0*t367*t5*t6
            t369 = 7.694644203726144d+0*t171*t5*t84
            t370 = 7.694644203726144d+0*t171*t6*t86
            t371 = -3.8473221018630716d+1*t112*t175*t5
            t372 = 6.155715362980915d+1*t112*t84*t86
            t373 = -2.3083932611178434d+1*t112*t178*t6
            t374 = -7.694644203726143d+1*t175*t5*t82
            t375 = 4.616786522235687d+1*t178*t6*t82
            t376 = -1.5389288407452287d+2*t10*t175*t86
            t377 = -9.233573044471374d+1*t10*t178*t84
            t378 = 4.616786522235687d+1*t10*t4*t6
            t379 = -9.087592854964233d-4*t214*t24*t60
            t380 = 5.082465978296986d-3*t206*t28*t5*t92
            t381 = 4.7846374908957684d-1*t206*t25*t28*t5*t84
            t382 = -2.870782494537461d+0*t10*t178*t25*t28*t84
            t383 = 1.4353912472687305d+0*t10*t25*t28*t4*t6
            t384 = -6.538889093261956d-1*t10*t70*t71*t72*t86*t92+2.03298
     1         63913187946d-2*t112*t28*t86*t92-3.2694445466309774d-1*t5*
     2         t70*t71*t72*t82*t92-1.6347222733154887d-1*t112*t5*t70*t71
     3         *t72*t92+2.541232989148493d-3*t171*t28*t5*t92-3.049479586
     4         978192d-2*t10*t178*t28*t92+5.381456786199792d-2*t60*t66*t
     5         67*t68*t90-1.1696447245269295d+0*t148*t20*t67*t68*t90+2.3
     6         39289449053859d+0*t141*t145*t20*t68*t90+1.211679047328564
     7         2d-3*t137*t24*t90-3.46317921627058d+1*t141*t142*t143*t20*
     8         t90-1.767585332069357d-1*t60*t62*t63*t64*t88+2.0d+0*t139*
     9         t3*t63*t64*t88-4.0d+0*t128*t132*t3*t64*t88+3.216395899738
     :         507d+1*t128*t129*t130*t3*t88-7.327395371169166d-3*t137*t1
     ;         9*t88-6.155715362980916d+1*t10*t25*t70*t71*t72*t84*t86+1.
     <         9138549963583074d+0*t112*t25*t28*t84*t86+1.53892884074522
     =         9d+1*t112*t25*t6*t70*t71*t72*t86+7.694644203726144d+0*t10
     >         *t157*t25*t6*t71*t72*t86-1.538928840745229d+1*t10*t150*t1
     ?         54*t25*t6*t72*t86-4.7846374908957684d-1*t206*t25*t28*t6*t
     @         86+2.3923187454478842d-1*t171*t25*t28*t6*t86+2.4749022066
     1         811444d+2*t10*t150*t151*t152*t25*t6*t86-4.784637490895768
     2         4d+0*t10*t175*t25*t28*t86-9.487269826154375d-2*t10*t184*t
     3         28*t86-3.077857681490458d+1*t25*t5*t70*t71*t72*t82*t84-1.
     4         538928840745229d+1*t112*t25*t5*t70*t71*t72*t84+2.39231874
     5         54478842d-1*t171*t25*t28*t5*t84+3.847322101863072d+0*t157
     6         *t25*t5*t6*t71*t72*t82-7.694644203726144d+0*t150*t154*t25
     7         *t5*t6*t72*t82+1.2374511033405722d+2*t150*t151*t152*t25*t
     8         5*t6*t82+1.4353912472687305d+0*t178*t25*t28*t6*t82-2.3923
     9         187454478842d+0*t175*t25*t28*t5*t82-4.743634913077187d-2*
     :         t184*t28*t5*t82+1.923661050931536d+0*t171*t25*t5*t6*t70*t
     ;         71*t72+1.923661050931536d+0*t112*t157*t25*t5*t6*t71*t72-3
     <         .847322101863072d+0*t112*t150*t154*t25*t5*t6*t72+2.690728
     =         393099896d-2*t116*t60*t66*t67*t68-5.848223622634647d-1*t1
     >         82*t20*t66*t67*t68-5.848223622634647d-1*t116*t148*t20*t67
     ?         *t68+1.1696447245269295d+0*t116*t141*t145*t20*t68-8.83792
     @         6660346784d-2*t115*t60*t62*t63*t64+1.0d+0*t180*t3*t62*t63
     1         *t64+1.0d+0*t115*t139*t3*t63*t64-2.0d+0*t115*t128*t132*t3
     2         *t64-4.5437964274821163d-4*t182*t24*t60+2.747773264188437
     3         d-3*t180*t19*t60-5.980796863619711d-2*t25*t28*t367*t5*t6+
     4         6.187255516702861d+1*t112*t150*t151*t152*t25*t5*t6-7.1769
     5         56236343652d-1*t112*t178*t25*t28*t6-1.1961593727239421d+0
     6         *t112*t175*t25*t28*t5-2.3718174565385935d-2*t112*t184*t28
     7         *t5+t383+t382+t381+t380+t379+1.9751631321680768d-2*t20*t2
     8         4*(t378+t377+t376+t375+t374+t373+t372+t371+t370+t369+t368
     9         +1.923661050931536d+0*t367+t364+t363+t330)-6.21814d-2*t19
     :         *t3*(t378+t377+t376+t375+t374+t373+t372+t371+t370+t369+t3
     ;         68+t364+t363+t330)+t362+t361+t360+t359+t358+t337+t335+t33
     <         4+t311+t309+t308+t307+t306+t305+t304+t303+t302+t301+t300+
     =         1.6081979498692536d+1*t115*t128*t129*t130*t3+t299+t298+t2
     >         97+t296+t294+t293+t292+t291+t290+t289+t288+t287+t286+t285
     ?         +t283+t278+t277+t276+t275+t274+t273+t272+t271+t270+6.0583
     @         95236642822d-4*t116*t137*t24-1.73158960813529d+1*t116*t14
     1         1*t142*t143*t20-3.663697685584583d-3*t115*t137*t19
            t385 = 2.3333333333333334d+0*t101*t216
            t386 = 6.666666666666667d-1*t366*t99+6.666666666666667d-1*t3
     1         65*t98-8.888888888888888d-1*t162*t190*t4*t80+8.8888888888
     2         88888d-1*t162*t189*t4*t77+2.962962962962963d-1*t111*t166*
     3         t344+2.962962962962963d-1*t110*t160*t343-2.22222222222222
     4         2d-1*t111*t170*t190-2.222222222222222d-1*t110*t165*t189
            t387 = t34*t386+t385+t346+1.9444444444444453d-1*t118*t192+3.
     1         8888888888888906d-1*t100*t192+1.1666666666666667d+0*t101*
     2         t191
            t388 = -8.469999812126351d-3*t217*t31*t33*t95*t96*t97-2.5409
     1         999436379055d-2*t100*t104*t119*t31*t95*t96*t97-2.54099994
     2         36379055d-2*t103*t104*t118*t31*t95*t96*t97-8.469999812126
     3         351d-3*t103*t215*t31*t33*t96*t97-4.2349999060631754d-3*t1
     4         17*t194*t31*t33*t96*t97-4.2349999060631754d-3*t119*t188*t
     5         31*t33*t96*t97-2.5409999436379055d-2*t100*t103*t104*t117*
     6         t31*t96*t97+1.6939999624252702d-2*t103*t117*t127*t31*t33*
     7         t95*t97+4.2349999060631754d-3*t31*t33*t37*t387*t97+2.5409
     8         999436379055d-2*t119*t195*t31*t32*t37*t97+5.0819998872758
     9         11d-2*t100*t103*t118*t31*t32*t37*t97+2.5409999436379055d-
     :         2*t100*t104*t217*t31*t37*t97+2.5409999436379055d-2*t103*t
     ;         104*t216*t31*t37*t97+1.2704999718189527d-2*t104*t118*t194
     <         *t31*t37*t97+1.2704999718189527d-2*t104*t119*t191*t31*t37
     =         *t97+8.469999812126351d-3*t119*t126*t127*t31*t33*t97+2.54
     >         09999436379055d-2*t100*t118*t31*t32*t36*t95*t96+1.2704999
     ?         718189527d-2*t104*t216*t31*t36*t95*t96+2.5409999436379055
     @         d-2*t103*t119*t196*t31*t33*t95*t96+2.1174999530315877d-3*
     1         t31*t33*t36*t384*t96+1.2704999718189527d-2*t117*t195*t31*
     2         t32*t36*t96+1.2704999718189527d-2*t100*t104*t215*t31*t36*
     3         t96+6.352499859094763d-3*t104*t117*t191*t31*t36*t96+6.352
     4         499859094763d-3*t104*t118*t188*t31*t36*t96+1.270499971818
     5         9527d-2*t117*t196*t197*t31*t33*t96-8.469999812126351d-3*t
     6         127*t215*t31*t33*t36*t95-2.5409999436379055d-2*t100*t104*
     7         t117*t127*t31*t36*t95-6.352499859094763d-3*t104*t31*t36*t
     8         37*t386-2.5409999436379055d-2*t100*t216*t31*t32*t36*t37-1
     9         .2704999718189527d-2*t118*t191*t31*t32*t36*t37-1.27049997
     :         18189527d-2*t118*t195*t31*t36*t37+5.081999887275811d-2*t1
     ;         19*t197*t31*t33*t349*t37-2.5409999436379055d-2*t103*t196*
     <         t217*t31*t33*t37-1.2704999718189527d-2*t119*t194*t196*t31
     =         *t33*t37-3.8114999154568574d-2*t104*t118*t196*t197*t31*t3
     >         7-7.622999830913715d-2*t100*t103*t104*t119*t196*t31*t37+1
     ?         .2704999718189527d-2*t117*t126*t31*t33*t342*t36-4.2349999
     @         060631754d-3*t117*t127*t188*t31*t33*t36-1.270499971818952
     1         7d-2*t104*t118*t126*t127*t31*t36
            t389 = 8.469999812126351d-3*t217*t31*t33*t95*t96*t97+2.54099
     1         99436379055d-2*t100*t104*t119*t31*t95*t96*t97+2.540999943
     2         6379055d-2*t103*t104*t118*t31*t95*t96*t97+8.4699998121263
     3         51d-3*t103*t215*t31*t33*t96*t97+4.2349999060631754d-3*t11
     4         7*t194*t31*t33*t96*t97+4.2349999060631754d-3*t119*t188*t3
     5         1*t33*t96*t97+2.5409999436379055d-2*t100*t103*t104*t117*t
     6         31*t96*t97-1.6939999624252702d-2*t103*t117*t127*t31*t33*t
     7         95*t97-4.2349999060631754d-3*t31*t33*t37*t387*t97-2.54099
     8         99436379055d-2*t119*t195*t31*t32*t37*t97-5.08199988727581
     9         1d-2*t100*t103*t118*t31*t32*t37*t97-2.5409999436379055d-2
     :         *t100*t104*t217*t31*t37*t97-2.5409999436379055d-2*t103*t1
     ;         04*t216*t31*t37*t97-1.2704999718189527d-2*t104*t118*t194*
     <         t31*t37*t97-1.2704999718189527d-2*t104*t119*t191*t31*t37*
     =         t97-8.469999812126351d-3*t119*t126*t127*t31*t33*t97-2.540
     >         9999436379055d-2*t100*t118*t31*t32*t36*t95*t96-1.27049997
     ?         18189527d-2*t104*t216*t31*t36*t95*t96-2.5409999436379055d
     @         -2*t103*t119*t196*t31*t33*t95*t96-2.1174999530315877d-3*t
     1         31*t33*t36*t384*t96-1.2704999718189527d-2*t117*t195*t31*t
     2         32*t36*t96-1.2704999718189527d-2*t100*t104*t215*t31*t36*t
     3         96-6.352499859094763d-3*t104*t117*t191*t31*t36*t96-6.3524
     4         99859094763d-3*t104*t118*t188*t31*t36*t96-1.2704999718189
     5         527d-2*t117*t196*t197*t31*t33*t96+8.469999812126351d-3*t1
     6         27*t215*t31*t33*t36*t95+2.5409999436379055d-2*t100*t104*t
     7         117*t127*t31*t36*t95+6.352499859094763d-3*t104*t31*t36*t3
     8         7*t386+2.5409999436379055d-2*t100*t216*t31*t32*t36*t37+1.
     9         2704999718189527d-2*t118*t191*t31*t32*t36*t37+1.270499971
     :         8189527d-2*t118*t195*t31*t36*t37-5.081999887275811d-2*t11
     ;         9*t197*t31*t33*t349*t37+2.5409999436379055d-2*t103*t196*t
     <         217*t31*t33*t37+1.2704999718189527d-2*t119*t194*t196*t31*
     =         t33*t37+3.8114999154568574d-2*t104*t118*t196*t197*t31*t37
     >         +7.622999830913715d-2*t100*t103*t104*t119*t196*t31*t37-1.
     ?         2704999718189527d-2*t117*t126*t31*t33*t342*t36+4.23499990
     @         60631754d-3*t117*t127*t188*t31*t33*t36+1.2704999718189527
     1         d-2*t104*t118*t126*t127*t31*t36
            t390 = -8.469999812126351d-3*t119*t31*t33*t37*t97-4.23499990
     1         60631754d-3*t117*t31*t33*t36*t96+1.2704999718189527d-2*t1
     2         04*t118*t31*t36*t37
            t391 = 2.0d+0*t220*t29*wght
            t392 = 2.0d+0*t122*t95*wght
            t393 = 2.0d+0*t108*t117*wght
            t394 = 2.0d+0*t215*t57*wght
            t395 = -8*t4*t6*t81-2.6666666666666666d+0*t162*t81-2.9629629
     1         62962963d-1*t224*t318*t80+4.444444444444444d-1*t167*t225*
     2         t80+8*t4*t6*t78+2.6666666666666666d+0*t162*t78-2.96296296
     3         2962963d-1*t222*t313*t77+4.444444444444444d-1*t161*t223*t
     4         77+1.7777777777777776d+0*t111*t162*t167*t4-1.777777777777
     5         7776d+0*t110*t161*t162*t4
            t396 = -1.923661050931536d+0*t395*t5*t6
            t397 = 1.5389288407452287d+1*t206*t6*t86
            t398 = 7.694644203726144d+0*t226*t5*t84
            t399 = -7.694644203726144d+0*t226*t6*t86
            t400 = -7.694644203726143d+1*t112*t175*t5
            t401 = 4.616786522235687d+1*t112*t178*t6
            t402 = -3.8473221018630716d+1*t175*t5*t82
            t403 = -6.155715362980915d+1*t82*t84*t86
            t404 = -2.3083932611178434d+1*t178*t6*t82
            t405 = 1.5389288407452287d+2*t10*t175*t86
            t406 = -2.0329863913187946d-2*t28*t82*t86*t92+6.538889093261
     1         955d-1*t10*t70*t71*t72*t86*t92-1.6347222733154887d-1*t5*t
     2         70*t71*t72*t82*t92-3.2694445466309774d-1*t112*t5*t70*t71*
     3         t72*t92+2.541232989148493d-3*t226*t28*t5*t92-3.0494795869
     4         781915d-2*t10*t178*t28*t92+2.690728393099896d-2*t60*t66*t
     5         67*t68*t90-5.848223622634647d-1*t148*t20*t67*t68*t90+1.16
     6         96447245269295d+0*t141*t145*t20*t68*t90+6.058395236642822
     7         d-4*t137*t24*t90-1.73158960813529d+1*t141*t142*t143*t20*t
     8         90-8.837926660346784d-2*t60*t62*t63*t64*t88+1.0d+0*t139*t
     9         3*t63*t64*t88-2.0d+0*t128*t132*t3*t64*t88+1.6081979498692
     :         536d+1*t128*t129*t130*t3*t88-3.663697685584583d-3*t137*t1
     ;         9*t88-1.9138549963583074d+0*t25*t28*t82*t84*t86+6.1557153
     <         62980916d+1*t10*t25*t70*t71*t72*t84*t86-1.538928840745229
     =         d+1*t25*t6*t70*t71*t72*t82*t86-7.694644203726144d+0*t10*t
     >         157*t25*t6*t71*t72*t86+1.538928840745229d+1*t10*t150*t154
     ?         *t25*t6*t72*t86-2.3923187454478842d-1*t226*t25*t28*t6*t86
     @         +4.7846374908957684d-1*t206*t25*t28*t6*t86-2.474902206681
     1         1444d+2*t10*t150*t151*t152*t25*t6*t86+4.7846374908957684d
     2         +0*t10*t175*t25*t28*t86+9.487269826154374d-2*t10*t184*t28
     3         *t86-1.538928840745229d+1*t25*t5*t70*t71*t72*t82*t84-3.07
     4         7857681490458d+1*t112*t25*t5*t70*t71*t72*t84+2.3923187454
     5         478842d-1*t226*t25*t28*t5*t84+1.923661050931536d+0*t157*t
     6         25*t5*t6*t71*t72*t82-3.847322101863072d+0*t150*t154*t25*t
     7         5*t6*t72*t82+6.187255516702861d+1*t150*t151*t152*t25*t5*t
     8         6*t82-7.176956236343652d-1*t178*t25*t28*t6*t82-1.19615937
     9         27239421d+0*t175*t25*t28*t5*t82-2.3718174565385935d-2*t18
     :         4*t28*t5*t82+1.923661050931536d+0*t226*t25*t5*t6*t70*t71*
     ;         t72+3.847322101863072d+0*t112*t157*t25*t5*t6*t71*t72-7.69
     <         4644203726144d+0*t112*t150*t154*t25*t5*t6*t72+5.381456786
     =         199792d-2*t116*t60*t66*t67*t68-5.848223622634647d-1*t20*t
     >         232*t66*t67*t68-1.1696447245269295d+0*t116*t148*t20*t67*t
     ?         68+2.339289449053859d+0*t116*t141*t145*t20*t68-1.76758533
     @         2069357d-1*t115*t60*t62*t63*t64+1.0d+0*t231*t3*t62*t63*t6
     1         4+2.0d+0*t115*t139*t3*t63*t64-4.0d+0*t115*t128*t132*t3*t6
     2         4-4.5437964274821163d-4*t232*t24*t60+2.747773264188437d-3
     3         *t19*t231*t60-5.980796863619711d-2*t25*t28*t395*t5*t6+1.2
     4         374511033405722d+2*t112*t150*t151*t152*t25*t5*t6+1.435391
     5         2472687305d+0*t112*t178*t25*t28*t6-2.3923187454478842d+0*
     6         t112*t175*t25*t28*t5-4.743634913077187d-2*t112*t184*t28*t
     7         5+1.9751631321680768d-2*t20*t24*(t405+t404+t403+t402+t401
     8         +t400+t399+t398+t397+t396+1.923661050931536d+0*t395+t377+
     9         t363+t333+t330)-6.21814d-2*t19*t3*(t405+t404+t403+t402+t4
     :         01+t400+t399+t398+t397+t396+t377+t363+t333+t330)+t382+t38
     ;         1+t380+t379+t362+t361+t360+t359+t358+t339+t337+t335+t334+
     <         t311+t309+t308+t307+t306+t305+t304+t303+t302+t301+t300+3.
     =         216395899738507d+1*t115*t128*t129*t130*t3+t299+t298+t297+
     >         t296+t294+t293+t292+t291+t290+t289+t288+t287+t286+t285+t2
     ?         83+t278+t277+t276+t275+t274+t273+t272+t271+t270+1.2116790
     @         473285642d-3*t116*t137*t24-3.46317921627058d+1*t116*t141*
     1         t142*t143*t20-7.327395371169166d-3*t115*t137*t19
            t407 = -4.0d+0*t4*t6*t99-1.3333333333333336d+0*t162*t99+4.0d
     1         +0*t4*t6*t98+1.3333333333333336d+0*t162*t98+2.96296296296
     2         2963d-1*t224*t344*t80-2.222222222222222d-1*t190*t225*t80+
     3         2.962962962962963d-1*t222*t343*t77-2.222222222222222d-1*t
     4         189*t223*t77-8.888888888888888d-1*t111*t162*t190*t4+8.888
     5         888888888888d-1*t110*t162*t189*t4
            t408 = t34*t407+t385+t346+1.1666666666666667d+0*t101*t234+3.
     1         8888888888888906d-1*t118*t192+1.9444444444444453d-1*t100*
     2         t192
            t409 = -4.2349999060631754d-3*t235*t31*t33*t95*t96*t97-2.540
     1         9999436379055d-2*t104*t118*t119*t31*t95*t96*t97-4.2349999
     2         060631754d-3*t103*t233*t31*t33*t96*t97-8.469999812126351d
     3         -3*t117*t217*t31*t33*t96*t97-8.469999812126351d-3*t119*t2
     4         15*t31*t33*t96*t97-2.5409999436379055d-2*t100*t104*t117*t
     5         119*t31*t96*t97-2.5409999436379055d-2*t103*t104*t117*t118
     6         *t31*t96*t97+1.6939999624252702d-2*t117*t119*t127*t31*t33
     7         *t95*t97+4.2349999060631754d-3*t31*t33*t37*t408*t97+2.540
     8         9999436379055d-2*t103*t236*t31*t32*t37*t97+5.081999887275
     9         811d-2*t100*t118*t119*t31*t32*t37*t97+1.2704999718189527d
     :         -2*t100*t104*t235*t31*t37*t97+1.2704999718189527d-2*t103*
     ;         t104*t234*t31*t37*t97+2.5409999436379055d-2*t104*t118*t21
     <         7*t31*t37*t97+2.5409999436379055d-2*t104*t119*t216*t31*t3
     =         7*t97+8.469999812126351d-3*t103*t127*t221*t31*t33*t97+1.2
     >         704999718189527d-2*t236*t31*t32*t36*t95*t96+6.35249985909
     ?         4763d-3*t104*t234*t31*t36*t95*t96+1.2704999718189527d-2*t
     @         196*t237*t31*t33*t95*t96+2.1174999530315877d-3*t31*t33*t3
     1         6*t406*t96+2.5409999436379055d-2*t100*t117*t118*t31*t32*t
     2         36*t96+6.352499859094763d-3*t100*t104*t233*t31*t36*t96+1.
     3         2704999718189527d-2*t104*t117*t216*t31*t36*t96+1.27049997
     4         18189527d-2*t104*t118*t215*t31*t36*t96+2.5409999436379055
     5         d-2*t103*t117*t119*t196*t31*t33*t96+1.2704999718189527d-2
     6         *t221*t31*t33*t342*t36*t95-4.2349999060631754d-3*t127*t23
     7         3*t31*t33*t36*t95-2.5409999436379055d-2*t104*t117*t118*t1
     8         27*t31*t36*t95-6.352499859094763d-3*t104*t31*t36*t37*t407
     9         -1.2704999718189527d-2*t100*t234*t31*t32*t36*t37-2.540999
     :         9436379055d-2*t118*t216*t31*t32*t36*t37-1.270499971818952
     ;         7d-2*t100*t236*t31*t36*t37+5.081999887275811d-2*t103*t237
     <         *t31*t33*t349*t37-1.2704999718189527d-2*t103*t196*t235*t3
     =         1*t33*t37-2.5409999436379055d-2*t119*t196*t217*t31*t33*t3
     >         7-3.8114999154568574d-2*t100*t104*t196*t237*t31*t37-7.622
     ?         999830913715d-2*t103*t104*t118*t119*t196*t31*t37-8.469999
     @         812126351d-3*t117*t127*t215*t31*t33*t36-1.270499971818952
     1         7d-2*t100*t104*t127*t221*t31*t36
            t410 = 4.2349999060631754d-3*t235*t31*t33*t95*t96*t97+2.5409
     1         999436379055d-2*t104*t118*t119*t31*t95*t96*t97+4.23499990
     2         60631754d-3*t103*t233*t31*t33*t96*t97+8.469999812126351d-
     3         3*t117*t217*t31*t33*t96*t97+8.469999812126351d-3*t119*t21
     4         5*t31*t33*t96*t97+2.5409999436379055d-2*t100*t104*t117*t1
     5         19*t31*t96*t97+2.5409999436379055d-2*t103*t104*t117*t118*
     6         t31*t96*t97-1.6939999624252702d-2*t117*t119*t127*t31*t33*
     7         t95*t97-4.2349999060631754d-3*t31*t33*t37*t408*t97-2.5409
     8         999436379055d-2*t103*t236*t31*t32*t37*t97-5.0819998872758
     9         11d-2*t100*t118*t119*t31*t32*t37*t97-1.2704999718189527d-
     :         2*t100*t104*t235*t31*t37*t97-1.2704999718189527d-2*t103*t
     ;         104*t234*t31*t37*t97-2.5409999436379055d-2*t104*t118*t217
     <         *t31*t37*t97-2.5409999436379055d-2*t104*t119*t216*t31*t37
     =         *t97-8.469999812126351d-3*t103*t127*t221*t31*t33*t97-1.27
     >         04999718189527d-2*t236*t31*t32*t36*t95*t96-6.352499859094
     ?         763d-3*t104*t234*t31*t36*t95*t96-1.2704999718189527d-2*t1
     @         96*t237*t31*t33*t95*t96-2.1174999530315877d-3*t31*t33*t36
     1         *t406*t96-2.5409999436379055d-2*t100*t117*t118*t31*t32*t3
     2         6*t96-6.352499859094763d-3*t100*t104*t233*t31*t36*t96-1.2
     3         704999718189527d-2*t104*t117*t216*t31*t36*t96-1.270499971
     4         8189527d-2*t104*t118*t215*t31*t36*t96-2.5409999436379055d
     5         -2*t103*t117*t119*t196*t31*t33*t96-1.2704999718189527d-2*
     6         t221*t31*t33*t342*t36*t95+4.2349999060631754d-3*t127*t233
     7         *t31*t33*t36*t95+2.5409999436379055d-2*t104*t117*t118*t12
     8         7*t31*t36*t95+6.352499859094763d-3*t104*t31*t36*t37*t407+
     9         1.2704999718189527d-2*t100*t234*t31*t32*t36*t37+2.5409999
     :         436379055d-2*t118*t216*t31*t32*t36*t37+1.2704999718189527
     ;         d-2*t100*t236*t31*t36*t37-5.081999887275811d-2*t103*t237*
     <         t31*t33*t349*t37+1.2704999718189527d-2*t103*t196*t235*t31
     =         *t33*t37+2.5409999436379055d-2*t119*t196*t217*t31*t33*t37
     >         +3.8114999154568574d-2*t100*t104*t196*t237*t31*t37+7.6229
     ?         99830913715d-2*t103*t104*t118*t119*t196*t31*t37+8.4699998
     @         12126351d-3*t117*t127*t215*t31*t33*t36+1.2704999718189527
     1         d-2*t100*t104*t127*t221*t31*t36
            t411 = t110**3
            t412 = t320+t314
            t413 = t111**3
            t414 = t319+t315
            t415 = 1.3333333333333333d+0*t414*t81+1.3333333333333333d+0*
     1         t412*t78-2.962962962962963d-1*t318*t413-2.962962962962963
     2         d-1*t313*t411+1.3333333333333333d+0*t111*t167*t225+1.3333
     3         333333333333d+0*t110*t161*t223
            t416 = -1.923661050931536d+0*t415*t5*t6
            t417 = 2.3083932611178434d+1*t226*t5*t84
            t418 = 2.3083932611178434d+1*t226*t6*t86
            t419 = -1.1541966305589216d+2*t112*t175*t5
            t420 = -1.8467146088942746d+2*t112*t84*t86
            t421 = -6.925179783353531d+1*t112*t178*t6
            t422 = 4.6167865222356863d+2*t10*t175*t86
            t423 = 1.9616667279785865d+0*t10*t70*t71*t72*t86*t92-6.09895
     1         9173956384d-2*t112*t28*t86*t92-4.904166819946466d-1*t112*
     2         t5*t70*t71*t72*t92+7.623698967445479d-3*t226*t28*t5*t92+1
     3         .8467146088942746d+2*t10*t25*t70*t71*t72*t84*t86-5.741564
     4         989074922d+0*t112*t25*t28*t84*t86-4.616786522235687d+1*t1
     5         12*t25*t6*t70*t71*t72*t86-2.3083932611178434d+1*t10*t157*
     6         t25*t6*t71*t72*t86+4.616786522235687d+1*t10*t150*t154*t25
     7         *t6*t72*t86+7.176956236343652d-1*t226*t25*t28*t6*t86-7.42
     8         4706620043432d+2*t10*t150*t151*t152*t25*t6*t86+1.43539124
     9         72687305d+1*t10*t175*t25*t28*t86+2.8461809478463124d-1*t1
     :         0*t184*t28*t86-4.616786522235687d+1*t112*t25*t5*t70*t71*t
     ;         72*t84+7.176956236343652d-1*t226*t25*t28*t5*t84+5.7709831
     <         52794609d+0*t226*t25*t5*t6*t70*t71*t72+5.770983152794609d
     =         +0*t112*t157*t25*t5*t6*t71*t72-1.1541966305589217d+1*t112
     >         *t150*t154*t25*t5*t6*t72+8.072185179299687d-2*t116*t60*t6
     ?         6*t67*t68-1.7544670867903941d+0*t20*t232*t66*t67*t68-1.75
     @         44670867903941d+0*t116*t148*t20*t67*t68+3.508934173580788
     1         3d+0*t116*t141*t145*t20*t68-2.6513779981040353d-1*t115*t6
     2         0*t62*t63*t64+3.0d+0*t231*t3*t62*t63*t64+3.0d+0*t115*t139
     3         *t3*t63*t64-6.0d+0*t115*t128*t132*t3*t64-1.36313892824463
     4         5d-3*t232*t24*t60+8.243319792565312d-3*t19*t231*t60-5.980
     5         796863619711d-2*t25*t28*t415*t5*t6+1.856176655010858d+2*t
     6         112*t150*t151*t152*t25*t5*t6-2.1530868709030954d+0*t112*t
     7         178*t25*t28*t6-3.588478118171826d+0*t112*t175*t25*t28*t5-
     8         7.11545236961578d-2*t112*t184*t28*t5+1.9751631321680768d-
     9         2*t20*t24*(t422+t421+t420+t419+t418+t417+t416+1.923661050
     :         931536d+0*t415+t378+t332+t330)-6.21814d-2*t19*t3*(t422+t4
     ;         21+t420+t419+t418+t417+t416+t378+t332+t330)+t383+t338+t33
     <         7+t336+t335+t334+t311+t310+t309+t308+t307+t306+t305+t304+
     =         t303+t302+t301+t300+4.824593849607761d+1*t115*t128*t129*t
     >         130*t3+t299+t298+t297+t296+t294+t293+t292+t291+t290+t289+
     ?         t288+t287+t286+t285+t283+t278+t277+t276+t275+t274+t273+t2
     @         72+t271+t270+1.8175185709928465d-3*t116*t137*t24-5.194768
     1         82440587d+1*t116*t141*t142*t143*t20-1.099109305675375d-2*
     2         t115*t137*t19
            t424 = t117**3
            t425 = 6.666666666666667d-1*t414*t99+6.666666666666667d-1*t4
     1         12*t98+2.962962962962963d-1*t344*t413+2.962962962962963d-
     2         1*t343*t411-6.666666666666666d-1*t111*t190*t225-6.6666666
     3         66666666d-1*t110*t189*t223
            t426 = t34*t425+t346+3.5d+0*t101*t234+5.833333333333336d-1*t
     1         118*t192
            t427 = t118**3
            t428 = t119**3
            t429 = 1.2704999718189527d-2*t117*t235*t31*t33*t96*t97+1.270
     1         4999718189527d-2*t119*t233*t31*t33*t96*t97+7.622999830913
     2         715d-2*t104*t117*t118*t119*t31*t96*t97-4.2349999060631754
     3         d-3*t31*t33*t37*t426*t97-7.622999830913715d-2*t119*t236*t
     4         31*t32*t37*t97-3.8114999154568574d-2*t104*t118*t235*t31*t
     5         37*t97-3.8114999154568574d-2*t104*t119*t234*t31*t37*t97-2
     6         .5409999436379055d-2*t119*t127*t221*t31*t33*t97-2.1174999
     7         530315877d-3*t31*t33*t36*t423*t96-3.8114999154568574d-2*t
     8         117*t236*t31*t32*t36*t96-1.9057499577284287d-2*t104*t117*
     9         t234*t31*t36*t96-1.9057499577284287d-2*t104*t118*t233*t31
     :         *t36*t96-3.8114999154568574d-2*t117*t196*t237*t31*t33*t96
     ;         -5.081999887275811d-2*t31*t33*t349*t37*t428+1.27049997181
     <         89527d-2*t31*t36*t37*t427+6.352499859094763d-3*t104*t31*t
     =         36*t37*t425-1.2704999718189527d-2*t31*t33*t342*t36*t424+3
     >         .8114999154568574d-2*t118*t234*t31*t32*t36*t37+3.81149991
     ?         54568574d-2*t119*t196*t235*t31*t33*t37+1.1434499746370573
     @         d-1*t104*t118*t196*t237*t31*t37+1.2704999718189527d-2*t11
     1         7*t127*t233*t31*t33*t36+3.8114999154568574d-2*t104*t118*t
     2         127*t221*t31*t36
            t430 = -1.2704999718189527d-2*t117*t235*t31*t33*t96*t97-1.27
     1         04999718189527d-2*t119*t233*t31*t33*t96*t97-7.62299983091
     2         3715d-2*t104*t117*t118*t119*t31*t96*t97+4.234999906063175
     3         4d-3*t31*t33*t37*t426*t97+7.622999830913715d-2*t119*t236*
     4         t31*t32*t37*t97+3.8114999154568574d-2*t104*t118*t235*t31*
     5         t37*t97+3.8114999154568574d-2*t104*t119*t234*t31*t37*t97+
     6         2.5409999436379055d-2*t119*t127*t221*t31*t33*t97+2.117499
     7         9530315877d-3*t31*t33*t36*t423*t96+3.8114999154568574d-2*
     8         t117*t236*t31*t32*t36*t96+1.9057499577284287d-2*t104*t117
     9         *t234*t31*t36*t96+1.9057499577284287d-2*t104*t118*t233*t3
     :         1*t36*t96+3.8114999154568574d-2*t117*t196*t237*t31*t33*t9
     ;         6+5.081999887275811d-2*t31*t33*t349*t37*t428-1.2704999718
     <         189527d-2*t31*t36*t37*t427-6.352499859094763d-3*t104*t31*
     =         t36*t37*t425+1.2704999718189527d-2*t31*t33*t342*t36*t424-
     >         3.8114999154568574d-2*t118*t234*t31*t32*t36*t37-3.8114999
     ?         154568574d-2*t119*t196*t235*t31*t33*t37-1.143449974637057
     @         3d-1*t104*t118*t196*t237*t31*t37-1.2704999718189527d-2*t1
     1         17*t127*t233*t31*t33*t36-3.8114999154568574d-2*t104*t118*
     2         t127*t221*t31*t36
            t431 = t120**3
            t432 = t121**3
            t433 = -8.469999812126351d-3*t103*t33*t95*t96*t97+4.23499990
     1         60631754d-3*t194*t33*t37*t97+2.5409999436379055d-2*t100*t
     2         103*t104*t37*t97+1.2704999718189527d-2*t100*t104*t36*t95*
     3         t96+2.1174999530315877d-3*t188*t33*t36*t96-1.270499971818
     4         9527d-2*t195*t32*t36*t37-6.352499859094763d-3*t104*t191*t
     5         36*t37-1.2704999718189527d-2*t196*t197*t33*t37-4.23499990
     6         60631754d-3*t126*t127*t33*t36
            t434 = 8.469999812126351d-3*t103*t33*t95*t96*t97-4.234999906
     1         0631754d-3*t194*t33*t37*t97-2.5409999436379055d-2*t100*t1
     2         03*t104*t37*t97-1.2704999718189527d-2*t100*t104*t36*t95*t
     3         96-2.1174999530315877d-3*t188*t33*t36*t96+1.2704999718189
     4         527d-2*t195*t32*t36*t37+6.352499859094763d-3*t104*t191*t3
     5         6*t37+1.2704999718189527d-2*t196*t197*t33*t37+4.234999906
     6         0631754d-3*t126*t127*t33*t36
            t435 = 2.0d+0*t1*t247*t95*wght+2.0d+0*t243*t95*wght+1.0d+0*t
     1         1*t29*(5.0d+0*t107*t433*t55*t56+2.1174999530315877d-2*t19
     2         8*t204*t33*t36*t37*t55*t56-6.352499859094763d-2*t202*t203
     3         *t33*t36*t37*t55*t56-2.0d+1*t106*t204*t246*t55*t56+2.5409
     4         999436379055d-1*t202*t33*t357*t36*t37*t53*t56-4.234999906
     5         0631754d-2*t198*t203*t33*t36*t37*t53*t56+4.0d+1*t106*t203
     6         *t246*t53*t56-1.2704999718189527d-1*t202*t33*t356*t36*t37
     7         *t51*t56+4.0d+0*t107*t433*t53*t54+1.6939999624252702d-2*t
     8         198*t204*t33*t36*t37*t53*t54-5.081999887275811d-2*t202*t2
     9         03*t33*t36*t37*t53*t54-1.6d+1*t106*t204*t246*t53*t54+1.52
     :         4599966182743d-1*t202*t33*t357*t36*t37*t51*t54-2.54099994
     ;         36379055d-2*t198*t203*t33*t36*t37*t51*t54+2.4d+1*t106*t20
     <         3*t246*t51*t54-5.081999887275811d-2*t202*t33*t356*t36*t37
     =         *t49*t54+3.0d+0*t107*t433*t51*t52+1.2704999718189527d-2*t
     >         198*t204*t33*t36*t37*t51*t52-3.8114999154568574d-2*t202*t
     ?         203*t33*t36*t37*t51*t52-1.2d+1*t106*t204*t246*t51*t52+7.6
     @         22999830913715d-2*t202*t33*t357*t36*t37*t49*t52-1.2704999
     1         718189527d-2*t198*t203*t33*t36*t37*t49*t52+1.2d+1*t106*t2
     2         03*t246*t49*t52-1.2704999718189527d-2*t202*t33*t356*t36*t
     3         37*t52+2.0d+0*t107*t433*t49*t50+8.469999812126351d-3*t198
     4         *t204*t33*t36*t37*t49*t50-2.5409999436379055d-2*t202*t203
     5         *t33*t36*t37*t49*t50-8.0d+0*t106*t204*t246*t49*t50+2.5409
     6         999436379055d-2*t202*t33*t357*t36*t37*t50-4.2349999060631
     7         754d-3*t198*t203*t33*t36*t37*t50+4.0d+0*t106*t203*t246*t5
     8         0+1.0d+0*t107*t433*t47+4.2349999060631754d-3*t198*t204*t3
     9         3*t36*t37*t47-1.2704999718189527d-2*t202*t203*t33*t36*t37
     :         *t47-4.0d+0*t106*t204*t246*t47-t38*t434*t46-2.11749995303
     ;         15877d-3*t200*t33*t36*t37*t38*t46-2.1174999530315877d-3*t
     <         199*t33*t36*t37*t38*t46-2*t105*t245*t38*t46-5.0d+0*t38*t4
     =         34*t44*t45-1.0587499765157939d-2*t200*t33*t36*t37*t38*t44
     >         *t45-1.0587499765157939d-2*t199*t33*t36*t37*t38*t44*t45-1
     ?         .0d+1*t105*t245*t38*t44*t45+1.2704999718189527d-1*t200*t2
     @         01*t33*t36*t37*t42*t45+4.2349999060631754d-2*t199*t201*t3
     1         3*t36*t37*t42*t45+4.0d+1*t105*t201*t245*t42*t45-1.2704999
     2         718189527d-1*t200*t33*t354*t36*t37*t40*t45-4.0d+0*t38*t42
     3         *t43*t434-3.0d+0*t38*t40*t41*t434-2.0d+0*t30*t38*t39*t434
     4         -8.469999812126351d-3*t200*t33*t36*t37*t38*t42*t43-8.4699
     5         99812126351d-3*t199*t33*t36*t37*t38*t42*t43-8.0d+0*t105*t
     6         245*t38*t42*t43+7.622999830913715d-2*t200*t201*t33*t36*t3
     7         7*t40*t43+2.5409999436379055d-2*t199*t201*t33*t36*t37*t40
     8         *t43+2.4d+1*t105*t201*t245*t40*t43-5.081999887275811d-2*t
     9         200*t33*t354*t36*t37*t39*t43-6.352499859094763d-3*t200*t3
     :         3*t36*t37*t38*t40*t41-6.352499859094763d-3*t199*t33*t36*t
     ;         37*t38*t40*t41-6.0d+0*t105*t245*t38*t40*t41+3.81149991545
     <         68574d-2*t200*t201*t33*t36*t37*t39*t41+1.2704999718189527
     =         d-2*t199*t201*t33*t36*t37*t39*t41+1.2d+1*t105*t201*t245*t
     >         39*t41-1.2704999718189527d-2*t200*t33*t354*t36*t37*t41-4.
     ?         2349999060631754d-3*t200*t30*t33*t36*t37*t38*t39-4.234999
     @         9060631754d-3*t199*t30*t33*t36*t37*t38*t39-4.0d+0*t105*t2
     1         45*t30*t38*t39+1.2704999718189527d-2*t200*t201*t30*t33*t3
     2         6*t37+4.2349999060631754d-3*t199*t201*t30*t33*t36*t37+4.0
     3         d+0*t105*t201*t245*t30)*wght+2.0d+0*t247*t29*wght+1.0d+0*
     4         t1*t188*t243*wght
            t436 = -1.6939999624252702d-2*t103*t33*t95*t96*t97+8.4699998
     1         12126351d-3*t194*t33*t37*t97+5.081999887275811d-2*t100*t1
     2         03*t104*t37*t97+2.5409999436379055d-2*t100*t104*t36*t95*t
     3         96+4.2349999060631754d-3*t188*t33*t36*t96-2.5409999436379
     4         055d-2*t195*t32*t36*t37-1.2704999718189527d-2*t104*t191*t
     5         36*t37-2.5409999436379055d-2*t196*t197*t33*t37-8.46999981
     6         2126351d-3*t126*t127*t33*t36
            t437 = 1.6939999624252702d-2*t103*t33*t95*t96*t97-8.46999981
     1         2126351d-3*t194*t33*t37*t97-5.081999887275811d-2*t100*t10
     2         3*t104*t37*t97-2.5409999436379055d-2*t100*t104*t36*t95*t9
     3         6-4.2349999060631754d-3*t188*t33*t36*t96+2.54099994363790
     4         55d-2*t195*t32*t36*t37+1.2704999718189527d-2*t104*t191*t3
     5         6*t37+2.5409999436379055d-2*t196*t197*t33*t37+8.469999812
     6         126351d-3*t126*t127*t33*t36
            t438 = 4.2349999060631754d-3*t119*t33*t95*t96*t97+4.23499990
     1         60631754d-3*t103*t117*t33*t96*t97-4.2349999060631754d-3*t
     2         217*t33*t37*t97-1.2704999718189527d-2*t100*t104*t119*t37*
     3         t97-1.2704999718189527d-2*t103*t104*t118*t37*t97-6.352499
     4         859094763d-3*t104*t118*t36*t95*t96-2.1174999530315877d-3*
     5         t215*t33*t36*t96-6.352499859094763d-3*t100*t104*t117*t36*
     6         t96+4.2349999060631754d-3*t117*t127*t33*t36*t95+1.2704999
     7         718189527d-2*t100*t118*t32*t36*t37+6.352499859094763d-3*t
     8         104*t216*t36*t37+1.2704999718189527d-2*t103*t119*t196*t33
     9         *t37
            t439 = -4.2349999060631754d-3*t119*t33*t95*t96*t97-4.2349999
     1         060631754d-3*t103*t117*t33*t96*t97+4.2349999060631754d-3*
     2         t217*t33*t37*t97+1.2704999718189527d-2*t100*t104*t119*t37
     3         *t97+1.2704999718189527d-2*t103*t104*t118*t37*t97+6.35249
     4         9859094763d-3*t104*t118*t36*t95*t96+2.1174999530315877d-3
     5         *t215*t33*t36*t96+6.352499859094763d-3*t100*t104*t117*t36
     6         *t96-4.2349999060631754d-3*t117*t127*t33*t36*t95-1.270499
     7         9718189527d-2*t100*t118*t32*t36*t37-6.352499859094763d-3*
     8         t104*t216*t36*t37-1.2704999718189527d-2*t103*t119*t196*t3
     9         3*t37
            t440 = 1.0d+0*t1*t256*t95*wght+1.0d+0*t243*t95*wght+1.0d+0*t
     1         1*t29*(5.0d+0*t107*t439*t55*t56+2.1174999530315877d-2*t20
     2         4*t219*t33*t36*t37*t55*t56-6.352499859094763d-2*t106*t121
     3         *t203*t33*t36*t37*t55*t56-1.0d+1*t106*t204*t255*t55*t56-1
     4         .0d+1*t121*t204*t246*t55*t56+2.5409999436379055d-1*t106*t
     5         121*t33*t357*t36*t37*t53*t56-4.2349999060631754d-2*t203*t
     6         219*t33*t36*t37*t53*t56+2.0d+1*t106*t203*t255*t53*t56+2.0
     7         d+1*t121*t203*t246*t53*t56-1.2704999718189527d-1*t106*t12
     8         1*t33*t356*t36*t37*t51*t56+4.0d+0*t107*t439*t53*t54+1.693
     9         9999624252702d-2*t204*t219*t33*t36*t37*t53*t54-5.08199988
     :         7275811d-2*t106*t121*t203*t33*t36*t37*t53*t54-8.0d+0*t106
     ;         *t204*t255*t53*t54-8.0d+0*t121*t204*t246*t53*t54+1.524599
     <         966182743d-1*t106*t121*t33*t357*t36*t37*t51*t54-2.5409999
     =         436379055d-2*t203*t219*t33*t36*t37*t51*t54+1.2d+1*t106*t2
     >         03*t255*t51*t54+1.2d+1*t121*t203*t246*t51*t54-5.081999887
     ?         275811d-2*t106*t121*t33*t356*t36*t37*t49*t54+3.0d+0*t107*
     @         t439*t51*t52+1.2704999718189527d-2*t204*t219*t33*t36*t37*
     1         t51*t52-3.8114999154568574d-2*t106*t121*t203*t33*t36*t37*
     2         t51*t52-6.0d+0*t106*t204*t255*t51*t52-6.0d+0*t121*t204*t2
     3         46*t51*t52+7.622999830913715d-2*t106*t121*t33*t357*t36*t3
     4         7*t49*t52-1.2704999718189527d-2*t203*t219*t33*t36*t37*t49
     5         *t52+6.0d+0*t106*t203*t255*t49*t52+6.0d+0*t121*t203*t246*
     6         t49*t52-1.2704999718189527d-2*t106*t121*t33*t356*t36*t37*
     7         t52+2.0d+0*t107*t439*t49*t50+8.469999812126351d-3*t204*t2
     8         19*t33*t36*t37*t49*t50-2.5409999436379055d-2*t106*t121*t2
     9         03*t33*t36*t37*t49*t50-4.0d+0*t106*t204*t255*t49*t50-4.0d
     :         +0*t121*t204*t246*t49*t50+2.5409999436379055d-2*t106*t121
     ;         *t33*t357*t36*t37*t50-4.2349999060631754d-3*t203*t219*t33
     <         *t36*t37*t50+2.0d+0*t106*t203*t255*t50+2.0d+0*t121*t203*t
     =         246*t50+1.0d+0*t107*t439*t47+4.2349999060631754d-3*t204*t
     >         219*t33*t36*t37*t47-1.2704999718189527d-2*t106*t121*t203*
     ?         t33*t36*t37*t47-2.0d+0*t106*t204*t255*t47-2.0d+0*t121*t20
     @         4*t246*t47-t38*t438*t46-2.1174999530315877d-3*t218*t33*t3
     1         6*t37*t38*t46-2.1174999530315877d-3*t105*t120*t33*t36*t37
     2         *t38*t46-t105*t254*t38*t46-t120*t245*t38*t46-5.0d+0*t38*t
     3         438*t44*t45-1.0587499765157939d-2*t218*t33*t36*t37*t38*t4
     4         4*t45-1.0587499765157939d-2*t105*t120*t33*t36*t37*t38*t44
     5         *t45-5.0d+0*t105*t254*t38*t44*t45-5.0d+0*t120*t245*t38*t4
     6         4*t45+4.2349999060631754d-2*t201*t218*t33*t36*t37*t42*t45
     7         +1.2704999718189527d-1*t105*t120*t201*t33*t36*t37*t42*t45
     8         +2.0d+1*t105*t201*t254*t42*t45+2.0d+1*t120*t201*t245*t42*
     9         t45-1.2704999718189527d-1*t105*t120*t33*t354*t36*t37*t40*
     :         t45-4.0d+0*t38*t42*t43*t438-3.0d+0*t38*t40*t41*t438-2.0d+
     ;         0*t30*t38*t39*t438-8.469999812126351d-3*t218*t33*t36*t37*
     <         t38*t42*t43-8.469999812126351d-3*t105*t120*t33*t36*t37*t3
     =         8*t42*t43-4.0d+0*t105*t254*t38*t42*t43-4.0d+0*t120*t245*t
     >         38*t42*t43+2.5409999436379055d-2*t201*t218*t33*t36*t37*t4
     ?         0*t43+7.622999830913715d-2*t105*t120*t201*t33*t36*t37*t40
     @         *t43+1.2d+1*t105*t201*t254*t40*t43+1.2d+1*t120*t201*t245*
     1         t40*t43-5.081999887275811d-2*t105*t120*t33*t354*t36*t37*t
     2         39*t43-6.352499859094763d-3*t218*t33*t36*t37*t38*t40*t41-
     3         6.352499859094763d-3*t105*t120*t33*t36*t37*t38*t40*t41-3.
     4         0d+0*t105*t254*t38*t40*t41-3.0d+0*t120*t245*t38*t40*t41+1
     5         .2704999718189527d-2*t201*t218*t33*t36*t37*t39*t41+3.8114
     6         999154568574d-2*t105*t120*t201*t33*t36*t37*t39*t41+6.0d+0
     7         *t105*t201*t254*t39*t41+6.0d+0*t120*t201*t245*t39*t41-1.2
     8         704999718189527d-2*t105*t120*t33*t354*t36*t37*t41-4.23499
     9         99060631754d-3*t218*t30*t33*t36*t37*t38*t39-4.23499990606
     :         31754d-3*t105*t120*t30*t33*t36*t37*t38*t39-2.0d+0*t105*t2
     ;         54*t30*t38*t39-2.0d+0*t120*t245*t30*t38*t39+4.23499990606
     <         31754d-3*t201*t218*t30*t33*t36*t37+1.2704999718189527d-2*
     =         t105*t120*t201*t30*t33*t36*t37+2.0d+0*t105*t201*t254*t30+
     >         2.0d+0*t120*t201*t245*t30)*wght+1.0d+0*t256*t29*wght+1.0d
     ?         +0*t247*t29*wght+1.0d+0*t1*t117*t247*wght+1.0d+0*t1*t215*
     @         t243*wght+1.0d+0*t117*t243*wght
            t441 = 8.469999812126351d-3*t119*t33*t95*t96*t97+8.469999812
     1         126351d-3*t103*t117*t33*t96*t97-8.469999812126351d-3*t217
     2         *t33*t37*t97-2.5409999436379055d-2*t100*t104*t119*t37*t97
     3         -2.5409999436379055d-2*t103*t104*t118*t37*t97-1.270499971
     4         8189527d-2*t104*t118*t36*t95*t96-4.2349999060631754d-3*t2
     5         15*t33*t36*t96-1.2704999718189527d-2*t100*t104*t117*t36*t
     6         96+8.469999812126351d-3*t117*t127*t33*t36*t95+2.540999943
     7         6379055d-2*t100*t118*t32*t36*t37+1.2704999718189527d-2*t1
     8         04*t216*t36*t37+2.5409999436379055d-2*t103*t119*t196*t33*
     9         t37
            t442 = -8.469999812126351d-3*t119*t33*t95*t96*t97-8.46999981
     1         2126351d-3*t103*t117*t33*t96*t97+8.469999812126351d-3*t21
     2         7*t33*t37*t97+2.5409999436379055d-2*t100*t104*t119*t37*t9
     3         7+2.5409999436379055d-2*t103*t104*t118*t37*t97+1.27049997
     4         18189527d-2*t104*t118*t36*t95*t96+4.2349999060631754d-3*t
     5         215*t33*t36*t96+1.2704999718189527d-2*t100*t104*t117*t36*
     6         t96-8.469999812126351d-3*t117*t127*t33*t36*t95-2.54099994
     7         36379055d-2*t100*t118*t32*t36*t37-1.2704999718189527d-2*t
     8         104*t216*t36*t37-2.5409999436379055d-2*t103*t119*t196*t33
     9         *t37
            t443 = -8.469999812126351d-3*t117*t119*t33*t96*t97+4.2349999
     1         060631754d-3*t235*t33*t37*t97+2.5409999436379055d-2*t104*
     2         t118*t119*t37*t97+2.1174999530315877d-3*t233*t33*t36*t96+
     3         1.2704999718189527d-2*t104*t117*t118*t36*t96-1.2704999718
     4         189527d-2*t236*t32*t36*t37-6.352499859094763d-3*t104*t234
     5         *t36*t37-1.2704999718189527d-2*t196*t237*t33*t37-4.234999
     6         9060631754d-3*t127*t221*t33*t36
            t444 = 8.469999812126351d-3*t117*t119*t33*t96*t97-4.23499990
     1         60631754d-3*t235*t33*t37*t97-2.5409999436379055d-2*t104*t
     2         118*t119*t37*t97-2.1174999530315877d-3*t233*t33*t36*t96-1
     3         .2704999718189527d-2*t104*t117*t118*t36*t96+1.27049997181
     4         89527d-2*t236*t32*t36*t37+6.352499859094763d-3*t104*t234*
     5         t36*t37+1.2704999718189527d-2*t196*t237*t33*t37+4.2349999
     6         060631754d-3*t127*t221*t33*t36
            t445 = 1.0d+0*t1*t29*(5.0d+0*t107*t443*t55*t56-6.35249985909
     1         4763d-2*t203*t241*t33*t36*t37*t55*t56+2.1174999530315877d
     2         -2*t204*t238*t33*t36*t37*t55*t56-2.0d+1*t121*t204*t255*t5
     3         5*t56+2.5409999436379055d-1*t241*t33*t357*t36*t37*t53*t56
     4         -4.2349999060631754d-2*t203*t238*t33*t36*t37*t53*t56+4.0d
     5         +1*t121*t203*t255*t53*t56-1.2704999718189527d-1*t241*t33*
     6         t356*t36*t37*t51*t56+4.0d+0*t107*t443*t53*t54-5.081999887
     7         275811d-2*t203*t241*t33*t36*t37*t53*t54+1.693999962425270
     8         2d-2*t204*t238*t33*t36*t37*t53*t54-1.6d+1*t121*t204*t255*
     9         t53*t54+1.524599966182743d-1*t241*t33*t357*t36*t37*t51*t5
     :         4-2.5409999436379055d-2*t203*t238*t33*t36*t37*t51*t54+2.4
     ;         d+1*t121*t203*t255*t51*t54-5.081999887275811d-2*t241*t33*
     <         t356*t36*t37*t49*t54+3.0d+0*t107*t443*t51*t52-3.811499915
     =         4568574d-2*t203*t241*t33*t36*t37*t51*t52+1.27049997181895
     >         27d-2*t204*t238*t33*t36*t37*t51*t52-1.2d+1*t121*t204*t255
     ?         *t51*t52+7.622999830913715d-2*t241*t33*t357*t36*t37*t49*t
     @         52-1.2704999718189527d-2*t203*t238*t33*t36*t37*t49*t52+1.
     1         2d+1*t121*t203*t255*t49*t52-1.2704999718189527d-2*t241*t3
     2         3*t356*t36*t37*t52+2.0d+0*t107*t443*t49*t50-2.54099994363
     3         79055d-2*t203*t241*t33*t36*t37*t49*t50+8.469999812126351d
     4         -3*t204*t238*t33*t36*t37*t49*t50-8.0d+0*t121*t204*t255*t4
     5         9*t50+2.5409999436379055d-2*t241*t33*t357*t36*t37*t50-4.2
     6         349999060631754d-3*t203*t238*t33*t36*t37*t50+4.0d+0*t121*
     7         t203*t255*t50+1.0d+0*t107*t443*t47-1.2704999718189527d-2*
     8         t203*t241*t33*t36*t37*t47+4.2349999060631754d-3*t204*t238
     9         *t33*t36*t37*t47-4.0d+0*t121*t204*t255*t47-t38*t444*t46-2
     :         .1174999530315877d-3*t240*t33*t36*t37*t38*t46-2.117499953
     ;         0315877d-3*t239*t33*t36*t37*t38*t46-2*t120*t254*t38*t46-5
     <         .0d+0*t38*t44*t444*t45-1.0587499765157939d-2*t240*t33*t36
     =         *t37*t38*t44*t45-1.0587499765157939d-2*t239*t33*t36*t37*t
     >         38*t44*t45-1.0d+1*t120*t254*t38*t44*t45+1.270499971818952
     ?         7d-1*t201*t240*t33*t36*t37*t42*t45+4.2349999060631754d-2*
     @         t201*t239*t33*t36*t37*t42*t45+4.0d+1*t120*t201*t254*t42*t
     1         45-1.2704999718189527d-1*t240*t33*t354*t36*t37*t40*t45-4.
     2         0d+0*t38*t42*t43*t444-3.0d+0*t38*t40*t41*t444-2.0d+0*t30*
     3         t38*t39*t444-8.469999812126351d-3*t240*t33*t36*t37*t38*t4
     4         2*t43-8.469999812126351d-3*t239*t33*t36*t37*t38*t42*t43-8
     5         .0d+0*t120*t254*t38*t42*t43+7.622999830913715d-2*t201*t24
     6         0*t33*t36*t37*t40*t43+2.5409999436379055d-2*t201*t239*t33
     7         *t36*t37*t40*t43+2.4d+1*t120*t201*t254*t40*t43-5.08199988
     8         7275811d-2*t240*t33*t354*t36*t37*t39*t43-6.35249985909476
     9         3d-3*t240*t33*t36*t37*t38*t40*t41-6.352499859094763d-3*t2
     :         39*t33*t36*t37*t38*t40*t41-6.0d+0*t120*t254*t38*t40*t41+3
     ;         .8114999154568574d-2*t201*t240*t33*t36*t37*t39*t41+1.2704
     <         999718189527d-2*t201*t239*t33*t36*t37*t39*t41+1.2d+1*t120
     =         *t201*t254*t39*t41-1.2704999718189527d-2*t240*t33*t354*t3
     >         6*t37*t41-4.2349999060631754d-3*t240*t30*t33*t36*t37*t38*
     ?         t39-4.2349999060631754d-3*t239*t30*t33*t36*t37*t38*t39-4.
     @         0d+0*t120*t254*t30*t38*t39+1.2704999718189527d-2*t201*t24
     1         0*t30*t33*t36*t37+4.2349999060631754d-3*t201*t239*t30*t33
     2         *t36*t37+4.0d+0*t120*t201*t254*t30)*wght+2.0d+0*t256*t29*
     3         wght+2.0d+0*t1*t117*t256*wght+1.0d+0*t1*t233*t243*wght+2.
     4         0d+0*t117*t243*wght
            t446 = -1.6939999624252702d-2*t117*t119*t33*t96*t97+8.469999
     1         812126351d-3*t235*t33*t37*t97+5.081999887275811d-2*t104*t
     2         118*t119*t37*t97+4.2349999060631754d-3*t233*t33*t36*t96+2
     3         .5409999436379055d-2*t104*t117*t118*t36*t96-2.54099994363
     4         79055d-2*t236*t32*t36*t37-1.2704999718189527d-2*t104*t234
     5         *t36*t37-2.5409999436379055d-2*t196*t237*t33*t37-8.469999
     6         812126351d-3*t127*t221*t33*t36
            t447 = 1.6939999624252702d-2*t117*t119*t33*t96*t97-8.4699998
     1         12126351d-3*t235*t33*t37*t97-5.081999887275811d-2*t104*t1
     2         18*t119*t37*t97-4.2349999060631754d-3*t233*t33*t36*t96-2.
     3         5409999436379055d-2*t104*t117*t118*t36*t96+2.540999943637
     4         9055d-2*t236*t32*t36*t37+1.2704999718189527d-2*t104*t234*
     5         t36*t37+2.5409999436379055d-2*t196*t237*t33*t37+8.4699998
     6         12126351d-3*t127*t221*t33*t36
            t448 = -4.483806051088776d-5*t196*t204*t261*t55*t56*t96+8.96
     1         7612102177552d-5*t196*t203*t261*t53*t56*t96-3.58704484087
     2         10215d-5*t196*t204*t261*t53*t54*t96+5.380567261306531d-5*
     3         t196*t203*t261*t51*t54*t96-2.6902836306532657d-5*t196*t20
     4         4*t261*t51*t52*t96+2.6902836306532657d-5*t196*t203*t261*t
     5         49*t52*t96-1.7935224204355107d-5*t196*t204*t261*t49*t50*t
     6         96+8.967612102177553d-6*t196*t203*t261*t50*t96-8.96761210
     7         2177553d-6*t196*t204*t261*t47*t96-4.483806051088777d-6*t1
     8         96*t261*t38*t46*t96-2.241903025544388d-5*t196*t261*t38*t4
     9         4*t45*t96+8.967612102177552d-5*t196*t201*t261*t42*t45*t96
     :         -1.7935224204355107d-5*t196*t261*t38*t42*t43*t96+5.380567
     ;         261306531d-5*t196*t201*t261*t40*t43*t96-1.345141815326632
     <         9d-5*t196*t261*t38*t40*t41*t96+2.6902836306532657d-5*t196
     =         *t201*t261*t39*t41*t96-8.967612102177553d-6*t196*t261*t30
     >         *t38*t39*t96+8.967612102177553d-6*t196*t201*t261*t30*t96
            t449 = 1.0d+0*t29*t448*wght
            t450 = -4.2349999060631754d-3*t245*t33*t36*t37*t38*t46
            t451 = -1.2704999718189527d-2*t245*t33*t36*t37*t38*t40*t41
            t452 = -1.6939999624252702d-2*t245*t33*t36*t37*t38*t42*t43
            t453 = -2.1174999530315877d-2*t245*t33*t36*t37*t38*t44*t45
            t454 = -8.469999812126351d-3*t245*t30*t33*t36*t37*t38*t39
            t455 = 8.469999812126351d-3*t201*t245*t30*t33*t36*t37
            t456 = 5.081999887275811d-2*t201*t245*t33*t36*t37*t40*t43
            t457 = 8.469999812126351d-2*t201*t245*t33*t36*t37*t42*t45
            t458 = 2.5409999436379055d-2*t201*t245*t33*t36*t37*t39*t41
            t459 = -8.469999812126351d-3*t203*t246*t33*t36*t37*t50
            t460 = 8.469999812126351d-3*t204*t246*t33*t36*t37*t47
            t461 = -2.5409999436379055d-2*t203*t246*t33*t36*t37*t49*t52
            t462 = 1.6939999624252702d-2*t204*t246*t33*t36*t37*t49*t50
            t463 = -5.081999887275811d-2*t203*t246*t33*t36*t37*t51*t54
            t464 = 2.5409999436379055d-2*t204*t246*t33*t36*t37*t51*t52
            t465 = -8.469999812126351d-2*t203*t246*t33*t36*t37*t53*t56
            t466 = 3.3879999248505405d-2*t204*t246*t33*t36*t37*t53*t54
            t467 = 4.2349999060631754d-2*t204*t246*t33*t36*t37*t55*t56
            t468 = 1.0d+0*t1*t29*(1.3451418153266329d-4*t106*t196*t203*t
     1         261*t55*t56*t96-5.380567261306531d-4*t106*t196*t261*t357*
     2         t53*t56*t96+2.6902836306532657d-4*t106*t196*t261*t356*t51
     3         *t56*t96+1.0761134522613064d-4*t106*t196*t203*t261*t53*t5
     4         4*t96-3.228340356783919d-4*t106*t196*t261*t357*t51*t54*t9
     5         6+1.0761134522613064d-4*t106*t196*t261*t356*t49*t54*t96+8
     6         .070850891959798d-5*t106*t196*t203*t261*t51*t52*t96-1.614
     7         1701783919596d-4*t106*t196*t261*t357*t49*t52*t96+2.690283
     8         6306532657d-5*t106*t196*t261*t356*t52*t96+5.3805672613065
     9         31d-5*t106*t196*t203*t261*t49*t50*t96-5.380567261306531d-
     :         5*t106*t196*t261*t357*t50*t96+2.6902836306532657d-5*t106*
     ;         t196*t203*t261*t47*t96-4.483806051088777d-6*t105*t196*t26
     <         1*t38*t46*t96-2.241903025544388d-5*t105*t196*t261*t38*t44
     =         *t45*t96+2.6902836306532657d-4*t105*t196*t201*t261*t42*t4
     >         5*t96-2.6902836306532657d-4*t105*t196*t261*t354*t40*t45*t
     ?         96-1.7935224204355107d-5*t105*t196*t261*t38*t42*t43*t96+1
     @         .6141701783919596d-4*t105*t196*t201*t261*t40*t43*t96-1.07
     1         61134522613064d-4*t105*t196*t261*t354*t39*t43*t96-1.34514
     2         18153266329d-5*t105*t196*t261*t38*t40*t41*t96+8.070850891
     3         959798d-5*t105*t196*t201*t261*t39*t41*t96-2.6902836306532
     4         657d-5*t105*t196*t261*t354*t41*t96-8.967612102177553d-6*t
     5         105*t196*t261*t30*t38*t39*t96+2.6902836306532657d-5*t105*
     6         t196*t201*t261*t30*t96+t467+t466+t465+t464+t463+t462+t461
     7         +t460+t459+t458+t457+t456+t455+t454+t453+t452+t451+t450)*
     8         wght+1.0d+0*t1*t448*t95*wght+t449
            t469 = -8.967612102177552d-5*t196*t204*t261*t55*t56*t96+1.79
     1         35224204355105d-4*t196*t203*t261*t53*t56*t96-7.1740896817
     2         42043d-5*t196*t204*t261*t53*t54*t96+1.0761134522613064d-4
     3         *t196*t203*t261*t51*t54*t96-5.380567261306531d-5*t196*t20
     4         4*t261*t51*t52*t96+5.380567261306531d-5*t196*t203*t261*t4
     5         9*t52*t96-3.5870448408710215d-5*t196*t204*t261*t49*t50*t9
     6         6+1.7935224204355107d-5*t196*t203*t261*t50*t96-1.79352242
     7         04355107d-5*t196*t204*t261*t47*t96-8.967612102177553d-6*t
     8         196*t261*t38*t46*t96-4.483806051088776d-5*t196*t261*t38*t
     9         44*t45*t96+1.7935224204355105d-4*t196*t201*t261*t42*t45*t
     :         96-3.5870448408710215d-5*t196*t261*t38*t42*t43*t96+1.0761
     ;         134522613064d-4*t196*t201*t261*t40*t43*t96-2.690283630653
     <         2657d-5*t196*t261*t38*t40*t41*t96+5.380567261306531d-5*t1
     =         96*t201*t261*t39*t41*t96-1.7935224204355107d-5*t196*t261*
     >         t30*t38*t39*t96+1.7935224204355107d-5*t196*t201*t261*t30*
     ?         t96
            t470 = 1.0d+0*t29*t469*wght
            t471 = 1.0d+0*t1*t29*(2.6902836306532657d-4*t106*t196*t203*t
     1         261*t55*t56*t96-1.0761134522613064d-3*t106*t196*t261*t357
     2         *t53*t56*t96+5.380567261306531d-4*t106*t196*t261*t356*t51
     3         *t56*t96+2.1522269045226128d-4*t106*t196*t203*t261*t53*t5
     4         4*t96-6.456680713567838d-4*t106*t196*t261*t357*t51*t54*t9
     5         6+2.1522269045226128d-4*t106*t196*t261*t356*t49*t54*t96+1
     6         .6141701783919596d-4*t106*t196*t203*t261*t51*t52*t96-3.22
     7         8340356783919d-4*t106*t196*t261*t357*t49*t52*t96+5.380567
     8         261306531d-5*t106*t196*t261*t356*t52*t96+1.07611345226130
     9         64d-4*t106*t196*t203*t261*t49*t50*t96-1.0761134522613064d
     :         -4*t106*t196*t261*t357*t50*t96+5.380567261306531d-5*t106*
     ;         t196*t203*t261*t47*t96-8.967612102177553d-6*t105*t196*t26
     <         1*t38*t46*t96-4.483806051088776d-5*t105*t196*t261*t38*t44
     =         *t45*t96+5.380567261306531d-4*t105*t196*t201*t261*t42*t45
     >         *t96-5.380567261306531d-4*t105*t196*t261*t354*t40*t45*t96
     ?         -3.5870448408710215d-5*t105*t196*t261*t38*t42*t43*t96+3.2
     @         28340356783919d-4*t105*t196*t201*t261*t40*t43*t96-2.15222
     1         69045226128d-4*t105*t196*t261*t354*t39*t43*t96-2.69028363
     2         06532657d-5*t105*t196*t261*t38*t40*t41*t96+1.614170178391
     3         9596d-4*t105*t196*t201*t261*t39*t41*t96-5.380567261306531
     4         d-5*t105*t196*t261*t354*t41*t96-1.7935224204355107d-5*t10
     5         5*t196*t261*t30*t38*t39*t96+5.380567261306531d-5*t105*t19
     6         6*t201*t261*t30*t96+2.1174999530315877d-2*t204*t252*t33*t
     7         36*t37*t55*t56-4.2349999060631754d-2*t203*t252*t33*t36*t3
     8         7*t53*t56+1.6939999624252702d-2*t204*t252*t33*t36*t37*t53
     9         *t54-2.5409999436379055d-2*t203*t252*t33*t36*t37*t51*t54+
     :         1.2704999718189527d-2*t204*t252*t33*t36*t37*t51*t52-1.270
     ;         4999718189527d-2*t203*t252*t33*t36*t37*t49*t52+8.46999981
     <         2126351d-3*t204*t252*t33*t36*t37*t49*t50-4.23499990606317
     =         54d-3*t203*t252*t33*t36*t37*t50+4.2349999060631754d-3*t20
     >         4*t252*t33*t36*t37*t47+t467+t466+t465+t464+t463+t462+t461
     ?         +t460-2.1174999530315877d-3*t251*t33*t36*t37*t38*t46+t459
     @         +t458+t457+t456+t455+t454+t453+t452+t451+t450-1.058749976
     1         5157939d-2*t251*t33*t36*t37*t38*t44*t45+4.234999906063175
     2         4d-2*t201*t251*t33*t36*t37*t42*t45-8.469999812126351d-3*t
     3         251*t33*t36*t37*t38*t42*t43+2.5409999436379055d-2*t201*t2
     4         51*t33*t36*t37*t40*t43-6.352499859094763d-3*t251*t33*t36*
     5         t37*t38*t40*t41+1.2704999718189527d-2*t201*t251*t33*t36*t
     6         37*t39*t41-4.2349999060631754d-3*t251*t30*t33*t36*t37*t38
     7         *t39+4.2349999060631754d-3*t201*t251*t30*t33*t36*t37)*wgh
     8         t+1.0d+0*t1*t469*t95*wght+t470
            t472 = -1.7935224204355105d-4*t196*t204*t261*t55*t56*t96+3.5
     1         87044840871021d-4*t196*t203*t261*t53*t56*t96-1.4348179363
     2         484087d-4*t196*t204*t261*t53*t54*t96+2.1522269045226128d-
     3         4*t196*t203*t261*t51*t54*t96-1.0761134522613064d-4*t196*t
     4         204*t261*t51*t52*t96+1.0761134522613064d-4*t196*t203*t261
     5         *t49*t52*t96-7.174089681742043d-5*t196*t204*t261*t49*t50*
     6         t96+3.5870448408710215d-5*t196*t203*t261*t50*t96-3.587044
     7         8408710215d-5*t196*t204*t261*t47*t96-1.7935224204355107d-
     8         5*t196*t261*t38*t46*t96-8.967612102177552d-5*t196*t261*t3
     9         8*t44*t45*t96+3.587044840871021d-4*t196*t201*t261*t42*t45
     :         *t96-7.174089681742043d-5*t196*t261*t38*t42*t43*t96+2.152
     ;         2269045226128d-4*t196*t201*t261*t40*t43*t96-5.38056726130
     <         6531d-5*t196*t261*t38*t40*t41*t96+1.0761134522613064d-4*t
     =         196*t201*t261*t39*t41*t96-3.5870448408710215d-5*t196*t261
     >         *t30*t38*t39*t96+3.5870448408710215d-5*t196*t201*t261*t30
     ?         *t96
            t473 = 1.0d+0*t29*t472*wght
            t474 = -4.2349999060631754d-3*t254*t33*t36*t37*t38*t46
            t475 = -1.2704999718189527d-2*t254*t33*t36*t37*t38*t40*t41
            t476 = -1.6939999624252702d-2*t254*t33*t36*t37*t38*t42*t43
            t477 = -2.1174999530315877d-2*t254*t33*t36*t37*t38*t44*t45
            t478 = -8.469999812126351d-3*t254*t30*t33*t36*t37*t38*t39
            t479 = 8.469999812126351d-3*t201*t254*t30*t33*t36*t37
            t480 = 5.081999887275811d-2*t201*t254*t33*t36*t37*t40*t43
            t481 = 8.469999812126351d-2*t201*t254*t33*t36*t37*t42*t45
            t482 = 2.5409999436379055d-2*t201*t254*t33*t36*t37*t39*t41
            t483 = -8.469999812126351d-3*t203*t255*t33*t36*t37*t50
            t484 = 8.469999812126351d-3*t204*t255*t33*t36*t37*t47
            t485 = -2.5409999436379055d-2*t203*t255*t33*t36*t37*t49*t52
            t486 = 1.6939999624252702d-2*t204*t255*t33*t36*t37*t49*t50
            t487 = -5.081999887275811d-2*t203*t255*t33*t36*t37*t51*t54
            t488 = 2.5409999436379055d-2*t204*t255*t33*t36*t37*t51*t52
            t489 = -8.469999812126351d-2*t203*t255*t33*t36*t37*t53*t56
            t490 = 3.3879999248505405d-2*t204*t255*t33*t36*t37*t53*t54
            t491 = 4.2349999060631754d-2*t204*t255*t33*t36*t37*t55*t56
            t492 = 1.0d+0*t1*t29*(1.3451418153266329d-4*t121*t196*t203*t
     1         261*t55*t56*t96-5.380567261306531d-4*t121*t196*t261*t357*
     2         t53*t56*t96+2.6902836306532657d-4*t121*t196*t261*t356*t51
     3         *t56*t96+1.0761134522613064d-4*t121*t196*t203*t261*t53*t5
     4         4*t96-3.228340356783919d-4*t121*t196*t261*t357*t51*t54*t9
     5         6+1.0761134522613064d-4*t121*t196*t261*t356*t49*t54*t96+8
     6         .070850891959798d-5*t121*t196*t203*t261*t51*t52*t96-1.614
     7         1701783919596d-4*t121*t196*t261*t357*t49*t52*t96+2.690283
     8         6306532657d-5*t121*t196*t261*t356*t52*t96+5.3805672613065
     9         31d-5*t121*t196*t203*t261*t49*t50*t96-5.380567261306531d-
     :         5*t121*t196*t261*t357*t50*t96+2.6902836306532657d-5*t121*
     ;         t196*t203*t261*t47*t96-4.483806051088777d-6*t120*t196*t26
     <         1*t38*t46*t96-2.241903025544388d-5*t120*t196*t261*t38*t44
     =         *t45*t96+2.6902836306532657d-4*t120*t196*t201*t261*t42*t4
     >         5*t96-2.6902836306532657d-4*t120*t196*t261*t354*t40*t45*t
     ?         96-1.7935224204355107d-5*t120*t196*t261*t38*t42*t43*t96+1
     @         .6141701783919596d-4*t120*t196*t201*t261*t40*t43*t96-1.07
     1         61134522613064d-4*t120*t196*t261*t354*t39*t43*t96-1.34514
     2         18153266329d-5*t120*t196*t261*t38*t40*t41*t96+8.070850891
     3         959798d-5*t120*t196*t201*t261*t39*t41*t96-2.6902836306532
     4         657d-5*t120*t196*t261*t354*t41*t96-8.967612102177553d-6*t
     5         120*t196*t261*t30*t38*t39*t96+2.6902836306532657d-5*t120*
     6         t196*t201*t261*t30*t96+t491+t490+t489+t488+t487+t486+t485
     7         +t484+t483+t482+t481+t480+t479+t478+t477+t476+t475+t474)*
     8         wght+1.0d+0*t1*t117*t448*wght+t449
            t493 = 1.0d+0*t1*t29*(2.6902836306532657d-4*t121*t196*t203*t
     1         261*t55*t56*t96-1.0761134522613064d-3*t121*t196*t261*t357
     2         *t53*t56*t96+5.380567261306531d-4*t121*t196*t261*t356*t51
     3         *t56*t96+2.1522269045226128d-4*t121*t196*t203*t261*t53*t5
     4         4*t96-6.456680713567838d-4*t121*t196*t261*t357*t51*t54*t9
     5         6+2.1522269045226128d-4*t121*t196*t261*t356*t49*t54*t96+1
     6         .6141701783919596d-4*t121*t196*t203*t261*t51*t52*t96-3.22
     7         8340356783919d-4*t121*t196*t261*t357*t49*t52*t96+5.380567
     8         261306531d-5*t121*t196*t261*t356*t52*t96+1.07611345226130
     9         64d-4*t121*t196*t203*t261*t49*t50*t96-1.0761134522613064d
     :         -4*t121*t196*t261*t357*t50*t96+5.380567261306531d-5*t121*
     ;         t196*t203*t261*t47*t96-8.967612102177553d-6*t120*t196*t26
     <         1*t38*t46*t96-4.483806051088776d-5*t120*t196*t261*t38*t44
     =         *t45*t96+5.380567261306531d-4*t120*t196*t201*t261*t42*t45
     >         *t96-5.380567261306531d-4*t120*t196*t261*t354*t40*t45*t96
     ?         -3.5870448408710215d-5*t120*t196*t261*t38*t42*t43*t96+3.2
     @         28340356783919d-4*t120*t196*t201*t261*t40*t43*t96-2.15222
     1         69045226128d-4*t120*t196*t261*t354*t39*t43*t96-2.69028363
     2         06532657d-5*t120*t196*t261*t38*t40*t41*t96+1.614170178391
     3         9596d-4*t120*t196*t201*t261*t39*t41*t96-5.380567261306531
     4         d-5*t120*t196*t261*t354*t41*t96-1.7935224204355107d-5*t12
     5         0*t196*t261*t30*t38*t39*t96+5.380567261306531d-5*t120*t19
     6         6*t201*t261*t30*t96+2.1174999530315877d-2*t204*t259*t33*t
     7         36*t37*t55*t56-4.2349999060631754d-2*t203*t259*t33*t36*t3
     8         7*t53*t56+1.6939999624252702d-2*t204*t259*t33*t36*t37*t53
     9         *t54-2.5409999436379055d-2*t203*t259*t33*t36*t37*t51*t54+
     :         1.2704999718189527d-2*t204*t259*t33*t36*t37*t51*t52-1.270
     ;         4999718189527d-2*t203*t259*t33*t36*t37*t49*t52+8.46999981
     <         2126351d-3*t204*t259*t33*t36*t37*t49*t50-4.23499990606317
     =         54d-3*t203*t259*t33*t36*t37*t50+t491+t490+t489+t488+t487+
     >         t486+t485+t484+t483+t482+t481+t480+t479+t478+t477+t476+t4
     ?         75+t474+4.2349999060631754d-3*t204*t259*t33*t36*t37*t47-2
     @         .1174999530315877d-3*t258*t33*t36*t37*t38*t46-1.058749976
     1         5157939d-2*t258*t33*t36*t37*t38*t44*t45+4.234999906063175
     2         4d-2*t201*t258*t33*t36*t37*t42*t45-8.469999812126351d-3*t
     3         258*t33*t36*t37*t38*t42*t43+2.5409999436379055d-2*t201*t2
     4         58*t33*t36*t37*t40*t43-6.352499859094763d-3*t258*t33*t36*
     5         t37*t38*t40*t41+1.2704999718189527d-2*t201*t258*t33*t36*t
     6         37*t39*t41-4.2349999060631754d-3*t258*t30*t33*t36*t37*t38
     7         *t39+4.2349999060631754d-3*t201*t258*t30*t33*t36*t37)*wgh
     8         t+1.0d+0*t1*t117*t469*wght+t470
            t494 = t32**9
            t495 = 1/t35**6.0d+0
            t496 = 1.0d+0*t1*t29*(t107*t36*t37*(3.797783641033293d-7*t19
     1         6*t204*t494*t53*t56*t96-5.696675461549939d-7*t196*t203*t4
     2         94*t51*t56*t96+2.278670184619976d-7*t196*t204*t494*t51*t5
     3         4*t96-2.278670184619976d-7*t196*t203*t49*t494*t54*t96+1.1
     4         39335092309988d-7*t196*t204*t49*t494*t52*t96-5.6966754615
     5         4994d-8*t196*t203*t494*t52*t96+3.797783641033293d-8*t196*
     6         t204*t494*t50*t96)+t36*t37*(-9.494459102583234d-9*t196*t3
     7         8*t46*t494*t96-4.7472295512916163d-8*t196*t38*t44*t45*t49
     8         4*t96+5.696675461549939d-7*t196*t201*t42*t45*t494*t96-5.6
     9         96675461549939d-7*t196*t354*t40*t45*t494*t96-3.7977836410
     :         33293d-8*t196*t38*t42*t43*t494*t96+3.418005276929964d-7*t
     ;         196*t201*t40*t43*t494*t96-2.278670184619976d-7*t196*t354*
     <         t39*t43*t494*t96-2.84833773077497d-8*t196*t38*t40*t41*t49
     =         4*t96+1.709002638464982d-7*t196*t201*t39*t41*t494*t96-5.6
     >         9667546154994d-8*t196*t354*t41*t494*t96-1.898891820516646
     ?         6d-8*t196*t30*t38*t39*t494*t96+5.69667546154994d-8*t196*t
     @         201*t30*t494*t96)+8.469999812126351d-3*t196*t204*t262*t33
     1         *t96+2.6902836306532657d-5*t123*t127*t203*t261*t495)*wght
            t497 = t36*t37*(-1.8988918205166466d-8*t196*t38*t46*t494*t96
     1         -9.494459102583233d-8*t196*t38*t44*t45*t494*t96+1.1393350
     2         923099879d-6*t196*t201*t42*t45*t494*t96-1.139335092309987
     3         9d-6*t196*t354*t40*t45*t494*t96-7.595567282066586d-8*t196
     4         *t38*t42*t43*t494*t96+6.836010553859928d-7*t196*t201*t40*
     5         t43*t494*t96-4.557340369239952d-7*t196*t354*t39*t43*t494*
     6         t96-5.69667546154994d-8*t196*t38*t40*t41*t494*t96+3.41800
     7         5276929964d-7*t196*t201*t39*t41*t494*t96-1.13933509230998
     8         8d-7*t196*t354*t41*t494*t96-3.797783641033293d-8*t196*t30
     9         *t38*t39*t494*t96+1.139335092309988d-7*t196*t201*t30*t494
     :         *t96)
            t498 = t107*t36*t37*(7.595567282066586d-7*t196*t204*t494*t53
     1         *t56*t96-1.1393350923099879d-6*t196*t203*t494*t51*t56*t96
     2         +4.557340369239952d-7*t196*t204*t494*t51*t54*t96-4.557340
     3         369239952d-7*t196*t203*t49*t494*t54*t96+2.278670184619976
     4         d-7*t196*t204*t49*t494*t52*t96-1.139335092309988d-7*t196*
     5         t203*t494*t52*t96+7.595567282066586d-8*t196*t204*t494*t50
     6         *t96)
            t499 = 1.0d+0*t1*t29*(t196*t204*(4.2349999060631754d-3*t265*
     1         t33+8.469999812126351d-3*t262*t33)*t96+t498+t497+5.380567
     2         261306531d-5*t123*t127*t203*t261*t495)*wght
            t500 = t36*t37*(-3.797783641033293d-8*t196*t38*t46*t494*t96-
     1         1.8988918205166466d-7*t196*t38*t44*t45*t494*t96+2.2786701
     2         846199758d-6*t196*t201*t42*t45*t494*t96-2.278670184619975
     3         8d-6*t196*t354*t40*t45*t494*t96-1.5191134564133174d-7*t19
     4         6*t38*t42*t43*t494*t96+1.3672021107719856d-6*t196*t201*t4
     5         0*t43*t494*t96-9.114680738479904d-7*t196*t354*t39*t43*t49
     6         4*t96-1.139335092309988d-7*t196*t38*t40*t41*t494*t96+6.83
     7         6010553859928d-7*t196*t201*t39*t41*t494*t96-2.27867018461
     8         9976d-7*t196*t354*t41*t494*t96-7.595567282066586d-8*t196*
     9         t30*t38*t39*t494*t96+2.278670184619976d-7*t196*t201*t30*t
     :         494*t96)
            t501 = t107*t36*t37*(1.519113456413317d-6*t196*t204*t494*t53
     1         *t56*t96-2.2786701846199758d-6*t196*t203*t494*t51*t56*t96
     2         +9.114680738479904d-7*t196*t204*t494*t51*t54*t96-9.114680
     3         738479904d-7*t196*t203*t49*t494*t54*t96+4.557340369239952
     4         d-7*t196*t204*t49*t494*t52*t96-2.278670184619976d-7*t196*
     5         t203*t494*t52*t96+1.5191134564133174d-7*t196*t204*t494*t5
     6         0*t96)
            fnc(iq) = 1.0d+0*t1*t29*t57*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t57*t95*wght+1.0d+0*t1*t108*t29*w
     1         ght+t109+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t117*t57*wght+1.0d+0*t1*t122*t29*
     1         wght+t109+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t124+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 1.0d+0*t1*t29*(t36*t37*(-4.234999906063175
     1         4d-3*t33*t38*t46-2.1174999530315877d-2*t33*t38*t44*t45-1.
     2         6939999624252702d-2*t33*t38*t42*t43-1.2704999718189527d-2
     3         *t33*t38*t40*t41-8.469999812126351d-3*t30*t33*t38*t39)+t1
     4         07*t125*t36*t37)*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t124+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t57*t95*wght+2.0d+0*t1*t108*t95*
     1         wght+1.0d+0*t1*t188*t57*wght+1.0d+0*t1*t205*t29*wght+2.0d
     2         +0*t108*t29*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t57*t95*wght+1.0d+0*t1*t122*t95*
     1         wght+1.0d+0*t1*t215*t57*wght+1.0d+0*t117*t57*wght+1.0d+0*
     2         t1*t220*t29*wght+1.0d+0*t122*t29*wght+1.0d+0*t108*t29*wgh
     3         t+1.0d+0*t1*t108*t117*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t233*t57*wght+2.0d+0*t117*t57
     1         *wght+1.0d+0*t1*t242*t29*wght+2.0d+0*t122*t29*wght+2.0d+0
     2         *t1*t117*t122*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t248+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = 1.0d+0*t1*t249*t95*wght+1.0d+0*t1*t253
     1         *t29*wght+t250+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t248+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t257+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = 1.0d+0*t1*t260*t29*wght+1.0d+0*t1*t117
     1         *t249*wght+t250+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t257+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t263+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = 1.0d+0*t1*t29*(8.469999812126351d-3*t
     1         123*t196*t204*t33*t96+t266+t264)*wght+Cmat2(iq,D2_GAA_GAB
     2         )
            Cmat2(iq,D2_GAA_GBB) = t263+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 1.0d+0*t1*t29*(8.469999812126351d-3*t
     1         125*t196*t204*t33*t96+t36*t37*(-1.7935224204355107d-5*t26
     2         1*t36*t37*t38*t46-8.967612102177552d-5*t261*t36*t37*t38*t
     3         44*t45+3.587044840871021d-4*t201*t261*t36*t37*t42*t45-7.1
     4         74089681742043d-5*t261*t36*t37*t38*t42*t43+2.152226904522
     5         6128d-4*t201*t261*t36*t37*t40*t43-5.380567261306531d-5*t2
     6         61*t36*t37*t38*t40*t41+1.0761134522613064d-4*t201*t261*t3
     7         6*t37*t39*t41-3.5870448408710215d-5*t261*t30*t36*t37*t38*
     8         t39+3.5870448408710215d-5*t201*t261*t30*t36*t37)+t107*t26
     9         7*t36*t37)*wght+Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = 1.0d+0*t1*t29*(4.2349999060631754d-3*
     1         t125*t196*t204*t33*t96+t266+t264)*wght+Cmat2(iq,D2_GAB_GB
     2         B)
            Cmat2(iq,D2_GBB_GBB) = t263+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = 3.0d+0*t1*t205*t95*wght+6.0d+0*t108*
     1         t95*wght+1.0d+0*t1*t340*t57*wght+3.0d+0*t188*t57*wght+1.0
     2         d+0*t1*t29*(3.0d+1*t203*t355*t55*t56+5.0d+0*t107*t352*t55
     3         *t56-3.0d+1*t106*t198*t204*t55*t56-1.2d+2*t355*t357*t53*t
     4         56+6.0d+1*t106*t198*t203*t53*t56+6.0d+1*t355*t356*t51*t56
     5         +2.4d+1*t203*t355*t53*t54+4.0d+0*t107*t352*t53*t54-2.4d+1
     6         *t106*t198*t204*t53*t54-7.2d+1*t355*t357*t51*t54+3.6d+1*t
     7         106*t198*t203*t51*t54+2.4d+1*t355*t356*t49*t54+1.8d+1*t20
     8         3*t355*t51*t52+3.0d+0*t107*t352*t51*t52-1.8d+1*t106*t198*
     9         t204*t51*t52-3.6d+1*t355*t357*t49*t52+1.8d+1*t106*t198*t2
     :         03*t49*t52+6.0d+0*t355*t356*t52+1.2d+1*t203*t355*t49*t50+
     ;         2.0d+0*t107*t352*t49*t50-1.2d+1*t106*t198*t204*t49*t50-1.
     <         2d+1*t355*t357*t50+6.0d+0*t106*t198*t203*t50+6.0d+0*t203*
     =         t355*t47+1.0d+0*t107*t352*t47-6.0d+0*t106*t198*t204*t47-t
     >         353*t38*t46-t351*t38*t46-3*t105*t199*t38*t46-5.0d+0*t353*
     ?         t38*t44*t45-5.0d+0*t351*t38*t44*t45-1.5d+1*t105*t199*t38*
     @         t44*t45+2.0d+1*t201*t353*t42*t45+2.0d+1*t200*t201*t268*t4
     1         2*t45+6.0d+1*t105*t199*t201*t42*t45-6.0d+1*t353*t354*t40*
     2         t45-4.0d+0*t353*t38*t42*t43-4.0d+0*t351*t38*t42*t43-1.2d+
     3         1*t105*t199*t38*t42*t43+1.2d+1*t201*t353*t40*t43+1.2d+1*t
     4         200*t201*t268*t40*t43+3.6d+1*t105*t199*t201*t40*t43-2.4d+
     5         1*t353*t354*t39*t43-3.0d+0*t353*t38*t40*t41-3.0d+0*t351*t
     6         38*t40*t41-9.0d+0*t105*t199*t38*t40*t41+6.0d+0*t201*t353*
     7         t39*t41+6.0d+0*t200*t201*t268*t39*t41+1.8d+1*t105*t199*t2
     8         01*t39*t41-6.0d+0*t353*t354*t41-2.0d+0*t30*t353*t38*t39-2
     9         .0d+0*t30*t351*t38*t39-6.0d+0*t105*t199*t30*t38*t39+2.0d+
     :         0*t201*t30*t353+2.0d+0*t200*t201*t268*t30+6.0d+0*t105*t19
     ;         9*t201*t30)*wght+3.0d+0*t205*t29*wght+3.0d+0*t1*t108*t188
     <         *wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*t1*t220*t95*wght+2.0d+0*t108*
     1         t95*wght+1.0d+0*t1*t384*t57*wght+1.0d+0*t188*t57*wght+1.0
     2         d+0*t1*t29*(5.0d+0*t107*t388*t55*t56-2.0d+1*t106*t204*t21
     3         9*t55*t56-1.0d+1*t121*t198*t204*t55*t56+3.0d+1*t121*t202*
     4         t203*t55*t56-1.2d+2*t121*t202*t357*t53*t56+4.0d+1*t106*t2
     5         03*t219*t53*t56+2.0d+1*t121*t198*t203*t53*t56+6.0d+1*t121
     6         *t202*t356*t51*t56+4.0d+0*t107*t388*t53*t54-1.6d+1*t106*t
     7         204*t219*t53*t54-8.0d+0*t121*t198*t204*t53*t54+2.4d+1*t12
     8         1*t202*t203*t53*t54-7.2d+1*t121*t202*t357*t51*t54+2.4d+1*
     9         t106*t203*t219*t51*t54+1.2d+1*t121*t198*t203*t51*t54+2.4d
     :         +1*t121*t202*t356*t49*t54+3.0d+0*t107*t388*t51*t52-1.2d+1
     ;         *t106*t204*t219*t51*t52-6.0d+0*t121*t198*t204*t51*t52+1.8
     <         d+1*t121*t202*t203*t51*t52-3.6d+1*t121*t202*t357*t49*t52+
     =         1.2d+1*t106*t203*t219*t49*t52+6.0d+0*t121*t198*t203*t49*t
     >         52+6.0d+0*t121*t202*t356*t52+2.0d+0*t107*t388*t49*t50-8.0
     ?         d+0*t106*t204*t219*t49*t50-4.0d+0*t121*t198*t204*t49*t50+
     @         1.2d+1*t121*t202*t203*t49*t50-1.2d+1*t121*t202*t357*t50+4
     1         .0d+0*t106*t203*t219*t50+2.0d+0*t121*t198*t203*t50+1.0d+0
     2         *t107*t388*t47-4.0d+0*t106*t204*t219*t47-2.0d+0*t121*t198
     3         *t204*t47+6.0d+0*t121*t202*t203*t47-t38*t389*t46-2*t105*t
     4         218*t38*t46-t120*t200*t38*t46-t120*t199*t38*t46-5.0d+0*t3
     5         8*t389*t44*t45-1.0d+1*t105*t218*t38*t44*t45-5.0d+0*t120*t
     6         200*t38*t44*t45-5.0d+0*t120*t199*t38*t44*t45+2.0d+1*t200*
     7         t201*t390*t42*t45+4.0d+1*t105*t201*t218*t42*t45+2.0d+1*t1
     8         20*t200*t201*t42*t45+2.0d+1*t120*t199*t201*t42*t45-6.0d+1
     9         *t120*t200*t354*t40*t45-4.0d+0*t38*t389*t42*t43-8.0d+0*t1
     :         05*t218*t38*t42*t43-4.0d+0*t120*t200*t38*t42*t43-4.0d+0*t
     ;         120*t199*t38*t42*t43+1.2d+1*t200*t201*t390*t40*t43+2.4d+1
     <         *t105*t201*t218*t40*t43+1.2d+1*t120*t200*t201*t40*t43+1.2
     =         d+1*t120*t199*t201*t40*t43-2.4d+1*t120*t200*t354*t39*t43-
     >         3.0d+0*t38*t389*t40*t41-6.0d+0*t105*t218*t38*t40*t41-3.0d
     ?         +0*t120*t200*t38*t40*t41-3.0d+0*t120*t199*t38*t40*t41+6.0
     @         d+0*t200*t201*t39*t390*t41+1.2d+1*t105*t201*t218*t39*t41+
     1         6.0d+0*t120*t200*t201*t39*t41+6.0d+0*t120*t199*t201*t39*t
     2         41-6.0d+0*t120*t200*t354*t41+2.0d+0*t200*t201*t30*t390-2.
     3         0d+0*t30*t38*t389*t39-4.0d+0*t105*t218*t30*t38*t39-2.0d+0
     4         *t120*t200*t30*t38*t39-2.0d+0*t120*t199*t30*t38*t39+4.0d+
     5         0*t105*t201*t218*t30+2.0d+0*t120*t200*t201*t30+2.0d+0*t12
     6         0*t199*t201*t30)*wght+1.0d+0*t205*t29*wght+2.0d+0*t1*t108
     7         *t215*wght+1.0d+0*t1*t117*t205*wght+1.0d+0*t1*t122*t188*w
     8         ght+t394+t393+t392+t391+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*t242*t95*wght+1.0d+0*t1*t4
     1         06*t57*wght+1.0d+0*t233*t57*wght+1.0d+0*t1*t29*(5.0d+0*t1
     2         07*t409*t55*t56+3.0d+1*t106*t203*t241*t55*t56-1.0d+1*t106
     3         *t204*t238*t55*t56-2.0d+1*t121*t204*t219*t55*t56-1.2d+2*t
     4         106*t241*t357*t53*t56+2.0d+1*t106*t203*t238*t53*t56+4.0d+
     5         1*t121*t203*t219*t53*t56+6.0d+1*t106*t241*t356*t51*t56+4.
     6         0d+0*t107*t409*t53*t54+2.4d+1*t106*t203*t241*t53*t54-8.0d
     7         +0*t106*t204*t238*t53*t54-1.6d+1*t121*t204*t219*t53*t54-7
     8         .2d+1*t106*t241*t357*t51*t54+1.2d+1*t106*t203*t238*t51*t5
     9         4+2.4d+1*t121*t203*t219*t51*t54+2.4d+1*t106*t241*t356*t49
     :         *t54+3.0d+0*t107*t409*t51*t52+1.8d+1*t106*t203*t241*t51*t
     ;         52-6.0d+0*t106*t204*t238*t51*t52-1.2d+1*t121*t204*t219*t5
     <         1*t52-3.6d+1*t106*t241*t357*t49*t52+6.0d+0*t106*t203*t238
     =         *t49*t52+1.2d+1*t121*t203*t219*t49*t52+6.0d+0*t106*t241*t
     >         356*t52+2.0d+0*t107*t409*t49*t50+1.2d+1*t106*t203*t241*t4
     ?         9*t50-4.0d+0*t106*t204*t238*t49*t50-8.0d+0*t121*t204*t219
     @         *t49*t50-1.2d+1*t106*t241*t357*t50+2.0d+0*t106*t203*t238*
     1         t50+4.0d+0*t121*t203*t219*t50+1.0d+0*t107*t409*t47+6.0d+0
     2         *t106*t203*t241*t47-2.0d+0*t106*t204*t238*t47-4.0d+0*t121
     3         *t204*t219*t47-t38*t410*t46-t105*t240*t38*t46-t105*t239*t
     4         38*t46-2*t120*t218*t38*t46-5.0d+0*t38*t410*t44*t45-5.0d+0
     5         *t105*t240*t38*t44*t45-5.0d+0*t105*t239*t38*t44*t45-1.0d+
     6         1*t120*t218*t38*t44*t45+2.0d+1*t105*t120*t201*t390*t42*t4
     7         5+2.0d+1*t105*t201*t240*t42*t45+2.0d+1*t105*t201*t239*t42
     8         *t45+4.0d+1*t120*t201*t218*t42*t45-6.0d+1*t105*t240*t354*
     9         t40*t45-4.0d+0*t38*t410*t42*t43-4.0d+0*t105*t240*t38*t42*
     :         t43-4.0d+0*t105*t239*t38*t42*t43-8.0d+0*t120*t218*t38*t42
     ;         *t43+1.2d+1*t105*t120*t201*t390*t40*t43+1.2d+1*t105*t201*
     <         t240*t40*t43+1.2d+1*t105*t201*t239*t40*t43+2.4d+1*t120*t2
     =         01*t218*t40*t43-2.4d+1*t105*t240*t354*t39*t43-3.0d+0*t38*
     >         t40*t41*t410-2.0d+0*t30*t38*t39*t410-3.0d+0*t105*t240*t38
     ?         *t40*t41-3.0d+0*t105*t239*t38*t40*t41-6.0d+0*t120*t218*t3
     @         8*t40*t41+6.0d+0*t105*t120*t201*t39*t390*t41+6.0d+0*t105*
     1         t201*t240*t39*t41+6.0d+0*t105*t201*t239*t39*t41+1.2d+1*t1
     2         20*t201*t218*t39*t41-6.0d+0*t105*t240*t354*t41+2.0d+0*t10
     3         5*t120*t201*t30*t390-2.0d+0*t105*t240*t30*t38*t39-2.0d+0*
     4         t105*t239*t30*t38*t39-4.0d+0*t120*t218*t30*t38*t39+2.0d+0
     5         *t105*t201*t240*t30+2.0d+0*t105*t201*t239*t30+4.0d+0*t120
     6         *t201*t218*t30)*wght+1.0d+0*t242*t29*wght+1.0d+0*t1*t108*
     7         t233*wght+2.0d+0*t1*t117*t220*wght+2.0d+0*t1*t122*t215*wg
     8         ht+2.0d+0*t117*t122*wght+t394+t393+t392+t391+Amat3(iq,D3_
     9         RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*t423*t57*wght+3.0d+0*t233*
     1         t57*wght+1.0d+0*t1*t29*(3.0d+1*t203*t432*t55*t56+5.0d+0*t
     2         107*t430*t55*t56-3.0d+1*t121*t204*t238*t55*t56-1.2d+2*t35
     3         7*t432*t53*t56+6.0d+1*t121*t203*t238*t53*t56+6.0d+1*t356*
     4         t432*t51*t56+2.4d+1*t203*t432*t53*t54+4.0d+0*t107*t430*t5
     5         3*t54-2.4d+1*t121*t204*t238*t53*t54-7.2d+1*t357*t432*t51*
     6         t54+3.6d+1*t121*t203*t238*t51*t54+2.4d+1*t356*t432*t49*t5
     7         4+1.8d+1*t203*t432*t51*t52+3.0d+0*t107*t430*t51*t52-1.8d+
     8         1*t121*t204*t238*t51*t52-3.6d+1*t357*t432*t49*t52+1.8d+1*
     9         t121*t203*t238*t49*t52+6.0d+0*t356*t432*t52+1.2d+1*t203*t
     :         432*t49*t50+2.0d+0*t107*t430*t49*t50-1.2d+1*t121*t204*t23
     ;         8*t49*t50-1.2d+1*t357*t432*t50+6.0d+0*t121*t203*t238*t50+
     <         6.0d+0*t203*t432*t47+1.0d+0*t107*t430*t47-6.0d+0*t121*t20
     =         4*t238*t47-t38*t431*t46-t38*t429*t46-3*t120*t239*t38*t46-
     >         5.0d+0*t38*t431*t44*t45-5.0d+0*t38*t429*t44*t45-1.5d+1*t1
     ?         20*t239*t38*t44*t45+2.0d+1*t201*t42*t431*t45-6.0d+1*t354*
     @         t40*t431*t45+2.0d+1*t201*t240*t390*t42*t45+6.0d+1*t120*t2
     1         01*t239*t42*t45-4.0d+0*t38*t42*t43*t431+1.2d+1*t201*t40*t
     2         43*t431-2.4d+1*t354*t39*t43*t431-3.0d+0*t38*t40*t41*t431+
     3         6.0d+0*t201*t39*t41*t431-6.0d+0*t354*t41*t431-2.0d+0*t30*
     4         t38*t39*t431+2.0d+0*t201*t30*t431-4.0d+0*t38*t42*t429*t43
     5         -1.2d+1*t120*t239*t38*t42*t43+1.2d+1*t201*t240*t390*t40*t
     6         43+3.6d+1*t120*t201*t239*t40*t43-3.0d+0*t38*t40*t41*t429-
     7         2.0d+0*t30*t38*t39*t429-9.0d+0*t120*t239*t38*t40*t41+6.0d
     8         +0*t201*t240*t39*t390*t41+1.8d+1*t120*t201*t239*t39*t41+2
     9         .0d+0*t201*t240*t30*t390-6.0d+0*t120*t239*t30*t38*t39+6.0
     :         d+0*t120*t201*t239*t30)*wght+3.0d+0*t242*t29*wght+3.0d+0*
     ;         t1*t117*t242*wght+3.0d+0*t1*t122*t233*wght+6.0d+0*t117*t1
     <         22*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t435+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = 2.0d+0*t1*t253*t95*wght+2.0d+0*t249
     1         *t95*wght+1.0d+0*t1*t29*(5.0d+0*t107*t436*t55*t56+4.23499
     2         99060631754d-2*t198*t204*t33*t36*t37*t55*t56-1.2704999718
     3         189527d-1*t202*t203*t33*t36*t37*t55*t56-2.0d+1*t106*t204*
     4         t252*t55*t56+5.081999887275811d-1*t202*t33*t357*t36*t37*t
     5         53*t56-8.469999812126351d-2*t198*t203*t33*t36*t37*t53*t56
     6         +4.0d+1*t106*t203*t252*t53*t56-2.5409999436379055d-1*t202
     7         *t33*t356*t36*t37*t51*t56+4.0d+0*t107*t436*t53*t54+3.3879
     8         999248505405d-2*t198*t204*t33*t36*t37*t53*t54-1.016399977
     9         4551621d-1*t202*t203*t33*t36*t37*t53*t54-1.6d+1*t106*t204
     :         *t252*t53*t54+3.049199932365486d-1*t202*t33*t357*t36*t37*
     ;         t51*t54-5.081999887275811d-2*t198*t203*t33*t36*t37*t51*t5
     <         4+2.4d+1*t106*t203*t252*t51*t54-1.0163999774551621d-1*t20
     =         2*t33*t356*t36*t37*t49*t54+3.0d+0*t107*t436*t51*t52+2.540
     >         9999436379055d-2*t198*t204*t33*t36*t37*t51*t52-7.62299983
     ?         0913715d-2*t202*t203*t33*t36*t37*t51*t52-1.2d+1*t106*t204
     @         *t252*t51*t52+1.524599966182743d-1*t202*t33*t357*t36*t37*
     1         t49*t52-2.5409999436379055d-2*t198*t203*t33*t36*t37*t49*t
     2         52+1.2d+1*t106*t203*t252*t49*t52-2.5409999436379055d-2*t2
     3         02*t33*t356*t36*t37*t52+2.0d+0*t107*t436*t49*t50+1.693999
     4         9624252702d-2*t198*t204*t33*t36*t37*t49*t50-5.08199988727
     5         5811d-2*t202*t203*t33*t36*t37*t49*t50-8.0d+0*t106*t204*t2
     6         52*t49*t50+5.081999887275811d-2*t202*t33*t357*t36*t37*t50
     7         -8.469999812126351d-3*t198*t203*t33*t36*t37*t50+4.0d+0*t1
     8         06*t203*t252*t50+1.0d+0*t107*t436*t47+8.469999812126351d-
     9         3*t198*t204*t33*t36*t37*t47-2.5409999436379055d-2*t202*t2
     :         03*t33*t36*t37*t47-4.0d+0*t106*t204*t252*t47-t38*t437*t46
     ;         -4.2349999060631754d-3*t200*t33*t36*t37*t38*t46-4.2349999
     <         060631754d-3*t199*t33*t36*t37*t38*t46-2*t105*t251*t38*t46
     =         -5.0d+0*t38*t437*t44*t45-2.1174999530315877d-2*t200*t33*t
     >         36*t37*t38*t44*t45-2.1174999530315877d-2*t199*t33*t36*t37
     ?         *t38*t44*t45-1.0d+1*t105*t251*t38*t44*t45+2.5409999436379
     @         055d-1*t200*t201*t33*t36*t37*t42*t45+8.469999812126351d-2
     1         *t199*t201*t33*t36*t37*t42*t45+4.0d+1*t105*t201*t251*t42*
     2         t45-2.5409999436379055d-1*t200*t33*t354*t36*t37*t40*t45-4
     3         .0d+0*t38*t42*t43*t437-3.0d+0*t38*t40*t41*t437-2.0d+0*t30
     4         *t38*t39*t437-1.6939999624252702d-2*t200*t33*t36*t37*t38*
     5         t42*t43-1.6939999624252702d-2*t199*t33*t36*t37*t38*t42*t4
     6         3-8.0d+0*t105*t251*t38*t42*t43+1.524599966182743d-1*t200*
     7         t201*t33*t36*t37*t40*t43+5.081999887275811d-2*t199*t201*t
     8         33*t36*t37*t40*t43+2.4d+1*t105*t201*t251*t40*t43-1.016399
     9         9774551621d-1*t200*t33*t354*t36*t37*t39*t43-1.27049997181
     :         89527d-2*t200*t33*t36*t37*t38*t40*t41-1.2704999718189527d
     ;         -2*t199*t33*t36*t37*t38*t40*t41-6.0d+0*t105*t251*t38*t40*
     <         t41+7.622999830913715d-2*t200*t201*t33*t36*t37*t39*t41+2.
     =         5409999436379055d-2*t199*t201*t33*t36*t37*t39*t41+1.2d+1*
     >         t105*t201*t251*t39*t41-2.5409999436379055d-2*t200*t33*t35
     ?         4*t36*t37*t41-8.469999812126351d-3*t200*t30*t33*t36*t37*t
     @         38*t39-8.469999812126351d-3*t199*t30*t33*t36*t37*t38*t39-
     1         4.0d+0*t105*t251*t30*t38*t39+2.5409999436379055d-2*t200*t
     2         201*t30*t33*t36*t37+8.469999812126351d-3*t199*t201*t30*t3
     3         3*t36*t37+4.0d+0*t105*t201*t251*t30)*wght+2.0d+0*t253*t29
     4         *wght+1.0d+0*t1*t188*t249*wght+Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t435+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t440+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = 1.0d+0*t1*t260*t95*wght+1.0d+0*t249
     1         *t95*wght+1.0d+0*t1*t29*(5.0d+0*t107*t442*t55*t56+4.23499
     2         99060631754d-2*t204*t219*t33*t36*t37*t55*t56-1.2704999718
     3         189527d-1*t106*t121*t203*t33*t36*t37*t55*t56-1.0d+1*t106*
     4         t204*t259*t55*t56-1.0d+1*t121*t204*t252*t55*t56+5.0819998
     5         87275811d-1*t106*t121*t33*t357*t36*t37*t53*t56-8.46999981
     6         2126351d-2*t203*t219*t33*t36*t37*t53*t56+2.0d+1*t106*t203
     7         *t259*t53*t56+2.0d+1*t121*t203*t252*t53*t56-2.54099994363
     8         79055d-1*t106*t121*t33*t356*t36*t37*t51*t56+4.0d+0*t107*t
     9         442*t53*t54+3.3879999248505405d-2*t204*t219*t33*t36*t37*t
     :         53*t54-1.0163999774551621d-1*t106*t121*t203*t33*t36*t37*t
     ;         53*t54-8.0d+0*t106*t204*t259*t53*t54-8.0d+0*t121*t204*t25
     <         2*t53*t54+3.049199932365486d-1*t106*t121*t33*t357*t36*t37
     =         *t51*t54-5.081999887275811d-2*t203*t219*t33*t36*t37*t51*t
     >         54+1.2d+1*t106*t203*t259*t51*t54+1.2d+1*t121*t203*t252*t5
     ?         1*t54-1.0163999774551621d-1*t106*t121*t33*t356*t36*t37*t4
     @         9*t54+3.0d+0*t107*t442*t51*t52+2.5409999436379055d-2*t204
     1         *t219*t33*t36*t37*t51*t52-7.622999830913715d-2*t106*t121*
     2         t203*t33*t36*t37*t51*t52-6.0d+0*t106*t204*t259*t51*t52-6.
     3         0d+0*t121*t204*t252*t51*t52+1.524599966182743d-1*t106*t12
     4         1*t33*t357*t36*t37*t49*t52-2.5409999436379055d-2*t203*t21
     5         9*t33*t36*t37*t49*t52+6.0d+0*t106*t203*t259*t49*t52+6.0d+
     6         0*t121*t203*t252*t49*t52-2.5409999436379055d-2*t106*t121*
     7         t33*t356*t36*t37*t52+2.0d+0*t107*t442*t49*t50+1.693999962
     8         4252702d-2*t204*t219*t33*t36*t37*t49*t50-5.08199988727581
     9         1d-2*t106*t121*t203*t33*t36*t37*t49*t50-4.0d+0*t106*t204*
     :         t259*t49*t50-4.0d+0*t121*t204*t252*t49*t50+5.081999887275
     ;         811d-2*t106*t121*t33*t357*t36*t37*t50-8.469999812126351d-
     <         3*t203*t219*t33*t36*t37*t50+2.0d+0*t106*t203*t259*t50+2.0
     =         d+0*t121*t203*t252*t50+1.0d+0*t107*t442*t47+8.46999981212
     >         6351d-3*t204*t219*t33*t36*t37*t47-2.5409999436379055d-2*t
     ?         106*t121*t203*t33*t36*t37*t47-2.0d+0*t106*t204*t259*t47-2
     @         .0d+0*t121*t204*t252*t47-t38*t441*t46-4.2349999060631754d
     1         -3*t218*t33*t36*t37*t38*t46-4.2349999060631754d-3*t105*t1
     2         20*t33*t36*t37*t38*t46-t105*t258*t38*t46-t120*t251*t38*t4
     3         6-5.0d+0*t38*t44*t441*t45-2.1174999530315877d-2*t218*t33*
     4         t36*t37*t38*t44*t45-2.1174999530315877d-2*t105*t120*t33*t
     5         36*t37*t38*t44*t45-5.0d+0*t105*t258*t38*t44*t45-5.0d+0*t1
     6         20*t251*t38*t44*t45+8.469999812126351d-2*t201*t218*t33*t3
     7         6*t37*t42*t45+2.5409999436379055d-1*t105*t120*t201*t33*t3
     8         6*t37*t42*t45+2.0d+1*t105*t201*t258*t42*t45+2.0d+1*t120*t
     9         201*t251*t42*t45-2.5409999436379055d-1*t105*t120*t33*t354
     :         *t36*t37*t40*t45-4.0d+0*t38*t42*t43*t441-3.0d+0*t38*t40*t
     ;         41*t441-2.0d+0*t30*t38*t39*t441-1.6939999624252702d-2*t21
     <         8*t33*t36*t37*t38*t42*t43-1.6939999624252702d-2*t105*t120
     =         *t33*t36*t37*t38*t42*t43-4.0d+0*t105*t258*t38*t42*t43-4.0
     >         d+0*t120*t251*t38*t42*t43+5.081999887275811d-2*t201*t218*
     ?         t33*t36*t37*t40*t43+1.524599966182743d-1*t105*t120*t201*t
     @         33*t36*t37*t40*t43+1.2d+1*t105*t201*t258*t40*t43+1.2d+1*t
     1         120*t201*t251*t40*t43-1.0163999774551621d-1*t105*t120*t33
     2         *t354*t36*t37*t39*t43-1.2704999718189527d-2*t218*t33*t36*
     3         t37*t38*t40*t41-1.2704999718189527d-2*t105*t120*t33*t36*t
     4         37*t38*t40*t41-3.0d+0*t105*t258*t38*t40*t41-3.0d+0*t120*t
     5         251*t38*t40*t41+2.5409999436379055d-2*t201*t218*t33*t36*t
     6         37*t39*t41+7.622999830913715d-2*t105*t120*t201*t33*t36*t3
     7         7*t39*t41+6.0d+0*t105*t201*t258*t39*t41+6.0d+0*t120*t201*
     8         t251*t39*t41-2.5409999436379055d-2*t105*t120*t33*t354*t36
     9         *t37*t41-8.469999812126351d-3*t218*t30*t33*t36*t37*t38*t3
     :         9-8.469999812126351d-3*t105*t120*t30*t33*t36*t37*t38*t39-
     ;         2.0d+0*t105*t258*t30*t38*t39-2.0d+0*t120*t251*t30*t38*t39
     <         +8.469999812126351d-3*t201*t218*t30*t33*t36*t37+2.5409999
     =         436379055d-2*t105*t120*t201*t30*t33*t36*t37+2.0d+0*t105*t
     >         201*t258*t30+2.0d+0*t120*t201*t251*t30)*wght+1.0d+0*t260*
     ?         t29*wght+1.0d+0*t253*t29*wght+1.0d+0*t1*t117*t253*wght+1.
     @         0d+0*t1*t215*t249*wght+1.0d+0*t117*t249*wght+Cmat3(iq,D3_
     1         RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = t440+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = t445+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = 1.0d+0*t1*t29*(5.0d+0*t107*t446*t55
     1         *t56-1.2704999718189527d-1*t203*t241*t33*t36*t37*t55*t56+
     2         4.2349999060631754d-2*t204*t238*t33*t36*t37*t55*t56-2.0d+
     3         1*t121*t204*t259*t55*t56+5.081999887275811d-1*t241*t33*t3
     4         57*t36*t37*t53*t56-8.469999812126351d-2*t203*t238*t33*t36
     5         *t37*t53*t56+4.0d+1*t121*t203*t259*t53*t56-2.540999943637
     6         9055d-1*t241*t33*t356*t36*t37*t51*t56+4.0d+0*t107*t446*t5
     7         3*t54-1.0163999774551621d-1*t203*t241*t33*t36*t37*t53*t54
     8         +3.3879999248505405d-2*t204*t238*t33*t36*t37*t53*t54-1.6d
     9         +1*t121*t204*t259*t53*t54+3.049199932365486d-1*t241*t33*t
     :         357*t36*t37*t51*t54-5.081999887275811d-2*t203*t238*t33*t3
     ;         6*t37*t51*t54+2.4d+1*t121*t203*t259*t51*t54-1.01639997745
     <         51621d-1*t241*t33*t356*t36*t37*t49*t54+3.0d+0*t107*t446*t
     =         51*t52-7.622999830913715d-2*t203*t241*t33*t36*t37*t51*t52
     >         +2.5409999436379055d-2*t204*t238*t33*t36*t37*t51*t52-1.2d
     ?         +1*t121*t204*t259*t51*t52+1.524599966182743d-1*t241*t33*t
     @         357*t36*t37*t49*t52-2.5409999436379055d-2*t203*t238*t33*t
     1         36*t37*t49*t52+1.2d+1*t121*t203*t259*t49*t52-2.5409999436
     2         379055d-2*t241*t33*t356*t36*t37*t52+2.0d+0*t107*t446*t49*
     3         t50-5.081999887275811d-2*t203*t241*t33*t36*t37*t49*t50+1.
     4         6939999624252702d-2*t204*t238*t33*t36*t37*t49*t50-8.0d+0*
     5         t121*t204*t259*t49*t50+5.081999887275811d-2*t241*t33*t357
     6         *t36*t37*t50-8.469999812126351d-3*t203*t238*t33*t36*t37*t
     7         50+4.0d+0*t121*t203*t259*t50+1.0d+0*t107*t446*t47-2.54099
     8         99436379055d-2*t203*t241*t33*t36*t37*t47+8.46999981212635
     9         1d-3*t204*t238*t33*t36*t37*t47-4.0d+0*t121*t204*t259*t47-
     :         t38*t447*t46-4.2349999060631754d-3*t240*t33*t36*t37*t38*t
     ;         46-4.2349999060631754d-3*t239*t33*t36*t37*t38*t46-2*t120*
     <         t258*t38*t46-5.0d+0*t38*t44*t447*t45-2.1174999530315877d-
     =         2*t240*t33*t36*t37*t38*t44*t45-2.1174999530315877d-2*t239
     >         *t33*t36*t37*t38*t44*t45-1.0d+1*t120*t258*t38*t44*t45+2.5
     ?         409999436379055d-1*t201*t240*t33*t36*t37*t42*t45+8.469999
     @         812126351d-2*t201*t239*t33*t36*t37*t42*t45+4.0d+1*t120*t2
     1         01*t258*t42*t45-2.5409999436379055d-1*t240*t33*t354*t36*t
     2         37*t40*t45-4.0d+0*t38*t42*t43*t447-3.0d+0*t38*t40*t41*t44
     3         7-2.0d+0*t30*t38*t39*t447-1.6939999624252702d-2*t240*t33*
     4         t36*t37*t38*t42*t43-1.6939999624252702d-2*t239*t33*t36*t3
     5         7*t38*t42*t43-8.0d+0*t120*t258*t38*t42*t43+1.524599966182
     6         743d-1*t201*t240*t33*t36*t37*t40*t43+5.081999887275811d-2
     7         *t201*t239*t33*t36*t37*t40*t43+2.4d+1*t120*t201*t258*t40*
     8         t43-1.0163999774551621d-1*t240*t33*t354*t36*t37*t39*t43-1
     9         .2704999718189527d-2*t240*t33*t36*t37*t38*t40*t41-1.27049
     :         99718189527d-2*t239*t33*t36*t37*t38*t40*t41-6.0d+0*t120*t
     ;         258*t38*t40*t41+7.622999830913715d-2*t201*t240*t33*t36*t3
     <         7*t39*t41+2.5409999436379055d-2*t201*t239*t33*t36*t37*t39
     =         *t41+1.2d+1*t120*t201*t258*t39*t41-2.5409999436379055d-2*
     >         t240*t33*t354*t36*t37*t41-8.469999812126351d-3*t240*t30*t
     ?         33*t36*t37*t38*t39-8.469999812126351d-3*t239*t30*t33*t36*
     @         t37*t38*t39-4.0d+0*t120*t258*t30*t38*t39+2.54099994363790
     1         55d-2*t201*t240*t30*t33*t36*t37+8.469999812126351d-3*t201
     2         *t239*t30*t33*t36*t37+4.0d+0*t120*t201*t258*t30)*wght+2.0
     3         d+0*t260*t29*wght+2.0d+0*t1*t117*t260*wght+1.0d+0*t1*t233
     4         *t249*wght+2.0d+0*t117*t249*wght+Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = t445+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = t468+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t471+Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t468+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = 1.0d+0*t1*t29*(5.380567261306531d-
     1         4*t106*t196*t203*t261*t55*t56*t96-2.1522269045226128d-3*t
     2         106*t196*t261*t357*t53*t56*t96+1.0761134522613064d-3*t106
     3         *t196*t261*t356*t51*t56*t96+4.3044538090452256d-4*t106*t1
     4         96*t203*t261*t53*t54*t96-1.2913361427135678d-3*t106*t196*
     5         t261*t357*t51*t54*t96+4.3044538090452256d-4*t106*t196*t26
     6         1*t356*t49*t54*t96+3.228340356783919d-4*t106*t196*t203*t2
     7         61*t51*t52*t96-6.456680713567838d-4*t106*t196*t261*t357*t
     8         49*t52*t96+1.0761134522613064d-4*t106*t196*t261*t356*t52*
     9         t96+2.1522269045226128d-4*t106*t196*t203*t261*t49*t50*t96
     :         -2.1522269045226128d-4*t106*t196*t261*t357*t50*t96+1.0761
     ;         134522613064d-4*t106*t196*t203*t261*t47*t96-1.79352242043
     <         55107d-5*t105*t196*t261*t38*t46*t96-8.967612102177552d-5*
     =         t105*t196*t261*t38*t44*t45*t96+1.0761134522613064d-3*t105
     >         *t196*t201*t261*t42*t45*t96-1.0761134522613064d-3*t105*t1
     ?         96*t261*t354*t40*t45*t96-7.174089681742043d-5*t105*t196*t
     @         261*t38*t42*t43*t96+6.456680713567838d-4*t105*t196*t201*t
     1         261*t40*t43*t96-4.3044538090452256d-4*t105*t196*t261*t354
     2         *t39*t43*t96-5.380567261306531d-5*t105*t196*t261*t38*t40*
     3         t41*t96+3.228340356783919d-4*t105*t196*t201*t261*t39*t41*
     4         t96-1.0761134522613064d-4*t105*t196*t261*t354*t41*t96-3.5
     5         870448408710215d-5*t105*t196*t261*t30*t38*t39*t96+1.07611
     6         34522613064d-4*t105*t196*t201*t261*t30*t96+8.469999812126
     7         351d-2*t204*t252*t33*t36*t37*t55*t56-1.6939999624252702d-
     8         1*t203*t252*t33*t36*t37*t53*t56+6.775999849701081d-2*t204
     9         *t252*t33*t36*t37*t53*t54-1.0163999774551621d-1*t203*t252
     :         *t33*t36*t37*t51*t54+5.081999887275811d-2*t204*t252*t33*t
     ;         36*t37*t51*t52-5.081999887275811d-2*t203*t252*t33*t36*t37
     <         *t49*t52+3.3879999248505405d-2*t204*t252*t33*t36*t37*t49*
     =         t50-1.6939999624252702d-2*t203*t252*t33*t36*t37*t50+1.693
     >         9999624252702d-2*t204*t252*t33*t36*t37*t47-8.469999812126
     ?         351d-3*t251*t33*t36*t37*t38*t46-4.2349999060631754d-2*t25
     @         1*t33*t36*t37*t38*t44*t45+1.6939999624252702d-1*t201*t251
     1         *t33*t36*t37*t42*t45-3.3879999248505405d-2*t251*t33*t36*t
     2         37*t38*t42*t43+1.0163999774551621d-1*t201*t251*t33*t36*t3
     3         7*t40*t43-2.5409999436379055d-2*t251*t33*t36*t37*t38*t40*
     4         t41+5.081999887275811d-2*t201*t251*t33*t36*t37*t39*t41-1.
     5         6939999624252702d-2*t251*t30*t33*t36*t37*t38*t39+1.693999
     6         9624252702d-2*t201*t251*t30*t33*t36*t37)*wght+1.0d+0*t1*t
     7         472*t95*wght+t473+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t471+Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t468+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t492+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = t493+Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t492+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = 1.0d+0*t1*t29*(5.380567261306531d-
     1         4*t121*t196*t203*t261*t55*t56*t96-2.1522269045226128d-3*t
     2         121*t196*t261*t357*t53*t56*t96+1.0761134522613064d-3*t121
     3         *t196*t261*t356*t51*t56*t96+4.3044538090452256d-4*t121*t1
     4         96*t203*t261*t53*t54*t96-1.2913361427135678d-3*t121*t196*
     5         t261*t357*t51*t54*t96+4.3044538090452256d-4*t121*t196*t26
     6         1*t356*t49*t54*t96+3.228340356783919d-4*t121*t196*t203*t2
     7         61*t51*t52*t96-6.456680713567838d-4*t121*t196*t261*t357*t
     8         49*t52*t96+1.0761134522613064d-4*t121*t196*t261*t356*t52*
     9         t96+2.1522269045226128d-4*t121*t196*t203*t261*t49*t50*t96
     :         -2.1522269045226128d-4*t121*t196*t261*t357*t50*t96+1.0761
     ;         134522613064d-4*t121*t196*t203*t261*t47*t96-1.79352242043
     <         55107d-5*t120*t196*t261*t38*t46*t96-8.967612102177552d-5*
     =         t120*t196*t261*t38*t44*t45*t96+1.0761134522613064d-3*t120
     >         *t196*t201*t261*t42*t45*t96-1.0761134522613064d-3*t120*t1
     ?         96*t261*t354*t40*t45*t96-7.174089681742043d-5*t120*t196*t
     @         261*t38*t42*t43*t96+6.456680713567838d-4*t120*t196*t201*t
     1         261*t40*t43*t96-4.3044538090452256d-4*t120*t196*t261*t354
     2         *t39*t43*t96-5.380567261306531d-5*t120*t196*t261*t38*t40*
     3         t41*t96+3.228340356783919d-4*t120*t196*t201*t261*t39*t41*
     4         t96-1.0761134522613064d-4*t120*t196*t261*t354*t41*t96-3.5
     5         870448408710215d-5*t120*t196*t261*t30*t38*t39*t96+1.07611
     6         34522613064d-4*t120*t196*t201*t261*t30*t96+8.469999812126
     7         351d-2*t204*t259*t33*t36*t37*t55*t56-1.6939999624252702d-
     8         1*t203*t259*t33*t36*t37*t53*t56+6.775999849701081d-2*t204
     9         *t259*t33*t36*t37*t53*t54-1.0163999774551621d-1*t203*t259
     :         *t33*t36*t37*t51*t54+5.081999887275811d-2*t204*t259*t33*t
     ;         36*t37*t51*t52-5.081999887275811d-2*t203*t259*t33*t36*t37
     <         *t49*t52+3.3879999248505405d-2*t204*t259*t33*t36*t37*t49*
     =         t50-1.6939999624252702d-2*t203*t259*t33*t36*t37*t50+1.693
     >         9999624252702d-2*t204*t259*t33*t36*t37*t47-8.469999812126
     ?         351d-3*t258*t33*t36*t37*t38*t46-4.2349999060631754d-2*t25
     @         8*t33*t36*t37*t38*t44*t45+1.6939999624252702d-1*t201*t258
     1         *t33*t36*t37*t42*t45-3.3879999248505405d-2*t258*t33*t36*t
     2         37*t38*t42*t43+1.0163999774551621d-1*t201*t258*t33*t36*t3
     3         7*t40*t43-2.5409999436379055d-2*t258*t33*t36*t37*t38*t40*
     4         t41+5.081999887275811d-2*t201*t258*t33*t36*t37*t39*t41-1.
     5         6939999624252702d-2*t258*t30*t33*t36*t37*t38*t39+1.693999
     6         9624252702d-2*t201*t258*t30*t33*t36*t37)*wght+1.0d+0*t1*t
     7         117*t472*wght+t473+Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = t493+Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t492+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t496+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t499+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t496+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = 1.0d+0*t1*t29*(1.6939999624252702
     1         d-2*t196*t204*t265*t33*t96+t501+t500+1.0761134522613064d-
     2         4*t123*t127*t203*t261*t495)*wght+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t499+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t496+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 1.0d+0*t1*t29*(t107*t36*t37*(3.03
     1         8226912826634d-6*t196*t204*t494*t53*t56*t96-4.55734036923
     2         99517d-6*t196*t203*t494*t51*t56*t96+1.8229361476959807d-6
     3         *t196*t204*t494*t51*t54*t96-1.8229361476959807d-6*t196*t2
     4         03*t49*t494*t54*t96+9.114680738479904d-7*t196*t204*t49*t4
     5         94*t52*t96-4.557340369239952d-7*t196*t203*t494*t52*t96+3.
     6         038226912826635d-7*t196*t204*t494*t50*t96)+t36*t37*(-7.59
     7         5567282066586d-8*t196*t38*t46*t494*t96-3.797783641033293d
     8         -7*t196*t38*t44*t45*t494*t96+4.5573403692399517d-6*t196*t
     9         201*t42*t45*t494*t96-4.5573403692399517d-6*t196*t354*t40*
     :         t45*t494*t96-3.038226912826635d-7*t196*t38*t42*t43*t494*t
     ;         96+2.734404221543971d-6*t196*t201*t40*t43*t494*t96-1.8229
     <         361476959807d-6*t196*t354*t39*t43*t494*t96-2.278670184619
     =         976d-7*t196*t38*t40*t41*t494*t96+1.3672021107719856d-6*t1
     >         96*t201*t39*t41*t494*t96-4.557340369239952d-7*t196*t354*t
     ?         41*t494*t96-1.5191134564133174d-7*t196*t30*t38*t39*t494*t
     @         96+4.557340369239952d-7*t196*t201*t30*t494*t96)+1.6939999
     1         624252702d-2*t196*t204*t267*t33*t96+1.0761134522613064d-4
     2         *t125*t127*t203*t261*t495)*wght+Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = 1.0d+0*t1*t29*(t196*t204*(4.23499
     1         99060631754d-3*t267*t33+8.469999812126351d-3*t265*t33)*t9
     2         6+t501+t500+5.380567261306531d-5*t125*t127*t203*t261*t495
     3         )*wght+Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = 1.0d+0*t1*t29*(8.469999812126351d
     1         -3*t196*t204*t265*t33*t96+t498+t497+2.6902836306532657d-5
     2         *t125*t127*t203*t261*t495)*wght+Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = t496+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = 1/rhoa**6.666666666666666d-1
            t2 = rhoa**5.0d-1
            t3 = 1/t2
            t4 = 1/rhoa**3.333333333333333d-1
            t5 = 1/rhoa**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhoa**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammaaa*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammaaa*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/t11
            t40 = 1/rhoa**1.6666666666666669d+0
            t41 = 1/t2**3
            t42 = 1/rhoa**1.3333333333333333d+0
            t43 = 1/rhoa**1.1666666666666667d+0
            t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4.0
     1         02143174996817d-1*t41-1.264669550498372d-1*t40
            t45 = 1/t10**2
            t46 = 1/t7
            t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42-8
     1         .223668877838045d-1*t41-1.6039141941921276d-1*t40
            t48 = 1/t6**2
            t49 = 1.0d+0*t46*t47*t48*t9+1.3210398931339265d-3*t42*t8+1.1
     1         102230246251565d-16*t13*t39*t44*t45+3.0506411443514264d-1
     2         9*t12*t42
            t50 = rhoa**1.6666666666666674d-1
            t51 = 1/t17**3.0d+0
            t52 = 1/t14**2
            t53 = 3.361321652984956d-3*gammaaa*t18*t49*t52+7.84308385696
     1         4898d-3*gammaaa*t16*t50*t51
            t54 = 1/t19**2
            t55 = -3.361321652984956d-3*gammaaa*t18*t49*t52-7.8430838569
     1         64898d-3*gammaaa*t16*t50*t51
            t56 = -t29*t37*t55-5.0d+0*t29*t35*t36*t55-4.0d+0*t29*t33*t34
     1         *t55-3.0d+0*t29*t31*t32*t55-2.0d+0*t28*t29*t30*t55+5.0d+0
     2         *t26*t27*t53*t54+4.0d+0*t24*t25*t53*t54+3.0d+0*t22*t23*t5
     3         3*t54+2.0d+0*t20*t21*t53*t54+1.0d+0*t15*t53*t54
            t57 = -1.680660826492478d-2*t26*t27-1.3445286611939825d-2*t2
     1         4*t25-1.0083964958954868d-2*t22*t23-6.722643305969912d-3*
     2         t20*t21-3.361321652984956d-3*t15
            t58 = 1/t11**2
            t59 = t44**2
            t60 = 1/t10**4
            t61 = 1/t10**3
            t62 = 1/rhoa**2.6666666666666666d+0
            t63 = 1/t2**5
            t64 = 1/rhoa**2.3333333333333334d+0
            t65 = 1/rhoa**2.1666666666666665d+0
            t66 = 1.1632736958443765d+0*t65+9.89141964955861d-1*t64+6.00
     1         3214762495226d-1*t63+2.1077825841639536d-1*t62
            t67 = 1/t7**2
            t68 = t47**2
            t69 = 1/t6**4
            t70 = 1/t6**3
            t71 = 2.1622951122684114d+0*t65+1.7087761055320938d+0*t64+1.
     1         2335503316757068d+0*t63+2.673190323653546d-1*t62
            t72 = 1.0d+0*t46*t48*t71*t9-2.0d+0*t46*t68*t70*t9+3.21639589
     1         9738507d+1*t67*t68*t69*t9-1.7613865241785684d-3*t64*t8+1.
     2         1102230246251565d-16*t13*t39*t45*t66-4.0675215258019015d-
     3         19*t12*t64-2.220446049250313d-16*t13*t39*t59*t61+1.785458
     4         3920998188d-15*t13*t58*t59*t60-8.497974591333913d-2*t42*t
     5         46*t47*t48-9.812069668265515d-18*t39*t42*t44*t45
            t73 = t53**2
            t74 = 1/t19**4
            t75 = 1/t19**3
            t76 = rhoa**3.333333333333335d-1
            t77 = 1/t17**4.0d+0
            t78 = 1/rhoa**8.333333333333333d-1
            t79 = t49**2
            t80 = 1/t14**3
            t81 = -6.722643305969912d-3*gammaaa*t18*t79*t80+1.3071806428
     1         274835d-3*gammaaa*t16*t51*t78-2.745079349937714d-2*gammaa
     2         a*t16*t76*t77+3.361321652984956d-3*gammaaa*t18*t52*t72-1.
     3         5686167713929794d-2*gammaaa*t49*t50*t51*t52
            t82 = 6.722643305969912d-3*gammaaa*t18*t79*t80-1.30718064282
     1         74835d-3*gammaaa*t16*t51*t78+2.745079349937714d-2*gammaaa
     2         *t16*t76*t77-3.361321652984956d-3*gammaaa*t18*t52*t72+1.5
     3         686167713929794d-2*gammaaa*t49*t50*t51*t52
            t83 = t55**2
            t84 = exp(6.722643305969912d-3*gammaaa*t16*t18)
            t85 = 2.0d+1*t33*t36*t83*t84+1.2d+1*t31*t34*t83*t84+6.0d+0*t
     1         30*t32*t83*t84+2.0d+0*t28*t83*t84-t29*t37*t83-5.0d+0*t29*
     2         t35*t36*t83-4.0d+0*t29*t33*t34*t83-3.0d+0*t29*t31*t32*t83
     3         -2.0d+0*t28*t29*t30*t83-t29*t37*t82-5.0d+0*t29*t35*t36*t8
     4         2-4.0d+0*t29*t33*t34*t82-3.0d+0*t29*t31*t32*t82-2.0d+0*t2
     5         8*t29*t30*t82+5.0d+0*t26*t27*t54*t81+4.0d+0*t24*t25*t54*t
     6         81+3.0d+0*t22*t23*t54*t81+2.0d+0*t20*t21*t54*t81+1.0d+0*t
     7         15*t54*t81-1.0d+1*t26*t27*t73*t75-8.0d+0*t24*t25*t73*t75-
     8         6.0d+0*t22*t23*t73*t75-4.0d+0*t20*t21*t73*t75-2.0d+0*t15*
     9         t73*t75+2.0d+1*t24*t27*t73*t74+1.2d+1*t22*t25*t73*t74+6.0
     :         d+0*t20*t23*t73*t74+2.0d+0*t21*t73*t74
            t86 = -1.680660826492478d-2*t16*t18*t26*t27*t54-1.3445286611
     1         939825d-2*t16*t18*t24*t25*t54-1.0083964958954868d-2*t16*t
     2         18*t22*t23*t54-6.722643305969912d-3*t16*t18*t20*t21*t54-3
     3         .361321652984956d-3*t15*t16*t18*t54-3.361321652984956d-3*
     4         t16*t18*t29*t37-1.680660826492478d-2*t16*t18*t29*t35*t36-
     5         1.3445286611939825d-2*t16*t18*t29*t33*t34-1.0083964958954
     6         868d-2*t16*t18*t29*t31*t32-6.722643305969912d-3*t16*t18*t
     7         28*t29*t30
            t87 = 3.361321652984956d-3*t18*t49*t52+7.843083856964898d-3*
     1         t16*t50*t51
            t88 = -3.361321652984956d-3*t18*t49*t52-7.843083856964898d-3
     1         *t16*t50*t51
            t89 = -t29*t37*t88-5.0d+0*t29*t35*t36*t88-4.0d+0*t29*t33*t34
     1         *t88-3.0d+0*t29*t31*t32*t88-2.0d+0*t28*t29*t30*t88+5.0d+0
     2         *t26*t27*t54*t87+4.0d+0*t24*t25*t54*t87+3.0d+0*t22*t23*t5
     3         4*t87+2.0d+0*t20*t21*t54*t87+1.0d+0*t15*t54*t87+6.7226433
     4         05969912d-2*t16*t18*t33*t36*t55*t84+4.033585983581947d-2*
     5         t16*t18*t31*t34*t55*t84+2.0167929917909735d-2*t16*t18*t30
     6         *t32*t55*t84+6.722643305969912d-3*t16*t18*t28*t55*t84+3.3
     7         61321652984956d-2*t16*t18*t26*t27*t53*t75+2.6890573223879
     8         65d-2*t16*t18*t24*t25*t53*t75+2.0167929917909735d-2*t16*t
     9         18*t22*t23*t53*t75+1.3445286611939825d-2*t16*t18*t20*t21*
     :         t53*t75+6.722643305969912d-3*t15*t16*t18*t53*t75-6.722643
     ;         305969912d-2*t16*t18*t24*t27*t53*t74-4.033585983581947d-2
     <         *t16*t18*t22*t25*t53*t74-2.0167929917909735d-2*t16*t18*t2
     =         0*t23*t53*t74-6.722643305969912d-3*t16*t18*t21*t53*t74-3.
     >         361321652984956d-3*t16*t18*t29*t37*t55-1.680660826492478d
     ?         -2*t16*t18*t29*t35*t36*t55-1.3445286611939825d-2*t16*t18*
     @         t29*t33*t34*t55-1.0083964958954868d-2*t16*t18*t29*t31*t32
     1         *t55-6.722643305969912d-3*t16*t18*t28*t29*t30*t55
            t90 = 2.2596966509651034d-4*t16*t18*t24*t27*t54+1.3558179905
     1         79062d-4*t16*t18*t22*t25*t54+6.77908995289531d-5*t16*t18*
     2         t20*t23*t54+2.2596966509651034d-5*t16*t18*t21*t54
            t91 = t44**3
            t92 = 1/rhoa**3.6666666666666664d+0
            t93 = 1/t2**7
            t94 = 1/rhoa**3.3333333333333337d+0
            t95 = 1/rhoa**3.1666666666666665d+0
            t96 = t47**3
            t97 = 2.0690405167709364d+3*t9*t96/(t6**6*t7**3)+6.0d+0*t46*
     1         t69*t9*t96-1.9298375398431045d+2*t67*t9*t96/t6**5+1.11022
     2         30246251565d-16*t13*t39*t45*(-2.520426340996149d+0*t95-2.
     3         3079979182303428d+0*t94-1.5008036906238065d+0*t93-5.62075
     4         3557770543d-1*t92)+1.0d+0*t46*t48*t9*(-4.684972743248224d
     5         +0*t95-3.9871442462415524d+0*t94-3.083875829189267d+0*t93
     6         -7.128507529742789d-1*t92)+4.1099018897499934d-3*t8*t94+9
     7         .490883560204437d-19*t12*t94+6.661338147750939d-16*t13*t3
     8         9*t60*t91-1.0712750352598913d-14*t13*t58*t91/t10**5+5.742
     9         741051503565d-14*t13*t91/(t10**6*t11**3)-6.0d+0*t46*t47*t
     :         70*t71*t9+9.649187699215522d+1*t47*t67*t69*t71*t9-1.27469
     ;         6188700087d-1*t42*t46*t48*t71+2.549392377400174d-1*t42*t4
     <         6*t68*t70-4.0999275947472624d+0*t42*t67*t68*t69-6.6613381
     =         47750939d-16*t13*t39*t44*t61*t66+5.356375176299456d-15*t1
     >         3*t44*t58*t60*t66-1.4718104502398274d-17*t39*t42*t45*t66+
     ?         1.6995949182667827d-1*t46*t47*t48*t64+1.962413933653103d-
     @         17*t39*t44*t45*t64+2.943620900479655d-17*t39*t42*t59*t61-
     1         2.3669625486718335d-16*t42*t58*t59*t60
            t98 = t53**3
            t99 = 1/t19**6
            t100 = 1/t19**5
            t101 = rhoa**5.000000000000002d-1
            t102 = 1/t17**5.0d+0
            t103 = 1/rhoa**6.666666666666665d-1
            t104 = 1/rhoa**1.8333333333333332d+0
            t105 = t49**3
            t106 = 1/t14**4
            t107 = 3.361321652984956d-3*gammaaa*t18*t52*t97+4.7058503141
     1         78939d-2*gammaaa*t50*t51*t79*t80-2.0167929917909735d-2*ga
     2         mmaaa*t18*t49*t72*t80-3.9215419284824504d-3*gammaaa*t49*t
     3         51*t52*t78+8.235238049813143d-2*gammaaa*t49*t52*t76*t77-1
     4         .3725396749688576d-2*gammaaa*t103*t16*t77-2.3529251570894
     5         694d-2*gammaaa*t50*t51*t52*t72-1.0893172023562361d-3*gamm
     6         aaa*t104*t16*t51+2.0167929917909735d-2*gammaaa*t105*t106*
     7         t18+1.2810370299709334d-1*gammaaa*t101*t102*t16
            t108 = -3.361321652984956d-3*gammaaa*t18*t52*t97-4.705850314
     1         178939d-2*gammaaa*t50*t51*t79*t80+2.0167929917909735d-2*g
     2         ammaaa*t18*t49*t72*t80+3.9215419284824504d-3*gammaaa*t49*
     3         t51*t52*t78-8.235238049813143d-2*gammaaa*t49*t52*t76*t77+
     4         1.3725396749688576d-2*gammaaa*t103*t16*t77+2.352925157089
     5         4694d-2*gammaaa*t50*t51*t52*t72+1.0893172023562361d-3*gam
     6         maaa*t104*t16*t51-2.0167929917909735d-2*gammaaa*t105*t106
     7         *t18-1.2810370299709334d-1*gammaaa*t101*t102*t16
            t109 = t55**3
            t110 = -6.722643305969912d-3*gammaaa*t18*t49*t52-1.568616771
     1         3929794d-2*gammaaa*t16*t50*t51
            t111 = exp(1.0083964958954868d-2*gammaaa*t16*t18)
            t112 = -6.722643305969912d-3*t18*t79*t80+1.3071806428274835d
     1         -3*t16*t51*t78-2.745079349937714d-2*t16*t76*t77+3.3613216
     2         52984956d-3*t18*t52*t72-1.5686167713929794d-2*t49*t50*t51
     3         *t52
            t113 = 6.722643305969912d-3*t18*t79*t80-1.3071806428274835d-
     1         3*t16*t51*t78+2.745079349937714d-2*t16*t76*t77-3.36132165
     2         2984956d-3*t18*t52*t72+1.5686167713929794d-2*t49*t50*t51*
     3         t52
            t114 = 2.2596966509651034d-4*t33*t36*t52*t77*t84+1.355817990
     1         579062d-4*t31*t34*t52*t77*t84+6.77908995289531d-5*t30*t32
     2         *t52*t77*t84+2.2596966509651034d-5*t28*t52*t77*t84-1.1298
     3         483254825517d-4*t26*t27*t52*t75*t77-9.038786603860414d-5*
     4         t24*t25*t52*t75*t77-6.77908995289531d-5*t22*t23*t52*t75*t
     5         77-4.519393301930207d-5*t20*t21*t52*t75*t77-2.25969665096
     6         51034d-5*t15*t52*t75*t77+2.2596966509651034d-4*t24*t27*t5
     7         2*t74*t77+1.355817990579062d-4*t22*t25*t52*t74*t77+6.7790
     8         8995289531d-5*t20*t23*t52*t74*t77+2.2596966509651034d-5*t
     9         21*t52*t74*t77-1.1298483254825517d-5*t29*t37*t52*t77-5.64
     :         9241627412759d-5*t29*t35*t36*t52*t77-4.519393301930207d-5
     ;         *t29*t33*t34*t52*t77-3.389544976447655d-5*t29*t31*t32*t52
     <         *t77-2.2596966509651034d-5*t28*t29*t30*t52*t77
            fnc(iq) = 1.0d+0*rhoa*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t14*t56*wght+1.0d+0*rhoa*t38*t4
     1         9*wght+1.0d+0*t14*t38*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*rhoa*t14*(t16*t18*t54*t57+t16*t18*(
     1         -3.361321652984956d-3*t29*t37-1.680660826492478d-2*t29*t3
     2         5*t36-1.3445286611939825d-2*t29*t33*t34-1.008396495895486
     3         8d-2*t29*t31*t32-6.722643305969912d-3*t28*t29*t30))*wght+
     4         Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t14*t85*wght+1.0d+0*rhoa*t3
     1         8*t72*wght+2.0d+0*rhoa*t49*t56*wght+2.0d+0*t14*t56*wght+2
     2         .0d+0*t38*t49*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*rhoa*t14*t89*wght+1.0d+0*rhoa*t
     1         49*t86*wght+1.0d+0*t14*t86*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*rhoa*t14*(t16*t18*t54*t90+t16*
     1         t18*(2.2596966509651034d-4*t16*t18*t33*t36*t84+1.35581799
     2         0579062d-4*t16*t18*t31*t34*t84+6.77908995289531d-5*t16*t1
     3         8*t30*t32*t84+2.2596966509651034d-5*t16*t18*t28*t84-1.129
     4         8483254825517d-5*t16*t18*t29*t37-5.649241627412759d-5*t16
     5         *t18*t29*t35*t36-4.519393301930207d-5*t16*t18*t29*t33*t34
     6         -3.389544976447655d-5*t16*t18*t29*t31*t32-2.2596966509651
     7         034d-5*t16*t18*t28*t29*t30)+6.722643305969912d-3*t52*t57*
     8         t75*t77)*wght+Cmat2(iq,D2_GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*t14*(6.0d+1*t22*t27*t98*
     1         t99+2.4d+1*t20*t25*t98*t99+6.0d+0*t23*t98*t99+3.0d+1*t26*
     2         t27*t74*t98+2.4d+1*t24*t25*t74*t98+1.8d+1*t22*t23*t74*t98
     3         +1.2d+1*t20*t21*t74*t98+6.0d+0*t15*t74*t98-1.2d+2*t100*t2
     4         4*t27*t98-7.2d+1*t100*t22*t25*t98-3.6d+1*t100*t20*t23*t98
     5         -1.2d+1*t100*t21*t98+2.0d+1*t110*t33*t36*t83*t84+1.2d+1*t
     6         110*t31*t34*t83*t84+6.0d+0*t110*t30*t32*t83*t84+2.0d+0*t1
     7         10*t28*t83*t84+6.0d+1*t33*t36*t55*t82*t84+3.6d+1*t31*t34*
     8         t55*t82*t84+1.8d+1*t30*t32*t55*t82*t84+6.0d+0*t28*t55*t82
     9         *t84+2.0d+1*t109*t33*t36*t84+1.2d+1*t109*t31*t34*t84+6.0d
     :         +0*t109*t30*t32*t84+2.0d+0*t109*t28*t84-3*t29*t37*t55*t82
     ;         -1.5d+1*t29*t35*t36*t55*t82-1.2d+1*t29*t33*t34*t55*t82-9.
     <         0d+0*t29*t31*t32*t55*t82-6.0d+0*t28*t29*t30*t55*t82-3.0d+
     =         1*t26*t27*t53*t75*t81-2.4d+1*t24*t25*t53*t75*t81-1.8d+1*t
     >         22*t23*t53*t75*t81-1.2d+1*t20*t21*t53*t75*t81-6.0d+0*t15*
     ?         t53*t75*t81+6.0d+1*t24*t27*t53*t74*t81+3.6d+1*t22*t25*t53
     @         *t74*t81+1.8d+1*t20*t23*t53*t74*t81+6.0d+0*t21*t53*t74*t8
     1         1+5.0d+0*t107*t26*t27*t54+4.0d+0*t107*t24*t25*t54+3.0d+0*
     2         t107*t22*t23*t54+2.0d+0*t107*t20*t21*t54+1.0d+0*t107*t15*
     3         t54-t109*t29*t37-t108*t29*t37-5.0d+0*t109*t29*t35*t36-5.0
     4         d+0*t108*t29*t35*t36-6.0d+1*t109*t111*t31*t36-4.0d+0*t109
     5         *t29*t33*t34-4.0d+0*t108*t29*t33*t34-2.4d+1*t109*t111*t30
     6         *t34-3.0d+0*t109*t29*t31*t32-3.0d+0*t108*t29*t31*t32-6.0d
     7         +0*t109*t111*t32-2.0d+0*t109*t28*t29*t30-2.0d+0*t108*t28*
     8         t29*t30)*wght+1.0d+0*rhoa*t38*t97*wght+3.0d+0*rhoa*t49*t8
     9         5*wght+3.0d+0*t14*t85*wght+3.0d+0*rhoa*t56*t72*wght+3.0d+
     :         0*t38*t72*wght+6.0d+0*t49*t56*wght+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*rhoa*t14*(-2.016792991790973
     1         5d-1*t16*t18*t22*t27*t73*t99-8.067171967163894d-2*t16*t18
     2         *t20*t25*t73*t99-2.0167929917909735d-2*t16*t18*t23*t73*t9
     3         9+4.0d+1*t33*t36*t55*t84*t88+2.4d+1*t31*t34*t55*t84*t88+1
     4         .2d+1*t30*t32*t55*t84*t88+4.0d+0*t28*t55*t84*t88-2*t29*t3
     5         7*t55*t88-1.0d+1*t29*t35*t36*t55*t88-8.0d+0*t29*t33*t34*t
     6         55*t88-6.0d+0*t29*t31*t32*t55*t88-4.0d+0*t28*t29*t30*t55*
     7         t88-2.0d+1*t26*t27*t53*t75*t87-1.6d+1*t24*t25*t53*t75*t87
     8         -1.2d+1*t22*t23*t53*t75*t87-8.0d+0*t20*t21*t53*t75*t87-4.
     9         0d+0*t15*t53*t75*t87+4.0d+1*t24*t27*t53*t74*t87+2.4d+1*t2
     :         2*t25*t53*t74*t87+1.2d+1*t20*t23*t53*t74*t87+4.0d+0*t21*t
     ;         53*t74*t87+2.0167929917909738d-1*t16*t18*t33*t36*t83*t84+
     <         1.2100757950745841d-1*t16*t18*t31*t34*t83*t84+6.050378975
     =         372921d-2*t16*t18*t30*t32*t83*t84+2.0167929917909735d-2*t
     >         16*t18*t28*t83*t84+6.722643305969912d-2*t16*t18*t33*t36*t
     ?         82*t84+4.033585983581947d-2*t16*t18*t31*t34*t82*t84+2.016
     @         7929917909735d-2*t16*t18*t30*t32*t82*t84+6.72264330596991
     1         2d-3*t16*t18*t28*t82*t84-3.361321652984956d-3*t16*t18*t29
     2         *t37*t83-1.680660826492478d-2*t16*t18*t29*t35*t36*t83-2.0
     3         167929917909735d-1*t111*t16*t18*t31*t36*t83-1.34452866119
     4         39825d-2*t16*t18*t29*t33*t34*t83-8.067171967163894d-2*t11
     5         1*t16*t18*t30*t34*t83-1.0083964958954868d-2*t16*t18*t29*t
     6         31*t32*t83-2.0167929917909735d-2*t111*t16*t18*t32*t83-6.7
     7         22643305969912d-3*t16*t18*t28*t29*t30*t83-3.3613216529849
     8         56d-3*t16*t18*t29*t37*t82-1.680660826492478d-2*t16*t18*t2
     9         9*t35*t36*t82-1.3445286611939825d-2*t16*t18*t29*t33*t34*t
     :         82-1.0083964958954868d-2*t16*t18*t29*t31*t32*t82-6.722643
     ;         305969912d-3*t16*t18*t28*t29*t30*t82+3.361321652984956d-2
     <         *t16*t18*t26*t27*t75*t81+2.689057322387965d-2*t16*t18*t24
     =         *t25*t75*t81+2.0167929917909735d-2*t16*t18*t22*t23*t75*t8
     >         1+1.3445286611939825d-2*t16*t18*t20*t21*t75*t81+6.7226433
     ?         05969912d-3*t15*t16*t18*t75*t81-6.722643305969912d-2*t16*
     @         t18*t24*t27*t74*t81-4.033585983581947d-2*t16*t18*t22*t25*
     1         t74*t81-2.0167929917909735d-2*t16*t18*t20*t23*t74*t81-6.7
     2         22643305969912d-3*t16*t18*t21*t74*t81-1.0083964958954868d
     3         -1*t16*t18*t26*t27*t73*t74-8.067171967163894d-2*t16*t18*t
     4         24*t25*t73*t74-6.050378975372921d-2*t16*t18*t22*t23*t73*t
     5         74-4.033585983581947d-2*t16*t18*t20*t21*t73*t74-2.0167929
     6         917909735d-2*t15*t16*t18*t73*t74+4.0335859835819476d-1*t1
     7         00*t16*t18*t24*t27*t73+2.4201515901491683d-1*t100*t16*t18
     8         *t22*t25*t73+1.2100757950745841d-1*t100*t16*t18*t20*t23*t
     9         73+4.033585983581947d-2*t100*t16*t18*t21*t73+5.0d+0*t112*
     :         t26*t27*t54+4.0d+0*t112*t24*t25*t54+3.0d+0*t112*t22*t23*t
     ;         54+2.0d+0*t112*t20*t21*t54+1.0d+0*t112*t15*t54-t113*t29*t
     <         37-5.0d+0*t113*t29*t35*t36-4.0d+0*t113*t29*t33*t34-3.0d+0
     =         *t113*t29*t31*t32-2.0d+0*t113*t28*t29*t30)*wght+2.0d+0*rh
     >         oa*t49*t89*wght+2.0d+0*t14*t89*wght+1.0d+0*rhoa*t72*t86*w
     ?         ght+2.0d+0*t49*t86*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*rhoa*t14*(6.77908995289531d
     1         -4*t22*t27*t52*t53*t77*t99+2.711635981158124d-4*t20*t25*t
     2         52*t53*t77*t99+6.77908995289531d-5*t23*t52*t53*t77*t99+1.
     3         3445286611939825d-1*t16*t18*t33*t36*t84*t88+8.06717196716
     4         3894d-2*t16*t18*t31*t34*t84*t88+4.033585983581947d-2*t16*
     5         t18*t30*t32*t84*t88+1.3445286611939825d-2*t16*t18*t28*t84
     6         *t88-6.722643305969912d-3*t16*t18*t29*t37*t88-3.361321652
     7         984956d-2*t16*t18*t29*t35*t36*t88-2.689057322387965d-2*t1
     8         6*t18*t29*t33*t34*t88-2.0167929917909735d-2*t16*t18*t29*t
     9         31*t32*t88-1.3445286611939825d-2*t16*t18*t28*t29*t30*t88+
     :         6.722643305969912d-2*t16*t18*t26*t27*t75*t87+5.3781146447
     ;         7593d-2*t16*t18*t24*t25*t75*t87+4.033585983581947d-2*t16*
     <         t18*t22*t23*t75*t87+2.689057322387965d-2*t16*t18*t20*t21*
     =         t75*t87+1.3445286611939825d-2*t15*t16*t18*t75*t87-1.34452
     >         86611939825d-1*t16*t18*t24*t27*t74*t87-8.067171967163894d
     ?         -2*t16*t18*t22*t25*t74*t87-4.033585983581947d-2*t16*t18*t
     @         20*t23*t74*t87-1.3445286611939825d-2*t16*t18*t21*t74*t87+
     1         6.779089952895311d-4*t33*t36*t52*t55*t77*t84+4.0674539717
     2         371866d-4*t31*t34*t52*t55*t77*t84+2.0337269858685933d-4*t
     3         30*t32*t52*t55*t77*t84+6.77908995289531d-5*t28*t52*t55*t7
     4         7*t84+3.389544976447655d-4*t26*t27*t52*t53*t74*t77+2.7116
     5         35981158124d-4*t24*t25*t52*t53*t74*t77+2.033726985868593d
     6         -4*t22*t23*t52*t53*t74*t77+1.355817990579062d-4*t20*t21*t
     7         52*t53*t74*t77+6.77908995289531d-5*t15*t52*t53*t74*t77-1.
     8         1298483254825517d-5*t29*t37*t52*t55*t77-5.649241627412759
     9         d-5*t29*t35*t36*t52*t55*t77-6.77908995289531d-4*t111*t31*
     :         t36*t52*t55*t77-4.519393301930207d-5*t29*t33*t34*t52*t55*
     ;         t77-2.711635981158124d-4*t111*t30*t34*t52*t55*t77-3.38954
     <         4976447655d-5*t29*t31*t32*t52*t55*t77-6.77908995289531d-5
     =         *t111*t32*t52*t55*t77-2.2596966509651034d-5*t28*t29*t30*t
     >         52*t55*t77-1.355817990579062d-3*t100*t24*t27*t52*t53*t77-
     ?         8.134907943474373d-4*t100*t22*t25*t52*t53*t77-4.067453971
     @         7371866d-4*t100*t20*t23*t52*t53*t77-1.355817990579062d-4*
     1         t100*t21*t52*t53*t77)*wght+1.0d+0*rhoa*t114*t49*wght+1.0d
     2         +0*t114*t14*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*rhoa*t14*(1.34452866119398
     1         25d-2*t52*t75*t77*t90+t16*t18*(2.2786701846199775d-6*t33*
     2         t36*t52*t77*t84+1.3672021107719862d-6*t31*t34*t52*t77*t84
     3         +6.836010553859931d-7*t30*t32*t52*t77*t84+2.2786701846199
     4         772d-7*t28*t52*t77*t84-3.7977836410332955d-8*t29*t37*t52*
     5         t77-1.8988918205166477d-7*t29*t35*t36*t52*t77-2.278670184
     6         6199775d-6*t111*t31*t36*t52*t77-1.5191134564133182d-7*t29
     7         *t33*t34*t52*t77-9.114680738479908d-7*t111*t30*t34*t52*t7
     8         7-1.1393350923099885d-7*t29*t31*t32*t52*t77-2.27867018461
     9         9977d-7*t111*t32*t52*t77-7.595567282066591d-8*t28*t29*t30
     :         *t52*t77)+6.77908995289531d-5*t57*t74*t80/t17**6.0d+0+t16
     ;         *t18*t54*(1.5191134564133182d-6*t24*t27*t52*t75*t77+9.114
     <         680738479908d-7*t22*t25*t52*t75*t77+4.557340369239954d-7*
     =         t20*t23*t52*t75*t77+1.5191134564133182d-7*t21*t52*t75*t77
     >         -2.2786701846199775d-6*t22*t27*t52*t74*t77-9.114680738479
     ?         908d-7*t20*t25*t52*t74*t77-2.278670184619977d-7*t23*t52*t
     @         74*t77))*wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = 1/rhob**6.666666666666666d-1
            t2 = rhob**5.0d-1
            t3 = 1/t2
            t4 = 1/rhob**3.333333333333333d-1
            t5 = 1/rhob**1.6666666666666666d-1
            t6 = 1.1120374863094686d+1*t5+3.8447462374472113d+0*t4+1.644
     1         733775567609d+0*t3+2.4058712912881916d-1*t1
            t7 = 3.216395899738507d+1/t6+1.0d+0
            t8 = log(t7)
            t9 = 1.274696188700087d-1*t4+1.0d+0
            t10 = 5.982550435771079d+0*t5+2.2255694211506874d+0*t4+8.004
     1         286349993635d-1*t3+1.8970043257475583d-1*t1
            t11 = 1.6081979498692536d+1/t10+1.0d+0
            t12 = log(t11)
            t13 = 1.3256889990520176d-1*t4+1.0d+0
            t14 = -3.1090699999999993d-2*t8*t9-6.903522198342671d-18*t12
     1         *t13
            t15 = param(2)
            t16 = 1/t14
            t17 = rhob**1.1666666666666667d+0
            t18 = 1/t17**2.0d+0
            t19 = 1.0d+0-3.361321652984956d-3*gammabb*t16*t18
            t20 = 1.0d+0-1.0d+0/t19
            t21 = param(3)
            t22 = t20**2.0d+0
            t23 = param(4)
            t24 = t20**3.0d+0
            t25 = param(5)
            t26 = t20**4.0d+0
            t27 = param(6)
            t28 = param(9)
            t29 = exp(3.361321652984956d-3*gammabb*t16*t18)
            t30 = 1.0d+0-t29
            t31 = t30**2.0d+0
            t32 = param(10)
            t33 = t30**3.0d+0
            t34 = param(11)
            t35 = t30**4.0d+0
            t36 = param(12)
            t37 = param(8)
            t38 = t30*t37+t30**5.0d+0*t36+t34*t35+t32*t33+t28*t31+t20**5
     1         .0d+0*t27+t25*t26+t23*t24+t21*t22+t15*t20+param(7)+param(
     2         1)
            t39 = 1/t11
            t40 = 1/rhob**1.6666666666666669d+0
            t41 = 1/t2**3
            t42 = 1/rhob**1.3333333333333333d+0
            t43 = 1/rhob**1.1666666666666667d+0
            t44 = -9.970917392951799d-1*t43-7.418564737168958d-1*t42-4.0
     1         02143174996817d-1*t41-1.264669550498372d-1*t40
            t45 = 1/t10**2
            t46 = 1/t7
            t47 = -1.8533958105157808d+0*t43-1.2815820791490704d+0*t42-8
     1         .223668877838045d-1*t41-1.6039141941921276d-1*t40
            t48 = 1/t6**2
            t49 = 1.0d+0*t46*t47*t48*t9+1.3210398931339265d-3*t42*t8+1.1
     1         102230246251565d-16*t13*t39*t44*t45+3.0506411443514264d-1
     2         9*t12*t42
            t50 = rhob**1.6666666666666674d-1
            t51 = 1/t17**3.0d+0
            t52 = 1/t14**2
            t53 = 3.361321652984956d-3*gammabb*t18*t49*t52+7.84308385696
     1         4898d-3*gammabb*t16*t50*t51
            t54 = 1/t19**2
            t55 = -3.361321652984956d-3*gammabb*t18*t49*t52-7.8430838569
     1         64898d-3*gammabb*t16*t50*t51
            t56 = -t29*t37*t55-5.0d+0*t29*t35*t36*t55-4.0d+0*t29*t33*t34
     1         *t55-3.0d+0*t29*t31*t32*t55-2.0d+0*t28*t29*t30*t55+5.0d+0
     2         *t26*t27*t53*t54+4.0d+0*t24*t25*t53*t54+3.0d+0*t22*t23*t5
     3         3*t54+2.0d+0*t20*t21*t53*t54+1.0d+0*t15*t53*t54
            t57 = -1.680660826492478d-2*t26*t27-1.3445286611939825d-2*t2
     1         4*t25-1.0083964958954868d-2*t22*t23-6.722643305969912d-3*
     2         t20*t21-3.361321652984956d-3*t15
            t58 = 1/t11**2
            t59 = t44**2
            t60 = 1/t10**4
            t61 = 1/t10**3
            t62 = 1/rhob**2.6666666666666666d+0
            t63 = 1/t2**5
            t64 = 1/rhob**2.3333333333333334d+0
            t65 = 1/rhob**2.1666666666666665d+0
            t66 = 1.1632736958443765d+0*t65+9.89141964955861d-1*t64+6.00
     1         3214762495226d-1*t63+2.1077825841639536d-1*t62
            t67 = 1/t7**2
            t68 = t47**2
            t69 = 1/t6**4
            t70 = 1/t6**3
            t71 = 2.1622951122684114d+0*t65+1.7087761055320938d+0*t64+1.
     1         2335503316757068d+0*t63+2.673190323653546d-1*t62
            t72 = 1.0d+0*t46*t48*t71*t9-2.0d+0*t46*t68*t70*t9+3.21639589
     1         9738507d+1*t67*t68*t69*t9-1.7613865241785684d-3*t64*t8+1.
     2         1102230246251565d-16*t13*t39*t45*t66-4.0675215258019015d-
     3         19*t12*t64-2.220446049250313d-16*t13*t39*t59*t61+1.785458
     4         3920998188d-15*t13*t58*t59*t60-8.497974591333913d-2*t42*t
     5         46*t47*t48-9.812069668265515d-18*t39*t42*t44*t45
            t73 = t53**2
            t74 = 1/t19**4
            t75 = 1/t19**3
            t76 = rhob**3.333333333333335d-1
            t77 = 1/t17**4.0d+0
            t78 = 1/rhob**8.333333333333333d-1
            t79 = t49**2
            t80 = 1/t14**3
            t81 = -6.722643305969912d-3*gammabb*t18*t79*t80+1.3071806428
     1         274835d-3*gammabb*t16*t51*t78-2.745079349937714d-2*gammab
     2         b*t16*t76*t77+3.361321652984956d-3*gammabb*t18*t52*t72-1.
     3         5686167713929794d-2*gammabb*t49*t50*t51*t52
            t82 = 6.722643305969912d-3*gammabb*t18*t79*t80-1.30718064282
     1         74835d-3*gammabb*t16*t51*t78+2.745079349937714d-2*gammabb
     2         *t16*t76*t77-3.361321652984956d-3*gammabb*t18*t52*t72+1.5
     3         686167713929794d-2*gammabb*t49*t50*t51*t52
            t83 = t55**2
            t84 = exp(6.722643305969912d-3*gammabb*t16*t18)
            t85 = 2.0d+1*t33*t36*t83*t84+1.2d+1*t31*t34*t83*t84+6.0d+0*t
     1         30*t32*t83*t84+2.0d+0*t28*t83*t84-t29*t37*t83-5.0d+0*t29*
     2         t35*t36*t83-4.0d+0*t29*t33*t34*t83-3.0d+0*t29*t31*t32*t83
     3         -2.0d+0*t28*t29*t30*t83-t29*t37*t82-5.0d+0*t29*t35*t36*t8
     4         2-4.0d+0*t29*t33*t34*t82-3.0d+0*t29*t31*t32*t82-2.0d+0*t2
     5         8*t29*t30*t82+5.0d+0*t26*t27*t54*t81+4.0d+0*t24*t25*t54*t
     6         81+3.0d+0*t22*t23*t54*t81+2.0d+0*t20*t21*t54*t81+1.0d+0*t
     7         15*t54*t81-1.0d+1*t26*t27*t73*t75-8.0d+0*t24*t25*t73*t75-
     8         6.0d+0*t22*t23*t73*t75-4.0d+0*t20*t21*t73*t75-2.0d+0*t15*
     9         t73*t75+2.0d+1*t24*t27*t73*t74+1.2d+1*t22*t25*t73*t74+6.0
     :         d+0*t20*t23*t73*t74+2.0d+0*t21*t73*t74
            t86 = -1.680660826492478d-2*t16*t18*t26*t27*t54-1.3445286611
     1         939825d-2*t16*t18*t24*t25*t54-1.0083964958954868d-2*t16*t
     2         18*t22*t23*t54-6.722643305969912d-3*t16*t18*t20*t21*t54-3
     3         .361321652984956d-3*t15*t16*t18*t54-3.361321652984956d-3*
     4         t16*t18*t29*t37-1.680660826492478d-2*t16*t18*t29*t35*t36-
     5         1.3445286611939825d-2*t16*t18*t29*t33*t34-1.0083964958954
     6         868d-2*t16*t18*t29*t31*t32-6.722643305969912d-3*t16*t18*t
     7         28*t29*t30
            t87 = 3.361321652984956d-3*t18*t49*t52+7.843083856964898d-3*
     1         t16*t50*t51
            t88 = -3.361321652984956d-3*t18*t49*t52-7.843083856964898d-3
     1         *t16*t50*t51
            t89 = -t29*t37*t88-5.0d+0*t29*t35*t36*t88-4.0d+0*t29*t33*t34
     1         *t88-3.0d+0*t29*t31*t32*t88-2.0d+0*t28*t29*t30*t88+5.0d+0
     2         *t26*t27*t54*t87+4.0d+0*t24*t25*t54*t87+3.0d+0*t22*t23*t5
     3         4*t87+2.0d+0*t20*t21*t54*t87+1.0d+0*t15*t54*t87+6.7226433
     4         05969912d-2*t16*t18*t33*t36*t55*t84+4.033585983581947d-2*
     5         t16*t18*t31*t34*t55*t84+2.0167929917909735d-2*t16*t18*t30
     6         *t32*t55*t84+6.722643305969912d-3*t16*t18*t28*t55*t84+3.3
     7         61321652984956d-2*t16*t18*t26*t27*t53*t75+2.6890573223879
     8         65d-2*t16*t18*t24*t25*t53*t75+2.0167929917909735d-2*t16*t
     9         18*t22*t23*t53*t75+1.3445286611939825d-2*t16*t18*t20*t21*
     :         t53*t75+6.722643305969912d-3*t15*t16*t18*t53*t75-6.722643
     ;         305969912d-2*t16*t18*t24*t27*t53*t74-4.033585983581947d-2
     <         *t16*t18*t22*t25*t53*t74-2.0167929917909735d-2*t16*t18*t2
     =         0*t23*t53*t74-6.722643305969912d-3*t16*t18*t21*t53*t74-3.
     >         361321652984956d-3*t16*t18*t29*t37*t55-1.680660826492478d
     ?         -2*t16*t18*t29*t35*t36*t55-1.3445286611939825d-2*t16*t18*
     @         t29*t33*t34*t55-1.0083964958954868d-2*t16*t18*t29*t31*t32
     1         *t55-6.722643305969912d-3*t16*t18*t28*t29*t30*t55
            t90 = 2.2596966509651034d-4*t16*t18*t24*t27*t54+1.3558179905
     1         79062d-4*t16*t18*t22*t25*t54+6.77908995289531d-5*t16*t18*
     2         t20*t23*t54+2.2596966509651034d-5*t16*t18*t21*t54
            t91 = t44**3
            t92 = 1/rhob**3.6666666666666664d+0
            t93 = 1/t2**7
            t94 = 1/rhob**3.3333333333333337d+0
            t95 = 1/rhob**3.1666666666666665d+0
            t96 = t47**3
            t97 = 2.0690405167709364d+3*t9*t96/(t6**6*t7**3)+6.0d+0*t46*
     1         t69*t9*t96-1.9298375398431045d+2*t67*t9*t96/t6**5+1.11022
     2         30246251565d-16*t13*t39*t45*(-2.520426340996149d+0*t95-2.
     3         3079979182303428d+0*t94-1.5008036906238065d+0*t93-5.62075
     4         3557770543d-1*t92)+1.0d+0*t46*t48*t9*(-4.684972743248224d
     5         +0*t95-3.9871442462415524d+0*t94-3.083875829189267d+0*t93
     6         -7.128507529742789d-1*t92)+4.1099018897499934d-3*t8*t94+9
     7         .490883560204437d-19*t12*t94+6.661338147750939d-16*t13*t3
     8         9*t60*t91-1.0712750352598913d-14*t13*t58*t91/t10**5+5.742
     9         741051503565d-14*t13*t91/(t10**6*t11**3)-6.0d+0*t46*t47*t
     :         70*t71*t9+9.649187699215522d+1*t47*t67*t69*t71*t9-1.27469
     ;         6188700087d-1*t42*t46*t48*t71+2.549392377400174d-1*t42*t4
     <         6*t68*t70-4.0999275947472624d+0*t42*t67*t68*t69-6.6613381
     =         47750939d-16*t13*t39*t44*t61*t66+5.356375176299456d-15*t1
     >         3*t44*t58*t60*t66-1.4718104502398274d-17*t39*t42*t45*t66+
     ?         1.6995949182667827d-1*t46*t47*t48*t64+1.962413933653103d-
     @         17*t39*t44*t45*t64+2.943620900479655d-17*t39*t42*t59*t61-
     1         2.3669625486718335d-16*t42*t58*t59*t60
            t98 = t53**3
            t99 = 1/t19**6
            t100 = 1/t19**5
            t101 = rhob**5.000000000000002d-1
            t102 = 1/t17**5.0d+0
            t103 = 1/rhob**6.666666666666665d-1
            t104 = 1/rhob**1.8333333333333332d+0
            t105 = t49**3
            t106 = 1/t14**4
            t107 = 3.361321652984956d-3*gammabb*t18*t52*t97+4.7058503141
     1         78939d-2*gammabb*t50*t51*t79*t80-2.0167929917909735d-2*ga
     2         mmabb*t18*t49*t72*t80-3.9215419284824504d-3*gammabb*t49*t
     3         51*t52*t78+8.235238049813143d-2*gammabb*t49*t52*t76*t77-1
     4         .3725396749688576d-2*gammabb*t103*t16*t77-2.3529251570894
     5         694d-2*gammabb*t50*t51*t52*t72-1.0893172023562361d-3*gamm
     6         abb*t104*t16*t51+2.0167929917909735d-2*gammabb*t105*t106*
     7         t18+1.2810370299709334d-1*gammabb*t101*t102*t16
            t108 = -3.361321652984956d-3*gammabb*t18*t52*t97-4.705850314
     1         178939d-2*gammabb*t50*t51*t79*t80+2.0167929917909735d-2*g
     2         ammabb*t18*t49*t72*t80+3.9215419284824504d-3*gammabb*t49*
     3         t51*t52*t78-8.235238049813143d-2*gammabb*t49*t52*t76*t77+
     4         1.3725396749688576d-2*gammabb*t103*t16*t77+2.352925157089
     5         4694d-2*gammabb*t50*t51*t52*t72+1.0893172023562361d-3*gam
     6         mabb*t104*t16*t51-2.0167929917909735d-2*gammabb*t105*t106
     7         *t18-1.2810370299709334d-1*gammabb*t101*t102*t16
            t109 = t55**3
            t110 = -6.722643305969912d-3*gammabb*t18*t49*t52-1.568616771
     1         3929794d-2*gammabb*t16*t50*t51
            t111 = exp(1.0083964958954868d-2*gammabb*t16*t18)
            t112 = -6.722643305969912d-3*t18*t79*t80+1.3071806428274835d
     1         -3*t16*t51*t78-2.745079349937714d-2*t16*t76*t77+3.3613216
     2         52984956d-3*t18*t52*t72-1.5686167713929794d-2*t49*t50*t51
     3         *t52
            t113 = 6.722643305969912d-3*t18*t79*t80-1.3071806428274835d-
     1         3*t16*t51*t78+2.745079349937714d-2*t16*t76*t77-3.36132165
     2         2984956d-3*t18*t52*t72+1.5686167713929794d-2*t49*t50*t51*
     3         t52
            t114 = 2.2596966509651034d-4*t33*t36*t52*t77*t84+1.355817990
     1         579062d-4*t31*t34*t52*t77*t84+6.77908995289531d-5*t30*t32
     2         *t52*t77*t84+2.2596966509651034d-5*t28*t52*t77*t84-1.1298
     3         483254825517d-4*t26*t27*t52*t75*t77-9.038786603860414d-5*
     4         t24*t25*t52*t75*t77-6.77908995289531d-5*t22*t23*t52*t75*t
     5         77-4.519393301930207d-5*t20*t21*t52*t75*t77-2.25969665096
     6         51034d-5*t15*t52*t75*t77+2.2596966509651034d-4*t24*t27*t5
     7         2*t74*t77+1.355817990579062d-4*t22*t25*t52*t74*t77+6.7790
     8         8995289531d-5*t20*t23*t52*t74*t77+2.2596966509651034d-5*t
     9         21*t52*t74*t77-1.1298483254825517d-5*t29*t37*t52*t77-5.64
     :         9241627412759d-5*t29*t35*t36*t52*t77-4.519393301930207d-5
     ;         *t29*t33*t34*t52*t77-3.389544976447655d-5*t29*t31*t32*t52
     <         *t77-2.2596966509651034d-5*t28*t29*t30*t52*t77
            fnc(iq) = 1.0d+0*rhob*t14*t38*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t14*t56*wght+1.0d+0*rhob*t38*t4
     1         9*wght+1.0d+0*t14*t38*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*rhob*t14*(t16*t18*t54*t57+t16*t18*(
     1         -3.361321652984956d-3*t29*t37-1.680660826492478d-2*t29*t3
     2         5*t36-1.3445286611939825d-2*t29*t33*t34-1.008396495895486
     3         8d-2*t29*t31*t32-6.722643305969912d-3*t28*t29*t30))*wght+
     4         Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t14*t85*wght+1.0d+0*rhob*t3
     1         8*t72*wght+2.0d+0*rhob*t49*t56*wght+2.0d+0*t14*t56*wght+2
     2         .0d+0*t38*t49*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*rhob*t14*t89*wght+1.0d+0*rhob*t
     1         49*t86*wght+1.0d+0*t14*t86*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*rhob*t14*(t16*t18*t54*t90+t16*
     1         t18*(2.2596966509651034d-4*t16*t18*t33*t36*t84+1.35581799
     2         0579062d-4*t16*t18*t31*t34*t84+6.77908995289531d-5*t16*t1
     3         8*t30*t32*t84+2.2596966509651034d-5*t16*t18*t28*t84-1.129
     4         8483254825517d-5*t16*t18*t29*t37-5.649241627412759d-5*t16
     5         *t18*t29*t35*t36-4.519393301930207d-5*t16*t18*t29*t33*t34
     6         -3.389544976447655d-5*t16*t18*t29*t31*t32-2.2596966509651
     7         034d-5*t16*t18*t28*t29*t30)+6.722643305969912d-3*t52*t57*
     8         t75*t77)*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*t14*(6.0d+1*t22*t27*t98*
     1         t99+2.4d+1*t20*t25*t98*t99+6.0d+0*t23*t98*t99+3.0d+1*t26*
     2         t27*t74*t98+2.4d+1*t24*t25*t74*t98+1.8d+1*t22*t23*t74*t98
     3         +1.2d+1*t20*t21*t74*t98+6.0d+0*t15*t74*t98-1.2d+2*t100*t2
     4         4*t27*t98-7.2d+1*t100*t22*t25*t98-3.6d+1*t100*t20*t23*t98
     5         -1.2d+1*t100*t21*t98+2.0d+1*t110*t33*t36*t83*t84+1.2d+1*t
     6         110*t31*t34*t83*t84+6.0d+0*t110*t30*t32*t83*t84+2.0d+0*t1
     7         10*t28*t83*t84+6.0d+1*t33*t36*t55*t82*t84+3.6d+1*t31*t34*
     8         t55*t82*t84+1.8d+1*t30*t32*t55*t82*t84+6.0d+0*t28*t55*t82
     9         *t84+2.0d+1*t109*t33*t36*t84+1.2d+1*t109*t31*t34*t84+6.0d
     :         +0*t109*t30*t32*t84+2.0d+0*t109*t28*t84-3*t29*t37*t55*t82
     ;         -1.5d+1*t29*t35*t36*t55*t82-1.2d+1*t29*t33*t34*t55*t82-9.
     <         0d+0*t29*t31*t32*t55*t82-6.0d+0*t28*t29*t30*t55*t82-3.0d+
     =         1*t26*t27*t53*t75*t81-2.4d+1*t24*t25*t53*t75*t81-1.8d+1*t
     >         22*t23*t53*t75*t81-1.2d+1*t20*t21*t53*t75*t81-6.0d+0*t15*
     ?         t53*t75*t81+6.0d+1*t24*t27*t53*t74*t81+3.6d+1*t22*t25*t53
     @         *t74*t81+1.8d+1*t20*t23*t53*t74*t81+6.0d+0*t21*t53*t74*t8
     1         1+5.0d+0*t107*t26*t27*t54+4.0d+0*t107*t24*t25*t54+3.0d+0*
     2         t107*t22*t23*t54+2.0d+0*t107*t20*t21*t54+1.0d+0*t107*t15*
     3         t54-t109*t29*t37-t108*t29*t37-5.0d+0*t109*t29*t35*t36-5.0
     4         d+0*t108*t29*t35*t36-6.0d+1*t109*t111*t31*t36-4.0d+0*t109
     5         *t29*t33*t34-4.0d+0*t108*t29*t33*t34-2.4d+1*t109*t111*t30
     6         *t34-3.0d+0*t109*t29*t31*t32-3.0d+0*t108*t29*t31*t32-6.0d
     7         +0*t109*t111*t32-2.0d+0*t109*t28*t29*t30-2.0d+0*t108*t28*
     8         t29*t30)*wght+1.0d+0*rhob*t38*t97*wght+3.0d+0*rhob*t49*t8
     9         5*wght+3.0d+0*t14*t85*wght+3.0d+0*rhob*t56*t72*wght+3.0d+
     :         0*t38*t72*wght+6.0d+0*t49*t56*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*rhob*t14*(-2.016792991790973
     1         5d-1*t16*t18*t22*t27*t73*t99-8.067171967163894d-2*t16*t18
     2         *t20*t25*t73*t99-2.0167929917909735d-2*t16*t18*t23*t73*t9
     3         9+4.0d+1*t33*t36*t55*t84*t88+2.4d+1*t31*t34*t55*t84*t88+1
     4         .2d+1*t30*t32*t55*t84*t88+4.0d+0*t28*t55*t84*t88-2*t29*t3
     5         7*t55*t88-1.0d+1*t29*t35*t36*t55*t88-8.0d+0*t29*t33*t34*t
     6         55*t88-6.0d+0*t29*t31*t32*t55*t88-4.0d+0*t28*t29*t30*t55*
     7         t88-2.0d+1*t26*t27*t53*t75*t87-1.6d+1*t24*t25*t53*t75*t87
     8         -1.2d+1*t22*t23*t53*t75*t87-8.0d+0*t20*t21*t53*t75*t87-4.
     9         0d+0*t15*t53*t75*t87+4.0d+1*t24*t27*t53*t74*t87+2.4d+1*t2
     :         2*t25*t53*t74*t87+1.2d+1*t20*t23*t53*t74*t87+4.0d+0*t21*t
     ;         53*t74*t87+2.0167929917909738d-1*t16*t18*t33*t36*t83*t84+
     <         1.2100757950745841d-1*t16*t18*t31*t34*t83*t84+6.050378975
     =         372921d-2*t16*t18*t30*t32*t83*t84+2.0167929917909735d-2*t
     >         16*t18*t28*t83*t84+6.722643305969912d-2*t16*t18*t33*t36*t
     ?         82*t84+4.033585983581947d-2*t16*t18*t31*t34*t82*t84+2.016
     @         7929917909735d-2*t16*t18*t30*t32*t82*t84+6.72264330596991
     1         2d-3*t16*t18*t28*t82*t84-3.361321652984956d-3*t16*t18*t29
     2         *t37*t83-1.680660826492478d-2*t16*t18*t29*t35*t36*t83-2.0
     3         167929917909735d-1*t111*t16*t18*t31*t36*t83-1.34452866119
     4         39825d-2*t16*t18*t29*t33*t34*t83-8.067171967163894d-2*t11
     5         1*t16*t18*t30*t34*t83-1.0083964958954868d-2*t16*t18*t29*t
     6         31*t32*t83-2.0167929917909735d-2*t111*t16*t18*t32*t83-6.7
     7         22643305969912d-3*t16*t18*t28*t29*t30*t83-3.3613216529849
     8         56d-3*t16*t18*t29*t37*t82-1.680660826492478d-2*t16*t18*t2
     9         9*t35*t36*t82-1.3445286611939825d-2*t16*t18*t29*t33*t34*t
     :         82-1.0083964958954868d-2*t16*t18*t29*t31*t32*t82-6.722643
     ;         305969912d-3*t16*t18*t28*t29*t30*t82+3.361321652984956d-2
     <         *t16*t18*t26*t27*t75*t81+2.689057322387965d-2*t16*t18*t24
     =         *t25*t75*t81+2.0167929917909735d-2*t16*t18*t22*t23*t75*t8
     >         1+1.3445286611939825d-2*t16*t18*t20*t21*t75*t81+6.7226433
     ?         05969912d-3*t15*t16*t18*t75*t81-6.722643305969912d-2*t16*
     @         t18*t24*t27*t74*t81-4.033585983581947d-2*t16*t18*t22*t25*
     1         t74*t81-2.0167929917909735d-2*t16*t18*t20*t23*t74*t81-6.7
     2         22643305969912d-3*t16*t18*t21*t74*t81-1.0083964958954868d
     3         -1*t16*t18*t26*t27*t73*t74-8.067171967163894d-2*t16*t18*t
     4         24*t25*t73*t74-6.050378975372921d-2*t16*t18*t22*t23*t73*t
     5         74-4.033585983581947d-2*t16*t18*t20*t21*t73*t74-2.0167929
     6         917909735d-2*t15*t16*t18*t73*t74+4.0335859835819476d-1*t1
     7         00*t16*t18*t24*t27*t73+2.4201515901491683d-1*t100*t16*t18
     8         *t22*t25*t73+1.2100757950745841d-1*t100*t16*t18*t20*t23*t
     9         73+4.033585983581947d-2*t100*t16*t18*t21*t73+5.0d+0*t112*
     :         t26*t27*t54+4.0d+0*t112*t24*t25*t54+3.0d+0*t112*t22*t23*t
     ;         54+2.0d+0*t112*t20*t21*t54+1.0d+0*t112*t15*t54-t113*t29*t
     <         37-5.0d+0*t113*t29*t35*t36-4.0d+0*t113*t29*t33*t34-3.0d+0
     =         *t113*t29*t31*t32-2.0d+0*t113*t28*t29*t30)*wght+2.0d+0*rh
     >         ob*t49*t89*wght+2.0d+0*t14*t89*wght+1.0d+0*rhob*t72*t86*w
     ?         ght+2.0d+0*t49*t86*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*rhob*t14*(6.77908995289531d
     1         -4*t22*t27*t52*t53*t77*t99+2.711635981158124d-4*t20*t25*t
     2         52*t53*t77*t99+6.77908995289531d-5*t23*t52*t53*t77*t99+1.
     3         3445286611939825d-1*t16*t18*t33*t36*t84*t88+8.06717196716
     4         3894d-2*t16*t18*t31*t34*t84*t88+4.033585983581947d-2*t16*
     5         t18*t30*t32*t84*t88+1.3445286611939825d-2*t16*t18*t28*t84
     6         *t88-6.722643305969912d-3*t16*t18*t29*t37*t88-3.361321652
     7         984956d-2*t16*t18*t29*t35*t36*t88-2.689057322387965d-2*t1
     8         6*t18*t29*t33*t34*t88-2.0167929917909735d-2*t16*t18*t29*t
     9         31*t32*t88-1.3445286611939825d-2*t16*t18*t28*t29*t30*t88+
     :         6.722643305969912d-2*t16*t18*t26*t27*t75*t87+5.3781146447
     ;         7593d-2*t16*t18*t24*t25*t75*t87+4.033585983581947d-2*t16*
     <         t18*t22*t23*t75*t87+2.689057322387965d-2*t16*t18*t20*t21*
     =         t75*t87+1.3445286611939825d-2*t15*t16*t18*t75*t87-1.34452
     >         86611939825d-1*t16*t18*t24*t27*t74*t87-8.067171967163894d
     ?         -2*t16*t18*t22*t25*t74*t87-4.033585983581947d-2*t16*t18*t
     @         20*t23*t74*t87-1.3445286611939825d-2*t16*t18*t21*t74*t87+
     1         6.779089952895311d-4*t33*t36*t52*t55*t77*t84+4.0674539717
     2         371866d-4*t31*t34*t52*t55*t77*t84+2.0337269858685933d-4*t
     3         30*t32*t52*t55*t77*t84+6.77908995289531d-5*t28*t52*t55*t7
     4         7*t84+3.389544976447655d-4*t26*t27*t52*t53*t74*t77+2.7116
     5         35981158124d-4*t24*t25*t52*t53*t74*t77+2.033726985868593d
     6         -4*t22*t23*t52*t53*t74*t77+1.355817990579062d-4*t20*t21*t
     7         52*t53*t74*t77+6.77908995289531d-5*t15*t52*t53*t74*t77-1.
     8         1298483254825517d-5*t29*t37*t52*t55*t77-5.649241627412759
     9         d-5*t29*t35*t36*t52*t55*t77-6.77908995289531d-4*t111*t31*
     :         t36*t52*t55*t77-4.519393301930207d-5*t29*t33*t34*t52*t55*
     ;         t77-2.711635981158124d-4*t111*t30*t34*t52*t55*t77-3.38954
     <         4976447655d-5*t29*t31*t32*t52*t55*t77-6.77908995289531d-5
     =         *t111*t32*t52*t55*t77-2.2596966509651034d-5*t28*t29*t30*t
     >         52*t55*t77-1.355817990579062d-3*t100*t24*t27*t52*t53*t77-
     ?         8.134907943474373d-4*t100*t22*t25*t52*t53*t77-4.067453971
     @         7371866d-4*t100*t20*t23*t52*t53*t77-1.355817990579062d-4*
     1         t100*t21*t52*t53*t77)*wght+1.0d+0*rhob*t114*t49*wght+1.0d
     2         +0*t114*t14*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*rhob*t14*(1.34452866119398
     1         25d-2*t52*t75*t77*t90+t16*t18*(2.2786701846199775d-6*t33*
     2         t36*t52*t77*t84+1.3672021107719862d-6*t31*t34*t52*t77*t84
     3         +6.836010553859931d-7*t30*t32*t52*t77*t84+2.2786701846199
     4         772d-7*t28*t52*t77*t84-3.7977836410332955d-8*t29*t37*t52*
     5         t77-1.8988918205166477d-7*t29*t35*t36*t52*t77-2.278670184
     6         6199775d-6*t111*t31*t36*t52*t77-1.5191134564133182d-7*t29
     7         *t33*t34*t52*t77-9.114680738479908d-7*t111*t30*t34*t52*t7
     8         7-1.1393350923099885d-7*t29*t31*t32*t52*t77-2.27867018461
     9         9977d-7*t111*t32*t52*t77-7.595567282066591d-8*t28*t29*t30
     :         *t52*t77)+6.77908995289531d-5*t57*t74*t80/t17**6.0d+0+t16
     ;         *t18*t54*(1.5191134564133182d-6*t24*t27*t52*t75*t77+9.114
     <         680738479908d-7*t22*t25*t52*t75*t77+4.557340369239954d-7*
     =         t20*t23*t52*t75*t77+1.5191134564133182d-7*t21*t52*t75*t77
     >         -2.2786701846199775d-6*t22*t27*t52*t74*t77-9.114680738479
     ?         908d-7*t20*t25*t52*t74*t77-2.278670184619977d-7*t23*t52*t
     @         74*t77))*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
