/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_MODULE_P_H_
#define _OPENCTL_MODULE_P_H_

#include <map>
#include <list>
#include <GTLCore/Value.h>
#include <GTLCore/ScopedName.h>
#include <vector>

namespace llvm {
  class Constant;
  class Module;
}

namespace GTLCore {
  class Function;
  class Parameter;
  class TypesManager;
  class Type;
  /**
   * @internal
   * This class is not part of the public API of GTLCore.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT ModuleData {
    public:
      ModuleData( llvm::Module* llvmModule);
      ~ModuleData();
      bool appendFunction(const ScopedName& name, Function* function);
      const std::list<Function*>* function(const String& _currentNameSpace, const String& _name) const;
      const std::list<Function*>* function(const ScopedName& name) const;
      const GTLCore::Function* function(const GTLCore::String& _nameSpace, const GTLCore::String& name, std::vector<GTLCore::Parameter>& arguments) const;
      std::list<Function*> functions();
      /**
       * Append a constant with the given name, and of the given type.
       */
      bool appendConstant(const ScopedName& name, const GTLCore::Type* type, const GTLCore::Value& val);
      /**
       * @return all the constants of that module
       */
      const std::map<ScopedName, const GTLCore::Type*>& constants() const;
      const std::map<ScopedName, GTLCore::Value>& constantsValue() const;
      void linkWith( const ModuleData* _module );
      void doLink();
      const llvm::Module* llvmModule() const { return m_llvmModule; }
      llvm::Module* llvmLinkedModule() { return m_llvmLinkedModule; }
      const llvm::Module* llvmLinkedModule() const { return m_llvmLinkedModule; }
      TypesManager* typesManager() { return m_typesManager; }
      const TypesManager* typesManager() const { return m_typesManager; }
      void hideAllSymbolsBut(std::list<GTLCore::String> _keepVisible);
    private:
      void linkWith( const llvm::Module* _module );
    private:
      std::map<ScopedName, const GTLCore::Type*> m_constants;
      std::map<ScopedName, GTLCore::Value> m_constantsValue;
      llvm::Module* m_llvmModule;
      llvm::Module* m_llvmLinkedModule;
      std::map<ScopedName, std::list<Function*>* > m_functions;
      TypesManager* m_typesManager;
      std::list< const llvm::Module* > m_linkModuleWith;
      std::list< GTLCore::String > m_linkModuleWithArchives;
  };
}

#endif
