!***********************************************************************
! This file is part of OpenMolcas.                                     *
!                                                                      *
! OpenMolcas is free software; you can redistribute it and/or modify   *
! it under the terms of the GNU Lesser General Public License, v. 2.1. *
! OpenMolcas is distributed in the hope that it will be useful, but it *
! is provided "as is" and without any express or implied warranties.   *
! For more details see the full text of the license in the file        *
! LICENSE or in <http://www.gnu.org/licenses/>.                        *
!                                                                      *
! Copyright (C) 1996-2006, Thorstein Thorsteinsson                     *
!               1996-2006, David L. Cooper                             *
!***********************************************************************

subroutine kotani_cvb(bikcof,ndet,ifns)

use Definitions, only: wp, iwp

implicit none
integer(kind=iwp), intent(in) :: ndet, ifns
real(kind=wp), intent(inout) :: bikcof(ndet,ifns)
integer(kind=iwp) :: k
real(kind=wp) :: dum(1)

! Kotani spin functions (generated by Gram-Schmidt orthonormalization of the Rumer functions)
call schmidtn_cvb(bikcof,ifns,dum,ndet,0)
do k=1,ifns/2
  call dswap_(ndet,bikcof(:,k),1,bikcof(:,ifns+1-k),1)
end do

return

end subroutine kotani_cvb
