Minutes from 146th OpenVDB TSC meeting, September 13th, 2022, (EDT)

Attendees: *Ken* M., *Andre* P, , *Dan* B.,

Additional Attendees: Greg Hurst (United Therapeutics), Karl Marrett

Regrets: *Jeff* L., *Nick* A., *Rich* J.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) VDB 10 PRs
5) ASWF Larger CI Machines
6) RootNodeOffset
7) Wolfram Mathematica Update
8) Next meeting


--------------------

1) Confirm quorum

Quorum is *not* present, no decisions will be taken in this meeting.

2) Secretary

Secretary is Dan Bailey

3) Forum

Discussion 1468, Gaps / Holes Question. Ken has some experience to share. Also
question about NeuralVDB would be worth answering for posterity.

4) VDB 10 PRs

Ken keen to merge PR1463, some major improvements to NanoVDB.

5) ASWF Larger CI Machines

We have access to the beta for some wider CI boxes from GitHub Actions Premium
service via ASWF. Free until end of September then paid for service. Dan is
testing and discussing with ASWF CI group.

6) RootNodeOffset

Lots of options as to how to integrate this. Simplest is to re-root all grids on
read and write, so as to use -2048^3 as the in-memory origin and 0^3 as the on
disk origin. All new grids would be created with the -2048^3 origin directly
and then re-mapped when written to disk. Ken has tested the re-mapping and it
is very fast as it only involves updating pointers. Two main questions that
arise from this - (a) is there value in using a dynamic root node offset,(b) is
there value in adding a breaking file format change to avoid the remapping and
to support writing out a -2048^3 origin.

Main question to resolve for ABI10 is whether or not to include a new dynamic
offset member variable which would break ABI. On the one hand, there may be
benefits in being able to change the root node offset to optimize for the
specific VDB grid - for example if rendering a single VDB to adjust the offset
to ensure it all fits into a single root node child. However is it worth the
cost of maintaining this? Possibly not. Nonetheless, adding an unused member
variable has almost negligible impact on memory usage, so perhaps it is worth
adding in case we wish to do this in the future anyway as it will not be
possible for another year due to ABI.

The other main consideration is what to do about the file format. Storing the
offset as a native part of the file would change the file format. One option is
to add the offset as metadata and to adjust the reader to be able to understand
and apply the metadata when reading. Prior to VDB5, the metadata would be
dropped, essentially re-rooting the tree. Between VDB5 and VDB10, the metadata
would be retained though the offset would not be applied. From VDB10, the
metadata would be retained and the offset would be applied. Whenever talking
about potentially bumping the file format, it is worth considering lots of
benign error reports from the file format incompatibility warning. This can be
mitigated to an extent by only bumping the file format value on write when
writing a grid that has a non-zero offset, but this requires extra work.

No decisions made on this. Lots more detail to discuss. Most important thing to
resolve is the ABI, so perhaps decision on including a member variable is the
only decision that needs to be taken right now. Although it would be nice to
offer the ability to use a different root node offset in the next major
release, it is expected the re-mapping feature will not be ready in time.

7) Wolfram Mathematica Update

Greg still working on getting this in. No updates from Wolfram / ASWF about
licensing, will make testing through CI difficult. Greg plans to put together
installation instructions for Ken / Andre to test and get feedback on how easy
the process is to follow.

8) Next meeting

Next meeting is on September 20th, 2022. 1pm-2pm EDT (GMT-4).
