/*
 * Plasma applet to display indicators from libindicate
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#ifndef MESSAGEINDICATOR_H
#define MESSAGEINDICATOR_H

// Qt
#include <QTreeView>

// KDE
#include <Plasma/PopupApplet>

// QIndicate
#include <qindicatelistener.h>

// Local
#include <listenermodel.h>

class QLabel;

class MessageIndicator : public Plasma::PopupApplet
{
Q_OBJECT
public:
    MessageIndicator(QObject* parent, const QVariantList& args);
    ~MessageIndicator();

    virtual void init();

public Q_SLOTS:
    void toolTipAboutToShow();

protected:
    virtual void popupEvent(bool show);
    virtual bool sceneEventFilter(QGraphicsItem*, QEvent* event);
    virtual void constraintsEvent(Plasma::Constraints);
    virtual void paintInterface(QPainter*, const QStyleOptionGraphicsItem*, const QRect&);

private Q_SLOTS:
    void slotRowsChanged(const QModelIndex& parent);
    void slotDrawAttentionChanged();
    void slotClicked(const QModelIndex& index);
    void slotServerAdded(QIndicate::Listener::Server* server);
    void dumpModels();
    void initPalette();
    void adjustViewSize();
    void activateLatestIndicator();

private:
    QIndicate::Listener* mListener;
    ListenerModel* mSourceModel;
    QWidget* mStack;
    QTreeView* mView;
    Plasma::Svg* mSvg;
    QLabel* mNoIndicatorLabel;
    QWidget* mCurrentWidget;

    void initIcon();
    void initSourceModel();
    void initView();
    void updateStatus();
    void removeInterestOnServers();
};

#endif /* MESSAGEINDICATOR_H */
