# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --unidata_version=11.0.0 --output=unicodedb_11_0_0 --base=unicodedb_3_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_3_2_0 as base_mod
version = '11.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError(name)

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x07 ABOVE '
'\x05 ADEG'
'\x06 AGUNG'
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x03 AN'
'\x05 AND '
'\n AND ARROW'
'\x14 AND DIAGONAL STROKE'
'\n AND KNIFE'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\r AND SKI BOOT'
'\t AND TAIL'
'\x13 AND TWO DOTS ABOVE'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x06 ARROW'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\t ASTERISK'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x05 BACK'
'\r BAT AND BALL'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\x07 CER-WA'
'\n CHARACTER'
'\x07 CHIKI '
'\x05 CHWV'
'\x07 CIRCLE'
'\x05 COAT'
'\n CONJOINED'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING ESH2'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\t DRACHMAS'
'\x02 E'
'\x06 EPOCH'
'\x06 EQUID'
'\x05 FACE'
'\x06 FACE '
'\x08 FACING '
'\x06 FINAL'
'\x13 FLUTTERING IN WIND'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\x05 GORA'
'\x05 GUNU'
'\x08 HANDLES'
'\t HITTING '
'\x05 HOOK'
'\x03 HU'
'\x08 HUNDRED'
'\x05 ICON'
'\x05 ILUT'
'\x03 IN'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x05 JERA'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x08 KEMBANG'
'\x04 KEY'
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\x06 LARGE'
'\t LEERAEWA'
'\x06 LELET'
'\x06 LENGA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x06 LONGA'
'\x07 LONSUM'
'\x13 LOVE YOU HAND SIGN'
'\x02 M'
'\x07 MAELEE'
'\x07 MAEMBA'
'\n MAHAPRANA'
'\x08 MAKSURA'
'\x05 MARK'
'\x06 MELIK'
'\x07 MENDUT'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x06 MURDA'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x08 NUTILLU'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\t OF PAPER'
'\r OF THE HORNS'
'\x08 OF YARN'
'\x05 OPEN'
'\x07 OPEN-O'
'\r OPPOSING KUR'
'\x04 ORE'
'\x04 OUT'
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
'\x12 OVER HI TIMES ASH'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x0f OVER SIG4 SHU2'
'\x16 OVER STAMPED ENVELOPE'
'\x08 OVER SU'
'\x14 OVER TUR ZA OVER ZA'
'\x08 OVER ZI'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DA'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GAL'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\x10 PLUS KAK PLUS A'
'\x0c PLUS KASKAL'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x12 PLUS PAP PLUS LU3'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\t PLUS SAG'
'\x11 PLUS SHA3 PLUS A'
'\t PLUS SHU'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x07 PLUS U'
'\t PLUS ZA7'
'\x06 POINT'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x0c PUNCTUATION'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x0c RING LITTLE'
'\x08 ROTUNDA'
'\x06 RULER'
'\x02 S'
'\x03 SA'
'\x05 SARI'
'\x08 SATCHEL'
'\n SCHROEDER'
'\x07 SECANT'
'\n SEPARATOR'
'\x04 SET'
'\x06 SEVEN'
'\x05 SHOE'
'\x05 SIDE'
'\x05 SIGN'
'\x06 SIGN '
'\x08 SLIDING'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x08 SQUARED'
'\x08 STATERS'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x16 SYMBOL FOR LIGHTHOUSE'
'\x05 TABS'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x12 THROUGH DESCENDER'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES BAD'
'\x10 TIMES DISH TENU'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\t TIMES HA'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x0b TIMES TAK4'
'\x08 TIMES U'
'\t TIMES UD'
'\x07 TO BAR'
'\x05 TONE'
'\x06 TONE-'
'\x0f TOUCHING INDEX'
'\x08 TTUDDAG'
'\x02 U'
'\x04 U U'
'\r VARIANT FORM'
'\x04 WEB'
'\x05 WITH'
'\x06 WITH '
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\x15 WITH DIAGONAL STROKE'
'\t WITH DOT'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE MIDDLE TILDE'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\x0b WITH FLASH'
'\x17 WITH HALF-CIRCLE BELOW'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\r WITH JEGOGAN'
'\x12 WITH KAVYKA ABOVE'
'\x0e WITH LONG LEG'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\x0e WITH ORNAMENT'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\x0f WITH RIGHT LEG'
'\n WITH RING'
'\x11 WITH SOUND WAVES'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\x12 WITH VERTICAL BAR'
'\x13 WITH VERTICAL TAIL'
'\x0b WITHIN DOT'
'\x07 WOLOSO'
'\x0b WRIST FLEX'
'\x02 X'
'\x08 YUQ NAE'
'\x01-'
'\x02-0'
'\x02-2'
'\x02-A'
'\x05-ALAF'
'\t-AMMONIAC'
'\x0f-CARRIER LETTER'
'\x0b-COPPER ORE'
'\x07-CREE L'
'\t-CREE RWE'
'\x08-EM DASH'
'\x03-EU'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x06-HIDET'
'\x07-INDIC '
'\x07-KIYEOK'
'\t-LOW TONE'
'\n-LUE KARAN'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x07-MU-MO-'
'\x0f-NO-EVIL MONKEY'
'\x02-O'
'\x0b-OFF SYMBOL'
'\x06-PIEUP'
'\n-POINTING '
'\x12-POINTING PENTAGON'
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x0e-STEM TONE BAR'
'\x10-STRUCK SMALL PI'
'\x03-TE'
'\x07-THIRTY'
'\x08-X BELOW'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x080 BRONZE'
'\x050 DOO'
'\x050 DWO'
'\x030 E'
'\x0b0 FOOTSTOOL'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\x040 KO'
'\t0 LONG LE'
'\x040 MA'
'\x050 MAN'
'\x060 NGGI'
'\x060 NGGO'
'\x040 NI'
'\x060 NYON'
'\x060 NYUN'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x040 SA'
'\x070 SPEAR'
'\x030 U'
'\x030 W'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 YE'
'\x040 ZO'
'\x030-0'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0304A'
'\x0207'
'\x0208'
'\x0209'
'\x030B9'
'\x011'
'\x031 A'
'\x071 ARROW'
'\x041 BA'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DO'
'\x041 DU'
'\x051 DWE'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x061 GOLD'
'\x041 HA'
'\x081 HELMET'
'\x061 HORN'
'\x041 IN'
'\x041 KI'
'\x041 KU'
'\n1 LONG MBE'
'\x061 NDEE'
'\x031 O'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 PO'
'\x041 QI'
'\x041 RA'
'\x041 SA'
'\x041 SI'
'\x041 SU'
'\x051 TEE'
'\x051 TWO'
'\x041 VU'
'\x061 WINE'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-0'
'\x031-2'
'\x051-VAS'
'\x0211'
'\x03121'
'\x0314D'
'\x03155'
'\x0216'
'\x0217'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x021F'
'\x012'
'\x032 B'
'\x042 BU'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\x072 PLUS '
'\n2 PLUS ASH'
'\x052 POO'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x052 SEE'
'\x042 SO'
'\x042 TI'
'\x042 VI'
'\x042 WO'
'\x072 WOMAN'
'\x032 Y'
'\x042 YA'
'\x032-0'
'\x052-VAS'
'\x0220'
'\x0320B'
'\x0221'
'\x0222'
'\x0224'
'\t247 DIPTE'
'\x03253'
'\x0726 EYYY'
'\x0229'
'\x022D'
'\x032DD'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 PA'
'\t3 PLUS AN'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x043 TA'
'\x053 VEE'
'\x053 WEI'
'\x073 WHEEL'
'\x043 YU'
'\x033-0'
'\x053-VAS'
'\x0230'
'\x03305'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0233'
'\x0234'
'\x0236'
'\x0238'
'\x0239'
'\x014'
'\x034 A'
'\x054 ABB'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x044 KE'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x044 NE'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x044 TE'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WA'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x044 ZE'
'\x034-0'
'\x054-VAS'
'\x0240'
'\x0242'
'\x0248'
'\x0249'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AN'
'\x045 AU'
'\t5 BATHTUB'
'\x045 BB'
'\t5 CYPERUS'
'\x045 DE'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 JU'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x065 MERI'
'\x045 MO'
'\x055 NDU'
'\x075 NGGEE'
'\x045 NU'
'\x045 OO'
'\x045 TE'
'\x045 TO'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WE'
'\x045 WO'
'\x065 WOOL'
'\x035-0'
'\x055-VAS'
'\x0250'
'\x0253'
'\x0255'
'\x03550'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x046 JE'
'\x046 JO'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x046 NA'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 TA2'
'\x066 TREE'
'\x056 WEE'
'\x046 WU'
'\x036-0'
'\x056-VAS'
'\x0262'
'\x03620'
'\x0264'
'\x036D7'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 DI'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x047 JA'
'\x057 JEE'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 VO'
'\x047 ZA'
'\x057-VAS'
'\x0270'
'\x0271'
'\x0272'
'\x0372C'
'\x0279'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x038 A'
'\x048 BO'
'\x048 DU'
'\x038 E'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x038 I'
'\x048 JI'
'\x038 K'
'\x088 KANAKO'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x058 NWA'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 SI'
'\x049 SO'
'\x049 TA'
'\x049 TO'
'\x049 TU'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x0292'
'\x0295'
'\x03981'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A HAAM'
'\x06A MFON'
'\x08A OVER M'
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\tA PLUS NA'
'\x08A SIGN A'
'\nA TANG LAI'
'\x07A WITH '
'\rA WITH STROKE'
'\x05A YUE'
'\x02A-'
'\x04A-HA'
'\x06A-KARA'
'\x05A-ROL'
'\x03A-U'
'\x02A0'
'\x02A2'
'\x02A4'
'\x03A7A'
'\x02AA'
'\x03AAF'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x03AAN'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\nAB2 TIMES '
'\x03ABA'
'\nABATA TREE'
'\x11ABBREVIATION MARK'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x05ABOVE'
'\x06ABOVE '
'\x15ABOVE LEFTWARDS ARROW'
'\x0eABOVE REVERSE '
'\x03AC '
'\x13ACCENT ATNAH HAFUKH'
'\rACCOMMODATION'
'\x03ACE'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACH'
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x03ACT'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x03AD3'
'\x03ADA'
'\x04ADA '
'\nADAK BINDI'
'\x03ADE'
'\tADEG ADEG'
'\x10ADIAN SYLLABICS '
'\x03ADU'
'\x05ADULT'
'\x02AE'
'\x03AEA'
'\x03AEF'
'\x07AELAENG'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESCULAPIUS'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x0eAFETY SCISSORS'
'\tAFFE FACE'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x02AG'
'\x04AGAB'
'\x04AGE '
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x06AGRAPH'
'\x02AH'
'\x08AH WITH '
'\x16AH WITH TWO DOTS ABOVE'
'\x04AHAD'
'\x08AHAPRANA'
'\x02AI'
'\x0fAI LAING DIGIT '
'\x03AIL'
'\tAIL WITH '
'\x0bAILLESS PHI'
'\x06AILURE'
'\x03AIN'
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\x1fAISED HAND WITH FINGERS SPLAYED'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x06AITON '
'\x07AITON A'
'\x08AITON RA'
'\x02AJ'
'\x06AJANI '
'\tAJANYALAN'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x03AK4'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x04AKRA'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x0fAL INTERSECTION'
'\x03AL2'
'\x04ALAF'
'\x04ALAG'
'\x0fALAYHE ASSALLAM'
'\x04ALDA'
'\x03ALE'
'\x04ALEF'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x05ALETH'
'\x08ALEUT KA'
'\x03ALF'
'\x04ALF '
'\x05ALF H'
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x05ALING'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'\x05ALLOT'
'\x0fALMOST EQUAL TO'
'\x03ALO'
'\x07ALOCHKA'
'\tALPAPRANA'
'\x05ALPHA'
'\x08ALTERNAT'
'\nALTERNATE '
'\x13ALTERNATE LAKH MARK'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x08AM WITH '
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x05AMEDH'
'\x03AMI'
'\x04AMLA'
'\x04AMMA'
'\x06AMOND '
'\x04AMPI'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\rAN RUPEE SIGN'
'\x04AN X'
'\x03AN2'
'\x03ANA'
'\x10ANABAZAR SQUARE '
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x11AND BLACK SQUARES'
'\x0eAND COLD SWEAT'
'\x0fAND FEMALE SIGN'
'\x12AND LOW RIGHT RING'
'\x18AND MALE AND FEMALE SIGN'
'\x15AND VOWEL LENGTH MARK'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\x07ANDA TA'
'\x07ANDERER'
'\nANDHI MARK'
'\nANDRABINDU'
'\x08ANE TREE'
'\x03ANG'
'\x04ANG '
'\tANG CITI '
'\x05ANGE '
'\x05ANGEL'
'\tANGGEUAET'
'\x05ANGKA'
'\x06ANGKAT'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x08ANI SIGN'
'\x05ANNON'
'\x08ANS SIGN'
'\x0fANS-SERIF ARROW'
'\x07ANSIOS-'
'\x0cANTARGOMUKHA'
'\tANTAYALAN'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\x0eANUSVARA ABOVE'
'\x03AO '
'\x02AP'
'\x03APA'
'\x04APAQ'
'\x03APE'
'\x07APEZIUM'
'\x03APH'
'\x07APITAL '
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x0cAPYEOUNPIEUP'
'\x0cAPYEOUNRIEUL'
'\x06APYRUS'
'\x02AQ'
'\x02AR'
'\x03AR '
'\x04ARA3'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\tARCHAIC M'
'\rARCHAIC SAMPI'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDNESS'
'\x03ARE'
'\nARFUL FACE'
'\x05ARGE '
'\x03ARK'
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\x07ARRED B'
'\x07ARRED O'
'\rARRED TRIDENT'
'\x06ARRIER'
'\x08ARRIVING'
'\x05ARROW'
'\x06ARROW '
'\x07ARROW O'
'\x12ARROW SHAFT WIDTH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x0eARSI YEH WITH '
'\x03ART'
'\x05ARTAR'
'\x17ARTY HORN AND PARTY HAT'
'\x04ARUM'
'\x04ARY '
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\rAS ABOVE SIGN'
'\x07AS SIGN'
'\x05ASAL '
'\x04ASAT'
'\x17ASCENDING MUSICAL NOTES'
'\x03ASE'
'\x03ASH'
'\x04ASH2'
'\x06ASHGAB'
'\x07ASHTRA '
'\x05ASKAL'
'\x05ASPER'
'\nASPIRATION'
'\x03ASS'
'\x06ASSING'
'\x08AST WIND'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATAKANA '
'\x08ATEBOARD'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\nATHA WITH '
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x05ATIN '
'\x0fATINATE MYSLITE'
'\x05ATIYA'
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATTIC '
'\x0cATTOOED HEAD'
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x07AUGHTS '
'\x03AUJ'
'\x04AULA'
'\x07AULDRON'
'\x03AUM'
'\x07AUNTLET'
'\x03AUS'
'\nAUTOMOBILE'
'\x06AUTUMN'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x08AVY BAND'
'\x0eAVY CHECK MARK'
'\x02AW'
'\x05AWAY '
'\rAWELLEMET YAZ'
'\x02AY'
'\x07AY SIGN'
'\x08AY-NIGHT'
'\x07AYALAM '
'\x03AYD'
'\nAYER BEADS'
'\x06AYEROK'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x05BACUS'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x0cBAHIRGOMUKHA'
'\x03BAL'
'\x05BALAG'
'\x04BALD'
'\x04BALL'
'\rBALL AND HOOP'
'\rBALLPOINT PEN'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x03BAR'
'\tBAR ABOVE'
'\x1aBAR WITH HORIZONTAL STROKE'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\x08BARRED B'
')BARREE WITH EXTENDED ARABIC-INDIC DIGIT T'
'\rBASAN LETTER '
'\tBASE UNIT'
'\x04BASH'
'\x08BATAEAN '
'\x03BAU'
'\x04BAYI'
'\x02BB'
'\x03BBA'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x06BEGIN '
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x05BENDE'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x04BER '
'\x08BER POLE'
'\x11BERBER ACADEMY YA'
'\x07BERGINE'
'\x03BET'
'\x04BETA'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x08BEVERAGE'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\x05BHETH'
'\x02BI'
'\tBIAL SIGN'
'\x03BIB'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x03BIN'
'\x05BINDU'
'\x07BINING '
'\x0cBINING MARK '
'\x08BINOVILE'
'\x0bBIRGA WITH '
'\x05BISAH'
'\x06BISCUS'
'\tBITE LIPS'
'\x0fBJOINED LETTER '
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\nBLACK FLAG'
'\rBLACK SQUARES'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x08BLED CAR'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\rBOHAIRIC KHEI'
'\x08BOL SIGN'
'\x05BOLD '
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x11BOTTOM HALF BLACK'
'\x15BOTTOM U-SHAPED ARROW'
'\x07BOURING'
'\x04BOVE'
'\x03BOW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x08BRA FACE'
'\x06BRANCH'
'\x0cBRATION MODE'
'\x05BREVE'
'\x19BREVE WITH INVERTED BREVE'
'\x05BREW '
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x12BSERVER EYE SYMBOL'
'\x04BSET'
'\x03BSP'
'\x05BSTER'
'\nBSTRUCTION'
'\x02BU'
'\x03BU '
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x08BUNDANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\x0cBYSMAL WATER'
'\x01C'
'\x02C '
'\tC CEDILLA'
'\x06C CLEF'
'\x06C SIGN'
'\x08C SIYAQ '
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x03CAI'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x05CALYA'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x07CANDRA '
'\x08CANDRA A'
'\rCANDRA LONG E'
'\x0bCANDRABINDU'
'\x0cCANDRABINDU '
'\x11CANDRABINDU ABOVE'
'\x04CANO'
'\x05CANUS'
'\x04CAP '
'\x08CAPITAL '
'\x0fCAPITAL DIGAMMA'
'\tCAPITAL I'
'\x0fCAPITAL LETTER '
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARET'
'\x06CARIK '
'\x05CARON'
'\x08CARRIER '
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CAUDA'
'\x04CAYN'
'\x02CC'
'\x05CCEPT'
'\x05CCOLI'
'\x0bCCUMULATION'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x05CECAK'
'\x05CECEK'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCENTURIAL SIGN'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x08CER BALL'
'\x06CER-WA'
'\x05CEREK'
'\x0eCERTAINTY SIGN'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x11CHA WITH TWO DOTS'
'\x06CHAMKO'
'\x14CHARACTER INTRODUCER'
'\x0cCHARACTER-1B'
'\x05CHART'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x06CHEIKH'
'\x07CHEINAP'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHIEUCH'
'\x07CHILLU '
'\x05CHIME'
'\x0bCHING CHICK'
'\x06CHIRET'
'\x03CHO'
'\x05CHOOI'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\rCHRYSANTHEMUM'
'\x03CHU'
'\x06CHURCH'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x06CIEUC-'
'\x0bCIEUC-HIEUH'
'\x04CIM '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\rCIRCLE INSIDE'
'\x12CIRCLE NUKTA ABOVE'
'\x0fCIRCLE WITH DOT'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x11CIRCLES WITH DOTS'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x0fCIRCUMFLEX AND '
'\nCISIVENESS'
'\rCITATION MARK'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x1dCKED FACE WITH EXPLODING HEAD'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x05CKING'
'\x05CKTIE'
'\x02CL'
'\x07CLEAVER'
'\x08CLIMBING'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0cCLOSED ENTRY'
'\x0bCLOSED EYES'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x06CLOSET'
'#CLOSING BRDA RNYING YIG MGO SGAB MA'
'\x07CLOTHES'
'\x05CLUBS'
'\x17CLUSTER-INITIAL LETTER '
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLATE BAR'
'\nCOLD SWEAT'
'\x05COLON'
'\x03COM'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x1aCOMPATIBILITY IDEOGRAPH-FA'
'\nCOMPONENT '
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x14CONSONANT SIGN HAARU'
'\x16CONSONANT SIGN MEDIAL '
'\x11CONSONANT SIGN PA'
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x04COON'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x07COPTIC '
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x08COUNCIL '
'\x08COUNTERS'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x06CREASE'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\nCROPHONIC '
'\x05CROSS'
'\nCROSS MARK'
'\x15CROSSE STICK AND BALL'
'\x07CROSSED'
'\x0cCROSSED-TAIL'
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GABA'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x05CTRIC'
'\x05CTURE'
'\x04CTUS'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x04CURL'
'\x08CURLICUE'
'\x06CURLY '
'\rCURLY BRACKET'
'\nCURLY HAIR'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\x05CUTE-'
'\x03CWI'
'\nCY MESSAGE'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x04D HA'
'\x0bD MIDDLE UP'
'\x07D MOUTH'
'\tD SALTIRE'
'\x16D SEPARATOR MIDDLE DOT'
'\x06D SIGN'
'\x08D SYMBOL'
'\x0eD-UP NEWSPAPER'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\x07DA FACE'
'\nDA PLUS HA'
'\nDA SATANGA'
'\x03DA2'
'\x03DAA'
'\x03DAD'
'\x06DAGESH'
'\x03DAH'
'\x05DAIC '
'\tDAL WITH '
'\x05DALAT'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x03DAP'
'\x03DAR'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\tDATE MARK'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDDA'
'\x04DDHI'
'\x05DDING'
'\x08DDY BEAR'
'\x02DE'
'\x18DE INVERTED BRIDGE BELOW'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\nDECORATION'
'\nDED PERSON'
'\x03DEG'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x03DEN'
'\x05DENCE'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\tDEOGRAPH '
'\x16DEOGRAPHIC TALLY MARK '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\x03DES'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0fDESCENDING TONE'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x05DESTY'
'\x06DGEHOG'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x07DHALATH'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\x07DI SIGN'
'\tDIAERESIS'
'\rDIAERESIZED U'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x0fDIAGONAL STROKE'
'\x07DIAMOND'
'\x08DIAMONDS'
'\x05DIAN '
'\x03DIB'
'\x04DIC '
'\rDIC MARK SIGN'
'\x0cDICTION SIGN'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x03DIM'
'\x08DIM GUNU'
'\x04DIM2'
'\x03DIN'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x10DITORIAL CORONIS'
'\x04DIUM'
'\x08DIVISION'
'\x03DJA'
'\x04DLE '
'\x05DLING'
'\x03DNA'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x0fDOT PUNCTUATION'
'\x08DOT REPH'
'\nDOT WITHIN'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x07DOTTED '
'\x10DOTTED CRESCENTS'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x0bDOTTED STEM'
'\x1aDOTTED SUBSTITUTION MARKER'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\nDOUBLE BAR'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'\x19DOUBLE CANDRABINDU VIRAMA'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x10DOUBLE DOT ABOVE'
'\x10DOUBLE HEAD MARK'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\rDOUBLE MUCAAD'
'\x0fDOUBLE ORNAMENT'
'\x0bDOUBLE RING'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE VERTICAL STROKE'
'\x16DOUBLE-LINED HEAD MARK'
'\x04DOWN'
'\x05DOWN '
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x02DR'
'\x07DRACHMA'
'\x0cDRACHMA SIGN'
'\x04DRAM'
'\tDRAM SIGN'
'\x05DRINK'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x05DSMAN'
'\x02DU'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x03DUG'
'\x0cDUG TIMES NI'
'\tDUN3 GUNU'
'\x0eDUN3 GUNU GUNU'
'\nDUOUS TREE'
'\x08DUSHENNA'
'\x06DVANCE'
'\x08DVANTAGE'
'\x08DVISVARA'
'\x05DWICH'
'\tDY BEETLE'
'\x03DZA'
'\x03DZE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x07E ABOVE'
'\x1eE ARROW POINTING DIRECTLY LEFT'
'\tE AT LEFT'
'\x14E CONSONANT MODIFIER'
'\x05E GEE'
'\x07E GLASS'
'\x06E HOOK'
'\x11E LIGHT MOON ARTA'
'\x05E OF '
'\x08E OF POO'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\x10E PLUS GAN2 TENU'
'\nE PLUS SUM'
'\x10E WITH DESCENDER'
'\x0cE WITH GRAVE'
'\x12E WITH MIDDLE HOOK'
'\x15E WITH RETROFLEX HOOK'
'\x0bE WITH VEIL'
'\x02E-'
'\x02E0'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x04EACE'
'\x03EAD'
'\x07EAD ORE'
'\x05EAGLE'
'\x04EANS'
'\nEARLY FORM'
'\x0bEARS OF JOY'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x12EASTERN PWO KAREN '
'\tEASTERN W'
'\x06EASURE'
'\x04EAT '
'\x05EATH '
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\x05EBALL'
'\tEBATBEIT '
'\tEBIT SIGN'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'\x08ED BRICK'
'\x06ED CAP'
'\x07ED FACE'
'\x06ED ICE'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x0eED PARAGRAPHOS'
'\x07ED RICE'
'\tED SYMBOL'
'\x0eED SYMBOL FOR '
'\tEDESTRIAN'
'\nEDESTRIANS'
'\x06EDIAL '
'\x05EDIC '
'\x0bEDICAL MASK'
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x0cEEK MUSICAL '
'\x03EEL'
'\x0fEELCHAIR SYMBOL'
'\x03EEM'
'\x04EEM '
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x03EEP'
'\x0cEEPING SMALL'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\tEFAIDRIN '
'\x06EFCASE'
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x15EFT HORIZONTAL SECANT'
'\x15EFT-POINTING TRIANGLE'
'\x14EFTWARDS ARROW WITH '
'\x0fEFTWARDS ARROWS'
'\x05EGION'
'\x02EH'
'\x08EH WITH '
'\x12EH WITH INVERTED V'
'\x17EH WITH SMALL TEH ABOVE'
'\nEHEH WITH '
'\x02EI'
'\x03EI '
'\x05EIDON'
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x0bEIGHT COMMA'
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x16EIGHTY ON BLACK SQUARE'
'\x03EIN'
'\x04EIPT'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x07EL PUMP'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x08ELEPHANT'
'\x03ELF'
'\x03ELL'
'\x0bELLOW HEART'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELO'
'\x03ELT'
'\x04ELTA'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x03EMK'
'\x05EMLJA'
'\x05EMLYA'
'\rEMPHATIC TONE'
'\x02EN'
'\x03EN '
'\x07EN LEAF'
'\x10EN MILLIONS SIGN'
'\x08EN NTEUM'
'\x06EN OF '
'\x12EN ON BLACK SQUARE'
'\x0bEN STRAIGHT'
'\x0bEN THOUSAND'
'\x0bEN TWELFTHS'
'\x0cENARIUS SIGN'
'\x04ENAT'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x08ENICIAN '
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTION'
'\x05ENTRE'
'\x05ENTRY'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x08ENVELOPE'
'\x02EO'
'\x05EO-YA'
'\x05EOPLE'
'\x08EOUT BOX'
'\x03EOW'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x04EPHA'
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\tER BUBBLE'
'\x06ER MUG'
'\x15ER RIGHT CORNER ANGLE'
'\tER SYMBOL'
'\x08ER TRUTH'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04ERET'
'\x0eERIAL ARAMAIC '
'\x0eERIC INDICATOR'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x05ERN W'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x06ERTED '
'\x03ERU'
'\x11ERU WITH BACK YER'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x08ESCENDER'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\x04ESH2'
'\x05ESHE3'
'\x03ESS'
'\x03EST'
'\x08EST WIND'
'\x06ESTAN '
'\x02ET'
'\x03ET '
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x05ETION'
'\x04ETOS'
'\x08ETRASEME'
'\x0cETRETES SIGN'
'\x06ETTER '
'\x14ETTER SMALL CAPITAL '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x03EU-'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x07EULEUNG'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\nEUTRAL YER'
'\x03EUX'
'\nEVAL COMMA'
'\x04EVEN'
'\x05EVEN '
'\nEVEN COMMA'
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\rEVEN TWELFTHS'
'\x08EVENTEEN'
'\x06EVENTY'
'\x16EVENTY ON BLACK SQUARE'
'\x08EVERANCE'
'\x0cEVERING FACE'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0eEXCLAMATION OH'
'\x06EXHALE'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\x1bEXTRA-HIGH CONTOUR TONE BAR'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x03EYK'
'\nEZING FACE'
'\x01F'
'\x02F '
'\x05F COW'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x07F WITH '
'\rF WITH STROKE'
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x06FAMILY'
'\x04FAST'
'\x05FATHA'
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
'\x0bFEMALE SIGN'
'\x07FERMATA'
'\x04FETH'
'\x08FETY PIN'
'\x04FEUQ'
'\x06FF OF '
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIER '
'\x05FIFTY'
'\x06FIFTY '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\x14FINAL CONSONANT MARK'
'\x15FINAL CONSONANT SIGN '
'\rFINAL LETTER '
'\tFINAL NGA'
'\tFINAL NUN'
'\x08FINAL TH'
'\x07FINAL Y'
'\x08FINGER C'
'\x1bFINGER COVERING CLOSED LIPS'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x19FISHHOOK AND MIDDLE TILDE'
'\x04FIST'
'\x04FITA'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x0cFIVE HUNDRED'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAGS'
'\x05FLAME'
'\x15FLATTENED PARENTHESIS'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLICT'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\x07FLUENCE'
'\x05FLUTE'
'\nFLUTTERING'
'\x02FO'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x08FOR STOP'
'\x12FORKED PARAGRAPHOS'
'\nFORMATION '
'\x06FORMEE'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\nFOUR BELOW'
'\tFOUR BENT'
'\x0cFOUR CORNERS'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS ABOVE'
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x11FRACTION ONE HALF'
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x08FROM BAR'
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x0cFT RERENGGAN'
'\x13FT-POINTING FLEURON'
'\x05FTEEN'
'\x0fFTER COMPLETION'
'\x03FTY'
'\x02FU'
'\x03FUE'
'\tFULL STOP'
'\x02FW'
'\x03FWA'
'\x01G'
'\x06G FACE'
'\tG IN HOLE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x03GAA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x18GAF WITH INVERTED STROKE'
'\x03GAG'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x03GAL'
'\x05GALI '
'\x05GAMAN'
'\x04GAME'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x03GAR'
'\rGAR FRACTION '
'\x08GARITIC '
'\x05GAROO'
'\x07GATIVE '
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x05GAZE-'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x05GBASA'
'\x06GBASAQ'
'\x08GBASINNA'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x06GDIAN '
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GE SIGN'
'\x05GEAN '
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x07GEMINAT'
'\x0bGEMINATION '
'\x0fGEMINATION MARK'
'\x03GEN'
'\x07GENERAL'
'\x0bGENTLE WIND'
'\x0cGEORGIAN NAR'
'\x03GER'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x05GGER '
'\nGGING FACE'
'\x05GGLES'
'\x06GGLING'
'\x0fGGLY LINE BELOW'
'\x12GGLY VERTICAL LINE'
'\nGGRAVATION'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHAMAL'
'\x03GHE'
'\tGHE WITH '
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x04GHOM'
'\x03GHT'
'\x04GHT '
'\rGHT ARROWHEAD'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x05GHULU'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\x04GIDA'
'\x04GIEA'
'\rGIFT ENVELOPE'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x03GIR'
'\x04GIR2'
'\x04GISH'
'\x12GISH CROSSING GISH'
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x08GOLITIC '
'\x0bGONEK ABOVE'
'\x04GONG'
'\x03GOU'
'\x07GRADUAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x08GRAPH UK'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'\x0bGREEK CROSS'
'\x0cGREEN DRAGON'
'\x06GS-PA '
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x04GUL '
'\x05GULUS'
'\x04GUNU'
'\x0eGUNU TIMES ASH'
'\x03GUR'
'\x05GVANG'
'#GVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x02GW'
'\x02GY'
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x0fH WITH FISHHOOK'
'\x03H00'
'\x02HA'
'\x11HA WITH DESCENDER'
'\x03HAA'
'\x07HAARKAA'
'\x03HAB'
'\x05HADDA'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x04HALA'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x11HALF BLACK CIRCLE'
'\x14HALF CIRCLE WITH DOT'
'\x08HALF GUR'
'\tHALF NOTE'
'\x0fHALF RING ABOVE'
'\tHALF SIGN'
'\x05HALQA'
'\x03HAM'
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x04HAND'
'\x13HAND COVERING MOUTH'
'\x0cHAND FORMAT '
'\tHAND SIGN'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x05HANGE'
'\x0eHANGUL IEUNG U'
'\x05HANNA'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTERS'
'\x08HARBAHAY'
'\tHARD SIGN'
'\x06HARIOT'
'\x06HARP S'
'\x07HASANTA'
'\x05HASE-'
'\x03HAT'
'\x04HATE'
'\x05HATHI'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x04HAYN'
'\x02HD'
'\x02HE'
'\x03HE '
'\x03HEA'
'\x04HEAD'
'\x05HEAD '
'\tHEAD MARK'
'\x1bHEAD MARK WITH MOON AND SUN'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\tHEADSCARF'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x0bHEATED FACE'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x08HEAVY YA'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x12HEN WITH DIAERESIS'
'\x04HENG'
'\x03HER'
'\rHER CHRISTMAS'
'\x06HERMES'
'\nHERMOMETER'
'\x04HERO'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x05HEUAE'
'\x06HEUAEP'
'\x07HEXAGON'
'\x16HEXIFORM LONG ANUSVARA'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\rHI TIMES ASH2'
'\x0cHIBITED SIGN'
'\x05HIDET'
'\rHIEROGLYPHIC '
'\x06HIEUCH'
'\x05HIEUH'
'\nHIEUH-SIOS'
'\x06HIEUKH'
'\x07HIEUPH-'
'\x0cHIEUPH-HIEUH'
'\x04HIGH'
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x03HII'
'\x04HIIN'
'\x04HILD'
'\x12HILOSOPHERS SULFUR'
'\tHIMA SIMA'
'\x05HIMEL'
'\x03HIN'
'\rHINESE TONE Y'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x07HIRTEEN'
'\x05HIRTY'
'\x15HIRTY ON BLACK SQUARE'
'\x03HIT'
'\x0bHITE DRAGON'
'\x08HITTING '
'\x07HIUCHUS'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x06HLAVI '
'\x0bHLETIC SHOE'
'\x02HM'
'\x10HMATULLAH ALAYHE'
'\x04HMI '
'\x02HO'
'\x06HO HOI'
'\x03HOA'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x13HOLAM HASER FOR VAV'
'\x10HOLDING TOGETHER'
'\x03HOM'
'\x04HOM '
'\x03HOO'
'\x04HOOK'
'\x05HOOK '
'\rHOOK AND TAIL'
'\tHOOK TAIL'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x13HORIZONTAL ELLIPSIS'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x12HORIZONTALLY BELOW'
'\x10HORN WITH STROKE'
'\x05HORSE'
'\x06HORT A'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\tHOT SASAK'
'\x05HOTEL'
'\x03HOU'
'\rHOUGHT BUBBLE'
'\x08HOULDER '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\nHREE COMMA'
'\x06HREE D'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x0fHREE DOTS BELOW'
' HREE DOTS POINTING UPWARDS BELOW'
'\x0cHREE FINGERS'
'\tHREE FOR '
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x14HREE-DOT NUKTA ABOVE'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x04HSHU'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x02HU'
'\x04HUB2'
'\x04HUEN'
'\x04HUET'
'\x03HUK'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x15HUNDRED MILLIONS SIGN'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x03HUR'
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\x02HW'
'\x03HWA'
'\tHWA WITH '
'\x04HWAH'
'\x03HWE'
'\x02HY'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x01I'
'\x02I '
'\x06I GUNU'
'\x06I HOOK'
'\x05I KOI'
'\x07I NTEUM'
'\tI PLUS LI'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x0bI TIMES BAD'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x02I-'
'\x03I-I'
'\x05I-RES'
'\x02I0'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\x0eIAGONAL STROKE'
'\tIAL LINE '
'\tIALECT-P '
'\x06IAMOND'
'\x07IAMOND '
'\x04IAN '
'\x0bIAN LETTER '
'\x05IANCE'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IARA'
'\x05IARDS'
'\x05IAUDA'
'\x06IB YAM'
'\x02IC'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x05ICKET'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICOPTER'
'\x11ICTED LEFT ENTRY-'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x06IDE ES'
'\tIDEOGRAM '
'\x0cIDEOGRAPHIC '
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x11IDEWAYS U BRACKET'
'\x03IDO'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IEUC'
'\x06IEUNG-'
'\x05IEUP-'
'\x04IFAT'
'\rIFI ROHINGYA '
'\x06IFIED '
'\x07IFIED E'
'\x06IFTEEN'
'\x04IFTH'
'\x04IFTY'
'\x14IFTY ON BLACK SQUARE'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\nIGATING RA'
'\x13IGATURE AYIN-DALETH'
'%IGATURE BISMILLAH AR-RAHMAN AR-RAHEEM'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x03IGH'
'\x04IGHT'
'\x05IGHT '
'\nIGHT ANGLE'
'\x0fIGHT ARROWHEAD '
'\x08IGHT OF '
'\rIGHT TWELFTHS'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x07IGHTEEN'
'\tIGHTH ASH'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\tIGIT ZERO'
'\x04IGN '
'\x0cIGN ATTHACAN'
'\x0cIGN AVAGRAHA'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\tIGN TOMPI'
'\x12IGSAW PUZZLE PIECE'
'\x02IH'
'\x02II'
'\x03II '
'\x03IKA'
'\x05IKARA'
'\x03IKU'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x06ILBOAT'
'\x04ILDE'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x0bILIQUA SIGN'
'\x05ILVER'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\nIMALUNGUN '
'\x03IME'
'\x04IMEL'
'\x10IMENSIONAL ANGLE'
'\x05IMES '
'\x05IMGBA'
'\x13IMIDIA SEXTULA SIGN'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\tIN SQUARE'
'\tIN WITH T'
'\x03IN2'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x10INDEPENDENT SHIN'
'\x13INDEPENDENT SVARITA'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x0bINDERGARTEN'
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x06INDIC '
'\x16INDIRECT QUESTION MARK'
'\nINDU BELOW'
'\x03INE'
'\x07INE OF '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
',ING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE'
'\x08ING FACE'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\tING LANES'
'\nING LITTLE'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\tING STONE'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x06INGAAT'
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x06INHALE'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x08INITIAL '
'#INITIAL BRDA RNYING YIG MGO MDUN MA'
'\x11INITIAL LETTER RA'
'\x06INKING'
'\x05INNA '
'\x07INNABAR'
'\tINNYIIYHE'
'\nINOCULAR O'
'\x0eINOLOGICAL DOT'
'\x03INS'
'\x0eINSERTION SIGN'
'\x06INSHIP'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\tINSULAR D'
'\tINSULAR G'
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\nINVERTED V'
'\x04INY '
'\x04INYA'
'\x03ION'
'\x08ION MARK'
'\x03IOS'
'\x04IOS-'
'\x03IOT'
'\x02IP'
'\x03IP '
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x04IQAA'
'\x02IR'
'\x05IRACY'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x06IRCLES'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x0eIRCULAR VIRAMA'
'\x05IRCUT'
'\x04IRED'
'\x04IRON'
'\x08IRPLANE '
'\x0cIRST SUBUNIT'
'\x06IRTEEN'
'\x04IRTY'
'\x03IRY'
'\x02IS'
'\x08IS WHEEL'
'\x03ISA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\rISH LIRA SIGN'
'\x04ISI '
'\x0bISIBLE PLUS'
'\x0bISIGOTHIC Z'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x0eISSION TICKETS'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITA PLUS GISH '
'\x0eITALIC LETTER '
'\x15ITALIC SMALL DOTLESS '
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x13ITED LIABILITY SIGN'
'\x0eITERATION MARK'
'\x05ITHI '
'\x05ITING'
'\rITING THROUGH'
'\x05ITLO '
'\x03ITO'
'\tITRA SIGN'
'\x04ITSA'
'\x07ITTING '
'\x05ITUAL'
'\x02IU'
'\x03IVE'
'\x04IVE '
'\tIVE COMMA'
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\rIVE SLOW SIGN'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x08IX COMMA'
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x06IXTEEN'
'\nIXTHS DISH'
'\x04IXTY'
'\x14IXTY ON BLACK SQUARE'
'\x06IXTY P'
'\x04IYA '
'\x04IYAQ'
'\x05IYEOK'
'\x06IYEOK-'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x05JANG '
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x0bJECT SYMBOL'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x07JEGOGAN'
'\x04JEON'
'\x04JERV'
'\x05JERVI'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x03JJA'
'\x03JK '
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x03JOA'
'\x06JOINED'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\nJONG TILE '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUDUL'
'\x05JUEUI'
'\x03JUU'
'\x03JWA'
'\x01K'
'\x02K '
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x07K WITH '
'\x02K-'
'\x05K-020'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\nKA SATANGA'
'\x15KA- SHOG GI MGO RGYAN'
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x03KAD'
'\x04KAD3'
'\x03KAF'
'\x03KAH'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x04KALI'
'\x03KAM'
'\x04KANG'
'\x04KAPA'
'\x04KAPH'
'\rKAPYEOUNPIEUP'
'\x03KAQ'
'\x04KARA'
'\x05KARO '
'\x07KARO BA'
'\x05KAROR'
'\x06KASAR '
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x03KAU'
'\x06KAVYKA'
'\rKAVYKA ABOVE '
'\x06KAYAH '
'\x05KBALL'
'\x04KCET'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\tKEN HEART'
'\x05KERET'
'\x05KESH2'
'\x03KET'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x02KH'
'\x07KHA YAT'
'\x04KHAH'
'\x07KHAMTI '
'\x14KHAMTI REDUPLICATION'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x05KHMU '
'\x02KI'
'\x04KICK'
'\x07KIEVAN '
'\x06KILLER'
'\x03KIN'
'\nKINDI MVOP'
'\x04KING'
'\tKING BOOT'
'\tKING FACE'
'\x04KINI'
'\rKISIM5 TIMES '
'\x0fKISIM5 TIMES BI'
'\x04KISS'
'\x06KIYEOK'
'\x0cKIYEOK-HIEUH'
'\rKIYEOK-TIKEUT'
'\x03KKA'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOET'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x03KON'
'\x07KOQNDON'
'\x11KOREAN CHARACTER '
'\x12KOREAN CHARACTER O'
'\x03KOT'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x02KS'
'\x0bKTAIL GLASS'
'\x0bKTIESELSKAB'
'\x05KTOP '
'\x02KU'
'\x03KU3'
'\x03KUE'
'\x03KUG'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x06KUSHU2'
'\x03KUU'
'\x05KWAEN'
'\x06KY WAY'
'\x11KYATHOS BASE SIGN'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL OF THREAD'
'\x0bL TIMES LAL'
'\x07L WITH '
'\rL WITH STROKE'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'\x03LA3'
'\x04LAAM'
'\x04LAAN'
'\x05LABAT'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x0bLACK CIRCLE'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\nLACKFOOT W'
'\x0bLACKLETTER '
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x03LAI'
'\x07LAK-050'
'\x04LAKH'
'\tLAKH MARK'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\x04LAMA'
'\x04LAMD'
'\x05LAMDA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\nLANE MERGE'
'\x1aLANTED SOUTH ARROW WITH HO'
'\x03LAP'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\tLARGEMENT'
'\x03LAS'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x08LATION X'
'\x15LATTENED OPEN A ABOVE'
'\x03LAU'
'\x03LAW'
'\x03LAY'
'\x05LAYAR'
'\x0cLAYING CARDS'
'\x04LBOX'
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDE '
'\x04LDER'
'\x02LE'
'\x03LE '
'\x07LE LEAF'
'\nLE LETTER '
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x0cLEADING EYES'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x05LEASE'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'&LEF WITH EXTENDED ARABIC-INDIC DIGIT T'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x11LEFT HALF BRACKET'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
'\nLEFT-HAND '
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x17LEFT-SHADED WHITE ARROW'
'\x12LEFT-STEM TONE BAR'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x18LEFTWARDS SQUIGGLE ARROW'
'\x03LEI'
'\nLEK ATTAK '
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x05LENIS'
'\x04LEPH'
'\x03LES'
'\x08LESS SHA'
'\x08LESSER Y'
'\x04LETH'
'\x0bLETION MARK'
'\x06LETTER'
'\x07LETTER '
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\nLETTER SHA'
'\x15LETTER SMALL CAPITAL '
'\x07LETTERS'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x02LF'
'\x03LF '
'\rLF BLACK STAR'
'\x07LF FACE'
'\x03LFA'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x03LHA'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x04LIFI'
'\x1fLIGATURE ALEF WITH LAM WITH YEH'
'\x05LIGHT'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\nLIMITATION'
'\x04LINE'
'\x05LINE '
'\x0eLINE EXTENSION'
'\x0bLINE FILLER'
'\x10LINED WHITE STAR'
'\x04LING'
'\x05LING '
'\x0cLINGING FIRE'
'\x03LIP'
'\x04LIPS'
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x08LL MOON '
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x07LLEYBUS'
'\x06LLHORN'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x04LLLA'
'\x10LLOW PAN OF FOOD'
'\x07LLOWING'
'\tLLY MARK '
'\x14LMOST EQUAL TO BELOW'
'\x02LO'
'\x03LOA'
'\x05LOAN '
'\x05LOBE '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x04LOLL'
'\x03LON'
'\tLOND HAIR'
'\x04LONG'
'\x05LONG '
'\rLONG ANUSVARA'
'\nLONG FINAL'
'\x0fLONG HOOK BELOW'
'\nLONG OVER '
'\tLONG TIP '
'\nLONG TSHEG'
'\x03LOO'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x10LOSED LITTLE YUS'
'\x0bLOTI NAGRI '
'\tLOTTAL OA'
'\x0bLOTTAL STOP'
'\x0eLOTUS POSITION'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\nLOW KAVYKA'
'\x16LOW PARAPHRASE BRACKET'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x08LOW TONE'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x1eLOWER LEFT DIAGONAL HALF BLACK'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x03LPA'
'\x04LPHA'
'\x18LPHA WITH RETROFLEX HOOK'
'\x05LPHIN'
'\x02LT'
'\tLT SHAKER'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x0bLTERNATE YA'
'\nLTIC CROSS'
'\x06LTILLO'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x0cLU PLUS ESH2'
'\x0bLU PLUS IGI'
'\x03LU3'
'\x03LUB'
'\x03LUG'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x05LURAL'
'\x03LUS'
'\x05LWAY '
'\x02LX'
'\x02LY'
'\x04LY H'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x06M BULL'
'\x06M FEED'
'\tM HE-GOAT'
'\x0cM NSHUT NYAM'
'\x05M RAM'
'\nM STALLION'
'\x07M STONE'
'\x08M SYMBOL'
'\x02M0'
'\x02MA'
'\x03MAA'
'\x05MAAEH'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x06MADDAH'
'\x05MADYA'
'\tMAEMGBIEE'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x13MAL EXPONENT SYMBOL'
'\nMALAYALAM '
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x06MALL F'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x03MAN'
'\x04MAN '
'\x10MAN WITHOUT SNOW'
'\x13MANCHU ALI GALI LHA'
'\x08MANDARIN'
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x06MANYA '
'\x03MAQ'
'\x03MAR'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\nMARK ABOVE'
'\tMARK CIM '
'\x0eMARK LOWER DOT'
'\tMARK SHAD'
'\rMARKS CHAPTER'
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x03MAY'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x0bMBLER GLASS'
'\x05MBOL '
'\x07MBOL B0'
'\tMBOL FOR '
'\x04MBOO'
'\x08MBRELLA '
'\x04MBS '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\nME PLUS EN'
'\x08MEASURE '
'\x04MED '
'\x0cMEDARY CAMEL'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\rMELODIC QITSA'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x07MENIAN '
'\x05MENOE'
'\x05MEPET'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\rMESSENIAN TEN'
'\x14MET WITH WHITE CROSS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x0bMIC LETTER '
'\x03MID'
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE HOOK'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x05MIEUM'
'\x06MIEUM-'
'\x0bMIEUM-HIEUH'
'\x04MIIM'
'\x04MIIN'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\nMILLE SIGN'
'\x08MILLIONS'
'\x04MILY'
'\x03MIM'
'\x03MIN'
'\rMINDER RIBBON'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\nMINO TILE '
'\x1eMINTON RACQUET AND SHUTTLECOCK'
'\nMINUS SIGN'
'\x08MIONIAN '
'\tMISEXTILE'
'\nMISMA SIGN'
'\x05MISRA'
'\x03MIT'
'\x04MIZE'
'\x03MKA'
'\x03MMA'
'\x0cMMA WITH DOT'
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'\rMOBILE PHONES'
'\x1aMODIFIER FITZPATRICK TYPE-'
'\x10MODIFIER LETTER '
'"MODIFIER LETTER LABIALIZATION MARK'
'\rMODIFIER MARK'
'\x03MON'
'\x04MON '
'\x04MONO'
'\x0bMONOCULAR O'
'\nMONOGRAM B'
'\x0cMONOGRAPH UK'
'\nMONTH SIGN'
'\x05MOON '
'\x15MORPHOLOGICAL DIVIDER'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x04MPET'
'\x05MPIRE'
'\x03MPL'
'\x06MPLING'
'\x05MROCK'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x18MTAVRULI CAPITAL LETTER '
'\x02MU'
'\x04MUAS'
'\x06MUCAAD'
'\x04MUCH'
'\x03MUG'
'\tMUKPHRENG'
'\rMULTIOCULAR O'
'\x08MULTIPLE'
'\x15MULTIPLE MEASURE REST'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x0fMUSICAL SYMBOL '
'\x02MV'
'\x04MVAT'
'\x03MWA'
'\x02MX'
'\x02MY'
'\x08MY HOUSE'
'\x04MYA '
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x0bN THE VERGE'
'\x07N WITH '
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x07N2 TENU'
'\x02NA'
'\x0fNA DOUBLE HELIX'
'\tNA KHONNA'
'\x08NA METEK'
'\x05NA PO'
'\x03NAA'
'\x04NAAU'
'\x06NACLES'
'\x05NADA '
'\x03NAH'
'\x04NAKE'
'\nNAKE BELOW'
'\x04NAM2'
'\x04NANT'
'\x03NAP'
'\x03NAR'
'\x0cNARROW SHAFT'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\x03NAU'
'\x13NAXIAN FIVE HUNDRED'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\tNCH FRIES'
'\x05NCORA'
'\x13NCTUS ELEVATUS MARK'
'\x02ND'
'\x03ND '
'\x0bND OF PIECE'
'\x15ND TELEPHONE RECEIVER'
'\x0bND TWO DOTS'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x04NDAP'
'\x13NDER CLOUD AND RAIN'
'\tNDRABINDU'
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x03NE '
'\x11NE EYEBROW RAISED'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x06NE OF '
'\x04NED '
'\x08NED FOOD'
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x07NEQUDAA'
'\x03NER'
'\tNERAL URN'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x03NET'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x0bNEUTRAL YER'
'\x03NEY'
'\x07NFINITY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x03NG '
'\x08NG ABOVE'
'\x0bNG LEFT LEG'
'\x11NG STROKE OVERLAY'
'\x14NG WITH CROSSED-TAIL'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x0bNGER BUBBLE'
'\tNGER SHIP'
'\x05NGINE'
'\x04NGSI'
'\x08NGTHENER'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\x08NI ABOVE'
'\x03NIE'
'\x05NIEUN'
'\x06NIEUN-'
'\x03NIG'
'\tNIGHT OF '
'\tNIHSHVASA'
'\x03NII'
'\x0bNIKOLSBURG '
'\x04NINE'
'\nNINE COMMA'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x08NINETEEN'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\tNING SIGN'
'\x05NINTH'
'\x14NIS RACQUET AND BALL'
'\x0bNITIAL IZHE'
'\x07NJAEMLI'
'\x0cNJALA GONDI '
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x03NNI'
'\x06NNING '
'\x04NNNA'
'\x02NO'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\nNOON ABOVE'
'\x0bNOON GHUNNA'
'\nNOON WITH '
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x0cNORTHERN TSE'
'\x04NOSE'
'\x05NOTCH'
'\x0cNOTCHED HOOK'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x06NOVILE'
'\x04NOWC'
'\x08NOWLEDGE'
'\x06NOWMAN'
'\x08NRES TOS'
'\x04NRUA'
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\rNSONANT SIGN '
'\x07NSPLUTO'
'\x05NSUAE'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR G'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x10NTAIGANA LETTER '
'\x05NTAIN'
'\x18NTED NORTH ARROW WITH HO'
'\tNTESSENCE'
'\x05NTHA '
'\x03NTI'
'\x0bNTIMONY ORE'
'\nNTING ROD '
'\nNTITY MARK'
'\nNTO SHRINE'
'\x05NTXIV'
'\x02NU'
'\x03NUB'
'\x07NUBIAN '
'\x05NUENG'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\x08NUMERAL '
'\rNUMERIC SIGN '
'\x03NUN'
'\x04NUNG'
'\x07NUSVARA'
'\x08NUSVARA '
'\x07NUTILLU'
'\x04NUTS'
'\x04NUUN'
'\tNVERTED M'
'\x02NY'
'$NY TWO DOTS OVER ONE DOT PUNCTUATION'
'\x03NYA'
'\x12NYET THYOOM TA-ROL'
'\x03NYI'
'\nNYIS TSHEG'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x10O WITH DOT ABOVE'
'\x02O-'
'\x03O-I'
'\x02O0'
'\x02OA'
'\x04OALA'
'\x03OAP'
'\x03OAY'
'\x06OBELOS'
'\x05OBILE'
'\x0eOBLIQUE HYPHEN'
'\x0eOBLIQUE STROKE'
'\nOBOLS SIGN'
'\x04OBRO'
'\x05OCADO'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\tOCCLUSION'
'\x06OCENCE'
'\x03OCK'
'\x08OCK SALT'
'\x05OCKET'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x03ODA'
'\x12ODD POWERS OF FOUR'
'\x08ODESTONE'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\nOF HYGIEIA'
'\x0bOF MASHFAAT'
'\x07OF SOAP'
'\x03OFF'
'\x07OFFICER'
'\x04OFT '
'\x08OFT SIGN'
'\x04OFUM'
'\x08OGOGRAM '
'\x0fOGOGRAM KHAMTI '
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x0cOING TO MEET'
'\x05OINT '
'\x06OITIC '
'\x04OJI '
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\x05OKARA'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\x0cOKING SYMBOL'
'\x05OKOJI'
'\x07OKRYTIE'
'\x02OL'
'\x07OLAPUK '
'\x03OLD'
'\x04OLD '
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x10OLD WHITE CIRCLE'
'\x05OLDER'
'\x0bOLDING BACK'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x05OLLON'
'\x08OLLOWING'
'\x04OLON'
'\x05OLONG'
'\rOLVING HEARTS'
'\x02OM'
'\x03OM '
'\x08OM NTEUM'
'\tOM SYMBOL'
'\x04OMAN'
'\x08OMANIAN '
'\x05OMBIE'
'\tOMBINING '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x0eOMING ENVELOPE'
'\x04OMMA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x0fON BLACK SQUARE'
'\x08ON CROSS'
'\x07ON FACE'
'\tON GROUND'
'\nON MEDIAL '
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x04ONA '
'\rONAL COMPUTER'
'\x04ONAP'
'\x03ONE'
'\x04ONE '
'\tONE COMMA'
'\x08ONE DOT '
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x14ONE HUNDRED THOUSAND'
'\x1bONE LARGE AND ONE SMALL EYE'
'\x14ONE MARK SGAW KAREN '
'\tONE MARK-'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x03ONG'
'\x04ONG '
'\x1aONG DOUBLE SOLIDUS OVERLAY'
'\tONG GRAVE'
'\x05ONG S'
'\x0bONG S WITH '
'\rONG-LEGGED DE'
'\x07ONGONAN'
'\tONGSEONG '
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x10ONJOINING MACRON'
'\x06ONOCLE'
'\x1aONOMICAL SYMBOL FOR URANUS'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x04ONUT'
'\x02OO'
'\tOO DENNEN'
'\nOODS-CREE '
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x03OOM'
'\nOON LILITH'
'\nOON SELENA'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x1aOPEN E WITH RETROFLEX HOOK'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\x06OPEN P'
'\nOPEN SHELF'
'\tOPERATOR '
'\x1eOPERATOR ABOVE LEFTWARDS ARROW'
'\x03OPH'
'\x05OPLET'
'\x04OPOD'
'\x06OPPER '
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x04ORD '
'\rORD SEPARATOR'
'\x0eORD SEPARATOR '
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x03ORI'
'\x0fORINHIEUH-HIEUH'
'\x11ORIZONTAL ELLIPSE'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x03ORN'
'\x0fORN WITH STROKE'
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nOROME SIGN'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x14ORTY ON BLACK SQUARE'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x06OSING '
'\x07OSITION'
'\nOSSED SHEI'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x0eOT PUNCTUATION'
'\x03OTA'
'\x07OTATED '
'\x13OTATED ARDHAVISARGA'
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\x08OTIFIED '
'\nOTING STAR'
'\x07OTLESS '
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x0cOTTOM HALF O'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x04OUBT'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x04OUR '
'\tOUR COMMA'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\tOURA SIGN'
'\x07OURTEEN'
'\rOURTH SUBUNIT'
'\x0bOUSEL HORSE'
'\x0eOUSING THUNDER'
'\x03OUT'
'\nOUT HANDLE'
'\x07OUT HUB'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\tOUTH WIND'
'\nOUTHERN TA'
'\x04OVAL'
'\x15OVAL WITH OVAL INSIDE'
'\x05OVER '
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\tOVER LONG'
'\tOVER MUSH'
'\x16OVER NU11 BUR OVER BUR'
'\x08OVER NUN'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SAG'
'\x08OVER SHE'
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x07OVER U '
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x05OW PA'
'\x15OW PARAPHRASE BRACKET'
'\x12OW TONE APOSTROPHE'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x03OWN'
'\rOWN POINTING '
'\x15OWN-POINTING TRIANGLE'
'\x03OX '
'\x07OX BACK'
'\x02OY'
'\x07OYSTICK'
'\x03OZE'
'\x06OZENGE'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x0cP TACK ABOVE'
'\x07P WITH '
'\x17P WITH EXCLAMATION MARK'
'\x02P0'
'\x02PA'
'\rPA NJI PIPAEM'
'\x17PA OVER PA GAR OVER GAR'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x04PALM'
'\x12PAMPHYLIAN DIGAMMA'
'\x03PAN'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x0ePARATED SYMBOL'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x07PARTURE'
'\nPASSIMBANG'
'\x07PAYEROK'
'\x06PBOARD'
'\x05PCHA '
'\x02PE'
'\x0cPE CARTRIDGE'
'\x11PE WITH DESCENDER'
'\x06PEAKS '
'\x0cPEECH BUBBLE'
'\x04PEEI'
'\x04PEEP'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x03PEN'
'\x04PEN '
'\x05PEN E'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\nPENDICULAR'
'\x07PENGKAL'
'\x0fPENSION RAILWAY'
'\x08PENTAGON'
'\tPENTAGRAM'
'\tPENTASEME'
'\x05PEPET'
'\x06PEPPER'
'\x03PER'
'\x04PER '
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x12PERFIXED LETTER RA'
'\x06PERSET'
'\x08PERSIAN '
'\x06PERSON'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x03PHA'
'\x04PHAB'
'\x05PHANT'
'\x03PHI'
'\x07PHIEUPH'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\x06PICKET'
'\x07PICTURE'
'\tPIDERY HA'
'\x05PIEUP'
'\x06PIEUP-'
'\nPIEUP-SIOS'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x05PING '
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x0bPLACEHOLDER'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\nPLE DAGGER'
'\tPLE HEART'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x07PLOYAN '
'\x04PLUG'
'\x04PLUM'
'\x05PLUS '
'\nPLUS ERIN2'
'\x14PLUS GISH TIMES TAK4'
'\x08PLUS LAL'
'\nPLUS NAGA '
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x11POETIC VERSE SIGN'
'\x0cPOETRY MARK-'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x17POINTING BACKHAND INDEX'
'\x13POINTING DOWNWARDS '
'\x18POINTING DOWNWARDS ABOVE'
'\x19POINTING MAGNIFYING GLASS'
'\x16POINTING UPWARDS BELOW'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x05PONSE'
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x05PPAGE'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\tPPOINTED '
'\nPPOPOTAMUS'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'\x03PPV'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\tPREFIXED '
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x11PRESSIONLESS FACE'
'\x05PRING'
'\x06PRINTS'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x06PSILON'
'\x12PSILON WITH STROKE'
'\x07PSTICKS'
'\x05PTIVE'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x08PUN IYEK'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'\x11PUNCTUATION SIGN '
'\x03PUQ'
'\x08PUSHPIKA'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x03PWA'
'\x06PWATCH'
'\x01Q'
'\x07Q WITH '
'\x10Q WITH HOOK TAIL'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x0cQAMATS QATAN'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\tQUADCOLON'
'\x0fQUADRUPLE ARROW'
'\x13QUADRUPLE CRESCENTS'
'\x0bQUALS SIGN '
'\x05QUARE'
'\x06QUARE '
'\x06QUARED'
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x0cQUARTER SIGN'
'\x08QUARTERS'
'\rQUARTERS SIGN'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\x08QUESTION'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUF'
'\x03QUI'
'\x0eQUINARIUS SIGN'
'\x08QUINCUNX'
'\x08QUINTILE'
'\x0cQUIRREL TAIL'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\tR COASTER'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x03R S'
'\x0bR WITH TAIL'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x02R0'
'\x02R2'
'\x07R2 GUNU'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x03RA '
'\x07RA REPA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x10RACTION ONE HALF'
'\x03RAE'
'\x05RAEA-'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x03RAI'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x07RAISED '
'\nRAISED DOT'
'\x0bRAISED FLAG'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'\x17RAISED OMISSION BRACKET'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x08RAL FACE'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x03RAN'
'\x04RAN '
'\x0cRANCHING OUT'
'\rRANGE DIAMOND'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x14RANSPOSITION BRACKET'
'\x07RARIETY'
'\x05RASHA'
'\x03RAT'
'\x05RATER'
'\x05RATHA'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x08RAUGHTS '
'\x06RAVEL-'
'\x03RAY'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x05RCHID'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\x07RD SIGN'
'\x12RDEL NAG RDEL DKAR'
'\nRDHACANDRA'
'\x0bRDHAVISARGA'
'\x02RE'
'\x07READING'
'\tREAK HERE'
'\x0bREAKTHROUGH'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x04REAT'
'\x11REATIONAL VEHICLE'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x08RECEIVER'
'\x0fRECEPTIVE EARTH'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\x04RED '
'\nRED CIRCLE'
'\nRED DRAGON'
'\x08RED HAIR'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\nREDIT SIGN'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\x05REEK '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x05RELAA'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x03REN'
'\x0cREN CROSSING'
'\x06RENGTH'
'\x04REPA'
'\x10REPETITION MARK-'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\nRESH BELOW'
'\tRESH-AYIN'
'\x10RESH-AYIN-DALETH'
'\x07RESILLO'
'\x07RESSION'
'\x0eRETROFLEX HOOK'
'\x17RETROFLEX HOOK AND BELT'
'\x0bREVE-MACRON'
'\x08REVERSE '
'\x0fREVERSE SOLIDUS'
'\tREVERSED '
'\nREVERSED I'
'\x0fREVERSED OPEN E'
'\x0eREVERSED-SCHWA'
'\x03REX'
'\x02RF'
'\x04RFER'
'\x02RG'
'\nRGE CIRCLE'
'\nRGE SQUARE'
'\x18RGLASS WITH FLOWING SAND'
'\x04RGU2'
'\x03RHO'
'\x16RHO WITH STROKE SYMBOL'
'\x02RI'
'\x03RI '
'\x0cRIAGE SYMBOL'
'\x0cRIAL TRAMWAY'
'\x07RIANGLE'
'\x12RIANGLE ARROWHEADS'
'\x11RIATION SELECTOR-'
'\x06RIBBON'
'\x04RICE'
'\x05RICEM'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x05RIEUL'
'\x06RIEUL-'
'\rRIEUL-KHIEUKH'
'\rRIEUL-PHIEUPH'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x12RIGHT HALF BRACKET'
'\nRIGHT HOOK'
'\x17RIGHT HORIZONTAL SECANT'
'\x14RIGHT POINTING INDEX'
'\x0fRIGHT RERENGGAN'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'\x0bRIGHT-HAND '
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x14RIGHT-POINTING ANGLE'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x06RIKRIK'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\nRING BELOW'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\nRING THUMB'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x07RINKLES'
'&RIOUS FACE WITH SYMBOLS COVERING MOUTH'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\rRIPLE SVARITA'
'\x07RIPPLE '
'\x05RIPT '
'\x06RIPT G'
'\tRIS FORM '
'\x04RISE'
'\x06RISEME'
'\x04RISH'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x03RK '
'\rRK SUNGLASSES'
'\x06RKAANU'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x07RMUKHI '
'\x05RNED '
'\x02RO'
'\x03RO '
'\x03ROA'
'\nROAD OMEGA'
'\x04ROAR'
'\x03ROC'
'\x06ROCKET'
'\nROEZENIAN '
'\x07ROGRESS'
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x0cROLLING EYES'
'\x03ROM'
'\x03RON'
'\x05RONOS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x04ROSH'
'\x04ROSS'
'\x0eROSS ON SHIELD'
'\x08ROSSED O'
'\x0bROSSED-TAIL'
'\x03ROT'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\x07ROTUNDA'
'\x05ROUND'
'\nROUNDED ER'
'\rRPENTRY PLANE'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\nRROW WITH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x06RSHANA'
'\x04RSO-'
'\x02RT'
'\rRTABLE STEREO'
'\tRTER MARK'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x10RUMAI PALAUNG FA'
'\x14RUMAI PALAUNG TONE-5'
'\x05RUMP-'
'\x04RUNG'
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x02RY'
'\x07RY FACE'
'\x11RYBLION BASE SIGN'
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x07S BELOW'
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\rS UP TOGETHER'
'\x07S-SAJDA'
'\x08S-SERIF '
'\x02S0'
'\x02SA'
'\x07SA VAH '
'\x04SA-I'
'\x03SAA'
'\x06SAADIY'
'\x03SAD'
'\x05SADHE'
'\x03SAG'
'\x03SAH'
'\x05SAKIN'
'\x05SAKTA'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x03SAM'
'\x10SAMARITAN SOURCE'
'\x06SANDAL'
'\x07SANDHI '
'\x04SANG'
'\x07SANGAN '
'\x10SANS-SERIF ARROW'
'\x03SAR'
'\x0cSARAM GONDI '
'\x05SARGA'
'\x05SASAK'
'\x03SAU'
'\x06SAUCER'
'\x03SAW'
'\x05SCENT'
'\nSCENT MOON'
'\x06SCHOOL'
'\x07SCOOTER'
'\x05SCOPE'
'\x0eSCRIPT SMALL L'
'\x08SCRIPT X'
'\x0eSCRIPTIONAL PA'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0eSECOND SUBUNIT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\tSEMICOLON'
'\x08SENTAGON'
'\x1cSENTATION FORM FOR VERTICAL '
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x07SERPINA'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x15SET PRECEDING SOLIDUS'
'\x07SEVENTH'
'\x02SH'
'\x03SH '
'\x15SH AMPERSAND ORNAMENT'
'\x13SH PLUS HU PLUS ASH'
'\x08SH WITH '
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\tSHAB CEEB'
'\x04SHAD'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x12SHAN REDUPLICATION'
'\x05SHANG'
'\x17SHAPE WITH A DOT INSIDE'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARU'
'\x03SHE'
'\x04SHE3'
'\tSHED FACE'
'\x04SHEI'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x07SHESHIG'
'\x0eSHESHIG TIMES '
'\x05SHGAB'
'\x03SHI'
'\x07SHIFT T'
'\x05SHIMA'
'\x04SHIN'
'\x05SHIRT'
'\x0fSHITA PLUS GISH'
'\nSHMIRI YEH'
'\x0bSHOGI PIECE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x08SHORT ER'
'\x0fSHORT OVER LONG'
'\x0cSHORT RIKRIK'
'\x05SHPIN'
'\x05SHTIN'
'\x04SHU '
'\x04SHU2'
'\x10SHU2 PLUS KASKAL'
'\x04SHYA'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\nSIDEWAYS I'
'\x14SIDEWAYS NOON GHUNNA'
'\x06SIEUNG'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x08SIGN LAE'
'\x11SIGN O WITH CROSS'
'\x07SIGN UD'
'\x03SII'
'\x04SIKI'
'\x05SILA3'
'\x0bSIMILE SIGN'
'\rSING DIAGONAL'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x04SIOS'
'\x05SIOS-'
'\nSIOS-PIEUP'
'\x0cSIOS-THIEUTH'
'\x0bSIOS-TIKEUT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\rSIX LATE FORM'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x16SKA- SHOG GI MGO RGYAN'
'\x04SKAL'
'\x05SKATE'
'\x13SLANTED NORTH ARROW'
'\x05SLASH'
'\x05SMALL'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\rSMALL DIGAMMA'
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL RING'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\nSMILO SIGN'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\x02SO'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x07SOLDIER'
'\x18SOLIDUS PRECEDING SUBSET'
'\x05SOLVE'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x06SOUTH '
'\x0cSOUTHERN TSE'
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x08SPERSION'
'\x05SPINE'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x03SQU'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x07SQUARES'
'\x08SQUEEZED'
'\x0cSQUIQUADRATE'
'\x02SS'
'\nSS OF MILK'
'\x03SSA'
'\rSSAGE WAITING'
'\x05SSANG'
'\x0bSSANGKIYEOK'
'\nSSANGNIEUN'
'\nSSANGPIEUP'
'\x08SSESSION'
'\x03SSI'
'\x1aSSIAN ASTROLOGICAL SYMBOL '
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x04SSUS'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x07ST TUBE'
'\nST-FEEDING'
'\x03STA'
'\tSTAL BALL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x07STATERS'
'\x0bSTEAMY ROOM'
'\tSTEBASKET'
'\tSTER FACE'
'\x07STERING'
'\x08STERISK '
'\rSTERTIUS SIGN'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x04STLE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x16STONE GRAVEYARD SYMBOL'
'\x0bSTORIC SITE'
'\x03STR'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\nSTRAL SIGN'
'\x13STRATIAN FIFTY MNAS'
'\x06STRING'
'\x06STROKE'
'\x07STROKE '
'\x0fSTROKE AND HOOK'
'\x19STROKE AND TWO DOTS ABOVE'
'\x0cSTROKE BELOW'
'\x18STROKE THROUGH DESCENDER'
'\x0eSTRONG ISOLATE'
'\nSTRUCTION '
'\x1bSTRUMENTAL NOTATION SYMBOL-'
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x03SU '
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x13SUBSTITUTION MARKER'
'\x04SUCK'
'\x06SUCKED'
'\x04SUKU'
'\x06SULAR '
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x05SURYA'
'\x03SUU'
'\x07SVARITA'
'\x0bSVASTI SIGN'
'\nSWASH TAIL'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x07SYMBOL '
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x07T BELOW'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x05T OF '
'\tT OF MEAT'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02T0'
'\x02TA'
'\x0eTA LINK ESCAPE'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\nTABULATION'
'\x0cTACKED COMMA'
'\x05TAGON'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x0fTAI LAING TONE-'
'\x08TAI LUE '
'\x04TAK4'
'\x0eTAKANA LETTER '
'\tTAKHALLUS'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\nTAMAN SIGN'
'\x06TAMING'
'\x03TAN'
'\tTANDSTILL'
'\x08TAR EYES'
'\x06TARGET'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAW'
'\x04TAWA'
'\x04TAXI'
'\x03TCH'
'\nTCOIN SIGN'
'\x02TE'
'\rTE ORDER MARK'
'\x0cTE SEPARATOR'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\x04TED '
'\rTED HAND SIGN'
'\x18TED INTERPOLATION MARKER'
'\x06TEDUNG'
'\x03TEE'
'\x04TEEN'
'\x05TEGEH'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x0bTENS DIGIT '
'\x05TENSE'
'\x05TENTH'
'\x04TENU'
'\x03TER'
'\x1eTERLOCKED FEMALE AND MALE SIGN'
'\x0eTERMINAL MARK-'
'\x0cTERNATE AYIN'
' TERNATE ONE-WAY LEFT WAY TRAFFIC'
'\x07TERNITY'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\x04TH G'
'\x0bTH-THALATHA'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x13THANG LONG ANUSVARA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x07THIEUTH'
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\x03THO'
'\x08THOUSAND'
'\tTHOUSAND '
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0fTHREE DISH TENU'
'\x10THREE DOTS ABOVE'
'\x0cTHREE HEARTS'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0bTHREE TIMES'
'\x08THROUGH '
'\tTHROUGH X'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x03THW'
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x04TIC '
'\x06TICAL '
'\nTICAL DISC'
'\rTICAL ELLIPSE'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x06TIKEUT'
'\x07TIKEUT-'
'\x07TIKRAMA'
'\x05TILDE'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES BAD'
'\tTIMES KUR'
'\tTIMES NA2'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES TAK4'
'\x04TIN '
'\tTIN CROSS'
'\x05TING '
'\nTING HEART'
'\x0bTION BOTTLE'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x03TIU'
'\x05TKAAN'
'\x03TLE'
'\x06TLESS '
'\x07TLESS J'
'\x05TMAAU'
'\x02TO'
'\x06TO BAR'
'\x08TO FORM '
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x0bTONAL MARK '
'\x04TONE'
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\x05TONE-'
'\x06TONGUE'
'\x0eTOP HALF BLACK'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x16TORTOISE SHELL BRACKET'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x05TRACK'
'\x0cTRAGRAM FOR '
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x03TRE'
'\tTREDECILE'
'\x04TREE'
'\nTREFACTION'
'\nTRESS AND '
'\tTRETCHED '
'\x03TRI'
'\x08TRI DISH'
'\x0bTRIAN CAMEL'
'\x08TRIANGLE'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x0fTRIANGULAR MARK'
'\x08TRICOLON'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE DANDA'
'\x11TRIPLE DASH ARROW'
'\x0cTRIPLE FLAME'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'!TRONG CENTRALIZATION STROKE BELOW'
'\x03TSA'
'\x03TSE'
'\x05TSEEB'
'\x05TSHEG'
'\x02TT'
'\x03TTA'
'\x03TTE'
'\x05TTED '
'\x19TTED SUBSTITUTION BRACKET'
'\x05TTER '
'\x07TTERFLY'
'\x05TTERN'
'\x05TTOCK'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x03TUJ'
'\x04TUKI'
'\tTUKWENTIS'
'\x0bTUNE COOKIE'
'\x03TUR'
'\x06TURBAN'
'\x0eTURKIC LETTER '
'\x05TURN '
'\nTURNED AYB'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\nTURNED GAN'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x13TURNED SECTION MARK'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'\x0eTWO DOTS BELOW'
'!TWO DOTS OVER ONE DOT PUNCTUATION'
'\x19TWO DOTS VERTICALLY ABOVE'
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x04TZEL'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x05U U U'
'\x07U WITH '
'\rU WITH STROKE'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x02U0'
'\x02U2'
'\nU2 PLUS BA'
'\x02U3'
'\x02UA'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\x06UANGXI'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x08UATRILLO'
'\x02UB'
'\x03UB '
'\x03UB2'
'\x0eUBHAYATO MUKHA'
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x08UBJOINER'
'\x04UBLE'
'\x05UBLE '
'\nUBLE DANDA'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x10UBLE PARENTHESIS'
'\x06UBLE R'
'\x0fUBLE RING BELOW'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\rUBSCRIPT ALEF'
'\x16UBSCRIPT SMALL LETTER '
'\x13UBSTITUTION BRACKET'
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x05UDAAT'
'\x06UDATTA'
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\x03UG2'
'\x06UGGAGE'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x04UHUR'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x02UK'
'\x05UKARA'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x08ULA SIGN'
'\x05ULAR '
'\x07ULATION'
'\x03ULL'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x03ULT'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x03UM '
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x12UM WITH DRUMSTICKS'
'\x04UMAN'
'\nUMAN EARTH'
'\x08UMBRELLA'
'\tUMED HEAD'
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x07UN MEUT'
'\x12UNATE SIGMA SYMBOL'
'\x0cUNBLENDED UK'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x0fUNCTUATION MARK'
'\x16UNCTUATION NUN HAFUKHA'
'\x03UND'
'\x05UNDER'
'\x06UNDER '
'\x08UNDERTIE'
'\x07UNDRED '
'\x1aUNEVEN EYES AND WAVY MOUTH'
'\x03UNG'
'\x08UNG DASH'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\tUNGSEONG '
'\x0bUNIT DIGIT '
'\x05UNITY'
'\nUNKIA SIGN'
'\x04UNNY'
'\x02UO'
'\x03UOM'
'\x03UON'
'\x04UON '
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\rUPONDIUS SIGN'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x1fUPPER RIGHT DIAGONAL HALF BLACK'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\nUR HUNDRED'
'\x06UR OF '
'\tUR-DE-LIS'
'\tURAMAZDAA'
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x05URITY'
'\x03URL'
'\x03URN'
'\x06URNAMA'
'\x06URNED '
'\x11URNED DAMMA BELOW'
'\tURNED GAN'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x03URT'
'\x03URU'
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US MARK'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\rUSHING UPWARD'
'\x06USHPIN'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x06USTER-'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\x05UTEUX'
'\x04UTH '
'\x0cUTH ARABIAN '
'\x0bUTH CORNERS'
'\nUTH OR SPY'
'\x05UTIES'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\x04UTTY'
'\x02UU'
'\x06UUMISH'
'\x02UX'
'\x02UZ'
'\x01V'
'\x08V OVER M'
'\x07V WITH '
'\x02V0'
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x07VAPOURS'
'\x07VARIANT'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VASTNESS OR WASTING'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\x08VE SASAK'
'\tVE THUMB '
'\x03VE-'
'\x04VEDE'
'\x0eVEDIC ANUSVARA'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\tVELOPMENT'
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\tVER LUGAL'
'\x08VERGENCE'
'\rVERGREEN TREE'
'\tVERLONG A'
'\rVERSE DIVIDER'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x13VERTICAL BAR VIRAMA'
'\x17VERTICAL BAR WITH QUILL'
'\rVERTICAL BARS'
'\x0eVERTICAL COLON'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x10VERTICALLY ABOVE'
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VES'
'\x08VESSEL B'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\x04VIDA'
'\nVIE CAMERA'
'\x05VIET '
'\x10VIEWING CEREMONY'
'\tVIGINTILE'
'\x07VILLAIN'
'\x03VIN'
'\x04VINE'
'\tVINE LEAF'
'\x06VIRAMA'
'\x07VISARGA'
'\x08VISARGA '
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x16VOCAL NOTATION SYMBOL-'
'\x08VOCALIC '
'\tVOCALIC L'
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x05VOICE'
'\x18VOICED LARYNGEAL SPIRANT'
'\x07VOICING'
'\x0cVOLTAGE SIGN'
'\x08VOLUTION'
'\x08VOMITING'
'\x0eVONIC ASTERISK'
'\x03VOP'
'\x0cVORCE SYMBOL'
'\x04VOS '
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x13VOWEL SIGN VOCALIC '
'\x14VOWEL SIGN VOCALIC L'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\nW OR MODEL'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\rW RING INSIDE'
'\x0bW WITH HOOK'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x04WAEN'
'\x04WAET'
'\x03WAI'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x03WAN'
'\x05WAQFA'
'\x04WARD'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\x03WAU'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\tWAW WITH '
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x05WELVE'
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x15WENTY ON BLACK SQUARE'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x05WFISH'
'\x02WG'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\nWHITE HAIR'
'\x0bWHITE JOKER'
'\x14WHITE LENTICULAR BRA'
'\x18WHITE LENTICULAR BRACKET'
'\x11WHITE SHOGI PIECE'
'\x0cWHITE SQUARE'
'\x1cWHITE TORTOISE SHELL BRACKET'
'\nWHOLE NOTE'
'\x02WI'
'\x05WIANG'
'\x04WIDE'
'\x05WIDTH'
'\x07WIFRUIT'
'\x07WIGNYAN'
'\x06WINDOW'
'\x05WINDU'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISAD'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x13WITH INFINITY BELOW'
'\x12WITH JUSTIFICATION'
'\x0eWITH LEFT HOOK'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x0fWITH RAIN DROPS'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\nWITH SPOON'
'\nWITH STRAW'
'\x0cWITH STROKE '
'\x18WITH TWO DOTS BELOW AND '
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x0cWN ARROWHEAD'
'\x07WN FACE'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO COMMA'
'\x07WO DOTS'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\nWO FINGERS'
'\x07WO FOR '
'\x06WO OF '
'\nWO SHORTS '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\x15WO-CIRCLE NUKTA ABOVE'
'\nWO-HEADED '
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x03WOA'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x0cWORD DIVIDER'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x03WOY'
'\x06WRENCH'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WU318'
'\x05WUAET'
'\x04WULU'
'\x02WZ'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x16XCLAMATION MARK SYMBOL'
'\x02XE'
'\nXED BICEPS'
'\x0bXESTES SIGN'
'\x04XEYN'
'\x02XG'
'\tXHAUSTION'
'\nXHEEJ CEEV'
'\x02XI'
'\x08XIANGQI '
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x02XT'
'\x07XT LINE'
'\x05XTILE'
'\x0bXTINGUISHER'
'\x15XTRA SHORT VOWEL MARK'
'\x05XTRA-'
'\x03XWG'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x07Y GREEN'
'\x06Y LOOP'
'\x08Y POPPER'
'\x08Y SMALL '
'\x0eY SMALL SQUARE'
'\nY THOUSAND'
'\x07Y WITH '
'\x03Y00'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x07YAH LI '
'\x03YAI'
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x03YAN'
'\x0cYAN NUMERAL '
'\x04YANG'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x03YEO'
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\x08YESIEUNG'
'\tYESIEUNG-'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x0eYI WITH STROKE'
'\x03YIN'
'\x06YIN-DO'
'\x05YING '
'\nYING CARD '
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YIZET'
'\x0cYLEFT SYMBOL'
'\x08YLLABLE '
'\x05YMBOL'
'\x06YMBOL '
'\nYMBOL AIVA'
'\x0cYMBOL BINDU '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x03YOA'
'\x03YOD'
'\x0cYOD TRIANGLE'
'\x04YODH'
'\x06YOMBO '
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x12YPTIAN HIEROGLYPH '
'\x0cYPTOGRAMMIC '
'\x14YRENAIC TWO DRACHMAS'
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x04YUKU'
'\x03YUT'
'\x03YWA'
'\x01Z'
'\x07Z WITH '
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x03ZAH'
'\x03ZAI'
'\x04ZAIN'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'\tZAL SASAK'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\nZAR AMULET'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\x15ZENE RING WITH CIRCLE'
'\x04ZERO'
'\x05ZERO '
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x02ZH'
'\x16ZH WITH RETROFLEX HOOK'
'\x03ZHA'
'\x05ZHAIN'
'\x03ZHE'
'\x02ZI'
'\tZIDA TENU'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\tZIR SASAK'
'\x04ZIZ2'
'\x02ZO'
'\x03ZOA'
'\x03ZOO'
'\nZU OVER ZU'
'\x08ZWARAKAY'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZY '
)
_charnodes =[68920,
 -54044,
 -1,
 132661,
 52765,
 -1,
 198179,
 101229,
 -1,
 263553,
 178889,
 -1,
 327930,
 226380,
 -1,
 393401,
 268596,
 74167,
 458852,
 356543,
 -1,
 524324,
 398881,
 -1,
 589846,
 463362,
 75009,
 720895,
 526872,
 -1,
 720910,
 642589,
 -1,
 -65524,
 701643,
 75019,
 -65523,
 735247,
 75018,
 -1,
 791061,
 75017,
 983057,
 705170,
 -1,
 -65520,
 934083,
 75016,
 -1,
 991765,
 75015,
 -65518,
 947350,
 75014,
 -65517,
 1143796,
 75013,
 -65516,
 1196138,
 75012,
 -65515,
 1255213,
 75011,
 -1,
 1320023,
 75010,
 1507362,
 529693,
 75021,
 1638399,
 1444376,
 -1,
 1638427,
 1560093,
 -1,
 -65510,
 1619147,
 75030,
 -1,
 1652751,
 75029,
 1835037,
 1598740,
 75024,
 -1,
 1770293,
 75025,
 -65506,
 1816952,
 75028,
 -65505,
 1941516,
 75027,
 -65504,
 2002067,
 75026,
 -65503,
 2052929,
 75023,
 -1,
 2113604,
 75022,
 -65501,
 1446991,
 75020,
 -1,
 2232544,
 75008,
 2424889,
 463960,
 -1,
 2490415,
 2364504,
 -1,
 2555950,
 2431106,
 74993,
 2686975,
 2492952,
 -1,
 2687019,
 2596840,
 -1,
 -65494,
 2662386,
 74997,
 -1,
 2719805,
 74996,
 -65492,
 2674344,
 74998,
 -65491,
 2843924,
 74995,
 -1,
 2906018,
 74994,
 -1,
 2494698,
 74992,
 3145780,
 2431106,
 -1,
 -65487,
 3085612,
 75006,
 -65486,
 3150650,
 75005,
 -65485,
 3215893,
 75004,
 -1,
 3280861,
 75003,
 3473463,
 3085612,
 -1,
 -65482,
 3413745,
 75000,
 -1,
 3477469,
 74999,
 -65480,
 3414136,
 75002,
 -1,
 3610540,
 75001,
 3801160,
 2363357,
 -1,
 3866685,
 3741649,
 -1,
 -65476,
 3805560,
 74974,
 -1,
 3870685,
 74973,
 4063296,
 3806508,
 -1,
 -65473,
 4002026,
 74970,
 -1,
 4067293,
 74969,
 4259907,
 4002325,
 -1,
 -65470,
 4199724,
 74967,
 -1,
 4264170,
 74966,
 -65468,
 4200739,
 74975,
 -65467,
 4396988,
 74972,
 -65466,
 4462307,
 74971,
 -65465,
 4527157,
 74968,
 -1,
 4591830,
 74965,
 4784212,
 3740181,
 -1,
 4849741,
 4723221,
 -1,
 -65461,
 4790225,
 74982,
 -65460,
 4855084,
 74981,
 -1,
 4919261,
 74980,
 5111888,
 4789793,
 -1,
 -65457,
 5051937,
 74985,
 -1,
 5117228,
 74984,
 5308499,
 5050602,
 -1,
 -65454,
 5249154,
 74979,
 -1,
 5312477,
 74978,
 -1,
 5248082,
 74983,
 5570653,
 4723514,
 -1,
 5636185,
 5510232,
 -1,
 -65449,
 5576657,
 74988,
 -65448,
 5641969,
 74987,
 -1,
 5706554,
 74986,
 5898332,
 5576657,
 -1,
 -65445,
 5837912,
 74990,
 -1,
 5903162,
 74989,
 -1,
 5839133,
 74991,
 6160480,
 5510897,
 -1,
 -65441,
 6100256,
 75032,
 -1,
 6165271,
 75031,
 6357091,
 6099178,
 -1,
 -65438,
 6296858,
 74977,
 -1,
 6362165,
 74976,
 -1,
 6297097,
 75007,
 6619315,
 414529,
 -1,
 6684845,
 6563519,
 74168,
 6815743,
 6619136,
 -1,
 6815916,
 6735914,
 -1,
 6881392,
 6756660,
 74169,
 6946925,
 6817507,
 -1,
 -65429,
 6911350,
 74172,
 -65428,
 6968323,
 74171,
 -1,
 7026861,
 74170,
 -65426,
 6928537,
 74175,
 -65425,
 7178536,
 74174,
 -1,
 7238732,
 74173,
 7405687,
 6868509,
 74213,
 7471220,
 7341795,
 -1,
 -65421,
 7458356,
 74215,
 -1,
 7477556,
 74214,
 -65419,
 7452767,
 74218,
 -65418,
 7616527,
 74217,
 -1,
 7672500,
 74216,
 7864448,
 7386455,
 -1,
 7929983,
 7821352,
 -1,
 7995515,
 7917221,
 74207,
 -1,
 7931894,
 74208,
 8126590,
 7957871,
 -1,
 -65411,
 8111382,
 74206,
 -1,
 8168291,
 74205,
 -1,
 8077688,
 74204,
 -1,
 7917860,
 74209,
 8454279,
 7827595,
 -1,
 8519813,
 8441373,
 -1,
 8585348,
 8483916,
 74194,
 -1,
 8521524,
 74195,
 -1,
 8524602,
 74193,
 8847359,
 8479105,
 74191,
 -1,
 8751400,
 74192,
 8913037,
 8409842,
 -1,
 8978570,
 8900645,
 74182,
 -1,
 8914730,
 74183,
 9109644,
 8919348,
 74180,
 -1,
 9087106,
 74181,
 -1,
 9068929,
 74632,
 9306258,
 8877132,
 -1,
 9371792,
 9293341,
 74198,
 -1,
 9335884,
 74199,
 -65391,
 9333926,
 74197,
 -1,
 9444507,
 74196,
 9633944,
 9265537,
 -1,
 9699479,
 9601157,
 74188,
 9830399,
 9635555,
 -1,
 -65386,
 9732129,
 74190,
 -1,
 9787454,
 74189,
 -1,
 9655817,
 74187,
 10027165,
 9618066,
 -1,
 10092700,
 9967924,
 -1,
 -65381,
 10055898,
 74211,
 -1,
 10113778,
 74210,
 -1,
 10043716,
 74212,
 10354849,
 9994373,
 -1,
 10420384,
 10305731,
 74200,
 -1,
 10356503,
 74201,
 -1,
 10409271,
 74202,
 10616997,
 10311720,
 -1,
 10682532,
 10557748,
 74184,
 -1,
 10646604,
 74185,
 -1,
 10641881,
 74186,
 10879144,
 10561215,
 -1,
 -65369,
 10838401,
 74177,
 -1,
 10886005,
 74176,
 -65367,
 10872619,
 74964,
 -65366,
 11045582,
 74203,
 -65365,
 11093578,
 74179,
 -1,
 11155756,
 74178,
 -1,
 6798949,
 74219,
 11468799,
 6662274,
 74220,
 11534335,
 11337728,
 -1,
 11534513,
 11454553,
 74221,
 -1,
 11470849,
 74222,
 11730943,
 11491281,
 74223,
 -1,
 11601419,
 74224,
 11796662,
 6586501,
 74228,
 11927551,
 11733652,
 74229,
 -1,
 11798471,
 74230,
 11993272,
 11760716,
 74226,
 -1,
 11930271,
 74227,
 -1,
 11952319,
 74225,
 12189942,
 380445,
 74235,
 12255465,
 12128789,
 74237,
 12386303,
 12189696,
 -1,
 12386530,
 12305042,
 -1,
 12452065,
 12346931,
 -1,
 12517572,
 12415115,
 -1,
 12583107,
 12458869,
 -1,
 12648642,
 12522298,
 74246,
 -1,
 12584690,
 74247,
 -1,
 12587541,
 74245,
 -1,
 12542337,
 74248,
 12910793,
 12498263,
 -1,
 12976328,
 12870017,
 -1,
 -65337,
 12939471,
 74255,
 -1,
 12977906,
 74254,
 -1,
 12935398,
 74635,
 13238477,
 12863921,
 74240,
 13369343,
 13172736,
 -1,
 -65332,
 13288726,
 74241,
 -1,
 13345667,
 74634,
 13500624,
 13222546,
 -1,
 -65329,
 13488266,
 74256,
 -1,
 13508095,
 75038,
 13697234,
 13475812,
 75036,
 -1,
 13633451,
 75037,
 13828309,
 13666600,
 -1,
 -65324,
 13815325,
 74253,
 -1,
 13844675,
 74252,
 14024920,
 13792406,
 -1,
 -65321,
 13980505,
 74250,
 -1,
 14026482,
 74249,
 14221531,
 13981736,
 -1,
 -65318,
 14180813,
 74243,
 -1,
 14229025,
 75035,
 -65316,
 14189481,
 74251,
 -65315,
 14378499,
 74244,
 -65314,
 14439376,
 74242,
 -65313,
 14498765,
 75034,
 -65312,
 14559021,
 74239,
 -1,
 14622241,
 74238,
 -1,
 12404689,
 74257,
 14876902,
 12367191,
 -1,
 14942437,
 14834671,
 74261,
 -1,
 14879264,
 74633,
 -1,
 14919574,
 74260,
 -65305,
 14850070,
 74259,
 -65304,
 15095766,
 75033,
 -1,
 15152821,
 74258,
 15335663,
 12211115,
 74263,
 15466495,
 15269888,
 -1,
 15466734,
 15372433,
 -1,
 -65299,
 15456131,
 74264,
 -1,
 15508781,
 74265,
 -1,
 15448454,
 74266,
 15728882,
 15302789,
 74269,
 15859711,
 15664672,
 74270,
 -1,
 15729441,
 74271,
 -65293,
 15692876,
 74268,
 -65292,
 15882280,
 74267,
 -65291,
 15930170,
 74262,
 -1,
 15993376,
 74236,
 16252927,
 12149121,
 74231,
 -65288,
 16169055,
 74234,
 -65287,
 16221903,
 74233,
 -1,
 16282700,
 74232,
 16449977,
 283378,
 -1,
 16515448,
 16390452,
 73909,
 16580964,
 16454165,
 73911,
 16711679,
 16515072,
 -1,
 16712035,
 16631850,
 -1,
 16777482,
 16667378,
 -1,
 16843014,
 16718132,
 74939,
 16908549,
 16820354,
 73932,
 17039359,
 16844515,
 -1,
 -65276,
 16943822,
 74941,
 -1,
 16988862,
 74940,
 -1,
 16877930,
 73931,
 17301503,
 16802177,
 73933,
 17301769,
 17175640,
 73934,
 -1,
 17237738,
 73935,
 -1,
 17279207,
 73936,
 17498389,
 16718132,
 -1,
 17563918,
 17479775,
 73917,
 17694719,
 17502741,
 74618,
 -1,
 17565472,
 73918,
 17760530,
 17499875,
 -1,
 -65264,
 17720596,
 73914,
 -65263,
 17782846,
 73913,
 -1,
 17840301,
 73912,
 18022676,
 17729832,
 73916,
 -1,
 17958724,
 74617,
 -1,
 17966808,
 73915,
 18219296,
 17478999,
 -1,
 18284828,
 18176040,
 -1,
 18350362,
 18243969,
 -1,
 -65255,
 18317445,
 74951,
 -1,
 18364431,
 73959,
 18612223,
 18301123,
 73957,
 -1,
 18483211,
 73958,
 18678047,
 18225460,
 -1,
 -65250,
 18655362,
 73956,
 -1,
 18707532,
 73955,
 -1,
 18665764,
 73960,
 18940203,
 18167823,
 -1,
 19005734,
 18927133,
 -1,
 19071269,
 18961157,
 -1,
 -65244,
 19034503,
 74937,
 -1,
 19096856,
 74936,
 -1,
 19015359,
 73926,
 19333418,
 18964865,
 73924,
 19464191,
 19300487,
 -1,
 -65239,
 19384409,
 73925,
 -1,
 19421137,
 74935,
 -1,
 19274036,
 73923,
 19661108,
 18903179,
 -1,
 19726639,
 19648029,
 -1,
 -65234,
 19708478,
 74943,
 -1,
 19731432,
 73948,
 19923249,
 19686171,
 73946,
 -1,
 19859317,
 73947,
 20119551,
 19863860,
 -1,
 -65229,
 20036575,
 73945,
 -1,
 20082827,
 73944,
 20250941,
 19617832,
 -1,
 20316475,
 20191540,
 -1,
 20382008,
 20280396,
 73938,
 -1,
 20318060,
 73939,
 20578303,
 20317923,
 -1,
 -65222,
 20480036,
 73937,
 -1,
 20519220,
 74942,
 -65220,
 20303634,
 73941,
 -1,
 20668834,
 73940,
 20840772,
 20220200,
 -1,
 20906306,
 20791491,
 74948,
 21037055,
 20842211,
 -1,
 -65215,
 20928006,
 74950,
 -1,
 20988380,
 74949,
 21233663,
 20894078,
 73952,
 -1,
 21104208,
 73953,
 21299530,
 20791491,
 -1,
 21365063,
 21268776,
 73929,
 -1,
 21301851,
 73930,
 21496137,
 21328972,
 73927,
 -1,
 21432172,
 73928,
 -1,
 21474538,
 74938,
 21692753,
 21243583,
 -1,
 21758287,
 21633332,
 -1,
 -65203,
 21735594,
 73920,
 -65202,
 21781041,
 74934,
 -1,
 21837839,
 73919,
 22085631,
 21746727,
 73921,
 -1,
 21956542,
 73922,
 22151510,
 21656652,
 -1,
 22217045,
 22092084,
 73949,
 22347775,
 22184069,
 74944,
 -1,
 22219412,
 74945,
 -1,
 22204570,
 74946,
 22479193,
 22138397,
 73962,
 22609919,
 22427663,
 73963,
 -1,
 22480654,
 73964,
 22675805,
 22446213,
 -1,
 -65189,
 22664503,
 74947,
 -65188,
 22700417,
 73951,
 -1,
 22757725,
 73950,
 22937952,
 22634881,
 -1,
 -65185,
 22919292,
 73943,
 -1,
 22959625,
 73942,
 -65183,
 22931227,
 74952,
 -65182,
 23118747,
 73961,
 -1,
 23174953,
 73954,
 -1,
 16686230,
 73965,
 23396714,
 16550184,
 73974,
 23527423,
 23335445,
 73975,
 23592959,
 23396352,
 -1,
 -65176,
 23512342,
 73976,
 -65175,
 23567519,
 73977,
 -1,
 23606887,
 73978,
 23789933,
 23360588,
 73970,
 -65172,
 23732073,
 73972,
 -1,
 23790342,
 73971,
 23986545,
 23734004,
 73966,
 24117247,
 23920640,
 -1,
 -65168,
 24032205,
 74953,
 -1,
 24065625,
 73967,
 24248691,
 23963778,
 73979,
 -1,
 24187706,
 73980,
 24379765,
 24197135,
 73968,
 -1,
 24315264,
 73969,
 -65162,
 24361185,
 73981,
 -65161,
 24477829,
 73973,
 -1,
 24511285,
 73910,
 24707481,
 16474497,
 73984,
 24772995,
 24684674,
 -1,
 24838529,
 24711994,
 73994,
 24969215,
 24775192,
 -1,
 -65155,
 24878889,
 73999,
 -65154,
 24936497,
 73998,
 -65153,
 24995092,
 73997,
 -65152,
 25056208,
 73996,
 -1,
 25106806,
 73995,
 25362431,
 24777237,
 73992,
 -1,
 25232181,
 73993,
 25428366,
 24753495,
 -1,
 25493901,
 25385000,
 74001,
 25624575,
 25427968,
 -1,
 25624972,
 25543314,
 -1,
 25690507,
 25585203,
 -1,
 -65143,
 25674651,
 74004,
 -65142,
 25712248,
 74955,
 -1,
 25765677,
 74003,
 -1,
 25642961,
 74005,
 -1,
 25573006,
 74002,
 -1,
 25435681,
 74000,
 26149266,
 25367640,
 73988,
 26279935,
 26083328,
 -1,
 -65135,
 26188969,
 73989,
 -1,
 26228353,
 73990,
 26411415,
 26083328,
 -1,
 26476950,
 26396714,
 -1,
 -65131,
 26463773,
 73986,
 -1,
 26493123,
 73985,
 -1,
 26424949,
 73987,
 -65128,
 26366706,
 74620,
 -1,
 26688368,
 73991,
 26870195,
 24694301,
 74006,
 26935715,
 26808853,
 74008,
 27066367,
 26869760,
 -1,
 27066786,
 26986538,
 -1,
 27132319,
 27029808,
 74009,
 -1,
 27069046,
 74010,
 -65120,
 27113022,
 74012,
 -65119,
 27234307,
 74011,
 -1,
 27288856,
 74956,
 -1,
 27023313,
 74013,
 27525546,
 26884111,
 74014,
 27656191,
 27459584,
 -1,
 27656616,
 27576362,
 -1,
 -65113,
 27620372,
 74016,
 -1,
 27662721,
 74015,
 -65111,
 27632494,
 74957,
 -1,
 27827378,
 74017,
 27984303,
 27502722,
 74021,
 28049838,
 27971101,
 -1,
 -65107,
 28031071,
 74024,
 -1,
 28084520,
 74023,
 -1,
 27989745,
 74022,
 28311985,
 27951237,
 74019,
 -1,
 28248746,
 74020,
 -65102,
 28275788,
 74018,
 -1,
 28377644,
 74007,
 28639231,
 26820803,
 -1,
 28639672,
 28555822,
 73982,
 28770303,
 28576280,
 -1,
 -65097,
 28691997,
 74954,
 -1,
 28734484,
 73983,
 -1,
 28578580,
 74619,
 28967488,
 16412811,
 -1,
 29032998,
 28907828,
 74071,
 29098511,
 28969496,
 -1,
 29163979,
 29053682,
 -1,
 29229507,
 29122945,
 74087,
 29295042,
 29210719,
 74624,
 29425663,
 29229056,
 -1,
 -65087,
 29336471,
 74089,
 -1,
 29374094,
 74090,
 -1,
 29272284,
 74088,
 29622728,
 29169972,
 74082,
 29688262,
 29599874,
 74085,
 -1,
 29624282,
 74086,
 -65081,
 29657450,
 74084,
 -1,
 29783116,
 74083,
 30015487,
 29609501,
 74091,
 -65078,
 29927666,
 74092,
 -1,
 29964303,
 74625,
 30147030,
 29144407,
 -1,
 30212562,
 30103592,
 -1,
 30278095,
 30199325,
 74115,
 -1,
 30241868,
 74629,
 -65072,
 30237467,
 74114,
 -65071,
 30359747,
 74113,
 -1,
 30415156,
 74112,
 30605780,
 30153012,
 74110,
 -1,
 30582914,
 74111,
 -65067,
 30593194,
 74117,
 -1,
 30696445,
 74116,
 30867934,
 30133789,
 74119,
 30933465,
 30845058,
 74963,
 -1,
 30872085,
 74631,
 -65062,
 30914655,
 74123,
 -65061,
 31033513,
 74122,
 -65060,
 31078415,
 74121,
 -65059,
 31134229,
 74120,
 -1,
 31197957,
 74962,
 31392230,
 30834821,
 -1,
 31457764,
 31342787,
 74100,
 31588351,
 31393507,
 -1,
 -65054,
 31507533,
 74103,
 -65053,
 31544838,
 74102,
 -1,
 31604781,
 74101,
 31850495,
 31416705,
 74104,
 -1,
 31721375,
 74105,
 31916525,
 31332660,
 74072,
 31982058,
 31897695,
 -1,
 -65047,
 31920954,
 74623,
 -1,
 31986197,
 74075,
 32178668,
 31930383,
 74073,
 -1,
 32114530,
 74074,
 -1,
 32149207,
 74622,
 32375284,
 31860415,
 -1,
 32440818,
 32315700,
 -1,
 -65040,
 32417922,
 74078,
 -65039,
 32470274,
 74077,
 -1,
 32520207,
 74076,
 -65037,
 32427549,
 74960,
 -1,
 32661889,
 74079,
 32834041,
 32338059,
 -1,
 32899575,
 32792961,
 74096,
 -1,
 32847887,
 74097,
 33095679,
 32839988,
 74961,
 -1,
 32993419,
 74095,
 33161725,
 32797772,
 -1,
 33227260,
 33148445,
 74099,
 -1,
 33194117,
 74627,
 -1,
 33186177,
 74098,
 33423872,
 33145490,
 -1,
 -65025,
 33410589,
 74630,
 -1,
 33432085,
 74118,
 33620483,
 33398477,
 -1,
 -65022,
 33579393,
 74108,
 -1,
 33626420,
 74628,
 33817094,
 33589544,
 -1,
 -65019,
 33804670,
 74107,
 -1,
 33833155,
 74106,
 34013705,
 33776001,
 -1,
 -65016,
 33980549,
 74094,
 -1,
 34035206,
 74093,
 34210316,
 33964227,
 -1,
 -65013,
 34191526,
 74081,
 -1,
 34255126,
 74080,
 -65011,
 34203375,
 74124,
 -65010,
 34387139,
 74109,
 -1,
 34430037,
 74626,
 34603541,
 29046799,
 -1,
 34669074,
 34542892,
 74131,
 -1,
 34604531,
 74132,
 -65005,
 34608216,
 74130,
 -65004,
 34739002,
 74129,
 -1,
 34804245,
 74128,
 34996761,
 34585567,
 74140,
 35127295,
 34930688,
 -1,
 -65000,
 35036388,
 74142,
 -1,
 35091724,
 74141,
 35258909,
 34960460,
 74135,
 35389439,
 35192832,
 -1,
 -64996,
 35309617,
 74136,
 -1,
 35337896,
 74137,
 35521056,
 35225733,
 -1,
 -64993,
 35460184,
 74139,
 -1,
 35525141,
 74138,
 35717666,
 35483787,
 74133,
 -1,
 35654262,
 74134,
 35848740,
 35656213,
 74125,
 -1,
 35783225,
 74126,
 -64987,
 35823324,
 74607,
 -1,
 35923647,
 74127,
 36110898,
 29019677,
 74154,
 36176425,
 36087938,
 74163,
 -1,
 36111698,
 74164,
 36307499,
 36140108,
 74160,
 -1,
 36242229,
 74161,
 36438573,
 36246616,
 74157,
 -1,
 36375306,
 74158,
 -64978,
 36420153,
 74165,
 -64977,
 36538664,
 74162,
 -64976,
 36574961,
 74159,
 -64975,
 36639546,
 74156,
 -1,
 36701610,
 74155,
 36897342,
 36069761,
 74144,
 36962872,
 36877655,
 -1,
 37028406,
 36922886,
 74152,
 -1,
 36963838,
 74153,
 -64969,
 36984872,
 74151,
 -1,
 37101089,
 74150,
 37290556,
 36899352,
 -1,
 37356091,
 37277213,
 74146,
 -1,
 37304335,
 74147,
 -1,
 37300013,
 74145,
 -64963,
 37259560,
 74149,
 -1,
 37500943,
 74148,
 -64961,
 36889069,
 74166,
 -1,
 37636529,
 74143,
 37814969,
 28947799,
 -1,
 37880449,
 37771304,
 -1,
 37945947,
 37839233,
 -1,
 38011473,
 37912709,
 74438,
 38141951,
 37947928,
 -1,
 38142535,
 38036756,
 74444,
 -1,
 38077237,
 74445,
 38273610,
 38086335,
 -1,
 -64951,
 38261023,
 74441,
 -1,
 38280737,
 74440,
 -64949,
 38254138,
 74449,
 -64948,
 38439017,
 74448,
 -64947,
 38502473,
 74447,
 -64946,
 38564888,
 74446,
 -64945,
 38622211,
 74443,
 -64944,
 38681474,
 74442,
 -1,
 38738228,
 74439,
 38928981,
 37988482,
 74451,
 39059455,
 38862848,
 -1,
 -64940,
 38978838,
 74452,
 -1,
 39034274,
 74453,
 39191129,
 38877199,
 74435,
 39321599,
 39127576,
 -1,
 -64936,
 39216643,
 74437,
 -1,
 39262516,
 74436,
 -64934,
 39174936,
 74454,
 -1,
 39423152,
 74450,
 39584362,
 37886260,
 74413,
 39649894,
 39523130,
 74414,
 39780351,
 39586328,
 -1,
 39780960,
 39702045,
 74421,
 -1,
 39716586,
 74422,
 -64927,
 39767183,
 74420,
 -64926,
 39893561,
 74419,
 -64925,
 39946958,
 74418,
 -64924,
 39999091,
 74417,
 -64923,
 40052525,
 74416,
 -1,
 40114484,
 74415,
 40305256,
 39589409,
 74423,
 -1,
 40241556,
 75057,
 -64919,
 40282332,
 74425,
 -1,
 40380141,
 74424,
 40567418,
 39534787,
 74426,
 40632949,
 40501248,
 -1,
 40698480,
 40608605,
 -1,
 -64914,
 40679104,
 75061,
 -64913,
 40733128,
 75060,
 -1,
 40788201,
 75059,
 40960628,
 40672665,
 75058,
 41091071,
 40894464,
 -1,
 -64909,
 41009962,
 74429,
 -1,
 41046881,
 74428,
 -1,
 40919270,
 74427,
 41288312,
 40613983,
 74432,
 -64905,
 41252218,
 74434,
 -1,
 41292309,
 74433,
 -64903,
 41257256,
 74431,
 -1,
 41440062,
 74430,
 41680895,
 40554013,
 74455,
 41681535,
 41554453,
 74457,
 41811967,
 41617123,
 -1,
 -64898,
 41697759,
 75063,
 -1,
 41762899,
 75062,
 -64896,
 41626750,
 74458,
 -1,
 41879008,
 74456,
 42074791,
 37820724,
 74387,
 42140323,
 42029810,
 74389,
 42270719,
 42074112,
 -1,
 42271391,
 42190890,
 -1,
 42336907,
 42257949,
 -1,
 -64889,
 42317919,
 74406,
 -64888,
 42379394,
 74405,
 -64887,
 42434693,
 74404,
 -64886,
 42477247,
 74403,
 -1,
 42537493,
 74402,
 42730128,
 42317143,
 -1,
 42795663,
 42686504,
 -1,
 -64882,
 42754843,
 74400,
 -1,
 42811631,
 75055,
 -1,
 42737185,
 74399,
 43057811,
 42713880,
 -1,
 -64878,
 43020506,
 75056,
 -1,
 43067071,
 74401,
 43254422,
 43020427,
 -1,
 -64875,
 43242535,
 74395,
 -1,
 43261425,
 74394,
 43451032,
 43204653,
 74391,
 -1,
 43394751,
 74392,
 -64871,
 43421699,
 74398,
 -64870,
 43549951,
 74397,
 -64869,
 43614285,
 74396,
 -64868,
 43672856,
 74646,
 -64867,
 43735102,
 74393,
 -64866,
 43796042,
 75054,
 -1,
 43850036,
 74390,
 44040865,
 42227665,
 74408,
 -1,
 43977324,
 75053,
 -64862,
 44014992,
 74407,
 -1,
 44142621,
 74388,
 44303013,
 42103884,
 74409,
 -1,
 44237794,
 74410,
 -64858,
 44279938,
 74412,
 -1,
 44403779,
 74411,
 44565168,
 42061341,
 74466,
 44630698,
 44542082,
 74473,
 -1,
 44570754,
 74474,
 44761772,
 44597381,
 74471,
 -1,
 44704855,
 74472,
 44892846,
 44709903,
 74468,
 -1,
 44831253,
 74469,
 -64849,
 44851523,
 74470,
 -1,
 44959387,
 74467,
 45219839,
 44523905,
 74459,
 45220532,
 45110002,
 74461,
 45350911,
 45159512,
 74462,
 -1,
 45221492,
 74463,
 45417143,
 45154304,
 -1,
 -64842,
 45402226,
 75064,
 -1,
 45438929,
 74460,
 -64840,
 45380770,
 74465,
 -1,
 45576396,
 74464,
 45744939,
 37763087,
 -1,
 45810420,
 45731357,
 73850,
 45875940,
 45765362,
 73857,
 45941475,
 45812248,
 -1,
 46006979,
 45904972,
 -1,
 46072514,
 45947188,
 -1,
 46138049,
 46039173,
 74911,
 -1,
 46074516,
 74912,
 -1,
 46100674,
 74910,
 -1,
 46059677,
 74913,
 46400201,
 45969547,
 -1,
 46465736,
 46386717,
 -1,
 46531271,
 46447161,
 74908,
 -1,
 46466901,
 74909,
 -1,
 46508162,
 74907,
 -1,
 46408815,
 74906,
 46793422,
 46355186,
 -1,
 46858957,
 46752129,
 74900,
 -64820,
 46839903,
 74902,
 -1,
 46901471,
 74901,
 -1,
 46799156,
 74899,
 47121106,
 46760069,
 -1,
 -64816,
 47079809,
 74916,
 -64815,
 47139209,
 74915,
 -1,
 47195223,
 74914,
 47383254,
 47061300,
 -1,
 47448789,
 47364191,
 74894,
 -1,
 47382838,
 74895,
 -1,
 47419095,
 74893,
 47645401,
 47363415,
 -1,
 -64808,
 47604102,
 74920,
 -1,
 47667893,
 74919,
 47842012,
 47601704,
 -1,
 -64805,
 47800705,
 74904,
 -1,
 47847732,
 74903,
 48038623,
 47790095,
 -1,
 -64802,
 48025982,
 74897,
 -1,
 48064109,
 74896,
 -64800,
 48013886,
 74918,
 -64799,
 48204947,
 74917,
 -64798,
 48260376,
 74905,
 -1,
 48318745,
 74898,
 -1,
 45928485,
 73858,
 48562921,
 45844776,
 73860,
 48628456,
 48501562,
 73861,
 48758783,
 48562997,
 73862,
 -1,
 48628533,
 73863,
 -1,
 48567384,
 73864,
 48890606,
 48506559,
 73854,
 48956141,
 48826904,
 -1,
 -64788,
 48937283,
 74614,
 -1,
 48974257,
 73855,
 -1,
 48894485,
 73856,
 49218290,
 48824320,
 -1,
 -64784,
 49199494,
 73853,
 -64783,
 49257594,
 73851,
 -1,
 49305553,
 73852,
 -64781,
 49195228,
 73865,
 -1,
 49436712,
 73859,
 49611550,
 45750580,
 73813,
 49677080,
 49566450,
 73814,
 49742615,
 49610752,
 -1,
 49808150,
 49705742,
 -1,
 49873662,
 49763058,
 -1,
 49939195,
 49832321,
 73821,
 -1,
 49916124,
 73822,
 50070269,
 49879348,
 73819,
 -1,
 50005896,
 73820,
 -1,
 50057253,
 73823,
 50266883,
 49837132,
 -1,
 50332418,
 50253341,
 73829,
 -64767,
 50299013,
 73831,
 -1,
 50333587,
 73830,
 -1,
 50272564,
 73828,
 50594568,
 50253341,
 -1,
 50660103,
 50533036,
 -1,
 -64762,
 50627336,
 74611,
 -1,
 50681454,
 73836,
 -1,
 50640991,
 73837,
 50922250,
 50555840,
 73825,
 -1,
 50857855,
 73826,
 51053325,
 50865855,
 -1,
 -64756,
 51011969,
 73818,
 -1,
 51060305,
 73817,
 51249936,
 50993460,
 -1,
 -64753,
 51217016,
 73816,
 -1,
 51251080,
 73815,
 -64751,
 51233691,
 73835,
 -64750,
 51427924,
 73834,
 -64749,
 51486719,
 73833,
 -64748,
 51546830,
 73832,
 -64747,
 51605808,
 73827,
 -1,
 51664958,
 73824,
 -1,
 49793083,
 74889,
 -1,
 49681210,
 74612,
 51970844,
 49653890,
 73839,
 52101119,
 51910964,
 -1,
 -64741,
 51975256,
 73841,
 -1,
 52040506,
 73840,
 -64739,
 51937413,
 73838,
 -1,
 52169397,
 74888,
 52428799,
 49570177,
 73842,
 52429606,
 52330629,
 73844,
 52495140,
 52365848,
 -1,
 -64734,
 52481640,
 74891,
 -64733,
 52541763,
 73845,
 -1,
 52585748,
 74890,
 52822015,
 52433429,
 73846,
 -1,
 52693706,
 74892,
 52888360,
 52410463,
 73849,
 -1,
 52824044,
 74613,
 53019434,
 52857128,
 73847,
 -1,
 52954033,
 73848,
 -1,
 52963007,
 73843,
 53216155,
 45731357,
 74507,
 53281641,
 53192834,
 74536,
 53347154,
 53267997,
 74551,
 53412688,
 53283352,
 -1,
 53478197,
 53367538,
 -1,
 53543732,
 53418292,
 74556,
 -64718,
 53520514,
 74559,
 -64717,
 53578090,
 74558,
 -1,
 53638220,
 74557,
 -1,
 53530141,
 74560,
 53871417,
 53464605,
 -1,
 -64713,
 53851339,
 74574,
 -64712,
 53884943,
 74573,
 -1,
 53937962,
 74572,
 54133566,
 53834828,
 -1,
 54199101,
 54119965,
 -1,
 -64708,
 54165637,
 74566,
 -1,
 54203194,
 75072,
 -1,
 54140408,
 75071,
 54461250,
 54092161,
 -1,
 -64704,
 54442079,
 74564,
 -64703,
 54493317,
 74563,
 -1,
 54547974,
 74562,
 54723397,
 54441303,
 -1,
 -64700,
 54682631,
 74570,
 -1,
 54745781,
 74569,
 54920008,
 54671375,
 -1,
 -64697,
 54907262,
 74555,
 -1,
 54927900,
 75070,
 55116618,
 54860084,
 74552,
 -1,
 55097757,
 74553,
 -64693,
 55102530,
 74571,
 -64692,
 55222057,
 74568,
 -64691,
 55281196,
 74567,
 -64690,
 55341770,
 74565,
 -64689,
 55400510,
 74561,
 -1,
 55453592,
 74554,
 55705599,
 53360798,
 74575,
 -1,
 55577281,
 74576,
 55772003,
 53285397,
 74539,
 55902207,
 55705600,
 -1,
 55903074,
 55822378,
 -1,
 55968603,
 55889437,
 -1,
 56034138,
 55906837,
 74545,
 56164351,
 55969507,
 -1,
 -64679,
 56043900,
 74547,
 -1,
 56108119,
 74546,
 -1,
 55982095,
 75069,
 56361824,
 55908660,
 -1,
 56427359,
 56297187,
 -1,
 -64674,
 56396146,
 74541,
 -1,
 56449086,
 74540,
 -1,
 56390732,
 74542,
 -64671,
 56332291,
 74544,
 -1,
 56645694,
 74543,
 -1,
 55863936,
 75068,
 56886117,
 55730561,
 74549,
 -1,
 56824634,
 74550,
 57017192,
 56819712,
 -1,
 -64665,
 56998278,
 74538,
 -1,
 57030377,
 74537,
 -1,
 56955992,
 74548,
 57279349,
 53248133,
 74525,
 57344880,
 57215512,
 -1,
 57410413,
 57312157,
 74648,
 -1,
 57345788,
 74527,
 -64658,
 57396765,
 74529,
 -64657,
 57522350,
 74528,
 -1,
 57570566,
 74526,
 57738100,
 57332004,
 74531,
 57868287,
 57674264,
 -1,
 -64653,
 57777961,
 74533,
 -1,
 57831815,
 74532,
 -1,
 57682376,
 74530,
 58065793,
 57227279,
 74515,
 58131328,
 57999360,
 -1,
 58196860,
 58116138,
 -1,
 58262394,
 58183229,
 74519,
 -1,
 58196789,
 74520,
 -64645,
 58230015,
 74518,
 -1,
 58337069,
 74517,
 58524542,
 58177926,
 74522,
 -1,
 58460704,
 74523,
 -64641,
 58487832,
 74516,
 -1,
 58611665,
 74521,
 -1,
 58118279,
 74524,
 58852234,
 58046559,
 74577,
 58917767,
 58788376,
 -1,
 58983301,
 58881009,
 74579,
 -1,
 58960002,
 74580,
 -64634,
 58966939,
 74581,
 -1,
 59054388,
 74578,
 -64632,
 58909185,
 74582,
 -64631,
 59232634,
 74584,
 -1,
 59249173,
 74583,
 59442066,
 58785792,
 -1,
 59507599,
 59416037,
 -1,
 -64627,
 59493965,
 74512,
 -64626,
 59556293,
 74511,
 -1,
 59612986,
 74510,
 59769745,
 59493917,
 74649,
 -1,
 59706114,
 74509,
 -1,
 59725757,
 74508,
 59966358,
 59434429,
 -1,
 60031893,
 59904826,
 74586,
 -1,
 59968134,
 74587,
 -1,
 60018205,
 74588,
 60228504,
 59935016,
 74534,
 -1,
 60162869,
 74535,
 -64615,
 60214388,
 74585,
 -64614,
 60303039,
 74514,
 -1,
 60363285,
 74513,
 60556283,
 53184808,
 -1,
 60621768,
 60514689,
 74316,
 60687297,
 60590376,
 74639,
 60752832,
 60635331,
 74322,
 60882943,
 60688920,
 -1,
 60883877,
 60804637,
 75050,
 -64606,
 60864607,
 74335,
 -64605,
 60929227,
 75052,
 -64604,
 60953268,
 74334,
 -1,
 61016085,
 75051,
 61211562,
 60864835,
 74330,
 61341695,
 61146858,
 -1,
 61342633,
 61257823,
 74332,
 -1,
 61277938,
 74333,
 -1,
 61276222,
 74331,
 61539248,
 61166322,
 -1,
 61604782,
 61525533,
 -1,
 -64595,
 61568076,
 75044,
 -1,
 61618191,
 74326,
 61865983,
 61563265,
 74642,
 -1,
 61782111,
 75043,
 61932468,
 61479220,
 -1,
 61998003,
 61913183,
 74324,
 -1,
 61933298,
 74325,
 -1,
 61966632,
 74323,
 62194615,
 61901096,
 -1,
 -64586,
 62181758,
 74329,
 -1,
 62210243,
 74328,
 62391226,
 62161029,
 -1,
 -64583,
 62341479,
 74327,
 -1,
 62399575,
 75048,
 -64581,
 62365695,
 75049,
 -64580,
 62551391,
 75047,
 -64579,
 62616139,
 75046,
 -64578,
 62676044,
 75045,
 -64577,
 62733172,
 75042,
 -1,
 62793547,
 74641,
 -1,
 60692610,
 74640,
 63046597,
 60653701,
 74319,
 63176703,
 62982737,
 -1,
 -64572,
 63088793,
 74321,
 -1,
 63146346,
 74320,
 -64570,
 63026726,
 74336,
 -64569,
 63246869,
 74318,
 -1,
 63310396,
 74317,
 63505385,
 60608029,
 74337,
 63570916,
 63473960,
 74339,
 63636441,
 63559157,
 74349,
 63766527,
 63569920,
 -1,
 63767511,
 63642138,
 -1,
 -64562,
 63753893,
 74359,
 -64561,
 63814409,
 74358,
 -64560,
 63867598,
 74357,
 -64559,
 63927446,
 74356,
 -64558,
 63992088,
 74355,
 -64557,
 64054552,
 74354,
 -64556,
 64116669,
 74353,
 -64555,
 64176207,
 74352,
 -64554,
 64235900,
 74351,
 -1,
 64300128,
 74350,
 64552959,
 63730460,
 74360,
 -1,
 64424706,
 74361,
 64684031,
 63569920,
 -1,
 64685024,
 64582968,
 -1,
 64750557,
 64665146,
 74342,
 -1,
 64685658,
 74343,
 -64546,
 64738615,
 74344,
 -64545,
 64848648,
 74341,
 -1,
 64902147,
 74340,
 65078242,
 64632528,
 74347,
 -1,
 65012724,
 74348,
 -64541,
 65062166,
 74345,
 -1,
 65183073,
 74346,
 65404927,
 63508976,
 74338,
 65470463,
 65273856,
 -1,
 -64537,
 65389846,
 983260,
 -64536,
 65450957,
 74643,
 -1,
 65510730,
 983261,
 65668085,
 63445300,
 74302,
 65733616,
 65622849,
 74304,
 65799151,
 65667072,
 -1,
 -64531,
 65783907,
 74306,
 -64530,
 65837091,
 74307,
 -1,
 65890944,
 74305,
 -1,
 65775746,
 74308,
 66126835,
 65699973,
 74310,
 -64526,
 66064917,
 74311,
 -1,
 66127083,
 74309,
 -64524,
 66065496,
 74638,
 -1,
 66261525,
 74303,
 66519039,
 65618115,
 74312,
 66584575,
 66387968,
 -1,
 66585594,
 66504746,
 -1,
 -64519,
 66572325,
 74314,
 -1,
 66591028,
 74313,
 -1,
 66566534,
 74315,
 66847826,
 60496180,
 73728,
 66913304,
 66791103,
 73738,
 66978832,
 66846720,
 -1,
 67044367,
 66963498,
 -1,
 67109890,
 67024991,
 -1,
 -64511,
 67096229,
 74881,
 -1,
 67127725,
 73747,
 67306500,
 67080195,
 74608,
 -1,
 67242388,
 74880,
 67437575,
 67264897,
 -1,
 -64506,
 67405356,
 73745,
 -1,
 67458569,
 73744,
 67634186,
 67392321,
 -1,
 -64503,
 67602794,
 73742,
 -1,
 67662924,
 73741,
 -64501,
 67620413,
 73748,
 -64500,
 67794182,
 73746,
 -64499,
 67852350,
 73743,
 -64498,
 67911776,
 73740,
 -1,
 67970139,
 73739,
 -1,
 67000273,
 73749,
 68288511,
 66916885,
 73750,
 68354047,
 68160024,
 -1,
 -64493,
 68273051,
 73755,
 -64492,
 68335790,
 73754,
 -64491,
 68387753,
 73753,
 -64490,
 68441040,
 73752,
 -64489,
 68495183,
 73751,
 -1,
 68557108,
 74609,
 68748325,
 66876492,
 73760,
 68813859,
 68684312,
 -1,
 68879389,
 68776075,
 -1,
 -64484,
 68837761,
 73766,
 -1,
 68885401,
 73765,
 -64482,
 68867383,
 73768,
 -64481,
 69056835,
 73767,
 -64480,
 69097534,
 73764,
 -64479,
 69162611,
 73763,
 -64478,
 69221245,
 73762,
 -1,
 69279265,
 73761,
 -64476,
 68765738,
 73770,
 -1,
 69410744,
 73769,
 69600305,
 68728151,
 -1,
 69665840,
 69556264,
 73784,
 69731374,
 69599232,
 -1,
 69796908,
 69704807,
 -1,
 69862443,
 69770334,
 73788,
 -1,
 69796349,
 73789,
 -1,
 69848142,
 73787,
 -64467,
 69789426,
 73785,
 -1,
 70021386,
 73786,
 -64465,
 69686105,
 73791,
 -1,
 70128149,
 73790,
 -1,
 69606984,
 73783,
 70386746,
 69536280,
 -1,
 -64461,
 70366758,
 73736,
 -64460,
 70420715,
 73735,
 -64459,
 70481197,
 73734,
 -64458,
 70542612,
 73733,
 -64457,
 70604862,
 73732,
 -64456,
 70669264,
 73731,
 -64455,
 70723373,
 73730,
 -1,
 70785332,
 73729,
 70976578,
 70355240,
 73773,
 71042113,
 70909952,
 -1,
 71107647,
 71017356,
 -1,
 -64450,
 71089765,
 73777,
 -1,
 71145448,
 73776,
 -64448,
 71091961,
 73775,
 -1,
 71277654,
 73774,
 -1,
 71022915,
 73778,
 71500870,
 70953090,
 -1,
 71566405,
 71441269,
 73780,
 -1,
 71502484,
 73781,
 -1,
 71528710,
 73782,
 71763018,
 71467640,
 73771,
 71892991,
 71698968,
 -1,
 -64439,
 71809347,
 73772,
 -1,
 71857148,
 74610,
 72025166,
 71725195,
 73757,
 72155135,
 71961112,
 -1,
 -64435,
 72071616,
 73759,
 -1,
 72108313,
 73758,
 72287312,
 71972879,
 73756,
 -1,
 72223301,
 74882,
 -64431,
 72262282,
 73779,
 -1,
 72356373,
 73737,
 72549529,
 66797763,
 73866,
 72615033,
 72541808,
 73889,
 72744959,
 72548352,
 -1,
 72746096,
 72665130,
 -1,
 72811611,
 72709196,
 -1,
 72877145,
 72751412,
 73903,
 -1,
 72840298,
 73904,
 -64422,
 72863261,
 73906,
 -1,
 72966529,
 73905,
 73139295,
 72751412,
 73890,
 73204830,
 73074549,
 73891,
 -1,
 73140895,
 73892,
 -1,
 73173288,
 73893,
 73401443,
 73101451,
 -1,
 73466978,
 73344111,
 73900,
 -1,
 73402678,
 73901,
 -1,
 73453235,
 73902,
 73663590,
 73387549,
 -1,
 -64411,
 73611279,
 73908,
 -1,
 73667093,
 73907,
 73860201,
 73643351,
 -1,
 -64408,
 73846301,
 74933,
 -1,
 73882293,
 74616,
 74056811,
 73816126,
 73897,
 -1,
 73990965,
 73898,
 74187885,
 74006624,
 73895,
 -1,
 74122037,
 73896,
 -64402,
 74147096,
 73899,
 -64401,
 74274749,
 74615,
 -1,
 74327853,
 73894,
 74579967,
 72726926,
 -1,
 74581107,
 74482589,
 74930,
 -1,
 74560855,
 74931,
 74712181,
 74544278,
 74928,
 -1,
 74675276,
 74929,
 -64394,
 74695016,
 74932,
 -64393,
 74802456,
 74927,
 -64392,
 74865740,
 74926,
 -1,
 74916951,
 74925,
 75105412,
 72552981,
 73869,
 75235327,
 75041304,
 -1,
 75236478,
 75150679,
 -1,
 -64387,
 75193013,
 73874,
 -1,
 75243041,
 73873,
 -64385,
 75222557,
 73875,
 -64384,
 75407332,
 74922,
 -64383,
 75465983,
 73872,
 -64382,
 75527188,
 74921,
 -64381,
 75584515,
 73871,
 -1,
 75635044,
 73870,
 75826317,
 75073832,
 73879,
 75956223,
 75759616,
 -1,
 75957386,
 75876394,
 -1,
 76022921,
 75912139,
 73880,
 -1,
 75958676,
 73881,
 -1,
 75989917,
 73882,
 -64373,
 75939429,
 73885,
 -64372,
 76191742,
 73884,
 -1,
 76232269,
 73883,
 76416145,
 75802754,
 -1,
 76481680,
 76375701,
 73887,
 -1,
 76418650,
 74923,
 -1,
 76432970,
 73886,
 76678291,
 76396710,
 73888,
 -1,
 76612125,
 74924,
 76809366,
 76611584,
 -1,
 -64363,
 76793935,
 73867,
 -1,
 76848258,
 73868,
 -64361,
 76772428,
 73878,
 -64360,
 76961386,
 73877,
 -1,
 77020034,
 73876,
 77202629,
 72532626,
 -1,
 77268145,
 77142324,
 74475,
 77333668,
 77222642,
 74483,
 77463551,
 77269528,
 -1,
 77464736,
 77379679,
 -1,
 -64353,
 77450781,
 74487,
 -1,
 77480131,
 74486,
 -64351,
 77451301,
 74489,
 -64350,
 77646921,
 74488,
 -64349,
 77682621,
 74485,
 -1,
 77736316,
 74484,
 77923498,
 77266944,
 -1,
 77989032,
 77908010,
 -1,
 -64345,
 77956351,
 74478,
 -1,
 78011468,
 74477,
 -64343,
 77944785,
 74479,
 -1,
 78128301,
 74476,
 78316718,
 77866687,
 74480,
 78446591,
 78249984,
 -1,
 -64339,
 78364261,
 74482,
 -1,
 78421433,
 74481,
 78578864,
 78278874,
 74490,
 -1,
 78514128,
 75065,
 -1,
 78555266,
 74491,
 78775482,
 77254173,
 74501,
 78841014,
 78741637,
 74504,
 78970879,
 78776856,
 -1,
 -64331,
 78890640,
 75067,
 -1,
 78926800,
 75066,
 79103160,
 78817410,
 74505,
 -1,
 79038116,
 74506,
 -64327,
 79065227,
 74503,
 -1,
 79188792,
 74502,
 79365315,
 78733697,
 74494,
 79430848,
 79341698,
 74497,
 79560703,
 79364096,
 -1,
 79561919,
 79470044,
 74499,
 -1,
 79495942,
 74500,
 -1,
 79546482,
 74498,
 -64319,
 79393868,
 74496,
 -64318,
 79696405,
 74647,
 -1,
 79759764,
 74495,
 80019455,
 79315139,
 74492,
 -1,
 79889205,
 74493,
 80086255,
 77168773,
 -1,
 80151776,
 80072221,
 74284,
 80217307,
 80132191,
 74290,
 80282835,
 80150528,
 -1,
 80348366,
 80256320,
 74294,
 80478207,
 80284184,
 -1,
 -64308,
 80376112,
 75041,
 -64307,
 80433985,
 75040,
 -1,
 80484748,
 74295,
 80676050,
 80332842,
 -1,
 -64304,
 80668109,
 74293,
 -64303,
 80704532,
 74292,
 -1,
 80746804,
 74291,
 -1,
 80623298,
 74296,
 81068031,
 80220986,
 74297,
 81133567,
 80936960,
 -1,
 81134810,
 81053738,
 -1,
 81200344,
 81074484,
 74298,
 -1,
 81135365,
 74299,
 -64295,
 81192397,
 74637,
 -1,
 81279678,
 74300,
 -1,
 81090513,
 74301,
 81528029,
 80171762,
 74286,
 -1,
 81462069,
 74287,
 -64290,
 81505852,
 74289,
 -64289,
 81628926,
 74288,
 -1,
 81659463,
 74285,
 81855721,
 80091444,
 74272,
 81921251,
 81836127,
 74278,
 -1,
 81859093,
 74279,
 82052326,
 81854464,
 -1,
 -64283,
 82036850,
 74273,
 -1,
 82073553,
 74274,
 -64281,
 82028674,
 74277,
 -64280,
 82204712,
 74276,
 -1,
 82252309,
 74275,
 82445548,
 81813889,
 74282,
 -64277,
 82413864,
 74283,
 -1,
 82446365,
 75039,
 82706431,
 82395331,
 74280,
 82771967,
 82621783,
 74281,
 -1,
 82663464,
 74636,
 82838798,
 80029375,
 -1,
 82904318,
 82778420,
 73792,
 82969846,
 82860593,
 73795,
 83099647,
 82905624,
 -1,
 -64268,
 83027405,
 74886,
 -64267,
 83070099,
 74885,
 -1,
 83106326,
 74884,
 83297529,
 82932812,
 73796,
 -64264,
 83238040,
 73798,
 -1,
 83297642,
 73797,
 83494139,
 83273858,
 73799,
 -1,
 83433954,
 73800,
 83625213,
 83441679,
 73793,
 -1,
 83561003,
 74883,
 -1,
 83579707,
 73794,
 83821833,
 82890269,
 73805,
 83887365,
 83755008,
 -1,
 83952900,
 83860593,
 -1,
 -64254,
 83939710,
 73807,
 -64253,
 84002885,
 74887,
 -1,
 84023827,
 73806,
 -1,
 83899969,
 73808,
 84280583,
 83863682,
 73811,
 -1,
 84218389,
 73812,
 84475903,
 84246597,
 73809,
 -1,
 84346228,
 73810,
 84606975,
 83779969,
 73801,
 84672511,
 84478488,
 -1,
 -64244,
 84567320,
 73804,
 -64243,
 84628483,
 73803,
 -1,
 84678964,
 73802,
 84870443,
 82794536,
 -1,
 84935963,
 84828545,
 74029,
 85065727,
 84871704,
 -1,
 85067028,
 84943959,
 74030,
 -64237,
 85004821,
 74031,
 -1,
 85067159,
 74959,
 -64235,
 85052957,
 74038,
 -64234,
 85244227,
 74037,
 -64233,
 85299203,
 74036,
 -64232,
 85357281,
 74035,
 -64231,
 85414749,
 74034,
 -64230,
 85474253,
 74033,
 -1,
 85534509,
 74032,
 85722405,
 84921885,
 74039,
 85787939,
 85665493,
 74040,
 85917695,
 85723672,
 -1,
 -64225,
 85839909,
 74045,
 -64224,
 85884100,
 74044,
 -64223,
 85946759,
 74043,
 -64222,
 86005955,
 74042,
 -1,
 86056888,
 74041,
 -64220,
 85768287,
 74621,
 -1,
 86209683,
 74046,
 86441983,
 85662004,
 74025,
 86443306,
 86310912,
 -1,
 86508841,
 86426902,
 74026,
 -1,
 86442805,
 74958,
 -1,
 86464465,
 74027,
 -1,
 86406220,
 74028,
 86771014,
 84828545,
 74047,
 86836531,
 86737029,
 74062,
 86902066,
 86769664,
 -1,
 -64209,
 86886514,
 74063,
 -64208,
 86949477,
 74066,
 -64207,
 87005194,
 74065,
 -1,
 87045788,
 74064,
 -1,
 86861421,
 74067,
 87295290,
 86790898,
 74053,
 87425023,
 87253377,
 74054,
 87490559,
 87293952,
 -1,
 -64201,
 87404124,
 74056,
 -64200,
 87465153,
 74057,
 -64199,
 87513041,
 74058,
 -1,
 87571258,
 74055,
 87754045,
 87258188,
 74059,
 -64196,
 87691797,
 74061,
 -1,
 87755355,
 74060,
 87950657,
 87702384,
 74050,
 88080383,
 87885268,
 -1,
 -64192,
 87998053,
 74052,
 -1,
 88026238,
 74051,
 -64190,
 87930975,
 74070,
 -64189,
 88189058,
 74069,
 -64188,
 88246568,
 74068,
 -64187,
 88286911,
 74049,
 -1,
 88342530,
 74048,
 88540516,
 86744781,
 -1,
 88606046,
 88498561,
 74367,
 88671573,
 88539136,
 -1,
 88737108,
 88655914,
 -1,
 88802636,
 88722973,
 74375,
 -1,
 88740373,
 74376,
 88933710,
 88760705,
 74373,
 -1,
 88876735,
 74374,
 89064785,
 88876735,
 -1,
 -64176,
 89050653,
 74371,
 -1,
 89088385,
 74370,
 89261395,
 89004340,
 74368,
 -1,
 89204415,
 74369,
 -1,
 89211075,
 74372,
 -1,
 88684253,
 74377,
 89587711,
 88647810,
 -1,
 89589085,
 89482237,
 74378,
 89718783,
 89522176,
 -1,
 89720156,
 89638954,
 -1,
 -64166,
 89712077,
 74381,
 -64165,
 89772069,
 74380,
 -1,
 89813305,
 74379,
 -1,
 89692209,
 74382,
 -1,
 89526805,
 74645,
 90113378,
 88545588,
 74362,
 -64160,
 90087117,
 74365,
 -64159,
 90147112,
 74364,
 -1,
 90191887,
 74363,
 90439679,
 90065329,
 74366,
 -1,
 90308899,
 74644,
 90506620,
 88532413,
 -1,
 90572141,
 90492445,
 74602,
 90637674,
 90510636,
 74603,
 90767359,
 90573336,
 -1,
 -64151,
 90687131,
 75075,
 -1,
 90708276,
 74604,
 -64149,
 90603653,
 74606,
 -64148,
 90844286,
 74605,
 -1,
 90900162,
 75074,
 91096436,
 90530177,
 74595,
 91161968,
 91039423,
 74598,
 -1,
 91095967,
 74599,
 -64143,
 91153866,
 74601,
 -64142,
 91247346,
 74600,
 -64141,
 91296570,
 74597,
 -1,
 91358905,
 74596,
 91555195,
 91035956,
 74589,
 91620728,
 91488256,
 -1,
 -64137,
 91604246,
 74590,
 -1,
 91668086,
 74591,
 -64135,
 91588876,
 74593,
 -64134,
 91771634,
 74592,
 -1,
 91821809,
 75073,
 -1,
 91505116,
 74594,
 92143615,
 90482818,
 -1,
 92145023,
 92018996,
 74383,
 -1,
 92087999,
 74384,
 -64128,
 92130845,
 74386,
 -1,
 92234113,
 74385,
 92407324,
 233461,
 -1,
 92472746,
 92359911,
 -1,
 92538264,
 92445471,
 -1,
 92603785,
 92526243,
 74812,
 92669320,
 92536832,
 -1,
 -64121,
 92612287,
 74815,
 -1,
 92674356,
 74814,
 -1,
 92607576,
 74813,
 92931469,
 92546751,
 -1,
 92997004,
 92872658,
 74834,
 -1,
 92932874,
 74835,
 -1,
 92984561,
 74808,
 93193615,
 92917277,
 74767,
 -1,
 93129482,
 74857,
 93324690,
 93174060,
 -1,
 -64111,
 93310493,
 74800,
 -1,
 93327893,
 74790,
 93521301,
 93279510,
 -1,
 -64108,
 93507101,
 74785,
 -1,
 93524501,
 74776,
 93717911,
 93463639,
 74754,
 -1,
 93653396,
 74828,
 -1,
 93666253,
 74761,
 93978623,
 92499492,
 -1,
 93980062,
 93893975,
 -1,
 94045597,
 93936173,
 -1,
 -64100,
 94031389,
 74801,
 -1,
 94048789,
 74791,
 -1,
 94007055,
 74844,
 94307746,
 93923007,
 -1,
 94373281,
 94248914,
 74836,
 -1,
 94309130,
 74837,
 -1,
 94360817,
 74809,
 94569892,
 94293533,
 74768,
 -1,
 94505738,
 74858,
 94700967,
 94524694,
 -1,
 -64090,
 94686749,
 74786,
 -1,
 94704149,
 74777,
 94897577,
 94643287,
 74755,
 -1,
 94833044,
 74829,
 -1,
 94845901,
 74762,
 95094222,
 92455570,
 -1,
 95159742,
 95051734,
 -1,
 95225265,
 95140140,
 -1,
 95290799,
 95211037,
 74798,
 -1,
 95226634,
 74799,
 95485951,
 95228437,
 74788,
 -1,
 95357706,
 74789,
 95552949,
 95168191,
 -1,
 95618484,
 95540465,
 74806,
 -1,
 95554314,
 74807,
 -1,
 95559634,
 74833,
 95815096,
 95540844,
 -1,
 -64073,
 95752977,
 74811,
 -1,
 95818239,
 74810,
 96011707,
 95769878,
 -1,
 -64070,
 95997469,
 74784,
 -1,
 96014869,
 74775,
 96208317,
 95954007,
 74753,
 -1,
 96143764,
 74827,
 -1,
 96156621,
 74760,
 96468991,
 95150099,
 -1,
 96470466,
 96388677,
 -1,
 -64063,
 96458315,
 74846,
 -1,
 96484301,
 74843,
 96667077,
 96450860,
 -1,
 -64060,
 96652829,
 74797,
 -1,
 96670229,
 74787,
 96863688,
 96621846,
 -1,
 -64057,
 96849437,
 74783,
 -1,
 96866837,
 74774,
 97060299,
 96806591,
 -1,
 -64054,
 97047793,
 74805,
 -1,
 97066962,
 74832,
 97256909,
 97002583,
 74752,
 -1,
 97192340,
 74826,
 -1,
 97208758,
 74841,
 97453543,
 95073623,
 -1,
 97519067,
 97405680,
 -1,
 97584597,
 97506961,
 -1,
 97650132,
 97517568,
 -1,
 -64045,
 97593023,
 74819,
 -1,
 97655092,
 74818,
 -1,
 97588026,
 74817,
 97912279,
 97570333,
 74770,
 -1,
 97848074,
 74860,
 -64040,
 97892657,
 74793,
 -64039,
 97998107,
 74779,
 -64038,
 98057165,
 74764,
 -1,
 98116695,
 74757,
 98305508,
 97480405,
 -1,
 98371038,
 98291229,
 74769,
 -1,
 98306826,
 74859,
 98502112,
 98313303,
 74756,
 -1,
 98437524,
 74830,
 -64031,
 98489946,
 74816,
 -64030,
 98613553,
 74792,
 -64029,
 98653467,
 74778,
 -1,
 98712525,
 74763,
 98959359,
 98261558,
 -1,
 -64026,
 98862636,
 74803,
 -1,
 98909133,
 74802,
 99091965,
 97423505,
 -1,
 99157498,
 99060433,
 -1,
 99223020,
 99141168,
 -1,
 -64021,
 99210827,
 74845,
 -1,
 99236813,
 74842,
 99419631,
 99198898,
 -1,
 -64018,
 99375077,
 74851,
 -1,
 99427415,
 74848,
 99616242,
 99374358,
 -1,
 -64015,
 99601949,
 74782,
 -1,
 99619349,
 74773,
 99812853,
 99565763,
 -1,
 -64012,
 99793223,
 74840,
 -1,
 99837177,
 74847,
 100009464,
 99755711,
 -1,
 -64009,
 99996913,
 74804,
 -1,
 100016082,
 74831,
 -64007,
 99989821,
 74796,
 -1,
 100161804,
 74852,
 100401151,
 99120890,
 -1,
 -64004,
 100318146,
 74849,
 -1,
 100378538,
 74850,
 100533772,
 99060883,
 -1,
 100599305,
 100502225,
 -1,
 100664835,
 100587133,
 74822,
 -63999,
 100602968,
 74824,
 -63998,
 100668218,
 74823,
 -1,
 100728834,
 74825,
 100926981,
 100650525,
 74772,
 -1,
 100862730,
 74862,
 -63994,
 100907313,
 74795,
 -63993,
 101012763,
 74781,
 -63992,
 101071821,
 74766,
 -1,
 101131351,
 74759,
 101384191,
 100554284,
 -1,
 -63989,
 101287468,
 74838,
 -1,
 101337517,
 74839,
 101580799,
 100483267,
 -1,
 101582358,
 101475473,
 -1,
 101647888,
 101570230,
 74820,
 -1,
 101585722,
 74821,
 101778962,
 101633565,
 74771,
 -1,
 101714698,
 74861,
 -63981,
 101759281,
 74794,
 -63980,
 101864731,
 74780,
 -63979,
 101923789,
 74765,
 -1,
 101983319,
 74758,
 102236159,
 101545370,
 -1,
 102237722,
 102124775,
 -1,
 -63975,
 102209902,
 74855,
 -1,
 102261731,
 74856,
 -63973,
 102223350,
 74854,
 -1,
 102405439,
 74853,
 102629375,
 92382852,
 -1,
 102630945,
 102513402,
 -1,
 -63969,
 102615878,
 74867,
 -63968,
 102672207,
 74868,
 -1,
 102708085,
 74866,
 -63966,
 102619156,
 74865,
 -1,
 102863608,
 74864,
 103024170,
 174210,
 -1,
 103089703,
 103000194,
 -1,
 -63962,
 103080721,
 127835,
 -1,
 103106249,
 128177,
 103350271,
 103052364,
 -1,
 -63959,
 103277365,
 10160,
 -1,
 103311577,
 129356,
 103482928,
 102997709,
 -1,
 103548462,
 103415808,
 -1,
 -63955,
 103538499,
 129380,
 -1,
 103584795,
 9982,
 -63953,
 103506813,
 11232,
 -1,
 103689550,
 129473,
 103876147,
 103464759,
 -1,
 -63950,
 103846928,
 128707,
 -1,
 103883397,
 127854,
 -63948,
 103858930,
 129385,
 -1,
 104019805,
 129362,
 104204434,
 102545,
 -1,
 104269701,
 104169605,
 -1,
 104335234,
 104212946,
 -1,
 104400518,
 104289010,
 -1,
 104466027,
 104363333,
 -1,
 104531523,
 104456972,
 -1,
 104597056,
 104480963,
 -1,
 104662591,
 104573058,
 -1,
 -63938,
 104648221,
 122911,
 -1,
 104685953,
 122912,
 -1,
 104644947,
 122885,
 -63935,
 104582685,
 122915,
 -63934,
 104894609,
 122918,
 -1,
 104932706,
 122913,
 105121353,
 104489345,
 122891,
 105186887,
 105093609,
 -1,
 -63930,
 105168150,
 122919,
 -1,
 105195948,
 122921,
 -63928,
 105178859,
 122889,
 -1,
 105352530,
 122890,
 105514575,
 105100631,
 -1,
 105580109,
 105469992,
 -1,
 -63924,
 105562904,
 122907,
 -1,
 105584948,
 122910,
 -63922,
 105546258,
 122916,
 -1,
 105742015,
 122900,
 105907794,
 105506237,
 -1,
 -63919,
 105864667,
 122886,
 -1,
 105924144,
 122888,
 106104405,
 105890450,
 -1,
 -63916,
 106093253,
 122901,
 -1,
 106150484,
 122908,
 106301016,
 106056935,
 -1,
 -63913,
 106279600,
 122903,
 -1,
 106327394,
 122922,
 106497627,
 106248207,
 -1,
 -63910,
 106467617,
 122884,
 -1,
 106524650,
 122892,
 106694238,
 106440383,
 -1,
 -63907,
 106680542,
 122881,
 -1,
 106718208,
 122920,
 -63905,
 106682144,
 122882,
 -63904,
 106877141,
 122902,
 -63903,
 106934954,
 122899,
 -63902,
 106996852,
 122898,
 -63901,
 107058798,
 122897,
 -63900,
 107121145,
 122896,
 -63899,
 107186464,
 122895,
 -63898,
 107248904,
 122894,
 -63897,
 107311412,
 122893,
 -63896,
 107371498,
 122904,
 -63895,
 107435662,
 122883,
 -63894,
 107491481,
 122909,
 -1,
 107554491,
 122880,
 107806719,
 104441986,
 -1,
 107808385,
 107682100,
 -1,
 107873918,
 107777899,
 -1,
 107939448,
 107821918,
 -1,
 108004978,
 107922066,
 -1,
 -63887,
 107995152,
 70504,
 -1,
 108027857,
 70505,
 108201589,
 107957479,
 -1,
 -63884,
 108174107,
 70506,
 -1,
 108228128,
 70507,
 -63882,
 108193418,
 70502,
 -63881,
 108379026,
 70508,
 -1,
 108434607,
 70503,
 108658687,
 107903627,
 -1,
 -63878,
 108583146,
 70515,
 -63877,
 108633897,
 70516,
 -63876,
 108693874,
 70514,
 -63875,
 108753117,
 70513,
 -1,
 108796212,
 70512,
 109051903,
 107861788,
 -1,
 -63872,
 108953860,
 7621,
 -1,
 108993385,
 7624,
 109248511,
 107758538,
 -1,
 109250181,
 109167250,
 -1,
 -63868,
 109228632,
 119362,
 -1,
 109267467,
 119363,
 -1,
 109224338,
 119364,
 109512394,
 104344804,
 -1,
 109577928,
 109503908,
 -1,
 109643452,
 109542027,
 -1,
 109708945,
 109592771,
 -1,
 109774476,
 109688151,
 11757,
 -1,
 109711304,
 11765,
 -63859,
 109750402,
 11756,
 -63858,
 109873448,
 11753,
 -63857,
 109936773,
 11752,
 -63856,
 109999180,
 11751,
 -1,
 110054631,
 42654,
 110233239,
 109666689,
 42613,
 110298774,
 110205473,
 -1,
 -63852,
 110248131,
 42655,
 -63851,
 110307756,
 11775,
 -1,
 110369076,
 11772,
 -1,
 110248131,
 11767,
 110626460,
 110224140,
 -1,
 -63847,
 110611997,
 11771,
 -63846,
 110649729,
 42614,
 -63845,
 110709107,
 42617,
 -1,
 110765238,
 11770,
 110954145,
 110605655,
 -1,
 111019680,
 110909480,
 -1,
 -63841,
 110964644,
 11763,
 -1,
 111024436,
 11762,
 -1,
 110989836,
 42618,
 111281828,
 110945725,
 -1,
 -63837,
 111237813,
 11748,
 -1,
 111296707,
 11749,
 111478438,
 111267357,
 42615,
 -1,
 111440836,
 42612,
 111609513,
 111461010,
 -1,
 -63832,
 111589177,
 11760,
 -1,
 111624387,
 11758,
 111806123,
 111579281,
 11754,
 -1,
 111772767,
 42619,
 111937197,
 111761470,
 11759,
 -1,
 111913752,
 42616,
 112068272,
 111884303,
 -1,
 -63825,
 112029669,
 11768,
 -1,
 112083139,
 11747,
 112264883,
 112010943,
 -1,
 -63822,
 112223232,
 11774,
 -1,
 112279747,
 11744,
 -63820,
 112252643,
 11745,
 -63819,
 112435412,
 11755,
 -63818,
 112494467,
 11769,
 -63817,
 112557294,
 11773,
 -63816,
 112619741,
 11750,
 -63815,
 112678276,
 11746,
 -63814,
 112742265,
 11764,
 -63813,
 112799726,
 11761,
 -1,
 112859444,
 11766,
 113051330,
 109626002,
 -1,
 113116864,
 113012214,
 -1,
 -63809,
 113094431,
 65071,
 -1,
 113145918,
 65070,
 -63807,
 113074078,
 42610,
 -1,
 113264217,
 42608,
 113444549,
 113024717,
 -1,
 -63804,
 113414876,
 1159,
 -1,
 113452715,
 42621,
 -63802,
 113433310,
 42607,
 -63801,
 113603026,
 42620,
 -1,
 113664271,
 42609,
 113901567,
 109549067,
 65062,
 -1,
 113770856,
 65069,
 113968901,
 109474892,
 -1,
 114034422,
 113911142,
 -1,
 114099952,
 114015368,
 -1,
 114165459,
 114039092,
 -1,
 -63793,
 114152952,
 7638,
 -63792,
 114200721,
 7637,
 -63791,
 114261922,
 7655,
 -63790,
 114311363,
 7636,
 -1,
 114363330,
 7666,
 114558678,
 114127948,
 7645,
 -63787,
 114529711,
 7653,
 -1,
 114560014,
 7660,
 114755289,
 114544238,
 -1,
 -63784,
 114719708,
 7664,
 -1,
 114768601,
 7668,
 114951899,
 114734423,
 7652,
 -1,
 114897095,
 7658,
 115082974,
 114927748,
 -1,
 -63779,
 115061751,
 7651,
 -1,
 115091630,
 7626,
 115279585,
 115052728,
 -1,
 -63776,
 115243996,
 7661,
 -1,
 115292889,
 7667,
 115476195,
 115231975,
 7659,
 -1,
 115439277,
 7635,
 115607270,
 115425475,
 -1,
 -63771,
 115590553,
 7641,
 -1,
 115652703,
 7663,
 115803880,
 115549887,
 7656,
 -1,
 115755496,
 7657,
 -63767,
 115795389,
 7654,
 -63766,
 115923684,
 7665,
 -63765,
 115973837,
 7662,
 -63764,
 116033832,
 7648,
 -63763,
 116093067,
 7644,
 -63762,
 116156958,
 7640,
 -63761,
 116216562,
 7642,
 -1,
 116272361,
 7639,
 116523007,
 114064067,
 -1,
 -63758,
 116435074,
 7650,
 -63757,
 116492584,
 7649,
 -63756,
 116555909,
 7647,
 -63755,
 116618316,
 7646,
 -1,
 116675314,
 7643,
 116852479,
 113984602,
 -1,
 116918014,
 116785152,
 -1,
 116983549,
 116859762,
 -1,
 117049084,
 116939461,
 -1,
 -63749,
 116992174,
 852,
 -1,
 117054064,
 7678,
 -1,
 116982120,
 8430,
 -1,
 116939039,
 849,
 -1,
 116906958,
 8429,
 117442308,
 116810749,
 -1,
 117507843,
 117384629,
 -1,
 -63742,
 117485354,
 65064,
 -1,
 117536840,
 65063,
 -1,
 117465287,
 6841,
 -1,
 117413258,
 8427,
 117835574,
 113915919,
 -1,
 117901088,
 117784771,
 -1,
 117966623,
 117888553,
 -1,
 118032150,
 117914462,
 -1,
 118097676,
 118014610,
 -1,
 -63733,
 118087696,
 43234,
 -1,
 118120401,
 43235,
 118294287,
 118076759,
 -1,
 -63730,
 118255314,
 43238,
 -1,
 118311659,
 43239,
 118490898,
 118246631,
 -1,
 -63727,
 118463259,
 43236,
 -1,
 118517280,
 43237,
 -63725,
 118482570,
 43232,
 -63724,
 118658223,
 43233,
 -63723,
 118721752,
 43241,
 -1,
 118768909,
 43240,
 118949662,
 117996171,
 -1,
 -63720,
 118937834,
 43248,
 -63719,
 119000605,
 43243,
 -63718,
 119056629,
 43247,
 -63717,
 119119657,
 43246,
 -63716,
 119179634,
 43245,
 -63715,
 119238877,
 43244,
 -1,
 119281972,
 43242,
 -1,
 118930127,
 43249,
 -1,
 117930616,
 7675,
 119605045,
 117870737,
 -1,
 119670573,
 119590734,
 -1,
 119736108,
 119603200,
 -1,
 119801637,
 119701764,
 862,
 -1,
 119734632,
 863,
 119932711,
 119745495,
 861,
 -1,
 119865704,
 860,
 -63704,
 119910705,
 858,
 -63703,
 120037466,
 6844,
 -63702,
 120100732,
 6840,
 -63701,
 120154786,
 7676,
 -1,
 120205755,
 7629,
 -1,
 119683101,
 6832,
 120457012,
 119653010,
 -1,
 120522545,
 120439935,
 -1,
 -63696,
 120477513,
 7616,
 -1,
 120527708,
 7617,
 120782847,
 120455180,
 -1,
 -63693,
 120696582,
 856,
 -1,
 120748072,
 7672,
 -1,
 120446958,
 6835,
 -1,
 119562759,
 6833,
 121046851,
 117812998,
 -1,
 121112386,
 120979456,
 -1,
 121177921,
 121054066,
 -1,
 121243456,
 121133765,
 -1,
 121308991,
 121182516,
 -1,
 121374526,
 121277004,
 -1,
 -63683,
 121361061,
 854,
 -1,
 121388750,
 7679,
 -1,
 121318287,
 848,
 -1,
 121252014,
 853,
 -1,
 121176424,
 8431,
 -1,
 121133343,
 855,
 -1,
 121101262,
 8428,
 121898828,
 121016465,
 -1,
 121964362,
 121861906,
 -1,
 -63674,
 121955928,
 66424,
 -63673,
 122010368,
 66426,
 -63672,
 122063739,
 66425,
 -63671,
 122108957,
 66423,
 -1,
 122167224,
 66422,
 -63669,
 121938237,
 6839,
 -1,
 122312419,
 7630,
 122488662,
 121864452,
 -1,
 122554194,
 122421248,
 -1,
 122619728,
 122531615,
 65061,
 -1,
 122552680,
 65068,
 122814463,
 122583102,
 65060,
 -1,
 122683752,
 65067,
 122945535,
 122490470,
 -1,
 -63660,
 122836803,
 7622,
 -63659,
 122891223,
 7628,
 -1,
 122952534,
 7620,
 123144030,
 122427700,
 -1,
 123209562,
 123125715,
 -1,
 -63655,
 123152558,
 857,
 -1,
 123214448,
 8432,
 123406173,
 123156465,
 -1,
 -63652,
 123371780,
 7623,
 -1,
 123426646,
 7625,
 -1,
 123370929,
 7677,
 123668322,
 123129373,
 -1,
 -63648,
 123647324,
 7634,
 -63647,
 123709575,
 7633,
 -1,
 123772665,
 7669,
 123930471,
 123650706,
 -1,
 123996006,
 123889089,
 -1,
 -63643,
 123973418,
 65066,
 -1,
 124024904,
 65065,
 -1,
 123974145,
 6836,
 124258155,
 123909463,
 -1,
 -63639,
 124245366,
 7619,
 -63638,
 124308418,
 6842,
 -1,
 124357053,
 7618,
 124520303,
 124231757,
 -1,
 -63635,
 124493293,
 6846,
 -63634,
 124528814,
 6845,
 -1,
 124590704,
 6843,
 124782450,
 124511996,
 -1,
 -63631,
 124725422,
 7631,
 -1,
 124787312,
 859,
 124979061,
 124772865,
 -1,
 -63628,
 124915668,
 6837,
 -1,
 124977512,
 851,
 125175672,
 124968440,
 -1,
 -63625,
 125130050,
 6838,
 -1,
 125188476,
 7673,
 125372283,
 125137369,
 -1,
 -63622,
 125349638,
 7670,
 -1,
 125401128,
 7671,
 125568894,
 125329793,
 -1,
 -63619,
 125547876,
 7632,
 -1,
 125602786,
 6834,
 125765505,
 125511359,
 -1,
 -63616,
 125742501,
 7627,
 -1,
 125790123,
 70459,
 -1,
 125717981,
 850,
 126091263,
 104308429,
 -1,
 -63612,
 126004598,
 128476,
 -1,
 126035078,
 129517,
 126224475,
 104242893,
 -1,
 126290010,
 126207855,
 -1,
 126355416,
 126268759,
 -1,
 126420942,
 126321126,
 -1,
 126486432,
 126390417,
 11423,
 126551967,
 126449398,
 -1,
 126617497,
 126498082,
 -1,
 126683025,
 126572584,
 -1,
 126748559,
 126622004,
 11471,
 -1,
 126730898,
 11477,
 -63600,
 126720197,
 11469,
 -1,
 126829820,
 11475,
 127010708,
 126662751,
 -1,
 -63597,
 126969354,
 11483,
 -1,
 127026428,
 11461,
 -63595,
 126981886,
 11455,
 -63594,
 127161317,
 11479,
 -63593,
 127224237,
 11463,
 -63592,
 127286266,
 11481,
 -1,
 127343950,
 11445,
 127598591,
 126586799,
 -1,
 127600541,
 127502632,
 -1,
 -63588,
 127591546,
 11489,
 -1,
 127620614,
 11487,
 -63586,
 127589360,
 11491,
 -1,
 127777199,
 11485,
 -1,
 126524058,
 11441,
 127993767,
 126433295,
 -1,
 128059302,
 127951418,
 -1,
 -63581,
 128027795,
 11451,
 -63580,
 128086347,
 11449,
 -63579,
 128147144,
 11467,
 -1,
 128196207,
 11443,
 -1,
 127999590,
 11399,
 128452526,
 127939963,
 -1,
 128518061,
 128443771,
 -1,
 -63574,
 128498006,
 11500,
 -63573,
 128552083,
 11453,
 -63572,
 128603109,
 11502,
 -1,
 128664841,
 11447,
 -1,
 128489894,
 11459,
 128911282,
 128431447,
 -1,
 -63568,
 128883354,
 11403,
 -63567,
 128935434,
 11429,
 -1,
 128982951,
 11457,
 129173430,
 128872587,
 -1,
 -63564,
 129153620,
 11421,
 -63563,
 129195084,
 11437,
 -1,
 129245613,
 11413,
 129435577,
 129155730,
 -1,
 -63560,
 129391625,
 11409,
 -1,
 129443283,
 11431,
 129632188,
 129408717,
 -1,
 -63557,
 129612372,
 11439,
 -1,
 129655169,
 11425,
 129828799,
 129594444,
 -1,
 -63554,
 129771001,
 11415,
 -1,
 129830792,
 11473,
 130025410,
 129767732,
 -1,
 -63551,
 129989415,
 11393,
 -1,
 130052791,
 11465,
 -63549,
 130016856,
 11405,
 -63548,
 130210042,
 11395,
 -63547,
 130272950,
 11433,
 -63546,
 130331396,
 11427,
 -63545,
 130387091,
 11419,
 -63544,
 130450687,
 11417,
 -63543,
 130507420,
 11411,
 -63542,
 130570888,
 11407,
 -63541,
 130634693,
 11397,
 -63540,
 130698839,
 11435,
 -63539,
 130761993,
 11401,
 -1,
 130820858,
 11507,
 131071999,
 126412003,
 -1,
 131074002,
 130987351,
 -1,
 -63535,
 131056681,
 11495,
 -1,
 131095861,
 11498,
 131270613,
 131035275,
 -1,
 -63532,
 131226703,
 11497,
 -1,
 131276058,
 11492,
 -63530,
 131253282,
 11496,
 -63529,
 131441217,
 11494,
 -1,
 131499270,
 11493,
 131663908,
 126299364,
 -1,
 131729439,
 131604942,
 -1,
 131794929,
 131698833,
 11422,
 131860464,
 131757814,
 -1,
 131925994,
 131806498,
 -1,
 131991522,
 131881000,
 -1,
 132057056,
 131930420,
 11470,
 -1,
 132039314,
 11476,
 -63519,
 132028613,
 11468,
 -1,
 132138236,
 11474,
 132319205,
 131971167,
 -1,
 -63516,
 132277770,
 11482,
 -1,
 132334844,
 11460,
 -63514,
 132290302,
 11454,
 -63513,
 132469733,
 11478,
 -63512,
 132532653,
 11462,
 -63511,
 132594682,
 11480,
 -1,
 132652366,
 11444,
 132907007,
 131895215,
 -1,
 132909038,
 132811048,
 -1,
 -63507,
 132899962,
 11488,
 -1,
 132929030,
 11486,
 -63505,
 132897776,
 11490,
 -1,
 133085615,
 11484,
 -1,
 131832474,
 11440,
 133302264,
 131741711,
 -1,
 133367799,
 133259834,
 -1,
 -63500,
 133336211,
 11450,
 -63499,
 133394763,
 11448,
 -63498,
 133455560,
 11466,
 -1,
 133504623,
 11442,
 -1,
 133308006,
 11398,
 133761023,
 133248379,
 -1,
 133826558,
 133752187,
 -1,
 -63493,
 133806422,
 11499,
 -63492,
 133860499,
 11452,
 -63491,
 133911525,
 11501,
 -1,
 133973257,
 11446,
 -1,
 133798310,
 11458,
 134219779,
 133739863,
 -1,
 -63487,
 134191770,
 11402,
 -63486,
 134243850,
 11428,
 -1,
 134291367,
 11456,
 134481927,
 134181003,
 -1,
 -63483,
 134462036,
 11420,
 -63482,
 134503500,
 11436,
 -1,
 134554029,
 11412,
 134744074,
 134464146,
 -1,
 -63479,
 134700041,
 11408,
 -1,
 134751699,
 11430,
 134940685,
 134717133,
 -1,
 -63476,
 134920788,
 11438,
 -1,
 134963585,
 11424,
 135137296,
 134902860,
 -1,
 -63473,
 135079417,
 11414,
 -1,
 135139208,
 11472,
 135333907,
 135076148,
 -1,
 -63470,
 135297831,
 11392,
 -1,
 135361207,
 11464,
 -63468,
 135325272,
 11404,
 -63467,
 135518458,
 11394,
 -63466,
 135581366,
 11432,
 -63465,
 135639812,
 11426,
 -63464,
 135695507,
 11418,
 -63463,
 135759103,
 11416,
 -63462,
 135815836,
 11410,
 -63461,
 135879304,
 11406,
 -63460,
 135943109,
 11396,
 -63459,
 136007255,
 11434,
 -63458,
 136070409,
 11400,
 -1,
 136129274,
 11506,
 136380415,
 131699649,
 -1,
 136382499,
 136298019,
 -1,
 -63454,
 136346194,
 11505,
 -1,
 136389749,
 11504,
 -1,
 136350870,
 11503,
 136644689,
 131614734,
 -1,
 136710211,
 136613831,
 -1,
 136775726,
 136692370,
 -1,
 136841258,
 136764132,
 -1,
 -63447,
 136810649,
 66292,
 -1,
 136857529,
 66283,
 137037869,
 136796200,
 -1,
 -63444,
 137014367,
 66293,
 -1,
 137063548,
 66284,
 -1,
 136988234,
 66282,
 137300021,
 136754519,
 -1,
 137365554,
 137260754,
 -1,
 -63439,
 137350657,
 66287,
 -1,
 137364312,
 66296,
 137625599,
 137317099,
 -1,
 -63436,
 137547265,
 66288,
 -1,
 137560920,
 66297,
 137758780,
 137252071,
 -1,
 137824313,
 137728145,
 -1,
 -63432,
 137810986,
 66294,
 -1,
 137868479,
 66285,
 138084351,
 137781633,
 -1,
 -63429,
 138008306,
 66295,
 -1,
 138040022,
 66286,
 138217535,
 137727192,
 -1,
 -63426,
 138202625,
 66290,
 -1,
 138216280,
 66299,
 138414146,
 138167565,
 -1,
 -63423,
 138404620,
 66289,
 -1,
 138412888,
 66298,
 -1,
 138384596,
 66291,
 138676304,
 136657758,
 -1,
 138741831,
 138658450,
 -1,
 -63418,
 138731536,
 66274,
 -1,
 138764241,
 66275,
 138938442,
 138720599,
 -1,
 -63415,
 138899154,
 66278,
 -1,
 138955499,
 66279,
 139135053,
 138890471,
 -1,
 -63412,
 139107099,
 66276,
 -1,
 139161120,
 66277,
 -63410,
 139105455,
 66273,
 -63409,
 139300056,
 66281,
 -1,
 139347213,
 66280,
 -1,
 138659450,
 66272,
 139593814,
 136614674,
 -1,
 -63405,
 139581358,
 11516,
 -63404,
 139618196,
 11515,
 -63403,
 139678433,
 11513,
 -1,
 139738024,
 11514,
 139921497,
 139545831,
 -1,
 -63400,
 139907328,
 11518,
 -1,
 139962651,
 11517,
 -1,
 139888545,
 11519,
 -1,
 126280903,
 127279,
 140249209,
 126209565,
 -1,
 140314743,
 140218241,
 -1,
 140380266,
 140300882,
 -1,
 140445793,
 140362386,
 -1,
 -63392,
 140435472,
 119649,
 -1,
 140468177,
 119650,
 140642404,
 140424535,
 -1,
 -63389,
 140603090,
 119653,
 -1,
 140659435,
 119654,
 140839015,
 140594407,
 -1,
 -63386,
 140811035,
 119651,
 -1,
 140865056,
 119652,
 -63384,
 140809391,
 119648,
 -63383,
 141003992,
 119656,
 -1,
 141051149,
 119655,
 141295615,
 140363006,
 -1,
 141297774,
 141214354,
 -1,
 -63379,
 141287440,
 119658,
 -1,
 141320145,
 119659,
 141494385,
 141276503,
 -1,
 -63376,
 141455058,
 119662,
 -1,
 141511403,
 119663,
 141690996,
 141446375,
 -1,
 -63373,
 141663003,
 119660,
 -1,
 141717024,
 119661,
 -63371,
 141661359,
 119657,
 -63370,
 141855960,
 119665,
 -1,
 141903117,
 119664,
 -63368,
 140288769,
 128145,
 -1,
 142028668,
 128715,
 142215301,
 140216616,
 -1,
 142280830,
 142167271,
 -1,
 -63364,
 142267693,
 128533,
 -63363,
 142318341,
 128534,
 -1,
 142363197,
 127882,
 142542977,
 142265268,
 -1,
 -63360,
 142522371,
 983186,
 -1,
 142570338,
 127899,
 142739588,
 142524716,
 -1,
 -63357,
 142729626,
 128119,
 -1,
 142785220,
 128679,
 -1,
 142727024,
 127978,
 143001738,
 142185113,
 -1,
 143067273,
 142958977,
 -1,
 -63352,
 143035388,
 127859,
 -1,
 143081667,
 127850,
 -1,
 143016793,
 127834,
 143329420,
 142990052,
 128004,
 -1,
 143262396,
 128046,
 143460495,
 143273188,
 -1,
 -63346,
 143431282,
 129381,
 -1,
 143487955,
 127864,
 -63344,
 143424890,
 128165,
 -63343,
 143609410,
 9904,
 -1,
 143664310,
 129509,
 143854052,
 104159272,
 -1,
 143919465,
 143792436,
 -1,
 143984897,
 143884423,
 -1,
 144050392,
 143948427,
 -1,
 144115874,
 144002692,
 -1,
 144181401,
 144083240,
 43590,
 -1,
 144134898,
 43586,
 -63334,
 144171788,
 43592,
 -63333,
 144294546,
 43589,
 -63332,
 144359078,
 43595,
 -63331,
 144418946,
 43593,
 -63330,
 144481997,
 43591,
 -63329,
 144536652,
 43594,
 -63328,
 144601227,
 43584,
 -63327,
 144659186,
 43585,
 -1,
 144715641,
 43588,
 144902316,
 144083240,
 -1,
 144967847,
 144857128,
 -1,
 -63323,
 144953432,
 43536,
 -63322,
 144994173,
 43538,
 -1,
 145037620,
 43537,
 145229994,
 144921330,
 -1,
 -63319,
 145215576,
 43530,
 -1,
 145234228,
 43531,
 -63317,
 145215576,
 43543,
 -1,
 145365300,
 43544,
 145557680,
 144875213,
 -1,
 -63314,
 145530665,
 43547,
 -63313,
 145578046,
 43548,
 -1,
 145627444,
 43546,
 145819828,
 145504271,
 -1,
 -63310,
 145774654,
 43542,
 -63309,
 145832094,
 43545,
 -1,
 145889588,
 43541,
 146081976,
 145761983,
 -1,
 -63306,
 146036798,
 43550,
 -63305,
 146089716,
 43553,
 -1,
 146151732,
 43549,
 146344123,
 146064018,
 -1,
 -63302,
 146298942,
 43540,
 -1,
 146348340,
 43539,
 146540734,
 146322775,
 -1,
 -63299,
 146519553,
 43558,
 -1,
 146544948,
 43559,
 146737345,
 146505861,
 -1,
 -63296,
 146722904,
 43551,
 -1,
 146741556,
 43552,
 146933956,
 146698379,
 -1,
 -63293,
 146888766,
 43527,
 -1,
 146938164,
 43526,
 147130567,
 146894687,
 -1,
 -63290,
 147085374,
 43535,
 -1,
 147134772,
 43534,
 147327178,
 147084018,
 -1,
 -63287,
 147281982,
 43529,
 -1,
 147331380,
 43528,
 147523789,
 147271545,
 -1,
 -63284,
 147478590,
 43533,
 -1,
 147527988,
 43532,
 147720399,
 147462452,
 43520,
 -1,
 147677569,
 43524,
 -63280,
 147710836,
 43554,
 -63279,
 147838478,
 43557,
 -63278,
 147901981,
 43522,
 -63277,
 147958005,
 43555,
 -63276,
 148017297,
 43525,
 -63275,
 148075670,
 43556,
 -63274,
 148136321,
 43521,
 -63273,
 148199486,
 43560,
 -1,
 148259011,
 43523,
 148441316,
 144038512,
 -1,
 148506845,
 148379956,
 -1,
 -63269,
 148491805,
 43569,
 -63268,
 148529537,
 43568,
 -1,
 148576564,
 43561,
 148768991,
 148491805,
 43565,
 -1,
 148717763,
 43570,
 148900065,
 148738193,
 43567,
 -1,
 148848835,
 43566,
 149031139,
 148857217,
 43562,
 -1,
 148988289,
 43563,
 -1,
 148980988,
 43564,
 149227762,
 148388702,
 -1,
 149293288,
 149209746,
 -1,
 -63257,
 149282832,
 43602,
 -1,
 149315537,
 43603,
 149489899,
 149271895,
 -1,
 -63254,
 149450450,
 43606,
 -1,
 149506795,
 43607,
 149686510,
 149441767,
 -1,
 -63251,
 149658395,
 43604,
 -1,
 149712416,
 43605,
 -63249,
 149677706,
 43600,
 -63248,
 149853359,
 43601,
 -63247,
 149916888,
 43609,
 -1,
 149964045,
 43608,
 150145275,
 149173344,
 -1,
 150210807,
 150097540,
 -1,
 -63243,
 150178812,
 43587,
 -63242,
 150241413,
 43596,
 -1,
 150296616,
 43597,
 -63240,
 150201204,
 43571,
 -63239,
 150461220,
 43574,
 -63238,
 150513909,
 43572,
 -1,
 150566038,
 43573,
 150798335,
 150120006,
 -1,
 150800639,
 150681615,
 -1,
 -63234,
 150772388,
 43614,
 -1,
 150806664,
 43613,
 -63232,
 150784898,
 43615,
 -1,
 150978064,
 43612,
 151128415,
 143946583,
 -1,
 151193909,
 151091851,
 -1,
 151259401,
 151175826,
 -1,
 151324935,
 151241362,
 -1,
 -63226,
 151279699,
 69906,
 -1,
 151329260,
 69905,
 -63224,
 151279699,
 69911,
 -1,
 151460332,
 69910,
 151652622,
 151226664,
 -1,
 -63221,
 151642999,
 69904,
 -63220,
 151685534,
 69909,
 -63219,
 151737156,
 69899,
 -1,
 151788012,
 69914,
 151980308,
 151599119,
 -1,
 152045842,
 151926799,
 -1,
 -63215,
 152000595,
 69908,
 -1,
 152050156,
 69907,
 -63213,
 152000595,
 69913,
 -1,
 152181228,
 69912,
 152373527,
 151970572,
 -1,
 -63210,
 152363895,
 69920,
 -1,
 152377836,
 69921,
 152570138,
 152346317,
 -1,
 -63207,
 152524883,
 69916,
 -1,
 152574444,
 69915,
 152766749,
 152532044,
 -1,
 -63204,
 152721491,
 69956,
 -1,
 152771052,
 69923,
 152963360,
 152727691,
 -1,
 -63201,
 152918099,
 69896,
 -1,
 152967660,
 69895,
 153159971,
 152923999,
 -1,
 -63198,
 153114707,
 69903,
 -1,
 153164268,
 69902,
 153356582,
 153113330,
 -1,
 -63195,
 153311315,
 69898,
 -1,
 153360876,
 69897,
 153553193,
 153300196,
 -1,
 -63192,
 153507923,
 69901,
 -1,
 153557484,
 69900,
 153749804,
 153495231,
 -1,
 -63189,
 153704531,
 69918,
 -1,
 153754092,
 69917,
 -63187,
 153738023,
 69924,
 -63186,
 153931293,
 69893,
 -63185,
 153990673,
 69925,
 -63184,
 154052880,
 69922,
 -63183,
 154108126,
 69919,
 -63182,
 154165633,
 69892,
 -63181,
 154228819,
 69926,
 -63180,
 154288323,
 69894,
 -1,
 154343916,
 69891,
 154536260,
 151180792,
 -1,
 154601795,
 154508877,
 -1,
 154667323,
 154540340,
 69927,
 -63175,
 154652189,
 69935,
 -63174,
 154689921,
 69933,
 -1,
 154736948,
 69957,
 154929469,
 154652189,
 69930,
 -1,
 154914333,
 69931,
 155060543,
 154898577,
 69934,
 -1,
 155017601,
 69936,
 155191617,
 155017601,
 69928,
 -1,
 155148673,
 69929,
 155385855,
 155140291,
 69932,
 -1,
 155279745,
 69958,
 -1,
 154561494,
 69939,
 155519317,
 154482703,
 -1,
 155584851,
 155477281,
 -1,
 155650377,
 155566738,
 -1,
 -63160,
 155639824,
 69944,
 -1,
 155672529,
 69945,
 155846988,
 155628887,
 -1,
 -63157,
 155807442,
 69948,
 -1,
 155863787,
 69949,
 156043599,
 155798759,
 -1,
 -63154,
 156015387,
 69946,
 -1,
 156069408,
 69947,
 -63152,
 156034698,
 69942,
 -63151,
 156210351,
 69943,
 -63150,
 156273880,
 69951,
 -1,
 156321037,
 69950,
 -63148,
 155556516,
 69954,
 -1,
 156442760,
 69953,
 156633435,
 155497815,
 -1,
 156698970,
 156591416,
 -1,
 -63144,
 156686669,
 69890,
 -63143,
 156708280,
 69888,
 -1,
 156770702,
 69889,
 -1,
 156648191,
 69952,
 -63140,
 156608551,
 69955,
 -63139,
 156995761,
 69937,
 -63138,
 157057256,
 69940,
 -1,
 157099493,
 69938,
 157288808,
 151103618,
 -1,
 157354340,
 157270797,
 -1,
 157419875,
 157340684,
 128200,
 -1,
 157352136,
 128185,
 -1,
 157368272,
 128201,
 157679615,
 157293381,
 983058,
 157745151,
 157548544,
 -1,
 -63129,
 157671072,
 983139,
 -1,
 157726762,
 983136,
 -1,
 157247963,
 9939,
 157944281,
 143868099,
 -1,
 158009811,
 157919362,
 -1,
 158075344,
 157979331,
 -1,
 158140879,
 158055560,
 -1,
 158206335,
 158122642,
 -1,
 158271861,
 158184791,
 -1,
 -63120,
 158258680,
 43960,
 -63119,
 158322205,
 43959,
 -63118,
 158371985,
 43958,
 -63117,
 158425473,
 43957,
 -63116,
 158482627,
 43956,
 -1,
 158538036,
 43955,
 158730620,
 158233676,
 -1,
 -63113,
 158717432,
 43954,
 -63112,
 158780957,
 43953,
 -63111,
 158830737,
 43952,
 -63110,
 158884225,
 43951,
 -63109,
 158941379,
 43950,
 -1,
 158996788,
 43949,
 -63107,
 158687617,
 43944,
 -63106,
 159137987,
 43942,
 -1,
 159193396,
 43940,
 159385990,
 158184791,
 43933,
 -63103,
 159372792,
 43938,
 -63102,
 159436317,
 43937,
 -63101,
 159486097,
 43936,
 -63100,
 159539585,
 43935,
 -63099,
 159596739,
 43934,
 -1,
 159652148,
 43932,
 159844750,
 159353128,
 -1,
 159910281,
 159783220,
 43918,
 -1,
 159864872,
 43920,
 -63094,
 159897080,
 43925,
 -63093,
 160026141,
 43924,
 -63092,
 160075921,
 43923,
 -63091,
 160129409,
 43922,
 -1,
 160186563,
 43921,
 160369046,
 159799336,
 -1,
 -63088,
 160355832,
 43906,
 -63087,
 160419357,
 43905,
 -63086,
 160469137,
 43904,
 -63085,
 160532850,
 43919,
 -63084,
 160588161,
 43903,
 -63083,
 160645315,
 43902,
 -1,
 160700724,
 43901,
 160893342,
 160315407,
 -1,
 -63080,
 160880120,
 43947,
 -63079,
 160943645,
 43946,
 -63078,
 160993425,
 43945,
 -63077,
 161051798,
 43948,
 -63076,
 161112449,
 43943,
 -63075,
 161169603,
 43941,
 -1,
 161225012,
 43939,
 161417637,
 160883468,
 -1,
 -63072,
 161404408,
 5116,
 -63071,
 161467933,
 5115,
 -63070,
 161517713,
 5114,
 -63069,
 161571201,
 5113,
 -63068,
 161628355,
 5112,
 -1,
 161683764,
 43967,
 161876396,
 161405668,
 -1,
 -63065,
 161863160,
 43966,
 -63064,
 161926685,
 43965,
 -63063,
 161976465,
 43964,
 -63062,
 162029953,
 43963,
 -63061,
 162087107,
 43962,
 -1,
 162142516,
 43961,
 162335155,
 161851208,
 -1,
 -63058,
 162321912,
 43931,
 -63057,
 162385437,
 43930,
 -63056,
 162435217,
 43929,
 -63055,
 162488705,
 43928,
 -63054,
 162545859,
 43927,
 -1,
 162601268,
 43926,
 162793914,
 162300037,
 -1,
 -63051,
 162780664,
 5117,
 -63050,
 162844189,
 43917,
 -63049,
 162893969,
 43916,
 -63048,
 162947457,
 43915,
 -63047,
 163004611,
 43914,
 -1,
 163060020,
 43913,
 163252673,
 162755660,
 -1,
 -63044,
 163239416,
 43912,
 -63043,
 163302941,
 43911,
 -63042,
 163352721,
 43910,
 -63041,
 163406209,
 43909,
 -63040,
 163463363,
 43908,
 -1,
 163518772,
 43907,
 163711432,
 163205874,
 -1,
 -63037,
 163698168,
 43900,
 -63036,
 163761693,
 43899,
 -63035,
 163811473,
 43898,
 -63034,
 163864961,
 43897,
 -63033,
 163922115,
 43896,
 -1,
 163977524,
 43894,
 -63031,
 163698168,
 43893,
 -63030,
 164154909,
 43892,
 -63029,
 164204689,
 43891,
 -63028,
 164262109,
 43895,
 -63027,
 164323713,
 43890,
 -63026,
 164380867,
 43889,
 -1,
 164436276,
 43888,
 -1,
 158104223,
 5109,
 164757503,
 158050434,
 -1,
 -63022,
 164684572,
 127800,
 -1,
 164717471,
 127826,
 164891094,
 157958339,
 -1,
 -63019,
 164869952,
 129472,
 -1,
 164933982,
 128227,
 -63017,
 164872220,
 127792,
 -63016,
 165062674,
 127937,
 -1,
 165098088,
 128638,
 165284319,
 157901185,
 -1,
 165349852,
 165246707,
 129490,
 -1,
 165326062,
 128696,
 -63011,
 165327714,
 9911,
 -63010,
 165454768,
 128063,
 -1,
 165491299,
 128020,
 165677538,
 165253265,
 -1,
 -63007,
 165651979,
 129378,
 -1,
 165688159,
 127851,
 -63005,
 165663832,
 9962,
 -1,
 165851805,
 127876,
 166005495,
 143792436,
 -1,
 166070878,
 165972264,
 983098,
 166136406,
 166009791,
 -1,
 166201847,
 166105233,
 -1,
 166267382,
 166162424,
 -1,
 166332911,
 166234408,
 6361,
 166461439,
 166320868,
 -1,
 166463981,
 166367377,
 6347,
 -1,
 166432913,
 6349,
 166658047,
 166420865,
 6343,
 -1,
 166551937,
 6345,
 166726129,
 166311255,
 6362,
 -1,
 166680616,
 6363,
 -62990,
 166707858,
 6357,
 -62989,
 166829773,
 6356,
 -62988,
 166887557,
 6360,
 -62987,
 166949003,
 6358,
 -1,
 166997220,
 6359,
 -1,
 166257420,
 6320,
 167250440,
 166189796,
 -1,
 167315970,
 167220868,
 -1,
 167381505,
 167298902,
 -1,
 167447036,
 167350417,
 5754,
 -1,
 167415953,
 5755,
 167578110,
 167403905,
 5752,
 -1,
 167534977,
 5753,
 167709184,
 167516468,
 5756,
 -1,
 167647540,
 5757,
 -1,
 167658421,
 5751,
 -1,
 167333607,
 5758,
 167971335,
 167266752,
 -1,
 168036870,
 167906973,
 -1,
 -62971,
 168007287,
 6369,
 -1,
 168040940,
 6370,
 -1,
 167987518,
 6365,
 -1,
 167913088,
 6323,
 168364565,
 167228759,
 -1,
 168430096,
 168306304,
 6335,
 168558591,
 168389816,
 -1,
 168561166,
 168474719,
 -1,
 -62963,
 168549451,
 6378,
 -1,
 168597111,
 6379,
 -62961,
 168521859,
 6385,
 -1,
 168713842,
 6380,
 168888852,
 168384552,
 -1,
 -62958,
 168878497,
 6338,
 -62957,
 168926865,
 6336,
 -1,
 168961664,
 6337,
 -1,
 168861329,
 6334,
 169216545,
 168346258,
 -1,
 169282074,
 169199001,
 -1,
 -62952,
 169270347,
 6373,
 -62951,
 169318007,
 6374,
 -1,
 169351660,
 6375,
 169544221,
 169245498,
 -1,
 -62948,
 169532491,
 6376,
 -1,
 169580151,
 6377,
 169740832,
 169501013,
 -1,
 -62945,
 169689283,
 6371,
 -1,
 169744692,
 6372,
 -1,
 169682560,
 6327,
 170002987,
 169191554,
 -1,
 170068521,
 169990884,
 -1,
 170134053,
 170037393,
 6353,
 -1,
 170102929,
 6354,
 170265127,
 170090881,
 6351,
 -1,
 170221953,
 6352,
 -62936,
 170214325,
 6350,
 -1,
 170334516,
 6355,
 -62934,
 170010240,
 6341,
 -1,
 170462885,
 6368,
 170658355,
 169969960,
 -1,
 170723889,
 170646244,
 -1,
 170789423,
 170692753,
 6346,
 -1,
 170758289,
 6348,
 170983423,
 170746241,
 6342,
 -1,
 170877313,
 6344,
 -62926,
 170696337,
 6331,
 -1,
 170993280,
 6332,
 171182653,
 170602061,
 -1,
 171248185,
 171135730,
 -1,
 171313720,
 171236068,
 -1,
 -62921,
 171298333,
 6381,
 -1,
 171317556,
 6384,
 -1,
 171252204,
 6383,
 171575868,
 171194862,
 -1,
 -62917,
 171557817,
 6389,
 -1,
 171589902,
 6382,
 -1,
 171536519,
 6386,
 171838017,
 171155149,
 -1,
 -62913,
 171827617,
 6326,
 -62912,
 171875985,
 6324,
 -1,
 171910784,
 6325,
 172100166,
 171779775,
 -1,
 172165701,
 172049091,
 -1,
 -62908,
 172140674,
 6388,
 -1,
 172192844,
 6387,
 -1,
 172127467,
 5759,
 172427849,
 172090124,
 -1,
 -62904,
 172400273,
 6339,
 -1,
 172435072,
 6340,
 172624460,
 172388491,
 -1,
 -62901,
 172612646,
 6329,
 -1,
 172631680,
 6328,
 172821071,
 172576388,
 -1,
 -62898,
 172801239,
 6366,
 -1,
 172861812,
 6367,
 173017682,
 172759348,
 -1,
 -62895,
 173007628,
 6321,
 -1,
 173024896,
 6322,
 -62893,
 172983070,
 6330,
 -62892,
 173176523,
 6333,
 -62891,
 173236602,
 5120,
 -1,
 173294227,
 6364,
 173476441,
 166080279,
 983097,
 -62888,
 173438628,
 128473,
 -1,
 173474251,
 983170,
 173673052,
 173422607,
 -1,
 -62885,
 173662988,
 127852,
 -1,
 173700941,
 128367,
 -62883,
 173642185,
 128758,
 -1,
 173837071,
 129387,
 174000796,
 166045826,
 -1,
 174066322,
 173957720,
 -1,
 174131814,
 174050845,
 66226,
 174260223,
 174116381,
 66239,
 174325759,
 174181917,
 66212,
 -62876,
 174247453,
 66235,
 -62875,
 174265146,
 66256,
 -1,
 174330389,
 66248,
 174525036,
 174110039,
 66224,
 174590569,
 174506642,
 66242,
 -1,
 174526997,
 66243,
 174721643,
 174544936,
 66222,
 -1,
 174658069,
 66223,
 -1,
 174699863,
 66232,
 174918257,
 174489733,
 66218,
 175046655,
 174859967,
 66250,
 -62865,
 174920792,
 66253,
 -62864,
 174986042,
 66252,
 -1,
 175051285,
 66251,
 175245941,
 174885160,
 66229,
 -62861,
 175212840,
 66227,
 -62860,
 175264498,
 66244,
 -1,
 175323151,
 66238,
 175508088,
 175227538,
 66221,
 175636479,
 175489682,
 66247,
 -1,
 175510037,
 66230,
 175704699,
 175469644,
 66211,
 175833087,
 175650831,
 66214,
 -1,
 175706645,
 66254,
 175901309,
 175679618,
 66213,
 -1,
 175876226,
 66249,
 176032383,
 175873741,
 66231,
 -1,
 175968789,
 66209,
 176163457,
 175992971,
 66236,
 -1,
 176099861,
 66237,
 176294531,
 176120193,
 66233,
 -1,
 176251265,
 66245,
 176425605,
 176247538,
 66240,
 -1,
 176362005,
 66241,
 176556679,
 176373955,
 66234,
 -1,
 176493077,
 66255,
 176687753,
 176502799,
 66210,
 -1,
 176624149,
 66220,
 176818828,
 176631061,
 -1,
 -62837,
 176755797,
 66246,
 -1,
 176820741,
 66225,
 177015438,
 176757044,
 66208,
 -1,
 176951829,
 66215,
 -62833,
 177005057,
 66228,
 -62832,
 177120978,
 66216,
 -62831,
 177180817,
 66219,
 -1,
 177219263,
 66217,
 177408662,
 174012433,
 -1,
 177474197,
 177366786,
 128199,
 -1,
 177406577,
 128450,
 -1,
 177426029,
 128451,
 177670809,
 177383554,
 -1,
 -62824,
 177641911,
 129365,
 -1,
 177693205,
 983073,
 -62822,
 177643246,
 127887,
 -62821,
 177839045,
 127904,
 -1,
 177867000,
 9936,
 178064104,
 173985799,
 -1,
 178129639,
 178027147,
 -1,
 178195114,
 178072804,
 -1,
 178260644,
 178149416,
 -1,
 178326178,
 178198836,
 66873,
 -1,
 178307730,
 66902,
 -62813,
 178298513,
 66889,
 -1,
 178413953,
 66890,
 178588327,
 178250612,
 -1,
 -62810,
 178578188,
 66891,
 -1,
 178641636,
 66911,
 178847743,
 178526516,
 -1,
 -62807,
 178775321,
 66912,
 -1,
 178825346,
 66882,
 178981552,
 178173271,
 -1,
 179047087,
 178935848,
 -1,
 179112622,
 178985268,
 66877,
 -1,
 179073163,
 66896,
 -1,
 179084945,
 66909,
 -1,
 178998488,
 66906,
 179374774,
 178927631,
 -1,
 179440308,
 179365309,
 -1,
 -62797,
 179430386,
 66895,
 -1,
 179447424,
 66901,
 -62795,
 179430335,
 66881,
 -1,
 179578038,
 66867,
 179767995,
 179365309,
 -1,
 179833530,
 179722280,
 -1,
 -62791,
 179791264,
 66871,
 -1,
 179837236,
 66875,
 -1,
 179774180,
 66869,
 180095679,
 179749522,
 -1,
 -62787,
 180085746,
 66899,
 -62786,
 180121294,
 66908,
 -1,
 180167703,
 66872,
 180357827,
 180052353,
 -1,
 -62783,
 180346811,
 66910,
 -62782,
 180398802,
 66876,
 -1,
 180457569,
 66879,
 180619974,
 180347660,
 -1,
 -62779,
 180592195,
 66874,
 -1,
 180627100,
 66913,
 180816585,
 180594417,
 -1,
 -62776,
 180806412,
 66887,
 -1,
 180856962,
 66893,
 181013196,
 180788941,
 -1,
 -62773,
 180973262,
 66914,
 -1,
 181028426,
 66903,
 181209807,
 180974668,
 -1,
 -62770,
 181200061,
 66885,
 -1,
 181215160,
 66878,
 181406418,
 181170315,
 -1,
 -62767,
 181366475,
 66915,
 -1,
 181412373,
 66884,
 181603029,
 181366623,
 -1,
 -62764,
 181559245,
 66883,
 -1,
 181610167,
 66897,
 181799640,
 181555954,
 -1,
 -62761,
 181757443,
 66866,
 -1,
 181820475,
 66904,
 181996251,
 181747907,
 -1,
 -62758,
 181986585,
 66870,
 -1,
 182003391,
 66868,
 182192862,
 181934388,
 -1,
 -62755,
 182163551,
 66888,
 -1,
 182222790,
 66864,
 -62753,
 182182524,
 66880,
 -62752,
 182376677,
 66907,
 -62751,
 182430308,
 66905,
 -62750,
 182490132,
 66898,
 -62749,
 182554243,
 66894,
 -62748,
 182616692,
 66892,
 -62747,
 182672448,
 66886,
 -62746,
 182734203,
 66900,
 -1,
 182790391,
 66865,
 -1,
 178074105,
 66927,
 183044845,
 178045586,
 128008,
 183173119,
 182977212,
 128049,
 183238655,
 183044899,
 -1,
 -62740,
 183165408,
 128572,
 -1,
 183223410,
 128569,
 183372529,
 183009413,
 -1,
 183438064,
 183322824,
 128247,
 -1,
 183372913,
 128248,
 -1,
 183411342,
 127957,
 183634676,
 183333964,
 -1,
 -62733,
 183596110,
 129305,
 -1,
 183650048,
 128197,
 -62731,
 183615504,
 9963,
 -62730,
 183804589,
 11839,
 -1,
 183842610,
 127797,
 184028152,
 165995276,
 -1,
 184093619,
 184004865,
 -1,
 184159067,
 184073352,
 -1,
 184224518,
 184140434,
 -1,
 184290047,
 184164059,
 -1,
 -62723,
 184280037,
 7303,
 -62722,
 184337485,
 7300,
 -1,
 184375902,
 7302,
 184552194,
 184268119,
 -1,
 -62719,
 184540235,
 42639,
 -1,
 184596281,
 42641,
 -62717,
 184540235,
 42637,
 -62716,
 184705194,
 7301,
 -62715,
 184762785,
 42635,
 -1,
 184823790,
 42643,
 185010963,
 184170511,
 -1,
 185076493,
 185001405,
 -1,
 185142027,
 185066941,
 -1,
 -62710,
 185096885,
 1323,
 -1,
 185155779,
 42633,
 -62708,
 185130059,
 42627,
 -1,
 185288179,
 42563,
 185469712,
 185047709,
 -1,
 -62705,
 185438353,
 42649,
 -1,
 185501548,
 42605,
 -62703,
 185457739,
 42625,
 -62702,
 185626597,
 42569,
 -1,
 185675758,
 1325,
 185862939,
 184985730,
 -1,
 185928473,
 185813865,
 -1,
 -62698,
 185919080,
 1297,
 -62697,
 185984429,
 42581,
 -62696,
 186043368,
 42593,
 -1,
 186073274,
 42565,
 -62694,
 185899793,
 7296,
 -1,
 186210366,
 1303,
 186387236,
 185840983,
 -1,
 186452769,
 186356231,
 -1,
 186518304,
 186400963,
 -1,
 -62689,
 186482821,
 42599,
 -1,
 186545228,
 42597,
 -1,
 186464633,
 42595,
 186843135,
 186406952,
 -1,
 -62685,
 186768459,
 42647,
 -1,
 186800193,
 1319,
 186977068,
 186335427,
 -1,
 187042601,
 186938486,
 -1,
 -62681,
 187008340,
 1313,
 -62680,
 187063926,
 1299,
 -1,
 187120203,
 1327,
 187367423,
 187009348,
 -1,
 -62677,
 187270484,
 1315,
 -1,
 187332746,
 1321,
 187501362,
 186936176,
 -1,
 187566897,
 187458504,
 -1,
 -62673,
 187556837,
 42579,
 -62672,
 187577046,
 42589,
 -1,
 187636020,
 42583,
 -1,
 187504948,
 42567,
 187894582,
 187491084,
 -1,
 -62668,
 187861288,
 42591,
 -62667,
 187910519,
 42577,
 -1,
 187964378,
 1305,
 188156731,
 187848744,
 -1,
 188222266,
 188094890,
 -1,
 -62663,
 188203198,
 1279,
 -1,
 188243574,
 1277,
 -1,
 188210251,
 42645,
 188484415,
 188099812,
 -1,
 -62659,
 188461990,
 42651,
 -62658,
 188513917,
 42585,
 -1,
 188559342,
 42631,
 188746563,
 188425919,
 -1,
 -62655,
 188723983,
 42573,
 -62654,
 188774963,
 42587,
 -1,
 188836289,
 42603,
 189008710,
 188736957,
 -1,
 -62651,
 188965227,
 42629,
 -1,
 189023798,
 42561,
 189205321,
 188996324,
 -1,
 -62648,
 189162298,
 7299,
 -1,
 189219011,
 1309,
 189401932,
 189177549,
 -1,
 -62645,
 189350275,
 1317,
 -1,
 189406977,
 1231,
 189598543,
 189368616,
 -1,
 -62642,
 189549265,
 42575,
 -1,
 189604735,
 7298,
 189795154,
 189564775,
 -1,
 -62639,
 189749014,
 42571,
 -1,
 189806407,
 42601,
 189991765,
 189756492,
 -1,
 -62636,
 189961665,
 7297,
 -1,
 190011454,
 1301,
 190188376,
 189945224,
 -1,
 -62633,
 190169293,
 1275,
 -1,
 190200395,
 1271,
 -62631,
 190173596,
 7304,
 -62630,
 190359281,
 1307,
 -1,
 190389906,
 1311,
 190581678,
 184102422,
 -1,
 190647145,
 190527503,
 -1,
 190712675,
 190637501,
 -1,
 190778209,
 190703037,
 -1,
 -62624,
 190732981,
 1322,
 -1,
 190791875,
 42632,
 -62622,
 190766155,
 42626,
 -1,
 190924275,
 42562,
 191105894,
 190683805,
 -1,
 -62619,
 191074449,
 42648,
 -1,
 191137644,
 42604,
 -62617,
 191093835,
 42624,
 -62616,
 191262693,
 42568,
 -1,
 191311854,
 1324,
 191499120,
 190628498,
 -1,
 191564653,
 191477079,
 -1,
 -62612,
 191552587,
 42638,
 -1,
 191608633,
 42640,
 -62610,
 191552587,
 42636,
 -62609,
 191709601,
 42634,
 -1,
 191770606,
 42642,
 191957881,
 191477079,
 -1,
 192023414,
 191926791,
 -1,
 192088949,
 191971523,
 -1,
 -62604,
 192053381,
 42598,
 -1,
 192115788,
 42596,
 -1,
 192035193,
 42594,
 192413695,
 191977512,
 -1,
 -62600,
 192339019,
 42646,
 -1,
 192370753,
 1318,
 192547712,
 191932546,
 -1,
 192613247,
 192498537,
 -1,
 -62596,
 192603752,
 1296,
 -62595,
 192669101,
 42580,
 -62594,
 192728040,
 42592,
 -1,
 192757946,
 42564,
 -1,
 192567358,
 1302,
 193006472,
 192495811,
 -1,
 193072005,
 192967798,
 -1,
 -62589,
 193037652,
 1312,
 -62588,
 193093238,
 1298,
 -1,
 193149515,
 1326,
 193396735,
 193038660,
 -1,
 -62585,
 193299796,
 1314,
 -1,
 193362058,
 1320,
 193530766,
 192965488,
 -1,
 193596301,
 193487816,
 -1,
 -62581,
 193586149,
 42578,
 -62580,
 193606358,
 42588,
 -1,
 193665332,
 42582,
 -1,
 193534260,
 42566,
 193923986,
 193520396,
 -1,
 -62576,
 193890600,
 42590,
 -62575,
 193939831,
 42576,
 -1,
 193993690,
 1304,
 194186135,
 193878056,
 -1,
 194251670,
 194124202,
 -1,
 -62571,
 194232510,
 1278,
 -1,
 194272886,
 1276,
 -1,
 194239563,
 42644,
 194513819,
 194129124,
 -1,
 -62567,
 194491302,
 42650,
 -62566,
 194543229,
 42584,
 -1,
 194588654,
 42630,
 194775967,
 194455231,
 -1,
 -62563,
 194753295,
 42572,
 -62562,
 194804275,
 42586,
 -1,
 194865601,
 42602,
 195038114,
 194766269,
 -1,
 -62559,
 194994539,
 42628,
 -1,
 195053110,
 42560,
 195234725,
 195004263,
 -1,
 -62556,
 195188502,
 42570,
 -1,
 195245895,
 42600,
 195431336,
 195188104,
 -1,
 -62553,
 195412173,
 1274,
 -1,
 195443275,
 1270,
 -62551,
 195419211,
 1308,
 -62550,
 195602161,
 1306,
 -62549,
 195666148,
 1316,
 -62548,
 195726290,
 42574,
 -62547,
 195787581,
 1300,
 -1,
 195829394,
 1310,
 196021169,
 190544523,
 -1,
 -62544,
 196000847,
 7467,
 -1,
 196053111,
 42606,
 -62542,
 195993791,
 42623,
 -1,
 196178386,
 42622,
 196348919,
 184067509,
 -1,
 196414394,
 196330130,
 -1,
 -62538,
 196398621,
 67633,
 -62537,
 196448401,
 67632,
 -62536,
 196501889,
 67631,
 -62535,
 196559043,
 67630,
 -1,
 196614452,
 67629,
 196807616,
 196392279,
 -1,
 -62532,
 196791837,
 67628,
 -62531,
 196841617,
 67627,
 -62530,
 196895105,
 67626,
 -62529,
 196952259,
 67625,
 -1,
 197007668,
 67624,
 197200838,
 196782210,
 -1,
 -62526,
 197185053,
 67623,
 -62525,
 197234833,
 67622,
 -62524,
 197288321,
 67621,
 -62523,
 197345475,
 67620,
 -1,
 197400884,
 67619,
 197594060,
 197172941,
 -1,
 -62520,
 197578269,
 67618,
 -62519,
 197628049,
 67617,
 -62518,
 197681537,
 67616,
 -62517,
 197738691,
 67615,
 -1,
 197794100,
 67614,
 197987282,
 197560616,
 -1,
 -62514,
 197971485,
 67613,
 -62513,
 198021265,
 67612,
 -62512,
 198074753,
 67611,
 -62511,
 198131907,
 67610,
 -1,
 198187316,
 67609,
 198380504,
 197951621,
 -1,
 -62508,
 198364701,
 67608,
 -62507,
 198414481,
 67607,
 -62506,
 198467969,
 67606,
 -62505,
 198525123,
 67605,
 -1,
 198580532,
 67604,
 198773726,
 198341708,
 -1,
 -62502,
 198757917,
 67603,
 -62501,
 198807697,
 67602,
 -62500,
 198861185,
 67601,
 -62499,
 198918339,
 67600,
 -1,
 198973748,
 67599,
 199166948,
 198733963,
 -1,
 -62496,
 199151133,
 67598,
 -62495,
 199200913,
 67597,
 -62494,
 199254401,
 67596,
 -62493,
 199311555,
 67595,
 -1,
 199366964,
 67594,
 199560169,
 199154404,
 -1,
 -62490,
 199528593,
 67637,
 -62489,
 199582081,
 67636,
 -62488,
 199639235,
 67635,
 -1,
 199694644,
 67634,
 199887852,
 199550397,
 -1,
 -62485,
 199856273,
 67647,
 -1,
 199891252,
 67644,
 200084463,
 199877121,
 -1,
 -62482,
 200032451,
 67640,
 -1,
 200087860,
 67639,
 200281074,
 200044383,
 -1,
 -62479,
 200249489,
 67592,
 -1,
 200284468,
 67589,
 -62477,
 200265245,
 67588,
 -62476,
 200446097,
 67587,
 -62475,
 200499585,
 67586,
 -62474,
 200556739,
 67585,
 -1,
 200612148,
 67584,
 -1,
 196293288,
 127744,
 200871063,
 183988245,
 -1,
 200936562,
 200815581,
 -1,
 201001995,
 200879332,
 -1,
 -62468,
 200953063,
 64207,
 -62467,
 201015491,
 64206,
 -62466,
 201078799,
 64205,
 -62465,
 201141476,
 64204,
 -62464,
 201205439,
 64203,
 -62463,
 201267508,
 64202,
 -62462,
 201332866,
 64201,
 -62461,
 201398225,
 64200,
 -62460,
 201463537,
 64199,
 -62459,
 201528865,
 64198,
 -62458,
 201594156,
 64197,
 -62457,
 201659480,
 64196,
 -62456,
 201724730,
 64195,
 -62455,
 201789973,
 64194,
 -62454,
 201855210,
 64193,
 -1,
 201920477,
 64192,
 202116124,
 200943295,
 -1,
 -62451,
 202067175,
 64191,
 -62450,
 202129603,
 64190,
 -62449,
 202192911,
 64189,
 -62448,
 202255588,
 64188,
 -62447,
 202319551,
 64187,
 -62446,
 202381620,
 64186,
 -62445,
 202446978,
 64185,
 -62444,
 202512337,
 64184,
 -62443,
 202577649,
 64183,
 -62442,
 202642977,
 64182,
 -62441,
 202708268,
 64181,
 -62440,
 202773592,
 64180,
 -62439,
 202838842,
 64179,
 -62438,
 202904085,
 64178,
 -62437,
 202969322,
 64177,
 -1,
 203034589,
 64176,
 203230253,
 202053940,
 -1,
 -62434,
 203181287,
 64175,
 -62433,
 203243715,
 64174,
 -62432,
 203307023,
 64173,
 -62431,
 203369700,
 64172,
 -62430,
 203433663,
 64171,
 -62429,
 203495732,
 64170,
 -62428,
 203561090,
 64169,
 -62427,
 203626449,
 64168,
 -62426,
 203691761,
 64167,
 -62425,
 203757089,
 64166,
 -62424,
 203822380,
 64165,
 -62423,
 203887704,
 64164,
 -62422,
 203952954,
 64163,
 -62421,
 204018197,
 64162,
 -62420,
 204083434,
 64161,
 -1,
 204148701,
 64160,
 204344382,
 203167874,
 -1,
 -62417,
 204295399,
 64159,
 -62416,
 204357827,
 64158,
 -62415,
 204421135,
 64157,
 -62414,
 204483812,
 64156,
 -62413,
 204547775,
 64155,
 -62412,
 204609844,
 64154,
 -62411,
 204675202,
 64153,
 -62410,
 204740561,
 64152,
 -62409,
 204805873,
 64151,
 -62408,
 204871201,
 64150,
 -62407,
 204936492,
 64149,
 -62406,
 205001816,
 64148,
 -62405,
 205067066,
 64147,
 -62404,
 205132309,
 64146,
 -62403,
 205197546,
 64145,
 -1,
 205262813,
 64144,
 205458511,
 204281809,
 -1,
 -62400,
 205409511,
 64143,
 -62399,
 205471939,
 64142,
 -62398,
 205535247,
 64141,
 -62397,
 205597924,
 64140,
 -62396,
 205661887,
 64139,
 -62395,
 205723956,
 64138,
 -62394,
 205789314,
 64137,
 -62393,
 205854673,
 64136,
 -62392,
 205919985,
 64135,
 -62391,
 205985313,
 64134,
 -62390,
 206050604,
 64133,
 -62389,
 206115928,
 64132,
 -62388,
 206181178,
 64131,
 -62387,
 206246421,
 64130,
 -62386,
 206311658,
 64129,
 -1,
 206376925,
 64128,
 206572640,
 205395697,
 -1,
 -62383,
 206523623,
 64127,
 -62382,
 206586051,
 64126,
 -62381,
 206649359,
 64125,
 -62380,
 206712036,
 64124,
 -62379,
 206775999,
 64123,
 -62378,
 206838068,
 64122,
 -62377,
 206903426,
 64121,
 -62376,
 206968785,
 64120,
 -62375,
 207034097,
 64119,
 -62374,
 207099425,
 64118,
 -62373,
 207164716,
 64117,
 -62372,
 207230040,
 64116,
 -62371,
 207295290,
 64115,
 -62370,
 207360533,
 64114,
 -62369,
 207425770,
 64113,
 -1,
 207491037,
 64112,
 207686763,
 206518287,
 -1,
 -62366,
 207624322,
 64217,
 -62365,
 207689681,
 64216,
 -62364,
 207754993,
 64215,
 -62363,
 207820321,
 64214,
 -62362,
 207885612,
 64213,
 -62361,
 207950936,
 64212,
 -62360,
 208016186,
 64211,
 -62359,
 208081429,
 64210,
 -62358,
 208146666,
 64209,
 -1,
 208211933,
 64208,
 208407663,
 207623713,
 -1,
 -62355,
 208353295,
 64109,
 -62354,
 208415972,
 64108,
 -1,
 208479935,
 64107,
 208732159,
 208343573,
 -1,
 -62351,
 208620775,
 64047,
 -1,
 208683203,
 64046,
 208928767,
 200917189,
 -1,
 208931969,
 208820264,
 12752,
 208997501,
 208922045,
 12757,
 209063033,
 208987581,
 12741,
 209128568,
 209053117,
 12750,
 -1,
 209081074,
 12769,
 -1,
 209100493,
 12747,
 209325179,
 209050340,
 12749,
 -1,
 209277682,
 12744,
 -62340,
 209306258,
 12746,
 -1,
 209408754,
 12742,
 209587327,
 208969421,
 12743,
 -1,
 209575168,
 12748,
 -62336,
 209576702,
 12768,
 -1,
 209670898,
 12758,
 209849483,
 208909655,
 12753,
 209915013,
 209839549,
 12759,
 -62332,
 209905085,
 12766,
 -1,
 209968384,
 12745,
 210111624,
 209902308,
 12740,
 -62329,
 210101693,
 12760,
 -1,
 210129650,
 12767,
 -62327,
 210092690,
 12761,
 -62326,
 210280141,
 12755,
 -1,
 210326258,
 12762,
 210504847,
 209821389,
 12754,
 -62323,
 210494909,
 12764,
 -62322,
 210522866,
 12770,
 -1,
 210581519,
 12763,
 210766993,
 210485906,
 12736,
 -1,
 210733352,
 12765,
 -62318,
 210756225,
 12738,
 -62317,
 210885888,
 12737,
 -62316,
 210937554,
 12771,
 -62315,
 210995496,
 12751,
 -62314,
 211040271,
 12756,
 -1,
 211102928,
 12739,
 211291363,
 200832076,
 -1,
 211356888,
 211259537,
 -1,
 211422411,
 211300894,
 -1,
 211487940,
 211354306,
 -1,
 211553449,
 211468946,
 -1,
 211618979,
 211540708,
 -1,
 211684512,
 211587217,
 -1,
 -62305,
 211619788,
 128349,
 -1,
 211682548,
 128337,
 211943423,
 211633664,
 -1,
 -62302,
 211816396,
 128359,
 -1,
 211879156,
 128347,
 212077734,
 211574737,
 -1,
 -62299,
 212013004,
 128350,
 -1,
 212075764,
 128338,
 212336639,
 212026954,
 -1,
 -62296,
 212209612,
 128357,
 -1,
 212272372,
 128345,
 212470960,
 211531095,
 -1,
 212536493,
 212430546,
 -1,
 -62292,
 212471756,
 128353,
 -1,
 212534516,
 128341,
 212795391,
 212486891,
 -1,
 -62289,
 212668364,
 128354,
 -1,
 212731124,
 128342,
 212929719,
 212421863,
 -1,
 212995252,
 212900635,
 -1,
 -62285,
 212930508,
 128351,
 -1,
 212993268,
 128339,
 213254143,
 212954656,
 -1,
 -62282,
 213127116,
 128352,
 -1,
 213189876,
 128340,
 213388478,
 212877507,
 -1,
 213454011,
 213351149,
 -1,
 -62278,
 213389260,
 128358,
 -1,
 213452020,
 128346,
 213712895,
 213410956,
 -1,
 -62275,
 213585868,
 128355,
 -1,
 213648628,
 128343,
 213847233,
 213357743,
 -1,
 -62272,
 213782476,
 128348,
 -1,
 213845236,
 128336,
 214106111,
 213814488,
 -1,
 -62269,
 213979084,
 128356,
 -1,
 214041844,
 128344,
 214302719,
 211476053,
 -1,
 214305993,
 214216454,
 -1,
 214371528,
 214293387,
 128257,
 -1,
 214305639,
 128258,
 -1,
 214302835,
 128472,
 -62262,
 214289172,
 11118,
 -1,
 214515585,
 128259,
 214699218,
 211400569,
 -1,
 214764751,
 214663516,
 -1,
 -62258,
 214739327,
 128235,
 -1,
 214794121,
 128234,
 -62256,
 214749537,
 127746,
 -62255,
 214924766,
 128272,
 -1,
 214969146,
 128213,
 215157975,
 214683688,
 -1,
 -62252,
 215140797,
 127786,
 -62251,
 215203162,
 127784,
 -62250,
 215263591,
 127783,
 -1,
 215317549,
 127785,
 -1,
 215146443,
 129313,
 215551198,
 211294516,
 -1,
 215616732,
 215524601,
 -1,
 -62245,
 215574576,
 128079,
 -1,
 215632005,
 127916,
 -62243,
 215596822,
 127963,
 -1,
 215779364,
 128385,
 216006655,
 215507329,
 -1,
 216009954,
 215911807,
 -1,
 -62239,
 215963286,
 129346,
 -1,
 216017026,
 127867,
 -1,
 215982279,
 128203,
 216272151,
 211247489,
 -1,
 216337684,
 216246997,
 -1,
 216403219,
 216299494,
 -1,
 216468724,
 216359297,
 -1,
 216534256,
 216414738,
 -1,
 216599787,
 216494219,
 -1,
 -62230,
 216570450,
 12871,
 -1,
 216622838,
 12869,
 216796398,
 216537396,
 -1,
 -62227,
 216744084,
 127568,
 -1,
 216805057,
 127569,
 -62225,
 216774397,
 12870,
 -1,
 216967198,
 12868,
 217124083,
 216515527,
 -1,
 -62222,
 217098370,
 127276,
 -1,
 217132260,
 127275,
 -1,
 217091050,
 128712,
 217386240,
 216436679,
 -1,
 217451769,
 217367186,
 -1,
 -62217,
 217439368,
 12873,
 -62216,
 217472415,
 12874,
 -1,
 217532026,
 12872,
 217713916,
 217429335,
 -1,
 -62213,
 217673503,
 12877,
 -1,
 217729852,
 12878,
 217910527,
 217664743,
 -1,
 -62210,
 217880947,
 12875,
 -1,
 217932776,
 12876,
 -1,
 217859431,
 12879,
 218172682,
 217328868,
 -1,
 218238217,
 218149778,
 -1,
 218303752,
 218169344,
 -1,
 218369287,
 218255568,
 129282,
 218497023,
 218303267,
 -1,
 -62202,
 218418531,
 129281,
 -1,
 218452294,
 129280,
 -1,
 218342539,
 128320,
 -1,
 218261620,
 9938,
 -1,
 218183695,
 127277,
 218828045,
 218133390,
 -1,
 -62196,
 218787965,
 12925,
 -1,
 218836922,
 12924,
 -62194,
 218817025,
 11198,
 -62193,
 219013630,
 127278,
 -62192,
 219073199,
 128981,
 -62191,
 219135567,
 128983,
 -62190,
 219175439,
 12926,
 -1,
 219228979,
 11199,
 -1,
 216388888,
 127914,
 219483414,
 216321552,
 127961,
 -1,
 219414829,
 127750,
 -1,
 219450230,
 127910,
 219680049,
 216246402,
 983074,
 219745574,
 219648145,
 -1,
 219811107,
 219725478,
 -1,
 219876638,
 219759374,
 -1,
 -62180,
 219857431,
 9876,
 -62179,
 219908933,
 127370,
 -1,
 219959244,
 127884,
 220138786,
 219807744,
 -1,
 220204321,
 220112011,
 128322,
 -1,
 220138621,
 128321,
 -1,
 220168837,
 10060,
 -1,
 220096628,
 9932,
 -62172,
 219799483,
 128081,
 -62171,
 220425485,
 129360,
 -1,
 220476239,
 128010,
 220663083,
 219734796,
 -1,
 220728618,
 220620771,
 -1,
 -62167,
 220679487,
 128546,
 -1,
 220737126,
 128575,
 -1,
 220708721,
 128302,
 220990765,
 220619490,
 129431,
 -1,
 220922181,
 127951,
 221121840,
 220938435,
 -1,
 -62161,
 221099762,
 127769,
 -1,
 221133778,
 128179,
 -1,
 221059603,
 129408,
 221383989,
 219627715,
 -1,
 -62157,
 221359411,
 9907,
 -62156,
 221413376,
 128328,
 -1,
 221461201,
 8373,
 -62154,
 221362772,
 983187,
 -62153,
 221599371,
 983200,
 -1,
 221654905,
 983171,
 221844876,
 49810,
 -1,
 221909885,
 221780276,
 -1,
 221974664,
 221874472,
 -1,
 222040199,
 221926130,
 -1,
 222105734,
 222025103,
 -1,
 222171269,
 222049283,
 -1,
 222236077,
 222107169,
 -1,
 222301514,
 222173314,
 -1,
 -62143,
 222238850,
 101050,
 -62142,
 222304209,
 101049,
 -62141,
 222369521,
 101048,
 -62140,
 222434849,
 101047,
 -62139,
 222500140,
 101046,
 -62138,
 222565464,
 101045,
 -62137,
 222630714,
 101044,
 -62136,
 222695957,
 101043,
 -62135,
 222761194,
 101042,
 -1,
 222826461,
 101041,
 223022421,
 222238673,
 -1,
 -62132,
 222959746,
 101040,
 -62131,
 223025105,
 101039,
 -62130,
 223090417,
 101038,
 -62129,
 223155745,
 101037,
 -62128,
 223221036,
 101036,
 -62127,
 223286360,
 101035,
 -62126,
 223351610,
 101034,
 -62125,
 223416853,
 101033,
 -62124,
 223482090,
 101032,
 -1,
 223547357,
 101031,
 223743328,
 222959345,
 -1,
 -62121,
 223680642,
 101030,
 -62120,
 223746001,
 101029,
 -62119,
 223811313,
 101028,
 -62118,
 223876641,
 101027,
 -62117,
 223941932,
 101026,
 -62116,
 224007256,
 101025,
 -62115,
 224072506,
 101024,
 -62114,
 224137749,
 101023,
 -62113,
 224202986,
 101022,
 -1,
 224268253,
 101021,
 224464235,
 223680033,
 -1,
 -62110,
 224401538,
 101020,
 -62109,
 224466897,
 101019,
 -62108,
 224532209,
 101018,
 -62107,
 224597537,
 101017,
 -62106,
 224662828,
 101016,
 -62105,
 224728152,
 101015,
 -62104,
 224793402,
 101014,
 -62103,
 224858645,
 101013,
 -62102,
 224923882,
 101012,
 -1,
 224989149,
 101011,
 225185142,
 224400684,
 -1,
 -62099,
 225122434,
 101010,
 -62098,
 225187793,
 101009,
 -62097,
 225253105,
 101008,
 -62096,
 225318433,
 101007,
 -62095,
 225383724,
 101006,
 -62094,
 225449048,
 101005,
 -62093,
 225514298,
 101004,
 -62092,
 225579541,
 101003,
 -62091,
 225644778,
 101002,
 -1,
 225710045,
 101001,
 225906049,
 225121368,
 -1,
 -62088,
 225843330,
 101000,
 -62087,
 225908689,
 100999,
 -62086,
 225974001,
 100998,
 -62085,
 226039329,
 100997,
 -62084,
 226104620,
 100996,
 -62083,
 226169944,
 100995,
 -62082,
 226235194,
 100994,
 -62081,
 226300437,
 100993,
 -62080,
 226365674,
 100992,
 -1,
 226430941,
 100991,
 226626956,
 225841978,
 -1,
 -62077,
 226564226,
 100990,
 -62076,
 226629585,
 100989,
 -62075,
 226694897,
 100988,
 -62074,
 226760225,
 100987,
 -62073,
 226825516,
 100986,
 -62072,
 226890840,
 100985,
 -62071,
 226956090,
 100984,
 -62070,
 227021333,
 100983,
 -62069,
 227086570,
 100982,
 -1,
 227151837,
 100981,
 227347863,
 226562581,
 -1,
 -62066,
 227285122,
 100980,
 -62065,
 227350481,
 100979,
 -62064,
 227415793,
 100978,
 -62063,
 227481121,
 100977,
 -62062,
 227546412,
 100976,
 -62061,
 227611736,
 100975,
 -62060,
 227676986,
 100974,
 -62059,
 227742229,
 100973,
 -62058,
 227807466,
 100972,
 -1,
 227872733,
 100971,
 228068770,
 227283178,
 -1,
 -62055,
 228006018,
 100970,
 -62054,
 228071377,
 100969,
 -62053,
 228136689,
 100968,
 -62052,
 228202017,
 100967,
 -62051,
 228267308,
 100966,
 -62050,
 228332632,
 100965,
 -62049,
 228397882,
 100964,
 -62048,
 228463125,
 100963,
 -62047,
 228528362,
 100962,
 -1,
 228593629,
 100961,
 228851711,
 228003805,
 -1,
 -62044,
 228726914,
 100960,
 -62043,
 228792273,
 100959,
 -62042,
 228857585,
 100958,
 -62041,
 228922913,
 100957,
 -62040,
 228988204,
 100956,
 -62039,
 229053528,
 100955,
 -62038,
 229118778,
 100954,
 -62037,
 229184021,
 100953,
 -62036,
 229249258,
 100952,
 -1,
 229314525,
 100951,
 229510684,
 222172460,
 -1,
 229576121,
 229447810,
 -1,
 -62032,
 229513346,
 100950,
 -62031,
 229578705,
 100949,
 -62030,
 229644017,
 100948,
 -62029,
 229709345,
 100947,
 -62028,
 229774636,
 100946,
 -62027,
 229839960,
 100945,
 -62026,
 229905210,
 100944,
 -62025,
 229970453,
 100943,
 -62024,
 230035690,
 100942,
 -1,
 230100957,
 100941,
 230297028,
 229513169,
 -1,
 -62021,
 230234242,
 100940,
 -62020,
 230299601,
 100939,
 -62019,
 230364913,
 100938,
 -62018,
 230430241,
 100937,
 -62017,
 230495532,
 100936,
 -62016,
 230560856,
 100935,
 -62015,
 230626106,
 100934,
 -62014,
 230691349,
 100933,
 -62013,
 230756586,
 100932,
 -1,
 230821853,
 100931,
 231017935,
 230233841,
 -1,
 -62010,
 230955138,
 100930,
 -62009,
 231020497,
 100929,
 -62008,
 231085809,
 100928,
 -62007,
 231151137,
 100927,
 -62006,
 231216428,
 100926,
 -62005,
 231281752,
 100925,
 -62004,
 231347002,
 100924,
 -62003,
 231412245,
 100923,
 -62002,
 231477482,
 100922,
 -1,
 231542749,
 100921,
 231738842,
 230954529,
 -1,
 -61999,
 231676034,
 100920,
 -61998,
 231741393,
 100919,
 -61997,
 231806705,
 100918,
 -61996,
 231872033,
 100917,
 -61995,
 231937324,
 100916,
 -61994,
 232002648,
 100915,
 -61993,
 232067898,
 100914,
 -61992,
 232133141,
 100913,
 -61991,
 232198378,
 100912,
 -1,
 232263645,
 100911,
 232459749,
 231675180,
 -1,
 -61988,
 232396930,
 100910,
 -61987,
 232462289,
 100909,
 -61986,
 232527601,
 100908,
 -61985,
 232592929,
 100907,
 -61984,
 232658220,
 100906,
 -61983,
 232723544,
 100905,
 -61982,
 232788794,
 100904,
 -61981,
 232854037,
 100903,
 -61980,
 232919274,
 100902,
 -1,
 232984541,
 100901,
 233180656,
 232395864,
 -1,
 -61977,
 233117826,
 100900,
 -61976,
 233183185,
 100899,
 -61975,
 233248497,
 100898,
 -61974,
 233313825,
 100897,
 -61973,
 233379116,
 100896,
 -61972,
 233444440,
 100895,
 -61971,
 233509690,
 100894,
 -61970,
 233574933,
 100893,
 -61969,
 233640170,
 100892,
 -1,
 233705437,
 100891,
 233901563,
 233116474,
 -1,
 -61966,
 233838722,
 100890,
 -61965,
 233904081,
 100889,
 -61964,
 233969393,
 100888,
 -61963,
 234034721,
 100887,
 -61962,
 234100012,
 100886,
 -61961,
 234165336,
 100885,
 -61960,
 234230586,
 100884,
 -61959,
 234295829,
 100883,
 -61958,
 234361066,
 100882,
 -1,
 234426333,
 100881,
 234622470,
 233837077,
 -1,
 -61955,
 234559618,
 100880,
 -61954,
 234624977,
 100879,
 -61953,
 234690289,
 100878,
 -61952,
 234755617,
 100877,
 -61951,
 234820908,
 100876,
 -61950,
 234886232,
 100875,
 -61949,
 234951482,
 100874,
 -61948,
 235016725,
 100873,
 -61947,
 235081962,
 100872,
 -1,
 235147229,
 100871,
 235343377,
 234557674,
 -1,
 -61944,
 235280514,
 100870,
 -61943,
 235345873,
 100869,
 -61942,
 235411185,
 100868,
 -61941,
 235476513,
 100867,
 -61940,
 235541804,
 100866,
 -61939,
 235607128,
 100865,
 -61938,
 235672378,
 100864,
 -61937,
 235737621,
 100863,
 -61936,
 235802858,
 100862,
 -1,
 235868125,
 100861,
 236126207,
 235278301,
 -1,
 -61933,
 236001410,
 100860,
 -61932,
 236066769,
 100859,
 -61931,
 236132081,
 100858,
 -61930,
 236197409,
 100857,
 -61929,
 236262700,
 100856,
 -61928,
 236328024,
 100855,
 -61927,
 236393274,
 100854,
 -61926,
 236458517,
 100853,
 -61925,
 236523754,
 100852,
 -1,
 236589021,
 100851,
 236785291,
 229446744,
 -1,
 236850728,
 236722306,
 -1,
 -61921,
 236787842,
 100850,
 -61920,
 236853201,
 100849,
 -61919,
 236918513,
 100848,
 -61918,
 236983841,
 100847,
 -61917,
 237049132,
 100846,
 -61916,
 237114456,
 100845,
 -61915,
 237179706,
 100844,
 -61914,
 237244949,
 100843,
 -61913,
 237310186,
 100842,
 -1,
 237375453,
 100841,
 237571635,
 236787665,
 -1,
 -61910,
 237508738,
 100840,
 -61909,
 237574097,
 100839,
 -61908,
 237639409,
 100838,
 -61907,
 237704737,
 100837,
 -61906,
 237770028,
 100836,
 -61905,
 237835352,
 100835,
 -61904,
 237900602,
 100834,
 -61903,
 237965845,
 100833,
 -61902,
 238031082,
 100832,
 -1,
 238096349,
 100831,
 238292542,
 237508337,
 -1,
 -61899,
 238229634,
 100830,
 -61898,
 238294993,
 100829,
 -61897,
 238360305,
 100828,
 -61896,
 238425633,
 100827,
 -61895,
 238490924,
 100826,
 -61894,
 238556248,
 100825,
 -61893,
 238621498,
 100824,
 -61892,
 238686741,
 100823,
 -61891,
 238751978,
 100822,
 -1,
 238817245,
 100821,
 239013449,
 238229025,
 -1,
 -61888,
 238950530,
 100820,
 -61887,
 239015889,
 100819,
 -61886,
 239081201,
 100818,
 -61885,
 239146529,
 100817,
 -61884,
 239211820,
 100816,
 -61883,
 239277144,
 100815,
 -61882,
 239342394,
 100814,
 -61881,
 239407637,
 100813,
 -61880,
 239472874,
 100812,
 -1,
 239538141,
 100811,
 239734356,
 238949676,
 -1,
 -61877,
 239671426,
 100810,
 -61876,
 239736785,
 100809,
 -61875,
 239802097,
 100808,
 -61874,
 239867425,
 100807,
 -61873,
 239932716,
 100806,
 -61872,
 239998040,
 100805,
 -61871,
 240063290,
 100804,
 -61870,
 240128533,
 100803,
 -61869,
 240193770,
 100802,
 -1,
 240259037,
 100801,
 240455263,
 239670360,
 -1,
 -61866,
 240392322,
 100800,
 -61865,
 240457681,
 100799,
 -61864,
 240522993,
 100798,
 -61863,
 240588321,
 100797,
 -61862,
 240653612,
 100796,
 -61861,
 240718936,
 100795,
 -61860,
 240784186,
 100794,
 -61859,
 240849429,
 100793,
 -61858,
 240914666,
 100792,
 -1,
 240979933,
 100791,
 241176170,
 240390970,
 -1,
 -61855,
 241113218,
 100790,
 -61854,
 241178577,
 100789,
 -61853,
 241243889,
 100788,
 -61852,
 241309217,
 100787,
 -61851,
 241374508,
 100786,
 -61850,
 241439832,
 100785,
 -61849,
 241505082,
 100784,
 -61848,
 241570325,
 100783,
 -61847,
 241635562,
 100782,
 -1,
 241700829,
 100781,
 241897077,
 241111573,
 -1,
 -61844,
 241834114,
 100780,
 -61843,
 241899473,
 100779,
 -61842,
 241964785,
 100778,
 -61841,
 242030113,
 100777,
 -61840,
 242095404,
 100776,
 -61839,
 242160728,
 100775,
 -61838,
 242225978,
 100774,
 -61837,
 242291221,
 100773,
 -61836,
 242356458,
 100772,
 -1,
 242421725,
 100771,
 242617984,
 241832170,
 -1,
 -61833,
 242555010,
 100770,
 -61832,
 242620369,
 100769,
 -61831,
 242685681,
 100768,
 -61830,
 242751009,
 100767,
 -61829,
 242816300,
 100766,
 -61828,
 242881624,
 100765,
 -61827,
 242946874,
 100764,
 -61826,
 243012117,
 100763,
 -61825,
 243077354,
 100762,
 -1,
 243142621,
 100761,
 243400703,
 242552797,
 -1,
 -61822,
 243275906,
 100760,
 -61821,
 243341265,
 100759,
 -61820,
 243406577,
 100758,
 -61819,
 243471905,
 100757,
 -61818,
 243537196,
 100756,
 -61817,
 243602520,
 100755,
 -61816,
 243667770,
 100754,
 -61815,
 243733013,
 100753,
 -61814,
 243798250,
 100752,
 -1,
 243863517,
 100751,
 244059898,
 236720954,
 -1,
 244125335,
 243996802,
 -1,
 -61810,
 244062338,
 100750,
 -61809,
 244127697,
 100749,
 -61808,
 244193009,
 100748,
 -61807,
 244258337,
 100747,
 -61806,
 244323628,
 100746,
 -61805,
 244388952,
 100745,
 -61804,
 244454202,
 100744,
 -61803,
 244519445,
 100743,
 -61802,
 244584682,
 100742,
 -1,
 244649949,
 100741,
 244846242,
 244062161,
 -1,
 -61799,
 244783234,
 100740,
 -61798,
 244848593,
 100739,
 -61797,
 244913905,
 100738,
 -61796,
 244979233,
 100737,
 -61795,
 245044524,
 100736,
 -61794,
 245109848,
 100735,
 -61793,
 245175098,
 100734,
 -61792,
 245240341,
 100733,
 -61791,
 245305578,
 100732,
 -1,
 245370845,
 100731,
 245567149,
 244782833,
 -1,
 -61788,
 245504130,
 100730,
 -61787,
 245569489,
 100729,
 -61786,
 245634801,
 100728,
 -61785,
 245700129,
 100727,
 -61784,
 245765420,
 100726,
 -61783,
 245830744,
 100725,
 -61782,
 245895994,
 100724,
 -61781,
 245961237,
 100723,
 -61780,
 246026474,
 100722,
 -1,
 246091741,
 100721,
 246288056,
 245503521,
 -1,
 -61777,
 246225026,
 100720,
 -61776,
 246290385,
 100719,
 -61775,
 246355697,
 100718,
 -61774,
 246421025,
 100717,
 -61773,
 246486316,
 100716,
 -61772,
 246551640,
 100715,
 -61771,
 246616890,
 100714,
 -61770,
 246682133,
 100713,
 -61769,
 246747370,
 100712,
 -1,
 246812637,
 100711,
 247008963,
 246224172,
 -1,
 -61766,
 246945922,
 100710,
 -61765,
 247011281,
 100709,
 -61764,
 247076593,
 100708,
 -61763,
 247141921,
 100707,
 -61762,
 247207212,
 100706,
 -61761,
 247272536,
 100705,
 -61760,
 247337786,
 100704,
 -61759,
 247403029,
 100703,
 -61758,
 247468266,
 100702,
 -1,
 247533533,
 100701,
 247729870,
 246944856,
 -1,
 -61755,
 247666818,
 100700,
 -61754,
 247732177,
 100699,
 -61753,
 247797489,
 100698,
 -61752,
 247862817,
 100697,
 -61751,
 247928108,
 100696,
 -61750,
 247993432,
 100695,
 -61749,
 248058682,
 100694,
 -61748,
 248123925,
 100693,
 -61747,
 248189162,
 100692,
 -1,
 248254429,
 100691,
 248450777,
 247665466,
 -1,
 -61744,
 248387714,
 100690,
 -61743,
 248453073,
 100689,
 -61742,
 248518385,
 100688,
 -61741,
 248583713,
 100687,
 -61740,
 248649004,
 100686,
 -61739,
 248714328,
 100685,
 -61738,
 248779578,
 100684,
 -61737,
 248844821,
 100683,
 -61736,
 248910058,
 100682,
 -1,
 248975325,
 100681,
 249171684,
 248386069,
 -1,
 -61733,
 249108610,
 100680,
 -61732,
 249173969,
 100679,
 -61731,
 249239281,
 100678,
 -61730,
 249304609,
 100677,
 -61729,
 249369900,
 100676,
 -61728,
 249435224,
 100675,
 -61727,
 249500474,
 100674,
 -61726,
 249565717,
 100673,
 -61725,
 249630954,
 100672,
 -1,
 249696221,
 100671,
 249892591,
 249106666,
 -1,
 -61722,
 249829506,
 100670,
 -61721,
 249894865,
 100669,
 -61720,
 249960177,
 100668,
 -61719,
 250025505,
 100667,
 -61718,
 250090796,
 100666,
 -61717,
 250156120,
 100665,
 -61716,
 250221370,
 100664,
 -61715,
 250286613,
 100663,
 -61714,
 250351850,
 100662,
 -1,
 250417117,
 100661,
 250675199,
 249827293,
 -1,
 -61711,
 250550402,
 100660,
 -61710,
 250615761,
 100659,
 -61709,
 250681073,
 100658,
 -61708,
 250746401,
 100657,
 -61707,
 250811692,
 100656,
 -61706,
 250877016,
 100655,
 -61705,
 250942266,
 100654,
 -61704,
 251007509,
 100653,
 -61703,
 251072746,
 100652,
 -1,
 251138013,
 100651,
 251334505,
 243995157,
 -1,
 251399942,
 251271298,
 -1,
 -61699,
 251336834,
 100650,
 -61698,
 251402193,
 100649,
 -61697,
 251467505,
 100648,
 -61696,
 251532833,
 100647,
 -61695,
 251598124,
 100646,
 -61694,
 251663448,
 100645,
 -61693,
 251728698,
 100644,
 -61692,
 251793941,
 100643,
 -61691,
 251859178,
 100642,
 -1,
 251924445,
 100641,
 252120849,
 251336657,
 -1,
 -61688,
 252057730,
 100640,
 -61687,
 252123089,
 100639,
 -61686,
 252188401,
 100638,
 -61685,
 252253729,
 100637,
 -61684,
 252319020,
 100636,
 -61683,
 252384344,
 100635,
 -61682,
 252449594,
 100634,
 -61681,
 252514837,
 100633,
 -61680,
 252580074,
 100632,
 -1,
 252645341,
 100631,
 252841756,
 252057329,
 -1,
 -61677,
 252778626,
 100630,
 -61676,
 252843985,
 100629,
 -61675,
 252909297,
 100628,
 -61674,
 252974625,
 100627,
 -61673,
 253039916,
 100626,
 -61672,
 253105240,
 100625,
 -61671,
 253170490,
 100624,
 -61670,
 253235733,
 100623,
 -61669,
 253300970,
 100622,
 -1,
 253366237,
 100621,
 253562663,
 252778017,
 -1,
 -61666,
 253499522,
 100620,
 -61665,
 253564881,
 100619,
 -61664,
 253630193,
 100618,
 -61663,
 253695521,
 100617,
 -61662,
 253760812,
 100616,
 -61661,
 253826136,
 100615,
 -61660,
 253891386,
 100614,
 -61659,
 253956629,
 100613,
 -61658,
 254021866,
 100612,
 -1,
 254087133,
 100611,
 254283570,
 253498668,
 -1,
 -61655,
 254220418,
 100610,
 -61654,
 254285777,
 100609,
 -61653,
 254351089,
 100608,
 -61652,
 254416417,
 100607,
 -61651,
 254481708,
 100606,
 -61650,
 254547032,
 100605,
 -61649,
 254612282,
 100604,
 -61648,
 254677525,
 100603,
 -61647,
 254742762,
 100602,
 -1,
 254808029,
 100601,
 255004477,
 254219352,
 -1,
 -61644,
 254941314,
 100600,
 -61643,
 255006673,
 100599,
 -61642,
 255071985,
 100598,
 -61641,
 255137313,
 100597,
 -61640,
 255202604,
 100596,
 -61639,
 255267928,
 100595,
 -61638,
 255333178,
 100594,
 -61637,
 255398421,
 100593,
 -61636,
 255463658,
 100592,
 -1,
 255528925,
 100591,
 255725384,
 254939962,
 -1,
 -61633,
 255662210,
 100590,
 -61632,
 255727569,
 100589,
 -61631,
 255792881,
 100588,
 -61630,
 255858209,
 100587,
 -61629,
 255923500,
 100586,
 -61628,
 255988824,
 100585,
 -61627,
 256054074,
 100584,
 -61626,
 256119317,
 100583,
 -61625,
 256184554,
 100582,
 -1,
 256249821,
 100581,
 256446291,
 255660565,
 -1,
 -61622,
 256383106,
 100580,
 -61621,
 256448465,
 100579,
 -61620,
 256513777,
 100578,
 -61619,
 256579105,
 100577,
 -61618,
 256644396,
 100576,
 -61617,
 256709720,
 100575,
 -61616,
 256774970,
 100574,
 -61615,
 256840213,
 100573,
 -61614,
 256905450,
 100572,
 -1,
 256970717,
 100571,
 257167198,
 256381162,
 -1,
 -61611,
 257104002,
 100570,
 -61610,
 257169361,
 100569,
 -61609,
 257234673,
 100568,
 -61608,
 257300001,
 100567,
 -61607,
 257365292,
 100566,
 -61606,
 257430616,
 100565,
 -61605,
 257495866,
 100564,
 -61604,
 257561109,
 100563,
 -61603,
 257626346,
 100562,
 -1,
 257691613,
 100561,
 257949695,
 257101789,
 -1,
 -61600,
 257824898,
 100560,
 -61599,
 257890257,
 100559,
 -61598,
 257955569,
 100558,
 -61597,
 258020897,
 100557,
 -61596,
 258086188,
 100556,
 -61595,
 258151512,
 100555,
 -61594,
 258216762,
 100554,
 -61593,
 258282005,
 100553,
 -61592,
 258347242,
 100552,
 -1,
 258412509,
 100551,
 258609112,
 251269354,
 -1,
 258674549,
 258545794,
 -1,
 -61588,
 258611330,
 100550,
 -61587,
 258676689,
 100549,
 -61586,
 258742001,
 100548,
 -61585,
 258807329,
 100547,
 -61584,
 258872620,
 100546,
 -61583,
 258937944,
 100545,
 -61582,
 259003194,
 100544,
 -61581,
 259068437,
 100543,
 -61580,
 259133674,
 100542,
 -1,
 259198941,
 100541,
 259395456,
 258611153,
 -1,
 -61577,
 259332226,
 100540,
 -61576,
 259397585,
 100539,
 -61575,
 259462897,
 100538,
 -61574,
 259528225,
 100537,
 -61573,
 259593516,
 100536,
 -61572,
 259658840,
 100535,
 -61571,
 259724090,
 100534,
 -61570,
 259789333,
 100533,
 -61569,
 259854570,
 100532,
 -1,
 259919837,
 100531,
 260116363,
 259331825,
 -1,
 -61566,
 260053122,
 100530,
 -61565,
 260118481,
 100529,
 -61564,
 260183793,
 100528,
 -61563,
 260249121,
 100527,
 -61562,
 260314412,
 100526,
 -61561,
 260379736,
 100525,
 -61560,
 260444986,
 100524,
 -61559,
 260510229,
 100523,
 -61558,
 260575466,
 100522,
 -1,
 260640733,
 100521,
 260837270,
 260052513,
 -1,
 -61555,
 260774018,
 100520,
 -61554,
 260839377,
 100519,
 -61553,
 260904689,
 100518,
 -61552,
 260970017,
 100517,
 -61551,
 261035308,
 100516,
 -61550,
 261100632,
 100515,
 -61549,
 261165882,
 100514,
 -61548,
 261231125,
 100513,
 -61547,
 261296362,
 100512,
 -1,
 261361629,
 100511,
 261558177,
 260773164,
 -1,
 -61544,
 261494914,
 100510,
 -61543,
 261560273,
 100509,
 -61542,
 261625585,
 100508,
 -61541,
 261690913,
 100507,
 -61540,
 261756204,
 100506,
 -61539,
 261821528,
 100505,
 -61538,
 261886778,
 100504,
 -61537,
 261952021,
 100503,
 -61536,
 262017258,
 100502,
 -1,
 262082525,
 100501,
 262279084,
 261493848,
 -1,
 -61533,
 262215810,
 100500,
 -61532,
 262281169,
 100499,
 -61531,
 262346481,
 100498,
 -61530,
 262411809,
 100497,
 -61529,
 262477100,
 100496,
 -61528,
 262542424,
 100495,
 -61527,
 262607674,
 100494,
 -61526,
 262672917,
 100493,
 -61525,
 262738154,
 100492,
 -1,
 262803421,
 100491,
 262999991,
 262214458,
 -1,
 -61522,
 262936706,
 100490,
 -61521,
 263002065,
 100489,
 -61520,
 263067377,
 100488,
 -61519,
 263132705,
 100487,
 -61518,
 263197996,
 100486,
 -61517,
 263263320,
 100485,
 -61516,
 263328570,
 100484,
 -61515,
 263393813,
 100483,
 -61514,
 263459050,
 100482,
 -1,
 263524317,
 100481,
 263720898,
 262935061,
 -1,
 -61511,
 263657602,
 100480,
 -61510,
 263722961,
 100479,
 -61509,
 263788273,
 100478,
 -61508,
 263853601,
 100477,
 -61507,
 263918892,
 100476,
 -61506,
 263984216,
 100475,
 -61505,
 264049466,
 100474,
 -61504,
 264114709,
 100473,
 -61503,
 264179946,
 100472,
 -1,
 264245213,
 100471,
 264441805,
 263655658,
 -1,
 -61500,
 264378498,
 100470,
 -61499,
 264443857,
 100469,
 -61498,
 264509169,
 100468,
 -61497,
 264574497,
 100467,
 -61496,
 264639788,
 100466,
 -61495,
 264705112,
 100465,
 -61494,
 264770362,
 100464,
 -61493,
 264835605,
 100463,
 -61492,
 264900842,
 100462,
 -1,
 264966109,
 100461,
 265224191,
 264376285,
 -1,
 -61489,
 265099394,
 100460,
 -61488,
 265164753,
 100459,
 -61487,
 265230065,
 100458,
 -61486,
 265295393,
 100457,
 -61485,
 265360684,
 100456,
 -61484,
 265426008,
 100455,
 -61483,
 265491258,
 100454,
 -61482,
 265556501,
 100453,
 -61481,
 265621738,
 100452,
 -1,
 265687005,
 100451,
 265883718,
 258543581,
 -1,
 265949156,
 265820290,
 -1,
 -61477,
 265885826,
 100450,
 -61476,
 265951185,
 100449,
 -61475,
 266016497,
 100448,
 -61474,
 266081825,
 100447,
 -61473,
 266147116,
 100446,
 -61472,
 266212440,
 100445,
 -61471,
 266277690,
 100444,
 -61470,
 266342933,
 100443,
 -61469,
 266408170,
 100442,
 -1,
 266473437,
 100441,
 266670063,
 265885649,
 -1,
 -61466,
 266606722,
 100440,
 -61465,
 266672081,
 100439,
 -61464,
 266737393,
 100438,
 -61463,
 266802721,
 100437,
 -61462,
 266868012,
 100436,
 -61461,
 266933336,
 100435,
 -61460,
 266998586,
 100434,
 -61459,
 267063829,
 100433,
 -61458,
 267129066,
 100432,
 -1,
 267194333,
 100431,
 267390970,
 266606321,
 -1,
 -61455,
 267327618,
 100430,
 -61454,
 267392977,
 100429,
 -61453,
 267458289,
 100428,
 -61452,
 267523617,
 100427,
 -61451,
 267588908,
 100426,
 -61450,
 267654232,
 100425,
 -61449,
 267719482,
 100424,
 -61448,
 267784725,
 100423,
 -61447,
 267849962,
 100422,
 -1,
 267915229,
 100421,
 268111877,
 267327009,
 -1,
 -61444,
 268048514,
 100420,
 -61443,
 268113873,
 100419,
 -61442,
 268179185,
 100418,
 -61441,
 268244513,
 100417,
 -61440,
 268309804,
 100416,
 -61439,
 268375128,
 100415,
 -61438,
 268440378,
 100414,
 -61437,
 268505621,
 100413,
 -61436,
 268570858,
 100412,
 -1,
 268636125,
 100411,
 268832784,
 268047660,
 -1,
 -61433,
 268769410,
 100410,
 -61432,
 268834769,
 100409,
 -61431,
 268900081,
 100408,
 -61430,
 268965409,
 100407,
 -61429,
 269030700,
 100406,
 -61428,
 269096024,
 100405,
 -61427,
 269161274,
 100404,
 -61426,
 269226517,
 100403,
 -61425,
 269291754,
 100402,
 -1,
 269357021,
 100401,
 269553691,
 268768344,
 -1,
 -61422,
 269490306,
 100400,
 -61421,
 269555665,
 100399,
 -61420,
 269620977,
 100398,
 -61419,
 269686305,
 100397,
 -61418,
 269751596,
 100396,
 -61417,
 269816920,
 100395,
 -61416,
 269882170,
 100394,
 -61415,
 269947413,
 100393,
 -61414,
 270012650,
 100392,
 -1,
 270077917,
 100391,
 270274598,
 269488954,
 -1,
 -61411,
 270211202,
 100390,
 -61410,
 270276561,
 100389,
 -61409,
 270341873,
 100388,
 -61408,
 270407201,
 100387,
 -61407,
 270472492,
 100386,
 -61406,
 270537816,
 100385,
 -61405,
 270603066,
 100384,
 -61404,
 270668309,
 100383,
 -61403,
 270733546,
 100382,
 -1,
 270798813,
 100381,
 270995505,
 270209557,
 -1,
 -61400,
 270932098,
 100380,
 -61399,
 270997457,
 100379,
 -61398,
 271062769,
 100378,
 -61397,
 271128097,
 100377,
 -61396,
 271193388,
 100376,
 -61395,
 271258712,
 100375,
 -61394,
 271323962,
 100374,
 -61393,
 271389205,
 100373,
 -61392,
 271454442,
 100372,
 -1,
 271519709,
 100371,
 271716412,
 270930154,
 -1,
 -61389,
 271652994,
 100370,
 -61388,
 271718353,
 100369,
 -61387,
 271783665,
 100368,
 -61386,
 271848993,
 100367,
 -61385,
 271914284,
 100366,
 -61384,
 271979608,
 100365,
 -61383,
 272044858,
 100364,
 -61382,
 272110101,
 100363,
 -61381,
 272175338,
 100362,
 -1,
 272240605,
 100361,
 272498687,
 271650781,
 -1,
 -61378,
 272373890,
 100360,
 -61377,
 272439249,
 100359,
 -61376,
 272504561,
 100358,
 -61375,
 272569889,
 100357,
 -61374,
 272635180,
 100356,
 -61373,
 272700504,
 100355,
 -61372,
 272765754,
 100354,
 -61371,
 272830997,
 100353,
 -1,
 272896234,
 100352,
 273154047,
 265819889,
 -1,
 273158226,
 273028184,
 -1,
 -61367,
 273094786,
 101100,
 -61366,
 273160145,
 101099,
 -61365,
 273225457,
 101098,
 -61364,
 273290785,
 101097,
 -61363,
 273356076,
 101096,
 -61362,
 273421400,
 101095,
 -61361,
 273486650,
 101094,
 -61360,
 273551893,
 101093,
 -61359,
 273617130,
 101092,
 -1,
 273682397,
 101091,
 273879133,
 273093434,
 -1,
 -61356,
 273815682,
 101090,
 -61355,
 273881041,
 101089,
 -61354,
 273946353,
 101088,
 -61353,
 274011681,
 101087,
 -61352,
 274076972,
 101086,
 -61351,
 274142296,
 101085,
 -61350,
 274207546,
 101084,
 -61349,
 274272789,
 101083,
 -61348,
 274338026,
 101082,
 -1,
 274403293,
 101081,
 274600040,
 273814037,
 -1,
 -61345,
 274536578,
 101080,
 -61344,
 274601937,
 101079,
 -61343,
 274667249,
 101078,
 -61342,
 274732577,
 101077,
 -61341,
 274797868,
 101076,
 -61340,
 274863192,
 101075,
 -61339,
 274928442,
 101074,
 -61338,
 274993685,
 101073,
 -61337,
 275058922,
 101072,
 -1,
 275124189,
 101071,
 275320947,
 274534634,
 -1,
 -61334,
 275257474,
 101070,
 -61333,
 275322833,
 101069,
 -61332,
 275388145,
 101068,
 -61331,
 275453473,
 101067,
 -61330,
 275518764,
 101066,
 -61329,
 275584088,
 101065,
 -61328,
 275649338,
 101064,
 -61327,
 275714581,
 101063,
 -61326,
 275779818,
 101062,
 -1,
 275845085,
 101061,
 276041854,
 275255261,
 -1,
 -61323,
 275978370,
 101060,
 -61322,
 276043729,
 101059,
 -61321,
 276109041,
 101058,
 -61320,
 276174369,
 101057,
 -61319,
 276239660,
 101056,
 -61318,
 276304984,
 101055,
 -61317,
 276370234,
 101054,
 -61316,
 276435477,
 101053,
 -61315,
 276500714,
 101052,
 -1,
 276565981,
 101051,
 276824063,
 275977516,
 -1,
 -61312,
 276698412,
 101106,
 -61311,
 276763736,
 101105,
 -61310,
 276828986,
 101104,
 -61309,
 276894229,
 101103,
 -61308,
 276959466,
 101102,
 -1,
 277024733,
 101101,
 -1,
 222129613,
 94176,
 -1,
 222054687,
 127818,
 -1,
 221977129,
 127883,
 277418473,
 221939180,
 -1,
 277483971,
 277398049,
 -1,
 277549259,
 277449000,
 -1,
 277614757,
 277514536,
 -1,
 277680281,
 277580072,
 -1,
 277745809,
 277616948,
 -1,
 -61297,
 277728797,
 983864,
 -61296,
 277766529,
 983861,
 -1,
 277813556,
 983854,
 278007955,
 277728797,
 983857,
 -1,
 277990941,
 983858,
 278139029,
 277975185,
 983862,
 -1,
 278106257,
 983863,
 278270103,
 278094209,
 983855,
 -1,
 278225281,
 983856,
 278462463,
 278216899,
 983859,
 -1,
 278347971,
 983860,
 278532253,
 277616948,
 -1,
 -61285,
 278515229,
 983732,
 -61284,
 278552961,
 983729,
 -1,
 278599988,
 983722,
 278794399,
 278515229,
 983725,
 -1,
 278777373,
 983726,
 278925473,
 278761617,
 983730,
 -1,
 278892689,
 983731,
 279056547,
 278880641,
 983723,
 -1,
 279011713,
 983724,
 279248895,
 279003331,
 983727,
 -1,
 279134403,
 983728,
 279318706,
 277603084,
 -1,
 279384234,
 279255348,
 -1,
 -61272,
 279367197,
 983710,
 -61271,
 279404929,
 983707,
 -1,
 279451956,
 983700,
 279646380,
 279367197,
 983703,
 -1,
 279629341,
 983704,
 279777454,
 279613585,
 983708,
 -1,
 279744657,
 983709,
 279908528,
 279732609,
 983701,
 -1,
 279863681,
 983702,
 280100863,
 279855299,
 983705,
 -1,
 279986371,
 983706,
 280170687,
 279270130,
 -1,
 280236215,
 280107316,
 -1,
 -61259,
 280219165,
 983688,
 -61258,
 280256897,
 983685,
 -1,
 280303924,
 983678,
 280498361,
 280219165,
 983681,
 -1,
 280481309,
 983682,
 280629435,
 280465553,
 983686,
 -1,
 280596625,
 983687,
 280760509,
 280584577,
 983679,
 -1,
 280715649,
 983680,
 280952831,
 280707267,
 983683,
 -1,
 280838339,
 983684,
 281022659,
 280107316,
 -1,
 -61247,
 281005597,
 983754,
 -61246,
 281043329,
 983751,
 -1,
 281090356,
 983744,
 281284805,
 281005597,
 983747,
 -1,
 281267741,
 983748,
 281415879,
 281251985,
 983752,
 -1,
 281383057,
 983753,
 281546953,
 281371009,
 983745,
 -1,
 281502081,
 983746,
 281739263,
 281493699,
 983749,
 -1,
 281624771,
 983750,
 281809139,
 277525847,
 -1,
 281874650,
 281761832,
 -1,
 281940177,
 281811252,
 -1,
 -61233,
 281923101,
 983886,
 -61232,
 281960833,
 983883,
 -1,
 282007860,
 983876,
 282202323,
 281923101,
 983879,
 -1,
 282185245,
 983880,
 282333397,
 282169489,
 983884,
 -1,
 282300561,
 983885,
 282464471,
 282288513,
 983877,
 -1,
 282419585,
 983878,
 282595545,
 282411203,
 983881,
 -1,
 282542275,
 983882,
 -1,
 282570992,
 983932,
 282792167,
 281851223,
 -1,
 282857695,
 282728756,
 -1,
 -61219,
 282840605,
 983897,
 -61218,
 282878337,
 983894,
 -1,
 282925364,
 983887,
 283119841,
 282840605,
 983890,
 -1,
 283102749,
 983891,
 283250915,
 283086993,
 983895,
 -1,
 283218065,
 983896,
 283381989,
 283206017,
 983888,
 -1,
 283337089,
 983889,
 283574271,
 283328707,
 983892,
 -1,
 283459779,
 983893,
 283644139,
 282728756,
 -1,
 -61207,
 283627037,
 983908,
 -61206,
 283664769,
 983905,
 -1,
 283711796,
 983898,
 283906285,
 283627037,
 983901,
 -1,
 283889181,
 983902,
 284037359,
 283873425,
 983906,
 -1,
 284004497,
 983907,
 284168433,
 283992449,
 983899,
 -1,
 284123521,
 983900,
 284360703,
 284115139,
 983903,
 -1,
 284246211,
 983904,
 284430618,
 281769036,
 -1,
 284496142,
 284390476,
 -1,
 284561666,
 284456012,
 -1,
 284627194,
 284498228,
 -1,
 -61192,
 284610077,
 983831,
 -61191,
 284647809,
 983828,
 -1,
 284694836,
 983821,
 284889340,
 284610077,
 983824,
 -1,
 284872221,
 983825,
 285020414,
 284856465,
 983829,
 -1,
 284987537,
 983830,
 285151488,
 284975489,
 983822,
 -1,
 285106561,
 983823,
 285343743,
 285098179,
 983826,
 -1,
 285229251,
 983827,
 285413638,
 284498228,
 -1,
 -61180,
 285396509,
 983842,
 -61179,
 285434241,
 983839,
 -1,
 285481268,
 983832,
 285675784,
 285396509,
 983835,
 -1,
 285658653,
 983836,
 285806858,
 285642897,
 983840,
 -1,
 285773969,
 983841,
 285937932,
 285761921,
 983833,
 -1,
 285892993,
 983834,
 286130175,
 285884611,
 983837,
 -1,
 286015683,
 983838,
 286200082,
 284432692,
 -1,
 -61168,
 286182941,
 983809,
 -61167,
 286220673,
 983806,
 -1,
 286267700,
 983799,
 286462228,
 286182941,
 983802,
 -1,
 286445085,
 983803,
 286593302,
 286429329,
 983807,
 -1,
 286560401,
 983808,
 286724376,
 286548353,
 983800,
 -1,
 286679425,
 983801,
 286916607,
 286671043,
 983804,
 -1,
 286802115,
 983805,
 286986548,
 284389515,
 -1,
 287052072,
 286965414,
 -1,
 287117600,
 286988596,
 983920,
 -61154,
 287100445,
 983931,
 -61153,
 287138177,
 983928,
 -1,
 287185204,
 983921,
 287379746,
 287100445,
 983924,
 -1,
 287362589,
 983925,
 287510820,
 287346833,
 983929,
 -1,
 287477905,
 983930,
 287641894,
 287465857,
 983922,
 -1,
 287596929,
 983923,
 287834111,
 287588547,
 983926,
 -1,
 287719619,
 983927,
 287904044,
 286988596,
 -1,
 -61142,
 287886877,
 983677,
 -61141,
 287924609,
 983674,
 -1,
 287971636,
 983667,
 288166190,
 287886877,
 983670,
 -1,
 288149021,
 983671,
 288297264,
 288133265,
 983675,
 -1,
 288264337,
 983676,
 288428338,
 288252289,
 983668,
 -1,
 288383361,
 983669,
 288620543,
 288374979,
 983672,
 -1,
 288506051,
 983673,
 288690510,
 286966418,
 -1,
 288756034,
 288670354,
 -1,
 288821562,
 288692532,
 -1,
 -61128,
 288804381,
 983721,
 -61127,
 288842113,
 983718,
 -1,
 288889140,
 983711,
 289083708,
 288804381,
 983714,
 -1,
 289066525,
 983715,
 289214782,
 289050769,
 983719,
 -1,
 289181841,
 983720,
 289345856,
 289169793,
 983712,
 -1,
 289300865,
 983713,
 289538047,
 289292483,
 983716,
 -1,
 289423555,
 983717,
 289608006,
 288692532,
 -1,
 -61116,
 289590813,
 983743,
 -61115,
 289628545,
 983740,
 -1,
 289675572,
 983733,
 289870152,
 289590813,
 983736,
 -1,
 289852957,
 983737,
 290001226,
 289837201,
 983741,
 -1,
 289968273,
 983742,
 290132300,
 289956225,
 983734,
 -1,
 290087297,
 983735,
 290324479,
 290078915,
 983738,
 -1,
 290209987,
 983739,
 290394472,
 288663682,
 -1,
 290459996,
 290367618,
 -1,
 290525524,
 290396468,
 -1,
 -61102,
 290508317,
 983853,
 -61101,
 290546049,
 983850,
 -1,
 290593076,
 983843,
 290787670,
 290508317,
 983846,
 -1,
 290770461,
 983847,
 290918744,
 290754705,
 983851,
 -1,
 290885777,
 983852,
 291049818,
 290873729,
 983844,
 -1,
 291004801,
 983845,
 291241983,
 290996419,
 983848,
 -1,
 291127491,
 983849,
 291311968,
 290396468,
 -1,
 -61090,
 291294749,
 983798,
 -61089,
 291332481,
 983795,
 -1,
 291379508,
 983788,
 291574114,
 291294749,
 983791,
 -1,
 291556893,
 983792,
 291705188,
 291541137,
 983796,
 -1,
 291672209,
 983797,
 291836262,
 291660161,
 983789,
 -1,
 291791233,
 983790,
 292028415,
 291782851,
 983793,
 -1,
 291913923,
 983794,
 292098421,
 290382604,
 -1,
 292163949,
 292034868,
 -1,
 -61077,
 292146717,
 983787,
 -61076,
 292184449,
 983784,
 -1,
 292231476,
 983777,
 292426095,
 292146717,
 983780,
 -1,
 292408861,
 983781,
 292557169,
 292393105,
 983785,
 -1,
 292524177,
 983786,
 292688243,
 292512129,
 983778,
 -1,
 292643201,
 983779,
 292880383,
 292634819,
 983782,
 -1,
 292765891,
 983783,
 292950402,
 292083192,
 -1,
 293015930,
 292886836,
 -1,
 -61064,
 292998685,
 983820,
 -61063,
 293036417,
 983817,
 -1,
 293083444,
 983810,
 293278076,
 292998685,
 983813,
 -1,
 293260829,
 983814,
 293409150,
 293245073,
 983818,
 -1,
 293376145,
 983819,
 293540224,
 293364097,
 983811,
 -1,
 293495169,
 983812,
 293732351,
 293486787,
 983815,
 -1,
 293617859,
 983816,
 293802383,
 292921037,
 -1,
 293867911,
 293738804,
 -1,
 -61051,
 293850653,
 983765,
 -61050,
 293888385,
 983762,
 -1,
 293935412,
 983755,
 294130057,
 293850653,
 983758,
 -1,
 294112797,
 983759,
 294261131,
 294097041,
 983763,
 -1,
 294228113,
 983764,
 294392205,
 294216065,
 983756,
 -1,
 294347137,
 983757,
 294584319,
 294338755,
 983760,
 -1,
 294469827,
 983761,
 294654364,
 293765253,
 -1,
 294719892,
 294590772,
 -1,
 -61038,
 294702621,
 983776,
 -61037,
 294740353,
 983773,
 -1,
 294787380,
 983766,
 294982038,
 294702621,
 983769,
 -1,
 294964765,
 983770,
 295113112,
 294949009,
 983774,
 -1,
 295080081,
 983775,
 295244186,
 295068033,
 983767,
 -1,
 295199105,
 983768,
 295436287,
 295190723,
 983771,
 -1,
 295321795,
 983772,
 295506345,
 294612831,
 -1,
 295571873,
 295442740,
 -1,
 -61025,
 295554589,
 983875,
 -61024,
 295592321,
 983872,
 -1,
 295639348,
 983865,
 295834019,
 295554589,
 983868,
 -1,
 295816733,
 983869,
 295965093,
 295800977,
 983873,
 -1,
 295932049,
 983874,
 296096167,
 295920001,
 983866,
 -1,
 296051073,
 983867,
 296288255,
 296042691,
 983870,
 -1,
 296173763,
 983871,
 296358326,
 295458856,
 -1,
 296423854,
 296294708,
 -1,
 -61012,
 296406557,
 983919,
 -61011,
 296444289,
 983916,
 -1,
 296491316,
 983909,
 296686000,
 296406557,
 983912,
 -1,
 296668701,
 983913,
 296817074,
 296652945,
 983917,
 -1,
 296784017,
 983918,
 296948148,
 296771969,
 983910,
 -1,
 296903041,
 983911,
 297140223,
 296894659,
 983914,
 -1,
 297025731,
 983915,
 297271295,
 296299748,
 -1,
 297275835,
 297146676,
 -1,
 -60999,
 297258525,
 983699,
 -60998,
 297296257,
 983696,
 -1,
 297343284,
 983689,
 297537981,
 297258525,
 983692,
 -1,
 297520669,
 983693,
 297669055,
 297504913,
 983697,
 -1,
 297635985,
 983698,
 297800129,
 297623937,
 983690,
 -1,
 297755009,
 983691,
 297992191,
 297746627,
 983694,
 -1,
 297877699,
 983695,
 298062302,
 277425380,
 -1,
 298127837,
 298030654,
 -1,
 298193354,
 298092840,
 983650,
 298258888,
 298158376,
 983648,
 -1,
 298223912,
 983660,
 -60983,
 298246924,
 983646,
 -1,
 298341106,
 983644,
 298521037,
 298169687,
 983664,
 -60980,
 298497367,
 983663,
 -1,
 298539048,
 983662,
 298717648,
 298480716,
 983655,
 298844159,
 298677324,
 983658,
 -1,
 298742860,
 983657,
 298914258,
 298697362,
 983649,
 -1,
 298893970,
 983647,
 299045332,
 298887298,
 983654,
 -1,
 299018370,
 983659,
 299176406,
 299004043,
 983643,
 -1,
 299155110,
 983666,
 -60969,
 299164428,
 983653,
 -60968,
 299292152,
 983656,
 -60967,
 299343565,
 983651,
 -60966,
 299401349,
 983652,
 -60965,
 299462495,
 983661,
 -60964,
 299522088,
 983665,
 -1,
 299576548,
 983645,
 -1,
 298101840,
 3063,
 299831778,
 298006543,
 -1,
 -60960,
 299787566,
 3046,
 -60959,
 299844319,
 3062,
 -1,
 299902595,
 3059,
 -60957,
 299820025,
 3061,
 -60956,
 300070179,
 3065,
 -60955,
 300127123,
 3024,
 -60954,
 300191695,
 3066,
 -60953,
 300255120,
 3060,
 -60952,
 300317368,
 2998,
 -1,
 300360730,
 3064,
 300552986,
 277373315,
 -1,
 300618386,
 300533184,
 -1,
 300683823,
 300579467,
 -1,
 300749316,
 300643404,
 -1,
 300814848,
 300719608,
 -1,
 300880370,
 300773515,
 -1,
 -60944,
 300868132,
 6692,
 -60943,
 300898366,
 6693,
 -1,
 300947764,
 6691,
 301142517,
 300860050,
 -1,
 -60940,
 301094974,
 6709,
 -1,
 301144372,
 6708,
 301339128,
 301113037,
 -1,
 -60937,
 301291582,
 6717,
 -1,
 301340980,
 6715,
 301535739,
 301280484,
 -1,
 -60934,
 301488190,
 6699,
 -1,
 301537588,
 6697,
 -60932,
 301523828,
 6719,
 -60931,
 301708801,
 6698,
 -60930,
 301771374,
 6704,
 -60929,
 301815870,
 6732,
 -1,
 301878588,
 6716,
 302060034,
 300751156,
 6723,
 -1,
 302006467,
 6739,
 -60925,
 302043224,
 6724,
 -1,
 302150806,
 6730,
 302322202,
 300702909,
 -1,
 302387721,
 302298455,
 -1,
 -60921,
 302364161,
 6727,
 -60920,
 302405694,
 6726,
 -1,
 302455092,
 6728,
 302649869,
 302346379,
 -1,
 -60917,
 302637604,
 6690,
 -60916,
 302667838,
 6689,
 -1,
 302717236,
 6688,
 302912016,
 302629522,
 -1,
 -60913,
 302864446,
 6707,
 -1,
 302913844,
 6706,
 303108627,
 302882509,
 -1,
 -60910,
 303061054,
 6713,
 -1,
 303110452,
 6712,
 303305238,
 303049956,
 -1,
 -60907,
 303257662,
 6696,
 -1,
 303307060,
 6695,
 -60905,
 303293300,
 6720,
 -60904,
 303475310,
 6702,
 -60903,
 303519806,
 6729,
 -1,
 303582524,
 6714,
 303763999,
 302295170,
 -1,
 303829534,
 303700276,
 6721,
 -60899,
 303809304,
 6701,
 -1,
 303860082,
 6705,
 -1,
 303812696,
 6722,
 304091683,
 303728936,
 -1,
 -60895,
 304079732,
 6700,
 -60894,
 304108353,
 6694,
 -1,
 304159028,
 6710,
 304353829,
 304074269,
 6735,
 -1,
 304336413,
 6736,
 304484903,
 304308609,
 6733,
 -1,
 304439681,
 6734,
 -60888,
 304470820,
 6725,
 -60887,
 304584311,
 6738,
 -60886,
 304644315,
 6718,
 -60885,
 304699234,
 6740,
 -60884,
 304759733,
 6737,
 -60883,
 304822430,
 6703,
 -60882,
 304883444,
 6711,
 -1,
 304945460,
 6731,
 305140305,
 300661449,
 -1,
 305205818,
 305098891,
 -1,
 305271351,
 305160430,
 -1,
 305336886,
 305203938,
 -1,
 -60876,
 305272108,
 6777,
 -60875,
 305337432,
 6776,
 -1,
 305402682,
 6775,
 -1,
 305270520,
 6780,
 305664569,
 305207810,
 6824,
 -1,
 305624095,
 6825,
 -1,
 305612807,
 6819,
 305861183,
 305182209,
 -1,
 305926717,
 305842412,
 6826,
 -1,
 305886239,
 6827,
 -60866,
 305912693,
 6818,
 -1,
 306017203,
 6752,
 306188868,
 305824073,
 -1,
 306254402,
 306147654,
 6772,
 -1,
 306185222,
 6744,
 -60861,
 306242489,
 6823,
 -1,
 306361982,
 6779,
 306516550,
 306175483,
 6816,
 -1,
 306502443,
 6817,
 306647625,
 306497901,
 -1,
 -60856,
 306582037,
 6774,
 -1,
 306647274,
 6773,
 306844236,
 306620546,
 -1,
 -60853,
 306793344,
 6822,
 -1,
 306846029,
 6778,
 307040847,
 306796584,
 -1,
 -60850,
 307011217,
 6820,
 -1,
 307044540,
 6828,
 -60848,
 306986033,
 6821,
 -1,
 307178786,
 6829,
 307368551,
 305126000,
 -1,
 307434072,
 307335313,
 6763,
 307499606,
 307370294,
 -1,
 -60843,
 307439790,
 6764,
 -1,
 307501680,
 6771,
 -60841,
 307487500,
 6765,
 -1,
 307662993,
 6768,
 307827292,
 307416605,
 6761,
 307892827,
 307809821,
 6762,
 -1,
 307839171,
 6760,
 -1,
 307839171,
 6759,
 308089440,
 307763508,
 6753,
 -60834,
 308044161,
 6769,
 -60833,
 308101315,
 6767,
 -1,
 308156724,
 6755,
 308351587,
 308069010,
 -1,
 -60830,
 308304195,
 6770,
 -1,
 308354784,
 6756,
 308548197,
 308306305,
 6757,
 -1,
 308502913,
 6758,
 -60826,
 308511060,
 6754,
 -1,
 308625603,
 6766,
 308810357,
 307348934,
 -1,
 308875883,
 308789906,
 -1,
 -60822,
 308862992,
 6802,
 -1,
 308895697,
 6803,
 309072494,
 308852055,
 -1,
 -60819,
 309030610,
 6806,
 -1,
 309086955,
 6807,
 309269105,
 309021927,
 -1,
 -60816,
 309238555,
 6804,
 -1,
 309292576,
 6805,
 -60814,
 309257866,
 6800,
 -60813,
 309433519,
 6801,
 -60812,
 309497048,
 6809,
 -1,
 309544205,
 6808,
 309727875,
 308764348,
 -1,
 309793401,
 309707410,
 -1,
 -60808,
 309780496,
 6786,
 -1,
 309813201,
 6787,
 309990012,
 309769559,
 -1,
 -60805,
 309948114,
 6790,
 -1,
 310004459,
 6791,
 310186623,
 309939431,
 -1,
 -60802,
 310156059,
 6788,
 -1,
 310210080,
 6789,
 -60800,
 310175370,
 6784,
 -60799,
 310351023,
 6785,
 -60798,
 310414552,
 6793,
 -1,
 310461709,
 6792,
 310706175,
 309670732,
 -1,
 310710929,
 310611682,
 -1,
 310776458,
 310673541,
 -1,
 310841993,
 310723471,
 -1,
 -60792,
 310814965,
 6741,
 -1,
 310867094,
 6742,
 -1,
 310778164,
 6748,
 311104141,
 310735948,
 -1,
 -60788,
 311074308,
 6746,
 -1,
 311105951,
 6743,
 -60786,
 311080449,
 6750,
 -60785,
 311254211,
 6747,
 -60784,
 311316179,
 6745,
 -1,
 311371508,
 6749,
 -1,
 310674243,
 6783,
 311628528,
 300603658,
 -1,
 311694034,
 311589515,
 -1,
 311759539,
 311656136,
 -1,
 311825049,
 311724328,
 -1,
 -60777,
 311813412,
 43664,
 -60776,
 311857297,
 43672,
 -1,
 311908034,
 43656,
 312087198,
 311783563,
 -1,
 312152733,
 312039464,
 -1,
 -60772,
 312119441,
 43650,
 -1,
 312172056,
 43652,
 -1,
 312119441,
 43648,
 312414881,
 312066706,
 -1,
 -60768,
 312381585,
 43668,
 -1,
 312434200,
 43670,
 312611492,
 312385229,
 -1,
 -60765,
 312578193,
 43676,
 -1,
 312630808,
 43678,
 312808103,
 312552676,
 -1,
 -60762,
 312774801,
 43658,
 -1,
 312827416,
 43660,
 -60760,
 312796452,
 43684,
 -60759,
 312990064,
 43690,
 -60758,
 313048415,
 43662,
 -60757,
 313111300,
 43686,
 -60756,
 313168017,
 43694,
 -60755,
 313231088,
 43682,
 -60754,
 313294278,
 43688,
 -60753,
 313351704,
 43692,
 -60752,
 313415362,
 43654,
 -60751,
 313479289,
 43680,
 -60750,
 313539597,
 43666,
 -1,
 313600730,
 43674,
 313851903,
 311712957,
 -1,
 313856696,
 313755944,
 -1,
 -60746,
 313845028,
 43665,
 -60745,
 313888913,
 43673,
 -1,
 313939650,
 43657,
 314118845,
 313815179,
 -1,
 314184380,
 314071080,
 -1,
 -60741,
 314151057,
 43651,
 -1,
 314203672,
 43653,
 -1,
 314151057,
 43649,
 314446528,
 314098322,
 -1,
 -60737,
 314413201,
 43669,
 -1,
 314465816,
 43671,
 314643139,
 314416845,
 -1,
 -60734,
 314609809,
 43677,
 -1,
 314662424,
 43679,
 314839750,
 314584292,
 -1,
 -60731,
 314806417,
 43659,
 -1,
 314859032,
 43661,
 -60729,
 314828068,
 43685,
 -60728,
 315021680,
 43691,
 -60727,
 315080031,
 43663,
 -60726,
 315142916,
 43687,
 -60725,
 315199633,
 43695,
 -60724,
 315262704,
 43683,
 -60723,
 315325894,
 43689,
 -60722,
 315383320,
 43693,
 -60721,
 315446978,
 43655,
 -60720,
 315510905,
 43681,
 -60719,
 315571213,
 43667,
 -1,
 315632346,
 43675,
 315822817,
 311679534,
 -1,
 315888345,
 315758900,
 -1,
 -60715,
 315876108,
 43708,
 -60714,
 315936856,
 43707,
 -60713,
 315984168,
 43709,
 -60712,
 316047493,
 43710,
 -1,
 316086580,
 43697,
 316281565,
 315870749,
 43700,
 316347100,
 316227779,
 43699,
 -1,
 316283188,
 43705,
 -1,
 316283188,
 43706,
 316543711,
 316236161,
 43698,
 -1,
 316479796,
 43704,
 -60704,
 316510353,
 43702,
 -1,
 316620995,
 43701,
 316805864,
 315802198,
 -1,
 316871397,
 316765032,
 -1,
 -60700,
 316836136,
 43739,
 -1,
 316891540,
 43743,
 -60698,
 316847742,
 43741,
 -60697,
 317034423,
 43740,
 -1,
 317087259,
 43742,
 317264621,
 316787043,
 -1,
 -60694,
 317245017,
 43713,
 -60693,
 317308329,
 43714,
 -60692,
 317362103,
 43712,
 -1,
 317408647,
 43711,
 317652991,
 317227342,
 -1,
 -60689,
 317545909,
 43703,
 -1,
 317595836,
 43696,
 317849599,
 311588700,
 -1,
 317854461,
 317768338,
 -1,
 317919992,
 317822307,
 -1,
 -60684,
 317855265,
 6516,
 -60683,
 317920556,
 6515,
 -60682,
 317985880,
 6514,
 -60681,
 318051130,
 6513,
 -1,
 318116373,
 6512,
 318313211,
 317896023,
 -1,
 -60678,
 318265406,
 6497,
 -1,
 318314804,
 6483,
 -60676,
 318265406,
 6487,
 -1,
 318445876,
 6486,
 318640896,
 317800643,
 6507,
 -60673,
 318593064,
 6502,
 -1,
 318652611,
 6501,
 318837507,
 318576948,
 6499,
 -60670,
 318820440,
 6508,
 -1,
 318857601,
 6509,
 319034117,
 318819869,
 6503,
 -1,
 318980291,
 6506,
 319165192,
 319004365,
 -1,
 -60665,
 319117374,
 6490,
 -1,
 319166772,
 6489,
 319361802,
 319131793,
 6505,
 -1,
 319328401,
 6504,
 319492877,
 319326504,
 -1,
 -60660,
 319443777,
 6482,
 -1,
 319494452,
 6498,
 319689488,
 319451275,
 -1,
 -60657,
 319641662,
 6496,
 -1,
 319691060,
 6480,
 -60655,
 319677300,
 6485,
 -60654,
 319873572,
 6481,
 -60653,
 319936014,
 6493,
 -60652,
 319993345,
 6484,
 -60651,
 320055025,
 6495,
 -60650,
 320110811,
 6491,
 -60649,
 320173206,
 6488,
 -60648,
 320233857,
 6500,
 -60647,
 320297022,
 6494,
 -1,
 320359740,
 6492,
 320541557,
 300511371,
 -1,
 320607092,
 320515679,
 -1,
 320672597,
 320567947,
 -1,
 320738083,
 320651922,
 -1,
 320803617,
 320717458,
 -1,
 -60640,
 320755774,
 71317,
 -1,
 320805172,
 71316,
 -60638,
 320755774,
 71322,
 -1,
 320936244,
 71321,
 321131304,
 320702760,
 -1,
 -60635,
 321119092,
 71315,
 -60634,
 321161586,
 71320,
 -60633,
 321213249,
 71310,
 -1,
 321263924,
 71325,
 321458990,
 321075215,
 -1,
 321524524,
 321402895,
 -1,
 -60629,
 321476670,
 71319,
 -1,
 321526068,
 71318,
 -60627,
 321476670,
 71324,
 -1,
 321657140,
 71323,
 321852210,
 321394996,
 71296,
 -60624,
 321834525,
 71305,
 -60623,
 321872257,
 71303,
 -1,
 321919284,
 71297,
 322114356,
 321834525,
 71300,
 -1,
 322096669,
 71301,
 322245431,
 322090327,
 -1,
 -60618,
 322197566,
 71335,
 -1,
 322246964,
 71336,
 322442042,
 322218114,
 -1,
 -60615,
 322414837,
 71338,
 -1,
 322443572,
 71332,
 322638653,
 322412237,
 -1,
 -60612,
 322590782,
 71327,
 -1,
 322640180,
 71326,
 322835264,
 322597003,
 -1,
 -60609,
 322787390,
 71307,
 -1,
 322836788,
 71306,
 323031875,
 322793311,
 -1,
 -60606,
 322983998,
 71314,
 -1,
 323033396,
 71313,
 323228485,
 322986369,
 71298,
 -1,
 323182977,
 71299,
 323359560,
 323179250,
 -1,
 -60601,
 323311678,
 71309,
 -1,
 323361076,
 71308,
 323556171,
 323300580,
 -1,
 -60598,
 323508286,
 71312,
 -1,
 323557684,
 71311,
 323752782,
 323495615,
 -1,
 -60595,
 323704894,
 71329,
 -1,
 323754292,
 71328,
 -60593,
 323740532,
 71331,
 -60592,
 323933710,
 71334,
 -60591,
 323981457,
 71304,
 -60590,
 324042971,
 71330,
 -60589,
 324105366,
 71333,
 -60588,
 324163646,
 71337,
 -1,
 324223171,
 71302,
 324408163,
 320617310,
 -1,
 324473689,
 324387474,
 -1,
 -60584,
 324460560,
 71362,
 -1,
 324493265,
 71363,
 324670300,
 324449623,
 -1,
 -60581,
 324628178,
 71366,
 -1,
 324684523,
 71367,
 324866911,
 324619495,
 -1,
 -60578,
 324836123,
 71364,
 -1,
 324890144,
 71365,
 -60576,
 324855434,
 71360,
 -60575,
 325031087,
 71361,
 -60574,
 325094616,
 71369,
 -1,
 325141773,
 71368,
 325325678,
 324393584,
 -1,
 325391208,
 325261620,
 -1,
 -60570,
 325373469,
 71349,
 -60569,
 325411201,
 71347,
 -1,
 325458228,
 71341,
 325653354,
 325373469,
 71344,
 -1,
 325635613,
 71345,
 325784428,
 325607809,
 71342,
 -1,
 325738881,
 71343,
 -60563,
 325750929,
 71348,
 -1,
 325861571,
 71346,
 326107135,
 325302985,
 -1,
 326112114,
 326031594,
 -1,
 -60559,
 326088401,
 71340,
 -1,
 326150660,
 71350,
 -60557,
 326078397,
 71351,
 -1,
 326246798,
 71339,
 -1,
 320555006,
 129377,
 326505336,
 320503207,
 -1,
 -60553,
 326472879,
 119671,
 -1,
 326520702,
 119672,
 326701946,
 326444735,
 983061,
 -1,
 326661991,
 127955,
 -60549,
 326689433,
 128661,
 -60548,
 326803671,
 128429,
 -1,
 326841164,
 127790,
 327029843,
 221864321,
 -1,
 327095278,
 327002242,
 -1,
 327160813,
 327049543,
 -1,
 327226302,
 327121547,
 -1,
 327291784,
 327210488,
 -1,
 327357319,
 327258412,
 -1,
 327422853,
 327329922,
 70791,
 -1,
 327395458,
 70792,
 327614463,
 327382092,
 70793,
 -1,
 327513164,
 70794,
 -1,
 327293236,
 70827,
 327750542,
 327271058,
 -1,
 327816076,
 327729810,
 -1,
 -60533,
 327768126,
 70810,
 -1,
 327817524,
 70809,
 -60531,
 327768126,
 70815,
 -1,
 327948596,
 70814,
 328143763,
 327715112,
 -1,
 -60528,
 328131444,
 70808,
 -60527,
 328173938,
 70813,
 -60526,
 328225601,
 70803,
 -1,
 328276276,
 70818,
 328471449,
 328087567,
 -1,
 328536983,
 328415247,
 -1,
 -60522,
 328489022,
 70812,
 -1,
 328538420,
 70811,
 -60520,
 328489022,
 70817,
 -1,
 328669492,
 70816,
 328864669,
 328407348,
 70785,
 -60517,
 328846877,
 70798,
 -60516,
 328884609,
 70796,
 -1,
 328931636,
 70786,
 329126817,
 328840535,
 -1,
 -60513,
 329102849,
 70829,
 -60512,
 329144382,
 70828,
 -1,
 329193780,
 70830,
 329388963,
 329109021,
 70789,
 -1,
 329371165,
 70790,
 329520038,
 329359053,
 -1,
 -60507,
 329472062,
 70820,
 -1,
 329521460,
 70819,
 329716649,
 329478283,
 -1,
 -60504,
 329668670,
 70800,
 -1,
 329718068,
 70799,
 329913260,
 329674591,
 -1,
 -60501,
 329865278,
 70807,
 -1,
 329914676,
 70806,
 330109870,
 329867649,
 70787,
 -1,
 330064257,
 70788,
 330240945,
 330060530,
 -1,
 -60496,
 330192958,
 70802,
 -1,
 330242356,
 70801,
 330437556,
 330181860,
 -1,
 -60493,
 330389566,
 70805,
 -1,
 330438964,
 70804,
 330634167,
 330376895,
 -1,
 -60490,
 330586174,
 70822,
 -1,
 330635572,
 70821,
 -60488,
 330621812,
 70824,
 -60487,
 330803445,
 70825,
 -60486,
 330862737,
 70797,
 -60485,
 330924251,
 70823,
 -60484,
 330986646,
 70826,
 -60483,
 331044926,
 70831,
 -1,
 331104451,
 70795,
 331289553,
 327211632,
 -1,
 331355076,
 331274634,
 -1,
 331420610,
 331327618,
 70837,
 -1,
 331393154,
 70838,
 331612159,
 331379788,
 70839,
 -1,
 331510860,
 70840,
 331682760,
 331290932,
 -1,
 -60474,
 331664925,
 70846,
 -60473,
 331702657,
 70843,
 -1,
 331749684,
 70832,
 331944906,
 331664925,
 70835,
 -1,
 331927069,
 70836,
 332075981,
 331921907,
 -1,
 -60468,
 332042385,
 70845,
 -1,
 332087491,
 70842,
 332272591,
 332030337,
 70833,
 -1,
 332226945,
 70834,
 -60464,
 332238993,
 70844,
 -1,
 332349635,
 70841,
 332534751,
 331234142,
 -1,
 332600277,
 332513938,
 -1,
 -60460,
 332587024,
 70866,
 -1,
 332619729,
 70867,
 332796888,
 332576087,
 -1,
 -60457,
 332754642,
 70870,
 -1,
 332810987,
 70871,
 332993499,
 332745959,
 -1,
 -60454,
 332962587,
 70868,
 -1,
 333016608,
 70869,
 -60452,
 332981898,
 70864,
 -60451,
 333157551,
 70865,
 -60450,
 333221080,
 70873,
 -1,
 333268237,
 70872,
 333452264,
 332511945,
 -1,
 333517795,
 333437162,
 -1,
 -60446,
 333493969,
 70849,
 -1,
 333556228,
 70850,
 333714406,
 333453620,
 -1,
 -60443,
 333698577,
 70852,
 -1,
 333746188,
 70848,
 -60441,
 333680573,
 70851,
 -1,
 333852088,
 70847,
 334042091,
 333388084,
 -1,
 -60438,
 334007672,
 70784,
 -1,
 334047320,
 70854,
 -60436,
 334009235,
 70855,
 -1,
 334190569,
 70853,
 -1,
 327107362,
 128555,
 334435377,
 327044726,
 -1,
 334500910,
 334396043,
 -1,
 334566428,
 334488332,
 -1,
 334631959,
 334502196,
 11568,
 334697462,
 334575631,
 11575,
 334762997,
 334641167,
 11577,
 -1,
 334714920,
 11578,
 -1,
 334714920,
 11576,
 334959609,
 334685629,
 11619,
 -60424,
 334947773,
 11621,
 -1,
 334977064,
 11594,
 335156220,
 334938770,
 11612,
 -60421,
 335135378,
 11615,
 -1,
 335173672,
 11613,
 335352831,
 335131991,
 11609,
 -60418,
 335328599,
 11610,
 -1,
 335370280,
 11611,
 335549442,
 335310987,
 11581,
 335675391,
 335501352,
 11589,
 -1,
 335566888,
 11583,
 335746053,
 335500018,
 11571,
 335871999,
 335697960,
 11606,
 -1,
 335763496,
 11572,
 335942663,
 335718530,
 11604,
 -1,
 335915138,
 11605,
 336073737,
 335894568,
 11584,
 -1,
 336025640,
 11587,
 336204811,
 336012991,
 11569,
 -1,
 336156712,
 11570,
 -60404,
 336192268,
 11618,
 -60403,
 336321252,
 11617,
 -60402,
 336385528,
 11616,
 -60401,
 336438994,
 11591,
 -60400,
 336502477,
 11602,
 -60399,
 336562472,
 11599,
 -60398,
 336625797,
 11598,
 -60397,
 336688204,
 11597,
 -60396,
 336752479,
 11574,
 -60395,
 336809191,
 11580,
 -60394,
 336867193,
 11614,
 -1,
 336927028,
 11588,
 337122329,
 334577859,
 11622,
 -1,
 337109772,
 11579,
 -60390,
 337104413,
 11603,
 -60389,
 337219729,
 11623,
 -1,
 337273217,
 11593,
 337450024,
 334545554,
 -1,
 337515559,
 337432313,
 -1,
 337581088,
 337473675,
 11582,
 -1,
 337532968,
 11590,
 337712163,
 337531634,
 -1,
 -60382,
 337676584,
 11600,
 -1,
 337729576,
 11607,
 -60380,
 337700551,
 11596,
 -60379,
 337880786,
 11592,
 -60378,
 337939452,
 11601,
 -1,
 337991720,
 11586,
 -1,
 337454706,
 11620,
 338236459,
 337389789,
 -1,
 -60374,
 338194271,
 11573,
 -1,
 338253864,
 11585,
 338493439,
 338172212,
 -1,
 -60371,
 338420825,
 11608,
 -1,
 338450537,
 11595,
 -60369,
 334477281,
 11632,
 -60368,
 338593581,
 11631,
 -1,
 338637903,
 11647,
 338826311,
 334375168,
 -1,
 338891836,
 338789002,
 -1,
 338957366,
 338831039,
 -1,
 -60363,
 338934728,
 4048,
 -1,
 338981099,
 983208,
 -60361,
 338938417,
 4058,
 -60360,
 339120252,
 4050,
 -60359,
 339183321,
 4049,
 -60358,
 339244987,
 4057,
 -60357,
 339306860,
 4051,
 -1,
 339358466,
 4052,
 339547204,
 338867543,
 -1,
 339612737,
 339529526,
 -1,
 -60353,
 339575700,
 3982,
 -60352,
 339637991,
 3981,
 -1,
 339700485,
 3983,
 339935231,
 339567928,
 -1,
 -60349,
 339847968,
 4046,
 -1,
 339897093,
 3980,
 340131839,
 339507851,
 -1,
 -60346,
 340046887,
 3948,
 -1,
 340095827,
 3947,
 340268110,
 338786115,
 -1,
 340333645,
 340254304,
 -1,
 340399180,
 340278354,
 -1,
 -60341,
 340338862,
 11807,
 -1,
 340400752,
 11806,
 -1,
 340373798,
 11803,
 -1,
 340301747,
 11081,
 340726864,
 340219154,
 128005,
 -1,
 340656828,
 128047,
 -60335,
 340693052,
 68410,
 -60334,
 340821177,
 9202,
 -1,
 340865651,
 127915,
 341054709,
 326975683,
 -1,
 341120202,
 341035544,
 -1,
 341185639,
 341060836,
 -1,
 341251168,
 341151889,
 -1,
 341316701,
 341215528,
 -1,
 341382236,
 341295762,
 -1,
 -60326,
 341355094,
 119563,
 -60325,
 341395366,
 119582,
 -1,
 341449537,
 119573,
 -1,
 341360514,
 119608,
 341770239,
 341280781,
 -1,
 -60321,
 341664356,
 119634,
 -1,
 341723648,
 119630,
 341906533,
 341212786,
 -1,
 341972068,
 341852355,
 -1,
 -60317,
 341937060,
 119590,
 -1,
 341981259,
 119613,
 -1,
 341955688,
 119631,
 -60314,
 341858825,
 119585,
 -1,
 342181805,
 119558,
 342365301,
 341129231,
 -1,
 342430830,
 342319489,
 -1,
 342496364,
 342392965,
 -1,
 -60309,
 342459966,
 119625,
 -1,
 342518105,
 119612,
 -60307,
 342480781,
 119568,
 -1,
 342642205,
 119636,
 342824050,
 342376643,
 -1,
 -60304,
 342794412,
 119623,
 -60303,
 342838693,
 119567,
 -1,
 342897134,
 119586,
 -60301,
 342808007,
 119584,
 -60300,
 343055052,
 119619,
 -1,
 343089861,
 119624,
 343282814,
 342311107,
 -1,
 343348346,
 343247144,
 -1,
 -60296,
 343307826,
 119603,
 -60295,
 343357877,
 119583,
 -1,
 343422316,
 119600,
 -60293,
 343335556,
 119626,
 -60292,
 343590267,
 119610,
 -60291,
 343638833,
 119618,
 -1,
 343680083,
 119580,
 343872648,
 343255170,
 -1,
 343938183,
 343818435,
 -1,
 344003717,
 343913815,
 -1,
 344069252,
 343957889,
 -1,
 -60285,
 344047483,
 119579,
 -1,
 344078834,
 119596,
 -1,
 344040609,
 119598,
 -60282,
 343963616,
 119578,
 -1,
 344267505,
 119572,
 -1,
 343895575,
 119605,
 344528017,
 343821543,
 -1,
 344593548,
 344510716,
 -1,
 -60277,
 344558500,
 119595,
 -1,
 344588772,
 119559,
 344790159,
 344559761,
 -1,
 -60274,
 344768459,
 119638,
 -1,
 344817055,
 119576,
 -60272,
 344751034,
 119606,
 -1,
 344923463,
 119632,
 345117849,
 344503639,
 -1,
 345183383,
 345096850,
 -1,
 345248918,
 345149585,
 -1,
 -60267,
 345233123,
 119601,
 -1,
 345285884,
 119628,
 -1,
 345222395,
 119593,
 -60264,
 345139618,
 119621,
 -1,
 345459539,
 119627,
 345642143,
 345068274,
 -1,
 345707676,
 345580871,
 119592,
 -1,
 345637741,
 119615,
 -60259,
 345689838,
 119614,
 -60258,
 345811896,
 119602,
 -1,
 345870964,
 119599,
 346035365,
 345611981,
 -1,
 346100899,
 345970996,
 -1,
 -60254,
 346082353,
 119604,
 -1,
 346108552,
 119588,
 -60252,
 346084485,
 119594,
 -1,
 346244882,
 119571,
 346428586,
 345970996,
 -1,
 -60249,
 346404588,
 119564,
 -60248,
 346445157,
 119633,
 -60247,
 346505357,
 119577,
 -1,
 346566349,
 119617,
 346756270,
 346390661,
 -1,
 -60244,
 346713173,
 119560,
 -60243,
 346768029,
 119609,
 -1,
 346825866,
 119616,
 347018419,
 346715212,
 -1,
 347083954,
 346954036,
 -1,
 -60239,
 347069158,
 119597,
 -1,
 347089799,
 119637,
 -1,
 347030708,
 119589,
 347346103,
 346957503,
 -1,
 -60235,
 347318802,
 119566,
 -60234,
 347378462,
 119587,
 -1,
 347415394,
 119561,
 347608250,
 347331364,
 -1,
 -60231,
 347587646,
 119620,
 -1,
 347631074,
 119575,
 347804861,
 347574417,
 -1,
 -60228,
 347776315,
 119565,
 -1,
 347834680,
 119635,
 348001472,
 347762827,
 -1,
 -60225,
 347957742,
 119591,
 -1,
 348013589,
 119562,
 348198083,
 347956845,
 -1,
 -60222,
 348162953,
 119622,
 -1,
 348206500,
 119570,
 348394694,
 348149800,
 -1,
 -60219,
 348361540,
 119574,
 -1,
 348398239,
 119629,
 -60217,
 348382555,
 119569,
 -60216,
 348575432,
 119607,
 -60215,
 348639838,
 119611,
 -1,
 348680282,
 119581,
 348853484,
 341079116,
 -1,
 348919013,
 348835989,
 -1,
 348984536,
 348869110,
 -1,
 349050068,
 348963474,
 -1,
 349115601,
 349036708,
 -1,
 -60208,
 349081998,
 3194,
 -1,
 349129482,
 3197,
 349372415,
 349069404,
 -1,
 -60205,
 349278606,
 3195,
 -1,
 349326090,
 3198,
 349508823,
 349017291,
 -1,
 -60202,
 349475214,
 3193,
 -1,
 349522698,
 3196,
 -1,
 349496981,
 3192,
 349770974,
 348961481,
 -1,
 349836508,
 349713300,
 -1,
 -60197,
 349777361,
 3072,
 -1,
 349839767,
 3076,
 -60195,
 349818154,
 3199,
 -1,
 349972011,
 3133,
 350164195,
 349731467,
 -1,
 -60192,
 350145508,
 3160,
 -60191,
 350205017,
 3162,
 -60190,
 350256521,
 3124,
 -1,
 350306486,
 3161,
 350552063,
 350149278,
 3170,
 -1,
 350450764,
 3171,
 350683135,
 348864707,
 -1,
 350688490,
 350593585,
 -1,
 350754025,
 350661569,
 128222,
 -1,
 350686586,
 128380,
 -1,
 350721115,
 128384,
 -60181,
 350673246,
 128250,
 -1,
 350926604,
 128301,
 351081712,
 348817704,
 -1,
 -60178,
 351060626,
 9978,
 -60177,
 351112509,
 127934,
 -1,
 351163557,
 8376,
 351343859,
 351017268,
 -1,
 -60174,
 351316164,
 128198,
 -1,
 351352683,
 127861,
 -60172,
 351321946,
 129514,
 -1,
 351484272,
 129528,
 351671583,
 341006376,
 -1,
 351737105,
 351644763,
 -1,
 351802633,
 351666176,
 -1,
 351868157,
 351775419,
 -1,
 -60166,
 351842054,
 128487,
 -60165,
 351893544,
 128486,
 -60164,
 351938734,
 128485,
 -1,
 352000624,
 128484,
 352195842,
 351827020,
 -1,
 352261377,
 352151495,
 -1,
 -60160,
 352235270,
 9886,
 -1,
 352286760,
 9887,
 -1,
 352208036,
 11057,
 352523525,
 352139279,
 -1,
 -60156,
 352491990,
 8278,
 -1,
 352544290,
 10176,
 -60154,
 352501222,
 128491,
 -60153,
 352691169,
 128962,
 -60152,
 352750509,
 128423,
 -1,
 352791743,
 128433,
 353042431,
 351735398,
 -1,
 353047824,
 352925713,
 -1,
 353113358,
 353028518,
 -1,
 -60147,
 353087695,
 11162,
 -1,
 353139091,
 11160,
 -60145,
 353087504,
 11161,
 -1,
 353270002,
 11163,
 -1,
 352994824,
 11835,
 353506584,
 351691137,
 -1,
 353572119,
 353470760,
 -1,
 353637654,
 353501184,
 -1,
 -60139,
 353613430,
 128936,
 -1,
 353654658,
 128929,
 -1,
 353596159,
 129300,
 -1,
 353544969,
 129353,
 353965341,
 353488413,
 -1,
 354030876,
 353928079,
 -1,
 -60133,
 354013964,
 128077,
 -1,
 354041650,
 128078,
 -1,
 353995420,
 9928,
 -60130,
 353934065,
 128173,
 -1,
 354240805,
 127777,
 354424131,
 351637649,
 -1,
 354489648,
 354399389,
 -1,
 354555183,
 354431495,
 -1,
 354620710,
 354489889,
 -1,
 -60124,
 354555829,
 127552,
 -60123,
 354620941,
 127560,
 -1,
 354685732,
 127557,
 354882857,
 354555633,
 -1,
 -60120,
 354817773,
 127558,
 -1,
 354881766,
 127556,
 355079468,
 354817324,
 -1,
 -60117,
 355018480,
 127555,
 -1,
 355078966,
 127559,
 355336191,
 355013929,
 -1,
 -60114,
 355211387,
 127554,
 -1,
 355274979,
 127553,
 -1,
 354514573,
 127274,
 355538236,
 354459343,
 -1,
 355603766,
 355489854,
 -1,
 355669301,
 355564301,
 -1,
 -60108,
 355645292,
 11833,
 -1,
 355674678,
 11210,
 -1,
 355648146,
 127913,
 -60105,
 355590004,
 128285,
 -60104,
 355912144,
 9184,
 -60103,
 355970892,
 11811,
 -60102,
 356032620,
 9180,
 -60101,
 356087912,
 11810,
 -1,
 356136858,
 9182,
 356324671,
 355504273,
 -1,
 -60098,
 356304281,
 129463,
 -1,
 356349666,
 129520,
 -60096,
 356289672,
 128069,
 -60095,
 356483861,
 127813,
 -60094,
 356545602,
 128508,
 -1,
 356607468,
 128701,
 356783456,
 354405917,
 -1,
 356848990,
 356755586,
 -1,
 356914522,
 356813578,
 -1,
 356980044,
 356889943,
 -1,
 357045578,
 356949018,
 -1,
 -60087,
 357031100,
 128597,
 -1,
 357057110,
 128599,
 -60085,
 357007839,
 8526,
 -1,
 357189155,
 11829,
 357373265,
 356923407,
 -1,
 357438800,
 357328167,
 -1,
 -60081,
 357425168,
 8586,
 -1,
 357457873,
 8587,
 -1,
 357375141,
 11832,
 357700948,
 357338651,
 -1,
 -60077,
 357686460,
 128596,
 -1,
 357712470,
 128598,
 357897559,
 357640739,
 -1,
 -60074,
 357874139,
 9930,
 -1,
 357933439,
 11202,
 -60072,
 357883313,
 9929,
 -60071,
 358060700,
 128399,
 -1,
 358101945,
 11826,
 358290781,
 356872331,
 -1,
 -60068,
 358247594,
 8378,
 -1,
 358304981,
 129411,
 -1,
 358271218,
 128034,
 -60065,
 356811613,
 129347,
 -1,
 358513822,
 127799,
 358684028,
 356755586,
 -1,
 358749546,
 358637953,
 -1,
 358815079,
 358686908,
 -1,
 358880614,
 358797550,
 -1,
 -60059,
 358855905,
 128208,
 -1,
 358895551,
 128681,
 -1,
 358840214,
 128710,
 -60056,
 358785772,
 11851,
 -60055,
 359086594,
 128305,
 -1,
 359150453,
 8285,
 359339378,
 358684980,
 -1,
 359404909,
 359301253,
 128650,
 -1,
 359334325,
 128651,
 359535984,
 359345380,
 -1,
 -60049,
 359516595,
 128668,
 -1,
 359559662,
 128434,
 -60047,
 359501552,
 11223,
 -1,
 359687789,
 128646,
 359863673,
 359305361,
 -1,
 359929208,
 359833293,
 -1,
 359994743,
 359883447,
 -1,
 -60042,
 359944021,
 128032,
 -1,
 360005639,
 127865,
 -1,
 359948655,
 127942,
 -1,
 359890276,
 128654,
 360382463,
 359845405,
 -1,
 -60037,
 360286210,
 127930,
 -1,
 360333603,
 11231,
 360519049,
 358669028,
 -1,
 360584584,
 360485009,
 -1,
 360650119,
 360513536,
 -1,
 360715650,
 360594510,
 -1,
 -60031,
 360691087,
 11818,
 -1,
 360712268,
 8282,
 -60029,
 360702284,
 128109,
 -60028,
 360889830,
 128490,
 -60027,
 360940682,
 128108,
 -60026,
 360995635,
 128149,
 -1,
 361049279,
 128432,
 -1,
 360582831,
 11834,
 -1,
 360541479,
 128256,
 361431039,
 360451686,
 -1,
 -60021,
 361347514,
 128085,
 -1,
 361410046,
 129430,
 361570065,
 221820247,
 -1,
 361634354,
 361521537,
 983080,
 361699689,
 361584303,
 -1,
 361765224,
 361685450,
 -1,
 361830150,
 361715752,
 -1,
 361895673,
 361765172,
 -1,
 361961208,
 361859710,
 -1,
 362026593,
 361909479,
 -1,
 362092093,
 361983267,
 121091,
 362217471,
 362020864,
 -1,
 362223092,
 362112770,
 120832,
 362348543,
 362151936,
 -1,
 362354118,
 362251577,
 120846,
 362479615,
 362283008,
 -1,
 362485165,
 362360036,
 -1,
 362550697,
 362452466,
 120853,
 362676223,
 362479616,
 -1,
 362681763,
 362596142,
 -1,
 362747298,
 362658413,
 120877,
 362872831,
 362676224,
 -1,
 -59999,
 362755141,
 120878,
 -1,
 362817722,
 120879,
 -1,
 362696939,
 120884,
 363074981,
 362634596,
 120857,
 -1,
 363006451,
 120882,
 363206055,
 363018110,
 120856,
 -1,
 363137489,
 120885,
 -59992,
 363169096,
 120855,
 -1,
 363292431,
 120854,
 363528191,
 362525586,
 -1,
 363533740,
 363414283,
 120858,
 -1,
 363465203,
 120883,
 -1,
 363463722,
 121001,
 363730361,
 362465064,
 120862,
 363855871,
 363659264,
 -1,
 363861427,
 363736292,
 -1,
 -59983,
 363844451,
 120872,
 -59982,
 363894267,
 120893,
 -1,
 363949043,
 120873,
 364123574,
 363812904,
 -1,
 -59979,
 364091031,
 120874,
 -1,
 364144905,
 120875,
 364320184,
 364060928,
 120895,
 -1,
 364250469,
 120894,
 -1,
 364259514,
 120866,
 364516799,
 363702402,
 -1,
 364582334,
 364472287,
 120966,
 364707839,
 364511232,
 -1,
 -59971,
 364590149,
 120972,
 -1,
 364652730,
 120971,
 -1,
 364518808,
 120849,
 364910017,
 364469604,
 120850,
 -1,
 364841251,
 120867,
 365041091,
 364849338,
 120848,
 -1,
 364972543,
 120865,
 -59964,
 365024020,
 120871,
 -59963,
 365150340,
 120864,
 -1,
 365198549,
 120996,
 365368805,
 362333998,
 -1,
 365434321,
 365345389,
 121052,
 365559807,
 365363200,
 -1,
 365565389,
 365479726,
 -1,
 -59957,
 365509361,
 121054,
 -59956,
 365573189,
 121055,
 -1,
 365635770,
 121056,
 365827536,
 365520648,
 -1,
 -59953,
 365780311,
 121059,
 -1,
 365832378,
 121057,
 -1,
 365767502,
 121058,
 366089691,
 365374692,
 -1,
 366155225,
 366071325,
 -1,
 366220760,
 366127234,
 -1,
 366286295,
 366204690,
 -1,
 -59946,
 366268907,
 121066,
 -1,
 366307829,
 121064,
 -1,
 366246761,
 121063,
 -1,
 366191874,
 120887,
 366673919,
 366111708,
 121067,
 -1,
 366557247,
 120892,
 366745055,
 366042742,
 121062,
 366870527,
 366691121,
 -1,
 -59938,
 366793352,
 120881,
 -1,
 366828900,
 120899,
 367007202,
 366694643,
 -1,
 -59935,
 366985294,
 121060,
 -1,
 367012026,
 121061,
 367263743,
 366944519,
 -1,
 -59932,
 367172610,
 120890,
 -1,
 367224436,
 120891,
 367400426,
 365321572,
 120843,
 367525887,
 367329280,
 -1,
 367531497,
 367429055,
 120852,
 -1,
 367462899,
 120870,
 -1,
 367492804,
 120844,
 367728110,
 367383224,
 120851,
 367853567,
 367659465,
 -1,
 -59923,
 367770221,
 120868,
 -1,
 367801413,
 120869,
 367990257,
 367700098,
 -1,
 -59920,
 367945854,
 121018,
 -1,
 367992202,
 120841,
 368186867,
 367929530,
 120838,
 -1,
 368117290,
 120861,
 -1,
 368129918,
 120842,
 368383499,
 362202920,
 121077,
 368508927,
 368312320,
 -1,
 368514557,
 368431601,
 -1,
 368580090,
 368493202,
 -1,
 -59911,
 368566425,
 121086,
 -1,
 368599119,
 121088,
 -59909,
 368540900,
 120979,
 -59908,
 368731919,
 120840,
 -1,
 368791947,
 121089,
 368973314,
 368453908,
 -1,
 369038848,
 368928538,
 121083,
 -1,
 368970062,
 120876,
 -59903,
 369013052,
 121085,
 -1,
 369132896,
 121084,
 369300998,
 368949874,
 -1,
 -59900,
 369244913,
 121079,
 -59899,
 369308741,
 121080,
 -1,
 369371322,
 121081,
 369563145,
 369269840,
 -1,
 -59896,
 369544671,
 121087,
 -1,
 369578443,
 121090,
 -59894,
 369515402,
 121078,
 -1,
 369709291,
 121082,
 369890849,
 368346432,
 -1,
 369956377,
 369870638,
 -1,
 370021906,
 369896676,
 -1,
 370087441,
 369978362,
 -1,
 -59888,
 370070152,
 120888,
 -1,
 370105700,
 120889,
 -1,
 370070377,
 120886,
 370349591,
 369959175,
 -1,
 370415126,
 370318327,
 -1,
 -59883,
 370397832,
 120896,
 -1,
 370423340,
 120897,
 -1,
 370370431,
 120898,
 -59880,
 370310357,
 121035,
 -1,
 370630297,
 120880,
 370808347,
 369939080,
 121030,
 -1,
 370739699,
 121033,
 370939422,
 370780290,
 -1,
 -59875,
 370894974,
 121037,
 -1,
 370941322,
 121032,
 -59873,
 370900181,
 121036,
 -59872,
 371080888,
 121028,
 -1,
 371140799,
 120860,
 371332656,
 369851612,
 -1,
 371398184,
 371277496,
 120974,
 371523583,
 371326976,
 -1,
 371529255,
 371438132,
 -1,
 -59866,
 371507278,
 120975,
 -1,
 371537876,
 120976,
 -1,
 371497490,
 120977,
 371791403,
 371376786,
 -1,
 -59862,
 371759825,
 120985,
 -1,
 371810556,
 120986,
 371988013,
 371746562,
 120992,
 -1,
 371919298,
 120988,
 -59858,
 371970696,
 120978,
 -59857,
 372091275,
 120983,
 -1,
 372123834,
 120984,
 372315707,
 371306784,
 -1,
 372381237,
 372278585,
 121012,
 372506623,
 372310016,
 -1,
 -59852,
 372418970,
 121014,
 -1,
 372454469,
 121013,
 -59850,
 372363912,
 121006,
 -59849,
 372623144,
 121016,
 -59848,
 372681099,
 121007,
 -59847,
 372735189,
 121008,
 -59846,
 372795138,
 121015,
 -1,
 372850360,
 121003,
 -59844,
 372267914,
 121092,
 -1,
 372986287,
 120906,
 373227519,
 362051165,
 120922,
 373293055,
 373096448,
 -1,
 373298767,
 373181671,
 -1,
 373364297,
 373255731,
 120908,
 373489663,
 373293056,
 -1,
 373495366,
 373382500,
 120919,
 373620735,
 373424128,
 -1,
 -59835,
 373540675,
 120920,
 -1,
 373591479,
 120921,
 -59833,
 373475125,
 120914,
 -59832,
 373707055,
 120910,
 -1,
 373762234,
 120912,
 374013951,
 373332782,
 120900,
 374079487,
 373882880,
 -1,
 374085197,
 373961797,
 120903,
 -1,
 374016284,
 120904,
 -59826,
 374037860,
 120902,
 -1,
 374155450,
 120901,
 374347349,
 373276212,
 -1,
 374412883,
 374288155,
 120930,
 374538239,
 374344179,
 120931,
 -1,
 374407535,
 120932,
 -59820,
 374373589,
 120933,
 -1,
 374564718,
 120929,
 374740572,
 374299530,
 120924,
 374865919,
 374669312,
 -1,
 374871643,
 374755209,
 120909,
 374996991,
 374800384,
 -1,
 -59814,
 374886703,
 120911,
 -1,
 374941882,
 120913,
 -1,
 374851395,
 120926,
 375199328,
 374720302,
 -1,
 -59810,
 375175789,
 120925,
 -59809,
 375214315,
 120928,
 -1,
 375269562,
 120927,
 -1,
 375138622,
 120923,
 375527069,
 361966820,
 -1,
 375592572,
 375508509,
 -1,
 375658103,
 375561933,
 120941,
 375783423,
 375586816,
 -1,
 375789163,
 375691062,
 120940,
 375914495,
 375717888,
 -1,
 375920234,
 375834414,
 -1,
 -59799,
 375896685,
 120942,
 -1,
 375935211,
 120946,
 -1,
 375885239,
 120944,
 376182384,
 375744258,
 120834,
 376307711,
 376111104,
 -1,
 376313455,
 376227624,
 121068,
 -1,
 376243524,
 121069,
 -1,
 376287548,
 121024,
 376510067,
 376162094,
 -1,
 -59790,
 376486509,
 120943,
 -1,
 376525035,
 120947,
 376706677,
 376459145,
 120915,
 -1,
 376636740,
 120916,
 -59786,
 376671671,
 120945,
 -1,
 376800620,
 121040,
 377028607,
 375632619,
 120949,
 377094143,
 376897536,
 -1,
 -59782,
 377001782,
 120948,
 -59781,
 377062812,
 121039,
 -1,
 377120570,
 121020,
 377296531,
 375548892,
 120950,
 377421823,
 377225216,
 -1,
 377427595,
 377317122,
 120833,
 377552895,
 377356288,
 -1,
 377558664,
 377455929,
 120847,
 377683967,
 377487360,
 -1,
 377689733,
 377566725,
 -1,
 -59772,
 377635595,
 120859,
 -1,
 377685034,
 121002,
 -59770,
 377669416,
 120863,
 -59769,
 377860379,
 120967,
 -1,
 377912533,
 120997,
 -59767,
 377532732,
 121019,
 -59766,
 378035543,
 120845,
 -1,
 378087610,
 120839,
 378279567,
 377390400,
 -1,
 378345102,
 378253628,
 121038,
 -1,
 378274159,
 121045,
 -1,
 378327688,
 121031,
 378541714,
 378240220,
 -1,
 -59759,
 378524296,
 120980,
 -1,
 378562306,
 120993,
 -1,
 378515772,
 121009,
 378863615,
 377255623,
 120934,
 378929151,
 378732544,
 -1,
 378934936,
 378849070,
 -1,
 -59753,
 378911341,
 120935,
 -1,
 378949867,
 120937,
 379131546,
 378897791,
 121046,
 -1,
 379062501,
 121047,
 -59749,
 379096503,
 120936,
 -59748,
 379217743,
 121065,
 -1,
 379277720,
 120905,
 379459285,
 375478312,
 -1,
 379524807,
 379414788,
 120957,
 379650047,
 379453440,
 -1,
 379655855,
 379545346,
 120836,
 379781119,
 379584512,
 -1,
 379786921,
 379701032,
 121072,
 379912191,
 379715584,
 -1,
 379917991,
 379827543,
 -1,
 -59738,
 379879862,
 121073,
 -1,
 379937590,
 121053,
 -59736,
 379885366,
 121070,
 -1,
 380073430,
 121071,
 380245677,
 379749696,
 -1,
 380311212,
 380219675,
 120968,
 -1,
 380240370,
 120973,
 -1,
 380271829,
 120998,
 -59730,
 380219708,
 121025,
 -1,
 380460388,
 121051,
 380638901,
 379623222,
 120955,
 380764159,
 380567552,
 -1,
 380769972,
 380684078,
 -1,
 -59725,
 380746349,
 120959,
 -1,
 380784875,
 120956,
 -1,
 380734903,
 120961,
 381032122,
 380599509,
 120970,
 381157375,
 380960768,
 -1,
 381163193,
 381052674,
 120994,
 -1,
 381094338,
 120989,
 -1,
 381142824,
 120987,
 381359806,
 381011758,
 -1,
 381425341,
 381336173,
 120960,
 -1,
 381356777,
 120963,
 -1,
 381364522,
 120964,
 381621952,
 381333787,
 120999,
 -1,
 381551235,
 121004,
 381753026,
 381584697,
 121029,
 -1,
 381683842,
 121041,
 381884101,
 381701351,
 -1,
 -59708,
 381852474,
 120907,
 -1,
 381906502,
 120917,
 -59706,
 381860868,
 120958,
 -1,
 382045623,
 120962,
 382271487,
 379491987,
 120939,
 382337023,
 382140416,
 -1,
 382342863,
 382240064,
 -1,
 382408398,
 382316872,
 121050,
 382533631,
 382337024,
 -1,
 -59699,
 382442464,
 121048,
 -1,
 382494317,
 121049,
 -1,
 382388008,
 121034,
 382736083,
 382297895,
 -1,
 -59695,
 382718443,
 121023,
 -59694,
 382770144,
 121021,
 -1,
 382821997,
 121022,
 -59692,
 382710157,
 121017,
 -1,
 382941066,
 120938,
 383129326,
 379396346,
 120965,
 383254527,
 383057920,
 -1,
 383260386,
 383149826,
 120837,
 383385599,
 383188992,
 -1,
 383391453,
 383305512,
 121076,
 383516671,
 383320064,
 -1,
 -59684,
 383425504,
 121074,
 -1,
 383477357,
 121075,
 383653599,
 383365436,
 121027,
 -1,
 383583589,
 121026,
 383844351,
 383616320,
 -1,
 -59679,
 383758619,
 120969,
 -1,
 383810773,
 121000,
 383981287,
 383220956,
 -1,
 384046822,
 383936258,
 120995,
 384172031,
 383977952,
 120991,
 -1,
 384042341,
 120990,
 -1,
 384029320,
 120982,
 384308971,
 383944044,
 121044,
 384434175,
 384237568,
 -1,
 -59670,
 384343008,
 121042,
 -1,
 384394861,
 121043,
 384630783,
 384282912,
 -1,
 -59667,
 384531669,
 121011,
 -1,
 384581347,
 121005,
 384827391,
 383097909,
 120951,
 384892927,
 384696320,
 -1,
 384898803,
 384812846,
 -1,
 -59662,
 384875117,
 120952,
 -1,
 384913643,
 120954,
 -59660,
 384872764,
 121010,
 -59659,
 385060279,
 120953,
 -59658,
 385121508,
 120981,
 -59657,
 385181442,
 120835,
 -1,
 385240969,
 120918,
 -1,
 361917376,
 121451,
 385548287,
 361841148,
 121343,
 385613823,
 385417216,
 -1,
 385619717,
 385517506,
 -1,
 385685252,
 385551974,
 -1,
 385750785,
 385669950,
 -1,
 -59649,
 385730578,
 121346,
 -59648,
 385794126,
 121345,
 -1,
 385824711,
 121348,
 386072575,
 385699871,
 -1,
 -59645,
 385990734,
 121347,
 -1,
 386021319,
 121349,
 -1,
 385614308,
 121350,
 -1,
 385593618,
 121344,
 386340928,
 361793264,
 -1,
 386406426,
 386324314,
 -1,
 386471809,
 386390846,
 -1,
 386537260,
 386411748,
 -1,
 386602786,
 386520309,
 -1,
 386668319,
 386531328,
 -1,
 386733845,
 386619432,
 -1,
 386799378,
 386670250,
 -1,
 386864912,
 386758102,
 121230,
 -1,
 386842423,
 121231,
 -59631,
 386841604,
 121228,
 -1,
 386958287,
 121229,
 387186687,
 386756111,
 -1,
 -59628,
 387076700,
 121254,
 -1,
 387133511,
 121261,
 387323674,
 386705330,
 -1,
 387389208,
 387282390,
 121226,
 -1,
 387366711,
 121227,
 -59623,
 387365892,
 121224,
 -1,
 387482575,
 121225,
 387710975,
 387302809,
 -1,
 387716894,
 387624066,
 -1,
 -59619,
 387693572,
 121232,
 -1,
 387744719,
 121233,
 -1,
 387663501,
 121247,
 388038655,
 386611249,
 -1,
 -59615,
 387955716,
 121248,
 -1,
 388006863,
 121249,
 388175655,
 386570531,
 -1,
 -59612,
 388152324,
 121147,
 -59611,
 388215780,
 121150,
 -59610,
 388269007,
 121148,
 -1,
 388330966,
 121149,
 388503339,
 388127608,
 -1,
 -59607,
 388480004,
 121151,
 -59606,
 388531151,
 121152,
 -1,
 388593110,
 121153,
 -1,
 388477842,
 121139,
 388831041,
 386521828,
 -1,
 388896574,
 388769332,
 -1,
 388962103,
 388839373,
 -1,
 389027635,
 388942697,
 -1,
 -59599,
 389004292,
 121244,
 -59598,
 389055439,
 121245,
 -1,
 389117398,
 121246,
 389349375,
 388971887,
 -1,
 -59595,
 389266436,
 121241,
 -59594,
 389317583,
 121242,
 -1,
 389379542,
 121243,
 389551931,
 388905732,
 -1,
 -59591,
 389528580,
 121268,
 -59590,
 389579727,
 121269,
 -1,
 389641686,
 121270,
 389873663,
 389504453,
 -1,
 -59587,
 389763676,
 121257,
 -1,
 389820487,
 121264,
 390070271,
 388870768,
 -1,
 -59584,
 389987113,
 121325,
 -1,
 390020456,
 121326,
 390207306,
 388805975,
 -1,
 390272841,
 390162720,
 -1,
 390338376,
 390250583,
 -1,
 390403910,
 390297046,
 121132,
 -1,
 390381367,
 121133,
 -59577,
 390380548,
 121130,
 -1,
 390497231,
 121131,
 -1,
 390324671,
 121134,
 -1,
 390224044,
 121253,
 390797138,
 390168172,
 -1,
 390862669,
 390773764,
 121237,
 -1,
 390791803,
 121240,
 390993744,
 390815173,
 -1,
 -59569,
 390943324,
 121256,
 -1,
 391000135,
 121263,
 -59567,
 390955983,
 121238,
 -1,
 391149014,
 121239,
 391321435,
 390735551,
 -1,
 391386967,
 391290501,
 -1,
 -59563,
 391363588,
 121154,
 -59562,
 391414735,
 121155,
 -1,
 391476694,
 121156,
 391708671,
 391333595,
 -1,
 -59559,
 391625732,
 121144,
 -59558,
 391676879,
 121145,
 -1,
 391738838,
 121146,
 391911266,
 391274753,
 -1,
 391976799,
 391863749,
 -1,
 -59554,
 391926364,
 121255,
 -1,
 391983175,
 121262,
 -59552,
 391953412,
 121234,
 -59551,
 392135631,
 121235,
 -1,
 392197590,
 121236,
 392370023,
 391891817,
 -1,
 392435557,
 392306497,
 121142,
 -1,
 392367694,
 121143,
 -59546,
 392421823,
 121141,
 -1,
 392544353,
 121140,
 392697708,
 392314223,
 -1,
 392763242,
 392634177,
 121137,
 -1,
 392695374,
 121138,
 -59541,
 392749503,
 121136,
 -1,
 392872014,
 121135,
 393025395,
 392635112,
 -1,
 393090928,
 393001994,
 -1,
 -59537,
 393067305,
 121315,
 -1,
 393100648,
 121317,
 393347071,
 393053142,
 -1,
 -59534,
 393263913,
 121316,
 -1,
 393297256,
 121318,
 393484151,
 393012988,
 -1,
 -59531,
 393460740,
 121157,
 -59530,
 393511887,
 121158,
 -1,
 393573846,
 121159,
 393746299,
 393453814,
 -1,
 -59527,
 393722884,
 121160,
 -59526,
 393774031,
 121161,
 -1,
 393835990,
 121162,
 394008448,
 393694968,
 -1,
 394073983,
 393964571,
 -1,
 -59522,
 394050345,
 121329,
 -1,
 394083688,
 121330,
 -1,
 394040922,
 121128,
 -1,
 393965479,
 121448,
 394401785,
 386420767,
 -1,
 394467222,
 394341604,
 -1,
 394532752,
 394450170,
 -1,
 394598283,
 394485189,
 -1,
 394663816,
 394547224,
 -1,
 -59513,
 394640388,
 121286,
 -1,
 394687958,
 121287,
 394919935,
 394604302,
 -1,
 -59510,
 394836996,
 121271,
 -1,
 394884566,
 121272,
 395057037,
 394556886,
 121303,
 -1,
 395034423,
 121304,
 -59506,
 395033604,
 121301,
 -59505,
 395150287,
 121302,
 -1,
 395195275,
 121305,
 395384724,
 394500387,
 -1,
 -59502,
 395361284,
 121204,
 -59501,
 395412431,
 121205,
 -1,
 395474390,
 121206,
 -59499,
 395359122,
 121198,
 -1,
 395598707,
 121207,
 395777958,
 394451684,
 -1,
 395843491,
 395716148,
 -1,
 395909023,
 395795909,
 -1,
 395974556,
 395857944,
 -1,
 -59493,
 395951108,
 121296,
 -1,
 395998678,
 121297,
 396230655,
 395915022,
 -1,
 -59490,
 396147716,
 121281,
 -1,
 396195286,
 121282,
 396367778,
 395883863,
 -1,
 -59487,
 396331448,
 121308,
 -1,
 396394934,
 121309,
 -1,
 396326358,
 121310,
 396689407,
 395817603,
 -1,
 -59483,
 396606249,
 121327,
 -1,
 396639592,
 121328,
 396826551,
 395738732,
 -1,
 396892086,
 396778949,
 -1,
 396957615,
 396840984,
 -1,
 397023148,
 396934154,
 -1,
 -59477,
 396999465,
 121292,
 -1,
 397032808,
 121294,
 397279231,
 396981724,
 -1,
 -59474,
 397196073,
 121293,
 -1,
 397229416,
 121295,
 397475839,
 396898062,
 -1,
 397481907,
 397392906,
 -1,
 -59470,
 397458217,
 121277,
 -1,
 397491560,
 121279,
 397737983,
 397440476,
 -1,
 -59467,
 397654825,
 121278,
 -1,
 397688168,
 121280,
 -1,
 396868612,
 121307,
 397940679,
 396779777,
 -1,
 398006214,
 397893061,
 -1,
 398071743,
 397955096,
 -1,
 398137277,
 398052201,
 -1,
 -59460,
 398114029,
 121290,
 -1,
 398161445,
 121291,
 -59458,
 398113915,
 121288,
 -1,
 398292451,
 121289,
 398524415,
 398012174,
 -1,
 398530499,
 398441482,
 -1,
 -59454,
 398510946,
 121275,
 -1,
 398540136,
 121273,
 398786559,
 398489052,
 -1,
 -59451,
 398707554,
 121276,
 -1,
 398736744,
 121274,
 -1,
 397982724,
 121306,
 398989264,
 397915479,
 -1,
 399054799,
 398944544,
 -1,
 399120334,
 399032407,
 -1,
 399185868,
 399078870,
 121191,
 -1,
 399163191,
 121192,
 -59443,
 399162372,
 121189,
 -1,
 399279055,
 121190,
 -1,
 399106495,
 121193,
 -1,
 399005875,
 121314,
 399579098,
 398926580,
 -1,
 399644628,
 399555594,
 -1,
 -59437,
 399620905,
 121319,
 -1,
 399654248,
 121322,
 399841239,
 399606742,
 -1,
 -59434,
 399817513,
 121320,
 -1,
 399850856,
 121323,
 400097279,
 399799772,
 -1,
 -59431,
 400014121,
 121321,
 -1,
 400047464,
 121324,
 400234464,
 399559529,
 -1,
 400299998,
 400170829,
 -1,
 -59427,
 400286143,
 121202,
 -1,
 400328642,
 121201,
 -59425,
 400286143,
 121200,
 -1,
 400474209,
 121199,
 400627685,
 400178543,
 -1,
 400693219,
 400564033,
 121196,
 -1,
 400625230,
 121197,
 -59420,
 400679359,
 121195,
 -1,
 400801870,
 121194,
 400955371,
 400565951,
 -1,
 401020906,
 400924293,
 -1,
 -59416,
 400997380,
 121208,
 -59415,
 401048527,
 121209,
 -1,
 401110486,
 121210,
 -1,
 400967383,
 121203,
 401348591,
 400942844,
 -1,
 -59411,
 401325060,
 121211,
 -59410,
 401376207,
 121212,
 -1,
 401438166,
 121213,
 401610739,
 401318134,
 -1,
 -59407,
 401587204,
 121214,
 -59406,
 401638351,
 121215,
 -1,
 401700310,
 121216,
 401872888,
 401559288,
 -1,
 401938423,
 401828899,
 -1,
 -59402,
 401914665,
 121331,
 -1,
 401948008,
 121332,
 -1,
 401905242,
 121129,
 -1,
 401829799,
 121449,
 402266127,
 394345210,
 -1,
 402331653,
 402204948,
 -1,
 402397184,
 402311686,
 -1,
 402462718,
 402355670,
 121187,
 -1,
 402439991,
 121188,
 -59393,
 402439172,
 121185,
 -1,
 402555855,
 121186,
 402784255,
 402335340,
 -1,
 402790403,
 402683350,
 121183,
 -1,
 402767671,
 121184,
 -59388,
 402766852,
 121181,
 -1,
 402883535,
 121182,
 403052554,
 402311686,
 -1,
 403118088,
 403011030,
 121179,
 -1,
 403095351,
 121180,
 -59383,
 403094532,
 121177,
 -1,
 403211215,
 121178,
 403439615,
 402990700,
 -1,
 403445773,
 403338710,
 121175,
 -1,
 403423031,
 121176,
 -59378,
 403422212,
 121173,
 -1,
 403538895,
 121174,
 403767295,
 402218333,
 -1,
 403773464,
 403690123,
 -1,
 403838999,
 403717821,
 -1,
 403904533,
 403775309,
 -1,
 -59372,
 403880964,
 121126,
 -1,
 403928534,
 121125,
 -59370,
 403880964,
 121122,
 -1,
 404059606,
 121121,
 -1,
 403814423,
 121123,
 -59367,
 403749496,
 121127,
 -1,
 404242210,
 121124,
 404488191,
 386389406,
 -1,
 404494375,
 404395835,
 -1,
 404559904,
 404466686,
 121418,
 404684799,
 404488192,
 -1,
 -59361,
 404612077,
 121420,
 -1,
 404677036,
 121419,
 404822052,
 404528181,
 121415,
 404946943,
 404750336,
 -1,
 -59357,
 404874221,
 121417,
 -1,
 404939180,
 121416,
 -59355,
 404808108,
 121414,
 -59354,
 405033195,
 121413,
 -1,
 405090551,
 121412,
 405280813,
 404434148,
 -1,
 405346348,
 405241462,
 -1,
 -59350,
 405310401,
 121403,
 -59349,
 405360875,
 121404,
 -1,
 405419204,
 121405,
 -1,
 405313834,
 121430,
 405674033,
 405259530,
 121424,
 405798911,
 405602304,
 -1,
 -59344,
 405717417,
 121426,
 -1,
 405754091,
 121425,
 405936181,
 405650720,
 121406,
 406061055,
 405864448,
 -1,
 -59340,
 405987756,
 121407,
 -1,
 406034230,
 121408,
 406198329,
 405893932,
 121421,
 406323199,
 406126592,
 -1,
 -59336,
 406249900,
 121423,
 -1,
 406278379,
 121422,
 406460477,
 406147687,
 121409,
 406585343,
 406388736,
 -1,
 -59332,
 406512044,
 121410,
 -1,
 406558518,
 121411,
 406781951,
 406446517,
 -1,
 -59329,
 406698793,
 121431,
 -1,
 406732136,
 121432,
 406919295,
 386318994,
 -1,
 406984796,
 406891179,
 -1,
 407050321,
 406969150,
 -1,
 407115852,
 407024621,
 -1,
 407181384,
 407100222,
 -1,
 -59322,
 407157545,
 121163,
 -59321,
 407190888,
 121164,
 -1,
 407248705,
 121165,
 407502847,
 407130143,
 -1,
 -59318,
 407419689,
 121166,
 -59317,
 407453032,
 121167,
 -1,
 407510849,
 121168,
 407705680,
 407053079,
 -1,
 -59314,
 407685986,
 121172,
 -59313,
 407747369,
 121170,
 -1,
 407780712,
 121171,
 -1,
 407681241,
 121169,
 408092671,
 406999071,
 -1,
 408098907,
 408007661,
 -1,
 408164439,
 408083262,
 -1,
 -59307,
 408140585,
 121220,
 -59306,
 408173928,
 121221,
 -1,
 408231745,
 121222,
 408485887,
 408113183,
 -1,
 -59303,
 408402729,
 121217,
 -59302,
 408436072,
 121218,
 -1,
 408493889,
 121219,
 -1,
 408074457,
 121223,
 408754289,
 406950033,
 -1,
 408819816,
 408718477,
 -1,
 408885345,
 408799413,
 -1,
 -59296,
 408865260,
 121436,
 -1,
 408889629,
 121435,
 409081956,
 408825634,
 -1,
 -59293,
 409059306,
 121439,
 -1,
 409102844,
 121440,
 -59291,
 409059319,
 121433,
 -59290,
 409241547,
 121438,
 -59289,
 409303900,
 121434,
 -1,
 409365001,
 121437,
 409540716,
 408801305,
 -1,
 -59286,
 409516841,
 121093,
 -59285,
 409569413,
 121094,
 -1,
 409610508,
 121095,
 409862143,
 409515125,
 -1,
 409868400,
 409787198,
 -1,
 -59281,
 409845875,
 121458,
 -1,
 409876443,
 121459,
 -1,
 409817148,
 121460,
 410189823,
 408699075,
 -1,
 410196091,
 410077692,
 121441,
 410320895,
 410124288,
 -1,
 410327161,
 410227735,
 -1,
 410392695,
 410306931,
 121443,
 -1,
 410322104,
 121444,
 410583039,
 410352802,
 121445,
 -1,
 410453176,
 121446,
 -59270,
 410290114,
 121442,
 -1,
 410593801,
 121447,
 410845183,
 410160843,
 -1,
 -59267,
 410748217,
 121390,
 -59266,
 410812100,
 121391,
 -1,
 410868920,
 121389,
 411048114,
 406890626,
 -1,
 411113646,
 411015685,
 -1,
 411179165,
 411045478,
 -1,
 411244688,
 411163454,
 -1,
 411310215,
 411220777,
 121250,
 411435007,
 411239236,
 -1,
 -59258,
 411325020,
 121258,
 -1,
 411381831,
 121265,
 411572363,
 411254120,
 121251,
 411697151,
 411501380,
 -1,
 -59254,
 411587164,
 121259,
 -1,
 411643975,
 121266,
 411893759,
 411508505,
 -1,
 411900047,
 411789408,
 -1,
 -59250,
 411849308,
 121260,
 -1,
 411906119,
 121267,
 -1,
 411844803,
 121252,
 412221439,
 411193375,
 -1,
 412227733,
 412138281,
 121311,
 412352511,
 412156740,
 -1,
 -59244,
 412241938,
 121298,
 -1,
 412299014,
 121283,
 412489881,
 412171624,
 121312,
 412614655,
 412418884,
 -1,
 -59240,
 412504082,
 121299,
 -1,
 412561158,
 121284,
 412811263,
 412426049,
 121313,
 412876799,
 412681028,
 -1,
 -59236,
 412766226,
 121300,
 -1,
 412823302,
 121285,
 413073407,
 411108525,
 -1,
 413079718,
 412946666,
 -1,
 -59232,
 413013537,
 121519,
 -59231,
 413078828,
 121518,
 -59230,
 413144152,
 121517,
 -59229,
 413209402,
 121516,
 -59228,
 413274645,
 121515,
 -59227,
 413339882,
 121514,
 -1,
 413405149,
 121513,
 -59225,
 413014146,
 121512,
 -59224,
 413538257,
 121511,
 -59223,
 413603569,
 121510,
 -59222,
 413668897,
 121509,
 -59221,
 413734188,
 121508,
 -59220,
 413799512,
 121507,
 -59219,
 413864762,
 121506,
 -1,
 413930005,
 121505,
 414187519,
 411094798,
 -1,
 -59216,
 414104361,
 121105,
 -59215,
 414156933,
 121106,
 -1,
 414198028,
 121107,
 414390492,
 410992835,
 -1,
 414456026,
 414376950,
 -1,
 414521539,
 414405703,
 -1,
 414587069,
 414505790,
 -1,
 414652602,
 414564430,
 121377,
 414777343,
 414580736,
 -1,
 -59207,
 414661992,
 121378,
 -1,
 414719809,
 121379,
 414973951,
 414592228,
 -1,
 -59204,
 414897408,
 121383,
 -1,
 414936120,
 121385,
 415170559,
 414535711,
 -1,
 415176898,
 415088718,
 121380,
 415301631,
 415105024,
 -1,
 -59199,
 415186280,
 121381,
 -1,
 415244097,
 121382,
 -1,
 415119316,
 121384,
 415504589,
 414496089,
 -1,
 415570119,
 415489537,
 -1,
 -59194,
 415534367,
 121372,
 -1,
 415565124,
 121370,
 415766730,
 415520991,
 -1,
 -59191,
 415733558,
 121369,
 -1,
 415773366,
 121371,
 -59189,
 415743632,
 121365,
 -59188,
 415930166,
 121364,
 -1,
 415969974,
 121366,
 416159953,
 415462976,
 -1,
 -59185,
 416141960,
 121374,
 -59184,
 416174190,
 121376,
 -1,
 416235192,
 121375,
 416422101,
 416099343,
 -1,
 -59181,
 416404104,
 121354,
 -59180,
 416451521,
 121355,
 -1,
 416497336,
 121356,
 416743423,
 416350208,
 -1,
 416749785,
 416623278,
 -1,
 -59176,
 416725801,
 121367,
 -1,
 416778373,
 121368,
 -1,
 416734782,
 121373,
 -59173,
 414442049,
 121452,
 -1,
 416949186,
 121392,
 417143033,
 414348364,
 -1,
 417208557,
 417096065,
 -1,
 417274088,
 417170213,
 -1,
 417339623,
 417233482,
 -1,
 -59167,
 417273585,
 121469,
 -59166,
 417338913,
 121468,
 -59165,
 417404204,
 121467,
 -59164,
 417469528,
 121466,
 -59163,
 417534778,
 121465,
 -59162,
 417600021,
 121464,
 -1,
 417665258,
 121463,
 -1,
 417280895,
 121462,
 417988607,
 417242829,
 -1,
 417994988,
 417857536,
 -1,
 -59157,
 417977243,
 121429,
 -1,
 418021240,
 121428,
 -1,
 417969578,
 121427,
 418316287,
 417173821,
 -1,
 418322678,
 418185216,
 -1,
 418388210,
 418273973,
 -1,
 -59151,
 418342028,
 121473,
 -1,
 418388856,
 121476,
 -59149,
 418373126,
 121474,
 -59148,
 418564549,
 121477,
 -59147,
 418610231,
 121478,
 -1,
 418658877,
 121475,
 418906111,
 418254438,
 -1,
 -59144,
 418831205,
 121471,
 -1,
 418861099,
 121472,
 419043606,
 417090791,
 -1,
 419109125,
 419001420,
 -1,
 419174660,
 419062493,
 -1,
 419240193,
 419149143,
 -1,
 419305728,
 419201467,
 -1,
 -59137,
 419281705,
 121116,
 -1,
 419334277,
 121118,
 -1,
 419252318,
 121119,
 419627007,
 419198428,
 -1,
 -59133,
 419543849,
 121115,
 -1,
 419596421,
 121117,
 -1,
 419141332,
 121456,
 419830029,
 419062145,
 -1,
 419895564,
 419790099,
 -1,
 -59128,
 419829281,
 121503,
 -59127,
 419894572,
 121502,
 -59126,
 419959896,
 121501,
 -59125,
 420025146,
 121500,
 -1,
 420090389,
 121499,
 -1,
 419859545,
 121470,
 420354321,
 419797172,
 -1,
 -59121,
 420340140,
 121363,
 -59120,
 420383681,
 121361,
 -1,
 420426948,
 121362,
 420616469,
 420289228,
 -1,
 420682004,
 420598484,
 121352,
 -1,
 420612623,
 121353,
 -1,
 420630786,
 121351,
 -1,
 420598016,
 121480,
 420944174,
 419018071,
 -1,
 421009697,
 420915210,
 -1,
 421075229,
 420984151,
 -1,
 421140764,
 421036475,
 -1,
 -59109,
 421116713,
 121111,
 -1,
 421169285,
 121113,
 -1,
 421087326,
 121114,
 421402912,
 421033436,
 -1,
 -59105,
 421378857,
 121110,
 -1,
 421431429,
 121112,
 -1,
 421351418,
 121120,
 421665061,
 420989775,
 -1,
 -59101,
 421641001,
 121099,
 -59100,
 421693573,
 121100,
 -1,
 421734668,
 121101,
 421927210,
 421617549,
 -1,
 421992745,
 421879165,
 -1,
 -59096,
 421969418,
 121453,
 -1,
 422028491,
 121454,
 -1,
 421971991,
 121457,
 422254893,
 421909612,
 -1,
 -59092,
 422232702,
 121108,
 -1,
 422258956,
 121109,
 -1,
 422200867,
 121481,
 422517058,
 420886543,
 -1,
 422582588,
 422503708,
 -1,
 422648116,
 422557015,
 -1,
 422713651,
 422602337,
 121339,
 -1,
 422641713,
 121340,
 -1,
 422674116,
 121336,
 422910263,
 422585242,
 -1,
 -59082,
 422886404,
 121333,
 -1,
 422933974,
 121334,
 -59080,
 422888714,
 121337,
 -59079,
 423079109,
 121338,
 -59078,
 423122680,
 121342,
 -59077,
 423185798,
 121335,
 -1,
 423250854,
 121341,
 423493631,
 422554475,
 -1,
 423500096,
 423398345,
 -1,
 -59073,
 423481992,
 121360,
 -1,
 423509688,
 121357,
 -59071,
 423482057,
 121359,
 -1,
 423640833,
 121358,
 423827786,
 422480168,
 -1,
 423893321,
 423795083,
 -1,
 423958855,
 423877348,
 -1,
 -59066,
 423932344,
 121395,
 -1,
 423978113,
 121396,
 -59064,
 423922625,
 121393,
 -1,
 424096964,
 121394,
 -1,
 423838452,
 121450,
 424352082,
 423767268,
 -1,
 424417615,
 424303491,
 -1,
 -59059,
 424395177,
 121388,
 -59058,
 424453674,
 121386,
 -1,
 424512449,
 121387,
 424738815,
 424382609,
 -1,
 -59055,
 424642238,
 121479,
 -1,
 424705521,
 121482,
 424876378,
 424291251,
 -1,
 424941911,
 424858939,
 -1,
 -59051,
 424917801,
 121102,
 -59050,
 424970373,
 121103,
 -1,
 425011468,
 121104,
 425263103,
 424886953,
 -1,
 -59047,
 425158973,
 121401,
 -1,
 425217034,
 121402,
 425400673,
 424811868,
 -1,
 425466206,
 425378212,
 -1,
 -59043,
 425420909,
 121398,
 -1,
 425462017,
 121400,
 425721855,
 425405109,
 -1,
 -59040,
 425617579,
 121397,
 -1,
 425658625,
 121399,
 425859429,
 425350972,
 -1,
 -59037,
 425835305,
 121096,
 -59036,
 425887877,
 121097,
 -1,
 425928972,
 121098,
 -59034,
 425843529,
 121455,
 -59033,
 426103672,
 121461,
 -1,
 426156140,
 121483,
 -1,
 361694509,
 129304,
 426383857,
 361641999,
 -1,
 426449382,
 426326708,
 -1,
 426514862,
 426408587,
 -1,
 426580342,
 426492562,
 -1,
 426645871,
 426565834,
 71129,
 -1,
 426598785,
 71130,
 426776946,
 426623634,
 -1,
 -59023,
 426727486,
 71065,
 -1,
 426776884,
 71064,
 426973557,
 426727464,
 -1,
 -59020,
 426945643,
 71128,
 -1,
 426973492,
 71070,
 -1,
 426907956,
 71069,
 427235709,
 426563064,
 -1,
 427301244,
 427200812,
 -1,
 427366778,
 427272322,
 71046,
 -1,
 427337858,
 71047,
 427556863,
 427324492,
 71048,
 -1,
 427455564,
 71049,
 -1,
 427235636,
 71082,
 427694466,
 427170100,
 71040,
 -59009,
 427675165,
 71053,
 -59008,
 427720681,
 71131,
 -59007,
 427778433,
 71051,
 -1,
 427825460,
 71041,
 428022151,
 427657512,
 -1,
 -59004,
 428008308,
 71063,
 -59003,
 428050802,
 71068,
 -59002,
 428102465,
 71058,
 -1,
 428153140,
 71073,
 428349837,
 427964431,
 -1,
 428415371,
 428292111,
 -1,
 -58998,
 428365886,
 71067,
 -1,
 428415284,
 71066,
 -58996,
 428365886,
 71072,
 -1,
 428546356,
 71071,
 428743057,
 428324183,
 -1,
 -58993,
 428717569,
 71084,
 -58992,
 428759102,
 71083,
 -1,
 428808500,
 71085,
 429005203,
 428723741,
 71044,
 -1,
 428985885,
 71045,
 429136278,
 428973773,
 -1,
 -58987,
 429086782,
 71075,
 -1,
 429136180,
 71074,
 429332889,
 429093003,
 -1,
 -58984,
 429283390,
 71055,
 -1,
 429332788,
 71054,
 429529500,
 429289311,
 -1,
 -58981,
 429479998,
 71062,
 -1,
 429529396,
 71061,
 429726110,
 429482369,
 71042,
 -1,
 429678977,
 71043,
 429857185,
 429675250,
 -1,
 -58976,
 429807678,
 71057,
 -1,
 429857076,
 71056,
 430053796,
 429796580,
 -1,
 -58973,
 430004286,
 71060,
 -1,
 430053684,
 71059,
 430250407,
 429991615,
 -1,
 -58970,
 430200894,
 71077,
 -1,
 430250292,
 71076,
 -58968,
 430236532,
 71079,
 -58967,
 430418165,
 71080,
 -58966,
 430477457,
 71052,
 -58965,
 430538971,
 71078,
 -58964,
 430601366,
 71081,
 -58963,
 430659646,
 71086,
 -1,
 430719171,
 71050,
 430905807,
 426489175,
 -1,
 430971335,
 430850243,
 -1,
 431036868,
 430913294,
 -1,
 431102402,
 431021664,
 -1,
 431167927,
 431082134,
 -1,
 431233462,
 431110648,
 -1,
 -58955,
 431214223,
 71114,
 -1,
 431242517,
 71115,
 -1,
 431203038,
 71122,
 431495611,
 431139521,
 -1,
 -58951,
 431475569,
 71118,
 -58950,
 431504876,
 71117,
 -1,
 431568333,
 71116,
 431757759,
 431436188,
 -1,
 -58947,
 431738320,
 71126,
 -58946,
 431794870,
 71125,
 -1,
 431837563,
 71127,
 -58944,
 431732720,
 71124,
 -58943,
 431990633,
 71123,
 -1,
 432029164,
 71121,
 432275455,
 431046242,
 71119,
 -1,
 432147887,
 71120,
 432406527,
 431005764,
 -1,
 -58938,
 432290894,
 71108,
 -1,
 432351128,
 71109,
 432603135,
 430925112,
 -1,
 432609739,
 432527594,
 -1,
 -58934,
 432584401,
 71102,
 -1,
 432646660,
 71103,
 -58932,
 432585317,
 71105,
 -58931,
 432771005,
 71104,
 -58930,
 432811448,
 71100,
 -1,
 432873870,
 71101,
 433068510,
 430889584,
 -1,
 433134038,
 433002804,
 -1,
 433199571,
 433094633,
 71132,
 -1,
 433180189,
 71133,
 -58924,
 433180189,
 71099,
 -58923,
 433283457,
 71097,
 -1,
 433330484,
 71087,
 433527256,
 433117597,
 71092,
 -1,
 433498242,
 71093,
 433658330,
 433507869,
 71090,
 -1,
 433638941,
 71091,
 433789404,
 433611137,
 71088,
 -1,
 433742209,
 71089,
 -58915,
 433754257,
 71098,
 -1,
 433864899,
 71096,
 434051554,
 433040647,
 -1,
 -58912,
 433984314,
 71112,
 -58911,
 434049557,
 71111,
 -1,
 434114794,
 71110,
 434313701,
 433993743,
 -1,
 -58908,
 434281124,
 71107,
 -1,
 434315400,
 71106,
 -1,
 434259695,
 71113,
 434634751,
 426396602,
 -1,
 434641388,
 434560259,
 -1,
 -58903,
 434623226,
 128414,
 -58902,
 434679682,
 128409,
 -58901,
 434731156,
 128408,
 -1,
 434781966,
 128415,
 435027967,
 434580003,
 -1,
 -58898,
 434950906,
 128416,
 -58897,
 435007362,
 128411,
 -58896,
 435058836,
 128410,
 -1,
 435109646,
 128417,
 435296814,
 426346792,
 -1,
 435362340,
 435247308,
 -1,
 435427857,
 435298894,
 -1,
 435493380,
 435392455,
 -1,
 435558905,
 435470994,
 -1,
 -58889,
 435543170,
 70123,
 -58888,
 435576217,
 70124,
 -1,
 435635786,
 70122,
 435821052,
 435533143,
 -1,
 -58885,
 435777306,
 70127,
 -1,
 435833653,
 70128,
 436017663,
 435786931,
 -1,
 -58882,
 435996253,
 70132,
 -1,
 436035847,
 70131,
 436214274,
 435965159,
 -1,
 -58879,
 436181358,
 70125,
 -1,
 436233187,
 70126,
 -58877,
 436178184,
 70130,
 -1,
 436356448,
 70129,
 436600831,
 435436382,
 -1,
 436607496,
 436519570,
 -1,
 -58873,
 436592656,
 70114,
 -1,
 436625361,
 70115,
 436804107,
 436581719,
 -1,
 -58870,
 436760274,
 70118,
 -1,
 436816619,
 70119,
 437000718,
 436751591,
 -1,
 -58867,
 436968219,
 70116,
 -1,
 437022240,
 70117,
 -58865,
 436966575,
 70113,
 -58864,
 437161176,
 70121,
 -1,
 437208333,
 70120,
 437393951,
 435387593,
 -1,
 437459477,
 437371538,
 -1,
 -58860,
 437444624,
 3560,
 -1,
 437477329,
 3561,
 437656088,
 437433687,
 -1,
 -58857,
 437612242,
 3564,
 -1,
 437668587,
 3565,
 437852699,
 437603559,
 -1,
 -58854,
 437820187,
 3562,
 -1,
 437874208,
 3563,
 -58852,
 437839498,
 3558,
 -58851,
 438015151,
 3559,
 -58850,
 438078680,
 3567,
 -1,
 438125837,
 3566,
 438370303,
 437335136,
 -1,
 438376995,
 438282370,
 -1,
 -58846,
 438323221,
 983935,
 -1,
 438377987,
 983934,
 -1,
 438363101,
 983933,
 438697983,
 435312286,
 -1,
 438704683,
 438566912,
 -1,
 438770217,
 438679975,
 -1,
 -58840,
 438755344,
 983154,
 -1,
 438788049,
 983157,
 -58838,
 438720287,
 983182,
 -1,
 438906817,
 983184,
 439156735,
 438636448,
 -1,
 -58835,
 439030586,
 983158,
 -1,
 439095829,
 983155,
 439294513,
 435282445,
 -1,
 -58832,
 439271310,
 128303,
 -1,
 439329433,
 128973,
 -1,
 439253825,
 128510,
 439556903,
 361599121,
 983077,
 439622304,
 439543105,
 -1,
 439687788,
 439581323,
 -1,
 439753278,
 439665298,
 -1,
 439818809,
 439730834,
 -1,
 -58824,
 439769150,
 72295,
 -1,
 439818548,
 72294,
 440015420,
 439792983,
 -1,
 -58821,
 439965758,
 72310,
 -1,
 440015156,
 72309,
 -58819,
 439965758,
 72300,
 -1,
 440146228,
 72299,
 440343109,
 439695375,
 -1,
 440408642,
 440285199,
 -1,
 -58815,
 440358974,
 72297,
 -1,
 440408372,
 72296,
 -58813,
 440395213,
 72311,
 -58812,
 440555582,
 72302,
 -1,
 440604980,
 72301,
 440801866,
 440305960,
 -1,
 -58809,
 440787828,
 72293,
 -58808,
 440830322,
 72298,
 -58807,
 440881985,
 72288,
 -1,
 440932660,
 72303,
 441129550,
 440776023,
 -1,
 -58804,
 441103873,
 72320,
 -58803,
 441145406,
 72319,
 -1,
 441194804,
 72321,
 441391698,
 441086091,
 -1,
 -58800,
 441368244,
 72323,
 -58799,
 441407550,
 72285,
 -1,
 441456948,
 72284,
 441653845,
 441378237,
 -1,
 -58796,
 441604158,
 72312,
 -1,
 441653556,
 72313,
 441850456,
 441622221,
 -1,
 -58793,
 441800766,
 72305,
 -1,
 441850164,
 72304,
 442047067,
 441806687,
 -1,
 -58790,
 441997374,
 72292,
 -1,
 442046772,
 72291,
 442243678,
 441996018,
 -1,
 -58787,
 442193982,
 72287,
 -1,
 442243380,
 72286,
 442440289,
 442182884,
 -1,
 -58784,
 442390590,
 72290,
 -1,
 442439988,
 72289,
 442636900,
 442377919,
 -1,
 -58781,
 442587198,
 72307,
 -1,
 442636596,
 72306,
 -58779,
 442622836,
 72315,
 -58778,
 442816014,
 72318,
 -58777,
 442870005,
 72316,
 -58776,
 442925275,
 72308,
 -58775,
 442987670,
 72317,
 -58774,
 443045950,
 72322,
 -58773,
 443095348,
 72272,
 -1,
 443158126,
 72314,
 443357817,
 439635631,
 -1,
 443423343,
 443331927,
 72340,
 -1,
 443373608,
 72339,
 443554417,
 443386152,
 72334,
 -1,
 443503346,
 72332,
 -58766,
 443525250,
 72337,
 -58765,
 443646085,
 72336,
 -58764,
 443708492,
 72338,
 -58763,
 443773067,
 72331,
 -58762,
 443831026,
 72330,
 -58761,
 443889679,
 72333,
 -58760,
 443950783,
 72335,
 -1,
 444010094,
 72341,
 444209800,
 443341358,
 -1,
 444275335,
 444185289,
 -1,
 444340862,
 444258698,
 -1,
 -58755,
 444311682,
 72281,
 -1,
 444363852,
 72282,
 444537472,
 444321309,
 72275,
 -1,
 444481731,
 72274,
 444668546,
 444502161,
 72277,
 -1,
 444612803,
 72278,
 444799621,
 444602676,
 -1,
 -58748,
 444780061,
 72280,
 -1,
 444817793,
 72279,
 -58746,
 444752257,
 72273,
 -1,
 444940483,
 72276,
 -1,
 444234302,
 72283,
 445192845,
 444170890,
 -1,
 -58742,
 445172722,
 72346,
 -58741,
 445233353,
 72347,
 -58740,
 445293482,
 72349,
 -1,
 445333102,
 72348,
 445520531,
 445133620,
 -1,
 445586065,
 445494615,
 -1,
 -58736,
 445536318,
 72328,
 -1,
 445585716,
 72329,
 -58734,
 445556981,
 72326,
 -1,
 445740182,
 72327,
 445913752,
 445494615,
 -1,
 445979287,
 445867320,
 -1,
 -58730,
 445962573,
 72343,
 -1,
 445981070,
 72342,
 -1,
 445960005,
 72345,
 446241436,
 445864661,
 72352,
 446365695,
 446169154,
 -1,
 -58725,
 446286753,
 72350,
 -1,
 446320594,
 72351,
 446503583,
 446219582,
 -1,
 -58722,
 446435861,
 72354,
 -1,
 446501098,
 72353,
 -1,
 446452957,
 72344,
 446765785,
 439571595,
 -1,
 446831291,
 446724747,
 -1,
 446896807,
 446805335,
 -1,
 446962342,
 446830900,
 -1,
 -58715,
 446923876,
 69436,
 -1,
 446970554,
 69439,
 -1,
 446913861,
 69441,
 447224490,
 446854220,
 -1,
 -58711,
 447170989,
 69444,
 -1,
 447225740,
 69433,
 447421100,
 447175349,
 69427,
 -1,
 447399321,
 69430,
 447552175,
 447355188,
 -1,
 -58706,
 447538320,
 69437,
 -1,
 447576664,
 69424,
 -58704,
 447538781,
 69429,
 -58703,
 447735100,
 69431,
 -58702,
 447798282,
 69428,
 -58701,
 447857712,
 69442,
 -58700,
 447917395,
 69440,
 -58699,
 447979732,
 69438,
 -58698,
 448040963,
 69435,
 -58697,
 448103549,
 69434,
 -58696,
 448164176,
 69432,
 -58695,
 448222788,
 69426,
 -58694,
 448286181,
 69443,
 -1,
 448342279,
 69425,
 448535243,
 446772116,
 -1,
 448600767,
 448515436,
 -1,
 -58690,
 448538798,
 69447,
 -1,
 448600688,
 69449,
 448797378,
 448552571,
 -1,
 -58687,
 448735406,
 69453,
 -1,
 448797296,
 69452,
 448993989,
 448740434,
 -1,
 -58684,
 448932014,
 69446,
 -1,
 448993904,
 69448,
 449190600,
 448935885,
 -1,
 -58681,
 449128622,
 69451,
 -1,
 449190512,
 69450,
 -58679,
 449167607,
 69456,
 -58678,
 449359176,
 69455,
 -1,
 449412643,
 69454,
 449583826,
 448505414,
 -1,
 449649360,
 449563998,
 -1,
 449714895,
 449632262,
 69461,
 -1,
 449645571,
 69462,
 -1,
 449655209,
 69464,
 -58671,
 449599735,
 69465,
 -1,
 449851716,
 69463,
 450042584,
 449548231,
 -1,
 450108118,
 450019986,
 -1,
 -58667,
 450092162,
 69459,
 -1,
 450119242,
 69458,
 450363391,
 450073775,
 69457,
 -1,
 450233176,
 69460,
 -1,
 449996467,
 69445,
 450501381,
 446736644,
 -1,
 450566903,
 450460299,
 -1,
 450632415,
 450529576,
 -1,
 -58659,
 450618235,
 69857,
 -58658,
 450646947,
 69847,
 -1,
 450698473,
 69849,
 450894562,
 450592987,
 -1,
 -58655,
 450844712,
 69846,
 -1,
 450904259,
 69864,
 451091173,
 450838723,
 -1,
 -58652,
 451041320,
 69863,
 -1,
 451101882,
 69859,
 -58650,
 451076987,
 69852,
 -58649,
 451270169,
 69850,
 -58648,
 451334298,
 69861,
 -58647,
 451396467,
 69841,
 -58646,
 451458602,
 69840,
 -58645,
 451520850,
 69853,
 -58644,
 451583855,
 69851,
 -58643,
 451646046,
 69862,
 -58642,
 451704151,
 69848,
 -58641,
 451768609,
 69855,
 -58640,
 451833737,
 69856,
 -58639,
 451896712,
 69860,
 -58638,
 451958901,
 69854,
 -58637,
 452023203,
 69845,
 -58636,
 452081878,
 69844,
 -58635,
 452144454,
 69843,
 -58634,
 452208442,
 69842,
 -1,
 452271337,
 69858,
 452526079,
 450509662,
 -1,
 452532987,
 452444818,
 -1,
 -58630,
 452517904,
 69874,
 -1,
 452550609,
 69875,
 452729598,
 452506967,
 -1,
 -58627,
 452685522,
 69878,
 -1,
 452741867,
 69879,
 452926209,
 452676839,
 -1,
 -58624,
 452893467,
 69876,
 -1,
 452947488,
 69877,
 -58622,
 452912778,
 69872,
 -58621,
 453088431,
 69873,
 -58620,
 453151960,
 69881,
 -1,
 453199117,
 69880,
 453384986,
 450483614,
 -1,
 453450512,
 453368999,
 -1,
 453516043,
 453420020,
 -1,
 -58615,
 453499196,
 128601,
 -58614,
 453539791,
 128593,
 -1,
 453586003,
 128609,
 453778189,
 453495550,
 11113,
 -1,
 453708500,
 11129,
 -58610,
 453762314,
 11011,
 -58609,
 453883567,
 129111,
 -1,
 453913130,
 11019,
 454164479,
 453395009,
 -1,
 454171413,
 454075380,
 -1,
 -58605,
 454154556,
 128603,
 -58604,
 454195151,
 128595,
 -1,
 454241363,
 128611,
 454433559,
 454150910,
 11112,
 -1,
 454363860,
 11128,
 -58600,
 454417674,
 11010,
 -58599,
 454538927,
 129110,
 -1,
 454568490,
 11018,
 454761247,
 453333642,
 -1,
 454826782,
 454688768,
 -1,
 -58595,
 454801761,
 128428,
 -1,
 454845130,
 127846,
 -1,
 454764378,
 129358,
 455088929,
 454720367,
 128618,
 -1,
 455017329,
 128619,
 455220004,
 455027940,
 -1,
 -58589,
 455177168,
 129510,
 -1,
 455225172,
 9917,
 -58587,
 455193943,
 983181,
 -58586,
 455382136,
 128284,
 -1,
 455432232,
 983043,
 455613451,
 439506984,
 -1,
 455678956,
 455547188,
 -1,
 455744426,
 455649410,
 -1,
 455809961,
 455678881,
 -1,
 455875435,
 455768715,
 -1,
 455940915,
 455857656,
 -1,
 456006450,
 455905580,
 -1,
 456071984,
 455977090,
 70025,
 -1,
 456042626,
 70026,
 456261631,
 456029260,
 70027,
 -1,
 456160332,
 70028,
 -1,
 455940404,
 70062,
 456399673,
 455918226,
 -1,
 456465207,
 456376978,
 -1,
 -58570,
 456415294,
 70044,
 -1,
 456464692,
 70043,
 -58568,
 456415294,
 70049,
 -1,
 456595764,
 70048,
 456792894,
 456362280,
 -1,
 -58565,
 456778612,
 70042,
 -58564,
 456821106,
 70047,
 -58563,
 456872769,
 70037,
 -1,
 456923444,
 70052,
 457120580,
 456734735,
 -1,
 457186114,
 457062415,
 -1,
 -58559,
 457136190,
 70046,
 -1,
 457185588,
 70045,
 -58557,
 457136190,
 70051,
 -1,
 457316660,
 70050,
 457513800,
 457054516,
 70019,
 -58554,
 457494045,
 70032,
 -58553,
 457531777,
 70030,
 -1,
 457578804,
 70020,
 457775948,
 457487703,
 -1,
 -58550,
 457750017,
 70064,
 -58549,
 457791550,
 70063,
 -1,
 457840948,
 70065,
 458038094,
 457756189,
 70023,
 -1,
 458018333,
 70024,
 458169169,
 458006221,
 -1,
 -58544,
 458119230,
 70054,
 -1,
 458168628,
 70053,
 458365780,
 458126412,
 -1,
 -58541,
 458323094,
 70061,
 -1,
 458365236,
 70060,
 458562391,
 458322059,
 -1,
 -58538,
 458512446,
 70034,
 -1,
 458561844,
 70033,
 458759002,
 458518367,
 -1,
 -58535,
 458709054,
 70041,
 -1,
 458758452,
 70040,
 458955612,
 458711425,
 70021,
 -1,
 458908033,
 70022,
 459086687,
 458904306,
 -1,
 -58530,
 459036734,
 70036,
 -1,
 459086132,
 70035,
 459283298,
 459025636,
 -1,
 -58527,
 459233342,
 70039,
 -1,
 459282740,
 70038,
 459479909,
 459220671,
 -1,
 -58524,
 459429950,
 70056,
 -1,
 459479348,
 70055,
 -58522,
 459465588,
 70058,
 -58521,
 459647221,
 70059,
 -58520,
 459706513,
 70031,
 -58519,
 459768027,
 70057,
 -58518,
 459823166,
 70066,
 -1,
 459882691,
 70029,
 460069757,
 455858734,
 -1,
 460135292,
 460045001,
 -1,
 460200818,
 460118410,
 -1,
 460266352,
 460171394,
 70072,
 -1,
 460236930,
 70073,
 460455935,
 460223564,
 70074,
 -1,
 460354636,
 70075,
 460528502,
 460134708,
 -1,
 -58508,
 460508701,
 70079,
 -58507,
 460546433,
 70077,
 -1,
 460593460,
 70067,
 460790648,
 460508701,
 70070,
 -1,
 460770845,
 70071,
 460921722,
 460743041,
 70068,
 -1,
 460874113,
 70069,
 -58501,
 460886161,
 70078,
 -1,
 460996803,
 70076,
 -1,
 460097360,
 70091,
 461249425,
 460043607,
 -1,
 461314954,
 461202744,
 -1,
 461380482,
 461297898,
 -1,
 -58495,
 461354705,
 70018,
 -1,
 461416964,
 70080,
 461577093,
 461314356,
 -1,
 -58492,
 461559313,
 70081,
 -1,
 461606924,
 70017,
 -58490,
 461558601,
 70083,
 -58489,
 461748837,
 70107,
 -58488,
 461803453,
 70090,
 -58487,
 461860864,
 70082,
 -1,
 461909432,
 70016,
 462101391,
 461258947,
 -1,
 462166926,
 462042906,
 -1,
 -58483,
 462098965,
 70111,
 -1,
 462164202,
 70110,
 -1,
 462135356,
 70088,
 -58480,
 462083545,
 70093,
 -1,
 462364829,
 70089,
 462560162,
 461191183,
 -1,
 462625696,
 462513441,
 -1,
 462691222,
 462602898,
 -1,
 -58475,
 462675984,
 70098,
 -1,
 462708689,
 70099,
 462887833,
 462665047,
 -1,
 -58472,
 462843602,
 70102,
 -1,
 462899947,
 70103,
 463084444,
 462834919,
 -1,
 -58469,
 463051547,
 70100,
 -1,
 463105568,
 70101,
 -58467,
 463070858,
 70096,
 -58466,
 463246511,
 70097,
 -58465,
 463310040,
 70105,
 -1,
 463357197,
 70104,
 -58463,
 462592676,
 70086,
 -1,
 463478920,
 70085,
 463674277,
 462504131,
 -1,
 -58460,
 463659746,
 70092,
 -1,
 463696194,
 70106,
 -58458,
 463639443,
 70084,
 -58457,
 463821584,
 70108,
 -58456,
 463877342,
 70109,
 -1,
 463936089,
 70087,
 -1,
 455766155,
 129416,
 464198634,
 455726584,
 -1,
 464264169,
 464151128,
 -1,
 464329654,
 464197940,
 -1,
 464395184,
 464300162,
 -1,
 -58449,
 464366258,
 66684,
 -1,
 464404675,
 66680,
 -58447,
 464378955,
 66679,
 -58446,
 464566367,
 66664,
 -58445,
 464612288,
 66682,
 -58444,
 464672808,
 66669,
 -58443,
 464737426,
 66673,
 -1,
 464796685,
 66665,
 464985021,
 464294033,
 -1,
 -58440,
 464967052,
 66668,
 -58439,
 465021058,
 66681,
 -58438,
 465084060,
 66677,
 -58437,
 465144104,
 66666,
 -58436,
 465200544,
 66678,
 -1,
 465247729,
 66676,
 465443779,
 464928963,
 -1,
 465509313,
 465377588,
 -1,
 -58432,
 465486482,
 66672,
 -1,
 465545346,
 66685,
 -58430,
 465482788,
 66683,
 -1,
 465655073,
 66663,
 465837000,
 465420946,
 -1,
 465902535,
 465786920,
 -1,
 -58426,
 465855624,
 66644,
 -1,
 465915093,
 66654,
 -1,
 465869239,
 66641,
 466164684,
 465789313,
 -1,
 -58422,
 466111719,
 66662,
 -58421,
 466169561,
 66674,
 -1,
 466231224,
 66686,
 466426831,
 466150390,
 -1,
 -58418,
 466410212,
 66687,
 -1,
 466426164,
 66648,
 466623442,
 466411536,
 -1,
 -58415,
 466588388,
 66667,
 -1,
 466632899,
 66658,
 466820053,
 466597207,
 -1,
 -58412,
 466801768,
 66646,
 -1,
 466849937,
 66645,
 467016664,
 466780293,
 -1,
 -58409,
 466970137,
 66661,
 -1,
 467026589,
 66656,
 467213275,
 466966568,
 -1,
 -58406,
 467194404,
 66649,
 -1,
 467212745,
 66659,
 -58404,
 467199783,
 66655,
 -58403,
 467393060,
 66653,
 -58402,
 467456648,
 66675,
 -58401,
 467514138,
 66670,
 -58400,
 467575055,
 66640,
 -58399,
 467636227,
 66671,
 -58398,
 467697132,
 66660,
 -58397,
 467759821,
 66642,
 -58396,
 467824746,
 66657,
 -58395,
 467882900,
 66652,
 -58394,
 467946943,
 66643,
 -58393,
 468007344,
 66651,
 -58392,
 468070592,
 66647,
 -1,
 468134281,
 66650,
 -1,
 464208682,
 127847,
 -58389,
 464160792,
 9752,
 -1,
 468352398,
 129368,
 468524031,
 455643281,
 -1,
 468589561,
 468497530,
 -1,
 468655091,
 468539806,
 -1,
 -58384,
 468636460,
 113827,
 -58383,
 468679337,
 113824,
 -58382,
 468729660,
 113826,
 -1,
 468792560,
 113825,
 468982776,
 468582400,
 -1,
 469048311,
 468919999,
 -1,
 -58378,
 468993885,
 11103,
 -1,
 469048106,
 11087,
 -1,
 469023722,
 11086,
 -1,
 468921678,
 127856,
 469375996,
 468559121,
 -1,
 -58373,
 469355450,
 128722,
 -1,
 469378869,
 128717,
 -58371,
 469359774,
 128703,
 -58370,
 469539370,
 127776,
 -1,
 469578309,
 129327,
 469769222,
 468476289,
 -1,
 469834755,
 469717645,
 -1,
 -58366,
 469801952,
 983075,
 -1,
 469853805,
 983078,
 -58364,
 469802701,
 128674,
 -58363,
 469995415,
 9961,
 -1,
 470042011,
 128737,
 470227977,
 469739650,
 -1,
 -58360,
 470208647,
 129335,
 -1,
 470247005,
 129424,
 -58358,
 470213388,
 983197,
 -1,
 470369297,
 128017,
 470555865,
 455547188,
 -1,
 470621307,
 470537255,
 -1,
 470686842,
 470557799,
 -1,
 470752336,
 470645387,
 -1,
 470817814,
 470734328,
 -1,
 470883349,
 470782252,
 -1,
 470948883,
 470853762,
 43144,
 -1,
 470919298,
 43145,
 471138303,
 470905932,
 43146,
 -1,
 471037004,
 43147,
 -1,
 470817076,
 43182,
 471276572,
 470794898,
 -1,
 471342106,
 471253650,
 -1,
 -58343,
 471291966,
 43165,
 -1,
 471341364,
 43164,
 -58341,
 471291966,
 43170,
 -1,
 471472436,
 43169,
 471669793,
 471238952,
 -1,
 -58338,
 471655284,
 43163,
 -58337,
 471697778,
 43168,
 -58336,
 471749441,
 43158,
 -1,
 471800116,
 43173,
 471997479,
 471611407,
 -1,
 472063013,
 471939087,
 -1,
 -58332,
 472012862,
 43167,
 -1,
 472062260,
 43166,
 -58330,
 472012862,
 43172,
 -1,
 472193332,
 43171,
 472390699,
 471931188,
 43138,
 -58327,
 472370717,
 43153,
 -58326,
 472408449,
 43150,
 -1,
 472455476,
 43139,
 472652847,
 472364375,
 -1,
 -58323,
 472626689,
 43184,
 -58322,
 472668222,
 43183,
 -1,
 472717620,
 43185,
 472914993,
 472632861,
 43142,
 -1,
 472895005,
 43143,
 473046068,
 472882893,
 -1,
 -58317,
 472995902,
 43175,
 -1,
 473045300,
 43174,
 473242678,
 473010321,
 43151,
 -1,
 473206929,
 43152,
 473373753,
 473199692,
 -1,
 -58312,
 473330838,
 43187,
 -1,
 473372980,
 43181,
 473570364,
 473329803,
 -1,
 -58309,
 473520190,
 43155,
 -1,
 473569588,
 43154,
 473766975,
 473526111,
 -1,
 -58306,
 473716798,
 43162,
 -1,
 473766196,
 43161,
 473963585,
 473719169,
 43140,
 -1,
 473915777,
 43141,
 474094660,
 473912050,
 -1,
 -58301,
 474044478,
 43157,
 -1,
 474093876,
 43156,
 474291270,
 474038467,
 43148,
 -1,
 474235075,
 43149,
 474422345,
 474229988,
 -1,
 -58296,
 474372158,
 43160,
 -1,
 474421556,
 43159,
 474618956,
 474359487,
 -1,
 -58293,
 474568766,
 43177,
 -1,
 474618164,
 43176,
 -58291,
 474604404,
 43179,
 -58290,
 474786037,
 43180,
 -58289,
 474841307,
 43178,
 -1,
 474896446,
 43186,
 475077730,
 470735472,
 -1,
 475143254,
 475060618,
 -1,
 475208788,
 475113602,
 43194,
 -1,
 475179138,
 43195,
 475398143,
 475165772,
 43196,
 -1,
 475296844,
 43197,
 475470938,
 475076916,
 -1,
 -58280,
 475450909,
 43203,
 -58279,
 475488641,
 43200,
 -1,
 475535668,
 43189,
 475733084,
 475450909,
 43192,
 -1,
 475713053,
 43193,
 475864158,
 475697297,
 43201,
 -1,
 475828369,
 43202,
 475995232,
 475816321,
 43190,
 -1,
 475947393,
 43191,
 476184575,
 475939011,
 43198,
 -1,
 476070083,
 43199,
 476257395,
 475019279,
 -1,
 476322929,
 476210465,
 -1,
 476388455,
 476299922,
 -1,
 -58266,
 476373008,
 43218,
 -1,
 476405713,
 43219,
 476585066,
 476362071,
 -1,
 -58263,
 476540626,
 43222,
 -1,
 476596971,
 43223,
 476781677,
 476531943,
 -1,
 -58260,
 476748571,
 43220,
 -1,
 476802592,
 43221,
 -58258,
 476767882,
 43216,
 -58257,
 476943535,
 43217,
 -58256,
 477007064,
 43225,
 -1,
 477054221,
 43224,
 -58254,
 476289700,
 43215,
 -1,
 477175944,
 43214,
 477371513,
 476232393,
 -1,
 477437047,
 477354218,
 -1,
 -58250,
 477411025,
 43137,
 -1,
 477473284,
 43204,
 -58248,
 477375928,
 43205,
 -1,
 477569422,
 43136,
 -1,
 477312134,
 43188,
 -1,
 470652892,
 129429,
 477895881,
 470581884,
 -1,
 477961367,
 477854347,
 -1,
 478026881,
 477938322,
 -1,
 -58241,
 478000661,
 2065,
 -58240,
 478047568,
 2056,
 -1,
 478091759,
 2069,
 478289029,
 477979009,
 -1,
 -58237,
 478274316,
 2052,
 -58236,
 478331538,
 2055,
 -1,
 478382376,
 2063,
 478551176,
 478262615,
 -1,
 -58233,
 478505213,
 2062,
 -1,
 478566769,
 2068,
 478747787,
 478488255,
 -1,
 -58230,
 478702928,
 2049,
 -1,
 478747116,
 2053,
 -58228,
 478733936,
 2054,
 -58227,
 478930357,
 2057,
 -58226,
 478982751,
 2067,
 -58225,
 479045708,
 2066,
 -58224,
 479105027,
 2061,
 -58223,
 479168040,
 2060,
 -58222,
 479229104,
 2059,
 -58221,
 479293697,
 2058,
 -58220,
 479351733,
 2050,
 -58219,
 479415895,
 2064,
 -58218,
 479475946,
 2051,
 -1,
 479534668,
 2048,
 479730857,
 477944432,
 -1,
 479796382,
 479690244,
 -1,
 479861915,
 479729972,
 2082,
 -1,
 479795508,
 2079,
 -58212,
 479841821,
 2086,
 -58211,
 479945089,
 2089,
 -1,
 480002243,
 2076,
 480189601,
 479760529,
 2091,
 480313343,
 480171940,
 2081,
 -1,
 480188724,
 2078,
 480386212,
 480163159,
 -1,
 -58205,
 480366809,
 2092,
 -1,
 480403273,
 2085,
 480582822,
 480319796,
 2083,
 -1,
 480516404,
 2080,
 -58201,
 480562717,
 2087,
 -58200,
 480665985,
 2090,
 -1,
 480723139,
 2077,
 480910524,
 479700550,
 -1,
 480976049,
 480844084,
 -1,
 481041582,
 480938280,
 -1,
 -58195,
 481003938,
 2110,
 -1,
 481055936,
 2098,
 -58193,
 481020165,
 2100,
 -58192,
 481211093,
 2108,
 -1,
 481251972,
 2097,
 481434804,
 480961981,
 -1,
 -58189,
 481389499,
 2104,
 -1,
 481434593,
 2106,
 481631415,
 481408343,
 -1,
 -58186,
 481595879,
 2109,
 -1,
 481648098,
 2101,
 -58184,
 481611035,
 2107,
 -58183,
 481797937,
 2105,
 -58182,
 481856385,
 2096,
 -58181,
 481920105,
 2103,
 -1,
 481962046,
 2099,
 482155720,
 480870533,
 -1,
 482221252,
 482091712,
 -1,
 482286784,
 482174573,
 2070,
 -1,
 482217585,
 2071,
 -58175,
 482251077,
 2072,
 -58174,
 482380673,
 2093,
 -58173,
 482428955,
 2075,
 -1,
 482490575,
 2073,
 482738175,
 482185652,
 -1,
 -58170,
 482654714,
 2084,
 -58169,
 482697601,
 2088,
 -1,
 482756635,
 2074,
 -1,
 482089524,
 2102,
 483007698,
 477858088,
 -1,
 483073233,
 482981365,
 -1,
 483138768,
 483023686,
 -1,
 483204303,
 483081583,
 -1,
 -58162,
 483183802,
 128630,
 -1,
 483210175,
 128631,
 -1,
 483163853,
 128632,
 -1,
 483093081,
 128634,
 -1,
 483016870,
 129386,
 483597524,
 482985153,
 128752,
 -1,
 483524822,
 128225,
 -58155,
 483582653,
 127927,
 -58154,
 483688393,
 129474,
 -58153,
 483750396,
 127862,
 -58152,
 483812789,
 9973,
 -1,
 483872234,
 129527,
 484056457,
 470525768,
 -1,
 484121992,
 483992231,
 -1,
 484187503,
 484063249,
 -1,
 484252955,
 484125924,
 -1,
 484318489,
 484208665,
 -1,
 484383986,
 484250924,
 -1,
 484449507,
 484315669,
 -1,
 -58143,
 484382642,
 127545,
 -58142,
 484447526,
 127516,
 -1,
 484512271,
 127520,
 484711654,
 484382850,
 -1,
 -58139,
 484643632,
 127511,
 -1,
 484708876,
 127509,
 484908265,
 484643928,
 -1,
 -58136,
 484840533,
 127525,
 -1,
 484905184,
 127540,
 485104876,
 484840250,
 -1,
 -58133,
 485051701,
 127534,
 -1,
 485109438,
 127506,
 -58131,
 485051704,
 127517,
 -58130,
 485243308,
 127532,
 -58129,
 485304041,
 127505,
 -58128,
 485365886,
 127524,
 -58127,
 485430813,
 127546,
 -1,
 485495304,
 127518,
 485694723,
 484316705,
 -1,
 485760247,
 485626389,
 -1,
 -58123,
 485693734,
 127527,
 -58122,
 485758467,
 127537,
 -1,
 485823779,
 127504,
 486022394,
 485693356,
 -1,
 -58119,
 485955714,
 127542,
 -1,
 486021073,
 127543,
 486219005,
 485954860,
 -1,
 -58116,
 486155982,
 127519,
 -1,
 486218029,
 127515,
 486415616,
 486150970,
 -1,
 -58113,
 486348294,
 127528,
 -1,
 486412509,
 127535,
 -58111,
 486362417,
 127526,
 -58110,
 486556139,
 127541,
 -1,
 486610662,
 127513,
 486808843,
 485627633,
 -1,
 486874375,
 486741292,
 -1,
 -58106,
 486806601,
 127544,
 -1,
 486871570,
 127522,
 -58104,
 486815894,
 127521,
 -58103,
 487004648,
 127539,
 -58102,
 487069993,
 127538,
 -1,
 487133683,
 127514,
 487333138,
 486741289,
 -1,
 487398671,
 487264221,
 -1,
 -58098,
 487331970,
 127530,
 -1,
 487395293,
 127529,
 -58096,
 487332325,
 127512,
 -58095,
 487528571,
 127508,
 -1,
 487592755,
 127533,
 487791894,
 487266257,
 -1,
 -58092,
 487733402,
 127536,
 -58091,
 487795998,
 127523,
 -1,
 487856432,
 127510,
 488112127,
 487725186,
 -1,
 -58088,
 487985655,
 127547,
 -1,
 488050905,
 127531,
 -58086,
 484284079,
 127378,
 -1,
 488207436,
 127377,
 488381758,
 484209740,
 -1,
 488447289,
 488318310,
 -1,
 488512824,
 488386070,
 -1,
 -58081,
 488498621,
 127305,
 -58080,
 488563468,
 127304,
 -58079,
 488628737,
 127303,
 -58078,
 488692452,
 127302,
 -58077,
 488756728,
 127301,
 -58076,
 488820253,
 127300,
 -58075,
 488882834,
 127299,
 -58074,
 488944983,
 127298,
 -58073,
 489007234,
 127297,
 -58072,
 489072338,
 127296,
 -58071,
 489135821,
 127295,
 -58070,
 489197713,
 127294,
 -58069,
 489261352,
 127293,
 -58068,
 489324677,
 127292,
 -58067,
 489387084,
 127291,
 -58066,
 489451659,
 127290,
 -58065,
 489516895,
 127289,
 -58064,
 489578881,
 127288,
 -58063,
 489642024,
 127287,
 -58062,
 489706226,
 127286,
 -58061,
 489770215,
 127285,
 -58060,
 489832643,
 127284,
 -58059,
 489895951,
 127283,
 -58058,
 489958628,
 127282,
 -58057,
 490022591,
 127281,
 -1,
 490084660,
 127280,
 -1,
 488488086,
 127397,
 490405887,
 488411281,
 -1,
 490413373,
 490296869,
 -1,
 -58052,
 490379359,
 10191,
 -1,
 490414073,
 10190,
 -1,
 490389286,
 127401,
 490675528,
 488355159,
 -1,
 490741058,
 490619075,
 -1,
 -58047,
 490723170,
 127393,
 -1,
 490746937,
 127388,
 -58045,
 490714455,
 127309,
 -58044,
 490903944,
 127384,
 -58043,
 490958644,
 127395,
 -58042,
 491020626,
 127402,
 -58041,
 491075599,
 127308,
 -1,
 491134818,
 9949,
 491330894,
 490631307,
 -1,
 491396429,
 491267280,
 -1,
 -58037,
 491369985,
 127490,
 -58036,
 491418489,
 127489,
 -1,
 491469177,
 127507,
 -1,
 491343061,
 9919,
 491724115,
 491280424,
 -1,
 -58032,
 491705848,
 127306,
 -58031,
 491741690,
 127400,
 -58030,
 491798496,
 127399,
 -1,
 491859172,
 127398,
 492051801,
 491670759,
 -1,
 492117335,
 492018463,
 -1,
 -58026,
 492073099,
 127390,
 -1,
 492125387,
 11820,
 -58024,
 492088411,
 127379,
 -1,
 492269173,
 127392,
 492445022,
 492028562,
 -1,
 492510557,
 492428004,
 -1,
 -58020,
 492474531,
 127389,
 -1,
 492521406,
 127394,
 -1,
 492462066,
 127387,
 492772705,
 492426744,
 -1,
 -58016,
 492746071,
 127386,
 -1,
 492802439,
 127404,
 492969316,
 492752413,
 -1,
 -58013,
 492936974,
 127385,
 -1,
 492985010,
 127403,
 493165927,
 492933265,
 -1,
 -58010,
 493128431,
 127396,
 -1,
 493187211,
 127383,
 493362538,
 493127976,
 -1,
 -58007,
 493310706,
 127382,
 -1,
 493374391,
 127381,
 -58005,
 493345859,
 127311,
 -58004,
 493528397,
 127310,
 -58003,
 493586688,
 127307,
 -58002,
 493642523,
 127380,
 -1,
 493700390,
 127391,
 493944831,
 484114432,
 -1,
 493952373,
 493870688,
 -1,
 -57998,
 493933484,
 11028,
 -57997,
 493996410,
 11026,
 -57996,
 494042969,
 11029,
 -1,
 494087007,
 11027,
 494280059,
 493893647,
 -1,
 494345594,
 494239877,
 13175,
 494469119,
 494272512,
 -1,
 -57991,
 494386789,
 13176,
 -1,
 494417729,
 13177,
 -1,
 494301023,
 127376,
 494673278,
 494229544,
 -1,
 -57987,
 494627785,
 127488,
 -1,
 494686962,
 13004,
 494869889,
 494616771,
 -1,
 -57984,
 494851576,
 13006,
 -1,
 494906890,
 13005,
 -57982,
 494851578,
 13278,
 -57981,
 495043604,
 128918,
 -57980,
 495101112,
 11216,
 -57979,
 495152669,
 13178,
 -57978,
 495211435,
 13311,
 -57977,
 495276345,
 9974,
 -1,
 495327579,
 13279,
 -1,
 484074267,
 129425,
 495590909,
 484036125,
 -1,
 495656435,
 495552808,
 -1,
 495721964,
 495597856,
 -1,
 495787450,
 495680139,
 -1,
 495852945,
 495749416,
 -1,
 -57969,
 495838068,
 7057,
 -57968,
 495866689,
 7053,
 -1,
 495917364,
 7060,
 496115094,
 495799527,
 -1,
 496180629,
 496068249,
 -1,
 -57964,
 496140421,
 7103,
 -1,
 496201867,
 7102,
 -1,
 496113972,
 7062,
 496442777,
 496088407,
 -1,
 -57960,
 496427892,
 7087,
 -1,
 496441652,
 7070,
 496639388,
 496412802,
 -1,
 -57957,
 496585287,
 7099,
 -1,
 496638260,
 7067,
 496835999,
 496596044,
 -1,
 -57954,
 496781895,
 7100,
 -1,
 496834868,
 7068,
 497032610,
 496791691,
 -1,
 -57951,
 496982078,
 7086,
 -1,
 497031476,
 7050,
 497229220,
 496976067,
 7048,
 -1,
 497208861,
 7049,
 497360295,
 497166015,
 -1,
 -57946,
 497309758,
 7101,
 -1,
 497359156,
 7064,
 497556905,
 497293620,
 7043,
 -1,
 497500355,
 7046,
 -57942,
 497542605,
 7056,
 -57941,
 497673076,
 7066,
 -57940,
 497738276,
 7071,
 -57939,
 497802020,
 7069,
 -57938,
 497866254,
 7063,
 -57937,
 497929757,
 7045,
 -57936,
 497992472,
 7058,
 -57935,
 498050801,
 7051,
 -57934,
 498114345,
 7061,
 -57933,
 498176145,
 7047,
 -57932,
 498237659,
 7065,
 -57931,
 498298749,
 7055,
 -57930,
 498360705,
 7044,
 -57929,
 498423870,
 7072,
 -57928,
 498488129,
 7052,
 -57927,
 498546846,
 7059,
 -1,
 498609435,
 7054,
 498802120,
 495729502,
 -1,
 498867646,
 498778770,
 -1,
 -57923,
 498851856,
 7090,
 -1,
 498884561,
 7091,
 499064257,
 498840919,
 -1,
 -57920,
 499019474,
 7094,
 -1,
 499075819,
 7095,
 499260868,
 499010791,
 -1,
 -57917,
 499227419,
 7092,
 -1,
 499281440,
 7093,
 -57915,
 499246730,
 7088,
 -57914,
 499422383,
 7089,
 -57913,
 499485912,
 7097,
 -1,
 499533069,
 7096,
 499719634,
 498771539,
 -1,
 499785164,
 499687117,
 -1,
 -57909,
 499766419,
 7362,
 -1,
 499785999,
 7361,
 -57907,
 499761625,
 7360,
 -57906,
 499940065,
 7364,
 -57905,
 500003040,
 7365,
 -57904,
 500054200,
 7366,
 -57903,
 500116825,
 7363,
 -1,
 500180727,
 7367,
 500375002,
 499702396,
 -1,
 500440537,
 500336936,
 -1,
 -57899,
 500426160,
 7077,
 -57898,
 500470655,
 7079,
 -57897,
 500520443,
 7076,
 -57896,
 500583036,
 7081,
 -1,
 500636645,
 7078,
 -1,
 500401322,
 7080,
 500899299,
 500349641,
 -1,
 500964834,
 500866857,
 -1,
 501030369,
 500926760,
 -1,
 501095904,
 500978418,
 -1,
 -57889,
 501079631,
 7042,
 -1,
 501118671,
 7041,
 -1,
 501081091,
 7040,
 -1,
 500990178,
 7082,
 -1,
 500947270,
 7083,
 501489131,
 500839602,
 -1,
 501554663,
 501462695,
 -1,
 -57882,
 501537572,
 7085,
 -1,
 501579995,
 7084,
 501751274,
 501518393,
 -1,
 -57879,
 501704092,
 7075,
 -1,
 501751324,
 7074,
 -1,
 501712464,
 7073,
 -1,
 501425707,
 7098,
 502078958,
 495694419,
 127749,
 -1,
 502007351,
 127748,
 502210033,
 502005760,
 -1,
 -57872,
 502193782,
 127774,
 -1,
 502212769,
 9925,
 -57870,
 502183982,
 127751,
 -1,
 502354009,
 127803,
 502537719,
 495624617,
 -1,
 -57867,
 502520107,
 129465,
 -57866,
 502577217,
 10185,
 -1,
 502619109,
 129464,
 502799866,
 502510935,
 -1,
 -57863,
 502767983,
 128671,
 -1,
 502815820,
 127843,
 502996476,
 502736575,
 983102,
 -1,
 502972424,
 983101,
 -1,
 502967813,
 127940,
 503193180,
 495575820,
 -1,
 503258682,
 503152270,
 -1,
 503324203,
 503216779,
 -1,
 503389702,
 503300754,
 -1,
 503455236,
 503366290,
 -1,
 -57853,
 503419025,
 43024,
 -1,
 503471640,
 43025,
 -57851,
 503419025,
 43028,
 -1,
 503602712,
 43029,
 503782924,
 503330831,
 -1,
 503848458,
 503724047,
 -1,
 -57847,
 503812241,
 43026,
 -1,
 503864856,
 43027,
 -57845,
 503812241,
 43030,
 -1,
 503995928,
 43031,
 504176143,
 503752834,
 -1,
 -57842,
 504148740,
 43040,
 -1,
 504205457,
 43038,
 504372754,
 504143565,
 -1,
 -57839,
 504336529,
 43033,
 -1,
 504389144,
 43034,
 504569365,
 504328331,
 -1,
 -57836,
 504533137,
 43015,
 -1,
 504585752,
 43016,
 504765976,
 504524639,
 -1,
 -57833,
 504729745,
 43022,
 -1,
 504782360,
 43023,
 504962587,
 504713970,
 -1,
 -57830,
 504926353,
 43017,
 -1,
 504978968,
 43018,
 505159198,
 504900836,
 -1,
 -57827,
 505122961,
 43020,
 -1,
 505175576,
 43021,
 505355809,
 505095871,
 -1,
 -57824,
 505319569,
 43035,
 -1,
 505372184,
 43036,
 -57822,
 505335325,
 43011,
 -57821,
 505527647,
 43041,
 -57820,
 505581713,
 43013,
 -57819,
 505646500,
 43032,
 -57818,
 505710320,
 43037,
 -57817,
 505773510,
 43039,
 -57816,
 505831809,
 43009,
 -57815,
 505896472,
 43042,
 -57814,
 505954499,
 43012,
 -1,
 506009908,
 43008,
 506207793,
 503306864,
 -1,
 -57811,
 506187293,
 43045,
 -57810,
 506238583,
 43047,
 -57809,
 506290561,
 43044,
 -57808,
 506347715,
 43046,
 -1,
 506403124,
 43043,
 506601014,
 506176459,
 -1,
 -57805,
 506532952,
 43051,
 -57804,
 506598202,
 43050,
 -57803,
 506663445,
 43049,
 -1,
 506728682,
 43048,
 506986495,
 506575561,
 -1,
 -57800,
 506878582,
 43014,
 -57799,
 506937501,
 43010,
 -1,
 506995086,
 43019,
 507190870,
 503230044,
 -1,
 507256405,
 507124386,
 -1,
 507321940,
 507214475,
 -1,
 507387468,
 507281796,
 -1,
 507452996,
 507349288,
 -1,
 507518530,
 507414824,
 -1,
 -57791,
 507480434,
 2149,
 -1,
 507517236,
 2148,
 -57789,
 507503476,
 2146,
 -1,
 507663169,
 2144,
 507846215,
 507411728,
 -1,
 -57786,
 507802774,
 2153,
 -1,
 507844916,
 2152,
 -57784,
 507825147,
 2147,
 -57783,
 508018356,
 2154,
 -57782,
 508078325,
 2151,
 -57781,
 508129149,
 2145,
 -1,
 508176739,
 2150,
 508370512,
 507362677,
 -1,
 -57778,
 508356325,
 1869,
 -57777,
 508392105,
 1870,
 -1,
 508448162,
 1871,
 508690431,
 508338676,
 -1,
 -57774,
 508581245,
 1838,
 -57773,
 508639916,
 1839,
 -1,
 508701046,
 1837,
 -1,
 507298164,
 983202,
 -1,
 507219023,
 128137,
 509025881,
 507152680,
 983094,
 -57768,
 508965024,
 983093,
 -1,
 509025482,
 128333,
 509280255,
 508986231,
 -1,
 -57765,
 509195906,
 8527,
 -1,
 509248190,
 128325,
 509419143,
 503169682,
 983189,
 509484658,
 509352244,
 -1,
 509550186,
 509454466,
 -1,
 509615719,
 509526764,
 -1,
 509681251,
 509588823,
 -1,
 -57758,
 509659990,
 983180,
 -1,
 509691321,
 983132,
 -57756,
 509658511,
 983044,
 -57755,
 509847007,
 983175,
 -57754,
 509893374,
 983042,
 -1,
 509958064,
 983174,
 510197759,
 509545251,
 -1,
 -57751,
 510111547,
 11243,
 -1,
 510163032,
 11242,
 510336621,
 509526674,
 -1,
 -57748,
 510316649,
 128509,
 -1,
 510356314,
 128649,
 510533232,
 510283256,
 -1,
 -57745,
 510483411,
 9882,
 -1,
 510532645,
 9877,
 -57743,
 510494690,
 128387,
 -1,
 510671852,
 127967,
 510860921,
 509454466,
 -1,
 510926456,
 510794036,
 -1,
 510991991,
 510878860,
 -1,
 -57738,
 510954404,
 9188,
 -1,
 510986392,
 128207,
 -1,
 510975021,
 127827,
 -1,
 510879971,
 983188,
 511319677,
 510840349,
 -1,
 -57733,
 511287081,
 128723,
 -57732,
 511331839,
 129369,
 -1,
 511392665,
 127897,
 511581826,
 511262915,
 -1,
 511647361,
 511516521,
 -1,
 -57728,
 511600625,
 127836,
 -1,
 511640626,
 128642,
 -1,
 511610304,
 11836,
 511909509,
 511545489,
 -1,
 -57724,
 511878859,
 9201,
 -1,
 511914529,
 128480,
 -57722,
 511894017,
 983045,
 -1,
 512079191,
 983169,
 512237225,
 509386445,
 983117,
 512302741,
 512180419,
 -1,
 512368273,
 512237041,
 -1,
 512433807,
 512313470,
 128264,
 512557055,
 512363299,
 -1,
 -57715,
 512476903,
 128266,
 -57714,
 512529712,
 128265,
 -1,
 512568702,
 128263,
 -57712,
 512387135,
 128483,
 -1,
 512692014,
 128586,
 512892564,
 512311491,
 -1,
 -57709,
 512833875,
 128676,
 -1,
 512896904,
 128172,
 -1,
 512867648,
 8375,
 513154716,
 512266385,
 -1,
 513220249,
 513118353,
 -1,
 -57704,
 513181992,
 129348,
 -1,
 513242206,
 129525,
 -57702,
 513201613,
 128051,
 -57701,
 513389749,
 127941,
 -1,
 513444943,
 129533,
 513613475,
 513106305,
 -1,
 513679009,
 513583588,
 -1,
 -57697,
 513653083,
 128026,
 -57696,
 513707624,
 128466,
 -1,
 513748319,
 128467,
 513998847,
 513620547,
 128375,
 -1,
 513870616,
 128376,
 514072232,
 513546548,
 983176,
 514137767,
 514044647,
 -1,
 -57690,
 514091094,
 128150,
 -1,
 514148745,
 10024,
 -1,
 514086290,
 127837,
 -1,
 514029128,
 128166,
 514465478,
 512196741,
 -1,
 514531008,
 514417025,
 -1,
 514596543,
 514489483,
 -1,
 514662076,
 514542916,
 -1,
 514727603,
 514635095,
 -1,
 514793138,
 514688497,
 128522,
 514916351,
 514719810,
 -1,
 -57679,
 514836156,
 129392,
 -1,
 514873738,
 129325,
 -1,
 514773566,
 128526,
 515120824,
 514693004,
 128515,
 515244031,
 515047490,
 -1,
 -57674,
 515164081,
 128518,
 -57673,
 515226918,
 128516,
 -1,
 515257194,
 128517,
 515506175,
 515069992,
 -1,
 -57670,
 515414321,
 128520,
 -57669,
 515457578,
 128525,
 -1,
 515514109,
 128519,
 515768319,
 514600559,
 -1,
 -57666,
 515676044,
 128570,
 -1,
 515726113,
 128571,
 -1,
 514568924,
 128527,
 515972805,
 514465499,
 -1,
 -57662,
 515952020,
 68411,
 -57661,
 516003962,
 128312,
 -57660,
 516041421,
 128313,
 -1,
 516103521,
 128745,
 -1,
 515936969,
 128684,
 516366043,
 514421836,
 -1,
 516431568,
 516309187,
 -1,
 516497102,
 516376587,
 -1,
 516562637,
 516450275,
 -1,
 -57653,
 516538959,
 128164,
 -57652,
 516574527,
 128564,
 -1,
 516627130,
 128716,
 -1,
 516547366,
 128554,
 -57649,
 516478396,
 128373,
 -1,
 516831247,
 128759,
 517021397,
 516383105,
 -1,
 517086932,
 516969972,
 -1,
 -57645,
 517061939,
 128578,
 -1,
 517100150,
 128577,
 -1,
 517025504,
 127829,
 517349082,
 516954420,
 -1,
 517414617,
 517312328,
 -1,
 -57640,
 517386933,
 11100,
 -1,
 517444271,
 11098,
 -1,
 517396991,
 42611,
 -1,
 517315002,
 127920,
 517742313,
 516309187,
 -1,
 517807839,
 517685443,
 -1,
 -57634,
 517749763,
 127793,
 -1,
 517803822,
 128584,
 -57632,
 517792464,
 9913,
 -57631,
 517980924,
 983168,
 -57630,
 518045337,
 9916,
 -57629,
 518107584,
 129324,
 -57628,
 518168621,
 11259,
 -57627,
 518227606,
 9914,
 -57626,
 518290224,
 129331,
 -57625,
 518339593,
 11250,
 -57624,
 518403112,
 129352,
 -1,
 518464694,
 128186,
 518659831,
 517680356,
 -1,
 518725358,
 518629506,
 -1,
 -57620,
 518689639,
 128220,
 -57619,
 518744991,
 128624,
 -1,
 518800382,
 128437,
 518987505,
 518688913,
 -1,
 -57616,
 518960158,
 129410,
 -1,
 519019021,
 128756,
 519184115,
 518938281,
 127979,
 -1,
 519112876,
 127890,
 519315190,
 519117108,
 -1,
 -57611,
 519286274,
 129507,
 -1,
 519338589,
 9878,
 -1,
 519266689,
 983185,
 519577344,
 518621480,
 -1,
 519642876,
 519544309,
 -1,
 -57606,
 519602724,
 9924,
 -57605,
 519645933,
 127938,
 -1,
 519700900,
 127956,
 519905023,
 519575860,
 -1,
 -57602,
 519860729,
 128013,
 -1,
 519923104,
 128012,
 -1,
 519849004,
 129319,
 520167174,
 519559908,
 -1,
 520232708,
 520100148,
 -1,
 -57597,
 520206438,
 128629,
 -1,
 520259880,
 129442,
 -57595,
 520213032,
 8275,
 -1,
 520382035,
 127946,
 520560396,
 520122507,
 -1,
 520625930,
 520511873,
 -1,
 -57591,
 520571006,
 9975,
 -1,
 520618140,
 127935,
 -57589,
 520605948,
 128128,
 -1,
 520758489,
 128761,
 520953616,
 520533335,
 -1,
 -57586,
 520886580,
 983133,
 -57585,
 520950586,
 983159,
 -1,
 521015829,
 983156,
 -1,
 520901768,
 983183,
 521283476,
 361529477,
 -1,
 521347508,
 521224387,
 -1,
 521412620,
 521308456,
 -1,
 521478154,
 521353621,
 -1,
 521543665,
 521454123,
 -1,
 521609092,
 521474013,
 -1,
 521674530,
 521541762,
 -1,
 -57575,
 521607383,
 125069,
 -57574,
 521672782,
 125123,
 -57573,
 521737971,
 124959,
 -57572,
 521803326,
 125036,
 -57571,
 521868664,
 124932,
 -57570,
 521933999,
 124952,
 -57569,
 521999215,
 125097,
 -57568,
 522064459,
 125088,
 -57567,
 522129840,
 124999,
 -1,
 522195025,
 125047,
 522395437,
 521607121,
 -1,
 -57564,
 522328204,
 124993,
 -57563,
 522393584,
 125024,
 -57562,
 522458911,
 125043,
 -57561,
 522524270,
 125056,
 -57560,
 522589659,
 125117,
 -57559,
 522654877,
 124985,
 -57558,
 522720118,
 125039,
 -57557,
 522785415,
 125049,
 -57556,
 522850700,
 125071,
 -1,
 522916022,
 125015,
 523116344,
 522327793,
 -1,
 -57553,
 523049201,
 124980,
 -57552,
 523114474,
 125021,
 -57551,
 523179932,
 125119,
 -57550,
 523245150,
 124933,
 -57549,
 523310436,
 125022,
 -57548,
 523375762,
 125089,
 -57547,
 523441057,
 124986,
 -57546,
 523506292,
 125080,
 -57545,
 523571504,
 125099,
 -1,
 523636751,
 125100,
 523837251,
 523048481,
 -1,
 -57542,
 523770107,
 125002,
 -57541,
 523835477,
 125068,
 -57540,
 523900766,
 125107,
 -57539,
 523966107,
 125074,
 -57538,
 524031357,
 124931,
 -57537,
 524096700,
 125108,
 -57536,
 524161938,
 125009,
 -57535,
 524227182,
 125076,
 -57534,
 524292552,
 124945,
 -1,
 524357732,
 125124,
 524558158,
 523769132,
 -1,
 -57531,
 524490909,
 124951,
 -57530,
 524556359,
 125121,
 -57529,
 524621683,
 125066,
 -57528,
 524686893,
 125095,
 -57527,
 524752328,
 125000,
 -57526,
 524817571,
 124987,
 -57525,
 524882813,
 125041,
 -57524,
 524948026,
 125044,
 -57523,
 525013383,
 125072,
 -1,
 525078648,
 125070,
 525279065,
 524489816,
 -1,
 -57520,
 525211909,
 124946,
 -57519,
 525277213,
 124934,
 -57518,
 525342538,
 125078,
 -57517,
 525407821,
 125046,
 -57516,
 525473258,
 124942,
 -57515,
 525538443,
 125090,
 -57514,
 525603796,
 125048,
 -57513,
 525668928,
 125037,
 -57512,
 525734206,
 125033,
 -1,
 525799457,
 125035,
 525999972,
 525210426,
 -1,
 -57509,
 525932753,
 125029,
 -57508,
 525998139,
 125028,
 -57507,
 526063490,
 125027,
 -57506,
 526128680,
 125020,
 -57505,
 526194015,
 125019,
 -57504,
 526259323,
 125018,
 -57503,
 526324774,
 125013,
 -57502,
 526390011,
 125012,
 -57501,
 526455250,
 125011,
 -1,
 526520370,
 125005,
 526720879,
 525931029,
 -1,
 -57498,
 526653586,
 125004,
 -57497,
 526718987,
 125003,
 -57496,
 526784325,
 124984,
 -57495,
 526849641,
 124983,
 -57494,
 526914947,
 124982,
 -57493,
 526980327,
 124998,
 -57492,
 527045645,
 124997,
 -57491,
 527110880,
 124996,
 -57490,
 527176107,
 124976,
 -1,
 527241346,
 124975,
 527441786,
 526651626,
 -1,
 -57487,
 527374572,
 124974,
 -57486,
 527439836,
 124992,
 -57485,
 527505144,
 124991,
 -57484,
 527570467,
 124990,
 -57483,
 527635922,
 124964,
 -57482,
 527701082,
 124963,
 -57481,
 527766409,
 124962,
 -57480,
 527831579,
 124957,
 -57479,
 527896824,
 124956,
 -1,
 527962085,
 124955,
 528220159,
 527372253,
 -1,
 -57476,
 528095402,
 124950,
 -57475,
 528160814,
 124949,
 -57474,
 528226136,
 124948,
 -57473,
 528291540,
 124938,
 -57472,
 528356832,
 124937,
 -57471,
 528422135,
 124936,
 -57470,
 528487319,
 124930,
 -57469,
 528552518,
 124929,
 -1,
 528617816,
 124928,
 528875519,
 521539818,
 -1,
 528883600,
 528750545,
 -1,
 -57465,
 528816291,
 124954,
 -57464,
 528881716,
 125079,
 -57463,
 528947025,
 125083,
 -57462,
 529012296,
 125034,
 -57461,
 529077718,
 125114,
 -57460,
 529142983,
 125065,
 -57459,
 529208235,
 125058,
 -57458,
 529273573,
 125113,
 -57457,
 529338645,
 124995,
 -1,
 529403891,
 124994,
 529604507,
 528815857,
 -1,
 -57454,
 529537175,
 124935,
 -57453,
 529602533,
 124973,
 -57452,
 529667962,
 125067,
 -57451,
 529733187,
 125032,
 -57450,
 529798536,
 125010,
 -57449,
 529863849,
 125082,
 -57448,
 529929234,
 125116,
 -57447,
 529994362,
 125081,
 -57446,
 530059676,
 125101,
 -1,
 530124907,
 125122,
 530325414,
 529536545,
 -1,
 -57443,
 530258123,
 125031,
 -57442,
 530323451,
 125061,
 -57441,
 530388760,
 125064,
 -57440,
 530454067,
 125063,
 -57439,
 530519491,
 124967,
 -57438,
 530584789,
 125120,
 -57437,
 530649948,
 124965,
 -57436,
 530715349,
 124977,
 -57435,
 530780514,
 125084,
 -1,
 530845740,
 125008,
 531046321,
 530257196,
 -1,
 -57432,
 530979004,
 125054,
 -57431,
 531044392,
 125093,
 -57430,
 531109678,
 125006,
 -57429,
 531175059,
 125052,
 -57428,
 531240297,
 125059,
 -57427,
 531305653,
 124953,
 -57426,
 531370918,
 124988,
 -57425,
 531436174,
 125109,
 -57424,
 531501500,
 125115,
 -1,
 531566559,
 124958,
 531767228,
 530977880,
 -1,
 -57421,
 531699908,
 125111,
 -57420,
 531765237,
 125096,
 -57419,
 531830664,
 124968,
 -57418,
 531895948,
 125051,
 -57417,
 531961246,
 125075,
 -57416,
 532026604,
 125118,
 -57415,
 532091928,
 124944,
 -57414,
 532157027,
 125086,
 -57413,
 532222428,
 125016,
 -1,
 532287527,
 125038,
 532488135,
 531698490,
 -1,
 -57410,
 532420875,
 124947,
 -57409,
 532486103,
 124961,
 -57408,
 532551431,
 124969,
 -57407,
 532616891,
 124979,
 -57406,
 532682094,
 124971,
 -57405,
 532747470,
 125112,
 -57404,
 532812649,
 125023,
 -57403,
 532877905,
 125087,
 -57402,
 532943187,
 124970,
 -1,
 533008411,
 125042,
 533209042,
 532419093,
 -1,
 -57399,
 533141680,
 125103,
 -57398,
 533207040,
 125040,
 -57397,
 533272427,
 125055,
 -57396,
 533337806,
 124939,
 -57395,
 533403056,
 125104,
 -57394,
 533468288,
 125094,
 -57393,
 533533646,
 125102,
 -57392,
 533598849,
 125077,
 -57391,
 533664215,
 125017,
 -1,
 533729368,
 125053,
 533929949,
 533139690,
 -1,
 -57388,
 533862582,
 125106,
 -57387,
 533928042,
 124940,
 -57386,
 533993317,
 125030,
 -57385,
 534058672,
 124978,
 -57384,
 534123958,
 125050,
 -57383,
 534189308,
 124941,
 -57382,
 534254477,
 125007,
 -57381,
 534319703,
 125092,
 -57380,
 534384939,
 125060,
 -1,
 534450236,
 124989,
 534650856,
 533860317,
 -1,
 -57377,
 534583569,
 125014,
 -57376,
 534648866,
 125091,
 -57375,
 534714130,
 125098,
 -57374,
 534779514,
 125057,
 -57373,
 534844818,
 125085,
 -57372,
 534910177,
 125001,
 -57371,
 534975314,
 124960,
 -57370,
 535040703,
 125073,
 -57369,
 535105829,
 125026,
 -1,
 535171071,
 124966,
 535429119,
 534583426,
 -1,
 -57366,
 535303948,
 125025,
 -57365,
 535369397,
 124981,
 -57364,
 535434547,
 124972,
 -57363,
 535500034,
 124943,
 -57362,
 535565187,
 125045,
 -57361,
 535630484,
 125110,
 -57360,
 535695725,
 125105,
 -1,
 535760917,
 125062,
 535961598,
 521485150,
 -1,
 536027125,
 535937682,
 -1,
 -57356,
 536010768,
 125128,
 -1,
 536043473,
 125129,
 536223736,
 535999831,
 -1,
 -57353,
 536178386,
 125132,
 -1,
 536234731,
 125133,
 536420347,
 536169703,
 -1,
 -57350,
 536386331,
 125130,
 -1,
 536440352,
 125131,
 -57348,
 536384687,
 125127,
 -57347,
 536579288,
 125135,
 -1,
 536626445,
 125134,
 536870911,
 535901087,
 -1,
 536879110,
 536789650,
 -1,
 536944645,
 536821955,
 -1,
 537010180,
 536906024,
 -1,
 -57341,
 536982871,
 125137,
 -1,
 537004452,
 125140,
 -1,
 536954694,
 125136,
 -1,
 536895428,
 125139,
 537337865,
 536830215,
 -1,
 -57336,
 537310551,
 125138,
 -1,
 537332132,
 125141,
 -1,
 537298458,
 125142,
 -57333,
 521450966,
 128697,
 -1,
 537565282,
 128334,
 537731246,
 521382018,
 -1,
 537796781,
 537694855,
 -1,
 537862279,
 537737150,
 -1,
 537927764,
 537825223,
 -1,
 537993251,
 537903762,
 -1,
 538058777,
 537975524,
 -1,
 538124311,
 538022033,
 68033,
 538247167,
 538050560,
 -1,
 538255382,
 538140935,
 68051,
 -1,
 538184090,
 68078,
 -1,
 538232413,
 68060,
 538509311,
 538068921,
 68042,
 -1,
 538380698,
 68069,
 538583073,
 538007592,
 -1,
 538648607,
 538553435,
 68034,
 538771455,
 538574848,
 -1,
 538779678,
 538665223,
 68052,
 -1,
 538708378,
 68079,
 -1,
 538756701,
 68061,
 539033599,
 538602620,
 68043,
 -1,
 538904986,
 68070,
 539164671,
 538527306,
 68041,
 -1,
 539036058,
 68068,
 539238450,
 537965911,
 -1,
 539303979,
 539193042,
 68037,
 539369513,
 539230208,
 -1,
 539435048,
 539320583,
 68055,
 -1,
 539363738,
 68082,
 -1,
 539412061,
 68064,
 539688959,
 539348481,
 68046,
 -1,
 539560346,
 68073,
 539820031,
 539249387,
 68038,
 539828272,
 539688960,
 -1,
 539893807,
 539779335,
 68056,
 -1,
 539822490,
 68083,
 -1,
 539870813,
 68065,
 540147711,
 539807233,
 68047,
 -1,
 540019098,
 68074,
 540221507,
 539184359,
 -1,
 540287035,
 540184721,
 -1,
 540352569,
 540267559,
 68035,
 540475391,
 540278784,
 -1,
 540483640,
 540369159,
 68053,
 -1,
 540412314,
 68080,
 -1,
 540460637,
 68062,
 540737535,
 540325055,
 68044,
 -1,
 540608922,
 68071,
 540868607,
 540238209,
 -1,
 540876865,
 540792547,
 68036,
 540999679,
 540803072,
 -1,
 541007936,
 540893447,
 68054,
 -1,
 540936602,
 68081,
 -1,
 540984925,
 68063,
 541261823,
 540824278,
 68045,
 -1,
 541133210,
 68072,
 541335625,
 540183768,
 68040,
 541401160,
 541261824,
 -1,
 541466695,
 541352199,
 68058,
 -1,
 541395354,
 68085,
 -1,
 541443677,
 68067,
 -1,
 541380100,
 68076,
 541728847,
 541279501,
 68039,
 541794382,
 541655040,
 -1,
 541859917,
 541745415,
 68057,
 -1,
 541788570,
 68084,
 -1,
 541836893,
 68066,
 -1,
 541778781,
 68075,
 542179327,
 541693103,
 68032,
 542244863,
 542048256,
 -1,
 542253139,
 542138631,
 68050,
 -1,
 542181786,
 68077,
 -1,
 542230109,
 68059,
 542449781,
 537883724,
 -1,
 542515314,
 542394913,
 -1,
 542580826,
 542491282,
 -1,
 -57256,
 542544017,
 68022,
 -57255,
 542589123,
 68021,
 -1,
 542644532,
 68020,
 542842973,
 542553431,
 -1,
 -57252,
 542785731,
 68017,
 -1,
 542841140,
 68015,
 543039584,
 542804264,
 -1,
 -57249,
 542982339,
 68010,
 -1,
 543037748,
 68009,
 543236195,
 542994571,
 -1,
 -57246,
 543184958,
 68013,
 -1,
 543234356,
 68018,
 543432805,
 543168820,
 68000,
 -1,
 543402729,
 68016,
 -57242,
 543417204,
 68004,
 -57241,
 543546148,
 68005,
 -57240,
 543598837,
 68011,
 -57239,
 543663857,
 68019,
 -57238,
 543727401,
 68007,
 -57237,
 543789201,
 68003,
 -57236,
 543850715,
 68008,
 -57235,
 543913110,
 68012,
 -57234,
 543973761,
 68002,
 -57233,
 544037960,
 68014,
 -57232,
 544096451,
 68001,
 -57231,
 544159902,
 68023,
 -1,
 544220916,
 68006,
 544473087,
 542478874,
 -1,
 -57228,
 544387826,
 68030,
 -1,
 544433753,
 68031,
 544669695,
 542396908,
 -1,
 544678010,
 544588434,
 -1,
 -57224,
 544661694,
 68087,
 -57223,
 544694407,
 68088,
 -1,
 544753317,
 68095,
 544940157,
 544650583,
 -1,
 -57220,
 544894716,
 68091,
 -1,
 544951070,
 68092,
 545136768,
 544904371,
 -1,
 -57217,
 545115447,
 68086,
 -1,
 545151194,
 68029,
 545333379,
 545082599,
 -1,
 -57214,
 545299352,
 68089,
 -1,
 545353381,
 68090,
 545529990,
 545276099,
 -1,
 -57211,
 545487603,
 68028,
 -1,
 545547451,
 68093,
 -1,
 545492209,
 68094,
 545849343,
 537812086,
 -1,
 545857707,
 545749643,
 -1,
 545923215,
 545833618,
 -1,
 545988748,
 545865923,
 67994,
 -1,
 545918571,
 67995,
 546119822,
 545921332,
 67992,
 -1,
 546049643,
 67993,
 -1,
 546082961,
 67996,
 546316436,
 545884456,
 -1,
 546381970,
 546259139,
 67980,
 -1,
 546311787,
 67981,
 546570239,
 546314548,
 67978,
 -1,
 546442859,
 67979,
 546644120,
 546288983,
 -1,
 546709655,
 546576692,
 67987,
 -1,
 546639467,
 67988,
 -1,
 546652355,
 67989,
 546906266,
 546613493,
 67982,
 -1,
 546836075,
 67983,
 547037341,
 546861195,
 -1,
 -57188,
 546986046,
 67985,
 -1,
 547035444,
 67990,
 547233951,
 546973428,
 67974,
 -1,
 547163755,
 67975,
 -57184,
 547218292,
 67972,
 -57183,
 547347236,
 67973,
 -57182,
 547399409,
 67991,
 -57181,
 547462953,
 67976,
 -57180,
 547524753,
 67971,
 -57179,
 547586267,
 67977,
 -57178,
 547648662,
 67984,
 -57177,
 547709313,
 67970,
 -57176,
 547773512,
 67986,
 -57175,
 547832003,
 67969,
 -57174,
 547895454,
 67997,
 -1,
 547952948,
 67968,
 548208639,
 545833586,
 67998,
 -1,
 548081259,
 67999,
 -1,
 537764349,
 129500,
 548348215,
 537671695,
 -1,
 548413724,
 548291640,
 -1,
 548479189,
 548386135,
 -1,
 548544724,
 548438502,
 -1,
 548610229,
 548505896,
 93819,
 -57164,
 548594444,
 93815,
 -1,
 548623090,
 983265,
 548806840,
 548542772,
 93805,
 -57161,
 548784360,
 93796,
 -1,
 548823425,
 93822,
 549003450,
 548791052,
 93823,
 -1,
 548982301,
 93811,
 549134524,
 548966545,
 93821,
 -1,
 549077187,
 93818,
 549265598,
 549089419,
 93804,
 -1,
 549232333,
 93798,
 549396672,
 549214248,
 983264,
 -1,
 549363405,
 93814,
 -57151,
 549381565,
 93797,
 -57150,
 549511681,
 93816,
 -57149,
 549575396,
 93795,
 -57148,
 549639672,
 93794,
 -57147,
 549703197,
 93810,
 -57146,
 549765778,
 93800,
 -57145,
 549827927,
 93793,
 -57144,
 549890178,
 93820,
 -57143,
 549955282,
 93813,
 -57142,
 550018765,
 93799,
 -57141,
 550076549,
 93792,
 -57140,
 550138956,
 93812,
 -57139,
 550203231,
 93806,
 -57138,
 550265217,
 93803,
 -57137,
 550327026,
 93801,
 -57136,
 550391015,
 93802,
 -57135,
 550453443,
 93807,
 -57134,
 550516751,
 93817,
 -57133,
 550579428,
 93809,
 -1,
 550643391,
 93808,
 -1,
 548529386,
 93849,
 550904058,
 548416740,
 -1,
 550969593,
 550838734,
 -1,
 551035098,
 550930728,
 93787,
 -57127,
 551019276,
 93783,
 -1,
 551047922,
 983263,
 551231709,
 550967604,
 93773,
 -57124,
 551209192,
 93764,
 -1,
 551248257,
 93790,
 551428319,
 551215884,
 93791,
 -1,
 551407133,
 93779,
 551559393,
 551391377,
 93789,
 -1,
 551502019,
 93786,
 551690467,
 551514251,
 93772,
 -1,
 551657165,
 93766,
 551821541,
 551639080,
 983262,
 -1,
 551788237,
 93782,
 -57114,
 551806397,
 93765,
 -57113,
 551936513,
 93784,
 -57112,
 552000228,
 93763,
 -57111,
 552064504,
 93762,
 -57110,
 552128029,
 93778,
 -57109,
 552190610,
 93768,
 -57108,
 552252759,
 93761,
 -57107,
 552315010,
 93788,
 -57106,
 552380114,
 93781,
 -57105,
 552443597,
 93767,
 -57104,
 552501381,
 93760,
 -57103,
 552563788,
 93780,
 -57102,
 552628063,
 93774,
 -57101,
 552690049,
 93771,
 -57100,
 552751858,
 93769,
 -57099,
 552815847,
 93770,
 -57098,
 552878275,
 93775,
 -57097,
 552941583,
 93785,
 -57096,
 553004260,
 93777,
 -1,
 553068223,
 93776,
 -1,
 550933509,
 93847,
 553328907,
 550845278,
 -1,
 553394432,
 553304722,
 -1,
 553459966,
 553377808,
 93826,
 -1,
 553386017,
 93845,
 553648127,
 553410513,
 93827,
 -1,
 553517089,
 93846,
 553722115,
 553366871,
 -1,
 -57086,
 553676498,
 93830,
 -1,
 553732843,
 93831,
 553918725,
 553686191,
 93825,
 -1,
 553844769,
 93844,
 554049800,
 553864423,
 -1,
 -57081,
 554015515,
 93828,
 -1,
 554069536,
 93829,
 -57079,
 554034826,
 93824,
 -57078,
 554208472,
 93833,
 -1,
 554255629,
 93832,
 554443034,
 553291719,
 -1,
 554508560,
 554418834,
 -1,
 -57074,
 554490970,
 93836,
 -57073,
 554524049,
 93837,
 -1,
 554583626,
 93834,
 554770707,
 554480983,
 -1,
 -57070,
 554725128,
 93840,
 -1,
 554781484,
 93841,
 554967318,
 554716391,
 -1,
 -57067,
 554933167,
 93838,
 -1,
 554984407,
 93839,
 555163929,
 554909891,
 -1,
 -57064,
 555121389,
 93835,
 -1,
 555181297,
 93842,
 -1,
 555126015,
 93843,
 -57061,
 554390241,
 93848,
 -1,
 555371515,
 93850,
 555614207,
 548364673,
 -1,
 555622710,
 555536679,
 -1,
 555688228,
 555595095,
 -1,
 555753762,
 555642581,
 -1,
 -57055,
 555728443,
 128950,
 -1,
 555787233,
 128971,
 -57053,
 555713024,
 9900,
 -1,
 555884386,
 128938,
 556081449,
 555633895,
 -1,
 556146984,
 556047207,
 -1,
 -57049,
 556114585,
 128967,
 -1,
 556149340,
 128965,
 -1,
 556101265,
 128944,
 556409132,
 556064003,
 -1,
 -57045,
 556383823,
 128911,
 -1,
 556413175,
 9898,
 556605743,
 556385993,
 -1,
 -57042,
 556573337,
 128963,
 -1,
 556608092,
 128961,
 556802354,
 556549395,
 -1,
 -57039,
 556777019,
 128956,
 -1,
 556835809,
 128974,
 556998965,
 556738239,
 -1,
 -57036,
 556962605,
 128901,
 -1,
 557020360,
 9899,
 -1,
 556947330,
 128931,
 -1,
 555567840,
 11852,
 557326753,
 548293104,
 -1,
 557392245,
 557282380,
 -1,
 557457780,
 557337121,
 -1,
 557523265,
 557418792,
 -1,
 557588797,
 557471476,
 43977,
 -1,
 557515845,
 44001,
 557719871,
 557521204,
 43973,
 -1,
 557646917,
 43999,
 -57024,
 557704052,
 43747,
 -1,
 557812082,
 43752,
 557982024,
 557499026,
 -1,
 558047557,
 557957778,
 -1,
 -57020,
 557996094,
 43749,
 -1,
 558045492,
 43748,
 558244167,
 557999520,
 43975,
 -1,
 558171205,
 44000,
 -1,
 558194555,
 43978,
 558440782,
 557922319,
 -1,
 558506316,
 558381071,
 -1,
 -57013,
 558454846,
 43751,
 -1,
 558504244,
 43750,
 -57011,
 558458272,
 43991,
 -1,
 558653307,
 43993,
 558834002,
 558413143,
 -1,
 -57008,
 558806529,
 43754,
 -57007,
 558848062,
 43753,
 -1,
 558899049,
 43969,
 559096150,
 558800589,
 -1,
 559161685,
 559028532,
 43972,
 -1,
 559088709,
 43998,
 -1,
 559110463,
 43984,
 559358298,
 559050891,
 -1,
 559423833,
 559321753,
 43968,
 -1,
 559350853,
 43995,
 -1,
 559374203,
 43976,
 559620444,
 559318705,
 43971,
 -1,
 559547461,
 43997,
 559751518,
 559576411,
 43970,
 -1,
 559678533,
 43996,
 559882593,
 559705951,
 -1,
 -56992,
 559834528,
 43990,
 -1,
 559896895,
 43987,
 560079203,
 559833473,
 43983,
 -1,
 560006213,
 44002,
 560210278,
 560026354,
 -1,
 -56987,
 560173721,
 43986,
 -1,
 560226171,
 43992,
 560406889,
 560148345,
 -1,
 -56984,
 560358816,
 43974,
 -1,
 560404788,
 43746,
 560603500,
 560342719,
 -1,
 -56981,
 560552255,
 43994,
 -1,
 560601396,
 43989,
 -56979,
 560587728,
 43980,
 -56978,
 560782138,
 43979,
 -56977,
 560845182,
 43982,
 -56976,
 560900438,
 43988,
 -56975,
 560959633,
 43745,
 -56974,
 561012984,
 43981,
 -56973,
 561070275,
 43744,
 -1,
 561128828,
 43985,
 -1,
 557437227,
 44012,
 561389962,
 557372920,
 -1,
 561455497,
 561356365,
 -1,
 561521021,
 561387828,
 -1,
 561586555,
 561453364,
 -1,
 -56966,
 561565213,
 43759,
 -1,
 561602945,
 43757,
 -56964,
 561565213,
 43758,
 -1,
 561744338,
 44005,
 561914240,
 561499677,
 -1,
 -56961,
 561892893,
 43756,
 -1,
 561940946,
 44008,
 562110851,
 561865089,
 -1,
 -56958,
 562072018,
 44004,
 -1,
 562127233,
 43755,
 -56956,
 562095162,
 44006,
 -56955,
 562288973,
 43765,
 -56954,
 562347442,
 44007,
 -56953,
 562402474,
 44003,
 -56952,
 562466823,
 44010,
 -1,
 562507806,
 44009,
 -1,
 561408982,
 43766,
 562766232,
 561331038,
 -1,
 562831758,
 562741906,
 -1,
 -56947,
 562814992,
 44018,
 -1,
 562847697,
 44019,
 563028369,
 562804055,
 -1,
 -56944,
 562982610,
 44022,
 -1,
 563038955,
 44023,
 563224980,
 562973927,
 -1,
 -56941,
 563190555,
 44020,
 -1,
 563244576,
 44021,
 -56939,
 563209866,
 44016,
 -56938,
 563385519,
 44017,
 -56937,
 563449048,
 44025,
 -1,
 563496205,
 44024,
 563683740,
 562698548,
 -1,
 -56934,
 563652145,
 44013,
 -56933,
 563711352,
 43762,
 -1,
 563763709,
 43761,
 563945887,
 563621911,
 -1,
 -56930,
 563889404,
 44011,
 -1,
 563945400,
 43760,
 -56928,
 563929457,
 43764,
 -1,
 564118070,
 43763,
 564273584,
 557304335,
 -1,
 564339119,
 564224695,
 -1,
 564404649,
 564314770,
 -1,
 564470183,
 564388019,
 -1,
 -56922,
 564436278,
 9173,
 -1,
 564490294,
 9174,
 -56920,
 564441688,
 9175,
 -1,
 564611595,
 9176,
 564797868,
 564362803,
 -1,
 -56917,
 564776427,
 9172,
 -1,
 564836845,
 9170,
 -56915,
 564771339,
 9171,
 -56914,
 564961682,
 9177,
 -1,
 564997079,
 9169,
 -1,
 564301969,
 128647,
 -56911,
 564248248,
 983172,
 -56910,
 565217008,
 128221,
 -56909,
 565280241,
 127816,
 -1,
 565322937,
 127830,
 565519350,
 521279796,
 -1,
 565584426,
 565479720,
 128104,
 565649916,
 565535444,
 -1,
 565715432,
 565607051,
 -1,
 565780926,
 565687639,
 -1,
 565846460,
 565713204,
 -1,
 -56901,
 565806180,
 68312,
 -1,
 565852858,
 68317,
 -56899,
 565819829,
 68323,
 -1,
 565992773,
 68322,
 566174146,
 565756562,
 -1,
 -56896,
 566122840,
 68309,
 -56895,
 566184444,
 68302,
 -1,
 566240873,
 68324,
 566436294,
 566106420,
 -1,
 -56892,
 566420624,
 68313,
 -56891,
 566458968,
 68288,
 -1,
 566503090,
 68314,
 566698441,
 566420925,
 -1,
 -56888,
 566647463,
 68298,
 -1,
 566699698,
 68297,
 566895052,
 566682113,
 -1,
 -56885,
 566859730,
 68319,
 -1,
 566895042,
 68305,
 567091663,
 566863570,
 -1,
 -56882,
 567056338,
 68318,
 -1,
 567107255,
 68320,
 567288274,
 567046283,
 -1,
 -56879,
 567237156,
 68306,
 -1,
 567288258,
 68304,
 567484885,
 567242591,
 -1,
 -56876,
 567433895,
 68300,
 -1,
 567486130,
 68299,
 567681495,
 567433909,
 68294,
 -1,
 567657881,
 68301,
 567812570,
 567628530,
 -1,
 -56871,
 567764509,
 68291,
 -1,
 567827775,
 68292,
 568009181,
 567752719,
 -1,
 -56868,
 567957848,
 68308,
 -1,
 568008332,
 68293,
 568205792,
 567944895,
 -1,
 -56865,
 568155140,
 68290,
 -1,
 568216060,
 68289,
 -56863,
 568190268,
 68303,
 -56862,
 568384522,
 68295,
 -56861,
 568438083,
 68321,
 -56860,
 568500436,
 68315,
 -56859,
 568561667,
 68311,
 -56858,
 568624253,
 68310,
 -56857,
 568685971,
 68307,
 -1,
 568741282,
 68316,
 568926705,
 565683782,
 -1,
 568992237,
 568867853,
 -1,
 569057772,
 568967826,
 68340,
 -1,
 568987194,
 68339,
 -1,
 569036653,
 68338,
 -56850,
 568970595,
 68341,
 -56849,
 569229193,
 68336,
 -56848,
 569277545,
 68342,
 -1,
 569331698,
 68337,
 569516536,
 568889287,
 -1,
 569582069,
 569492114,
 -1,
 -56844,
 569564290,
 68334,
 -1,
 569591370,
 68333,
 569778679,
 569545903,
 68331,
 -1,
 569705304,
 68335,
 -1,
 569724798,
 68332,
 569975291,
 569449030,
 -1,
 -56838,
 569911470,
 68326,
 -1,
 569973360,
 68325,
 -1,
 569948920,
 68296,
 570237469,
 565590234,
 -1,
 570303001,
 570194571,
 -1,
 570368530,
 570235188,
 -1,
 570434050,
 570340695,
 2126,
 -56831,
 570418621,
 2129,
 -1,
 570447912,
 2132,
 570630660,
 570409618,
 2133,
 -1,
 570606226,
 2120,
 570761734,
 570585227,
 2122,
 -1,
 570734081,
 2121,
 -56825,
 570746301,
 2118,
 -56824,
 570861698,
 2131,
 -56823,
 570926802,
 2130,
 -56822,
 570990285,
 2128,
 -56821,
 571050280,
 2125,
 -56820,
 571113605,
 2124,
 -56819,
 571176012,
 2123,
 -56818,
 571237997,
 2136,
 -56817,
 571299880,
 2116,
 -56816,
 571364082,
 2114,
 -56815,
 571422735,
 2115,
 -1,
 571483839,
 2113,
 571679253,
 570319233,
 -1,
 -56812,
 571654802,
 2119,
 -1,
 571705640,
 2127,
 -56810,
 571659595,
 2117,
 -56809,
 571830548,
 2135,
 -56808,
 571889977,
 2112,
 -1,
 571949188,
 2134,
 -56806,
 570284455,
 2138,
 -56805,
 572106298,
 2142,
 -56804,
 572151005,
 2139,
 -1,
 572202106,
 2137,
 572400166,
 570163200,
 -1,
 572465697,
 572382816,
 -1,
 -56800,
 572443795,
 128115,
 -1,
 572479397,
 128114,
 572662308,
 572417648,
 -1,
 -56797,
 572640560,
 129333,
 -1,
 572664973,
 128372,
 -56795,
 572602642,
 128378,
 -1,
 572792944,
 128107,
 -56793,
 572376265,
 128368,
 -56792,
 572962255,
 128094,
 -56791,
 573003458,
 129389,
 -1,
 573056196,
 8380,
 573252265,
 565532712,
 -1,
 573317746,
 573206607,
 -1,
 573383226,
 573289815,
 -1,
 573448754,
 573337314,
 -1,
 573514289,
 573385956,
 -1,
 -56784,
 573467668,
 127006,
 -1,
 573528651,
 126988,
 -1,
 573450107,
 126997,
 573776439,
 573393665,
 -1,
 573841974,
 573713636,
 -1,
 -56779,
 573795348,
 127007,
 -1,
 573856331,
 126989,
 -1,
 573777787,
 126998,
 -56776,
 573755764,
 127015,
 -56775,
 574072232,
 127014,
 -1,
 574135328,
 126977,
 574300741,
 573358738,
 -1,
 574366272,
 574283948,
 -1,
 574431807,
 574303460,
 -1,
 -56770,
 574385172,
 127002,
 -1,
 574446155,
 126984,
 -1,
 574367611,
 126993,
 574750719,
 574316646,
 -1,
 574759492,
 574631140,
 -1,
 -56765,
 574712852,
 127003,
 -1,
 574773835,
 126985,
 -1,
 574695291,
 126994,
 575021648,
 574246119,
 -1,
 575087179,
 574987103,
 -1,
 575152714,
 575024356,
 -1,
 -56759,
 575106068,
 127004,
 -1,
 575167051,
 126986,
 -1,
 575088507,
 126995,
 575471615,
 575041133,
 -1,
 575480399,
 575352036,
 -1,
 -56754,
 575433748,
 127005,
 -1,
 575494731,
 126987,
 -1,
 575416187,
 126996,
 575742551,
 574984337,
 -1,
 575808086,
 575703811,
 -1,
 575873621,
 575745252,
 -1,
 -56748,
 575826964,
 127001,
 -1,
 575887947,
 126983,
 -1,
 575809403,
 126992,
 -1,
 575777523,
 127011,
 576201310,
 575703336,
 -1,
 576266845,
 576153530,
 -1,
 576332380,
 576204004,
 -1,
 -56741,
 576285716,
 127009,
 -1,
 576346699,
 126991,
 -1,
 576268155,
 127000,
 -1,
 576231761,
 126979,
 576660069,
 576143555,
 -1,
 576725604,
 576611506,
 -1,
 576791139,
 576662756,
 -1,
 -56734,
 576744468,
 127008,
 -1,
 576805451,
 126990,
 -1,
 576726907,
 126999,
 -1,
 576660625,
 126976,
 577118825,
 576641764,
 -1,
 -56729,
 577071666,
 127017,
 -56728,
 577134009,
 126982,
 -1,
 577194436,
 126978,
 577380972,
 577054452,
 -1,
 -56725,
 577340289,
 127012,
 -1,
 577384990,
 127019,
 -56723,
 577350680,
 126980,
 -56722,
 577545048,
 127010,
 -56721,
 577597508,
 127018,
 -56720,
 577656718,
 126981,
 -56719,
 577712302,
 127013,
 -1,
 577775137,
 127016,
 578027519,
 573251040,
 -1,
 578036389,
 577926220,
 -1,
 578101924,
 577980961,
 -1,
 578167419,
 578077330,
 -1,
 578232953,
 578142866,
 -1,
 -56712,
 578181182,
 69983,
 -1,
 578230580,
 69982,
 -56710,
 578181182,
 69988,
 -1,
 578361652,
 69987,
 578560641,
 578107407,
 -1,
 578626175,
 578500623,
 -1,
 -56706,
 578574398,
 69985,
 -1,
 578623796,
 69984,
 -56704,
 578574398,
 69990,
 -1,
 578754868,
 69989,
 578953861,
 578521384,
 -1,
 -56701,
 578937716,
 69981,
 -56700,
 578980210,
 69986,
 -1,
 579017012,
 69991,
 579216008,
 578922626,
 -1,
 -56697,
 579184885,
 70002,
 -1,
 579213620,
 69997,
 579412619,
 579182285,
 -1,
 -56694,
 579360830,
 69993,
 -1,
 579410228,
 69992,
 579609230,
 579367051,
 -1,
 -56691,
 579557438,
 69974,
 -1,
 579606836,
 69973,
 579805841,
 579563359,
 -1,
 -56688,
 579754046,
 69980,
 -1,
 579803444,
 69979,
 580002452,
 579752690,
 -1,
 -56685,
 579950654,
 69976,
 -1,
 580000052,
 69975,
 580199063,
 579939556,
 -1,
 -56682,
 580147262,
 69978,
 -1,
 580196660,
 69977,
 580395674,
 580134591,
 -1,
 -56679,
 580343870,
 69995,
 -1,
 580393268,
 69994,
 -56677,
 580376078,
 69999,
 -56676,
 580570653,
 69970,
 -56675,
 580630017,
 70000,
 -56674,
 580685969,
 69972,
 -56673,
 580747483,
 69996,
 -56672,
 580809878,
 69998,
 -56671,
 580870529,
 69969,
 -56670,
 580933694,
 70001,
 -56669,
 580993219,
 69971,
 -1,
 581048628,
 69968,
 -1,
 578053236,
 70006,
 581313192,
 578008407,
 -1,
 -56665,
 581264727,
 70003,
 -1,
 581321471,
 70005,
 -1,
 581245529,
 70004,
 581575436,
 573224644,
 -1,
 581640935,
 581532299,
 -1,
 581706418,
 581616274,
 -1,
 581771951,
 581681810,
 -1,
 -56658,
 581720126,
 72983,
 -1,
 581769524,
 72982,
 -56656,
 581740789,
 73008,
 -56655,
 581916734,
 72988,
 -1,
 581966132,
 72987,
 582165175,
 581667112,
 -1,
 -56652,
 582148980,
 72981,
 -56651,
 582191474,
 72986,
 -56650,
 582243137,
 72976,
 -1,
 582293812,
 72991,
 582492861,
 582105103,
 -1,
 582558395,
 582432783,
 -1,
 -56646,
 582506558,
 72985,
 -1,
 582555956,
 72984,
 -56644,
 582506558,
 72990,
 -1,
 582687028,
 72989,
 582886081,
 582424884,
 72960,
 -56641,
 582864413,
 72971,
 -56640,
 582902145,
 72968,
 -1,
 582949172,
 72961,
 583148229,
 582858071,
 -1,
 -56637,
 583120385,
 73002,
 -56636,
 583161918,
 73001,
 -1,
 583211316,
 73003,
 583410377,
 583102603,
 -1,
 -56633,
 583384756,
 73006,
 -56632,
 583424062,
 72973,
 -1,
 583473460,
 72972,
 583672525,
 583364447,
 -1,
 -56629,
 583635041,
 73007,
 -56628,
 583686206,
 72980,
 -1,
 583735604,
 72979,
 583934671,
 583650845,
 72964,
 -1,
 583912989,
 72965,
 584065746,
 583900877,
 -1,
 -56623,
 584013886,
 72993,
 -1,
 584063284,
 72992,
 584262357,
 584021068,
 -1,
 -56620,
 584217750,
 73005,
 -1,
 584259892,
 72999,
 584458967,
 584212865,
 72962,
 -1,
 584409473,
 72963,
 584590042,
 584405746,
 -1,
 -56615,
 584538174,
 72975,
 -1,
 584587572,
 72974,
 584786653,
 584527076,
 -1,
 -56612,
 584734782,
 72978,
 -1,
 584784180,
 72977,
 584983264,
 584722111,
 -1,
 -56609,
 584931390,
 72995,
 -1,
 584980788,
 72994,
 -56607,
 584967028,
 72997,
 -56606,
 585160206,
 73000,
 -56605,
 585214197,
 72998,
 -56604,
 585273489,
 72969,
 -56603,
 585335003,
 72996,
 -56602,
 585390142,
 73004,
 -1,
 585449667,
 72966,
 585638645,
 581621240,
 -1,
 585704180,
 585604685,
 -1,
 585769709,
 585636148,
 -1,
 -56597,
 585747997,
 73023,
 -56596,
 585785729,
 73020,
 -1,
 585832756,
 73009,
 586031855,
 585747997,
 73012,
 -1,
 586010141,
 73013,
 586162929,
 585982337,
 73010,
 -1,
 586113409,
 73011,
 -56590,
 586144157,
 73014,
 -56589,
 586256529,
 73021,
 -1,
 586301635,
 73018,
 -1,
 585657302,
 73029,
 586556163,
 585579358,
 -1,
 586621689,
 586531474,
 -1,
 -56584,
 586604560,
 73042,
 -1,
 586637265,
 73043,
 586818300,
 586593623,
 -1,
 -56581,
 586772178,
 73046,
 -1,
 586828523,
 73047,
 587014911,
 586763495,
 -1,
 -56578,
 586980123,
 73044,
 -1,
 587034144,
 73045,
 -56576,
 586999434,
 73040,
 -56575,
 587175087,
 73041,
 -56574,
 587238616,
 73049,
 -1,
 587285773,
 73048,
 587473673,
 586529481,
 -1,
 -56571,
 587454797,
 73025,
 -56570,
 587501501,
 73026,
 -56569,
 587552978,
 73028,
 -56568,
 587607442,
 73027,
 -1,
 587669902,
 73024,
 587923455,
 587442306,
 -1,
 -56565,
 587810862,
 73030,
 -1,
 587864526,
 73031,
 588063595,
 581544066,
 -1,
 588129129,
 588001339,
 -1,
 588194617,
 588100951,
 -1,
 588260150,
 588173093,
 -1,
 588325654,
 588235410,
 -1,
 588391188,
 588297559,
 -1,
 -56557,
 588339262,
 72867,
 -1,
 588388660,
 72866,
 -56555,
 588339262,
 72859,
 -1,
 588519732,
 72858,
 588718874,
 588286248,
 -1,
 -56552,
 588702580,
 72857,
 -56551,
 588731201,
 72853,
 -1,
 588781876,
 72861,
 588981021,
 588703165,
 -1,
 -56548,
 588929086,
 72870,
 -1,
 588978484,
 72871,
 589177632,
 588952919,
 -1,
 -56545,
 589125694,
 72876,
 -1,
 589175092,
 72877,
 589374243,
 589143757,
 -1,
 -56542,
 589322302,
 72863,
 -1,
 589371700,
 72862,
 589570854,
 589328523,
 -1,
 -56539,
 589518910,
 72851,
 -1,
 589568308,
 72850,
 589767465,
 589510671,
 -1,
 -56536,
 589751757,
 72868,
 -1,
 589764916,
 72860,
 589964076,
 589704420,
 -1,
 -56533,
 589912126,
 72855,
 -1,
 589961524,
 72854,
 -56531,
 589947764,
 72873,
 -56530,
 590142244,
 72869,
 -56529,
 590194933,
 72874,
 -56528,
 590250203,
 72865,
 -56527,
 590312598,
 72875,
 -56526,
 590376829,
 72856,
 -56525,
 590436414,
 72878,
 -56524,
 590500673,
 72852,
 -56523,
 590554868,
 72864,
 -1,
 590616884,
 72879,
 590872575,
 588211512,
 -1,
 -56520,
 590753208,
 72886,
 -1,
 590815630,
 72885,
 591012705,
 588151435,
 -1,
 591078208,
 590987922,
 -1,
 591143742,
 591050071,
 -1,
 -56515,
 591091774,
 72835,
 -1,
 591141172,
 72834,
 -56513,
 591091774,
 72827,
 -1,
 591272244,
 72826,
 591471428,
 591038760,
 -1,
 -56510,
 591455092,
 72825,
 -56509,
 591483713,
 72821,
 -1,
 591534388,
 72829,
 591733575,
 591455677,
 -1,
 -56506,
 591681598,
 72838,
 -1,
 591730996,
 72839,
 591930186,
 591705431,
 -1,
 -56503,
 591878206,
 72844,
 -1,
 591927604,
 72845,
 592126797,
 591896269,
 -1,
 -56500,
 592074814,
 72831,
 -1,
 592124212,
 72830,
 592323408,
 592081035,
 -1,
 -56497,
 592271422,
 72819,
 -1,
 592320820,
 72818,
 592520019,
 592263183,
 -1,
 -56494,
 592504269,
 72836,
 -1,
 592517428,
 72828,
 592716630,
 592456932,
 -1,
 -56491,
 592664638,
 72823,
 -1,
 592714036,
 72822,
 -56489,
 592700276,
 72841,
 -56488,
 592894756,
 72837,
 -56487,
 592947445,
 72842,
 -56486,
 593002715,
 72833,
 -56485,
 593065110,
 72843,
 -56484,
 593129341,
 72824,
 -56483,
 593188926,
 72846,
 -56482,
 593253185,
 72820,
 -56481,
 593307380,
 72832,
 -56480,
 593369396,
 72847,
 -1,
 593432174,
 72840,
 593634151,
 590994032,
 -1,
 -56477,
 593612317,
 72882,
 -56476,
 593662097,
 72884,
 -56475,
 593715585,
 72881,
 -56474,
 593772739,
 72883,
 -1,
 593828332,
 72880,
 -56472,
 593593012,
 72817,
 -1,
 593976011,
 72816,
 -56470,
 588105565,
 129355,
 -1,
 594128483,
 9901,
 594289573,
 588018764,
 -1,
 594355104,
 594224788,
 -1,
 594420604,
 594311819,
 -1,
 594486136,
 594358367,
 -1,
 594551666,
 594441292,
 3453,
 594673663,
 594506828,
 3454,
 -1,
 594572364,
 3414,
 594748276,
 594512168,
 3451,
 -1,
 594708776,
 3450,
 -56459,
 594731788,
 3413,
 -56458,
 594850852,
 3452,
 -56457,
 594903173,
 3412,
 -1,
 594964619,
 3455,
 -56455,
 594463805,
 3386,
 -56454,
 595103135,
 3369,
 -56453,
 595147995,
 3406,
 -1,
 595206743,
 3423,
 595403662,
 594366956,
 -1,
 595469193,
 595367091,
 -1,
 595534721,
 595444370,
 -1,
 -56448,
 595516537,
 3419,
 -1,
 595543946,
 3420,
 595731332,
 595479783,
 -1,
 -56445,
 595695974,
 3417,
 -1,
 595747806,
 3422,
 -56443,
 595704749,
 3446,
 -56442,
 595896234,
 3443,
 -56441,
 595957096,
 3416,
 -56440,
 596007130,
 3444,
 -1,
 596067662,
 3447,
 596312063,
 595445385,
 -1,
 -56437,
 596233551,
 3421,
 -56436,
 596294583,
 3448,
 -56435,
 596355049,
 3445,
 -1,
 596395349,
 3418,
 596583318,
 595376841,
 -1,
 596648851,
 596520164,
 -1,
 -56431,
 596612043,
 3328,
 -56430,
 596667456,
 3388,
 -1,
 596713640,
 3329,
 -56428,
 596629466,
 3387,
 -56427,
 596877346,
 3407,
 -1,
 596911659,
 3389,
 597107610,
 596564618,
 -1,
 597173145,
 597062732,
 3426,
 -1,
 597128268,
 3427,
 -1,
 597144612,
 3396,
 597369759,
 597069767,
 -1,
 597435294,
 597333171,
 -1,
 -56419,
 597411421,
 3442,
 -1,
 597451015,
 3441,
 -1,
 597411043,
 3440,
 -1,
 597309769,
 3449,
 597819391,
 594297029,
 -1,
 597828516,
 597745486,
 -1,
 -56413,
 597801668,
 9894,
 -1,
 597827649,
 9895,
 -1,
 597762078,
 9893,
 598090690,
 594243968,
 -1,
 598156218,
 598047371,
 -1,
 598221739,
 598116648,
 -1,
 -56407,
 598205300,
 73451,
 -56406,
 598233921,
 73442,
 -1,
 598284596,
 73448,
 -56404,
 598205300,
 73452,
 -56403,
 598464014,
 73455,
 -56402,
 598524696,
 73446,
 -56401,
 598586881,
 73456,
 -56400,
 598649077,
 73453,
 -56399,
 598712105,
 73443,
 -56398,
 598769883,
 73445,
 -56397,
 598832278,
 73454,
 -56396,
 598896861,
 73440,
 -56395,
 598962045,
 73450,
 -56394,
 599020353,
 73441,
 -56393,
 599079070,
 73447,
 -56392,
 599141659,
 73449,
 -56391,
 599205620,
 73444,
 -1,
 599267636,
 73457,
 599466943,
 598137456,
 -1,
 -56388,
 599445021,
 73460,
 -56387,
 599494801,
 73462,
 -56386,
 599548289,
 73459,
 -1,
 599605443,
 73461,
 -56384,
 599433396,
 73463,
 -56383,
 599738080,
 73464,
 -1,
 599793893,
 73458,
 599991262,
 598074307,
 -1,
 600056779,
 599966354,
 -1,
 600122311,
 600038116,
 -1,
 -56378,
 600084625,
 119522,
 -1,
 600131072,
 119532,
 600318922,
 600070184,
 -1,
 -56375,
 600288347,
 119523,
 -1,
 600337525,
 119533,
 -1,
 600262218,
 119530,
 600581072,
 600028503,
 -1,
 600646606,
 600534738,
 119526,
 -1,
 600622262,
 119536,
 600834047,
 600591083,
 119527,
 -1,
 600753334,
 119537,
 600908758,
 600526055,
 -1,
 600974291,
 600873755,
 119524,
 -1,
 600949942,
 119534,
 601161727,
 600924545,
 -1,
 -56363,
 601085667,
 119525,
 -1,
 601117376,
 119535,
 601301978,
 600850627,
 -1,
 601367513,
 601253004,
 119528,
 -1,
 601310206,
 119538,
 -1,
 601324269,
 119531,
 601564124,
 601263320,
 119529,
 -1,
 601539766,
 119539,
 -56355,
 601548426,
 119520,
 -1,
 601658543,
 119521,
 601826287,
 599967217,
 -1,
 601891812,
 601796188,
 -1,
 601957347,
 601839031,
 -1,
 -56350,
 601939408,
 10221,
 -1,
 601968600,
 10223,
 -1,
 601930523,
 10187,
 602219495,
 601847853,
 -1,
 -56346,
 602201552,
 10220,
 -1,
 602230744,
 10222,
 602416106,
 602172813,
 -1,
 -56343,
 602369887,
 120485,
 -1,
 602431873,
 120484,
 602612717,
 602352401,
 -1,
 -56340,
 602586221,
 120779,
 -1,
 602615292,
 120778,
 -56338,
 602584850,
 120001,
 -1,
 602754410,
 10189,
 602940402,
 601792205,
 -1,
 -56335,
 602896212,
 127809,
 -1,
 602933600,
 9967,
 603137013,
 602886898,
 -1,
 -56332,
 603098025,
 129522,
 -1,
 603144387,
 129497,
 -1,
 603120293,
 128470,
 603399545,
 565481617,
 -1,
 603465013,
 603338767,
 -1,
 603530548,
 603414913,
 -1,
 603595977,
 603475546,
 -1,
 603661512,
 603552395,
 -1,
 603726936,
 603632983,
 -1,
 603792466,
 603685307,
 -1,
 603857931,
 603767442,
 7511,
 603923464,
 603837594,
 -1,
 603988994,
 603855156,
 7492,
 -56319,
 603946914,
 7579,
 -1,
 603996355,
 7494,
 604185604,
 603947141,
 7514,
 -1,
 604114236,
 7597,
 -56315,
 604165624,
 7610,
 -56314,
 604280666,
 7500,
 -56313,
 604332417,
 7502,
 -1,
 604395560,
 7587,
 -56311,
 603887365,
 7508,
 -56310,
 604527615,
 7615,
 -1,
 604573061,
 7605,
 604775444,
 603794660,
 7580,
 604840978,
 604709318,
 -1,
 604906511,
 604791169,
 7590,
 -1,
 604835323,
 7591,
 -56304,
 604884509,
 7608,
 -56303,
 604997928,
 7600,
 -1,
 605058124,
 7595,
 -56301,
 604789836,
 7521,
 -1,
 605162400,
 7581,
 605365275,
 604730444,
 -1,
 605430810,
 605293347,
 -1,
 -56297,
 605400446,
 7593,
 -56296,
 605462410,
 7594,
 -56295,
 605521330,
 43870,
 -1,
 605580021,
 43869,
 -1,
 605381712,
 43001,
 605824032,
 605307075,
 7497,
 -56291,
 605808327,
 7614,
 -56290,
 605865369,
 7582,
 -56289,
 605927519,
 7604,
 -1,
 605981692,
 7505,
 606151717,
 605802013,
 7512,
 606217252,
 606076928,
 -1,
 -56285,
 606199475,
 43871,
 -1,
 606218136,
 7606,
 -1,
 606184945,
 7607,
 606479403,
 606123351,
 -1,
 606544937,
 606416100,
 -1,
 -56280,
 606515778,
 7586,
 -1,
 606560600,
 7498,
 -56278,
 606495585,
 7513,
 -1,
 606669973,
 7603,
 606872623,
 606414527,
 7495,
 -56275,
 606837334,
 7509,
 -56274,
 606882280,
 7517,
 -1,
 606937932,
 7601,
 607134771,
 606856637,
 7611,
 607256575,
 607062819,
 -1,
 -56270,
 607169918,
 7612,
 -1,
 607205253,
 7613,
 607396919,
 607096977,
 7506,
 607518719,
 607363378,
 -1,
 -56266,
 607424657,
 7507,
 -1,
 607469763,
 7499,
 607659067,
 607343346,
 7501,
 607780863,
 607628438,
 -1,
 -56262,
 607691295,
 7520,
 -1,
 607736773,
 7518,
 607921214,
 607598607,
 7496,
 -56259,
 607885885,
 7585,
 -1,
 607929851,
 7519,
 608117825,
 607852852,
 7491,
 -56256,
 608075682,
 7493,
 -1,
 608134765,
 7516,
 608314435,
 608097784,
 7515,
 -1,
 608242837,
 7609,
 608445509,
 608280269,
 7510,
 -1,
 608394316,
 7602,
 608576584,
 608405828,
 -1,
 -56249,
 608546174,
 7599,
 -1,
 608598154,
 7598,
 608773194,
 608534661,
 7504,
 -1,
 608701589,
 7596,
 608904269,
 608723329,
 -1,
 -56244,
 608868837,
 7589,
 -1,
 608898555,
 7588,
 -56242,
 608873951,
 7583,
 -56241,
 609054859,
 7503,
 -56240,
 609120105,
 7592,
 -56239,
 609180604,
 43868,
 -1,
 609242343,
 7584,
 609428565,
 603769473,
 -1,
 -56236,
 609386290,
 42785,
 -1,
 609443061,
 42784,
 609681407,
 609376296,
 -1,
 -56233,
 609589569,
 42890,
 -1,
 609633743,
 765,
 609821828,
 603663588,
 -1,
 609887348,
 609755590,
 -1,
 609952862,
 609855618,
 7487,
 610074623,
 609897321,
 -1,
 -56227,
 609978664,
 7483,
 -1,
 610025667,
 7474,
 610215008,
 609915025,
 7484,
 -1,
 610192925,
 7485,
 610346082,
 610162728,
 7476,
 -1,
 610274811,
 43000,
 610477156,
 610281151,
 7470,
 -1,
 610411332,
 7471,
 610608230,
 610408756,
 7468,
 -1,
 610549955,
 7469,
 -56217,
 610589412,
 7490,
 -56216,
 610719224,
 11389,
 -56215,
 610782749,
 7489,
 -56214,
 610845330,
 7488,
 -56213,
 610901709,
 7486,
 -56212,
 610961704,
 7482,
 -56211,
 611025029,
 7481,
 -56210,
 611087436,
 7480,
 -56209,
 611152011,
 7479,
 -56208,
 611217247,
 7478,
 -56207,
 611279233,
 7477,
 -56206,
 611341042,
 7475,
 -56205,
 611401923,
 7473,
 -1,
 611465231,
 7472,
 611656831,
 609836361,
 -1,
 611722362,
 611608176,
 -1,
 -56201,
 611694862,
 42754,
 -56200,
 611759299,
 42758,
 -56199,
 611821384,
 42756,
 -1,
 611885710,
 42752,
 612106239,
 611655872,
 -1,
 -56196,
 612022542,
 42755,
 -56195,
 612086979,
 42759,
 -56194,
 612149064,
 42757,
 -1,
 612213390,
 42753,
 612377731,
 611640740,
 -1,
 -56191,
 612351330,
 42653,
 -56190,
 612391518,
 42652,
 -1,
 612451914,
 7544,
 -1,
 612340602,
 42889,
 612705431,
 609779396,
 -1,
 612770966,
 612630528,
 -1,
 612836490,
 612726824,
 -1,
 612902025,
 612761823,
 767,
 -1,
 612850368,
 753,
 -1,
 612831144,
 42773,
 613098639,
 612776973,
 -1,
 613164174,
 613075971,
 -1,
 -56179,
 613140826,
 42763,
 -1,
 613185847,
 42768,
 -1,
 613146558,
 751,
 613426322,
 613068380,
 -1,
 -56175,
 613387260,
 755,
 -1,
 613438908,
 754,
 -56173,
 613405336,
 752,
 -56172,
 613599196,
 759,
 -56171,
 613640923,
 42783,
 -1,
 613691852,
 42888,
 -1,
 612714655,
 42778,
 613950632,
 612647107,
 -1,
 614016165,
 613933816,
 -1,
 614081695,
 613973704,
 -1,
 614147229,
 614022413,
 -1,
 -56164,
 614123866,
 42764,
 -1,
 614168887,
 42769,
 -56162,
 614103351,
 42774,
 -1,
 614288542,
 983993,
 614531071,
 614030525,
 -1,
 614540451,
 614415629,
 -1,
 -56158,
 614517082,
 42760,
 -1,
 614562103,
 42765,
 -56156,
 614496567,
 42770,
 -1,
 614681786,
 983992,
 614924287,
 613976652,
 -1,
 -56153,
 614825778,
 764,
 -1,
 614882549,
 762,
 615064755,
 613909784,
 -1,
 615130286,
 615005182,
 -1,
 615195821,
 615071087,
 -1,
 -56148,
 615143241,
 757,
 -1,
 615193436,
 758,
 -1,
 615143241,
 756,
 615514111,
 615055360,
 -1,
 615523506,
 615398669,
 -1,
 -56143,
 615500122,
 42762,
 -1,
 615545143,
 42767,
 -1,
 615479607,
 42772,
 615785657,
 615033196,
 -1,
 -56139,
 615764623,
 42779,
 -56138,
 615803611,
 42782,
 -56137,
 615861200,
 42781,
 -56136,
 615923395,
 42780,
 -1,
 615986037,
 760,
 616178878,
 615734461,
 -1,
 616244413,
 616119565,
 -1,
 -56132,
 616221018,
 42761,
 -1,
 616266039,
 42766,
 -1,
 616200503,
 42771,
 616506562,
 616119378,
 -1,
 -56128,
 616486861,
 42775,
 -56127,
 616545278,
 42776,
 -1,
 616586968,
 42777,
 616768709,
 616441996,
 -1,
 -56124,
 616726322,
 763,
 -1,
 616783093,
 761,
 -56122,
 616748301,
 42864,
 -56121,
 616929182,
 766,
 -1,
 616977669,
 4348,
 -1,
 603597789,
 43867,
 617283583,
 603521024,
 -1,
 617293066,
 617183883,
 -1,
 617358546,
 617272824,
 -1,
 617424081,
 617320748,
 -1,
 617489615,
 617392258,
 71174,
 -1,
 617457794,
 71175,
 617676799,
 617444428,
 71176,
 -1,
 617575500,
 71177,
 -1,
 617355572,
 71210,
 617817304,
 617333394,
 -1,
 617882838,
 617792146,
 -1,
 -56107,
 617830462,
 71193,
 -1,
 617879860,
 71192,
 -56105,
 617830462,
 71198,
 -1,
 618010932,
 71197,
 618210525,
 617777448,
 -1,
 -56102,
 618193780,
 71191,
 -56101,
 618236274,
 71196,
 -56100,
 618287937,
 71186,
 -1,
 618338612,
 71201,
 618538211,
 618149903,
 -1,
 618603745,
 618477583,
 -1,
 -56096,
 618551358,
 71195,
 -1,
 618600756,
 71194,
 -56094,
 618551358,
 71200,
 -1,
 618731828,
 71199,
 618931431,
 618469684,
 71168,
 -56091,
 618909213,
 71181,
 -56090,
 618946945,
 71179,
 -1,
 618993972,
 71169,
 619193579,
 618902871,
 -1,
 -56087,
 619165185,
 71212,
 -56086,
 619206718,
 71211,
 -1,
 619256116,
 71213,
 619455725,
 619171357,
 71172,
 -1,
 619433501,
 71173,
 619586800,
 619421389,
 -1,
 -56081,
 619534398,
 71203,
 -1,
 619583796,
 71202,
 619783411,
 619541580,
 -1,
 -56078,
 619738262,
 71215,
 -1,
 619780404,
 71209,
 619980022,
 619737227,
 -1,
 -56075,
 619927614,
 71183,
 -1,
 619977012,
 71182,
 620176633,
 619933535,
 -1,
 -56072,
 620124222,
 71190,
 -1,
 620173620,
 71189,
 620373243,
 620126593,
 71170,
 -1,
 620323201,
 71171,
 620504318,
 620319474,
 -1,
 -56067,
 620451902,
 71185,
 -1,
 620501300,
 71184,
 620700929,
 620440804,
 -1,
 -56064,
 620648510,
 71188,
 -1,
 620697908,
 71187,
 620897540,
 620635839,
 -1,
 -56061,
 620845118,
 71205,
 -1,
 620894516,
 71204,
 -56059,
 620880756,
 71207,
 -56058,
 621062389,
 71208,
 -56057,
 621121681,
 71180,
 -56056,
 621183195,
 71206,
 -56055,
 621238334,
 71214,
 -1,
 621297859,
 71178,
 621487386,
 617273968,
 -1,
 621552912,
 621468042,
 -1,
 621618446,
 621521026,
 71221,
 -1,
 621586562,
 71222,
 621805567,
 621573196,
 71223,
 -1,
 621704268,
 71224,
 621880596,
 621484340,
 -1,
 -56046,
 621858333,
 71228,
 -56045,
 621896065,
 71226,
 -1,
 621943092,
 71216,
 622142742,
 621858333,
 71219,
 -1,
 622120477,
 71220,
 622273816,
 622092673,
 71217,
 -1,
 622223745,
 71218,
 -56039,
 622235793,
 71227,
 -1,
 622346435,
 71225,
 622535979,
 621426703,
 -1,
 622601513,
 622486817,
 -1,
 622667039,
 622576274,
 -1,
 -56034,
 622649360,
 71250,
 -1,
 622682065,
 71251,
 622863650,
 622638423,
 -1,
 -56031,
 622816978,
 71254,
 -1,
 622873323,
 71255,
 623060261,
 622808295,
 -1,
 -56028,
 623024923,
 71252,
 -1,
 623078944,
 71253,
 -56026,
 623044234,
 71248,
 -56025,
 623219887,
 71249,
 -56024,
 623283416,
 71257,
 -1,
 623330573,
 71256,
 -56022,
 622566052,
 71234,
 -1,
 623452296,
 71233,
 623650099,
 622508745,
 -1,
 623715631,
 623630570,
 -1,
 -56018,
 623687377,
 71230,
 -1,
 623749636,
 71231,
 623912242,
 623647028,
 -1,
 -56015,
 623881011,
 71232,
 -1,
 623939596,
 71229,
 -1,
 623862093,
 71236,
 -1,
 623581785,
 71235,
 -1,
 603474223,
 129339,
 624305497,
 603425064,
 -1,
 624371019,
 624252626,
 -1,
 624436539,
 624345611,
 71273,
 624558079,
 624364323,
 -1,
 -56006,
 624466202,
 71274,
 -1,
 624508498,
 71275,
 624698687,
 624407487,
 71265,
 624820223,
 624626467,
 -1,
 -56002,
 624728346,
 71269,
 -1,
 624770642,
 71270,
 624960834,
 624673426,
 -1,
 -55999,
 624940221,
 71276,
 -1,
 624996839,
 71267,
 625157445,
 624917131,
 -1,
 -55996,
 625115701,
 6314,
 -1,
 625160104,
 6264,
 625354055,
 625109651,
 71271,
 -1,
 625282088,
 71272,
 625485130,
 625289712,
 -1,
 -55991,
 625449242,
 71264,
 -1,
 625491538,
 71268,
 -1,
 625425810,
 71266,
 625747282,
 624332945,
 -1,
 625812817,
 625694464,
 -1,
 625878352,
 625795852,
 -1,
 -55985,
 625829485,
 9867,
 -1,
 625877180,
 9866,
 -1,
 625820219,
 119552,
 -1,
 625781082,
 128669,
 626206039,
 625691861,
 -1,
 626271574,
 626130944,
 -1,
 -55979,
 626253709,
 128184,
 -1,
 626272049,
 128176,
 -1,
 626200346,
 129297,
 626589695,
 626160226,
 128018,
 -1,
 626459324,
 128053,
 626664804,
 624283165,
 -1,
 626730337,
 626626324,
 -1,
 626795872,
 626662734,
 9968,
 626917375,
 626720768,
 -1,
 -55970,
 626829663,
 128670,
 -55969,
 626863421,
 128672,
 -1,
 626928013,
 128693,
 -1,
 626721536,
 128507,
 627189091,
 626702137,
 128001,
 -1,
 627114684,
 128045,
 -1,
 627164569,
 128068,
 627385707,
 626639506,
 -1,
 627451242,
 627349599,
 -1,
 627516777,
 627376128,
 -1,
 -55960,
 627488516,
 128757,
 -1,
 627518197,
 128741,
 -1,
 627498022,
 128739,
 -1,
 627399621,
 129334,
 627844464,
 627347601,
 -1,
 627909999,
 627804458,
 -1,
 -55954,
 627890448,
 127889,
 -1,
 627912014,
 129390,
 -1,
 627849236,
 128496,
 628172148,
 627780020,
 128241,
 628293631,
 628097024,
 -1,
 -55949,
 628219646,
 128242,
 -1,
 628265467,
 128244,
 628434295,
 628145739,
 -1,
 -55946,
 628387324,
 129439,
 -1,
 628441283,
 128332,
 -55944,
 628417415,
 128511,
 -1,
 628611327,
 127909,
 628762187,
 603382741,
 -1,
 628827616,
 628716620,
 -1,
 628893148,
 628771361,
 -1,
 628958619,
 628864343,
 -1,
 629024154,
 628906024,
 -1,
 629089687,
 628957115,
 -1,
 629155203,
 629049640,
 -1,
 -55935,
 629138292,
 4218,
 -55934,
 629180786,
 43491,
 -1,
 629217588,
 4220,
 629417350,
 629108875,
 -1,
 -55931,
 629364798,
 4214,
 -1,
 629414196,
 4213,
 629613961,
 629363442,
 -1,
 -55928,
 629561406,
 43488,
 -1,
 629610804,
 4215,
 629810572,
 629550308,
 -1,
 -55925,
 629758014,
 43489,
 -1,
 629807412,
 4216,
 630007183,
 629745343,
 -1,
 -55922,
 629954622,
 43492,
 -1,
 630004020,
 4223,
 -55920,
 629990861,
 4217,
 -55919,
 630179245,
 4224,
 -55918,
 630235664,
 4221,
 -55917,
 630288372,
 43490,
 -55916,
 630347838,
 4225,
 -55915,
 630410556,
 4222,
 -55914,
 630470814,
 4219,
 -1,
 630528308,
 4130,
 630783999,
 629070926,
 -1,
 -55911,
 630700202,
 43647,
 -1,
 630730660,
 43646,
 -1,
 628970553,
 4193,
 630990262,
 628912767,
 -1,
 631055777,
 630929423,
 -1,
 631121312,
 630994959,
 -1,
 -55905,
 631068734,
 43625,
 -1,
 631118132,
 43624,
 -1,
 631068734,
 43626,
 631383460,
 631032824,
 -1,
 -55901,
 631330878,
 43623,
 -1,
 631380276,
 43622,
 631580071,
 631343400,
 -1,
 -55898,
 631563124,
 43621,
 -1,
 631576884,
 43627,
 631776682,
 631533407,
 -1,
 -55895,
 631724094,
 43620,
 -1,
 631773492,
 43619,
 631973293,
 631724072,
 -1,
 -55892,
 631920702,
 43630,
 -1,
 631970100,
 43629,
 632169904,
 631909604,
 -1,
 -55889,
 632117310,
 43618,
 -1,
 632166708,
 43617,
 -55887,
 632153549,
 43634,
 -55886,
 632349220,
 43633,
 -55885,
 632403457,
 43628,
 -55884,
 632465653,
 43635,
 -55883,
 632509249,
 43616,
 -1,
 632573244,
 43631,
 632759755,
 630965111,
 -1,
 632825277,
 632698895,
 -1,
 632890811,
 632764431,
 -1,
 -55878,
 632838206,
 43502,
 -1,
 632887604,
 43501,
 -55876,
 632838206,
 43516,
 -1,
 633018676,
 43515,
 633218496,
 632785192,
 -1,
 -55873,
 633201524,
 43495,
 -1,
 633244018,
 43503,
 633415107,
 633171807,
 -1,
 -55870,
 633362494,
 43500,
 -1,
 633411892,
 43499,
 633611718,
 633361138,
 -1,
 -55867,
 633559102,
 43498,
 -1,
 633608500,
 43497,
 633808329,
 633546431,
 -1,
 -55864,
 633755710,
 43518,
 -1,
 633805108,
 43517,
 -55862,
 633765161,
 43514,
 -1,
 633949500,
 43496,
 634136018,
 632719202,
 -1,
 634201551,
 634071111,
 -1,
 -55858,
 634142915,
 4189,
 -1,
 634198324,
 4188,
 -55856,
 634162239,
 4186,
 -55855,
 634351604,
 4187,
 -1,
 634405059,
 4136,
 634594774,
 634077824,
 -1,
 -55852,
 634578361,
 4207,
 -55851,
 634621328,
 4206,
 -1,
 634672641,
 4208,
 634856921,
 634576079,
 -1,
 -55848,
 634832301,
 4197,
 -1,
 634889927,
 4198,
 -55846,
 634828007,
 4238,
 -55845,
 635000674,
 4159,
 -1,
 635051476,
 43642,
 635305983,
 628855331,
 -1,
 -55842,
 635217719,
 43637,
 -55841,
 635277543,
 43636,
 -1,
 635330047,
 43638,
 635512339,
 628798807,
 -1,
 635577853,
 635462968,
 -1,
 635643374,
 635549926,
 -1,
 635708904,
 635619693,
 -1,
 -55835,
 635639329,
 4234,
 -55834,
 635704620,
 4233,
 -55833,
 635769658,
 4232,
 -1,
 635834901,
 4231,
 636036589,
 635647331,
 -1,
 636102124,
 636012909,
 -1,
 -55829,
 636031802,
 4236,
 -1,
 636097045,
 4235,
 -1,
 636044860,
 4237,
 -1,
 636008168,
 43493,
 636429812,
 635624674,
 -1,
 -55824,
 636359980,
 4205,
 -55823,
 636425304,
 4204,
 -55822,
 636490554,
 4203,
 -55821,
 636555797,
 4202,
 -1,
 636621034,
 4201,
 636823031,
 636404610,
 -1,
 -55818,
 636753196,
 43645,
 -1,
 636817941,
 43644,
 637019642,
 636777116,
 -1,
 -55815,
 636949306,
 4251,
 -1,
 637014250,
 4250,
 -55813,
 636990712,
 4239,
 -55812,
 637181909,
 43643,
 -1,
 637215798,
 4154,
 637412875,
 635525498,
 -1,
 637478401,
 637387410,
 -1,
 -55808,
 637460496,
 4242,
 -1,
 637493201,
 4243,
 637675012,
 637449559,
 -1,
 -55805,
 637628114,
 4246,
 -1,
 637684459,
 4247,
 637871623,
 637619431,
 -1,
 -55802,
 637836059,
 4244,
 -1,
 637890080,
 4245,
 -55800,
 637855370,
 4240,
 -55799,
 638031023,
 4241,
 -55798,
 638094552,
 4249,
 -1,
 638141709,
 4248,
 638386175,
 637396195,
 -1,
 638395920,
 638262725,
 -1,
 -55794,
 638373210,
 43641,
 -55793,
 638424239,
 43640,
 -1,
 638471108,
 43639,
 638713855,
 638367974,
 -1,
 -55790,
 638620847,
 4254,
 -1,
 638667716,
 4255,
 638854698,
 635492976,
 -1,
 638920219,
 638825815,
 -1,
 638985754,
 638867829,
 -1,
 639051288,
 638927043,
 4228,
 -1,
 638976005,
 4229,
 -55783,
 638996208,
 4230,
 -1,
 639113708,
 4227,
 -1,
 638932012,
 4194,
 639378975,
 638874087,
 -1,
 -55779,
 639356445,
 4211,
 -55778,
 639406537,
 4210,
 -1,
 639452085,
 4212,
 639641122,
 639360207,
 -1,
 -55775,
 639619160,
 4200,
 -1,
 639650375,
 4199,
 639837733,
 639600482,
 -1,
 -55772,
 639799441,
 4148,
 -1,
 639853963,
 4147,
 640034343,
 639770060,
 4252,
 -1,
 639984001,
 4253,
 -55768,
 640009187,
 4139,
 -55767,
 640111795,
 4209,
 -1,
 640172232,
 4149,
 640362044,
 638829202,
 -1,
 640427577,
 640294173,
 -1,
 640493103,
 640402066,
 -1,
 -55762,
 640475152,
 43506,
 -1,
 640507857,
 43507,
 640689714,
 640464215,
 -1,
 -55759,
 640642770,
 43510,
 -1,
 640699115,
 43511,
 640886325,
 640634087,
 -1,
 -55756,
 640850715,
 43508,
 -1,
 640904736,
 43509,
 -55754,
 640870026,
 43504,
 -55753,
 641045679,
 43505,
 -55752,
 641109208,
 43513,
 -1,
 641156365,
 43512,
 641400831,
 640390417,
 -1,
 -55749,
 641298958,
 4196,
 -1,
 641358477,
 4195,
 641541704,
 640300128,
 -1,
 641607239,
 641499269,
 -1,
 641672771,
 641549199,
 -1,
 -55744,
 641655668,
 4155,
 -55743,
 641719076,
 4157,
 -55742,
 641771765,
 4156,
 -1,
 641816638,
 4158,
 642056191,
 641635398,
 -1,
 -55739,
 641960306,
 4190,
 -55738,
 642023643,
 4191,
 -1,
 642086038,
 4192,
 -1,
 641579244,
 4226,
 642383871,
 641500956,
 -1,
 -55734,
 642300155,
 43494,
 -1,
 642347655,
 43632,
 642524935,
 628711809,
 -1,
 642590456,
 642458022,
 -1,
 642655938,
 642546315,
 -1,
 642721376,
 642630290,
 -1,
 642786903,
 642684259,
 -1,
 -55727,
 642717649,
 94105,
 -55726,
 642782961,
 94104,
 -55725,
 642848289,
 94103,
 -55724,
 642913580,
 94102,
 -55723,
 642978904,
 94101,
 -55722,
 643044154,
 94100,
 -1,
 643109397,
 94099,
 643311195,
 642757975,
 -1,
 -55719,
 643282433,
 93994,
 -55718,
 643323966,
 93998,
 -1,
 643373364,
 94007,
 643573342,
 643267386,
 -1,
 -55715,
 643556212,
 93980,
 -1,
 643569972,
 93978,
 -55713,
 643547928,
 93966,
 -1,
 643701044,
 93962,
 643901037,
 642681128,
 -1,
 643966564,
 643883788,
 -1,
 -55709,
 643913790,
 93997,
 -1,
 643963188,
 93996,
 644163175,
 643926312,
 -1,
 -55706,
 644110398,
 93973,
 -1,
 644159796,
 93972,
 644359786,
 644109042,
 -1,
 -55703,
 644307006,
 93988,
 -1,
 644356404,
 93987,
 644556396,
 644290868,
 93968,
 -1,
 644527698,
 94032,
 -1,
 644503614,
 93969,
 644753017,
 643884477,
 -1,
 644818548,
 644736445,
 -1,
 644884082,
 644789591,
 -1,
 -55695,
 644866932,
 94017,
 -1,
 644880692,
 94014,
 -55693,
 644866932,
 94016,
 -1,
 645011764,
 94013,
 645211767,
 644789591,
 -1,
 -55690,
 645158974,
 94006,
 -1,
 645208372,
 94012,
 -55688,
 645158974,
 94005,
 -1,
 645339444,
 94011,
 645539460,
 644736125,
 -1,
 645604992,
 645513874,
 -1,
 645670526,
 645576023,
 -1,
 -55683,
 645617726,
 94000,
 -1,
 645667124,
 94009,
 -55681,
 645645080,
 93964,
 -1,
 645798196,
 93965,
 -55679,
 645570345,
 93954,
 -55678,
 645959056,
 93970,
 -55677,
 646017245,
 93984,
 -1,
 646070462,
 94001,
 646260365,
 645508262,
 -1,
 646325900,
 646223203,
 -1,
 -55673,
 646256593,
 94111,
 -55672,
 646321697,
 94110,
 -55671,
 646386988,
 94109,
 -55670,
 646452312,
 94108,
 -55669,
 646517269,
 94107,
 -1,
 646582506,
 94106,
 -1,
 646297770,
 94002,
 646850199,
 646199311,
 -1,
 646915730,
 646833597,
 -1,
 -55664,
 646899149,
 93995,
 -55663,
 646928446,
 93999,
 -1,
 646977844,
 94008,
 647177877,
 646871866,
 -1,
 -55660,
 647160692,
 93981,
 -1,
 647174452,
 93979,
 -55658,
 647116958,
 93967,
 -1,
 647305524,
 93963,
 647505567,
 646781236,
 -1,
 647571102,
 647473880,
 -1,
 647636636,
 647530792,
 -1,
 -55653,
 647582529,
 93989,
 -1,
 647633204,
 93971,
 -55651,
 647620427,
 94015,
 -1,
 647790811,
 93958,
 -1,
 647518248,
 94019,
 648029861,
 647459916,
 -1,
 648095395,
 647977000,
 -1,
 -55646,
 648078196,
 93977,
 -1,
 648091956,
 93976,
 -55644,
 648078196,
 93975,
 -1,
 648223028,
 93974,
 648423081,
 648000855,
 -1,
 -55641,
 648394241,
 94004,
 -55640,
 648435774,
 94003,
 -1,
 648485172,
 94010,
 648685230,
 648368882,
 -1,
 648750765,
 648632360,
 -1,
 -55636,
 648697918,
 93993,
 -1,
 648747316,
 93992,
 -1,
 648681780,
 93983,
 649012913,
 648664568,
 -1,
 -55632,
 648957244,
 93961,
 -1,
 649009460,
 93960,
 649209524,
 648980178,
 -1,
 -55629,
 649155393,
 93986,
 -1,
 649206068,
 93985,
 649406135,
 649174733,
 -1,
 -55626,
 649360534,
 93955,
 -1,
 649402676,
 93952,
 649602746,
 649363589,
 -1,
 -55623,
 649549886,
 93957,
 -1,
 649599284,
 93956,
 649799357,
 649549864,
 -1,
 -55620,
 649746494,
 94020,
 -1,
 649795892,
 93990,
 -55618,
 649781796,
 93991,
 -55617,
 649976612,
 94018,
 -55616,
 650014941,
 93982,
 -55615,
 650071356,
 93959,
 -1,
 650127092,
 93953,
 650323694,
 642636400,
 -1,
 650389196,
 650273153,
 94049,
 650454727,
 650320180,
 94050,
 650575871,
 650414376,
 94051,
 -1,
 650466034,
 94052,
 -55608,
 650432029,
 94056,
 -55607,
 650612881,
 94053,
 -55606,
 650677244,
 94057,
 -55605,
 650731905,
 94055,
 -1,
 650789059,
 94054,
 650979029,
 650320180,
 94036,
 651044559,
 650938664,
 94039,
 -1,
 650990322,
 94040,
 651175633,
 650985667,
 94067,
 -1,
 651116739,
 94068,
 -55598,
 651152925,
 94075,
 -55597,
 651256193,
 94073,
 -55596,
 651320389,
 94038,
 -1,
 651368756,
 94037,
 651568860,
 650956317,
 94058,
 651634393,
 651499828,
 94059,
 651755519,
 651594024,
 94060,
 -1,
 651645682,
 94061,
 -55590,
 651611677,
 94062,
 -55589,
 651791356,
 94064,
 -1,
 651838716,
 94063,
 652027618,
 651509955,
 94045,
 652093151,
 651995266,
 94071,
 -1,
 652060802,
 94069,
 652224225,
 652052776,
 94046,
 -1,
 652169970,
 94047,
 -1,
 652173697,
 94074,
 652420838,
 651989137,
 94041,
 -55580,
 652398109,
 94076,
 -55579,
 652447889,
 94042,
 -1,
 652496085,
 94048,
 652682984,
 652403468,
 94065,
 -1,
 652632449,
 94066,
 652814058,
 652663524,
 94044,
 -1,
 652775569,
 94043,
 652945132,
 652784645,
 94072,
 -1,
 652912770,
 94070,
 653131775,
 652904744,
 94077,
 -1,
 653021938,
 94078,
 653207283,
 650299732,
 -1,
 -55568,
 653183369,
 94096,
 -55567,
 653242118,
 94095,
 -55566,
 653273262,
 94098,
 -1,
 653335152,
 94097,
 653590527,
 653179593,
 -1,
 653600503,
 653503644,
 -1,
 -55562,
 653580760,
 94034,
 -1,
 653599867,
 94035,
 -1,
 653534331,
 94033,
 653862656,
 642528635,
 -1,
 653928189,
 653824145,
 -1,
 -55557,
 653899532,
 128300,
 -55556,
 653959723,
 127908,
 -1,
 653994089,
 129440,
 654245887,
 653852672,
 -1,
 -55553,
 654152811,
 983235,
 -1,
 654194992,
 983236,
 654386948,
 653823123,
 -1,
 -55550,
 654345909,
 128469,
 -55549,
 654392264,
 128189,
 -1,
 654453897,
 128656,
 654704639,
 654341196,
 -1,
 -55546,
 654603305,
 127756,
 -1,
 654667176,
 127894,
 654845784,
 642502173,
 -1,
 654911294,
 654802886,
 -1,
 654976829,
 654844196,
 -1,
 655042364,
 654932619,
 -1,
 655107858,
 654981135,
 -1,
 655173392,
 655046671,
 -1,
 -55538,
 655120446,
 70292,
 -55537,
 655177886,
 70291,
 -1,
 655235380,
 70290,
 -55535,
 655120446,
 70297,
 -1,
 655366452,
 70296,
 655566616,
 655082130,
 -1,
 655632150,
 655540882,
 -1,
 -55531,
 655579198,
 70289,
 -1,
 655628596,
 70288,
 -55529,
 655579198,
 70295,
 -1,
 655759668,
 70294,
 655959836,
 655534210,
 -1,
 -55526,
 655927541,
 70311,
 -55525,
 655972414,
 70312,
 -1,
 656021812,
 70306,
 656221984,
 655919400,
 -1,
 -55522,
 656204660,
 70287,
 -55521,
 656247154,
 70293,
 -1,
 656283956,
 70298,
 656484131,
 656187085,
 -1,
 -55518,
 656431166,
 70300,
 -1,
 656480564,
 70299,
 656680742,
 656437387,
 -1,
 -55515,
 656627774,
 70277,
 -1,
 656677172,
 70276,
 656877353,
 656633695,
 -1,
 -55512,
 656830333,
 70285,
 -1,
 656873780,
 70284,
 657073964,
 656823026,
 -1,
 -55509,
 657020990,
 70280,
 -1,
 657070388,
 70278,
 657270575,
 657009892,
 -1,
 -55506,
 657217598,
 70283,
 -1,
 657266996,
 70282,
 657467186,
 657204927,
 -1,
 -55503,
 657414206,
 70303,
 -1,
 657463604,
 70301,
 -55501,
 657449844,
 70305,
 -55500,
 657643022,
 70308,
 -55499,
 657706525,
 70274,
 -55498,
 657765889,
 70309,
 -55497,
 657817819,
 70304,
 -55496,
 657880214,
 70307,
 -55495,
 657940865,
 70273,
 -55494,
 658004030,
 70310,
 -55493,
 658063555,
 70275,
 -1,
 658118964,
 70272,
 -1,
 655013727,
 70313,
 -1,
 654928763,
 127926,
 658505727,
 654882135,
 -1,
 658515799,
 658399927,
 -1,
 658581332,
 658486615,
 -1,
 658646867,
 658564323,
 -1,
 658712402,
 658600658,
 -1,
 658777928,
 658653379,
 -1,
 658843463,
 658728195,
 -1,
 -55482,
 658821768,
 119271,
 -1,
 658849464,
 119270,
 -1,
 658803280,
 119263,
 659105611,
 658745289,
 -1,
 -55478,
 659083912,
 119269,
 -1,
 659111608,
 119268,
 659302222,
 659049703,
 -1,
 -55475,
 659256929,
 119272,
 -1,
 659318431,
 119264,
 -55473,
 659283437,
 119266,
 -55472,
 659467237,
 119265,
 -55471,
 659511573,
 119267,
 -1,
 659565811,
 119262,
 -1,
 658671758,
 119081,
 -1,
 658584874,
 127932,
 659892054,
 658535014,
 127929,
 -1,
 659819791,
 127896,
 -1,
 659852899,
 127925,
 -1,
 658464953,
 127812,
 660154257,
 654816007,
 -1,
 660219776,
 660109963,
 -1,
 660285278,
 660193938,
 -1,
 -55460,
 660232892,
 92757,
 -55459,
 660292999,
 92766,
 -1,
 660347188,
 92736,
 660547425,
 660246673,
 92754,
 -55456,
 660508817,
 92753,
 -1,
 660567116,
 92749,
 660744037,
 660500619,
 -1,
 -55453,
 660705425,
 92761,
 -55452,
 660756614,
 92744,
 -1,
 660816370,
 92748,
 661006184,
 660711554,
 -1,
 -55449,
 660967569,
 92755,
 -1,
 661021057,
 92765,
 661202795,
 660971213,
 -1,
 -55446,
 661150796,
 92743,
 -1,
 661199156,
 92752,
 661399406,
 661162280,
 -1,
 -55443,
 661349997,
 92751,
 -1,
 661411334,
 92737,
 661596017,
 661356677,
 -1,
 -55440,
 661546499,
 92739,
 -1,
 661593069,
 92750,
 661792627,
 661550230,
 92763,
 -1,
 661752104,
 92762,
 661923702,
 661739582,
 -1,
 -55435,
 661885073,
 92745,
 -1,
 661938561,
 92764,
 662120312,
 661864643,
 92760,
 -1,
 662051124,
 92758,
 662251386,
 662059166,
 92741,
 -1,
 662200705,
 92746,
 -55429,
 662234404,
 92738,
 -55428,
 662362916,
 92759,
 -55427,
 662419875,
 92756,
 -55426,
 662450364,
 92747,
 -55425,
 662513396,
 92740,
 -1,
 662575412,
 92742,
 662831103,
 660158479,
 -1,
 662841231,
 662725921,
 -1,
 662906757,
 662815378,
 -1,
 -55420,
 662888464,
 92770,
 -1,
 662921169,
 92771,
 663103368,
 662877527,
 -1,
 -55417,
 663056082,
 92774,
 -1,
 663112427,
 92775,
 663299979,
 663047399,
 -1,
 -55414,
 663264027,
 92772,
 -1,
 663318048,
 92773,
 -55412,
 663283338,
 92768,
 -55411,
 663458991,
 92769,
 -55410,
 663522520,
 92777,
 -1,
 663569677,
 92776,
 -55408,
 662805156,
 92783,
 -1,
 663691400,
 92782,
 -55406,
 660134628,
 983173,
 -55405,
 663870155,
 983216,
 -1,
 663914552,
 983228,
 664088266,
 521237580,
 -1,
 664152811,
 664035713,
 -1,
 664218161,
 664111400,
 -1,
 664283694,
 664158403,
 -1,
 664349226,
 664216088,
 -1,
 664414502,
 664279446,
 -1,
 664479738,
 664348351,
 -1,
 664545259,
 664408029,
 -1,
 664610731,
 664474133,
 -1,
 664676256,
 664539669,
 67090,
 -55393,
 664633477,
 67092,
 -1,
 664685799,
 67091,
 664872867,
 664604906,
 67087,
 -55390,
 664830085,
 67089,
 -1,
 664882407,
 67088,
 665069477,
 664802106,
 67093,
 -1,
 665026693,
 67094,
 -55386,
 665000066,
 67100,
 -55385,
 665130961,
 67098,
 -55384,
 665196273,
 67097,
 -55383,
 665261601,
 67096,
 -55382,
 665326680,
 67095,
 -1,
 665391069,
 67086,
 665593781,
 664540460,
 -1,
 -55379,
 665524354,
 67123,
 -55378,
 665589713,
 67122,
 -55377,
 665655025,
 67121,
 -55376,
 665720353,
 67120,
 -55375,
 665785644,
 67119,
 -55374,
 665850968,
 67118,
 -55373,
 665916218,
 67117,
 -55372,
 665981162,
 67116,
 -1,
 666046429,
 67115,
 666249151,
 665522141,
 -1,
 -55369,
 666179714,
 67080,
 -55368,
 666245073,
 67079,
 -55367,
 666310385,
 67078,
 -55366,
 666375713,
 67077,
 -55365,
 666441004,
 67076,
 -55364,
 666506328,
 67075,
 -55363,
 666571578,
 67074,
 -55362,
 666636821,
 67073,
 -1,
 666702058,
 67072,
 666904520,
 666178648,
 -1,
 -55359,
 666835074,
 67114,
 -55358,
 666900433,
 67113,
 -55357,
 666965745,
 67112,
 -55356,
 667031073,
 67111,
 -55355,
 667096364,
 67110,
 -55354,
 667161688,
 67109,
 -55353,
 667226346,
 67108,
 -1,
 667291613,
 67107,
 667494352,
 666834673,
 -1,
 -55350,
 667424898,
 67136,
 -55349,
 667490257,
 67135,
 -55348,
 667555569,
 67134,
 -55347,
 667620897,
 67133,
 -55346,
 667685976,
 67132,
 -55345,
 667751226,
 67131,
 -1,
 667815901,
 67130,
 668018647,
 667424721,
 -1,
 -55342,
 667948785,
 67142,
 -55341,
 668014113,
 67141,
 -55340,
 668079404,
 67140,
 -55339,
 668144149,
 67139,
 -55338,
 668209386,
 67138,
 -1,
 668274653,
 67137,
 668477406,
 667948577,
 -1,
 -55335,
 668407938,
 67129,
 -55334,
 668473073,
 67128,
 -55333,
 668538401,
 67127,
 -55332,
 668603692,
 67126,
 -55331,
 668668138,
 67125,
 -1,
 668733405,
 67124,
 668936165,
 668406586,
 -1,
 -55328,
 668866690,
 67106,
 -55327,
 668932049,
 67105,
 -55326,
 668997361,
 67104,
 -55325,
 669062232,
 67103,
 -55324,
 669126890,
 67102,
 -1,
 669192157,
 67101,
 669450239,
 668864746,
 -1,
 -55321,
 669325041,
 67085,
 -55320,
 669390369,
 67084,
 -55319,
 669455162,
 67083,
 -55318,
 669520106,
 67082,
 -1,
 669585373,
 67081,
 669843455,
 664473834,
 -1,
 669853680,
 669717013,
 -1,
 -55314,
 669782842,
 67148,
 -55313,
 669848085,
 67147,
 -1,
 669913053,
 67145,
 670115827,
 669784017,
 -1,
 -55310,
 670046161,
 67155,
 -1,
 670109661,
 67154,
 670312438,
 670045244,
 -1,
 -55307,
 670246591,
 67150,
 -1,
 670308660,
 67149,
 -55305,
 670243104,
 67156,
 -55304,
 670439343,
 67153,
 -55303,
 670504682,
 67152,
 -1,
 670568965,
 67144,
 670771285,
 664409388,
 -1,
 670836742,
 670701521,
 -1,
 -55299,
 670767234,
 67324,
 -55298,
 670832593,
 67323,
 -55297,
 670897905,
 67322,
 -55296,
 670963233,
 67321,
 -55295,
 671028524,
 67320,
 -55294,
 671093848,
 67319,
 -55293,
 671159098,
 67318,
 -55292,
 671224341,
 67317,
 -55291,
 671289578,
 67316,
 -1,
 671354845,
 67315,
 671557649,
 670766833,
 -1,
 -55288,
 671488130,
 67314,
 -55287,
 671553489,
 67313,
 -55286,
 671618801,
 67312,
 -55285,
 671684129,
 67311,
 -55284,
 671749420,
 67310,
 -55283,
 671814744,
 67309,
 -55282,
 671879994,
 67308,
 -55281,
 671945237,
 67307,
 -55280,
 672010474,
 67306,
 -1,
 672075741,
 67305,
 672278555,
 671487276,
 -1,
 -55277,
 672209026,
 67298,
 -55276,
 672274161,
 67297,
 -55275,
 672339489,
 67296,
 -55274,
 672404780,
 67295,
 -55273,
 672470104,
 67294,
 -55272,
 672535354,
 67293,
 -55271,
 672600597,
 67292,
 -55270,
 672665834,
 67291,
 -1,
 672731101,
 67290,
 672933925,
 672207674,
 -1,
 -55267,
 672864386,
 67282,
 -55266,
 672929745,
 67281,
 -55265,
 672995057,
 67280,
 -55264,
 673060385,
 67279,
 -55263,
 673125676,
 67278,
 -55262,
 673191000,
 67277,
 -55261,
 673255957,
 67276,
 -55260,
 673321194,
 67275,
 -1,
 673386461,
 67274,
 673589295,
 672862741,
 -1,
 -55257,
 673519746,
 67273,
 -55256,
 673585105,
 67272,
 -55255,
 673650417,
 67271,
 -55254,
 673715745,
 67270,
 -55253,
 673781036,
 67269,
 -55252,
 673846360,
 67268,
 -55251,
 673911610,
 67267,
 -55250,
 673976554,
 67266,
 -1,
 674041821,
 67265,
 674244664,
 673517533,
 -1,
 -55247,
 674175106,
 67258,
 -55246,
 674240465,
 67257,
 -55245,
 674305569,
 67256,
 -55244,
 674370860,
 67255,
 -55243,
 674436184,
 67254,
 -55242,
 674501434,
 67253,
 -55241,
 674566677,
 67252,
 -1,
 674631914,
 67251,
 674834496,
 674174040,
 -1,
 -55238,
 674764930,
 67289,
 -55237,
 674830289,
 67288,
 -55236,
 674895601,
 67287,
 -55235,
 674960684,
 67286,
 -55234,
 675025429,
 67285,
 -55233,
 675090666,
 67284,
 -1,
 675155933,
 67283,
 675358791,
 674764930,
 -1,
 -55230,
 675289041,
 67330,
 -55229,
 675354145,
 67329,
 -55228,
 675419436,
 67328,
 -55227,
 675484760,
 67327,
 -55226,
 675549717,
 67326,
 -1,
 675614954,
 67325,
 675817550,
 675288609,
 -1,
 -55223,
 675747970,
 67304,
 -55222,
 675813329,
 67303,
 -55221,
 675878433,
 67302,
 -55220,
 675943724,
 67301,
 -55219,
 676009048,
 67300,
 -1,
 676074298,
 67299,
 676331519,
 675746026,
 -1,
 -55216,
 676206113,
 67264,
 -55215,
 676271404,
 67263,
 -55214,
 676336442,
 67262,
 -55213,
 676401685,
 67261,
 -55212,
 676466922,
 67260,
 -1,
 676532189,
 67259,
 676735147,
 670700346,
 -1,
 676800612,
 676663530,
 -1,
 676866139,
 676729658,
 -1,
 -55207,
 676801764,
 67173,
 -55206,
 676865727,
 67172,
 -1,
 676927796,
 67171,
 -55204,
 676796546,
 67179,
 -55203,
 677058513,
 67178,
 -55202,
 677123825,
 67177,
 -55201,
 677189153,
 67176,
 -55200,
 677254444,
 67175,
 -55199,
 677319768,
 67174,
 -55198,
 677384725,
 67170,
 -55197,
 677449962,
 67169,
 -1,
 677515229,
 67168,
 677718129,
 676728797,
 -1,
 677783657,
 677648514,
 -1,
 -55193,
 677719268,
 67167,
 -55192,
 677783231,
 67166,
 -1,
 677845300,
 67165,
 -55190,
 677713873,
 67164,
 -55189,
 677975793,
 67163,
 -55188,
 678041121,
 67162,
 -55187,
 678106412,
 67161,
 -55186,
 678171736,
 67160,
 -55185,
 678236986,
 67159,
 -55184,
 678302229,
 67158,
 -1,
 678367466,
 67157,
 678570108,
 677647905,
 -1,
 -55181,
 678500482,
 67229,
 -55180,
 678565841,
 67228,
 -55179,
 678631153,
 67227,
 -55178,
 678696481,
 67226,
 -55177,
 678761772,
 67225,
 -55176,
 678827096,
 67224,
 -55175,
 678892346,
 67223,
 -55174,
 678957589,
 67222,
 -55173,
 679022826,
 67221,
 -1,
 679088093,
 67220,
 679291015,
 678499628,
 -1,
 -55170,
 679221378,
 67219,
 -55169,
 679286737,
 67218,
 -55168,
 679352049,
 67217,
 -55167,
 679417377,
 67216,
 -55166,
 679482668,
 67215,
 -55165,
 679547992,
 67214,
 -55164,
 679613242,
 67213,
 -55163,
 679678485,
 67212,
 -55162,
 679743722,
 67211,
 -1,
 679808989,
 67210,
 680011922,
 679220312,
 -1,
 -55159,
 679942274,
 67209,
 -55158,
 680007633,
 67208,
 -55157,
 680072945,
 67207,
 -55156,
 680138273,
 67206,
 -55155,
 680203564,
 67205,
 -55154,
 680268888,
 67204,
 -55153,
 680334138,
 67203,
 -55152,
 680399381,
 67202,
 -55151,
 680464618,
 67201,
 -1,
 680529885,
 67200,
 680732829,
 679940922,
 -1,
 -55148,
 680663170,
 67199,
 -55147,
 680728529,
 67198,
 -55146,
 680793841,
 67197,
 -55145,
 680859169,
 67196,
 -55144,
 680924460,
 67195,
 -55143,
 680989784,
 67194,
 -55142,
 681055034,
 67193,
 -55141,
 681120277,
 67192,
 -55140,
 681185514,
 67191,
 -1,
 681250781,
 67190,
 681453736,
 680661525,
 -1,
 -55137,
 681384066,
 67189,
 -55136,
 681449425,
 67188,
 -55135,
 681514737,
 67187,
 -55134,
 681580065,
 67186,
 -55133,
 681645356,
 67185,
 -55132,
 681710680,
 67184,
 -55131,
 681775930,
 67183,
 -55130,
 681841173,
 67182,
 -55129,
 681906410,
 67181,
 -1,
 681971677,
 67180,
 682229759,
 681383665,
 -1,
 -55126,
 682103018,
 67231,
 -1,
 682168285,
 67230,
 682371303,
 676664865,
 -1,
 682436791,
 682299626,
 -1,
 -55122,
 682367106,
 67348,
 -55121,
 682432465,
 67347,
 -55120,
 682497777,
 67346,
 -55119,
 682563105,
 67345,
 -55118,
 682628396,
 67344,
 -55117,
 682693720,
 67343,
 -55116,
 682758970,
 67342,
 -55115,
 682824213,
 67341,
 -55114,
 682889450,
 67340,
 -1,
 682954717,
 67339,
 683157697,
 682366252,
 -1,
 -55111,
 683088002,
 67377,
 -55110,
 683153361,
 67376,
 -55109,
 683218673,
 67375,
 -55108,
 683284001,
 67374,
 -55107,
 683349292,
 67373,
 -55106,
 683414616,
 67372,
 -55105,
 683479866,
 67371,
 -55104,
 683545109,
 67370,
 -1,
 683610346,
 67369,
 683813067,
 683086357,
 -1,
 -55101,
 683743362,
 67357,
 -55100,
 683808721,
 67356,
 -55099,
 683874033,
 67355,
 -55098,
 683939361,
 67354,
 -55097,
 684004440,
 67353,
 -55096,
 684069690,
 67352,
 -55095,
 684134933,
 67351,
 -55094,
 684200170,
 67350,
 -1,
 684265437,
 67349,
 684468436,
 683742296,
 -1,
 -55091,
 684398722,
 67368,
 -55090,
 684464081,
 67367,
 -55089,
 684529185,
 67366,
 -55088,
 684594476,
 67365,
 -55087,
 684659800,
 67364,
 -55086,
 684725050,
 67363,
 -55085,
 684790293,
 67362,
 -1,
 684855261,
 67361,
 685058269,
 684396509,
 -1,
 -55082,
 684988546,
 67338,
 -55081,
 685053905,
 67337,
 -55080,
 685119009,
 67336,
 -55079,
 685184088,
 67335,
 -55078,
 685249338,
 67334,
 -55077,
 685314581,
 67333,
 -55076,
 685379818,
 67332,
 -1,
 685445085,
 67331,
 685648099,
 684987937,
 -1,
 -55073,
 685577304,
 67382,
 -55072,
 685642554,
 67381,
 -55071,
 685707797,
 67380,
 -55070,
 685773034,
 67379,
 -1,
 685838301,
 67378,
 686096383,
 685577018,
 -1,
 -55067,
 685971409,
 67360,
 -55066,
 686036721,
 67359,
 -1,
 686101592,
 67358,
 686303490,
 682301169,
 -1,
 686369016,
 686231517,
 -1,
 686434544,
 686299266,
 -1,
 686500079,
 686362214,
 -1,
 -55060,
 686429796,
 67404,
 -55059,
 686494872,
 67403,
 -55058,
 686560156,
 67402,
 -1,
 686625374,
 67401,
 -1,
 686425049,
 67400,
 -55055,
 686364688,
 67399,
 -55054,
 686823205,
 67398,
 -55053,
 686888506,
 67397,
 -55052,
 686953819,
 67396,
 -55051,
 687019127,
 67395,
 -55050,
 687084376,
 67394,
 -55049,
 687149591,
 67393,
 -1,
 687214828,
 67392,
 687417600,
 686297322,
 -1,
 -55046,
 687347453,
 67411,
 -55045,
 687412551,
 67410,
 -55044,
 687477854,
 67409,
 -55043,
 687543259,
 67408,
 -55042,
 687608567,
 67407,
 -55041,
 687673806,
 67406,
 -1,
 687739027,
 67405,
 -55039,
 687346755,
 67413,
 -1,
 687870760,
 67412,
 688072984,
 686232664,
 -1,
 688138510,
 688000989,
 -1,
 -55035,
 688068887,
 67241,
 -55034,
 688134255,
 67240,
 -55033,
 688199590,
 67239,
 -55032,
 688264925,
 67238,
 -55031,
 688330234,
 67237,
 -55030,
 688395537,
 67236,
 -55029,
 688460847,
 67235,
 -55028,
 688526084,
 67234,
 -55027,
 688591338,
 67233,
 -1,
 688656580,
 67232,
 688914431,
 688066794,
 -1,
 -55024,
 688789615,
 67250,
 -55023,
 688854950,
 67249,
 -55022,
 688920285,
 67248,
 -55021,
 688985594,
 67247,
 -55020,
 689050897,
 67246,
 -55019,
 689116207,
 67245,
 -55018,
 689181444,
 67244,
 -55017,
 689246698,
 67243,
 -1,
 689311940,
 67242,
 689514785,
 688003189,
 -1,
 -55014,
 689444593,
 67431,
 -55013,
 689509921,
 67430,
 -55012,
 689575212,
 67429,
 -55011,
 689640536,
 67428,
 -55010,
 689705786,
 67427,
 -55009,
 689771029,
 67426,
 -55008,
 689836266,
 67425,
 -1,
 689901533,
 67424,
 690104613,
 689443050,
 -1,
 -55005,
 690033727,
 67151,
 -55004,
 690098957,
 67146,
 -1,
 690163914,
 67143,
 -1,
 690032849,
 67099,
 690487295,
 664348353,
 -1,
 690497975,
 690381633,
 -1,
 690563477,
 690431679,
 -1,
 690628983,
 690491626,
 -1,
 690694462,
 690556893,
 -1,
 690759983,
 690623788,
 -1,
 -54995,
 690716860,
 65669,
 -54994,
 690769144,
 65668,
 -1,
 690815669,
 65667,
 691022130,
 690690178,
 -1,
 -54991,
 690978961,
 65677,
 -1,
 691031276,
 65676,
 691218741,
 690952145,
 -1,
 -54988,
 691175562,
 65675,
 -1,
 691227922,
 65674,
 691415352,
 691148529,
 -1,
 -54985,
 691372191,
 65673,
 -1,
 691424519,
 65672,
 691611963,
 691344929,
 -1,
 -54982,
 691568822,
 65671,
 -1,
 691621106,
 65670,
 -54980,
 691541099,
 65666,
 -54979,
 691737327,
 65665,
 -1,
 691802187,
 65664,
 692005193,
 690624033,
 -1,
 -54976,
 691935362,
 65713,
 -54975,
 692000721,
 65712,
 -54974,
 692066033,
 65711,
 -54973,
 692131361,
 65710,
 -54972,
 692196652,
 65709,
 -54971,
 692261976,
 65708,
 -54970,
 692327241,
 65707,
 -54969,
 692392496,
 65706,
 -54968,
 692457706,
 65705,
 -1,
 692522973,
 65704,
 692726099,
 691934961,
 -1,
 -54965,
 692656258,
 65722,
 -54964,
 692721617,
 65721,
 -54963,
 692786929,
 65720,
 -54962,
 692852423,
 65719,
 -54961,
 692917336,
 65718,
 -54960,
 692982721,
 65717,
 -54959,
 693047829,
 65716,
 -54958,
 693113066,
 65715,
 -1,
 693178333,
 65714,
 693381468,
 692655404,
 -1,
 -54955,
 693311620,
 65703,
 -54954,
 693376977,
 65702,
 -54953,
 693442289,
 65701,
 -54952,
 693507160,
 65699,
 -54951,
 693572410,
 65698,
 -54950,
 693637653,
 65697,
 -54949,
 693702988,
 65696,
 -1,
 693768157,
 65695,
 693971300,
 693311441,
 -1,
 -54946,
 693901442,
 65729,
 -54945,
 693966124,
 65728,
 -54944,
 694031448,
 65727,
 -54943,
 694096698,
 65726,
 -54942,
 694161941,
 65725,
 -54941,
 694227178,
 65724,
 -1,
 694292445,
 65723,
 694495594,
 693900376,
 -1,
 -54938,
 694425121,
 65694,
 -54937,
 694490607,
 65693,
 -54936,
 694555157,
 65692,
 -54935,
 694620471,
 65691,
 -1,
 694685674,
 65690,
 694888816,
 694424085,
 -1,
 -54932,
 694818124,
 65682,
 -54931,
 694883325,
 65681,
 -54930,
 694948511,
 65680,
 -54929,
 695013629,
 65679,
 -1,
 695079063,
 65678,
 695282036,
 694817594,
 -1,
 -54926,
 695210517,
 65687,
 -54925,
 695275969,
 65686,
 -1,
 695341170,
 65685,
 695599103,
 695212162,
 -1,
 -54922,
 695472451,
 65731,
 -1,
 695537629,
 65730,
 695795711,
 690557461,
 -1,
 695806338,
 695670060,
 -1,
 -54918,
 695736450,
 65757,
 -54917,
 695801809,
 65756,
 -54916,
 695867121,
 65755,
 -54915,
 695932449,
 65754,
 -54914,
 695997740,
 65753,
 -54913,
 696063076,
 65752,
 -54912,
 696128314,
 65751,
 -54911,
 696193557,
 65750,
 -1,
 696258794,
 65749,
 696461707,
 695735384,
 -1,
 -54908,
 696391810,
 65748,
 -54907,
 696457169,
 65747,
 -54906,
 696522273,
 65745,
 -54905,
 696587564,
 65744,
 -54904,
 696652830,
 65743,
 -54903,
 696717856,
 65742,
 -54902,
 696783110,
 65741,
 -1,
 696848543,
 65740,
 697051538,
 696390458,
 -1,
 -54899,
 696981025,
 65739,
 -54898,
 697046104,
 65738,
 -54897,
 697111557,
 65737,
 -54896,
 697176597,
 65736,
 -54895,
 697241840,
 65735,
 -1,
 697307271,
 65734,
 697565183,
 696979989,
 -1,
 -54892,
 697439549,
 65733,
 -1,
 697503747,
 65732,
 697761791,
 690542788,
 -1,
 697772469,
 697635349,
 -1,
 697837986,
 697700586,
 -1,
 -54887,
 697768066,
 65778,
 -54886,
 697833425,
 65777,
 -54885,
 697898737,
 65776,
 -54884,
 697964065,
 65775,
 -54883,
 698029356,
 65774,
 -54882,
 698094680,
 65773,
 -54881,
 698159930,
 65772,
 -54880,
 698225173,
 65771,
 -54879,
 698290410,
 65770,
 -1,
 698355677,
 65769,
 698558893,
 697765853,
 -1,
 -54876,
 698488962,
 65768,
 -54875,
 698554321,
 65767,
 -54874,
 698619633,
 65766,
 -54873,
 698684961,
 65765,
 -54872,
 698750252,
 65764,
 -54871,
 698815576,
 65763,
 -54870,
 698880826,
 65762,
 -54869,
 698946069,
 65761,
 -54868,
 699011306,
 65760,
 -1,
 699076573,
 65759,
 699279796,
 698487317,
 -1,
 -54865,
 699209858,
 65784,
 -54864,
 699275217,
 65783,
 -54863,
 699340529,
 65782,
 -54862,
 699405857,
 65781,
 -54861,
 699470357,
 65780,
 -1,
 699535594,
 65779,
 -1,
 699209216,
 65785,
 -54858,
 697701432,
 65786,
 -1,
 699732475,
 65758,
 699935264,
 690471454,
 -1,
 700000781,
 699890997,
 -1,
 700066243,
 699930353,
 -1,
 -54853,
 699996250,
 65572,
 -54852,
 700061492,
 65551,
 -54851,
 700126885,
 65608,
 -54850,
 700192229,
 65592,
 -54849,
 700257544,
 65597,
 -54848,
 700322748,
 65558,
 -54847,
 700388007,
 65567,
 -54846,
 700453151,
 65603,
 -1,
 700518455,
 65554,
 700721613,
 699995436,
 -1,
 -54843,
 700651766,
 65586,
 -54842,
 700717157,
 65585,
 -54841,
 700782377,
 65546,
 -54840,
 700847550,
 65565,
 -54839,
 700912882,
 65591,
 -54838,
 700978168,
 65578,
 -54837,
 701043354,
 65564,
 -54836,
 701108506,
 65545,
 -1,
 701173880,
 65570,
 701376983,
 700650005,
 -1,
 -54833,
 701307105,
 65606,
 -54832,
 701372423,
 65538,
 -54831,
 701437836,
 65577,
 -54830,
 701503147,
 65580,
 -54829,
 701568302,
 65600,
 -54828,
 701633730,
 65562,
 -54827,
 701699017,
 65560,
 -54826,
 701763991,
 65573,
 -1,
 701829307,
 65599,
 702032353,
 701304797,
 -1,
 -54823,
 701962471,
 65582,
 -54822,
 702027731,
 65536,
 -54821,
 702093058,
 65543,
 -54820,
 702158471,
 65561,
 -54819,
 702223821,
 65589,
 -54818,
 702289116,
 65587,
 -54817,
 702354403,
 65566,
 -54816,
 702419664,
 65579,
 -1,
 702484752,
 65541,
 702687722,
 701961761,
 -1,
 -54813,
 702617856,
 65590,
 -54812,
 702683231,
 65610,
 -54811,
 702748480,
 65553,
 -54810,
 702813889,
 65611,
 -54809,
 702879091,
 65550,
 -54808,
 702943941,
 65607,
 -54807,
 703009140,
 65539,
 -1,
 703074429,
 65576,
 703277555,
 702616664,
 -1,
 -54804,
 703207489,
 65605,
 -54803,
 703272532,
 65547,
 -54802,
 703337814,
 65542,
 -54801,
 703403142,
 65552,
 -54800,
 703468348,
 65601,
 -54799,
 703533802,
 65594,
 -54798,
 703599014,
 65583,
 -1,
 703664305,
 65593,
 703867388,
 703206202,
 -1,
 -54795,
 703797468,
 65568,
 -54794,
 703862753,
 65537,
 -54793,
 703928209,
 65588,
 -54792,
 703993433,
 65549,
 -54791,
 704058354,
 65609,
 -54790,
 704123595,
 65574,
 -54789,
 704188833,
 65581,
 -1,
 704254047,
 65563,
 704457221,
 703795434,
 -1,
 -54786,
 704386977,
 65596,
 -54785,
 704452256,
 65571,
 -54784,
 704517547,
 65559,
 -54783,
 704582770,
 65544,
 -54782,
 704648119,
 65557,
 -54781,
 704713435,
 65584,
 -54780,
 704778642,
 65569,
 -1,
 704843919,
 65540,
 705047050,
 704387025,
 -1,
 -54777,
 704976790,
 65612,
 -54776,
 705041720,
 65602,
 -54775,
 705106269,
 65555,
 -1,
 705171526,
 65556,
 705429503,
 704977026,
 -1,
 -54772,
 705302966,
 65613,
 -1,
 705368057,
 65604,
 705626111,
 699958127,
 -1,
 705636883,
 705501137,
 -1,
 -54768,
 705566850,
 65629,
 -54767,
 705631777,
 65628,
 -54766,
 705696570,
 65627,
 -1,
 705761813,
 65626,
 705964566,
 705566241,
 -1,
 -54763,
 705893464,
 65624,
 -1,
 705958714,
 65623,
 706161177,
 705893464,
 -1,
 -54760,
 706091138,
 65621,
 -1,
 706156273,
 65620,
 706357788,
 706089194,
 -1,
 -54757,
 706287746,
 65617,
 -1,
 706353105,
 65616,
 -54755,
 706287545,
 65625,
 -54754,
 706483729,
 65622,
 -54753,
 706548812,
 65619,
 -1,
 706614036,
 65618,
 706871295,
 699893624,
 -1,
 706882089,
 706744554,
 -1,
 706947621,
 706810682,
 -1,
 -54748,
 706876836,
 65689,
 -1,
 706941761,
 65688,
 707144232,
 706875925,
 -1,
 -54745,
 707074068,
 65684,
 -1,
 707139385,
 65683,
 -1,
 707073556,
 65700,
 -1,
 706810650,
 65746,
 707526655,
 664272896,
 -1,
 707537453,
 707445582,
 983068,
 -1,
 707463379,
 983142,
 -1,
 707481027,
 983062,
 707788799,
 664236171,
 -1,
 -54736,
 707674940,
 128391,
 -1,
 707725656,
 128279,
 707930766,
 664174725,
 -1,
 707996301,
 707865679,
 -1,
 708061788,
 707951243,
 -1,
 708127288,
 708035218,
 -1,
 -54730,
 708094197,
 6430,
 -54729,
 708139070,
 6412,
 -1,
 708188468,
 6411,
 708389436,
 708097367,
 -1,
 -54726,
 708359681,
 6426,
 -54725,
 708401214,
 6425,
 -1,
 708450612,
 6427,
 708651584,
 708334322,
 -1,
 -54722,
 708633535,
 6429,
 -54721,
 708663358,
 6404,
 -1,
 708712756,
 6403,
 708913730,
 708633460,
 6421,
 -1,
 708872488,
 6410,
 709044805,
 708878029,
 -1,
 -54716,
 708991038,
 6417,
 -1,
 709040436,
 6416,
 709241416,
 709003560,
 -1,
 -54713,
 709186369,
 6405,
 -1,
 709237044,
 6415,
 709438027,
 709193867,
 -1,
 -54710,
 709384254,
 6402,
 -1,
 709433652,
 6401,
 709634638,
 709390175,
 -1,
 -54707,
 709580862,
 6409,
 -1,
 709630260,
 6408,
 709831249,
 709572623,
 -1,
 -54704,
 709777470,
 6414,
 -1,
 709826868,
 6413,
 710027860,
 709766372,
 -1,
 -54701,
 709974078,
 6407,
 -1,
 710023476,
 6406,
 710224471,
 709961407,
 -1,
 -54698,
 710170686,
 6419,
 -1,
 710220084,
 6418,
 -54696,
 710204196,
 6424,
 -54695,
 710387957,
 6422,
 -54694,
 710443227,
 6420,
 -54693,
 710505622,
 6423,
 -1,
 710563902,
 6428,
 710748785,
 708031831,
 -1,
 710814312,
 710705638,
 -1,
 710879841,
 710773032,
 -1,
 -54688,
 710824769,
 6449,
 -1,
 710875444,
 6452,
 -54686,
 710853400,
 6451,
 -54685,
 711043317,
 6455,
 -54684,
 711106345,
 6453,
 -54683,
 711164123,
 6454,
 -54682,
 711226518,
 6456,
 -54681,
 711291101,
 6448,
 -1,
 711336334,
 6450,
 711535213,
 710763832,
 -1,
 -54678,
 711505420,
 6459,
 -54677,
 711559277,
 6457,
 -54676,
 711622227,
 6464,
 -1,
 711684657,
 6458,
 711917567,
 711511845,
 -1,
 -54673,
 711844724,
 6441,
 -54672,
 711908132,
 6443,
 -1,
 711960821,
 6442,
 712125053,
 710728232,
 -1,
 712190588,
 712050929,
 -1,
 712256118,
 712120628,
 6432,
 -54667,
 712232477,
 6438,
 -1,
 712270209,
 6436,
 712452728,
 712216721,
 6440,
 -1,
 712413329,
 6437,
 712583802,
 712392899,
 6439,
 -1,
 712523971,
 6435,
 -54661,
 712560157,
 6434,
 -1,
 712663425,
 6433,
 -1,
 712117889,
 6400,
 712911499,
 712063838,
 -1,
 712977025,
 712884882,
 -1,
 -54656,
 712957968,
 6472,
 -1,
 712990673,
 6473,
 713173636,
 712947031,
 -1,
 -54653,
 713125586,
 6476,
 -1,
 713181931,
 6477,
 713370247,
 713116903,
 -1,
 -54650,
 713333531,
 6474,
 -1,
 713387552,
 6475,
 -54648,
 713352842,
 6470,
 -54647,
 713528495,
 6471,
 -54646,
 713592024,
 6479,
 -1,
 713639181,
 6478,
 -54644,
 712878119,
 6469,
 -1,
 713771984,
 6468,
 -1,
 707947961,
 13007,
 714025678,
 707903851,
 -1,
 714091211,
 713980555,
 -1,
 714156702,
 714064530,
 -1,
 714222233,
 714118323,
 -1,
 714287768,
 714180891,
 -1,
 -54636,
 714262362,
 42232,
 -54635,
 714312050,
 42236,
 -54634,
 714371056,
 42237,
 -54633,
 714422278,
 42234,
 -1,
 714484442,
 42235,
 -1,
 714246552,
 42233,
 714746524,
 714192215,
 -1,
 -54629,
 714692670,
 42206,
 -1,
 714742068,
 42205,
 -54627,
 714692670,
 42197,
 -1,
 714873140,
 42196,
 715074209,
 714133021,
 42228,
 -54624,
 715020328,
 42230,
 -1,
 715079875,
 42229,
 715270820,
 715056573,
 -1,
 -54621,
 715216958,
 42211,
 -1,
 715266356,
 42212,
 715467431,
 715240791,
 -1,
 -54618,
 715413566,
 42219,
 -1,
 715462964,
 42210,
 715664042,
 715431629,
 -1,
 -54615,
 715610174,
 42194,
 -1,
 715659572,
 42193,
 715860652,
 715624593,
 42227,
 -1,
 715800771,
 42231,
 715991727,
 715819304,
 -1,
 -54610,
 715936577,
 42213,
 -1,
 715987252,
 42208,
 716188338,
 715944075,
 -1,
 -54607,
 716134462,
 42200,
 -1,
 716183860,
 42199,
 716384949,
 716134440,
 -1,
 -54604,
 716331070,
 42216,
 -1,
 716380468,
 42214,
 716581560,
 716329714,
 -1,
 -54601,
 716527678,
 42221,
 -1,
 716577076,
 42198,
 716778170,
 716521667,
 42224,
 -1,
 716754461,
 42225,
 716909245,
 716716047,
 -1,
 -54596,
 716891597,
 42204,
 -1,
 716904756,
 42195,
 717105856,
 716844260,
 -1,
 -54593,
 717051966,
 42203,
 -1,
 717101364,
 42202,
 717302466,
 717035828,
 42222,
 -1,
 717242563,
 42223,
 -54589,
 717284212,
 42220,
 -54588,
 717414948,
 42215,
 -54587,
 717478692,
 42218,
 -54586,
 717521115,
 42207,
 -54585,
 717583510,
 42209,
 -54584,
 717647741,
 42201,
 -54583,
 717709697,
 42226,
 -54582,
 717770044,
 42217,
 -1,
 717825780,
 42192,
 718077951,
 714057286,
 -1,
 -54579,
 717968097,
 42239,
 -1,
 718025657,
 42238,
 718220006,
 713970418,
 -1,
 718285541,
 718168260,
 -1,
 718351075,
 718209024,
 -1,
 718416600,
 718294247,
 -1,
 718482133,
 718379892,
 -1,
 -54572,
 718454665,
 128964,
 -1,
 718485479,
 11212,
 718733311,
 718433828,
 -1,
 -54569,
 718650939,
 128943,
 -1,
 718709729,
 128969,
 718875355,
 718389906,
 -1,
 -54566,
 718855264,
 128978,
 -1,
 718889071,
 128960,
 719071966,
 718845271,
 -1,
 -54563,
 719023849,
 128949,
 -1,
 719069026,
 128937,
 -54561,
 719052227,
 128910,
 -54560,
 719235418,
 128648,
 -54559,
 719280002,
 128930,
 -54558,
 719340856,
 128955,
 -1,
 719400952,
 128504,
 719650815,
 718310677,
 128498,
 -1,
 719520124,
 128497,
 -1,
 718218684,
 128626,
 719792872,
 718185966,
 128482,
 -1,
 719767444,
 128132,
 -54551,
 719775315,
 129422,
 -54550,
 719903411,
 8374,
 -1,
 719950900,
 129409,
 720121204,
 664082740,
 -1,
 720186708,
 720095357,
 -1,
 720252006,
 720155991,
 -1,
 720317523,
 720208315,
 -1,
 720383056,
 720272011,
 -1,
 720448276,
 720355986,
 -1,
 720513800,
 720424477,
 -1,
 720579335,
 720483070,
 -1,
 720644859,
 720539793,
 -1,
 720710392,
 720584899,
 7444,
 720830463,
 720636707,
 -1,
 -54537,
 720748734,
 43841,
 -1,
 720789261,
 43842,
 720972538,
 720635210,
 43843,
 -1,
 720899579,
 43844,
 -1,
 720937271,
 7432,
 721169150,
 720623107,
 -1,
 -54531,
 721114947,
 983627,
 -1,
 721165142,
 983628,
 721365760,
 721117569,
 7433,
 -1,
 721325835,
 42879,
 721496834,
 721311786,
 686,
 -1,
 721420458,
 687,
 -54525,
 721473711,
 43857,
 -54524,
 721594552,
 11385,
 -54523,
 721646668,
 42881,
 -54522,
 721703666,
 7543,
 -1,
 721755098,
 7426,
 -1,
 720535685,
 42871,
 722021132,
 720459816,
 -1,
 722086667,
 721983754,
 42853,
 -1,
 722012591,
 42855,
 -1,
 722013671,
 7546,
 722283280,
 721947427,
 -1,
 -54514,
 722240946,
 7541,
 -54513,
 722287379,
 11366,
 -1,
 722352005,
 566,
 -54511,
 722265533,
 42793,
 -54510,
 722513262,
 42795,
 -54509,
 722573061,
 7446,
 -1,
 722607419,
 11383,
 722807599,
 720418135,
 -1,
 722873116,
 722756440,
 -1,
 722938649,
 722833553,
 7441,
 -54504,
 722903382,
 7442,
 -1,
 722931195,
 7443,
 -54502,
 722914845,
 7453,
 -54501,
 723111146,
 7455,
 -1,
 723139299,
 7454,
 723331877,
 722808036,
 -1,
 723397409,
 723300924,
 -1,
 723462944,
 723363970,
 43851,
 -1,
 723389898,
 43852,
 -1,
 723407630,
 43830,
 723714047,
 723345756,
 -1,
 -54493,
 723627390,
 7573,
 -54492,
 723670851,
 983629,
 -1,
 723721046,
 983630,
 723921707,
 723258147,
 -1,
 -54489,
 723900451,
 983587,
 -54488,
 723960311,
 575,
 -54487,
 724017034,
 7562,
 -54486,
 724078855,
 42921,
 -1,
 724141490,
 7540,
 724314926,
 723851572,
 -1,
 -54483,
 724271115,
 42892,
 -1,
 724333170,
 43872,
 -1,
 724289738,
 43845,
 724577099,
 722747587,
 -1,
 724642626,
 724503331,
 -1,
 724708149,
 724621347,
 983567,
 724828159,
 724631618,
 -1,
 -54476,
 724719427,
 983569,
 -1,
 724769622,
 983571,
 724970296,
 724668979,
 -1,
 -54473,
 724944860,
 983597,
 -1,
 724966230,
 983595,
 725166907,
 724909153,
 -1,
 -54470,
 725141468,
 983601,
 -1,
 725162838,
 983599,
 725363518,
 725103070,
 -1,
 -54467,
 725319940,
 983573,
 -1,
 725364295,
 983575,
 -54465,
 725336254,
 583,
 -54464,
 725527934,
 7570,
 -54463,
 725585475,
 11384,
 -1,
 725635152,
 43828,
 725822277,
 724613264,
 -1,
 -54460,
 725790078,
 7576,
 -1,
 725852042,
 7563,
 726018888,
 725768217,
 -1,
 -54457,
 725972989,
 42787,
 -1,
 726034029,
 42789,
 -54455,
 726001354,
 7578,
 -54454,
 726188690,
 42859,
 -1,
 726240298,
 43836,
 726412133,
 724525441,
 -1,
 726477655,
 726370600,
 -1,
 726543188,
 726450613,
 -1,
 -54449,
 726516370,
 42887,
 -54448,
 726578519,
 42885,
 -54447,
 726640770,
 42883,
 -54446,
 726684402,
 7545,
 -54445,
 726748391,
 42876,
 -1,
 726808591,
 42874,
 727056383,
 726521788,
 -1,
 -54442,
 726962633,
 43840,
 -1,
 726998803,
 43876,
 727198561,
 726403875,
 -1,
 727264092,
 727137377,
 -1,
 -54438,
 727238620,
 983603,
 -54437,
 727275331,
 983602,
 -1,
 727325526,
 983578,
 727526239,
 727224895,
 -1,
 -54434,
 727500764,
 983607,
 -1,
 727522134,
 983605,
 -54432,
 727494014,
 7574,
 -1,
 727679255,
 983577,
 727853924,
 727161271,
 -1,
 -54429,
 727802831,
 43873,
 -1,
 727849394,
 7548,
 -1,
 727823703,
 42861,
 728116090,
 726388253,
 -1,
 728181621,
 728039424,
 -1,
 728247156,
 728161888,
 -1,
 728312684,
 728203531,
 -1,
 -54422,
 728287196,
 983623,
 -54421,
 728323907,
 983589,
 -1,
 728374102,
 983621,
 728574831,
 728282455,
 -1,
 -54418,
 728550318,
 42937,
 -1,
 728588119,
 43854,
 728771442,
 728535603,
 -1,
 -54415,
 728745948,
 983619,
 -1,
 728767318,
 983617,
 -54413,
 728739198,
 7577,
 -1,
 728922250,
 43858,
 -1,
 728180673,
 43855,
 -54410,
 728147448,
 7551,
 -54409,
 729125009,
 43875,
 -54408,
 729186437,
 42872,
 -54407,
 729244033,
 43856,
 -1,
 729301187,
 7531,
 729492365,
 728082562,
 -1,
 729557895,
 729415680,
 -1,
 729623430,
 729538139,
 -1,
 729688965,
 729546752,
 -1,
 -54401,
 729663452,
 983615,
 -54400,
 729727166,
 589,
 -54399,
 729784202,
 7561,
 -54398,
 729846023,
 42919,
 -54397,
 729908658,
 7538,
 -54396,
 729960282,
 7539,
 -1,
 730019380,
 43849,
 -1,
 729652196,
 43847,
 -1,
 729592823,
 42843,
 730344331,
 729500521,
 -1,
 730409866,
 730279140,
 8580,
 -1,
 730336232,
 42815,
 -1,
 730371937,
 7572,
 730660863,
 730321188,
 42869,
 -1,
 730531983,
 42845,
 730737570,
 729452689,
 -1,
 730803095,
 730702130,
 -1,
 730868630,
 730763409,
 -1,
 730934165,
 730794787,
 -1,
 -54382,
 730906814,
 43839,
 -54381,
 730967422,
 7575,
 -54380,
 731010883,
 983625,
 -1,
 731061078,
 983626,
 -1,
 730874051,
 43874,
 -1,
 730808756,
 7571,
 731392928,
 730729251,
 -1,
 731458460,
 731371555,
 983581,
 731578367,
 731381826,
 -1,
 -54373,
 731469635,
 983583,
 -1,
 731519830,
 983585,
 731774975,
 731413958,
 -1,
 -54370,
 731699975,
 11386,
 -54369,
 731748098,
 42829,
 -1,
 731810840,
 42827,
 -54367,
 731353233,
 42831,
 -1,
 731939935,
 42935,
 732113844,
 730667316,
 -1,
 732179372,
 732037120,
 -1,
 732244907,
 732159584,
 -1,
 732310440,
 732205619,
 -1,
 -54361,
 732284892,
 983593,
 -1,
 732306262,
 983591,
 -54359,
 732283070,
 11365,
 -54358,
 732474750,
 7567,
 -1,
 732528919,
 983565,
 -1,
 732212719,
 43825,
 732769198,
 732157432,
 42809,
 -1,
 732695712,
 42811,
 -54353,
 732750604,
 42813,
 -54352,
 732876317,
 42807,
 -54351,
 732926097,
 42805,
 -54350,
 732987303,
 7568,
 -54349,
 733036948,
 983624,
 -1,
 733092148,
 42803,
 733293509,
 732066892,
 -1,
 733359040,
 733219619,
 -1,
 733424569,
 733298031,
 -1,
 -54344,
 733382066,
 43832,
 -1,
 733423512,
 11361,
 -54342,
 733399004,
 983611,
 -54341,
 733588877,
 42894,
 -54340,
 733650826,
 7557,
 -54339,
 733709664,
 43833,
 -54338,
 733768437,
 43831,
 -54337,
 733830377,
 42825,
 -1,
 733886341,
 564,
 734079939,
 733320629,
 -1,
 -54334,
 734026985,
 7837,
 -1,
 734083859,
 7836,
 -54332,
 734056740,
 42866,
 -1,
 734218026,
 43829,
 734407638,
 733226687,
 -1,
 734473162,
 734360822,
 -1,
 734538697,
 734433425,
 43837,
 -1,
 734465531,
 43838,
 -1,
 734478531,
 43826,
 734735311,
 734402868,
 -1,
 734800846,
 734704683,
 -1,
 -54323,
 734740675,
 43827,
 -1,
 734797587,
 43824,
 -1,
 734771089,
 43853,
 735062995,
 734661411,
 -1,
 -54319,
 735027082,
 7552,
 -54318,
 735086002,
 7532,
 -1,
 735137872,
 42903,
 -54316,
 735032125,
 42823,
 -54315,
 735287894,
 7447,
 -1,
 735332840,
 42933,
 735521763,
 734385656,
 -1,
 735587292,
 735447843,
 -1,
 -54311,
 735555423,
 11377,
 -54310,
 735616906,
 7564,
 -54309,
 735656723,
 42847,
 -1,
 735721349,
 11380,
 735914976,
 735548135,
 -1,
 -54306,
 735891544,
 42911,
 -54305,
 735941065,
 42909,
 -1,
 735976410,
 42907,
 -54303,
 735896332,
 42849,
 -54302,
 736128201,
 42851,
 -1,
 736184023,
 42857,
 736373744,
 735459343,
 -1,
 736439273,
 736299811,
 -1,
 -54298,
 736403338,
 7553,
 -54297,
 736462258,
 7533,
 -54296,
 736517761,
 7569,
 -1,
 736573317,
 545,
 736766957,
 736399505,
 -1,
 736832492,
 736743314,
 43848,
 -1,
 736758669,
 43850,
 -1,
 736807165,
 567,
 -54290,
 736743716,
 42865,
 -54289,
 736970235,
 7839,
 -1,
 737027780,
 568,
 737225724,
 736308452,
 -1,
 737291253,
 737172556,
 43859,
 737411071,
 737217867,
 -1,
 -54284,
 737324967,
 43860,
 -1,
 737376456,
 43861,
 737553401,
 737217315,
 -1,
 -54281,
 737525950,
 572,
 -54280,
 737582986,
 42900,
 -1,
 737617816,
 42899,
 737815547,
 737529602,
 42797,
 -1,
 737741697,
 42799,
 -1,
 737776660,
 42863,
 738012167,
 737184040,
 -1,
 738077701,
 737938211,
 -1,
 738143233,
 738012388,
 -1,
 -54272,
 738120843,
 565,
 -1,
 738177967,
 43835,
 -54270,
 738107274,
 7559,
 -54269,
 738300167,
 42917,
 -54268,
 738362802,
 7536,
 -1,
 738409035,
 42897,
 -54266,
 738054436,
 42868,
 -1,
 738546466,
 983579,
 738733073,
 737968261,
 -1,
 738798605,
 738659107,
 -1,
 -54262,
 738772956,
 983613,
 -54261,
 738828170,
 7558,
 -54260,
 738887090,
 7535,
 -1,
 738932276,
 43834,
 739126288,
 738747177,
 -1,
 -54257,
 739104248,
 7933,
 -1,
 739147024,
 7931,
 -1,
 739103012,
 42867,
 739388441,
 738696966,
 -1,
 739453974,
 739358039,
 -1,
 739519509,
 739429294,
 7549,
 -1,
 739445167,
 42833,
 -1,
 739485813,
 42837,
 -54249,
 739417994,
 7560,
 -54248,
 739673522,
 7537,
 -1,
 739725392,
 42835,
 739912737,
 739340471,
 -1,
 739978268,
 739885246,
 42817,
 -1,
 739901523,
 42821,
 740109343,
 739915791,
 -1,
 -54242,
 740057633,
 42819,
 -1,
 740116884,
 11370,
 -54240,
 740073354,
 7556,
 -1,
 740266247,
 42915,
 740437034,
 739858472,
 -1,
 740502565,
 740398749,
 -1,
 -54236,
 740448067,
 983631,
 -1,
 740498262,
 983632,
 740699176,
 740428579,
 -1,
 -54233,
 740663178,
 42901,
 -1,
 740702795,
 11368,
 -54231,
 740640541,
 42791,
 -1,
 740826788,
 11382,
 741026866,
 740418072,
 -1,
 741092401,
 740982214,
 -1,
 741157936,
 741051404,
 43863,
 741277695,
 741081088,
 -1,
 -54225,
 741203740,
 43865,
 -1,
 741220398,
 43864,
 -1,
 741137146,
 43862,
 -1,
 741056394,
 7565,
 741551159,
 741008831,
 -1,
 -54220,
 741523959,
 576,
 -54219,
 741580682,
 7566,
 -54218,
 741639602,
 7542,
 -1,
 741685835,
 11372,
 741878845,
 741517010,
 -1,
 741944380,
 741804835,
 -1,
 -54214,
 741916932,
 42839,
 -54213,
 741957263,
 587,
 -1,
 742013715,
 42841,
 -1,
 741908178,
 569,
 742272067,
 741823218,
 -1,
 742337601,
 742198051,
 -1,
 -54208,
 742301578,
 7555,
 -1,
 742363399,
 42913,
 -54206,
 742293156,
 578,
 -1,
 742479934,
 983199,
 742665288,
 742253416,
 -1,
 742730823,
 742634839,
 -1,
 -54202,
 742706094,
 591,
 -1,
 742743895,
 43866,
 -1,
 742686311,
 7935,
 742992972,
 742608152,
 -1,
 -54198,
 742965438,
 42905,
 -54197,
 743022474,
 7554,
 -1,
 743081394,
 7534,
 743255119,
 742944609,
 -1,
 -54194,
 743227582,
 585,
 -1,
 743259248,
 983609,
 -1,
 743234325,
 11379,
 743571455,
 720317974,
 -1,
 -54190,
 743493238,
 7550,
 -1,
 743530981,
 7547,
 743768063,
 720293852,
 -1,
 743779414,
 743683415,
 8347,
 -1,
 743715015,
 8340,
 -54185,
 743760385,
 8339,
 -54184,
 743888376,
 7525,
 -54183,
 743951901,
 7524,
 -54182,
 744014482,
 8348,
 -54181,
 744073346,
 7523,
 -54180,
 744136397,
 8346,
 -54179,
 744198289,
 8338,
 -54178,
 744261928,
 8345,
 -54177,
 744325253,
 8344,
 -54176,
 744387660,
 8343,
 -54175,
 744452235,
 8342,
 -54174,
 744517471,
 11388,
 -54173,
 744579457,
 7522,
 -54172,
 744642600,
 8341,
 -54171,
 744702147,
 8337,
 -1,
 744757556,
 8336,
 744959267,
 720186902,
 -1,
 745024630,
 744931986,
 -1,
 745090161,
 745002138,
 -1,
 745155691,
 745019700,
 11375,
 -1,
 745111458,
 11376,
 -54164,
 745133560,
 581,
 -54163,
 745259666,
 42929,
 -54162,
 745305164,
 42880,
 -54161,
 745369739,
 42928,
 -54160,
 745433640,
 42878,
 -1,
 745494568,
 42893,
 745679987,
 745037618,
 42852,
 -1,
 745605551,
 42854,
 -54156,
 745661885,
 42792,
 -54155,
 745778542,
 42794,
 -1,
 745802706,
 574,
 746007690,
 744964291,
 -1,
 746073222,
 745933603,
 -1,
 746138748,
 746051619,
 983566,
 746258431,
 746061890,
 -1,
 -54149,
 746149699,
 983568,
 -1,
 746199894,
 983570,
 746400895,
 746099251,
 -1,
 -54146,
 746375132,
 983596,
 -1,
 746396502,
 983594,
 746597506,
 746339425,
 -1,
 -54143,
 746571740,
 983600,
 -1,
 746593110,
 983598,
 746794117,
 746533342,
 -1,
 -54140,
 746750212,
 983572,
 -1,
 746794567,
 983574,
 -1,
 746766526,
 582,
 747056265,
 746018841,
 -1,
 -54136,
 747010045,
 42786,
 -1,
 747071085,
 42788,
 -1,
 747029138,
 42858,
 747318424,
 745937204,
 -1,
 747383953,
 747244323,
 -1,
 747449487,
 747344435,
 -1,
 -54130,
 747423708,
 983592,
 -1,
 747445078,
 983590,
 -54128,
 747421886,
 570,
 -1,
 747602199,
 983564,
 747777171,
 747361784,
 42808,
 -1,
 747703456,
 42810,
 -54124,
 747758348,
 42812,
 -54123,
 747884061,
 42806,
 -54122,
 747933841,
 42804,
 -54121,
 747995042,
 11373,
 -1,
 748034356,
 42802,
 748235942,
 747266433,
 -1,
 748301472,
 748195587,
 -1,
 -54117,
 748274322,
 42886,
 -54116,
 748336471,
 42884,
 -54115,
 748398722,
 42882,
 -54114,
 748442354,
 42877,
 -54113,
 748506343,
 42875,
 -1,
 748566543,
 42873,
 748760229,
 748227363,
 -1,
 748825764,
 748720691,
 -1,
 -54109,
 748799964,
 983606,
 -1,
 748821334,
 983604,
 -1,
 748781847,
 983576,
 -1,
 748729687,
 42860,
 749153457,
 748205399,
 -1,
 749218987,
 749079331,
 -1,
 -54103,
 749197347,
 983586,
 -54102,
 749257207,
 11390,
 -1,
 749310215,
 42920,
 749481134,
 749175227,
 -1,
 -54099,
 749446876,
 586,
 -1,
 749481484,
 42926,
 -54097,
 749427311,
 7838,
 -54096,
 749614551,
 42924,
 -1,
 749674330,
 42891,
 749874366,
 749119618,
 -1,
 749939898,
 749797376,
 -1,
 750005433,
 749919840,
 -1,
 750070967,
 749978258,
 -1,
 -54090,
 750020028,
 983614,
 -1,
 750066989,
 11364,
 -54088,
 750043326,
 588,
 -1,
 750227719,
 42918,
 -1,
 749974519,
 42842,
 750464189,
 749882217,
 -1,
 -54084,
 750425946,
 42923,
 -1,
 750464266,
 42814,
 -1,
 750440755,
 42844,
 750726343,
 749852152,
 -1,
 750791875,
 750686951,
 -1,
 -54079,
 750768216,
 42910,
 -54078,
 750817737,
 42908,
 -1,
 750853082,
 42906,
 -54076,
 750773004,
 42848,
 -54075,
 751004873,
 42850,
 -54074,
 751060695,
 42856,
 -1,
 751111122,
 42846,
 751316178,
 750702111,
 -1,
 751381713,
 751296096,
 -1,
 751447245,
 751337739,
 -1,
 -54069,
 751421404,
 983622,
 -54068,
 751458115,
 983588,
 -1,
 751508310,
 983620,
 751709392,
 751407667,
 -1,
 -54065,
 751683548,
 983618,
 -1,
 751704918,
 983616,
 -1,
 751681726,
 42936,
 -1,
 751314840,
 580,
 752037085,
 751276177,
 -1,
 752102619,
 751962915,
 -1,
 752168152,
 752080931,
 983580,
 752287743,
 752091202,
 -1,
 -54057,
 752179011,
 983582,
 -1,
 752229206,
 983584,
 752484351,
 752123334,
 -1,
 -54054,
 752391938,
 42828,
 -1,
 752454680,
 42826,
 -54052,
 752062609,
 42830,
 -1,
 752583775,
 42934,
 752757989,
 751989878,
 -1,
 752823521,
 752690879,
 -1,
 -54048,
 752764407,
 42925,
 -1,
 752820757,
 573,
 -54046,
 752797660,
 983610,
 -54045,
 752977330,
 11362,
 -54044,
 753032425,
 42824,
 -1,
 753089927,
 11360,
 753282285,
 752692452,
 -1,
 753347816,
 753258242,
 42796,
 -1,
 753273729,
 42798,
 753478891,
 753273635,
 -1,
 -54038,
 753451198,
 571,
 -1,
 753477528,
 42898,
 -54036,
 753439764,
 42862,
 -1,
 753622092,
 42931,
 753806580,
 753234103,
 -1,
 753872112,
 753778878,
 42816,
 -1,
 753795155,
 42820,
 754003187,
 753809423,
 -1,
 -54030,
 753951265,
 42818,
 -1,
 754010516,
 11369,
 -1,
 753963271,
 42914,
 754265338,
 753770246,
 -1,
 754330873,
 754234711,
 -1,
 754396408,
 754305966,
 11363,
 -1,
 754321839,
 42832,
 -1,
 754362485,
 42836,
 -1,
 754274384,
 42834,
 754658561,
 754221189,
 -1,
 754724094,
 754606889,
 -1,
 -54019,
 754701816,
 7932,
 -1,
 754744592,
 7930,
 754974719,
 754649891,
 -1,
 -54016,
 754894812,
 983612,
 -1,
 754933366,
 11374,
 755117319,
 754604072,
 -1,
 755182853,
 755043107,
 -1,
 -54012,
 755129974,
 42922,
 -1,
 755186251,
 11367,
 -54010,
 755123997,
 42790,
 -1,
 755310244,
 11381,
 755510541,
 755050175,
 -1,
 755576075,
 755436323,
 -1,
 -54006,
 755548350,
 579,
 -1,
 755585104,
 42902,
 -54004,
 755544893,
 42822,
 -1,
 755714536,
 42932,
 755903761,
 755461985,
 -1,
 -54001,
 755877852,
 983608,
 -54000,
 755941566,
 584,
 -1,
 755971636,
 42930,
 756165909,
 755847922,
 -1,
 -53997,
 756121252,
 577,
 -53996,
 756176958,
 983198,
 -1,
 756223318,
 42912,
 756428056,
 756147647,
 -1,
 -53993,
 756400631,
 11391,
 -1,
 756431435,
 11371,
 756624667,
 756409192,
 -1,
 -53990,
 756596926,
 590,
 -1,
 756645479,
 7934,
 756821278,
 756590292,
 -1,
 -53987,
 756793604,
 42838,
 -1,
 756824851,
 42840,
 757017889,
 756779332,
 -1,
 -53984,
 756977927,
 42916,
 -1,
 757021259,
 42896,
 -53982,
 756996885,
 11378,
 -1,
 757157152,
 42904,
 757345611,
 744913547,
 -1,
 757411145,
 757314903,
 -1,
 757476680,
 757367249,
 -1,
 757542187,
 757449362,
 7451,
 757661695,
 757519514,
 -1,
 -53975,
 757573762,
 7450,
 -53974,
 757629061,
 43002,
 -1,
 757678275,
 11387,
 757869873,
 757508226,
 -1,
 757935407,
 757812073,
 -1,
 -53970,
 757901442,
 7449,
 -1,
 757958952,
 7438,
 -53968,
 757911844,
 42870,
 -1,
 758058426,
 43846,
 758263092,
 757829777,
 7439,
 -53965,
 758238749,
 7445,
 -1,
 758292822,
 7440,
 758459703,
 758202563,
 7431,
 -53962,
 758441671,
 7459,
 -1,
 758498713,
 7430,
 758656313,
 758389044,
 7424,
 -1,
 758595779,
 7425,
 -53958,
 758638013,
 7458,
 -53957,
 758766308,
 7457,
 -53956,
 758830584,
 7456,
 -53955,
 758894109,
 7452,
 -53954,
 758953303,
 42801,
 -53953,
 759015122,
 42927,
 -53952,
 759078605,
 7448,
 -53951,
 759136389,
 7437,
 -53950,
 759198846,
 7436,
 -53949,
 759263371,
 7435,
 -53948,
 759328607,
 7434,
 -53947,
 759385319,
 42800,
 -53946,
 759445519,
 7429,
 -53945,
 759508196,
 7428,
 -1,
 759572453,
 7427,
 -1,
 757426636,
 42895,
 -53942,
 757389759,
 7460,
 -1,
 759766350,
 7461,
 760020991,
 757286975,
 -1,
 760032591,
 759934410,
 -1,
 -53938,
 759996109,
 43004,
 -1,
 760040679,
 43003,
 760229202,
 759980417,
 -1,
 -53935,
 760188975,
 43005,
 -1,
 760218686,
 43006,
 -53933,
 760199837,
 42999,
 -1,
 760357474,
 43007,
 760556899,
 720152706,
 -1,
 760622434,
 760501397,
 -1,
 760687963,
 760582289,
 -1,
 760753498,
 760646353,
 -1,
 -53927,
 760721773,
 68415,
 -1,
 760757421,
 68413,
 -1,
 760719903,
 128310,
 761015646,
 760663390,
 -1,
 -53923,
 760983960,
 68414,
 -1,
 761019631,
 68412,
 761212257,
 760949447,
 -1,
 -53920,
 761150243,
 128311,
 -1,
 761213175,
 128309,
 -1,
 761179149,
 128308,
 -1,
 760570284,
 8382,
 761539948,
 760516775,
 -1,
 761605479,
 761492164,
 -1,
 -53914,
 761565319,
 3807,
 -1,
 761616066,
 3806,
 761802090,
 761548924,
 -1,
 -53911,
 761762836,
 983204,
 -1,
 761800320,
 983205,
 -53909,
 761770756,
 983206,
 -1,
 761953734,
 983207,
 762129775,
 761511753,
 -1,
 -53906,
 762109558,
 127772,
 -1,
 762167887,
 127767,
 762326386,
 762062527,
 -1,
 -53903,
 762267024,
 127991,
 -1,
 762315244,
 129404,
 -53901,
 762265772,
 128030,
 -1,
 762459670,
 129357,
 762654311,
 720060611,
 -1,
 762719738,
 762598026,
 -1,
 762785224,
 762698628,
 -1,
 762850715,
 762757778,
 -1,
 762916237,
 762818173,
 -1,
 762981772,
 762842830,
 -1,
 763047306,
 762913650,
 11104,
 763166719,
 762970112,
 -1,
 763178376,
 763092576,
 -1,
 763243904,
 763133502,
 -1,
 -53889,
 763220940,
 11172,
 -1,
 763248477,
 11174,
 763440515,
 763182447,
 -1,
 -53886,
 763418695,
 983237,
 -1,
 763453197,
 11130,
 -53884,
 763418762,
 129072,
 -53883,
 763595226,
 129056,
 -53882,
 763659263,
 129060,
 -53881,
 763714398,
 129068,
 -1,
 763767592,
 129064,
 -53879,
 763152654,
 11120,
 -1,
 763927914,
 11136,
 -53877,
 763010931,
 11140,
 -1,
 764033340,
 11114,
 -1,
 762904856,
 129168,
 764292506,
 762896630,
 -1,
 764358041,
 764224376,
 -1,
 764423576,
 764337760,
 -1,
 764489110,
 764396178,
 -1,
 764554645,
 764419373,
 11067,
 764674047,
 764480291,
 -1,
 -53868,
 764598343,
 11068,
 -1,
 764624522,
 11069,
 -1,
 764522117,
 11244,
 -53865,
 764467271,
 11060,
 -1,
 764821130,
 11061,
 -1,
 764367414,
 11062,
 -1,
 764332943,
 11063,
 -1,
 764253978,
 129186,
 765210034,
 762782584,
 -1,
 765275564,
 765189728,
 -1,
 765341092,
 765248146,
 -1,
 765406625,
 765291383,
 -1,
 -53856,
 765383628,
 11025,
 -1,
 765411165,
 11024,
 765657087,
 765336881,
 -1,
 -53853,
 765581383,
 11065,
 -1,
 765607562,
 11066,
 765799847,
 765312010,
 -1,
 -53850,
 765774520,
 129024,
 -1,
 765806696,
 129040,
 -53848,
 765759062,
 129176,
 -53847,
 765953050,
 129028,
 -53846,
 766014988,
 129032,
 -53845,
 766068840,
 129044,
 -1,
 766131521,
 11064,
 766324145,
 765205110,
 -1,
 766389680,
 766291377,
 -1,
 -53841,
 766363618,
 11083,
 -1,
 766385901,
 11074,
 -1,
 766320365,
 11082,
 -1,
 766297870,
 11070,
 766717368,
 765142719,
 -1,
 766782902,
 766670018,
 -1,
 -53835,
 766718344,
 11144,
 -1,
 766780274,
 11013,
 -53833,
 766745212,
 129184,
 -1,
 766909182,
 129192,
 767110587,
 766686551,
 -1,
 -53830,
 767076253,
 129080,
 -1,
 767107393,
 129104,
 767307198,
 767076482,
 -1,
 -53827,
 767267171,
 128620,
 -1,
 767321305,
 129190,
 767503809,
 767253318,
 -1,
 -53824,
 767439886,
 129088,
 -1,
 767501170,
 129092,
 767700420,
 767446247,
 -1,
 -53821,
 767669100,
 129194,
 -1,
 767715599,
 129076,
 -53819,
 767679779,
 129172,
 -53818,
 767862617,
 11077,
 -53817,
 767916319,
 129188,
 -1,
 767964174,
 129084,
 768159217,
 762707968,
 -1,
 768224724,
 768104510,
 -1,
 768290259,
 768178957,
 -1,
 768355794,
 768225527,
 129287,
 768475135,
 768281379,
 -1,
 768486864,
 768393874,
 -1,
 -53809,
 768466985,
 129285,
 -1,
 768499705,
 129284,
 -53807,
 768430406,
 129283,
 -1,
 768621646,
 129286,
 -1,
 768289372,
 11240,
 -1,
 768248412,
 128379,
 768945627,
 768190594,
 -1,
 769011162,
 768894097,
 -1,
 -53801,
 768990474,
 11012,
 -53800,
 769051390,
 11108,
 -53799,
 769111727,
 129112,
 -1,
 769141290,
 11020,
 -1,
 768941479,
 11788,
 769404384,
 768914775,
 -1,
 -53795,
 769380339,
 11778,
 -53794,
 769433853,
 128488,
 -53793,
 769483627,
 11814,
 -1,
 769527666,
 10181,
 769732069,
 769333556,
 -1,
 769797604,
 769700942,
 -1,
 -53789,
 769768544,
 11056,
 -1,
 769798493,
 11058,
 -1,
 769756254,
 128494,
 770059752,
 769704594,
 -1,
 -53785,
 770026049,
 11785,
 -1,
 770072447,
 128492,
 770256363,
 770012236,
 -1,
 -53782,
 770232462,
 128709,
 -1,
 770285066,
 11804,
 770452974,
 770194445,
 -1,
 -53779,
 770428801,
 11816,
 -1,
 770493449,
 11780,
 -53777,
 770433491,
 128398,
 -53776,
 770627566,
 11808,
 -1,
 770650813,
 9948,
 770899967,
 768085606,
 -1,
 770911735,
 770788687,
 -1,
 770977269,
 770884075,
 4054,
 -1,
 770903043,
 4056,
 -53770,
 770920308,
 129307,
 -1,
 771040035,
 1422,
 -53768,
 770885934,
 8294,
 -53767,
 771204163,
 128269,
 -1,
 771250646,
 9958,
 771436127,
 762683598,
 -1,
 771501617,
 771390091,
 -1,
 771567109,
 771474066,
 -1,
 771632640,
 771539602,
 -1,
 -53761,
 771577918,
 7246,
 -1,
 771627316,
 7245,
 771829251,
 771601751,
 -1,
 -53758,
 771774526,
 7192,
 -1,
 771823924,
 7191,
 -53756,
 771774526,
 7179,
 -1,
 771954996,
 7178,
 772156937,
 771530445,
 -1,
 -53753,
 772109462,
 7183,
 -53752,
 772167742,
 7184,
 -1,
 772217140,
 7182,
 772419085,
 772114728,
 -1,
 -53749,
 772399988,
 7177,
 -53748,
 772428609,
 7173,
 -1,
 772479284,
 7181,
 772681233,
 772370571,
 -1,
 -53745,
 772633750,
 7169,
 -53744,
 772692030,
 7170,
 -1,
 772741428,
 7168,
 772943381,
 772618255,
 -1,
 -53741,
 772924877,
 7193,
 -53740,
 772946078,
 7247,
 -1,
 773003572,
 7180,
 773205528,
 772912471,
 -1,
 -53737,
 773150782,
 7201,
 -1,
 773200180,
 7200,
 773402139,
 773161093,
 -1,
 -53734,
 773354646,
 7190,
 -1,
 773396788,
 7189,
 773598750,
 773347368,
 -1,
 -53731,
 773551254,
 7198,
 -1,
 773593396,
 7197,
 773795361,
 773542642,
 -1,
 -53728,
 773747862,
 7172,
 -1,
 773790004,
 7171,
 773991972,
 773737703,
 -1,
 -53725,
 773944470,
 7186,
 -1,
 773986612,
 7185,
 774188583,
 773926116,
 -1,
 -53722,
 774133822,
 7175,
 -1,
 774183220,
 7174,
 774385194,
 774121151,
 -1,
 -53719,
 774337686,
 7188,
 -1,
 774379828,
 7187,
 -53717,
 774366068,
 7194,
 -53716,
 774560548,
 7202,
 -53715,
 774624782,
 7199,
 -53714,
 774678773,
 7195,
 -53713,
 774730902,
 7196,
 -53712,
 774795133,
 7176,
 -1,
 774838580,
 7203,
 775040575,
 771439454,
 -1,
 775106101,
 775013010,
 -1,
 -53708,
 775086096,
 7234,
 -1,
 775118801,
 7235,
 775302712,
 775075159,
 -1,
 -53705,
 775253714,
 7238,
 -1,
 775310059,
 7239,
 775499323,
 775245031,
 -1,
 -53702,
 775461659,
 7236,
 -1,
 775515680,
 7237,
 -53700,
 775480970,
 7232,
 -53699,
 775656623,
 7233,
 -53698,
 775720152,
 7241,
 -1,
 775767309,
 7240,
 775958089,
 774976608,
 -1,
 776023618,
 775915816,
 7216,
 -1,
 776004756,
 7220,
 776154692,
 775975051,
 7213,
 -1,
 776085692,
 7221,
 -53691,
 776127122,
 7219,
 -53690,
 776251522,
 7218,
 -53689,
 776314573,
 7217,
 -53688,
 776372357,
 7214,
 -1,
 776434764,
 7215,
 776613457,
 775936624,
 -1,
 776678988,
 776588829,
 7210,
 -1,
 776654365,
 7211,
 776810062,
 776638609,
 7208,
 -1,
 776769681,
 7209,
 -53681,
 776757633,
 7207,
 -53680,
 776880323,
 7212,
 -1,
 776935916,
 7206,
 777137752,
 776578630,
 -1,
 777203286,
 777110162,
 -1,
 777268821,
 777173479,
 7231,
 -1,
 777191875,
 7230,
 -1,
 777198037,
 7227,
 -53673,
 777162853,
 7228,
 -1,
 777400157,
 7229,
 777650175,
 777106775,
 -1,
 777662044,
 777572133,
 -1,
 -53669,
 777642868,
 7204,
 -1,
 777693429,
 7205,
 777912319,
 777610552,
 -1,
 -53666,
 777824777,
 7222,
 -1,
 777883581,
 7223,
 778055266,
 771365975,
 -1,
 -53663,
 778036013,
 129388,
 -1,
 778044121,
 127811,
 -53661,
 778032952,
 127898,
 -53660,
 778213168,
 128006,
 -53659,
 778274654,
 127819,
 -53658,
 778326770,
 129461,
 -1,
 778386080,
 128210,
 778579620,
 762635020,
 -1,
 778645126,
 778514636,
 -1,
 778710636,
 778617490,
 66199,
 -53653,
 778683026,
 66200,
 -1,
 778721320,
 66185,
 778907246,
 778668328,
 66191,
 -1,
 778864936,
 66193,
 779038320,
 778862725,
 66190,
 -1,
 778993797,
 66192,
 779169394,
 778989707,
 66187,
 -1,
 779120779,
 66196,
 779300468,
 779108547,
 66177,
 -1,
 779258152,
 66202,
 779431542,
 779232959,
 66178,
 -1,
 779376680,
 66179,
 779562616,
 779360564,
 66176,
 -1,
 779520296,
 66201,
 -53639,
 779543997,
 66184,
 -53638,
 779674113,
 66204,
 -53637,
 779737828,
 66183,
 -53636,
 779800093,
 66194,
 -53635,
 779859287,
 66198,
 -53634,
 779921538,
 66197,
 -53633,
 779986642,
 66188,
 -53632,
 780050125,
 66195,
 -53631,
 780104780,
 66189,
 -53630,
 780169055,
 66186,
 -53629,
 780231041,
 66182,
 -53628,
 780294184,
 66203,
 -53627,
 780358386,
 66180,
 -1,
 780417039,
 66181,
 780611235,
 778582836,
 -1,
 780676770,
 780565131,
 -1,
 780742282,
 780649106,
 67887,
 -1,
 780714642,
 67892,
 780873356,
 780711255,
 67891,
 -1,
 780842327,
 67886,
 781004430,
 780831016,
 67883,
 -1,
 780962088,
 67896,
 781135504,
 780956748,
 67881,
 -1,
 781116172,
 67895,
 781266578,
 781074627,
 67876,
 -1,
 781224232,
 67894,
 781397652,
 781195572,
 67872,
 -1,
 781355304,
 67893,
 -53611,
 781378316,
 67879,
 -53610,
 781506040,
 67877,
 -53609,
 781569565,
 67888,
 -53608,
 781625474,
 67885,
 -53607,
 781690578,
 67890,
 -53606,
 781750417,
 67884,
 -53605,
 781811845,
 67882,
 -53604,
 781873291,
 67880,
 -53603,
 781934977,
 67878,
 -53602,
 781996786,
 67874,
 -53601,
 782060775,
 67889,
 -53600,
 782120975,
 67875,
 -53599,
 782183652,
 67897,
 -1,
 782247615,
 67873,
 -1,
 780651318,
 67903,
 -1,
 780560423,
 129317,
 782577346,
 778539153,
 -1,
 782642867,
 782555876,
 -1,
 782708399,
 782583937,
 -1,
 782773934,
 782661677,
 -1,
 782839467,
 782737101,
 -1,
 -53590,
 782780099,
 128393,
 -1,
 782835026,
 128396,
 -53588,
 782782738,
 128395,
 -53587,
 782972294,
 128397,
 -1,
 783034221,
 128394,
 -1,
 782741459,
 128318,
 783351807,
 782630912,
 -1,
 783363762,
 783249874,
 11847,
 -1,
 783289320,
 11848,
 -1,
 783297533,
 128261,
 783560376,
 782578206,
 128274,
 783625911,
 783509746,
 -1,
 -53578,
 783607434,
 983079,
 -1,
 783652015,
 983076,
 -1,
 783551745,
 128271,
 783888059,
 783537894,
 -1,
 -53574,
 783841924,
 128140,
 -1,
 783900533,
 127977,
 784084670,
 783846399,
 -1,
 -53571,
 784038411,
 11059,
 -1,
 784088049,
 10188,
 -53569,
 784060487,
 128557,
 -53568,
 784255133,
 129524,
 -53567,
 784301427,
 127853,
 -1,
 784346171,
 129438,
 784543431,
 782542978,
 -1,
 -53564,
 784502929,
 983225,
 -53563,
 784564357,
 983220,
 -53562,
 784621953,
 983230,
 -1,
 784679107,
 983222,
 -53560,
 784519310,
 129523,
 -53559,
 784823683,
 129433,
 -1,
 784878823,
 983065,
 785069426,
 664017204,
 -1,
 785133921,
 785025320,
 -1,
 785199442,
 785065346,
 -1,
 785264460,
 785125610,
 -1,
 785329892,
 785190877,
 -1,
 785395411,
 785258225,
 83070,
 -53551,
 785329380,
 83073,
 -53550,
 785393343,
 83072,
 -1,
 785455412,
 83071,
 785657559,
 785323096,
 83062,
 -53547,
 785591524,
 83065,
 -53546,
 785655487,
 83064,
 -1,
 785717556,
 83063,
 785919706,
 785585452,
 83066,
 -53543,
 785852095,
 83068,
 -1,
 785914164,
 83067,
 786116316,
 785846805,
 83059,
 -1,
 786045236,
 83060,
 786247390,
 786043114,
 83057,
 -1,
 786176308,
 83058,
 786378464,
 786173917,
 83055,
 -1,
 786307380,
 83056,
 -53535,
 786307202,
 83075,
 -53534,
 786438097,
 83074,
 -53533,
 786503201,
 83069,
 -1,
 786567994,
 83061,
 786771698,
 785256682,
 -1,
 786837224,
 786698205,
 83076,
 -53529,
 786769599,
 83078,
 -1,
 786831668,
 83077,
 787033834,
 786765100,
 83083,
 -1,
 786962740,
 83084,
 -53525,
 786962562,
 83088,
 -53524,
 787093457,
 83087,
 -53523,
 787158769,
 83086,
 -53522,
 787224097,
 83085,
 -53521,
 787289176,
 83082,
 -53520,
 787354426,
 83081,
 -53519,
 787419669,
 83080,
 -1,
 787484906,
 83079,
 787689214,
 786699066,
 -1,
 787754741,
 787617068,
 83105,
 -1,
 787683636,
 83106,
 -53514,
 787683458,
 83110,
 -53513,
 787814353,
 83109,
 -53512,
 787879665,
 83108,
 -53511,
 787944993,
 83107,
 -53510,
 788010072,
 83104,
 -53509,
 788075322,
 83103,
 -53508,
 788140565,
 83102,
 -53507,
 788205802,
 83101,
 -1,
 788271069,
 83100,
 788475658,
 787616277,
 -1,
 788541185,
 788403500,
 83094,
 -1,
 788470068,
 83095,
 -53502,
 788469890,
 83099,
 -53501,
 788600785,
 83098,
 -53500,
 788666097,
 83097,
 -53499,
 788731425,
 83096,
 -53498,
 788796504,
 83093,
 -53497,
 788861754,
 83092,
 -53496,
 788926997,
 83091,
 -53495,
 788992234,
 83090,
 -1,
 789057501,
 83089,
 789262101,
 788404354,
 -1,
 -53492,
 789190786,
 83170,
 -53491,
 789256145,
 83169,
 -53490,
 789321457,
 83168,
 -53489,
 789386785,
 83167,
 -53488,
 789452076,
 83166,
 -53487,
 789517400,
 83165,
 -53486,
 789582650,
 83164,
 -53485,
 789647893,
 83163,
 -53484,
 789713130,
 83162,
 -1,
 789778397,
 83161,
 789983008,
 789190609,
 -1,
 -53481,
 789911682,
 83160,
 -53480,
 789977041,
 83159,
 -53479,
 790042353,
 83158,
 -53478,
 790107681,
 83157,
 -53477,
 790172972,
 83156,
 -53476,
 790238296,
 83155,
 -53475,
 790303546,
 83154,
 -53474,
 790368789,
 83153,
 -53473,
 790434026,
 83152,
 -1,
 790499293,
 83151,
 790703915,
 789911281,
 -1,
 -53470,
 790632578,
 83150,
 -53469,
 790697937,
 83149,
 -53468,
 790763249,
 83148,
 -53467,
 790828577,
 83147,
 -53466,
 790893868,
 83146,
 -53465,
 790959192,
 83145,
 -53464,
 791024442,
 83144,
 -53463,
 791089685,
 83143,
 -53462,
 791154922,
 83142,
 -1,
 791220189,
 83141,
 791424822,
 790631969,
 -1,
 -53459,
 791353474,
 83140,
 -53458,
 791418833,
 83139,
 -53457,
 791484145,
 83138,
 -53456,
 791549473,
 83137,
 -53455,
 791614764,
 83136,
 -53454,
 791680088,
 83135,
 -53453,
 791745338,
 83134,
 -53452,
 791810581,
 83133,
 -53451,
 791875818,
 83132,
 -1,
 791941085,
 83131,
 792145729,
 791352620,
 -1,
 -53448,
 792074370,
 83130,
 -53447,
 792139729,
 83129,
 -53446,
 792205041,
 83128,
 -53445,
 792270369,
 83127,
 -53444,
 792335660,
 83126,
 -53443,
 792400984,
 83125,
 -53442,
 792466234,
 83124,
 -53441,
 792531477,
 83123,
 -53440,
 792596714,
 83122,
 -1,
 792661981,
 83121,
 792920063,
 792073304,
 -1,
 -53437,
 792795266,
 83120,
 -53436,
 792860625,
 83119,
 -53435,
 792925937,
 83118,
 -53434,
 792991265,
 83117,
 -53433,
 793056556,
 83116,
 -53432,
 793121880,
 83115,
 -53431,
 793187130,
 83114,
 -53430,
 793252373,
 83113,
 -53429,
 793317610,
 83112,
 -1,
 793382877,
 83111,
 793587659,
 785191738,
 -1,
 793653086,
 793514810,
 -1,
 793718610,
 793581089,
 83322,
 -53424,
 793652452,
 83325,
 -53423,
 793716415,
 83324,
 -1,
 793778484,
 83323,
 793980758,
 793645589,
 -1,
 -53420,
 793914596,
 83318,
 -53419,
 793978559,
 83317,
 -1,
 794040628,
 83316,
 -53417,
 793909378,
 83328,
 -53416,
 794171345,
 83327,
 -53415,
 794236657,
 83326,
 -53414,
 794301740,
 83321,
 -53413,
 794367064,
 83320,
 -53412,
 794432314,
 83319,
 -53411,
 794497258,
 83315,
 -1,
 794562525,
 83314,
 794767213,
 793581521,
 -1,
 794832737,
 794695201,
 83381,
 -1,
 794761524,
 83382,
 794963812,
 794759994,
 -1,
 -53405,
 794892596,
 83378,
 -1,
 794953825,
 83377,
 795160422,
 794890474,
 83374,
 -1,
 795089204,
 83375,
 -53401,
 795089026,
 83385,
 -53400,
 795219921,
 83384,
 -53399,
 795285233,
 83383,
 -53398,
 795350316,
 83380,
 -53397,
 795415640,
 83379,
 -53396,
 795480597,
 83376,
 -1,
 795545565,
 83373,
 795750266,
 794695201,
 -1,
 795815792,
 795678673,
 83359,
 -1,
 795744564,
 83360,
 795946866,
 795743320,
 83354,
 -1,
 795875636,
 83355,
 -53389,
 795875458,
 83361,
 -53388,
 796006129,
 83358,
 -53387,
 796071457,
 83357,
 -53386,
 796136748,
 83356,
 -53385,
 796201786,
 83353,
 -53384,
 796267029,
 83352,
 -53383,
 796332266,
 83351,
 -1,
 796397533,
 83350,
 796602246,
 795678449,
 -1,
 796667773,
 796528874,
 83363,
 -1,
 796596532,
 83364,
 -53378,
 796596354,
 83372,
 -53377,
 796727249,
 83371,
 -53376,
 796792561,
 83370,
 -53375,
 796857889,
 83369,
 -53374,
 796923180,
 83368,
 -53373,
 796988504,
 83367,
 -53372,
 797053754,
 83366,
 -53371,
 797118997,
 83365,
 -1,
 797183965,
 83362,
 797388690,
 796529964,
 -1,
 797454217,
 797317250,
 83348,
 -1,
 797382964,
 83349,
 -53366,
 797382609,
 83347,
 -53365,
 797513457,
 83346,
 -53364,
 797578785,
 83345,
 -53363,
 797644076,
 83344,
 -53362,
 797709400,
 83343,
 -53361,
 797774650,
 83342,
 -53360,
 797839893,
 83341,
 -53359,
 797905130,
 83340,
 -1,
 797970397,
 83339,
 798175134,
 797315605,
 -1,
 798240661,
 798103682,
 83312,
 -1,
 798169396,
 83313,
 -53354,
 798169041,
 83311,
 -53353,
 798299889,
 83310,
 -53352,
 798365217,
 83309,
 -53351,
 798430508,
 83308,
 -53350,
 798495832,
 83307,
 -53349,
 798561082,
 83306,
 -53348,
 798626325,
 83305,
 -53347,
 798691562,
 83304,
 -1,
 798756829,
 83303,
 798961578,
 798101469,
 -1,
 799027105,
 798890114,
 83291,
 -1,
 798955828,
 83292,
 -53342,
 798955473,
 83290,
 -53341,
 799086321,
 83289,
 -53340,
 799151649,
 83288,
 -53339,
 799216940,
 83287,
 -53338,
 799282264,
 83286,
 -53337,
 799347514,
 83285,
 -53336,
 799412757,
 83284,
 -53335,
 799477994,
 83283,
 -1,
 799543261,
 83282,
 799748021,
 798890114,
 -1,
 -53332,
 799676546,
 83395,
 -53331,
 799741905,
 83394,
 -53330,
 799807217,
 83393,
 -53329,
 799872545,
 83392,
 -53328,
 799937836,
 83391,
 -53327,
 800003160,
 83390,
 -53326,
 800068449,
 83389,
 -53325,
 800133653,
 83388,
 -53324,
 800198890,
 83387,
 -1,
 800264157,
 83386,
 800468928,
 799675480,
 -1,
 -53321,
 800397442,
 83338,
 -53320,
 800462801,
 83337,
 -53319,
 800528113,
 83336,
 -53318,
 800593441,
 83335,
 -53317,
 800658732,
 83334,
 -53316,
 800724056,
 83333,
 -53315,
 800789306,
 83332,
 -53314,
 800854549,
 83331,
 -53313,
 800919786,
 83330,
 -1,
 800985053,
 83329,
 801243135,
 800395498,
 -1,
 -53310,
 801118338,
 83302,
 -53309,
 801183697,
 83301,
 -53308,
 801249009,
 83300,
 -53307,
 801314337,
 83299,
 -53306,
 801379628,
 83298,
 -53305,
 801444952,
 83297,
 -53304,
 801510202,
 83296,
 -53303,
 801575445,
 83295,
 -53302,
 801640682,
 83294,
 -1,
 801705949,
 83293,
 801910853,
 793514517,
 -1,
 801976283,
 801837021,
 -1,
 802041808,
 801903125,
 83173,
 -53297,
 801973951,
 83175,
 -1,
 802036020,
 83174,
 802238418,
 801970306,
 83183,
 -1,
 802167092,
 83184,
 802369492,
 802166513,
 83180,
 -1,
 802298164,
 83181,
 -53291,
 802297809,
 83182,
 -53290,
 802428449,
 83179,
 -53289,
 802493740,
 83178,
 -53288,
 802559064,
 83177,
 -53287,
 802624314,
 83176,
 -53286,
 802689258,
 83172,
 -1,
 802754525,
 83171,
 802959336,
 801904770,
 -1,
 803024862,
 802887810,
 83280,
 -1,
 802953524,
 83281,
 803155936,
 802952280,
 83274,
 -1,
 803084596,
 83275,
 -53279,
 803084241,
 83279,
 -53278,
 803215089,
 83278,
 -53277,
 803280417,
 83277,
 -53276,
 803345708,
 83276,
 -53275,
 803410746,
 83273,
 -53274,
 803475989,
 83272,
 -53273,
 803541226,
 83271,
 -1,
 803606493,
 83270,
 803811317,
 802885866,
 -1,
 803876843,
 803739169,
 83192,
 -1,
 803805492,
 83193,
 804007917,
 803804460,
 83190,
 -1,
 803936564,
 83191,
 -53266,
 803936386,
 83196,
 -53265,
 804067281,
 83195,
 -53264,
 804132593,
 83194,
 -53263,
 804197464,
 83189,
 -53262,
 804262714,
 83188,
 -53261,
 804327957,
 83187,
 -53260,
 804393194,
 83186,
 -1,
 804458461,
 83185,
 804663297,
 803739601,
 -1,
 804728824,
 804591746,
 83268,
 -1,
 804657460,
 83269,
 -53255,
 804657105,
 83267,
 -53254,
 804787953,
 83266,
 -53253,
 804853281,
 83265,
 -53252,
 804918572,
 83264,
 -53251,
 804983896,
 83263,
 -53250,
 805049146,
 83262,
 -53249,
 805114389,
 83261,
 -53248,
 805179626,
 83260,
 -1,
 805244893,
 83259,
 805449741,
 804591137,
 -1,
 805515268,
 805377777,
 83245,
 -1,
 805443892,
 83246,
 -53243,
 805443714,
 83248,
 -53242,
 805574609,
 83247,
 -53241,
 805639713,
 83244,
 -53240,
 805705004,
 83243,
 -53239,
 805770328,
 83242,
 -53238,
 805835578,
 83241,
 -53237,
 805900821,
 83240,
 -53236,
 805966058,
 83239,
 -1,
 806031325,
 83238,
 806236185,
 805376533,
 -1,
 806301712,
 806164209,
 83204,
 -1,
 806230324,
 83205,
 -53231,
 806230146,
 83207,
 -53230,
 806361041,
 83206,
 -53229,
 806426145,
 83203,
 -53228,
 806491436,
 83202,
 -53227,
 806556760,
 83201,
 -53226,
 806622010,
 83200,
 -53225,
 806687253,
 83199,
 -53224,
 806752490,
 83198,
 -1,
 806817757,
 83197,
 807022628,
 806164209,
 -1,
 -53221,
 806951042,
 83258,
 -53220,
 807016401,
 83257,
 -53219,
 807081713,
 83256,
 -53218,
 807147041,
 83255,
 -53217,
 807212332,
 83254,
 -53216,
 807277656,
 83253,
 -53215,
 807342906,
 83252,
 -53214,
 807408149,
 83251,
 -53213,
 807473386,
 83250,
 -1,
 807538653,
 83249,
 807743535,
 806950188,
 -1,
 -53210,
 807671938,
 83237,
 -53209,
 807737297,
 83236,
 -53208,
 807802609,
 83235,
 -53207,
 807867937,
 83234,
 -53206,
 807933228,
 83233,
 -53205,
 807998552,
 83232,
 -53204,
 808063802,
 83231,
 -53203,
 808129045,
 83230,
 -53202,
 808194282,
 83229,
 -1,
 808259549,
 83228,
 808464442,
 807670872,
 -1,
 -53199,
 808392834,
 83227,
 -53198,
 808458193,
 83226,
 -53197,
 808523505,
 83225,
 -53196,
 808588833,
 83224,
 -53195,
 808654124,
 83223,
 -53194,
 808719448,
 83222,
 -53193,
 808784698,
 83221,
 -53192,
 808849941,
 83220,
 -53191,
 808915178,
 83219,
 -1,
 808980445,
 83218,
 809238527,
 808391482,
 -1,
 -53188,
 809113730,
 83217,
 -53187,
 809179089,
 83216,
 -53186,
 809244401,
 83215,
 -53185,
 809309729,
 83214,
 -53184,
 809375020,
 83213,
 -53183,
 809440344,
 83212,
 -53182,
 809505594,
 83211,
 -53181,
 809570837,
 83210,
 -53180,
 809636074,
 83209,
 -1,
 809701341,
 83208,
 809906367,
 801837021,
 -1,
 809971797,
 809833560,
 -1,
 810037322,
 809899553,
 82994,
 -53175,
 809969343,
 82996,
 -1,
 810031412,
 82995,
 810233932,
 809964844,
 82992,
 -1,
 810162484,
 82993,
 810365006,
 810160362,
 82987,
 -1,
 810293556,
 82988,
 -53169,
 810293378,
 82999,
 -53168,
 810424273,
 82998,
 -53167,
 810489585,
 82997,
 -53166,
 810554456,
 82991,
 -53165,
 810619706,
 82990,
 -53164,
 810684949,
 82989,
 -1,
 810749917,
 82986,
 810954851,
 809899553,
 -1,
 811020378,
 810882593,
 83016,
 -53160,
 810953956,
 83019,
 -53159,
 811017919,
 83018,
 -1,
 811079988,
 83017,
 -53157,
 810948738,
 83022,
 -53156,
 811210705,
 83021,
 -53155,
 811276017,
 83020,
 -53154,
 811341100,
 83015,
 -53153,
 811406424,
 83014,
 -53152,
 811471674,
 83013,
 -53151,
 811536917,
 83012,
 -53150,
 811602154,
 83011,
 -1,
 811667421,
 83010,
 811872368,
 810883202,
 -1,
 811937894,
 811800529,
 83052,
 -1,
 811866420,
 83053,
 812068968,
 811865841,
 83050,
 -1,
 811997492,
 83051,
 -53143,
 811997314,
 83054,
 -53142,
 812127777,
 83049,
 -53141,
 812193068,
 83048,
 -53140,
 812258392,
 83047,
 -53139,
 812323642,
 83046,
 -53138,
 812388885,
 83045,
 -53137,
 812454122,
 83044,
 -1,
 812519389,
 83043,
 812724348,
 811799354,
 -1,
 812789875,
 812652674,
 82984,
 -1,
 812718388,
 82985,
 -53132,
 812718033,
 82983,
 -53131,
 812848881,
 82982,
 -53130,
 812914209,
 82981,
 -53129,
 812979500,
 82980,
 -53128,
 813044824,
 82979,
 -53127,
 813110074,
 82978,
 -53126,
 813175317,
 82977,
 -53125,
 813240554,
 82976,
 -1,
 813305821,
 82975,
 813510792,
 812651029,
 -1,
 813576319,
 813438497,
 82970,
 -1,
 813504820,
 82971,
 -53120,
 813504642,
 82974,
 -53119,
 813635537,
 82973,
 -53118,
 813700849,
 82972,
 -53117,
 813765932,
 82969,
 -53116,
 813831256,
 82968,
 -53115,
 813896506,
 82967,
 -53114,
 813961749,
 82966,
 -53113,
 814026986,
 82965,
 -1,
 814092253,
 82964,
 814297236,
 813437162,
 -1,
 814362763,
 814223325,
 82953,
 -1,
 814291252,
 82954,
 -53108,
 814291074,
 82963,
 -53107,
 814421969,
 82962,
 -53106,
 814487281,
 82961,
 -53105,
 814552609,
 82960,
 -53104,
 814617900,
 82959,
 -53103,
 814683224,
 82958,
 -53102,
 814748474,
 82957,
 -53101,
 814813717,
 82956,
 -1,
 814878954,
 82955,
 815083679,
 814225361,
 -1,
 -53098,
 815011970,
 83042,
 -53097,
 815077329,
 83041,
 -53096,
 815142641,
 83040,
 -53095,
 815207969,
 83039,
 -53094,
 815273260,
 83038,
 -53093,
 815338584,
 83037,
 -53092,
 815403834,
 83036,
 -53091,
 815469077,
 83035,
 -53090,
 815534314,
 83034,
 -1,
 815599581,
 83033,
 815804586,
 815011569,
 -1,
 -53087,
 815732866,
 83032,
 -53086,
 815798225,
 83031,
 -53085,
 815863537,
 83030,
 -53084,
 815928865,
 83029,
 -53083,
 815994156,
 83028,
 -53082,
 816059480,
 83027,
 -53081,
 816124730,
 83026,
 -53080,
 816189973,
 83025,
 -53079,
 816255210,
 83024,
 -1,
 816320477,
 83023,
 816525493,
 815732012,
 -1,
 -53076,
 816453762,
 83009,
 -53075,
 816519121,
 83008,
 -53074,
 816584433,
 83007,
 -53073,
 816649761,
 83006,
 -53072,
 816715052,
 83005,
 -53071,
 816780376,
 83004,
 -53070,
 816845626,
 83003,
 -53069,
 816910869,
 83002,
 -53068,
 816976106,
 83001,
 -1,
 817041373,
 83000,
 817299455,
 816451549,
 -1,
 -53065,
 817174658,
 82952,
 -53064,
 817240017,
 82951,
 -53063,
 817305329,
 82950,
 -53062,
 817370657,
 82949,
 -53061,
 817435948,
 82948,
 -53060,
 817501272,
 82947,
 -53059,
 817566522,
 82946,
 -53058,
 817631765,
 82945,
 -1,
 817697002,
 82944,
 817901872,
 809833560,
 -1,
 817967309,
 817829164,
 -1,
 818032835,
 817895153,
 83455,
 -1,
 817961268,
 83456,
 818163909,
 817958877,
 83447,
 -1,
 818092340,
 83448,
 -53050,
 818092162,
 83458,
 -53049,
 818223057,
 83457,
 -53048,
 818288161,
 83454,
 -53047,
 818353452,
 83453,
 -53046,
 818418776,
 83452,
 -53045,
 818484026,
 83451,
 -53044,
 818549269,
 83450,
 -1,
 818614506,
 83449,
 818819290,
 817893610,
 -1,
 818884817,
 818745309,
 -1,
 -53040,
 818813241,
 83407,
 -1,
 818872659,
 83406,
 -53038,
 818813058,
 83416,
 -53037,
 819009489,
 83415,
 -53036,
 819074801,
 83414,
 -53035,
 819140129,
 83413,
 -53034,
 819205420,
 83412,
 -53033,
 819270744,
 83411,
 -53032,
 819335994,
 83410,
 -53031,
 819401237,
 83409,
 -1,
 819466474,
 83408,
 819671269,
 818747345,
 -1,
 -53028,
 819599490,
 83488,
 -53027,
 819664849,
 83487,
 -53026,
 819730161,
 83486,
 -53025,
 819795489,
 83485,
 -53024,
 819860780,
 83484,
 -53023,
 819926104,
 83483,
 -53022,
 819991354,
 83482,
 -53021,
 820056597,
 83481,
 -53020,
 820121834,
 83480,
 -1,
 820187101,
 83479,
 820392176,
 819599089,
 -1,
 -53017,
 820320386,
 83478,
 -53016,
 820385745,
 83477,
 -53015,
 820451057,
 83476,
 -53014,
 820516385,
 83475,
 -53013,
 820581676,
 83474,
 -53012,
 820647000,
 83473,
 -53011,
 820712250,
 83472,
 -53010,
 820777493,
 83471,
 -53009,
 820842730,
 83470,
 -1,
 820907997,
 83469,
 821113083,
 820319777,
 -1,
 -53006,
 821041282,
 83468,
 -53005,
 821106641,
 83467,
 -53004,
 821171953,
 83466,
 -53003,
 821237281,
 83465,
 -53002,
 821302572,
 83464,
 -53001,
 821367896,
 83463,
 -53000,
 821433146,
 83462,
 -52999,
 821498389,
 83461,
 -52998,
 821563626,
 83460,
 -1,
 821628893,
 83459,
 821833990,
 821040216,
 -1,
 -52995,
 821762178,
 83446,
 -52994,
 821827537,
 83445,
 -52993,
 821892849,
 83444,
 -52992,
 821958177,
 83443,
 -52991,
 822023468,
 83442,
 -52990,
 822088792,
 83441,
 -52989,
 822154042,
 83440,
 -52988,
 822219285,
 83439,
 -52987,
 822284522,
 83438,
 -1,
 822349789,
 83437,
 822554897,
 821760826,
 -1,
 -52984,
 822483074,
 83436,
 -52983,
 822548433,
 83435,
 -52982,
 822613745,
 83434,
 -52981,
 822679073,
 83433,
 -52980,
 822744364,
 83432,
 -52979,
 822809688,
 83431,
 -52978,
 822874938,
 83430,
 -52977,
 822940181,
 83429,
 -52976,
 823005418,
 83428,
 -1,
 823070685,
 83427,
 823275804,
 822481429,
 -1,
 -52973,
 823203970,
 83426,
 -52972,
 823269329,
 83425,
 -52971,
 823334641,
 83424,
 -52970,
 823399969,
 83423,
 -52969,
 823465260,
 83422,
 -52968,
 823530584,
 83421,
 -52967,
 823595834,
 83420,
 -52966,
 823661077,
 83419,
 -52965,
 823726314,
 83418,
 -1,
 823791581,
 83417,
 823996711,
 823201757,
 -1,
 -52962,
 823924866,
 83405,
 -52961,
 823990225,
 83404,
 -52960,
 824055537,
 83403,
 -52959,
 824120865,
 83402,
 -52958,
 824186156,
 83401,
 -52957,
 824251480,
 83400,
 -52956,
 824316730,
 83399,
 -52955,
 824381973,
 83398,
 -52954,
 824447210,
 83397,
 -1,
 824512477,
 83396,
 824770559,
 823924866,
 -1,
 -52951,
 824645361,
 83496,
 -52950,
 824710689,
 83495,
 -52949,
 824775980,
 83494,
 -52948,
 824841304,
 83493,
 -52947,
 824906554,
 83492,
 -52946,
 824971797,
 83491,
 -52945,
 825037034,
 83490,
 -1,
 825102301,
 83489,
 825360383,
 817829164,
 -1,
 825372988,
 825233941,
 -1,
 -52941,
 825301122,
 83525,
 -52940,
 825366481,
 83524,
 -52939,
 825431793,
 83523,
 -52938,
 825497121,
 83522,
 -52937,
 825562412,
 83521,
 -52936,
 825627736,
 83520,
 -52935,
 825692986,
 83519,
 -52934,
 825758229,
 83518,
 -52933,
 825823466,
 83517,
 -1,
 825888733,
 83516,
 826093895,
 825299178,
 -1,
 -52930,
 826022018,
 83515,
 -52929,
 826087377,
 83514,
 -52928,
 826152689,
 83513,
 -52927,
 826218017,
 83512,
 -52926,
 826283308,
 83511,
 -52925,
 826348632,
 83510,
 -52924,
 826413882,
 83509,
 -52923,
 826479125,
 83508,
 -52922,
 826544362,
 83507,
 -1,
 826609629,
 83506,
 826814801,
 826019805,
 -1,
 -52919,
 826742914,
 83505,
 -52918,
 826808273,
 83504,
 -52917,
 826873585,
 83503,
 -52916,
 826938913,
 83502,
 -52915,
 827004204,
 83501,
 -52914,
 827069528,
 83500,
 -52913,
 827134778,
 83499,
 -52912,
 827200021,
 83498,
 -1,
 827265258,
 83497,
 -1,
 826741813,
 83526,
 827535708,
 785171090,
 128028,
 827601243,
 827482856,
 -1,
 827666778,
 827575021,
 -1,
 -52906,
 827640211,
 11151,
 -52905,
 827699183,
 11148,
 -52904,
 827758401,
 11119,
 -52903,
 827816147,
 11150,
 -1,
 827861873,
 11149,
 -1,
 827604865,
 128260,
 -1,
 827541303,
 128246,
 828191072,
 827478770,
 -1,
 -52898,
 828166327,
 128551,
 -52897,
 828224817,
 128544,
 -1,
 828262581,
 128162,
 -1,
 828125322,
 9875,
 828519242,
 785098882,
 -1,
 828584770,
 828447339,
 -1,
 828650300,
 828506112,
 -1,
 828715555,
 828604635,
 -1,
 828781088,
 828687857,
 -1,
 828846479,
 828717071,
 -1,
 828912012,
 828805265,
 -1,
 828977543,
 828886977,
 -1,
 829043055,
 828949138,
 -1,
 829108589,
 828987432,
 -1,
 -52884,
 829047994,
 126646,
 -1,
 829103649,
 126648,
 -52882,
 829047994,
 126645,
 -1,
 829234409,
 126632,
 829436275,
 829011287,
 -1,
 -52879,
 829381536,
 126644,
 -52878,
 829441022,
 126638,
 -1,
 829496181,
 126641,
 829698422,
 829416909,
 -1,
 -52875,
 829646445,
 126630,
 -1,
 829708328,
 126650,
 829895033,
 829634718,
 -1,
 -52872,
 829846604,
 126627,
 -1,
 829896719,
 126649,
 -52870,
 829875213,
 126633,
 -52869,
 830069770,
 126629,
 -52868,
 830123191,
 126643,
 -52867,
 830187257,
 126642,
 -52866,
 830246356,
 126637,
 -52865,
 830309428,
 126636,
 -52864,
 830371194,
 126635,
 -52863,
 830435962,
 126647,
 -52862,
 830500794,
 126626,
 -52861,
 830560373,
 126631,
 -52860,
 830625143,
 126651,
 -52859,
 830688717,
 126640,
 -52858,
 830744723,
 126625,
 -1,
 830807374,
 126639,
 831062015,
 828950774,
 -1,
 -52855,
 830973689,
 126495,
 -52854,
 831032788,
 126493,
 -52853,
 831081933,
 126494,
 -1,
 831137939,
 126492,
 831389695,
 828840244,
 -1,
 -52850,
 831288396,
 126467,
 -1,
 831338511,
 126489,
 831533492,
 828798028,
 -1,
 831599027,
 831493837,
 -1,
 831664535,
 831570578,
 -1,
 831730069,
 831608872,
 -1,
 -52844,
 831669434,
 126614,
 -1,
 831725089,
 126616,
 -52842,
 831669434,
 126613,
 -1,
 831855849,
 126600,
 832057755,
 831632727,
 -1,
 -52839,
 832002976,
 126612,
 -52838,
 832062462,
 126606,
 -1,
 832117621,
 126609,
 832319902,
 832038349,
 -1,
 -52835,
 832267885,
 126598,
 -1,
 832329768,
 126618,
 832516513,
 832264232,
 -1,
 -52832,
 832455866,
 126596,
 -1,
 832511209,
 126599,
 832713124,
 832452766,
 -1,
 -52829,
 832664652,
 126595,
 -1,
 832714767,
 126617,
 832909735,
 832641332,
 -1,
 -52826,
 832862205,
 126592,
 -1,
 832923245,
 126607,
 -52824,
 832889869,
 126601,
 -52823,
 833084426,
 126597,
 -52822,
 833137847,
 126611,
 -52821,
 833201913,
 126610,
 -52820,
 833261012,
 126605,
 -52819,
 833324084,
 126604,
 -52818,
 833385850,
 126603,
 -52817,
 833450618,
 126615,
 -52816,
 833515450,
 126594,
 -52815,
 833574263,
 126619,
 -52814,
 833637837,
 126608,
 -1,
 833693843,
 126593,
 -1,
 831528809,
 126475,
 833958358,
 831501655,
 -1,
 834023891,
 833931916,
 -1,
 834089402,
 833995410,
 -1,
 -52808,
 834034597,
 126582,
 -52807,
 834094266,
 126581,
 -1,
 834149609,
 126568,
 834351550,
 834057559,
 -1,
 -52804,
 834296736,
 126580,
 -52803,
 834356222,
 126574,
 -1,
 834411381,
 126577,
 834613699,
 834287631,
 -1,
 834679234,
 834574901,
 -1,
 -52799,
 834620877,
 126590,
 -1,
 834676883,
 126588,
 -1,
 834607989,
 126585,
 834941382,
 834564235,
 -1,
 -52795,
 834885749,
 126583,
 -1,
 834935895,
 126570,
 835137993,
 834885672,
 -1,
 -52792,
 835077306,
 126564,
 -1,
 835132649,
 126567,
 -52790,
 835118544,
 126586,
 -52789,
 835314701,
 126569,
 -52788,
 835364601,
 126578,
 -52787,
 835423700,
 126573,
 -52786,
 835486772,
 126572,
 -52785,
 835547066,
 126562,
 -52784,
 835605879,
 126587,
 -52783,
 835669453,
 126576,
 -52782,
 835725459,
 126561,
 -1,
 835788110,
 126575,
 -52780,
 833969056,
 126484,
 -52779,
 835929086,
 126478,
 -1,
 835984245,
 126481,
 836186607,
 833907043,
 -1,
 836252123,
 836154711,
 -1,
 -52775,
 836197280,
 126516,
 -52774,
 836256766,
 126510,
 -1,
 836311925,
 126513,
 836514270,
 836223634,
 -1,
 -52771,
 836459429,
 126518,
 -1,
 836519098,
 126517,
 836710881,
 836464779,
 -1,
 -52768,
 836655221,
 126519,
 -1,
 836705367,
 126506,
 836907492,
 836655144,
 -1,
 -52765,
 836846778,
 126500,
 -1,
 836902121,
 126503,
 -52763,
 836887565,
 126505,
 -52762,
 837068537,
 126514,
 -52761,
 837127636,
 126509,
 -52760,
 837190708,
 126508,
 -52759,
 837252474,
 126507,
 -52758,
 837316538,
 126498,
 -52757,
 837375351,
 126523,
 -52756,
 837438925,
 126512,
 -52755,
 837499083,
 126521,
 -52754,
 837560467,
 126497,
 -1,
 837623118,
 126511,
 837825033,
 836158098,
 -1,
 837890565,
 837753140,
 -1,
 837956100,
 837838310,
 -1,
 838021622,
 837924183,
 -1,
 -52748,
 837966752,
 126548,
 -52747,
 838026238,
 126542,
 -1,
 838081397,
 126545,
 838283771,
 837957647,
 -1,
 838349306,
 838244917,
 -1,
 -52743,
 838313721,
 126559,
 -1,
 838372820,
 126557,
 -1,
 838278005,
 126553,
 -52740,
 838263821,
 126537,
 -52739,
 838575865,
 126546,
 -52738,
 838634964,
 126541,
 -52737,
 838694266,
 126539,
 -52736,
 838759034,
 126551,
 -52735,
 838823866,
 126530,
 -52734,
 838883445,
 126535,
 -52733,
 838948215,
 126555,
 -1,
 838999374,
 126543,
 -1,
 837900328,
 126472,
 839266824,
 837834792,
 -1,
 -52729,
 839206074,
 126486,
 -1,
 839261729,
 126488,
 -1,
 839206074,
 126485,
 839528972,
 837805517,
 -1,
 -52725,
 839476845,
 126470,
 -1,
 839538728,
 126490,
 839725583,
 839489449,
 -1,
 -52722,
 839681092,
 126704,
 -1,
 839735417,
 126705,
 839922194,
 839676043,
 -1,
 -52719,
 839866485,
 126487,
 -1,
 839916631,
 126474,
 840118805,
 839850292,
 -1,
 -52716,
 840071165,
 126464,
 -1,
 840132205,
 126479,
 -52714,
 840098829,
 126473,
 -52713,
 840293386,
 126469,
 -52712,
 840346807,
 126483,
 -52711,
 840410873,
 126482,
 -52710,
 840469972,
 126477,
 -52709,
 840533044,
 126476,
 -52708,
 840593338,
 126466,
 -52707,
 840652917,
 126471,
 -52706,
 840717687,
 126491,
 -52705,
 840781261,
 126480,
 -1,
 840837267,
 126465,
 841089023,
 828748483,
 -1,
 -52702,
 841005736,
 2303,
 -1,
 841059812,
 1624,
 841233075,
 828666956,
 -1,
 841298610,
 841171139,
 -1,
 841364143,
 841272355,
 -1,
 841429556,
 841296023,
 -1,
 841495085,
 841400978,
 -1,
 841560620,
 841441283,
 -1,
 841626155,
 841524317,
 1874,
 -1,
 841547956,
 1875,
 -1,
 841572127,
 1872,
 -1,
 841539670,
 1876,
 841888305,
 841464842,
 -1,
 841953840,
 841864696,
 1878,
 -1,
 841875816,
 2208,
 -1,
 841909305,
 2230,
 -52686,
 841837358,
 1877,
 -52685,
 842094949,
 2209,
 -1,
 842153102,
 1873,
 842347076,
 841370855,
 -1,
 842412607,
 842277830,
 -1,
 842478139,
 842353685,
 -1,
 842543674,
 842449554,
 -1,
 -52679,
 842522647,
 1909,
 -1,
 842555356,
 1910,
 -1,
 842486052,
 1911,
 842805822,
 842449554,
 -1,
 -52675,
 842784826,
 1598,
 -1,
 842817550,
 1599,
 -1,
 842754885,
 1597,
 843120639,
 842351805,
 -1,
 843133507,
 843039378,
 -1,
 -52670,
 843112520,
 1888,
 -1,
 843145262,
 1889,
 -1,
 843070606,
 2212,
 843395667,
 842275124,
 -1,
 843461196,
 843343499,
 -1,
 843526729,
 843440177,
 -1,
 -52664,
 843503715,
 1887,
 -1,
 843520624,
 1885,
 843775999,
 843472899,
 -1,
 -52661,
 843686954,
 1886,
 -1,
 843720878,
 2227,
 843919952,
 843403822,
 -1,
 -52658,
 843884281,
 2236,
 -52657,
 843943380,
 2237,
 -1,
 843992525,
 2235,
 844234751,
 843872257,
 -1,
 -52654,
 844161047,
 1907,
 -1,
 844193756,
 1908,
 844378719,
 843360386,
 -1,
 844444254,
 844317885,
 -1,
 844509786,
 844412247,
 -1,
 844575321,
 844464571,
 -1,
 -52648,
 844533209,
 2233,
 -1,
 844571169,
 1905,
 -1,
 844549038,
 1883,
 -52645,
 844484022,
 1899,
 -52644,
 844791399,
 2218,
 -52643,
 844852037,
 1775,
 -1,
 844912997,
 1900,
 -1,
 844403297,
 2220,
 845165165,
 844329099,
 -1,
 845230696,
 845104369,
 -1,
 845296231,
 845202066,
 -1,
 845361766,
 845242371,
 -1,
 -52636,
 845325405,
 1892,
 -52635,
 845359278,
 1596,
 -1,
 845421168,
 1891,
 -1,
 845340730,
 1595,
 -1,
 845233239,
 1890,
 845807615,
 845158708,
 -1,
 845820524,
 845696280,
 -1,
 -52629,
 845794678,
 1919,
 -1,
 845823108,
 2228,
 -1,
 845789648,
 1568,
 846082678,
 845133143,
 -1,
 846148212,
 846021634,
 -1,
 -52624,
 846122422,
 1901,
 -52623,
 846183466,
 1904,
 -52622,
 846228293,
 1918,
 -52621,
 846287195,
 1884,
 -1,
 846351410,
 1917,
 -52619,
 846121509,
 2225,
 -1,
 846470016,
 2223,
 846672514,
 846026792,
 -1,
 846738049,
 846601452,
 -1,
 846803581,
 846707729,
 -1,
 846869116,
 846731572,
 -1,
 -52613,
 846826098,
 1903,
 -1,
 846867343,
 1906,
 -1,
 846801070,
 1902,
 847131264,
 846774930,
 -1,
 -52609,
 847110202,
 1879,
 -1,
 847142958,
 1880,
 -1,
 847072345,
 1916,
 -1,
 846677190,
 1791,
 847458954,
 846652433,
 -1,
 847524487,
 847437659,
 -1,
 -52603,
 847494323,
 2234,
 -52602,
 847534437,
 2216,
 -1,
 847592535,
 2217,
 847839231,
 847456238,
 -1,
 -52599,
 847765527,
 1914,
 -1,
 847798236,
 1915,
 847983249,
 847413381,
 -1,
 848048784,
 847922164,
 -1,
 848114319,
 847985746,
 -1,
 -52594,
 848046254,
 1894,
 -1,
 848108144,
 1893,
 -1,
 848086699,
 2215,
 -1,
 847979196,
 1564,
 848442008,
 847919328,
 -1,
 848507541,
 848413330,
 -1,
 -52588,
 848486514,
 1881,
 -1,
 848519198,
 2222,
 848756735,
 848456329,
 -1,
 -52585,
 848680440,
 1774,
 -1,
 848739592,
 1882,
 848900765,
 848419854,
 -1,
 848966300,
 848841856,
 -1,
 -52581,
 848945175,
 1912,
 -1,
 848977884,
 1913,
 -1,
 848903396,
 2219,
 849228450,
 848858608,
 -1,
 849293985,
 849198090,
 -1,
 -52576,
 849270264,
 1897,
 -1,
 849331059,
 1896,
 -1,
 849268101,
 1895,
 849556135,
 849179724,
 -1,
 849621670,
 849485676,
 -1,
 -52571,
 849558919,
 2214,
 -1,
 849618840,
 1898,
 -1,
 849583612,
 2221,
 849883818,
 849527442,
 -1,
 -52567,
 849822937,
 2232,
 -1,
 849878261,
 2211,
 -52565,
 849864157,
 2226,
 -52564,
 850044669,
 2213,
 -52563,
 850108692,
 2231,
 -52562,
 850161599,
 2210,
 -1,
 850219899,
 2224,
 850460671,
 841306769,
 -1,
 -52559,
 850340014,
 2297,
 -1,
 850401904,
 2295,
 -1,
 841245738,
 65021,
 850670340,
 841200983,
 -1,
 850735825,
 850624955,
 -1,
 850801355,
 850681021,
 -1,
 850866881,
 850778852,
 -1,
 850932416,
 850827406,
 -1,
 850997949,
 850860340,
 -1,
 -52550,
 850970017,
 2266,
 -52549,
 851031533,
 2267,
 -52548,
 851093715,
 2260,
 -1,
 851151180,
 2268,
 -52546,
 850975609,
 2271,
 -52545,
 851293748,
 2269,
 -1,
 851355433,
 2270,
 -1,
 850863721,
 2291,
 851587780,
 850834775,
 -1,
 -52541,
 851535201,
 2273,
 -1,
 851581813,
 2261,
 -52539,
 851568088,
 1559,
 -52538,
 851755891,
 1557,
 -52537,
 851814137,
 2263,
 -52536,
 851873275,
 2264,
 -52535,
 851934106,
 1558,
 -52534,
 851988633,
 2272,
 -1,
 852041038,
 2262,
 852243150,
 850755272,
 -1,
 -52531,
 852220938,
 2259,
 -1,
 852266491,
 2265,
 -52529,
 852193678,
 1562,
 -52528,
 852381067,
 1560,
 -1,
 852441347,
 1561,
 852636395,
 850715875,
 -1,
 852701919,
 852607634,
 -1,
 852767449,
 852680753,
 -1,
 852832983,
 852744279,
 -1,
 -52522,
 852764846,
 64446,
 -1,
 852826736,
 64445,
 -52520,
 852764846,
 64437,
 -1,
 852957808,
 64436,
 853213183,
 852713475,
 -1,
 853226205,
 853124118,
 -1,
 -52516,
 853158062,
 64441,
 -1,
 853219952,
 64440,
 -52514,
 853158062,
 64439,
 -1,
 853351024,
 64438,
 853553892,
 852638733,
 -1,
 853619427,
 853525140,
 -1,
 -52510,
 853551278,
 64435,
 -1,
 853613168,
 64434,
 -1,
 853594025,
 64444,
 853881575,
 853523682,
 -1,
 -52506,
 853813422,
 64449,
 -1,
 853875312,
 64448,
 854078186,
 853823824,
 -1,
 -52503,
 854010030,
 64443,
 -1,
 854071920,
 64442,
 -1,
 854044955,
 64447,
 854340343,
 852583736,
 -1,
 854405873,
 854308353,
 -1,
 -52498,
 854362548,
 1537,
 -52497,
 854427907,
 1540,
 -52496,
 854490431,
 1552,
 -1,
 854543955,
 1539,
 854733556,
 854370549,
 -1,
 -52493,
 854679042,
 1554,
 -1,
 854735553,
 1555,
 -52491,
 854705071,
 1556,
 -52490,
 854886059,
 1551,
 -1,
 854924886,
 1553,
 855126787,
 854280277,
 -1,
 855192322,
 855106582,
 -1,
 855257853,
 855120180,
 -1,
 855323388,
 855209981,
 983633,
 -1,
 855245951,
 983635,
 -1,
 855261379,
 983640,
 -52482,
 855238061,
 983638,
 -52481,
 855497738,
 983634,
 -52480,
 855559709,
 983637,
 -52479,
 855609801,
 983636,
 -1,
 855654595,
 983639,
 -1,
 855150091,
 983641,
 -1,
 855101390,
 1622,
 855978769,
 850641554,
 -1,
 856044303,
 855938227,
 -1,
 856109833,
 856018284,
 -1,
 -52472,
 856041646,
 2286,
 -1,
 856103536,
 2283,
 856306444,
 856069314,
 -1,
 -52469,
 856238254,
 2285,
 -1,
 856300144,
 2282,
 856555519,
 856260204,
 -1,
 -52466,
 856434862,
 2287,
 -1,
 856496752,
 2284,
 -52464,
 856020129,
 2275,
 -1,
 856666635,
 1566,
 856830744,
 855914387,
 -1,
 856896276,
 856781198,
 2278,
 -1,
 856867837,
 2281,
 857027350,
 856837515,
 2276,
 -1,
 856998909,
 2279,
 857210879,
 856963331,
 2277,
 -1,
 857129981,
 2280,
 857289503,
 856795266,
 -1,
 857355037,
 857236642,
 -1,
 857420572,
 857283184,
 2296,
 -1,
 857345000,
 2301,
 -1,
 857352366,
 2298,
 -52450,
 857295730,
 1629,
 -1,
 857548416,
 1544,
 857748262,
 857225231,
 -1,
 857813794,
 857709232,
 2299,
 -1,
 857738216,
 2300,
 857944869,
 857741620,
 -1,
 -52444,
 857916510,
 1549,
 -1,
 857966274,
 2302,
 -1,
 857894137,
 2274,
 858207020,
 857689319,
 -1,
 858272555,
 858137873,
 -1,
 -52439,
 858246499,
 1630,
 -52438,
 858304795,
 2292,
 -1,
 858340439,
 2293,
 -1,
 858232559,
 1538,
 858600240,
 858184304,
 -1,
 -52434,
 858569978,
 1626,
 -52433,
 858614551,
 1627,
 -1,
 858668164,
 1628,
 858862388,
 858560315,
 -1,
 -52430,
 858812841,
 2290,
 -52429,
 858869137,
 2288,
 -1,
 858929417,
 2289,
 859124535,
 858820551,
 -1,
 -52426,
 859093700,
 1536,
 -1,
 859144848,
 1541,
 -52424,
 859105078,
 1625,
 -52423,
 859298809,
 1631,
 -52422,
 859349945,
 1550,
 -52421,
 859402644,
 2294,
 -1,
 859466444,
 1623,
 859701247,
 828575454,
 -1,
 859714368,
 859611565,
 -1,
 -52417,
 859686124,
 1546,
 -1,
 859735567,
 1545,
 -52415,
 859656672,
 1543,
 -1,
 859846455,
 1542,
 860042055,
 828540060,
 -1,
 860107590,
 860011656,
 -1,
 -52411,
 860087425,
 1416,
 -1,
 860146863,
 1376,
 -1,
 860045309,
 1423,
 860422143,
 860014426,
 -1,
 -52407,
 860340030,
 127912,
 -1,
 860370767,
 128667,
 860566517,
 828470348,
 -1,
 860632046,
 860500006,
 -1,
 860697445,
 860599639,
 -1,
 860762967,
 860671517,
 -1,
 860828502,
 860695207,
 -1,
 860894037,
 860766517,
 -1,
 860959571,
 860862045,
 -1,
 -52398,
 860894472,
 128807,
 -1,
 860955004,
 128814,
 -52396,
 860894472,
 128802,
 -1,
 861086076,
 128812,
 -1,
 860842842,
 128862,
 -1,
 860781365,
 128781,
 861418333,
 860692001,
 -1,
 861483868,
 861389458,
 128788,
 861601791,
 861406460,
 -1,
 -52389,
 861484303,
 128806,
 -1,
 861544828,
 128813,
 -1,
 861408887,
 128825,
 861811553,
 861389458,
 -1,
 861877088,
 861776522,
 128860,
 -1,
 861802091,
 128861,
 -1,
 861807444,
 128850,
 -52382,
 861774503,
 128839,
 -52381,
 862032099,
 128852,
 -52380,
 862086653,
 128795,
 -1,
 862138177,
 128847,
 862335864,
 860625204,
 -1,
 862401389,
 862299979,
 -1,
 862466924,
 862322688,
 -1,
 862532458,
 862443877,
 128776,
 -1,
 862457451,
 128777,
 862715903,
 862497969,
 128774,
 -1,
 862588523,
 128775,
 -1,
 862408932,
 128773,
 862860146,
 862352460,
 -1,
 862925680,
 862810429,
 128822,
 -1,
 862850667,
 128823,
 -52367,
 862900516,
 128837,
 -1,
 862995984,
 128874,
 -52365,
 862835834,
 128829,
 -52364,
 863156595,
 128855,
 -52363,
 863220839,
 128826,
 -52362,
 863276917,
 128811,
 -52361,
 863338927,
 128859,
 -1,
 863398848,
 128769,
 863581068,
 862268644,
 -1,
 863646596,
 863545474,
 -1,
 863712128,
 863621150,
 128869,
 863830015,
 863637094,
 -1,
 -52355,
 863704364,
 128873,
 -52354,
 863769688,
 128872,
 -52353,
 863834938,
 128871,
 -1,
 863900181,
 128870,
 864157695,
 863670654,
 -1,
 864170883,
 864040200,
 128803,
 -1,
 864095851,
 128804,
 -1,
 864119898,
 128798,
 864367496,
 863574324,
 -1,
 -52346,
 864331435,
 128846,
 -52345,
 864387194,
 128844,
 -1,
 864436296,
 128848,
 864629643,
 864327649,
 -1,
 -52342,
 864590000,
 128800,
 -1,
 864625008,
 128805,
 -1,
 864577967,
 128787,
 864891804,
 863545474,
 -1,
 864957338,
 864829635,
 -1,
 865022871,
 864901067,
 128818,
 865088403,
 864947814,
 -1,
 -52335,
 865014872,
 128821,
 -52334,
 865080122,
 128820,
 -1,
 865145365,
 128819,
 865402879,
 865010940,
 -1,
 865416086,
 865280380,
 128816,
 -1,
 865341035,
 128817,
 -1,
 865365082,
 128799,
 865612697,
 864951990,
 128827,
 -1,
 865537643,
 128828,
 -1,
 865585611,
 128877,
 865861631,
 864915802,
 128792,
 -1,
 865734251,
 128793,
 865940391,
 864822975,
 -1,
 866005921,
 865900681,
 128834,
 866123775,
 865930854,
 -1,
 -52320,
 865997626,
 128836,
 -1,
 866062869,
 128835,
 866268068,
 865936649,
 -1,
 -52317,
 866244155,
 128876,
 -1,
 866288387,
 128875,
 -52315,
 866234044,
 128857,
 -52314,
 866415839,
 128783,
 -1,
 866479317,
 128830,
 866661297,
 865916408,
 -1,
 866726832,
 866607489,
 -1,
 866792366,
 866683672,
 128778,
 866857901,
 866717286,
 -1,
 -52308,
 866784058,
 128780,
 -1,
 866849301,
 128779,
 -1,
 866780417,
 128815,
 867172351,
 866765660,
 128790,
 -1,
 867044971,
 128791,
 -1,
 866666717,
 128808,
 867316667,
 866623181,
 -1,
 867382198,
 867274897,
 -1,
 867447733,
 867359814,
 128843,
 -1,
 867386130,
 128858,
 -1,
 867418786,
 128856,
 867644345,
 867356189,
 -1,
 -52296,
 867617398,
 128868,
 -1,
 867675905,
 128867,
 -52294,
 867609562,
 128863,
 -1,
 867786018,
 128782,
 867972035,
 867287698,
 -1,
 868037567,
 867919469,
 -1,
 -52290,
 867972908,
 128840,
 -1,
 868025696,
 128809,
 868234177,
 867967961,
 128831,
 -1,
 868159083,
 128832,
 -52286,
 868210147,
 128845,
 -1,
 868331201,
 128849,
 868496330,
 867926149,
 -1,
 868561864,
 868436172,
 128784,
 868679679,
 868486758,
 -1,
 -52281,
 868553530,
 128786,
 -1,
 868618773,
 128785,
 -52279,
 868521569,
 128881,
 -1,
 868753989,
 128824,
 868955089,
 868440104,
 -1,
 869020622,
 868913297,
 -1,
 -52275,
 868996135,
 128878,
 -1,
 869053534,
 128854,
 869269503,
 868949663,
 -1,
 -52272,
 869178111,
 128883,
 -1,
 869220344,
 128882,
 869413847,
 868890639,
 -1,
 869479382,
 869362821,
 -1,
 869544917,
 869449119,
 128865,
 -1,
 869469803,
 128866,
 -1,
 869517325,
 128864,
 -1,
 869410443,
 128880,
 869807067,
 869362778,
 -1,
 869872602,
 869729632,
 128796,
 -1,
 869797483,
 128797,
 -1,
 869797521,
 128801,
 870069214,
 869784356,
 -1,
 -52259,
 870048257,
 128842,
 -1,
 870106395,
 128772,
 870265825,
 870033488,
 -1,
 -52256,
 870223713,
 128768,
 -1,
 870265386,
 128833,
 870462436,
 870222995,
 -1,
 -52253,
 870435427,
 128789,
 -1,
 870471091,
 128879,
 870659047,
 870413388,
 -1,
 -52250,
 870617505,
 128851,
 -1,
 870662656,
 128810,
 870855658,
 870601458,
 -1,
 -52247,
 870830372,
 128841,
 -1,
 870879983,
 128794,
 -52245,
 870831220,
 128853,
 -52244,
 871010928,
 128838,
 -52243,
 871059263,
 128770,
 -1,
 871121467,
 128771,
 871314417,
 860569795,
 -1,
 -52240,
 871281786,
 983054,
 -1,
 871334718,
 9879,
 -52238,
 871286106,
 9941,
 -52237,
 871465093,
 983201,
 -52236,
 871523219,
 128126,
 -1,
 871572237,
 9200,
 871773289,
 860502031,
 -1,
 871838821,
 871724414,
 -1,
 871904291,
 871771364,
 -1,
 871969826,
 871834062,
 -1,
 872035325,
 871926056,
 -1,
 -52229,
 872014708,
 125209,
 -52228,
 872075646,
 125200,
 -1,
 872110142,
 125211,
 872297473,
 871985291,
 -1,
 -52225,
 872260534,
 125216,
 -52224,
 872306750,
 125213,
 -1,
 872356951,
 125201,
 872559620,
 872276748,
 -1,
 -52221,
 872503989,
 125198,
 -1,
 872552756,
 125202,
 872756231,
 872527191,
 -1,
 -52218,
 872704439,
 125189,
 -1,
 872765502,
 125217,
 872952842,
 872698610,
 -1,
 -52215,
 872884329,
 125214,
 -1,
 872945972,
 125208,
 873149453,
 872888335,
 -1,
 -52212,
 873093182,
 125197,
 -1,
 873142771,
 125185,
 873346064,
 873080511,
 -1,
 -52209,
 873290421,
 125191,
 -1,
 873339188,
 125188,
 -52207,
 873326087,
 125215,
 -52206,
 873520138,
 125199,
 -52205,
 873584142,
 125212,
 -52204,
 873647645,
 125203,
 -52203,
 873712706,
 125210,
 -52202,
 873769205,
 125192,
 -52201,
 873834228,
 125207,
 -52200,
 873898196,
 125190,
 -52199,
 873959569,
 125196,
 -52198,
 874022370,
 125187,
 -52197,
 874083494,
 125186,
 -52196,
 874147852,
 125204,
 -52195,
 874209665,
 125195,
 -52194,
 874272830,
 125206,
 -52193,
 874335548,
 125194,
 -52192,
 874397891,
 125193,
 -52191,
 874459213,
 125205,
 -1,
 874520252,
 125184,
 -1,
 871929416,
 125256,
 874787917,
 871873672,
 -1,
 874853416,
 874744104,
 -1,
 -52186,
 874832756,
 125243,
 -52185,
 874893694,
 125234,
 -1,
 874928190,
 125245,
 875115564,
 874803339,
 -1,
 -52182,
 875078582,
 125250,
 -52181,
 875124798,
 125247,
 -1,
 875174999,
 125235,
 875377711,
 875094796,
 -1,
 -52178,
 875322037,
 125232,
 -1,
 875370804,
 125236,
 875574322,
 875345239,
 -1,
 -52175,
 875522487,
 125223,
 -1,
 875583550,
 125251,
 875770933,
 875516658,
 -1,
 -52172,
 875702377,
 125248,
 -1,
 875764020,
 125242,
 875967544,
 875706383,
 -1,
 -52169,
 875911230,
 125231,
 -1,
 875960819,
 125219,
 876164155,
 875898559,
 -1,
 -52166,
 876108469,
 125225,
 -1,
 876157236,
 125222,
 -52164,
 876144135,
 125249,
 -52163,
 876338186,
 125233,
 -52162,
 876402190,
 125246,
 -52161,
 876465693,
 125237,
 -52160,
 876530754,
 125244,
 -52159,
 876587253,
 125226,
 -52158,
 876652276,
 125241,
 -52157,
 876716244,
 125224,
 -52156,
 876777617,
 125230,
 -52155,
 876840418,
 125221,
 -52154,
 876901542,
 125220,
 -52153,
 876965900,
 125238,
 -52152,
 877027713,
 125229,
 -52151,
 877090878,
 125240,
 -52150,
 877153596,
 125228,
 -52149,
 877215939,
 125227,
 -52148,
 877277261,
 125239,
 -1,
 877338300,
 125218,
 877540443,
 874724190,
 -1,
 877605969,
 877511314,
 -1,
 -52144,
 877584400,
 125266,
 -1,
 877617105,
 125267,
 877802580,
 877573463,
 -1,
 -52141,
 877752018,
 125270,
 -1,
 877808363,
 125271,
 877999191,
 877743335,
 -1,
 -52138,
 877959963,
 125268,
 -1,
 878013984,
 125269,
 -52136,
 877979274,
 125264,
 -52135,
 878154927,
 125265,
 -52134,
 878218456,
 125273,
 -1,
 878265613,
 125272,
 878457950,
 877488483,
 -1,
 -52131,
 878422055,
 125279,
 -1,
 878463952,
 125278,
 878654561,
 878400713,
 -1,
 -52128,
 878603102,
 125254,
 -1,
 878657785,
 125257,
 -52126,
 878631503,
 125253,
 -52125,
 878809021,
 125258,
 -52124,
 878860639,
 125255,
 -1,
 878911169,
 125252,
 879113320,
 871792773,
 -1,
 -52121,
 879062292,
 127903,
 -1,
 879118854,
 11237,
 -1,
 879087890,
 129489,
 879375545,
 871718509,
 -1,
 879441039,
 879327883,
 -1,
 879506544,
 879368500,
 71442,
 879624191,
 879460319,
 -1,
 -52114,
 879543064,
 71429,
 -52113,
 879579969,
 71446,
 -1,
 879634164,
 71450,
 879834228,
 879462696,
 -1,
 -52110,
 879813492,
 71440,
 -52109,
 879842113,
 71426,
 -1,
 879892788,
 71427,
 880096375,
 879805074,
 -1,
 -52106,
 880039998,
 71436,
 -1,
 880089396,
 71428,
 880292986,
 880058061,
 -1,
 -52103,
 880236606,
 71431,
 -1,
 880286004,
 71430,
 880489597,
 880242827,
 -1,
 -52100,
 880433214,
 71425,
 -1,
 880482612,
 71424,
 880686208,
 880439135,
 -1,
 -52097,
 880629822,
 71449,
 -1,
 880679220,
 71434,
 880882819,
 880628466,
 -1,
 -52094,
 880826430,
 71447,
 -1,
 880875828,
 71445,
 881079430,
 880818191,
 -1,
 -52091,
 881023038,
 71444,
 -1,
 881072436,
 71443,
 881276041,
 881010367,
 -1,
 -52088,
 881219646,
 71448,
 -1,
 881269044,
 71432,
 -52086,
 881243649,
 71439,
 -52085,
 881436917,
 71437,
 -52084,
 881492187,
 71433,
 -52083,
 881554582,
 71438,
 -52082,
 881612862,
 71441,
 -1,
 881668004,
 71435,
 881865883,
 879417968,
 -1,
 881931413,
 881793332,
 71456,
 -52078,
 881908452,
 71463,
 -52077,
 881950853,
 71466,
 -52076,
 882008449,
 71465,
 -1,
 882055476,
 71457,
 882259095,
 881905181,
 71460,
 -1,
 882232861,
 71461,
 882390169,
 882205057,
 71458,
 -1,
 882336129,
 71459,
 -52070,
 882348177,
 71464,
 -1,
 882458819,
 71462,
 882652329,
 881802078,
 -1,
 882717855,
 882623122,
 -1,
 -52066,
 882696208,
 71474,
 -1,
 882728913,
 71475,
 882914466,
 882685271,
 -1,
 -52063,
 882863826,
 71478,
 -1,
 882920171,
 71479,
 883111077,
 882855143,
 -1,
 -52060,
 883071771,
 71476,
 -1,
 883125792,
 71477,
 -52058,
 883091082,
 71472,
 -52057,
 883266735,
 71473,
 -52056,
 883330264,
 71481,
 -1,
 883377421,
 71480,
 883569841,
 882619735,
 -1,
 883635376,
 883516728,
 -1,
 883700910,
 883602775,
 -1,
 -52051,
 883655155,
 71484,
 -1,
 883704568,
 71485,
 -52049,
 883668187,
 71486,
 -1,
 883847898,
 71467,
 -1,
 883614992,
 71487,
 884094134,
 883504283,
 -1,
 884159669,
 884044876,
 -1,
 -52044,
 884106251,
 71455,
 -1,
 884152628,
 71453,
 -1,
 884123893,
 71454,
 884473855,
 884051931,
 -1,
 -52040,
 884399234,
 71483,
 -1,
 884426314,
 71482,
 884618507,
 879313091,
 -1,
 884684042,
 884561069,
 -1,
 884749561,
 884641735,
 -1,
 884815053,
 884720274,
 -1,
 884880580,
 884792036,
 -1,
 884946114,
 884838545,
 65800,
 885063679,
 884867072,
 -1,
 -52031,
 884983389,
 65827,
 -1,
 885022983,
 65818,
 885260287,
 884885433,
 65809,
 -1,
 885131674,
 65836,
 885339339,
 884824104,
 -1,
 885404873,
 885304411,
 65801,
 885522431,
 885325824,
 -1,
 -52024,
 885442141,
 65828,
 -1,
 885481735,
 65819,
 885719039,
 885353596,
 65810,
 -1,
 885590426,
 65837,
 885850111,
 885278282,
 65808,
 -1,
 885721498,
 65835,
 885929178,
 884782423,
 -1,
 885994708,
 885878482,
 65804,
 886060241,
 885968385,
 65813,
 -1,
 885983642,
 65840,
 886243327,
 885981184,
 -1,
 -52013,
 886163037,
 65831,
 -1,
 886202631,
 65822,
 886439935,
 885934827,
 65805,
 886453463,
 886361601,
 65814,
 -1,
 886376858,
 65841,
 886636543,
 886374400,
 -1,
 -52007,
 886556253,
 65832,
 -1,
 886595847,
 65823,
 886781161,
 885869799,
 -1,
 886846690,
 886739089,
 -1,
 886912224,
 886821927,
 65802,
 887029759,
 886833152,
 -1,
 -52001,
 886949469,
 65829,
 -1,
 886989063,
 65820,
 887226367,
 886879423,
 65811,
 -1,
 887097754,
 65838,
 887357439,
 886792577,
 -1,
 887370983,
 887281379,
 65803,
 887488511,
 887291904,
 -1,
 -51994,
 887408221,
 65830,
 -1,
 887447815,
 65821,
 887685119,
 887313110,
 65812,
 -1,
 887556506,
 65839,
 887764207,
 886738136,
 65807,
 887829740,
 887737857,
 65816,
 -1,
 887753114,
 65843,
 888012799,
 887750656,
 -1,
 -51986,
 887932509,
 65834,
 -1,
 887972103,
 65825,
 888157429,
 887702797,
 65806,
 888222962,
 888136460,
 65815,
 -1,
 888146330,
 65842,
 888406015,
 888143872,
 -1,
 -51980,
 888325725,
 65833,
 -1,
 888365319,
 65824,
 888602623,
 888116399,
 65799,
 888668159,
 888471552,
 -1,
 -51976,
 888587869,
 65826,
 -1,
 888627463,
 65817,
 888812804,
 884726500,
 -1,
 888878337,
 888751379,
 -1,
 888943870,
 888818919,
 -1,
 -51971,
 888904631,
 65851,
 -1,
 888958056,
 65848,
 -51969,
 888915511,
 65850,
 -51968,
 889108304,
 65849,
 -1,
 889137190,
 65847,
 889389055,
 888838305,
 -1,
 -51965,
 889289807,
 65792,
 -1,
 889338958,
 65793,
 889533703,
 888767412,
 -1,
 -51962,
 889505335,
 65855,
 -1,
 889567056,
 65854,
 -51960,
 889486503,
 65853,
 -51959,
 889667597,
 65852,
 -1,
 889729016,
 65794,
 -1,
 884649584,
 128673,
 889992530,
 884594168,
 -1,
 890058065,
 889932237,
 -1,
 890123600,
 890010251,
 -1,
 890189078,
 890050868,
 68352,
 890254610,
 890116404,
 68353,
 -51951,
 890212497,
 68355,
 -1,
 890276136,
 68357,
 890451220,
 890192067,
 68358,
 -1,
 890388675,
 68359,
 -51947,
 890409105,
 68354,
 -1,
 890538280,
 68356,
 890713374,
 890145064,
 -1,
 890778907,
 890655474,
 -1,
 -51943,
 890758134,
 68387,
 -51942,
 890820323,
 68388,
 -1,
 890847427,
 68386,
 -51940,
 890758134,
 68390,
 -51939,
 890997454,
 68391,
 -1,
 891044035,
 68389,
 891237668,
 890680663,
 -1,
 891303202,
 891181096,
 -1,
 -51935,
 891282422,
 68403,
 -1,
 891306179,
 68401,
 -51933,
 891271491,
 68404,
 -1,
 891437251,
 68399,
 891630888,
 891216385,
 -1,
 -51930,
 891610102,
 68370,
 -51929,
 891672291,
 68371,
 -1,
 891699395,
 68369,
 891893036,
 891601554,
 -1,
 -51926,
 891864141,
 68381,
 -51925,
 891902645,
 68378,
 -1,
 891961539,
 68377,
 892155184,
 891835122,
 -1,
 -51922,
 892099253,
 68374,
 -51921,
 892163218,
 68373,
 -1,
 892223683,
 68372,
 892417331,
 892134845,
 -1,
 -51918,
 892361397,
 68402,
 -1,
 892420291,
 68400,
 892613942,
 892396300,
 -1,
 -51915,
 892593142,
 68394,
 -1,
 892616899,
 68395,
 892810552,
 892587549,
 68366,
 -1,
 892784157,
 68367,
 892941626,
 892768401,
 68362,
 -1,
 892899473,
 68363,
 893072700,
 892887425,
 68364,
 -1,
 893018497,
 68365,
 893203775,
 893016104,
 -1,
 -51906,
 893158301,
 68393,
 -1,
 893206723,
 68405,
 893400385,
 893141187,
 68360,
 -1,
 893337795,
 68361,
 893531460,
 893335567,
 -1,
 -51901,
 893475509,
 68380,
 -1,
 893534403,
 68379,
 893728071,
 893462207,
 -1,
 -51898,
 893672117,
 68385,
 -1,
 893731011,
 68384,
 -51896,
 893703907,
 68396,
 -51895,
 893889354,
 68397,
 -51894,
 893952212,
 68382,
 -51893,
 894010269,
 68392,
 -51892,
 894072653,
 68398,
 -51891,
 894136825,
 68368,
 -51890,
 894201771,
 68376,
 -51889,
 894258594,
 68383,
 -1,
 894316249,
 68375,
 -1,
 890051124,
 68409,
 -1,
 890016038,
 129361,
 894645592,
 889966109,
 -1,
 894711126,
 894617919,
 -1,
 -51883,
 894669042,
 128663,
 -1,
 894706914,
 127975,
 -51881,
 894681240,
 8371,
 -1,
 894839023,
 127814,
 895038813,
 894615351,
 -1,
 895104348,
 895002754,
 -1,
 -51877,
 895063587,
 9954,
 -1,
 895097821,
 11225,
 -1,
 895063525,
 128562,
 895366497,
 895000269,
 -1,
 -51873,
 895329051,
 983194,
 -51872,
 895390571,
 11236,
 -1,
 895429860,
 983195,
 895628645,
 895320197,
 -1,
 -51869,
 895590968,
 127994,
 -51868,
 895633673,
 127944,
 -1,
 895691880,
 128657,
 895890793,
 895560932,
 -1,
 895956328,
 895840395,
 983053,
 -1,
 895913608,
 983052,
 -1,
 895877703,
 9190,
 896152940,
 895861394,
 -1,
 -51861,
 896111523,
 9883,
 -1,
 896163315,
 128095,
 896349551,
 896101471,
 -1,
 -51858,
 896285235,
 128747,
 -1,
 896344937,
 128748,
 -51856,
 896299999,
 8525,
 -51855,
 896486983,
 1547,
 -1,
 896542503,
 129518,
 896744309,
 785006787,
 -1,
 896809499,
 896684786,
 -1,
 896875034,
 896787816,
 -1,
 896939509,
 896801076,
 -1,
 897005006,
 896864221,
 -1,
 897070470,
 896930904,
 -1,
 897135994,
 896996652,
 77877,
 -1,
 897063220,
 77878,
 897267068,
 897061690,
 77874,
 -1,
 897194292,
 77875,
 897398142,
 897192469,
 77872,
 -1,
 897325364,
 77873,
 897529216,
 897322973,
 77869,
 -1,
 897456436,
 77870,
 -51839,
 897456258,
 77882,
 -51838,
 897587153,
 77881,
 -51837,
 897652465,
 77880,
 -51836,
 897717793,
 77879,
 -51835,
 897782872,
 77876,
 -1,
 897847530,
 77871,
 898053523,
 896995562,
 -1,
 898119049,
 897980145,
 77844,
 -1,
 898046260,
 77845,
 898250123,
 898045016,
 77840,
 -1,
 898177332,
 77841,
 -51828,
 898177154,
 77847,
 -51827,
 898308049,
 77846,
 -51826,
 898373153,
 77843,
 -51825,
 898438444,
 77842,
 -51824,
 898503482,
 77839,
 -51823,
 898568725,
 77838,
 -51822,
 898633962,
 77837,
 -1,
 898699229,
 77836,
 898905504,
 897978333,
 -1,
 898971031,
 898831905,
 77830,
 -51818,
 898901695,
 77832,
 -1,
 898963764,
 77831,
 899167641,
 898897196,
 77828,
 -1,
 899094836,
 77829,
 -51814,
 899094658,
 77835,
 -51813,
 899225553,
 77834,
 -51812,
 899290865,
 77833,
 -51811,
 899355736,
 77827,
 -51810,
 899420986,
 77826,
 -51809,
 899486229,
 77825,
 -1,
 899551466,
 77824,
 899757484,
 898831162,
 -1,
 899823011,
 899682837,
 77860,
 -1,
 899750196,
 77861,
 -51804,
 899750018,
 77868,
 -51803,
 899880913,
 77867,
 -51802,
 899946225,
 77866,
 -51801,
 900011553,
 77865,
 -51800,
 900076844,
 77864,
 -51799,
 900142168,
 77863,
 -51798,
 900207418,
 77862,
 -51797,
 900272362,
 77859,
 -1,
 900337629,
 77858,
 900543927,
 899683873,
 -1,
 -51794,
 900470914,
 77902,
 -51793,
 900536273,
 77901,
 -51792,
 900601585,
 77900,
 -51791,
 900666913,
 77899,
 -51790,
 900732204,
 77898,
 -51789,
 900797528,
 77897,
 -51788,
 900862778,
 77896,
 -51787,
 900928021,
 77895,
 -51786,
 900993258,
 77894,
 -1,
 901058525,
 77893,
 901264834,
 900470060,
 -1,
 -51783,
 901191810,
 77892,
 -51782,
 901257169,
 77891,
 -51781,
 901322481,
 77890,
 -51780,
 901387809,
 77889,
 -51779,
 901453100,
 77888,
 -51778,
 901518424,
 77887,
 -51777,
 901583674,
 77886,
 -51776,
 901648917,
 77885,
 -51775,
 901714154,
 77884,
 -1,
 901779421,
 77883,
 901985741,
 901190165,
 -1,
 -51772,
 901912706,
 77857,
 -51771,
 901978065,
 77856,
 -51770,
 902043377,
 77855,
 -51769,
 902108705,
 77854,
 -51768,
 902173996,
 77853,
 -51767,
 902239320,
 77852,
 -51766,
 902304570,
 77851,
 -51765,
 902369813,
 77850,
 -51764,
 902435050,
 77849,
 -1,
 902500317,
 77848,
 -1,
 901912492,
 77903,
 902823935,
 896932319,
 -1,
 902837723,
 902696925,
 -1,
 902903251,
 902764273,
 78867,
 -51758,
 902833855,
 78869,
 -1,
 902895924,
 78868,
 -51756,
 902830210,
 78871,
 -51755,
 903026641,
 78870,
 -51754,
 903091745,
 78866,
 -51753,
 903157036,
 78865,
 -51752,
 903222360,
 78864,
 -51751,
 903287610,
 78863,
 -51750,
 903352853,
 78862,
 -1,
 903418090,
 78861,
 903624166,
 902763029,
 -1,
 -51747,
 903551106,
 78891,
 -51746,
 903616465,
 78890,
 -51745,
 903681777,
 78889,
 -51744,
 903747105,
 78888,
 -51743,
 903812396,
 78887,
 -51742,
 903877720,
 78886,
 -51741,
 903942970,
 78885,
 -51740,
 904008213,
 78884,
 -51739,
 904073450,
 78883,
 -1,
 904138717,
 78882,
 904345073,
 903549162,
 -1,
 -51736,
 904272002,
 78881,
 -51735,
 904337361,
 78880,
 -51734,
 904402673,
 78879,
 -51733,
 904468001,
 78878,
 -51732,
 904533292,
 78877,
 -51731,
 904598616,
 78876,
 -51730,
 904663866,
 78875,
 -51729,
 904729109,
 78874,
 -51728,
 904794346,
 78873,
 -1,
 904859613,
 78872,
 905117695,
 904270650,
 -1,
 -51725,
 904991253,
 78894,
 -51724,
 905056490,
 78893,
 -1,
 905121757,
 78892,
 905328228,
 896895272,
 -1,
 905393709,
 905252829,
 -1,
 905459206,
 905319226,
 -1,
 905524730,
 905385713,
 78361,
 -1,
 905451828,
 78362,
 905655804,
 905450796,
 78358,
 -1,
 905582900,
 78359,
 905786878,
 905581656,
 78356,
 -1,
 905713972,
 78357,
 905917952,
 905712442,
 78354,
 -1,
 905845044,
 78355,
 -51711,
 905844866,
 78364,
 -51710,
 905975761,
 78363,
 -51709,
 906040865,
 78360,
 -51708,
 906105365,
 78353,
 -51707,
 906170602,
 78352,
 -1,
 906235869,
 78351,
 906442259,
 905384170,
 -1,
 906507786,
 906368977,
 78336,
 -51703,
 906438335,
 78338,
 -1,
 906500404,
 78337,
 -51701,
 906434690,
 78339,
 -51700,
 906630897,
 78335,
 -51699,
 906696225,
 78334,
 -51698,
 906761516,
 78333,
 -51697,
 906826840,
 78332,
 -51696,
 906892090,
 78331,
 -51695,
 906957333,
 78330,
 -51694,
 907022570,
 78329,
 -1,
 907087837,
 78328,
 907294239,
 906367509,
 -1,
 907359766,
 907220268,
 78345,
 -1,
 907286836,
 78346,
 -51689,
 907286658,
 78350,
 -51688,
 907417553,
 78349,
 -51687,
 907482865,
 78348,
 -51686,
 907548193,
 78347,
 -51685,
 907613272,
 78344,
 -51684,
 907678522,
 78343,
 -51683,
 907743765,
 78342,
 -51682,
 907809002,
 78341,
 -1,
 907874269,
 78340,
 908080681,
 907218909,
 -1,
 -51679,
 908007554,
 78327,
 -51678,
 908072913,
 78326,
 -51677,
 908138225,
 78325,
 -51676,
 908203553,
 78324,
 -51675,
 908268844,
 78323,
 -51674,
 908334168,
 78322,
 -51673,
 908399418,
 78321,
 -51672,
 908464661,
 78320,
 -1,
 908529898,
 78319,
 908787711,
 908006488,
 -1,
 -51669,
 908661269,
 78367,
 -51668,
 908726506,
 78366,
 -1,
 908791773,
 78365,
 908998219,
 905367202,
 -1,
 909063740,
 908923114,
 -1,
 909129265,
 908990417,
 78409,
 -1,
 909056308,
 78410,
 909260339,
 909054186,
 78401,
 -1,
 909187380,
 78402,
 909391413,
 909184989,
 78399,
 -1,
 909318452,
 78400,
 -51658,
 909318274,
 78411,
 -51657,
 909448945,
 78408,
 -51656,
 909514273,
 78407,
 -51655,
 909579564,
 78406,
 -51654,
 909644888,
 78405,
 -51653,
 909710138,
 78404,
 -1,
 909775381,
 78403,
 909981254,
 908988381,
 -1,
 -51650,
 909908098,
 78398,
 -51649,
 909973457,
 78397,
 -51648,
 910038769,
 78396,
 -51647,
 910104097,
 78395,
 -51646,
 910169388,
 78394,
 -51645,
 910234712,
 78393,
 -51644,
 910299962,
 78392,
 -51643,
 910365205,
 78391,
 -1,
 910430442,
 78390,
 910688255,
 909906453,
 -1,
 910702153,
 910561813,
 78414,
 -1,
 910629172,
 78415,
 -51638,
 910627050,
 78413,
 -1,
 910757853,
 78412,
 911015935,
 908948620,
 -1,
 911029848,
 910889194,
 -1,
 911095375,
 910956273,
 78385,
 -1,
 911022388,
 78386,
 -51632,
 911022210,
 78388,
 -51631,
 911153105,
 78387,
 -51630,
 911218209,
 78384,
 -51629,
 911283500,
 78383,
 -51628,
 911348824,
 78382,
 -51627,
 911414074,
 78381,
 -51626,
 911479317,
 78380,
 -51625,
 911544554,
 78379,
 -1,
 911609821,
 78378,
 911816291,
 910954461,
 -1,
 911881819,
 911742252,
 78372,
 -1,
 911808820,
 78373,
 -51620,
 911808642,
 78377,
 -51619,
 911939537,
 78376,
 -51618,
 912004849,
 78375,
 -51617,
 912070177,
 78374,
 -51616,
 912135256,
 78371,
 -51615,
 912200506,
 78370,
 -51614,
 912265749,
 78369,
 -1,
 912330986,
 78368,
 -1,
 911741706,
 78389,
 912602824,
 905263251,
 -1,
 912668283,
 912528684,
 -1,
 912733808,
 912592861,
 77997,
 -51608,
 912679297,
 78006,
 -51607,
 912742440,
 78005,
 -51606,
 912806642,
 78004,
 -51605,
 912870631,
 78003,
 -51604,
 912933059,
 78002,
 -51603,
 912996367,
 78001,
 -51602,
 913059044,
 78000,
 -51601,
 913123007,
 77999,
 -1,
 913185076,
 77998,
 913389170,
 912659544,
 78011,
 -1,
 913316148,
 78012,
 913520244,
 913314325,
 78008,
 -1,
 913447220,
 78009,
 -51595,
 913447042,
 78017,
 -51594,
 913577937,
 78016,
 -51593,
 913643249,
 78015,
 -51592,
 913708577,
 78014,
 -51591,
 913773868,
 78013,
 -51590,
 913838906,
 78010,
 -1,
 913903850,
 78007,
 914110092,
 912594465,
 -1,
 914175621,
 914036465,
 78025,
 -51586,
 914118696,
 78033,
 -51585,
 914182898,
 78032,
 -51584,
 914246887,
 78031,
 -51583,
 914309315,
 78030,
 -51582,
 914372623,
 78029,
 -51581,
 914435300,
 78028,
 -51580,
 914499263,
 78027,
 -1,
 914561332,
 78026,
 -51578,
 914101793,
 78024,
 -51577,
 914691372,
 78023,
 -51576,
 914756696,
 78022,
 -51575,
 914821946,
 78021,
 -51574,
 914887189,
 78020,
 -51573,
 914952426,
 78019,
 -1,
 915017693,
 78018,
 915224217,
 914035800,
 -1,
 915289743,
 915150801,
 77994,
 -1,
 915216692,
 77995,
 915420817,
 915215905,
 77991,
 -1,
 915347764,
 77992,
 -51566,
 915347586,
 77996,
 -51565,
 915478257,
 77993,
 -51564,
 915543340,
 77990,
 -51563,
 915608664,
 77989,
 -51562,
 915673914,
 77988,
 -51561,
 915739157,
 77987,
 -51560,
 915804394,
 77986,
 -1,
 915869661,
 77985,
 916076198,
 915149626,
 -1,
 916141724,
 916001880,
 77978,
 -1,
 916068660,
 77979,
 916272798,
 916066538,
 77974,
 -1,
 916199732,
 77975,
 -51553,
 916199554,
 77984,
 -51552,
 916330449,
 77983,
 -51551,
 916395761,
 77982,
 -51550,
 916461089,
 77981,
 -51549,
 916526380,
 77980,
 -51548,
 916591418,
 77977,
 -51547,
 916656661,
 77976,
 -1,
 916721629,
 77973,
 916928178,
 916001301,
 -1,
 916993705,
 916854513,
 77969,
 -1,
 916920628,
 77970,
 -51542,
 916920450,
 77972,
 -51541,
 917051345,
 77971,
 -51540,
 917116449,
 77968,
 -51539,
 917181740,
 77967,
 -51538,
 917247064,
 77966,
 -51537,
 917312314,
 77965,
 -51536,
 917377557,
 77964,
 -51535,
 917442794,
 77963,
 -1,
 917508061,
 77962,
 917714621,
 916852970,
 -1,
 -51532,
 917641346,
 77961,
 -51531,
 917706705,
 77960,
 -51530,
 917772017,
 77959,
 -51529,
 917837345,
 77958,
 -51528,
 917902636,
 77957,
 -51527,
 917967960,
 77956,
 -51526,
 918033210,
 77955,
 -51525,
 918098453,
 77954,
 -51524,
 918163690,
 77953,
 -1,
 918228957,
 77952,
 918487039,
 917639133,
 -1,
 918501056,
 918362065,
 77949,
 -1,
 918427956,
 77950,
 -51519,
 918427778,
 77951,
 -51518,
 918558449,
 77948,
 -51517,
 918623777,
 77947,
 -51516,
 918689068,
 77946,
 -51515,
 918754392,
 77945,
 -51514,
 918819642,
 77944,
 -51513,
 918884885,
 77943,
 -1,
 918950122,
 77942,
 919156506,
 912578059,
 -1,
 919221987,
 919081493,
 -1,
 919287511,
 919146461,
 78726,
 -51508,
 919237708,
 78738,
 -51507,
 919302283,
 78737,
 -51506,
 919367519,
 78736,
 -51505,
 919429505,
 78735,
 -51504,
 919492648,
 78734,
 -51503,
 919556850,
 78733,
 -51502,
 919620839,
 78732,
 -51501,
 919683267,
 78731,
 -51500,
 919746575,
 78730,
 -51499,
 919809252,
 78729,
 -51498,
 919873215,
 78728,
 -1,
 919935284,
 78727,
 920139481,
 919214210,
 78749,
 -1,
 920066356,
 78750,
 920270555,
 920066001,
 78747,
 -1,
 920197428,
 78748,
 920401629,
 920195898,
 78741,
 -1,
 920328500,
 78742,
 -51490,
 920327921,
 78746,
 -51489,
 920458785,
 78745,
 -51488,
 920524076,
 78744,
 -51487,
 920589400,
 78743,
 -51486,
 920654357,
 78740,
 -1,
 920719594,
 78739,
 920925945,
 919146461,
 -1,
 920991470,
 920850666,
 78690,
 -51482,
 920936833,
 78699,
 -51481,
 920999976,
 78698,
 -51480,
 921064178,
 78697,
 -51479,
 921128167,
 78696,
 -51478,
 921190595,
 78695,
 -51477,
 921253903,
 78694,
 -51476,
 921316580,
 78693,
 -51475,
 921380543,
 78692,
 -1,
 921442612,
 78691,
 921646833,
 920917745,
 78706,
 -51472,
 921577151,
 78708,
 -1,
 921639220,
 78707,
 921843443,
 921571861,
 78700,
 -1,
 921770292,
 78701,
 -51468,
 921770114,
 78710,
 -51467,
 921901009,
 78709,
 -51466,
 921966113,
 78705,
 -51465,
 922031404,
 78704,
 -51464,
 922096728,
 78703,
 -1,
 922161978,
 78702,
 922367753,
 920850666,
 -1,
 922433278,
 922292458,
 78712,
 -51460,
 922365156,
 78715,
 -51459,
 922429119,
 78714,
 -1,
 922491188,
 78713,
 922695425,
 922358293,
 78716,
 -51456,
 922625727,
 78718,
 -1,
 922687796,
 78717,
 -51454,
 922622082,
 78725,
 -51453,
 922818513,
 78724,
 -51452,
 922883825,
 78723,
 -51451,
 922949153,
 78722,
 -51450,
 923014444,
 78721,
 -51449,
 923079768,
 78720,
 -51448,
 923145018,
 78719,
 -1,
 923209693,
 78711,
 923416344,
 922293050,
 -1,
 923481868,
 923342577,
 78761,
 -1,
 923408692,
 78762,
 923612942,
 923407162,
 78756,
 -1,
 923539764,
 78757,
 923744016,
 923537642,
 78753,
 -1,
 923670836,
 78754,
 923875090,
 923668445,
 78751,
 -1,
 923801908,
 78752,
 -51437,
 923801730,
 78764,
 -51436,
 923932625,
 78763,
 -51435,
 923997729,
 78760,
 -51434,
 924063020,
 78759,
 -51433,
 924128344,
 78758,
 -1,
 924193301,
 78755,
 924450815,
 923342103,
 78765,
 -1,
 924326196,
 78766,
 924530540,
 919113944,
 -1,
 924596013,
 924454877,
 -1,
 924661539,
 924522017,
 78423,
 -51426,
 924601575,
 78429,
 -51425,
 924664003,
 78428,
 -51424,
 924727311,
 78427,
 -51423,
 924789988,
 78426,
 -51422,
 924853951,
 78425,
 -1,
 924916020,
 78424,
 925120293,
 924587308,
 78421,
 -1,
 925047092,
 78422,
 925251367,
 925044970,
 78416,
 -1,
 925178164,
 78417,
 -51416,
 925177986,
 78432,
 -51415,
 925308881,
 78431,
 -51414,
 925374193,
 78430,
 -51413,
 925439064,
 78420,
 -51412,
 925504314,
 78419,
 -1,
 925569557,
 78418,
 925775678,
 924521274,
 -1,
 925841203,
 925701665,
 78469,
 -51408,
 925775887,
 78473,
 -51407,
 925838564,
 78472,
 -51406,
 925902527,
 78471,
 -1,
 925964596,
 78470,
 926168885,
 925766458,
 78465,
 -1,
 926095668,
 78466,
 926299959,
 926093277,
 78461,
 -1,
 926226740,
 78462,
 -51400,
 926226562,
 78476,
 -51399,
 926357457,
 78475,
 -51398,
 926422769,
 78474,
 -51397,
 926487852,
 78468,
 -51396,
 926553176,
 78467,
 -51395,
 926618133,
 78464,
 -1,
 926683370,
 78463,
 926889805,
 925700629,
 -1,
 926955329,
 926816386,
 78459,
 -1,
 926882100,
 78460,
 927086403,
 926881068,
 78454,
 -1,
 927013172,
 78455,
 927217477,
 927011928,
 78452,
 -1,
 927144244,
 78453,
 927348551,
 927141853,
 78447,
 -1,
 927275316,
 78448,
 -51384,
 927274961,
 78458,
 -51383,
 927405809,
 78457,
 -51382,
 927471137,
 78456,
 -51381,
 927535930,
 78451,
 -51380,
 927601173,
 78450,
 -1,
 927666410,
 78449,
 927872860,
 926814442,
 -1,
 927938386,
 927797213,
 78433,
 -51376,
 927870180,
 78436,
 -51375,
 927934143,
 78435,
 -1,
 927996212,
 78434,
 928200532,
 927864962,
 78445,
 -1,
 928127284,
 78446,
 -51371,
 928126929,
 78444,
 -51370,
 928257777,
 78443,
 -51369,
 928323105,
 78442,
 -51368,
 928388396,
 78441,
 -51367,
 928453720,
 78440,
 -51366,
 928518970,
 78439,
 -51365,
 928584213,
 78438,
 -1,
 928649450,
 78437,
 928855911,
 927798360,
 -1,
 -51362,
 928782466,
 78486,
 -51361,
 928847825,
 78485,
 -51360,
 928913137,
 78484,
 -51359,
 928978465,
 78483,
 -51358,
 929043756,
 78482,
 -51357,
 929109080,
 78481,
 -51356,
 929174330,
 78480,
 -51355,
 929239573,
 78479,
 -51354,
 929304810,
 78478,
 -1,
 929370077,
 78477,
 929628159,
 928781612,
 -1,
 929642347,
 929501149,
 78487,
 -51350,
 929572543,
 78489,
 -1,
 929634612,
 78488,
 -1,
 929566954,
 78490,
 929904564,
 924483800,
 -1,
 929970052,
 929829098,
 -1,
 930035575,
 929894933,
 78268,
 -51344,
 929978408,
 78276,
 -51343,
 930042610,
 78275,
 -51342,
 930106599,
 78274,
 -51341,
 930169027,
 78273,
 -51340,
 930232335,
 78272,
 -51339,
 930295012,
 78271,
 -51338,
 930358975,
 78270,
 -1,
 930421044,
 78269,
 930625401,
 929961713,
 78283,
 -1,
 930552116,
 78284,
 930756475,
 930551329,
 78281,
 -1,
 930683188,
 78282,
 930887549,
 930682156,
 78279,
 -1,
 930814260,
 78280,
 931018623,
 930811869,
 78265,
 -1,
 930945332,
 78266,
 -51328,
 930945154,
 78286,
 -51327,
 931076049,
 78285,
 -51326,
 931140696,
 78278,
 -51325,
 931205946,
 78277,
 -1,
 931270890,
 78267,
 931477394,
 929895226,
 -1,
 931542920,
 931402554,
 78304,
 -51321,
 931473087,
 78306,
 -1,
 931535156,
 78305,
 931739530,
 931467498,
 78301,
 -1,
 931666228,
 78302,
 -51317,
 931666050,
 78312,
 -51316,
 931796945,
 78311,
 -51315,
 931862257,
 78310,
 -51314,
 931927585,
 78309,
 -51313,
 931992876,
 78308,
 -51312,
 932058200,
 78307,
 -51311,
 932123157,
 78303,
 -1,
 932188125,
 78300,
 932394912,
 931402261,
 -1,
 932460437,
 932321233,
 78297,
 -1,
 932387124,
 78298,
 932591511,
 932385880,
 78292,
 -1,
 932518196,
 78293,
 932722585,
 932516373,
 78289,
 -1,
 932649268,
 78290,
 -51302,
 932649090,
 78299,
 -51301,
 932779761,
 78296,
 -51300,
 932845089,
 78295,
 -51299,
 932910380,
 78294,
 -51298,
 932975418,
 78291,
 -51297,
 933040362,
 78288,
 -1,
 933105629,
 78287,
 933312429,
 932319197,
 -1,
 933377956,
 933236970,
 78253,
 -51293,
 933308095,
 78255,
 -1,
 933370164,
 78254,
 933574566,
 933303098,
 78257,
 -1,
 933501236,
 78258,
 -51289,
 933501058,
 78264,
 -51288,
 933631953,
 78263,
 -51287,
 933697265,
 78262,
 -51286,
 933762593,
 78261,
 -51285,
 933827884,
 78260,
 -51284,
 933893208,
 78259,
 -1,
 933958165,
 78256,
 934215679,
 933237848,
 -1,
 934229936,
 934088669,
 78313,
 -1,
 934156596,
 78314,
 -51279,
 934155352,
 78318,
 -51278,
 934286138,
 78317,
 -51277,
 934351381,
 78316,
 -1,
 934416618,
 78315,
 934623228,
 929844526,
 -1,
 934688707,
 934548568,
 -1,
 934754232,
 934614769,
 78132,
 -1,
 934680884,
 78133,
 934885306,
 934680097,
 78130,
 -1,
 934811956,
 78131,
 935016380,
 934810924,
 78128,
 -1,
 934943028,
 78129,
 -51267,
 934942850,
 78135,
 -51266,
 935073745,
 78134,
 -51265,
 935138392,
 78127,
 -51264,
 935203642,
 78126,
 -51263,
 935268885,
 78125,
 -51262,
 935334122,
 78124,
 -1,
 935399389,
 78123,
 935606225,
 934613818,
 -1,
 935671750,
 935532497,
 78120,
 -1,
 935598388,
 78121,
 935802824,
 935597809,
 78118,
 -1,
 935729460,
 78119,
 935933898,
 935727338,
 78111,
 -1,
 935860532,
 78112,
 -51253,
 935860354,
 78122,
 -51252,
 935990817,
 78117,
 -51251,
 936056108,
 78116,
 -51250,
 936121432,
 78115,
 -51249,
 936186682,
 78114,
 -51248,
 936251925,
 78113,
 -1,
 936316893,
 78110,
 936523741,
 935531029,
 -1,
 936589268,
 936448234,
 78100,
 -1,
 936515892,
 78101,
 -51243,
 936515714,
 78109,
 -51242,
 936646609,
 78108,
 -51241,
 936711921,
 78107,
 -51240,
 936777249,
 78106,
 -51239,
 936842540,
 78105,
 -51238,
 936907864,
 78104,
 -51237,
 936973114,
 78103,
 -51236,
 937038357,
 78102,
 -1,
 937103325,
 78099,
 937310185,
 936448234,
 -1,
 937375712,
 937235258,
 78091,
 -1,
 937302324,
 78092,
 -51231,
 937302146,
 78098,
 -51230,
 937433041,
 78097,
 -51229,
 937498353,
 78096,
 -51228,
 937563681,
 78095,
 -51227,
 937628972,
 78094,
 -51226,
 937694296,
 78093,
 -51225,
 937759253,
 78090,
 -51224,
 937824490,
 78089,
 -1,
 937889757,
 78088,
 938096628,
 937234397,
 -1,
 938162156,
 938021098,
 78078,
 -1,
 938088756,
 78079,
 -51219,
 938088578,
 78087,
 -51218,
 938219473,
 78086,
 -51217,
 938284785,
 78085,
 -51216,
 938350113,
 78084,
 -51215,
 938415404,
 78083,
 -51214,
 938480728,
 78082,
 -51213,
 938545978,
 78081,
 -1,
 938611221,
 78080,
 938868735,
 938022188,
 -1,
 938883065,
 938741994,
 78137,
 -51209,
 938814692,
 78140,
 -51208,
 938878655,
 78139,
 -1,
 938940724,
 78138,
 -51206,
 938808122,
 78142,
 -51205,
 939069973,
 78141,
 -1,
 939134941,
 78136,
 939341891,
 934564661,
 -1,
 939407370,
 939267160,
 -1,
 939472896,
 939332908,
 78196,
 -1,
 939399476,
 78197,
 939603970,
 939397946,
 78193,
 -1,
 939530548,
 78194,
 -51197,
 939530370,
 78201,
 -51196,
 939661265,
 78200,
 -51195,
 939726577,
 78199,
 -51194,
 939791905,
 78198,
 -51193,
 939856984,
 78195,
 -51192,
 939921941,
 78192,
 -51191,
 939987178,
 78191,
 -1,
 940052445,
 78190,
 940259351,
 939332410,
 -1,
 940324877,
 940185329,
 78186,
 -1,
 940251444,
 78187,
 940455951,
 940250657,
 78184,
 -1,
 940382516,
 78185,
 -51184,
 940382338,
 78189,
 -51183,
 940513233,
 78188,
 -51182,
 940578092,
 78183,
 -51181,
 940643416,
 78182,
 -51180,
 940708666,
 78181,
 -51179,
 940773909,
 78180,
 -51178,
 940839146,
 78179,
 -1,
 940904413,
 78178,
 941111332,
 940184085,
 -1,
 941176858,
 941037089,
 78173,
 -1,
 941103412,
 78174,
 941307932,
 941101021,
 78166,
 -1,
 941234484,
 78167,
 -51171,
 941234306,
 78177,
 -51170,
 941365201,
 78176,
 -51169,
 941430513,
 78175,
 -51168,
 941495596,
 78172,
 -51167,
 941560920,
 78171,
 -51166,
 941626170,
 78170,
 -51165,
 941691413,
 78169,
 -1,
 941756650,
 78168,
 941963313,
 941035485,
 -1,
 942028840,
 941889265,
 78150,
 -51161,
 941958847,
 78152,
 -1,
 942020916,
 78151,
 942225450,
 941954593,
 78148,
 -1,
 942151988,
 78149,
 -51157,
 942151810,
 78154,
 -51156,
 942282705,
 78153,
 -51155,
 942347564,
 78147,
 -51154,
 942412888,
 78146,
 -51153,
 942478138,
 78145,
 -51152,
 942543381,
 78144,
 -1,
 942608618,
 78143,
 942815293,
 941887722,
 -1,
 942880820,
 942739690,
 78156,
 -1,
 942807348,
 78157,
 -51147,
 942807170,
 78165,
 -51146,
 942938065,
 78164,
 -51145,
 943003377,
 78163,
 -51144,
 943068705,
 78162,
 -51143,
 943133996,
 78161,
 -51142,
 943199320,
 78160,
 -51141,
 943264570,
 78159,
 -51140,
 943329813,
 78158,
 -1,
 943394781,
 78155,
 943652863,
 942740780,
 -1,
 -51137,
 943527000,
 78206,
 -51136,
 943592250,
 78205,
 -51135,
 943657493,
 78204,
 -51134,
 943722730,
 78203,
 -1,
 943787997,
 78202,
 943995007,
 939308542,
 -1,
 944060498,
 943919338,
 -1,
 944126024,
 943985752,
 78560,
 -51129,
 944055999,
 78562,
 -1,
 944118068,
 78561,
 944322634,
 944051953,
 78565,
 -1,
 944249140,
 78566,
 -51125,
 944248962,
 78568,
 -51124,
 944379857,
 78567,
 -51123,
 944444961,
 78564,
 -51122,
 944510252,
 78563,
 -51121,
 944575290,
 78559,
 -51120,
 944640533,
 78558,
 -51119,
 944705770,
 78557,
 -1,
 944771037,
 78556,
 944978015,
 943985173,
 -1,
 945043542,
 944903713,
 78575,
 -51115,
 944973503,
 78577,
 -1,
 945035572,
 78576,
 -51113,
 944969858,
 78580,
 -51112,
 945166289,
 78579,
 -51111,
 945231601,
 78578,
 -51110,
 945296684,
 78574,
 -51109,
 945362008,
 78573,
 -51108,
 945427258,
 78572,
 -51107,
 945492501,
 78571,
 -51106,
 945557738,
 78570,
 -1,
 945623005,
 78569,
 945829995,
 944902970,
 -1,
 945895522,
 945755436,
 78586,
 -1,
 945822004,
 78587,
 -51101,
 945821826,
 78591,
 -51100,
 945952721,
 78590,
 -51099,
 946018033,
 78589,
 -51098,
 946083361,
 78588,
 -51097,
 946148440,
 78585,
 -51096,
 946213690,
 78584,
 -51095,
 946278933,
 78583,
 -51094,
 946344170,
 78582,
 -1,
 946409437,
 78581,
 946616439,
 945754077,
 -1,
 946681966,
 946542113,
 78551,
 -1,
 946608436,
 78552,
 946813040,
 946606613,
 78546,
 -1,
 946739508,
 78547,
 -51087,
 946739330,
 78555,
 -51086,
 946870225,
 78554,
 -51085,
 946935537,
 78553,
 -51084,
 947000620,
 78550,
 -51083,
 947065944,
 78549,
 -51082,
 947131194,
 78548,
 -1,
 947196138,
 78545,
 947453951,
 946541656,
 -1,
 -51079,
 947328545,
 78598,
 -51078,
 947393836,
 78597,
 -51077,
 947459160,
 78596,
 -51076,
 947524410,
 78595,
 -51075,
 947589653,
 78594,
 -51074,
 947654890,
 78593,
 -1,
 947720157,
 78592,
 947927220,
 943967906,
 -1,
 947992717,
 947851797,
 -1,
 948058243,
 947918978,
 78674,
 -1,
 947984692,
 78675,
 948189317,
 947983162,
 78667,
 -1,
 948115764,
 78668,
 -51066,
 948115409,
 78673,
 -51065,
 948246257,
 78672,
 -51064,
 948311585,
 78671,
 -51063,
 948376876,
 78670,
 -51062,
 948442200,
 78669,
 -51061,
 948507157,
 78666,
 -51060,
 948572394,
 78665,
 -1,
 948637661,
 78664,
 948844697,
 947917626,
 -1,
 948910224,
 948769301,
 78678,
 -1,
 948836660,
 78679,
 -51055,
 948836482,
 78686,
 -51054,
 948967377,
 78685,
 -51053,
 949032689,
 78684,
 -51052,
 949098017,
 78683,
 -51051,
 949163308,
 78682,
 -51050,
 949228632,
 78681,
 -51049,
 949293882,
 78680,
 -51048,
 949358826,
 78677,
 -1,
 949424093,
 78676,
 949631141,
 948768733,
 -1,
 949696669,
 949556769,
 78648,
 -51044,
 949626559,
 78650,
 -1,
 949688628,
 78649,
 -51042,
 949622914,
 78653,
 -51041,
 949819345,
 78652,
 -51040,
 949884657,
 78651,
 -51039,
 949949740,
 78647,
 -51038,
 950015064,
 78646,
 -51037,
 950080314,
 78645,
 -51036,
 950145557,
 78644,
 -1,
 950210794,
 78643,
 950417584,
 949555434,
 -1,
 -51033,
 950343810,
 78663,
 -51032,
 950409169,
 78662,
 -51031,
 950474481,
 78661,
 -51030,
 950539809,
 78660,
 -51029,
 950605100,
 78659,
 -51028,
 950670424,
 78658,
 -51027,
 950735674,
 78657,
 -51026,
 950800917,
 78656,
 -51025,
 950866154,
 78655,
 -1,
 950931421,
 78654,
 951189503,
 950342744,
 -1,
 -51022,
 951063061,
 78689,
 -51021,
 951128298,
 78688,
 -1,
 951193565,
 78687,
 951400677,
 947897109,
 -1,
 951466179,
 951324637,
 -1,
 951531704,
 951392386,
 78610,
 -1,
 951458100,
 78611,
 951662778,
 951457745,
 78608,
 -1,
 951589172,
 78609,
 951793852,
 951588593,
 78606,
 -1,
 951720244,
 78607,
 951924926,
 951718714,
 78601,
 -1,
 951851316,
 78602,
 -51009,
 951850529,
 78605,
 -51008,
 951981356,
 78604,
 -51007,
 952046680,
 78603,
 -51006,
 952111637,
 78600,
 -1,
 952176874,
 78599,
 952383696,
 951390442,
 -1,
 952449222,
 952309281,
 78619,
 -1,
 952375604,
 78620,
 952580296,
 952373482,
 78613,
 -1,
 952506676,
 78614,
 -50999,
 952506498,
 78623,
 -50998,
 952637393,
 78622,
 -50997,
 952702705,
 78621,
 -50996,
 952767788,
 78618,
 -50995,
 952833112,
 78617,
 -50994,
 952898362,
 78616,
 -50993,
 952963605,
 78615,
 -1,
 953028573,
 78612,
 953235675,
 952308245,
 -1,
 -50990,
 953161858,
 78633,
 -50989,
 953227217,
 78632,
 -50988,
 953292529,
 78631,
 -50987,
 953357857,
 78630,
 -50986,
 953423148,
 78629,
 -50985,
 953488472,
 78628,
 -50984,
 953553722,
 78627,
 -50983,
 953618965,
 78626,
 -50982,
 953684202,
 78625,
 -1,
 953749469,
 78624,
 954007551,
 953160506,
 -1,
 954022110,
 953881402,
 78638,
 -1,
 953948468,
 78639,
 954153184,
 953946645,
 78636,
 -1,
 954079540,
 78637,
 -50975,
 954078753,
 78642,
 -50974,
 954209580,
 78641,
 -50973,
 954274904,
 78640,
 -50972,
 954339562,
 78635,
 -1,
 954404829,
 78634,
 954611990,
 951337433,
 -1,
 954677491,
 954536469,
 -1,
 954743017,
 954603473,
 78066,
 -1,
 954669364,
 78067,
 954874091,
 954666973,
 78057,
 -1,
 954800436,
 78058,
 -50964,
 954800258,
 78068,
 -50963,
 954930929,
 78065,
 -50962,
 954996257,
 78064,
 -50961,
 955061548,
 78063,
 -50960,
 955126872,
 78062,
 -50959,
 955192122,
 78061,
 -50958,
 955257365,
 78060,
 -1,
 955322602,
 78059,
 955529472,
 954601706,
 -1,
 955594998,
 955455217,
 78053,
 -1,
 955521332,
 78054,
 955726072,
 955520545,
 78051,
 -1,
 955652404,
 78052,
 -50951,
 955652226,
 78056,
 -50950,
 955783121,
 78055,
 -50949,
 955847980,
 78050,
 -50948,
 955913304,
 78049,
 -50947,
 955978554,
 78048,
 -50946,
 956043797,
 78047,
 -50945,
 956109034,
 78046,
 -1,
 956174301,
 78045,
 956381452,
 955453405,
 -1,
 956446979,
 956307586,
 78043,
 -1,
 956373300,
 78044,
 956578053,
 956372945,
 78041,
 -1,
 956504372,
 78042,
 -50938,
 956503793,
 78040,
 -50937,
 956634657,
 78039,
 -50936,
 956699948,
 78038,
 -50935,
 956765272,
 78037,
 -50934,
 956830522,
 78036,
 -50933,
 956895765,
 78035,
 -1,
 956961002,
 78034,
 957218815,
 956306234,
 -1,
 957233423,
 957092952,
 78073,
 -1,
 957159732,
 78074,
 -50928,
 957159377,
 78077,
 -50927,
 957290225,
 78076,
 -50926,
 957355553,
 78075,
 -50925,
 957420346,
 78072,
 -50924,
 957485589,
 78071,
 -50923,
 957550826,
 78070,
 -1,
 957616093,
 78069,
 957823298,
 954590663,
 -1,
 957888816,
 957747434,
 -1,
 957954338,
 957814060,
 78842,
 -50918,
 957899137,
 78851,
 -50917,
 957962280,
 78850,
 -50916,
 958026482,
 78849,
 -50915,
 958090471,
 78848,
 -50914,
 958152899,
 78847,
 -50913,
 958216207,
 78846,
 -50912,
 958278884,
 78845,
 -50911,
 958342847,
 78844,
 -1,
 958404916,
 78843,
 958609707,
 957879841,
 78852,
 -50908,
 958552104,
 78860,
 -50907,
 958616306,
 78859,
 -50906,
 958680295,
 78858,
 -50905,
 958742723,
 78857,
 -50904,
 958806031,
 78856,
 -50903,
 958868708,
 78855,
 -50902,
 958932671,
 78854,
 -1,
 958994740,
 78853,
 -50900,
 958534744,
 78841,
 -50899,
 959124282,
 78840,
 -50898,
 959189525,
 78839,
 -50897,
 959254762,
 78838,
 -1,
 959320029,
 78837,
 959578111,
 957812701,
 -1,
 959592758,
 959451669,
 78821,
 -50893,
 959526927,
 78825,
 -50892,
 959589604,
 78824,
 -50891,
 959653567,
 78823,
 -1,
 959715636,
 78822,
 959920441,
 959517498,
 78826,
 -50888,
 959850175,
 78828,
 -1,
 959912244,
 78827,
 960117051,
 959845676,
 78831,
 -1,
 960043316,
 78832,
 960248125,
 960042072,
 78829,
 -1,
 960174388,
 78830,
 -50882,
 960174210,
 78836,
 -50881,
 960305105,
 78835,
 -50880,
 960370417,
 78834,
 -50879,
 960435745,
 78833,
 -1,
 960499946,
 78820,
 960706920,
 957786329,
 -1,
 960772432,
 960631018,
 -1,
 960837958,
 960697889,
 78530,
 -1,
 960764212,
 78531,
 960969032,
 960761821,
 78523,
 -1,
 960895284,
 78524,
 -50871,
 960895106,
 78534,
 -50870,
 961026001,
 78533,
 -50869,
 961091313,
 78532,
 -50868,
 961156396,
 78529,
 -50867,
 961221720,
 78528,
 -50866,
 961286970,
 78527,
 -50865,
 961352213,
 78526,
 -1,
 961417450,
 78525,
 961624413,
 960696285,
 -1,
 961689940,
 961549114,
 78514,
 -50861,
 961619647,
 78516,
 -1,
 961681716,
 78515,
 961886550,
 961614357,
 78512,
 -1,
 961812788,
 78513,
 -50857,
 961812610,
 78522,
 -50856,
 961943505,
 78521,
 -50855,
 962008817,
 78520,
 -50854,
 962074145,
 78519,
 -50853,
 962139436,
 78518,
 -50852,
 962204760,
 78517,
 -1,
 962269418,
 78511,
 962527231,
 961548821,
 -1,
 -50849,
 962402434,
 78544,
 -50848,
 962467793,
 78543,
 -50847,
 962533105,
 78542,
 -50846,
 962598433,
 78541,
 -50845,
 962663724,
 78540,
 -50844,
 962729048,
 78539,
 -50843,
 962794298,
 78538,
 -50842,
 962859541,
 78537,
 -50841,
 962924778,
 78536,
 -1,
 962990045,
 78535,
 963197324,
 960682785,
 -1,
 963262840,
 963121386,
 -1,
 963328364,
 963188689,
 78789,
 -1,
 963254580,
 78790,
 963459438,
 963254001,
 78787,
 -1,
 963385652,
 78788,
 963590512,
 963384408,
 78783,
 -1,
 963516724,
 78784,
 963721586,
 963514333,
 78778,
 -1,
 963647796,
 78779,
 -50829,
 963647618,
 78791,
 -50828,
 963778081,
 78786,
 -50827,
 963843372,
 78785,
 -50826,
 963908410,
 78782,
 -50825,
 963973653,
 78781,
 -1,
 964038890,
 78780,
 964245892,
 963186653,
 -1,
 964311419,
 964171906,
 78776,
 -1,
 964237620,
 78777,
 964442493,
 964236090,
 78769,
 -1,
 964368692,
 78770,
 -50818,
 964368337,
 78775,
 -50817,
 964499185,
 78774,
 -50816,
 964564513,
 78773,
 -50815,
 964629804,
 78772,
 -50814,
 964695128,
 78771,
 -50813,
 964760085,
 78768,
 -1,
 964825322,
 78767,
 965083135,
 964170261,
 -1,
 965097863,
 964957272,
 78796,
 -1,
 965024052,
 78797,
 -50808,
 965023020,
 78798,
 -50807,
 965153594,
 78795,
 -50806,
 965218837,
 78794,
 -50805,
 965284074,
 78793,
 -1,
 965349341,
 78792,
 965556652,
 963128600,
 -1,
 965622170,
 965480413,
 -1,
 965687698,
 965546517,
 77915,
 -50800,
 965618916,
 77918,
 -50799,
 965682879,
 77917,
 -1,
 965744948,
 77916,
 -50797,
 965613698,
 77925,
 -50796,
 965875665,
 77924,
 -50795,
 965940977,
 77923,
 -50794,
 966006305,
 77922,
 -50793,
 966071596,
 77921,
 -50792,
 966136920,
 77920,
 -50791,
 966202170,
 77919,
 -1,
 966267114,
 77914,
 966474150,
 965546218,
 -1,
 966539677,
 966397917,
 77926,
 -1,
 966465844,
 77927,
 -50786,
 966465666,
 77936,
 -50785,
 966596561,
 77935,
 -50784,
 966661873,
 77934,
 -50783,
 966727201,
 77933,
 -50782,
 966792492,
 77932,
 -50781,
 966857816,
 77931,
 -50780,
 966923066,
 77930,
 -50779,
 966988309,
 77929,
 -1,
 967053546,
 77928,
 967311359,
 966398485,
 -1,
 -50776,
 967185496,
 77941,
 -50775,
 967250746,
 77940,
 -50774,
 967315989,
 77939,
 -50773,
 967381226,
 77938,
 -1,
 967446493,
 77937,
 967653826,
 965501440,
 -1,
 967719353,
 967577565,
 -1,
 967784880,
 967645314,
 78225,
 -1,
 967711028,
 78226,
 967915954,
 967709996,
 78220,
 -1,
 967842100,
 78221,
 -50765,
 967841745,
 78224,
 -50764,
 967972593,
 78223,
 -50763,
 968037921,
 78222,
 -50762,
 968103000,
 78219,
 -50761,
 968168250,
 78218,
 -50760,
 968233493,
 78217,
 -1,
 968298730,
 78216,
 968556543,
 967643370,
 -1,
 968571324,
 968429802,
 78229,
 -1,
 968497460,
 78230,
 968702398,
 968495069,
 78227,
 -1,
 968628532,
 78228,
 -50753,
 968627500,
 78234,
 -50752,
 968758360,
 78233,
 -50751,
 968823610,
 78232,
 -1,
 968888853,
 78231,
 969095634,
 967614246,
 -1,
 969161167,
 969019357,
 -1,
 969226694,
 969085754,
 78494,
 -1,
 969152820,
 78495,
 969357768,
 969150698,
 78491,
 -1,
 969283892,
 78492,
 -50743,
 969283714,
 78501,
 -50742,
 969414609,
 78500,
 -50741,
 969479921,
 78499,
 -50740,
 969545249,
 78498,
 -50739,
 969610540,
 78497,
 -50738,
 969675864,
 78496,
 -1,
 969740821,
 78493,
 969998335,
 969085162,
 -1,
 -50735,
 969871594,
 78503,
 -1,
 969936861,
 78502,
 970144223,
 969073184,
 -1,
 970209750,
 970069080,
 78802,
 -50731,
 970139327,
 78804,
 -1,
 970201396,
 78803,
 970406360,
 970135505,
 78809,
 -1,
 970332468,
 78810,
 970537434,
 970331681,
 78806,
 -1,
 970463540,
 78807,
 -50725,
 970462961,
 78808,
 -50724,
 970593580,
 78805,
 -50723,
 970658618,
 78801,
 -50722,
 970723861,
 78800,
 -1,
 970789098,
 78799,
 970996202,
 970093711,
 -1,
 971061730,
 970921505,
 78249,
 -1,
 970987828,
 78250,
 971192804,
 970986005,
 78244,
 -1,
 971118900,
 78245,
 -50715,
 971118545,
 78252,
 -50714,
 971249393,
 78251,
 -50713,
 971314476,
 78248,
 -50712,
 971379800,
 78247,
 -50711,
 971445050,
 78246,
 -1,
 971509994,
 78243,
 971717109,
 970925777,
 -1,
 971782637,
 971642156,
 77908,
 -1,
 971708724,
 77909,
 -50706,
 971708546,
 77913,
 -50705,
 971839441,
 77912,
 -50704,
 971904753,
 77911,
 -50703,
 971970081,
 77910,
 -50702,
 972035160,
 77907,
 -50701,
 972100410,
 77906,
 -50700,
 972165653,
 77905,
 -1,
 972230890,
 77904,
 972438015,
 971694960,
 -1,
 972503544,
 972361962,
 78811,
 -1,
 972429620,
 78812,
 -50695,
 972429265,
 78819,
 -50694,
 972560113,
 78818,
 -50693,
 972625441,
 78817,
 -50692,
 972690732,
 78816,
 -50691,
 972756056,
 78815,
 -50690,
 972821306,
 78814,
 -1,
 972886549,
 78813,
 973093385,
 972380218,
 -1,
 973158914,
 973018657,
 78212,
 -1,
 973084980,
 78213,
 -50685,
 973084625,
 78215,
 -50684,
 973215473,
 78214,
 -50683,
 973280556,
 78211,
 -50682,
 973345880,
 78210,
 -50681,
 973411130,
 78209,
 -50680,
 973476373,
 78208,
 -1,
 973541610,
 78207,
 973748754,
 973041864,
 -1,
 -50677,
 973674449,
 78242,
 -50676,
 973739761,
 78241,
 -50675,
 973805089,
 78240,
 -50674,
 973870380,
 78239,
 -50673,
 973935704,
 78238,
 -50672,
 974000954,
 78237,
 -50671,
 974066197,
 78236,
 -1,
 974131434,
 78235,
 974389247,
 973711085,
 -1,
 -50668,
 974264049,
 78510,
 -50667,
 974329377,
 78509,
 -50666,
 974394668,
 78508,
 -50665,
 974459992,
 78507,
 -50664,
 974525242,
 78506,
 -50663,
 974590485,
 78505,
 -1,
 974655722,
 78504,
 -1,
 896815858,
 129370,
 974928605,
 896778898,
 -1,
 974994139,
 974871925,
 -1,
 975059657,
 974959959,
 -1,
 975125192,
 975037652,
 -1,
 975190586,
 975056100,
 -1,
 975256120,
 975121636,
 -1,
 975321649,
 975198248,
 -1,
 975387178,
 975263784,
 -1,
 975452709,
 975323331,
 43813,
 -1,
 975388867,
 43812,
 975583783,
 975378740,
 43808,
 -1,
 975509812,
 43811,
 -50648,
 975556125,
 43809,
 -50647,
 975671441,
 43814,
 -1,
 975724929,
 43810,
 975911468,
 975323331,
 11709,
 -1,
 975847619,
 11708,
 976042542,
 975837492,
 11704,
 -1,
 975968564,
 11707,
 -50641,
 976014877,
 11705,
 -50640,
 976130193,
 11710,
 -1,
 976183681,
 11706,
 976370227,
 975257795,
 11693,
 -1,
 976306371,
 11692,
 976501301,
 976296244,
 11688,
 -1,
 976427316,
 11691,
 -50634,
 976473629,
 11689,
 -50633,
 976588945,
 11694,
 -1,
 976642433,
 11690,
 -50631,
 975212763,
 11655,
 -1,
 976772642,
 11664,
 976960075,
 975131378,
 -1,
 977025603,
 976937740,
 -1,
 977091134,
 976961731,
 11741,
 -1,
 977027267,
 11740,
 977222208,
 977017140,
 11736,
 -1,
 977148212,
 11739,
 -50623,
 977194525,
 11737,
 -50622,
 977309841,
 11742,
 -1,
 977363329,
 11738,
 977549897,
 976967699,
 -1,
 977615430,
 977486019,
 11670,
 -1,
 977551555,
 11669,
 977746504,
 977541428,
 11667,
 -1,
 977672500,
 4895,
 -1,
 977691009,
 11668,
 -50614,
 977506523,
 4879,
 -1,
 977895066,
 11658,
 978074205,
 976893967,
 -1,
 978139733,
 978008079,
 -1,
 978205268,
 978081832,
 -1,
 978270800,
 978141379,
 43789,
 -1,
 978206915,
 43788,
 -50607,
 978243101,
 43785,
 -50606,
 978358417,
 43790,
 -50605,
 978411905,
 43786,
 -1,
 978459116,
 43787,
 -1,
 978161883,
 11661,
 978729564,
 978118077,
 -1,
 978795096,
 978665667,
 43797,
 -1,
 978731203,
 43796,
 -50599,
 978767389,
 43793,
 -50598,
 978882705,
 43798,
 -50597,
 978936193,
 43794,
 -1,
 978983404,
 43795,
 -1,
 978686171,
 11660,
 979253869,
 978040151,
 -1,
 979319398,
 979219799,
 -1,
 979384929,
 979255491,
 11685,
 -1,
 979321027,
 11684,
 979516003,
 979310900,
 11680,
 -1,
 979441972,
 11683,
 -50588,
 979488285,
 11681,
 -50587,
 979603601,
 11686,
 -1,
 979657089,
 11682,
 979843691,
 979256021,
 -1,
 -50584,
 979805895,
 5004,
 -50583,
 979863816,
 4992,
 -50582,
 979915502,
 5000,
 -1,
 979971276,
 4996,
 -50580,
 979800283,
 11651,
 -1,
 980114978,
 11652,
 980302459,
 979183295,
 -1,
 980367990,
 980231871,
 -1,
 980433521,
 980304067,
 43821,
 -1,
 980369603,
 43820,
 980564595,
 980359476,
 43816,
 -1,
 980490548,
 43819,
 -50572,
 980536861,
 43817,
 -50571,
 980652177,
 43822,
 -1,
 980705665,
 43818,
 980892282,
 980343524,
 -1,
 980957817,
 980828355,
 4999,
 -1,
 980893891,
 4998,
 -1,
 980902273,
 4997,
 -1,
 980848859,
 11653,
 981219974,
 980271762,
 -1,
 981285507,
 981190041,
 -1,
 981351039,
 981221571,
 43781,
 -1,
 981287107,
 43780,
 -50560,
 981323293,
 43777,
 -50559,
 981438609,
 43782,
 -50558,
 981492097,
 43778,
 -1,
 981539308,
 43779,
 -50556,
 981264163,
 4935,
 -50555,
 981700827,
 11654,
 -1,
 981753378,
 11663,
 981940880,
 981198269,
 -1,
 982006415,
 981919165,
 -1,
 982071946,
 981942467,
 11701,
 -1,
 982008003,
 11700,
 982203020,
 981997876,
 11696,
 -1,
 982128948,
 11699,
 -50547,
 982175261,
 11697,
 -50546,
 982290577,
 11702,
 -1,
 982344065,
 11698,
 -1,
 981962971,
 11659,
 982596250,
 981918209,
 -1,
 982661785,
 982573836,
 -1,
 982727316,
 982597827,
 11733,
 -1,
 982663363,
 11732,
 982858390,
 982653236,
 11728,
 -1,
 982784308,
 11731,
 -50537,
 982830621,
 11729,
 -50536,
 982945937,
 11734,
 -1,
 982999425,
 11730,
 -1,
 982618331,
 4743,
 983251620,
 982558418,
 -1,
 983317155,
 983229196,
 -1,
 983382686,
 983253187,
 11717,
 -1,
 983318723,
 11716,
 983513760,
 983308596,
 11712,
 -1,
 983439668,
 11715,
 -50527,
 983485981,
 11713,
 -50526,
 983601297,
 11718,
 -1,
 983654785,
 11714,
 -1,
 983273691,
 4679,
 983906990,
 983199883,
 -1,
 983972525,
 983884556,
 -1,
 984038056,
 983908547,
 11725,
 -1,
 983974083,
 11724,
 984169130,
 983963956,
 11720,
 -1,
 984095028,
 11723,
 -50517,
 984141341,
 11721,
 -50516,
 984256657,
 11726,
 -1,
 984310145,
 11722,
 -1,
 983929051,
 4783,
 984562357,
 983867085,
 -1,
 984627891,
 984537828,
 -1,
 984693426,
 984563907,
 5007,
 -1,
 984629443,
 5006,
 -1,
 984637825,
 5005,
 -50508,
 984584411,
 11666,
 -1,
 984833570,
 11665,
 985021115,
 984514693,
 -1,
 985086650,
 984996580,
 -1,
 985152185,
 985022659,
 4995,
 -1,
 985088195,
 4994,
 -1,
 985096577,
 4993,
 -1,
 985043163,
 11649,
 985414335,
 984961771,
 -1,
 985479870,
 985350339,
 5003,
 -1,
 985415875,
 5002,
 -1,
 985424257,
 5001,
 985676482,
 985368872,
 -1,
 -50495,
 985654567,
 11657,
 -1,
 985698523,
 11656,
 -50493,
 985654567,
 4847,
 -50492,
 985850178,
 4815,
 -50491,
 985903883,
 11650,
 -50490,
 985955785,
 11648,
 -50489,
 986017842,
 11662,
 -1,
 986078754,
 4615,
 -1,
 975061759,
 4960,
 986331862,
 975030595,
 -1,
 986397390,
 986265615,
 -1,
 986462925,
 986335462,
 5009,
 -1,
 986386135,
 5016,
 -1,
 986407861,
 5012,
 986659537,
 986345611,
 -1,
 -50480,
 986633453,
 5017,
 -1,
 986662590,
 5013,
 -50478,
 986637505,
 5008,
 -50477,
 986823195,
 5011,
 -50476,
 986886388,
 5010,
 -50475,
 986930288,
 5015,
 -1,
 986984569,
 5014,
 987234303,
 986264468,
 -1,
 987249370,
 987124945,
 -1,
 -50471,
 987202181,
 4959,
 -1,
 987242586,
 4957,
 -1,
 987224637,
 4958,
 -50468,
 974971393,
 983047,
 -1,
 987440831,
 983096,
 987642651,
 974877772,
 -1,
 987708178,
 987572248,
 -1,
 987773668,
 987662632,
 -1,
 -50463,
 987721643,
 66837,
 -50462,
 987775171,
 66835,
 -50461,
 987838841,
 66821,
 -1,
 987896116,
 66836,
 988101354,
 987714290,
 -1,
 988166888,
 988043304,
 -1,
 -50457,
 988102851,
 66853,
 -1,
 988159899,
 66854,
 -50455,
 988114859,
 66827,
 -1,
 988299459,
 66826,
 988494573,
 988079549,
 -1,
 -50452,
 988437173,
 66852,
 -1,
 988496067,
 66851,
 988691184,
 988463762,
 -1,
 -50449,
 988633781,
 66846,
 -1,
 988692675,
 66845,
 988887795,
 988656983,
 -1,
 -50446,
 988830389,
 66844,
 -1,
 988889283,
 66843,
 989084406,
 988850306,
 -1,
 -50443,
 989047626,
 66842,
 -1,
 989085891,
 66841,
 989281017,
 989033548,
 -1,
 -50440,
 989230925,
 66833,
 -1,
 989282499,
 66832,
 989477628,
 989229195,
 -1,
 -50437,
 989420213,
 66855,
 -1,
 989479107,
 66831,
 989674238,
 989413571,
 66824,
 -1,
 989618561,
 66823,
 989805313,
 989607951,
 -1,
 -50432,
 989747893,
 66822,
 -1,
 989806787,
 66820,
 990001924,
 989736164,
 -1,
 -50429,
 989944501,
 66819,
 -1,
 990003395,
 66818,
 -50427,
 989979404,
 66850,
 -50426,
 990175842,
 66849,
 -50425,
 990238435,
 66848,
 -50424,
 990301725,
 66847,
 -50423,
 990357281,
 66840,
 -50422,
 990421204,
 66839,
 -50421,
 990482577,
 66838,
 -50420,
 990544797,
 66834,
 -50419,
 990605227,
 66830,
 -50418,
 990667137,
 66829,
 -50417,
 990730933,
 66828,
 -50416,
 990793122,
 66825,
 -50415,
 990849129,
 66817,
 -1,
 990910772,
 66816,
 991116058,
 987644099,
 -1,
 991181593,
 991049510,
 -1,
 991247128,
 991100928,
 -1,
 -50410,
 991218103,
 128294,
 -50409,
 991273811,
 128268,
 -1,
 991329233,
 128161,
 -1,
 991174200,
 9191,
 -1,
 991142425,
 128024,
 -1,
 991055079,
 129501,
 991705904,
 987594885,
 -1,
 991771432,
 991662734,
 -1,
 991836963,
 991725313,
 -1,
 -50401,
 991761953,
 127999,
 -50400,
 991827244,
 127998,
 -50399,
 991892568,
 127997,
 -50398,
 991957818,
 127996,
 -1,
 992023014,
 127995,
 992280575,
 991769592,
 -1,
 -50395,
 992206188,
 129459,
 -50394,
 992259107,
 129456,
 -50393,
 992294824,
 129457,
 -1,
 992356181,
 129458,
 992608255,
 991733273,
 -1,
 992623405,
 992513635,
 128453,
 992739327,
 992544471,
 -1,
 -50388,
 992629906,
 128454,
 -1,
 992688143,
 128455,
 992885551,
 992583530,
 128460,
 -1,
 992851287,
 128461,
 -1,
 992820240,
 128459,
 993082178,
 991660328,
 -1,
 993147709,
 993015825,
 -1,
 993213244,
 993104332,
 -1,
 993278775,
 993182354,
 -1,
 993344310,
 993241653,
 983048,
 -1,
 993263989,
 983095,
 -1,
 993283089,
 983046,
 -50376,
 993245059,
 983134,
 -50375,
 993502687,
 983178,
 -50374,
 993559503,
 983099,
 -50373,
 993623119,
 983064,
 -1,
 993679280,
 983177,
 -1,
 993189587,
 128282,
 993934144,
 993122115,
 -1,
 -50369,
 993885229,
 128388,
 -1,
 993935290,
 128233,
 994181119,
 993896146,
 983051,
 -1,
 994103474,
 983050,
 994261839,
 993059329,
 -1,
 994327374,
 994232847,
 -1,
 994392909,
 994264598,
 -1,
 994458440,
 994368771,
 -1,
 -50361,
 994426447,
 128915,
 -1,
 994455799,
 128905,
 994655051,
 994424151,
 -1,
 -50358,
 994602729,
 128954,
 -1,
 994647906,
 128942,
 -50356,
 994596738,
 128935,
 -1,
 994791338,
 128948,
 -1,
 994321654,
 128125,
 -1,
 994289046,
 128529,
 995113820,
 994187572,
 -1,
 995179355,
 995076226,
 128066,
 995244888,
 995149212,
 -1,
 995310423,
 995196371,
 -1,
 995375958,
 995236148,
 -1,
 -50347,
 995342935,
 127759,
 -1,
 995394755,
 127758,
 -1,
 995314367,
 127757,
 -1,
 995275775,
 9178,
 995753983,
 995165436,
 -1,
 -50342,
 995667633,
 127806,
 -1,
 995721578,
 127805,
 -1,
 995120798,
 129413,
 995965791,
 995091446,
 128065,
 -50338,
 995931479,
 128064,
 -1,
 995972758,
 128083,
 996162403,
 995931479,
 -1,
 996227938,
 996093156,
 983104,
 -1,
 996155830,
 983103,
 -1,
 996153652,
 983135,
 996424551,
 996118673,
 -1,
 -50331,
 996393618,
 983049,
 -50330,
 996442245,
 983100,
 -1,
 996504652,
 983067,
 996686698,
 996398308,
 -1,
 -50327,
 996648149,
 127972,
 -1,
 996683359,
 127984,
 996883309,
 996651593,
 -1,
 -50324,
 996855130,
 11249,
 -1,
 996906159,
 11248,
 997079920,
 996845437,
 -1,
 -50321,
 997056140,
 11257,
 -1,
 997071485,
 11072,
 -50319,
 997054358,
 127794,
 -50318,
 997236521,
 983179,
 -50317,
 997289902,
 9167,
 -50316,
 997342171,
 11790,
 -1,
 997396227,
 128231,
 997606063,
 896673471,
 -1,
 997671021,
 997529908,
 -1,
 997736221,
 997623972,
 -1,
 997801746,
 997685899,
 -1,
 997867188,
 997760717,
 -1,
 997932716,
 997808766,
 -1,
 997997658,
 997867717,
 -1,
 998063032,
 997951784,
 -1,
 998128535,
 998003442,
 -1,
 998194055,
 998076555,
 -1,
 998259586,
 998166045,
 -1,
 -50303,
 998219469,
 92598,
 -1,
 998277253,
 92619,
 998456197,
 998197831,
 -1,
 -50300,
 998433281,
 92543,
 -1,
 998448109,
 92553,
 998703103,
 998381876,
 92531,
 -1,
 998580114,
 92601,
 998783888,
 998134514,
 -1,
 998849420,
 998755869,
 -1,
 -50294,
 998811948,
 92550,
 -50293,
 998874829,
 92624,
 -1,
 998906929,
 92563,
 999161855,
 998785219,
 -1,
 999177103,
 999083705,
 92607,
 -1,
 999146130,
 92535,
 -1,
 999113656,
 92557,
 999373714,
 998756025,
 92640,
 -1,
 999342738,
 92657,
 999504789,
 999329937,
 -1,
 -50284,
 999466706,
 92544,
 -1,
 999530189,
 92541,
 -50282,
 999443113,
 92579,
 -1,
 999627060,
 92658,
 999832481,
 998062095,
 -1,
 999898013,
 999758132,
 -1,
 999963548,
 999823670,
 -1,
 -50277,
 999931244,
 92562,
 -1,
 999983378,
 92637,
 -1,
 999923405,
 92518,
 1000225696,
 999842177,
 -1,
 -50273,
 1000187602,
 92558,
 -1,
 1000219154,
 92592,
 -1,
 1000198526,
 92528,
 1000487847,
 999780191,
 -1,
 1000553382,
 1000423619,
 -1,
 1000618917,
 1000489155,
 92628,
 -1,
 1000538798,
 92648,
 -1,
 1000592882,
 92547,
 -1,
 1000479735,
 92554,
 1000881068,
 1000454239,
 -1,
 1000946603,
 1000853021,
 -1,
 -50262,
 1000904450,
 92527,
 -1,
 1000947907,
 92545,
 -1,
 1000891279,
 92540,
 1001208751,
 1000859069,
 -1,
 -50258,
 1001182234,
 92609,
 -1,
 1001202194,
 92583,
 1001405362,
 1001186429,
 -1,
 -50255,
 1001337495,
 92589,
 -1,
 1001400588,
 92608,
 1001601973,
 1001374354,
 -1,
 -50252,
 1001574692,
 92604,
 -1,
 1001595306,
 92622,
 1001798583,
 1001527604,
 92662,
 -1,
 1001734339,
 92613,
 -1,
 1001747326,
 92584,
 1001995216,
 998022861,
 -1,
 1002060735,
 1001967133,
 92576,
 1002126269,
 1001986356,
 -1,
 -50244,
 1002088146,
 92618,
 -1,
 1002127555,
 92529,
 -50242,
 1002078341,
 92561,
 -1,
 1002258627,
 92649,
 1002453957,
 1001986356,
 -1,
 1002519490,
 1002379572,
 92524,
 -1,
 1002471557,
 92536,
 1002700799,
 1002440404,
 -1,
 -50236,
 1002602602,
 92634,
 -1,
 1002653688,
 92625,
 1002847177,
 1002398081,
 92663,
 1002962943,
 1002782915,
 -1,
 -50232,
 1002881682,
 92621,
 -1,
 1002915922,
 92593,
 1003109326,
 1002782915,
 -1,
 1003174861,
 1003081245,
 -1,
 -50228,
 1003151873,
 92647,
 -1,
 1003209362,
 92605,
 -1,
 1003111941,
 92548,
 1003487231,
 1003065489,
 92568,
 -1,
 1003394068,
 92610,
 1003568099,
 1001947269,
 -1,
 1003633622,
 1003493684,
 92667,
 1003699156,
 1003569347,
 92600,
 -1,
 1003651205,
 92542,
 -50219,
 1003661010,
 92668,
 -1,
 1003790029,
 92555,
 1003961304,
 1003577729,
 92654,
 -1,
 1003897781,
 92611,
 1004092379,
 1003902029,
 -1,
 -50214,
 1004029514,
 92581,
 -1,
 1004083508,
 92551,
 1004288990,
 1004021865,
 -1,
 -50211,
 1004261668,
 92520,
 -1,
 1004290243,
 92582,
 -50209,
 1004263658,
 92617,
 -50208,
 1004457657,
 92614,
 -50207,
 1004508180,
 92671,
 -50206,
 1004555763,
 92591,
 -1,
 1004619338,
 92666,
 1004813302,
 1003537042,
 -1,
 1004878826,
 1004738868,
 -1,
 1004944359,
 1004804404,
 92635,
 -1,
 1004906194,
 92577,
 -50200,
 1004906194,
 92636,
 -50199,
 1005027461,
 92530,
 -1,
 1005078122,
 92559,
 1005272046,
 1004850717,
 -1,
 1005337581,
 1005224069,
 92586,
 -1,
 1005263834,
 92569,
 -1,
 1005263834,
 92566,
 1005534194,
 1005228177,
 -1,
 1005599729,
 1005490321,
 92537,
 -1,
 1005553960,
 92519,
 -1,
 1005561554,
 92630,
 1005846527,
 1005469891,
 -1,
 1005861877,
 1005768221,
 92669,
 -1,
 1005788187,
 92572,
 -1,
 1005816104,
 92672,
 1006058504,
 1004790540,
 -1,
 1006124028,
 1006030365,
 -1,
 -50183,
 1006085842,
 92644,
 -50182,
 1006143784,
 92645,
 -50181,
 1006192722,
 92594,
 -1,
 1006246916,
 92641,
 1006451713,
 1006062151,
 -1,
 1006517247,
 1006377946,
 92567,
 -1,
 1006486162,
 92623,
 -50176,
 1006494209,
 92639,
 -1,
 1006600325,
 92606,
 1006779396,
 1006409800,
 -1,
 -50173,
 1006748162,
 92642,
 -1,
 1006777717,
 92643,
 1006976007,
 1006723457,
 -1,
 -50170,
 1006944914,
 92590,
 -1,
 1006977973,
 92564,
 -1,
 1006903722,
 92588,
 1007238164,
 1006024023,
 -1,
 1007303694,
 1007179816,
 -1,
 1007369228,
 1007259793,
 92659,
 -1,
 1007331026,
 92660,
 -50163,
 1007315896,
 92638,
 -1,
 1007438445,
 92580,
 1007631377,
 1007239363,
 -1,
 -50160,
 1007600274,
 92560,
 -1,
 1007632579,
 92534,
 -50158,
 1007603394,
 92571,
 -50157,
 1007784851,
 92525,
 -1,
 1007819244,
 92549,
 1008024609,
 1007187020,
 -1,
 1008090139,
 1007980689,
 -1,
 1008155673,
 1008046225,
 -1,
 -50152,
 1008124562,
 92556,
 -1,
 1008175400,
 92523,
 -50150,
 1008117458,
 92664,
 -1,
 1008304261,
 92539,
 1008483359,
 1008015668,
 -1,
 -50147,
 1008445138,
 92633,
 -50146,
 1008508621,
 92521,
 -1,
 1008541545,
 92575,
 -50144,
 1008455197,
 92653,
 -1,
 1008683610,
 92595,
 1008876590,
 1007972491,
 -1,
 1008942118,
 1008848413,
 -1,
 -50140,
 1008910994,
 92620,
 -50139,
 1008965378,
 92538,
 -1,
 1009011156,
 92587,
 1009204267,
 1008877763,
 -1,
 1009269802,
 1009176093,
 -1,
 -50135,
 1009246721,
 92646,
 -1,
 1009261530,
 92570,
 -1,
 1009238674,
 92599,
 -50132,
 1009164808,
 92532,
 -50131,
 1009488017,
 92665,
 -1,
 1009541505,
 92670,
 1009728570,
 1008815335,
 -1,
 1009794102,
 1009700381,
 -1,
 1009859636,
 1009713152,
 -1,
 -50126,
 1009822947,
 92661,
 -50125,
 1009869185,
 92616,
 -1,
 1009921388,
 92626,
 1010171903,
 1009795267,
 92596,
 -1,
 1010090642,
 92612,
 1010252856,
 1009719604,
 92603,
 -1,
 1010214610,
 92673,
 -50119,
 1010209683,
 92627,
 -1,
 1010320309,
 92651,
 1010515015,
 1009668850,
 -1,
 1010580548,
 1010456616,
 -1,
 1010646082,
 1010516163,
 -1,
 1010711617,
 1010617885,
 -1,
 -50113,
 1010688513,
 92552,
 -50112,
 1010731304,
 92565,
 -1,
 1010768858,
 92615,
 -1,
 1010680466,
 92602,
 -50109,
 1010602899,
 92674,
 -1,
 1010964988,
 92578,
 1011220479,
 1010509929,
 -1,
 -50106,
 1011144178,
 92597,
 -1,
 1011204754,
 92585,
 1011366989,
 1010477186,
 -1,
 1011432523,
 1011292468,
 -1,
 -50102,
 1011394258,
 92526,
 -1,
 1011433667,
 92656,
 -50100,
 1011377721,
 92546,
 -1,
 1011567324,
 92655,
 1011760210,
 1011342052,
 -1,
 1011825745,
 1011731997,
 -1,
 -50096,
 1011781777,
 92533,
 -1,
 1011826883,
 92650,
 -1,
 1011763932,
 92574,
 1012087895,
 1011734008,
 -1,
 1012153430,
 1012023491,
 -1,
 -50091,
 1012125369,
 92573,
 -1,
 1012154563,
 92652,
 -1,
 1012110227,
 92522,
 -50088,
 1012043921,
 92631,
 -50087,
 1012359553,
 92632,
 -1,
 1012406580,
 92629,
 1012612353,
 997931025,
 -1,
 1012677775,
 1012566312,
 -1,
 1012743277,
 1012617970,
 -1,
 1012808805,
 1012691083,
 -1,
 1012874337,
 1012746823,
 -1,
 -50080,
 1012837980,
 92432,
 -1,
 1012866075,
 92457,
 -50078,
 1012851721,
 92435,
 -50077,
 1013043582,
 92412,
 -50076,
 1013080975,
 92476,
 -1,
 1013129642,
 92414,
 1013383167,
 1012749042,
 -1,
 1013398634,
 1013258548,
 -1,
 1013464169,
 1013325673,
 92465,
 -1,
 1013390298,
 92409,
 -1,
 1013423821,
 92483,
 -50069,
 1013373744,
 92467,
 -50068,
 1013633655,
 92485,
 -1,
 1013664476,
 92475,
 1013857397,
 1012690783,
 -1,
 1013922928,
 1013801345,
 92403,
 -1,
 1013859253,
 92405,
 1014054003,
 1013860935,
 -1,
 -50062,
 1014022802,
 92407,
 -1,
 1014045677,
 92430,
 -50060,
 1014026359,
 92487,
 -1,
 1014178218,
 92418,
 1014381693,
 1013822807,
 -1,
 1014447225,
 1014326159,
 -1,
 -50056,
 1014416018,
 92459,
 -1,
 1014472397,
 92447,
 1014643836,
 1014388776,
 -1,
 -50053,
 1014617484,
 92486,
 -1,
 1014645685,
 92408,
 -1,
 1014616356,
 92480,
 1014905986,
 1014358796,
 -1,
 -50049,
 1014878296,
 92463,
 -50048,
 1014915457,
 92493,
 -50047,
 1014974932,
 92450,
 -1,
 1015029609,
 92410,
 1015233672,
 1014839311,
 -1,
 1015299206,
 1015169219,
 -1,
 -50043,
 1015272946,
 92425,
 -1,
 1015300291,
 92437,
 -50041,
 1015256084,
 92440,
 -1,
 1015422825,
 92471,
 1015626893,
 1015202450,
 -1,
 1015692428,
 1015562435,
 -1,
 -50037,
 1015664932,
 92472,
 -1,
 1015693507,
 92505,
 -1,
 1015666152,
 92514,
 -50034,
 1015598621,
 92503,
 -1,
 1015898497,
 92507,
 1016085674,
 1012629637,
 92497,
 1016151191,
 1016024295,
 -1,
 1016216723,
 1016107153,
 92445,
 -1,
 1016170792,
 92404,
 1016347798,
 1016154695,
 -1,
 -50027,
 1016316562,
 92424,
 -1,
 1016339418,
 92458,
 -1,
 1016292239,
 92466,
 1016609947,
 1016091725,
 -1,
 -50023,
 1016566293,
 92438,
 -50022,
 1016619919,
 92444,
 -1,
 1016679048,
 92442,
 1016872096,
 1016545475,
 -1,
 1016937631,
 1016843805,
 -1,
 -50018,
 1016906386,
 92427,
 -1,
 1016957224,
 92478,
 -1,
 1016873912,
 92496,
 1017199780,
 1016800959,
 -1,
 1017265315,
 1017125356,
 92448,
 -1,
 1017186520,
 92515,
 -1,
 1017238132,
 92401,
 1017461927,
 1017125172,
 -1,
 -50010,
 1017411575,
 92426,
 -1,
 1017464625,
 92482,
 -50008,
 1017436686,
 92510,
 -50007,
 1017630237,
 92499,
 -1,
 1017681377,
 92441,
 1017855165,
 1016051031,
 -1,
 1017920692,
 1017796648,
 -1,
 1017986225,
 1017856195,
 -1,
 1018051760,
 1017957917,
 -1,
 -50001,
 1018028545,
 92501,
 -1,
 1018043354,
 92417,
 -1,
 1017987267,
 92413,
 -49998,
 1017957917,
 92504,
 -49997,
 1018271813,
 92508,
 -1,
 1018324363,
 92500,
 1018510520,
 1017892381,
 -1,
 -49994,
 1018482205,
 92498,
 -49993,
 1018511555,
 92419,
 -1,
 1018567642,
 92473,
 1018772667,
 1018435892,
 -1,
 -49990,
 1018734290,
 92516,
 -1,
 1018797773,
 92423,
 -49988,
 1018730935,
 92452,
 -1,
 1018907245,
 92428,
 1019100363,
 1017802891,
 -1,
 1019165893,
 1019035843,
 -1,
 1019231428,
 1019137565,
 -1,
 -49983,
 1019190989,
 92460,
 -49982,
 1019255237,
 92431,
 -49981,
 1019314309,
 92454,
 -1,
 1019354173,
 92415,
 -1,
 1019200146,
 92420,
 1019624649,
 1019137565,
 92489,
 -49977,
 1019586258,
 92479,
 -49976,
 1019646867,
 92422,
 -1,
 1019709736,
 92474,
 -49974,
 1019601929,
 92502,
 -1,
 1019861813,
 92449,
 1020017879,
 1019069074,
 -1,
 1020083410,
 1019953347,
 -1,
 1020148945,
 1020055069,
 -1,
 -49969,
 1020117650,
 92416,
 -49968,
 1020168488,
 92481,
 -1,
 1020206084,
 92451,
 -1,
 1020085176,
 92456,
 1020476628,
 1020055069,
 92433,
 -1,
 1020434871,
 92477,
 -49963,
 1020434501,
 92492,
 -49962,
 1020551553,
 92513,
 -1,
 1020599258,
 92491,
 1020804321,
 1019966540,
 -1,
 1020869854,
 1020739779,
 -1,
 1020935388,
 1020841501,
 -1,
 -49957,
 1020887173,
 92484,
 -1,
 1020926993,
 92439,
 -49955,
 1020904082,
 92464,
 -1,
 1021068216,
 92495,
 -49953,
 1020842276,
 92446,
 -49952,
 1021220933,
 92511,
 -1,
 1021272975,
 92406,
 1021459690,
 1020763853,
 -1,
 1021525221,
 1021431325,
 -1,
 -49948,
 1021498764,
 92443,
 -1,
 1021552338,
 92509,
 1021721832,
 1021460675,
 -1,
 -49945,
 1021695379,
 92462,
 -1,
 1021722819,
 92506,
 -49943,
 1021668212,
 92461,
 -1,
 1021845930,
 92469,
 1022049522,
 1021436684,
 -1,
 1022115056,
 1022021149,
 -1,
 1022180591,
 1022070929,
 -1,
 -49938,
 1022140109,
 92470,
 -1,
 1022197893,
 92468,
 -1,
 1022157152,
 92453,
 -49935,
 1022051914,
 92429,
 -1,
 1022368765,
 92421,
 1022573816,
 1022011522,
 -1,
 1022639350,
 1022510669,
 -1,
 -49931,
 1022595823,
 92490,
 -1,
 1022658660,
 92512,
 -49929,
 1022584203,
 92494,
 -1,
 1022761965,
 92455,
 1022967035,
 1022548708,
 -1,
 -49926,
 1022938818,
 92411,
 -1,
 1022960042,
 92402,
 1023163646,
 1022907760,
 -1,
 -49923,
 1023101525,
 92488,
 -1,
 1023154668,
 92434,
 1023410175,
 1023102183,
 -1,
 -49920,
 1023298163,
 92436,
 -1,
 1023351276,
 92517,
 1023557012,
 1012542694,
 -1,
 1023622454,
 1023510824,
 -1,
 1023687952,
 1023562482,
 -1,
 1023753483,
 1023628018,
 -1,
 1023819018,
 1023725085,
 92362,
 -49913,
 1023775764,
 92341,
 -49912,
 1023836293,
 92347,
 -49911,
 1023886376,
 92370,
 -1,
 1023941640,
 92336,
 -1,
 1023755850,
 92307,
 1024212238,
 1023701131,
 -1,
 -49907,
 1024184415,
 92303,
 -1,
 1024205330,
 92309,
 -49905,
 1024168851,
 92368,
 -1,
 1024336402,
 92395,
 1024539928,
 1023653207,
 -1,
 1024605460,
 1024511517,
 -1,
 -49901,
 1024563662,
 92359,
 -1,
 1024624936,
 92374,
 -49899,
 1024562067,
 92371,
 -49898,
 1024743977,
 92351,
 -49897,
 1024805472,
 92325,
 -1,
 1024858420,
 92350,
 1025064225,
 1024473103,
 -1,
 1025129756,
 1025002055,
 -1,
 -49893,
 1025098386,
 92349,
 -1,
 1025121311,
 92308,
 1025326367,
 1025055028,
 -1,
 -49890,
 1025285837,
 92378,
 -1,
 1025343621,
 92375,
 -49888,
 1025283043,
 92317,
 -1,
 1025467166,
 92331,
 1025654057,
 1025011551,
 -1,
 1025719589,
 1025589443,
 -1,
 -49884,
 1025693170,
 92389,
 -1,
 1025721272,
 92360,
 1025916200,
 1025644852,
 -1,
 -49881,
 1025867909,
 92367,
 -1,
 1025918469,
 92356,
 -1,
 1025888375,
 92333,
 1026178351,
 1025622674,
 -1,
 1026243885,
 1026113731,
 -1,
 -49876,
 1026216504,
 92345,
 -1,
 1026263336,
 92372,
 -49874,
 1026215469,
 92314,
 -1,
 1026365932,
 92340,
 1026571570,
 1026155965,
 -1,
 -49871,
 1026509444,
 92323,
 -1,
 1026562356,
 92304,
 1026768181,
 1026496820,
 -1,
 -49868,
 1026729682,
 92396,
 -1,
 1026789060,
 92338,
 -1,
 1026745516,
 92313,
 1027030355,
 1023574149,
 -1,
 1027095881,
 1026959039,
 -1,
 1027161406,
 1027031235,
 -1,
 1027226940,
 1027132957,
 -1,
 -49861,
 1027203585,
 92385,
 -1,
 1027244165,
 92315,
 -49859,
 1027189036,
 92354,
 -1,
 1027360138,
 92311,
 1027554625,
 1027105153,
 92381,
 -49856,
 1027523218,
 92326,
 -1,
 1027583698,
 92343,
 1027751238,
 1027479860,
 -1,
 1027816773,
 1027676470,
 -1,
 -49852,
 1027777104,
 92387,
 -1,
 1027812648,
 92318,
 -1,
 1027772536,
 92383,
 1028128767,
 1027722781,
 -1,
 -49848,
 1028014275,
 92324,
 -1,
 1028070381,
 92364,
 1028275536,
 1027021108,
 -1,
 1028341069,
 1028210883,
 -1,
 -49844,
 1028307540,
 92363,
 -1,
 1028358953,
 92382,
 1028587519,
 1028259840,
 -1,
 -49841,
 1028493020,
 92376,
 -1,
 1028551253,
 92339,
 -49839,
 1028247225,
 92391,
 -49838,
 1028678543,
 92390,
 -1,
 1028740197,
 92344,
 1028930916,
 1026977931,
 -1,
 1028996447,
 1028866243,
 -1,
 1029061979,
 1028967965,
 -1,
 1029127513,
 1029027159,
 -1,
 -49832,
 1029069845,
 92319,
 -1,
 1029130972,
 92384,
 -49830,
 1029079173,
 92386,
 -1,
 1029271907,
 92321,
 1029455198,
 1029015850,
 -1,
 -49827,
 1029404359,
 92393,
 -1,
 1029459354,
 92394,
 -1,
 1029423762,
 92361,
 1029717346,
 1028967965,
 -1,
 -49823,
 1029685906,
 92366,
 -1,
 1029740303,
 92373,
 -49821,
 1029677095,
 92328,
 -1,
 1029839340,
 92329,
 1030045035,
 1028907788,
 -1,
 1030110569,
 1030016541,
 -1,
 -49817,
 1030087008,
 92388,
 -49816,
 1030127749,
 92305,
 -1,
 1030161602,
 92322,
 -49814,
 1030048415,
 92327,
 -1,
 1030298092,
 92377,
 1030503795,
 1030013586,
 -1,
 1030569327,
 1030450512,
 -1,
 -49810,
 1030540999,
 92358,
 -1,
 1030560192,
 92334,
 1030765938,
 1030504643,
 -1,
 -49807,
 1030739352,
 92346,
 -1,
 1030800018,
 92400,
 -1,
 1030691340,
 92332,
 1031028091,
 1030468951,
 -1,
 1031093623,
 1030969384,
 -1,
 -49802,
 1031065719,
 92379,
 -1,
 1031105464,
 92392,
 1031290234,
 1031028931,
 -1,
 -49799,
 1031263730,
 92330,
 -1,
 1031325076,
 92380,
 -1,
 1031261907,
 92335,
 1031552385,
 1030976588,
 -1,
 1031617919,
 1031477556,
 -1,
 -49794,
 1031577293,
 92342,
 -1,
 1031635077,
 92357,
 -49792,
 1031589405,
 92365,
 -1,
 1031760824,
 92397,
 1031945606,
 1031511757,
 -1,
 1032011141,
 1031889281,
 -1,
 -49788,
 1031974610,
 92316,
 -1,
 1032030504,
 92398,
 -1,
 1031947850,
 92399,
 1032273291,
 1031885554,
 -1,
 1032338826,
 1032214590,
 -1,
 -49783,
 1032300844,
 92310,
 -1,
 1032363725,
 92320,
 -1,
 1032267842,
 92312,
 1032600974,
 1032248036,
 -1,
 -49779,
 1032573576,
 92369,
 -1,
 1032593650,
 92306,
 1032797585,
 1032575181,
 -1,
 -49776,
 1032774145,
 92337,
 -1,
 1032789013,
 92353,
 -49774,
 1032762563,
 92355,
 -49773,
 1032934109,
 92348,
 -1,
 1032989817,
 92352,
 1033190930,
 1023482166,
 -1,
 1033256376,
 1033144616,
 -1,
 1033321884,
 1033224850,
 -1,
 1033387419,
 1033249194,
 92223,
 1033502719,
 1033306112,
 -1,
 -49766,
 1033408300,
 92194,
 -1,
 1033471214,
 92185,
 -1,
 1033345113,
 92178,
 1033715106,
 1033261810,
 -1,
 1033780640,
 1033663480,
 -1,
 -49761,
 1033736331,
 92182,
 -1,
 1033766045,
 92160,
 -49759,
 1033721069,
 92229,
 -1,
 1033904415,
 92173,
 1034108326,
 1033691916,
 -1,
 1034173861,
 1034051969,
 92239,
 -1,
 1034142415,
 92225,
 -1,
 1034111444,
 92233,
 1034370473,
 1034085821,
 -1,
 -49752,
 1034342785,
 92191,
 -1,
 1034361172,
 92167,
 1034567084,
 1034336351,
 -1,
 -49749,
 1034511247,
 92237,
 -1,
 1034557748,
 92241,
 1034763695,
 1034514571,
 -1,
 -49746,
 1034708872,
 92180,
 -1,
 1034754566,
 92227,
 1034960306,
 1034696862,
 -1,
 -49743,
 1034887387,
 92212,
 -1,
 1034945554,
 92201,
 1035156917,
 1034885428,
 -1,
 -49740,
 1035118290,
 92245,
 -1,
 1035147604,
 92164,
 -49738,
 1035104149,
 92231,
 -49737,
 1035298194,
 92204,
 -1,
 1035355722,
 92244,
 1035550159,
 1033207941,
 -1,
 1035615684,
 1035475252,
 -1,
 1035681218,
 1035550915,
 -1,
 1035746751,
 1035632773,
 92238,
 -49731,
 1035720928,
 92174,
 -49730,
 1035760575,
 92203,
 -1,
 1035807068,
 92171,
 -49728,
 1035713108,
 92230,
 -49727,
 1035964536,
 92210,
 -1,
 1036022365,
 92186,
 -49725,
 1035640550,
 92221,
 -1,
 1036160760,
 92175,
 1036336585,
 1035571345,
 -1,
 1036402120,
 1036293011,
 -1,
 -49721,
 1036363414,
 92198,
 -1,
 1036405453,
 92214,
 -1,
 1036355885,
 92190,
 1036664268,
 1036265204,
 -1,
 -49717,
 1036625618,
 92246,
 -1,
 1036685432,
 92232,
 -49715,
 1036638417,
 92176,
 -49714,
 1036801119,
 92196,
 -1,
 1036864140,
 92197,
 1037057503,
 1035515223,
 -1,
 1037123032,
 1036998696,
 -1,
 1037188564,
 1037094429,
 -1,
 -49709,
 1037140101,
 92215,
 -1,
 1037190997,
 92165,
 1037385175,
 1037132161,
 -1,
 -49706,
 1037347116,
 92222,
 -1,
 1037404802,
 92168,
 -1,
 1037342796,
 92224,
 1037647324,
 1037078673,
 -1,
 -49702,
 1037615762,
 92235,
 -49701,
 1037674194,
 92220,
 -1,
 1037733235,
 92208,
 -49699,
 1037620712,
 92181,
 -49698,
 1037855889,
 92195,
 -1,
 1037912728,
 92177,
 1038106096,
 1037016781,
 -1,
 1038171623,
 1038031156,
 -1,
 1038237156,
 1038096692,
 -1,
 -49693,
 1038199084,
 92226,
 -1,
 1038254213,
 92236,
 -49691,
 1038203086,
 92187,
 -49690,
 1038387230,
 92189,
 -1,
 1038418962,
 92200,
 1038630382,
 1038128151,
 -1,
 1038695915,
 1038589740,
 -1,
 -49686,
 1038636149,
 92169,
 -1,
 1038690036,
 92170,
 1038942207,
 1038648563,
 -1,
 -49683,
 1038832757,
 92162,
 -1,
 1038886644,
 92163,
 -49681,
 1038602888,
 92205,
 -1,
 1039026644,
 92202,
 1039220217,
 1038053515,
 -1,
 1039285748,
 1039155395,
 -1,
 -49677,
 1039257804,
 92179,
 -1,
 1039319698,
 92211,
 1039482359,
 1039210804,
 -1,
 -49674,
 1039443666,
 92240,
 -1,
 1039486268,
 92199,
 -49672,
 1039454852,
 92213,
 -1,
 1039639719,
 92219,
 1039810049,
 1039188626,
 -1,
 1039875581,
 1039781405,
 -1,
 -49668,
 1039801361,
 92206,
 -1,
 1039860844,
 92172,
 1040072192,
 1039813191,
 -1,
 -49665,
 1040041352,
 92209,
 -1,
 1040063492,
 92234,
 -1,
 1040018790,
 92166,
 1040334343,
 1039758412,
 -1,
 1040399876,
 1040305693,
 92243,
 -1,
 1040325649,
 92207,
 -49659,
 1040356362,
 92216,
 -49658,
 1040468443,
 92184,
 -1,
 1040523697,
 92183,
 1040727564,
 1040274162,
 -1,
 1040793099,
 1040669711,
 -1,
 -49654,
 1040754988,
 92188,
 -1,
 1040799129,
 92193,
 -1,
 1040722339,
 92161,
 1041055247,
 1040698909,
 -1,
 -49650,
 1041010054,
 92228,
 -1,
 1041043037,
 92192,
 -49648,
 1041028916,
 92242,
 -49647,
 1041216350,
 92218,
 -1,
 1041256272,
 92217,
 1041448547,
 1033119425,
 -1,
 1041514022,
 1041399941,
 -1,
 1041579547,
 1041442495,
 -1,
 1041645080,
 1041504564,
 -1,
 -49641,
 1041572416,
 92255,
 -1,
 1041630308,
 92252,
 -49639,
 1041617540,
 92292,
 -49638,
 1041788247,
 92268,
 -1,
 1041844912,
 92286,
 1042038303,
 1041504564,
 92300,
 1042153471,
 1041958100,
 -1,
 -49634,
 1042076701,
 92296,
 -1,
 1042106982,
 92295,
 1042300450,
 1041976551,
 -1,
 -49631,
 1042256977,
 92267,
 -1,
 1042313024,
 92284,
 1042497061,
 1042238023,
 -1,
 -49628,
 1042465500,
 92290,
 -1,
 1042523858,
 92281,
 -1,
 1042454118,
 92287,
 1042759223,
 1041467688,
 -1,
 1042824751,
 1042698994,
 -1,
 1042890285,
 1042764530,
 -1,
 1042955819,
 1042862724,
 92282,
 -1,
 1042875403,
 92283,
 -49620,
 1042893386,
 92277,
 -1,
 1043012088,
 92298,
 -49618,
 1042846611,
 92302,
 -1,
 1043165925,
 92276,
 1043349042,
 1042801420,
 -1,
 -49615,
 1043292570,
 92269,
 -1,
 1043340273,
 92288,
 1043545653,
 1043314007,
 -1,
 -49612,
 1043489011,
 92247,
 -1,
 1043547722,
 92299,
 -49610,
 1043515289,
 92260,
 -1,
 1043677232,
 92261,
 1043873343,
 1042724183,
 -1,
 1043938875,
 1043815093,
 -1,
 -49606,
 1043910348,
 92266,
 -1,
 1043972837,
 92265,
 -49604,
 1043910744,
 92285,
 -49603,
 1044079503,
 92249,
 -49602,
 1044138466,
 92250,
 -1,
 1044192789,
 92279,
 1044397640,
 1043820683,
 -1,
 1044463172,
 1044335175,
 -1,
 -49598,
 1044440181,
 92272,
 -49597,
 1044489878,
 92270,
 -1,
 1044519917,
 92294,
 1044725319,
 1044406657,
 -1,
 -49594,
 1044686546,
 92301,
 -1,
 1044726763,
 92253,
 -1,
 1044651881,
 92256,
 1044987469,
 1044356813,
 -1,
 -49590,
 1044959793,
 92289,
 -49589,
 1044999504,
 92263,
 -49588,
 1045054498,
 92257,
 -1,
 1045111799,
 92274,
 1045315155,
 1044935756,
 -1,
 1045380689,
 1045240116,
 -1,
 -49584,
 1045332137,
 92259,
 -1,
 1045372907,
 92273,
 -49582,
 1045336986,
 92251,
 -1,
 1045514708,
 92297,
 1045708376,
 1045283474,
 -1,
 1045773911,
 1045679647,
 -1,
 -49578,
 1045728988,
 92264,
 -1,
 1045791029,
 92248,
 -1,
 1045699064,
 92280,
 1046036059,
 1045685004,
 -1,
 -49574,
 1045973667,
 92254,
 -1,
 1046027403,
 92258,
 1046232670,
 1045976480,
 -1,
 -49571,
 1046204093,
 92262,
 -1,
 1046251816,
 92271,
 1046429281,
 1046171042,
 -1,
 -49568,
 1046402546,
 92291,
 -1,
 1046429891,
 92293,
 -49566,
 1046405619,
 92278,
 -1,
 1046599899,
 92275,
 1046806527,
 1041386729,
 -1,
 1046822514,
 1046710568,
 -1,
 1046888039,
 1046793757,
 92697,
 -1,
 1046813658,
 92696,
 1047019114,
 1046835039,
 -1,
 -49559,
 1046990521,
 92698,
 -1,
 1047010285,
 92688,
 1047215725,
 1046958834,
 -1,
 -49556,
 1047163939,
 92711,
 -1,
 1047221057,
 92712,
 -49554,
 1047192698,
 92681,
 -49553,
 1047381170,
 92704,
 -49552,
 1047443626,
 92702,
 -49551,
 1047486849,
 92708,
 -1,
 1047541959,
 92687,
 1047740027,
 1046787415,
 -1,
 1047805559,
 1047681064,
 -1,
 -49547,
 1047776797,
 92700,
 -49546,
 1047826577,
 92713,
 -1,
 1047881099,
 92691,
 -49544,
 1047778792,
 92690,
 -49543,
 1048011137,
 92692,
 -49542,
 1048070876,
 92693,
 -1,
 1048125301,
 92727,
 1048329860,
 1047687307,
 -1,
 1048395391,
 1048264899,
 -1,
 -49538,
 1048363666,
 92695,
 -1,
 1048414504,
 92710,
 -49536,
 1048372233,
 92694,
 -49535,
 1048563229,
 92677,
 -49534,
 1048616745,
 92726,
 -49533,
 1048678545,
 92719,
 -1,
 1048713524,
 92675,
 1048919693,
 1048291458,
 -1,
 1048985225,
 1048854723,
 -1,
 -49529,
 1048958450,
 92709,
 -49528,
 1049004328,
 92721,
 -1,
 1049051331,
 92679,
 1049247372,
 1048928641,
 -1,
 -49525,
 1049190785,
 92683,
 -1,
 1049248693,
 92684,
 -1,
 1049218589,
 92707,
 1049509524,
 1048871045,
 92689,
 1049575057,
 1049437887,
 -1,
 -49520,
 1049511498,
 92720,
 -1,
 1049565676,
 92724,
 -49518,
 1049530513,
 92723,
 -49517,
 1049707452,
 92685,
 -1,
 1049762100,
 92722,
 1049968281,
 1049477778,
 -1,
 1050033816,
 1049893172,
 -1,
 -49513,
 1049968835,
 92680,
 -1,
 1050024244,
 92686,
 -1,
 1049971156,
 92725,
 1050295966,
 1049927373,
 -1,
 1050361501,
 1050230979,
 -1,
 -49508,
 1050334706,
 92703,
 -1,
 1050362051,
 92706,
 -1,
 1050332857,
 92714,
 1050623650,
 1050244172,
 -1,
 -49504,
 1050581061,
 92718,
 -49503,
 1050632577,
 92717,
 -1,
 1050679604,
 92682,
 1050885797,
 1050600204,
 -1,
 -49500,
 1050843205,
 92699,
 -1,
 1050876212,
 92701,
 1051082408,
 1050860260,
 -1,
 -49497,
 1051054168,
 92705,
 -1,
 1051072820,
 92716,
 -49495,
 1051056849,
 92728,
 -49494,
 1051250205,
 92676,
 -49493,
 1051283605,
 92715,
 -1,
 1051345845,
 92678,
 1051541167,
 997903901,
 -1,
 -49490,
 1051476163,
 42696,
 -1,
 1051532250,
 42711,
 1051737778,
 1051476163,
 -1,
 -49487,
 1051710962,
 42693,
 -1,
 1051738307,
 42698,
 -49485,
 1051681153,
 42717,
 -1,
 1051859252,
 42667,
 1052065479,
 997820712,
 -1,
 1052131001,
 1052012383,
 -1,
 -49481,
 1052102329,
 42686,
 -49480,
 1052132277,
 42694,
 -1,
 1052187629,
 42674,
 1052393149,
 1052070642,
 -1,
 -49477,
 1052341283,
 42707,
 -49476,
 1052398401,
 42708,
 -1,
 1052449076,
 42709,
 1052655295,
 1052364317,
 42685,
 -1,
 1052580826,
 42684,
 1052786370,
 1052623506,
 -1,
 -49471,
 1052759528,
 42731,
 -1,
 1052787637,
 42695,
 -49469,
 1052763258,
 42664,
 -49468,
 1052948650,
 42691,
 -49467,
 1052991873,
 42703,
 -49466,
 1053046983,
 42673,
 -1,
 1053104436,
 42715,
 1053310676,
 1052012683,
 -1,
 1053376203,
 1053266065,
 42719,
 -49462,
 1053350614,
 42734,
 -1,
 1053382062,
 42735,
 1053572815,
 1053311171,
 -1,
 -49459,
 1053545970,
 42692,
 -49458,
 1053606546,
 42683,
 -1,
 1053657384,
 42706,
 -49456,
 1053549577,
 42682,
 -49455,
 1053806109,
 42659,
 -49454,
 1053859625,
 42729,
 -49453,
 1053909377,
 42725,
 -1,
 1053956404,
 42657,
 1054162655,
 1053261957,
 42675,
 1054228184,
 1054097603,
 -1,
 -49449,
 1054181672,
 42722,
 -1,
 1054229432,
 42671,
 1054424795,
 1054156479,
 -1,
 -49446,
 1054361162,
 42720,
 -1,
 1054415340,
 42727,
 -49444,
 1054395933,
 42677,
 -49443,
 1054576785,
 42726,
 -49442,
 1054630273,
 42702,
 -1,
 1054677300,
 42723,
 1054883561,
 1054127447,
 -1,
 1054949093,
 1054824488,
 -1,
 -49438,
 1054920221,
 42688,
 -49437,
 1054970001,
 42710,
 -49436,
 1055024523,
 42678,
 -1,
 1055083228,
 42680,
 -49434,
 1054922216,
 42676,
 -49433,
 1055220097,
 42679,
 -49432,
 1055279836,
 42681,
 -1,
 1055334261,
 42732,
 1055538931,
 1054845058,
 -1,
 1055604462,
 1055473859,
 -1,
 -49428,
 1055577586,
 42704,
 -49427,
 1055623464,
 42721,
 -1,
 1055670467,
 42661,
 1055866609,
 1055547777,
 -1,
 -49424,
 1055809921,
 42668,
 -1,
 1055867829,
 42669,
 -49422,
 1055837725,
 42700,
 -1,
 1055988698,
 42705,
 1056194299,
 1055507090,
 -1,
 1056259831,
 1056129219,
 -1,
 -49418,
 1056227986,
 42728,
 -1,
 1056278824,
 42730,
 1056456442,
 1056184628,
 -1,
 -49415,
 1056391363,
 42662,
 -1,
 1056446772,
 42672,
 -1,
 1056399745,
 42724,
 1056718593,
 1056142412,
 -1,
 -49411,
 1056689693,
 42701,
 -49410,
 1056741445,
 42718,
 -49409,
 1056792961,
 42716,
 -49408,
 1056850876,
 42670,
 -1,
 1056905524,
 42666,
 1057111814,
 1056656615,
 -1,
 -49405,
 1057082909,
 42712,
 -49404,
 1057133459,
 42713,
 -49403,
 1057178549,
 42699,
 -1,
 1057233404,
 42733,
 1057439498,
 1057088268,
 -1,
 -49400,
 1057412122,
 42689,
 -49399,
 1057462341,
 42687,
 -1,
 1057495348,
 42690,
 1057701645,
 1057413860,
 -1,
 -49396,
 1057673304,
 42697,
 -1,
 1057691956,
 42714,
 -49394,
 1057672733,
 42658,
 -49393,
 1057853585,
 42663,
 -49392,
 1057907073,
 42665,
 -49391,
 1057964981,
 42660,
 -1,
 1058019636,
 42656,
 1058225945,
 997733196,
 -1,
 1058291480,
 1058177157,
 -1,
 1058357015,
 1058220506,
 -1,
 -49386,
 1058327673,
 42737,
 -1,
 1058370438,
 42736,
 -1,
 1058308315,
 42741,
 -1,
 1058242033,
 42740,
 -49382,
 1058191260,
 42742,
 -49381,
 1058646055,
 42743,
 -49380,
 1058704734,
 42738,
 -1,
 1058755297,
 42739,
 1058947020,
 997684300,
 -1,
 1059012540,
 1058891736,
 -1,
 1059077983,
 1058962059,
 -1,
 1059143463,
 1059046034,
 -1,
 1059208998,
 1059068212,
 6946,
 1059323903,
 1059127296,
 -1,
 -49372,
 1059243060,
 6947,
 -49371,
 1059293403,
 6942,
 -1,
 1059354218,
 6941,
 -1,
 1059186449,
 6983,
 1059602220,
 1059096872,
 -1,
 1059667754,
 1059526964,
 6950,
 -1,
 1059588203,
 6945,
 -49365,
 1059644276,
 6940,
 -1,
 1059738433,
 6935,
 1059929905,
 1059549323,
 -1,
 1059995440,
 1059854644,
 6931,
 -49361,
 1059933439,
 6981,
 -1,
 1059980404,
 6932,
 -1,
 1059938155,
 6982,
 1060257591,
 1059862686,
 6948,
 1060372479,
 1060176993,
 -1,
 1060388662,
 1060295778,
 -1,
 -49355,
 1060340031,
 6944,
 -1,
 1060380425,
 6943,
 -1,
 1060314064,
 6949,
 1060650812,
 1060182324,
 -1,
 1060716346,
 1060598119,
 6917,
 -1,
 1060637062,
 6918,
 -49349,
 1060684422,
 6987,
 -1,
 1060791702,
 6928,
 1060978496,
 1060615681,
 6962,
 1061093375,
 1060898978,
 -1,
 -49345,
 1061003049,
 6961,
 -1,
 1061049153,
 6960,
 1061240643,
 1060940021,
 6957,
 1061355519,
 1061161084,
 6923,
 -1,
 1061226886,
 6924,
 1061437254,
 1061188758,
 6958,
 1061552127,
 1061356579,
 6925,
 -1,
 1061423494,
 6926,
 1061633864,
 1061408966,
 6921,
 -1,
 1061554566,
 6922,
 1061764938,
 1061592873,
 6951,
 -1,
 1061684138,
 6952,
 1061896012,
 1061720745,
 6929,
 -1,
 1061816710,
 6930,
 1062027086,
 1061842813,
 6938,
 -1,
 1061946265,
 6939,
 1062158160,
 1061971350,
 6919,
 -1,
 1062078854,
 6920,
 1062289234,
 1062097729,
 6933,
 -1,
 1062208303,
 6934,
 1062420309,
 1062224067,
 -1,
 -49324,
 1062367591,
 6927,
 -1,
 1062423807,
 6984,
 1062616919,
 1062350107,
 6936,
 -1,
 1062536156,
 6937,
 1062747993,
 1062545140,
 6953,
 -1,
 1062667211,
 6954,
 -49318,
 1062725131,
 6986,
 -49317,
 1062855540,
 6956,
 -49316,
 1062918948,
 6959,
 -49315,
 1062983433,
 6985,
 -49314,
 1063026907,
 6955,
 -1,
 1063082046,
 6963,
 1063272328,
 1059031280,
 -1,
 1063337838,
 1063204879,
 -1,
 1063403368,
 1063262516,
 -1,
 1063468902,
 1063357436,
 7012,
 1063583743,
 1063387136,
 -1,
 -49307,
 1063502290,
 7013,
 -1,
 1063539908,
 7018,
 -49305,
 1063413727,
 7017,
 -1,
 1063667485,
 7015,
 1063862123,
 1063338179,
 -1,
 -49302,
 1063834148,
 7016,
 -1,
 1063881724,
 7010,
 -49300,
 1063834148,
 7011,
 -49299,
 1064015233,
 7009,
 -1,
 1064069087,
 7014,
 1064255353,
 1063269268,
 -1,
 1064320884,
 1064202796,
 -1,
 1064386418,
 1064292578,
 7021,
 -1,
 1064307995,
 7024,
 1064566783,
 1064336211,
 7022,
 -1,
 1064439067,
 7025,
 -49291,
 1064289467,
 7019,
 -49290,
 1064595416,
 7023,
 -49289,
 1064654575,
 7027,
 -49288,
 1064716038,
 7020,
 -1,
 1064773812,
 7026,
 1064976257,
 1064204519,
 -1,
 1065041790,
 1064933271,
 -1,
 -49284,
 1065013796,
 7033,
 -49283,
 1065052127,
 7036,
 -1,
 1065099452,
 7032,
 1065353215,
 1064973032,
 -1,
 -49280,
 1065275587,
 7035,
 -1,
 1065295345,
 7034,
 1065549823,
 1064939524,
 -1,
 1065566085,
 1065457491,
 -1,
 -49276,
 1065537671,
 7028,
 -1,
 1065557144,
 7029,
 1065811967,
 1065497330,
 -1,
 -49273,
 1065734339,
 7030,
 -1,
 1065754097,
 7031,
 1065959322,
 1063246448,
 -1,
 1066024848,
 1065927314,
 -1,
 1066090383,
 1065950929,
 6974,
 1066205183,
 1066008576,
 -1,
 1066221454,
 1066118402,
 6975,
 -1,
 1066142086,
 6977,
 -1,
 1066189995,
 6976,
 -1,
 1066025903,
 6965,
 1066483602,
 1065996566,
 6966,
 -1,
 1066404006,
 6967,
 1066614676,
 1066451376,
 6968,
 -1,
 1066533735,
 6969,
 1066745750,
 1066576124,
 6970,
 -1,
 1066666374,
 6971,
 1066876824,
 1066705308,
 6978,
 -1,
 1066797446,
 6979,
 1067057151,
 1066824857,
 6972,
 -1,
 1066928518,
 6973,
 1067138984,
 1065892702,
 -1,
 1067204510,
 1067106962,
 -1,
 -49251,
 1067180048,
 6994,
 -1,
 1067212753,
 6995,
 1067401121,
 1067169111,
 -1,
 -49248,
 1067347666,
 6998,
 -1,
 1067404011,
 6999,
 1067597732,
 1067338983,
 -1,
 -49245,
 1067555611,
 6996,
 -1,
 1067609632,
 6997,
 -49243,
 1067574922,
 6992,
 -49242,
 1067750575,
 6993,
 -49241,
 1067814104,
 7001,
 -1,
 1067861261,
 7000,
 1068056496,
 1067104969,
 -1,
 1068122028,
 1068028186,
 -1,
 -49237,
 1068084918,
 6912,
 -1,
 1068117394,
 6913,
 -49235,
 1068089810,
 6915,
 -49234,
 1068281125,
 6964,
 -49233,
 1068314368,
 6914,
 -1,
 1068378620,
 6916,
 1068580789,
 1068015401,
 -1,
 1068646324,
 1068531845,
 -1,
 -49229,
 1068582668,
 7008,
 -1,
 1068637085,
 7003,
 -1,
 1068601201,
 7002,
 1068908474,
 1068510784,
 -1,
 1068974009,
 1068867369,
 -1,
 -49224,
 1068936493,
 7007,
 -1,
 1068992706,
 7005,
 -1,
 1068940036,
 7006,
 -49221,
 1068883491,
 7004,
 -1,
 1069161397,
 6980,
 1069416447,
 1058960460,
 -1,
 1069432779,
 1069322385,
 -1,
 1069498314,
 1069400724,
 -1,
 1069563849,
 1069427418,
 -1,
 1069629384,
 1069539864,
 -1,
 1069694918,
 1069557439,
 -1,
 1069760453,
 1069650675,
 -1,
 -49212,
 1069725473,
 128503,
 -1,
 1069756402,
 128505,
 -1,
 1069686503,
 128499,
 -49209,
 1069659937,
 128501,
 -1,
 1069972502,
 11197,
 -1,
 1069578020,
 128502,
 -1,
 1069528865,
 128500,
 -1,
 1069454356,
 127880,
 -1,
 1069352251,
 129526,
 1070415894,
 1058914962,
 129415,
 1070481427,
 1070341620,
 -1,
 1070546938,
 1070430859,
 -1,
 1070612445,
 1070511447,
 -1,
 1070677979,
 1070556686,
 -1,
 -49198,
 1070654324,
 7132,
 -49197,
 1070717732,
 7116,
 -49196,
 1070773761,
 7129,
 -49195,
 1070835957,
 7123,
 -49194,
 1070898985,
 7112,
 -49193,
 1070956763,
 7125,
 -49192,
 1071019158,
 7135,
 -49191,
 1071077438,
 7107,
 -49190,
 1071141697,
 7119,
 -1,
 1071192372,
 7105,
 -49188,
 1070636074,
 7126,
 -1,
 1071323444,
 7128,
 1071529955,
 1070565672,
 -1,
 -49185,
 1071506292,
 7136,
 -49184,
 1071552859,
 7127,
 -49183,
 1071600449,
 7133,
 -49182,
 1071659166,
 7138,
 -1,
 1071716660,
 7113,
 1071923178,
 1071480965,
 -1,
 1071988713,
 1071847732,
 7124,
 1072103423,
 1071942285,
 -1,
 -49177,
 1072018945,
 7130,
 -49176,
 1072073074,
 7114,
 -1,
 1072126014,
 7108,
 -1,
 1071916788,
 7139,
 1072381932,
 1071882025,
 7111,
 -1,
 1072329655,
 7117,
 -49171,
 1072358260,
 7131,
 -49170,
 1072487204,
 7115,
 -49169,
 1072549405,
 7141,
 -49168,
 1072605429,
 7122,
 -49167,
 1072657558,
 7134,
 -49166,
 1072722290,
 7110,
 -49165,
 1072787325,
 7120,
 -49164,
 1072849281,
 7140,
 -49163,
 1072912446,
 7106,
 -49162,
 1072976705,
 7118,
 -49161,
 1073035422,
 7121,
 -49160,
 1073098011,
 7137,
 -49159,
 1073161972,
 7109,
 -1,
 1073223988,
 7104,
 1073430533,
 1070520944,
 -1,
 1073496061,
 1073401373,
 7150,
 -1,
 1073414893,
 7151,
 1073627136,
 1073443180,
 -1,
 -49153,
 1073582225,
 7149,
 -1,
 1073635713,
 7147,
 1073823746,
 1073561795,
 7143,
 -1,
 1073758403,
 7145,
 -49149,
 1073782657,
 7144,
 -49148,
 1073909905,
 7148,
 -1,
 1073963393,
 7146,
 1074151437,
 1073395031,
 -1,
 1074216972,
 1074128117,
 -1,
 1074282506,
 1074175693,
 -1,
 -49143,
 1074226857,
 7165,
 -1,
 1074274583,
 7167,
 -49141,
 1074235791,
 7164,
 -1,
 1074425975,
 7166,
 -1,
 1074161003,
 7142,
 1074675728,
 1074110391,
 -1,
 -49137,
 1074632143,
 7155,
 -1,
 1074681548,
 7154,
 1074921471,
 1074607200,
 -1,
 -49134,
 1074826236,
 7152,
 -1,
 1074878504,
 7153,
 1075068949,
 1070422056,
 128704,
 -1,
 1075039301,
 128705,
 -1,
 1075037571,
 128267,
 1075265607,
 1070380375,
 -1,
 1075331140,
 1075230212,
 -1,
 1075396667,
 1075280523,
 -1,
 1075462172,
 1075331267,
 92908,
 -49125,
 1075416468,
 92880,
 -1,
 1075462339,
 92907,
 1075658783,
 1075438348,
 -1,
 -49122,
 1075602305,
 92885,
 -1,
 1075660158,
 92900,
 1075855393,
 1075632932,
 92891,
 -1,
 1075788124,
 92902,
 1075986467,
 1075826205,
 92906,
 -1,
 1075962346,
 92896,
 1076117541,
 1075941521,
 92904,
 -1,
 1076072593,
 92905,
 1076248616,
 1076064395,
 -1,
 -49113,
 1076207471,
 92888,
 -1,
 1076238644,
 92881,
 1076445227,
 1076187890,
 -1,
 -49110,
 1076374604,
 92893,
 -1,
 1076436201,
 92886,
 1076641838,
 1076377615,
 -1,
 -49107,
 1076596881,
 92894,
 -1,
 1076649236,
 92887,
 -49105,
 1076619040,
 92892,
 -49104,
 1076812494,
 92899,
 -49103,
 1076873483,
 92897,
 -49102,
 1076934457,
 92882,
 -49101,
 1076993833,
 92901,
 -49100,
 1077052205,
 92884,
 -49099,
 1077112879,
 92889,
 -49098,
 1077174657,
 92909,
 -49097,
 1077240166,
 92890,
 -49096,
 1077300540,
 92883,
 -49095,
 1077358297,
 92895,
 -49094,
 1077421812,
 92898,
 -1,
 1077483828,
 92903,
 1077690435,
 1075327892,
 -1,
 1077755967,
 1077640900,
 -1,
 -49090,
 1077677840,
 92915,
 -1,
 1077742300,
 92913,
 1077952578,
 1077697720,
 -1,
 -49087,
 1077874414,
 92916,
 -1,
 1077938908,
 92912,
 -1,
 1077904673,
 92914,
 -1,
 1077629665,
 92917,
 1078280262,
 1075278417,
 129530,
 -1,
 1078208351,
 127936,
 -1,
 1078215375,
 9918,
 1078476883,
 1075195108,
 -1,
 1078542417,
 1078423691,
 -1,
 1078607950,
 1078506839,
 -1,
 1078673485,
 1078556087,
 -1,
 -49076,
 1078637237,
 11101,
 -1,
 1078694585,
 11099,
 -1,
 1078632274,
 983056,
 1078984703,
 1078525952,
 -1,
 -49072,
 1078910675,
 128281,
 -1,
 1078956496,
 128386,
 -49070,
 1078512291,
 128043,
 -1,
 1079088148,
 129363,
 1079263323,
 1078429992,
 -1,
 1079328858,
 1079210123,
 127974,
 1079443455,
 1079283313,
 -1,
 -49065,
 1079370801,
 128180,
 -49064,
 1079420129,
 128183,
 -49063,
 1079462581,
 128182,
 -1,
 1079524408,
 128181,
 -1,
 1079254998,
 127820,
 1079787617,
 1079192788,
 128118,
 1079902207,
 1079705600,
 -1,
 -49058,
 1079820879,
 128700,
 -49057,
 1079849041,
 128036,
 -49056,
 1079913304,
 127868,
 -1,
 1079976149,
 128124,
 1080180838,
 1079748738,
 -1,
 1080246373,
 1080098816,
 -1,
 -49052,
 1080201715,
 129532,
 -1,
 1080242147,
 128202,
 -1,
 1080174804,
 128136,
 1080508522,
 1080120050,
 -1,
 -49048,
 1080479867,
 129366,
 -49047,
 1080513432,
 128708,
 -1,
 1080575376,
 129391,
 1080819711,
 1080440847,
 -1,
 -49044,
 1080723043,
 127992,
 -1,
 1080775954,
 129441,
 1080967443,
 997632130,
 -1,
 1081032965,
 1080891700,
 -1,
 1081098500,
 1080974867,
 -1,
 1081163956,
 1081047691,
 -1,
 1081229432,
 1081136632,
 -1,
 1081294967,
 1081184556,
 -1,
 1081360501,
 1081256066,
 69643,
 -1,
 1081321602,
 69644,
 1081540607,
 1081308236,
 69645,
 -1,
 1081439308,
 69646,
 -1,
 1081219380,
 69679,
 1081688190,
 1081197202,
 -1,
 1081753724,
 1081655954,
 -1,
 -49029,
 1081694270,
 69662,
 -1,
 1081743668,
 69661,
 -49027,
 1081694270,
 69667,
 -1,
 1081874740,
 69666,
 1082081411,
 1081643153,
 69649,
 1082195967,
 1082029881,
 -1,
 -49023,
 1082111015,
 69686,
 -49022,
 1082166687,
 69687,
 -1,
 1082228105,
 69685,
 1082409096,
 1082034472,
 -1,
 -49019,
 1082385268,
 69660,
 -49018,
 1082427762,
 69665,
 -49017,
 1082479425,
 69655,
 -1,
 1082530100,
 69670,
 1082736782,
 1082341391,
 -1,
 1082802316,
 1082669071,
 -1,
 -49013,
 1082742846,
 69664,
 -1,
 1082792244,
 69663,
 -49011,
 1082742846,
 69669,
 -1,
 1082923316,
 69668,
 1083130002,
 1082661172,
 69637,
 -49008,
 1083100701,
 69650,
 -49007,
 1083138433,
 69648,
 -1,
 1083185460,
 69638,
 1083392150,
 1083094359,
 -1,
 -49004,
 1083356673,
 69681,
 -49003,
 1083398206,
 69680,
 -1,
 1083447604,
 69682,
 1083654296,
 1083362845,
 69641,
 -1,
 1083624989,
 69642,
 1083785371,
 1083612877,
 -1,
 -48998,
 1083725886,
 69672,
 -1,
 1083775284,
 69671,
 1083981982,
 1083733068,
 -1,
 -48995,
 1083929750,
 69684,
 -1,
 1083971892,
 69678,
 1084178593,
 1083928715,
 -1,
 -48992,
 1084119102,
 69652,
 -1,
 1084168500,
 69651,
 1084375204,
 1084125023,
 -1,
 -48989,
 1084315710,
 69659,
 -1,
 1084365108,
 69658,
 1084571814,
 1084318081,
 69639,
 -1,
 1084514689,
 69640,
 1084702889,
 1084510962,
 -1,
 -48984,
 1084643390,
 69654,
 -1,
 1084692788,
 69653,
 1084899500,
 1084632292,
 -1,
 -48981,
 1084839998,
 69657,
 -1,
 1084889396,
 69656,
 1085096111,
 1084827327,
 -1,
 -48978,
 1085036606,
 69674,
 -1,
 1085086004,
 69673,
 -48976,
 1085072244,
 69676,
 -48975,
 1085253877,
 69677,
 -48974,
 1085309147,
 69675,
 -48973,
 1085364286,
 69683,
 -1,
 1085423811,
 69647,
 1085620434,
 1081118663,
 -1,
 1085685949,
 1085588114,
 -1,
 1085751481,
 1085659876,
 -1,
 -48968,
 1085706385,
 69715,
 -1,
 1085753273,
 69724,
 1085948092,
 1085691944,
 -1,
 -48965,
 1085910107,
 69716,
 -1,
 1085959292,
 69725,
 -1,
 1085883978,
 69723,
 1086210242,
 1085650263,
 -1,
 1086275776,
 1086156498,
 69719,
 -1,
 1086246401,
 69728,
 1086455807,
 1086212843,
 69720,
 -1,
 1086377473,
 69729,
 1086537929,
 1086147815,
 -1,
 1086603462,
 1086492817,
 -1,
 -48955,
 1086575655,
 69717,
 -1,
 1086633151,
 69726,
 1086849023,
 1086546305,
 -1,
 -48952,
 1086772963,
 69718,
 -1,
 1086804694,
 69727,
 1086996685,
 1086493871,
 69714,
 1087111167,
 1086914560,
 -1,
 -48948,
 1087030877,
 69733,
 -1,
 1087070471,
 69732,
 1087258831,
 1086950616,
 69722,
 -1,
 1087229441,
 69731,
 1087389905,
 1087194381,
 69721,
 -1,
 1087365900,
 69730,
 -1,
 1087336509,
 69759,
 1087586533,
 1085593080,
 -1,
 1087652068,
 1087544909,
 -1,
 1087717593,
 1087625610,
 -1,
 1087783127,
 1087678594,
 69694,
 -1,
 1087744130,
 69695,
 1087963135,
 1087730764,
 69696,
 -1,
 1087861836,
 69697,
 1088045277,
 1087641908,
 -1,
 -48933,
 1088015901,
 69701,
 -48932,
 1088053633,
 69699,
 -1,
 1088100660,
 69688,
 1088307423,
 1088015901,
 69692,
 -1,
 1088278045,
 69693,
 1088438497,
 1088250241,
 69690,
 -1,
 1088381313,
 69691,
 -48926,
 1088393361,
 69700,
 -48925,
 1088504003,
 69698,
 -1,
 1088563559,
 69689,
 -1,
 1087597526,
 69702,
 1088831734,
 1087518735,
 -1,
 1088897268,
 1088775457,
 -1,
 1088962794,
 1088864914,
 -1,
 -48919,
 1088938000,
 69736,
 -1,
 1088970705,
 69737,
 1089159405,
 1088927063,
 -1,
 -48916,
 1089105618,
 69740,
 -1,
 1089161963,
 69741,
 1089356016,
 1089096935,
 -1,
 -48913,
 1089313563,
 69738,
 -1,
 1089367584,
 69739,
 -48911,
 1089332874,
 69734,
 -48910,
 1089508527,
 69735,
 -48909,
 1089572056,
 69743,
 -1,
 1089619213,
 69742,
 -48907,
 1088854692,
 69704,
 -1,
 1089740936,
 69703,
 1089945852,
 1088797385,
 -1,
 -48904,
 1089919309,
 69634,
 -48903,
 1089983305,
 69636,
 -48902,
 1090023424,
 69635,
 -48901,
 1090071992,
 69632,
 -1,
 1090134414,
 69633,
 1090387967,
 1089906246,
 -1,
 1090404608,
 1090286668,
 -1,
 -48897,
 1090362005,
 69709,
 -1,
 1090414518,
 69707,
 1090601219,
 1090337805,
 -1,
 -48894,
 1090572132,
 69706,
 -1,
 1090634386,
 69705,
 -1,
 1090532779,
 69708,
 -1,
 1081042541,
 129504,
 1090928907,
 1080975745,
 -1,
 1090994441,
 1090861071,
 -1,
 -48888,
 1090933913,
 127753,
 -1,
 1090994634,
 128112,
 -48886,
 1090929730,
 128188,
 -1,
 1091121694,
 129521,
 1091322127,
 1090883729,
 -1,
 -48883,
 1091277715,
 129529,
 -48882,
 1091334715,
 128148,
 -1,
 1091382983,
 129382,
 1091633151,
 1091256815,
 -1,
 -48879,
 1091551074,
 129329,
 -48878,
 1091596454,
 983124,
 -1,
 1091647503,
 127838,
 1091846552,
 1080907914,
 -1,
 1091912017,
 1091795595,
 -1,
 1091977499,
 1091884536,
 -1,
 1092043034,
 1091932460,
 -1,
 1092108569,
 1092003970,
 72710,
 -1,
 1092069506,
 72711,
 -1,
 1092056140,
 72712,
 -1,
 1091967284,
 72746,
 1092370721,
 1091945106,
 -1,
 1092436255,
 1092338322,
 -1,
 -48866,
 1092376638,
 72729,
 -1,
 1092426036,
 72728,
 -48864,
 1092376638,
 72734,
 -1,
 1092557108,
 72733,
 1092763942,
 1092323624,
 -1,
 -48861,
 1092739956,
 72727,
 -48860,
 1092782450,
 72732,
 -48859,
 1092834113,
 72722,
 -1,
 1092884788,
 72737,
 1093091628,
 1092696079,
 -1,
 1093157162,
 1093023759,
 -1,
 -48855,
 1093097534,
 72731,
 -1,
 1093146932,
 72730,
 -48853,
 1093097534,
 72736,
 -1,
 1093278004,
 72735,
 1093484848,
 1093015860,
 72704,
 -48850,
 1093455389,
 72717,
 -48849,
 1093493121,
 72715,
 -1,
 1093540148,
 72705,
 1093746996,
 1093449047,
 -1,
 -48846,
 1093711361,
 72748,
 -48845,
 1093752894,
 72747,
 -1,
 1093802292,
 72749,
 1094009142,
 1093717533,
 72708,
 -1,
 1093979677,
 72709,
 1094140217,
 1093967565,
 -1,
 -48840,
 1094080574,
 72739,
 -1,
 1094129972,
 72738,
 1094336828,
 1094086795,
 -1,
 -48837,
 1094277182,
 72719,
 -1,
 1094326580,
 72718,
 1094533439,
 1094283103,
 -1,
 -48834,
 1094473790,
 72726,
 -1,
 1094523188,
 72725,
 1094730049,
 1094476161,
 72706,
 -1,
 1094672769,
 72707,
 1094861124,
 1094669042,
 -1,
 -48829,
 1094801470,
 72721,
 -1,
 1094850868,
 72720,
 1095057735,
 1094790372,
 -1,
 -48826,
 1094998078,
 72724,
 -1,
 1095047476,
 72723,
 1095254346,
 1094985407,
 -1,
 -48823,
 1095194686,
 72741,
 -1,
 1095244084,
 72740,
 -48821,
 1095230324,
 72743,
 -48820,
 1095411957,
 72744,
 -48819,
 1095471249,
 72716,
 -48818,
 1095532763,
 72742,
 -48817,
 1095595158,
 72745,
 -48816,
 1095653438,
 72750,
 -1,
 1095712963,
 72714,
 1095909739,
 1091866567,
 -1,
 1095975258,
 1095877266,
 -1,
 1096040790,
 1095949028,
 -1,
 -48811,
 1095995537,
 72795,
 -1,
 1096042425,
 72804,
 1096237401,
 1095981096,
 -1,
 -48808,
 1096199259,
 72796,
 -1,
 1096248444,
 72805,
 -1,
 1096173130,
 72803,
 1096499551,
 1095939415,
 -1,
 1096565085,
 1096445650,
 72799,
 -1,
 1096535553,
 72808,
 1096744959,
 1096501995,
 72800,
 -1,
 1096666625,
 72809,
 1096827238,
 1096436967,
 -1,
 1096892771,
 1096781969,
 -1,
 -48798,
 1096864807,
 72797,
 -1,
 1096922303,
 72806,
 1097138175,
 1096835457,
 -1,
 -48795,
 1097062115,
 72798,
 -1,
 1097093846,
 72807,
 1097285992,
 1096781016,
 72802,
 -1,
 1097256449,
 72811,
 1097417066,
 1097221389,
 72801,
 -1,
 1097392908,
 72810,
 -1,
 1097372847,
 72794,
 1097613690,
 1095883376,
 -1,
 1097679216,
 1097587082,
 -1,
 1097744751,
 1097640066,
 72756,
 -1,
 1097705602,
 72757,
 -1,
 1097692236,
 72758,
 1097941364,
 1097603380,
 -1,
 -48782,
 1097911837,
 72763,
 -48781,
 1097949569,
 72761,
 -1,
 1097996596,
 72751,
 1098203510,
 1097911837,
 72754,
 -1,
 1098173981,
 72755,
 1098334584,
 1098146177,
 72752,
 -1,
 1098277249,
 72753,
 -48775,
 1098289297,
 72762,
 -1,
 1098399939,
 72760,
 1098596747,
 1097545743,
 -1,
 1098662281,
 1098540321,
 -1,
 1098727807,
 1098629778,
 -1,
 -48770,
 1098702864,
 72786,
 -1,
 1098735569,
 72787,
 1098924418,
 1098691927,
 -1,
 -48767,
 1098870482,
 72790,
 -1,
 1098926827,
 72791,
 1099121029,
 1098861799,
 -1,
 -48764,
 1099078427,
 72788,
 -1,
 1099132448,
 72789,
 -48762,
 1099097738,
 72784,
 -48761,
 1099273391,
 72785,
 -48760,
 1099336920,
 72793,
 -1,
 1099384077,
 72792,
 -48758,
 1098619556,
 72770,
 -1,
 1099505800,
 72769,
 1099710867,
 1098562249,
 -1,
 1099776399,
 1099684074,
 -1,
 -48754,
 1099740881,
 72766,
 -1,
 1099803140,
 72767,
 1099973010,
 1099700532,
 -1,
 -48751,
 1099945489,
 72768,
 -1,
 1099993100,
 72765,
 -1,
 1099902392,
 72764,
 1100235158,
 1099650039,
 -1,
 -48747,
 1100157461,
 72773,
 -1,
 1100222698,
 72772,
 -48745,
 1100210566,
 72771,
 -1,
 1100374309,
 72812,
 1100562972,
 1091793996,
 -1,
 1100628502,
 1100487417,
 -1,
 1100693932,
 1100578949,
 -1,
 1100759467,
 1100628904,
 -1,
 1100824992,
 1100706892,
 -1,
 1100890527,
 1100760185,
 9204,
 -1,
 1100808634,
 11207,
 -1,
 1100848800,
 11047,
 1101087140,
 1100757007,
 -1,
 1101152675,
 1101045359,
 9207,
 -1,
 1101070778,
 11206,
 -1,
 1101095492,
 11045,
 1101349286,
 1101058868,
 9206,
 -1,
 1101267386,
 11205,
 1101480361,
 1101315082,
 -1,
 -48728,
 1101430678,
 128927,
 -1,
 1101478691,
 128921,
 1101725695,
 1101443176,
 9205,
 -1,
 1101595066,
 11208,
 -1,
 1100715703,
 9912,
 1101873595,
 1100658007,
 -1,
 1101939121,
 1101834127,
 -1,
 -48721,
 1101877417,
 9209,
 -48720,
 1101934378,
 11200,
 -1,
 1101999288,
 128306,
 1102201269,
 1101889979,
 -1,
 -48717,
 1102167945,
 11089,
 -48716,
 1102217110,
 11050,
 -1,
 1102265123,
 11049,
 1102463416,
 1102150686,
 -1,
 -48713,
 1102429775,
 128909,
 -1,
 1102459127,
 128900,
 -48711,
 1102417553,
 9927,
 -48710,
 1102607360,
 128369,
 -1,
 1102650458,
 9984,
 1102856651,
 1101802724,
 -1,
 1102922185,
 1102828806,
 -1,
 1102987712,
 1102894045,
 -1,
 -48705,
 1102950567,
 11179,
 -1,
 1103001987,
 11178,
 1103184323,
 1102950551,
 -1,
 -48702,
 1103156202,
 11181,
 -1,
 1103183786,
 11183,
 1103380934,
 1103133044,
 -1,
 -48699,
 1103352810,
 11180,
 -1,
 1103380394,
 11182,
 1103626239,
 1103314802,
 -1,
 -48696,
 1103540391,
 11177,
 -1,
 1103591811,
 11176,
 -48694,
 1102885783,
 9960,
 -1,
 1103719394,
 9210,
 1103905242,
 1102788623,
 -1,
 1103970770,
 1103863389,
 -1,
 1104036304,
 1103892308,
 -1,
 -48689,
 1103981792,
 128899,
 -1,
 1104035450,
 9196,
 -48687,
 1104010162,
 11167,
 -1,
 1104152622,
 128419,
 1104363991,
 1103931522,
 -1,
 1104429526,
 1104291309,
 -1,
 -48683,
 1104380443,
 9922,
 -1,
 1104442096,
 9923,
 -1,
 1104386006,
 127778,
 1104740351,
 1104306763,
 -1,
 -48679,
 1104647211,
 11230,
 -1,
 1104686890,
 11201,
 1104888293,
 1103865986,
 -1,
 1104953828,
 1104831628,
 -1,
 1105019362,
 1104875348,
 -1,
 1105084895,
 1104952954,
 9193,
 -1,
 1105006099,
 9197,
 -48672,
 1105054411,
 9199,
 -48671,
 1105174911,
 11091,
 -1,
 1105226976,
 128898,
 -48669,
 1104993202,
 11166,
 -1,
 1105332270,
 128413,
 -1,
 1104910736,
 127990,
 1105609202,
 1104835660,
 -1,
 1105674735,
 1105544282,
 -1,
 1105740267,
 1105596244,
 -1,
 1105805802,
 1105673850,
 9194,
 -1,
 1105726995,
 9198,
 -1,
 1105751264,
 128896,
 1106002414,
 1105657856,
 -1,
 -48659,
 1105961982,
 128412,
 -1,
 1106015660,
 9944,
 -1,
 1105976242,
 11164,
 1106313215,
 1105601206,
 -1,
 -48655,
 1106230863,
 11035,
 -1,
 1106260215,
 11044,
 1106461178,
 1105576594,
 -1,
 1106526711,
 1106406224,
 -1,
 -48651,
 1106493007,
 128908,
 -48650,
 1106542486,
 128925,
 -1,
 1106590499,
 128919,
 -48648,
 1106501930,
 9942,
 -48647,
 1106752710,
 9951,
 -1,
 1106811614,
 128383,
 1106985472,
 1106433919,
 -1,
 1107051007,
 1106961221,
 -1,
 -48643,
 1107017295,
 11037,
 -48642,
 1107066774,
 128926,
 -1,
 1107114787,
 128920,
 -1,
 1107019654,
 11054,
 1107378694,
 1106956936,
 -1,
 1107444228,
 1107300180,
 -1,
 -48637,
 1107389664,
 128897,
 -1,
 1107443322,
 9195,
 -48635,
 1107418034,
 11165,
 -1,
 1107560494,
 128418,
 1107771916,
 1107318824,
 -1,
 1107837450,
 1107706051,
 -1,
 -48631,
 1107812903,
 11042,
 -1,
 1107829717,
 128420,
 -48629,
 1107794137,
 11052,
 -1,
 1107960457,
 128426,
 1108165137,
 1107730125,
 -1,
 1108230672,
 1108100682,
 -1,
 -48625,
 1108198246,
 11039,
 -1,
 1108249037,
 127986,
 -1,
 1108202849,
 128392,
 1108492820,
 1108102375,
 -1,
 -48621,
 1108448062,
 128447,
 -1,
 1108505858,
 9873,
 -48619,
 1108453429,
 10067,
 -1,
 1108644201,
 11204,
 1108820505,
 1100599387,
 -1,
 -48616,
 1108761371,
 128153,
 -1,
 1108814650,
 128216,
 1109065727,
 1108775057,
 -1,
 -48613,
 1108991226,
 128033,
 -1,
 1109049133,
 127804,
 1109213773,
 1100533277,
 -1,
 1109279299,
 1109152498,
 128027,
 1109393407,
 1109223384,
 -1,
 1109410363,
 1109293707,
 -1,
 1109475881,
 1109362984,
 -1,
 1109541412,
 1109451532,
 -1,
 -48605,
 1109470491,
 6671,
 -1,
 1109530932,
 6670,
 1109738023,
 1109480178,
 -1,
 -48602,
 1109684445,
 6659,
 -1,
 1109727540,
 6658,
 -48600,
 1109698805,
 6667,
 -1,
 1109858612,
 6666,
 1110065708,
 1109426309,
 -1,
 -48597,
 1110023977,
 6663,
 -1,
 1110055220,
 6662,
 -48595,
 1110041460,
 6672,
 -48594,
 1110234638,
 6675,
 -48593,
 1110295320,
 6664,
 -48592,
 1110357505,
 6676,
 -48591,
 1110419701,
 6673,
 -48590,
 1110482729,
 6660,
 -48589,
 1110537366,
 6674,
 -48588,
 1110601949,
 6656,
 -48587,
 1110667133,
 6669,
 -48586,
 1110726718,
 6678,
 -48585,
 1110790977,
 6657,
 -48584,
 1110849694,
 6665,
 -48583,
 1110912283,
 6668,
 -48582,
 1110976244,
 6661,
 -1,
 1111038260,
 6677,
 1111245377,
 1109383792,
 -1,
 -48579,
 1111215645,
 6680,
 -48578,
 1111265425,
 6682,
 -48577,
 1111318913,
 6679,
 -48576,
 1111376067,
 6681,
 -1,
 1111432154,
 6683,
 -48574,
 1111203735,
 6686,
 -1,
 1111574240,
 6687,
 1111769672,
 1109243223,
 128652,
 1111835207,
 1111736978,
 -1,
 -48570,
 1111799148,
 128101,
 -1,
 1111819138,
 128100,
 -1,
 1111755080,
 128655,
 1112097354,
 1111719276,
 128363,
 -1,
 1112018389,
 128364,
 -48565,
 1112067113,
 129419,
 -48564,
 1112192049,
 127791,
 -1,
 1112237511,
 127959,
 1112425084,
 1109168273,
 -1,
 1112490583,
 1112394744,
 -1,
 1112556118,
 1112445846,
 -1,
 -48559,
 1112525264,
 9185,
 -48558,
 1112584012,
 11813,
 -48557,
 1112645740,
 9181,
 -48556,
 1112701032,
 11812,
 -48555,
 1112758501,
 11211,
 -1,
 1112815514,
 9183,
 -1,
 1112504193,
 127870,
 1113080417,
 1112438518,
 -1,
 1113145947,
 1113054467,
 -1,
 -48550,
 1113112143,
 128912,
 -1,
 1113141495,
 128902,
 1113342558,
 1113109847,
 -1,
 -48547,
 1113288425,
 128951,
 -1,
 1113333602,
 128939,
 -48545,
 1113282434,
 128932,
 -48544,
 1113477034,
 128945,
 -1,
 1113539896,
 128957,
 1113735784,
 1113040018,
 -1,
 -48541,
 1113712456,
 12730,
 -48540,
 1113755840,
 12590,
 -48539,
 1113820557,
 12591,
 -48538,
 1113881402,
 12729,
 -48537,
 1113941384,
 12589,
 -1,
 1114002800,
 12728,
 1114194543,
 1113709284,
 -1,
 1114260078,
 1114141772,
 -1,
 1114325613,
 1114177536,
 -1,
 -48532,
 1114300216,
 129379,
 -1,
 1114345948,
 128335,
 -1,
 1114269663,
 127923,
 -1,
 1114177608,
 127993,
 1114653299,
 1114149529,
 128366,
 1114718834,
 1114604165,
 128278,
 -1,
 1114638711,
 128209,
 -1,
 1114682711,
 128218,
 1114915445,
 1114628876,
 128102,
 -1,
 1114879446,
 128713,
 1115046519,
 1114887201,
 128144,
 -1,
 1114965262,
 127893,
 1115177593,
 1114996869,
 983258,
 -1,
 1115104959,
 128163,
 -48518,
 1115153074,
 129354,
 -48517,
 1115261646,
 129460,
 -1,
 1115300373,
 128023,
 1115505310,
 1112359107,
 -1,
 1115570831,
 1115457832,
 -1,
 1115636363,
 1115509679,
 -1,
 1115701892,
 1115585163,
 -1,
 1115767427,
 1115648623,
 -1,
 -48510,
 1115712341,
 983642,
 -1,
 1115758733,
 2510,
 -1,
 1115739941,
 2556,
 1116029575,
 1115665751,
 -1,
 -48506,
 1115972938,
 2493,
 -1,
 1116020893,
 2558,
 1116226186,
 1115953460,
 -1,
 -48503,
 1116179832,
 2432,
 -1,
 1116219480,
 2557,
 -1,
 1116165082,
 2555,
 1116488334,
 1115603602,
 -1,
 -48499,
 1116442771,
 127857,
 -1,
 1116471534,
 11102,
 -1,
 1116464756,
 9187,
 1116750488,
 1115494708,
 -1,
 1116816019,
 1116711042,
 -1,
 -48494,
 1116748232,
 129492,
 -1,
 1116799676,
 128059,
 1117012630,
 1116767165,
 -1,
 -48491,
 1116944981,
 127901,
 -1,
 1117004859,
 127900,
 -48489,
 1116981394,
 128147,
 -1,
 1117138835,
 127958,
 1117340316,
 1116697676,
 983055,
 1117454335,
 1117287500,
 128276,
 -48485,
 1117347502,
 128718,
 -1,
 1117391693,
 128277,
 -48483,
 1117276312,
 127866,
 -1,
 1117534223,
 128719,
 1117733546,
 1115447681,
 -1,
 1117799074,
 1117694082,
 -1,
 -48479,
 1117767142,
 127874,
 -1,
 1117796367,
 128038,
 1117995685,
 1117748496,
 -1,
 -48476,
 1117938326,
 127921,
 -1,
 1117995803,
 129506,
 1118192296,
 1117927434,
 -1,
 -48473,
 1118137635,
 128692,
 -1,
 1118191811,
 128690,
 -48471,
 1118159938,
 8383,
 -1,
 1118335753,
 128089,
 1118519981,
 1117709068,
 -1,
 -48468,
 1118496277,
 983267,
 -1,
 1118553168,
 983257,
 -48466,
 1118483799,
 983057,
 -1,
 1118675469,
 983125,
 1118848637,
 997578232,
 -1,
 1118913806,
 1118771508,
 -1,
 1118979084,
 1118855555,
 -1,
 1119044603,
 1118945822,
 -1,
 1119110120,
 1118993709,
 -1,
 1119175399,
 1119062312,
 -1,
 1119240898,
 1119113970,
 42507,
 1119306431,
 1119179506,
 -1,
 1119371962,
 1119240387,
 42500,
 -48455,
 1119324456,
 42501,
 -1,
 1119371459,
 42271,
 1119568572,
 1119326353,
 42460,
 -1,
 1119522961,
 42384,
 -48451,
 1119538717,
 42421,
 -48450,
 1119641985,
 42308,
 -1,
 1119689012,
 42348,
 -48448,
 1119261716,
 42428,
 -48447,
 1119831626,
 42467,
 -1,
 1119887288,
 42315,
 1120092880,
 1119172623,
 -1,
 1120158411,
 1120047249,
 42450,
 1120223946,
 1120106320,
 -1,
 -48442,
 1120189870,
 42514,
 -48441,
 1120239835,
 42538,
 -48440,
 1120301277,
 42513,
 -48439,
 1120357692,
 42512,
 -1,
 1120418829,
 42539,
 -1,
 1120178321,
 42374,
 1120682701,
 1120092355,
 42490,
 -1,
 1120616643,
 42261,
 -48434,
 1120652829,
 42411,
 -48433,
 1120756097,
 42298,
 -1,
 1120803124,
 42337,
 1121010392,
 1120068364,
 -1,
 1121075923,
 1120964753,
 42464,
 -1,
 1121030289,
 42388,
 1121206997,
 1121009859,
 42506,
 -1,
 1121140931,
 42275,
 -48426,
 1121177117,
 42425,
 -48425,
 1121280385,
 42312,
 -1,
 1121327412,
 42352,
 1121534688,
 1120956255,
 -1,
 1121600219,
 1121489041,
 42457,
 -1,
 1121554577,
 42381,
 1121731293,
 1121534147,
 42497,
 -1,
 1121665219,
 42268,
 -48418,
 1121701405,
 42418,
 -48417,
 1121804673,
 42305,
 -1,
 1121851700,
 42344,
 1122058978,
 1121489041,
 42463,
 -1,
 1122013329,
 42387,
 1122190052,
 1121992899,
 42505,
 -1,
 1122123971,
 42274,
 -48411,
 1122160157,
 42424,
 -48410,
 1122263425,
 42311,
 -1,
 1122310452,
 42351,
 1122517759,
 1119125637,
 -1,
 1122583280,
 1122456653,
 -1,
 1122648811,
 1122537617,
 42438,
 -1,
 1122603153,
 42363,
 1122779885,
 1122582723,
 42478,
 -1,
 1122713795,
 42250,
 -48402,
 1122749981,
 42400,
 -48401,
 1122853249,
 42287,
 -1,
 1122900276,
 42326,
 1123107576,
 1122510527,
 -1,
 1123173107,
 1123061905,
 42436,
 -1,
 1123127441,
 42361,
 1123304181,
 1123107011,
 42475,
 -1,
 1123238083,
 42248,
 -48394,
 1123274269,
 42398,
 -48393,
 1123377537,
 42285,
 -1,
 1123424564,
 42323,
 1123631866,
 1123061905,
 42462,
 -1,
 1123586193,
 42386,
 1123762940,
 1123565763,
 42504,
 -1,
 1123696835,
 42273,
 -48387,
 1123733021,
 42423,
 -48386,
 1123836289,
 42310,
 -1,
 1123883316,
 42350,
 1124090647,
 1122449423,
 -1,
 1124156176,
 1124030504,
 -1,
 1124221705,
 1124096040,
 -1,
 1124287236,
 1124176017,
 42446,
 -1,
 1124241553,
 42370,
 1124418310,
 1124221123,
 42486,
 -1,
 1124352195,
 42257,
 -48377,
 1124388381,
 42407,
 -48376,
 1124491649,
 42294,
 -1,
 1124538676,
 42333,
 1124745995,
 1124176017,
 42445,
 -1,
 1124700305,
 42369,
 1124877069,
 1124679875,
 42485,
 -1,
 1124810947,
 42256,
 -48370,
 1124847133,
 42406,
 -48369,
 1124950401,
 42293,
 -1,
 1124997428,
 42332,
 1125204754,
 1124110481,
 42449,
 -1,
 1125159057,
 42373,
 1125335828,
 1125138627,
 42489,
 -1,
 1125269699,
 42260,
 -48363,
 1125305885,
 42410,
 -48362,
 1125409153,
 42297,
 -1,
 1125456180,
 42336,
 1125663530,
 1124036747,
 -1,
 1125729058,
 1125621453,
 -1,
 1125794588,
 1125662915,
 42476,
 -48357,
 1125746984,
 42477,
 -1,
 1125793987,
 42249,
 1125991198,
 1125748881,
 42437,
 -1,
 1125945489,
 42362,
 1126122272,
 1125914932,
 42324,
 -1,
 1126074664,
 42325,
 -48351,
 1126092317,
 42399,
 -1,
 1126195585,
 42286,
 1126384420,
 1125683345,
 42459,
 -1,
 1126338705,
 42383,
 1126515494,
 1126318275,
 42499,
 -1,
 1126449347,
 42270,
 1126646568,
 1126439220,
 42346,
 -1,
 1126598952,
 42347,
 -48343,
 1126616605,
 42420,
 -1,
 1126719873,
 42307,
 1126908733,
 1125602034,
 -1,
 1126974261,
 1126835903,
 -1,
 1127039791,
 1126928529,
 42439,
 -48338,
 1126994065,
 42364,
 -1,
 1127057704,
 42440,
 1127236402,
 1126973635,
 42479,
 -48335,
 1127188776,
 42480,
 -1,
 1127235779,
 42251,
 -48333,
 1127206429,
 42401,
 -48332,
 1127375233,
 42288,
 -1,
 1127422260,
 42327,
 1127629624,
 1126908099,
 42502,
 -48329,
 1127581992,
 42503,
 -1,
 1127628995,
 42272,
 1127826234,
 1127583889,
 42461,
 -1,
 1127780497,
 42385,
 -48325,
 1127796253,
 42422,
 -48324,
 1127899521,
 42309,
 -1,
 1127946548,
 42349,
 1128153933,
 1126884797,
 -1,
 1128219462,
 1128093736,
 -1,
 1128284993,
 1128173713,
 42454,
 -1,
 1128239249,
 42378,
 1128416067,
 1128218819,
 42494,
 -1,
 1128349891,
 42265,
 -48316,
 1128386077,
 42415,
 -48315,
 1128489345,
 42302,
 -1,
 1128536372,
 42341,
 1128743752,
 1128173713,
 42453,
 -1,
 1128698001,
 42377,
 1128874826,
 1128677571,
 42493,
 -1,
 1128808643,
 42264,
 -48309,
 1128844829,
 42414,
 -48308,
 1128948097,
 42301,
 -1,
 1128995124,
 42340,
 1129202524,
 1128127204,
 -1,
 1129268050,
 1129156753,
 42431,
 1129333585,
 1129222289,
 42356,
 -1,
 1129285928,
 42357,
 -1,
 1129285928,
 42432,
 1129530198,
 1129201859,
 42470,
 1129595733,
 1129464003,
 42243,
 -1,
 1129548072,
 42244,
 -1,
 1129548072,
 42471,
 1129792344,
 1129500189,
 42393,
 -1,
 1129744680,
 42394,
 1129923418,
 1129734529,
 42280,
 -1,
 1129875752,
 42281,
 1130102783,
 1129847092,
 42318,
 -1,
 1130006824,
 42319,
 1130185580,
 1129169554,
 -1,
 1130251109,
 1130125352,
 -1,
 1130316640,
 1130205329,
 42444,
 -1,
 1130270865,
 42368,
 1130447714,
 1130250435,
 42484,
 -1,
 1130381507,
 42255,
 -48285,
 1130417693,
 42405,
 -48284,
 1130520961,
 42292,
 -1,
 1130567988,
 42331,
 1130775399,
 1130205329,
 42443,
 -1,
 1130729617,
 42367,
 1130906473,
 1130709187,
 42483,
 -1,
 1130840259,
 42254,
 -48278,
 1130876445,
 42404,
 -48277,
 1130979713,
 42291,
 -1,
 1131026740,
 42330,
 1131234172,
 1130149207,
 -1,
 1131299701,
 1131173928,
 -1,
 1131365232,
 1131253905,
 42452,
 -1,
 1131319441,
 42376,
 1131496306,
 1131299011,
 42492,
 -1,
 1131430083,
 42263,
 -48269,
 1131466269,
 42413,
 -48268,
 1131569537,
 42300,
 -1,
 1131616564,
 42339,
 1131823991,
 1131253905,
 42451,
 -1,
 1131778193,
 42375,
 1131955065,
 1131757763,
 42491,
 -1,
 1131888835,
 42262,
 -48262,
 1131925021,
 42412,
 -48261,
 1132028289,
 42299,
 -1,
 1132075316,
 42338,
 1132282764,
 1131161279,
 -1,
 1132348293,
 1132222504,
 -1,
 1132413824,
 1132302481,
 42434,
 -1,
 1132368017,
 42359,
 1132544898,
 1132347587,
 42473,
 -1,
 1132478659,
 42246,
 -48253,
 1132514845,
 42396,
 -48252,
 1132618113,
 42283,
 -1,
 1132665140,
 42321,
 1132872583,
 1132302481,
 42435,
 -1,
 1132826769,
 42360,
 1133003657,
 1132806339,
 42474,
 -1,
 1132937411,
 42247,
 -48246,
 1132973597,
 42397,
 -48245,
 1133076865,
 42284,
 -1,
 1133123892,
 42322,
 1133331353,
 1132222504,
 -1,
 1133396880,
 1133285521,
 42429,
 -48241,
 1133351057,
 42355,
 -1,
 1133414696,
 42430,
 1133593491,
 1133330627,
 42468,
 -48238,
 1133545768,
 42469,
 -1,
 1133592771,
 42242,
 1133790101,
 1133563421,
 42391,
 -1,
 1133742376,
 42392,
 1133921175,
 1133732225,
 42278,
 -1,
 1133873448,
 42279,
 1134100479,
 1133844788,
 42316,
 -1,
 1134004520,
 42317,
 1134183330,
 1133278284,
 -1,
 1134248861,
 1134117059,
 42487,
 -48228,
 1134201983,
 42508,
 -1,
 1134248131,
 42258,
 1134445471,
 1134203025,
 42447,
 -1,
 1134399633,
 42371,
 -48224,
 1134415389,
 42408,
 -48223,
 1134518657,
 42295,
 -1,
 1134565684,
 42334,
 1134773162,
 1134158604,
 -1,
 1134838693,
 1134727313,
 42458,
 -1,
 1134792849,
 42382,
 1134969767,
 1134772419,
 42498,
 -1,
 1134903491,
 42269,
 -48216,
 1134939677,
 42419,
 -48215,
 1135042945,
 42306,
 -1,
 1135089972,
 42345,
 1135297458,
 1134745080,
 -1,
 1135362989,
 1135251601,
 42442,
 -1,
 1135317137,
 42366,
 1135494063,
 1135296707,
 42482,
 -1,
 1135427779,
 42253,
 -48208,
 1135463965,
 42403,
 -48207,
 1135567233,
 42290,
 -1,
 1135614260,
 42329,
 1135821754,
 1135257730,
 -1,
 1135887285,
 1135775889,
 42448,
 -1,
 1135841425,
 42372,
 1136018359,
 1135820995,
 42488,
 -1,
 1135952067,
 42259,
 -48200,
 1135988253,
 42409,
 -48199,
 1136091521,
 42296,
 -1,
 1136138548,
 42335,
 1136346050,
 1135779533,
 -1,
 1136411581,
 1136300177,
 42433,
 -1,
 1136365713,
 42358,
 1136542655,
 1136345283,
 42472,
 -1,
 1136476355,
 42245,
 -48192,
 1136512541,
 42395,
 -48191,
 1136615809,
 42282,
 -1,
 1136662836,
 42320,
 1136870346,
 1136291679,
 -1,
 1136935877,
 1136824465,
 42456,
 -1,
 1136890001,
 42380,
 1137066951,
 1136869571,
 42496,
 -1,
 1137000643,
 42267,
 -48184,
 1137036829,
 42417,
 -48183,
 1137140097,
 42304,
 -1,
 1137187124,
 42343,
 1137394642,
 1136807143,
 -1,
 1137460173,
 1137348753,
 42441,
 -1,
 1137414289,
 42365,
 1137591247,
 1137393859,
 42481,
 -1,
 1137524931,
 42252,
 -48176,
 1137561117,
 42402,
 -48175,
 1137664385,
 42289,
 -1,
 1137711412,
 42328,
 1137918938,
 1137323236,
 -1,
 1137984469,
 1137873041,
 42455,
 -1,
 1137938577,
 42379,
 1138115543,
 1137918147,
 42495,
 -1,
 1138049219,
 42266,
 -48168,
 1138085405,
 42416,
 -48167,
 1138188673,
 42303,
 -1,
 1138235700,
 42342,
 1138443230,
 1137873041,
 42426,
 1138508765,
 1138397329,
 42353,
 -1,
 1138460968,
 42354,
 -1,
 1138460968,
 42427,
 1138705378,
 1138376899,
 42465,
 1138770913,
 1138639043,
 42240,
 -1,
 1138723112,
 42241,
 -1,
 1138723112,
 42466,
 1138967524,
 1138675229,
 42389,
 -1,
 1138919720,
 42390,
 1139098598,
 1138909569,
 42276,
 -1,
 1139050792,
 42277,
 1139277823,
 1139022132,
 42313,
 -1,
 1139181864,
 42314,
 1139408895,
 1119060841,
 -1,
 1139426285,
 1139327634,
 -1,
 -48149,
 1139381633,
 42525,
 -48148,
 1139435487,
 42517,
 -1,
 1139481068,
 42521,
 1139688434,
 1139357711,
 -1,
 1139753969,
 1139642513,
 -1,
 -48144,
 1139709313,
 42523,
 -1,
 1139740478,
 42526,
 -1,
 1139679420,
 42522,
 1140016117,
 1139634315,
 -1,
 -48140,
 1139986980,
 42524,
 -1,
 1140016140,
 42516,
 1140212728,
 1139952871,
 -1,
 -48137,
 1140147212,
 42515,
 -1,
 1140201964,
 42520,
 -48135,
 1140165832,
 42518,
 -48134,
 1140355146,
 42527,
 -1,
 1140402055,
 42519,
 1140605961,
 1118976862,
 -1,
 1140671487,
 1140572818,
 -1,
 -48130,
 1140645904,
 42530,
 -1,
 1140678609,
 42531,
 1140868098,
 1140634967,
 -1,
 -48127,
 1140813522,
 42534,
 -1,
 1140869867,
 42535,
 1141064709,
 1140804839,
 -1,
 -48124,
 1141021467,
 42532,
 -1,
 1141075488,
 42533,
 -48122,
 1141040778,
 42528,
 -48121,
 1141216431,
 42529,
 -48120,
 1141279960,
 42537,
 -1,
 1141327117,
 42536,
 -48118,
 1140566055,
 42511,
 -48117,
 1141461729,
 42510,
 -1,
 1141519289,
 42509,
 1141720333,
 1118940824,
 -1,
 1141785724,
 1141641450,
 -1,
 1141851161,
 1141708930,
 917762,
 -48112,
 1141774466,
 917942,
 -48111,
 1141839825,
 917941,
 -48110,
 1141905137,
 917940,
 -48109,
 1141970465,
 917939,
 -48108,
 1142035756,
 917938,
 -48107,
 1142101080,
 917937,
 -48106,
 1142166330,
 917936,
 -48105,
 1142231573,
 917935,
 -48104,
 1142296810,
 917934,
 -1,
 1142362077,
 917933,
 1142572068,
 1141774289,
 917761,
 -48101,
 1142495362,
 917932,
 -48100,
 1142560721,
 917931,
 -48099,
 1142626033,
 917930,
 -48098,
 1142691361,
 917929,
 -48097,
 1142756652,
 917928,
 -48096,
 1142821976,
 917927,
 -48095,
 1142887226,
 917926,
 -48094,
 1142952469,
 917925,
 -48093,
 1143017706,
 917924,
 -1,
 1143082973,
 917923,
 1143292975,
 1142494961,
 917760,
 -48090,
 1143216258,
 917922,
 -48089,
 1143281617,
 917921,
 -48088,
 1143346929,
 917920,
 -48087,
 1143412257,
 917919,
 -48086,
 1143477548,
 917918,
 -48085,
 1143542872,
 917917,
 -48084,
 1143608122,
 917916,
 -48083,
 1143673365,
 917915,
 -48082,
 1143738602,
 917914,
 -1,
 1143803869,
 917913,
 1144013882,
 1143215649,
 -1,
 -48079,
 1143937154,
 917912,
 -48078,
 1144002513,
 917911,
 -48077,
 1144067825,
 917910,
 -48076,
 1144133153,
 917909,
 -48075,
 1144198444,
 917908,
 -48074,
 1144263768,
 917907,
 -48073,
 1144329018,
 917906,
 -48072,
 1144394261,
 917905,
 -48071,
 1144459498,
 917904,
 -1,
 1144524765,
 917903,
 1144734789,
 1143936300,
 -1,
 -48068,
 1144658050,
 917902,
 -48067,
 1144723409,
 917901,
 -48066,
 1144788721,
 917900,
 -48065,
 1144854049,
 917899,
 -48064,
 1144919340,
 917898,
 -48063,
 1144984664,
 917897,
 -48062,
 1145049914,
 917896,
 -48061,
 1145115157,
 917895,
 -48060,
 1145180394,
 917894,
 -1,
 1145245661,
 917893,
 1145455696,
 1144656984,
 -1,
 -48057,
 1145378946,
 917892,
 -48056,
 1145444305,
 917891,
 -48055,
 1145509617,
 917890,
 -48054,
 1145574945,
 917889,
 -48053,
 1145640236,
 917888,
 -48052,
 1145705560,
 917887,
 -48051,
 1145770810,
 917886,
 -48050,
 1145836053,
 917885,
 -48049,
 1145901290,
 917884,
 -1,
 1145966557,
 917883,
 1146176603,
 1145377594,
 -1,
 -48046,
 1146099842,
 917882,
 -48045,
 1146165201,
 917881,
 -48044,
 1146230513,
 917880,
 -48043,
 1146295841,
 917879,
 -48042,
 1146361132,
 917878,
 -48041,
 1146426456,
 917877,
 -48040,
 1146491706,
 917876,
 -48039,
 1146556949,
 917875,
 -48038,
 1146622186,
 917874,
 -1,
 1146687453,
 917873,
 1146897510,
 1146098197,
 -1,
 -48035,
 1146820738,
 917872,
 -48034,
 1146886097,
 917871,
 -48033,
 1146951409,
 917870,
 -48032,
 1147016737,
 917869,
 -48031,
 1147082028,
 917868,
 -48030,
 1147147352,
 917867,
 -48029,
 1147212602,
 917866,
 -48028,
 1147277845,
 917865,
 -48027,
 1147343082,
 917864,
 -1,
 1147408349,
 917863,
 1147618417,
 1146818794,
 -1,
 -48024,
 1147541634,
 917862,
 -48023,
 1147606993,
 917861,
 -48022,
 1147672305,
 917860,
 -48021,
 1147737633,
 917859,
 -48020,
 1147802924,
 917858,
 -48019,
 1147868248,
 917857,
 -48018,
 1147933498,
 917856,
 -48017,
 1147998741,
 917855,
 -48016,
 1148063978,
 917854,
 -1,
 1148129245,
 917853,
 1148387327,
 1147539421,
 -1,
 -48013,
 1148262530,
 917852,
 -48012,
 1148327889,
 917851,
 -48011,
 1148393201,
 917850,
 -48010,
 1148458529,
 917849,
 -48009,
 1148523820,
 917848,
 -48008,
 1148589144,
 917847,
 -48007,
 1148654394,
 917846,
 -48006,
 1148719637,
 917845,
 -48005,
 1148784874,
 917844,
 -1,
 1148850141,
 917843,
 1149060288,
 1141707285,
 -1,
 1149125768,
 1148982360,
 917767,
 -48001,
 1149048962,
 917992,
 -48000,
 1149114321,
 917991,
 -47999,
 1149179633,
 917990,
 -47998,
 1149244961,
 917989,
 -47997,
 1149310252,
 917988,
 -47996,
 1149375576,
 917987,
 -47995,
 1149440826,
 917986,
 -47994,
 1149506069,
 917985,
 -47993,
 1149571306,
 917984,
 -1,
 1149636573,
 917983,
 1149846675,
 1149047610,
 917766,
 -47990,
 1149769858,
 917982,
 -47989,
 1149835217,
 917981,
 -47988,
 1149900529,
 917980,
 -47987,
 1149965857,
 917979,
 -47986,
 1150031148,
 917978,
 -47985,
 1150096472,
 917977,
 -47984,
 1150161722,
 917976,
 -47983,
 1150226965,
 917975,
 -47982,
 1150292202,
 917974,
 -1,
 1150357469,
 917973,
 1150567582,
 1149768213,
 917765,
 -47979,
 1150490754,
 917972,
 -47978,
 1150556113,
 917971,
 -47977,
 1150621425,
 917970,
 -47976,
 1150686753,
 917969,
 -47975,
 1150752044,
 917968,
 -47974,
 1150817368,
 917967,
 -47973,
 1150882618,
 917966,
 -47972,
 1150947861,
 917965,
 -47971,
 1151013098,
 917964,
 -1,
 1151078365,
 917963,
 1151288489,
 1150488810,
 917764,
 -47968,
 1151211650,
 917962,
 -47967,
 1151277009,
 917961,
 -47966,
 1151342321,
 917960,
 -47965,
 1151407649,
 917959,
 -47964,
 1151472940,
 917958,
 -47963,
 1151538264,
 917957,
 -47962,
 1151603514,
 917956,
 -47961,
 1151668757,
 917955,
 -47960,
 1151733994,
 917954,
 -1,
 1151799261,
 917953,
 1152009396,
 1151209437,
 917763,
 -47957,
 1151932546,
 917952,
 -47956,
 1151997905,
 917951,
 -47955,
 1152063217,
 917950,
 -47954,
 1152128545,
 917949,
 -47953,
 1152193836,
 917948,
 -47952,
 1152259160,
 917947,
 -47951,
 1152324410,
 917946,
 -47950,
 1152389653,
 917945,
 -47949,
 1152454890,
 917944,
 -1,
 1152520157,
 917943,
 1152730300,
 1151931692,
 917768,
 -47946,
 1152652833,
 917999,
 -47945,
 1152718124,
 917998,
 -47944,
 1152783448,
 917997,
 -47943,
 1152848698,
 917996,
 -47942,
 1152913941,
 917995,
 -47941,
 1152979178,
 917994,
 -1,
 1153044445,
 917993,
 -47939,
 1152653442,
 917772,
 -47938,
 1153177553,
 917771,
 -47937,
 1153242865,
 917770,
 -1,
 1153308193,
 917769,
 1153516747,
 1148983426,
 -1,
 -47934,
 1153439874,
 917842,
 -47933,
 1153505233,
 917841,
 -47932,
 1153570545,
 917840,
 -47931,
 1153635873,
 917839,
 -47930,
 1153701164,
 917838,
 -47929,
 1153766488,
 917837,
 -47928,
 1153831738,
 917836,
 -47927,
 1153896981,
 917835,
 -47926,
 1153962218,
 917834,
 -1,
 1154027485,
 917833,
 1154237654,
 1153439697,
 -1,
 -47923,
 1154160770,
 917832,
 -47922,
 1154226129,
 917831,
 -47921,
 1154291441,
 917830,
 -47920,
 1154356769,
 917829,
 -47919,
 1154422060,
 917828,
 -47918,
 1154487384,
 917827,
 -47917,
 1154552634,
 917826,
 -47916,
 1154617877,
 917825,
 -47915,
 1154683114,
 917824,
 -1,
 1154748381,
 917823,
 1154958561,
 1154160369,
 -1,
 -47912,
 1154881666,
 917822,
 -47911,
 1154947025,
 917821,
 -47910,
 1155012337,
 917820,
 -47909,
 1155077665,
 917819,
 -47908,
 1155142956,
 917818,
 -47907,
 1155208280,
 917817,
 -47906,
 1155273530,
 917816,
 -47905,
 1155338773,
 917815,
 -47904,
 1155404010,
 917814,
 -1,
 1155469277,
 917813,
 1155679468,
 1154881057,
 -1,
 -47901,
 1155602562,
 917812,
 -47900,
 1155667921,
 917811,
 -47899,
 1155733233,
 917810,
 -47898,
 1155798561,
 917809,
 -47897,
 1155863852,
 917808,
 -47896,
 1155929176,
 917807,
 -47895,
 1155994426,
 917806,
 -47894,
 1156059669,
 917805,
 -47893,
 1156124906,
 917804,
 -1,
 1156190173,
 917803,
 1156400375,
 1155601708,
 -1,
 -47890,
 1156323458,
 917802,
 -47889,
 1156388817,
 917801,
 -47888,
 1156454129,
 917800,
 -47887,
 1156519457,
 917799,
 -47886,
 1156584748,
 917798,
 -47885,
 1156650072,
 917797,
 -47884,
 1156715322,
 917796,
 -47883,
 1156780565,
 917795,
 -47882,
 1156845802,
 917794,
 -1,
 1156911069,
 917793,
 1157121282,
 1156322392,
 -1,
 -47879,
 1157044354,
 917792,
 -47878,
 1157109713,
 917791,
 -47877,
 1157175025,
 917790,
 -47876,
 1157240353,
 917789,
 -47875,
 1157305644,
 917788,
 -47874,
 1157370968,
 917787,
 -47873,
 1157436218,
 917786,
 -47872,
 1157501461,
 917785,
 -47871,
 1157566698,
 917784,
 -1,
 1157631965,
 917783,
 1157890047,
 1157043002,
 -1,
 -47868,
 1157765250,
 917782,
 -47867,
 1157830609,
 917781,
 -47866,
 1157895921,
 917780,
 -47865,
 1157961249,
 917779,
 -47864,
 1158026540,
 917778,
 -47863,
 1158091864,
 917777,
 -47862,
 1158157114,
 917776,
 -47861,
 1158222357,
 917775,
 -47860,
 1158287594,
 917774,
 -1,
 1158352861,
 917773,
 -1,
 1141671943,
 129499,
 1158628879,
 1118877015,
 -1,
 1158694270,
 1158549738,
 983240,
 1158759707,
 1158617218,
 983270,
 -47854,
 1158682754,
 983450,
 -47853,
 1158748113,
 983449,
 -47852,
 1158813425,
 983448,
 -47851,
 1158878753,
 983447,
 -47850,
 1158944044,
 983446,
 -47849,
 1159009368,
 983445,
 -47848,
 1159074618,
 983444,
 -47847,
 1159139861,
 983443,
 -47846,
 1159205098,
 983442,
 -1,
 1159270365,
 983441,
 1159480614,
 1158682577,
 983269,
 -47843,
 1159403650,
 983440,
 -47842,
 1159469009,
 983439,
 -47841,
 1159534321,
 983438,
 -47840,
 1159599649,
 983437,
 -47839,
 1159664940,
 983436,
 -47838,
 1159730264,
 983435,
 -47837,
 1159795514,
 983434,
 -47836,
 1159860757,
 983433,
 -47835,
 1159925994,
 983432,
 -1,
 1159991261,
 983431,
 1160201521,
 1159403249,
 983268,
 -47832,
 1160124546,
 983430,
 -47831,
 1160189905,
 983429,
 -47830,
 1160255217,
 983428,
 -47829,
 1160320545,
 983427,
 -47828,
 1160385836,
 983426,
 -47827,
 1160451160,
 983425,
 -47826,
 1160516410,
 983424,
 -47825,
 1160581653,
 983423,
 -47824,
 1160646890,
 983422,
 -1,
 1160712157,
 983421,
 1160922428,
 1160123937,
 983255,
 -47821,
 1160845442,
 983420,
 -47820,
 1160910801,
 983419,
 -47819,
 1160976113,
 983418,
 -47818,
 1161041441,
 983417,
 -47817,
 1161106732,
 983416,
 -47816,
 1161172056,
 983415,
 -47815,
 1161237306,
 983414,
 -47814,
 1161302549,
 983413,
 -47813,
 1161367786,
 983412,
 -1,
 1161433053,
 983411,
 1161643335,
 1160844588,
 983254,
 -47810,
 1161566338,
 983410,
 -47809,
 1161631697,
 983409,
 -47808,
 1161697009,
 983408,
 -47807,
 1161762337,
 983407,
 -47806,
 1161827628,
 983406,
 -47805,
 1161892952,
 983405,
 -47804,
 1161958202,
 983404,
 -47803,
 1162023445,
 983403,
 -47802,
 1162088682,
 983402,
 -1,
 1162153949,
 983401,
 1162364242,
 1161565272,
 983253,
 -47799,
 1162287234,
 983400,
 -47798,
 1162352593,
 983399,
 -47797,
 1162417905,
 983398,
 -47796,
 1162483233,
 983397,
 -47795,
 1162548524,
 983396,
 -47794,
 1162613848,
 983395,
 -47793,
 1162679098,
 983394,
 -47792,
 1162744341,
 983393,
 -47791,
 1162809578,
 983392,
 -1,
 1162874845,
 983391,
 1163085149,
 1162285882,
 983252,
 -47788,
 1163008130,
 983390,
 -47787,
 1163073489,
 983389,
 -47786,
 1163138801,
 983388,
 -47785,
 1163204129,
 983387,
 -47784,
 1163269420,
 983386,
 -47783,
 1163334744,
 983385,
 -47782,
 1163399994,
 983384,
 -47781,
 1163465237,
 983383,
 -47780,
 1163530474,
 983382,
 -1,
 1163595741,
 983381,
 1163806056,
 1163006485,
 983251,
 -47777,
 1163729026,
 983380,
 -47776,
 1163794385,
 983379,
 -47775,
 1163859697,
 983378,
 -47774,
 1163925025,
 983377,
 -47773,
 1163990316,
 983376,
 -47772,
 1164055640,
 983375,
 -47771,
 1164120890,
 983374,
 -47770,
 1164186133,
 983373,
 -47769,
 1164251370,
 983372,
 -1,
 1164316637,
 983371,
 1164526963,
 1163727082,
 983250,
 -47766,
 1164449922,
 983370,
 -47765,
 1164515281,
 983369,
 -47764,
 1164580593,
 983368,
 -47763,
 1164645921,
 983367,
 -47762,
 1164711212,
 983366,
 -47761,
 1164776536,
 983365,
 -47760,
 1164841786,
 983364,
 -47759,
 1164907029,
 983363,
 -47758,
 1164972266,
 983362,
 -1,
 1165037533,
 983361,
 1165295615,
 1164447709,
 983249,
 -47755,
 1165170818,
 983360,
 -47754,
 1165236177,
 983359,
 -47753,
 1165301489,
 983358,
 -47752,
 1165366817,
 983357,
 -47751,
 1165432108,
 983356,
 -47750,
 1165497432,
 983355,
 -47749,
 1165562682,
 983354,
 -47748,
 1165627925,
 983353,
 -47747,
 1165693162,
 983352,
 -1,
 1165758429,
 983351,
 1165968834,
 1158615573,
 983241,
 1166034314,
 1165890648,
 983275,
 -47743,
 1165957250,
 983500,
 -47742,
 1166022609,
 983499,
 -47741,
 1166087921,
 983498,
 -47740,
 1166153249,
 983497,
 -47739,
 1166218540,
 983496,
 -47738,
 1166283864,
 983495,
 -47737,
 1166349114,
 983494,
 -47736,
 1166414357,
 983493,
 -47735,
 1166479594,
 983492,
 -1,
 1166544861,
 983491,
 1166755221,
 1165955898,
 983274,
 -47732,
 1166678146,
 983490,
 -47731,
 1166743505,
 983489,
 -47730,
 1166808817,
 983488,
 -47729,
 1166874145,
 983487,
 -47728,
 1166939436,
 983486,
 -47727,
 1167004760,
 983485,
 -47726,
 1167070010,
 983484,
 -47725,
 1167135253,
 983483,
 -47724,
 1167200490,
 983482,
 -1,
 1167265757,
 983481,
 1167476128,
 1166676501,
 983273,
 -47721,
 1167399042,
 983480,
 -47720,
 1167464401,
 983479,
 -47719,
 1167529713,
 983478,
 -47718,
 1167595041,
 983477,
 -47717,
 1167660332,
 983476,
 -47716,
 1167725656,
 983475,
 -47715,
 1167790906,
 983474,
 -47714,
 1167856149,
 983473,
 -47713,
 1167921386,
 983472,
 -1,
 1167986653,
 983471,
 1168197035,
 1167397098,
 983272,
 -47710,
 1168119938,
 983470,
 -47709,
 1168185297,
 983469,
 -47708,
 1168250609,
 983468,
 -47707,
 1168315937,
 983467,
 -47706,
 1168381228,
 983466,
 -47705,
 1168446552,
 983465,
 -47704,
 1168511802,
 983464,
 -47703,
 1168577045,
 983463,
 -47702,
 1168642282,
 983462,
 -1,
 1168707549,
 983461,
 1168917942,
 1168117725,
 983271,
 -47699,
 1168840834,
 983460,
 -47698,
 1168906193,
 983459,
 -47697,
 1168971505,
 983458,
 -47696,
 1169036833,
 983457,
 -47695,
 1169102124,
 983456,
 -47694,
 1169167448,
 983455,
 -47693,
 1169232698,
 983454,
 -47692,
 1169297941,
 983453,
 -47691,
 1169363178,
 983452,
 -1,
 1169428445,
 983451,
 1169638846,
 1168839980,
 983276,
 -47688,
 1169561121,
 983507,
 -47687,
 1169626412,
 983506,
 -47686,
 1169691736,
 983505,
 -47685,
 1169756986,
 983504,
 -47684,
 1169822229,
 983503,
 -47683,
 1169887466,
 983502,
 -1,
 1169952733,
 983501,
 -47681,
 1169561730,
 983280,
 -47680,
 1170085841,
 983279,
 -47679,
 1170151153,
 983278,
 -1,
 1170216481,
 983277,
 1170425293,
 1165891714,
 983248,
 -47676,
 1170348162,
 983350,
 -47675,
 1170413521,
 983349,
 -47674,
 1170478833,
 983348,
 -47673,
 1170544161,
 983347,
 -47672,
 1170609452,
 983346,
 -47671,
 1170674776,
 983345,
 -47670,
 1170740026,
 983344,
 -47669,
 1170805269,
 983343,
 -47668,
 1170870506,
 983342,
 -1,
 1170935773,
 983341,
 1171146200,
 1170347985,
 983247,
 -47665,
 1171069058,
 983340,
 -47664,
 1171134417,
 983339,
 -47663,
 1171199729,
 983338,
 -47662,
 1171265057,
 983337,
 -47661,
 1171330348,
 983336,
 -47660,
 1171395672,
 983335,
 -47659,
 1171460922,
 983334,
 -47658,
 1171526165,
 983333,
 -47657,
 1171591402,
 983332,
 -1,
 1171656669,
 983331,
 1171867107,
 1171068657,
 983246,
 -47654,
 1171789954,
 983330,
 -47653,
 1171855313,
 983329,
 -47652,
 1171920625,
 983328,
 -47651,
 1171985953,
 983327,
 -47650,
 1172051244,
 983326,
 -47649,
 1172116568,
 983325,
 -47648,
 1172181818,
 983324,
 -47647,
 1172247061,
 983323,
 -47646,
 1172312298,
 983322,
 -1,
 1172377565,
 983321,
 1172588014,
 1171789345,
 983245,
 -47643,
 1172510850,
 983320,
 -47642,
 1172576209,
 983319,
 -47641,
 1172641521,
 983318,
 -47640,
 1172706849,
 983317,
 -47639,
 1172772140,
 983316,
 -47638,
 1172837464,
 983315,
 -47637,
 1172902714,
 983314,
 -47636,
 1172967957,
 983313,
 -47635,
 1173033194,
 983312,
 -1,
 1173098461,
 983311,
 1173308921,
 1172509996,
 983244,
 -47632,
 1173231746,
 983310,
 -47631,
 1173297105,
 983309,
 -47630,
 1173362417,
 983308,
 -47629,
 1173427745,
 983307,
 -47628,
 1173493036,
 983306,
 -47627,
 1173558360,
 983305,
 -47626,
 1173623610,
 983304,
 -47625,
 1173688853,
 983303,
 -47624,
 1173754090,
 983302,
 -1,
 1173819357,
 983301,
 1174029828,
 1173230680,
 983243,
 -47621,
 1173952642,
 983300,
 -47620,
 1174018001,
 983299,
 -47619,
 1174083313,
 983298,
 -47618,
 1174148641,
 983297,
 -47617,
 1174213932,
 983296,
 -47616,
 1174279256,
 983295,
 -47615,
 1174344506,
 983294,
 -47614,
 1174409749,
 983293,
 -47613,
 1174474986,
 983292,
 -1,
 1174540253,
 983291,
 1174798335,
 1173951290,
 983242,
 -47610,
 1174673538,
 983290,
 -47609,
 1174738897,
 983289,
 -47608,
 1174804209,
 983288,
 -47607,
 1174869537,
 983287,
 -47606,
 1174934828,
 983286,
 -47605,
 1175000152,
 983285,
 -47604,
 1175065402,
 983284,
 -47603,
 1175130645,
 983283,
 -47602,
 1175195882,
 983282,
 -1,
 1175261149,
 983281,
 1175471720,
 1158561987,
 -1,
 1175537225,
 1175403326,
 -1,
 1175602734,
 1175501513,
 -1,
 1175668251,
 1175525684,
 -1,
 1175733785,
 1175621652,
 -1,
 1175799318,
 1175705117,
 7403,
 -1,
 1175719432,
 7404,
 -47593,
 1175768854,
 7409,
 -47592,
 1175856958,
 7402,
 -1,
 1175920985,
 7401,
 -47590,
 1175701460,
 7415,
 -1,
 1176087358,
 7410,
 1176258081,
 1175640405,
 -1,
 1176323614,
 1176227895,
 7395,
 -1,
 1176243720,
 7399,
 1176454688,
 1176248709,
 7397,
 -1,
 1176374792,
 7400,
 -1,
 1176420835,
 7394,
 1176651303,
 1176217730,
 -1,
 1176716837,
 1176587157,
 -1,
 -47580,
 1176686647,
 7396,
 -1,
 1176707461,
 7398,
 -47578,
 1176683986,
 7408,
 -1,
 1176869361,
 7411,
 -47576,
 1176626071,
 7380,
 -47575,
 1177015113,
 7414,
 -47574,
 1177077985,
 7405,
 -47573,
 1177128126,
 7379,
 -47572,
 1177189898,
 7407,
 -47571,
 1177251840,
 7413,
 -1,
 1177312292,
 7406,
 1177550847,
 1175570772,
 -1,
 1177568820,
 1177478027,
 -1,
 1177634354,
 1177514418,
 7383,
 -1,
 1177553077,
 7385,
 -47565,
 1177577156,
 7382,
 -1,
 1177689259,
 7381,
 1177896504,
 1177535122,
 -1,
 -47562,
 1177870408,
 7390,
 -47561,
 1177924134,
 7387,
 -1,
 1177968670,
 7391,
 1178158653,
 1177828365,
 -1,
 1178224188,
 1178128211,
 -1,
 -47557,
 1178190307,
 7386,
 -1,
 1178251558,
 7417,
 -1,
 1178190506,
 7389,
 1178486336,
 1178119772,
 -1,
 -47553,
 1178438659,
 7416,
 -1,
 1178490863,
 7392,
 1178682947,
 1178431709,
 -1,
 -47550,
 1178650033,
 7388,
 -1,
 1178711150,
 7376,
 1178879558,
 1178611097,
 -1,
 -47547,
 1178806446,
 7384,
 -1,
 1178868336,
 7412,
 -47545,
 1178843447,
 7377,
 -47544,
 1179035008,
 7378,
 -1,
 1179067686,
 7393,
 1179272807,
 1175496834,
 -1,
 1179338330,
 1179247374,
 -1,
 1179403865,
 1179278150,
 -1,
 1179469392,
 1179366743,
 -1,
 -47538,
 1179423568,
 128636,
 -47537,
 1179479785,
 128953,
 -1,
 1179524962,
 128941,
 1179731539,
 1179442435,
 -1,
 -47534,
 1179696719,
 128914,
 -1,
 1179726071,
 128904,
 1179928150,
 1179665683,
 -1,
 -47531,
 1179893307,
 128959,
 -1,
 1179952097,
 128976,
 -47529,
 1179889082,
 128637,
 -47528,
 1180063618,
 128934,
 -1,
 1180127146,
 128947,
 -1,
 1179331351,
 128933,
 1180434431,
 1179305844,
 -1,
 1180452450,
 1180353170,
 -1,
 1180517984,
 1180375571,
 -1,
 1180583519,
 1180487924,
 983069,
 -1,
 1180502227,
 983143,
 -1,
 1180500948,
 11135,
 -47519,
 1180477750,
 128678,
 -1,
 1180722620,
 11823,
 -47517,
 1180416918,
 11837,
 -47516,
 1180860825,
 9896,
 -47515,
 1180925018,
 9168,
 -47514,
 1180979526,
 8286,
 -1,
 1181034406,
 10186,
 -1,
 1179238253,
 9910,
 1181304432,
 1175441634,
 -1,
 1181369967,
 1181242375,
 -1,
 1181435502,
 1181324467,
 -1,
 -47508,
 1181402384,
 8530,
 -47507,
 1181464663,
 8528,
 -1,
 1181519159,
 8529,
 -1,
 1181411003,
 8585,
 -1,
 1181298152,
 11238,
 1181828728,
 1181245825,
 -1,
 1181894262,
 1181760014,
 -1,
 1181959797,
 1181810688,
 -1,
 -47500,
 1181897659,
 127918,
 -1,
 1181953399,
 128249,
 -1,
 1181888086,
 128252,
 -47497,
 1181848407,
 127931,
 -1,
 1182149578,
 128243,
 1182353018,
 1181794962,
 983070,
 -1,
 1182315863,
 983144,
 1182531583,
 1182307044,
 -1,
 -47492,
 1182432002,
 127952,
 -1,
 1182477795,
 127755,
 1182681661,
 1118800168,
 -1,
 1182746668,
 1182649885,
 -1,
 1182812201,
 1182710324,
 -1,
 1182877736,
 1182740438,
 -1,
 1182943118,
 1182798357,
 -1,
 1183008403,
 1182875843,
 -1,
 -47484,
 1182944487,
 111343,
 -47483,
 1183006915,
 111342,
 -47482,
 1183070223,
 111341,
 -47481,
 1183132900,
 111340,
 -47480,
 1183196863,
 111339,
 -47479,
 1183258932,
 111338,
 -47478,
 1183324290,
 111337,
 -47477,
 1183389649,
 111336,
 -47476,
 1183454961,
 111335,
 -47475,
 1183520289,
 111334,
 -47474,
 1183585580,
 111333,
 -47473,
 1183650904,
 111332,
 -47472,
 1183716154,
 111331,
 -47471,
 1183781397,
 111330,
 -47470,
 1183846634,
 111329,
 -1,
 1183911901,
 111328,
 1184122532,
 1182939151,
 -1,
 -47467,
 1184058599,
 111327,
 -47466,
 1184121027,
 111326,
 -47465,
 1184184335,
 111325,
 -47464,
 1184247012,
 111324,
 -47463,
 1184310975,
 111323,
 -47462,
 1184373044,
 111322,
 -47461,
 1184438402,
 111321,
 -47460,
 1184503761,
 111320,
 -47459,
 1184569073,
 111319,
 -47458,
 1184634401,
 111318,
 -47457,
 1184699692,
 111317,
 -47456,
 1184765016,
 111316,
 -47455,
 1184830266,
 111315,
 -47454,
 1184895509,
 111314,
 -47453,
 1184960746,
 111313,
 -1,
 1185026013,
 111312,
 1185236661,
 1184050404,
 -1,
 -47450,
 1185172711,
 111311,
 -47449,
 1185235139,
 111310,
 -47448,
 1185298447,
 111309,
 -47447,
 1185361124,
 111308,
 -47446,
 1185425087,
 111307,
 -47445,
 1185487156,
 111306,
 -47444,
 1185552514,
 111305,
 -47443,
 1185617873,
 111304,
 -47442,
 1185683185,
 111303,
 -47441,
 1185748513,
 111302,
 -47440,
 1185813804,
 111301,
 -47439,
 1185879128,
 111300,
 -47438,
 1185944378,
 111299,
 -47437,
 1186009621,
 111298,
 -47436,
 1186074858,
 111297,
 -1,
 1186140125,
 111296,
 1186350790,
 1185162943,
 -1,
 -47433,
 1186286823,
 111295,
 -47432,
 1186349251,
 111294,
 -47431,
 1186412559,
 111293,
 -47430,
 1186475236,
 111292,
 -47429,
 1186539199,
 111291,
 -47428,
 1186601268,
 111290,
 -47427,
 1186666626,
 111289,
 -47426,
 1186731985,
 111288,
 -47425,
 1186797297,
 111287,
 -47424,
 1186862625,
 111286,
 -47423,
 1186927916,
 111285,
 -47422,
 1186993240,
 111284,
 -47421,
 1187058490,
 111283,
 -47420,
 1187123733,
 111282,
 -47419,
 1187188970,
 111281,
 -1,
 1187254237,
 111280,
 1187464919,
 1186273588,
 -1,
 -47416,
 1187400935,
 111279,
 -47415,
 1187463363,
 111278,
 -47414,
 1187526671,
 111277,
 -47413,
 1187589348,
 111276,
 -47412,
 1187653311,
 111275,
 -47411,
 1187715380,
 111274,
 -47410,
 1187780738,
 111273,
 -47409,
 1187846097,
 111272,
 -47408,
 1187911409,
 111271,
 -47407,
 1187976737,
 111270,
 -47406,
 1188042028,
 111269,
 -47405,
 1188107352,
 111268,
 -47404,
 1188172602,
 111267,
 -47403,
 1188237845,
 111266,
 -47402,
 1188303082,
 111265,
 -1,
 1188368349,
 111264,
 1188579048,
 1187387522,
 -1,
 -47399,
 1188515047,
 111263,
 -47398,
 1188577475,
 111262,
 -47397,
 1188640783,
 111261,
 -47396,
 1188703460,
 111260,
 -47395,
 1188767423,
 111259,
 -47394,
 1188829492,
 111258,
 -47393,
 1188894850,
 111257,
 -47392,
 1188960209,
 111256,
 -47391,
 1189025521,
 111255,
 -47390,
 1189090849,
 111254,
 -47389,
 1189156140,
 111253,
 -47388,
 1189221464,
 111252,
 -47387,
 1189286714,
 111251,
 -47386,
 1189351957,
 111250,
 -47385,
 1189417194,
 111249,
 -1,
 1189482461,
 111248,
 1189693177,
 1188501457,
 -1,
 -47382,
 1189629159,
 111247,
 -47381,
 1189691587,
 111246,
 -47380,
 1189754895,
 111245,
 -47379,
 1189817572,
 111244,
 -47378,
 1189881535,
 111243,
 -47377,
 1189943604,
 111242,
 -47376,
 1190008962,
 111241,
 -47375,
 1190074321,
 111240,
 -47374,
 1190139633,
 111239,
 -47373,
 1190204961,
 111238,
 -47372,
 1190270252,
 111237,
 -47371,
 1190335576,
 111236,
 -47370,
 1190400826,
 111235,
 -47369,
 1190466069,
 111234,
 -47368,
 1190531306,
 111233,
 -1,
 1190596573,
 111232,
 1190807306,
 1189615345,
 -1,
 -47365,
 1190743271,
 111231,
 -47364,
 1190805699,
 111230,
 -47363,
 1190869007,
 111229,
 -47362,
 1190931684,
 111228,
 -47361,
 1190995647,
 111227,
 -47360,
 1191057716,
 111226,
 -47359,
 1191123074,
 111225,
 -47358,
 1191188433,
 111224,
 -47357,
 1191253745,
 111223,
 -47356,
 1191319073,
 111222,
 -47355,
 1191384364,
 111221,
 -47354,
 1191449688,
 111220,
 -47353,
 1191514938,
 111219,
 -47352,
 1191580181,
 111218,
 -47351,
 1191645418,
 111217,
 -1,
 1191710685,
 111216,
 1191921435,
 1190729249,
 -1,
 -47348,
 1191857383,
 111215,
 -47347,
 1191919811,
 111214,
 -47346,
 1191983119,
 111213,
 -47345,
 1192045796,
 111212,
 -47344,
 1192109759,
 111211,
 -47343,
 1192171828,
 111210,
 -47342,
 1192237186,
 111209,
 -47341,
 1192302545,
 111208,
 -47340,
 1192367857,
 111207,
 -47339,
 1192433185,
 111206,
 -47338,
 1192498476,
 111205,
 -47337,
 1192563800,
 111204,
 -47336,
 1192629050,
 111203,
 -47335,
 1192694293,
 111202,
 -47334,
 1192759530,
 111201,
 -1,
 1192824797,
 111200,
 1193035564,
 1191843116,
 -1,
 -47331,
 1192971495,
 111199,
 -47330,
 1193033923,
 111198,
 -47329,
 1193097231,
 111197,
 -47328,
 1193159908,
 111196,
 -47327,
 1193223871,
 111195,
 -47326,
 1193285940,
 111194,
 -47325,
 1193351298,
 111193,
 -47324,
 1193416657,
 111192,
 -47323,
 1193481969,
 111191,
 -47322,
 1193547297,
 111190,
 -47321,
 1193612588,
 111189,
 -47320,
 1193677912,
 111188,
 -47319,
 1193743162,
 111187,
 -47318,
 1193808405,
 111186,
 -47317,
 1193873642,
 111185,
 -1,
 1193938909,
 111184,
 1194149693,
 1192957016,
 -1,
 -47314,
 1194085607,
 111183,
 -47313,
 1194148035,
 111182,
 -47312,
 1194211343,
 111181,
 -47311,
 1194274020,
 111180,
 -47310,
 1194337983,
 111179,
 -47309,
 1194400052,
 111178,
 -47308,
 1194465410,
 111177,
 -47307,
 1194530769,
 111176,
 -47306,
 1194596081,
 111175,
 -47305,
 1194661409,
 111174,
 -47304,
 1194726700,
 111173,
 -47303,
 1194792024,
 111172,
 -47302,
 1194857274,
 111171,
 -47301,
 1194922517,
 111170,
 -47300,
 1194987754,
 111169,
 -1,
 1195053021,
 111168,
 1195263822,
 1194070842,
 -1,
 -47297,
 1195199719,
 111167,
 -47296,
 1195262147,
 111166,
 -47295,
 1195325455,
 111165,
 -47294,
 1195388132,
 111164,
 -47293,
 1195452095,
 111163,
 -47292,
 1195514164,
 111162,
 -47291,
 1195579522,
 111161,
 -47290,
 1195644881,
 111160,
 -47289,
 1195710193,
 111159,
 -47288,
 1195775521,
 111158,
 -47287,
 1195840812,
 111157,
 -47286,
 1195906136,
 111156,
 -47285,
 1195971386,
 111155,
 -47284,
 1196036629,
 111154,
 -47283,
 1196101866,
 111153,
 -1,
 1196167133,
 111152,
 1196377951,
 1195184661,
 -1,
 -47280,
 1196313831,
 111151,
 -47279,
 1196376259,
 111150,
 -47278,
 1196439567,
 111149,
 -47277,
 1196502244,
 111148,
 -47276,
 1196566207,
 111147,
 -47275,
 1196628276,
 111146,
 -47274,
 1196693634,
 111145,
 -47273,
 1196758993,
 111144,
 -47272,
 1196824305,
 111143,
 -47271,
 1196889633,
 111142,
 -47270,
 1196954924,
 111141,
 -47269,
 1197020248,
 111140,
 -47268,
 1197085498,
 111139,
 -47267,
 1197150741,
 111138,
 -47266,
 1197215978,
 111137,
 -1,
 1197281245,
 111136,
 1197492080,
 1196298474,
 -1,
 -47263,
 1197427943,
 111135,
 -47262,
 1197490371,
 111134,
 -47261,
 1197553679,
 111133,
 -47260,
 1197616356,
 111132,
 -47259,
 1197680319,
 111131,
 -47258,
 1197742388,
 111130,
 -47257,
 1197807746,
 111129,
 -47256,
 1197873105,
 111128,
 -47255,
 1197938417,
 111127,
 -47254,
 1198003745,
 111126,
 -47253,
 1198069036,
 111125,
 -47252,
 1198134360,
 111124,
 -47251,
 1198199610,
 111123,
 -47250,
 1198264853,
 111122,
 -47249,
 1198330090,
 111121,
 -1,
 1198395357,
 111120,
 1198606209,
 1197412317,
 -1,
 -47246,
 1198542055,
 111119,
 -47245,
 1198604483,
 111118,
 -47244,
 1198667791,
 111117,
 -47243,
 1198730468,
 111116,
 -47242,
 1198794431,
 111115,
 -47241,
 1198856500,
 111114,
 -47240,
 1198921858,
 111113,
 -47239,
 1198987217,
 111112,
 -47238,
 1199052529,
 111111,
 -47237,
 1199117857,
 111110,
 -47236,
 1199183148,
 111109,
 -47235,
 1199248472,
 111108,
 -47234,
 1199313722,
 111107,
 -47233,
 1199378965,
 111106,
 -47232,
 1199444202,
 111105,
 -1,
 1199509469,
 111104,
 1199767551,
 1198542055,
 -1,
 -47229,
 1199646399,
 111355,
 -47228,
 1199708468,
 111354,
 -47227,
 1199773826,
 111353,
 -47226,
 1199839185,
 111352,
 -47225,
 1199904497,
 111351,
 -47224,
 1199969825,
 111350,
 -47223,
 1200035116,
 111349,
 -47222,
 1200100440,
 111348,
 -47221,
 1200165690,
 111347,
 -47220,
 1200230933,
 111346,
 -47219,
 1200296170,
 111345,
 -1,
 1200361437,
 111344,
 1200619519,
 1182863594,
 -1,
 1200637856,
 1200508135,
 -1,
 -47215,
 1200573671,
 111103,
 -47214,
 1200636099,
 111102,
 -47213,
 1200699407,
 111101,
 -47212,
 1200762084,
 111100,
 -47211,
 1200826047,
 111099,
 -47210,
 1200888116,
 111098,
 -47209,
 1200953474,
 111097,
 -47208,
 1201018833,
 111096,
 -47207,
 1201084145,
 111095,
 -47206,
 1201149473,
 111094,
 -47205,
 1201214764,
 111093,
 -47204,
 1201280088,
 111092,
 -47203,
 1201345338,
 111091,
 -47202,
 1201410581,
 111090,
 -47201,
 1201475818,
 111089,
 -1,
 1201541085,
 111088,
 1201751985,
 1200570563,
 -1,
 -47198,
 1201687783,
 111087,
 -47197,
 1201750211,
 111086,
 -47196,
 1201813519,
 111085,
 -47195,
 1201876196,
 111084,
 -47194,
 1201940159,
 111083,
 -47193,
 1202002228,
 111082,
 -47192,
 1202067586,
 111081,
 -47191,
 1202132945,
 111080,
 -47190,
 1202198257,
 111079,
 -47189,
 1202263585,
 111078,
 -47188,
 1202328876,
 111077,
 -47187,
 1202394200,
 111076,
 -47186,
 1202459450,
 111075,
 -47185,
 1202524693,
 111074,
 -47184,
 1202589930,
 111073,
 -1,
 1202655197,
 111072,
 1202866114,
 1201682447,
 -1,
 -47181,
 1202801895,
 111071,
 -47180,
 1202864323,
 111070,
 -47179,
 1202927631,
 111069,
 -47178,
 1202990308,
 111068,
 -47177,
 1203054271,
 111067,
 -47176,
 1203116340,
 111066,
 -47175,
 1203181698,
 111065,
 -47174,
 1203247057,
 111064,
 -47173,
 1203312369,
 111063,
 -47172,
 1203377697,
 111062,
 -47171,
 1203442988,
 111061,
 -47170,
 1203508312,
 111060,
 -47169,
 1203573562,
 111059,
 -47168,
 1203638805,
 111058,
 -47167,
 1203704042,
 111057,
 -1,
 1203769309,
 111056,
 1203980243,
 1202793700,
 -1,
 -47164,
 1203916007,
 111055,
 -47163,
 1203978435,
 111054,
 -47162,
 1204041743,
 111053,
 -47161,
 1204104420,
 111052,
 -47160,
 1204168383,
 111051,
 -47159,
 1204230452,
 111050,
 -47158,
 1204295810,
 111049,
 -47157,
 1204361169,
 111048,
 -47156,
 1204426481,
 111047,
 -47155,
 1204491809,
 111046,
 -47154,
 1204557100,
 111045,
 -47153,
 1204622424,
 111044,
 -47152,
 1204687674,
 111043,
 -47151,
 1204752917,
 111042,
 -47150,
 1204818154,
 111041,
 -1,
 1204883421,
 111040,
 1205094372,
 1203906239,
 -1,
 -47147,
 1205030119,
 111039,
 -47146,
 1205092547,
 111038,
 -47145,
 1205155855,
 111037,
 -47144,
 1205218532,
 111036,
 -47143,
 1205282495,
 111035,
 -47142,
 1205344564,
 111034,
 -47141,
 1205409922,
 111033,
 -47140,
 1205475281,
 111032,
 -47139,
 1205540593,
 111031,
 -47138,
 1205605921,
 111030,
 -47137,
 1205671212,
 111029,
 -47136,
 1205736536,
 111028,
 -47135,
 1205801786,
 111027,
 -47134,
 1205867029,
 111026,
 -47133,
 1205932266,
 111025,
 -1,
 1205997533,
 111024,
 1206208501,
 1205016884,
 -1,
 -47130,
 1206144231,
 111023,
 -47129,
 1206206659,
 111022,
 -47128,
 1206269967,
 111021,
 -47127,
 1206332644,
 111020,
 -47126,
 1206396607,
 111019,
 -47125,
 1206458676,
 111018,
 -47124,
 1206524034,
 111017,
 -47123,
 1206589393,
 111016,
 -47122,
 1206654705,
 111015,
 -47121,
 1206720033,
 111014,
 -47120,
 1206785324,
 111013,
 -47119,
 1206850648,
 111012,
 -47118,
 1206915898,
 111011,
 -47117,
 1206981141,
 111010,
 -47116,
 1207046378,
 111009,
 -1,
 1207111645,
 111008,
 1207322630,
 1206130818,
 -1,
 -47113,
 1207258343,
 111007,
 -47112,
 1207320771,
 111006,
 -47111,
 1207384079,
 111005,
 -47110,
 1207446756,
 111004,
 -47109,
 1207510719,
 111003,
 -47108,
 1207572788,
 111002,
 -47107,
 1207638146,
 111001,
 -47106,
 1207703505,
 111000,
 -47105,
 1207768817,
 110999,
 -47104,
 1207834145,
 110998,
 -47103,
 1207899436,
 110997,
 -47102,
 1207964760,
 110996,
 -47101,
 1208030010,
 110995,
 -47100,
 1208095253,
 110994,
 -47099,
 1208160490,
 110993,
 -1,
 1208225757,
 110992,
 1208436759,
 1207244753,
 -1,
 -47096,
 1208372455,
 110991,
 -47095,
 1208434883,
 110990,
 -47094,
 1208498191,
 110989,
 -47093,
 1208560868,
 110988,
 -47092,
 1208624831,
 110987,
 -47091,
 1208686900,
 110986,
 -47090,
 1208752258,
 110985,
 -47089,
 1208817617,
 110984,
 -47088,
 1208882929,
 110983,
 -47087,
 1208948257,
 110982,
 -47086,
 1209013548,
 110981,
 -47085,
 1209078872,
 110980,
 -47084,
 1209144122,
 110979,
 -47083,
 1209209365,
 110978,
 -47082,
 1209274602,
 110977,
 -1,
 1209339869,
 110976,
 1209597951,
 1208358641,
 -1,
 -47079,
 1209486567,
 110975,
 -47078,
 1209548995,
 110974,
 -47077,
 1209612303,
 110973,
 -47076,
 1209674980,
 110972,
 -47075,
 1209738943,
 110971,
 -47074,
 1209801012,
 110970,
 -47073,
 1209866370,
 110969,
 -47072,
 1209931729,
 110968,
 -47071,
 1209997041,
 110967,
 -47070,
 1210062369,
 110966,
 -47069,
 1210127660,
 110965,
 -47068,
 1210192984,
 110964,
 -47067,
 1210258234,
 110963,
 -47066,
 1210323477,
 110962,
 -47065,
 1210388714,
 110961,
 -1,
 1210453981,
 110960,
 -1,
 1182821837,
 94177,
 1210730539,
 1182757964,
 983041,
 -1,
 1210676300,
 983040,
 -1,
 1210696343,
 128297,
 1210927469,
 1182679235,
 -1,
 1210992930,
 1210899172,
 -1,
 1211058348,
 1210915126,
 -1,
 1211123831,
 1211005579,
 -1,
 1211189306,
 1211074856,
 -1,
 1211254836,
 1211163404,
 -1,
 -47053,
 1211193406,
 70681,
 -1,
 1211242804,
 70680,
 1211451447,
 1211192050,
 -1,
 -47050,
 1211390014,
 70675,
 -1,
 1211439412,
 70674,
 -47048,
 1211402610,
 70686,
 -47047,
 1211586622,
 70692,
 -1,
 1211636020,
 70691,
 1211844671,
 1211160970,
 -1,
 1211910205,
 1211803778,
 70662,
 -1,
 1211869314,
 70663,
 1212088319,
 1211855948,
 70664,
 -1,
 1211987020,
 70665,
 1212172357,
 1211810450,
 -1,
 1212237891,
 1212138130,
 -1,
 -47038,
 1212176446,
 70683,
 -1,
 1212225844,
 70682,
 -47036,
 1212176446,
 70688,
 -1,
 1212356916,
 70687,
 1212565579,
 1212102671,
 -1,
 1212631113,
 1212495887,
 -1,
 -47032,
 1212569662,
 70685,
 -1,
 1212619060,
 70684,
 -47030,
 1212569662,
 70690,
 -1,
 1212750132,
 70689,
 1212958799,
 1212487988,
 70656,
 -47027,
 1212927517,
 70669,
 -47026,
 1212965249,
 70667,
 -1,
 1213012276,
 70657,
 1213220947,
 1212921175,
 -1,
 -47023,
 1213183489,
 70706,
 -47022,
 1213225022,
 70705,
 -1,
 1213274420,
 70707,
 1213483093,
 1213189661,
 70660,
 -1,
 1213451805,
 70661,
 1213614168,
 1213442178,
 -1,
 -47017,
 1213552702,
 70701,
 -1,
 1213602100,
 70700,
 1213810779,
 1213570765,
 -1,
 -47014,
 1213749310,
 70694,
 -1,
 1213798708,
 70693,
 1214007390,
 1213759621,
 -1,
 -47011,
 1213945918,
 70698,
 -1,
 1213995316,
 70697,
 1214204001,
 1213953100,
 -1,
 -47008,
 1214142526,
 70703,
 -1,
 1214191924,
 70702,
 1214400612,
 1214148747,
 -1,
 -47005,
 1214339134,
 70671,
 -1,
 1214388532,
 70670,
 1214597223,
 1214345055,
 -1,
 -47002,
 1214535742,
 70679,
 -1,
 1214585140,
 70678,
 1214793833,
 1214538113,
 70658,
 -1,
 1214734721,
 70659,
 1214924908,
 1214730994,
 -1,
 -46997,
 1214863422,
 70673,
 -1,
 1214912820,
 70672,
 1215121519,
 1214852324,
 -1,
 -46994,
 1215060030,
 70677,
 -1,
 1215109428,
 70676,
 1215318130,
 1215047359,
 -1,
 -46991,
 1215256638,
 70696,
 -1,
 1215306036,
 70695,
 -46989,
 1215292276,
 70699,
 -46988,
 1215486756,
 70704,
 -46987,
 1215533201,
 70668,
 -46986,
 1215584318,
 70708,
 -1,
 1215643843,
 70666,
 1215842439,
 1211095664,
 -1,
 1215907965,
 1215814026,
 -1,
 1215973499,
 1215867010,
 70714,
 -1,
 1215932546,
 70715,
 1216151551,
 1215919180,
 70716,
 -1,
 1216050252,
 70717,
 1216235649,
 1215830324,
 -1,
 -46977,
 1216204317,
 70721,
 -46976,
 1216242049,
 70719,
 -1,
 1216289076,
 70709,
 1216497795,
 1216204317,
 70712,
 -1,
 1216466461,
 70713,
 1216628869,
 1216438657,
 70710,
 -1,
 1216569729,
 70711,
 -46970,
 1216581777,
 70720,
 -1,
 1216692419,
 70718,
 1216891032,
 1215772687,
 -1,
 1216956566,
 1216832801,
 -1,
 1217022092,
 1216922258,
 -1,
 -46965,
 1216995344,
 70738,
 -1,
 1217028049,
 70739,
 1217218703,
 1216984407,
 -1,
 -46962,
 1217162962,
 70742,
 -1,
 1217219307,
 70743,
 1217415314,
 1217154279,
 -1,
 -46959,
 1217370907,
 70740,
 -1,
 1217424928,
 70741,
 -46957,
 1217390218,
 70736,
 -46956,
 1217565871,
 70737,
 -46955,
 1217629400,
 70745,
 -1,
 1217676557,
 70744,
 -46953,
 1216912036,
 70732,
 -1,
 1217798280,
 70731,
 1218005158,
 1216853335,
 -1,
 1218070693,
 1217945985,
 -1,
 1218136228,
 1218008754,
 -1,
 1218201758,
 1218107626,
 -1,
 -46947,
 1218164433,
 70725,
 -1,
 1218226692,
 70722,
 1218398369,
 1218124084,
 -1,
 -46944,
 1218369041,
 70727,
 -1,
 1218416652,
 70724,
 -46942,
 1218351037,
 70726,
 -46941,
 1218530955,
 70728,
 -1,
 1218588088,
 70723,
 -1,
 1218066789,
 70730,
 -1,
 1217994909,
 70750,
 -46937,
 1217962701,
 70747,
 -46936,
 1218876307,
 70729,
 -46935,
 1218931167,
 70749,
 -46934,
 1218991084,
 70734,
 -46933,
 1219048377,
 70733,
 -1,
 1219107417,
 70735,
 1219315998,
 1210974208,
 -1,
 1219381530,
 1219281810,
 -1,
 1219447025,
 1219328651,
 -1,
 1219512524,
 1219395272,
 -1,
 1219578036,
 1219478162,
 -1,
 -46926,
 1219540481,
 6539,
 -46925,
 1219582014,
 6546,
 -1,
 1219631412,
 6545,
 1219840183,
 1219551745,
 -1,
 -46922,
 1219810830,
 6569,
 -1,
 1219828020,
 6534,
 1220036794,
 1219802455,
 -1,
 -46919,
 1220005558,
 6571,
 -1,
 1220024628,
 6540,
 1220233405,
 1219993293,
 -1,
 -46916,
 1220171838,
 6552,
 -1,
 1220221236,
 6551,
 1220430016,
 1220184360,
 -1,
 -46913,
 1220367169,
 6535,
 -1,
 1220417844,
 6547,
 1220626627,
 1220374667,
 -1,
 -46910,
 1220597262,
 6568,
 -1,
 1220614452,
 6533,
 -46908,
 1220600692,
 6541,
 -46907,
 1220793870,
 6558,
 -46906,
 1220847345,
 6529,
 -46905,
 1220903131,
 6553,
 -46904,
 1220965526,
 6559,
 -46903,
 1221023806,
 6563,
 -46902,
 1221086524,
 6557,
 -46901,
 1221146782,
 6564,
 -1,
 1221207796,
 6565,
 1221413097,
 1219452093,
 -1,
 1221478609,
 1221378706,
 -1,
 -46897,
 1221441025,
 6536,
 -46896,
 1221482558,
 6543,
 -1,
 1221531956,
 6542,
 1221740756,
 1221452289,
 -1,
 -46893,
 1221711374,
 6567,
 -1,
 1221728564,
 6531,
 1221937367,
 1221702999,
 -1,
 -46890,
 1221906102,
 6570,
 -1,
 1221925172,
 6537,
 1222133978,
 1221893837,
 -1,
 -46887,
 1222072382,
 6549,
 -1,
 1222121780,
 6548,
 1222330589,
 1222084904,
 -1,
 -46884,
 1222267713,
 6532,
 -1,
 1222318388,
 6544,
 1222527200,
 1222275211,
 -1,
 -46881,
 1222497806,
 6566,
 -1,
 1222514996,
 6530,
 -46879,
 1222501236,
 6538,
 -46878,
 1222694414,
 6555,
 -46877,
 1222747889,
 6528,
 -46876,
 1222803675,
 6550,
 -46875,
 1222866070,
 6556,
 -46874,
 1222924350,
 6560,
 -46873,
 1222987068,
 6554,
 -46872,
 1223047326,
 6561,
 -1,
 1223108340,
 6562,
 1223360511,
 1221348996,
 -1,
 1223379180,
 1223264552,
 6595,
 -1,
 1223316210,
 6594,
 -46867,
 1223349752,
 6593,
 -46866,
 1223458949,
 6596,
 -46865,
 1223520395,
 6597,
 -46864,
 1223571471,
 6598,
 -1,
 1223632575,
 6599,
 1223837957,
 1219418736,
 -1,
 1223903479,
 1223806493,
 6579,
 1223969013,
 1223835843,
 6585,
 -1,
 1223942924,
 6591,
 -46858,
 1223942924,
 6588,
 -1,
 1224068637,
 6580,
 1224231163,
 1223856273,
 6583,
 1224296698,
 1224153396,
 6584,
 -1,
 1224270604,
 6590,
 -1,
 1224270604,
 6589,
 1224493312,
 1224153396,
 -1,
 1224558846,
 1224415540,
 6577,
 -1,
 1224532748,
 6587,
 -46849,
 1224532748,
 6586,
 -1,
 1224622275,
 6582,
 1224820995,
 1224434049,
 -1,
 -46846,
 1224794892,
 6592,
 -1,
 1224827265,
 6578,
 -46844,
 1224792672,
 6576,
 -1,
 1224949955,
 6581,
 1225148691,
 1223768926,
 -1,
 1225214217,
 1225114258,
 -1,
 -46840,
 1225187344,
 6610,
 -1,
 1225220049,
 6611,
 1225410828,
 1225176407,
 -1,
 -46837,
 1225354962,
 6614,
 -1,
 1225411307,
 6615,
 1225607439,
 1225346279,
 -1,
 -46834,
 1225562907,
 6612,
 -1,
 1225616928,
 6613,
 -46832,
 1225582218,
 6608,
 -46831,
 1225757871,
 6609,
 -46830,
 1225821400,
 6617,
 -1,
 1225868557,
 6616,
 1226066200,
 1225114258,
 -1,
 1226131735,
 1226020134,
 -1,
 -46826,
 1226052117,
 6601,
 -1,
 1226117354,
 6600,
 -1,
 1226070346,
 6618,
 1226440703,
 1226029789,
 6622,
 -1,
 1226364408,
 6623,
 1226524957,
 1219331995,
 -1,
 -46820,
 1226497654,
 127770,
 -1,
 1226555983,
 127761,
 -1,
 1226472527,
 983063,
 1226787105,
 1219263572,
 -1,
 -46816,
 1226747654,
 11155,
 -1,
 1226799144,
 11154,
 -1,
 1226751455,
 128240,
 1227049317,
 1210930212,
 -1,
 1227114821,
 1227013741,
 -1,
 1227180351,
 1227060855,
 -1,
 -46810,
 1227154877,
 127369,
 -46809,
 1227219724,
 127368,
 -46808,
 1227284993,
 127367,
 -46807,
 1227348708,
 127366,
 -46806,
 1227412984,
 127365,
 -46805,
 1227476509,
 127364,
 -46804,
 1227539090,
 127363,
 -46803,
 1227601239,
 127362,
 -46802,
 1227663490,
 127361,
 -46801,
 1227728594,
 127360,
 -46800,
 1227792077,
 127359,
 -46799,
 1227853969,
 127358,
 -46798,
 1227917608,
 127357,
 -46797,
 1227980933,
 127356,
 -46796,
 1228043340,
 127355,
 -46795,
 1228107915,
 127354,
 -46794,
 1228173151,
 127353,
 -46793,
 1228235137,
 127352,
 -46792,
 1228298280,
 127351,
 -46791,
 1228362482,
 127350,
 -46790,
 1228426471,
 127349,
 -46789,
 1228488899,
 127348,
 -46788,
 1228552207,
 127347,
 -46787,
 1228614884,
 127346,
 -46786,
 1228678847,
 127345,
 -1,
 1228740916,
 127344,
 -46784,
 1227152451,
 127375,
 -46783,
 1228912129,
 127373,
 -46782,
 1228971817,
 127372,
 -46781,
 1229021865,
 127371,
 -46780,
 1229075979,
 10062,
 -1,
 1229134355,
 127374,
 1229343076,
 1227043156,
 -1,
 1229408609,
 1229289079,
 -1,
 -46776,
 1229383101,
 127337,
 -46775,
 1229447948,
 127336,
 -46774,
 1229513217,
 127335,
 -46773,
 1229576932,
 127334,
 -46772,
 1229641208,
 127333,
 -46771,
 1229704733,
 127332,
 -46770,
 1229767314,
 127331,
 -46769,
 1229829463,
 127330,
 -46768,
 1229891714,
 127329,
 -46767,
 1229956818,
 127328,
 -46766,
 1230020301,
 127327,
 -46765,
 1230082193,
 127326,
 -46764,
 1230145832,
 127325,
 -46763,
 1230209157,
 127324,
 -46762,
 1230271564,
 127323,
 -46761,
 1230336139,
 127322,
 -46760,
 1230401375,
 127321,
 -46759,
 1230463361,
 127320,
 -46758,
 1230526504,
 127319,
 -46757,
 1230590706,
 127318,
 -46756,
 1230654695,
 127317,
 -46755,
 1230717123,
 127316,
 -46754,
 1230780431,
 127315,
 -46753,
 1230843108,
 127314,
 -46752,
 1230907071,
 127313,
 -1,
 1230969140,
 127312,
 -46750,
 1229376175,
 128982,
 -46749,
 1231142479,
 128984,
 -1,
 1231174501,
 9471,
 -1,
 1229265694,
 983091,
 1231440232,
 1227019660,
 -1,
 -46745,
 1231399401,
 128528,
 -1,
 1231439998,
 9906,
 -46743,
 1231413960,
 983130,
 -46742,
 1231601458,
 11228,
 -46741,
 1231661825,
 129299,
 -46740,
 1231713356,
 983131,
 -1,
 1231762062,
 128084,
 1231964603,
 1210872683,
 -1,
 1232030102,
 1231909964,
 -1,
 1232095636,
 1231964705,
 -1,
 1232161141,
 1232046376,
 2002,
 1232226675,
 1232135028,
 2018,
 -1,
 1232145990,
 2023,
 1232404479,
 1232148788,
 2019,
 -1,
 1232277062,
 2016,
 1232488827,
 1232105311,
 -1,
 1232554362,
 1232442519,
 -1,
 -46728,
 1232513269,
 2026,
 -46727,
 1232564093,
 2024,
 -1,
 1232613284,
 2025,
 -1,
 1232476468,
 2006,
 1232882046,
 1232447618,
 -1,
 -46723,
 1232840949,
 2010,
 -1,
 1232869684,
 2009,
 1233078656,
 1232834705,
 2000,
 -1,
 1233031313,
 1999,
 1233209730,
 1233010883,
 1997,
 -1,
 1233141955,
 1995,
 1233340804,
 1233139870,
 2008,
 -1,
 1233278060,
 2001,
 -46715,
 1233314676,
 2022,
 -46714,
 1233443620,
 2021,
 -46713,
 1233505821,
 1998,
 -46712,
 1233568536,
 2005,
 -46711,
 1233630721,
 2011,
 -46710,
 1233690409,
 2004,
 -46709,
 1233748187,
 2017,
 -46708,
 1233810582,
 2015,
 -46707,
 1233875165,
 2014,
 -46706,
 1233936769,
 1996,
 -46705,
 1233999934,
 2020,
 -46704,
 1234064464,
 2012,
 -46703,
 1234128188,
 2013,
 -46702,
 1234186148,
 2007,
 -46701,
 1234249460,
 2003,
 -1,
 1234311476,
 1994,
 -46699,
 1232051744,
 2037,
 -1,
 1234443751,
 2042,
 1234651559,
 1231960079,
 -1,
 1234717093,
 1234593057,
 -1,
 1234782619,
 1234682514,
 -1,
 -46694,
 1234755600,
 1986,
 -1,
 1234788305,
 1987,
 1234979230,
 1234744663,
 -1,
 -46691,
 1234923218,
 1990,
 -1,
 1234979563,
 1991,
 1235175841,
 1234914535,
 -1,
 -46688,
 1235131163,
 1988,
 -1,
 1235185184,
 1989,
 -46686,
 1235150474,
 1984,
 -46685,
 1235326127,
 1985,
 -46684,
 1235389656,
 1993,
 -1,
 1235436813,
 1992,
 -46682,
 1234671926,
 2046,
 -1,
 1235558758,
 2045,
 1235765685,
 1234580347,
 -1,
 1235831220,
 1235691986,
 -1,
 1235896750,
 1235779076,
 -1,
 -46677,
 1235858020,
 2033,
 -46676,
 1235910450,
 2032,
 -46675,
 1235967221,
 2031,
 -1,
 1236023918,
 2030,
 1236224434,
 1235859955,
 -1,
 -46672,
 1236185700,
 2029,
 -46671,
 1236238130,
 2028,
 -1,
 1236294901,
 2027,
 -46669,
 1236175335,
 2034,
 -1,
 1236418045,
 2035,
 -1,
 1235779803,
 2040,
 1236683192,
 1235731030,
 -1,
 -46665,
 1236637306,
 2038,
 -1,
 1236685908,
 2039,
 -46663,
 1236648939,
 2047,
 -46662,
 1236819199,
 2036,
 -1,
 1236880336,
 2041,
 1237076477,
 1231917201,
 -1,
 1237141988,
 1237035138,
 -1,
 1237207523,
 1237108121,
 -1,
 1237273058,
 1237123072,
 -1,
 1237338574,
 1237215117,
 -1,
 1237404105,
 1237275116,
 -1,
 1237469638,
 1237357747,
 -1,
 -46653,
 1237433261,
 43059,
 -46652,
 1237493674,
 43056,
 -46651,
 1237539034,
 43057,
 -1,
 1237599566,
 43060,
 1237843967,
 1237436041,
 -1,
 -46648,
 1237760951,
 43061,
 -1,
 1237821417,
 43058,
 1237993932,
 1237362507,
 -1,
 -46645,
 1237955723,
 43062,
 -1,
 1238011788,
 43065,
 -46643,
 1237955864,
 43064,
 -1,
 1238147789,
 43063,
 1238321624,
 1237310631,
 -1,
 1238387155,
 1238279156,
 -1,
 -46639,
 1238358332,
 128600,
 -46638,
 1238398927,
 128592,
 -1,
 1238445139,
 128608,
 1238649301,
 1238354686,
 11110,
 -1,
 1238567636,
 11126,
 -46634,
 1238621450,
 11009,
 -46633,
 1238742703,
 129108,
 -1,
 1238772266,
 11017,
 1239023615,
 1238254145,
 -1,
 1239042525,
 1238934516,
 -1,
 -46629,
 1239013692,
 128602,
 -46628,
 1239054287,
 128594,
 -1,
 1239100499,
 128610,
 1239304671,
 1239010046,
 11111,
 -1,
 1239222996,
 11127,
 -46624,
 1239276810,
 11008,
 -46623,
 1239398063,
 129109,
 -1,
 1239427626,
 11016,
 -1,
 1237205609,
 128746,
 -1,
 1237138243,
 8379,
 1239763440,
 1237057536,
 -1,
 1239828968,
 1239719629,
 -1,
 -46617,
 1239772099,
 128370,
 -1,
 1239827332,
 128695,
 1240025578,
 1239762867,
 9940,
 -1,
 1239943403,
 128683,
 1240156653,
 1239951039,
 -1,
 -46612,
 1240116053,
 983126,
 -1,
 1240163091,
 128691,
 -46610,
 1240120651,
 128685,
 -46609,
 1240307017,
 128286,
 -1,
 1240368883,
 128245,
 1240549882,
 1239728786,
 -1,
 1240615415,
 1240481987,
 128456,
 1240680948,
 1240542010,
 128211,
 -1,
 1240599467,
 128212,
 1240858623,
 1240598231,
 -1,
 -46602,
 1240749202,
 128457,
 -1,
 1240807439,
 128458,
 1241055231,
 1240543249,
 -1,
 -46599,
 1240969138,
 128324,
 -1,
 1241020584,
 128323,
 -46597,
 1240512313,
 128067,
 -46596,
 1241155923,
 128689,
 -1,
 1241220768,
 65934,
 1241401911,
 1236998452,
 -1,
 1241467441,
 1241327669,
 -1,
 1241532964,
 1241414283,
 -1,
 1241598474,
 1241468548,
 -1,
 -46590,
 1241572668,
 67724,
 -46589,
 1241627061,
 67740,
 -46588,
 1241681923,
 67732,
 -46587,
 1241744509,
 67730,
 -46586,
 1241806227,
 67728,
 -46585,
 1241870672,
 67726,
 -46584,
 1241930421,
 67718,
 -46583,
 1241983239,
 67714,
 -1,
 1242046086,
 67712,
 1242253839,
 1241560407,
 -1,
 1242319374,
 1242175796,
 -1,
 -46579,
 1242268772,
 67734,
 -1,
 1242315450,
 67737,
 -1,
 1242258757,
 67741,
 1242581522,
 1242219154,
 -1,
 -46575,
 1242515964,
 67723,
 -1,
 1242572393,
 67742,
 1242778132,
 1242520245,
 67719,
 -1,
 1242744217,
 67722,
 1242909207,
 1242700084,
 -1,
 -46570,
 1242883216,
 67735,
 -1,
 1242921560,
 67713,
 -46568,
 1242883677,
 67721,
 -46567,
 1243079996,
 67725,
 -46566,
 1243143178,
 67720,
 -46565,
 1243196739,
 67739,
 -46564,
 1243260739,
 67738,
 -46563,
 1243324628,
 67736,
 -46562,
 1243385859,
 67733,
 -46561,
 1243448445,
 67731,
 -46560,
 1243510163,
 67729,
 -46559,
 1243574608,
 67727,
 -46558,
 1243633220,
 67716,
 -46557,
 1243691248,
 67717,
 -1,
 1243752711,
 67715,
 1243957808,
 1241485255,
 -1,
 1244023339,
 1243923090,
 -1,
 1244088873,
 1243994852,
 -1,
 -46552,
 1244041361,
 67752,
 -1,
 1244088249,
 67758,
 -46550,
 1244028881,
 67753,
 -1,
 1244218954,
 67757,
 1244416557,
 1243976879,
 67751,
 -1,
 1244332888,
 67759,
 1244594175,
 1244351719,
 -1,
 -46545,
 1244502811,
 67754,
 -1,
 1244556832,
 67756,
 -1,
 1243887349,
 67755,
 -46542,
 1241441864,
 129535,
 -46541,
 1244779808,
 129314,
 -46540,
 1244842153,
 127966,
 -46539,
 1244890016,
 128219,
 -46538,
 1244950667,
 983092,
 -1,
 1245013419,
 128133,
 1245203002,
 1241327295,
 -1,
 -46535,
 1245167061,
 983196,
 -1,
 1245206568,
 983127,
 -46533,
 1245153815,
 983227,
 -46532,
 1245344844,
 983066,
 -1,
 1245406409,
 127747,
 1245597138,
 1182619688,
 -1,
 1245662305,
 1245528259,
 -1,
 1245727639,
 1245613873,
 -1,
 1245792875,
 1245671563,
 -1,
 1245858382,
 1245714886,
 -1,
 1245923909,
 1245778154,
 110615,
 -46524,
 1245843690,
 110625,
 -1,
 1245908957,
 110624,
 -46522,
 1245868537,
 110626,
 -46521,
 1246042242,
 110623,
 -46520,
 1246107601,
 110622,
 -46519,
 1246172913,
 110621,
 -46518,
 1246238241,
 110620,
 -46517,
 1246303532,
 110619,
 -46516,
 1246368856,
 110618,
 -46515,
 1246434106,
 110617,
 -1,
 1246499349,
 110616,
 1246710359,
 1245798899,
 -1,
 -46512,
 1246631889,
 110634,
 -46511,
 1246697201,
 110633,
 -46510,
 1246762529,
 110632,
 -46509,
 1246827820,
 110631,
 -46508,
 1246893144,
 110630,
 -46507,
 1246958394,
 110629,
 -46506,
 1247023637,
 110628,
 -1,
 1247088874,
 110627,
 1247300191,
 1246678660,
 -1,
 -46503,
 1247221489,
 110641,
 -46502,
 1247286817,
 110640,
 -46501,
 1247352108,
 110639,
 -46500,
 1247417432,
 110638,
 -46499,
 1247482682,
 110637,
 -46498,
 1247547925,
 110636,
 -1,
 1247613162,
 110635,
 1247824486,
 1247232470,
 -1,
 -46495,
 1247745569,
 110647,
 -46494,
 1247810860,
 110646,
 -46493,
 1247876184,
 110645,
 -46492,
 1247941434,
 110644,
 -46491,
 1248006677,
 110643,
 -1,
 1248071914,
 110642,
 1248329727,
 1247776977,
 -1,
 -46488,
 1248228042,
 110651,
 -46487,
 1248269114,
 110650,
 -46486,
 1248334357,
 110649,
 -1,
 1248399594,
 110648,
 1248610965,
 1245730856,
 -1,
 1248676472,
 1248532934,
 -1,
 1248742000,
 1248596202,
 110750,
 -46481,
 1248661738,
 110760,
 -1,
 1248727005,
 110759,
 -46479,
 1248663682,
 110758,
 -46478,
 1248860113,
 110757,
 -46477,
 1248925425,
 110756,
 -46476,
 1248990753,
 110755,
 -46475,
 1249056044,
 110754,
 -46474,
 1249121368,
 110753,
 -46473,
 1249186618,
 110752,
 -1,
 1249251861,
 110751,
 1249462913,
 1248628945,
 -1,
 -46470,
 1249384401,
 110785,
 -46469,
 1249449713,
 110784,
 -46468,
 1249515041,
 110783,
 -46467,
 1249580332,
 110782,
 -46466,
 1249645656,
 110781,
 -46465,
 1249710906,
 110780,
 -46464,
 1249776149,
 110779,
 -1,
 1249841386,
 110778,
 1250052745,
 1249403379,
 -1,
 -46461,
 1249974001,
 110767,
 -46460,
 1250039329,
 110766,
 -46459,
 1250104620,
 110765,
 -46458,
 1250169944,
 110764,
 -46457,
 1250235194,
 110763,
 -46456,
 1250300437,
 110762,
 -1,
 1250365674,
 110761,
 1250577041,
 1249984982,
 -1,
 -46453,
 1250498289,
 110777,
 -46452,
 1250563617,
 110776,
 -46451,
 1250628908,
 110775,
 -46450,
 1250694232,
 110774,
 -46449,
 1250759482,
 110773,
 -46448,
 1250824725,
 110772,
 -1,
 1250889962,
 110771,
 1251147775,
 1250545284,
 -1,
 -46445,
 1251021626,
 110770,
 -46444,
 1251086869,
 110769,
 -1,
 1251152106,
 110768,
 1251363517,
 1248572759,
 -1,
 1251429023,
 1251331716,
 -1,
 -46440,
 1251350481,
 110673,
 -46439,
 1251415793,
 110672,
 -46438,
 1251481121,
 110671,
 -46437,
 1251546412,
 110670,
 -46436,
 1251611736,
 110669,
 -46435,
 1251676986,
 110668,
 -46434,
 1251742229,
 110667,
 -1,
 1251807466,
 110666,
 1252018856,
 1251350982,
 -1,
 -46431,
 1251940305,
 110659,
 -46430,
 1252005617,
 110658,
 -46429,
 1252070945,
 110657,
 -46428,
 1252136236,
 110656,
 -46427,
 1252201560,
 110655,
 -46426,
 1252266810,
 110654,
 -46425,
 1252332053,
 110653,
 -1,
 1252397290,
 110652,
 1252608688,
 1251971281,
 -1,
 -46422,
 1252529905,
 110685,
 -46421,
 1252595233,
 110684,
 -46420,
 1252660524,
 110683,
 -46419,
 1252725848,
 110682,
 -46418,
 1252791098,
 110681,
 -46417,
 1252856341,
 110680,
 -1,
 1252921578,
 110679,
 1253132983,
 1252549107,
 -1,
 -46414,
 1253053985,
 110665,
 -46413,
 1253119276,
 110664,
 -46412,
 1253184600,
 110663,
 -46411,
 1253249850,
 110662,
 -46410,
 1253315093,
 110661,
 -1,
 1253380330,
 110660,
 1253638143,
 1253065174,
 -1,
 -46407,
 1253512492,
 110678,
 -46406,
 1253577816,
 110677,
 -46405,
 1253643066,
 110676,
 -46404,
 1253708309,
 110675,
 -1,
 1253773546,
 110674,
 1253984998,
 1251313960,
 -1,
 1254050504,
 1253906886,
 -1,
 -46400,
 1253972098,
 110726,
 -46399,
 1254037457,
 110725,
 -46398,
 1254102769,
 110724,
 -46397,
 1254168097,
 110723,
 -46396,
 1254233388,
 110722,
 -46395,
 1254298712,
 110721,
 -46394,
 1254363962,
 110720,
 -46393,
 1254429205,
 110719,
 -1,
 1254494442,
 110718,
 1254705873,
 1253990899,
 -1,
 -46390,
 1254671437,
 110734,
 -46389,
 1254692593,
 110733,
 -46388,
 1254757921,
 110732,
 -46387,
 1254823212,
 110731,
 -46386,
 1254888536,
 110730,
 -46385,
 1254953786,
 110729,
 -46384,
 1255019029,
 110728,
 -1,
 1255084266,
 110727,
 1255295705,
 1254638038,
 -1,
 -46381,
 1255240552,
 110744,
 -46380,
 1255282209,
 110743,
 -46379,
 1255347500,
 110742,
 -46378,
 1255412824,
 110741,
 -46377,
 1255478074,
 110740,
 -46376,
 1255543317,
 110739,
 -1,
 1255608554,
 110738,
 1255819999,
 1255248081,
 -1,
 -46373,
 1255740716,
 110749,
 -46372,
 1255806040,
 110748,
 -46371,
 1255871290,
 110747,
 -46370,
 1255936533,
 110746,
 -1,
 1256001770,
 110745,
 1256213219,
 1255788164,
 -1,
 -46367,
 1256133434,
 110737,
 -46366,
 1256198677,
 110736,
 -1,
 1256263914,
 110735,
 1256521727,
 1256132390,
 -1,
 -46363,
 1256395285,
 110878,
 -1,
 1256460522,
 110877,
 1256672012,
 1253950098,
 -1,
 1256737521,
 1256604118,
 -1,
 -46359,
 1256659074,
 110710,
 -46358,
 1256724433,
 110709,
 -46357,
 1256789745,
 110708,
 -46356,
 1256855073,
 110707,
 -46355,
 1256920364,
 110706,
 -46354,
 1256985688,
 110705,
 -46353,
 1257050938,
 110704,
 -46352,
 1257116181,
 110703,
 -1,
 1257181418,
 110702,
 1257392889,
 1256689873,
 -1,
 -46349,
 1257351413,
 110717,
 -46348,
 1257379361,
 110716,
 -46347,
 1257444652,
 110715,
 -46346,
 1257509976,
 110714,
 -46345,
 1257575226,
 110713,
 -46344,
 1257640469,
 110712,
 -1,
 1257705706,
 110711,
 1257917185,
 1257333235,
 -1,
 -46341,
 1257838321,
 110696,
 -46340,
 1257903649,
 110695,
 -46339,
 1257968940,
 110694,
 -46338,
 1258034264,
 110693,
 -46337,
 1258099514,
 110692,
 -46336,
 1258164757,
 110691,
 -1,
 1258229994,
 110690,
 1258441479,
 1257885316,
 -1,
 -46333,
 1258408203,
 110701,
 -46332,
 1258427480,
 110700,
 -46331,
 1258492730,
 110699,
 -46330,
 1258557973,
 110698,
 -1,
 1258623210,
 110697,
 1258881023,
 1258363334,
 -1,
 -46327,
 1258755160,
 110689,
 -46326,
 1258820410,
 110688,
 -46325,
 1258885653,
 110687,
 -1,
 1258950890,
 110686,
 1259162413,
 1256630402,
 -1,
 1259227925,
 1259102707,
 -1,
 -46321,
 1259149041,
 110839,
 -46320,
 1259214369,
 110838,
 -46319,
 1259279660,
 110837,
 -46318,
 1259344984,
 110836,
 -46317,
 1259410234,
 110835,
 -46316,
 1259475477,
 110834,
 -1,
 1259540714,
 110833,
 1259752220,
 1259196036,
 -1,
 -46313,
 1259673121,
 110845,
 -46312,
 1259738412,
 110844,
 -46311,
 1259803736,
 110843,
 -46310,
 1259868986,
 110842,
 -46309,
 1259934229,
 110841,
 -1,
 1259999466,
 110840,
 1260210979,
 1259704529,
 -1,
 -46306,
 1260131873,
 110855,
 -46305,
 1260197164,
 110854,
 -46304,
 1260262488,
 110853,
 -46303,
 1260327738,
 110852,
 -46302,
 1260392981,
 110851,
 -1,
 1260458218,
 110850,
 1260669736,
 1260143062,
 -1,
 -46299,
 1260590168,
 110849,
 -46298,
 1260655418,
 110848,
 -46297,
 1260720661,
 110847,
 -1,
 1260785898,
 110846,
 1261043711,
 1260591558,
 -1,
 -46294,
 1260917848,
 110832,
 -46293,
 1260983098,
 110831,
 -46292,
 1261048341,
 110830,
 -1,
 1261113578,
 110829,
 1261325134,
 1259110533,
 -1,
 1261390646,
 1261265395,
 -1,
 -46288,
 1261311729,
 110799,
 -46287,
 1261377057,
 110798,
 -46286,
 1261442348,
 110797,
 -46285,
 1261507672,
 110796,
 -46284,
 1261572922,
 110795,
 -46283,
 1261638165,
 110794,
 -1,
 1261703402,
 110793,
 1261914942,
 1261312454,
 -1,
 -46280,
 1261836017,
 110792,
 -46279,
 1261901345,
 110791,
 -46278,
 1261966636,
 110790,
 -46277,
 1262031960,
 110789,
 -46276,
 1262097210,
 110788,
 -46275,
 1262162453,
 110787,
 -1,
 1262227690,
 110786,
 1262439237,
 1261867217,
 -1,
 -46272,
 1262360097,
 110812,
 -46271,
 1262425388,
 110811,
 -46270,
 1262490712,
 110810,
 -46269,
 1262555962,
 110809,
 -46268,
 1262621205,
 110808,
 -1,
 1262686442,
 110807,
 1262897994,
 1262407300,
 -1,
 -46265,
 1262818392,
 110803,
 -46264,
 1262883642,
 110802,
 -46263,
 1262948885,
 110801,
 -1,
 1263014122,
 110800,
 1263271935,
 1262830038,
 -1,
 -46260,
 1263173851,
 110806,
 -46259,
 1263211029,
 110805,
 -1,
 1263276266,
 110804,
 1263487848,
 1261296356,
 -1,
 1263553367,
 1263440081,
 -1,
 -46255,
 1263474417,
 110876,
 -46254,
 1263539745,
 110875,
 -46253,
 1263605036,
 110874,
 -46252,
 1263670360,
 110873,
 -46251,
 1263735610,
 110872,
 -46250,
 1263800853,
 110871,
 -1,
 1263866090,
 110870,
 1264077661,
 1263493619,
 -1,
 -46247,
 1263998252,
 110865,
 -46246,
 1264063576,
 110864,
 -46245,
 1264128826,
 110863,
 -46244,
 1264194069,
 110862,
 -1,
 1264259306,
 110861,
 1264470883,
 1263999430,
 -1,
 -46241,
 1264391468,
 110860,
 -46240,
 1264456792,
 110859,
 -46239,
 1264522042,
 110858,
 -46238,
 1264587285,
 110857,
 -1,
 1264652522,
 110856,
 1264910335,
 1264402902,
 -1,
 -46235,
 1264784472,
 110869,
 -46234,
 1264849722,
 110868,
 -46233,
 1264914965,
 110867,
 -1,
 1264980202,
 110866,
 1265191804,
 1263461132,
 -1,
 1265257328,
 1265144017,
 -1,
 -46229,
 1265178145,
 110828,
 -46228,
 1265243436,
 110827,
 -46227,
 1265308760,
 110826,
 -46226,
 1265374010,
 110825,
 -46225,
 1265439253,
 110824,
 -1,
 1265504490,
 110823,
 1265716087,
 1265179078,
 -1,
 -46222,
 1265689892,
 110818,
 -46221,
 1265702188,
 110817,
 -46220,
 1265767512,
 110816,
 -46219,
 1265832762,
 110815,
 -46218,
 1265898005,
 110814,
 -1,
 1265963242,
 110813,
 1266221055,
 1265684100,
 -1,
 -46215,
 1266095192,
 110822,
 -46214,
 1266160442,
 110821,
 -46213,
 1266225685,
 110820,
 -1,
 1266290922,
 110819,
 1266502531,
 1265123798,
 -1,
 -46210,
 1266423329,
 110611,
 -46209,
 1266488620,
 110610,
 -46208,
 1266553944,
 110609,
 -46207,
 1266619194,
 110608,
 -46206,
 1266684437,
 110607,
 -1,
 1266749674,
 983266,
 1266961289,
 1266470532,
 -1,
 -46203,
 1266881836,
 110606,
 -46202,
 1266947160,
 110605,
 -46201,
 1267012410,
 110604,
 -46200,
 1267077653,
 110603,
 -1,
 1267142890,
 110602,
 1267354510,
 1266901491,
 -1,
 -46197,
 1267274840,
 110601,
 -46196,
 1267340090,
 110600,
 -46195,
 1267405333,
 110599,
 -1,
 1267470570,
 110598,
 1267682195,
 1267276230,
 -1,
 -46192,
 1267654672,
 110597,
 -46191,
 1267667770,
 110596,
 -46190,
 1267733013,
 110595,
 -1,
 1267798250,
 110594,
 1268056063,
 1267634385,
 -1,
 -46187,
 1267929914,
 110614,
 -46186,
 1267995157,
 110613,
 -1,
 1268060394,
 110612,
 1268272118,
 1245700653,
 -1,
 1268337581,
 1268236946,
 -1,
 1268403116,
 1268275896,
 -1,
 1268468638,
 1268329700,
 -1,
 -46180,
 1268427689,
 19904,
 -46179,
 1268481169,
 19933,
 -1,
 1268524542,
 19953,
 1268730787,
 1268390196,
 -1,
 1268796322,
 1268689026,
 -1,
 -46175,
 1268751313,
 19954,
 -1,
 1268812047,
 19910,
 -1,
 1268722903,
 19932,
 1269058470,
 1268701924,
 -1,
 -46171,
 1268991443,
 19951,
 -1,
 1269047445,
 19959,
 -46169,
 1269017546,
 19905,
 -46168,
 1269203687,
 19957,
 -46167,
 1269264917,
 19955,
 -46166,
 1269330014,
 19961,
 -46165,
 1269388537,
 19960,
 -1,
 1269452159,
 19940,
 -1,
 1268362061,
 19913,
 1269713847,
 1268267023,
 -1,
 1269779378,
 1269645507,
 -1,
 -46160,
 1269749584,
 19956,
 -46159,
 1269791998,
 19943,
 -1,
 1269839268,
 19944,
 1270041525,
 1269719425,
 -1,
 -46156,
 1270005249,
 19962,
 -1,
 1270042152,
 19906,
 -46154,
 1270010960,
 19935,
 -1,
 1270162126,
 19939,
 1270369218,
 1269650162,
 -1,
 1270434753,
 1270327426,
 -1,
 1270500288,
 1270366884,
 -1,
 1270565823,
 1270456013,
 -1,
 1270631358,
 1270517905,
 -1,
 -46147,
 1270602910,
 19937,
 -1,
 1270660846,
 19917,
 -1,
 1270590744,
 19931,
 -1,
 1270531062,
 19929,
 -1,
 1270422216,
 19925,
 -1,
 1270359376,
 19948,
 1271090120,
 1270330711,
 -1,
 1271155654,
 1271038395,
 -1,
 -46139,
 1271120886,
 19912,
 -1,
 1271178632,
 19965,
 -46137,
 1271120897,
 19915,
 -1,
 1271309109,
 19926,
 1271483342,
 1271031405,
 -1,
 1271548876,
 1271433512,
 -1,
 -46133,
 1271501135,
 19928,
 -1,
 1271548095,
 19964,
 -46131,
 1271484512,
 19934,
 -1,
 1271674276,
 19945,
 1271876563,
 1271442250,
 -1,
 1271942098,
 1271841426,
 -1,
 -46127,
 1271911567,
 19927,
 -1,
 1271966610,
 19936,
 -1,
 1271912941,
 19952,
 1272204247,
 1271832269,
 -1,
 -46123,
 1272173907,
 19949,
 -46122,
 1272230709,
 19938,
 -1,
 1272267255,
 19914,
 1272466396,
 1272156305,
 -1,
 1272531931,
 1272423673,
 -1,
 -46118,
 1272491382,
 19950,
 -1,
 1272551838,
 19941,
 -1,
 1272458305,
 19942,
 1272794081,
 1272394572,
 -1,
 1272859616,
 1272744232,
 -1,
 -46113,
 1272825048,
 19923,
 -1,
 1272860684,
 19909,
 -1,
 1272809027,
 19947,
 1273121765,
 1272719039,
 -1,
 -46109,
 1273080671,
 19946,
 -46108,
 1273130472,
 19924,
 -1,
 1273185353,
 19967,
 1273383913,
 1273043252,
 -1,
 -46105,
 1273341253,
 19922,
 -46104,
 1273385670,
 19966,
 -1,
 1273441392,
 19958,
 1273646060,
 1273354980,
 -1,
 -46101,
 1273600235,
 19921,
 -1,
 1273634238,
 19908,
 1273842671,
 1273595632,
 -1,
 -46098,
 1273812400,
 19930,
 -1,
 1273838227,
 19918,
 1274039282,
 1273777383,
 -1,
 -46095,
 1273992049,
 19920,
 -1,
 1274037731,
 19916,
 -46093,
 1274013004,
 19907,
 -46092,
 1274182724,
 19963,
 -46091,
 1274240600,
 19911,
 -1,
 1274300315,
 19919,
 1274498131,
 1268193588,
 -1,
 1274563656,
 1274469082,
 -1,
 1274629127,
 1274525015,
 -1,
 1274694656,
 1274584090,
 -1,
 1274760189,
 1274666157,
 -1,
 -46084,
 1274730812,
 128605,
 -1,
 1274752083,
 128613,
 1275002879,
 1274692167,
 -1,
 -46081,
 1274927420,
 128607,
 -1,
 1274948691,
 128615,
 1275153411,
 1274638037,
 -1,
 -46078,
 1275117115,
 128952,
 -1,
 1275175905,
 128972,
 1275350022,
 1275074868,
 -1,
 -46075,
 1275301542,
 128635,
 -1,
 1275363346,
 128940,
 -1,
 1275278815,
 128625,
 1275612178,
 1274573900,
 -1,
 1275677707,
 1275567608,
 -1,
 -46070,
 1275640624,
 10079,
 -1,
 1275674055,
 10080,
 1275874318,
 1275610255,
 -1,
 -46067,
 1275819504,
 129052,
 -1,
 1275873384,
 129048,
 1276070929,
 1275795764,
 -1,
 -46064,
 1276037250,
 128327,
 -1,
 1276096013,
 11093,
 -1,
 1276011611,
 128627,
 1276333082,
 1275533620,
 -1,
 1276398617,
 1276294204,
 -1,
 1276464152,
 1276351663,
 129180,
 1276575743,
 1276379136,
 -1,
 -46057,
 1276495402,
 129183,
 -1,
 1276532954,
 129182,
 -1,
 1276431862,
 129181,
 -1,
 1276348400,
 128628,
 1276857377,
 1276284443,
 -1,
 1276922910,
 1276828845,
 -1,
 -46051,
 1276893500,
 128604,
 -1,
 1276914771,
 128612,
 1277165567,
 1276854855,
 -1,
 -46048,
 1277090108,
 128606,
 -1,
 1277111379,
 128614,
 1277316136,
 1276788931,
 -1,
 1277381671,
 1277256849,
 -1,
 1277447206,
 1277338584,
 -1,
 -46043,
 1277403801,
 128977,
 -1,
 1277438556,
 128975,
 -1,
 1277410875,
 128958,
 -1,
 1277354571,
 10071,
 1277774895,
 1277245455,
 -1,
 1277840430,
 1277726865,
 -1,
 1277905965,
 1277812732,
 -1,
 -46036,
 1277851120,
 129055,
 -1,
 1277905000,
 129051,
 -1,
 1277853018,
 128178,
 -1,
 1277783742,
 10135,
 1278233652,
 1277702391,
 11096,
 1278299187,
 1278151459,
 -1,
 -46030,
 1278263517,
 9955,
 -1,
 1278292259,
 11095,
 -1,
 1278228563,
 11097,
 1278561336,
 1278205187,
 -1,
 -46026,
 1278525007,
 128913,
 -46025,
 1278558022,
 9947,
 -1,
 1278619895,
 128903,
 1278823483,
 1278530552,
 -1,
 -46022,
 1278768624,
 129053,
 -1,
 1278822504,
 129049,
 1279020094,
 1278790975,
 -1,
 -46019,
 1278976665,
 128980,
 -1,
 1279011420,
 128979,
 1279216705,
 1278980280,
 -1,
 -46016,
 1279161840,
 129054,
 -1,
 1279215720,
 129050,
 1279413316,
 1279152003,
 -1,
 -46013,
 1279376955,
 128946,
 -1,
 1279435745,
 128970,
 -46011,
 1279370144,
 10133,
 -46010,
 1279564858,
 11094,
 -46009,
 1279624834,
 10134,
 -1,
 1279683161,
 128633,
 1279872080,
 1274521730,
 -1,
 1279937615,
 1279836820,
 -1,
 1280003150,
 1279909472,
 -1,
 -46004,
 1279969466,
 127892,
 -46003,
 1280028330,
 128157,
 -1,
 1280058226,
 128152,
 -1,
 1279932861,
 128159,
 -1,
 1279856430,
 128585,
 1280442367,
 1279801359,
 -1,
 -45998,
 1280360487,
 9980,
 -1,
 1280418347,
 127911,
 1280592988,
 1274424311,
 -1,
 1280658521,
 1280548557,
 -1,
 1280724056,
 1280610945,
 -1,
 -45993,
 1280681744,
 1479,
 -1,
 1280728644,
 1466,
 -1,
 1280692688,
 1478,
 -45990,
 1280632111,
 1519,
 -45989,
 1280934565,
 1477,
 -1,
 1280973478,
 1442,
 1281182815,
 1280537676,
 -1,
 -45986,
 1281131737,
 9937,
 -1,
 1281188601,
 128641,
 -45984,
 1281141458,
 127807,
 -1,
 1281309337,
 129428,
 1281510790,
 1245583668,
 -1,
 1281576279,
 1281460520,
 -1,
 1281641742,
 1281513414,
 -1,
 1281707232,
 1281584991,
 -1,
 1281772727,
 1281660375,
 -1,
 1281838204,
 1281733975,
 -1,
 1281903731,
 1281799842,
 -1,
 1281969258,
 1281869765,
 55245,
 -1,
 1281888077,
 55246,
 1282100333,
 1281932122,
 -1,
 -45972,
 1282066373,
 55277,
 -1,
 1282110257,
 55276,
 -45970,
 1282073698,
 983211,
 -45969,
 1282256613,
 55255,
 -45968,
 1282318953,
 55270,
 -45967,
 1282378915,
 4607,
 -45966,
 1282442697,
 55264,
 -1,
 1282486489,
 55289,
 1282736127,
 1281846123,
 -1,
 1282755703,
 1282616548,
 -1,
 -45962,
 1282696099,
 55279,
 -1,
 1282759812,
 55280,
 -45960,
 1282721314,
 55281,
 -45959,
 1282908099,
 55278,
 -45958,
 1282966985,
 55274,
 -45957,
 1283027285,
 55275,
 -1,
 1283087499,
 55282,
 1283280011,
 1281793741,
 -1,
 1283345541,
 1283220399,
 -1,
 1283411073,
 1283271908,
 -1,
 -45952,
 1283351459,
 55272,
 -1,
 1283415172,
 55273,
 -45950,
 1283377093,
 55267,
 -45949,
 1283570552,
 55271,
 -45948,
 1283632883,
 55268,
 -1,
 1283687881,
 55269,
 1283869832,
 1283284131,
 -1,
 -45945,
 1283835426,
 55291,
 -1,
 1283898197,
 55290,
 1284112383,
 1283793233,
 -1,
 -45942,
 1284022889,
 55283,
 -1,
 1284075861,
 55284,
 1284263061,
 1283239646,
 -1,
 1284328591,
 1284236278,
 -1,
 -45938,
 1284291261,
 55259,
 -1,
 1284348105,
 55260,
 1284525202,
 1284285039,
 -1,
 -45935,
 1284491205,
 55257,
 -1,
 1284547107,
 55258,
 -45933,
 1284488908,
 55253,
 -45932,
 1284670934,
 55256,
 -1,
 1284731704,
 55254,
 1284918429,
 1284229068,
 -1,
 1284983960,
 1284881237,
 55248,
 -1,
 1284902630,
 55249,
 1285115035,
 1284910308,
 -1,
 -45926,
 1285055395,
 55250,
 -1,
 1285119108,
 55251,
 -45924,
 1285080610,
 55252,
 -1,
 1285268073,
 55247,
 1285442725,
 1284862091,
 -1,
 1285508260,
 1285386059,
 -1,
 -45920,
 1285464681,
 4603,
 -45919,
 1285524643,
 4602,
 -45918,
 1285583535,
 4605,
 -45917,
 1285643403,
 4606,
 -1,
 1285697623,
 4604,
 -1,
 1285431806,
 55261,
 1285967020,
 1285416043,
 -1,
 1286032553,
 1285910667,
 -1,
 -45912,
 1285975877,
 983209,
 -1,
 1286036636,
 983212,
 -45910,
 1285996236,
 983210,
 -45909,
 1286178249,
 55285,
 -1,
 1286233227,
 55286,
 1286425777,
 1285916111,
 -1,
 -45906,
 1286389464,
 55263,
 -45905,
 1286447734,
 55265,
 -45904,
 1286507683,
 55262,
 -1,
 1286549721,
 55266,
 1286753460,
 1286376617,
 -1,
 -45901,
 1286713048,
 55243,
 -1,
 1286746199,
 55244,
 1286995967,
 1286680799,
 -1,
 -45898,
 1286913763,
 55288,
 -1,
 1286972009,
 55287,
 1287192575,
 1281741384,
 -1,
 1287212227,
 1287086579,
 -1,
 1287277761,
 1287185164,
 -1,
 1287343292,
 1287209155,
 55232,
 -1,
 1287295121,
 55231,
 1287474367,
 1287264564,
 -1,
 -45890,
 1287405763,
 55230,
 -1,
 1287458622,
 55229,
 -45888,
 1287441949,
 55235,
 -1,
 1287622801,
 55234,
 -45886,
 1287229652,
 55233,
 -1,
 1287741825,
 55236,
 1287933133,
 1287185164,
 -1,
 1287998664,
 1287885009,
 -1,
 1288064199,
 1287919924,
 55218,
 -1,
 1287995587,
 55219,
 -1,
 1287997423,
 55220,
 1288260811,
 1287966340,
 -1,
 -45878,
 1288212625,
 55224,
 -1,
 1288248282,
 55223,
 -45876,
 1288194034,
 4517,
 -1,
 1288378843,
 4516,
 1288588499,
 1287885009,
 -1,
 1288654034,
 1288561420,
 -1,
 1288719569,
 1288575284,
 4518,
 -1,
 1288650947,
 4519,
 -1,
 1288652783,
 55216,
 -1,
 1288605908,
 55217,
 1288981720,
 1288522321,
 -1,
 1289047254,
 1288913091,
 55227,
 -1,
 1288999057,
 55226,
 -45865,
 1288999057,
 55228,
 -1,
 1289099572,
 55225,
 1289309405,
 1288902964,
 -1,
 1289374940,
 1289267504,
 -1,
 -45861,
 1289306307,
 55238,
 -1,
 1289361716,
 55237,
 -1,
 1289293496,
 4515,
 1289682943,
 1289277060,
 -1,
 -45857,
 1289610313,
 55221,
 -1,
 1289642486,
 55222,
 1289879551,
 1281634447,
 -1,
 1289899248,
 1289793246,
 -1,
 1289964776,
 1289860439,
 -1,
 1290030311,
 1289926306,
 -1,
 -45851,
 1289996229,
 43367,
 -45850,
 1290052201,
 43370,
 -1,
 1290105649,
 43365,
 -1,
 1289972583,
 43372,
 1290357996,
 1289908363,
 -1,
 -45846,
 1290301253,
 43364,
 -45845,
 1290362012,
 43374,
 -1,
 1290412529,
 43371,
 -45843,
 1290323909,
 43366,
 -45842,
 1290576489,
 43369,
 -45841,
 1290634697,
 43368,
 -1,
 1290678489,
 43373,
 1290882294,
 1289865164,
 -1,
 -45838,
 1290845013,
 43362,
 -45837,
 1290907352,
 4446,
 -45836,
 1290969705,
 43361,
 -45835,
 1291027913,
 43360,
 -1,
 1291071705,
 43363,
 1291275515,
 1290845894,
 -1,
 -45832,
 1291248717,
 43388,
 -45831,
 1291306530,
 43385,
 -45830,
 1291369312,
 43381,
 -1,
 1291399398,
 43384,
 1291603201,
 1291230925,
 -1,
 1291668736,
 1291543471,
 -1,
 -45826,
 1291631467,
 43378,
 -45825,
 1291678383,
 43379,
 -1,
 1291738251,
 43380,
 -1,
 1291607211,
 43386,
 1291996421,
 1291553961,
 -1,
 -45821,
 1291959125,
 4443,
 -45820,
 1292000395,
 4445,
 -1,
 1292054745,
 4444,
 1292258569,
 1291945423,
 -1,
 -45817,
 1292224453,
 43376,
 -45816,
 1292286805,
 43377,
 -1,
 1292333873,
 43375,
 1292520716,
 1292198824,
 -1,
 -45813,
 1292480216,
 43382,
 -1,
 1292524683,
 43383,
 -45811,
 1292464965,
 4442,
 -1,
 1292655761,
 43387,
 1292848465,
 1281582010,
 -1,
 1292913972,
 1292794507,
 -1,
 1292979478,
 1292857483,
 -1,
 1293045012,
 1292921257,
 -1,
 -45805,
 1293017972,
 68889,
 -1,
 1293081380,
 68887,
 -45803,
 1292982334,
 68872,
 -1,
 1293162804,
 68881,
 1293372698,
 1292929320,
 -1,
 -45800,
 1293345652,
 68891,
 -45799,
 1293374273,
 68890,
 -1,
 1293424948,
 68885,
 1293634845,
 1293337234,
 -1,
 -45796,
 1293599512,
 68868,
 -1,
 1293621556,
 68867,
 1293831456,
 1293595991,
 -1,
 -45793,
 1293768766,
 68880,
 -1,
 1293818164,
 68879,
 1294028067,
 1293789314,
 -1,
 -45790,
 1293986037,
 68877,
 -1,
 1294014772,
 68876,
 1294224678,
 1293957135,
 -1,
 -45787,
 1294153886,
 68875,
 -1,
 1294211380,
 68874,
 -45785,
 1294198221,
 68878,
 -45784,
 1294394228,
 68888,
 -45783,
 1294457636,
 68886,
 -45782,
 1294521870,
 68892,
 -45781,
 1294573353,
 68866,
 -45780,
 1294631131,
 68884,
 -45779,
 1294693526,
 68883,
 -45778,
 1294757757,
 68869,
 -45777,
 1294817342,
 68871,
 -45776,
 1294881601,
 68882,
 -45775,
 1294945596,
 68873,
 -45774,
 1295002907,
 68870,
 -45773,
 1295066868,
 68865,
 -1,
 1295128884,
 68864,
 1295338818,
 1292843870,
 -1,
 1295404344,
 1295303314,
 -1,
 -45769,
 1295376400,
 68914,
 -1,
 1295409105,
 68915,
 1295600955,
 1295365463,
 -1,
 -45766,
 1295544018,
 68918,
 -1,
 1295600363,
 68919,
 1295797566,
 1295535335,
 -1,
 -45763,
 1295751963,
 68916,
 -1,
 1295805984,
 68917,
 -45761,
 1295771274,
 68912,
 -45760,
 1295946927,
 68913,
 -45759,
 1296010456,
 68921,
 -1,
 1296057613,
 68920,
 1296256328,
 1295309358,
 -1,
 -45756,
 1296223773,
 68895,
 -45755,
 1296273553,
 68897,
 -45754,
 1296327041,
 68894,
 -45753,
 1296384195,
 68896,
 -1,
 1296439604,
 68893,
 1296649550,
 1296218825,
 -1,
 1296715085,
 1296614168,
 -1,
 -45749,
 1296678647,
 68903,
 -45748,
 1296730482,
 68902,
 -1,
 1296783559,
 68901,
 -1,
 1296652885,
 68900,
 1297088511,
 1296597642,
 -1,
 -45744,
 1297004078,
 68898,
 -1,
 1297058181,
 68899,
 1297285119,
 1292777487,
 -1,
 1297304917,
 1297164020,
 -1,
 -45740,
 1297251600,
 129342,
 -1,
 1297306354,
 128092,
 -45738,
 1297266899,
 129309,
 -1,
 1297419482,
 129310,
 1297632635,
 1281540754,
 -1,
 1297698170,
 1297590797,
 -1,
 1297763699,
 1297644171,
 -1,
 1297829215,
 1297724759,
 -1,
 1297894750,
 1297750324,
 -1,
 -45731,
 1297843300,
 67822,
 -1,
 1297889978,
 67825,
 -1,
 1297833285,
 67828,
 1298156898,
 1297793682,
 -1,
 -45727,
 1298090492,
 67816,
 -1,
 1298146921,
 67829,
 1298353508,
 1298094773,
 67812,
 -1,
 1298318745,
 67815,
 1298484583,
 1298274612,
 -1,
 -45722,
 1298457881,
 67823,
 -1,
 1298496088,
 67808,
 -45720,
 1298458211,
 67814,
 -45719,
 1298654524,
 67817,
 -45718,
 1298717706,
 67813,
 -45717,
 1298769731,
 67826,
 -45716,
 1298833620,
 67824,
 -45715,
 1298894851,
 67821,
 -45714,
 1298957437,
 67820,
 -45713,
 1299019155,
 67819,
 -45712,
 1299083600,
 67818,
 -45711,
 1299142212,
 67810,
 -45710,
 1299200247,
 67811,
 -1,
 1299261703,
 67809,
 1299513343,
 1297715143,
 -1,
 1299533175,
 1299432082,
 -1,
 -45706,
 1299504258,
 67838,
 -1,
 1299531338,
 67837,
 1299729785,
 1299485871,
 67835,
 -1,
 1299645272,
 67839,
 -1,
 1299664766,
 67836,
 -1,
 1297625197,
 128035,
 1299991938,
 1297580165,
 -1,
 1300057472,
 1299940528,
 128296,
 1300168703,
 1299972162,
 -1,
 -45697,
 1300095397,
 128736,
 -1,
 1300144715,
 9874,
 -45695,
 1300021185,
 128057,
 -1,
 1300245634,
 127828,
 -45693,
 1299950329,
 128436,
 -45692,
 1300407642,
 128587,
 -45691,
 1300458575,
 128135,
 -1,
 1300511303,
 11233,
 1300712879,
 1281462417,
 -1,
 1300778393,
 1300670594,
 -1,
 1300843925,
 1300721494,
 -1,
 1300909457,
 1300808338,
 -1,
 1300974992,
 1300830739,
 -1,
 1301040527,
 1300943092,
 983059,
 1301151743,
 1300955136,
 -1,
 -45682,
 1301077664,
 983140,
 -1,
 1301133354,
 983137,
 -1,
 1300956116,
 11134,
 -1,
 1300932918,
 128677,
 1301433748,
 1300834851,
 -1,
 -45677,
 1301385577,
 11203,
 -1,
 1301437468,
 11043,
 -1,
 1301381529,
 9897,
 1301741567,
 1300805433,
 128014,
 1301807103,
 1301610496,
 -1,
 -45672,
 1301719316,
 127943,
 -1,
 1301761343,
 128052,
 1301958047,
 1300745757,
 -1,
 1302023582,
 1301919548,
 -1,
 1302089117,
 1301949535,
 127968,
 -1,
 1302050135,
 127960,
 -1,
 1302060672,
 127969,
 -1,
 1301982755,
 9203,
 1302351269,
 1301922450,
 -1,
 1302416804,
 1302265856,
 -1,
 -45662,
 1302372770,
 127798,
 -45661,
 1302412313,
 127789,
 -1,
 1302473043,
 9749,
 -1,
 1302349200,
 127976,
 1302744489,
 1302295628,
 -1,
 1302810024,
 1302691608,
 128616,
 -1,
 1302725489,
 128617,
 -1,
 1302741187,
 128371,
 1303006636,
 1302694878,
 -1,
 -45653,
 1302931582,
 128029,
 -1,
 1302988871,
 127855,
 -45651,
 1302969901,
 127973,
 -45650,
 1303158477,
 983123,
 -1,
 1303195776,
 128298,
 1303399877,
 1300652417,
 -1,
 1303465400,
 1303357763,
 -1,
 1303530935,
 1303390615,
 -1,
 -45645,
 1303498269,
 983980,
 -45644,
 1303548049,
 983982,
 -45643,
 1303601537,
 983979,
 -45642,
 1303658691,
 983981,
 -1,
 1303714100,
 983978,
 -1,
 1303454330,
 110593,
 1303989697,
 1303401840,
 -1,
 1304055229,
 1303907942,
 -1,
 1304120764,
 1304018421,
 128644,
 -1,
 1304038186,
 128645,
 -1,
 1304058767,
 128096,
 1304363007,
 1303969792,
 -1,
 -45633,
 1304287712,
 9889,
 -45632,
 1304334705,
 983122,
 -1,
 1304374269,
 128262,
 -45630,
 1303953470,
 9964,
 -45629,
 1304536354,
 129435,
 -45628,
 1304589045,
 129406,
 -1,
 1304635906,
 127802,
 1304841674,
 1303372556,
 -1,
 1304907209,
 1304796877,
 -1,
 -45624,
 1304859050,
 11794,
 -1,
 1304910761,
 11802,
 -1,
 1304843825,
 11226,
 1305169358,
 1304808989,
 -1,
 -45620,
 1305131340,
 128559,
 -45619,
 1305184954,
 128175,
 -1,
 1305236778,
 129303,
 1305431505,
 1305133714,
 983060,
 -45616,
 1305392471,
 983138,
 -1,
 1305440095,
 983141,
 -1,
 1305392459,
 8372,
 1305694502,
 1245552333,
 -1,
 1305759563,
 1305614644,
 -1,
 1305824909,
 1305696923,
 -1,
 1305890314,
 1305750756,
 -1,
 1305955823,
 1305843262,
 -1,
 1306021343,
 1305905448,
 -1,
 1306086875,
 1305985682,
 -1,
 -45606,
 1306048221,
 92957,
 -1,
 1306090131,
 92971,
 -45604,
 1306031811,
 92960,
 -45603,
 1306227150,
 92962,
 -45602,
 1306275817,
 92968,
 -1,
 1306338771,
 92972,
 1306545635,
 1305958440,
 -1,
 -45599,
 1306495487,
 92969,
 -45598,
 1306556099,
 92965,
 -1,
 1306600915,
 92959,
 1306807782,
 1306471652,
 -1,
 -45595,
 1306745491,
 92967,
 -1,
 1306797523,
 92975,
 -45593,
 1306780649,
 92964,
 -45592,
 1306976829,
 92974,
 -45591,
 1307039452,
 92956,
 -45590,
 1307093662,
 92961,
 -45589,
 1307158308,
 92963,
 -45588,
 1307222805,
 92970,
 -45587,
 1307280154,
 92966,
 -45586,
 1307342531,
 92958,
 -1,
 1307387347,
 92973,
 1307639807,
 1305900450,
 -1,
 1307659766,
 1307558546,
 -1,
 1307725301,
 1307620695,
 -1,
 -45581,
 1307696170,
 93069,
 -45580,
 1307728766,
 93053,
 -1,
 1307777555,
 93062,
 -1,
 1307663936,
 93061,
 1308052986,
 1307603083,
 -1,
 -45576,
 1308024760,
 93070,
 -45575,
 1308071543,
 93058,
 -1,
 1308121183,
 93064,
 1308315133,
 1308025612,
 -1,
 -45572,
 1308246977,
 93054,
 -1,
 1308302813,
 93068,
 1308511744,
 1308284408,
 -1,
 -45569,
 1308483506,
 93071,
 -1,
 1308499421,
 93066,
 1308708355,
 1308456012,
 -1,
 -45566,
 1308650629,
 93055,
 -1,
 1308698101,
 93056,
 1308904966,
 1308645438,
 -1,
 -45563,
 1308876722,
 93059,
 -1,
 1308917893,
 93065,
 -45561,
 1308877574,
 93057,
 -45560,
 1309057556,
 93063,
 -45559,
 1309116504,
 93060,
 -1,
 1309166950,
 93067,
 1309363773,
 1305852617,
 -1,
 1309429270,
 1309290738,
 -1,
 1309494800,
 1309393554,
 -1,
 1309560335,
 1309467394,
 93044,
 -1,
 1309475294,
 93045,
 -1,
 1309523405,
 92997,
 1309756947,
 1309420772,
 -1,
 -45550,
 1309724380,
 93043,
 -1,
 1309760411,
 92985,
 -45548,
 1309713953,
 93046,
 -45547,
 1309904536,
 93047,
 -1,
 1309956249,
 93042,
 1310150176,
 1309401601,
 -1,
 1310215710,
 1310122764,
 -1,
 1310281245,
 1310147567,
 -1,
 -45542,
 1310247426,
 92990,
 -45541,
 1310305857,
 92989,
 -45540,
 1310363554,
 92988,
 -1,
 1310412129,
 92991,
 -1,
 1310234231,
 93028,
 -45537,
 1310155267,
 93034,
 -1,
 1310598674,
 92996,
 1310805546,
 1310120479,
 -1,
 1310871078,
 1310769810,
 -1,
 1310936613,
 1310808104,
 -1,
 -45532,
 1310888851,
 92983,
 -1,
 1310941699,
 92986,
 -1,
 1310898367,
 92984,
 -45529,
 1310832510,
 92992,
 -45528,
 1311149729,
 92994,
 -45527,
 1311211585,
 93027,
 -1,
 1311264200,
 92987,
 1311460910,
 1310769810,
 -1,
 -45524,
 1311433358,
 93037,
 -45523,
 1311464834,
 93030,
 -1,
 1311516115,
 93039,
 1311723059,
 1311408261,
 -1,
 1311788594,
 1311654853,
 -1,
 -45519,
 1311755244,
 93038,
 -1,
 1311818095,
 92993,
 -1,
 1311757581,
 93041,
 1312050742,
 1311672616,
 -1,
 -45515,
 1312017520,
 93035,
 -1,
 1312073517,
 93033,
 1312247353,
 1311987752,
 -1,
 -45512,
 1312198571,
 93032,
 -1,
 1312258899,
 93029,
 -45510,
 1312220991,
 93031,
 -45509,
 1312390770,
 93040,
 -45508,
 1312449186,
 92995,
 -1,
 1312499240,
 93036,
 1312706152,
 1309334069,
 -1,
 1312771661,
 1312626996,
 -1,
 1312837186,
 1312742116,
 -1,
 -45503,
 1312806392,
 92943,
 -1,
 1312827071,
 92942,
 1313033797,
 1312804381,
 -1,
 -45500,
 1313003000,
 92933,
 -1,
 1313023679,
 92932,
 1313230408,
 1312973185,
 -1,
 -45497,
 1313199608,
 92939,
 -1,
 1313220287,
 92938,
 1313427019,
 1313151284,
 -1,
 -45494,
 1313396216,
 92955,
 -1,
 1313416895,
 92954,
 -45492,
 1313396216,
 92951,
 -1,
 1313547967,
 92950,
 1313754707,
 1312738845,
 -1,
 1313820241,
 1313675572,
 -1,
 -45488,
 1313789432,
 92945,
 -1,
 1313810111,
 92944,
 -45486,
 1313789432,
 92935,
 -1,
 1313941183,
 92934,
 1314147929,
 1313706129,
 -1,
 1314213463,
 1314099345,
 -1,
 -45482,
 1314182648,
 92941,
 -1,
 1314203327,
 92940,
 -45480,
 1314182648,
 92947,
 -1,
 1314334399,
 92946,
 1314541151,
 1314087297,
 -1,
 1314606685,
 1314462004,
 -1,
 -45476,
 1314575864,
 92949,
 -1,
 1314596543,
 92948,
 -45474,
 1314575864,
 92931,
 -1,
 1314727615,
 92930,
 1314934373,
 1314472131,
 -1,
 1314999907,
 1314865347,
 -1,
 -45470,
 1314969080,
 92929,
 -1,
 1314989759,
 92928,
 -45468,
 1314969080,
 92937,
 -1,
 1315120831,
 92936,
 1315373055,
 1314904804,
 -1,
 -45465,
 1315296760,
 92953,
 -1,
 1315317439,
 92952,
 1315524214,
 1312635742,
 -1,
 1315589740,
 1315488402,
 -1,
 -45461,
 1315561488,
 93010,
 -1,
 1315594193,
 93011,
 1315786351,
 1315550551,
 -1,
 -45458,
 1315729106,
 93014,
 -1,
 1315785451,
 93015,
 1315982962,
 1315720423,
 -1,
 -45455,
 1315937051,
 93012,
 -1,
 1315991072,
 93013,
 -45453,
 1315956362,
 93008,
 -45452,
 1316132015,
 93009,
 -45451,
 1316195544,
 93017,
 -1,
 1316242701,
 93016,
 1316441730,
 1315475399,
 -1,
 1316507262,
 1316405906,
 -1,
 1316572797,
 1316439626,
 -1,
 1316638332,
 1316487168,
 -1,
 -45445,
 1316603504,
 93021,
 -1,
 1316628927,
 93024,
 -1,
 1316599127,
 93019,
 -1,
 1316532489,
 93025,
 1316966017,
 1316446471,
 -1,
 -45440,
 1316926807,
 93020,
 -1,
 1316947107,
 93023,
 -1,
 1316914714,
 93022,
 1317273599,
 1316389531,
 -1,
 1317293702,
 1317192338,
 -1,
 -45435,
 1317261067,
 92976,
 -1,
 1317283334,
 92982,
 1317490313,
 1317254487,
 -1,
 -45432,
 1317457624,
 92980,
 -1,
 1317507217,
 92977,
 1317686924,
 1317433483,
 -1,
 -45429,
 1317624471,
 92979,
 -1,
 1317685641,
 92978,
 -1,
 1317625449,
 92981,
 1317949142,
 1305792034,
 -1,
 1318014657,
 1317893196,
 -1,
 1318080188,
 1317947937,
 -1,
 1318145692,
 1318014183,
 -1,
 1318211227,
 1318086297,
 -1,
 1318276756,
 1318160680,
 72416,
 -1,
 1318212338,
 72419,
 -45419,
 1318249228,
 72420,
 -45418,
 1318378212,
 72418,
 -45417,
 1318437522,
 72414,
 -45416,
 1318493901,
 72412,
 -45415,
 1318551685,
 72415,
 -45414,
 1318614092,
 72417,
 -1,
 1318678667,
 72413,
 -1,
 1318132020,
 72403,
 1318932126,
 1318112797,
 72409,
 -1,
 1318852916,
 72410,
 1319063201,
 1318896274,
 -1,
 -45408,
 1319000126,
 72399,
 -1,
 1319049524,
 72398,
 1319259812,
 1319018189,
 -1,
 -45405,
 1319196734,
 72401,
 -1,
 1319246132,
 72384,
 1319456423,
 1319209256,
 -1,
 -45402,
 1319392065,
 72391,
 -1,
 1319442740,
 72400,
 1319653034,
 1319399563,
 -1,
 -45399,
 1319589950,
 72394,
 -1,
 1319639348,
 72385,
 1319849644,
 1319592321,
 72407,
 -1,
 1319770420,
 72411,
 1319980719,
 1319775460,
 -1,
 -45394,
 1319917630,
 72404,
 -1,
 1319967028,
 72397,
 -45392,
 1319953869,
 72389,
 -45391,
 1320146446,
 72390,
 -45390,
 1320203777,
 72395,
 -45389,
 1320265973,
 72402,
 -45388,
 1320325265,
 72408,
 -45387,
 1320386779,
 72387,
 -45386,
 1320449174,
 72386,
 -45385,
 1320507454,
 72392,
 -45384,
 1320571713,
 72393,
 -45383,
 1320632515,
 72406,
 -45382,
 1320695966,
 72388,
 -45381,
 1320756980,
 72396,
 -1,
 1320818996,
 72405,
 1321074687,
 1318034995,
 72436,
 1321140223,
 1320943616,
 -1,
 1321160384,
 1321041407,
 72435,
 -1,
 1321075410,
 72438,
 -1,
 1321094782,
 72439,
 1321357001,
 1317975706,
 -1,
 1321422535,
 1321322831,
 72428,
 1321533439,
 1321336832,
 -1,
 1321553606,
 1321434623,
 72427,
 -1,
 1321468626,
 72429,
 -1,
 1321487998,
 72430,
 1321795583,
 1321359010,
 72423,
 -1,
 1321665234,
 72426,
 1321881294,
 1321316964,
 72422,
 1321992191,
 1321795584,
 -1,
 1322012365,
 1321893375,
 72421,
 -1,
 1321927378,
 72424,
 -1,
 1321946750,
 72425,
 1322208978,
 1321829674,
 72431,
 1322319871,
 1322123264,
 -1,
 -45359,
 1322221080,
 72433,
 -1,
 1322274430,
 72434,
 1322516479,
 1322145442,
 72437,
 1322582015,
 1322385408,
 -1,
 -45355,
 1322505795,
 72432,
 -1,
 1322536574,
 72440,
 1322733314,
 1317906562,
 -1,
 1322798838,
 1322665871,
 -1,
 1322864371,
 1322743415,
 -1,
 -45350,
 1322837437,
 127273,
 -45349,
 1322902284,
 127272,
 -45348,
 1322967553,
 127271,
 -45347,
 1323031268,
 127270,
 -45346,
 1323095544,
 127269,
 -45345,
 1323159069,
 127268,
 -45344,
 1323221650,
 127267,
 -45343,
 1323283799,
 127266,
 -45342,
 1323346050,
 127265,
 -45341,
 1323411154,
 127264,
 -45340,
 1323474637,
 127263,
 -45339,
 1323536529,
 127262,
 -45338,
 1323600168,
 127261,
 -45337,
 1323663493,
 127260,
 -45336,
 1323725900,
 127259,
 -45335,
 1323790475,
 127258,
 -45334,
 1323855711,
 127257,
 -45333,
 1323917697,
 127256,
 -45332,
 1323980840,
 127255,
 -45331,
 1324045042,
 127254,
 -45330,
 1324109031,
 127253,
 -45329,
 1324171459,
 127252,
 -45328,
 1324234767,
 127251,
 -45327,
 1324297444,
 127250,
 -45326,
 1324361407,
 127249,
 -1,
 1324423476,
 127248,
 1324679167,
 1322808224,
 -1,
 -45323,
 1324576736,
 12829,
 -1,
 1324614484,
 12830,
 1324830462,
 1322762898,
 -1,
 1324895996,
 1324769840,
 -1,
 -45319,
 1324864136,
 983149,
 -45318,
 1324896491,
 983145,
 -45317,
 1324957368,
 983146,
 -1,
 1325016862,
 983148,
 -45315,
 1324868412,
 127881,
 -1,
 1325173655,
 12880,
 1325354753,
 1324752098,
 -1,
 -45312,
 1325323536,
 11853,
 -1,
 1325373832,
 11791,
 -1,
 1325315003,
 129436,
 1325616948,
 1322677324,
 -1,
 1325682483,
 1325564037,
 -1,
 1325748015,
 1325655453,
 -1,
 1325813539,
 1325692749,
 -1,
 1325879074,
 1325780003,
 -1,
 1325944588,
 1325839703,
 -1,
 1326010123,
 1325865268,
 -1,
 -45302,
 1325958244,
 67695,
 -1,
 1326004922,
 67698,
 -1,
 1325948229,
 67701,
 1326272271,
 1325908626,
 -1,
 -45298,
 1326205436,
 67688,
 -1,
 1326261865,
 67702,
 1326468881,
 1326209717,
 67684,
 -1,
 1326433689,
 67687,
 1326599956,
 1326389556,
 -1,
 -45293,
 1326572688,
 67696,
 -1,
 1326611032,
 67680,
 -45291,
 1326573149,
 67686,
 -45290,
 1326769468,
 67689,
 -45289,
 1326832650,
 67685,
 -45288,
 1326886211,
 67700,
 -45287,
 1326950211,
 67699,
 -45286,
 1327014100,
 67697,
 -45285,
 1327075331,
 67694,
 -45284,
 1327137917,
 67692,
 -45283,
 1327199635,
 67691,
 -45282,
 1327264080,
 67690,
 -45281,
 1327322692,
 67682,
 -45280,
 1327386333,
 67693,
 -45279,
 1327446256,
 67683,
 -1,
 1327507719,
 67681,
 -1,
 1325814444,
 67703,
 1327779630,
 1325764551,
 -1,
 1327845162,
 1327743634,
 -1,
 1327910696,
 1327815396,
 -1,
 -45273,
 1327861905,
 67706,
 -1,
 1327908793,
 67711,
 -45271,
 1327849425,
 67707,
 -1,
 1328039498,
 67710,
 1328238381,
 1327779047,
 -1,
 -45268,
 1328192283,
 67708,
 -1,
 1328246304,
 67709,
 -1,
 1328190639,
 67705,
 -1,
 1327738961,
 67704,
 1328566066,
 1325662208,
 -1,
 -45263,
 1328532081,
 127796,
 -1,
 1328556995,
 11801,
 -1,
 1328526815,
 129330,
 -1,
 1325626940,
 9908,
 1328893758,
 1325552370,
 -1,
 1328959293,
 1328824515,
 128463,
 1329024827,
 1328873472,
 -1,
 1329090362,
 1328995942,
 -1,
 -45255,
 1329058955,
 128195,
 -1,
 1329097736,
 128479,
 -1,
 1329024343,
 128196,
 -45252,
 1328985431,
 128464,
 -1,
 1329309826,
 128223,
 -1,
 1328910730,
 128724,
 1329549123,
 1328856742,
 -1,
 1329614658,
 1329479875,
 -1,
 -45247,
 1329564778,
 128755,
 -1,
 1329608827,
 11261,
 -1,
 1329570987,
 128706,
 1329876806,
 1329498408,
 -1,
 -45243,
 1329805477,
 128060,
 -1,
 1329868115,
 129374,
 1330073416,
 1329805327,
 983121,
 -1,
 1330002822,
 983120,
 -45239,
 1330043633,
 128062,
 -45238,
 1330160082,
 128206,
 -1,
 1330197055,
 128230,
 1330401278,
 1305696296,
 -1,
 1330466775,
 1330321716,
 -1,
 1330532247,
 1330403227,
 -1,
 1330597771,
 1330477707,
 -1,
 1330663256,
 1330561682,
 -1,
 1330728787,
 1330627218,
 -1,
 -45230,
 1330665534,
 43114,
 -1,
 1330714932,
 43113,
 1330925398,
 1330689367,
 -1,
 -45227,
 1330862142,
 43089,
 -1,
 1330911540,
 43088,
 -45225,
 1330862142,
 43081,
 -1,
 1331042612,
 43080,
 1331253085,
 1330612520,
 -1,
 -45222,
 1331225460,
 43079,
 -45221,
 1331267954,
 43116,
 -45220,
 1331319617,
 43075,
 -1,
 1331370292,
 43083,
 1331580769,
 1331213655,
 -1,
 -45217,
 1331528129,
 43094,
 -45216,
 1331583038,
 43098,
 -1,
 1331632436,
 43099,
 1331842917,
 1331509263,
 -1,
 -45213,
 1331815885,
 43090,
 -45212,
 1331837086,
 43115,
 -1,
 1331894580,
 43082,
 1332105065,
 1331768548,
 -1,
 1332170600,
 1332025652,
 43076,
 -1,
 1332120240,
 43123,
 -1,
 1332107326,
 43077,
 1332367212,
 1332025652,
 43101,
 -45205,
 1332330007,
 43120,
 -1,
 1332379636,
 43117,
 1332563823,
 1332340157,
 -1,
 -45202,
 1332500542,
 43092,
 -1,
 1332549940,
 43093,
 1332760434,
 1332533689,
 -1,
 -45199,
 1332705889,
 43118,
 -1,
 1332754490,
 43119,
 1332957045,
 1332715213,
 -1,
 -45196,
 1332893758,
 43085,
 -1,
 1332943156,
 43084,
 1333153656,
 1332899979,
 -1,
 -45193,
 1333090366,
 43073,
 -1,
 1333139764,
 43072,
 1333350267,
 1333089010,
 -1,
 -45190,
 1333285697,
 43109,
 -1,
 1333336372,
 43074,
 1333546877,
 1333280963,
 43104,
 -1,
 1333477571,
 43110,
 -45186,
 1333519220,
 43095,
 -45185,
 1333649956,
 43107,
 -45184,
 1333713700,
 43091,
 -45183,
 1333775901,
 43103,
 -45182,
 1333831925,
 43096,
 -45181,
 1333896945,
 43106,
 -45180,
 1333956753,
 43105,
 -45179,
 1334018267,
 43087,
 -45178,
 1334080662,
 43097,
 -45177,
 1334144893,
 43078,
 -45176,
 1334206849,
 43102,
 -45175,
 1334270014,
 43100,
 -45174,
 1334332732,
 43108,
 -1,
 1334388468,
 43086,
 1334595475,
 1330558295,
 -1,
 1334661010,
 1334562333,
 -1,
 1334726545,
 1334585875,
 -1,
 -45169,
 1334698868,
 43112,
 -45168,
 1334762276,
 43111,
 -1,
 1334814965,
 43121,
 -1,
 1334682074,
 43122,
 -1,
 1334602023,
 43124,
 1335119766,
 1334542986,
 -1,
 -45163,
 1335081161,
 43126,
 -1,
 1335115374,
 43127,
 -1,
 1335049742,
 43125,
 1335427071,
 1330474303,
 -1,
 1335447459,
 1335307492,
 -1,
 1335512989,
 1335398545,
 -1,
 1335578524,
 1335460642,
 66020,
 -1,
 1335519556,
 66045,
 -1,
 1335525457,
 66022,
 1335775137,
 1335433524,
 -1,
 -45153,
 1335739026,
 66028,
 -45152,
 1335800848,
 66018,
 -1,
 1335862803,
 66003,
 -45150,
 1335722049,
 66012,
 -1,
 1335975197,
 66004,
 1336168363,
 1335407959,
 -1,
 1336233895,
 1336106060,
 -1,
 -45146,
 1336188621,
 66024,
 -1,
 1336231323,
 66011,
 -45144,
 1336199750,
 66042,
 -45143,
 1336377800,
 66043,
 -45142,
 1336441990,
 66021,
 -1,
 1336485481,
 66015,
 1336692658,
 1336092351,
 -1,
 1336758191,
 1336643729,
 -1,
 -45138,
 1336728292,
 66010,
 -1,
 1336775662,
 66017,
 1336954801,
 1336689589,
 66033,
 -1,
 1336892886,
 66023,
 -1,
 1336922377,
 66027,
 1337151416,
 1336647373,
 -1,
 1337216950,
 1337095244,
 -1,
 -45131,
 1337184618,
 66001,
 -1,
 1337204915,
 66034,
 -45129,
 1337148282,
 66000,
 -1,
 1337336331,
 66036,
 1337544636,
 1337115282,
 -1,
 -45126,
 1337512559,
 66032,
 -45125,
 1337549457,
 66008,
 -1,
 1337599400,
 66002,
 1337806784,
 1337481256,
 -1,
 -45122,
 1337760006,
 66025,
 -45121,
 1337811766,
 66026,
 -1,
 1337869805,
 66006,
 1338068931,
 1337776868,
 -1,
 -45118,
 1338020781,
 66005,
 -1,
 1338058321,
 66044,
 1338265542,
 1338026114,
 -1,
 -45115,
 1338218896,
 66037,
 -1,
 1338253161,
 66029,
 1338462153,
 1338212571,
 -1,
 -45112,
 1338428471,
 66014,
 -1,
 1338476967,
 66013,
 1338658764,
 1338407763,
 -1,
 -45109,
 1338605693,
 66038,
 -1,
 1338652687,
 66016,
 1338855375,
 1338594034,
 -1,
 -45106,
 1338813032,
 66041,
 -1,
 1338844682,
 66007,
 1339051986,
 1338784781,
 -1,
 -45103,
 1339021027,
 66031,
 -1,
 1339063545,
 66019,
 -45101,
 1339021623,
 66035,
 -45100,
 1339203209,
 66039,
 -45099,
 1339248744,
 66040,
 -45098,
 1339310600,
 66030,
 -1,
 1339368306,
 66009,
 1339621375,
 1330417809,
 -1,
 1339641853,
 1339508513,
 -1,
 1339707379,
 1339587211,
 -1,
 1339772894,
 1339667799,
 -1,
 -45092,
 1339710789,
 67860,
 -45091,
 1339770412,
 67854,
 -1,
 1339825073,
 67857,
 1340035041,
 1339736722,
 -1,
 -45088,
 1339967956,
 67848,
 -1,
 1340024275,
 67861,
 1340231651,
 1339972277,
 67844,
 -1,
 1340195474,
 67847,
 1340362726,
 1340152116,
 -1,
 -45083,
 1340308234,
 67840,
 -1,
 1340368493,
 67855,
 -45081,
 1340335572,
 67846,
 -45080,
 1340532011,
 67849,
 -45079,
 1340595184,
 67845,
 -45078,
 1340650381,
 67859,
 -45077,
 1340712762,
 67858,
 -45076,
 1340776660,
 67856,
 -45075,
 1340837891,
 67853,
 -45074,
 1340900477,
 67852,
 -45073,
 1340962184,
 67851,
 -45072,
 1341026589,
 67850,
 -45071,
 1341084608,
 67842,
 -45070,
 1341143529,
 67843,
 -1,
 1341204727,
 67841,
 1341411324,
 1339658183,
 -1,
 1341476858,
 1341375122,
 -1,
 1341542392,
 1341446884,
 -1,
 -45065,
 1341493393,
 67866,
 -1,
 1341540281,
 67864,
 -45063,
 1341480913,
 67867,
 -1,
 1341670986,
 67863,
 1341915135,
 1341428911,
 67862,
 -1,
 1341784920,
 67865,
 -1,
 1341383046,
 67871,
 -1,
 1339588720,
 11227,
 1342132338,
 1330345036,
 -1,
 1342197865,
 1342052660,
 -1,
 1342263400,
 1342170273,
 -1,
 1342328871,
 1342227090,
 -1,
 1342394392,
 1342289165,
 -1,
 1342459918,
 1342312682,
 127201,
 -45051,
 1342380162,
 127219,
 -45050,
 1342445521,
 127218,
 -45049,
 1342510833,
 127217,
 -45048,
 1342576161,
 127216,
 -45047,
 1342641452,
 127215,
 -45046,
 1342706776,
 127214,
 -45045,
 1342772026,
 127213,
 -45044,
 1342837269,
 127212,
 -45043,
 1342902506,
 127211,
 -1,
 1342967773,
 127210,
 1343180817,
 1342378517,
 127202,
 -45040,
 1343099114,
 127221,
 -1,
 1343164381,
 127220,
 -45038,
 1343101058,
 127209,
 -45037,
 1343297489,
 127208,
 -45036,
 1343362801,
 127207,
 -45035,
 1343428129,
 127206,
 -45034,
 1343493420,
 127205,
 -45033,
 1343558744,
 127204,
 -1,
 1343623994,
 127203,
 1343836189,
 1342365868,
 -1,
 -45030,
 1343798744,
 127138,
 -45029,
 1343839027,
 127154,
 -45028,
 1343896363,
 127170,
 -1,
 1343959854,
 127186,
 1344163874,
 1343774822,
 -1,
 -45025,
 1344126424,
 127139,
 -45024,
 1344166707,
 127155,
 -45023,
 1344224043,
 127171,
 -1,
 1344287534,
 127187,
 1344536575,
 1344095859,
 -1,
 -45020,
 1344454104,
 127146,
 -45019,
 1344494387,
 127162,
 -45018,
 1344551723,
 127178,
 -1,
 1344615214,
 127194,
 1344819252,
 1342262503,
 -1,
 1344884783,
 1344770193,
 -1,
 1344950318,
 1344853045,
 -1,
 -45013,
 1344912856,
 127140,
 -45012,
 1344953139,
 127156,
 -45011,
 1345010475,
 127172,
 -1,
 1345073966,
 127188,
 -1,
 1344901860,
 127200,
 1345388543,
 1344826989,
 -1,
 -45007,
 1345306072,
 127141,
 -45006,
 1345346355,
 127157,
 -45005,
 1345403691,
 127173,
 -1,
 1345467182,
 127189,
 1345671231,
 1344779607,
 -1,
 1345736762,
 1345613538,
 -1,
 -45001,
 1345699288,
 127142,
 -45000,
 1345739571,
 127158,
 -44999,
 1345796907,
 127174,
 -1,
 1345860398,
 127190,
 1346109439,
 1345669889,
 -1,
 -44996,
 1346026968,
 127143,
 -44995,
 1346067251,
 127159,
 -44994,
 1346124587,
 127175,
 -1,
 1346188078,
 127191,
 1346392138,
 1345613963,
 -1,
 1346457669,
 1346342068,
 -1,
 -44990,
 1346420184,
 127148,
 -44989,
 1346460467,
 127164,
 -44988,
 1346517803,
 127180,
 -1,
 1346581294,
 127196,
 1346830335,
 1346398345,
 -1,
 -44985,
 1346747864,
 127150,
 -44984,
 1346788147,
 127166,
 -44983,
 1346845483,
 127182,
 -1,
 1346908974,
 127198,
 1347113039,
 1346349056,
 -1,
 -44980,
 1347075544,
 127149,
 -44979,
 1347115827,
 127165,
 -44978,
 1347173163,
 127181,
 -1,
 1347236654,
 127197,
 1347440724,
 1347063016,
 -1,
 -44975,
 1347403224,
 127145,
 -44974,
 1347443507,
 127161,
 -44973,
 1347500843,
 127177,
 -1,
 1347564334,
 127193,
 1347768409,
 1347383168,
 -1,
 -44970,
 1347730904,
 127147,
 -44969,
 1347771187,
 127163,
 -44968,
 1347828523,
 127179,
 -1,
 1347892014,
 127195,
 1348096094,
 1347700014,
 -1,
 -44965,
 1348058584,
 127144,
 -44964,
 1348098867,
 127160,
 -44963,
 1348156203,
 127176,
 -1,
 1348219694,
 127192,
 1348423779,
 1348016873,
 -1,
 -44960,
 1348386264,
 127137,
 -44959,
 1348426547,
 127153,
 -44958,
 1348483883,
 127169,
 -1,
 1348547374,
 127185,
 1348751462,
 1348347583,
 -1,
 -44955,
 1348695252,
 127183,
 -1,
 1348737781,
 127136,
 -44953,
 1348722039,
 127199,
 -1,
 1348906028,
 127167,
 -1,
 1342189292,
 128720,
 1349144689,
 1342164509,
 983150,
 1349255167,
 1349110037,
 -1,
 1349275758,
 1349173906,
 -1,
 -44947,
 1349246992,
 11219,
 -1,
 1349279697,
 11220,
 1349517311,
 1349209319,
 -1,
 -44944,
 1349425947,
 11221,
 -1,
 1349479968,
 11222,
 -1,
 1349072911,
 983147,
 1349734551,
 1342092902,
 -1,
 1349800072,
 1349679755,
 -1,
 1349865593,
 1349760343,
 -1,
 1349931128,
 1349785908,
 -1,
 -44937,
 1349878884,
 68493,
 -1,
 1349925562,
 68495,
 -1,
 1349868869,
 68496,
 1350193275,
 1349802677,
 68484,
 -1,
 1350157721,
 68487,
 -44932,
 1350166109,
 68486,
 -44931,
 1350296892,
 68488,
 -44930,
 1350360088,
 68485,
 -44929,
 1350419504,
 68497,
 -44928,
 1350475988,
 68494,
 -44927,
 1350537219,
 68492,
 -44926,
 1350599809,
 68491,
 -44925,
 1350661523,
 68490,
 -44924,
 1350725968,
 68489,
 -44923,
 1350784580,
 68482,
 -44922,
 1350842608,
 68483,
 -44921,
 1350904071,
 68481,
 -1,
 1350966918,
 68480,
 1351176338,
 1349750727,
 -1,
 1351241871,
 1351139986,
 -1,
 1351307405,
 1351211748,
 -1,
 -44916,
 1351258257,
 68522,
 -1,
 1351305145,
 68526,
 -44914,
 1351245777,
 68523,
 -1,
 1351435850,
 68525,
 1351635089,
 1351193775,
 68521,
 -1,
 1351549784,
 68527,
 -1,
 1351569695,
 68524,
 1351831701,
 1351111019,
 -1,
 -44908,
 1351760974,
 68508,
 -1,
 1351824901,
 68507,
 -44906,
 1351798023,
 68506,
 -1,
 1351989087,
 68505,
 1352159422,
 1349664963,
 -1,
 1352224945,
 1352116354,
 -1,
 1352290477,
 1352185175,
 -1,
 1352356012,
 1352242196,
 -1,
 1352421547,
 1352269824,
 -1,
 1352487075,
 1352392288,
 -1,
 1352552608,
 1352410815,
 -1,
 -44897,
 1352498677,
 128113,
 -1,
 1352539863,
 9977,
 -44895,
 1352508652,
 128590,
 -44894,
 1352686342,
 129493,
 -1,
 1352749185,
 128591,
 1352945830,
 1352427120,
 -1,
 -44891,
 1352908715,
 129494,
 -1,
 1352957616,
 129496,
 -44889,
 1352903106,
 128588,
 -44888,
 1353077357,
 128589,
 -44887,
 1353137185,
 129336,
 -44886,
 1353200287,
 129495,
 -1,
 1353264024,
 128583,
 -1,
 1352343076,
 128187,
 -1,
 1352289116,
 128547,
 -44882,
 1352245596,
 10178,
 -44881,
 1353548370,
 9854,
 -44880,
 1353601239,
 127917,
 -1,
 1353648363,
 8524,
 1353863350,
 1352173864,
 -1,
 -44877,
 1353827180,
 9956,
 -44876,
 1353890696,
 128532,
 -44875,
 1353930689,
 128039,
 -1,
 1353975428,
 128390,
 1354191036,
 1353783604,
 -1,
 1354256570,
 1354116324,
 -1,
 -44871,
 1354207574,
 129434,
 -1,
 1354258472,
 127825,
 -44869,
 1354213506,
 127824,
 -1,
 1354403877,
 129372,
 -44867,
 1354156698,
 129515,
 -1,
 1354513034,
 128694,
 1354715368,
 1352116354,
 -1,
 1354780885,
 1354645699,
 -1,
 1354846419,
 1354741679,
 -1,
 1354911942,
 1354805004,
 -1,
 1354977477,
 1354882435,
 -1,
 -44860,
 1354920436,
 65048,
 -1,
 1354969715,
 983256,
 -1,
 1354939990,
 65096,
 1355239625,
 1354856493,
 -1,
 -44856,
 1355210136,
 65047,
 -1,
 1355267670,
 65095,
 1355436236,
 1355178827,
 -1,
 -44853,
 1355371233,
 65042,
 -1,
 1355428793,
 65041,
 1355632847,
 1355363148,
 -1,
 -44850,
 1355581118,
 65040,
 -1,
 1355644401,
 65043,
 -44848,
 1355593628,
 65044,
 -44847,
 1355786279,
 65046,
 -44846,
 1355833063,
 65049,
 -1,
 1355893712,
 65045,
 -44844,
 1354812952,
 129384,
 -1,
 1356027574,
 129328,
 1356222692,
 1354719617,
 -1,
 1356288223,
 1356191246,
 -1,
 1356353758,
 1356252267,
 -1,
 1356419291,
 1356271206,
 -1,
 -44838,
 1356337685,
 983166,
 -1,
 1356402922,
 983163,
 1356660735,
 1356333056,
 -1,
 -44835,
 1356582234,
 983165,
 -1,
 1356633263,
 983162,
 -1,
 1356281851,
 983192,
 1356922879,
 1356237096,
 -1,
 1356943586,
 1356842267,
 128424,
 -1,
 1356858209,
 128438,
 1357119487,
 1356869337,
 129332,
 -1,
 1357037222,
 128120,
 1357205735,
 1356173457,
 -1,
 -44826,
 1357166626,
 11224,
 -1,
 1357208675,
 128711,
 -1,
 1357129376,
 128255,
 1357467914,
 1354666129,
 -1,
 1357533424,
 1357438114,
 -1,
 1357598957,
 1357493591,
 -1,
 -44820,
 1357571293,
 9211,
 -1,
 1357608939,
 9214,
 1357840383,
 1357550612,
 -1,
 -44817,
 1357713217,
 9212,
 -1,
 1357777240,
 9213,
 1357992182,
 1357499933,
 -1,
 1358057716,
 1357957260,
 -1,
 -44813,
 1357991231,
 128545,
 -1,
 1358048870,
 128574,
 -44811,
 1358004248,
 127831,
 -1,
 1358180217,
 128093,
 1358385403,
 1357955730,
 -1,
 1358450938,
 1358305588,
 -1,
 -44807,
 1358416139,
 129364,
 -1,
 1358441076,
 128688,
 -1,
 1358365978,
 127858,
 1358713088,
 1358345559,
 -1,
 1358778623,
 1358676626,
 -1,
 -44802,
 1358703526,
 128238,
 -1,
 1358765616,
 128239,
 -1,
 1358710019,
 11239,
 1359040772,
 1358658390,
 -1,
 1359106307,
 1358966326,
 128659,
 -1,
 1359066557,
 128680,
 -1,
 1359057407,
 128110,
 1359302919,
 1358995149,
 -1,
 -44794,
 1359230255,
 127871,
 -1,
 1359282780,
 8297,
 -44792,
 1359262845,
 128254,
 -44791,
 1359450564,
 128041,
 -1,
 1359491704,
 128425,
 1359696152,
 1357406593,
 -1,
 1359761679,
 1359631090,
 128022,
 1359871999,
 1359675392,
 -1,
 -44786,
 1359777342,
 128061,
 -1,
 1359826239,
 128055,
 1360023826,
 1359710926,
 -1,
 -44783,
 1359946219,
 127821,
 -1,
 1360003664,
 127885,
 1360220437,
 1359967308,
 -1,
 -44780,
 1360163916,
 128138,
 -1,
 1360216379,
 128169,
 -44778,
 1360183330,
 128299,
 -44777,
 1360347331,
 129383,
 -1,
 1360409118,
 9935,
 1360613666,
 1359662621,
 -1,
 1360679196,
 1360570498,
 -1,
 -44773,
 1360639801,
 128091,
 -1,
 1360700151,
 128156,
 -44771,
 1360642738,
 128686,
 -44770,
 1360837160,
 128204,
 -44769,
 1360890421,
 11854,
 -44768,
 1360931470,
 128226,
 -44767,
 1360990741,
 983167,
 -1,
 1361055978,
 983164,
 1361269029,
 1360541711,
 -1,
 -44764,
 1361207681,
 983233,
 -1,
 1361267943,
 983224,
 -1,
 1361215621,
 983193,
 1361531928,
 1305645201,
 -1,
 1361597248,
 1361474636,
 -1,
 1361662720,
 1361524751,
 -1,
 1361728252,
 1361575936,
 -1,
 1361793440,
 1361666360,
 -1,
 1361858913,
 1361755272,
 -1,
 1361924427,
 1361789123,
 68809,
 1361989938,
 1361873192,
 68825,
 1362055472,
 1361953426,
 68839,
 -1,
 1361973139,
 68849,
 -44751,
 1362027276,
 68826,
 -1,
 1362111716,
 68805,
 1362317621,
 1361915108,
 68804,
 -44748,
 1362277719,
 68806,
 -1,
 1362319400,
 68841,
 1362514231,
 1362290109,
 68847,
 -1,
 1362474327,
 68848,
 1362645305,
 1362477714,
 68838,
 -1,
 1362617100,
 68840,
 1362776379,
 1362605399,
 68836,
 -1,
 1362748861,
 68837,
 1362907453,
 1362722949,
 68824,
 -1,
 1362861773,
 68833,
 1363038527,
 1362850892,
 68822,
 -1,
 1363010316,
 68823,
 1363169601,
 1362973426,
 68813,
 -1,
 1363141388,
 68814,
 -44734,
 1363138040,
 68846,
 -44733,
 1363257474,
 68834,
 -44732,
 1363320525,
 68832,
 -44731,
 1363374219,
 68819,
 -44730,
 1363439455,
 68818,
 -44729,
 1363499048,
 68815,
 -44728,
 1363561703,
 68812,
 -44727,
 1363624131,
 68811,
 -44726,
 1363687439,
 68807,
 -1,
 1363748543,
 68802,
 1363956048,
 1361844532,
 68800,
 -44723,
 1363905097,
 68808,
 -44722,
 1363968802,
 68803,
 -44721,
 1364029579,
 68820,
 -1,
 1364072756,
 68801,
 1364283732,
 1363922461,
 68842,
 -44718,
 1364250141,
 68843,
 -44717,
 1364309335,
 68850,
 -1,
 1364364668,
 68821,
 1364545879,
 1364234385,
 68827,
 -44714,
 1364496529,
 68828,
 -1,
 1364542389,
 68831,
 1364742490,
 1364505808,
 -1,
 -44711,
 1364709464,
 68845,
 -1,
 1364758985,
 68830,
 1364939101,
 1364692172,
 -1,
 -44708,
 1364906072,
 68844,
 -1,
 1364955593,
 68829,
 1365135711,
 1364877697,
 68816,
 -1,
 1365074305,
 68817,
 -44704,
 1365096962,
 68835,
 -1,
 1365193390,
 68810,
 1365397911,
 1361784342,
 -1,
 1365463425,
 1365328067,
 68745,
 1365528936,
 1365412136,
 68761,
 1365594470,
 1365492370,
 68775,
 -1,
 1365512083,
 68785,
 -44697,
 1365566220,
 68762,
 -1,
 1365650660,
 68741,
 1365856619,
 1365454052,
 68740,
 -44694,
 1365816663,
 68742,
 -1,
 1365858344,
 68777,
 1366053229,
 1365829053,
 68783,
 -1,
 1366013271,
 68784,
 1366184303,
 1366016658,
 68774,
 -1,
 1366156044,
 68776,
 1366315377,
 1366144343,
 68772,
 -1,
 1366287805,
 68773,
 1366446451,
 1366261893,
 68760,
 -1,
 1366400717,
 68769,
 1366577525,
 1366389836,
 68758,
 -1,
 1366549260,
 68759,
 1366708599,
 1366512370,
 68749,
 -1,
 1366680332,
 68750,
 -44680,
 1366676984,
 68782,
 -44679,
 1366796418,
 68770,
 -44678,
 1366859469,
 68768,
 -44677,
 1366913163,
 68755,
 -44676,
 1366978399,
 68754,
 -44675,
 1367037992,
 68751,
 -44674,
 1367100647,
 68748,
 -44673,
 1367163075,
 68747,
 -44672,
 1367226383,
 68743,
 -1,
 1367287487,
 68738,
 1367495046,
 1365383476,
 68736,
 -44669,
 1367444041,
 68744,
 -44668,
 1367507746,
 68739,
 -44667,
 1367568523,
 68756,
 -1,
 1367611700,
 68737,
 1367822730,
 1367461405,
 68778,
 -44664,
 1367789085,
 68779,
 -44663,
 1367848279,
 68786,
 -1,
 1367903612,
 68757,
 1368084877,
 1367773329,
 68763,
 -44660,
 1368035473,
 68764,
 -1,
 1368081333,
 68767,
 1368281488,
 1368044752,
 -1,
 -44657,
 1368248408,
 68781,
 -1,
 1368297929,
 68766,
 1368478099,
 1368231116,
 -1,
 -44654,
 1368445016,
 68780,
 -1,
 1368494537,
 68765,
 1368674709,
 1368416641,
 68752,
 -1,
 1368613249,
 68753,
 -44650,
 1368635906,
 68771,
 -1,
 1368732334,
 68746,
 1368981503,
 1365348295,
 -1,
 1369002396,
 1368888495,
 68858,
 1369112575,
 1368915968,
 -1,
 -44645,
 1369032285,
 68863,
 -1,
 1369071879,
 68862,
 1369264543,
 1368936023,
 -1,
 -44642,
 1369233123,
 68859,
 -1,
 1369264854,
 68861,
 -1,
 1369228515,
 68860,
 1369526805,
 1361748393,
 -1,
 1369592294,
 1369486679,
 -1,
 1369657829,
 1369530963,
 -1,
 1369723356,
 1369619145,
 -1,
 1369788842,
 1369651215,
 -1,
 1369854376,
 1369708852,
 66477,
 1369964543,
 1369792882,
 66508,
 -1,
 1369837163,
 66509,
 -44631,
 1369820701,
 66479,
 -1,
 1369989505,
 66478,
 1370182062,
 1369708852,
 66464,
 1370292223,
 1370149958,
 66504,
 -44627,
 1370183742,
 66506,
 -1,
 1370230379,
 66505,
 1370444210,
 1370145426,
 -1,
 -44624,
 1370410525,
 66476,
 -44623,
 1370445886,
 66480,
 -1,
 1370495284,
 66475,
 1370706358,
 1370404183,
 -1,
 -44620,
 1370666497,
 66498,
 -44619,
 1370708030,
 66497,
 -1,
 1370757428,
 66495,
 1370968506,
 1370652805,
 -1,
 -44616,
 1370934813,
 66488,
 -44615,
 1370972545,
 66487,
 -1,
 1371019572,
 66486,
 1371230654,
 1370891967,
 -1,
 1371296189,
 1371150644,
 66482,
 -1,
 1371231041,
 66510,
 -1,
 1371264491,
 66511,
 1371492801,
 1371202049,
 -1,
 -44608,
 1371453619,
 66507,
 -1,
 1371478324,
 66471,
 1371689412,
 1371461112,
 -1,
 -44605,
 1371627905,
 66491,
 -1,
 1371674932,
 66490,
 1371886023,
 1371646082,
 -1,
 -44602,
 1371852317,
 66493,
 -1,
 1371871540,
 66492,
 1372082634,
 1371834664,
 -1,
 -44599,
 1372048925,
 66485,
 -1,
 1372068148,
 66484,
 1372279245,
 1372024971,
 -1,
 -44596,
 1372245533,
 66468,
 -1,
 1372264756,
 66467,
 1372475856,
 1372221279,
 -1,
 -44593,
 1372414337,
 66474,
 -1,
 1372461364,
 66473,
 1372672467,
 1372410610,
 -1,
 -44590,
 1372638749,
 66470,
 -1,
 1372657972,
 66469,
 -44588,
 1372644813,
 66496,
 -44587,
 1372840820,
 66489,
 -44586,
 1372900893,
 66466,
 -44585,
 1372954409,
 66481,
 -44584,
 1373009046,
 66494,
 -44583,
 1373069697,
 66465,
 -44582,
 1373132862,
 66499,
 -44581,
 1373195580,
 66483,
 -1,
 1373252891,
 66472,
 1373458916,
 1369673671,
 -1,
 1373524450,
 1373422226,
 -1,
 1373589985,
 1373493988,
 -1,
 -44576,
 1373540497,
 66514,
 -1,
 1373587385,
 66516,
 -1,
 1373521482,
 66515,
 -44573,
 1373476015,
 66513,
 -1,
 1373790471,
 66517,
 -1,
 1373430116,
 66512,
 -1,
 1369609372,
 128435,
 1374158847,
 1369539852,
 -1,
 1374179823,
 1374085900,
 -1,
 1374245355,
 1374111870,
 66415,
 -44566,
 1374211613,
 66408,
 -1,
 1374249345,
 66416,
 1374441965,
 1374165300,
 66420,
 -1,
 1374405266,
 66417,
 -44562,
 1374408221,
 66419,
 -1,
 1374532910,
 66407,
 1374704116,
 1374139735,
 -1,
 1374769651,
 1374640168,
 -1,
 -44558,
 1374721679,
 66405,
 -1,
 1374761092,
 66406,
 -1,
 1374709131,
 66401,
 1375031799,
 1374642561,
 66393,
 -44554,
 1374961859,
 66418,
 -1,
 1375017268,
 66421,
 1375228412,
 1374959631,
 -1,
 1375293947,
 1375200701,
 -1,
 -44550,
 1375235426,
 66392,
 -1,
 1375297084,
 66390,
 -1,
 1375244909,
 66387,
 1375556095,
 1375200701,
 -1,
 -44546,
 1375493692,
 66389,
 -1,
 1375544524,
 66391,
 1375752706,
 1375524344,
 -1,
 -44543,
 1375704719,
 66398,
 -1,
 1375750270,
 66414,
 1375949317,
 1375715986,
 -1,
 -44540,
 1375910788,
 66413,
 -1,
 1375935770,
 66402,
 1376145927,
 1375899793,
 66409,
 -1,
 1376096401,
 66410,
 1376277001,
 1376075971,
 66388,
 -1,
 1376210151,
 66411,
 -44534,
 1376243229,
 66403,
 -44533,
 1376365755,
 66400,
 -44532,
 1376428298,
 66399,
 -44531,
 1376488315,
 66397,
 -44530,
 1376552100,
 66396,
 -44529,
 1376614948,
 66395,
 -44528,
 1376678772,
 66394,
 -44527,
 1376737342,
 66412,
 -44526,
 1376801703,
 66386,
 -44525,
 1376858177,
 66404,
 -44524,
 1376922750,
 66385,
 -1,
 1376985016,
 66384,
 1377194598,
 1369492634,
 -1,
 1377260100,
 1377147134,
 -1,
 1377325614,
 1377179956,
 68608,
 1377391139,
 1377255619,
 -1,
 -44518,
 1377362700,
 68632,
 -44517,
 1377419922,
 68677,
 -44516,
 1377482071,
 68670,
 -44515,
 1377544322,
 68668,
 -44514,
 1377601832,
 68644,
 -44513,
 1377662028,
 68640,
 -44512,
 1377726603,
 68634,
 -44511,
 1377784562,
 68623,
 -44510,
 1377843215,
 68627,
 -1,
 1377904319,
 68619,
 1378112037,
 1377350999,
 68669,
 -1,
 1378048040,
 68671,
 -44506,
 1378083596,
 68630,
 -44505,
 1378206354,
 68675,
 -44504,
 1378265218,
 68666,
 -44503,
 1378330322,
 68660,
 -44502,
 1378388264,
 68643,
 -44501,
 1378448460,
 68638,
 -44500,
 1378505458,
 68621,
 -44499,
 1378564111,
 68625,
 -1,
 1378625215,
 68617,
 1378832954,
 1377255619,
 -1,
 1378898484,
 1378781480,
 -1,
 -44495,
 1378870028,
 68650,
 -44494,
 1378927250,
 68646,
 -44493,
 1378964210,
 68653,
 -1,
 1379020004,
 68648,
 -44491,
 1378870717,
 68628,
 -44490,
 1379186783,
 68673,
 -44489,
 1379245773,
 68655,
 -44488,
 1379303557,
 68642,
 -44487,
 1379368902,
 68641,
 -1,
 1379413220,
 68658,
 1379619392,
 1378783377,
 68614,
 1379684925,
 1379549379,
 68615,
 -1,
 1379627147,
 68636,
 -44482,
 1379648146,
 68679,
 -44481,
 1379772114,
 68664,
 -1,
 1379835597,
 68656,
 1380012611,
 1379557761,
 68611,
 -44478,
 1379968722,
 68662,
 -1,
 1380003044,
 68657,
 -1,
 1379936304,
 68680,
 1380319231,
 1377231936,
 -1,
 1380340312,
 1380194612,
 68609,
 1380405838,
 1380270275,
 68610,
 1380471369,
 1380354344,
 68645,
 -1,
 1380406002,
 68654,
 -44470,
 1380442892,
 68633,
 -44469,
 1380565650,
 68678,
 -44468,
 1380610187,
 68635,
 -44467,
 1380668146,
 68624,
 -1,
 1380722367,
 68620,
 -44465,
 1380377356,
 68631,
 -44464,
 1380893330,
 68676,
 -44463,
 1380956255,
 68672,
 -44462,
 1381017730,
 68667,
 -44461,
 1381082834,
 68661,
 -44460,
 1381141500,
 68652,
 -44459,
 1381200972,
 68639,
 -44458,
 1381257970,
 68622,
 -44457,
 1381316623,
 68626,
 -1,
 1381377727,
 68618,
 1381585504,
 1380270275,
 68613,
 1381651037,
 1381533992,
 -1,
 -44453,
 1381622540,
 68651,
 -44452,
 1381679762,
 68647,
 -1,
 1381706980,
 68649,
 -44450,
 1381623229,
 68629,
 -44449,
 1381873759,
 68674,
 -1,
 1381903588,
 68659,
 1382109796,
 1381535889,
 -1,
 1382175331,
 1382039747,
 68616,
 -1,
 1382117515,
 68637,
 -1,
 1382131410,
 68665,
 1382416383,
 1382048129,
 68612,
 -1,
 1382328018,
 68663,
 1382503113,
 1377156447,
 -1,
 1382568604,
 1382438027,
 -1,
 1382634125,
 1382511692,
 -1,
 1382699660,
 1382566433,
 -1,
 1382765172,
 1382633092,
 -1,
 1382830701,
 1382728752,
 69403,
 -1,
 1382747686,
 69404,
 1382961775,
 1382790688,
 69398,
 -1,
 1382878758,
 69399,
 1383092849,
 1382912003,
 69391,
 -1,
 1383009830,
 69392,
 -44430,
 1383029429,
 69382,
 -44429,
 1383147783,
 69379,
 -1,
 1383210630,
 69377,
 1383420537,
 1382724951,
 -1,
 1383486072,
 1383340340,
 -1,
 -44425,
 1383433316,
 69393,
 -1,
 1383479994,
 69397,
 -1,
 1383423301,
 69401,
 1383748222,
 1383340340,
 -1,
 1383813757,
 1383691340,
 -1,
 -44420,
 1383777613,
 69395,
 -1,
 1383811114,
 69376,
 -1,
 1383785616,
 69394,
 1384075904,
 1383684789,
 69381,
 -1,
 1384039833,
 69385,
 -44415,
 1384048221,
 69384,
 -44414,
 1384179004,
 69386,
 -44413,
 1384242186,
 69383,
 -44412,
 1384301616,
 69402,
 -44411,
 1384361309,
 69400,
 -44410,
 1384423636,
 69396,
 -44409,
 1384484867,
 69390,
 -44408,
 1384547453,
 69389,
 -44407,
 1384609171,
 69388,
 -44406,
 1384673616,
 69387,
 -44405,
 1384732228,
 69380,
 -1,
 1384786183,
 69378,
 -1,
 1382638614,
 69415,
 1385058971,
 1382584263,
 -1,
 1385124502,
 1385022098,
 -1,
 1385190034,
 1385093860,
 -1,
 -44399,
 1385140369,
 69406,
 -1,
 1385187257,
 69411,
 1385386645,
 1385125928,
 -1,
 -44396,
 1385344091,
 69407,
 -1,
 1385393276,
 69412,
 -1,
 1385317962,
 69410,
 1385648792,
 1385075887,
 69405,
 -1,
 1385562968,
 69413,
 1385824255,
 1385581799,
 -1,
 -44390,
 1385732891,
 69408,
 -1,
 1385786912,
 69409,
 -1,
 1384993286,
 69414,
 1386086399,
 1382536611,
 -1,
 1386107588,
 1385986699,
 -1,
 1386173092,
 1386070674,
 -1,
 1386238626,
 1386108968,
 -1,
 -44383,
 1386170876,
 68220,
 -1,
 1386227305,
 68219,
 -44381,
 1386170876,
 68215,
 -1,
 1386358377,
 68201,
 1386566314,
 1386132823,
 -1,
 1386631849,
 1386486068,
 -1,
 -44377,
 1386594962,
 68202,
 -44376,
 1386644580,
 68207,
 -1,
 1386691258,
 68206,
 -1,
 1386569029,
 68198,
 1386959535,
 1386493967,
 -1,
 1387025070,
 1386895422,
 -1,
 -44371,
 1386969715,
 68217,
 -1,
 1387018938,
 68211,
 -1,
 1386946188,
 68213,
 1387287218,
 1386901643,
 -1,
 -44367,
 1387224068,
 68205,
 -1,
 1387274690,
 68203,
 1387483828,
 1387223733,
 68192,
 -1,
 1387447705,
 68194,
 1387614903,
 1387418354,
 -1,
 -44362,
 1387554333,
 68212,
 -1,
 1387616941,
 68214,
 1387811514,
 1387534644,
 -1,
 -44359,
 1387783449,
 68210,
 -1,
 1387821053,
 68209,
 -44357,
 1387783779,
 68216,
 -44356,
 1387980092,
 68218,
 -44355,
 1388043274,
 68197,
 -44354,
 1388096835,
 68199,
 -44353,
 1388160835,
 68196,
 -44352,
 1388220419,
 68204,
 -44351,
 1388283005,
 68195,
 -44350,
 1388344723,
 68193,
 -44349,
 1388400034,
 68208,
 -1,
 1388456199,
 68200,
 1388707839,
 1386057667,
 -1,
 1388729032,
 1388587215,
 -1,
 -44345,
 1388680367,
 68221,
 -1,
 1388727904,
 68222,
 -1,
 1388660986,
 68223,
 1388991222,
 1382452770,
 -1,
 1389056753,
 1388935819,
 -1,
 1389122257,
 1389019794,
 -1,
 1389187791,
 1389058088,
 -1,
 -44338,
 1389118650,
 68251,
 -1,
 1389174305,
 68249,
 -44336,
 1389118650,
 68233,
 -1,
 1389305065,
 68247,
 1389515477,
 1389054348,
 -1,
 -44333,
 1389433658,
 68239,
 -44332,
 1389498901,
 68230,
 -1,
 1389564138,
 68234,
 1389777624,
 1389487565,
 -1,
 -44329,
 1389717101,
 68248,
 -1,
 1389778984,
 68252,
 1389974235,
 1389719691,
 -1,
 -44326,
 1389910133,
 68237,
 -1,
 1389960279,
 68235,
 1390170846,
 1389910056,
 -1,
 -44323,
 1390101690,
 68224,
 -1,
 1390157033,
 68226,
 1390367457,
 1390105330,
 -1,
 -44320,
 1390303380,
 68246,
 -1,
 1390363627,
 68244,
 1390564068,
 1390295198,
 -1,
 -44317,
 1390507084,
 68245,
 -1,
 1390557199,
 68243,
 1390760679,
 1390483764,
 -1,
 -44314,
 1390704637,
 68241,
 -1,
 1390765677,
 68242,
 -44312,
 1390732301,
 68250,
 -44311,
 1390926858,
 68229,
 -44310,
 1390982684,
 68238,
 -44309,
 1391045815,
 68231,
 -44308,
 1391109881,
 68228,
 -44307,
 1391168980,
 68236,
 -44306,
 1391232052,
 68227,
 -44305,
 1391293818,
 68225,
 -44304,
 1391349197,
 68240,
 -1,
 1391405203,
 68232,
 1391656959,
 1389006791,
 -1,
 1391678197,
 1391575698,
 -1,
 -44300,
 1391647874,
 68255,
 -1,
 1391674954,
 68254,
 -1,
 1391629487,
 68253,
 1391940347,
 1388932478,
 -1,
 -44296,
 1391911926,
 66349,
 -44295,
 1391967680,
 66351,
 -44294,
 1392021041,
 66350,
 -1,
 1392069052,
 66335,
 -1,
 1391882850,
 128477,
 1392377855,
 1361660033,
 -1,
 -44290,
 1392304454,
 128117,
 -44289,
 1392345627,
 128116,
 -1,
 1392384980,
 129491,
 1392639999,
 1361576406,
 -1,
 1392661287,
 1392540299,
 -1,
 1392726796,
 1392580916,
 -1,
 1392792328,
 1392646452,
 -1,
 -44283,
 1392761572,
 7267,
 -44282,
 1392803973,
 7266,
 -44281,
 1392865419,
 7264,
 -1,
 1392930655,
 7265,
 -44279,
 1392755346,
 7259,
 -44278,
 1393069052,
 7261,
 -44277,
 1393128524,
 7262,
 -1,
 1393185522,
 7260,
 1393382163,
 1392669772,
 -1,
 1393447695,
 1393301812,
 7258,
 -1,
 1393367348,
 7263,
 -44272,
 1393413661,
 7273,
 -44271,
 1393528977,
 7283,
 -44270,
 1393582465,
 7268,
 -1,
 1393639619,
 7278,
 1393840920,
 1393348125,
 -1,
 -44267,
 1393812236,
 7277,
 -44266,
 1393855885,
 7276,
 -44265,
 1393899535,
 7275,
 -1,
 1393962212,
 7274,
 1394168605,
 1393791121,
 -1,
 -44262,
 1394136568,
 7286,
 -44261,
 1394199544,
 7284,
 -44260,
 1394235432,
 7287,
 -1,
 1394288319,
 7285,
 1394496290,
 1394106753,
 -1,
 -44257,
 1394455895,
 7269,
 -44256,
 1394518146,
 7272,
 -44255,
 1394577465,
 7271,
 -1,
 1394628648,
 7270,
 1394868223,
 1394426051,
 -1,
 -44252,
 1394783268,
 7282,
 -44251,
 1394843341,
 7279,
 -44250,
 1394903336,
 7281,
 -1,
 1394948441,
 7280,
 1395151669,
 1392589662,
 -1,
 1395217195,
 1395114642,
 -1,
 -44246,
 1395187728,
 7250,
 -1,
 1395220433,
 7251,
 1395413806,
 1395176791,
 -1,
 -44243,
 1395355346,
 7254,
 -1,
 1395411691,
 7255,
 1395610417,
 1395346663,
 -1,
 -44240,
 1395563291,
 7252,
 -1,
 1395617312,
 7253,
 -44238,
 1395582602,
 7248,
 -44237,
 1395758255,
 7249,
 -44236,
 1395821784,
 7257,
 -1,
 1395868941,
 7256,
 1396069178,
 1395105485,
 -1,
 1396134713,
 1396036020,
 -1,
 -44232,
 1396082781,
 7294,
 -1,
 1396129348,
 7295,
 -1,
 1396070487,
 7292,
 1396396861,
 1396017237,
 -1,
 -44228,
 1396313788,
 7290,
 -1,
 1396378361,
 7288,
 -44226,
 1396354239,
 7291,
 -44225,
 1396527944,
 7289,
 -1,
 1396579596,
 7293,
 1396790222,
 1361556823,
 -1,
 1396855708,
 1396710560,
 -1,
 1396921199,
 1396817032,
 -1,
 1396986700,
 1396850883,
 66783,
 1397052235,
 1396922408,
 -1,
 1397117768,
 1397015186,
 -1,
 -44217,
 1397077505,
 66803,
 -1,
 1397102900,
 66801,
 -44215,
 1397071657,
 66797,
 -44214,
 1397256413,
 66789,
 -1,
 1397305252,
 66782,
 -1,
 1396991597,
 66784,
 1397576528,
 1396906292,
 66776,
 1397642063,
 1397514625,
 66777,
 -1,
 1397590312,
 66778,
 -1,
 1397577768,
 66779,
 1397838677,
 1397539474,
 -1,
 1397904212,
 1397798231,
 -1,
 -44205,
 1397839934,
 66804,
 -1,
 1397889332,
 66802,
 -1,
 1397823796,
 66800,
 1398166361,
 1397780619,
 -1,
 -44201,
 1398137716,
 66790,
 -44200,
 1398167614,
 66808,
 -1,
 1398217012,
 66788,
 1398428508,
 1398138301,
 -1,
 -44197,
 1398364222,
 66811,
 -1,
 1398413620,
 66810,
 1398625119,
 1398388055,
 -1,
 -44194,
 1398560830,
 66799,
 -1,
 1398610228,
 66798,
 1398821729,
 1398575249,
 66794,
 -1,
 1398761069,
 66795,
 1398952804,
 1398757416,
 -1,
 -44189,
 1398924148,
 66786,
 -1,
 1398937908,
 66785,
 -44187,
 1398922020,
 66807,
 -44186,
 1399115293,
 66806,
 -44185,
 1399168809,
 66796,
 -44184,
 1399228786,
 66793,
 -44183,
 1399292123,
 66792,
 -44182,
 1399354518,
 66791,
 -44181,
 1399415169,
 66787,
 -44180,
 1399477619,
 66809,
 -44179,
 1399536296,
 66805,
 -44178,
 1399599012,
 66781,
 -1,
 1399663542,
 66780,
 1399914495,
 1396846102,
 -1,
 1399935865,
 1399800003,
 66743,
 1400001400,
 1399871528,
 -1,
 1400066933,
 1399964306,
 -1,
 -44172,
 1400026625,
 66763,
 -1,
 1400052020,
 66761,
 -44170,
 1400020777,
 66757,
 -44169,
 1400205533,
 66749,
 -1,
 1400254372,
 66742,
 -1,
 1399940717,
 66744,
 1400525693,
 1399855412,
 66736,
 1400591228,
 1400463745,
 66737,
 -1,
 1400539432,
 66738,
 -1,
 1400526888,
 66739,
 1400787842,
 1400488594,
 -1,
 1400853377,
 1400747351,
 -1,
 -44160,
 1400789054,
 66764,
 -1,
 1400838452,
 66762,
 -1,
 1400772916,
 66760,
 1401115526,
 1400729739,
 -1,
 -44156,
 1401086836,
 66750,
 -44155,
 1401116734,
 66768,
 -1,
 1401166132,
 66748,
 1401377673,
 1401087421,
 -1,
 -44152,
 1401313342,
 66771,
 -1,
 1401362740,
 66770,
 1401574284,
 1401337175,
 -1,
 -44149,
 1401509950,
 66759,
 -1,
 1401559348,
 66758,
 1401770894,
 1401524369,
 66754,
 -1,
 1401710189,
 66755,
 1401901969,
 1401706536,
 -1,
 -44144,
 1401873268,
 66746,
 -1,
 1401887028,
 66745,
 -44142,
 1401871140,
 66767,
 -44141,
 1402064413,
 66766,
 -44140,
 1402117929,
 66756,
 -44139,
 1402177906,
 66753,
 -44138,
 1402241243,
 66752,
 -44137,
 1402303638,
 66751,
 -44136,
 1402364289,
 66747,
 -44135,
 1402426739,
 66769,
 -44134,
 1402485416,
 66765,
 -44133,
 1402548132,
 66741,
 -1,
 1402612662,
 66740,
 1402819533,
 1396802157,
 -1,
 1402885055,
 1402763915,
 -1,
 1402950561,
 1402804532,
 66710,
 -44128,
 1402894333,
 66688,
 -1,
 1402935604,
 66715,
 1403147172,
 1402910039,
 -1,
 -44125,
 1403084056,
 66697,
 -1,
 1403132212,
 66696,
 1403343782,
 1403097233,
 66713,
 -1,
 1403293841,
 66717,
 1403474857,
 1403285643,
 -1,
 -44120,
 1403410494,
 66693,
 -1,
 1403460079,
 66703,
 1403671467,
 1403404483,
 66711,
 -1,
 1403601091,
 66716,
 1403802542,
 1403598863,
 -1,
 -44115,
 1403738174,
 66698,
 -1,
 1403798487,
 66694,
 -44113,
 1403773812,
 66709,
 -44112,
 1403970084,
 66692,
 -44111,
 1404034058,
 66707,
 -44110,
 1404096029,
 66714,
 -44109,
 1404158744,
 66690,
 -44108,
 1404217589,
 66695,
 -44107,
 1404282612,
 66702,
 -44106,
 1404342314,
 66706,
 -44105,
 1404405223,
 66705,
 -44104,
 1404466347,
 66704,
 -44103,
 1404530557,
 66691,
 -44102,
 1404592513,
 66712,
 -44101,
 1404655678,
 66708,
 -44100,
 1404719937,
 66700,
 -44099,
 1404783932,
 66701,
 -44098,
 1404841657,
 66699,
 -1,
 1404905204,
 66689,
 1405157375,
 1402813278,
 -1,
 1405178819,
 1405076114,
 -1,
 -44094,
 1405149200,
 66722,
 -1,
 1405181905,
 66723,
 1405375430,
 1405138263,
 -1,
 -44091,
 1405316818,
 66726,
 -1,
 1405373163,
 66727,
 1405572041,
 1405308135,
 -1,
 -44088,
 1405524763,
 66724,
 -1,
 1405578784,
 66725,
 -44086,
 1405544074,
 66720,
 -44085,
 1405719727,
 66721,
 -44084,
 1405783256,
 66729,
 -1,
 1405830413,
 66728,
 -1,
 1402744036,
 983191,
 1406096356,
 1396746370,
 -1,
 1406161888,
 1406037819,
 -1,
 1406227417,
 1406095852,
 -1,
 1406292950,
 1406178483,
 -1,
 -44077,
 1406253997,
 2933,
 -44076,
 1406314410,
 2930,
 -44075,
 1406359770,
 2931,
 -1,
 1406420302,
 2934,
 1406664703,
 1406256777,
 -1,
 -44072,
 1406581687,
 2935,
 -1,
 1406642153,
 2932,
 1406817245,
 1406196362,
 -1,
 1406882780,
 1406760012,
 2914,
 -1,
 1406825548,
 2915,
 -1,
 1406841892,
 2884,
 1407123455,
 1406761611,
 -1,
 -44065,
 1407048484,
 2929,
 -1,
 1407112718,
 2869,
 1407276003,
 1406083279,
 -1,
 -44062,
 1407212315,
 129505,
 -1,
 1407265594,
 128217,
 -1,
 1407192050,
 10183,
 1407538167,
 1406049997,
 -1,
 1407603700,
 1407467715,
 -1,
 1407669235,
 1407551786,
 -1,
 1407734762,
 1407631720,
 -1,
 -44055,
 1407689197,
 10180,
 -1,
 1407724594,
 10179,
 1407931373,
 1407680860,
 -1,
 -44052,
 1407887743,
 128236,
 -1,
 1407942537,
 128237,
 1408127984,
 1407864039,
 -1,
 -44049,
 1408078654,
 128449,
 -1,
 1408132571,
 128194,
 -44047,
 1408073177,
 128275,
 -44046,
 1408260594,
 128080,
 -1,
 1408314170,
 128214,
 -1,
 1407625844,
 983190,
 1408586742,
 1407567739,
 128191,
 -1,
 1408500577,
 128440,
 -1,
 1408523726,
 9934,
 1408783362,
 1407486248,
 -1,
 1408848894,
 1408709553,
 -1,
 -44038,
 1408812089,
 128662,
 -44037,
 1408869499,
 128660,
 -44036,
 1408913220,
 128753,
 -44035,
 1408969865,
 128653,
 -1,
 1409033750,
 128664,
 1409242113,
 1408778437,
 -1,
 -44032,
 1409170605,
 11819,
 -1,
 1409232063,
 128431,
 -1,
 1409158206,
 128283,
 1409504266,
 1408751487,
 -1,
 1409569801,
 1409447378,
 128471,
 1409679359,
 1409524371,
 -1,
 1409700872,
 1409604867,
 -1,
 -44025,
 1409662600,
 11194,
 -1,
 1409687549,
 11195,
 -1,
 1409624654,
 11196,
 -1,
 1409506106,
 129397,
 1410028557,
 1409471884,
 -1,
 -44020,
 1409973365,
 9885,
 -1,
 1410018218,
 128228,
 1410225168,
 1409955595,
 -1,
 -44017,
 1410177088,
 128025,
 -1,
 1410211030,
 128721,
 -44015,
 1410195969,
 128002,
 -44014,
 1410391989,
 129417,
 -44013,
 1410433231,
 128329,
 -44012,
 1410494618,
 128076,
 -44011,
 1410557347,
 128738,
 -44010,
 1410616846,
 127970,
 -44009,
 1410677230,
 127842,
 -1,
 1410739231,
 9215,
 1410946825,
 1361466098,
 -1,
 1411011964,
 1410902146,
 -1,
 1411077384,
 1410941877,
 -1,
 1411142915,
 1411018893,
 -1,
 1411208304,
 1411062068,
 -1,
 1411273837,
 1411134970,
 -1,
 1411339331,
 1411196321,
 -1,
 1411404850,
 1411272279,
 -1,
 1411470379,
 1411372771,
 65859,
 1411579903,
 1411383296,
 -1,
 1411601446,
 1411498642,
 -1,
 1411666981,
 1411538838,
 65862,
 -1,
 1411582333,
 65870,
 -1,
 1411587711,
 65864,
 1411863594,
 1411539207,
 65861,
 1411973119,
 1411776512,
 -1,
 -43991,
 1411892159,
 65868,
 -1,
 1411956643,
 65875,
 -1,
 1411825571,
 65871,
 1412235263,
 1411404502,
 65860,
 1412300799,
 1412104192,
 -1,
 1412322353,
 1412219538,
 -1,
 1412387888,
 1412259734,
 65863,
 -1,
 1412303167,
 65878,
 -1,
 1412308607,
 65866,
 -1,
 1412284323,
 65873,
 1412650045,
 1411355827,
 -1,
 1412715576,
 1412585512,
 -1,
 1412781111,
 1412682241,
 -1,
 -43978,
 1412744127,
 65867,
 -1,
 1412808611,
 65874,
 -1,
 1412701851,
 65857,
 1413043259,
 1412679270,
 -1,
 -43974,
 1413006271,
 65869,
 -1,
 1413070755,
 65876,
 -43972,
 1412999082,
 65856,
 -1,
 1413169123,
 65858,
 1413414911,
 1412613351,
 -1,
 1413436481,
 1413333650,
 -1,
 -43968,
 1413373876,
 65877,
 -1,
 1413422719,
 65865,
 -43966,
 1413398435,
 65872,
 -1,
 1413580500,
 65879,
 1413764188,
 1411302034,
 -1,
 1413829716,
 1413700598,
 -1,
 1413895243,
 1413792402,
 -1,
 1413960777,
 1413830696,
 -1,
 -43960,
 1413917791,
 65899,
 -1,
 1413966972,
 65893,
 -43958,
 1413931024,
 65884,
 -1,
 1414088266,
 65892,
 1414288463,
 1413846191,
 65881,
 1414397951,
 1414201344,
 -1,
 -43954,
 1414317661,
 65905,
 -1,
 1414357255,
 65898,
 1414594559,
 1414221399,
 -1,
 1414616147,
 1414518502,
 -1,
 -43950,
 1414579805,
 65906,
 -1,
 1414619399,
 65902,
 -1,
 1414550230,
 65897,
 1414922239,
 1413788458,
 -1,
 1414943834,
 1414811223,
 -1,
 1415009368,
 1414911715,
 65887,
 -1,
 1414923096,
 65901,
 1415184383,
 1414943446,
 65894,
 -1,
 1415053345,
 65895,
 1415315455,
 1414907107,
 65888,
 -1,
 1415184417,
 65889,
 1415402594,
 1413700545,
 -1,
 1415468129,
 1415349901,
 -1,
 -43937,
 1415431395,
 65890,
 -43936,
 1415484591,
 65882,
 -1,
 1415532128,
 65896,
 -1,
 1415388229,
 65880,
 1415795814,
 1415333939,
 -1,
 1415861349,
 1415761242,
 65883,
 -1,
 1415774881,
 65886,
 -1,
 1415794589,
 65900,
 1416057961,
 1415720164,
 -1,
 -43928,
 1416029576,
 65885,
 -1,
 1416045569,
 65903,
 -43926,
 1416020131,
 65908,
 -43925,
 1416202755,
 65904,
 -43924,
 1416266955,
 65891,
 -1,
 1416313303,
 65907,
 1416560639,
 1411229826,
 -1,
 -43921,
 1416479556,
 65926,
 -1,
 1416534949,
 65927,
 1416713369,
 1411147373,
 -1,
 1416778904,
 1416675639,
 -1,
 1416844410,
 1416696920,
 119327,
 -43916,
 1416763522,
 119356,
 -43915,
 1416828881,
 119355,
 -43914,
 1416894193,
 119354,
 -43913,
 1416959276,
 119353,
 -43912,
 1417024314,
 119352,
 -43911,
 1417089557,
 119351,
 -1,
 1417154525,
 119350,
 1417368706,
 1416761578,
 119325,
 -43908,
 1417287810,
 119337,
 -43907,
 1417353169,
 119336,
 -43906,
 1417418481,
 119335,
 -43905,
 1417483352,
 119334,
 -43904,
 1417548602,
 119333,
 -43903,
 1417613845,
 119332,
 -1,
 1417679082,
 119331,
 1417893001,
 1417286165,
 119326,
 -43900,
 1417812098,
 119343,
 -43899,
 1417877233,
 119342,
 -43898,
 1417942561,
 119341,
 -43897,
 1418007852,
 119340,
 -43896,
 1418073176,
 119339,
 -1,
 1418138426,
 119338,
 1418351759,
 1417811244,
 119328,
 -43893,
 1418269784,
 119361,
 -43892,
 1418335034,
 119360,
 -43891,
 1418400277,
 119359,
 -43890,
 1418465514,
 119358,
 -1,
 1418530781,
 119357,
 1418744982,
 1418269498,
 -1,
 -43887,
 1418664066,
 119349,
 -43886,
 1418729425,
 119348,
 -43885,
 1418794737,
 119347,
 -43884,
 1418860065,
 119346,
 -43883,
 1418924565,
 119345,
 -1,
 1418989533,
 119344,
 -43881,
 1418663889,
 119330,
 -1,
 1419122417,
 119329,
 -1,
 1416706897,
 65933,
 1419400375,
 1416681843,
 -1,
 1419465893,
 1419317482,
 119296,
 -43876,
 1419384962,
 119314,
 -43875,
 1419450321,
 119313,
 -43874,
 1419515633,
 119312,
 -43873,
 1419580961,
 119311,
 -43872,
 1419646252,
 119310,
 -43871,
 1419711576,
 119309,
 -43870,
 1419776826,
 119308,
 -43869,
 1419842069,
 119307,
 -43868,
 1419907306,
 119306,
 -1,
 1419972573,
 119305,
 1420186795,
 1419384108,
 119300,
 -43865,
 1420104792,
 119324,
 -43864,
 1420170042,
 119323,
 -43863,
 1420235285,
 119322,
 -43862,
 1420300522,
 119321,
 -1,
 1420365789,
 119320,
 1420580017,
 1420104213,
 119297,
 -43859,
 1420498008,
 119319,
 -43858,
 1420563258,
 119318,
 -43857,
 1420628501,
 119317,
 -43856,
 1420693738,
 119316,
 -1,
 1420759005,
 119315,
 -43854,
 1420499074,
 119304,
 -43853,
 1420892113,
 119303,
 -43852,
 1420957425,
 119302,
 -43851,
 1421022753,
 119301,
 -43850,
 1421087832,
 119299,
 -1,
 1421153082,
 119298,
 1421366476,
 1419359575,
 -1,
 1421432004,
 1421312443,
 -1,
 1421497536,
 1421376139,
 -1,
 1421563069,
 1421456727,
 -1,
 -43844,
 1421499928,
 1016,
 -1,
 1421549496,
 1019,
 -43842,
 1421516708,
 887,
 -43841,
 1421695999,
 881,
 -1,
 1421746796,
 883,
 1421956291,
 1421454794,
 -1,
 -43838,
 1421901910,
 891,
 -1,
 1421950246,
 893,
 -1,
 1421884710,
 892,
 1422218442,
 1421397980,
 -1,
 -43834,
 1422175809,
 7528,
 -43833,
 1422238239,
 7529,
 -43832,
 1422283717,
 7527,
 -43831,
 1422340173,
 7530,
 -1,
 1422403835,
 7526,
 -43829,
 1422189826,
 65952,
 -1,
 1422551667,
 65932,
 1422742748,
 1421290995,
 -1,
 1422808279,
 1422685260,
 -1,
 1422873814,
 1422740001,
 -1,
 1422939346,
 1422832983,
 -1,
 -43823,
 1422876184,
 1015,
 -1,
 1422925752,
 1018,
 -43821,
 1422910792,
 895,
 -43820,
 1423089572,
 886,
 -43819,
 1423137791,
 880,
 -1,
 1423188588,
 882,
 -1,
 1422840201,
 1017,
 1423463642,
 1422765514,
 -1,
 -43815,
 1423409238,
 1021,
 -1,
 1423457574,
 1023,
 -43813,
 1423405349,
 975,
 -1,
 1423588646,
 1022,
 1423791334,
 1422685260,
 -1,
 1423856869,
 1423723048,
 -1,
 1423922401,
 1423810253,
 -1,
 -43808,
 1423882836,
 7466,
 -1,
 1423925633,
 7464,
 -43806,
 1423879745,
 7465,
 -43805,
 1424069608,
 43877,
 -43804,
 1424127373,
 7463,
 -1,
 1424184261,
 7462,
 -1,
 1423797760,
 65923,
 1424446703,
 1423753874,
 -1,
 1424512234,
 1424416787,
 -1,
 -43799,
 1424475725,
 65911,
 -1,
 1424527638,
 65917,
 1424708845,
 1424449494,
 -1,
 -43796,
 1424664562,
 65912,
 -1,
 1424724246,
 65918,
 -43794,
 1424667961,
 65929,
 -1,
 1424825972,
 65914,
 1425036534,
 1424396433,
 -1,
 1425102068,
 1424984785,
 -1,
 1425167603,
 1425037615,
 65909,
 -1,
 1425080353,
 65910,
 -1,
 1425123292,
 65931,
 -43787,
 1425068644,
 65924,
 -1,
 1425287944,
 65916,
 1425495289,
 1424982149,
 -1,
 -43784,
 1425462632,
 119365,
 -1,
 1425492500,
 65921,
 1425691900,
 1425427687,
 -1,
 -43781,
 1425644368,
 65919,
 -1,
 1425698398,
 65920,
 -43779,
 1425663665,
 65930,
 -43778,
 1425859577,
 65913,
 -43777,
 1425924720,
 65925,
 -43776,
 1425976901,
 1020,
 -43775,
 1426027568,
 65922,
 -43774,
 1426085642,
 65928,
 -1,
 1426145259,
 65915,
 1426391039,
 1411090730,
 -1,
 -43771,
 1426306636,
 129367,
 -43770,
 1426348827,
 128154,
 -43769,
 1426402106,
 128215,
 -1,
 1426465259,
 127823,
 1426675053,
 1410996532,
 -1,
 1426740587,
 1426624363,
 -1,
 1426806093,
 1426684555,
 -1,
 1426871573,
 1426773496,
 -1,
 1426937105,
 1426821420,
 -1,
 1427002639,
 1426892930,
 70411,
 -1,
 1426958466,
 70496,
 1427177471,
 1426945100,
 70412,
 -1,
 1427076172,
 70497,
 1427264788,
 1426867094,
 -1,
 -43757,
 1427193207,
 70495,
 -1,
 1427251598,
 70494,
 -1,
 1427183924,
 70453,
 1427526939,
 1426834066,
 -1,
 1427592473,
 1427489426,
 -1,
 -43752,
 1427527742,
 70432,
 -1,
 1427577140,
 70431,
 -43750,
 1427527742,
 70437,
 -1,
 1427708212,
 70436,
 1427920160,
 1427474728,
 -1,
 -43747,
 1427891060,
 70430,
 -43746,
 1427933554,
 70435,
 -43745,
 1427985217,
 70425,
 -1,
 1428035892,
 70440,
 1428247846,
 1427847183,
 -1,
 1428313380,
 1428174863,
 -1,
 -43741,
 1428248638,
 70434,
 -1,
 1428298036,
 70433,
 -43739,
 1428248638,
 70439,
 -1,
 1428429108,
 70438,
 1428641066,
 1428166964,
 70405,
 -43736,
 1428606493,
 70420,
 -43735,
 1428644225,
 70416,
 -1,
 1428691252,
 70406,
 1428903214,
 1428600151,
 -1,
 -43732,
 1428862465,
 70455,
 -43731,
 1428903998,
 70454,
 -1,
 1428953396,
 70456,
 1429165360,
 1428868637,
 70409,
 -1,
 1429130781,
 70410,
 1429296435,
 1429118669,
 -1,
 -43726,
 1429231678,
 70443,
 -1,
 1429281076,
 70442,
 1429493046,
 1429238860,
 -1,
 -43723,
 1429435542,
 70451,
 -1,
 1429477684,
 70450,
 1429689657,
 1429434507,
 -1,
 -43720,
 1429624894,
 70422,
 -1,
 1429674292,
 70421,
 1429886268,
 1429630815,
 -1,
 -43717,
 1429821502,
 70429,
 -1,
 1429870900,
 70428,
 1430082878,
 1429823873,
 70407,
 -1,
 1430020481,
 70408,
 1430213953,
 1430016754,
 -1,
 -43712,
 1430149182,
 70424,
 -1,
 1430198580,
 70423,
 1430410564,
 1430138084,
 -1,
 -43709,
 1430345790,
 70427,
 -1,
 1430395188,
 70426,
 1430607175,
 1430333119,
 -1,
 -43706,
 1430542398,
 70445,
 -1,
 1430591796,
 70444,
 -43704,
 1430578036,
 70447,
 -43703,
 1430759669,
 70448,
 -43702,
 1430820471,
 70419,
 -43701,
 1430880475,
 70446,
 -43700,
 1430935614,
 70457,
 -1,
 1430995893,
 70415,
 1431197021,
 1426774640,
 -1,
 1431262547,
 1431165322,
 -1,
 1431328081,
 1431218306,
 70467,
 -1,
 1431283842,
 70468,
 1431502847,
 1431270476,
 70498,
 -1,
 1431401548,
 70499,
 1431590231,
 1431181620,
 -1,
 -43691,
 1431555613,
 70476,
 -43690,
 1431593345,
 70472,
 -1,
 1431640372,
 70462,
 1431852377,
 1431555613,
 70465,
 -1,
 1431817757,
 70466,
 1431983451,
 1431789953,
 70463,
 -1,
 1431921025,
 70464,
 -43684,
 1431934583,
 70475,
 -1,
 1432044469,
 70471,
 1432245609,
 1431157449,
 -1,
 1432311137,
 1432213738,
 -1,
 -43680,
 1432270545,
 70403,
 -1,
 1432332804,
 70477,
 1432507748,
 1432235236,
 -1,
 -43677,
 1432458187,
 70400,
 -1,
 1432494248,
 70401,
 1432704359,
 1432426804,
 -1,
 -43674,
 1432671761,
 70461,
 -1,
 1432719372,
 70402,
 -43672,
 1432658858,
 70493,
 -1,
 1432850365,
 70460,
 -43670,
 1432195987,
 70480,
 -1,
 1432954326,
 70487,
 -43668,
 1426694660,
 127815,
 -1,
 1433092152,
 127891,
 1433294199,
 1426612609,
 -1,
 1433359734,
 1433243032,
 -1,
 1433425269,
 1433292095,
 128512,
 1433534463,
 1433340707,
 -1,
 1433556340,
 1433449815,
 -1,
 -43661,
 1433519115,
 129321,
 -1,
 1433568753,
 128513,
 -1,
 1433507061,
 129322,
 -1,
 1433349784,
 128568,
 -1,
 1433305336,
 128556,
 1433993215,
 1433243793,
 -1,
 1434015099,
 1433916043,
 -1,
 -43654,
 1433974732,
 983109,
 -1,
 1434026629,
 11218,
 -1,
 1433984553,
 128151,
 1434277378,
 1410941123,
 -1,
 1434342908,
 1434228925,
 -1,
 1434408380,
 1434290236,
 -1,
 1434473863,
 1434343464,
 -1,
 1434539396,
 1434392884,
 -1,
 1434604931,
 1434495106,
 7348,
 -1,
 1434531956,
 7358,
 -1,
 1434534083,
 7344,
 -43643,
 1434489289,
 7349,
 -43642,
 1434739585,
 7346,
 -1,
 1434796227,
 7345,
 1434998157,
 1434397924,
 -1,
 1435063691,
 1434933288,
 -1,
 -43638,
 1435002477,
 7337,
 -1,
 1435050517,
 7341,
 -43636,
 1435002272,
 7340,
 -1,
 1435180984,
 7338,
 1435391378,
 1434960530,
 -1,
 1435456913,
 1435310388,
 -1,
 -43632,
 1435412610,
 7330,
 -1,
 1435470120,
 7319,
 -1,
 1435423923,
 7353,
 1435719062,
 1435310388,
 -1,
 -43628,
 1435666728,
 7312,
 -43627,
 1435723373,
 7354,
 -1,
 1435780682,
 7357,
 1435981209,
 1435690429,
 -1,
 -43624,
 1435916845,
 7327,
 -1,
 1435977290,
 7318,
 1436177820,
 1435940183,
 -1,
 -43621,
 1436114245,
 7336,
 -1,
 1436164024,
 7329,
 1436374431,
 1436131021,
 -1,
 -43618,
 1436310061,
 7332,
 -1,
 1436361237,
 7326,
 1436571042,
 1436316822,
 -1,
 -43615,
 1436530007,
 7322,
 -1,
 1436559743,
 7359,
 1436767653,
 1436512395,
 -1,
 -43612,
 1436703277,
 7333,
 -1,
 1436753848,
 7321,
 1436964264,
 1436708703,
 -1,
 -43609,
 1436902816,
 7339,
 -1,
 1436965233,
 7343,
 1437160875,
 1436898034,
 -1,
 -43606,
 1437096305,
 7334,
 -1,
 1437147064,
 7314,
 1437357486,
 1437089987,
 -1,
 -43603,
 1437305128,
 7316,
 -1,
 1437367189,
 7352,
 -43601,
 1437328665,
 7351,
 -43600,
 1437524537,
 7342,
 -43599,
 1437588555,
 7347,
 -43598,
 1437653299,
 7317,
 -43597,
 1437716862,
 7331,
 -43596,
 1437772076,
 7328,
 -43595,
 1437837085,
 7335,
 -43594,
 1437897748,
 7325,
 -43593,
 1437960662,
 7324,
 -43592,
 1438024219,
 7323,
 -43591,
 1438082669,
 7320,
 -43590,
 1438142039,
 7350,
 -43589,
 1438202954,
 7315,
 -1,
 1438263171,
 7313,
 1438471665,
 1434369160,
 -1,
 1438537156,
 1438406696,
 -1,
 1438602689,
 1438456116,
 -1,
 -43584,
 1438558338,
 11556,
 -1,
 1438597315,
 11552,
 -43582,
 1438552521,
 11557,
 -43581,
 1438737281,
 11554,
 -1,
 1438793923,
 11553,
 1438995914,
 1438461156,
 -1,
 1439061448,
 1438930984,
 -1,
 -43577,
 1439000173,
 11545,
 -1,
 1439048213,
 11549,
 -43575,
 1438999968,
 11548,
 -1,
 1439178680,
 11546,
 1439389133,
 1438967229,
 -1,
 -43572,
 1439324717,
 11535,
 -1,
 1439385162,
 11526,
 1439585744,
 1439351576,
 -1,
 -43569,
 1439541378,
 11538,
 -1,
 1439598888,
 11527,
 1439782355,
 1439544663,
 -1,
 -43566,
 1439718725,
 11544,
 -1,
 1439768504,
 11537,
 1439978966,
 1439735501,
 -1,
 -43563,
 1439914541,
 11540,
 -1,
 1439965717,
 11534,
 1440175577,
 1439920267,
 -1,
 -43560,
 1440111149,
 11541,
 -1,
 1440161720,
 11529,
 1440372188,
 1440116575,
 -1,
 -43557,
 1440310688,
 11547,
 -1,
 1440373105,
 11551,
 1440568799,
 1440305906,
 -1,
 -43554,
 1440504177,
 11542,
 -1,
 1440554936,
 11522,
 1440765410,
 1440487732,
 -1,
 -43551,
 1440713000,
 11520,
 -1,
 1440761418,
 11565,
 -43549,
 1440736537,
 11559,
 -43548,
 1440932409,
 11550,
 -43547,
 1440996427,
 11555,
 -43546,
 1441061171,
 11525,
 -43545,
 1441124734,
 11539,
 -43544,
 1441179948,
 11536,
 -43543,
 1441244957,
 11543,
 -43542,
 1441305620,
 11533,
 -43541,
 1441368534,
 11532,
 -43540,
 1441432091,
 11531,
 -43539,
 1441494588,
 11530,
 -43538,
 1441556077,
 11528,
 -43537,
 1441613386,
 11524,
 -43536,
 1441676362,
 11523,
 -1,
 1441736579,
 11521,
 1441945081,
 1438415499,
 -1,
 1442010613,
 1441863988,
 -1,
 -43532,
 1441949293,
 4346,
 -1,
 1442006602,
 4349,
 -43530,
 1441975943,
 983936,
 -43529,
 1442172127,
 4345,
 -43528,
 1442215094,
 4351,
 -1,
 1442273886,
 4350,
 1442512895,
 1441869334,
 -1,
 -43525,
 1442440473,
 4295,
 -1,
 1442454532,
 4301,
 1442665984,
 1434264085,
 9881,
 1442775039,
 1442581277,
 -1,
 -43521,
 1442683887,
 9965,
 -1,
 1442710331,
 9966,
 -43519,
 1442614431,
 129502,
 -1,
 1442873543,
 128142,
 1443059336,
 1434219596,
 -1,
 1443124868,
 1442978100,
 -1,
 1443190403,
 1443059418,
 -1,
 1443255876,
 1443150984,
 -1,
 1443321359,
 1443214679,
 -1,
 1443386891,
 1443256360,
 -1,
 1443452426,
 1443349272,
 11339,
 -1,
 1443406407,
 11356,
 -1,
 1443371316,
 11342,
 1443649037,
 1443332626,
 11348,
 -1,
 1443565064,
 11349,
 -43506,
 1443603039,
 11346,
 -1,
 1443724991,
 11332,
 1443911192,
 1443291916,
 -1,
 1443976725,
 1443840195,
 -1,
 1444042260,
 1443932290,
 -1,
 -43501,
 1444007453,
 11343,
 -1,
 1444045185,
 11344,
 -1,
 1444004179,
 11317,
 -43498,
 1443941917,
 11347,
 -43497,
 1444253841,
 11350,
 -1,
 1444291938,
 11345,
 1444501024,
 1443848577,
 11323,
 1444566556,
 1444472519,
 -1,
 -43493,
 1444507146,
 11355,
 -1,
 1444561091,
 11321,
 1444763167,
 1444518377,
 -1,
 -43490,
 1444723990,
 11351,
 -1,
 1444751788,
 11353,
 -1,
 1444711762,
 11322,
 1445025316,
 1444463250,
 -1,
 -43486,
 1444993733,
 11333,
 -43485,
 1445050964,
 11340,
 -1,
 1445114693,
 11357,
 1445287464,
 1444952079,
 -1,
 -43482,
 1445258859,
 11319,
 -43481,
 1445302561,
 11316,
 -1,
 1445359594,
 11324,
 1445549611,
 1445258685,
 -1,
 -43478,
 1445486043,
 11318,
 -1,
 1445545520,
 11320,
 1445746222,
 1445502669,
 -1,
 -43475,
 1445696214,
 11330,
 -1,
 1445740739,
 11338,
 1445942833,
 1445695633,
 -1,
 -43472,
 1445907522,
 11337,
 -1,
 1445957544,
 11329,
 1446139444,
 1445885004,
 -1,
 -43469,
 1446080624,
 11326,
 -1,
 1446126956,
 11358,
 1446336055,
 1446071527,
 -1,
 -43466,
 1446294192,
 11335,
 -1,
 1446341986,
 11354,
 1446532666,
 1446258367,
 -1,
 -43463,
 1446498526,
 11313,
 -1,
 1446536192,
 11352,
 -43461,
 1446500128,
 11314,
 -43460,
 1446695125,
 11334,
 -43459,
 1446752938,
 11331,
 -43458,
 1446808057,
 11328,
 -43457,
 1446873376,
 11327,
 -43456,
 1446932788,
 11325,
 -43455,
 1446992874,
 11336,
 -43454,
 1447057038,
 11315,
 -43453,
 1447112857,
 11341,
 -1,
 1447175867,
 11312,
 1447428095,
 1443180054,
 -1,
 1447450190,
 1447343447,
 -1,
 1447515722,
 1447385128,
 -1,
 1447581257,
 1447478040,
 11291,
 -1,
 1447535175,
 11308,
 -1,
 1447500084,
 11294,
 1447777868,
 1447461394,
 11300,
 -1,
 1447693832,
 11301,
 -43443,
 1447731807,
 11298,
 -1,
 1447853759,
 11284,
 1448040023,
 1447420684,
 -1,
 1448105556,
 1447968963,
 -1,
 1448171091,
 1448061058,
 -1,
 -43438,
 1448136221,
 11295,
 -1,
 1448173953,
 11296,
 -1,
 1448132947,
 11269,
 -43435,
 1448070685,
 11299,
 -43434,
 1448382609,
 11302,
 -1,
 1448420706,
 11297,
 1448629855,
 1447977345,
 11275,
 1448695387,
 1448601287,
 -1,
 -43430,
 1448635914,
 11307,
 -1,
 1448689859,
 11273,
 1448891998,
 1448647145,
 -1,
 -43427,
 1448852758,
 11303,
 -1,
 1448880556,
 11305,
 -1,
 1448840530,
 11274,
 1449154147,
 1448592018,
 -1,
 -43423,
 1449122501,
 11285,
 -43422,
 1449179732,
 11292,
 -1,
 1449243461,
 11309,
 1449416295,
 1449080847,
 -1,
 -43419,
 1449387627,
 11271,
 -43418,
 1449431329,
 11268,
 -1,
 1449488362,
 11276,
 1449678442,
 1449387453,
 -1,
 -43415,
 1449614811,
 11270,
 -1,
 1449674288,
 11272,
 1449875053,
 1449631437,
 -1,
 -43412,
 1449824982,
 11282,
 -1,
 1449869507,
 11290,
 1450071664,
 1449824401,
 -1,
 -43409,
 1450036290,
 11289,
 -1,
 1450086312,
 11281,
 1450268275,
 1450013772,
 -1,
 -43406,
 1450209392,
 11278,
 -1,
 1450255724,
 11310,
 1450464886,
 1450200295,
 -1,
 -43403,
 1450422960,
 11287,
 -1,
 1450470754,
 11306,
 1450661497,
 1450387135,
 -1,
 -43400,
 1450627294,
 11265,
 -1,
 1450664960,
 11304,
 -43398,
 1450628896,
 11266,
 -43397,
 1450823893,
 11286,
 -43396,
 1450881706,
 11283,
 -43395,
 1450936825,
 11280,
 -43394,
 1451002144,
 11279,
 -43393,
 1451061556,
 11277,
 -43392,
 1451121642,
 11288,
 -43391,
 1451185806,
 11267,
 -43390,
 1451241625,
 11293,
 -1,
 1451304635,
 11264,
 -1,
 1443151529,
 129371,
 1451622399,
 1443074193,
 -1,
 -43386,
 1451548212,
 127775,
 -43385,
 1451612352,
 129508,
 -1,
 1451632748,
 127760,
 1451841275,
 1443024413,
 -1,
 1451906782,
 1451789670,
 -1,
 1451972287,
 1451850379,
 -1,
 1452037777,
 1451934354,
 -1,
 1452103311,
 1451999890,
 -1,
 -43378,
 1452038206,
 73086,
 -1,
 1452087604,
 73085,
 -43376,
 1452038206,
 73076,
 -1,
 1452218676,
 73075,
 1452430999,
 1451964431,
 -1,
 1452496533,
 1452357647,
 -1,
 -43372,
 1452431422,
 73091,
 -1,
 1452480820,
 73090,
 -43370,
 1452431422,
 73081,
 -1,
 1452611892,
 73080,
 1452824219,
 1452349748,
 73056,
 -43367,
 1452789277,
 73067,
 -43366,
 1452827009,
 73064,
 -1,
 1452874036,
 73057,
 1453086365,
 1452789277,
 73060,
 -1,
 1453051421,
 73061,
 1453217440,
 1453039309,
 -1,
 -43361,
 1453152318,
 73094,
 -1,
 1453201716,
 73093,
 1453414051,
 1453164840,
 -1,
 -43358,
 1453347649,
 73092,
 -1,
 1453398324,
 73082,
 1453610662,
 1453356108,
 -1,
 -43355,
 1453552790,
 73087,
 -1,
 1453594932,
 73077,
 1453807273,
 1453551755,
 -1,
 -43352,
 1453742142,
 73074,
 -1,
 1453791540,
 73073,
 1454003884,
 1453748063,
 -1,
 -43349,
 1453938750,
 73089,
 -1,
 1453988148,
 73088,
 1454200494,
 1453941121,
 73058,
 -1,
 1454137729,
 73059,
 1454331569,
 1454134002,
 -1,
 -43344,
 1454266430,
 73079,
 -1,
 1454315828,
 73078,
 1454528180,
 1454255332,
 -1,
 -43341,
 1454463038,
 73084,
 -1,
 1454512436,
 73083,
 1454724791,
 1454450367,
 -1,
 -43338,
 1454659646,
 73071,
 -1,
 1454709044,
 73070,
 -43336,
 1454695284,
 73068,
 -43335,
 1454888462,
 73069,
 -43334,
 1454945793,
 73097,
 -43333,
 1455007989,
 73096,
 -43332,
 1455068791,
 73066,
 -43331,
 1455128795,
 73072,
 -43330,
 1455183934,
 73095,
 -1,
 1455244213,
 73063,
 1455445708,
 1451939320,
 -1,
 1455511243,
 1455398477,
 -1,
 1455576773,
 1455429940,
 -1,
 -43325,
 1455541789,
 73108,
 -43324,
 1455579521,
 73105,
 -1,
 1455626548,
 73098,
 1455838919,
 1455541789,
 73101,
 -1,
 1455803933,
 73102,
 1455969993,
 1455776129,
 73099,
 -1,
 1455907201,
 73100,
 -43318,
 1455920759,
 73107,
 -1,
 1456030645,
 73104,
 -1,
 1455451094,
 73111,
 1456297690,
 1455373150,
 -1,
 1456363216,
 1456259730,
 -1,
 -43313,
 1456332816,
 73122,
 -1,
 1456365521,
 73123,
 1456559827,
 1456321879,
 -1,
 -43310,
 1456500434,
 73126,
 -1,
 1456556779,
 73127,
 1456756438,
 1456491751,
 -1,
 -43307,
 1456708379,
 73124,
 -1,
 1456762400,
 73125,
 -43305,
 1456727690,
 73120,
 -43304,
 1456903343,
 73121,
 -43303,
 1456966872,
 73129,
 -1,
 1457014029,
 73128,
 1457215197,
 1456257737,
 -1,
 -43300,
 1457183053,
 73110,
 -1,
 1457201550,
 73109,
 -1,
 1457165203,
 73112,
 1457477360,
 1451847583,
 -1,
 1457542888,
 1457437385,
 -1,
 1457608419,
 1457504914,
 -1,
 -43294,
 1457578208,
 2815,
 -1,
 1457610901,
 2813,
 1457805030,
 1457567063,
 -1,
 -43291,
 1457770713,
 2810,
 -1,
 1457805411,
 2811,
 -43289,
 1457750312,
 2812,
 -1,
 1457926449,
 2814,
 1458132716,
 1457486475,
 -1,
 1458198251,
 1458100627,
 2700,
 -1,
 1458140236,
 2785,
 -1,
 1458169569,
 2809,
 1458394862,
 1458100894,
 2786,
 -1,
 1458336844,
 2787,
 -43281,
 1458353443,
 2801,
 -1,
 1458444889,
 2800,
 1458657015,
 1457435382,
 -1,
 1458722550,
 1458617033,
 -1,
 -43277,
 1458693042,
 2677,
 -43276,
 1458755917,
 2563,
 -43275,
 1458819121,
 2641,
 -1,
 1458838438,
 2561,
 -1,
 1458641497,
 2678,
 1459115770,
 1458577941,
 -1,
 -43271,
 1459044391,
 128130,
 -1,
 1459101993,
 8370,
 -1,
 1459056035,
 127928,
 1459377922,
 1451790481,
 -1,
 1459443455,
 1459296564,
 -1,
 -43266,
 1459405458,
 128016,
 -1,
 1459450968,
 129349,
 -43264,
 1459400955,
 129421,
 -43263,
 1459583787,
 127948,
 -1,
 1459639605,
 129405,
 1459836678,
 1459317696,
 -1,
 1459902213,
 1459778636,
 128103,
 -1,
 1459860950,
 128714,
 -1,
 1459821673,
 129426,
 -43257,
 1459795287,
 983110,
 -43256,
 1460035430,
 128123,
 -1,
 1460084602,
 127922,
 1460296069,
 1410873359,
 -1,
 1460361261,
 1460244625,
 -1,
 1460426626,
 1460307544,
 -1,
 1460492103,
 1460393924,
 -1,
 1460557638,
 1460407912,
 -1,
 1460623126,
 1460475609,
 -1,
 -43248,
 1460540961,
 127123,
 -43247,
 1460606252,
 127122,
 -43246,
 1460671576,
 127121,
 -43245,
 1460736826,
 127120,
 -43244,
 1460802069,
 127119,
 -43243,
 1460867306,
 127118,
 -1,
 1460932573,
 127117,
 1461147422,
 1460540918,
 -1,
 -43240,
 1461065249,
 127116,
 -43239,
 1461130540,
 127115,
 -43238,
 1461195864,
 127114,
 -43237,
 1461261114,
 127113,
 -43236,
 1461326357,
 127112,
 -43235,
 1461391594,
 127111,
 -1,
 1461456861,
 127110,
 1461671718,
 1461064973,
 -1,
 -43232,
 1461589537,
 127109,
 -43231,
 1461654828,
 127108,
 -43230,
 1461720152,
 127107,
 -43229,
 1461785402,
 127106,
 -43228,
 1461850645,
 127105,
 -43227,
 1461915882,
 127104,
 -1,
 1461981149,
 127103,
 1462196014,
 1461589035,
 -1,
 -43224,
 1462113825,
 127102,
 -43223,
 1462179116,
 127101,
 -43222,
 1462244440,
 127100,
 -43221,
 1462309690,
 127099,
 -43220,
 1462374933,
 127098,
 -43219,
 1462440170,
 127097,
 -1,
 1462505437,
 127096,
 1462720310,
 1462113024,
 -1,
 -43216,
 1462638113,
 127095,
 -43215,
 1462703404,
 127094,
 -43214,
 1462768728,
 127093,
 -43213,
 1462833978,
 127092,
 -43212,
 1462899221,
 127091,
 -43211,
 1462964458,
 127090,
 -1,
 1463029725,
 127089,
 1463244606,
 1462637026,
 -1,
 -43208,
 1463162401,
 127088,
 -43207,
 1463227692,
 127087,
 -43206,
 1463293016,
 127086,
 -43205,
 1463358266,
 127085,
 -43204,
 1463423509,
 127084,
 -43203,
 1463488746,
 127083,
 -1,
 1463554013,
 127082,
 1463812095,
 1463161024,
 -1,
 -43200,
 1463686689,
 127081,
 -43199,
 1463751980,
 127080,
 -43198,
 1463817304,
 127079,
 -43197,
 1463882554,
 127078,
 -43196,
 1463947797,
 127077,
 -43195,
 1464013034,
 127076,
 -1,
 1464078301,
 127075,
 -1,
 1460470079,
 127074,
 1464401919,
 1460428493,
 -1,
 1464424321,
 1464274536,
 -1,
 1464489809,
 1464342233,
 -1,
 -43189,
 1464407585,
 127073,
 -43188,
 1464472876,
 127072,
 -43187,
 1464538200,
 127071,
 -43186,
 1464603450,
 127070,
 -43185,
 1464668693,
 127069,
 -43184,
 1464733930,
 127068,
 -1,
 1464799197,
 127067,
 1465014105,
 1464407542,
 -1,
 -43181,
 1464931873,
 127066,
 -43180,
 1464997164,
 127065,
 -43179,
 1465062488,
 127064,
 -43178,
 1465127738,
 127063,
 -43177,
 1465192981,
 127062,
 -43176,
 1465258218,
 127061,
 -1,
 1465323485,
 127060,
 1465538401,
 1464931597,
 -1,
 -43173,
 1465456161,
 127059,
 -43172,
 1465521452,
 127058,
 -43171,
 1465586776,
 127057,
 -43170,
 1465652026,
 127056,
 -43169,
 1465717269,
 127055,
 -43168,
 1465782506,
 127054,
 -1,
 1465847773,
 127053,
 1466062697,
 1465455659,
 -1,
 -43165,
 1465980449,
 127052,
 -43164,
 1466045740,
 127051,
 -43163,
 1466111064,
 127050,
 -43162,
 1466176314,
 127049,
 -43161,
 1466241557,
 127048,
 -43160,
 1466306794,
 127047,
 -1,
 1466372061,
 127046,
 1466586993,
 1465979648,
 -1,
 -43157,
 1466504737,
 127045,
 -43156,
 1466570028,
 127044,
 -43155,
 1466635352,
 127043,
 -43154,
 1466700602,
 127042,
 -43153,
 1466765845,
 127041,
 -43152,
 1466831082,
 127040,
 -1,
 1466896349,
 127039,
 1467111289,
 1466503650,
 -1,
 -43149,
 1467029025,
 127038,
 -43148,
 1467094316,
 127037,
 -43147,
 1467159640,
 127036,
 -43146,
 1467224890,
 127035,
 -43145,
 1467290133,
 127034,
 -43144,
 1467355370,
 127033,
 -1,
 1467420637,
 127032,
 1467678719,
 1467027648,
 -1,
 -43141,
 1467553313,
 127031,
 -43140,
 1467618604,
 127030,
 -43139,
 1467683928,
 127029,
 -43138,
 1467749178,
 127028,
 -43137,
 1467814421,
 127027,
 -43136,
 1467879658,
 127026,
 -1,
 1467944925,
 127025,
 -1,
 1464336703,
 127024,
 1468225491,
 1460359922,
 128021,
 1468291026,
 1468180728,
 -1,
 1468356542,
 1468234379,
 -1,
 1468422027,
 1468318354,
 -1,
 1468487561,
 1468383890,
 -1,
 -43128,
 1468422206,
 71701,
 -1,
 1468471604,
 71700,
 -43126,
 1468422206,
 71706,
 -1,
 1468602676,
 71705,
 1468815248,
 1468369192,
 -1,
 -43123,
 1468785524,
 71699,
 -43122,
 1468828018,
 71704,
 -43121,
 1468879681,
 71694,
 -1,
 1468930356,
 71709,
 1469142934,
 1468741647,
 -1,
 1469208468,
 1469069327,
 -1,
 -43117,
 1469143102,
 71703,
 -1,
 1469192500,
 71702,
 -43115,
 1469143102,
 71708,
 -1,
 1469323572,
 71707,
 1469536154,
 1469061428,
 71680,
 -43112,
 1469500957,
 71689,
 -43111,
 1469538689,
 71687,
 -1,
 1469585716,
 71681,
 1469798302,
 1469494615,
 -1,
 -43108,
 1469756929,
 71720,
 -43107,
 1469798462,
 71719,
 -1,
 1469847860,
 71721,
 1470060448,
 1469763101,
 71684,
 -1,
 1470025245,
 71685,
 1470191523,
 1470015618,
 -1,
 -43102,
 1470146805,
 71723,
 -1,
 1470175540,
 71716,
 1470388134,
 1470144205,
 -1,
 -43099,
 1470322750,
 71711,
 -1,
 1470372148,
 71710,
 1470584745,
 1470328971,
 -1,
 -43096,
 1470519358,
 71691,
 -1,
 1470568756,
 71690,
 1470781356,
 1470525279,
 -1,
 -43093,
 1470715966,
 71698,
 -1,
 1470765364,
 71697,
 1470977966,
 1470718337,
 71682,
 -1,
 1470914945,
 71683,
 1471109041,
 1470911218,
 -1,
 -43088,
 1471043646,
 71693,
 -1,
 1471093044,
 71692,
 1471305652,
 1471032548,
 -1,
 -43085,
 1471240254,
 71696,
 -1,
 1471289652,
 71695,
 1471502263,
 1471227583,
 -1,
 -43082,
 1471436862,
 71713,
 -1,
 1471486260,
 71712,
 -43080,
 1471472500,
 71715,
 -43079,
 1471665678,
 71718,
 -43078,
 1471713425,
 71688,
 -43077,
 1471774939,
 71714,
 -43076,
 1471837334,
 71717,
 -43075,
 1471895614,
 71722,
 -1,
 1471955139,
 71686,
 1472157643,
 1468324464,
 -1,
 1472223171,
 1472076084,
 -1,
 -43071,
 1472187933,
 71734,
 -43070,
 1472225665,
 71732,
 -1,
 1472272692,
 71724,
 1472485317,
 1472190877,
 71729,
 -1,
 1472440450,
 71730,
 1472616391,
 1472450077,
 71727,
 -1,
 1472581149,
 71728,
 1472747465,
 1472553345,
 71725,
 -1,
 1472684417,
 71726,
 -43062,
 1472696465,
 71733,
 -1,
 1472807107,
 71731,
 1473009617,
 1472117449,
 -1,
 1473075151,
 1472977130,
 -1,
 -43058,
 1473033937,
 71736,
 -1,
 1473096196,
 71737,
 -43056,
 1473023933,
 71738,
 -1,
 1473192334,
 71735,
 -1,
 1472928345,
 71739,
 -1,
 1468203708,
 128054,
 1473533963,
 1468194747,
 -1,
 1473599496,
 1473502079,
 -1,
 1473665027,
 1473557849,
 -1,
 1473730540,
 1473626770,
 -1,
 1473796075,
 1473687165,
 -1,
 1473861610,
 1473711822,
 -1,
 1473927143,
 1473782642,
 11107,
 1474035711,
 1473839104,
 -1,
 1474058213,
 1473961568,
 -1,
 1474123743,
 1474002494,
 -1,
 -43042,
 1474080896,
 11169,
 -1,
 1474132319,
 11168,
 -43040,
 1474091146,
 129075,
 -43039,
 1474267610,
 129059,
 -43038,
 1474331647,
 129063,
 -43037,
 1474386782,
 129071,
 -43036,
 1474444831,
 11133,
 -1,
 1474505512,
 129067,
 -43034,
 1474021646,
 11123,
 -1,
 1474656736,
 11139,
 -43032,
 1473898244,
 11085,
 -43031,
 1474797427,
 11143,
 -1,
 1474836796,
 11117,
 -1,
 1473773848,
 129171,
 -1,
 1473765633,
 11247,
 1475172342,
 1473648948,
 -1,
 1475237877,
 1475130446,
 -1,
 1475303409,
 1475197962,
 -1,
 -43024,
 1475267256,
 129027,
 -1,
 1475299432,
 129043,
 -43022,
 1475251798,
 129179,
 -43021,
 1475445786,
 129031,
 -43020,
 1475507724,
 129035,
 -1,
 1475561576,
 129047,
 -1,
 1475185199,
 11796,
 1475827705,
 1475130711,
 -1,
 -43016,
 1475782557,
 129083,
 -1,
 1475813697,
 129107,
 1476024316,
 1475763014,
 -1,
 -43013,
 1475949582,
 129091,
 -1,
 1476010866,
 129095,
 1476220927,
 1475947043,
 -1,
 -43010,
 1476145544,
 11147,
 -1,
 1476207474,
 11015,
 -43008,
 1476189475,
 129175,
 -43007,
 1476375331,
 128623,
 -43006,
 1476415261,
 129079,
 -1,
 1476473870,
 129087,
 1476722687,
 1473577673,
 -1,
 1476745222,
 1476628041,
 129289,
 -1,
 1476660200,
 129291,
 1476919295,
 1476681334,
 129288,
 -1,
 1476791272,
 129290,
 1477050367,
 1473515348,
 -1,
 -42998,
 1476967620,
 128317,
 -1,
 1477028931,
 128315,
 1477203996,
 1473498653,
 -1,
 1477269531,
 1477126759,
 -1,
 1477335062,
 1477181440,
 -1,
 1477400593,
 1477293399,
 -1,
 -42992,
 1477367158,
 11844,
 -1,
 1477428057,
 11849,
 -42990,
 1477367757,
 9208,
 -42989,
 1477546232,
 11799,
 -42988,
 1477607227,
 11842,
 -42987,
 1477665146,
 11840,
 -1,
 1477719987,
 10175,
 1477924890,
 1477261329,
 -1,
 -42984,
 1477886543,
 11260,
 -42983,
 1477935503,
 9891,
 -1,
 1477987793,
 9890,
 -1,
 1477840823,
 8508,
 -1,
 1477203368,
 127849,
 1478318116,
 1477168131,
 -1,
 1478383648,
 1478276439,
 -1,
 -42977,
 1478338441,
 11034,
 -1,
 1478398800,
 11850,
 -42975,
 1478347342,
 11784,
 -42974,
 1478537276,
 11798,
 -42973,
 1478594795,
 11795,
 -1,
 1478637061,
 8284,
 1478842409,
 1478244196,
 128462,
 1478950911,
 1478757155,
 -1,
 1478973480,
 1478870415,
 128441,
 -1,
 1478885519,
 128442,
 -1,
 1478926935,
 128443,
 -42966,
 1478809341,
 128330,
 -42965,
 1479120991,
 128682,
 -42964,
 1479180224,
 128044,
 -1,
 1479214296,
 128687,
 1479432408,
 1460325917,
 -1,
 1479497942,
 1479385931,
 -1,
 1479563432,
 1479441035,
 -1,
 1479628876,
 1479521623,
 113692,
 1479694399,
 1479540736,
 -1,
 1479759924,
 1479663213,
 113701,
 -1,
 1479672168,
 113702,
 1479890998,
 1479721618,
 113714,
 -1,
 1479805017,
 113715,
 1480022072,
 1479843533,
 113716,
 -1,
 1479936089,
 113717,
 1480153146,
 1479962763,
 113727,
 -1,
 1480067161,
 113728,
 1480284220,
 1480093535,
 113696,
 -1,
 1480198303,
 113710,
 -42947,
 1480242519,
 113706,
 -42946,
 1480362280,
 113723,
 -1,
 1480425605,
 113724,
 1480611915,
 1479638477,
 -1,
 1480677444,
 1480540355,
 -1,
 -42942,
 1480624424,
 113767,
 -42941,
 1480677416,
 113740,
 -1,
 1480736963,
 113742,
 1480939591,
 1480626321,
 -1,
 -42938,
 1480907492,
 113730,
 -1,
 1480952104,
 113769,
 -42936,
 1480904221,
 113752,
 -42935,
 1481076575,
 113685,
 -42934,
 1481128613,
 113682,
 -1,
 1481187256,
 113768,
 -1,
 1480548176,
 113737,
 1481463895,
 1479575848,
 113690,
 1481529426,
 1481385008,
 -1,
 -42929,
 1481494045,
 113761,
 -42928,
 1481543825,
 113762,
 -42927,
 1481597313,
 113763,
 -1,
 1481644340,
 113764,
 1481900031,
 1481441280,
 -1,
 1481922645,
 1481801861,
 113694,
 -1,
 1481836703,
 113708,
 -42922,
 1481891437,
 113698,
 -1,
 1482011991,
 113704,
 1482184801,
 1481404255,
 113691,
 1482293247,
 1482096640,
 -1,
 1482315867,
 1482219117,
 113699,
 -1,
 1482274172,
 113700,
 1482446941,
 1482274135,
 113705,
 -1,
 1482361832,
 113711,
 1482578015,
 1482393896,
 113712,
 -1,
 1482492063,
 113713,
 1482751999,
 1482522757,
 113695,
 -1,
 1482623135,
 113709,
 1482840169,
 1482152676,
 113720,
 1482905700,
 1482789009,
 113757,
 -1,
 1482873572,
 113760,
 -42907,
 1482842497,
 113758,
 -42906,
 1482971176,
 113721,
 -42905,
 1483031804,
 113759,
 -42904,
 1483086132,
 113756,
 -1,
 1483147353,
 113722,
 1483364463,
 1482795138,
 113675,
 1483429997,
 1483314098,
 -1,
 -42900,
 1483394589,
 113750,
 -1,
 1483432321,
 113741,
 -42898,
 1483364392,
 113688,
 -1,
 1483540639,
 113680,
 1483757684,
 1483313297,
 113732,
 -42895,
 1483725540,
 113754,
 -42894,
 1483787805,
 113755,
 -42893,
 1483838046,
 113753,
 -1,
 1483872564,
 113731,
 1484085370,
 1483702405,
 113689,
 1484193791,
 1483997184,
 -1,
 1484216440,
 1484097832,
 113693,
 -1,
 1484130463,
 113707,
 -42887,
 1484185197,
 113697,
 -1,
 1484305751,
 113703,
 1484478590,
 1484049949,
 113745,
 -42884,
 1484415361,
 113738,
 -42883,
 1484478504,
 113751,
 -1,
 1484522705,
 113748,
 1484740739,
 1484440210,
 113667,
 1484806274,
 1484652544,
 -1,
 -42879,
 1484764503,
 113718,
 -1,
 1484826804,
 113719,
 -1,
 1484740648,
 113681,
 1485068424,
 1484693197,
 113666,
 1485133959,
 1484998980,
 -1,
 -42874,
 1485080872,
 113765,
 -1,
 1485144197,
 113766,
 -1,
 1485046993,
 113676,
 1485396109,
 1485009996,
 113670,
 1485461644,
 1485346181,
 -1,
 -42869,
 1485426205,
 113749,
 -1,
 1485463937,
 113743,
 -1,
 1485396008,
 113687,
 1485723794,
 1485336715,
 113669,
 1485789329,
 1485635584,
 -1,
 -42864,
 1485744308,
 113725,
 -1,
 1485799557,
 113679,
 -1,
 1485729931,
 113684,
 1486051477,
 1485652163,
 113735,
 -42860,
 1486016029,
 113746,
 -1,
 1486045379,
 113739,
 1486248088,
 1485977615,
 113672,
 -42857,
 1486182440,
 113683,
 -1,
 1486227615,
 113677,
 1486444698,
 1486217729,
 113665,
 -1,
 1486412516,
 113747,
 1486575772,
 1486411256,
 113673,
 -1,
 1486524724,
 113770,
 1486706846,
 1486512513,
 113734,
 -1,
 1486635203,
 113736,
 1486837920,
 1486641192,
 113664,
 -1,
 1486779468,
 113686,
 1486968994,
 1486770930,
 113674,
 -1,
 1486882908,
 113726,
 1487100068,
 1486900455,
 113668,
 -1,
 1487013073,
 113678,
 1487231142,
 1487018292,
 113729,
 -1,
 1487182490,
 113733,
 -42841,
 1487201270,
 113744,
 -1,
 1487283903,
 113671,
 1487493330,
 1479482483,
 -1,
 1487558841,
 1487434828,
 -1,
 1487624376,
 1487511032,
 -1,
 1487689901,
 1487591364,
 113816,
 -1,
 1487603904,
 113779,
 1487820976,
 1487631436,
 -1,
 -42833,
 1487771045,
 113811,
 -1,
 1487824822,
 113814,
 1488017587,
 1487739188,
 -1,
 -42830,
 1487975479,
 113817,
 -1,
 1488009196,
 113808,
 -42828,
 1487985652,
 113815,
 -42827,
 1488177061,
 113809,
 -42826,
 1488213827,
 113810,
 -42825,
 1488272462,
 113812,
 -1,
 1488335095,
 113813,
 -1,
 1487553635,
 113776,
 1488607429,
 1487494333,
 -1,
 1488672956,
 1488574404,
 113800,
 -1,
 1488586944,
 113781,
 1488804031,
 1488614476,
 -1,
 -42818,
 1488754085,
 113795,
 -1,
 1488807862,
 113798,
 -42816,
 1488772084,
 113799,
 -42815,
 1488963493,
 113793,
 -42814,
 1489000259,
 113794,
 -42813,
 1489058894,
 113796,
 -42812,
 1489121527,
 113797,
 -1,
 1489181526,
 113792,
 1489393870,
 1488528791,
 -1,
 1489459402,
 1489355544,
 -1,
 1489524937,
 1489407059,
 113784,
 -1,
 1489437518,
 113788,
 -1,
 1489462688,
 113785,
 -42805,
 1489418057,
 113782,
 -42804,
 1489664330,
 113783,
 -42803,
 1489723789,
 113787,
 -1,
 1489781020,
 113786,
 1489983697,
 1489339676,
 -1,
 -42800,
 1489950775,
 113780,
 -1,
 1489985275,
 113777,
 -1,
 1489940330,
 113778,
 -42797,
 1487455756,
 113821,
 -42796,
 1490205414,
 113820,
 -42795,
 1490265702,
 113823,
 -1,
 1490304568,
 113822,
 -42793,
 1479444497,
 129375,
 -1,
 1490432542,
 129414,
 1490639150,
 1479360707,
 -1,
 1490704661,
 1490605560,
 -1,
 1490770190,
 1490624496,
 -1,
 1490835696,
 1490713227,
 -1,
 1490901215,
 1490800157,
 -1,
 -42786,
 1490866264,
 2423,
 -1,
 1490895043,
 2422,
 1491097826,
 1490849937,
 -1,
 -42783,
 1491046857,
 2420,
 -1,
 1491091651,
 2419,
 1491294437,
 1491030770,
 -1,
 -42780,
 1491238564,
 2429,
 -1,
 1491292993,
 2427,
 1491491048,
 1491212596,
 -1,
 -42777,
 1491460876,
 43262,
 -1,
 1491524324,
 2421,
 -42775,
 1491461857,
 2425,
 -42774,
 1491646970,
 2308,
 -42773,
 1491698423,
 2424,
 -42772,
 1491759121,
 2428,
 -42771,
 1491819370,
 2426,
 -42770,
 1491876192,
 2430,
 -42769,
 1491938721,
 2418,
 -1,
 1492002890,
 2431,
 1492211966,
 1490795209,
 -1,
 1492277495,
 1492135364,
 -1,
 1492343029,
 1492238994,
 -1,
 -42764,
 1492312080,
 43253,
 -1,
 1492344785,
 43254,
 -42762,
 1492310342,
 43251,
 -1,
 1492461099,
 43255,
 1492670714,
 1492235607,
 -1,
 -42759,
 1492623191,
 43250,
 -1,
 1492673314,
 43260,
 -42757,
 1492625050,
 43256,
 -42756,
 1492806327,
 2304,
 -42755,
 1492868312,
 2417,
 -1,
 1492925869,
 43252,
 1493129482,
 1492179568,
 -1,
 1493195010,
 1493093917,
 -1,
 -42751,
 1493160024,
 2391,
 -1,
 1493188803,
 2390,
 1493391621,
 1493143697,
 -1,
 -42748,
 1493340617,
 2363,
 -1,
 1493385411,
 2362,
 1493588232,
 1493309748,
 -1,
 -42745,
 1493558028,
 43263,
 -1,
 1493621476,
 2383,
 -42743,
 1493542341,
 2382,
 -1,
 1493708202,
 2389,
 -42741,
 1493069709,
 43261,
 -42740,
 1493850896,
 43259,
 -42739,
 1493914604,
 43257,
 -1,
 1493970490,
 43258,
 1494220799,
 1490707133,
 -1,
 1494243602,
 1494139538,
 -1,
 -42735,
 1494212624,
 983085,
 -1,
 1494245329,
 983087,
 -42733,
 1494204599,
 983160,
 -42732,
 1494389935,
 983083,
 -1,
 1494438175,
 983089,
 1494636835,
 1490662743,
 -1,
 1494702368,
 1494567038,
 -1,
 1494767902,
 1494632919,
 -1,
 1494833435,
 1494727816,
 -1,
 -42726,
 1494782573,
 66638,
 -1,
 1494830007,
 66639,
 1495072767,
 1494756886,
 -1,
 -42723,
 1494979181,
 66598,
 -1,
 1495026615,
 66599,
 1495269375,
 1494729362,
 127964,
 -1,
 1495139217,
 127965,
 1495400447,
 1494643691,
 -1,
 -42718,
 1495326236,
 128468,
 -1,
 1495348255,
 128421,
 1495554342,
 1494578252,
 983119,
 -42715,
 1495494322,
 128666,
 -1,
 1495550444,
 983118,
 1495750955,
 1495477476,
 -1,
 1495816490,
 1495687553,
 -1,
 -42711,
 1495761264,
 9192,
 -1,
 1495810169,
 127795,
 -1,
 1495772027,
 128475,
 -42708,
 1495706829,
 127962,
 -42707,
 1496031389,
 127980,
 -1,
 1496074366,
 129420,
 1496275300,
 1490575745,
 -1,
 1496340814,
 1496208114,
 -1,
 1496406336,
 1496280403,
 -1,
 1496471860,
 1496376975,
 -1,
 -42701,
 1496404705,
 127232,
 -1,
 1496462265,
 127233,
 1496668471,
 1496433298,
 -1,
 -42698,
 1496637472,
 127235,
 -1,
 1496670183,
 127236,
 1496865082,
 1496626519,
 -1,
 -42695,
 1496805081,
 127239,
 -1,
 1496861430,
 127240,
 1497061693,
 1496796391,
 -1,
 -42692,
 1497013028,
 127237,
 -1,
 1497067049,
 127238,
 -42690,
 1497011384,
 127234,
 -42689,
 1497205981,
 127242,
 -1,
 1497253146,
 127241,
 1497497599,
 1496361467,
 -1,
 1497520453,
 1497383483,
 119557,
 1497628671,
 1497464960,
 -1,
 -42684,
 1497551185,
 119556,
 -1,
 1497580207,
 119555,
 1497782600,
 1497463402,
 -1,
 -42681,
 1497720429,
 9869,
 -1,
 1497768124,
 9870,
 1497979211,
 1497716776,
 -1,
 -42678,
 1497944406,
 119554,
 -1,
 1497973429,
 119553,
 1498218495,
 1497913195,
 -1,
 -42675,
 1498113645,
 9871,
 -1,
 1498161340,
 9868,
 1498372438,
 1496260512,
 -1,
 1498437972,
 1498340960,
 -1,
 -42671,
 1498401146,
 11032,
 -42670,
 1498459963,
 11031,
 -42669,
 1498511448,
 11030,
 -1,
 1498557279,
 11033,
 -42667,
 1498399764,
 128924,
 -1,
 1498724628,
 128160,
 1498896731,
 1498330625,
 -1,
 1498962266,
 1498850584,
 -1,
 -42663,
 1498893631,
 128542,
 -1,
 1498950822,
 128549,
 -1,
 1498884741,
 9933,
 1499224414,
 1498867535,
 -1,
 -42659,
 1499185743,
 128171,
 -1,
 1499221311,
 128565,
 1499421025,
 1499171912,
 -1,
 -42656,
 1499368222,
 127244,
 -1,
 1499410794,
 127243,
 -42654,
 1499388434,
 9902,
 -42653,
 1499573237,
 127919,
 -1,
 1499613597,
 128754,
 1499814258,
 1496193332,
 -1,
 1499879786,
 1499747620,
 -1,
 1499945321,
 1499848288,
 -1,
 -42648,
 1499901715,
 11831,
 -1,
 1499953203,
 11830,
 -1,
 1499886428,
 128481,
 1500207469,
 1499838562,
 -1,
 -42644,
 1500176066,
 11843,
 -1,
 1500234319,
 128168,
 1500404080,
 1500154152,
 -1,
 -42641,
 1500337858,
 127841,
 -1,
 1500393296,
 128131,
 -42639,
 1500365595,
 983081,
 -1,
 1500558023,
 128374,
 1500731772,
 1499768962,
 -1,
 1500797303,
 1500680337,
 -1,
 -42635,
 1500750608,
 128167,
 -42634,
 1500812124,
 129316,
 -1,
 1500873666,
 128042,
 1501059449,
 1500716241,
 128009,
 -1,
 1500971708,
 128050,
 -42630,
 1501024574,
 129345,
 -42629,
 1501130371,
 9946,
 -1,
 1501186492,
 128087,
 1501387138,
 1500654820,
 -1,
 -42626,
 1501345111,
 983161,
 -42625,
 1501369432,
 983090,
 -42624,
 1501434682,
 983088,
 -42623,
 1501499925,
 983086,
 -1,
 1501565162,
 983084,
 -42621,
 1501353696,
 128192,
 -42620,
 1501727093,
 129516,
 -1,
 1501787981,
 983082,
 1501977590,
 1460236427,
 -1,
 1502042908,
 1501911080,
 -1,
 1502108172,
 1501988020,
 -1,
 1502173650,
 1502066007,
 -1,
 1502239185,
 1502143715,
 -1,
 1502304673,
 1502191309,
 -1,
 1502370205,
 1502259698,
 -1,
 1502435738,
 1502285414,
 -1,
 1502501268,
 1502357183,
 -1,
 1502566801,
 1502466687,
 -1,
 -42608,
 1502524191,
 6649,
 -1,
 1502573423,
 6633,
 1502806015,
 1502495999,
 -1,
 -42605,
 1502720799,
 6648,
 -1,
 1502770031,
 6632,
 1502960023,
 1502454405,
 -1,
 -42602,
 1502917407,
 6647,
 -1,
 1502966639,
 6631,
 1503199231,
 1502906575,
 -1,
 -42599,
 1503114015,
 6646,
 -1,
 1503163247,
 6630,
 1503395839,
 1502347264,
 -1,
 -42596,
 1503310623,
 6645,
 -1,
 1503359855,
 6629,
 1503549856,
 1502307726,
 -1,
 -42593,
 1503507231,
 6642,
 -1,
 1503556463,
 6626,
 -1,
 1503470876,
 6624,
 1503812023,
 1502230824,
 -1,
 1503877556,
 1503727206,
 -1,
 1503943082,
 1503829709,
 -1,
 1504008615,
 1503898102,
 -1,
 -42586,
 1503965983,
 6655,
 -1,
 1504015215,
 6639,
 1504247807,
 1503946126,
 -1,
 -42583,
 1504162591,
 6652,
 -1,
 1504211823,
 6636,
 1504401841,
 1503864511,
 -1,
 1504467374,
 1504367231,
 -1,
 -42579,
 1504424735,
 6654,
 -1,
 1504473967,
 6638,
 1504706559,
 1504396543,
 -1,
 -42576,
 1504621343,
 6653,
 -1,
 1504670575,
 6637,
 1504903167,
 1504348367,
 -1,
 -42573,
 1504817951,
 6651,
 -1,
 1504867183,
 6635,
 1505099775,
 1503789056,
 -1,
 -42570,
 1505014559,
 6650,
 -1,
 1505063791,
 6634,
 1505253830,
 1503754792,
 -1,
 1505319361,
 1505205965,
 -1,
 1505384896,
 1505274354,
 6133,
 1505492991,
 1505300070,
 -1,
 1505515966,
 1505371839,
 -1,
 -42563,
 1505481339,
 6137,
 -1,
 1505510652,
 6136,
 -42561,
 1505469057,
 6135,
 -1,
 1505659082,
 6134,
 -1,
 1505322379,
 6130,
 1505909188,
 1505240767,
 -1,
 -42557,
 1505874555,
 6132,
 -1,
 1505903868,
 6131,
 -42555,
 1505869221,
 6128,
 -1,
 1506052298,
 6129,
 1506236877,
 1505175231,
 -1,
 1506302410,
 1506202239,
 -1,
 -42551,
 1506259743,
 6644,
 -1,
 1506308975,
 6628,
 1506541567,
 1506231551,
 -1,
 -42548,
 1506456351,
 6643,
 -1,
 1506505583,
 6627,
 1506695632,
 1506183375,
 -1,
 -42545,
 1506652959,
 6641,
 -1,
 1506702191,
 6625,
 -1,
 1506659616,
 6640,
 -1,
 1502176573,
 6109,
 1507023362,
 1502098544,
 -1,
 1507088860,
 1506984594,
 -1,
 1507154391,
 1507050905,
 -1,
 -42538,
 1507102865,
 983950,
 -1,
 1507137844,
 983948,
 1507351002,
 1507088424,
 -1,
 -42535,
 1507299473,
 983955,
 -1,
 1507334452,
 983953,
 -42533,
 1507299473,
 983954,
 -1,
 1507465524,
 983952,
 1507678689,
 1507035432,
 -1,
 -42530,
 1507648804,
 983946,
 -42529,
 1507692689,
 983956,
 -42528,
 1507743426,
 983941,
 -1,
 1507793204,
 983951,
 1508006375,
 1507618955,
 -1,
 1508071909,
 1507940392,
 -1,
 -42524,
 1508020369,
 983940,
 -1,
 1508055348,
 983938,
 -42522,
 1508020369,
 983939,
 -1,
 1508186420,
 983937,
 1508399597,
 1507929316,
 -1,
 1508465131,
 1508333608,
 -1,
 -42518,
 1508413585,
 983945,
 -1,
 1508448564,
 983943,
 -42516,
 1508413585,
 983944,
 -1,
 1508579636,
 983942,
 1508792817,
 1508357463,
 -1,
 -42513,
 1508750849,
 983967,
 -42512,
 1508792382,
 983966,
 -1,
 1508841780,
 983968,
 1509054966,
 1508744909,
 -1,
 1509120501,
 1508988968,
 -1,
 -42508,
 1509068945,
 983960,
 -1,
 1509103924,
 983958,
 -1,
 1509068945,
 983959,
 1509382649,
 1508996172,
 -1,
 -42504,
 1509331089,
 983964,
 -1,
 1509366068,
 983970,
 1509579260,
 1509308431,
 -1,
 -42501,
 1509527697,
 983949,
 -1,
 1509562676,
 983947,
 -42499,
 1509549348,
 983962,
 -42498,
 1509742960,
 983965,
 -42497,
 1509798660,
 983963,
 -42496,
 1509852912,
 983961,
 -42495,
 1509906494,
 983969,
 -1,
 1509959412,
 983957,
 1510169096,
 1506961112,
 -1,
 1510234629,
 1510126894,
 983973,
 -1,
 1510204172,
 983974,
 1510408191,
 1510188754,
 -1,
 -42489,
 1510329885,
 983972,
 -1,
 1510359235,
 983975,
 1510604799,
 1510136432,
 -1,
 -42486,
 1510511507,
 983976,
 -42485,
 1510552406,
 983971,
 -1,
 1510611448,
 983977,
 1510824551,
 1502072894,
 -1,
 1510890058,
 1510767243,
 -1,
 1510955541,
 1510815759,
 -1,
 1511021075,
 1510881295,
 -1,
 -42479,
 1510955070,
 70347,
 -42478,
 1511012510,
 70345,
 -1,
 1511070004,
 70344,
 -42476,
 1510955070,
 70352,
 -1,
 1511201076,
 70351,
 1511414299,
 1510916754,
 -1,
 1511479833,
 1511375506,
 -1,
 -42472,
 1511413822,
 70343,
 -1,
 1511463220,
 70342,
 -42470,
 1511413822,
 70350,
 -1,
 1511594292,
 70349,
 1511807520,
 1511360808,
 -1,
 -42467,
 1511777140,
 70341,
 -42466,
 1511819634,
 70348,
 -42465,
 1511871297,
 70335,
 -1,
 1511921972,
 70353,
 1512135204,
 1511725364,
 70320,
 -42462,
 1512099357,
 70329,
 -42461,
 1512137089,
 70327,
 -1,
 1512184116,
 70321,
 1512397352,
 1512075103,
 -1,
 -42458,
 1512337277,
 70339,
 -42457,
 1512396862,
 70340,
 -1,
 1512446260,
 70338,
 1512659500,
 1512329970,
 -1,
 -42454,
 1512593470,
 70334,
 -42453,
 1512657729,
 70333,
 -1,
 1512708404,
 70332,
 1512921648,
 1512580799,
 -1,
 -42450,
 1512855614,
 70358,
 -42449,
 1512908532,
 70357,
 -1,
 1512970548,
 70356,
 1513183794,
 1512885789,
 70324,
 -1,
 1513147933,
 70325,
 1513314869,
 1513141591,
 -1,
 -42444,
 1513248830,
 70364,
 -1,
 1513298228,
 70365,
 1513511480,
 1513269378,
 -1,
 -42441,
 1513466101,
 70346,
 -1,
 1513494836,
 70361,
 1513708091,
 1513463501,
 -1,
 -42438,
 1513642046,
 70355,
 -1,
 1513691444,
 70354,
 1513904702,
 1513648267,
 -1,
 -42435,
 1513838654,
 70331,
 -1,
 1513888052,
 70330,
 1514101312,
 1513841025,
 70322,
 -1,
 1514037633,
 70323,
 1514232387,
 1514024164,
 -1,
 -42430,
 1514166334,
 70337,
 -1,
 1514215732,
 70336,
 -42428,
 1514201972,
 70360,
 -42427,
 1514395150,
 70363,
 -42426,
 1514442897,
 70328,
 -42425,
 1514504411,
 70359,
 -42424,
 1514566806,
 70362,
 -42423,
 1514625086,
 70366,
 -1,
 1514684611,
 70326,
 1514887768,
 1510816606,
 -1,
 1514953294,
 1514848914,
 -1,
 -42419,
 1514922000,
 70386,
 -1,
 1514954705,
 70387,
 1515149905,
 1514911063,
 -1,
 -42416,
 1515089618,
 70390,
 -1,
 1515145963,
 70391,
 1515346516,
 1515080935,
 -1,
 -42413,
 1515297563,
 70388,
 -1,
 1515351584,
 70389,
 -42411,
 1515316874,
 70384,
 -42410,
 1515492527,
 70385,
 -42409,
 1515556056,
 70393,
 -1,
 1515603213,
 70392,
 1515805283,
 1514855024,
 -1,
 1515870813,
 1515723060,
 -1,
 -42405,
 1515834909,
 70376,
 -42404,
 1515872641,
 70374,
 -1,
 1515919668,
 70368,
 1516132959,
 1515834909,
 70371,
 -1,
 1516097053,
 70372,
 1516264033,
 1516069249,
 70369,
 -1,
 1516200321,
 70370,
 -42398,
 1516212369,
 70375,
 -1,
 1516323011,
 70373,
 1516568575,
 1515764425,
 -1,
 -42395,
 1516493126,
 70378,
 -42394,
 1516539837,
 70377,
 -1,
 1516577166,
 70367,
 1516788425,
 1510744890,
 -1,
 1516853915,
 1516731019,
 -1,
 1516919410,
 1516814994,
 -1,
 1516984944,
 1516880530,
 -1,
 1517050478,
 1516946066,
 -1,
 -42387,
 1516984382,
 68147,
 -1,
 1517033780,
 68148,
 -42385,
 1516984382,
 68123,
 -1,
 1517164852,
 68122,
 -42383,
 1516918846,
 68128,
 -1,
 1517295924,
 68127,
 1517509240,
 1516845071,
 -1,
 1517574774,
 1517434895,
 -1,
 -42379,
 1517508670,
 68125,
 -1,
 1517558068,
 68124,
 -42377,
 1517508670,
 68130,
 -1,
 1517689140,
 68129,
 1517902460,
 1517466967,
 -1,
 -42374,
 1517860353,
 68142,
 -42373,
 1517901886,
 68141,
 -1,
 1517951284,
 68143,
 1518164608,
 1517848872,
 -1,
 -42370,
 1518134132,
 68121,
 -42369,
 1518176626,
 68126,
 -1,
 1518213428,
 68131,
 1518426756,
 1518104715,
 -1,
 -42366,
 1518366941,
 68146,
 -42365,
 1518426174,
 68113,
 -1,
 1518475572,
 68112,
 1518688903,
 1518392824,
 -1,
 -42362,
 1518622782,
 68149,
 -1,
 1518672180,
 68140,
 1518885514,
 1518640845,
 -1,
 -42359,
 1518819390,
 68133,
 -1,
 1518868788,
 68132,
 1519082125,
 1518818034,
 -1,
 -42356,
 1519015998,
 68115,
 -1,
 1519065396,
 68114,
 1519278736,
 1519004900,
 -1,
 -42353,
 1519212606,
 68118,
 -1,
 1519262004,
 68117,
 1519475347,
 1519199935,
 -1,
 -42350,
 1519409214,
 68135,
 -1,
 1519458612,
 68134,
 -42348,
 1519445453,
 68144,
 -42347,
 1519641460,
 68137,
 -42346,
 1519692021,
 68138,
 -42345,
 1519747291,
 68136,
 -42344,
 1519809686,
 68139,
 -42343,
 1519873917,
 68119,
 -42342,
 1519933502,
 68145,
 -1,
 1519982900,
 68096,
 1520196265,
 1516807750,
 -1,
 1520261793,
 1520121871,
 -1,
 1520327328,
 1520210065,
 -1,
 -42337,
 1520291673,
 68183,
 -1,
 1520353938,
 68176,
 -1,
 1520246920,
 68182,
 1520589476,
 1520202828,
 -1,
 -42333,
 1520540309,
 68181,
 -1,
 1520592834,
 68184,
 1520786087,
 1520512228,
 -1,
 -42330,
 1520741687,
 68179,
 -1,
 1520790492,
 68178,
 -42328,
 1520745568,
 68177,
 -1,
 1520927332,
 68180,
 1521113779,
 1520162296,
 -1,
 1521179314,
 1521065543,
 -1,
 1521244849,
 1521138377,
 -1,
 -42323,
 1521211805,
 68099,
 -42322,
 1521274397,
 68098,
 -42321,
 1521324177,
 68102,
 -42320,
 1521377665,
 68097,
 -1,
 1521434819,
 68101,
 -1,
 1521187390,
 68108,
 -1,
 1521118166,
 68159,
 1521769147,
 1521072841,
 -1,
 1521834679,
 1521695757,
 -1,
 -42314,
 1521799065,
 68109,
 -1,
 1521861290,
 68154,
 -42312,
 1521801549,
 68111,
 -42311,
 1521954483,
 68153,
 -42310,
 1522018204,
 68152,
 -1,
 1522082190,
 68110,
 1522293442,
 1521717191,
 -1,
 1522358975,
 1522254482,
 -1,
 -42306,
 1522326658,
 68165,
 -1,
 1522353738,
 68164,
 1522597887,
 1522308275,
 -1,
 -42303,
 1522517597,
 68167,
 -1,
 1522557191,
 68166,
 1522752200,
 1522219870,
 -1,
 1522817734,
 1522713234,
 -1,
 -42299,
 1522786320,
 68161,
 -1,
 1522819025,
 68162,
 -42297,
 1522767023,
 68160,
 -1,
 1522946335,
 68163,
 -1,
 1522684422,
 68168,
 1523253247,
 1516737171,
 -1,
 1523276546,
 1523153547,
 -1,
 1523342034,
 1523202063,
 -1,
 1523407568,
 1523267599,
 -1,
 -42290,
 1523341374,
 70167,
 -42289,
 1523398814,
 70172,
 -1,
 1523456308,
 70166,
 -42287,
 1523341374,
 70173,
 -1,
 1523587380,
 70171,
 1523800792,
 1523303058,
 -1,
 1523866326,
 1523761810,
 -1,
 -42283,
 1523800126,
 70165,
 -1,
 1523849524,
 70164,
 -42281,
 1523800126,
 70170,
 -1,
 1523980596,
 70169,
 1524194013,
 1523747112,
 -1,
 -42278,
 1524163444,
 70163,
 -42277,
 1524205938,
 70168,
 -42276,
 1524257601,
 70157,
 -1,
 1524308276,
 70174,
 1524521697,
 1524111668,
 70144,
 -42273,
 1524485661,
 70151,
 -42272,
 1524523393,
 70149,
 -1,
 1524570420,
 70145,
 1524783845,
 1524454130,
 -1,
 -42269,
 1524717630,
 70156,
 -42268,
 1524781889,
 70155,
 -1,
 1524832564,
 70154,
 1525045993,
 1524704959,
 -1,
 -42265,
 1524979774,
 70179,
 -42264,
 1525032692,
 70178,
 -1,
 1525094708,
 70177,
 1525308140,
 1524997837,
 -1,
 -42261,
 1525241918,
 70176,
 -1,
 1525291316,
 70175,
 1525504751,
 1525249100,
 -1,
 -42258,
 1525445782,
 70187,
 -1,
 1525487924,
 70183,
 1525701362,
 1525444747,
 -1,
 -42255,
 1525635134,
 70153,
 -1,
 1525684532,
 70152,
 1525897973,
 1525641055,
 -1,
 -42252,
 1525837693,
 70161,
 -1,
 1525881140,
 70160,
 1526094584,
 1525820644,
 -1,
 -42249,
 1526028350,
 70159,
 -1,
 1526077748,
 70158,
 -42247,
 1526063988,
 70181,
 -42246,
 1526257166,
 70184,
 -42245,
 1526320669,
 70147,
 -42244,
 1526380033,
 70185,
 -42243,
 1526442229,
 70182,
 -42242,
 1526501521,
 70150,
 -42241,
 1526563035,
 70180,
 -42240,
 1526620545,
 70146,
 -42239,
 1526683710,
 70186,
 -1,
 1526743235,
 70148,
 1526946572,
 1523243632,
 -1,
 1527012103,
 1526864180,
 -1,
 -42235,
 1526976029,
 70195,
 -42234,
 1527013761,
 70193,
 -1,
 1527060788,
 70188,
 1527274249,
 1526948225,
 70189,
 -1,
 1527210369,
 70190,
 -42230,
 1527238173,
 70191,
 -42229,
 1527353489,
 70194,
 -1,
 1527398595,
 70192,
 1527601941,
 1526904151,
 -1,
 1527667476,
 1527539000,
 -1,
 1527733009,
 1527625047,
 -1,
 -42224,
 1527697625,
 70206,
 -1,
 1527732323,
 70199,
 -42222,
 1527699782,
 70197,
 -42221,
 1527877565,
 70198,
 -1,
 1527914894,
 70196,
 -1,
 1527595775,
 70203,
 1528191770,
 1527527439,
 -1,
 1528257305,
 1528142493,
 -1,
 -42216,
 1528215391,
 70204,
 -1,
 1528248602,
 70201,
 -1,
 1528176776,
 70200,
 -42213,
 1528160646,
 70202,
 -1,
 1528437337,
 70205,
 1528650709,
 1501960500,
 -1,
 1528716150,
 1528589788,
 -1,
 1528781657,
 1528658571,
 -1,
 1528847142,
 1528707087,
 -1,
 1528912676,
 1528772623,
 -1,
 -42206,
 1528846398,
 69787,
 -42205,
 1528904360,
 69786,
 -1,
 1528961332,
 69785,
 -42203,
 1528846398,
 69793,
 -1,
 1529092404,
 69792,
 1529305900,
 1528808082,
 -1,
 1529371434,
 1529266834,
 -1,
 -42199,
 1529305150,
 69784,
 -1,
 1529354548,
 69783,
 -42197,
 1529305150,
 69791,
 -1,
 1529485620,
 69790,
 1529699121,
 1529252136,
 -1,
 -42194,
 1529668468,
 69782,
 -42193,
 1529710962,
 69789,
 -42192,
 1529762625,
 69777,
 -1,
 1529813300,
 69794,
 1530026805,
 1529616692,
 69763,
 -42189,
 1529990685,
 69772,
 -42188,
 1530028417,
 69770,
 -1,
 1530075444,
 69764,
 1530288953,
 1529984343,
 -1,
 -42185,
 1530246657,
 69805,
 -42184,
 1530288190,
 69804,
 -1,
 1530337588,
 69806,
 1530551099,
 1530252829,
 69767,
 -1,
 1530514973,
 69768,
 1530682174,
 1530505346,
 -1,
 -42179,
 1530615870,
 69788,
 -1,
 1530665268,
 69801,
 1530878785,
 1530633933,
 -1,
 -42176,
 1530812478,
 69796,
 -1,
 1530861876,
 69795,
 1531075396,
 1530818699,
 -1,
 -42173,
 1531009086,
 69774,
 -1,
 1531058484,
 69773,
 1531272007,
 1531015007,
 -1,
 -42170,
 1531205694,
 69781,
 -1,
 1531255092,
 69780,
 1531468617,
 1531208065,
 69765,
 -1,
 1531404673,
 69766,
 1531599692,
 1531400946,
 -1,
 -42165,
 1531533374,
 69776,
 -1,
 1531582772,
 69775,
 1531796303,
 1531522276,
 -1,
 -42162,
 1531729982,
 69779,
 -1,
 1531779380,
 69778,
 1531992914,
 1531717311,
 -1,
 -42159,
 1531926590,
 69798,
 -1,
 1531975988,
 69797,
 -42157,
 1531962228,
 69800,
 -42156,
 1532155406,
 69803,
 -42155,
 1532203153,
 69771,
 -42154,
 1532264667,
 69799,
 -42153,
 1532327062,
 69802,
 -42152,
 1532385342,
 69807,
 -1,
 1532444867,
 69769,
 1532648292,
 1528748656,
 -1,
 1532713822,
 1532565812,
 -1,
 -42148,
 1532677661,
 69816,
 -42147,
 1532715393,
 69814,
 -1,
 1532762420,
 69808,
 1532975968,
 1532677661,
 69811,
 -1,
 1532939805,
 69812,
 1533107042,
 1532912001,
 69809,
 -1,
 1533043073,
 69810,
 -42141,
 1533055121,
 69815,
 -1,
 1533165763,
 69813,
 1533369197,
 1532605783,
 -1,
 1533434732,
 1533306168,
 -1,
 1533500265,
 1533401322,
 -1,
 -42136,
 1533458129,
 69762,
 -1,
 1533520388,
 69817,
 -42134,
 1533448125,
 69818,
 -42133,
 1533619640,
 69760,
 -1,
 1533682062,
 69761,
 -1,
 1533362943,
 69822,
 1533959026,
 1533294607,
 -1,
 1534024561,
 1533909661,
 -1,
 -42128,
 1533982559,
 69823,
 -1,
 1534015770,
 69825,
 -1,
 1533943944,
 69824,
 1534286708,
 1533906895,
 69821,
 -1,
 1534197765,
 69837,
 -42123,
 1534216149,
 69820,
 -1,
 1534335577,
 69819,
 1534548918,
 1528685439,
 -1,
 1534614427,
 1534491275,
 -1,
 1534679932,
 1534560552,
 -1,
 -42118,
 1534649204,
 43281,
 -42117,
 1534677825,
 43277,
 -1,
 1534728500,
 43284,
 1534942079,
 1534640786,
 -1,
 -42114,
 1534875710,
 43294,
 -1,
 1534925108,
 43282,
 1535138690,
 1534899543,
 -1,
 -42111,
 1535072318,
 43279,
 -1,
 1535121716,
 43278,
 1535335301,
 1535090381,
 -1,
 -42108,
 1535268926,
 43286,
 -1,
 1535318324,
 43285,
 1535531912,
 1535283345,
 -1,
 -42105,
 1535479953,
 43301,
 -1,
 1535525059,
 43299,
 1535728523,
 1535471755,
 -1,
 -42102,
 1535662142,
 43275,
 -1,
 1535711540,
 43274,
 1535925134,
 1535662120,
 -1,
 -42099,
 1535886104,
 43283,
 -1,
 1535908148,
 43295,
 -42097,
 1535894989,
 43280,
 -42096,
 1536090996,
 43291,
 -42095,
 1536154404,
 43293,
 -42094,
 1536218638,
 43296,
 -42093,
 1536272629,
 43290,
 -42092,
 1536327899,
 43287,
 -42091,
 1536390294,
 43292,
 -42090,
 1536450945,
 43300,
 -42089,
 1536512833,
 43276,
 -42088,
 1536571550,
 43288,
 -42087,
 1536634139,
 43297,
 -42086,
 1536698100,
 43289,
 -1,
 1536760116,
 43298,
 1536973737,
 1534540638,
 -1,
 1537039263,
 1536934546,
 -1,
 -42082,
 1537007632,
 43266,
 -1,
 1537040337,
 43267,
 1537235874,
 1536996695,
 -1,
 -42079,
 1537175250,
 43270,
 -1,
 1537231595,
 43271,
 1537432485,
 1537166567,
 -1,
 -42076,
 1537383195,
 43268,
 -1,
 1537437216,
 43269,
 -42074,
 1537402506,
 43264,
 -42073,
 1537578159,
 43265,
 -42072,
 1537641688,
 43273,
 -1,
 1537688845,
 43272,
 1537891247,
 1536940590,
 -1,
 1537956780,
 1537855005,
 43304,
 -1,
 1537884355,
 43302,
 1538087854,
 1537884355,
 43303,
 -1,
 1538015427,
 43305,
 -1,
 1538035857,
 43306,
 1538284467,
 1537853780,
 -1,
 1538350002,
 1538207089,
 43308,
 -1,
 1538262747,
 43309,
 -1,
 1538302788,
 43307,
 1538588671,
 1538243273,
 -1,
 -42059,
 1538505295,
 43311,
 -1,
 1538537463,
 43310,
 1538743237,
 1534495016,
 -1,
 1538808772,
 1538689454,
 -1,
 1538874305,
 1538767561,
 -1,
 1538939836,
 1538831703,
 -1,
 -42053,
 1538891607,
 3200,
 -1,
 1538941730,
 3204,
 -42051,
 1538904905,
 3314,
 -42050,
 1539084221,
 3260,
 -42049,
 1539141632,
 3313,
 -42048,
 1539190200,
 3201,
 -1,
 1539253803,
 3261,
 1539464131,
 1538841246,
 3298,
 -1,
 1539404876,
 3299,
 -1,
 1539406483,
 983203,
 -1,
 1538741278,
 129432,
 1539726292,
 1538704288,
 -1,
 1539791820,
 1539647895,
 -1,
 -42040,
 1539755549,
 983985,
 -42039,
 1539805329,
 983987,
 -42038,
 1539858817,
 983984,
 -42037,
 1539915971,
 983986,
 -1,
 1539971380,
 983983,
 1540227071,
 1539709236,
 -1,
 1540250579,
 1540123246,
 -1,
 1540316113,
 1540211346,
 -1,
 -42032,
 1540279837,
 983989,
 -1,
 1540329617,
 983990,
 -42030,
 1540267725,
 983991,
 -1,
 1540435673,
 983988,
 -1,
 1540205280,
 110592,
 -1,
 1539643941,
 128331,
 1540774889,
 1528581333,
 128273,
 1540840424,
 1540697582,
 -1,
 1540905957,
 1540766558,
 -1,
 1540971483,
 1540866706,
 -1,
 -42022,
 1540939792,
 983556,
 -1,
 1540972497,
 983557,
 1541168094,
 1540928855,
 -1,
 -42019,
 1541107410,
 983560,
 -1,
 1541163755,
 983561,
 1541364705,
 1541098727,
 -1,
 -42016,
 1541315355,
 983558,
 -1,
 1541369376,
 983559,
 -42014,
 1541334666,
 983554,
 -42013,
 1541510319,
 983555,
 -42012,
 1541573848,
 983563,
 -1,
 1541621005,
 983562,
 -42010,
 1540867299,
 128287,
 -42009,
 1541771215,
 983552,
 -1,
 1541809325,
 983553,
 -1,
 1540762333,
 128422,
 1542085620,
 1540710785,
 -1,
 1542151154,
 1542045350,
 128143,
 1542216689,
 1542088675,
 -1,
 1542282224,
 1542147391,
 128535,
 1542389759,
 1542196003,
 -1,
 -42001,
 1542307110,
 128537,
 -1,
 1542337226,
 128538,
 -1,
 1542205054,
 128573,
 -1,
 1542128776,
 128139,
 -41997,
 1542118924,
 129373,
 -1,
 1542621031,
 128088,
 -41995,
 1542042470,
 11235,
 -1,
 1542754526,
 128040,
 1542938000,
 1501931650,
 -1,
 1543003244,
 1542865091,
 -1,
 1543068711,
 1542942617,
 -1,
 1543134229,
 1543010955,
 -1,
 1543199747,
 1543080232,
 -1,
 1543265278,
 1543168780,
 -1,
 -41987,
 1543204733,
 43333,
 -1,
 1543248180,
 43323,
 1543461889,
 1543197426,
 -1,
 -41984,
 1543394113,
 43331,
 -1,
 1543444788,
 43314,
 -41982,
 1543387294,
 43332,
 -1,
 1543575860,
 43317,
 1543789574,
 1543143557,
 -1,
 -41979,
 1543710452,
 43330,
 -1,
 1543772468,
 43320,
 -41977,
 1543758708,
 43327,
 -41976,
 1543953188,
 43328,
 -41975,
 1544012568,
 43315,
 -41974,
 1544074753,
 43324,
 -41973,
 1544136949,
 43325,
 -41972,
 1544199977,
 43318,
 -41971,
 1544254614,
 43326,
 -41970,
 1544319197,
 43312,
 -41969,
 1544384381,
 43322,
 -41968,
 1544443966,
 43329,
 -41967,
 1544508225,
 43313,
 -41966,
 1544566942,
 43316,
 -41965,
 1544629531,
 43321,
 -41964,
 1544693492,
 43319,
 -1,
 1544755508,
 43334,
 1544969249,
 1543099896,
 -1,
 1545034784,
 1544920653,
 -1,
 1545100314,
 1544962243,
 43337,
 -41959,
 1545063965,
 43341,
 -1,
 1545083188,
 43342,
 1545296925,
 1545017652,
 -1,
 -41956,
 1545260573,
 43340,
 -1,
 1545298305,
 43338,
 -41954,
 1545260573,
 43336,
 -41953,
 1545441425,
 43339,
 -1,
 1545494913,
 43335,
 -1,
 1544973270,
 43347,
 1545755686,
 1544893536,
 -1,
 1545821220,
 1545701672,
 43344,
 -1,
 1545753330,
 43343,
 -41947,
 1545775234,
 43345,
 -1,
 1545885736,
 43346,
 -1,
 1545713503,
 43359,
 1546148930,
 1543001674,
 -1,
 -41943,
 1546118589,
 127487,
 -41942,
 1546183436,
 127486,
 -41941,
 1546248705,
 127485,
 -41940,
 1546312420,
 127484,
 -41939,
 1546376696,
 127483,
 -41938,
 1546440221,
 127482,
 -41937,
 1546502802,
 127481,
 -41936,
 1546564951,
 127480,
 -41935,
 1546627202,
 127479,
 -41934,
 1546692306,
 127478,
 -41933,
 1546755789,
 127477,
 -41932,
 1546817681,
 127476,
 -41931,
 1546881320,
 127475,
 -41930,
 1546944645,
 127474,
 -41929,
 1547007052,
 127473,
 -41928,
 1547071627,
 127472,
 -41927,
 1547136863,
 127471,
 -41926,
 1547198849,
 127470,
 -41925,
 1547261992,
 127469,
 -41924,
 1547326194,
 127468,
 -41923,
 1547390183,
 127467,
 -41922,
 1547452611,
 127466,
 -41921,
 1547515919,
 127465,
 -41920,
 1547578596,
 127464,
 -41919,
 1547642559,
 127463,
 -1,
 1547704628,
 127462,
 1547918427,
 1546114552,
 -1,
 1547983962,
 1547848012,
 -1,
 1548049488,
 1547909137,
 -1,
 1548115016,
 1548011342,
 -1,
 -41913,
 1548079884,
 128402,
 -1,
 1548107570,
 128403,
 1548311627,
 1548068994,
 -1,
 -41910,
 1548248215,
 11262,
 -1,
 1548295530,
 128401,
 -41908,
 1548277997,
 128404,
 -41907,
 1548462119,
 11822,
 -41906,
 1548507573,
 128405,
 -41905,
 1548570802,
 11793,
 -1,
 1548628921,
 11841,
 1548877823,
 1547960320,
 -1,
 1548901460,
 1548797937,
 -1,
 -41901,
 1548857511,
 11079,
 -1,
 1548908931,
 11073,
 1549098071,
 1548843859,
 -1,
 -41898,
 1549044455,
 983151,
 -1,
 1549096394,
 128968,
 -41896,
 1549057414,
 10184,
 -41895,
 1549231874,
 983152,
 -1,
 1549283331,
 128639,
 -1,
 1547932549,
 128158,
 1549556832,
 1547878474,
 -1,
 1549622367,
 1549492993,
 -1,
 -41890,
 1549537813,
 9953,
 -1,
 1549603050,
 9952,
 -1,
 1549571763,
 128699,
 1549884516,
 1549479140,
 -1,
 -41886,
 1549839255,
 128665,
 -41885,
 1549899923,
 983112,
 -1,
 1549944194,
 129534,
 1550146663,
 1549847721,
 -1,
 -41882,
 1550102278,
 11153,
 -1,
 1550153768,
 11152,
 1550343274,
 1550071825,
 -1,
 -41879,
 1550276150,
 129511,
 -1,
 1550328299,
 127822,
 -41877,
 1550288432,
 127895,
 -1,
 1550482313,
 128524,
 1550671081,
 1542939009,
 983153,
 1550736596,
 1550603699,
 -1,
 1550802095,
 1550703492,
 -1,
 1550867591,
 1550762642,
 -1,
 1550933125,
 1550823037,
 -1,
 1550998660,
 1550847694,
 -1,
 1551064194,
 1550918514,
 11106,
 1551171583,
 1550974976,
 -1,
 1551195264,
 1551097440,
 -1,
 1551260792,
 1551138366,
 -1,
 -41865,
 1551225804,
 11173,
 -1,
 1551253341,
 11175,
 1551457403,
 1551187311,
 -1,
 -41862,
 1551423559,
 983238,
 -1,
 1551458061,
 11132,
 -41860,
 1551423626,
 129074,
 -41859,
 1551600090,
 129058,
 -41858,
 1551664127,
 129062,
 -41857,
 1551719262,
 129070,
 -1,
 1551772456,
 129066,
 -41855,
 1551157518,
 11122,
 -1,
 1551932689,
 11138,
 -41853,
 1551015795,
 11142,
 -1,
 1552038204,
 11116,
 -1,
 1550909720,
 129170,
 -41850,
 1550901505,
 11246,
 -1,
 1552258842,
 129187,
 1552440473,
 1550787448,
 -1,
 1552506003,
 1552408160,
 -1,
 1552571532,
 1552468149,
 -1,
 -41845,
 1552536524,
 11023,
 -1,
 1552564061,
 11022,
 1552768143,
 1552530442,
 -1,
 -41842,
 1552730808,
 129026,
 -1,
 1552762984,
 129042,
 -41840,
 1552715350,
 129178,
 -41839,
 1552909338,
 129030,
 -41838,
 1552971276,
 129034,
 -1,
 1553025128,
 129046,
 1553226902,
 1552467717,
 -1,
 -41835,
 1553187260,
 11076,
 -1,
 1553225589,
 11075,
 1553465343,
 1553144467,
 -1,
 -41832,
 1553385442,
 11084,
 -1,
 1553407725,
 11080,
 1553620127,
 1552361151,
 -1,
 1553685661,
 1553560770,
 -1,
 -41828,
 1553609096,
 11146,
 -1,
 1553671026,
 11157,
 -41826,
 1553635939,
 129185,
 -1,
 1553799934,
 129193,
 1554013346,
 1553577303,
 -1,
 -41823,
 1553967005,
 129082,
 -1,
 1553998145,
 129106,
 1554209957,
 1553967234,
 -1,
 -41820,
 1554157923,
 128622,
 -1,
 1554212057,
 129189,
 1554406568,
 1554144070,
 -1,
 -41817,
 1554330638,
 129090,
 -1,
 1554391922,
 129094,
 1554603179,
 1554336999,
 -1,
 -41814,
 1554559852,
 129195,
 -1,
 1554606351,
 129078,
 -41812,
 1554570531,
 129174,
 -41811,
 1554753369,
 11078,
 -41810,
 1554807071,
 129191,
 -1,
 1554854926,
 129086,
 1555061963,
 1550712832,
 -1,
 1555127482,
 1555019095,
 -1,
 1555193015,
 1555079380,
 -1,
 1555258550,
 1555111440,
 128360,
 1555365887,
 1555172131,
 -1,
 -41803,
 1555285735,
 128362,
 -1,
 1555338544,
 128361,
 -1,
 1555186409,
 128489,
 -41800,
 1555156979,
 11779,
 -41799,
 1555522411,
 11815,
 -1,
 1555566450,
 10182,
 1555782847,
 1555046588,
 -1,
 1555848382,
 1555724112,
 -1,
 -41795,
 1555808656,
 11776,
 -1,
 1555840333,
 11777,
 -1,
 1555777678,
 128495,
 1556110530,
 1555743378,
 -1,
 -41791,
 1556064833,
 11786,
 -1,
 1556111231,
 128493,
 1556307141,
 1556043838,
 -1,
 -41788,
 1556253276,
 128381,
 -1,
 1556314897,
 11241,
 1556503752,
 1556233229,
 -1,
 -41785,
 1556467585,
 11817,
 -1,
 1556532233,
 11781,
 -41783,
 1556469742,
 11809,
 -41782,
 1556654506,
 11789,
 -1,
 1556709121,
 11805,
 1556938751,
 1554976358,
 -1,
 1556962513,
 1556827471,
 -1,
 1557028047,
 1556922859,
 4053,
 -1,
 1556941827,
 4055,
 -41776,
 1556959092,
 129308,
 -1,
 1557078819,
 1421,
 -41774,
 1556924702,
 8295,
 -41773,
 1557242947,
 128270,
 -1,
 1557289430,
 9957,
 1557486818,
 1550657619,
 127872,
 1557594111,
 1557397734,
 -1,
 1557617881,
 1557516939,
 -1,
 -41768,
 1557573382,
 11187,
 -1,
 1557624872,
 11186,
 1557814492,
 1557573388,
 -1,
 -41765,
 1557779080,
 11189,
 -1,
 1557806776,
 11191,
 1558011103,
 1557755949,
 -1,
 -41762,
 1557975688,
 11188,
 -1,
 1558003384,
 11190,
 1558249471,
 1557937853,
 -1,
 -41759,
 1558163206,
 11185,
 -1,
 1558214696,
 11184,
 1558404325,
 1557433340,
 128141,
 -41756,
 1558341608,
 128365,
 -1,
 1558382631,
 11824,
 1558600936,
 1558327004,
 -1,
 -41753,
 1558525310,
 127832,
 -1,
 1558587226,
 127833,
 -1,
 1558532078,
 129350,
 1558863156,
 1550634525,
 -1,
 1558928668,
 1558807810,
 -1,
 1558994185,
 1558876103,
 -1,
 1559059700,
 1558954642,
 -1,
 1559125232,
 1559026404,
 -1,
 -41745,
 1559072921,
 69235,
 -1,
 1559119801,
 69226,
 1559321843,
 1559058472,
 -1,
 -41742,
 1559276639,
 69236,
 -1,
 1559325820,
 69227,
 -1,
 1559250506,
 69225,
 1559583995,
 1559016791,
 -1,
 1559649528,
 1559523026,
 -1,
 -41737,
 1559612929,
 69230,
 -1,
 1559626584,
 69239,
 1559887871,
 1559579371,
 -1,
 -41734,
 1559809537,
 69231,
 -1,
 1559823192,
 69240,
 1560042754,
 1559514343,
 -1,
 1560108287,
 1559990417,
 -1,
 -41730,
 1560073258,
 69237,
 -1,
 1560130751,
 69228,
 1560346623,
 1560043905,
 -1,
 -41727,
 1560270578,
 69238,
 -1,
 1560302294,
 69229,
 1560501509,
 1559989464,
 -1,
 -41724,
 1560464897,
 69233,
 -1,
 1560478552,
 69242,
 1560698120,
 1560429837,
 -1,
 -41721,
 1560666892,
 69232,
 -1,
 1560675160,
 69241,
 -1,
 1560646868,
 69234,
 1560960278,
 1558920030,
 -1,
 1561025805,
 1560920722,
 -1,
 -41716,
 1560993808,
 69217,
 -1,
 1561026513,
 69218,
 1561222416,
 1560982871,
 -1,
 -41713,
 1561161426,
 69221,
 -1,
 1561217771,
 69222,
 1561419027,
 1561152743,
 -1,
 -41710,
 1561369371,
 69219,
 -1,
 1561423392,
 69220,
 -41708,
 1561367727,
 69216,
 -41707,
 1561562328,
 69224,
 -1,
 1561609485,
 69223,
 1561853951,
 1560891884,
 -1,
 1561877787,
 1561760947,
 -1,
 -41703,
 1561839146,
 69245,
 -41702,
 1561896874,
 69244,
 -1,
 1561942234,
 69243,
 -1,
 1561841142,
 69246,
 1562205483,
 1558874408,
 -1,
 1562271016,
 1562141356,
 -1,
 1562336549,
 1562202655,
 -1,
 1562402082,
 1562253620,
 -1,
 -41695,
 1562331536,
 5880,
 -1,
 1562389732,
 5879,
 -41693,
 1562352008,
 5876,
 -41692,
 1562537093,
 5877,
 -1,
 1562592442,
 5878,
 -41690,
 1562294367,
 5874,
 -41689,
 1562744439,
 5875,
 -1,
 1562800267,
 5873,
 1563033599,
 1562216744,
 -1,
 -41686,
 1562929349,
 127933,
 -1,
 1562986622,
 127939,
 1563188530,
 1562164987,
 -1,
 -41683,
 1563154721,
 11251,
 -41682,
 1563216487,
 11256,
 -41681,
 1563277222,
 11255,
 -41680,
 1563338860,
 11253,
 -41679,
 1563397756,
 11252,
 -1,
 1563437543,
 11254,
 -41677,
 1563120763,
 127945,
 -1,
 1563568747,
 8381,
 1563778408,
 1558810769,
 -1,
 1563843916,
 1563722271,
 -1,
 1563909438,
 1563800919,
 -1,
 1563974973,
 1563836611,
 -1,
 1564040507,
 1563943621,
 -1,
 -41670,
 1564004581,
 65939,
 -1,
 1564025144,
 65936,
 -41668,
 1564000220,
 65944,
 -1,
 1564182710,
 65938,
 -1,
 1563911665,
 65941,
 1564433732,
 1563856876,
 -1,
 1564499266,
 1564364390,
 -1,
 -41663,
 1564460637,
 8583,
 -1,
 1564492307,
 8582,
 -41661,
 1564457887,
 8581,
 -1,
 1564644576,
 8584,
 1564826952,
 1564358671,
 -1,
 -41658,
 1564791637,
 65945,
 -41657,
 1564829247,
 65940,
 -1,
 1564886705,
 65942,
 -41655,
 1564791209,
 65937,
 -41654,
 1565042772,
 65943,
 -41653,
 1565077298,
 65947,
 -1,
 1565140008,
 65946,
 1565351256,
 1563808231,
 -1,
 1565416789,
 1565279083,
 -1,
 1565482321,
 1565374559,
 -1,
 -41648,
 1565445863,
 127588,
 -1,
 1565498010,
 127586,
 -41646,
 1565450905,
 127587,
 -41645,
 1565622305,
 127585,
 -41644,
 1565676250,
 127584,
 -1,
 1565732170,
 127589,
 1565982719,
 1565327360,
 -1,
 -41641,
 1565901844,
 128907,
 -1,
 1565959843,
 128205,
 1566137694,
 1565293840,
 -1,
 1566203228,
 1566064835,
 -1,
 -41637,
 1566156943,
 127906,
 -1,
 1566193796,
 128478,
 -41635,
 1566140561,
 129315,
 -1,
 1566311715,
 129531,
 1566530913,
 1566098459,
 -1,
 -41632,
 1566498132,
 11215,
 -1,
 1566538744,
 11213,
 1566727523,
 1566488377,
 127801,
 -1,
 1566690303,
 127989,
 -41628,
 1566694452,
 128675,
 -41627,
 1566808497,
 128019,
 -41626,
 1566847603,
 128640,
 -41625,
 1566911301,
 129302,
 -1,
 1566975130,
 127840,
 1567186313,
 1563695412,
 -1,
 1567251838,
 1567121793,
 -1,
 1567317369,
 1567209337,
 -1,
 1567382895,
 1567250821,
 9995,
 1567490047,
 1567296291,
 -1,
 -41618,
 1567400056,
 128406,
 -1,
 1567444783,
 128400,
 1567645042,
 1567326341,
 -1,
 -41615,
 1567570036,
 127339,
 -1,
 1567632634,
 127338,
 1567841652,
 1567571022,
 11827,
 -1,
 1567802514,
 11783,
 -41611,
 1567800911,
 11787,
 -41610,
 1567910456,
 11782,
 -41609,
 1567969140,
 9994,
 -41608,
 1568027577,
 11828,
 -1,
 1568089858,
 129306,
 1568300411,
 1567263016,
 9926,
 -1,
 1568222100,
 127752,
 1568473087,
 1568243828,
 -1,
 -41603,
 1568393746,
 128740,
 -1,
 1568419382,
 128643,
 1568628099,
 1567173860,
 -1,
 1568693634,
 1568565219,
 -1,
 -41599,
 1568638903,
 127949,
 -1,
 1568681526,
 127950,
 -1,
 1568617731,
 129437,
 1568955781,
 1568553877,
 128251,
 -1,
 1568866692,
 128280,
 1569086855,
 1568876622,
 128007,
 -1,
 1568998076,
 128048,
 -41592,
 1569047186,
 128000,
 -1,
 1569161349,
 128015,
 1569349006,
 1567126604,
 -1,
 -41589,
 1569296529,
 983226,
 -41588,
 1569357957,
 983221,
 -41587,
 1569415553,
 983231,
 -1,
 1569472707,
 983223,
 -41585,
 1569305943,
 983113,
 -1,
 1569611115,
 129423,
 1569808061,
 1542904548,
 -1,
 1569873429,
 1569724724,
 -1,
 1569938945,
 1569826946,
 -1,
 1570004480,
 1569857733,
 -1,
 1570069948,
 1569963144,
 -1,
 1570135450,
 1570038540,
 -1,
 1570200984,
 1570098717,
 71875,
 -1,
 1570139999,
 71886,
 -41575,
 1570148497,
 71877,
 -1,
 1570249012,
 71876,
 1570463136,
 1570068520,
 -1,
 1570528670,
 1570410641,
 -1,
 -41571,
 1570485284,
 71899,
 -1,
 1570536902,
 71898,
 -41569,
 1570467666,
 71897,
 -1,
 1570644501,
 71900,
 1570856356,
 1570380084,
 71873,
 -41566,
 1570816658,
 71893,
 -41565,
 1570868220,
 71882,
 -1,
 1570930821,
 71894,
 1571118504,
 1570783427,
 71880,
 1571225599,
 1571064104,
 -1,
 -41561,
 1571152652,
 71885,
 -1,
 1571195176,
 71888,
 1571380651,
 1571081757,
 -1,
 -41558,
 1571343901,
 71879,
 -1,
 1571368164,
 71887,
 1571577262,
 1571337559,
 -1,
 -41555,
 1571537375,
 71901,
 -1,
 1571579275,
 71902,
 1571773872,
 1571524753,
 71881,
 -1,
 1571699033,
 71889,
 1571904947,
 1571719464,
 -1,
 -41550,
 1571869220,
 71891,
 -1,
 1571902276,
 71872,
 -41548,
 1571872248,
 71874,
 -41547,
 1572067691,
 71903,
 -41546,
 1572129791,
 71890,
 -41545,
 1572185630,
 71896,
 -41544,
 1572238184,
 71884,
 -41543,
 1572300171,
 71878,
 -41542,
 1572361025,
 71883,
 -41541,
 1572419742,
 71892,
 -1,
 1572482124,
 71895,
 1572691428,
 1569992214,
 -1,
 1572756930,
 1572659980,
 -1,
 1572822464,
 1572720157,
 71843,
 -1,
 1572761439,
 71854,
 -41535,
 1572769937,
 71845,
 -1,
 1572870452,
 71844,
 1573084616,
 1572689960,
 -1,
 1573150150,
 1573032081,
 -1,
 -41531,
 1573106724,
 71867,
 -1,
 1573158342,
 71866,
 -41529,
 1573089106,
 71865,
 -1,
 1573265941,
 71868,
 1573477836,
 1573001524,
 71841,
 -41526,
 1573438098,
 71861,
 -41525,
 1573489660,
 71850,
 -1,
 1573552261,
 71862,
 1573739984,
 1573404867,
 71848,
 1573847039,
 1573685544,
 -1,
 -41521,
 1573774092,
 71853,
 -1,
 1573816616,
 71856,
 1574002131,
 1573703197,
 -1,
 -41518,
 1573965341,
 71847,
 -1,
 1573989604,
 71855,
 1574198742,
 1573958999,
 -1,
 -41515,
 1574158815,
 71869,
 -1,
 1574200715,
 71870,
 1574395352,
 1574146193,
 71849,
 -1,
 1574320473,
 71857,
 1574526427,
 1574340904,
 -1,
 -41510,
 1574490660,
 71859,
 -1,
 1574523716,
 71840,
 -41508,
 1574493688,
 71842,
 -41507,
 1574689131,
 71871,
 -41506,
 1574751231,
 71858,
 -41505,
 1574807070,
 71864,
 -41504,
 1574859624,
 71852,
 -41503,
 1574921611,
 71846,
 -41502,
 1574982465,
 71851,
 -41501,
 1575041182,
 71860,
 -1,
 1575103564,
 71863,
 1575312882,
 1572617054,
 -1,
 1575378408,
 1575273106,
 -1,
 -41497,
 1575346192,
 71906,
 -1,
 1575378897,
 71907,
 1575575019,
 1575335255,
 -1,
 -41494,
 1575513810,
 71910,
 -1,
 1575570155,
 71911,
 1575771630,
 1575505127,
 -1,
 -41491,
 1575721755,
 71908,
 -1,
 1575775776,
 71909,
 -41489,
 1575741066,
 71904,
 -41488,
 1575916719,
 71905,
 -41487,
 1575980248,
 71913,
 -1,
 1576027405,
 71912,
 1576230399,
 1575260103,
 -1,
 1576295927,
 1576190610,
 -1,
 -41483,
 1576262786,
 71915,
 -41482,
 1576295833,
 71916,
 -1,
 1576355402,
 71914,
 1576558074,
 1576252759,
 -1,
 -41479,
 1576496922,
 71919,
 -1,
 1576553269,
 71920,
 1576754685,
 1576488167,
 -1,
 -41476,
 1576704366,
 71917,
 -1,
 1576756195,
 71918,
 -41474,
 1576701192,
 71922,
 -1,
 1576879456,
 71921,
 -1,
 1576178579,
 71935,
 -1,
 1569951021,
 9888,
 1577213448,
 1569899803,
 -1,
 1577278983,
 1577123840,
 -1,
 -41468,
 1577245684,
 127754,
 -41467,
 1577297030,
 129341,
 -41466,
 1577333499,
 128702,
 -1,
 1577397335,
 128003,
 -1,
 1577223287,
 127817,
 1577672206,
 1577178616,
 -1,
 1577737741,
 1577609187,
 -1,
 -41461,
 1577704777,
 127987,
 -41460,
 1577736619,
 128075,
 -1,
 1577790019,
 127988,
 -1,
 1577664720,
 11071,
 1578065425,
 1577640620,
 -1,
 -41456,
 1577997841,
 127764,
 -1,
 1578055096,
 127762,
 1578262036,
 1578011919,
 -1,
 -41453,
 1578194449,
 127766,
 -1,
 1578251704,
 127768,
 -1,
 1578221495,
 128465,
 1578524259,
 1569806376,
 -1,
 1578589793,
 1578462644,
 -1,
 1578655269,
 1578546519,
 -1,
 1578720797,
 1578619262,
 127779,
 1578827775,
 1578631168,
 -1,
 1578851868,
 1578707105,
 127781,
 -1,
 1578765732,
 127782,
 -1,
 1578819367,
 127780,
 1579048482,
 1578674063,
 -1,
 1579114017,
 1578972364,
 -1,
 -41440,
 1579079854,
 128916,
 -1,
 1579123724,
 128917,
 -1,
 1579035832,
 128307,
 1579417599,
 1578992059,
 -1,
 -41436,
 1579335561,
 11090,
 -1,
 1579384726,
 11051,
 1579572785,
 1578579983,
 -1,
 1579638315,
 1579508299,
 -1,
 1579703850,
 1579562188,
 -1,
 -41431,
 1579669659,
 128922,
 -1,
 1579713520,
 128923,
 -1,
 1579640449,
 9931,
 1579965998,
 1579592354,
 -1,
 -41427,
 1579909659,
 9920,
 -1,
 1579971312,
 9921,
 1580204031,
 1579916897,
 -1,
 -41424,
 1580103802,
 128407,
 -1,
 1580148495,
 128071,
 1580359225,
 1579512908,
 -1,
 1580424757,
 1580287070,
 -1,
 -41420,
 1580377086,
 128072,
 -1,
 1580430764,
 9945,
 1580621368,
 1580341556,
 -1,
 -41417,
 1580583042,
 128326,
 -1,
 1580641816,
 11036,
 -1,
 1580572327,
 128928,
 1580883519,
 1580319378,
 -1,
 1580949053,
 1580836994,
 -1,
 -41412,
 1580884586,
 10177,
 -1,
 1580933562,
 9186,
 -41410,
 1580917034,
 9943,
 -1,
 1581095646,
 128382,
 1581276741,
 1580826757,
 -1,
 1581342276,
 1581204392,
 -1,
 -41406,
 1581301641,
 11088,
 -41405,
 1581350806,
 11048,
 -1,
 1581398819,
 11046,
 -1,
 1581291202,
 11229,
 1581669963,
 1581209640,
 -1,
 1581735497,
 1581596867,
 -1,
 -41400,
 1581703719,
 11041,
 -1,
 1581721178,
 9989,
 -41398,
 1581684953,
 11053,
 -1,
 1581851273,
 128427,
 1582063185,
 1581599975,
 -1,
 1582128720,
 1582003276,
 -1,
 1582194255,
 1582046360,
 9872,
 -1,
 1582107829,
 9983,
 -1,
 1582145112,
 128174,
 -1,
 1582078855,
 11214,
 1582456404,
 1582028671,
 -1,
 -41389,
 1582424910,
 11038,
 -1,
 1582483334,
 11055,
 1582653015,
 1582411526,
 -1,
 -41386,
 1582567263,
 11092,
 -1,
 1582630958,
 128073,
 1582849626,
 1582604590,
 -1,
 -41383,
 1582809958,
 11040,
 -1,
 1582860749,
 127985,
 1583046237,
 1582769031,
 -1,
 -41380,
 1583009270,
 129197,
 -1,
 1583060143,
 129196,
 -41378,
 1583010527,
 128070,
 -41377,
 1583196213,
 10068,
 -41376,
 1583238113,
 10069,
 -1,
 1583296766,
 128906,
 -41374,
 1578517467,
 9855,
 -1,
 1583423083,
 128011,
 1583636128,
 1578459521,
 -1,
 1583701655,
 1583561121,
 -1,
 1583767154,
 1583660473,
 -1,
 1583832684,
 1583733927,
 -1,
 -41368,
 1583798388,
 129159,
 -41367,
 1583842270,
 129143,
 -41366,
 1583905728,
 129127,
 -41365,
 1583962957,
 129151,
 -1,
 1584015322,
 129135,
 1584267263,
 1583759937,
 -1,
 -41362,
 1584191604,
 129158,
 -41361,
 1584235486,
 129142,
 -41360,
 1584298944,
 129126,
 -41359,
 1584356173,
 129150,
 -1,
 1584408538,
 129134,
 1584619135,
 1583713819,
 -1,
 1584684665,
 1584585895,
 -1,
 -41355,
 1584650356,
 129156,
 -41354,
 1584694238,
 129140,
 -41353,
 1584757696,
 129124,
 -41352,
 1584814925,
 129148,
 -1,
 1584867290,
 129132,
 1585119231,
 1584611905,
 -1,
 -41349,
 1585043572,
 129157,
 -41348,
 1585087454,
 129141,
 -41347,
 1585150912,
 129125,
 -41346,
 1585208141,
 129149,
 -1,
 1585260506,
 129133,
 1585471109,
 1584583636,
 -1,
 -41343,
 1585436788,
 129153,
 -41342,
 1585480670,
 129137,
 -41341,
 1585544128,
 129121,
 -41340,
 1585601357,
 129145,
 -1,
 1585653722,
 129129,
 1585864331,
 1585426571,
 -1,
 -41337,
 1585830004,
 129154,
 -41336,
 1585873886,
 129138,
 -41335,
 1585937344,
 129122,
 -41334,
 1585994573,
 129146,
 -1,
 1586046938,
 129130,
 1586257553,
 1585805673,
 -1,
 -41331,
 1586223220,
 129152,
 -41330,
 1586267102,
 129136,
 -41329,
 1586330560,
 129120,
 -41328,
 1586387789,
 129144,
 -1,
 1586440154,
 129128,
 1586692095,
 1586184039,
 -1,
 -41325,
 1586616436,
 129155,
 -41324,
 1586660318,
 129139,
 -41323,
 1586723776,
 129123,
 -41322,
 1586781005,
 129147,
 -1,
 1586833370,
 129131,
 1587043997,
 1583647016,
 -1,
 1587109531,
 1586968593,
 -1,
 -41318,
 1587032167,
 127888,
 -1,
 1587096250,
 127788,
 -41316,
 1587049215,
 128521,
 -1,
 1587233044,
 127863,
 -41314,
 1586998326,
 128430,
 -41313,
 1587380179,
 129344,
 -1,
 1587434834,
 11838,
 1587633839,
 1583583377,
 -1,
 1587699370,
 1587576965,
 -1,
 1587764905,
 1587617720,
 128105,
 1587830440,
 1587721561,
 -1,
 -41307,
 1587787411,
 128097,
 -41306,
 1587829380,
 128082,
 -41305,
 1587884838,
 128090,
 -1,
 1587948351,
 128098,
 -1,
 1587743548,
 128111,
 -1,
 1587693386,
 128698,
 1588289198,
 1587652738,
 -1,
 -41300,
 1588244168,
 128543,
 -41299,
 1588295435,
 128506,
 -1,
 1588344925,
 11825,
 -1,
 1588230943,
 128058,
 1588616887,
 1587560643,
 -1,
 1588682419,
 1588552065,
 -1,
 -41294,
 1588614633,
 127947,
 -1,
 1588676945,
 983234,
 1588879030,
 1588601852,
 -1,
 -41291,
 1588809023,
 128553,
 -1,
 1588866662,
 128576,
 -1,
 1588803946,
 128146,
 1589141180,
 1588570242,
 -1,
 1589206715,
 1589067971,
 -1,
 -41286,
 1589166101,
 129340,
 -1,
 1589217825,
 128295,
 -1,
 1589125597,
 127873,
 -1,
 1589079903,
 983229,
 1589534658,
 1569743233,
 -1,
 1589600138,
 1589479720,
 -1,
 1589665569,
 1589524495,
 983129,
 1589731104,
 1589600641,
 -1,
 1589796639,
 1589652737,
 -1,
 1589862166,
 1589743559,
 -1,
 1589927636,
 1589822098,
 -1,
 1589993163,
 1589893860,
 -1,
 1590058697,
 1589940369,
 126066,
 1590165503,
 1589968896,
 -1,
 -41272,
 1590085213,
 126093,
 -1,
 1590124807,
 126084,
 1590362111,
 1589987257,
 126075,
 -1,
 1590233498,
 126102,
 1590451922,
 1589925928,
 -1,
 1590517456,
 1590406235,
 126067,
 1590624255,
 1590427648,
 -1,
 -41265,
 1590543965,
 126094,
 -1,
 1590583559,
 126085,
 1590820863,
 1590455420,
 126076,
 -1,
 1590692250,
 126103,
 1590951935,
 1590380106,
 126074,
 -1,
 1590823322,
 126101,
 1591041761,
 1589884247,
 -1,
 1591107291,
 1590980306,
 126070,
 1591172824,
 1591070209,
 126079,
 -1,
 1591085466,
 126106,
 1591345151,
 1591083008,
 -1,
 -41254,
 1591264861,
 126097,
 -1,
 1591304455,
 126088,
 1591541759,
 1591036651,
 126071,
 1591566046,
 1591463425,
 126080,
 -1,
 1591478682,
 126107,
 1591738367,
 1591476224,
 -1,
 -41248,
 1591658077,
 126098,
 -1,
 1591697671,
 126089,
 1591893744,
 1590971623,
 -1,
 1591959273,
 1591840913,
 -1,
 1592024807,
 1591923751,
 126068,
 1592131583,
 1591934976,
 -1,
 -41242,
 1592051293,
 126095,
 -1,
 1592090887,
 126086,
 1592328191,
 1591981247,
 126077,
 -1,
 1592199578,
 126104,
 1592459263,
 1591894401,
 -1,
 1592483566,
 1592383203,
 126069,
 1592590335,
 1592393728,
 -1,
 -41235,
 1592510045,
 126096,
 -1,
 1592549639,
 126087,
 1592786943,
 1592414934,
 126078,
 -1,
 1592658330,
 126105,
 1592876797,
 1591846262,
 -1,
 1592942324,
 1592836754,
 -1,
 -41229,
 1592909840,
 126116,
 -1,
 1592942545,
 126117,
 1593138935,
 1592898903,
 -1,
 -41226,
 1593077458,
 126120,
 -1,
 1593133803,
 126121,
 1593335546,
 1593068775,
 -1,
 -41223,
 1593285403,
 126118,
 -1,
 1593339424,
 126119,
 -41221,
 1593283759,
 126115,
 -41220,
 1593478360,
 126123,
 -1,
 1593525517,
 126122,
 1593728771,
 1592823000,
 126073,
 1593794304,
 1593691649,
 126082,
 -1,
 1593706906,
 126109,
 1593966591,
 1593704448,
 -1,
 -41214,
 1593886301,
 126100,
 -1,
 1593925895,
 126091,
 1594121993,
 1593656589,
 126072,
 1594187526,
 1594090252,
 126081,
 -1,
 1594100122,
 126108,
 1594359807,
 1594097664,
 -1,
 -41208,
 1594279517,
 126099,
 -1,
 1594319111,
 126090,
 1594515213,
 1594070191,
 126065,
 1594621951,
 1594425344,
 -1,
 -41204,
 1594541661,
 126092,
 -1,
 1594581255,
 126083,
 1594777362,
 1594433314,
 -1,
 1594842897,
 1594737298,
 -1,
 -41200,
 1594810384,
 126130,
 -1,
 1594836633,
 126131,
 -1,
 1594791087,
 126129,
 1595105044,
 1594717543,
 126110,
 -1,
 1595023288,
 126111,
 1595277311,
 1595044218,
 126113,
 -1,
 1595154360,
 126114,
 1595367195,
 1589793260,
 -1,
 1595432730,
 1595315379,
 -1,
 -41191,
 1595385770,
 126125,
 -1,
 1595431130,
 126126,
 -1,
 1595393752,
 126127,
 -41188,
 1595323672,
 126128,
 -41187,
 1595646657,
 126124,
 -41186,
 1595700588,
 126112,
 -1,
 1595744045,
 126132,
 -1,
 1589714879,
 8377,
 -1,
 1589660609,
 983128,
 1596088174,
 1589622570,
 -1,
 1596153674,
 1596044437,
 -1,
 1596219198,
 1596095115,
 -1,
 1596284713,
 1596175703,
 -1,
 1596350248,
 1596201268,
 -1,
 -41177,
 1596294244,
 68430,
 -1,
 1596340922,
 68433,
 -1,
 1596284229,
 68436,
 1596612396,
 1596244626,
 -1,
 -41173,
 1596541436,
 68424,
 -1,
 1596597865,
 68437,
 1596809006,
 1596545717,
 68420,
 -1,
 1596769689,
 68423,
 1596940081,
 1596725556,
 -1,
 -41168,
 1596908688,
 68431,
 -1,
 1596947032,
 68416,
 -41166,
 1596909149,
 68422,
 -41165,
 1597105468,
 68425,
 -41164,
 1597168650,
 68421,
 -41163,
 1597222211,
 68435,
 -41162,
 1597286211,
 68434,
 -41161,
 1597350100,
 68432,
 -41160,
 1597411331,
 68429,
 -41159,
 1597473917,
 68428,
 -41158,
 1597535635,
 68427,
 -41157,
 1597600080,
 68426,
 -41156,
 1597658692,
 68418,
 -41155,
 1597716720,
 68419,
 -1,
 1597778183,
 68417,
 1598029823,
 1596166087,
 -1,
 1598054213,
 1597948562,
 -1,
 1598119747,
 1598020324,
 -1,
 -41150,
 1598066833,
 68441,
 -1,
 1598113721,
 68445,
 -41148,
 1598054353,
 68442,
 -1,
 1598244426,
 68444,
 1598447433,
 1598002351,
 68440,
 1598554111,
 1598357504,
 -1,
 -41144,
 1598473821,
 68447,
 -1,
 1598513415,
 68446,
 -1,
 1598378271,
 68443,
 1598816255,
 1596087788,
 -1,
 1598840674,
 1598716555,
 -1,
 1598906193,
 1598797143,
 -1,
 1598971728,
 1598822708,
 -1,
 -41137,
 1598915684,
 68462,
 -1,
 1598962362,
 68464,
 -1,
 1598905669,
 68465,
 1599233876,
 1598866066,
 -1,
 -41133,
 1599162876,
 68456,
 -1,
 1599219305,
 68466,
 1599430486,
 1599167157,
 68452,
 -1,
 1599391129,
 68455,
 -41129,
 1599399517,
 68454,
 -41128,
 1599530300,
 68457,
 -41127,
 1599593496,
 68453,
 -41126,
 1599643860,
 68463,
 -41125,
 1599705091,
 68461,
 -41124,
 1599767681,
 68460,
 -41123,
 1599829395,
 68459,
 -41122,
 1599893840,
 68458,
 -41121,
 1599952452,
 68450,
 -41120,
 1600010480,
 68451,
 -41119,
 1600071943,
 68449,
 -1,
 1600134790,
 68448,
 1600389119,
 1598787527,
 -1,
 1600413545,
 1600307858,
 -1,
 1600479079,
 1600379620,
 -1,
 -41114,
 1600426129,
 68473,
 -1,
 1600473017,
 68477,
 -41112,
 1600413649,
 68474,
 -1,
 1600603722,
 68476,
 1600806765,
 1600361647,
 68472,
 1600913407,
 1600716800,
 -1,
 -41108,
 1600833117,
 68479,
 -1,
 1600872711,
 68478,
 -1,
 1600737567,
 68475,
 1601134454,
 1596052984,
 -1,
 1601199989,
 1601063276,
 -1,
 1601265522,
 1601142518,
 11845,
 -1,
 1601178921,
 11846,
 -41101,
 1601229304,
 8276,
 -41100,
 1601347976,
 9959,
 -1,
 1601399373,
 11800,
 -1,
 1601137853,
 8292,
 1601658749,
 1601087159,
 -1,
 1601724283,
 1601599088,
 -1,
 -41095,
 1601682597,
 128289,
 -41094,
 1601731289,
 128292,
 -1,
 1601777190,
 128288,
 -41092,
 1601684094,
 128291,
 -1,
 1601933284,
 128290,
 1602117509,
 1601589445,
 -1,
 1602183044,
 1602074582,
 -1,
 1602248578,
 1602142866,
 -1,
 -41087,
 1602215952,
 983111,
 -1,
 1602248657,
 983108,
 -41085,
 1602196655,
 983114,
 -1,
 1602375967,
 983105,
 -1,
 1602108030,
 128129,
 1602641800,
 1602039012,
 -1,
 -41081,
 1602595707,
 128474,
 -1,
 1602655222,
 128232,
 -41079,
 1602602271,
 9892,
 -1,
 1602759594,
 128229,
 1602969524,
 1589544927,
 128127,
 1603076095,
 1602898155,
 -1,
 1603100583,
 1602976395,
 -1,
 1603166098,
 1603056983,
 -1,
 1603231633,
 1603082548,
 -1,
 -41072,
 1603175524,
 67662,
 -1,
 1603222202,
 67665,
 -1,
 1603165509,
 67668,
 1603493781,
 1603125906,
 -1,
 -41068,
 1603422716,
 67656,
 -1,
 1603479145,
 67669,
 1603690391,
 1603426997,
 67652,
 -1,
 1603650969,
 67655,
 1603821466,
 1603606836,
 -1,
 -41063,
 1603789968,
 67663,
 -1,
 1603828312,
 67648,
 -41061,
 1603790429,
 67654,
 -41060,
 1603986748,
 67657,
 -41059,
 1604049930,
 67653,
 -41058,
 1604103491,
 67667,
 -41057,
 1604167491,
 67666,
 -41056,
 1604231380,
 67664,
 -41055,
 1604292611,
 67661,
 -41054,
 1604355197,
 67660,
 -41053,
 1604416915,
 67659,
 -41052,
 1604481360,
 67658,
 -41051,
 1604539972,
 67650,
 -41050,
 1604598000,
 67651,
 -1,
 1604659463,
 67649,
 1604870067,
 1603047367,
 -1,
 1604935599,
 1604829842,
 -1,
 1605001132,
 1604901604,
 -1,
 -41045,
 1604948113,
 67673,
 -1,
 1604995001,
 67676,
 1605197742,
 1604929098,
 67675,
 -1,
 1605110170,
 67679,
 -1,
 1605132241,
 67674,
 1605435391,
 1604883631,
 67672,
 1605500927,
 1605304320,
 -1,
 -41038,
 1605420637,
 67678,
 -1,
 1605460231,
 67677,
 -1,
 1604826988,
 67671,
 1605722044,
 1602894364,
 -1,
 1605787576,
 1605681810,
 -1,
 -41033,
 1605754896,
 119667,
 -1,
 1605787601,
 119668,
 1605984187,
 1605717223,
 -1,
 -41030,
 1605933851,
 119669,
 -1,
 1605987872,
 119670,
 -1,
 1605932207,
 119666,
 1606246336,
 1605643996,
 -1,
 -41026,
 1606204388,
 9976,
 -41025,
 1606245926,
 127954,
 -1,
 1606301069,
 127848,
 -41023,
 1606215160,
 127982,
 -1,
 1606419533,
 129311,
 1606639716,
 1589464295,
 -1,
 1606705143,
 1606555956,
 -1,
 1606770670,
 1606626532,
 -1,
 1606836204,
 1606697157,
 -1,
 1606901734,
 1606803035,
 -1,
 1606967269,
 1606811648,
 -1,
 1607032783,
 1606914193,
 -1,
 1607098317,
 1606984012,
 128558,
 1607204863,
 1607008256,
 -1,
 -41012,
 1607129590,
 129326,
 -1,
 1607147535,
 128560,
 -41010,
 1607043797,
 129320,
 -1,
 1607299216,
 128582,
 1607491539,
 1606992215,
 128539,
 1607598079,
 1607401538,
 -1,
 -41006,
 1607523907,
 128540,
 -1,
 1607583665,
 128541,
 1607753686,
 1607451282,
 -1,
 -41003,
 1607687130,
 129298,
 -1,
 1607746078,
 128514,
 1607950297,
 1607704269,
 -1,
 -41000,
 1607890862,
 129402,
 -1,
 1607934943,
 129395,
 1608146908,
 1607893125,
 -1,
 -40997,
 1608095260,
 129488,
 -1,
 1608139676,
 128567,
 1608343519,
 1608069964,
 -1,
 -40994,
 1608309818,
 129312,
 -1,
 1608349488,
 128531,
 -40992,
 1608307209,
 129396,
 -40991,
 1608495953,
 128580,
 -40990,
 1608551847,
 128581,
 -40989,
 1608613463,
 128548,
 -40988,
 1608669937,
 129301,
 -1,
 1608732417,
 129323,
 -1,
 1606917136,
 128566,
 1608998889,
 1606858071,
 -1,
 -40984,
 1608922515,
 128561,
 -1,
 1608984121,
 128523,
 -40982,
 1608959768,
 128536,
 -40981,
 1609146271,
 129318,
 -1,
 1609204493,
 128134,
 -40979,
 1606797799,
 127981,
 -1,
 1609349903,
 8507,
 1609523185,
 1606738435,
 -1,
 -40976,
 1609466096,
 128224,
 -1,
 1609523956,
 128439,
 1609719796,
 1609465104,
 -1,
 -40973,
 1609656314,
 9950,
 -1,
 1609713233,
 127810,
 -40971,
 1609680381,
 127877,
 -40970,
 1609860643,
 128106,
 -1,
 1609919617,
 129498,
 1610113048,
 1606640001,
 -1,
 1610178567,
 1610066050,
 -1,
 1610244097,
 1610105027,
 128293,
 1610309629,
 1610211733,
 -1,
 -40964,
 1610265943,
 127878,
 -1,
 1610287378,
 127879,
 1610506240,
 1610220203,
 -1,
 -40961,
 1610474198,
 129519,
 -1,
 1610517620,
 128658,
 -1,
 1610429822,
 129512,
 1610809343,
 1610202938,
 -1,
 1610833925,
 1610721211,
 -1,
 -40956,
 1610800758,
 127771,
 -1,
 1610859087,
 127763,
 -40954,
 1610793245,
 8296,
 -1,
 1610982069,
 129351,
 1611161615,
 1610118220,
 -1,
 1611227148,
 1611088069,
 -1,
 -40950,
 1611184076,
 983106,
 -40949,
 1611223182,
 128193,
 -1,
 1611279669,
 128452,
 1611530239,
 1611169927,
 -1,
 -40946,
 1611441621,
 128253,
 -1,
 1611485720,
 127902,
 1611685908,
 1611117911,
 -1,
 1611751443,
 1611618344,
 128031,
 -40942,
 1611688115,
 127907,
 -1,
 1611727244,
 127845,
 -1,
 1611711620,
 128074,
 1612013591,
 1611650794,
 -1,
 -40938,
 1611966010,
 8281,
 -1,
 1612022405,
 11821,
 -1,
 1611941279,
 127953,
 1612275759,
 1610059921,
 -1,
 1612341282,
 1612238365,
 -1,
 1612406817,
 1612294276,
 -1,
 1612472350,
 1612332114,
 -1,
 -40931,
 1612424762,
 8280,
 -1,
 1612481157,
 8283,
 -40929,
 1612424161,
 128966,
 -40928,
 1612609492,
 127808,
 -1,
 1612657982,
 11156,
 -1,
 1612353346,
 9970,
 1612931113,
 1612294274,
 -1,
 1612996647,
 1612869771,
 -1,
 1613062182,
 1612906600,
 127860,
 -1,
 1612975512,
 127869,
 -1,
 1612989258,
 11792,
 -40920,
 1612958851,
 129376,
 -1,
 1613201560,
 983071,
 1613389867,
 1612880311,
 129462,
 -1,
 1613342126,
 128099,
 1613520941,
 1613320946,
 127787,
 -1,
 1613453334,
 127745,
 -40914,
 1613488646,
 129418,
 -1,
 1613592392,
 128448,
 1613783107,
 1612215372,
 -1,
 1613848630,
 1613729937,
 -1,
 1613914165,
 1613814942,
 9880,
 1614020607,
 1613825748,
 -1,
 -40908,
 1613943232,
 8277,
 -1,
 1613985493,
 127924,
 -1,
 1613866321,
 128190,
 1614241850,
 1613816987,
 -1,
 -40904,
 1614198497,
 128760,
 -40903,
 1614235622,
 128389,
 -1,
 1614298056,
 129359,
 1614503999,
 1614158132,
 -1,
 1614569534,
 1614463634,
 -1,
 -40899,
 1614515108,
 9189,
 -1,
 1614547167,
 129407,
 -1,
 1614500603,
 9971,
 1614831682,
 1614430403,
 -1,
 -40895,
 1614799461,
 128170,
 -1,
 1614861372,
 9884,
 -1,
 1614796096,
 128563,
 1615093840,
 1613736066,
 -1,
 1615159368,
 1615040657,
 -1,
 -40890,
 1615126483,
 128550,
 -40889,
 1615171351,
 128037,
 -1,
 1615221492,
 128056,
 1615421516,
 1615077250,
 -1,
 -40886,
 1615382535,
 128445,
 -40885,
 1615438423,
 128444,
 -1,
 1615470541,
 128446,
 1615683663,
 1615347907,
 -1,
 -40882,
 1615628837,
 127839,
 -1,
 1615678684,
 129398,
 -1,
 1615618948,
 127844,
 1615945815,
 1615056413,
 -1,
 1616011348,
 1615887648,
 -1,
 -40877,
 1615978102,
 127773,
 -1,
 1616036431,
 127765,
 -40875,
 1615968057,
 9179,
 -40874,
 1616153485,
 9905,
 -1,
 1616201107,
 9981,
 1616404573,
 1615872195,
 -1,
 1616470107,
 1616360484,
 -1,
 -40870,
 1616438028,
 9972,
 -1,
 1616473224,
 127905,
 -40868,
 1616415260,
 129338,
 -1,
 1616585387,
 128552,
 1616797793,
 1616370379,
 -1,
 -40865,
 1616712506,
 983215,
 -40864,
 1616777749,
 983214,
 -1,
 1616842986,
 983213,
 1617059939,
 1616754007,
 983107,
 -1,
 1616994689,
 983232,
 -1,
 1616989415,
 983072,
 1617256681,
 1606578015,
 -1,
 1617322211,
 1617172788,
 -1,
 1617387738,
 1617286707,
 -1,
 1617453215,
 1617327949,
 -1,
 1617518750,
 1617415203,
 -1,
 1617584241,
 1617463592,
 -1,
 1617649773,
 1617515329,
 43412,
 1617756159,
 1617560604,
 43402,
 -1,
 1617627251,
 43403,
 1617846383,
 1617617780,
 43418,
 -1,
 1617757386,
 43416,
 1618018303,
 1617762612,
 43428,
 -1,
 1617888458,
 43423,
 1618108534,
 1617543826,
 -1,
 1618174068,
 1618068248,
 43419,
 -1,
 1618084980,
 43420,
 1618345983,
 1618090292,
 43424,
 -1,
 1618216138,
 43425,
 1618436219,
 1618032655,
 -1,
 1618501753,
 1618360478,
 43421,
 -1,
 1618412660,
 43422,
 1618673663,
 1618417972,
 43426,
 -1,
 1618543732,
 43427,
 1618763903,
 1618392577,
 43441,
 1618870271,
 1618674785,
 -1,
 -40834,
 1618793565,
 43439,
 -1,
 1618812177,
 43440,
 1619026051,
 1618714409,
 43429,
 1619132415,
 1618935808,
 -1,
 -40830,
 1619036373,
 43430,
 -1,
 1619079012,
 43401,
 1619288199,
 1618964701,
 43407,
 1619394559,
 1619197952,
 -1,
 -40826,
 1619310295,
 43408,
 -1,
 1619364053,
 43409,
 1619550346,
 1619222913,
 43398,
 -40823,
 1619485057,
 43399,
 -1,
 1619526597,
 43397,
 1619746956,
 1619503349,
 43435,
 -1,
 1619656730,
 43436,
 1619878030,
 1619685245,
 43415,
 -1,
 1619788916,
 43417,
 1620009104,
 1619809089,
 43410,
 -1,
 1619920074,
 43411,
 1620140178,
 1619930395,
 43413,
 -1,
 1620051146,
 43414,
 1620271252,
 1620059892,
 43431,
 -1,
 1620182218,
 43432,
 1620402326,
 1620187444,
 43396,
 -1,
 1620337025,
 43405,
 -40809,
 1620370292,
 43434,
 -40808,
 1620499236,
 43438,
 -40807,
 1620561437,
 43400,
 -40806,
 1620611217,
 43406,
 -40805,
 1620672731,
 43433,
 -40804,
 1620735126,
 43437,
 -40803,
 1620793406,
 43442,
 -1,
 1620852931,
 43404,
 -1,
 1617449631,
 43457,
 1621123252,
 1617403689,
 -1,
 1621188785,
 1621047457,
 -1,
 1621254310,
 1621128268,
 -1,
 1621319845,
 1621216797,
 -1,
 -40796,
 1621265530,
 43465,
 -1,
 1621320003,
 43461,
 -1,
 1621256503,
 43464,
 1621581994,
 1621170484,
 -1,
 1621647529,
 1621506515,
 43466,
 -1,
 1621557268,
 43467,
 -1,
 1621592727,
 43459,
 1621844141,
 1621532365,
 -1,
 -40788,
 1621781653,
 43468,
 -1,
 1621827819,
 43463,
 -40786,
 1621810723,
 43462,
 -40785,
 1622001875,
 43486,
 -40784,
 1622049071,
 43460,
 -1,
 1622109340,
 43487,
 1622343679,
 1621134332,
 -1,
 -40781,
 1622256173,
 43471,
 -1,
 1622307714,
 43456,
 1622499522,
 1621048158,
 -1,
 1622565048,
 1622459026,
 -1,
 -40777,
 1622532112,
 43474,
 -1,
 1622564817,
 43475,
 1622761659,
 1622521175,
 -1,
 -40774,
 1622699730,
 43478,
 -1,
 1622756075,
 43479,
 1622958270,
 1622691047,
 -1,
 -40771,
 1622907675,
 43476,
 -1,
 1622961696,
 43477,
 -40769,
 1622926986,
 43472,
 -40768,
 1623102639,
 43473,
 -40767,
 1623166168,
 43481,
 -1,
 1623213325,
 43480,
 1623417038,
 1622465136,
 -1,
 1623482568,
 1623376530,
 -1,
 1623548103,
 1623398708,
 -1,
 -40762,
 1623504147,
 43444,
 -1,
 1623555206,
 43450,
 -1,
 1623495551,
 43445,
 1623810250,
 1623450105,
 43446,
 -1,
 1623721102,
 43447,
 1623941324,
 1623769520,
 43448,
 -1,
 1623852181,
 43449,
 -40755,
 1623892380,
 43452,
 -1,
 1623997373,
 43451,
 1624203476,
 1623374537,
 -1,
 1624269009,
 1624125178,
 43393,
 -1,
 1624181134,
 43443,
 -40750,
 1624235540,
 43395,
 -40749,
 1624350667,
 43392,
 -1,
 1624405711,
 43394,
 1624596696,
 1624126560,
 -1,
 -40746,
 1624547687,
 43454,
 -40745,
 1624601157,
 43453,
 -1,
 1624649049,
 43455,
 -40743,
 1624558835,
 43469,
 -1,
 1624813463,
 43458,
 1624989922,
 1617338299,
 -1,
 -40740,
 1624949342,
 128304,
 -40739,
 1625007317,
 127971,
 -40738,
 1625068121,
 128121,
 -40737,
 1625118405,
 128122,
 -40736,
 1625177156,
 127886,
 -40735,
 1625239135,
 127983,
 -1,
 1625302924,
 9979,
 -1,
 1624912434,
 127875,
 1625579750,
 1617284637,
 -1,
 -40731,
 1625525668,
 9909,
 -1,
 1625576763,
 129337,
 -40729,
 1625530004,
 128377,
 -40728,
 1625711989,
 129513,
 -1,
 1625768462,
 128086,
 1625973087,
 1617219101,
 -1,
 1626038569,
 1625923277,
 -1,
 1626104090,
 1626004356,
 -1,
 1626169601,
 1626063506,
 -1,
 1626235136,
 1626123901,
 -1,
 1626300671,
 1626148558,
 -1,
 1626366205,
 1626219378,
 11105,
 1626472447,
 1626275840,
 -1,
 1626497275,
 1626398304,
 -1,
 1626562805,
 1626439230,
 -1,
 -40716,
 1626517632,
 11171,
 -1,
 1626569055,
 11170,
 -40714,
 1626527882,
 129073,
 -40713,
 1626704346,
 129057,
 -40712,
 1626768383,
 129061,
 -40711,
 1626823518,
 129069,
 -40710,
 1626881567,
 11131,
 -1,
 1626942248,
 129065,
 -40708,
 1626458382,
 11121,
 -1,
 1627093427,
 11137,
 -40706,
 1626316659,
 11141,
 -1,
 1627207996,
 11115,
 -1,
 1626210584,
 129169,
 -1,
 1626202369,
 11245,
 1627545867,
 1626085684,
 -1,
 1627611402,
 1627501646,
 -1,
 1627676934,
 1627569162,
 -1,
 -40699,
 1627638456,
 129025,
 -1,
 1627670632,
 129041,
 -40697,
 1627622998,
 129177,
 -40696,
 1627816986,
 129029,
 -40695,
 1627878924,
 129033,
 -1,
 1627932776,
 129045,
 -1,
 1627556399,
 11797,
 1628201230,
 1627512086,
 -1,
 -40691,
 1628168088,
 129173,
 -1,
 1628197439,
 11192,
 1628397841,
 1628157271,
 -1,
 -40688,
 1628350365,
 129081,
 -1,
 1628381505,
 129105,
 1628594452,
 1628330822,
 -1,
 -40685,
 1628517390,
 129089,
 -1,
 1628578674,
 129093,
 1628791063,
 1628514851,
 -1,
 -40682,
 1628713352,
 11145,
 -1,
 1628775282,
 11014,
 -40680,
 1628746531,
 128621,
 -40679,
 1628917533,
 129077,
 -1,
 1628976142,
 129085,
 1629184289,
 1626017620,
 -1,
 1629249822,
 1629142026,
 -1,
 -40675,
 1629203523,
 128316,
 -1,
 1629232481,
 128744,
 -40673,
 1629203523,
 128314,
 -40672,
 1629390333,
 128742,
 -1,
 1629429089,
 128743,
 1629643047,
 1629093888,
 -1,
 1629708582,
 1629568701,
 -1,
 -40668,
 1629670142,
 11109,
 -40667,
 1629730479,
 129113,
 -1,
 1629760042,
 11021,
 -1,
 1629627301,
 11193,
 -40664,
 1629600398,
 128579,
 -1,
 1629987250,
 128319,
 1630167378,
 1625969685,
 -1,
 1630232913,
 1630108299,
 -1,
 1630298417,
 1630188887,
 -1,
 1630363951,
 1630214452,
 -1,
 -40658,
 1630308026,
 66450,
 -1,
 1630353785,
 66453,
 -40656,
 1630323048,
 66461,
 -1,
 1630494021,
 66444,
 1630691637,
 1630257810,
 -1,
 -40653,
 1630638225,
 66458,
 -40652,
 1630689822,
 66456,
 -1,
 1630751188,
 66441,
 1630953784,
 1630660029,
 -1,
 -40649,
 1630916125,
 66449,
 -1,
 1630947816,
 66439,
 1631150395,
 1630892171,
 -1,
 -40646,
 1631082558,
 66435,
 -1,
 1631132759,
 66443,
 1631347005,
 1631084056,
 66437,
 -1,
 1631306520,
 66440,
 1631478080,
 1631277810,
 -1,
 -40641,
 1631410324,
 66457,
 -1,
 1631461270,
 66434,
 1631674691,
 1631401999,
 -1,
 -40638,
 1631606979,
 66447,
 -1,
 1631667707,
 66436,
 1631871302,
 1631590708,
 -1,
 -40635,
 1631813534,
 66432,
 -1,
 1631872621,
 66451,
 -40633,
 1631839531,
 66442,
 -40632,
 1632034832,
 66438,
 -40631,
 1632095773,
 66460,
 -40630,
 1632152158,
 66455,
 -40629,
 1632216894,
 66454,
 -40628,
 1632282142,
 66452,
 -40627,
 1632342019,
 66448,
 -40626,
 1632404605,
 66446,
 -40625,
 1632466317,
 66445,
 -40624,
 1632526721,
 66459,
 -1,
 1632577787,
 66433,
 -1,
 1630200164,
 66463,
 1632854363,
 1630112040,
 -1,
 1632919896,
 1632788865,
 -1,
 1632985431,
 1632879250,
 -1,
 -40618,
 1632912225,
 11258,
 -1,
 1632962760,
 983115,
 -1,
 1632908596,
 129412,
 -40615,
 1632862924,
 9903,
 -40614,
 1633169258,
 11217,
 -1,
 1633230764,
 128530,
 1633444190,
 1632797574,
 -1,
 -40611,
 1633410798,
 9748,
 -1,
 1633457212,
 9969,
 -1,
 1633400151,
 983116,
 1633706448,
 1625941437,
 -1,
 1633771973,
 1633624026,
 -1,
 1633837465,
 1633712779,
 -1,
 1633902955,
 1633796754,
 -1,
 1633968486,
 1633862290,
 -1,
 -40603,
 1633900606,
 72213,
 -1,
 1633950004,
 72212,
 1634165097,
 1633924439,
 -1,
 -40600,
 1634097214,
 72228,
 -1,
 1634146612,
 72227,
 -40598,
 1634097214,
 72218,
 -1,
 1634277684,
 72217,
 1634492788,
 1633826831,
 -1,
 1634558319,
 1634461117,
 -1,
 -40594,
 1634490430,
 72230,
 -1,
 1634539828,
 72229,
 1634754930,
 1634482191,
 -1,
 -40591,
 1634687038,
 72215,
 -1,
 1634736436,
 72214,
 -40589,
 1634687038,
 72220,
 -1,
 1634867508,
 72219,
 1635082617,
 1634437416,
 -1,
 -40586,
 1635050356,
 72211,
 -40585,
 1635092850,
 72216,
 -40584,
 1635144513,
 72207,
 -1,
 1635195188,
 72221,
 1635410301,
 1635038551,
 -1,
 -40581,
 1635366401,
 72239,
 -40580,
 1635407934,
 72238,
 -1,
 1635457332,
 72240,
 1635672449,
 1635348619,
 -1,
 -40577,
 1635630772,
 72242,
 -40576,
 1635670078,
 72204,
 -1,
 1635719476,
 72203,
 1635934596,
 1635640765,
 -1,
 -40573,
 1635866686,
 72231,
 -1,
 1635916084,
 72232,
 1636131207,
 1635884749,
 -1,
 -40570,
 1636063294,
 72223,
 -1,
 1636112692,
 72222,
 1636327818,
 1636061938,
 -1,
 -40567,
 1636259902,
 72206,
 -1,
 1636309300,
 72205,
 1636524429,
 1636248804,
 -1,
 -40564,
 1636456510,
 72209,
 -1,
 1636505908,
 72208,
 1636721040,
 1636443839,
 -1,
 -40561,
 1636653118,
 72225,
 -1,
 1636702516,
 72224,
 -40559,
 1636688756,
 72234,
 -40558,
 1636881934,
 72237,
 -40557,
 1636935925,
 72235,
 -40556,
 1636991195,
 72226,
 -40555,
 1637053590,
 72236,
 -40554,
 1637117821,
 72210,
 -40553,
 1637177406,
 72241,
 -40552,
 1637226804,
 72192,
 -1,
 1637289582,
 72233,
 1637507494,
 1633802798,
 -1,
 1637573029,
 1637464777,
 -1,
 1637638557,
 1637535261,
 72195,
 -1,
 1637564611,
 72194,
 1637769631,
 1637585041,
 72198,
 -1,
 1637695683,
 72197,
 1637900706,
 1637685556,
 -1,
 -40543,
 1637862941,
 72200,
 -1,
 1637900673,
 72199,
 -40541,
 1637854676,
 72201,
 -40540,
 1638031745,
 72193,
 -1,
 1638088899,
 72196,
 -1,
 1637513790,
 72202,
 1638359473,
 1637463383,
 -1,
 1638425008,
 1638294840,
 -1,
 1638490540,
 1638346130,
 -1,
 1638556075,
 1638410700,
 72245,
 -1,
 1638468971,
 72246,
 -1,
 1638468971,
 72247,
 1638752687,
 1638455530,
 -1,
 -40530,
 1638708945,
 72249,
 -1,
 1638771204,
 72244,
 -1,
 1638670734,
 72248,
 -1,
 1638387525,
 72263,
 1639080380,
 1638281876,
 -1,
 1639145913,
 1639044485,
 -1,
 1639211448,
 1639075525,
 -1,
 -40523,
 1639179124,
 72251,
 -40522,
 1639241230,
 72254,
 -40521,
 1639295221,
 72252,
 -1,
 1639347350,
 72253,
 -1,
 1639147920,
 72250,
 1639645183,
 1639094679,
 -1,
 -40517,
 1639537355,
 72256,
 -1,
 1639595681,
 72262,
 1639801281,
 1639023242,
 -1,
 -40514,
 1639762930,
 72257,
 -40513,
 1639823561,
 72258,
 -40512,
 1639874120,
 72260,
 -1,
 1639923310,
 72259,
 1640128964,
 1639737699,
 -1,
 -40509,
 1640061643,
 72255,
 -1,
 1640119969,
 72261,
 -1,
 1640058522,
 72243,
 1640391115,
 1633737444,
 -1,
 1640456649,
 1640335656,
 -1,
 -40504,
 1640394591,
 983218,
 -1,
 1640442935,
 983259,
 -40502,
 1640414677,
 983217,
 -1,
 1640591199,
 983219,
 1640784334,
 1640317123,
 -1,
 -40499,
 1640748301,
 11234,
 -1,
 1640770490,
 129427,
 -40497,
 1640731579,
 129503,
 -1,
 1640917902,
 129296,
 1641112035,
 1633673884,
 -1,
 1641177562,
 1641065480,
 -1,
 1641243093,
 1641098468,
 -1,
 -40492,
 1641175656,
 129636,
 -1,
 1641226546,
 129637,
 -40490,
 1641201022,
 129638,
 -40489,
 1641382473,
 129633,
 -40488,
 1641439043,
 129635,
 -40487,
 1641501937,
 129632,
 -1,
 1641563590,
 129634,
 1641807871,
 1641097763,
 -1,
 1641832926,
 1641688292,
 -1,
 -40483,
 1641765480,
 129643,
 -1,
 1641816370,
 129644,
 -40481,
 1641790846,
 129645,
 -40480,
 1641972297,
 129640,
 -40479,
 1642028867,
 129642,
 -40478,
 1642091761,
 129639,
 -1,
 1642153414,
 129641,
 1642357222,
 1641079564,
 -1,
 -40475,
 1642291635,
 983239,
 -1,
 1642350039,
 128155,
 -1,
 1642309731,
 9915]
_charnames_564 = [
11199,
11263,
11023,
11244,
11247,
11324,
11407,
11497,
11254,
11488,
11381,
11047,
11315,
11538,
11329,
11529,
11473,
11371,
11397,
11070,
11535,
11341,
11436,
11322,
11447,
11135,
11545,
11333,
]

_charnames_751 = [
9358,
9362,
9352,
9361,
9360,
9389,
9387,
9388,
9363,
9400,
9412,
9383,
9411,
9382,
9303,
9414,
9351,
]

_charnames_848 = [
1854,
1789,
1921,
1908,
1786,
1855,
1852,
1857,
1842,
1880,
1831,
1905,
1830,
1829,
1827,
1828,
]

_charnames_880 = [
21716,
21694,
21717,
21695,
-1,
-1,
21715,
21693,
-1,
-1,
-1,
21697,
21699,
21698,
-1,
21714,
]

_charnames_1015 = [
21712,
21691,
21718,
21713,
21692,
21759,
21720,
21723,
21721,
]

_charnames_1270 = [
2983,
2903,
-1,
-1,
2982,
2902,
2965,
2873,
2964,
2872,
]

_charnames_1296 = [
2939,
2837,
2947,
2855,
2988,
2900,
2943,
2842,
2961,
2869,
2985,
2905,
2984,
2888,
2989,
2906,
2946,
2854,
2950,
2858,
2986,
2890,
2936,
2851,
2951,
2859,
2911,
2825,
2920,
2834,
2948,
2856,
]

_charnames_1416 = [
13124,
-1,
-1,
-1,
-1,
23760,
11766,
13126,
]

_charnames_1536 = [
13109,
13037,
13099,
13040,
13038,
13110,
13121,
13120,
13086,
13119,
13118,
13680,
-1,
13091,
13113,
13045,
13039,
13046,
13042,
13043,
13044,
12997,
13000,
12996,
13007,
13008,
13006,
-1,
12944,
-1,
13072,
-1,
12908,
]

_charnames_1622 = [
13059,
13115,
12834,
13111,
13101,
13102,
13103,
13085,
13096,
13112,
]

_charnames_1869 = [
7757,
7758,
7759,
12843,
12851,
12841,
12842,
12844,
12849,
12846,
12926,
12927,
12947,
12951,
12889,
12914,
12872,
12874,
12871,
12865,
12866,
12903,
12901,
12899,
12942,
12941,
12961,
12960,
12959,
12965,
12890,
12893,
12911,
12924,
12922,
12912,
12888,
12923,
12881,
12882,
12856,
12857,
12858,
12954,
12955,
12936,
12937,
12928,
12915,
12913,
12906,
]

_charnames_1984 = [
18849,
18850,
18841,
18842,
18847,
18848,
18844,
18845,
18852,
18851,
18835,
18817,
18829,
18816,
18822,
18815,
18814,
18819,
18800,
18834,
18825,
18823,
18810,
18833,
18818,
18813,
18812,
18824,
18831,
18832,
18828,
18827,
18804,
18826,
18801,
18803,
18830,
18821,
18820,
18802,
18808,
18809,
18807,
18865,
18864,
18863,
18861,
18860,
18859,
18858,
18866,
18867,
18873,
18836,
18870,
18871,
18868,
18874,
18837,
-1,
-1,
18854,
18853,
18872,
7318,
7305,
7315,
7317,
7298,
7306,
7307,
7299,
7295,
7308,
7314,
7313,
7312,
7311,
7302,
7300,
7316,
7294,
7310,
7309,
7303,
7296,
7358,
7359,
7360,
7363,
7367,
7362,
7325,
7336,
7328,
7322,
7333,
7327,
7321,
7332,
7365,
7331,
7323,
7334,
7366,
7324,
7335,
7326,
7330,
7361,
-1,
-1,
7353,
7344,
7341,
7355,
7342,
7350,
7368,
7354,
7346,
7352,
7347,
7351,
7343,
7349,
7340,
-1,
8727,
8721,
8719,
8720,
8718,
8725,
8710,
8723,
8707,
8709,
8708,
8716,
8715,
8714,
8703,
8724,
8713,
8704,
8712,
8711,
8705,
8706,
8728,
8726,
8717,
8732,
8729,
8731,
-1,
-1,
8730,
-1,
7747,
7754,
7746,
7751,
7745,
7744,
7755,
7753,
7750,
7749,
7752,
]

_charnames_2208 = [
12847,
12850,
12973,
12969,
12867,
12971,
12964,
12943,
12933,
12934,
12891,
12956,
12894,
12966,
12948,
12917,
12974,
12916,
12970,
12875,
12907,
-1,
12848,
12972,
12968,
12887,
12932,
12879,
12877,
12878,
]

_charnames_2259 = [
13004,
12987,
12995,
13002,
12998,
12999,
13005,
12985,
12986,
12988,
12990,
12991,
12989,
13001,
12994,
13093,
13071,
13076,
13078,
13074,
13077,
13079,
13075,
13067,
13064,
13070,
13066,
13063,
13069,
13106,
13107,
13105,
12992,
13097,
13098,
13114,
12977,
13082,
12976,
13084,
13088,
13089,
13083,
13092,
12833,
22779,
-1,
-1,
-1,
22761,
]

_charnames_2382 = [
22792,
22791,
-1,
-1,
-1,
-1,
-1,
22793,
22785,
22784,
]

_charnames_2417 = [
22780,
22766,
22753,
22752,
22759,
22750,
22749,
22762,
22760,
22764,
22756,
22763,
22755,
22765,
22767,
17032,
]

_charnames_2555 = [
17034,
17027,
17033,
17030,
-1,
-1,
22261,
-1,
22259,
]

_charnames_2809 = [
22251,
22244,
22245,
22246,
22242,
22247,
22241,
]

_charnames_2929 = [
21470,
21459,
21460,
21464,
21458,
21461,
21463,
]

_charnames_3059 = [
4577,
4582,
4578,
4576,
4573,
4584,
4579,
4581,
-1,
-1,
-1,
-1,
-1,
5338,
-1,
-1,
-1,
5339,
]

_charnames_3192 = [
5335,
5333,
5327,
5330,
5334,
5328,
5331,
5340,
23482,
23487,
-1,
-1,
23483,
]

_charnames_3386 = [
9080,
9107,
9105,
9109,
-1,
-1,
-1,
-1,
-1,
-1,
9113,
]

_charnames_3406 = [
9082,
9108,
-1,
-1,
-1,
-1,
9078,
9076,
9073,
-1,
9094,
9090,
9101,
9087,
9088,
9098,
9091,
9083,
-1,
-1,
9111,
9112,
]

_charnames_3440 = [
9118,
9117,
9116,
9093,
9095,
9100,
9092,
9096,
9099,
9119,
9075,
9074,
9077,
9071,
9072,
9079,
]

_charnames_3558 = [
6683,
6684,
6675,
6676,
6681,
6682,
6678,
6679,
6686,
6685,
]

_charnames_4046 = [
5186,
-1,
5172,
5176,
5175,
5178,
5179,
23757,
11763,
23758,
11764,
5177,
5174,
]

_charnames_4130 = [
9622,
-1,
-1,
-1,
-1,
-1,
9681,
-1,
-1,
9767,
]

_charnames_4147 = [
9764,
9763,
9769,
-1,
-1,
-1,
-1,
9724,
9791,
9793,
9792,
9794,
9690,
]

_charnames_4186 = [
9679,
9680,
9678,
9677,
9796,
9797,
9798,
9626,
9754,
9787,
9786,
9687,
9688,
9761,
9760,
9715,
9714,
9713,
9712,
9711,
9684,
9683,
9685,
9768,
9757,
9756,
9758,
9605,
9604,
9608,
9611,
9615,
9600,
9621,
9602,
9617,
9620,
9614,
9616,
9619,
9799,
9753,
9750,
9751,
9752,
9703,
9702,
9701,
9700,
9707,
9706,
9708,
9689,
9722,
9735,
9736,
9727,
9728,
9733,
9734,
9730,
9731,
9738,
9737,
9721,
9720,
9765,
9766,
9745,
9746,
]

_charnames_4295 = [
22010,
-1,
-1,
-1,
-1,
-1,
22011,
]

_charnames_4345 = [
22006,
22003,
-1,
9415,
22004,
22008,
22007,
]

_charnames_4992 = [
14952,
15033,
15032,
15031,
14954,
14969,
14968,
14967,
14953,
15038,
15037,
15036,
14951,
15026,
15025,
15024,
15057,
15051,
15059,
15058,
15053,
15056,
15061,
15060,
15052,
15055,
]

_charnames_5109 = [
2511,
-1,
-1,
2467,
2466,
2465,
2464,
2463,
2484,
-1,
-1,
2644,
]

_charnames_5751 = [
2560,
2556,
2557,
2554,
2555,
2558,
2559,
2561,
2629,
]

_charnames_5873 = [
23847,
23845,
23846,
23842,
23843,
23844,
23841,
23840,
]

_charnames_6128 = [
22980,
22981,
22976,
22979,
22978,
22969,
22975,
22974,
22973,
22972,
]

_charnames_6314 = [
9539,
-1,
-1,
-1,
-1,
-1,
2550,
2640,
2641,
2567,
2623,
2624,
2622,
2592,
2635,
2634,
2642,
2609,
2610,
2643,
2580,
2569,
2578,
2579,
2577,
2631,
2632,
2601,
2607,
2541,
2608,
2542,
2605,
2539,
2606,
2540,
2599,
2597,
2598,
2595,
2596,
2600,
2546,
2545,
2548,
2549,
2547,
2537,
2543,
2544,
2645,
2566,
2637,
2638,
2602,
2564,
2565,
2590,
2591,
2583,
2584,
2585,
2587,
2588,
2572,
2573,
2575,
2614,
2619,
2616,
2615,
2574,
2620,
2628,
2627,
2618,
]

_charnames_6400 = [
10876,
10826,
10825,
10815,
10814,
10822,
10835,
10834,
10829,
10828,
10817,
10807,
10806,
10832,
10831,
10823,
10820,
10819,
10838,
10837,
10841,
10816,
10840,
10842,
10839,
10810,
10809,
10811,
10843,
10813,
10805,
-1,
10867,
10875,
10874,
10873,
10869,
10871,
10868,
10872,
10870,
10862,
10864,
10863,
-1,
-1,
-1,
-1,
10854,
10847,
10855,
10849,
10848,
10851,
10852,
10850,
10853,
10858,
10860,
10857,
-1,
-1,
-1,
-1,
10859,
-1,
-1,
-1,
10892,
10891,
10887,
10888,
10879,
10880,
10885,
10886,
10882,
10883,
10890,
10889,
4879,
4881,
4875,
4858,
4883,
4880,
4860,
4859,
4886,
4871,
4870,
4885,
4889,
4882,
4888,
4884,
4878,
4857,
4876,
4864,
4887,
4863,
4862,
4867,
4873,
4872,
4868,
4861,
4865,
4866,
-1,
-1,
4855,
4854,
4853,
4852,
4851,
]

_charnames_6528 = [
18658,
18629,
18655,
18643,
18651,
18626,
18614,
18622,
18638,
18646,
18656,
18609,
18617,
18627,
18640,
18639,
18652,
18611,
18610,
18623,
18649,
18648,
18659,
18620,
18619,
18630,
18662,
18657,
18660,
18633,
18628,
18631,
18661,
18663,
18664,
18632,
18634,
18635,
18654,
18642,
18625,
18613,
18645,
18616,
-1,
-1,
-1,
-1,
18691,
18684,
18690,
18674,
18678,
18692,
18687,
18679,
18680,
18675,
18686,
18685,
18677,
18682,
18681,
18676,
18689,
18668,
18667,
18666,
18669,
18670,
18671,
18672,
18710,
18709,
-1,
-1,
-1,
-1,
-1,
-1,
18703,
18704,
18695,
18696,
18701,
18702,
18698,
18699,
18706,
18705,
18711,
-1,
-1,
-1,
18712,
18713,
22944,
22991,
22943,
22988,
22985,
22940,
22937,
22934,
22931,
22928,
22966,
22963,
22953,
22960,
22957,
22950,
22992,
22990,
22942,
22987,
22984,
22939,
22936,
22933,
22930,
22927,
22965,
22962,
22952,
22959,
22956,
22949,
16947,
16950,
16934,
16933,
16945,
16953,
16939,
16938,
16942,
16951,
16936,
16935,
16952,
16948,
16931,
16930,
16940,
16944,
16946,
16941,
16943,
16954,
16949,
16958,
16956,
16959,
16957,
16960,
-1,
-1,
16961,
16962,
4620,
4619,
4618,
4593,
4591,
4592,
4641,
4629,
4628,
4602,
4604,
4601,
4640,
4636,
4631,
4652,
4605,
4637,
4623,
4622,
4596,
4595,
4642,
4653,
4626,
4625,
4633,
4599,
4607,
4598,
4649,
4603,
4630,
4635,
4638,
4608,
4610,
4647,
4615,
4614,
4616,
4632,
4611,
4654,
4606,
4645,
4646,
4643,
4644,
4651,
4648,
4609,
4650,
4743,
4744,
4748,
4673,
4751,
4747,
4750,
4745,
4752,
4749,
-1,
4670,
4700,
4709,
4703,
4706,
4707,
4708,
4699,
4698,
4696,
4697,
4690,
4692,
4694,
4710,
4702,
4695,
4701,
4705,
4693,
4672,
4680,
4679,
4661,
4660,
4659,
4683,
4675,
4662,
-1,
-1,
4753,
4735,
4736,
4727,
4728,
4733,
4734,
4730,
4731,
4738,
4737,
-1,
-1,
-1,
-1,
-1,
-1,
4721,
4722,
4713,
4714,
4719,
4720,
4716,
4717,
4724,
4723,
-1,
-1,
-1,
-1,
-1,
-1,
4676,
4677,
4669,
4665,
4685,
4687,
4682,
4674,
4663,
4664,
4667,
4668,
4686,
4688,
-1,
-1,
1836,
1845,
1917,
1844,
1894,
1907,
1910,
1866,
1833,
1795,
1897,
1902,
1832,
1901,
1900,
]

_charnames_6912 = [
16298,
16299,
16302,
16300,
16303,
16184,
16185,
16206,
16207,
16198,
16199,
16193,
16194,
16196,
16197,
16211,
16187,
16202,
16203,
16173,
16175,
16208,
16209,
16171,
16213,
16214,
16204,
16205,
16170,
16165,
16164,
16181,
16180,
16169,
16161,
16163,
16177,
16182,
16168,
16200,
16201,
16215,
16216,
16221,
16218,
16192,
16195,
16219,
16191,
16190,
16188,
16222,
16301,
16271,
16272,
16273,
16274,
16275,
16276,
16277,
16280,
16281,
16266,
16268,
16270,
16269,
16278,
16279,
16315,
16174,
16176,
16166,
16212,
16220,
16217,
16186,
-1,
-1,
-1,
-1,
16292,
16293,
16284,
16285,
16290,
16291,
16287,
16288,
16295,
16294,
16308,
16307,
16314,
16312,
16313,
16311,
16306,
16236,
16234,
16235,
16226,
16228,
16237,
16231,
16233,
16230,
16229,
16244,
16247,
16240,
16242,
16245,
16241,
16243,
16248,
16246,
16259,
16260,
16262,
16263,
16253,
16251,
16256,
16255,
16252,
-1,
-1,
-1,
7648,
7647,
7646,
7591,
7605,
7598,
7592,
7602,
7586,
7587,
7585,
7600,
7607,
7567,
7609,
7604,
7593,
7566,
7599,
7608,
7568,
7601,
7573,
7597,
7590,
7603,
7594,
7579,
7582,
7596,
7576,
7595,
7606,
7658,
7657,
7656,
7638,
7636,
7640,
7637,
7641,
7639,
7649,
7650,
7654,
7653,
7584,
7575,
7620,
7621,
7612,
7613,
7618,
7619,
7615,
7616,
7623,
7622,
7659,
7578,
7581,
7589,
7572,
7571,
16377,
16346,
16372,
16344,
16360,
16376,
16369,
16362,
16341,
16354,
16359,
16365,
16338,
16363,
16373,
16345,
16370,
16374,
16367,
16340,
16356,
16342,
16347,
16351,
16348,
16339,
16358,
16364,
16337,
16352,
16368,
16343,
16350,
16375,
16353,
16361,
16371,
16366,
16396,
16384,
16386,
16385,
16388,
16383,
16387,
16382,
16379,
16380,
16401,
16402,
16399,
16398,
]

_charnames_7164 = [
16394,
16392,
16395,
16393,
11792,
11790,
11791,
11808,
11807,
11787,
11814,
11813,
11823,
11786,
11780,
11779,
11796,
11788,
11784,
11782,
11783,
11811,
11810,
11817,
11816,
11802,
11801,
11778,
11777,
11794,
11818,
11821,
11822,
11805,
11804,
11820,
11799,
11798,
11819,
11824,
11866,
11867,
11856,
11854,
11852,
11853,
11850,
11851,
11855,
11842,
11847,
11848,
11840,
11846,
11845,
11844,
11841,
11843,
11869,
11870,
-1,
-1,
-1,
11861,
11862,
11863,
11860,
11859,
11835,
11836,
11827,
11828,
11833,
11834,
11830,
11831,
11838,
11837,
-1,
-1,
-1,
11775,
11774,
11795,
21297,
21298,
21289,
21290,
21295,
21296,
21292,
21293,
21300,
21299,
21261,
21256,
21259,
21257,
21258,
21262,
21254,
21255,
21253,
21252,
21265,
21278,
21281,
21280,
21279,
21263,
21271,
21270,
21269,
21268,
21266,
21284,
21286,
21285,
21283,
21264,
21274,
21276,
21273,
21275,
21308,
21310,
21307,
21309,
21305,
21311,
21303,
21304,
2841,
2899,
2894,
2887,
2813,
2819,
2814,
2812,
2904,
]

_charnames_7312 = [
21907,
21947,
21930,
21946,
21932,
21937,
21912,
21904,
21944,
21924,
21920,
21943,
21942,
21941,
21918,
21911,
21939,
21915,
21903,
21938,
21917,
21923,
21929,
21940,
21914,
21897,
21900,
21926,
21899,
21898,
21935,
21927,
21891,
21894,
21893,
21936,
21889,
21892,
21945,
21934,
21933,
21905,
21908,
-1,
-1,
21909,
21890,
21921,
7628,
7627,
7626,
7632,
7629,
7630,
7631,
7633,
]

_charnames_7376 = [
17986,
17990,
17991,
17962,
17959,
17971,
17970,
17968,
17988,
17969,
17978,
17974,
17985,
17980,
17973,
17975,
17983,
17992,
17952,
17948,
17955,
17950,
17956,
17949,
17951,
17944,
17943,
17940,
17941,
17961,
17965,
17963,
17957,
17942,
17946,
17958,
17989,
17964,
17960,
17945,
17982,
17979,
-1,
-1,
-1,
-1,
-1,
-1,
11575,
11576,
11014,
11591,
11590,
11589,
11574,
11572,
11002,
11006,
11587,
11586,
11585,
11584,
11566,
11569,
11571,
11030,
11031,
11032,
10996,
11570,
11026,
11220,
11583,
11565,
11560,
11558,
11580,
11033,
11035,
11034,
11579,
11578,
11577,
11573,
11593,
11594,
21732,
21731,
21728,
21729,
21727,
2991,
9316,
9317,
9314,
9315,
9331,
9330,
9309,
9329,
9312,
9328,
9327,
9326,
9325,
9324,
9323,
9308,
9310,
9311,
9322,
9306,
9321,
9320,
9318,
9278,
9215,
9279,
9217,
9259,
9275,
9243,
9256,
9270,
9221,
9271,
9222,
9294,
9288,
9247,
9267,
9269,
9224,
9260,
9283,
9213,
9248,
9257,
9218,
9281,
9280,
9261,
9274,
9277,
9273,
9234,
11362,
11354,
11352,
11351,
21705,
21703,
21701,
21702,
21704,
11129,
11217,
11238,
11339,
11275,
11267,
11287,
11138,
11139,
11050,
11021,
11317,
11013,
9346,
11089,
11019,
11346,
11107,
11283,
11345,
11125,
11216,
11237,
11338,
11327,
11295,
11195,
11274,
11265,
11286,
11136,
11048,
11076,
11225,
11313,
11316,
11177,
11185,
11239,
11071,
11158,
11146,
11042,
11103,
11154,
11075,
11122,
11080,
9216,
9227,
9235,
9245,
9293,
9297,
9276,
9255,
9223,
9292,
9291,
9229,
9230,
9295,
9238,
9239,
9233,
9289,
9219,
9287,
9286,
9232,
9262,
9284,
9258,
9246,
9226,
9251,
9252,
9231,
9282,
9220,
9263,
9265,
9266,
9244,
9225,
1839,
1840,
1898,
1896,
1877,
1663,
1875,
1883,
1664,
1884,
1757,
1919,
1876,
1835,
1867,
1904,
1916,
1888,
1887,
1762,
1745,
1743,
1742,
1775,
1773,
1764,
1774,
1781,
1772,
1747,
1780,
1779,
1771,
1778,
1777,
1756,
1753,
1748,
1768,
1744,
1766,
1767,
1754,
1761,
1749,
1759,
1770,
1765,
1751,
1769,
1746,
1760,
1752,
1889,
1913,
1914,
1843,
1911,
-1,
1823,
1834,
1885,
1787,
1853,
]

_charnames_8275 = [
7940,
24434,
24627,
5379,
-1,
24604,
24597,
5505,
24605,
22563,
5481,
18021,
-1,
-1,
-1,
-1,
-1,
24437,
-1,
11767,
23761,
24581,
20742,
]

_charnames_8336 = [
11365,
11364,
11356,
11350,
11349,
11363,
11360,
11359,
11358,
11357,
11355,
11348,
11353,
]

_charnames_8370 = [
22265,
13654,
19921,
3380,
10985,
7828,
5359,
24351,
5467,
18915,
8745,
23859,
11618,
17064,
]

_charnames_8524 = [
20656,
13679,
5450,
7770,
18028,
18029,
18027,
]

_charnames_8580 = [
11144,
23874,
23873,
23872,
23875,
18030,
5454,
5455,
]

_charnames_9167 = [
15218,
18020,
8622,
8619,
8620,
8618,
8613,
8614,
8615,
8616,
8621,
15191,
24660,
5433,
16978,
5435,
16981,
5431,
16976,
24124,
17038,
7797,
24636,
13672,
15128,
22824,
16861,
16872,
16899,
16847,
16862,
16873,
16863,
13300,
7811,
5201,
19870,
16797,
16809,
16804,
16801,
22545,
16814,
16842,
20715,
20718,
20719,
20716,
21527,
]

_charnames_9866 = [
9551,
9550,
22861,
22854,
22855,
22860,
24141,
16915,
19839,
12640,
3355,
7791,
7925,
13296,
24625,
22012,
7790,
13674,
24641,
21515,
5375,
5376,
24064,
19902,
22553,
22552,
24456,
9124,
9122,
9123,
18019,
19860,
8491,
8500,
8482,
9066,
22881,
24920,
2192,
24661,
18791,
3378,
20275,
24804,
18023,
2524,
16811,
7903,
7908,
25062,
7905,
6947,
16454,
7501,
24108,
24109,
16852,
16853,
7929,
7664,
23929,
16824,
5404,
5463,
5461,
24106,
3362,
22874,
21494,
20759,
2715,
19549,
3336,
2408,
18920,
13297,
16887,
24125,
16877,
24116,
22906,
19510,
11760,
7495,
24562,
16888,
23646,
23645,
13658,
19505,
20658,
23763,
11769,
24435,
16841,
7172,
2530,
2804,
19905,
22014,
22015,
9201,
9563,
24925,
24609,
24638,
24665,
7383,
7558,
7944,
24509,
20639,
5357,
24801,
19537,
24662,
1581,
24142,
16826,
-1,
-1,
-1,
-1,
24136,
-1,
-1,
-1,
-1,
23926,
23915,
]

_charnames_10060 = [
3361,
-1,
18755,
-1,
-1,
-1,
-1,
16916,
24158,
24159,
-1,
19495,
]

_charnames_10175 = [
22549,
5380,
24123,
20653,
21481,
21480,
11743,
23737,
21475,
23639,
7669,
18022,
9187,
11965,
9198,
7484,
7483,
]

_charnames_11008 = [
18911,
18901,
6935,
6925,
11734,
11701,
24854,
22526,
18913,
18903,
6937,
6927,
11737,
24869,
23691,
23690,
11680,
11679,
7538,
7540,
7537,
7539,
22866,
22865,
22864,
22867,
22558,
16880,
24119,
16892,
24146,
16910,
24152,
24135,
16904,
19859,
16881,
16803,
24131,
16799,
24130,
16820,
16819,
24100,
16906,
24137,
16895,
24147,
11746,
5377,
11747,
11964,
11670,
11671,
11672,
11673,
11691,
11682,
11683,
11665,
11667,
11668,
11697,
24077,
15215,
23635,
11695,
23701,
23700,
11717,
23724,
23634,
23704,
5197,
11696,
11694,
23703,
22503,
7159,
7158,
24129,
16818,
24099,
16864,
24149,
19472,
19525,
19506,
19503,
19507,
7896,
16460,
7895,
16459,
17037,
7157,
11642,
24815,
23666,
22489,
11735,
24867,
18899,
18909,
6933,
6923,
11659,
24830,
23683,
22505,
3273,
12631,
11656,
24827,
23680,
22501,
-1,
-1,
18900,
18910,
6934,
6924,
11650,
24825,
23674,
22499,
19855,
18015,
11657,
24828,
23681,
22502,
11658,
24829,
23682,
22504,
11700,
24853,
23707,
22525,
12630,
12633,
12632,
12629,
23654,
23653,
18720,
18719,
24608,
23708,
-1,
-1,
5389,
5390,
5388,
5391,
16878,
16900,
16866,
16848,
22494,
22493,
24820,
24819,
11646,
23670,
11647,
23671,
16840,
16839,
16831,
16830,
16836,
16833,
16837,
16834,
23777,
23776,
23768,
23767,
23773,
23770,
23774,
23771,
24845,
24870,
21510,
21511,
21512,
16327,
3341,
3346,
16815,
16857,
5462,
19858,
16917,
16805,
16802,
16798,
16810,
-1,
5428,
16980,
10964,
23904,
24144,
23903,
7555,
24921,
21882,
20588,
20589,
20591,
20592,
5488,
20709,
13659,
19913,
20477,
18793,
24132,
16856,
5499,
1582,
19845,
25036,
23540,
13663,
13415,
18031,
20735,
11730,
23748,
7785,
7784,
11669,
24832,
23685,
22507,
15212,
15211,
7910,
23852,
23856,
23855,
23857,
23854,
23853,
15214,
24917,
7907,
22551,
20289,
23625,
-1,
22146,
22135,
22137,
22144,
22117,
22099,
22120,
22116,
22121,
22106,
22110,
22103,
22118,
22142,
22129,
22141,
22140,
22127,
22123,
22139,
22093,
22112,
22138,
22132,
22143,
22126,
22124,
22087,
22113,
22145,
22089,
22097,
22098,
22102,
22092,
22100,
22090,
22091,
22101,
22108,
22136,
22109,
22133,
22105,
22088,
22114,
22130,
-1,
22083,
22072,
22074,
22081,
22054,
22036,
22057,
22053,
22058,
22043,
22047,
22040,
22055,
22079,
22066,
22078,
22077,
22064,
22060,
22076,
22030,
22049,
22075,
22069,
22080,
22063,
22061,
22024,
22050,
22082,
22026,
22034,
22035,
22039,
22029,
22037,
22027,
22028,
22038,
22045,
22073,
22046,
22070,
22042,
22025,
22051,
22067,
-1,
11492,
11192,
11490,
11510,
11446,
11176,
11022,
11524,
11303,
11506,
11294,
11543,
11318,
11414,
11520,
11369,
11370,
11224,
11553,
11343,
11227,
11526,
11305,
11027,
11072,
11011,
11165,
11562,
11361,
9319,
11433,
11542,
2065,
1984,
2068,
1987,
2075,
1994,
2039,
1958,
2077,
1996,
2048,
1967,
2067,
1986,
2074,
1993,
2056,
1975,
2073,
1992,
2054,
1973,
2062,
1981,
2072,
1991,
2071,
1990,
2052,
1971,
2010,
1929,
2060,
1979,
2070,
1989,
2049,
1968,
2057,
1976,
2069,
1988,
2076,
1995,
2053,
1972,
2059,
1978,
2032,
1951,
2038,
1957,
2025,
1944,
2045,
1964,
2036,
1955,
2035,
1954,
2043,
1962,
2021,
1940,
2050,
1969,
2046,
1965,
2020,
1939,
2023,
1942,
2066,
1985,
2037,
1956,
2016,
1935,
2014,
1933,
2063,
1982,
2017,
1936,
2015,
1934,
2022,
1941,
2024,
1943,
2019,
1938,
2031,
1950,
2029,
1948,
2028,
1947,
2030,
1949,
2004,
2007,
2006,
2000,
2005,
2003,
2001,
2042,
1961,
2044,
1963,
2083,
2082,
2081,
2078,
1997,
-1,
-1,
-1,
-1,
-1,
2132,
2133,
2131,
2130,
2136,
2135,
2137,
21984,
22000,
21982,
21999,
21998,
21989,
21964,
21967,
21997,
21976,
21996,
21995,
21994,
21993,
21973,
21963,
21991,
21970,
21966,
21990,
21972,
21975,
21981,
21992,
21969,
21958,
21961,
21978,
21960,
21959,
21987,
21979,
21952,
21955,
21954,
21988,
21951,
21953,
-1,
21986,
-1,
-1,
-1,
-1,
-1,
21985,
-1,
-1,
5105,
5129,
5130,
5122,
5124,
5161,
5139,
5106,
5109,
5107,
5108,
5144,
5140,
5119,
5150,
5121,
5127,
5162,
5158,
5128,
5142,
5120,
5151,
5134,
5156,
5147,
5112,
5165,
5155,
5138,
5137,
5136,
5153,
5157,
5135,
5145,
5125,
5126,
5123,
5154,
5164,
5116,
5117,
5118,
5113,
5115,
5141,
5114,
5133,
5132,
5131,
5110,
5159,
5111,
5143,
5146,
]

_charnames_11647 = [
5168,
15045,
15034,
15044,
14955,
14956,
14970,
14980,
14904,
15041,
15040,
14922,
14991,
14940,
14932,
15046,
14981,
14905,
15028,
15027,
14918,
14920,
14917,
14916,
]

_charnames_11680 = [
14945,
14947,
14949,
14946,
14944,
14943,
14948,
-1,
14899,
14901,
14903,
14900,
14898,
14897,
14902,
-1,
14986,
14988,
14990,
14987,
14985,
14984,
14989,
-1,
14892,
14894,
14896,
14893,
14891,
14890,
14895,
-1,
15006,
15008,
15010,
15007,
15005,
15004,
15009,
-1,
15016,
15018,
15020,
15017,
15015,
15014,
15019,
-1,
14996,
14998,
15000,
14997,
14995,
14994,
14999,
-1,
14910,
14912,
14914,
14911,
14909,
14908,
14913,
-1,
1714,
1715,
1720,
1711,
1698,
1699,
1719,
1679,
1678,
1677,
1705,
1716,
1676,
1674,
1704,
1707,
1703,
1722,
1695,
1694,
1721,
1675,
1723,
1686,
1710,
1717,
1691,
1688,
1685,
1718,
1713,
1684,
23740,
23741,
11740,
23735,
11757,
23751,
23925,
23923,
22560,
11750,
23744,
23924,
11738,
23753,
15219,
20224,
24614,
23630,
19911,
22562,
22517,
24842,
22561,
22546,
24436,
20273,
19912,
5196,
11754,
23754,
5195,
5194,
11759,
23752,
5434,
5432,
16979,
16977,
11742,
23736,
11756,
23750,
5504,
21503,
7510,
24598,
23628,
18017,
23780,
24237,
5465,
23922,
23927,
5451,
22888,
22887,
5456,
5427,
5511,
5392,
7809,
18018,
24223,
2805,
22548,
23631,
22547,
22891,
22543,
24432,
24433,
11952,
11953,
22544,
22559,
5479,
8502,
20223,
20766,
]

_charnames_12728 = [
16999,
16997,
16994,
-1,
-1,
-1,
-1,
-1,
3215,
3218,
3217,
3222,
3205,
3189,
3196,
3197,
3194,
3204,
3195,
3192,
3198,
3193,
3190,
3220,
3187,
3201,
3211,
3209,
3221,
3188,
3200,
3202,
3206,
3208,
3210,
3214,
3212,
3216,
3203,
3207,
3199,
3191,
3213,
3219,
]

_charnames_12868 = [
3311,
3306,
3310,
3305,
3320,
3318,
3319,
3325,
3326,
3322,
3323,
3327,
20221,
]

_charnames_19904 = [
19355,
19366,
19380,
19442,
19435,
19423,
19361,
19444,
19396,
19372,
19414,
19398,
19441,
19389,
19438,
19445,
19440,
19434,
19430,
19422,
19427,
19392,
19399,
19408,
19402,
19391,
19437,
19390,
19362,
19356,
19404,
19381,
19409,
19388,
19413,
19382,
19371,
19418,
19419,
19376,
19377,
19405,
19426,
19424,
19393,
19412,
19417,
19364,
19410,
19357,
19360,
19368,
19375,
19367,
19432,
19365,
19370,
19369,
19379,
19443,
19403,
19397,
19431,
19428,
]

_charnames_42192 = [
10954,
10921,
10920,
10940,
10909,
10908,
10935,
10929,
10928,
10951,
10943,
10942,
10939,
10907,
10906,
10949,
10926,
10950,
10918,
10914,
10915,
10925,
10932,
10947,
10931,
10953,
10948,
10917,
10946,
10934,
10944,
10945,
10936,
10937,
10952,
10922,
10910,
10912,
10911,
10923,
10899,
10904,
10902,
10903,
10900,
10901,
10957,
10956,
17375,
17376,
17298,
17235,
17236,
17342,
17281,
17288,
17140,
17179,
17132,
17201,
17358,
17326,
17256,
17249,
17164,
17157,
17308,
17334,
17171,
17100,
17272,
17265,
17225,
17218,
17366,
17350,
17116,
17318,
17189,
17081,
17207,
17147,
17123,
17108,
17380,
17381,
17301,
17302,
17240,
17241,
17344,
17283,
17290,
17142,
17185,
17134,
17203,
17360,
17328,
17258,
17251,
17166,
17159,
17312,
17336,
17173,
17102,
17274,
17267,
17227,
17220,
17368,
17352,
17118,
17320,
17193,
17085,
17211,
17149,
17125,
17110,
17382,
17383,
17089,
17303,
17304,
17242,
17243,
17345,
17284,
17291,
17143,
17182,
17183,
17135,
17204,
17361,
17329,
17259,
17252,
17167,
17160,
17313,
17337,
17174,
17103,
17275,
17268,
17228,
17221,
17369,
17353,
17119,
17321,
17190,
17191,
17086,
17212,
17150,
17126,
17111,
17371,
17372,
17294,
17231,
17232,
17340,
17279,
17286,
17138,
17181,
17130,
17197,
17356,
17324,
17254,
17247,
17162,
17155,
17310,
17332,
17169,
17098,
17270,
17263,
17223,
17216,
17364,
17348,
17114,
17316,
17187,
17083,
17209,
17145,
17121,
17106,
17378,
17379,
17299,
17300,
17238,
17239,
17343,
17282,
17289,
17141,
17184,
17133,
17202,
17359,
17327,
17257,
17250,
17165,
17158,
17311,
17335,
17172,
17101,
17273,
17266,
17226,
17219,
17367,
17351,
17117,
17319,
17192,
17084,
17210,
17148,
17124,
17109,
17370,
17373,
17087,
17293,
17295,
17230,
17233,
17339,
17278,
17285,
17137,
17180,
17129,
17196,
17198,
17355,
17323,
17253,
17246,
17161,
17154,
17309,
17331,
17168,
17091,
17269,
17262,
17222,
17215,
17363,
17347,
17113,
17315,
17186,
17082,
17208,
17144,
17120,
17105,
17374,
17377,
17088,
17296,
17297,
17234,
17237,
17341,
17280,
17287,
17139,
17177,
17178,
17131,
17199,
17200,
17357,
17325,
17255,
17248,
17163,
17156,
17306,
17333,
17170,
17099,
17271,
17264,
17224,
17217,
17365,
17349,
17115,
17317,
17188,
17079,
17080,
17205,
17206,
17146,
17122,
17107,
17077,
17307,
17419,
17418,
17417,
17096,
17095,
17093,
17398,
17396,
17387,
17400,
17402,
17399,
17388,
17393,
17391,
17395,
17386,
17392,
17401,
17413,
17414,
17405,
17406,
17411,
17412,
17408,
17409,
17416,
17415,
17094,
17097,
]

_charnames_42560 = [
2977,
2885,
2914,
2828,
2942,
2840,
2957,
2865,
2919,
2833,
2979,
2896,
2972,
2880,
2987,
2893,
2960,
2868,
2954,
2862,
2940,
2838,
2956,
2864,
2969,
2877,
2973,
2881,
2955,
2863,
2959,
2867,
2941,
2839,
2933,
2848,
2932,
2847,
2931,
2846,
2980,
2897,
2974,
2882,
2917,
2831,
2992,
1733,
1729,
1735,
1728,
7897,
1701,
1681,
1689,
1700,
1708,
1690,
1696,
1706,
1734,
1732,
2994,
2993,
2918,
2832,
2913,
2827,
2976,
2884,
2970,
2878,
2912,
2826,
2926,
2820,
2925,
2818,
2923,
2816,
2924,
2817,
2927,
2821,
2966,
2874,
2935,
2850,
2916,
2830,
2968,
2876,
9345,
9344,
1680,
1683,
16145,
16083,
16141,
16080,
16144,
16109,
16120,
16142,
16066,
16143,
16128,
16051,
16111,
16112,
16127,
16087,
16121,
16069,
16056,
16084,
16101,
16091,
16099,
16102,
16100,
16103,
16079,
16077,
16062,
16061,
16054,
16136,
16097,
16135,
16137,
16067,
16076,
16048,
16055,
16065,
16045,
16139,
16049,
16132,
16113,
16124,
16093,
16068,
16107,
16114,
16078,
16058,
16059,
16060,
16098,
16046,
16130,
16131,
16140,
16070,
16126,
16050,
16125,
16072,
16089,
16108,
16086,
16094,
16122,
16082,
16092,
16090,
16117,
16081,
16118,
16064,
16104,
16133,
16073,
16074,
16150,
16149,
16155,
16156,
16152,
16151,
16153,
16154,
]

_charnames_42752 = [
9337,
9342,
9334,
9339,
9336,
9341,
9335,
9340,
9377,
9403,
9392,
9356,
9371,
9378,
9404,
9393,
9357,
9372,
9379,
9405,
9394,
9353,
9373,
9407,
9408,
9409,
9366,
9396,
9399,
9398,
9397,
9364,
9300,
9299,
11399,
11078,
11400,
11079,
11525,
11304,
11379,
11024,
11380,
11025,
11494,
11257,
11495,
11258,
11588,
11581,
11415,
11187,
11413,
11184,
11412,
11183,
11409,
11180,
11410,
11181,
11411,
11182,
11452,
11145,
11502,
11290,
11505,
11293,
11503,
11291,
11531,
11219,
11491,
11198,
11482,
11167,
11481,
11166,
11483,
11168,
11511,
11284,
11513,
11288,
11512,
11285,
11548,
11321,
11549,
11323,
11449,
11142,
11453,
11148,
11462,
11226,
11459,
11232,
11460,
11233,
11377,
11017,
11378,
11018,
11461,
11234,
11401,
11081,
11429,
11108,
11499,
11259,
9413,
11245,
11203,
11280,
11269,
11147,
11567,
11015,
11127,
11423,
11091,
11422,
11090,
11421,
11375,
11007,
11373,
11012,
11420,
11088,
11419,
11087,
11418,
11086,
9365,
9347,
9302,
11440,
11052,
11376,
11194,
11592,
11552,
11268,
11498,
11256,
11255,
11302,
11530,
11218,
11554,
11337,
11458,
11231,
11457,
11230,
11456,
11229,
11540,
11328,
11507,
11296,
11551,
11266,
11448,
11137,
11434,
11049,
11523,
11451,
11439,
11487,
11437,
11582,
11374,
11372,
11536,
11500,
11532,
11221,
11484,
11169,
11472,
11117,
]

_charnames_42999 = [
11602,
9313,
9242,
11561,
11598,
11597,
11600,
11601,
11603,
7722,
7719,
7736,
7713,
7721,
7715,
7735,
7699,
7700,
7705,
7706,
7737,
7708,
7709,
7702,
7703,
7682,
7683,
7688,
7689,
7684,
7685,
7690,
7691,
7716,
7696,
7697,
7711,
7712,
7717,
7694,
7718,
7693,
7714,
7720,
7728,
7726,
7724,
7727,
7725,
7733,
7732,
7731,
7730,
-1,
-1,
-1,
-1,
18883,
18884,
18888,
18882,
18885,
18887,
18890,
18893,
18892,
18891,
-1,
-1,
-1,
-1,
-1,
-1,
20343,
20342,
20346,
20315,
20326,
20328,
20358,
20313,
20311,
20310,
20324,
20316,
20340,
20339,
20362,
20356,
20309,
20308,
20322,
20351,
20333,
20334,
20318,
20349,
20353,
20357,
20319,
20320,
20360,
20329,
20359,
20352,
20347,
20355,
20354,
20350,
20361,
20345,
20348,
20367,
20366,
20306,
20305,
20323,
20314,
20331,
20336,
20337,
20330,
20368,
20369,
20327,
20370,
20374,
20372,
20373,
]

_charnames_43136 = [
7288,
7285,
7207,
7210,
7231,
7232,
7215,
7216,
7185,
7186,
7187,
7188,
7236,
7237,
7209,
7220,
7221,
7208,
7227,
7226,
7235,
7234,
7199,
7240,
7239,
7230,
7229,
7197,
7193,
7192,
7204,
7203,
7198,
7195,
7194,
7206,
7205,
7200,
7219,
7218,
7243,
7242,
7246,
7244,
7245,
7224,
7189,
7213,
7212,
7214,
7247,
7223,
7289,
7257,
7262,
7263,
7258,
7259,
7250,
7251,
7252,
7253,
7264,
7265,
7256,
7260,
7261,
7255,
7286,
7287,
]

_charnames_43214 = [
7282,
7281,
7277,
7278,
7269,
7270,
7275,
7276,
7272,
7273,
7280,
7279,
-1,
-1,
-1,
-1,
-1,
-1,
1810,
1811,
1802,
1803,
1808,
1809,
1805,
1806,
1813,
1812,
1821,
1816,
1820,
1819,
1818,
1817,
1815,
1822,
22776,
22773,
22781,
22771,
22772,
22774,
22778,
22796,
22797,
22795,
22777,
22794,
22758,
22790,
23461,
23462,
23453,
23454,
23459,
23460,
23456,
23457,
23464,
23463,
23434,
23433,
23446,
23418,
23425,
23424,
23438,
23417,
23422,
23436,
23419,
23428,
23427,
23443,
23447,
23449,
23442,
23439,
23444,
23440,
23421,
23437,
23441,
23448,
23450,
23431,
23445,
23430,
23467,
23468,
23466,
23469,
23470,
23474,
23472,
23473,
23477,
23476,
23565,
23568,
23552,
23560,
23569,
23554,
23563,
23571,
23557,
23570,
23566,
23549,
23561,
23562,
23564,
23558,
23559,
23567,
23556,
23551,
23553,
23548,
23572,
23583,
23581,
23575,
23580,
23582,
23579,
23576,
23577,
23587,
23586,
23588,
23589,
23584,
]

_charnames_43359 = [
23590,
19700,
19699,
19697,
19701,
19689,
19686,
19692,
19684,
19694,
19693,
19685,
19691,
19687,
19695,
19690,
19720,
19718,
19719,
19709,
19710,
19711,
19705,
19722,
19723,
19706,
19704,
19712,
19725,
19703,
-1,
-1,
-1,
24786,
24783,
24787,
24785,
24724,
24713,
24711,
24712,
24728,
24706,
24683,
24684,
24733,
24725,
24729,
24707,
24709,
24710,
24718,
24719,
24682,
24720,
24721,
24716,
24686,
24717,
24685,
24690,
24691,
24695,
24696,
24688,
24692,
24693,
24697,
24698,
24687,
24703,
24705,
24722,
24723,
24730,
24726,
24714,
24715,
24731,
24727,
24701,
24702,
24699,
24732,
24784,
24773,
24775,
24776,
24777,
24778,
24779,
24774,
24781,
24780,
24790,
24789,
24791,
24755,
24734,
24793,
24745,
24751,
24740,
24749,
24748,
24741,
24739,
24743,
24744,
24747,
24792,
-1,
24754,
24766,
24767,
24758,
24759,
24764,
24765,
24761,
24762,
24769,
24768,
-1,
-1,
-1,
-1,
24750,
24752,
9607,
9610,
9618,
9601,
9613,
9709,
9801,
9662,
9674,
9669,
9668,
9666,
9665,
9658,
9657,
9663,
9781,
9782,
9773,
9774,
9779,
9780,
9776,
9777,
9784,
9783,
9673,
9660,
9659,
9672,
9671,
-1,
2253,
2261,
2257,
2263,
2254,
2259,
2243,
2242,
2249,
2248,
2216,
2217,
2252,
2251,
2246,
2245,
2212,
2214,
2213,
2234,
2233,
2227,
2225,
2218,
2219,
2226,
2223,
2221,
2222,
2231,
2229,
2239,
2240,
2230,
2255,
2258,
2260,
2256,
2236,
2237,
2262,
2268,
2273,
2274,
2275,
2269,
2272,
2271,
2267,
2266,
2270,
2295,
2297,
2298,
2296,
]

_charnames_43584 = [
2207,
2208,
2200,
2292,
2209,
2202,
2199,
2205,
2201,
2204,
2206,
2203,
2293,
2294,
-1,
-1,
2286,
2287,
2278,
2279,
2284,
2285,
2281,
2282,
2289,
2288,
-1,
-1,
2304,
2302,
2301,
2303,
9652,
9647,
9646,
9641,
9640,
9637,
9635,
9634,
9631,
9630,
9632,
9638,
9650,
9644,
9643,
9653,
9802,
9649,
9648,
9651,
9694,
9693,
9695,
9743,
9742,
9741,
9691,
9723,
9718,
9717,
9625,
9624,
4765,
4796,
4763,
4794,
4764,
4795,
4783,
4814,
4760,
4791,
4773,
4804,
4774,
4805,
4777,
4808,
4758,
4789,
4785,
4816,
4767,
4798,
4768,
4799,
4759,
4790,
4786,
4817,
4770,
4801,
4771,
4802,
4784,
4815,
4780,
4811,
4775,
4806,
4778,
4809,
4781,
4812,
4776,
4807,
4782,
4813,
4779,
4810,
4847,
4824,
4829,
4826,
4825,
4832,
4831,
4846,
4830,
4827,
4828,
4821,
4820,
4822,
4823,
4844,
4843,
4841,
4842,
]

_charnames_43739 = [
4835,
4838,
4837,
4839,
4836,
8562,
8560,
8552,
8511,
8516,
8515,
8523,
8522,
8512,
8528,
8527,
8578,
8574,
8570,
8571,
8569,
8606,
8603,
8602,
8608,
8607,
8580,
8585,
]

_charnames_43777 = [
14975,
14977,
14978,
14974,
14973,
14976,
-1,
-1,
14928,
14930,
14931,
14927,
14926,
14929,
-1,
-1,
14936,
14938,
14939,
14935,
14934,
14937,
]

_charnames_43808 = [
14885,
14887,
14889,
14886,
14884,
14883,
14888,
-1,
14961,
14963,
14965,
14962,
14960,
14959,
14964,
-1,
11213,
11179,
11209,
11212,
11073,
11204,
11040,
11197,
11191,
11196,
11276,
11264,
11082,
11207,
11208,
11153,
11093,
10998,
10999,
11000,
11001,
11054,
11568,
11141,
11242,
11140,
11243,
11038,
11039,
11214,
11118,
11124,
11128,
11010,
11123,
11249,
11251,
11252,
11312,
11308,
11311,
11310,
11334,
9416,
9296,
9241,
9240,
9250,
11053,
11106,
11157,
11126,
11094,
21730,
]

_charnames_43888 = [
2510,
2509,
2508,
2506,
2505,
2504,
2503,
2507,
2502,
2501,
2500,
2499,
2498,
2453,
2452,
2451,
2449,
2448,
2447,
2496,
2495,
2494,
2493,
2492,
2491,
2489,
2488,
2487,
2486,
2485,
2439,
2450,
2440,
2445,
2444,
2443,
2442,
2441,
2482,
2481,
2480,
2479,
2478,
2477,
2437,
2431,
2436,
2435,
2434,
2433,
2432,
2461,
2430,
2460,
2429,
2459,
2428,
2457,
2456,
2455,
2458,
2427,
2426,
2425,
2424,
2423,
2422,
2420,
2419,
2418,
2417,
2416,
2415,
2475,
2474,
2473,
2472,
2471,
2470,
2468,
8535,
8529,
8540,
8538,
8531,
8509,
8551,
8517,
8537,
8507,
8519,
8557,
8556,
8561,
8558,
8545,
8533,
8563,
8548,
8544,
8559,
8555,
8543,
8524,
8549,
8525,
8554,
8536,
8541,
8539,
8532,
8510,
8518,
8508,
8546,
8582,
8577,
8572,
8579,
8581,
8575,
8584,
8583,
8605,
8564,
8601,
-1,
-1,
8596,
8597,
8588,
8589,
8594,
8595,
8591,
8592,
8599,
8598,
]

_charnames_55216 = [
19665,
19666,
19653,
19654,
19655,
19678,
19679,
19658,
19657,
19671,
19669,
19668,
19670,
19646,
19645,
19643,
19642,
19649,
19648,
19647,
19650,
19675,
19674,
-1,
-1,
-1,
-1,
19634,
19635,
19560,
19561,
19612,
19606,
19607,
19609,
19610,
19611,
19602,
19604,
19566,
19603,
19600,
19601,
19597,
19598,
19620,
19631,
19629,
19569,
19630,
19632,
19585,
19587,
19588,
19567,
19586,
19583,
19584,
19577,
19578,
19564,
19563,
19576,
19573,
19574,
19575,
19579,
19593,
19594,
19626,
19627,
19638,
19637,
19570,
19591,
19590,
]

_charnames_64107 = [
3182,
3181,
3180,
-1,
-1,
3167,
3166,
3165,
3164,
3163,
3162,
3161,
3160,
3159,
3158,
3157,
3156,
3155,
3154,
3153,
3152,
3150,
3149,
3148,
3147,
3146,
3145,
3144,
3143,
3142,
3141,
3140,
3139,
3138,
3137,
3136,
3135,
3133,
3132,
3131,
3130,
3129,
3128,
3127,
3126,
3125,
3124,
3123,
3122,
3121,
3120,
3119,
3118,
3116,
3115,
3114,
3113,
3112,
3111,
3110,
3109,
3108,
3107,
3106,
3105,
3104,
3103,
3102,
3101,
3099,
3098,
3097,
3096,
3095,
3094,
3093,
3092,
3091,
3090,
3089,
3088,
3087,
3086,
3085,
3084,
3082,
3081,
3080,
3079,
3078,
3077,
3076,
3075,
3074,
3073,
3072,
3071,
3070,
3069,
3068,
3067,
3178,
3177,
3176,
3175,
3174,
3173,
3172,
3171,
3170,
3169,
]

_charnames_64434 = [
13026,
13025,
13016,
13015,
13022,
13021,
13020,
13019,
13033,
13032,
13027,
13014,
13013,
13034,
13030,
13029,
]

_charnames_65040 = [
20685,
20683,
20682,
20686,
20687,
20690,
20688,
20679,
20675,
20689,
]

_charnames_65060 = [
1872,
1870,
1736,
1794,
1793,
1893,
1892,
1873,
1871,
1737,
1727,
1726,
]

_charnames_65536 = [
10713,
10741,
10703,
10728,
10756,
10720,
10733,
10714,
10752,
10699,
10694,
10732,
-1,
10743,
10726,
10683,
10734,
10724,
10690,
10760,
10761,
10753,
10687,
10751,
10708,
10715,
10707,
10747,
10698,
10695,
10718,
10688,
10740,
10755,
10700,
10750,
10682,
10709,
10745,
-1,
10729,
10704,
10697,
10719,
10705,
10746,
10712,
10737,
10754,
10693,
10692,
10717,
10742,
10716,
10722,
10696,
10685,
10738,
10736,
-1,
10749,
10686,
-1,
10710,
10706,
10735,
10759,
10689,
10764,
10731,
10702,
10727,
10684,
10744,
10723,
10725,
10758,
10763,
-1,
-1,
10779,
10778,
10783,
10782,
10776,
10775,
10781,
10773,
10772,
10780,
10770,
10769,
10768,
10767,
]

_charnames_65664 = [
10557,
10556,
10555,
10542,
10541,
10540,
10554,
10553,
10551,
10550,
10548,
10547,
10545,
10544,
10607,
10606,
10605,
10604,
10603,
10791,
10790,
10611,
10610,
10609,
10788,
10787,
10601,
10600,
10599,
10598,
10597,
10587,
10586,
10585,
10584,
10583,
10792,
10582,
10581,
10580,
10568,
10567,
10566,
10565,
10564,
10563,
10562,
10561,
10560,
10559,
10578,
10577,
10576,
10575,
10574,
10573,
10572,
10571,
10570,
10595,
10594,
10593,
10592,
10591,
10590,
10589,
10614,
10613,
10644,
10643,
10641,
10640,
10639,
10638,
10637,
10636,
10634,
10633,
10632,
10631,
10630,
10629,
10793,
10628,
10627,
10625,
10624,
10623,
10622,
10621,
10620,
10619,
10618,
10617,
10678,
10668,
10667,
10666,
10665,
10664,
10663,
10662,
10661,
10660,
10659,
10657,
10656,
10655,
10654,
10653,
10652,
10651,
10650,
10649,
10648,
10675,
10674,
10673,
10672,
10671,
10670,
10676,
10677,
-1,
-1,
-1,
-1,
-1,
13570,
13571,
13577,
-1,
-1,
-1,
-1,
13557,
13502,
13509,
13532,
13539,
13518,
13524,
13551,
13545,
13515,
13506,
13513,
13536,
13543,
13519,
13525,
13552,
13546,
13560,
13505,
13512,
13535,
13542,
13523,
13529,
13556,
13550,
13559,
13504,
13511,
13534,
13541,
13522,
13528,
13555,
13549,
13516,
13507,
13514,
13537,
13544,
13520,
13526,
13553,
13547,
-1,
-1,
-1,
13568,
13565,
13567,
13566,
13564,
13576,
13575,
13574,
13573,
21563,
21559,
21564,
21536,
21547,
21542,
21539,
21550,
21541,
21568,
21552,
21557,
21544,
21561,
21540,
21546,
21569,
21553,
21558,
21545,
21562,
21567,
21551,
21570,
21601,
21579,
21599,
21603,
21577,
21607,
21604,
21590,
21594,
21595,
21598,
21611,
21578,
21576,
21592,
21593,
21600,
21587,
21582,
21575,
21605,
21591,
21586,
21608,
21610,
21581,
21585,
21612,
21609,
21745,
21746,
21736,
21739,
21757,
21742,
21762,
21749,
21737,
21740,
21754,
21755,
21752,
21760,
21733,
21748,
21758,
21614,
21615,
21761,
21741,
21756,
21747,
21707,
21656,
18940,
-1,
23866,
23880,
23868,
23865,
23878,
23869,
23879,
23881,
23867,
23877,
23883,
23882,
-1,
-1,
-1,
-1,
21706,
]

_charnames_66000 = [
20406,
20404,
20411,
20384,
20386,
20417,
20415,
20430,
20410,
20438,
20397,
20390,
20385,
20424,
20423,
20394,
20427,
20398,
20383,
20433,
20378,
20393,
20380,
20400,
20389,
20413,
20414,
20401,
20382,
20421,
20437,
20432,
20409,
20399,
20405,
20434,
20407,
20420,
20426,
20435,
20436,
20429,
20391,
20392,
20418,
20379,
]

_charnames_66176 = [
11894,
11890,
11892,
11893,
11908,
11909,
11906,
11898,
11896,
11883,
11905,
11888,
11902,
11904,
11886,
11884,
11887,
11885,
11899,
11903,
11889,
11901,
11900,
11881,
11882,
11895,
11891,
11907,
11897,
-1,
-1,
-1,
2700,
2686,
2695,
2680,
2658,
2683,
2681,
2701,
2703,
2705,
2668,
2704,
2696,
2677,
2665,
2666,
2662,
2699,
2656,
2674,
2702,
2673,
2679,
2685,
2667,
2689,
2693,
2659,
2687,
2688,
2676,
2657,
2691,
2692,
2663,
2664,
2675,
2690,
2698,
2678,
2661,
2684,
2669,
2672,
2671,
2670,
2682,
2694,
2660,
]

_charnames_66272 = [
2128,
2125,
2117,
2118,
2123,
2124,
2120,
2121,
2127,
2126,
2093,
2089,
2092,
2104,
2107,
2096,
2099,
2112,
2109,
2114,
2088,
2091,
2103,
2106,
2097,
2100,
2113,
2110,
]

_charnames_66384 = [
21012,
21011,
21009,
20987,
20999,
20989,
20986,
20990,
20985,
20980,
21007,
21006,
21005,
21004,
20992,
21003,
21002,
20979,
20996,
21001,
21010,
20977,
20978,
20974,
20969,
20997,
20998,
21000,
21008,
20995,
20993,
20968,
20970,
20972,
20981,
20973,
20971,
20982,
1865,
1864,
1861,
1863,
1862,
-1,
-1,
-1,
-1,
-1,
24900,
24912,
24895,
24889,
24898,
24891,
24903,
24887,
24892,
24884,
24902,
24890,
24880,
24910,
24909,
24897,
24908,
24886,
24877,
24901,
24907,
24878,
24906,
24905,
24883,
24894,
24882,
24911,
24904,
24879,
-1,
24913,
20906,
20952,
20949,
20940,
20939,
20946,
20945,
20928,
20955,
20943,
20942,
20913,
20911,
20901,
20905,
20904,
20912,
20950,
20923,
20954,
20937,
20936,
20921,
20920,
20919,
20948,
20931,
20930,
20934,
20933,
20951,
20917,
20947,
20916,
20915,
20953,
-1,
-1,
-1,
-1,
20907,
20909,
20908,
20927,
20902,
20903,
20924,
20925,
20964,
20962,
20959,
20961,
20960,
20963,
]

_charnames_66638 = [
22809,
22810,
7135,
7111,
7138,
7141,
7109,
7124,
7123,
7143,
7118,
7129,
7144,
7142,
7140,
7132,
7110,
7131,
7127,
7139,
7121,
7130,
7137,
7126,
7113,
7106,
7089,
7093,
7098,
7120,
7095,
7091,
7134,
7136,
7103,
7092,
7114,
7133,
7100,
7097,
7099,
7088,
7087,
7096,
7090,
7105,
7086,
7104,
7115,
7117,
21407,
21438,
21426,
21432,
21423,
21415,
21421,
21427,
21411,
21410,
21420,
21437,
21435,
21436,
21428,
21416,
21431,
21430,
21429,
21424,
21434,
21422,
21406,
21417,
21433,
21412,
21425,
21408,
21418,
21413,
-1,
-1,
21449,
21450,
21441,
21442,
21447,
21448,
21444,
21445,
21452,
21451,
-1,
-1,
-1,
-1,
-1,
-1,
21369,
21370,
21371,
21372,
21403,
21402,
21367,
21360,
21368,
21392,
21391,
21399,
21381,
21366,
21379,
21398,
21397,
21396,
21388,
21389,
21395,
21365,
21387,
21386,
21377,
21364,
21376,
21363,
21375,
21401,
21394,
21393,
21380,
21400,
21384,
21383,
-1,
-1,
-1,
-1,
21324,
21325,
21326,
21327,
21358,
21357,
21322,
21315,
21323,
21347,
21346,
21354,
21336,
21321,
21334,
21353,
21352,
21351,
21343,
21344,
21350,
21320,
21342,
21341,
21332,
21319,
21331,
21318,
21330,
21356,
21349,
21348,
21335,
21355,
21339,
21338,
-1,
-1,
-1,
-1,
15121,
15120,
15107,
15106,
15104,
15074,
15103,
15101,
15100,
15119,
15081,
15080,
15118,
15117,
15116,
15099,
15096,
15095,
15115,
15073,
15075,
15072,
15114,
15113,
15112,
15093,
15092,
15090,
15089,
15087,
15086,
15111,
15110,
15109,
15108,
15084,
15083,
15078,
15079,
15098,
]

_charnames_66864 = [
2781,
2790,
2774,
2741,
2778,
2746,
2777,
2744,
2750,
2720,
2756,
2745,
2753,
2732,
2766,
2754,
2782,
2740,
2729,
2771,
2769,
2765,
2788,
2759,
2780,
2722,
2723,
2725,
2787,
2760,
2786,
2738,
2733,
2772,
2785,
2748,
2789,
2739,
2721,
2763,
2775,
2784,
2735,
2783,
2749,
2734,
2752,
2726,
2728,
2757,
2762,
2768,
]

_charnames_67072 = [
10174,
10173,
10172,
10171,
10170,
10169,
10168,
10167,
10166,
10218,
10217,
10216,
10215,
10214,
10154,
10144,
10146,
10145,
10141,
10143,
10142,
10147,
10148,
10153,
10152,
10151,
10150,
10533,
10149,
10212,
10211,
10210,
10209,
10208,
10207,
10183,
10182,
10181,
10180,
10179,
10178,
10177,
10176,
10164,
10163,
10162,
10161,
10160,
10159,
10158,
10157,
10156,
10205,
10204,
10203,
10202,
10201,
10200,
10191,
10190,
10189,
10188,
10187,
10186,
10185,
10198,
10197,
10196,
10195,
10194,
10193,
10532,
10233,
10223,
10531,
10222,
10221,
10229,
10228,
10530,
10232,
10231,
10226,
10225,
10230,
10352,
10351,
10350,
10349,
10348,
10347,
10346,
10345,
10344,
10343,
10342,
10339,
10338,
10337,
10330,
10329,
10328,
10336,
10335,
10334,
10333,
10332,
10331,
10407,
10406,
10405,
10404,
10403,
10402,
10401,
10400,
10399,
10398,
10396,
10395,
10394,
10393,
10392,
10391,
10390,
10389,
10388,
10387,
10385,
10384,
10383,
10382,
10381,
10380,
10379,
10378,
10377,
10376,
10374,
10373,
10372,
10371,
10370,
10369,
10368,
10367,
10366,
10365,
10363,
10362,
10361,
10360,
10359,
10358,
10357,
10356,
10355,
10354,
10410,
10409,
10509,
10508,
10507,
10506,
10505,
10504,
10503,
10502,
10501,
10500,
10519,
10518,
10517,
10516,
10515,
10514,
10513,
10512,
10511,
10295,
10294,
10293,
10292,
10291,
10290,
10289,
10288,
10324,
10323,
10322,
10321,
10320,
10319,
10286,
10285,
10284,
10283,
10282,
10281,
10280,
10279,
10278,
10276,
10275,
10274,
10273,
10272,
10271,
10270,
10269,
10268,
10303,
10302,
10301,
10300,
10299,
10298,
10297,
10266,
10265,
10264,
10263,
10262,
10261,
10260,
10259,
10258,
10317,
10316,
10315,
10314,
10313,
10312,
10256,
10255,
10254,
10253,
10252,
10251,
10250,
10249,
10248,
10247,
10245,
10244,
10243,
10242,
10241,
10240,
10239,
10238,
10237,
10236,
10310,
10309,
10308,
10307,
10306,
10305,
10460,
10459,
10458,
10457,
10456,
10455,
10454,
10453,
10422,
10421,
10420,
10419,
10418,
10417,
10416,
10415,
10414,
10413,
10442,
10441,
10440,
10439,
10438,
10437,
10436,
10435,
10434,
10470,
10469,
10468,
10451,
10450,
10449,
10448,
10447,
10446,
10445,
10444,
10432,
10431,
10430,
10429,
10428,
10427,
10426,
10425,
10424,
10466,
10465,
10464,
10463,
10462,
]

_charnames_67392 = [
10487,
10486,
10485,
10484,
10483,
10482,
10481,
10480,
10479,
10478,
10477,
10476,
10475,
10495,
10494,
10493,
10492,
10491,
10490,
10489,
10497,
10496,
]

_charnames_67424 = [
10528,
10527,
10526,
10525,
10524,
10523,
10522,
10521,
]

_charnames_67584 = [
3062,
3061,
3060,
3059,
3058,
3057,
-1,
-1,
3056,
-1,
3043,
3042,
3041,
3040,
3039,
3037,
3036,
3035,
3034,
3033,
3031,
3030,
3029,
3028,
3027,
3025,
3024,
3023,
3022,
3021,
3019,
3018,
3017,
3016,
3015,
3013,
3012,
3011,
3010,
3009,
3007,
3006,
3005,
3004,
3003,
3001,
3000,
2999,
2998,
2997,
3048,
3047,
3046,
3045,
-1,
3054,
3053,
-1,
-1,
-1,
3051,
-1,
-1,
3050,
24473,
24486,
24484,
24485,
24469,
24476,
24474,
24470,
24467,
24475,
24483,
24482,
24481,
24480,
24463,
24472,
24479,
24464,
24478,
24477,
24465,
24468,
-1,
24499,
24495,
24490,
24494,
24492,
24491,
24498,
24497,
24493,
20243,
20257,
20254,
20256,
20239,
20246,
20244,
20240,
20237,
20245,
20253,
20252,
20251,
20255,
20250,
20233,
20242,
20249,
20234,
20248,
20247,
20235,
20238,
20258,
20270,
20269,
20262,
20264,
20267,
20268,
20265,
20263,
18953,
18966,
18952,
18979,
18977,
18978,
18951,
18962,
18969,
18967,
18963,
18960,
18945,
18968,
18950,
18976,
18949,
18975,
18948,
18974,
18947,
18973,
18956,
18965,
18972,
18957,
18971,
18970,
18946,
18958,
18961,
]

_charnames_67751 = [
18987,
18983,
18985,
18990,
18992,
18991,
18986,
18984,
18988,
]

_charnames_67808 = [
19814,
19826,
19824,
19825,
19810,
19817,
19815,
19811,
19808,
19816,
19823,
19822,
19821,
19820,
19804,
19813,
19819,
19805,
19818,
-1,
19806,
19809,
-1,
-1,
-1,
-1,
-1,
19831,
19833,
19830,
19829,
19832,
20452,
20466,
20464,
20465,
20449,
20456,
20454,
20450,
20447,
20455,
20463,
20462,
20461,
20460,
20444,
20453,
20459,
20445,
20458,
20457,
20443,
20448,
20474,
20473,
20471,
20475,
20470,
20472,
-1,
-1,
-1,
20476,
11922,
11937,
11933,
11935,
11920,
11925,
11932,
11924,
11931,
11918,
11930,
11916,
11929,
11927,
11915,
11912,
11926,
11934,
11928,
11914,
11913,
11923,
11921,
11919,
11917,
11936,
-1,
-1,
-1,
-1,
-1,
11938,
]

_charnames_67968 = [
8362,
8360,
8358,
8355,
8351,
8352,
8349,
8350,
8354,
8356,
8338,
8339,
8336,
8337,
8344,
8345,
8357,
8347,
8359,
8341,
8342,
8343,
8348,
8353,
8332,
8333,
8330,
8331,
8334,
8361,
8363,
8364,
8291,
8303,
8301,
8298,
8293,
8294,
8305,
8297,
8299,
8287,
8286,
8295,
8300,
8289,
8302,
8284,
8292,
8283,
8290,
8296,
8281,
8280,
8279,
8304,
-1,
-1,
-1,
-1,
8324,
8319,
8307,
8308,
8271,
8210,
8218,
8244,
8252,
8228,
8235,
8265,
8259,
8225,
8215,
8223,
8249,
8257,
8233,
8240,
-1,
-1,
8273,
8212,
8220,
8246,
8254,
8230,
8237,
8267,
8261,
8275,
8214,
8222,
8248,
8256,
8232,
8239,
8269,
8263,
8226,
8216,
8224,
8250,
8258,
8234,
8241,
8270,
8264,
8274,
8213,
8221,
8247,
8255,
8231,
8238,
8268,
8262,
8318,
8311,
8312,
8321,
8322,
8315,
8316,
8325,
8326,
8313,
23194,
23215,
23213,
23212,
-1,
23216,
23214,
-1,
-1,
-1,
-1,
-1,
23217,
23221,
23226,
23223,
23171,
23170,
23180,
23179,
-1,
23183,
23182,
23192,
-1,
23165,
23151,
23150,
23157,
23156,
23166,
23153,
23152,
23159,
23158,
23167,
23177,
23176,
23186,
23185,
23190,
23188,
23189,
23191,
23174,
23162,
23161,
23163,
23187,
23193,
23169,
23148,
23149,
23173,
-1,
-1,
23225,
23224,
23222,
-1,
-1,
-1,
-1,
23218,
23238,
23236,
23237,
23239,
23230,
23229,
23233,
23232,
23240,
]

_charnames_68176 = [
23199,
23207,
23206,
23205,
23208,
23202,
23200,
23198,
23203,
]

_charnames_68192 = [
21170,
21185,
21171,
21184,
21182,
21180,
21161,
21181,
21187,
21155,
21158,
21169,
21183,
21168,
21160,
21159,
21186,
21177,
21176,
21165,
21173,
21166,
21174,
21154,
21178,
21164,
21179,
21153,
21152,
21190,
21191,
21192,
21212,
21230,
21213,
21229,
21227,
21224,
21203,
21226,
21232,
21199,
21204,
21210,
21228,
21209,
21225,
21202,
21231,
21221,
21222,
21219,
21216,
21218,
21215,
21200,
21206,
21198,
21223,
21197,
21207,
21237,
21236,
21235,
]

_charnames_68288 = [
8644,
8671,
8670,
8664,
8665,
8668,
8661,
8673,
8699,
8648,
8647,
8660,
8659,
8662,
8640,
8672,
8657,
8651,
8656,
8678,
8667,
8639,
8677,
8676,
8634,
8643,
8645,
8675,
8679,
8635,
8653,
8650,
8654,
8674,
8637,
8636,
8641,
8698,
8697,
-1,
-1,
-1,
-1,
8693,
8695,
8692,
8691,
8694,
8686,
8688,
8684,
8683,
8682,
8685,
8687,
]

_charnames_68352 = [
13582,
13583,
13588,
13584,
13589,
13585,
13586,
13587,
13631,
13632,
13624,
13625,
13626,
13627,
13622,
13623,
13644,
13607,
13605,
13606,
13615,
13614,
13613,
13647,
13645,
13611,
13610,
13635,
13634,
13609,
13641,
13646,
13638,
13637,
13594,
13592,
13593,
13597,
13595,
13596,
13642,
13629,
13620,
13621,
13639,
13640,
13643,
13603,
13618,
13601,
13617,
13600,
13602,
13630,
-1,
-1,
-1,
13648,
5200,
7873,
11613,
11609,
11612,
11608,
24368,
24381,
24379,
24380,
24364,
24371,
24369,
24365,
24362,
24370,
24378,
24377,
24376,
24375,
24358,
24367,
24374,
24359,
24373,
24372,
24360,
24363,
-1,
-1,
24389,
24385,
24387,
24393,
24388,
24386,
24392,
24391,
24417,
24416,
24414,
24415,
24404,
24408,
24406,
24405,
24402,
24407,
24413,
24412,
24411,
24410,
24398,
24409,
24399,
24400,
24403,
-1,
-1,
-1,
-1,
-1,
24425,
24421,
24423,
24429,
24424,
24422,
24428,
24427,
20615,
20614,
20612,
20613,
20601,
20605,
20603,
20602,
20604,
20611,
20610,
20609,
20608,
20598,
20607,
20599,
20600,
20606,
]

_charnames_68521 = [
20623,
20619,
20621,
20625,
20622,
20620,
20624,
]

_charnames_68608 = [
21015,
21061,
21062,
21056,
21092,
21080,
21050,
21051,
21089,
21037,
21079,
21026,
21069,
21035,
21077,
21024,
21068,
21036,
21078,
21025,
21044,
21085,
21029,
21070,
21017,
21065,
21023,
21067,
21052,
21090,
21034,
21076,
21022,
21048,
21047,
21033,
21021,
21063,
21041,
21083,
21043,
21084,
21040,
21082,
21075,
21042,
21064,
21046,
21055,
21058,
21049,
21087,
21032,
21074,
21057,
21093,
21054,
21091,
21031,
21073,
21020,
21027,
21019,
21028,
21072,
21045,
21086,
21030,
21071,
21018,
21066,
21053,
21059,
]

_charnames_68736 = [
20865,
20869,
20864,
20867,
20840,
20839,
20841,
20863,
20866,
20834,
20886,
20862,
20861,
20853,
20854,
20860,
20883,
20884,
20859,
20858,
20868,
20873,
20851,
20852,
20849,
20835,
20838,
20874,
20875,
20882,
20879,
20876,
20857,
20850,
20856,
20885,
20847,
20848,
20845,
20836,
20846,
20842,
20870,
20871,
20881,
20878,
20855,
20843,
20844,
20837,
20872,
]

_charnames_68800 = [
20811,
20815,
20810,
20813,
20786,
20785,
20787,
20809,
20812,
20780,
20832,
20808,
20807,
20799,
20800,
20806,
20829,
20830,
20805,
20804,
20814,
20819,
20797,
20798,
20795,
20781,
20784,
20820,
20821,
20828,
20825,
20822,
20803,
20796,
20802,
20831,
20793,
20794,
20791,
20782,
20792,
20788,
20816,
20817,
20827,
20824,
20801,
20789,
20790,
20783,
20818,
]

_charnames_68858 = [
20888,
20893,
20895,
20894,
20891,
20890,
19763,
19762,
19754,
19740,
19739,
19757,
19761,
19758,
19732,
19760,
19749,
19748,
19746,
19745,
19750,
19743,
19742,
19733,
19759,
19756,
19755,
19737,
19752,
19731,
19751,
19730,
19736,
19735,
19753,
19783,
19781,
19779,
19782,
19780,
19791,
19792,
19789,
19788,
19787,
19786,
]

_charnames_68912 = [
19774,
19775,
19766,
19767,
19772,
19773,
19769,
19770,
19777,
19776,
]

_charnames_69216 = [
23827,
23819,
23820,
23825,
23826,
23822,
23823,
23829,
23828,
23795,
23791,
23794,
23806,
23809,
23798,
23801,
23814,
23811,
23816,
23790,
23793,
23805,
23808,
23799,
23802,
23815,
23812,
23834,
23833,
23832,
23835,
]

_charnames_69376 = [
21116,
21107,
21131,
21106,
21130,
21118,
21105,
21122,
21120,
21119,
21121,
21129,
21128,
21127,
21126,
21103,
21104,
21110,
21117,
21115,
21125,
21111,
21101,
21102,
21124,
21112,
21123,
21099,
21100,
21142,
21136,
21139,
21145,
21146,
21141,
21137,
21140,
21143,
21147,
21132,
]

_charnames_69424 = [
6830,
6842,
6840,
6826,
6833,
6831,
6827,
6832,
6839,
6825,
6838,
6837,
6820,
6829,
6836,
6821,
6835,
6822,
6834,
6841,
6824,
6872,
6851,
6845,
6852,
6846,
6855,
6854,
6849,
6848,
6858,
6857,
6856,
6870,
6869,
6868,
6871,
6861,
6862,
6865,
6863,
6864,
]

_charnames_69632 = [
16634,
16635,
16631,
16633,
16632,
16526,
16529,
16548,
16549,
16534,
16535,
16499,
16500,
16501,
16502,
16563,
16528,
16510,
16527,
16544,
16543,
16552,
16551,
16518,
16555,
16554,
16547,
16546,
16516,
16507,
16506,
16523,
16522,
16517,
16509,
16508,
16525,
16524,
16519,
16538,
16537,
16558,
16557,
16561,
16559,
16560,
16541,
16503,
16532,
16531,
16533,
16562,
16540,
16514,
16512,
16513,
16604,
16611,
16607,
16608,
16605,
16606,
16597,
16598,
16599,
16600,
16610,
16603,
16609,
16602,
16612,
16629,
16628,
16642,
16641,
16639,
16643,
16638,
-1,
-1,
-1,
-1,
16585,
16567,
16570,
16580,
16583,
16574,
16576,
16591,
16589,
16572,
16568,
16571,
16581,
16584,
16575,
16577,
16592,
16590,
16588,
16587,
16624,
16625,
16616,
16617,
16622,
16623,
16619,
16620,
16627,
16626,
]

_charnames_69759 = [
16593,
23402,
23403,
23399,
23345,
23348,
23367,
23368,
23353,
23354,
23384,
23347,
23380,
23346,
23363,
23362,
23371,
23370,
23343,
23374,
23373,
23366,
23365,
23341,
23337,
23336,
23331,
23330,
23329,
23356,
23342,
23339,
23338,
23333,
23332,
23344,
23360,
23359,
23377,
23376,
23381,
23378,
23357,
23382,
23379,
23351,
23350,
23352,
23383,
23389,
23392,
23393,
23390,
23391,
23395,
23388,
23394,
23387,
23400,
23401,
23413,
23412,
23410,
23404,
23407,
23409,
23408,
]

_charnames_69837 = [
23411,
-1,
-1,
6889,
6888,
6901,
6900,
6899,
6898,
6880,
6877,
6893,
6878,
6886,
6891,
6885,
6890,
6897,
6894,
6895,
6876,
6902,
6884,
6896,
6887,
6892,
6883,
6881,
]

_charnames_69872 = [
6913,
6914,
6905,
6906,
6911,
6912,
6908,
6909,
6916,
6915,
-1,
-1,
-1,
-1,
-1,
-1,
2392,
2393,
2391,
2356,
2353,
2349,
2355,
2335,
2334,
2341,
2340,
2316,
2344,
2343,
2338,
2337,
2314,
2310,
2309,
2321,
2320,
2315,
2312,
2311,
2323,
2322,
2317,
2329,
2328,
2347,
2346,
2352,
2325,
2326,
2351,
2332,
2348,
2350,
2354,
2359,
2367,
2368,
2363,
2364,
2369,
2361,
2365,
2360,
2366,
2396,
2398,
2371,
2397,
-1,
2383,
2384,
2375,
2376,
2381,
2382,
2378,
2379,
2386,
2385,
2394,
2388,
2387,
2395,
2331,
2362,
2370,
]

_charnames_69968 = [
8867,
8864,
8859,
8866,
8861,
8845,
8844,
8851,
8850,
8854,
8853,
8848,
8847,
8834,
8824,
8823,
8830,
8829,
8835,
8826,
8825,
8832,
8831,
8836,
8842,
8841,
8857,
8856,
8862,
8839,
8863,
8858,
8860,
8865,
8838,
8870,
8872,
8871,
8868,
]

_charnames_70016 = [
7049,
7044,
7040,
6980,
6983,
7002,
7003,
6988,
6989,
6958,
6959,
6960,
6961,
7018,
6982,
7015,
6981,
6998,
6997,
7006,
7005,
6972,
7009,
7008,
7001,
7000,
6970,
6966,
6965,
6977,
6976,
6971,
6968,
6967,
6979,
6978,
6973,
6992,
6991,
7012,
7011,
7016,
7013,
7014,
6995,
6994,
6962,
6986,
6985,
6987,
7017,
7029,
7032,
7033,
7030,
7031,
7022,
7023,
7024,
7025,
7035,
7028,
7034,
7027,
7041,
7043,
7048,
7045,
7077,
7073,
7072,
7080,
7054,
7056,
7047,
7036,
7075,
7055,
-1,
-1,
7068,
7069,
7060,
7061,
7066,
7067,
7063,
7064,
7071,
7070,
7076,
7046,
7078,
7079,
7053,
7052,
-1,
6670,
6662,
6663,
6668,
6669,
6665,
6666,
6672,
6671,
6648,
6646,
6647,
6656,
6657,
6650,
6651,
6659,
6658,
6654,
6653,
]

_charnames_70144 = [
23261,
23264,
23295,
23290,
23297,
23263,
23293,
23262,
23281,
23280,
23268,
23267,
23266,
23259,
23287,
23286,
23284,
23283,
-1,
23257,
23253,
23252,
23247,
23245,
23258,
23255,
23254,
23249,
23246,
23248,
23260,
23275,
23274,
23272,
23271,
23270,
23294,
23288,
23292,
23278,
23289,
23291,
23296,
23277,
23302,
23303,
23304,
23305,
23307,
23301,
23306,
23300,
23315,
23313,
23314,
23312,
23321,
23320,
23322,
23316,
23319,
23323,
23311,
]

_charnames_70272 = [
10043,
10040,
10036,
10042,
10021,
10020,
10027,
-1,
10026,
-1,
10030,
10029,
10024,
10023,
-1,
10013,
10005,
10004,
9999,
9998,
9997,
10014,
10007,
10006,
10001,
10000,
10015,
10018,
10017,
10033,
-1,
10032,
10038,
10034,
10011,
10039,
10035,
10037,
10041,
10009,
10010,
10044,
-1,
-1,
-1,
-1,
-1,
-1,
23072,
23075,
23102,
23103,
23088,
23089,
23113,
23074,
23109,
23073,
23101,
23100,
23083,
23082,
23081,
23070,
23106,
23105,
23079,
23077,
23078,
23068,
23064,
23063,
23058,
23057,
23094,
23056,
23069,
23066,
23065,
23060,
23059,
23071,
23098,
23097,
23087,
23086,
23085,
23110,
23107,
23095,
23111,
23108,
23091,
23092,
23112,
23142,
23132,
23135,
23136,
23133,
23134,
23138,
23131,
23137,
23130,
23141,
23140,
-1,
-1,
-1,
-1,
-1,
23124,
23125,
23116,
23117,
23122,
23123,
23119,
23120,
23127,
23126,
-1,
-1,
-1,
-1,
-1,
-1,
21858,
21859,
21862,
21855,
-1,
21798,
21801,
21820,
21821,
21806,
21807,
21773,
21775,
-1,
-1,
21836,
21800,
-1,
-1,
21833,
21799,
21816,
21815,
21824,
21823,
21790,
21827,
21826,
21819,
21818,
21788,
21784,
21783,
21795,
21794,
21789,
21786,
21785,
21797,
21796,
21791,
-1,
21810,
21809,
21830,
21829,
21834,
21831,
21832,
-1,
21813,
21812,
-1,
21780,
21804,
21803,
21805,
21835,
-1,
1920,
21864,
21861,
21846,
21849,
21850,
21847,
21848,
21839,
21840,
-1,
-1,
21852,
21845,
-1,
-1,
21851,
21844,
21856,
-1,
-1,
21865,
-1,
-1,
-1,
-1,
-1,
-1,
21866,
-1,
-1,
-1,
-1,
-1,
21863,
21779,
21778,
21774,
21776,
21841,
21842,
-1,
-1,
1653,
1655,
1648,
1649,
1651,
1652,
1654,
-1,
-1,
-1,
1661,
1660,
1659,
1657,
1658,
]

_charnames_70656 = [
18507,
18510,
18535,
18536,
18515,
18516,
18491,
18492,
18493,
18494,
18550,
18509,
18548,
18508,
18531,
18530,
18539,
18538,
18486,
18485,
18542,
18541,
18534,
18533,
18483,
18482,
18498,
18497,
18504,
18503,
18487,
18500,
18499,
18506,
18505,
18489,
18488,
18522,
18521,
18545,
18544,
18525,
18524,
18546,
18519,
18518,
18528,
18527,
18547,
18513,
18512,
18514,
18549,
18560,
18563,
18564,
18561,
18562,
18553,
18554,
18555,
18556,
18566,
18559,
18565,
18558,
18589,
18595,
18592,
18588,
18593,
18591,
18594,
18599,
18596,
18583,
18582,
18602,
18601,
18603,
18578,
18579,
18570,
18571,
18576,
18577,
18573,
18574,
18581,
18580,
-1,
18598,
-1,
18600,
18597,
]

_charnames_70784 = [
5097,
5017,
5020,
5036,
5037,
5025,
5026,
4995,
4996,
4997,
4998,
5053,
5019,
5049,
5018,
5032,
5031,
5040,
5039,
5009,
5043,
5042,
5035,
5034,
5007,
5003,
5002,
5014,
5013,
5008,
5005,
5004,
5016,
5015,
5010,
5029,
5028,
5046,
5045,
5050,
5047,
5048,
5051,
4999,
5023,
5022,
5024,
5052,
5063,
5069,
5070,
5064,
5065,
5056,
5057,
5058,
5059,
5072,
5068,
5062,
5071,
5067,
5061,
5095,
5093,
5089,
5090,
5094,
5092,
5100,
5098,
5099,
]

_charnames_70864 = [
5083,
5084,
5075,
5076,
5081,
5082,
5078,
5079,
5086,
5085,
]

_charnames_71040 = [
6525,
6529,
6556,
6557,
6545,
6546,
6520,
6521,
6522,
6523,
6573,
6528,
6569,
6526,
6552,
6551,
6560,
6559,
6533,
6563,
6562,
6555,
6554,
6531,
6513,
6512,
6538,
6537,
6532,
6517,
6516,
6540,
6539,
6534,
6549,
6548,
6566,
6565,
6570,
6567,
6568,
6571,
6524,
6543,
6542,
6544,
6572,
6613,
6618,
6619,
6616,
6617,
6614,
6615,
-1,
-1,
6621,
6612,
6620,
6611,
6605,
6606,
6601,
6602,
6604,
6603,
6628,
6627,
6597,
6598,
6625,
6624,
6623,
6629,
6580,
6581,
6586,
6585,
6584,
6594,
6595,
6593,
6582,
6592,
6591,
6589,
6588,
6590,
6515,
6509,
6510,
6527,
6609,
6610,
]

_charnames_71168 = [
9443,
9446,
9465,
9466,
9451,
9452,
9421,
9422,
9423,
9424,
9481,
9445,
9478,
9444,
9461,
9460,
9469,
9468,
9435,
9472,
9471,
9464,
9463,
9433,
9429,
9428,
9440,
9439,
9434,
9431,
9430,
9442,
9441,
9436,
9455,
9454,
9475,
9474,
9479,
9476,
9477,
9458,
9425,
9449,
9448,
9450,
9480,
9457,
9491,
9494,
9495,
9492,
9493,
9484,
9485,
9486,
9487,
9497,
9490,
9496,
9489,
9521,
9517,
9518,
9520,
9514,
9513,
9523,
9522,
]

_charnames_71248 = [
9509,
9510,
9501,
9502,
9507,
9508,
9504,
9505,
9512,
9511,
-1,
-1,
-1,
-1,
-1,
-1,
9544,
9531,
9546,
9537,
9545,
9533,
9534,
9541,
9542,
9527,
9529,
9530,
9536,
]

_charnames_71296 = [
4910,
4913,
4931,
4932,
4914,
4915,
4948,
4912,
4944,
4911,
4927,
4926,
4935,
4934,
4902,
4938,
4937,
4930,
4929,
4900,
4896,
4895,
4907,
4906,
4901,
4898,
4897,
4909,
4908,
4903,
4924,
4923,
4941,
4940,
4945,
4942,
4921,
4946,
4943,
4917,
4918,
4947,
4920,
4979,
4976,
4967,
4970,
4971,
4968,
4969,
4973,
4966,
4972,
4965,
4977,
4978,
]

_charnames_71360 = [
4959,
4960,
4951,
4952,
4957,
4958,
4954,
4955,
4962,
4961,
]

_charnames_71424 = [
13436,
13435,
13426,
13427,
13430,
13421,
13433,
13432,
13448,
13451,
13439,
13454,
13429,
13450,
13452,
13449,
13425,
13453,
13419,
13445,
13444,
13442,
13422,
13441,
13447,
13438,
13423,
-1,
-1,
13492,
13493,
13491,
13456,
13460,
13463,
13464,
13461,
13462,
13466,
13457,
13465,
13459,
13458,
13487,
-1,
-1,
-1,
-1,
13477,
13478,
13469,
13470,
13475,
13476,
13472,
13473,
13480,
13479,
13496,
13495,
13484,
13485,
13486,
13488,
]

_charnames_71680 = [
22422,
22425,
22444,
22445,
22430,
22431,
22461,
22424,
22457,
22423,
22440,
22439,
22448,
22447,
22414,
22451,
22450,
22443,
22442,
22412,
22408,
22407,
22419,
22418,
22413,
22410,
22409,
22421,
22420,
22415,
22437,
22436,
22454,
22453,
22458,
22455,
22434,
22459,
22456,
22428,
22427,
22429,
22460,
22433,
22466,
22471,
22472,
22469,
22470,
22467,
22468,
22474,
22465,
22473,
22464,
22480,
22477,
22478,
22479,
22481,
]

_charnames_71840 = [
24026,
24008,
24027,
23998,
24001,
24000,
24032,
24017,
24012,
24022,
24010,
24033,
24031,
24014,
23999,
24018,
24015,
24023,
24029,
24025,
24034,
24009,
24011,
24035,
24030,
24006,
24005,
24004,
24007,
24020,
24021,
24028,
23986,
23968,
23987,
23958,
23961,
23960,
23992,
23977,
23972,
23982,
23970,
23993,
23991,
23974,
23959,
23978,
23975,
23983,
23989,
23985,
23994,
23969,
23971,
23995,
23990,
23966,
23965,
23964,
23967,
23980,
23981,
23988,
24046,
24047,
24038,
24039,
24044,
24045,
24041,
24042,
24049,
24048,
24054,
24052,
24053,
24059,
24060,
24056,
24057,
24062,
24061,
]

_charnames_72192 = [
24983,
24995,
24988,
24987,
24996,
24990,
24989,
24993,
24992,
24994,
24997,
24960,
24959,
24969,
24968,
24951,
24972,
24971,
24981,
24949,
24933,
24932,
24945,
24944,
24950,
24938,
24937,
24947,
24946,
24952,
24966,
24965,
24975,
24974,
24979,
24936,
24935,
24942,
24941,
24962,
24963,
24984,
24976,
24978,
24980,
24977,
24955,
24954,
24956,
24982,
24958,
25028,
25006,
25001,
25002,
25003,
25007,
25005,
25016,
25012,
25014,
25015,
25013,
25026,
25018,
25021,
25022,
25024,
25023,
25027,
25019,
25008,
]

_charnames_72272 = [
6762,
6789,
6783,
6782,
6790,
6784,
6785,
6788,
6787,
6780,
6781,
6791,
6737,
6736,
6749,
6748,
6728,
6752,
6751,
6746,
6745,
6726,
6712,
6711,
6721,
6720,
6727,
6717,
6716,
6724,
6723,
6729,
6743,
6742,
6755,
6754,
6759,
6715,
6714,
6722,
6739,
6740,
6763,
6756,
6758,
6760,
6757,
6732,
6731,
6733,
6761,
6735,
-1,
-1,
6801,
6802,
6799,
6800,
6773,
6772,
6768,
6774,
6767,
6775,
6770,
6769,
6771,
6766,
6765,
6776,
6806,
6805,
6815,
6807,
6793,
6794,
6796,
6795,
6810,
6811,
6808,
6814,
6813,
]

_charnames_72384 = [
20131,
20137,
20149,
20148,
20153,
20143,
20144,
20133,
20150,
20151,
20136,
20145,
20154,
20142,
20128,
20127,
20134,
20130,
20146,
20123,
20141,
20155,
20152,
20138,
20147,
20124,
20125,
20139,
20119,
20122,
20118,
20120,
20114,
20121,
20117,
20115,
20116,
20171,
20169,
20167,
20172,
20173,
20168,
20164,
20162,
20165,
20166,
20174,
20180,
20176,
20177,
20158,
20156,
20178,
20159,
20160,
20181,
]

_charnames_72704 = [
16684,
16687,
16703,
16704,
16692,
16693,
16663,
16664,
16665,
-1,
16720,
16686,
16716,
16685,
16699,
16698,
16707,
16706,
16676,
16710,
16709,
16702,
16701,
16674,
16670,
16669,
16681,
16680,
16675,
16672,
16671,
16683,
16682,
16677,
16696,
16695,
16713,
16712,
16717,
16714,
16715,
16718,
16666,
16690,
16689,
16691,
16719,
16755,
16758,
16759,
16756,
16757,
16749,
16750,
16751,
-1,
16761,
16754,
16760,
16753,
16786,
16785,
16781,
16782,
16784,
16778,
16777,
16790,
16789,
16788,
]

_charnames_72784 = [
16773,
16774,
16765,
16766,
16771,
16772,
16768,
16769,
16776,
16775,
16746,
16724,
16727,
16737,
16740,
16731,
16733,
16744,
16742,
16729,
16725,
16728,
16738,
16741,
16732,
16734,
16745,
16743,
16791,
-1,
-1,
-1,
9064,
9063,
9039,
9038,
9053,
9026,
9045,
9044,
9051,
9025,
9023,
9022,
9042,
9027,
9036,
9035,
9054,
9049,
9021,
9020,
9041,
9047,
9029,
9030,
9056,
9046,
9048,
9050,
9032,
9033,
9052,
9055,
-1,
-1,
8997,
8996,
9011,
8984,
9003,
9002,
9009,
8983,
8981,
8980,
9000,
8985,
8994,
8993,
9012,
9007,
8979,
8978,
8999,
9005,
8987,
8988,
-1,
9004,
9006,
9008,
8990,
8991,
9010,
9013,
9062,
9060,
9058,
9061,
9059,
9016,
9015,
]

_charnames_72960 = [
8893,
8896,
8917,
8918,
8909,
8910,
8934,
-1,
8895,
8931,
-1,
8894,
8904,
8903,
8921,
8920,
8885,
8924,
8923,
8908,
8907,
8883,
8878,
8877,
8890,
8889,
8884,
8881,
8880,
8892,
8891,
8886,
8913,
8912,
8927,
8926,
8932,
8928,
8930,
8916,
8929,
8899,
8898,
8900,
8933,
8915,
8902,
8906,
8879,
8940,
8943,
8944,
8941,
8942,
8945,
-1,
-1,
-1,
8947,
-1,
8939,
8946,
-1,
8938,
8968,
8964,
8965,
8967,
8966,
8948,
8970,
8971,
]

_charnames_73040 = [
8959,
8960,
8951,
8952,
8957,
8958,
8954,
8955,
8962,
8961,
-1,
-1,
-1,
-1,
-1,
-1,
22167,
22170,
22188,
22189,
22171,
22172,
-1,
22206,
22169,
-1,
22203,
22168,
22199,
22200,
22198,
22197,
22204,
22184,
22183,
22160,
22159,
22181,
22192,
22191,
22166,
22165,
22178,
22195,
22194,
22158,
22157,
22180,
22187,
22186,
22164,
22163,
22177,
22175,
22174,
22205,
22202,
22201,
22212,
22215,
22216,
22213,
22214,
-1,
22218,
22211,
-1,
22217,
22210,
22236,
22235,
22219,
22237,
]

_charnames_73120 = [
22230,
22231,
22222,
22223,
22228,
22229,
22225,
22226,
22233,
22232,
]

_charnames_73440 = [
9139,
9141,
9129,
9136,
9144,
9137,
9133,
9142,
9130,
9143,
9140,
9128,
9131,
9135,
9138,
9132,
9134,
9145,
9153,
9149,
9147,
9150,
9148,
9151,
9152,
]

_charnames_73728 = [
1019,
1081,
1080,
1079,
1078,
1077,
1076,
1075,
1074,
1105,
1020,
1038,
1037,
1033,
1032,
1036,
1030,
1029,
1035,
1025,
1034,
1039,
1040,
1046,
1045,
1044,
1043,
1042,
1102,
1098,
1101,
1100,
1048,
1058,
1057,
1056,
1055,
1052,
1051,
1054,
1053,
1060,
1059,
1094,
1096,
1082,
1088,
1087,
1086,
1085,
1089,
1104,
1091,
1092,
1093,
1072,
1062,
1068,
1069,
1067,
1065,
1066,
1071,
1070,
1264,
1275,
1277,
1265,
1270,
1272,
1271,
1273,
1274,
1289,
1293,
1292,
1291,
1278,
1283,
1281,
1284,
1287,
1288,
1285,
1286,
756,
757,
783,
782,
780,
779,
763,
764,
761,
762,
765,
789,
776,
777,
788,
770,
767,
769,
768,
787,
786,
785,
784,
774,
775,
796,
792,
795,
794,
798,
810,
799,
802,
804,
808,
809,
806,
698,
752,
753,
751,
745,
748,
749,
699,
739,
755,
740,
741,
742,
743,
744,
754,
1106,
1172,
1173,
1145,
1155,
1154,
1152,
1149,
1148,
1150,
1176,
1175,
1174,
1156,
1159,
1160,
1161,
1164,
1163,
1162,
1168,
1166,
1169,
1107,
1115,
1116,
1117,
1118,
1135,
1131,
1132,
1129,
1130,
1133,
1120,
1121,
1122,
1111,
1112,
1114,
1113,
1125,
1124,
251,
375,
252,
273,
272,
271,
276,
274,
267,
269,
334,
332,
335,
336,
298,
294,
296,
293,
327,
328,
325,
326,
261,
257,
262,
263,
264,
265,
313,
310,
311,
316,
315,
351,
350,
307,
306,
303,
304,
302,
338,
348,
347,
322,
323,
354,
286,
285,
282,
283,
281,
287,
353,
342,
343,
344,
355,
365,
368,
371,
372,
362,
364,
363,
374,
356,
357,
359,
360,
361,
369,
370,
373,
436,
439,
376,
405,
404,
406,
398,
400,
401,
408,
385,
386,
378,
384,
383,
382,
381,
380,
397,
388,
396,
394,
392,
395,
409,
434,
410,
413,
414,
416,
415,
418,
419,
423,
422,
425,
433,
431,
432,
426,
430,
429,
428,
1317,
1319,
1321,
1322,
1295,
1297,
1298,
1306,
1305,
1304,
1303,
1302,
1301,
1300,
1307,
1308,
1314,
1313,
1312,
1311,
1310,
1316,
1323,
1349,
1348,
1341,
1344,
1343,
1331,
1332,
1337,
1334,
1335,
1336,
1338,
1340,
1339,
1324,
1326,
1329,
1328,
1327,
1330,
1347,
1346,
1345,
442,
486,
490,
491,
489,
497,
496,
495,
499,
523,
522,
451,
455,
454,
452,
453,
445,
450,
448,
449,
456,
457,
520,
519,
504,
501,
502,
508,
506,
479,
483,
482,
481,
484,
485,
517,
516,
513,
525,
466,
467,
465,
464,
463,
461,
469,
468,
511,
470,
476,
475,
474,
473,
524,
546,
547,
549,
532,
531,
530,
528,
529,
544,
545,
537,
539,
540,
543,
542,
533,
536,
535,
575,
562,
571,
569,
570,
573,
572,
567,
566,
564,
565,
550,
561,
560,
555,
556,
559,
553,
554,
558,
551,
552,
557,
574,
5,
101,
104,
108,
107,
106,
111,
110,
109,
167,
166,
171,
170,
138,
139,
136,
137,
162,
163,
164,
151,
147,
150,
149,
133,
134,
132,
130,
131,
145,
144,
142,
143,
158,
159,
160,
169,
126,
125,
124,
121,
122,
127,
155,
154,
156,
112,
115,
114,
118,
117,
116,
172,
173,
175,
176,
177,
178,
184,
182,
183,
179,
180,
181,
246,
249,
248,
247,
185,
245,
186,
224,
223,
201,
203,
221,
217,
220,
194,
192,
193,
195,
215,
214,
219,
212,
211,
199,
198,
206,
225,
232,
230,
229,
227,
244,
233,
236,
237,
238,
243,
242,
239,
240,
241,
1248,
1252,
1253,
1256,
1255,
1254,
1249,
1250,
1260,
1261,
1257,
1258,
1222,
1247,
1243,
1244,
1246,
1245,
1223,
1233,
1232,
1231,
1225,
1229,
1234,
1235,
1238,
1239,
1241,
1242,
1001,
1012,
1002,
1006,
1004,
1005,
1007,
1010,
1008,
1009,
1013,
1017,
1016,
1018,
924,
967,
966,
961,
964,
963,
926,
947,
945,
946,
941,
952,
950,
949,
933,
937,
935,
936,
931,
929,
965,
968,
996,
969,
991,
990,
987,
988,
989,
994,
995,
992,
993,
970,
982,
981,
980,
979,
978,
977,
976,
975,
974,
973,
983,
984,
1374,
1377,
1376,
1375,
1378,
1351,
1361,
1362,
1360,
1359,
1363,
1356,
1357,
1354,
1355,
1364,
1366,
1371,
1370,
1369,
1372,
1405,
1406,
1408,
1407,
641,
674,
642,
670,
662,
663,
668,
661,
660,
666,
665,
664,
655,
653,
658,
650,
649,
648,
647,
646,
673,
671,
675,
676,
678,
677,
603,
604,
613,
612,
611,
610,
609,
608,
606,
607,
614,
617,
616,
618,
628,
627,
626,
633,
632,
629,
631,
630,
597,
600,
599,
579,
592,
585,
584,
591,
590,
581,
582,
589,
588,
587,
586,
602,
593,
595,
596,
601,
634,
640,
635,
639,
688,
694,
689,
690,
691,
696,
695,
679,
687,
684,
685,
686,
682,
683,
680,
681,
1178,
1193,
1191,
1190,
1192,
1194,
1197,
1196,
1179,
1187,
1186,
1183,
1182,
1185,
1184,
1198,
1200,
1219,
1220,
1210,
1218,
1216,
1211,
1215,
1213,
1214,
1201,
1209,
1208,
1202,
1206,
1207,
811,
913,
912,
910,
909,
908,
922,
921,
885,
894,
891,
890,
888,
889,
895,
892,
893,
896,
873,
879,
876,
878,
877,
884,
880,
883,
882,
918,
919,
812,
871,
870,
850,
862,
861,
863,
865,
864,
854,
857,
856,
872,
867,
868,
813,
840,
841,
847,
838,
816,
819,
818,
817,
820,
846,
833,
832,
831,
845,
827,
844,
843,
836,
835,
842,
824,
823,
822,
848,
849,
897,
902,
899,
900,
901,
903,
905,
904,
920,
915,
916,
917,
1396,
1398,
1399,
1401,
1400,
1403,
1389,
1395,
1394,
1390,
1391,
1393,
1392,
1381,
1382,
1385,
1387,
1386,
548,
1026,
1047,
1097,
773,
791,
807,
747,
1134,
1128,
275,
268,
440,
407,
1315,
492,
488,
446,
458,
526,
507,
514,
462,
510,
472,
140,
228,
204,
200,
1262,
1240,
1011,
925,
960,
959,
942,
999,
1379,
1373,
667,
1217,
875,
911,
]

_charnames_74752 = [
1483,
1467,
1429,
1447,
1502,
1498,
1557,
1544,
1469,
1431,
1449,
1507,
1497,
1556,
1543,
1421,
1442,
1500,
1493,
1552,
1539,
1521,
1479,
1466,
1428,
1446,
1506,
1496,
1555,
1542,
1520,
1478,
1465,
1427,
1445,
1476,
1455,
1456,
1425,
1436,
1505,
1495,
1554,
1541,
1528,
1475,
1453,
1454,
1424,
1435,
1510,
1509,
1526,
1481,
1458,
1459,
1420,
1441,
1463,
1462,
1412,
1416,
1415,
1414,
1504,
1492,
1491,
1490,
1550,
1551,
1535,
1537,
1536,
1538,
1484,
1468,
1430,
1448,
1503,
1527,
1482,
1460,
1418,
1419,
1439,
1440,
1546,
1547,
1523,
1485,
1515,
1473,
1437,
1514,
1472,
1524,
1518,
1531,
1532,
1517,
1529,
1563,
1562,
1560,
1561,
1422,
1443,
1501,
1494,
1553,
1540,
-1,
1570,
1569,
1568,
1566,
1567,
]

_charnames_74880 = [
1027,
1024,
1103,
1276,
1269,
1268,
1267,
1282,
797,
790,
803,
801,
805,
725,
723,
724,
734,
733,
738,
717,
714,
716,
715,
731,
730,
737,
712,
711,
709,
710,
705,
703,
704,
706,
721,
720,
719,
736,
735,
728,
727,
1153,
1151,
1167,
1170,
1144,
1143,
1142,
1139,
1140,
1137,
1138,
1141,
1127,
333,
297,
292,
291,
329,
256,
260,
259,
314,
301,
339,
340,
341,
346,
318,
321,
320,
280,
352,
367,
438,
393,
417,
424,
1320,
1299,
498,
503,
477,
471,
168,
71,
66,
65,
70,
63,
62,
69,
68,
60,
59,
67,
98,
97,
82,
81,
76,
75,
74,
83,
79,
78,
88,
87,
86,
91,
90,
92,
46,
38,
45,
44,
42,
41,
43,
54,
53,
56,
55,
51,
50,
49,
48,
99,
35,
8,
21,
20,
19,
18,
17,
16,
15,
13,
12,
11,
34,
22,
33,
32,
27,
28,
31,
30,
29,
26,
25,
95,
94,
231,
222,
218,
208,
209,
207,
1259,
1228,
1227,
958,
943,
940,
957,
956,
955,
953,
954,
928,
932,
930,
672,
669,
654,
657,
615,
624,
623,
622,
621,
638,
637,
693,
1199,
1205,
1204,
866,
858,
839,
829,
828,
1402,
1388,
1384,
]

_charnames_77824 = [
13727,
13726,
13725,
13724,
13719,
13720,
13716,
13718,
13717,
13723,
13722,
13721,
13714,
13713,
13712,
13711,
13705,
13706,
13710,
13709,
13703,
13704,
13708,
13707,
13772,
13771,
13770,
13769,
13768,
13767,
13766,
13765,
13764,
13763,
13739,
13738,
13729,
13730,
13737,
13736,
13735,
13734,
13733,
13732,
13731,
13694,
13695,
13701,
13692,
13693,
13690,
13691,
13700,
13688,
13689,
13699,
13698,
13697,
13696,
13761,
13760,
13759,
13758,
13757,
13756,
13755,
13754,
13753,
13752,
13750,
13749,
13748,
13747,
13746,
13745,
13744,
13743,
13742,
13741,
13773,
14836,
14835,
14834,
14833,
14827,
14828,
14832,
14831,
14830,
14829,
14745,
14734,
14737,
14736,
14735,
14744,
14743,
14742,
14741,
14740,
14739,
14738,
14747,
14748,
14757,
14756,
14755,
14754,
14753,
14752,
14751,
14750,
14749,
14763,
14762,
14761,
14760,
14759,
14023,
14022,
14021,
14020,
14019,
14018,
14017,
14014,
14015,
14016,
14012,
14011,
14010,
14009,
14008,
14007,
14006,
14005,
14004,
14003,
14001,
14000,
13999,
13998,
13997,
13996,
13995,
13991,
13992,
13994,
13993,
13989,
13980,
13981,
13988,
13987,
13978,
13979,
13986,
13985,
13984,
13983,
13982,
13976,
13975,
13974,
13973,
13972,
13971,
13967,
13968,
13970,
13965,
13966,
13969,
13926,
13935,
13934,
13933,
13932,
13931,
13930,
13929,
13928,
13927,
13946,
13938,
13939,
13945,
13936,
13937,
13944,
13943,
13942,
13941,
13940,
13963,
13962,
13961,
13960,
13959,
13958,
13957,
13948,
13956,
13955,
13954,
13953,
13952,
13951,
13950,
13949,
14603,
14602,
14601,
14600,
14599,
14598,
14597,
14595,
14596,
14593,
14594,
14591,
14590,
14589,
14588,
14587,
14586,
14582,
14583,
14580,
14581,
14585,
14584,
14569,
14570,
14578,
14577,
14576,
14575,
14574,
14573,
14572,
14567,
14568,
14571,
14613,
14612,
14611,
14610,
14605,
14606,
14609,
14608,
14607,
14314,
14315,
14323,
14322,
14321,
14320,
14319,
14318,
14317,
14316,
14312,
14311,
14310,
14302,
14303,
14309,
14308,
14307,
14306,
14305,
14304,
14300,
14290,
14291,
14299,
14298,
14297,
14296,
14295,
14294,
14293,
14292,
14288,
14280,
14281,
14287,
14286,
14285,
14284,
14283,
14278,
14279,
14276,
14277,
14282,
14274,
14273,
14272,
14271,
14270,
14266,
14267,
14264,
14265,
14262,
14263,
14269,
14268,
14331,
14325,
14328,
14327,
14326,
14330,
14329,
14384,
14383,
14382,
14381,
14380,
14376,
14377,
14373,
14375,
14374,
14379,
14378,
14396,
14386,
14387,
14395,
14394,
14393,
14392,
14391,
14390,
14389,
14388,
14362,
14363,
14371,
14370,
14369,
14368,
14367,
14360,
14361,
14366,
14365,
14364,
14358,
14357,
14356,
14355,
14354,
14353,
14349,
14350,
14347,
14348,
14352,
14351,
14345,
14344,
14343,
14336,
14337,
14342,
14334,
14335,
14341,
14340,
14339,
14338,
14402,
14401,
14400,
14399,
14398,
14856,
14855,
14854,
14853,
14852,
14848,
14849,
14851,
14850,
14776,
14775,
14774,
14773,
14768,
14769,
14772,
14771,
14770,
14766,
14767,
14780,
14781,
14778,
14779,
14785,
14784,
14783,
14782,
14865,
14864,
14863,
14862,
14861,
14860,
14859,
14858,
14825,
14818,
14819,
14824,
14823,
14822,
14816,
14817,
14821,
14820,
14241,
14243,
14242,
14252,
14244,
14245,
14251,
14250,
14249,
14248,
14247,
14246,
14205,
14206,
14211,
14190,
14198,
14197,
14196,
14195,
14194,
14193,
14192,
14191,
14210,
14209,
14203,
14204,
14201,
14202,
14199,
14200,
14208,
14207,
14239,
14238,
14231,
14232,
14237,
14229,
14230,
14236,
14235,
14234,
14227,
14228,
14233,
14225,
14216,
14217,
14224,
14213,
14215,
14214,
14223,
14222,
14221,
14220,
14219,
14218,
14254,
14255,
14259,
14258,
14257,
14256,
13864,
13863,
13862,
13861,
13860,
13859,
13858,
13857,
13856,
13842,
13841,
13840,
13839,
13838,
13837,
13836,
13835,
13831,
13833,
13832,
13834,
13854,
13853,
13852,
13851,
13850,
13844,
13845,
13849,
13848,
13847,
13846,
13829,
13828,
13827,
13822,
13823,
13820,
13821,
13818,
13819,
13826,
13816,
13817,
13825,
13824,
13868,
13867,
13866,
13922,
13921,
13920,
13919,
13913,
13914,
13918,
13917,
13916,
13915,
13911,
13910,
13909,
13908,
13907,
13906,
13905,
13901,
13902,
13904,
13903,
13923,
13893,
13892,
13891,
13890,
13889,
13888,
13887,
13886,
13885,
13875,
13876,
13873,
13874,
13883,
13882,
13881,
13880,
13879,
13878,
13871,
13872,
13877,
13898,
13897,
13895,
13896,
14117,
14118,
14124,
14123,
14122,
14115,
14116,
14108,
14114,
14113,
14112,
14111,
14110,
14109,
14121,
14120,
14119,
14158,
14161,
14160,
14159,
14171,
14170,
14169,
14168,
14167,
14166,
14165,
14164,
14162,
14163,
14149,
14150,
14156,
14155,
14154,
14147,
14148,
14145,
14146,
14153,
14152,
14151,
14143,
14144,
14133,
14134,
14141,
14140,
14131,
14132,
14139,
14138,
14126,
14130,
14129,
14128,
14127,
14137,
14136,
14135,
14182,
14181,
14180,
14179,
14178,
14177,
14176,
14175,
14174,
14173,
14184,
14186,
14185,
14187,
14790,
14791,
14798,
14788,
14789,
14797,
14796,
14795,
14794,
14793,
14792,
14801,
14800,
14873,
14872,
14871,
14870,
14869,
14868,
14867,
14684,
14676,
14677,
14673,
14675,
14674,
14683,
14682,
14681,
14680,
14679,
14678,
14662,
14663,
14671,
14670,
14669,
14668,
14667,
14660,
14661,
14666,
14665,
14664,
14695,
14694,
14693,
14692,
14691,
14690,
14689,
14688,
14687,
14686,
14454,
14446,
14447,
14453,
14452,
14451,
14444,
14445,
14450,
14449,
14448,
14417,
14416,
14415,
14414,
14405,
14407,
14406,
14413,
14412,
14408,
14409,
14411,
14410,
14430,
14429,
14428,
14427,
14426,
14425,
14419,
14421,
14420,
14424,
14423,
14422,
14442,
14441,
14440,
14439,
14438,
14432,
14433,
14437,
14436,
14435,
14434,
14462,
14461,
14460,
14459,
14458,
14457,
14456,
14530,
14529,
14524,
14525,
14528,
14527,
14526,
14522,
14523,
14520,
14521,
14518,
14519,
14543,
14534,
14535,
14542,
14541,
14540,
14539,
14532,
14533,
14538,
14537,
14536,
14554,
14553,
14552,
14551,
14550,
14549,
14548,
14547,
14546,
14545,
14564,
14563,
14558,
14559,
14556,
14557,
14562,
14561,
14560,
14500,
14499,
14498,
14497,
14496,
14490,
14492,
14491,
14495,
14494,
14493,
14511,
14510,
14509,
14508,
14507,
14506,
14505,
14504,
14503,
14502,
14476,
14475,
14474,
14467,
14468,
14473,
14472,
14471,
14470,
14469,
14465,
14466,
14488,
14487,
14478,
14479,
14486,
14485,
14484,
14483,
14482,
14481,
14480,
14515,
14514,
14513,
14052,
14061,
14060,
14059,
14058,
14057,
14056,
14055,
14054,
14053,
14065,
14066,
14072,
14071,
14070,
14069,
14062,
14064,
14063,
14068,
14067,
14088,
14074,
14077,
14076,
14075,
14078,
14080,
14079,
14087,
14086,
14085,
14084,
14083,
14082,
14081,
14026,
14038,
14037,
14036,
14035,
14034,
14033,
14032,
14031,
14030,
14029,
14028,
14027,
14050,
14049,
14043,
14044,
14048,
14047,
14046,
14045,
14041,
14042,
14039,
14040,
14096,
14097,
14094,
14095,
14103,
14092,
14093,
14102,
14101,
14100,
14090,
14091,
14099,
14098,
14104,
14105,
14723,
14722,
14715,
14716,
14721,
14720,
14719,
14718,
14717,
14713,
14714,
14704,
14705,
14711,
14710,
14709,
14702,
14703,
14708,
14707,
14700,
14701,
14698,
14699,
14706,
14731,
14730,
14729,
14728,
14725,
14726,
14727,
14814,
14813,
14812,
14803,
14805,
14804,
14811,
14808,
14809,
14810,
14806,
14807,
14838,
14839,
14846,
14845,
14844,
14843,
14842,
14841,
14840,
14657,
14641,
14645,
14644,
14643,
14642,
14646,
14648,
14647,
14651,
14652,
14649,
14650,
14656,
14655,
14654,
14653,
14639,
14638,
14637,
14636,
14635,
14616,
14625,
14624,
14623,
14622,
14621,
14620,
14619,
14618,
14617,
14626,
14634,
14633,
14632,
14631,
14630,
14629,
14628,
14627,
13786,
13785,
13784,
13783,
13782,
13781,
13776,
13778,
13777,
13780,
13779,
13808,
13807,
13806,
13805,
13804,
13803,
13802,
13801,
13800,
13799,
13797,
13796,
13795,
13794,
13793,
13792,
13791,
13790,
13789,
13788,
13812,
13811,
13810,
]

_charnames_82944 = [
12478,
12477,
12476,
12475,
12474,
12473,
12472,
12471,
12470,
12425,
12426,
12435,
12434,
12433,
12432,
12431,
12430,
12429,
12428,
12427,
12423,
12422,
12421,
12420,
12419,
12418,
12413,
12414,
12417,
12416,
12415,
12411,
12410,
12409,
12408,
12407,
12406,
12405,
12404,
12403,
12401,
12402,
12372,
12364,
12365,
12371,
12370,
12369,
12362,
12363,
12359,
12361,
12360,
12368,
12367,
12366,
12468,
12467,
12466,
12465,
12464,
12463,
12462,
12461,
12460,
12459,
12386,
12385,
12384,
12383,
12382,
12381,
12374,
12377,
12376,
12375,
12380,
12379,
12378,
12457,
12456,
12455,
12454,
12453,
12452,
12451,
12450,
12449,
12448,
12446,
12445,
12444,
12443,
12442,
12441,
12440,
12439,
12438,
12437,
12399,
12398,
12397,
12396,
12395,
12394,
12393,
12390,
12391,
12388,
12389,
12392,
11998,
11999,
11996,
11997,
11994,
11995,
12003,
11987,
11990,
11989,
11988,
11991,
11993,
11992,
12002,
11983,
11986,
11985,
11984,
12001,
12000,
12005,
12007,
12006,
12017,
12016,
12015,
12014,
12008,
12009,
12013,
12012,
12011,
12010,
12041,
12040,
12039,
12038,
12037,
12031,
12032,
12036,
12035,
12034,
12033,
12029,
12028,
12027,
12026,
12025,
12019,
12020,
12024,
12023,
12022,
12021,
12107,
12106,
12105,
12104,
12103,
12102,
12101,
12100,
12099,
12098,
12096,
12095,
12094,
12093,
12092,
12091,
12090,
12089,
12088,
12087,
12085,
12084,
12083,
12082,
12081,
12080,
12079,
12078,
12077,
12076,
12074,
12073,
12072,
12071,
12070,
12069,
12068,
12067,
12066,
12065,
12063,
12062,
12061,
12060,
12059,
12058,
12057,
12056,
12055,
12054,
12052,
12051,
12050,
12049,
12048,
12047,
12046,
12045,
12044,
12043,
12250,
12249,
12237,
12239,
12238,
12248,
12247,
12246,
12245,
12242,
12243,
12244,
12240,
12241,
12276,
12275,
12274,
12273,
12272,
12267,
12268,
12265,
12266,
12271,
12270,
12269,
12312,
12311,
12310,
12309,
12308,
12307,
12306,
12302,
12303,
12305,
12304,
12356,
12355,
12354,
12353,
12352,
12351,
12350,
12349,
12348,
12347,
12345,
12344,
12343,
12342,
12341,
12340,
12339,
12338,
12337,
12336,
12334,
12333,
12332,
12331,
12330,
12329,
12328,
12327,
12326,
12325,
12300,
12299,
12298,
12297,
12296,
12295,
12294,
12290,
12291,
12293,
12292,
12323,
12322,
12321,
12320,
12319,
12318,
12317,
12316,
12315,
12314,
12288,
12287,
12286,
12285,
12284,
12283,
12282,
12281,
12280,
12278,
12279,
12263,
12262,
12261,
12260,
12254,
12255,
12259,
12258,
12257,
12256,
12252,
12253,
12201,
12200,
12199,
12198,
12197,
12196,
12195,
12194,
12193,
12191,
12192,
12234,
12233,
12232,
12231,
12230,
12229,
12228,
12227,
12226,
12225,
12189,
12188,
12187,
12186,
12185,
12184,
12183,
12182,
12181,
12179,
12180,
12125,
12124,
12117,
12116,
12115,
12123,
12122,
12121,
12110,
12113,
12112,
12111,
12120,
12119,
12118,
12223,
12222,
12221,
12220,
12219,
12218,
12217,
12216,
12215,
12214,
12177,
12176,
12175,
12174,
12173,
12172,
12171,
12170,
12169,
12167,
12168,
12153,
12152,
12151,
12150,
12144,
12145,
12149,
12148,
12147,
12142,
12143,
12146,
12165,
12155,
12156,
12164,
12163,
12162,
12161,
12160,
12159,
12158,
12157,
12140,
12132,
12133,
12139,
12131,
12130,
12138,
12137,
12127,
12128,
12136,
12135,
12134,
12212,
12211,
12210,
12209,
12208,
12207,
12206,
12205,
12204,
12203,
12582,
12581,
12580,
12579,
12578,
12577,
12576,
12575,
12574,
12573,
12496,
12495,
12505,
12504,
12503,
12502,
12501,
12500,
12499,
12498,
12497,
12571,
12570,
12569,
12568,
12567,
12566,
12565,
12564,
12563,
12562,
12560,
12559,
12558,
12557,
12556,
12555,
12554,
12553,
12552,
12551,
12549,
12548,
12547,
12546,
12545,
12544,
12543,
12542,
12541,
12540,
12483,
12484,
12492,
12491,
12490,
12489,
12488,
12487,
12481,
12482,
12486,
12485,
12538,
12537,
12536,
12535,
12534,
12533,
12532,
12531,
12530,
12529,
12527,
12526,
12525,
12524,
12523,
12522,
12521,
12520,
12519,
12518,
12516,
12515,
12514,
12513,
12512,
12511,
12510,
12509,
12508,
12507,
12591,
12590,
12589,
12588,
12587,
12586,
12585,
12584,
12624,
12623,
12622,
12621,
12620,
12619,
12618,
12617,
12616,
12614,
12613,
12612,
12611,
12610,
12609,
12608,
12607,
12606,
12605,
12603,
12602,
12601,
12600,
12599,
12598,
12597,
12596,
12595,
12594,
12625,
]

_charnames_92160 = [
15775,
15883,
15852,
15853,
15796,
15827,
15872,
15784,
15830,
15849,
15850,
15806,
15868,
15777,
15804,
15811,
15820,
15838,
15771,
15858,
15789,
15836,
15774,
15878,
15877,
15770,
15809,
15844,
15881,
15845,
15816,
15783,
15886,
15882,
15769,
15837,
15821,
15822,
15814,
15862,
15846,
15793,
15855,
15805,
15798,
15854,
15867,
15875,
15835,
15870,
15808,
15859,
15792,
15863,
15815,
15826,
15876,
15889,
15888,
15864,
15834,
15810,
15829,
15767,
15831,
15780,
15842,
15790,
15885,
15776,
15807,
15797,
15819,
15781,
15871,
15833,
15843,
15786,
15803,
15779,
15861,
15787,
15887,
15874,
15799,
15795,
15818,
15923,
15958,
15932,
15933,
15953,
15895,
15942,
15961,
15894,
15943,
15947,
15962,
15951,
15925,
15926,
15964,
15946,
15957,
15930,
15929,
15904,
15897,
15920,
15938,
15965,
15937,
15952,
15948,
15970,
15918,
15915,
15969,
15934,
15959,
15908,
15913,
15914,
15905,
15931,
15898,
15909,
15921,
15945,
15907,
15967,
15896,
15968,
15939,
15902,
15901,
15954,
15916,
15924,
15899,
15941,
15917,
15628,
15665,
15719,
15757,
15626,
15643,
15629,
15752,
15677,
15754,
15669,
15661,
15675,
15747,
15647,
15684,
15703,
15753,
15706,
15720,
15664,
15687,
15638,
15679,
15721,
15714,
15715,
15736,
15648,
15730,
15656,
15726,
15738,
15625,
15759,
15668,
15695,
15662,
15622,
15741,
15680,
15698,
15659,
15728,
15623,
15762,
15642,
15639,
15637,
15763,
15760,
15676,
15761,
15655,
15742,
15725,
15634,
15652,
15710,
15621,
15691,
15688,
15743,
15712,
15654,
15630,
15756,
15624,
15636,
15660,
15713,
15635,
15646,
15694,
15722,
15645,
15733,
15737,
15678,
15692,
15685,
15704,
15674,
15705,
15683,
15718,
15651,
15697,
15696,
15734,
15708,
15709,
15631,
15667,
15744,
15748,
15749,
15729,
15523,
15610,
15470,
15506,
15471,
15584,
15473,
15483,
15464,
15489,
15609,
15458,
15536,
15460,
15555,
15566,
15535,
15476,
15542,
15556,
15601,
15559,
15546,
15508,
15492,
15525,
15517,
15548,
15600,
15474,
15553,
15455,
15570,
15613,
15457,
15615,
15493,
15512,
15579,
15494,
15529,
15514,
15587,
15513,
15505,
15582,
15480,
15521,
15562,
15488,
15568,
15547,
15599,
15554,
15607,
15569,
15456,
15509,
15479,
15552,
15592,
15590,
15486,
15580,
15463,
15510,
15466,
15598,
15593,
15597,
15495,
15498,
15543,
15560,
15468,
15459,
15571,
15518,
15558,
15484,
15567,
15526,
15465,
15578,
15467,
15482,
15475,
15612,
15557,
15604,
15574,
15572,
15487,
15606,
15581,
15519,
15503,
15541,
15528,
15539,
15534,
15561,
15501,
15537,
15499,
15591,
15502,
15538,
15588,
15527,
15583,
15605,
15573,
15500,
15522,
15545,
15616,
15260,
15344,
15324,
15389,
15446,
15384,
15296,
15378,
15433,
15273,
15264,
15292,
15336,
15237,
15403,
15439,
15376,
15246,
15297,
15343,
15396,
15386,
15275,
15252,
15315,
15235,
15251,
15274,
15435,
15269,
15309,
15379,
15241,
15322,
15422,
15236,
15270,
15317,
15383,
15247,
15262,
15337,
15375,
15293,
15258,
15243,
15366,
15423,
15341,
15357,
15310,
15340,
15401,
15377,
15348,
15444,
15441,
15390,
15289,
15334,
15427,
15253,
15373,
15321,
15325,
15278,
15287,
15430,
15339,
15397,
15367,
15280,
15365,
15329,
15263,
15304,
15354,
15392,
15412,
15429,
15232,
15402,
15314,
15238,
15425,
15414,
15283,
15308,
15360,
15245,
15281,
15277,
15311,
15319,
15413,
15286,
15327,
15424,
15410,
15326,
15291,
15233,
15395,
15303,
15284,
15358,
15242,
15300,
15411,
15416,
15267,
15449,
15345,
15447,
15448,
15388,
15299,
15333,
15335,
15259,
15372,
15359,
15248,
15355,
15362,
15363,
15352,
15353,
15400,
15307,
15268,
15294,
15440,
15417,
15445,
15391,
15318,
15436,
15434,
15249,
15254,
15370,
15371,
15409,
15285,
15301,
15385,
15404,
15330,
15313,
15316,
15347,
15405,
15328,
15349,
15415,
15426,
16003,
16041,
16000,
16043,
16008,
16022,
15981,
16033,
16010,
16011,
16018,
16023,
15985,
15977,
16013,
15991,
15990,
15992,
15993,
15999,
15997,
15974,
15973,
15976,
16035,
15988,
16036,
15983,
16027,
15982,
16038,
16028,
16012,
15984,
16006,
15998,
15979,
15980,
15989,
16029,
16042,
16039,
16032,
16031,
16002,
16015,
16007,
16019,
16017,
16016,
16024,
16001,
15994,
16040,
]

_charnames_92736 = [
10077,
10093,
10106,
10095,
10110,
10104,
10111,
10089,
10083,
10100,
10105,
10109,
10084,
10080,
10096,
10092,
10090,
10079,
10078,
10086,
10108,
10075,
10103,
10107,
10102,
10082,
10098,
10097,
10101,
10087,
10076,
-1,
10123,
10124,
10115,
10116,
10121,
10122,
10118,
10119,
10126,
10125,
-1,
-1,
-1,
-1,
10128,
10127,
]

_charnames_92880 = [
16410,
16423,
16433,
16439,
16435,
16413,
16426,
16429,
16422,
16436,
16438,
16415,
16430,
16425,
16428,
16440,
16418,
16432,
16441,
16431,
16414,
16434,
16416,
16442,
16419,
16420,
16417,
16411,
16409,
16437,
-1,
-1,
16449,
16446,
16450,
16445,
16448,
16451,
]

_charnames_92928 = [
20066,
20065,
20062,
20061,
20036,
20035,
20050,
20049,
20068,
20067,
20039,
20038,
20054,
20053,
20033,
20032,
20048,
20047,
20056,
20055,
20060,
20059,
20044,
20043,
20071,
20070,
20042,
20041,
19944,
19929,
19949,
19938,
19931,
19945,
19932,
19946,
19942,
19937,
19948,
19940,
19933,
19936,
19947,
19930,
19934,
19950,
19943,
19941,
20100,
20104,
20107,
20106,
20103,
20108,
20101,
20003,
20005,
19986,
20004,
20009,
19995,
19994,
19993,
19996,
20006,
20017,
20007,
20027,
19999,
19983,
]

_charnames_93008 = [
20082,
20083,
20074,
20075,
20080,
20081,
20077,
20078,
20085,
20084,
-1,
20092,
20095,
20090,
20097,
20096,
20091,
20093,
-1,
20008,
19997,
20024,
20012,
20025,
20023,
20021,
19998,
20020,
20028,
20011,
20016,
20013,
20026,
20018,
19989,
19985,
19981,
19982,
19987,
19988,
-1,
-1,
-1,
-1,
-1,
19955,
19963,
19969,
19970,
19974,
19960,
19972,
19976,
19957,
19956,
19975,
19961,
19973,
19967,
19977,
19964,
19954,
19959,
19966,
]

_charnames_93760 = [
8431,
8427,
8424,
8423,
8411,
8421,
8418,
8430,
8426,
8435,
8436,
8434,
8417,
8410,
8433,
8437,
8440,
8439,
8425,
8414,
8432,
8429,
8420,
8408,
8422,
8438,
8416,
8407,
8428,
8415,
8412,
8413,
8394,
8390,
8387,
8386,
8374,
8384,
8381,
8393,
8389,
8398,
8399,
8397,
8380,
8373,
8396,
8400,
8403,
8402,
8388,
8377,
8395,
8392,
8383,
8371,
8385,
8401,
8379,
8370,
8391,
8378,
8375,
8376,
8456,
8451,
8444,
8446,
8454,
8455,
8449,
8450,
8458,
8457,
8463,
8471,
8461,
8462,
8468,
8469,
8465,
8466,
8472,
8473,
8452,
8445,
8447,
8441,
8474,
8404,
8475,
]

_charnames_93952 = [
9910,
9921,
9856,
9909,
9913,
9912,
9885,
9920,
9904,
9903,
9823,
9878,
9854,
9855,
9822,
9877,
9834,
9836,
9857,
9883,
9830,
9829,
9892,
9891,
9890,
9889,
9821,
9876,
9820,
9875,
9919,
9901,
9858,
9907,
9906,
9833,
9832,
9882,
9916,
9917,
9900,
9899,
9816,
9871,
9827,
9826,
9817,
9872,
9852,
9859,
9868,
9895,
9894,
9847,
9845,
9818,
9873,
9853,
9896,
9848,
9846,
9843,
9841,
9884,
9842,
9840,
9918,
9886,
9915,
]

_charnames_94032 = [
9835,
9975,
9973,
9974,
9932,
9940,
9939,
9933,
9934,
9954,
9956,
9961,
9960,
9948,
9951,
9952,
9957,
9923,
9924,
9925,
9926,
9928,
9931,
9930,
9927,
9929,
9941,
9942,
9943,
9944,
9945,
9947,
9946,
9958,
9959,
9935,
9936,
9950,
9963,
9949,
9962,
9938,
9953,
9937,
9955,
9964,
9965,
]

_charnames_94095 = [
9968,
9967,
9970,
9969,
9814,
9813,
9812,
9811,
9810,
9809,
9808,
9867,
9866,
9865,
9864,
9863,
9862,
]

_charnames_100352 = [
4165,
4164,
4163,
4162,
4161,
4160,
4159,
4158,
4157,
4155,
4154,
4153,
4152,
4151,
4150,
4149,
4148,
4147,
4146,
4144,
4143,
4142,
4141,
4140,
4139,
4138,
4137,
4136,
4135,
4133,
4132,
4131,
4130,
4129,
4128,
4127,
4126,
4125,
4124,
4122,
4121,
4120,
4119,
4118,
4117,
4116,
4115,
4114,
4113,
4111,
4110,
4109,
4108,
4107,
4106,
4105,
4104,
4103,
4102,
4100,
4099,
4098,
4097,
4096,
4095,
4094,
4093,
4092,
4091,
4089,
4088,
4087,
4086,
4085,
4084,
4083,
4082,
4081,
4080,
4078,
4077,
4076,
4075,
4074,
4073,
4072,
4071,
4070,
4069,
4067,
4066,
4065,
4064,
4063,
4062,
4061,
4060,
4059,
4058,
4055,
4054,
4053,
4052,
4051,
4050,
4049,
4048,
4047,
4046,
4044,
4043,
4042,
4041,
4040,
4039,
4038,
4037,
4036,
4035,
4033,
4032,
4031,
4030,
4029,
4028,
4027,
4026,
4025,
4024,
4022,
4021,
4020,
4019,
4018,
4017,
4016,
4015,
4014,
4013,
4011,
4010,
4009,
4008,
4007,
4006,
4005,
4004,
4003,
4002,
4000,
3999,
3998,
3997,
3996,
3995,
3994,
3993,
3992,
3991,
3989,
3988,
3987,
3986,
3985,
3984,
3983,
3982,
3981,
3980,
3978,
3977,
3976,
3975,
3974,
3973,
3972,
3971,
3970,
3969,
3967,
3966,
3965,
3964,
3963,
3962,
3961,
3960,
3959,
3958,
3956,
3955,
3954,
3953,
3952,
3951,
3950,
3949,
3948,
3947,
3944,
3943,
3942,
3941,
3940,
3939,
3938,
3937,
3936,
3935,
3933,
3932,
3931,
3930,
3929,
3928,
3927,
3926,
3925,
3924,
3922,
3921,
3920,
3919,
3918,
3917,
3916,
3915,
3914,
3913,
3911,
3910,
3909,
3908,
3907,
3906,
3905,
3904,
3903,
3902,
3900,
3899,
3898,
3897,
3896,
3895,
3894,
3893,
3892,
3891,
3889,
3888,
3887,
3886,
3885,
3884,
3883,
3882,
3881,
3880,
3878,
3877,
3876,
3875,
3874,
3873,
3872,
3871,
3870,
3869,
3867,
3866,
3865,
3864,
3863,
3862,
3861,
3860,
3859,
3858,
3856,
3855,
3854,
3853,
3852,
3851,
3850,
3849,
3848,
3847,
3845,
3844,
3843,
3842,
3841,
3840,
3839,
3838,
3837,
3836,
3833,
3832,
3831,
3830,
3829,
3828,
3827,
3826,
3825,
3824,
3822,
3821,
3820,
3819,
3818,
3817,
3816,
3815,
3814,
3813,
3811,
3810,
3809,
3808,
3807,
3806,
3805,
3804,
3803,
3802,
3800,
3799,
3798,
3797,
3796,
3795,
3794,
3793,
3792,
3791,
3789,
3788,
3787,
3786,
3785,
3784,
3783,
3782,
3781,
3780,
3778,
3777,
3776,
3775,
3774,
3773,
3772,
3771,
3770,
3769,
3767,
3766,
3765,
3764,
3763,
3762,
3761,
3760,
3759,
3758,
3756,
3755,
3754,
3753,
3752,
3751,
3750,
3749,
3748,
3747,
3745,
3744,
3743,
3742,
3741,
3740,
3739,
3738,
3737,
3736,
3734,
3733,
3732,
3731,
3730,
3729,
3728,
3727,
3726,
3725,
3722,
3721,
3720,
3719,
3718,
3717,
3716,
3715,
3714,
3713,
3711,
3710,
3709,
3708,
3707,
3706,
3705,
3704,
3703,
3702,
3700,
3699,
3698,
3697,
3696,
3695,
3694,
3693,
3692,
3691,
3689,
3688,
3687,
3686,
3685,
3684,
3683,
3682,
3681,
3680,
3678,
3677,
3676,
3675,
3674,
3673,
3672,
3671,
3670,
3669,
3667,
3666,
3665,
3664,
3663,
3662,
3661,
3660,
3659,
3658,
3656,
3655,
3654,
3653,
3652,
3651,
3650,
3649,
3648,
3647,
3645,
3644,
3643,
3642,
3641,
3640,
3639,
3638,
3637,
3636,
3634,
3633,
3632,
3631,
3630,
3629,
3628,
3627,
3626,
3625,
3623,
3622,
3621,
3620,
3619,
3618,
3617,
3616,
3615,
3614,
3611,
3610,
3609,
3608,
3607,
3606,
3605,
3604,
3603,
3602,
3600,
3599,
3598,
3597,
3596,
3595,
3594,
3593,
3592,
3591,
3589,
3588,
3587,
3586,
3585,
3584,
3583,
3582,
3581,
3580,
3578,
3577,
3576,
3575,
3574,
3573,
3572,
3571,
3570,
3569,
3567,
3566,
3565,
3564,
3563,
3562,
3561,
3560,
3559,
3558,
3556,
3555,
3554,
3553,
3552,
3551,
3550,
3549,
3548,
3547,
3545,
3544,
3543,
3542,
3541,
3540,
3539,
3538,
3537,
3536,
3534,
3533,
3532,
3531,
3530,
3529,
3528,
3527,
3526,
3525,
3523,
3522,
3521,
3520,
3519,
3518,
3517,
3516,
3515,
3514,
3512,
3511,
3510,
3509,
3508,
3507,
3506,
3505,
3504,
3503,
3500,
3499,
3498,
3497,
3496,
3495,
3494,
3493,
3492,
3491,
3489,
3488,
3487,
3486,
3485,
3484,
3483,
3482,
3481,
3480,
3478,
3477,
3476,
3475,
3474,
3473,
3472,
3471,
3470,
3469,
3467,
3466,
3465,
3464,
3463,
3462,
3461,
3460,
3459,
3458,
3456,
3455,
3454,
3453,
3452,
3451,
3450,
3449,
3448,
3447,
3445,
3444,
3443,
3442,
3441,
3440,
3439,
3438,
3437,
3436,
3434,
3433,
3432,
3431,
3430,
3429,
3428,
3427,
3426,
3425,
3423,
3422,
3421,
3420,
3419,
3418,
3417,
3416,
3415,
3414,
3412,
3411,
3410,
3409,
3408,
3407,
3406,
3405,
3404,
3403,
3401,
3400,
3399,
3398,
3397,
3396,
3395,
3394,
3393,
3392,
4221,
4220,
4219,
4218,
4217,
4216,
4215,
4214,
4213,
4212,
4210,
4209,
4208,
4207,
4206,
4205,
4204,
4203,
4202,
4201,
4199,
4198,
4197,
4196,
4195,
4194,
4193,
4192,
4191,
4190,
4188,
4187,
4186,
4185,
4184,
4183,
4182,
4181,
4180,
4179,
4177,
4176,
4175,
4174,
4173,
4172,
4171,
4170,
4169,
4168,
4228,
4227,
4226,
4225,
4224,
4223,
]

_charnames_110592 = [
23507,
19895,
19346,
19345,
19344,
19343,
19341,
19340,
19339,
19338,
19336,
19335,
19334,
19333,
19332,
19329,
19328,
19327,
19326,
19325,
19350,
19349,
19348,
19010,
19021,
19020,
19019,
19018,
19017,
19016,
19015,
19014,
19012,
19011,
19013,
19030,
19029,
19028,
19027,
19026,
19025,
19024,
19023,
19038,
19037,
19036,
19035,
19034,
19033,
19032,
19045,
19044,
19043,
19042,
19041,
19040,
19050,
19049,
19048,
19047,
19111,
19110,
19109,
19108,
19107,
19106,
19105,
19104,
19126,
19125,
19124,
19123,
19122,
19121,
19102,
19101,
19100,
19099,
19098,
19097,
19096,
19095,
19132,
19131,
19130,
19129,
19128,
19119,
19118,
19117,
19116,
19115,
19114,
19113,
19211,
19210,
19209,
19208,
19200,
19199,
19198,
19197,
19196,
19195,
19194,
19206,
19205,
19204,
19203,
19202,
19184,
19183,
19182,
19181,
19180,
19179,
19178,
19177,
19176,
19192,
19191,
19190,
19189,
19188,
19187,
19186,
19143,
19142,
19141,
19140,
19139,
19138,
19137,
19136,
19135,
19152,
19151,
19150,
19149,
19148,
19147,
19146,
19145,
19170,
19169,
19168,
19160,
19159,
19158,
19157,
19156,
19155,
19154,
19166,
19165,
19164,
19163,
19162,
19053,
19063,
19062,
19061,
19060,
19059,
19058,
19057,
19056,
19055,
19054,
19080,
19079,
19078,
19077,
19076,
19075,
19074,
19092,
19091,
19090,
19088,
19087,
19086,
19085,
19084,
19083,
19082,
19072,
19071,
19070,
19069,
19068,
19067,
19066,
19065,
19261,
19260,
19259,
19258,
19257,
19256,
19255,
19253,
19252,
19251,
19250,
19249,
19248,
19247,
19273,
19272,
19271,
19270,
19277,
19276,
19275,
19268,
19267,
19266,
19265,
19264,
19263,
19318,
19317,
19316,
19315,
19314,
19313,
19323,
19322,
19321,
19320,
19311,
19310,
19309,
19308,
19307,
19306,
19244,
19243,
19242,
19241,
19220,
19219,
19218,
19217,
19216,
19215,
19214,
19227,
19226,
19225,
19224,
19223,
19222,
19239,
19238,
19237,
19236,
19234,
19233,
19232,
19231,
19230,
19229,
19298,
19297,
19296,
19295,
19294,
19292,
19291,
19290,
19289,
19288,
19303,
19302,
19301,
19300,
19286,
19285,
19284,
19283,
19282,
19281,
19280,
19173,
19172,
]

_charnames_110960 = [
18471,
18470,
18469,
18468,
18467,
18466,
18465,
18464,
18463,
18462,
18461,
18460,
18459,
18458,
18457,
18456,
18454,
18453,
18452,
18451,
18450,
18449,
18448,
18447,
18446,
18445,
18444,
18443,
18442,
18441,
18440,
18439,
18437,
18436,
18435,
18434,
18433,
18432,
18431,
18430,
18429,
18428,
18427,
18426,
18425,
18424,
18423,
18422,
18420,
18419,
18418,
18417,
18416,
18415,
18414,
18413,
18412,
18411,
18410,
18409,
18408,
18407,
18406,
18405,
18403,
18402,
18401,
18400,
18399,
18398,
18397,
18396,
18395,
18394,
18393,
18392,
18391,
18390,
18389,
18388,
18386,
18385,
18384,
18383,
18382,
18381,
18380,
18379,
18378,
18377,
18376,
18375,
18374,
18373,
18372,
18371,
18369,
18368,
18367,
18366,
18365,
18364,
18363,
18362,
18361,
18360,
18359,
18358,
18357,
18356,
18355,
18354,
18352,
18351,
18350,
18349,
18348,
18347,
18346,
18345,
18344,
18343,
18342,
18341,
18340,
18339,
18338,
18337,
18335,
18334,
18333,
18332,
18331,
18330,
18329,
18328,
18327,
18326,
18325,
18324,
18323,
18322,
18321,
18320,
18304,
18303,
18302,
18301,
18300,
18299,
18298,
18297,
18296,
18295,
18294,
18293,
18292,
18291,
18290,
18289,
18287,
18286,
18285,
18284,
18283,
18282,
18281,
18280,
18279,
18278,
18277,
18276,
18275,
18274,
18273,
18272,
18270,
18269,
18268,
18267,
18266,
18265,
18264,
18263,
18262,
18261,
18260,
18259,
18258,
18257,
18256,
18255,
18253,
18252,
18251,
18250,
18249,
18248,
18247,
18246,
18245,
18244,
18243,
18242,
18241,
18240,
18239,
18238,
18236,
18235,
18234,
18233,
18232,
18231,
18230,
18229,
18228,
18227,
18226,
18225,
18224,
18223,
18222,
18221,
18219,
18218,
18217,
18216,
18215,
18214,
18213,
18212,
18211,
18210,
18209,
18208,
18207,
18206,
18205,
18204,
18202,
18201,
18200,
18199,
18198,
18197,
18196,
18195,
18194,
18193,
18192,
18191,
18190,
18189,
18188,
18187,
18185,
18184,
18183,
18182,
18181,
18180,
18179,
18178,
18177,
18176,
18175,
18174,
18173,
18172,
18171,
18170,
18168,
18167,
18166,
18165,
18164,
18163,
18162,
18161,
18160,
18159,
18158,
18157,
18156,
18155,
18154,
18153,
18151,
18150,
18149,
18148,
18147,
18146,
18145,
18144,
18143,
18142,
18141,
18140,
18139,
18138,
18137,
18136,
18134,
18133,
18132,
18131,
18130,
18129,
18128,
18127,
18126,
18125,
18124,
18123,
18122,
18121,
18120,
18119,
18117,
18116,
18115,
18114,
18113,
18112,
18111,
18110,
18109,
18108,
18107,
18106,
18105,
18104,
18103,
18102,
18100,
18099,
18098,
18097,
18096,
18095,
18094,
18093,
18092,
18091,
18090,
18089,
18088,
18087,
18086,
18085,
18083,
18082,
18081,
18080,
18079,
18078,
18077,
18076,
18075,
18074,
18073,
18072,
18071,
18070,
18069,
18068,
18066,
18065,
18064,
18063,
18062,
18061,
18060,
18059,
18058,
18057,
18056,
18055,
18054,
18053,
18052,
18051,
18317,
18316,
18315,
18314,
18313,
18312,
18311,
18310,
18309,
18308,
18307,
18306,
]

_charnames_113664 = [
22686,
22680,
22659,
22654,
22690,
22669,
22664,
22695,
22677,
22682,
22688,
22633,
22663,
22679,
22691,
22672,
22638,
22658,
22601,
22678,
22673,
22600,
22687,
22668,
22637,
22644,
22604,
22615,
22576,
22646,
22611,
22623,
22586,
22648,
22613,
22617,
22618,
22578,
22579,
22649,
22614,
22619,
22588,
22647,
22612,
22624,
22587,
22620,
22621,
22622,
22580,
22581,
22582,
22583,
22656,
22657,
22625,
22629,
22632,
22589,
22590,
22671,
22689,
22584,
22585,
22692,
22597,
22643,
22639,
22693,
22684,
22674,
22685,
22603,
22651,
22676,
22594,
22636,
22595,
22667,
22694,
22650,
22675,
22681,
22653,
22666,
22635,
22652,
22599,
22642,
22640,
22641,
22631,
22626,
22628,
22630,
22627,
22606,
22607,
22608,
22609,
22661,
22662,
22593,
22602,
22598,
22683,
-1,
-1,
-1,
-1,
-1,
22712,
22736,
22737,
22700,
22735,
22715,
22730,
22731,
22727,
22729,
22733,
22732,
22728,
-1,
-1,
-1,
22724,
22720,
22721,
22717,
22722,
22723,
22718,
22719,
22714,
]

_charnames_113808 = [
22706,
22708,
22709,
22702,
22710,
22711,
22703,
22707,
22699,
22705,
-1,
-1,
22739,
22738,
22741,
22740,
7152,
7154,
7153,
7151,
]

_charnames_119262 = [
10065,
10055,
10061,
10063,
10062,
10064,
10058,
10057,
10054,
10053,
10060,
]

_charnames_119296 = [
21658,
21675,
21686,
21685,
21669,
21684,
21683,
21682,
21681,
21668,
21667,
21666,
21665,
21664,
21663,
21662,
21661,
21660,
21659,
21680,
21679,
21678,
21677,
21676,
21674,
21673,
21672,
21671,
21670,
21626,
21634,
21618,
21641,
21655,
21654,
21633,
21632,
21631,
21630,
21629,
21628,
21627,
21640,
21639,
21638,
21637,
21636,
21635,
21653,
21652,
21651,
21650,
21649,
21648,
21625,
21624,
21623,
21622,
21621,
21620,
21619,
21646,
21645,
21644,
21643,
21642,
1667,
1668,
1669,
21751,
]

_charnames_119520 = [
9180,
9181,
9157,
9160,
9169,
9172,
9164,
9166,
9175,
9178,
9162,
9177,
9158,
9161,
9170,
9173,
9165,
9167,
9176,
9179,
]

_charnames_119552 = [
9552,
22858,
22857,
22852,
22851,
22849,
5222,
5259,
5291,
5302,
5311,
5209,
5286,
5307,
5300,
5232,
5228,
5318,
5314,
5284,
5254,
5211,
5316,
5305,
5262,
5288,
5253,
5250,
5245,
5321,
5210,
5240,
5234,
5221,
5233,
5301,
5282,
5298,
5218,
5310,
5274,
5270,
5283,
5258,
5251,
5296,
5252,
5278,
5241,
5268,
5277,
5239,
5281,
5255,
5263,
5319,
5212,
5292,
5243,
5320,
5227,
5219,
5276,
5275,
5293,
5289,
5244,
5235,
5304,
5271,
5313,
5231,
5236,
5226,
5242,
5272,
5269,
5317,
5215,
5220,
5264,
5287,
5214,
5308,
5229,
5297,
5261,
]

_charnames_119648 = [
2151,
2143,
2144,
2149,
2150,
2146,
2147,
2153,
2152,
2164,
2156,
2157,
2162,
2163,
2159,
2160,
2166,
2165,
24507,
24502,
24503,
24505,
24506,
4982,
4983,
]

_charnames_120832 = [
5526,
5758,
5739,
5878,
5792,
5847,
5617,
5770,
5627,
5616,
5619,
5605,
5609,
5769,
5528,
5760,
5569,
5566,
5567,
5610,
5607,
5531,
5544,
5543,
5541,
5539,
5546,
5763,
5664,
5618,
5549,
5765,
5572,
5570,
5560,
5568,
5612,
5613,
5608,
5571,
5552,
5554,
5556,
5557,
5631,
5534,
5536,
5537,
5656,
5597,
5540,
5547,
5538,
5542,
5649,
5592,
5647,
5648,
5603,
5604,
5594,
5553,
5559,
5558,
5652,
5653,
5654,
5598,
5705,
5710,
5709,
5707,
5708,
5788,
5692,
5827,
5696,
5719,
5703,
5721,
5704,
5722,
5702,
5747,
5748,
5828,
5879,
5698,
5700,
5701,
5693,
5728,
5717,
5725,
5723,
5727,
5726,
5716,
5712,
5713,
5714,
5715,
5779,
5782,
5786,
5783,
5844,
5831,
5733,
5731,
5736,
5745,
5738,
5749,
5737,
5746,
5753,
5751,
5756,
5870,
5873,
5876,
5874,
5807,
5811,
5790,
5829,
5810,
5819,
5812,
5830,
5820,
5821,
5845,
5562,
5766,
5802,
5856,
5813,
5565,
5564,
5803,
5666,
5669,
5670,
5671,
5677,
5626,
5776,
5877,
5862,
5678,
5679,
5673,
5674,
5817,
5676,
5816,
5861,
5860,
5675,
5777,
5815,
5859,
5573,
5767,
5804,
5822,
5857,
5548,
5764,
5690,
5823,
5869,
5685,
5687,
5688,
5778,
5875,
5868,
5681,
5684,
5683,
5689,
5686,
5843,
5615,
5768,
5755,
5841,
5842,
5840,
5743,
5805,
5854,
5853,
5663,
5824,
5657,
5774,
5661,
5658,
5838,
5655,
5662,
5660,
5772,
5754,
5750,
5825,
5865,
5866,
5863,
5773,
5784,
5785,
5836,
5837,
5834,
5806,
5575,
5798,
5578,
5579,
5580,
5583,
5584,
5582,
5600,
5601,
5595,
5591,
5590,
5787,
5589,
5593,
5741,
5742,
5799,
5800,
5794,
5797,
5851,
5852,
5849,
5620,
5641,
5635,
5636,
5637,
5642,
5630,
5633,
5632,
5624,
5639,
5625,
5628,
5640,
5524,
5691,
6249,
6250,
6251,
6498,
6499,
6500,
6434,
6435,
6436,
6484,
6485,
6486,
6319,
6320,
6321,
6443,
6444,
6430,
6426,
6431,
6427,
6428,
6402,
6398,
6403,
6399,
6400,
6432,
6166,
6165,
6167,
6169,
6164,
6163,
6168,
6015,
6135,
5958,
5959,
5956,
5957,
5960,
5995,
5994,
5992,
5993,
5931,
5990,
5989,
5987,
5988,
5976,
5977,
5978,
5923,
5925,
5926,
5924,
5928,
5929,
5930,
5972,
5973,
5974,
6004,
6005,
6006,
6008,
6009,
6010,
6213,
6214,
6215,
6217,
6218,
6219,
6224,
6222,
6223,
6221,
6157,
6158,
6155,
6156,
6152,
6153,
6150,
6151,
6147,
6148,
6145,
6146,
6142,
6143,
6140,
6141,
6092,
6093,
6090,
6091,
6094,
6116,
6115,
6113,
6114,
6036,
6111,
6110,
6109,
6108,
6122,
6033,
6034,
6035,
6037,
6119,
6120,
6121,
6124,
6125,
6126,
6128,
6129,
6130,
6232,
6233,
6234,
6228,
6229,
6230,
6235,
5912,
5913,
5910,
5911,
5904,
5905,
5902,
5903,
5916,
5917,
5983,
5984,
5985,
5963,
5968,
5969,
5964,
5940,
5941,
5942,
5936,
5937,
5938,
5918,
5920,
5921,
6275,
6279,
6287,
5961,
5907,
5981,
5966,
5948,
6277,
6281,
6285,
5908,
5982,
5967,
5949,
6278,
6282,
6286,
5944,
5945,
5946,
6025,
6026,
6082,
6085,
6081,
6084,
6065,
6068,
6066,
6069,
6045,
6046,
6292,
6296,
6300,
6022,
6023,
6077,
6078,
6075,
6076,
6058,
6061,
6059,
6062,
6042,
6043,
6291,
6295,
6299,
6029,
6030,
6027,
6028,
6031,
6086,
6070,
6048,
6049,
6050,
6289,
6293,
6297,
6095,
5998,
6001,
5999,
6002,
6098,
6101,
6104,
6099,
6102,
6105,
5951,
5952,
6052,
6053,
6013,
6014,
6133,
6134,
6453,
6454,
6458,
6451,
6455,
6456,
6449,
6450,
6459,
6457,
5881,
5893,
5887,
5886,
5890,
5888,
5891,
5892,
6420,
6418,
6419,
6354,
6355,
6356,
6463,
6465,
6464,
6462,
6415,
6416,
6414,
6347,
6346,
6348,
6359,
6360,
6344,
6342,
6345,
6341,
6361,
6350,
6352,
6351,
6326,
6328,
6329,
6334,
6336,
6337,
6331,
6338,
6332,
6477,
6478,
6476,
6270,
6268,
6269,
6363,
6471,
6472,
6469,
6470,
6495,
6492,
6496,
6493,
6488,
6489,
6185,
6186,
6187,
6193,
6195,
6196,
6201,
6203,
6204,
6182,
6181,
6180,
6176,
6179,
6178,
6172,
6175,
6174,
6197,
6200,
6199,
6189,
6192,
6191,
6380,
6379,
6378,
6188,
6206,
6207,
6244,
6246,
6240,
6239,
6247,
6245,
6242,
6243,
6258,
6265,
6261,
6262,
6263,
6264,
6266,
6016,
6136,
6473,
5880,
6362,
6439,
6440,
6501,
6404,
6441,
6254,
6255,
6256,
6502,
6375,
6374,
6373,
6372,
6371,
6370,
6369,
6368,
6412,
6391,
6392,
6384,
6386,
6389,
6385,
6387,
6388,
6480,
6421,
6445,
6481,
6503,
]

_charnames_121499 = [
6411,
6410,
6409,
6408,
6407,
-1,
6317,
6316,
6315,
6314,
6313,
6312,
6311,
6310,
6309,
6308,
6307,
6306,
6305,
6304,
6303,
]

_charnames_122880 = [
1642,
1628,
1630,
1640,
1625,
1599,
1616,
-1,
1617,
1607,
1608,
1603,
1626,
1638,
1637,
1636,
1635,
1634,
1633,
1632,
1614,
1619,
1631,
1622,
1639,
-1,
-1,
1611,
1620,
1641,
1612,
1597,
1598,
1602,
-1,
1600,
1613,
-1,
1601,
1605,
1629,
1606,
1623,
]

_charnames_124928 = [
8067,
8066,
8065,
7997,
7964,
7985,
8016,
8081,
8064,
8063,
8062,
8139,
8148,
8152,
8019,
8172,
8120,
8001,
8015,
8125,
8061,
8060,
8059,
8004,
7965,
8108,
8070,
8057,
8056,
8055,
8112,
7962,
8164,
8126,
8054,
8053,
8052,
8098,
8167,
8096,
8116,
8127,
8133,
8129,
8171,
8082,
8048,
8046,
8045,
8099,
8150,
8128,
7982,
8170,
8041,
8040,
8039,
7976,
7988,
8009,
8109,
8156,
8051,
8050,
8049,
7971,
8079,
8078,
8044,
8043,
8042,
7968,
8008,
8163,
7993,
8038,
8037,
8035,
8105,
8153,
8101,
7999,
8085,
8034,
8033,
8032,
8158,
7980,
8122,
8144,
8031,
8030,
8029,
7983,
7986,
8131,
7972,
8169,
8166,
8028,
8027,
8026,
8149,
8092,
8084,
8023,
8073,
8024,
7963,
8022,
8123,
7977,
8137,
8010,
8134,
7973,
8011,
8173,
8018,
7969,
8021,
7978,
8151,
8117,
8106,
8145,
8103,
8138,
7974,
8161,
8076,
8107,
8155,
8093,
8176,
8095,
8094,
8075,
8006,
8083,
7994,
7960,
8013,
7979,
8012,
8165,
7996,
8118,
8000,
8143,
8017,
8071,
7989,
8088,
8086,
8072,
8100,
8162,
8121,
8132,
7967,
7987,
8020,
8159,
8154,
8104,
8141,
8007,
8115,
7966,
8160,
7990,
7991,
8089,
8142,
8136,
8140,
8175,
8147,
7995,
7998,
8110,
8174,
8114,
8130,
8077,
8074,
8111,
8087,
7975,
8119,
7984,
8097,
8005,
8090,
7961,
8002,
-1,
-1,
8187,
8179,
8180,
8185,
8186,
8182,
8183,
8189,
8188,
8196,
8194,
8199,
8197,
8195,
8200,
8201,
]

_charnames_125184 = [
13345,
13324,
13338,
13337,
13327,
13317,
13335,
13326,
13333,
13343,
13342,
13340,
13336,
13323,
13314,
13329,
13307,
13312,
13315,
13331,
13339,
13344,
13341,
13334,
13321,
13306,
13332,
13308,
13330,
13311,
13320,
13328,
13310,
13318,
13388,
13367,
13381,
13380,
13370,
13360,
13378,
13369,
13376,
13386,
13385,
13383,
13379,
13366,
13357,
13372,
13350,
13355,
13358,
13374,
13382,
13387,
13384,
13377,
13364,
13349,
13375,
13351,
13373,
13354,
13363,
13371,
13353,
13361,
13412,
13409,
13407,
13411,
13346,
13408,
13410,
-1,
-1,
-1,
-1,
-1,
13399,
13400,
13391,
13392,
13397,
13398,
13394,
13395,
13402,
13401,
-1,
-1,
-1,
-1,
13405,
13404,
]

_charnames_126065 = [
24329,
24261,
24268,
24291,
24298,
24277,
24283,
24323,
24317,
24274,
24265,
24272,
24295,
24302,
24278,
24284,
24324,
24318,
24332,
24264,
24271,
24294,
24301,
24282,
24288,
24328,
24322,
24331,
24263,
24270,
24293,
24300,
24281,
24287,
24327,
24321,
24275,
24266,
24273,
24296,
24303,
24279,
24285,
24325,
24319,
24338,
24339,
24349,
24340,
24341,
24314,
24306,
24307,
24312,
24313,
24309,
24310,
24316,
24315,
24348,
24344,
24345,
24346,
24347,
24337,
24335,
24336,
24350,
]

_charnames_126464 = [
12819,
12831,
12827,
12685,
-1,
12822,
12810,
12828,
12804,
12821,
12817,
12723,
12826,
12825,
12756,
12820,
12830,
12757,
12824,
12823,
12755,
12808,
12806,
12816,
12807,
12686,
12811,
12829,
12683,
12681,
12682,
12680,
-1,
12781,
12777,
-1,
12770,
-1,
-1,
12771,
-1,
12772,
12768,
12776,
12775,
12774,
12761,
12782,
12779,
12762,
12773,
-1,
12760,
12765,
12764,
12767,
-1,
12780,
-1,
12778,
-1,
-1,
-1,
-1,
-1,
-1,
12800,
-1,
-1,
-1,
-1,
12801,
-1,
12795,
-1,
12798,
-1,
12797,
12788,
12803,
-1,
12789,
12796,
-1,
12787,
-1,
-1,
12799,
-1,
12794,
-1,
12802,
-1,
12793,
-1,
12792,
-1,
12753,
12750,
-1,
12743,
-1,
-1,
12744,
12729,
12746,
12741,
-1,
12749,
12748,
12732,
12754,
12752,
12733,
12747,
-1,
12731,
12728,
12727,
12740,
-1,
12738,
12745,
12751,
12737,
-1,
12736,
-1,
12709,
12722,
12719,
12706,
12703,
12712,
12700,
12704,
12694,
12711,
-1,
12717,
12716,
12715,
12697,
12710,
12721,
12698,
12714,
12713,
12696,
12693,
12691,
12718,
12692,
12707,
12701,
12720,
-1,
-1,
-1,
-1,
-1,
12677,
12673,
12663,
-1,
12666,
12660,
12674,
12654,
12665,
-1,
12671,
12670,
12669,
12657,
12678,
12676,
12658,
12668,
12667,
12656,
12653,
12651,
12672,
12652,
12664,
12661,
12675,
]

_charnames_126976 = [
8804,
8761,
8808,
8797,
8812,
8815,
8807,
8788,
8766,
8771,
8777,
8782,
8752,
8757,
8802,
8795,
8789,
8767,
8772,
8778,
8783,
8753,
8758,
8803,
8796,
8787,
8765,
8770,
8776,
8781,
8751,
8756,
8801,
8794,
8813,
8790,
8810,
8816,
8760,
8759,
8817,
8806,
8814,
8811,
-1,
-1,
-1,
-1,
22401,
22400,
22399,
22398,
22397,
22396,
22395,
22394,
22392,
22391,
22390,
22389,
22388,
22387,
22386,
22384,
22383,
22382,
22381,
22380,
22379,
22378,
22376,
22375,
22374,
22373,
22372,
22371,
22370,
22368,
22367,
22366,
22365,
22364,
22363,
22362,
22360,
22359,
22358,
22357,
22356,
22355,
22354,
22352,
22351,
22350,
22349,
22348,
22347,
22346,
22342,
22341,
22340,
22339,
22338,
22337,
22336,
22335,
22333,
22332,
22331,
22330,
22329,
22328,
22327,
22325,
22324,
22323,
22322,
22321,
22320,
22319,
22317,
22316,
22315,
22314,
22313,
22312,
22311,
22309,
22308,
22307,
22306,
22305,
22304,
22303,
22301,
22300,
22299,
22298,
22297,
22296,
22295,
22293,
22292,
22291,
22290,
22289,
22288,
22287,
]

_charnames_127136 = [
20581,
20575,
20505,
20510,
20522,
20528,
20534,
20539,
20570,
20560,
20515,
20565,
20545,
20555,
20550,
-1,
-1,
20576,
20506,
20511,
20523,
20529,
20535,
20540,
20571,
20561,
20516,
20566,
20546,
20556,
20551,
20583,
-1,
20577,
20507,
20512,
20524,
20530,
20536,
20541,
20572,
20562,
20517,
20567,
20547,
20557,
20552,
20580,
-1,
20578,
20508,
20513,
20525,
20531,
20537,
20542,
20573,
20563,
20518,
20568,
20548,
20558,
20553,
20582,
20526,
20483,
20494,
20503,
20502,
20501,
20500,
20499,
20498,
20497,
20493,
20492,
20491,
20490,
20489,
20488,
20487,
20486,
20485,
20484,
20496,
20495,
]

_charnames_127232 = [
22834,
22835,
22845,
22837,
22838,
22843,
22844,
22840,
22841,
22847,
22846,
22880,
22879,
-1,
-1,
-1,
20210,
20209,
20208,
20207,
20206,
20205,
20204,
20203,
20202,
20201,
20200,
20199,
20198,
20197,
20196,
20195,
20194,
20193,
20192,
20191,
20190,
20189,
20188,
20187,
20186,
20185,
5423,
3314,
3313,
3337,
3342,
2138,
7479,
7478,
7477,
7476,
7475,
7474,
7473,
7472,
7471,
7470,
7469,
7468,
7467,
7466,
7465,
7464,
7463,
7462,
7461,
7460,
7459,
7458,
7457,
7456,
7455,
7454,
7503,
7532,
7494,
7490,
7531,
7530,
18784,
18783,
18782,
18781,
18780,
18779,
18778,
18777,
18776,
18775,
18774,
18773,
18772,
18771,
18770,
18769,
18768,
18767,
18766,
18765,
18764,
18763,
18762,
18761,
18760,
18759,
23921,
23920,
-1,
-1,
-1,
-1,
18750,
18749,
18748,
18747,
18746,
18745,
18744,
18743,
18742,
18741,
18740,
18739,
18738,
18737,
18736,
18735,
18734,
18733,
18732,
18731,
18730,
18729,
18728,
18727,
18726,
18725,
3356,
18754,
18753,
18752,
18756,
18751,
7546,
7450,
7449,
7511,
7533,
7529,
7528,
7526,
7491,
7522,
7519,
7517,
7489,
7515,
7509,
7534,
7512,
7488,
7516,
7492,
7525,
7480,
7506,
7505,
7504,
7485,
7493,
7523,
7520,
]

_charnames_127462 = [
23617,
23616,
23615,
23614,
23613,
23612,
23611,
23610,
23609,
23608,
23607,
23606,
23605,
23604,
23603,
23602,
23601,
23600,
23599,
23598,
23597,
23596,
23595,
23594,
23593,
23592,
7548,
7499,
7498,
]

_charnames_127504 = [
7414,
7406,
7403,
7500,
7440,
7397,
7445,
7396,
7439,
7426,
7434,
7420,
7393,
7404,
7409,
7419,
7394,
7431,
7430,
7444,
7407,
7399,
7424,
7412,
7422,
7438,
7437,
7448,
7405,
7441,
7402,
7423,
7443,
7413,
7433,
7432,
7400,
7425,
7416,
7417,
7429,
7392,
7408,
7447,
-1,
-1,
-1,
-1,
5411,
5422,
5421,
5418,
5416,
5413,
5415,
5419,
5412,
]

_charnames_127744 = [
3063,
24620,
3279,
19004,
7661,
7660,
3349,
7665,
23930,
16647,
24067,
18044,
9989,
15190,
15189,
15188,
22151,
18716,
24080,
24580,
24079,
24659,
24082,
11630,
24083,
3374,
18715,
24579,
11629,
24658,
7663,
22149,
7165,
5406,
16854,
24088,
24092,
24090,
24091,
3285,
3284,
3286,
3283,
24619,
24218,
19874,
4988,
16971,
2518,
7901,
15216,
22825,
20272,
2806,
19873,
5471,
2513,
23905,
19908,
7666,
16923,
15194,
15193,
19551,
24607,
9200,
24563,
11873,
10071,
5440,
13655,
21867,
8626,
24071,
4230,
11876,
16474,
20752,
23657,
21767,
20666,
20665,
2514,
7799,
19841,
7892,
8627,
20724,
23782,
23783,
2185,
1573,
7807,
7847,
16658,
24653,
23911,
22894,
21526,
7673,
24655,
24594,
6941,
7145,
24511,
22555,
2184,
2529,
2650,
11968,
1586,
19883,
7160,
17036,
20730,
2183,
24612,
5362,
7382,
24220,
2190,
5494,
17052,
3297,
16479,
24613,
16982,
20741,
23764,
24251,
17056,
24802,
2531,
24564,
24571,
24572,
16330,
20220,
2173,
4231,
3357,
20753,
24799,
2713,
24217,
9581,
7922,
21868,
19531,
17014,
9990,
23658,
10069,
7804,
11874,
2176,
17045,
17044,
24590,
13414,
2714,
24666,
23898,
24593,
9979,
9592,
3350,
19538,
13128,
5429,
3347,
5202,
3291,
20655,
18035,
22882,
7898,
17059,
22280,
17005,
24628,
10070,
10045,
7380,
22266,
10068,
5498,
18038,
10067,
23849,
5358,
7945,
16453,
2519,
7930,
23850,
7676,
7834,
5495,
19863,
13667,
23858,
7941,
24241,
22272,
23936,
23937,
3372,
18043,
24599,
24510,
4985,
7931,
2800,
17047,
16972,
19868,
3348,
22827,
3292,
22814,
22815,
18995,
7793,
19867,
19869,
21525,
24796,
15208,
19884,
16468,
13653,
19876,
11962,
2180,
7921,
22828,
24556,
24512,
24800,
15209,
24153,
16911,
24074,
24076,
23906,
16868,
11632,
16491,
17006,
13666,
15138,
15137,
15136,
15135,
15134,
23943,
9569,
21520,
24070,
2186,
5198,
11875,
23941,
2792,
22903,
3365,
24162,
7934,
7933,
19861,
23944,
22269,
7178,
9559,
23908,
2526,
22402,
20747,
17019,
15129,
21518,
7838,
16925,
12626,
19882,
11634,
24592,
5493,
16922,
5469,
19834,
16478,
24646,
17057,
20660,
23541,
20744,
22902,
16465,
22571,
9570,
2187,
5199,
23942,
2793,
22904,
7833,
19864,
9560,
22482,
20750,
24647,
19840,
24238,
17042,
20292,
20749,
20296,
2525,
15197,
15196,
15184,
18938,
9571,
5439,
24157,
24112,
24115,
24150,
24595,
24075,
21523,
5402,
5403,
3290,
21489,
3363,
24229,
15198,
18796,
5514,
24808,
22907,
23539,
17065,
24230,
20762,
19796,
20725,
8743,
13675,
19900,
24228,
24231,
24618,
16966,
16965,
17011,
22275,
8629,
24226,
24565,
8741,
5508,
5506,
20739,
24232,
16648,
20638,
8736,
8735,
21246,
21245,
16475,
2178,
20707,
24797,
24798,
22279,
16480,
15181,
13299,
24458,
7946,
24452,
22264,
22895,
10983,
18998,
24555,
19844,
16485,
7765,
20755,
23537,
11961,
23778,
22017,
23530,
17013,
2167,
24246,
17046,
16653,
5509,
7845,
21883,
19533,
16919,
21765,
25061,
20763,
19532,
23642,
19534,
22869,
15127,
12639,
17016,
7882,
2191,
7848,
22900,
22892,
20756,
24640,
22876,
7827,
5405,
24143,
19916,
9557,
1574,
19501,
3375,
16470,
16473,
16472,
16471,
9556,
2402,
7912,
20651,
16649,
9986,
24629,
21492,
22914,
24586,
21487,
20280,
20282,
2803,
5361,
2707,
2401,
2403,
16484,
3298,
20765,
23895,
20297,
7798,
5476,
17009,
11878,
18930,
18931,
3281,
21490,
21766,
16920,
21474,
17010,
18996,
7915,
8625,
5351,
20284,
24559,
7379,
20767,
2517,
21516,
24457,
20298,
15220,
24455,
15167,
3278,
3277,
21483,
21484,
20733,
20734,
18721,
9584,
9586,
18039,
9587,
18927,
12635,
2798,
2799,
18036,
5354,
23939,
18037,
24589,
20743,
20711,
5512,
3270,
3271,
3274,
12634,
11954,
19904,
7822,
7818,
7821,
7820,
16405,
15126,
11768,
23762,
11959,
3280,
23509,
11955,
21488,
17049,
17051,
17008,
10800,
23940,
16463,
15164,
21505,
6949,
5430,
18926,
23525,
24442,
24440,
24444,
24443,
24441,
24569,
15125,
24250,
19836,
18475,
19886,
20757,
9978,
5355,
3370,
6703,
24795,
5480,
16816,
24097,
11617,
11616,
11610,
11615,
7874,
7875,
24862,
22538,
24860,
22537,
11950,
24872,
3335,
3360,
3359,
18937,
18936,
7771,
24118,
19471,
3379,
21522,
22569,
23508,
9590,
7768,
8203,
17004,
3264,
3231,
3237,
3251,
3254,
3244,
3247,
3261,
3267,
3240,
3258,
3234,
3263,
3230,
3236,
3250,
3253,
3243,
3246,
3260,
3266,
3239,
3257,
3233,
23730,
23733,
23732,
16968,
16969,
23779,
17007,
2651,
8742,
16825,
18918,
19880,
8739,
7886,
22897,
7841,
7842,
24806,
8740,
11731,
5352,
23747,
24126,
16889,
5353,
3293,
16464,
7792,
15166,
24632,
20661,
10799,
16912,
11945,
11949,
11947,
11946,
11948,
11758,
5464,
23918,
23626,
23622,
23623,
23627,
23629,
23917,
24111,
6634,
6633,
6639,
6638,
16876,
16867,
6632,
6635,
6637,
6640,
16901,
16849,
16905,
22818,
23528,
5383,
20704,
20745,
16907,
24138,
6940,
4987,
24221,
21504,
5510,
5384,
5487,
20965,
19842,
7917,
20705,
24560,
21493,
22566,
22567,
22568,
24650,
24649,
24651,
16914,
24622,
21486,
2708,
2709,
24587,
15145,
15147,
15148,
18929,
18933,
18934,
15151,
15149,
15150,
22564,
20277,
20283,
24084,
7839,
7840,
22817,
9985,
9205,
21507,
3272,
2647,
24454,
22826,
1923,
21243,
23899,
20281,
7812,
22889,
10982,
7823,
5372,
5371,
5370,
5369,
11741,
23734,
5507,
5381,
11751,
23745,
11748,
23742,
9583,
10980,
10979,
16325,
16329,
16326,
16328,
16323,
10978,
16324,
24236,
9568,
5441,
7787,
6705,
9591,
21871,
21875,
24533,
7859,
7862,
7863,
7861,
7867,
7865,
24219,
7854,
24552,
23659,
7866,
7858,
7871,
18790,
15182,
24922,
24542,
20659,
2171,
2172,
23532,
24553,
23534,
23535,
24527,
24529,
24530,
22872,
24235,
12638,
20722,
3368,
20652,
24546,
22873,
24645,
12637,
24668,
24244,
7885,
5101,
21878,
11966,
24521,
19915,
24524,
24551,
13660,
24642,
7883,
22877,
24549,
24539,
21877,
2796,
7869,
7870,
2795,
23536,
20723,
3369,
24245,
7891,
7890,
24871,
24544,
24545,
24526,
20650,
7902,
19535,
7824,
19843,
20646,
20647,
20640,
20642,
18897,
6921,
18907,
6931,
5458,
5448,
5459,
5449,
18896,
6920,
18906,
6930,
19484,
19451,
19487,
19454,
18898,
6922,
18908,
6932,
19485,
19452,
19488,
19455,
19878,
19879,
6943,
6944,
11708,
24855,
23715,
22528,
7916,
19462,
10981,
19473,
19481,
7938,
7373,
7374,
7375,
19527,
7376,
19460,
17997,
18006,
2520,
23641,
23909,
19550,
7808,
23933,
19898,
19899,
5489,
8623,
10975,
7788,
5483,
5484,
16963,
21500,
5496,
16967,
9987,
13668,
24575,
20737,
21498,
4986,
21497,
13652,
21501,
23649,
22820,
13129,
5486,
9553,
9565,
7672,
9566,
13578,
7171,
23907,
7826,
19856,
18016,
2179,
20738,
5477,
22570,
18921,
7877,
18925,
20764,
22572,
20729,
18939,
17063,
18924,
17062,
9567,
20669,
18919,
2523,
8202,
24233,
23647,
16477,
5442,
24069,
7164,
16403,
16404,
20290,
1585,
16488,
11753,
5478,
20710,
3315,
17012,
22276,
2168,
7884,
7163,
17050,
17053,
20584,
21519,
7162,
7802,
20285,
]

_charnames_128736 = [
19838,
7173,
21524,
9577,
23932,
9576,
24863,
24864,
24861,
7876,
18914,
13677,
13678,
-1,
-1,
-1,
7378,
21499,
22883,
20288,
7920,
9575,
2652,
7887,
24631,
7947,
-1,
-1,
-1,
-1,
-1,
-1,
13279,
13175,
13292,
13293,
13277,
13164,
13162,
13163,
13160,
13161,
13225,
13228,
13227,
13142,
13242,
13221,
13252,
13255,
13254,
13195,
13144,
13282,
13230,
13231,
13210,
13211,
13289,
13155,
13272,
13273,
13187,
13206,
13193,
13274,
13139,
13185,
13186,
13194,
13146,
13137,
13232,
13246,
13286,
13173,
13140,
13147,
13138,
13229,
13204,
13205,
13198,
13202,
13201,
13200,
13166,
13167,
13257,
13148,
13172,
13207,
13208,
13170,
13222,
13247,
13248,
13280,
13213,
13216,
13215,
13168,
13291,
13153,
13245,
13288,
13276,
13235,
13190,
13249,
13189,
13156,
13191,
13250,
13152,
13285,
13154,
13290,
13261,
13171,
13237,
13220,
13236,
13174,
13150,
13151,
13141,
13241,
13269,
13267,
13268,
13240,
13239,
13178,
13183,
13182,
13181,
13180,
13169,
13219,
13218,
13209,
13260,
13283,
13270,
13256,
13264,
13263,
]

_charnames_128896 = [
16874,
16898,
16865,
16846,
16823,
8499,
16986,
19511,
18002,
15175,
24160,
23894,
16884,
16822,
10974,
8490,
16985,
19509,
18001,
15174,
24095,
24096,
7554,
16886,
16894,
16808,
24104,
24105,
22868,
16885,
16893,
16807,
24120,
5397,
10976,
8501,
16990,
18009,
18007,
15179,
5396,
10973,
8483,
16989,
19461,
17999,
15178,
10966,
8488,
16991,
19522,
18008,
15180,
10972,
8480,
16988,
19457,
17998,
15177,
10977,
8496,
16992,
19494,
18004,
10970,
8494,
5382,
8493,
10963,
8487,
24606,
8486,
23638,
10967,
19523,
8481,
19458,
6704,
8497,
19493,
18005,
19492,
10969,
19517,
19516,
3343,
18785,
3344,
18786,
]

_charnames_129024 = [
11685,
24836,
23693,
22511,
11688,
24839,
23696,
22514,
11689,
24840,
23697,
22515,
-1,
-1,
-1,
-1,
11686,
24837,
23694,
22512,
11690,
24841,
23698,
22516,
19469,
19514,
19520,
19500,
19468,
19513,
19519,
19499,
11652,
24822,
23676,
22496,
11653,
24823,
23677,
22497,
11655,
24826,
23679,
22500,
11654,
24824,
23678,
22498,
11651,
24821,
23675,
22495,
11715,
24856,
23722,
22529,
11705,
24847,
23712,
22519,
11719,
24857,
23726,
22530,
11711,
24850,
23718,
22522,
11712,
24851,
23719,
22523,
]

_charnames_129104 = [
11706,
24848,
23713,
22520,
18902,
18912,
6936,
6926,
11736,
24868,
-1,
-1,
-1,
-1,
-1,
-1,
24206,
24194,
24200,
24212,
24182,
24188,
24175,
24169,
24208,
24196,
24202,
24214,
24184,
24190,
24177,
24171,
24205,
24193,
24199,
24211,
24181,
24187,
24174,
24168,
24207,
24195,
24201,
24213,
24183,
24189,
24176,
24170,
24204,
24192,
24198,
24210,
24180,
24186,
24173,
24167,
]

_charnames_129168 = [
11660,
24831,
23684,
22506,
11716,
24844,
23723,
22527,
11687,
24838,
23695,
22513,
19476,
19480,
19479,
19478,
11702,
23709,
11674,
23686,
11718,
23716,
11709,
23725,
11703,
23710,
11714,
23721,
24156,
24155,
]

_charnames_129280 = [
3334,
3333,
3331,
11728,
11727,
11726,
11729,
11723,
22534,
22532,
22535,
22533,
-1,
-1,
-1,
-1,
25039,
9558,
24532,
18794,
5398,
24547,
23910,
19917,
6504,
2802,
23928,
11765,
23759,
19797,
19798,
24513,
24541,
3287,
18994,
23900,
22901,
11939,
24554,
7935,
24525,
21874,
21876,
24548,
7906,
7857,
24523,
7166,
20692,
16656,
20274,
7909,
20706,
8738,
9578,
7175,
20648,
24805,
24667,
9524,
24249,
24068,
19795,
-1,
24222,
22905,
3296,
5470,
7831,
22270,
23784,
24582,
7911,
5399,
17017,
9065,
1577,
11635,
6942,
24633,
3364,
13649,
1588,
16466,
20728,
2711,
16487,
21764,
7147,
7803,
14874,
22147,
20667,
23538,
20293,
22742,
24615,
4980,
2528,
17003,
1580,
2189,
16654,
20758,
20691,
1587,
7377,
2653,
11872,
8744,
9582,
16489,
7856,
-1,
-1,
24536,
24543,
21513,
24654,
-1,
-1,
-1,
24535,
-1,
11633,
22273,
19907,
24637,
3376,
10986,
7919,
5468,
24919,
15195,
22743,
16332,
7081,
21521,
24621,
16970,
22829,
22271,
10984,
23951,
7176,
7560,
22277,
25037,
19552,
7290,
5515,
3371,
23492,
11976,
20664,
19906,
20225,
23938,
11969,
9589,
9980,
16492,
7939,
]

_charnames_129456 = [
15141,
15142,
15143,
15140,
17018,
11877,
24617,
5437,
7670,
7668,
-1,
-1,
-1,
-1,
-1,
-1,
2516,
1583,
7381,
]

_charnames_129488 = [
24538,
13416,
2522,
21247,
17041,
20641,
20644,
20649,
20645,
9204,
24566,
17677,
8365,
15130,
22016,
25038,
16644,
21473,
17060,
7924,
22150,
2193,
6946,
23656,
24576,
24807,
5363,
20668,
22915,
1924,
13681,
24574,
5438,
16650,
9203,
11975,
11967,
7832,
16331,
7384,
5364,
16652,
16452,
23901,
16483,
7835,
23651,
18993,
]

_charnames_129632 = [
25048,
25046,
25049,
25047,
25043,
25044,
25045,
25057,
25055,
25058,
25056,
25052,
25053,
25054,
]

_charnames_917760 = [
17444,
17433,
17422,
17577,
17566,
17555,
17544,
17533,
17588,
17599,
17598,
17597,
17596,
17676,
17675,
17674,
17673,
17672,
17671,
17670,
17669,
17668,
17667,
17665,
17664,
17663,
17662,
17661,
17660,
17659,
17658,
17657,
17656,
17654,
17653,
17652,
17651,
17650,
17649,
17648,
17647,
17646,
17645,
17643,
17642,
17641,
17640,
17639,
17638,
17637,
17636,
17635,
17634,
17632,
17631,
17630,
17629,
17628,
17627,
17626,
17625,
17624,
17623,
17621,
17620,
17619,
17618,
17617,
17616,
17615,
17614,
17613,
17612,
17610,
17609,
17608,
17607,
17606,
17605,
17604,
17603,
17602,
17601,
17531,
17530,
17529,
17528,
17527,
17526,
17525,
17524,
17523,
17522,
17520,
17519,
17518,
17517,
17516,
17515,
17514,
17513,
17512,
17511,
17509,
17508,
17507,
17506,
17505,
17504,
17503,
17502,
17501,
17500,
17498,
17497,
17496,
17495,
17494,
17493,
17492,
17491,
17490,
17489,
17487,
17486,
17485,
17484,
17483,
17482,
17481,
17480,
17479,
17478,
17476,
17475,
17474,
17473,
17472,
17471,
17470,
17469,
17468,
17467,
17465,
17464,
17463,
17462,
17461,
17460,
17459,
17458,
17457,
17456,
17454,
17453,
17452,
17451,
17450,
17449,
17448,
17447,
17446,
17445,
17443,
17442,
17441,
17440,
17439,
17438,
17437,
17436,
17435,
17434,
17432,
17431,
17430,
17429,
17428,
17427,
17426,
17425,
17424,
17423,
17587,
17586,
17585,
17584,
17583,
17582,
17581,
17580,
17579,
17578,
17576,
17575,
17574,
17573,
17572,
17571,
17570,
17569,
17568,
17567,
17565,
17564,
17563,
17562,
17561,
17560,
17559,
17558,
17557,
17556,
17554,
17553,
17552,
17551,
17550,
17549,
17548,
17547,
17546,
17545,
17543,
17542,
17541,
17540,
17539,
17538,
17537,
17536,
17535,
17534,
17595,
17594,
17593,
17592,
17591,
17590,
17589,
]

_charnames_983040 = [
18474,
18473,
7781,
6950,
7779,
7813,
15158,
15067,
15156,
15204,
15169,
15168,
13671,
13670,
13295,
17048,
16461,
17069,
2404,
19851,
19918,
4984,
10797,
18717,
15162,
11977,
19003,
15206,
10795,
18013,
18040,
24616,
24675,
2712,
3351,
7169,
11958,
6706,
7170,
11957,
5517,
22896,
22916,
22803,
22913,
22800,
22912,
22801,
22911,
22804,
22910,
18788,
18997,
7767,
7766,
15157,
15068,
2646,
2533,
15161,
15205,
7675,
7674,
15201,
15200,
24451,
24585,
24673,
24449,
21881,
22278,
24448,
23650,
23950,
24450,
24918,
24926,
7815,
22821,
22819,
20295,
20294,
19903,
19885,
16657,
17070,
18923,
19001,
24352,
24255,
18792,
18795,
7778,
7949,
15159,
15202,
2407,
19854,
19919,
2406,
19853,
19920,
10796,
18014,
18041,
20217,
20218,
20593,
20219,
20216,
20585,
23637,
23640,
23660,
6695,
6701,
7951,
6696,
6700,
7950,
22802,
22909,
20701,
20698,
20769,
20700,
20697,
20768,
7904,
7814,
2648,
3383,
8624,
10129,
7782,
7780,
7843,
15163,
15160,
15217,
7777,
6948,
6697,
7952,
6698,
7926,
2175,
3381,
7800,
7772,
21491,
21453,
20702,
20773,
13662,
13664,
19000,
7177,
11539,
11330,
3382,
13298,
7764,
23491,
11624,
11625,
11626,
11627,
5173,
19623,
19625,
19565,
19624,
24672,
24671,
24670,
10130,
25033,
25031,
25034,
11972,
23947,
11974,
23949,
20772,
11971,
23946,
19002,
10131,
24252,
11973,
23948,
24674,
20771,
24242,
9982,
9983,
11649,
23673,
25060,
17679,
17790,
17924,
17913,
17902,
17891,
17880,
17869,
17858,
17779,
17768,
17757,
17746,
17735,
17724,
17713,
20676,
17068,
17015,
25032,
998,
1000,
8419,
8409,
8382,
8372,
19330,
17067,
17702,
17691,
17680,
17835,
17824,
17813,
17802,
17791,
17846,
17857,
17856,
17855,
17854,
17934,
17933,
17932,
17931,
17930,
17929,
17928,
17927,
17926,
17925,
17923,
17922,
17921,
17920,
17919,
17918,
17917,
17916,
17915,
17914,
17912,
17911,
17910,
17909,
17908,
17907,
17906,
17905,
17904,
17903,
17901,
17900,
17899,
17898,
17897,
17896,
17895,
17894,
17893,
17892,
17890,
17889,
17888,
17887,
17886,
17885,
17884,
17883,
17882,
17881,
17879,
17878,
17877,
17876,
17875,
17874,
17873,
17872,
17871,
17870,
17868,
17867,
17866,
17865,
17864,
17863,
17862,
17861,
17860,
17859,
17789,
17788,
17787,
17786,
17785,
17784,
17783,
17782,
17781,
17780,
17778,
17777,
17776,
17775,
17774,
17773,
17772,
17771,
17770,
17769,
17767,
17766,
17765,
17764,
17763,
17762,
17761,
17760,
17759,
17758,
17756,
17755,
17754,
17753,
17752,
17751,
17750,
17749,
17748,
17747,
17745,
17744,
17743,
17742,
17741,
17740,
17739,
17738,
17737,
17736,
17734,
17733,
17732,
17731,
17730,
17729,
17728,
17727,
17726,
17725,
17723,
17722,
17721,
17720,
17719,
17718,
17717,
17716,
17715,
17714,
17712,
17711,
17710,
17709,
17708,
17707,
17706,
17705,
17704,
17703,
17701,
17700,
17699,
17698,
17697,
17696,
17695,
17694,
17693,
17692,
17690,
17689,
17688,
17687,
17686,
17685,
17684,
17683,
17682,
17681,
17845,
17844,
17843,
17842,
17841,
17840,
17839,
17838,
17837,
17836,
17834,
17833,
17832,
17831,
17830,
17829,
17828,
17827,
17826,
17825,
17823,
17822,
17821,
17820,
17819,
17818,
17817,
17816,
17815,
17814,
17812,
17811,
17810,
17809,
17808,
17807,
17806,
17805,
17804,
17803,
17801,
17800,
17799,
17798,
17797,
17796,
17795,
17794,
17793,
17792,
17853,
17852,
17851,
17850,
17849,
17848,
17847,
]

_charnames_983552 = [
23526,
23527,
23521,
23522,
23513,
23514,
23519,
23520,
23516,
23517,
23524,
23523,
11408,
11178,
11384,
11057,
11386,
11059,
11387,
11060,
11395,
11068,
11396,
11069,
11428,
11104,
11099,
11270,
11476,
11160,
11478,
11162,
11479,
11163,
11432,
11046,
11467,
11114,
11406,
11175,
11405,
11174,
11390,
11063,
11389,
11062,
11393,
11066,
11392,
11065,
11098,
11097,
11427,
11102,
11426,
11101,
11534,
11342,
11489,
11193,
11519,
11273,
11445,
11134,
11471,
11121,
11470,
11120,
11468,
11115,
11466,
11113,
11186,
11155,
11156,
11004,
11005,
11043,
11044,
11299,
11300,
13050,
13054,
13051,
13056,
13055,
13053,
13057,
13052,
13058,
17025,
4564,
4553,
4572,
4552,
4561,
4550,
4560,
4549,
4568,
4569,
4566,
4562,
4557,
4567,
4559,
4558,
4563,
4551,
4570,
4556,
4555,
4554,
4571,
4565,
4395,
4400,
4401,
4396,
4397,
4402,
4403,
4394,
4398,
4399,
4393,
4278,
4283,
4284,
4279,
4280,
4285,
4286,
4277,
4281,
4282,
4276,
4538,
4543,
4544,
4539,
4540,
4545,
4546,
4537,
4541,
4542,
4536,
4265,
4270,
4271,
4266,
4267,
4272,
4273,
4264,
4268,
4269,
4263,
4409,
4414,
4415,
4410,
4411,
4416,
4417,
4408,
4412,
4413,
4407,
4252,
4257,
4258,
4253,
4254,
4259,
4260,
4251,
4255,
4256,
4250,
4421,
4426,
4427,
4422,
4423,
4428,
4429,
4420,
4424,
4425,
4419,
4290,
4295,
4296,
4291,
4292,
4297,
4298,
4289,
4293,
4294,
4288,
4486,
4491,
4492,
4487,
4488,
4493,
4494,
4485,
4489,
4490,
4484,
4499,
4504,
4505,
4500,
4501,
4506,
4507,
4498,
4502,
4503,
4497,
4460,
4465,
4466,
4461,
4462,
4467,
4468,
4459,
4463,
4464,
4458,
4447,
4452,
4453,
4448,
4449,
4454,
4455,
4446,
4450,
4451,
4445,
4369,
4374,
4375,
4370,
4371,
4376,
4377,
4368,
4372,
4373,
4367,
4473,
4478,
4479,
4474,
4475,
4480,
4481,
4472,
4476,
4477,
4471,
4345,
4350,
4351,
4346,
4347,
4352,
4353,
4344,
4348,
4349,
4343,
4357,
4362,
4363,
4358,
4359,
4364,
4365,
4356,
4360,
4361,
4355,
4435,
4440,
4441,
4436,
4437,
4442,
4443,
4434,
4438,
4439,
4433,
4240,
4245,
4246,
4241,
4242,
4247,
4248,
4239,
4243,
4244,
4238,
4512,
4517,
4518,
4513,
4514,
4519,
4520,
4511,
4515,
4516,
4510,
4304,
4309,
4310,
4305,
4306,
4311,
4312,
4303,
4307,
4308,
4302,
4318,
4323,
4324,
4319,
4320,
4325,
4326,
4317,
4321,
4322,
4316,
4330,
4335,
4336,
4331,
4332,
4337,
4338,
4329,
4333,
4334,
4328,
4525,
4530,
4531,
4526,
4527,
4532,
4533,
4524,
4528,
4529,
4523,
4380,
4383,
4388,
4389,
4384,
4385,
4390,
4391,
4382,
4386,
4387,
4381,
4313,
6691,
6690,
6689,
22005,
23014,
23012,
23013,
23011,
23007,
23020,
23018,
23019,
23017,
23005,
23035,
22998,
23034,
22997,
23008,
23003,
23001,
23002,
23000,
23006,
23041,
23028,
23029,
23027,
23039,
23036,
23038,
23031,
23037,
23023,
23022,
23024,
23040,
23032,
23050,
23046,
23043,
23044,
23047,
23049,
23051,
19894,
19892,
19890,
19893,
19891,
23499,
23497,
23495,
23498,
23496,
23506,
23503,
23504,
23505,
9380,
9374,
]

def lookup_charcode(code):
    res = -1
    if code == 545: res = 11240
    elif 564 <= code <= 591: res = _charnames_564[code-564]
    elif code == 686: res = 11008
    elif code == 687: res = 11009
    elif 751 <= code <= 767: res = _charnames_751[code-751]
    elif 848 <= code <= 863: res = _charnames_848[code-848]
    elif 880 <= code <= 895: res = _charnames_880[code-880]
    elif code == 975: res = 21722
    elif 1015 <= code <= 1023: res = _charnames_1015[code-1015]
    elif code == 1159: res = 1731
    elif code == 1231: res = 2891
    elif 1270 <= code <= 1279: res = _charnames_1270[code-1270]
    elif 1296 <= code <= 1327: res = _charnames_1296[code-1296]
    elif code == 1376: res = 13125
    elif 1416 <= code <= 1423: res = _charnames_1416[code-1416]
    elif code == 1442: res = 19547
    elif code == 1466: res = 19543
    elif code == 1477: res = 19546
    elif code == 1478: res = 19544
    elif code == 1479: res = 19542
    elif code == 1519: res = 19545
    elif 1536 <= code <= 1568: res = _charnames_1536[code-1536]
    elif code == 1595: res = 12902
    elif code == 1596: res = 12900
    elif code == 1597: res = 12862
    elif code == 1598: res = 12860
    elif code == 1599: res = 12861
    elif 1622 <= code <= 1631: res = _charnames_1622[code-1622]
    elif code == 1774: res = 12950
    elif code == 1775: res = 12892
    elif code == 1791: res = 12929
    elif code == 1837: res = 7763
    elif code == 1838: res = 7761
    elif code == 1839: res = 7762
    elif 1869 <= code <= 1919: res = _charnames_1869[code-1869]
    elif 1984 <= code <= 2154: res = _charnames_1984[code-1984]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2259 <= code <= 2308: res = _charnames_2259[code-2259]
    elif code == 2362: res = 22788
    elif code == 2363: res = 22787
    elif 2382 <= code <= 2391: res = _charnames_2382[code-2382]
    elif 2417 <= code <= 2432: res = _charnames_2417[code-2417]
    elif code == 2493: res = 17029
    elif code == 2510: res = 17026
    elif 2555 <= code <= 2563: res = _charnames_2555[code-2555]
    elif code == 2641: res = 22260
    elif code == 2677: res = 22258
    elif code == 2678: res = 22262
    elif code == 2700: res = 22249
    elif code == 2785: res = 22250
    elif code == 2786: res = 22252
    elif code == 2787: res = 22253
    elif code == 2800: res = 22255
    elif code == 2801: res = 22254
    elif 2809 <= code <= 2815: res = _charnames_2809[code-2809]
    elif code == 2869: res = 21471
    elif code == 2884: res = 21468
    elif code == 2914: res = 21466
    elif code == 2915: res = 21467
    elif 2929 <= code <= 2935: res = _charnames_2929[code-2929]
    elif code == 2998: res = 4583
    elif code == 3024: res = 4580
    elif code == 3046: res = 4575
    elif 3059 <= code <= 3076: res = _charnames_3059[code-3059]
    elif code == 3124: res = 5345
    elif code == 3133: res = 5341
    elif code == 3160: res = 5343
    elif code == 3161: res = 5346
    elif code == 3162: res = 5344
    elif code == 3170: res = 5347
    elif code == 3171: res = 5348
    elif 3192 <= code <= 3204: res = _charnames_3192[code-3192]
    elif code == 3260: res = 23485
    elif code == 3261: res = 23488
    elif code == 3298: res = 23489
    elif code == 3299: res = 23490
    elif code == 3313: res = 23486
    elif code == 3314: res = 23484
    elif code == 3328: res = 9104
    elif code == 3329: res = 9106
    elif code == 3369: res = 9081
    elif 3386 <= code <= 3396: res = _charnames_3386[code-3386]
    elif 3406 <= code <= 3427: res = _charnames_3406[code-3406]
    elif 3440 <= code <= 3455: res = _charnames_3440[code-3440]
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 11622
    elif code == 3807: res = 11621
    elif code == 3947: res = 5190
    elif code == 3948: res = 5189
    elif code == 3980: res = 5187
    elif code == 3981: res = 5183
    elif code == 3982: res = 5182
    elif code == 3983: res = 5184
    elif 4046 <= code <= 4058: res = _charnames_4046[code-4046]
    elif 4130 <= code <= 4139: res = _charnames_4130[code-4130]
    elif 4147 <= code <= 4159: res = _charnames_4147[code-4147]
    elif 4186 <= code <= 4255: res = _charnames_4186[code-4186]
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif 4345 <= code <= 4351: res = _charnames_4345[code-4345]
    elif code == 4442: res = 19724
    elif code == 4443: res = 19714
    elif code == 4444: res = 19716
    elif code == 4445: res = 19715
    elif code == 4446: res = 19698
    elif code == 4515: res = 19676
    elif code == 4516: res = 19660
    elif code == 4517: res = 19659
    elif code == 4518: res = 19663
    elif code == 4519: res = 19664
    elif code == 4602: res = 19616
    elif code == 4603: res = 19615
    elif code == 4604: res = 19619
    elif code == 4605: res = 19617
    elif code == 4606: res = 19618
    elif code == 4607: res = 19568
    elif code == 4615: res = 15047
    elif code == 4679: res = 15011
    elif code == 4743: res = 15001
    elif code == 4783: res = 15021
    elif code == 4815: res = 15043
    elif code == 4847: res = 15042
    elif code == 4879: res = 14921
    elif code == 4895: res = 14919
    elif code == 4935: res = 14979
    elif code == 4957: res = 15065
    elif code == 4958: res = 15066
    elif code == 4959: res = 15064
    elif code == 4960: res = 15048
    elif 4992 <= code <= 5017: res = _charnames_4992[code-4992]
    elif 5109 <= code <= 5120: res = _charnames_5109[code-5109]
    elif 5751 <= code <= 5759: res = _charnames_5751[code-5751]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6109: res = 22993
    elif 6128 <= code <= 6137: res = _charnames_6128[code-6128]
    elif code == 6264: res = 9540
    elif 6314 <= code <= 6389: res = _charnames_6314[code-6314]
    elif 6400 <= code <= 6516: res = _charnames_6400[code-6400]
    elif 6528 <= code <= 6846: res = _charnames_6528[code-6528]
    elif 6912 <= code <= 7155: res = _charnames_6912[code-6912]
    elif 7164 <= code <= 7304: res = _charnames_7164[code-7164]
    elif 7312 <= code <= 7367: res = _charnames_7312[code-7312]
    elif 7376 <= code <= 7679: res = _charnames_7376[code-7376]
    elif code == 7836: res = 11202
    elif code == 7837: res = 11201
    elif code == 7838: res = 11438
    elif code == 7839: res = 11246
    elif code == 7930: res = 11517
    elif code == 7931: res = 11279
    elif code == 7932: res = 11516
    elif code == 7933: res = 11278
    elif code == 7934: res = 11546
    elif code == 7935: res = 11335
    elif 8275 <= code <= 8297: res = _charnames_8275[code-8275]
    elif 8336 <= code <= 8348: res = _charnames_8336[code-8336]
    elif 8370 <= code <= 8383: res = _charnames_8370[code-8370]
    elif code == 8427: res = 1796
    elif code == 8428: res = 1858
    elif code == 8429: res = 1790
    elif code == 8430: res = 1788
    elif code == 8431: res = 1856
    elif code == 8432: res = 1881
    elif code == 8507: res = 24557
    elif code == 8508: res = 22554
    elif 8524 <= code <= 8530: res = _charnames_8524[code-8524]
    elif 8580 <= code <= 8587: res = _charnames_8580[code-8580]
    elif 9167 <= code <= 9215: res = _charnames_9167[code-9167]
    elif code == 9471: res = 18787
    elif code == 9748: res = 24924
    elif code == 9749: res = 19875
    elif code == 9752: res = 7146
    elif code == 9854: res = 20654
    elif code == 9855: res = 24161
    elif 9866 <= code <= 9995: res = _charnames_9866[code-9866]
    elif code == 10024: res = 7846
    elif 10060 <= code <= 10071: res = _charnames_10060[code-10060]
    elif code == 10079: res = 19465
    elif code == 10080: res = 19466
    elif code == 10133: res = 19524
    elif code == 10134: res = 19526
    elif code == 10135: res = 19502
    elif code == 10160: res = 1576
    elif 10175 <= code <= 10191: res = _charnames_10175[code-10175]
    elif code == 10220: res = 9189
    elif code == 10221: res = 9185
    elif code == 10222: res = 9190
    elif code == 10223: res = 9186
    elif 11008 <= code <= 11623: res = _charnames_11008[code-11008]
    elif code == 11631: res = 5167
    elif code == 11632: res = 5166
    elif 11647 <= code <= 11670: res = _charnames_11647[code-11647]
    elif 11680 <= code <= 11854: res = _charnames_11680[code-11680]
    elif code == 12589: res = 16998
    elif code == 12590: res = 16995
    elif code == 12591: res = 16996
    elif 12728 <= code <= 12771: res = _charnames_12728[code-12728]
    elif code == 12829: res = 20212
    elif code == 12830: res = 20213
    elif 12868 <= code <= 12880: res = _charnames_12868[code-12868]
    elif code == 12924: res = 3340
    elif code == 12925: res = 3339
    elif code == 12926: res = 3345
    elif code == 13004: res = 7549
    elif code == 13005: res = 7552
    elif code == 13006: res = 7551
    elif code == 13007: res = 10893
    elif code == 13175: res = 7542
    elif code == 13176: res = 7544
    elif code == 13177: res = 7545
    elif code == 13178: res = 7556
    elif code == 13278: res = 7553
    elif code == 13279: res = 7559
    elif code == 13311: res = 7557
    elif 19904 <= code <= 19967: res = _charnames_19904[code-19904]
    elif 42192 <= code <= 42539: res = _charnames_42192[code-42192]
    elif 42560 <= code <= 42743: res = _charnames_42560[code-42560]
    elif 42752 <= code <= 42937: res = _charnames_42752[code-42752]
    elif 42999 <= code <= 43127: res = _charnames_42999[code-42999]
    elif 43136 <= code <= 43205: res = _charnames_43136[code-43136]
    elif 43214 <= code <= 43347: res = _charnames_43214[code-43214]
    elif 43359 <= code <= 43574: res = _charnames_43359[code-43359]
    elif 43584 <= code <= 43714: res = _charnames_43584[code-43584]
    elif 43739 <= code <= 43766: res = _charnames_43739[code-43739]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 44025: res = _charnames_43888[code-43888]
    elif 55216 <= code <= 55291: res = _charnames_55216[code-55216]
    elif code == 64046: res = 3185
    elif code == 64047: res = 3184
    elif 64107 <= code <= 64217: res = _charnames_64107[code-64107]
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif code == 65021: res = 12978
    elif 65040 <= code <= 65049: res = _charnames_65040[code-65040]
    elif 65060 <= code <= 65071: res = _charnames_65060[code-65060]
    elif code == 65095: res = 20680
    elif code == 65096: res = 20677
    elif 65536 <= code <= 65629: res = _charnames_65536[code-65536]
    elif 65664 <= code <= 65952: res = _charnames_65664[code-65664]
    elif 66000 <= code <= 66045: res = _charnames_66000[code-66000]
    elif 66176 <= code <= 66256: res = _charnames_66176[code-66176]
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 21242
    elif code == 66349: res = 21239
    elif code == 66350: res = 21241
    elif code == 66351: res = 21240
    elif 66384 <= code <= 66517: res = _charnames_66384[code-66384]
    elif code == 66598: res = 22812
    elif code == 66599: res = 22813
    elif 66638 <= code <= 66855: res = _charnames_66638[code-66638]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 2791
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67584 <= code <= 67742: res = _charnames_67584[code-67584]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67903: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68168: res = _charnames_67968[code-67968]
    elif 68176 <= code <= 68184: res = _charnames_68176[code-68176]
    elif 68192 <= code <= 68255: res = _charnames_68192[code-68192]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68352 <= code <= 68497: res = _charnames_68352[code-68352]
    elif code == 68505: res = 20630
    elif code == 68506: res = 20629
    elif code == 68507: res = 20628
    elif code == 68508: res = 20627
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68608 <= code <= 68680: res = _charnames_68608[code-68608]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif 68858 <= code <= 68903: res = _charnames_68858[code-68858]
    elif 68912 <= code <= 68921: res = _charnames_68912[code-68912]
    elif 69216 <= code <= 69246: res = _charnames_69216[code-69216]
    elif 69376 <= code <= 69415: res = _charnames_69376[code-69376]
    elif 69424 <= code <= 69465: res = _charnames_69424[code-69424]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif 69759 <= code <= 69825: res = _charnames_69759[code-69759]
    elif 69837 <= code <= 69864: res = _charnames_69837[code-69837]
    elif 69872 <= code <= 69958: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70750: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71680 <= code <= 71739: res = _charnames_71680[code-71680]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 24063
    elif 72192 <= code <= 72263: res = _charnames_72192[code-72192]
    elif 72272 <= code <= 72354: res = _charnames_72272[code-72272]
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 72960 <= code <= 73031: res = _charnames_72960[code-72960]
    elif 73040 <= code <= 73112: res = _charnames_73040[code-73040]
    elif 73120 <= code <= 73129: res = _charnames_73120[code-73120]
    elif 73440 <= code <= 73464: res = _charnames_73440[code-73440]
    elif 73728 <= code <= 74649: res = _charnames_73728[code-73728]
    elif 74752 <= code <= 74868: res = _charnames_74752[code-74752]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 77824 <= code <= 78894: res = _charnames_77824[code-77824]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93760 <= code <= 93850: res = _charnames_93760[code-93760]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 4229
    elif code == 94177: res = 18472
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif 110592 <= code <= 110878: res = _charnames_110592[code-110592]
    elif 110960 <= code <= 111355: res = _charnames_110960[code-110960]
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif code == 119081: res = 10066
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119296 <= code <= 119365: res = _charnames_119296[code-119296]
    elif 119520 <= code <= 119539: res = _charnames_119520[code-119520]
    elif 119552 <= code <= 119638: res = _charnames_119552[code-119552]
    elif 119648 <= code <= 119672: res = _charnames_119648[code-119648]
    elif code == 120001: res = 9197
    elif code == 120484: res = 9193
    elif code == 120485: res = 9192
    elif code == 120778: res = 9196
    elif code == 120779: res = 9195
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126065 <= code <= 126132: res = _charnames_126065[code-126065]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 12813
    elif code == 126705: res = 12814
    elif 126976 <= code <= 127123: res = _charnames_126976[code-126976]
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif 127232 <= code <= 127404: res = _charnames_127232[code-127232]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127504 <= code <= 127560: res = _charnames_127504[code-127504]
    elif code == 127568: res = 3308
    elif code == 127569: res = 3309
    elif code == 127584: res = 23891
    elif code == 127585: res = 23890
    elif code == 127586: res = 23888
    elif code == 127587: res = 23889
    elif code == 127588: res = 23887
    elif code == 127589: res = 23892
    elif 127744 <= code <= 128724: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128883: res = _charnames_128736[code-128736]
    elif 128896 <= code <= 128984: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129280 <= code <= 129442: res = _charnames_129280[code-129280]
    elif 129456 <= code <= 129474: res = _charnames_129456[code-129456]
    elif 129488 <= code <= 129535: res = _charnames_129488[code-129488]
    elif 129632 <= code <= 129645: res = _charnames_129632[code-129632]
    elif 917760 <= code <= 917999: res = _charnames_917760[code-917760]
    elif 983040 <= code <= 983507: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983993: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError(code)
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'N', 15360),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AL', 'N', 4160),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sc', 'R', 'N', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'N', 4608),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklmnopqrstuvwxwyz{w\x15\x15\x15|}~wwwwwwwwww\x15\x15\x15\x15\x7fwwwwwwwwwww'
'wwww\x15\x15\x80wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww\x15\x15\x81\x82ww\x83\x845555555555555555'
'5555555\x8555\x86wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww5\x87\x88wwwwwwwww\x89www'
'wwwwwwwwwwwwwwww\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91((\x92wwwww\x93wwwwwww\x94\x95ww\x96w\x97w\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2wwwww'
'\xa3\xa45555555\xa5\xa6\xa755555555555555555555555\xa855555\xa955555555555555555\xaa5555'
'5555555555555555555555555555555555\xab55555555555555555555555555555'
'55555555555555555555555555555555555555\xac5555555555555555\xad\xae5555555'
'55555555555555\xaf5555555555555555555555555555\xb0\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xa85\xb2\xb1\xb1\xb1\xb1\xb3'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb3'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'\xb4\xb5wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xb6'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xb6'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd9\x92\x92\x87\xa4\x87\x92\x93\x9cq\x92\xb2\x80g\x81\x80FFFFFFFFFF\x81\x92\xc0\xbf\xc0\x92'
'\x9288888888888888888888888888\x9c\x92q\xacd\xac\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9c\xbfq\xbf\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd6\x8a\xa4\xa4\xa0\xa4\xd1\x8a\xa9\xcf-z\xbf\x07\xcc\xac\xc4\xb4TT\xa9\x1b\x8a\x8c\xa9T-v[[[\x8a'
'77777757777777775777777\xb75777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb7\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xab\xab\xa9\xab)')''')'))\x1f$\xab\xab\xab\xab\xab\xab\xa9\xa9\xa9\xa9\xab\xa9\xab\xa9%%%%%\xab\xab\xab\xab\xab\xab\xab)\xab$\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xab7\x1b\x15\x15#\x1b\x1b\x1b\x907'
'\x15\x15\x15\x15\xab\xab7\x91777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xbc7\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xca@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x89\x89\x89\x89\x89\x89\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89j\x15\x15\xcf\xcf\xa3\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@l@'
'\x96@@\x96@@\x96@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x153333\x96\x97\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xbc\xbc\xae\x86\x86\x9f\x7f{\xcf\xcf@@@@@@@@@@@{\x05\x15{{,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@CCCCCCCCCC\x86||{,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,{,@@@@@@@\x06\xcf@@@@@@\x1e\x1e@@\xcf@@@@,,EEEEEEEEEE,,,\xc3\xc3,'
'{{{{{{{{{{{{{{\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'HHHHHHHHHH333333333333333333333333333333333@@@@@@@@@**\xcf\x90\x90\x90*\x15\x15@\xa6\xa6'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x15'
'3333333333333333333333333@@@\x15\x15\x96\x15,,,,,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15,,,,,,,,\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@\x06@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x89\x89GGGGGGGGGG\x89$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG00\xa3\xa3XXXXXX\xca\xa30\x89@\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG@@000@\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x89\xa3\x15\x15\x15\x15\x15\x15\x150@@@@@@'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG\xca0XXXXXX\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGXXX\xcf\xcf\xcf\xcf\xcf\xcf\xa3\xcf\x15\x15\x15\x15\x15'
'@:::@00000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15]]]]]]]\xca'
'0@::\x8900000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15GGGGGGGGGG\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15000\x1500000000000000000000000000000000000000000@@0::'
':@@@@\x15:::\x15:::@0\xca\x15\x15\x15\x15000:XXXXXXX000@@\x15\x15GGGGGGGGGGXXXXXXXXX\xca000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15::\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa3'
'000000$@@@@@@@@\x89GGGGGGGGGG\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15GGGGGGGGGG\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xca\xca\xca\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\xca\x89\xca\xca\xca@@\xca\xca\xca\xca\xca\xcaGGGGGGGGGGXXXXXXXXXX\xca@\xca@\xca@\x9bp\x9bp::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x89@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xca\xca'
'\xca\xca\xca\xca\xca\xca@\xca\xca\xca\xca\xca\xca\x15\xca\xca\x89\x89\x89\x89\x89\xca\xca\xca\xca\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'GGGGGGGGGG\x89\x89\x89\x89\x89\x89000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:GGGGGGGGGG:::@\xca\xca77777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89$\x1b\x1b\x1b'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x89\x89\x89\x89\x89\x89\x89\x89\x89YYYYYYYYYXXXXXXXXXXX\x15\x15\x15'
'0000000000000000\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'j000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x89\x8900000000000000000'
'\xd800000000000000000000000000\x9bp\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x89\x89\x89KKK00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x89\x89\x89$\x89\x89\x89\xa30@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15]]]]]]]]]]\x15\x15\x15\x15\x15\x15'
'\x90\x90\x90\x90\x90\x90j\x90\x90\x90\x90@@@\x08\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$00000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'00000AA0000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcf\x15\x15\x15\x90\x90GGGGGGGGGG000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15GGGGGGGGGGY\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'00000000000000000000000@@::@\x15\x15\x89\x8900000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89\x89\x89\x89$\x89\x89\x89\x89\x89\x89\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15GGGGGGGGGG\x89\x89\x89\x89\x89\x89\x89\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@@@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00GGGGGGGGGG000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x89\x89\x89\x89\x89'
'GGGGGGGGGG\x15\x15\x15000GGGGGGGGGG000000000000000000000000000000$$$$$$\x89\x89'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x157777777777777777777777777777777777777777777\x15\x15777'
'\x89\x89\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15@@@\x89@@@@@@@@@@@@@:@@@@@@@0000@0000::@00:@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15@@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xab\x1b\xab'
'\xab\xab\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\xab\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xab\xab\xab\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xab\xab\xab\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\x15'
'\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\x08\x08\x08\n\x11ijjiii\x8a\x90xu\x9aywt\x9ay\x8a\x8a\x8a\x90\x8b\x8a\x8a\x8b\xd4\xd5\x0b\x12\x0f\r\x14\xd6\x84\x86\x84\x84\x86\x8a\x90\x90\x90zv\x8a\x90\x90\x8ac'
'c\x90\x90\x90\xaf\x9bp\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xbc\x90c\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xd8\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08V%\x15\x15TVVVVV\xb1\xb1\xbc\x9bp '
'VTTTTVVVVV\xb1\xb1\xbc\x9bp\x15%%%%%%%%%%%%%\x15\x15\x15\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa2\xa3\xa3\xa0\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf7\xcc\xcf\xcc\xcf7\xcf\xcc\x1b777\x1b\x1b777\x19\xcf7\xcc\xcf\xbe77777\xcf\xcf\xcf\xcc\xcc\xcf7\xcf5\xcf7\xcf7577\xc6\x1b7777\x1b0000\x1b\xcf\xcf\x1b\x1b77'
'\xbd\xbc\xbc\xbc\xbc7\x1b\x1b\x1b\x1b\xcf\xbc\xcf\xcf\x1b\xca]]][[]]]]]][[[[]IIIIIIIIIIIILLLLJJJJJJJJJJMMMMMM'
'KKK7\x1bKKKK[\xcf\xcf\x15\x15\x15\x15\xb7\xb7\xb7\xb7\xb7\xcc\xcc\xcc\xcc\xcc\xbc\xbc\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xcf\xcf\xb7\xcf\xb7\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xb7\xbd\xb8\xb8\xbd\xbc\xbc\xb7\xb8\xbd\xbd\xb8\xbd\xbd\xbc\xb7\xbc\xb8\xb1\xb5\xbc\xb8\xbd\xbc\xbc\xbc\xb8\xbd\xbd\xb8\xb7\xb8\xb8\xbd\xbd\xb7\xbd\xb7\xbd\xb7\xb7\xb7\xb7\xb8\xb8\xbd\xb8\xbd\xbd\xbd\xbd\xbd\xb7\xb7\xb7\xb7\xbc\xbd\xbc\xbd\xb8\xb8\xbd\xbd'
