# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TagDescriptionCreateParameters(Model):
    """Parameters supplied to the Create TagDescription operation.

    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing
     the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources
     describing the tag.
    :type external_docs_description: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TagDescriptionCreateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.external_docs_url = kwargs.get('external_docs_url', None)
        self.external_docs_description = kwargs.get('external_docs_description', None)
