# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .dataset_location import DatasetLocation


class AmazonS3Location(DatasetLocation):
    """The location of amazon S3 dataset.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: Required. Type of dataset storage location.
    :type type: str
    :param folder_path: Specify the folder path of dataset. Type: string (or
     Expression with resultType string)
    :type folder_path: object
    :param file_name: Specify the file name of dataset. Type: string (or
     Expression with resultType string).
    :type file_name: object
    :param bucket_name: Specify the bucketName of amazon S3. Type: string (or
     Expression with resultType string)
    :type bucket_name: object
    :param version: Specify the version of amazon S3. Type: string (or
     Expression with resultType string).
    :type version: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_path': {'key': 'folderPath', 'type': 'object'},
        'file_name': {'key': 'fileName', 'type': 'object'},
        'bucket_name': {'key': 'bucketName', 'type': 'object'},
        'version': {'key': 'version', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(AmazonS3Location, self).__init__(**kwargs)
        self.bucket_name = kwargs.get('bucket_name', None)
        self.version = kwargs.get('version', None)
