# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .control_activity import ControlActivity


class FilterActivity(ControlActivity):
    """Filter and return results from input array based on the conditions.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param type: Required. Constant filled by server.
    :type type: str
    :param items: Required. Input array on which filter should be applied.
    :type items: ~azure.mgmt.datafactory.models.Expression
    :param condition: Required. Condition to be used for filtering the input.
    :type condition: ~azure.mgmt.datafactory.models.Expression
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'items': {'required': True},
        'condition': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'type': {'key': 'type', 'type': 'str'},
        'items': {'key': 'typeProperties.items', 'type': 'Expression'},
        'condition': {'key': 'typeProperties.condition', 'type': 'Expression'},
    }

    def __init__(self, **kwargs):
        super(FilterActivity, self).__init__(**kwargs)
        self.items = kwargs.get('items', None)
        self.condition = kwargs.get('condition', None)
        self.type = 'Filter'
