# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MapsAccountsMoveRequest(Model):
    """The description of what resources to move between resource groups.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group: Required. The name of the destination
     resource group.
    :type target_resource_group: str
    :param resource_ids: Required. A list of resource names to move from the
     source resource group.
    :type resource_ids: list[str]
    """

    _validation = {
        'target_resource_group': {'required': True},
        'resource_ids': {'required': True},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resource_ids': {'key': 'resourceIds', 'type': '[str]'},
    }

    def __init__(self, *, target_resource_group: str, resource_ids, **kwargs) -> None:
        super(MapsAccountsMoveRequest, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resource_ids = resource_ids
