# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AgentProperties(msrest.serialization.Model):
    """The properties that determine the run agent configuration.

    :param cpu: The CPU configuration in terms of number of cores required for the run.
    :type cpu: int
    """

    _attribute_map = {
        'cpu': {'key': 'cpu', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AgentProperties, self).__init__(**kwargs)
        self.cpu = kwargs.get('cpu', None)


class Argument(msrest.serialization.Model):
    """The properties of a run argument.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the argument.
    :type name: str
    :param value: Required. The value of the argument.
    :type value: str
    :param is_secret: Flag to indicate whether the argument represents a secret and want to be
     removed from build logs.
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Argument, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']
        self.is_secret = kwargs.get('is_secret', False)


class AuthInfo(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param token_type: Required. The type of Auth token. Possible values include: "PAT", "OAuth".
    :type token_type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TokenType
    :param token: Required. The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid.
    :type expires_in: int
    """

    _validation = {
        'token_type': {'required': True},
        'token': {'required': True},
    }

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthInfo, self).__init__(**kwargs)
        self.token_type = kwargs['token_type']
        self.token = kwargs['token']
        self.refresh_token = kwargs.get('refresh_token', None)
        self.scope = kwargs.get('scope', None)
        self.expires_in = kwargs.get('expires_in', None)


class AuthInfoUpdateParameters(msrest.serialization.Model):
    """The authorization properties for accessing the source code repository.

    :param token_type: The type of Auth token. Possible values include: "PAT", "OAuth".
    :type token_type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TokenType
    :param token: The access token used to access the source control provider.
    :type token: str
    :param refresh_token: The refresh token used to refresh the access token.
    :type refresh_token: str
    :param scope: The scope of the access token.
    :type scope: str
    :param expires_in: Time in seconds that the token remains valid.
    :type expires_in: int
    """

    _attribute_map = {
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'expires_in': {'key': 'expiresIn', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthInfoUpdateParameters, self).__init__(**kwargs)
        self.token_type = kwargs.get('token_type', None)
        self.token = kwargs.get('token', None)
        self.refresh_token = kwargs.get('refresh_token', None)
        self.scope = kwargs.get('scope', None)
        self.expires_in = kwargs.get('expires_in', None)


class BaseImageDependency(msrest.serialization.Model):
    """Properties that describe a base image dependency.

    :param type: The type of the base image dependency. Possible values include: "BuildTime",
     "RunTime".
    :type type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageDependencyType
    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageDependency, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.registry = kwargs.get('registry', None)
        self.repository = kwargs.get('repository', None)
        self.tag = kwargs.get('tag', None)
        self.digest = kwargs.get('digest', None)


class BaseImageTrigger(msrest.serialization.Model):
    """The trigger based on base image dependency.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: Required. The type of the auto trigger for base image
     dependency updates. Possible values include: "All", "Runtime".
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'base_image_trigger_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageTrigger, self).__init__(**kwargs)
        self.base_image_trigger_type = kwargs['base_image_trigger_type']
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class BaseImageTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating base image dependency trigger.

    All required parameters must be populated in order to send to Azure.

    :param base_image_trigger_type: The type of the auto trigger for base image dependency updates.
     Possible values include: "All", "Runtime".
    :type base_image_trigger_type: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageTriggerType
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'base_image_trigger_type': {'key': 'baseImageTriggerType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseImageTriggerUpdateParameters, self).__init__(**kwargs)
        self.base_image_trigger_type = kwargs.get('base_image_trigger_type', None)
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class Credentials(msrest.serialization.Model):
    """The parameters that describes a set of credentials that will be used when a run is invoked.

    :param source_registry: Describes the credential parameters for accessing the source registry.
    :type source_registry:
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceRegistryCredentials
    :param custom_registries: Describes the credential parameters for accessing other custom
     registries. The key
     for the dictionary item will be the registry login server (myregistry.azurecr.io) and
     the value of the item will be the registry credentials for accessing the registry.
    :type custom_registries: dict[str,
     ~azure.mgmt.containerregistry.v2018_09_01.models.CustomRegistryCredentials]
    """

    _attribute_map = {
        'source_registry': {'key': 'sourceRegistry', 'type': 'SourceRegistryCredentials'},
        'custom_registries': {'key': 'customRegistries', 'type': '{CustomRegistryCredentials}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Credentials, self).__init__(**kwargs)
        self.source_registry = kwargs.get('source_registry', None)
        self.custom_registries = kwargs.get('custom_registries', None)


class CustomRegistryCredentials(msrest.serialization.Model):
    """Describes the credentials that will be used to access a custom registry during a run.

    :param user_name: The username for logging into the custom registry.
    :type user_name: ~azure.mgmt.containerregistry.v2018_09_01.models.SecretObject
    :param password: The password for logging into the custom registry. The password is a secret
     object that allows multiple ways of providing the value for it.
    :type password: ~azure.mgmt.containerregistry.v2018_09_01.models.SecretObject
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'SecretObject'},
        'password': {'key': 'password', 'type': 'SecretObject'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomRegistryCredentials, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class RunRequest(msrest.serialization.Model):
    """The request parameters for scheduling a run.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildRequest, EncodedTaskRunRequest, FileTaskRunRequest, TaskRunRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    _subtype_map = {
        'type': {'DockerBuildRequest': 'DockerBuildRequest', 'EncodedTaskRunRequest': 'EncodedTaskRunRequest', 'FileTaskRunRequest': 'FileTaskRunRequest', 'TaskRunRequest': 'TaskRunRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunRequest, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.is_archive_enabled = kwargs.get('is_archive_enabled', False)


class DockerBuildRequest(RunRequest):
    """The parameters for a docker quick build.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the source location.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when executing the run.
    :type arguments: list[~azure.mgmt.containerregistry.v2018_09_01.models.Argument]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2018_09_01.models.Credentials
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'docker_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildRequest, self).__init__(**kwargs)
        self.type = 'DockerBuildRequest'  # type: str
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', True)
        self.no_cache = kwargs.get('no_cache', False)
        self.docker_file_path = kwargs['docker_file_path']
        self.target = kwargs.get('target', None)
        self.arguments = kwargs.get('arguments', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class TaskStepProperties(msrest.serialization.Model):
    """Base properties for any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStep, EncodedTaskStep, FileTaskStep.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'base_image_dependencies': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStep', 'EncodedTask': 'EncodedTaskStep', 'FileTask': 'FileTaskStep'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskStepProperties, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.base_image_dependencies = None
        self.context_path = kwargs.get('context_path', None)
        self.context_access_token = kwargs.get('context_access_token', None)


class DockerBuildStep(TaskStepProperties):
    """The Docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: Required. The Docker file path relative to the source context.
    :type docker_file_path: str
    :param target: The name of the target build stage for the docker build.
    :type target: str
    :param arguments: The collection of override arguments to be used when executing this build
     step.
    :type arguments: list[~azure.mgmt.containerregistry.v2018_09_01.models.Argument]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'docker_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildStep, self).__init__(**kwargs)
        self.type = 'Docker'  # type: str
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', True)
        self.no_cache = kwargs.get('no_cache', False)
        self.docker_file_path = kwargs['docker_file_path']
        self.target = kwargs.get('target', None)
        self.arguments = kwargs.get('arguments', None)


class TaskStepUpdateParameters(msrest.serialization.Model):
    """Base properties for updating any task step.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DockerBuildStepUpdateParameters, EncodedTaskStepUpdateParameters, FileTaskStepUpdateParameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Docker': 'DockerBuildStepUpdateParameters', 'EncodedTask': 'EncodedTaskStepUpdateParameters', 'FileTask': 'FileTaskStepUpdateParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.context_path = kwargs.get('context_path', None)
        self.context_access_token = kwargs.get('context_access_token', None)


class DockerBuildStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating a docker build step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param image_names: The fully qualified image names including the repository and tag.
    :type image_names: list[str]
    :param is_push_enabled: The value of this property indicates whether the image built should be
     pushed to the registry or not.
    :type is_push_enabled: bool
    :param no_cache: The value of this property indicates whether the image cache is enabled or
     not.
    :type no_cache: bool
    :param docker_file_path: The Docker file path relative to the source context.
    :type docker_file_path: str
    :param arguments: The collection of override arguments to be used when executing this build
     step.
    :type arguments: list[~azure.mgmt.containerregistry.v2018_09_01.models.Argument]
    :param target: The name of the target build stage for the docker build.
    :type target: str
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'image_names': {'key': 'imageNames', 'type': '[str]'},
        'is_push_enabled': {'key': 'isPushEnabled', 'type': 'bool'},
        'no_cache': {'key': 'noCache', 'type': 'bool'},
        'docker_file_path': {'key': 'dockerFilePath', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': '[Argument]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DockerBuildStepUpdateParameters, self).__init__(**kwargs)
        self.type = 'Docker'  # type: str
        self.image_names = kwargs.get('image_names', None)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.no_cache = kwargs.get('no_cache', None)
        self.docker_file_path = kwargs.get('docker_file_path', None)
        self.arguments = kwargs.get('arguments', None)
        self.target = kwargs.get('target', None)


class EncodedTaskRunRequest(RunRequest):
    """The parameters for a quick task run request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2018_09_01.models.Credentials
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'encoded_task_content': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskRunRequest, self).__init__(**kwargs)
        self.type = 'EncodedTaskRunRequest'  # type: str
        self.encoded_task_content = kwargs['encoded_task_content']
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class EncodedTaskStep(TaskStepProperties):
    """The properties of a encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param encoded_task_content: Required. Base64 encoded value of the template/definition file
     content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'encoded_task_content': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskStep, self).__init__(**kwargs)
        self.type = 'EncodedTask'  # type: str
        self.encoded_task_content = kwargs['encoded_task_content']
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)


class EncodedTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties for updating encoded task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param encoded_task_content: Base64 encoded value of the template/definition file content.
    :type encoded_task_content: str
    :param encoded_values_content: Base64 encoded value of the parameters/values file content.
    :type encoded_values_content: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'encoded_task_content': {'key': 'encodedTaskContent', 'type': 'str'},
        'encoded_values_content': {'key': 'encodedValuesContent', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncodedTaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = 'EncodedTask'  # type: str
        self.encoded_task_content = kwargs.get('encoded_task_content', None)
        self.encoded_values_content = kwargs.get('encoded_values_content', None)
        self.values = kwargs.get('values', None)


class FileTaskRunRequest(RunRequest):
    """The request parameters for a scheduling run against a task file.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param task_file_path: Required. The template/definition file path relative to the source.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the source.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param platform: Required. The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param source_location: The URL(absolute or relative) of the source context. It can be an URL
     to a tar or git repository.
     If it is relative URL, the relative path should be obtained from calling
     listBuildSourceUploadUrl API.
    :type source_location: str
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2018_09_01.models.Credentials
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'task_file_path': {'required': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
        'platform': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
        'timeout': {'key': 'timeout', 'type': 'int'},
        'platform': {'key': 'platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'agentConfiguration', 'type': 'AgentProperties'},
        'source_location': {'key': 'sourceLocation', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskRunRequest, self).__init__(**kwargs)
        self.type = 'FileTaskRunRequest'  # type: str
        self.task_file_path = kwargs['task_file_path']
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.platform = kwargs['platform']
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_location = kwargs.get('source_location', None)
        self.credentials = kwargs.get('credentials', None)


class FileTaskStep(TaskStepProperties):
    """The properties of a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :ivar base_image_dependencies: List of base image dependencies for a step.
    :vartype base_image_dependencies:
     list[~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageDependency]
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param task_file_path: Required. The task template/definition file path relative to the source
     context.
    :type task_file_path: str
    :param values_file_path: The task values/parameters file path relative to the source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'base_image_dependencies': {'readonly': True},
        'task_file_path': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'base_image_dependencies': {'key': 'baseImageDependencies', 'type': '[BaseImageDependency]'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskStep, self).__init__(**kwargs)
        self.type = 'FileTask'  # type: str
        self.task_file_path = kwargs['task_file_path']
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)


class FileTaskStepUpdateParameters(TaskStepUpdateParameters):
    """The properties of updating a task step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the step.Constant filled by server.  Possible values include:
     "Docker", "FileTask", "EncodedTask".
    :vartype type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.StepType
    :param context_path: The URL(absolute or relative) of the source context for the task step.
    :type context_path: str
    :param context_access_token: The token (git PAT or SAS token of storage account blob)
     associated with the context for a step.
    :type context_access_token: str
    :param task_file_path: The task template/definition file path relative to the source context.
    :type task_file_path: str
    :param values_file_path: The values/parameters file path relative to the source context.
    :type values_file_path: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'context_path': {'key': 'contextPath', 'type': 'str'},
        'context_access_token': {'key': 'contextAccessToken', 'type': 'str'},
        'task_file_path': {'key': 'taskFilePath', 'type': 'str'},
        'values_file_path': {'key': 'valuesFilePath', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileTaskStepUpdateParameters, self).__init__(**kwargs)
        self.type = 'FileTask'  # type: str
        self.task_file_path = kwargs.get('task_file_path', None)
        self.values_file_path = kwargs.get('values_file_path', None)
        self.values = kwargs.get('values', None)


class ImageDescriptor(msrest.serialization.Model):
    """Properties for a registry image.

    :param registry: The registry login server.
    :type registry: str
    :param repository: The repository name.
    :type repository: str
    :param tag: The tag name.
    :type tag: str
    :param digest: The sha256-based digest of the image manifest.
    :type digest: str
    """

    _attribute_map = {
        'registry': {'key': 'registry', 'type': 'str'},
        'repository': {'key': 'repository', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageDescriptor, self).__init__(**kwargs)
        self.registry = kwargs.get('registry', None)
        self.repository = kwargs.get('repository', None)
        self.tag = kwargs.get('tag', None)
        self.digest = kwargs.get('digest', None)


class ImageUpdateTrigger(msrest.serialization.Model):
    """The image update trigger that caused a build.

    :param id: The unique ID of the trigger.
    :type id: str
    :param timestamp: The timestamp when the image update happened.
    :type timestamp: ~datetime.datetime
    :param images: The list of image updates that caused the build.
    :type images: list[~azure.mgmt.containerregistry.v2018_09_01.models.ImageDescriptor]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'images': {'key': 'images', 'type': '[ImageDescriptor]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageUpdateTrigger, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.images = kwargs.get('images', None)


class PlatformProperties(msrest.serialization.Model):
    """The platform properties against which the run has to happen.

    All required parameters must be populated in order to send to Azure.

    :param os: Required. The operating system type required for the run. Possible values include:
     "Windows", "Linux".
    :type os: str or ~azure.mgmt.containerregistry.v2018_09_01.models.OS
    :param architecture: The OS architecture. Possible values include: "amd64", "x86", "arm".
    :type architecture: str or ~azure.mgmt.containerregistry.v2018_09_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :type variant: str or ~azure.mgmt.containerregistry.v2018_09_01.models.Variant
    """

    _validation = {
        'os': {'required': True},
    }

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlatformProperties, self).__init__(**kwargs)
        self.os = kwargs['os']
        self.architecture = kwargs.get('architecture', None)
        self.variant = kwargs.get('variant', None)


class PlatformUpdateParameters(msrest.serialization.Model):
    """The properties for updating the platform configuration.

    :param os: The operating system type required for the run. Possible values include: "Windows",
     "Linux".
    :type os: str or ~azure.mgmt.containerregistry.v2018_09_01.models.OS
    :param architecture: The OS architecture. Possible values include: "amd64", "x86", "arm".
    :type architecture: str or ~azure.mgmt.containerregistry.v2018_09_01.models.Architecture
    :param variant: Variant of the CPU. Possible values include: "v6", "v7", "v8".
    :type variant: str or ~azure.mgmt.containerregistry.v2018_09_01.models.Variant
    """

    _attribute_map = {
        'os': {'key': 'os', 'type': 'str'},
        'architecture': {'key': 'architecture', 'type': 'str'},
        'variant': {'key': 'variant', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PlatformUpdateParameters, self).__init__(**kwargs)
        self.os = kwargs.get('os', None)
        self.architecture = kwargs.get('architecture', None)
        self.variant = kwargs.get('variant', None)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for a ARM proxy resource. It will have everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class Run(ProxyResource):
    """Run resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.RunStatus
    :param last_updated_time: The last updated time for the run.
    :type last_updated_time: ~datetime.datetime
    :param run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :type run_type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.RunType
    :param create_time: The time the run was scheduled.
    :type create_time: ~datetime.datetime
    :param start_time: The time the run started.
    :type start_time: ~datetime.datetime
    :param finish_time: The time the run finished.
    :type finish_time: ~datetime.datetime
    :param output_images: The list of all images that were generated from the run. This is
     applicable if the run generates base image dependencies.
    :type output_images: list[~azure.mgmt.containerregistry.v2018_09_01.models.ImageDescriptor]
    :param task: The task against which run was scheduled.
    :type task: str
    :param image_update_trigger: The image update trigger that caused the run. This is applicable
     if the task has base image trigger configured.
    :type image_update_trigger: ~azure.mgmt.containerregistry.v2018_09_01.models.ImageUpdateTrigger
    :param source_trigger: The source trigger that caused the run.
    :type source_trigger: ~azure.mgmt.containerregistry.v2018_09_01.models.SourceTriggerDescriptor
    :param platform: The platform properties against which the run will happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param source_registry_auth: The scope of the credentials that were used to login to the source
     registry during this run.
    :type source_registry_auth: str
    :param custom_registries: The list of custom registries that were logged in during this run.
    :type custom_registries: list[str]
    :ivar run_error_message: The error message received from backend systems after the run is
     scheduled.
    :vartype run_error_message: str
    :param provisioning_state: The provisioning state of a run. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :type provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.ProvisioningState
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'run_error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'run_id': {'key': 'properties.runId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'run_type': {'key': 'properties.runType', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'properties.finishTime', 'type': 'iso-8601'},
        'output_images': {'key': 'properties.outputImages', 'type': '[ImageDescriptor]'},
        'task': {'key': 'properties.task', 'type': 'str'},
        'image_update_trigger': {'key': 'properties.imageUpdateTrigger', 'type': 'ImageUpdateTrigger'},
        'source_trigger': {'key': 'properties.sourceTrigger', 'type': 'SourceTriggerDescriptor'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'source_registry_auth': {'key': 'properties.sourceRegistryAuth', 'type': 'str'},
        'custom_registries': {'key': 'properties.customRegistries', 'type': '[str]'},
        'run_error_message': {'key': 'properties.runErrorMessage', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_archive_enabled': {'key': 'properties.isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Run, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.status = kwargs.get('status', None)
        self.last_updated_time = kwargs.get('last_updated_time', None)
        self.run_type = kwargs.get('run_type', None)
        self.create_time = kwargs.get('create_time', None)
        self.start_time = kwargs.get('start_time', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.output_images = kwargs.get('output_images', None)
        self.task = kwargs.get('task', None)
        self.image_update_trigger = kwargs.get('image_update_trigger', None)
        self.source_trigger = kwargs.get('source_trigger', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.source_registry_auth = kwargs.get('source_registry_auth', None)
        self.custom_registries = kwargs.get('custom_registries', None)
        self.run_error_message = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', False)


class RunFilter(msrest.serialization.Model):
    """Properties that are enabled for Odata querying on runs.

    :param run_id: The unique identifier for the run.
    :type run_id: str
    :param run_type: The type of run. Possible values include: "QuickBuild", "QuickRun",
     "AutoBuild", "AutoRun".
    :type run_type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.RunType
    :param status: The current status of the run. Possible values include: "Queued", "Started",
     "Running", "Succeeded", "Failed", "Canceled", "Error", "Timeout".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.RunStatus
    :param create_time: The create time for a run.
    :type create_time: ~datetime.datetime
    :param finish_time: The time the run finished.
    :type finish_time: ~datetime.datetime
    :param output_image_manifests: The list of comma-separated image manifests that were generated
     from the run. This is applicable if the run is of
     build type.
    :type output_image_manifests: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    :param task_name: The name of the task that the run corresponds to.
    :type task_name: str
    """

    _attribute_map = {
        'run_id': {'key': 'runId', 'type': 'str'},
        'run_type': {'key': 'runType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
        'finish_time': {'key': 'finishTime', 'type': 'iso-8601'},
        'output_image_manifests': {'key': 'outputImageManifests', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunFilter, self).__init__(**kwargs)
        self.run_id = kwargs.get('run_id', None)
        self.run_type = kwargs.get('run_type', None)
        self.status = kwargs.get('status', None)
        self.create_time = kwargs.get('create_time', None)
        self.finish_time = kwargs.get('finish_time', None)
        self.output_image_manifests = kwargs.get('output_image_manifests', None)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', None)
        self.task_name = kwargs.get('task_name', None)


class RunGetLogResult(msrest.serialization.Model):
    """The result of get log link operation.

    :param log_link: The link to logs for a run on a azure container registry.
    :type log_link: str
    """

    _attribute_map = {
        'log_link': {'key': 'logLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunGetLogResult, self).__init__(**kwargs)
        self.log_link = kwargs.get('log_link', None)


class RunListResult(msrest.serialization.Model):
    """Collection of runs.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_09_01.models.Run]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Run]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RunUpdateParameters(msrest.serialization.Model):
    """The set of run properties that can be updated.

    :param is_archive_enabled: The value that indicates whether archiving is enabled or not.
    :type is_archive_enabled: bool
    """

    _attribute_map = {
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RunUpdateParameters, self).__init__(**kwargs)
        self.is_archive_enabled = kwargs.get('is_archive_enabled', None)


class SecretObject(msrest.serialization.Model):
    """Describes the properties of a secret object value.

    :param value: The value of the secret. The format of this value will be determined
     based on the type of the secret object. If the type is Opaque, the value will be
     used as is without any modification.
    :type value: str
    :param type: The type of the secret object which determines how the value of the secret object
     has to be
     interpreted. Possible values include: "Opaque".
    :type type: str or ~azure.mgmt.containerregistry.v2018_09_01.models.SecretObjectType
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretObject, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.type = kwargs.get('type', None)


class SetValue(msrest.serialization.Model):
    """The properties of a overridable value that can be passed to a task template.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the overridable value.
    :type name: str
    :param value: Required. The overridable value.
    :type value: str
    :param is_secret: Flag to indicate whether the value represents a secret or not.
    :type is_secret: bool
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'is_secret': {'key': 'isSecret', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SetValue, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']
        self.is_secret = kwargs.get('is_secret', False)


class SourceProperties(msrest.serialization.Model):
    """The properties of the source code repository.

    All required parameters must be populated in order to send to Azure.

    :param source_control_type: Required. The type of source control service. Possible values
     include: "Github", "VisualStudioTeamService".
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceControlType
    :param repository_url: Required. The full URL to the source code repository.
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties: ~azure.mgmt.containerregistry.v2018_09_01.models.AuthInfo
    """

    _validation = {
        'source_control_type': {'required': True},
        'repository_url': {'required': True},
    }

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceProperties, self).__init__(**kwargs)
        self.source_control_type = kwargs['source_control_type']
        self.repository_url = kwargs['repository_url']
        self.branch = kwargs.get('branch', None)
        self.source_control_auth_properties = kwargs.get('source_control_auth_properties', None)


class SourceRegistryCredentials(msrest.serialization.Model):
    """Describes the credential parameters for accessing the source registry.

    :param login_mode: The authentication mode which determines the source registry login scope.
     The credentials for the source registry
     will be generated using the given scope. These credentials will be used to login to
     the source registry during the run. Possible values include: "None", "Default".
    :type login_mode: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceRegistryLoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceRegistryCredentials, self).__init__(**kwargs)
        self.login_mode = kwargs.get('login_mode', None)


class SourceTrigger(msrest.serialization.Model):
    """The properties of a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: Required. The properties that describes the source(code) for the
     task.
    :type source_repository: ~azure.mgmt.containerregistry.v2018_09_01.models.SourceProperties
    :param source_trigger_events: Required. The source event corresponding to the trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'source_repository': {'required': True},
        'source_trigger_events': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceProperties'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTrigger, self).__init__(**kwargs)
        self.source_repository = kwargs['source_repository']
        self.source_trigger_events = kwargs['source_trigger_events']
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class SourceTriggerDescriptor(msrest.serialization.Model):
    """The source trigger that caused a run.

    :param id: The unique ID of the trigger.
    :type id: str
    :param event_type: The event type of the trigger.
    :type event_type: str
    :param commit_id: The unique ID that identifies a commit.
    :type commit_id: str
    :param pull_request_id: The unique ID that identifies pull request.
    :type pull_request_id: str
    :param repository_url: The repository URL.
    :type repository_url: str
    :param branch_name: The branch name in the repository.
    :type branch_name: str
    :param provider_type: The source control provider type.
    :type provider_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'commit_id': {'key': 'commitId', 'type': 'str'},
        'pull_request_id': {'key': 'pullRequestId', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch_name': {'key': 'branchName', 'type': 'str'},
        'provider_type': {'key': 'providerType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTriggerDescriptor, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.event_type = kwargs.get('event_type', None)
        self.commit_id = kwargs.get('commit_id', None)
        self.pull_request_id = kwargs.get('pull_request_id', None)
        self.repository_url = kwargs.get('repository_url', None)
        self.branch_name = kwargs.get('branch_name', None)
        self.provider_type = kwargs.get('provider_type', None)


class SourceTriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating a source based trigger.

    All required parameters must be populated in order to send to Azure.

    :param source_repository: The properties that describes the source(code) for the task.
    :type source_repository:
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceUpdateParameters
    :param source_trigger_events: The source event corresponding to the trigger.
    :type source_trigger_events: list[str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceTriggerEvent]
    :param status: The current status of trigger. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerStatus
    :param name: Required. The name of the trigger.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'source_repository': {'key': 'sourceRepository', 'type': 'SourceUpdateParameters'},
        'source_trigger_events': {'key': 'sourceTriggerEvents', 'type': '[str]'},
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceTriggerUpdateParameters, self).__init__(**kwargs)
        self.source_repository = kwargs.get('source_repository', None)
        self.source_trigger_events = kwargs.get('source_trigger_events', None)
        self.status = kwargs.get('status', None)
        self.name = kwargs['name']


class SourceUpdateParameters(msrest.serialization.Model):
    """The properties for updating the source code repository.

    :param source_control_type: The type of source control service. Possible values include:
     "Github", "VisualStudioTeamService".
    :type source_control_type: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.SourceControlType
    :param repository_url: The full URL to the source code repository.
    :type repository_url: str
    :param branch: The branch name of the source code.
    :type branch: str
    :param source_control_auth_properties: The authorization properties for accessing the source
     code repository and to set up
     webhooks for notifications.
    :type source_control_auth_properties:
     ~azure.mgmt.containerregistry.v2018_09_01.models.AuthInfoUpdateParameters
    """

    _attribute_map = {
        'source_control_type': {'key': 'sourceControlType', 'type': 'str'},
        'repository_url': {'key': 'repositoryUrl', 'type': 'str'},
        'branch': {'key': 'branch', 'type': 'str'},
        'source_control_auth_properties': {'key': 'sourceControlAuthProperties', 'type': 'AuthInfoUpdateParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceUpdateParameters, self).__init__(**kwargs)
        self.source_control_type = kwargs.get('source_control_type', None)
        self.repository_url = kwargs.get('repository_url', None)
        self.branch = kwargs.get('branch', None)
        self.source_control_auth_properties = kwargs.get('source_control_auth_properties', None)


class SourceUploadDefinition(msrest.serialization.Model):
    """The properties of a response to source upload request.

    :param upload_url: The URL where the client can upload the source.
    :type upload_url: str
    :param relative_path: The relative path to the source. This is used to submit the subsequent
     queue build request.
    :type relative_path: str
    """

    _attribute_map = {
        'upload_url': {'key': 'uploadUrl', 'type': 'str'},
        'relative_path': {'key': 'relativePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceUploadDefinition, self).__init__(**kwargs)
        self.upload_url = kwargs.get('upload_url', None)
        self.relative_path = kwargs.get('relative_path', None)


class Task(Resource):
    """The task that has the ARM resource and task properties. 
The task will have all information to schedule a run against it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the task. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2018_09_01.models.ProvisioningState
    :ivar creation_date: The creation date of task.
    :vartype creation_date: ~datetime.datetime
    :param status: The current status of task. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TaskStatus
    :param platform: The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformProperties
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param step: The properties of a task step.
    :type step: ~azure.mgmt.containerregistry.v2018_09_01.models.TaskStepProperties
    :param trigger: The properties that describe all triggers for the task.
    :type trigger: ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerProperties
    :param credentials: The properties that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2018_09_01.models.Credentials
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'creation_date': {'readonly': True},
        'timeout': {'maximum': 28800, 'minimum': 300},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformProperties'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepProperties'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Task, self).__init__(**kwargs)
        self.provisioning_state = None
        self.creation_date = None
        self.status = kwargs.get('status', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.timeout = kwargs.get('timeout', 3600)
        self.step = kwargs.get('step', None)
        self.trigger = kwargs.get('trigger', None)
        self.credentials = kwargs.get('credentials', None)


class TaskListResult(msrest.serialization.Model):
    """The collection of tasks.

    :param value: The collection value.
    :type value: list[~azure.mgmt.containerregistry.v2018_09_01.models.Task]
    :param next_link: The URI that can be used to request the next set of paged results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Task]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TaskRunRequest(RunRequest):
    """The parameters for a task run request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The type of the run request.Constant filled by server.
    :vartype type: str
    :param is_archive_enabled: The value that indicates whether archiving is enabled for the run or
     not.
    :type is_archive_enabled: bool
    :param task_name: Required. The name of task against which run has to be queued.
    :type task_name: str
    :param values: The collection of overridable values that can be passed when running a task.
    :type values: list[~azure.mgmt.containerregistry.v2018_09_01.models.SetValue]
    """

    _validation = {
        'type': {'required': True, 'readonly': True},
        'task_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'is_archive_enabled': {'key': 'isArchiveEnabled', 'type': 'bool'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'values': {'key': 'values', 'type': '[SetValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskRunRequest, self).__init__(**kwargs)
        self.type = 'TaskRunRequest'  # type: str
        self.task_name = kwargs['task_name']
        self.values = kwargs.get('values', None)


class TaskUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a task.

    :param tags: A set of tags. The ARM resource tags.
    :type tags: dict[str, str]
    :param status: The current status of task. Possible values include: "Disabled", "Enabled".
    :type status: str or ~azure.mgmt.containerregistry.v2018_09_01.models.TaskStatus
    :param platform: The platform properties against which the run has to happen.
    :type platform: ~azure.mgmt.containerregistry.v2018_09_01.models.PlatformUpdateParameters
    :param agent_configuration: The machine configuration of the run agent.
    :type agent_configuration: ~azure.mgmt.containerregistry.v2018_09_01.models.AgentProperties
    :param timeout: Run timeout in seconds.
    :type timeout: int
    :param step: The properties for updating a task step.
    :type step: ~azure.mgmt.containerregistry.v2018_09_01.models.TaskStepUpdateParameters
    :param trigger: The properties for updating trigger properties.
    :type trigger: ~azure.mgmt.containerregistry.v2018_09_01.models.TriggerUpdateParameters
    :param credentials: The parameters that describes a set of credentials that will be used when
     this run is invoked.
    :type credentials: ~azure.mgmt.containerregistry.v2018_09_01.models.Credentials
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'PlatformUpdateParameters'},
        'agent_configuration': {'key': 'properties.agentConfiguration', 'type': 'AgentProperties'},
        'timeout': {'key': 'properties.timeout', 'type': 'int'},
        'step': {'key': 'properties.step', 'type': 'TaskStepUpdateParameters'},
        'trigger': {'key': 'properties.trigger', 'type': 'TriggerUpdateParameters'},
        'credentials': {'key': 'properties.credentials', 'type': 'Credentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaskUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.status = kwargs.get('status', None)
        self.platform = kwargs.get('platform', None)
        self.agent_configuration = kwargs.get('agent_configuration', None)
        self.timeout = kwargs.get('timeout', None)
        self.step = kwargs.get('step', None)
        self.trigger = kwargs.get('trigger', None)
        self.credentials = kwargs.get('credentials', None)


class TriggerProperties(msrest.serialization.Model):
    """The properties of a trigger.

    :param source_triggers: The collection of triggers based on source code repository.
    :type source_triggers: list[~azure.mgmt.containerregistry.v2018_09_01.models.SourceTrigger]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger: ~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageTrigger
    """

    _attribute_map = {
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTrigger]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTrigger'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerProperties, self).__init__(**kwargs)
        self.source_triggers = kwargs.get('source_triggers', None)
        self.base_image_trigger = kwargs.get('base_image_trigger', None)


class TriggerUpdateParameters(msrest.serialization.Model):
    """The properties for updating triggers.

    :param source_triggers: The collection of triggers based on source code repository.
    :type source_triggers:
     list[~azure.mgmt.containerregistry.v2018_09_01.models.SourceTriggerUpdateParameters]
    :param base_image_trigger: The trigger based on base image dependencies.
    :type base_image_trigger:
     ~azure.mgmt.containerregistry.v2018_09_01.models.BaseImageTriggerUpdateParameters
    """

    _attribute_map = {
        'source_triggers': {'key': 'sourceTriggers', 'type': '[SourceTriggerUpdateParameters]'},
        'base_image_trigger': {'key': 'baseImageTrigger', 'type': 'BaseImageTriggerUpdateParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerUpdateParameters, self).__init__(**kwargs)
        self.source_triggers = kwargs.get('source_triggers', None)
        self.base_image_trigger = kwargs.get('base_image_trigger', None)
