# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class AzureBareMetalInstance(TrackedResource):
    """AzureBareMetal instance info on Azure (ARM properties and AzureBareMetal properties).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~bare_metal_infrastructure_client.models.SystemData
    :param hardware_profile: Specifies the hardware settings for the AzureBareMetal instance.
    :type hardware_profile: ~bare_metal_infrastructure_client.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the AzureBareMetal instance disks.
    :type storage_profile: ~bare_metal_infrastructure_client.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the AzureBareMetal instance.
    :type os_profile: ~bare_metal_infrastructure_client.models.OSProfile
    :param network_profile: Specifies the network settings for the AzureBareMetal instance.
    :type network_profile: ~bare_metal_infrastructure_client.models.NetworkProfile
    :ivar azure_bare_metal_instance_id: Specifies the AzureBareMetal instance unique ID.
    :vartype azure_bare_metal_instance_id: str
    :ivar power_state: Resource power state. Possible values include: "starting", "started",
     "stopping", "stopped", "restarting", "unknown".
    :vartype power_state: str or
     ~bare_metal_infrastructure_client.models.AzureBareMetalInstancePowerStateEnum
    :ivar proximity_placement_group: Resource proximity placement group.
    :vartype proximity_placement_group: str
    :ivar hw_revision: Hardware revision of an AzureBareMetal instance.
    :vartype hw_revision: str
    :param partner_node_id: ARM ID of another AzureBareMetalInstance that will share a network with
     this AzureBareMetalInstance.
    :type partner_node_id: str
    :ivar provisioning_state: State of provisioning of the AzureBareMetalInstance. Possible values
     include: "Accepted", "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~bare_metal_infrastructure_client.models.AzureBareMetalProvisioningStatesEnum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'azure_bare_metal_instance_id': {'readonly': True},
        'power_state': {'readonly': True},
        'proximity_placement_group': {'readonly': True},
        'hw_revision': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'azure_bare_metal_instance_id': {'key': 'properties.azureBareMetalInstanceId', 'type': 'str'},
        'power_state': {'key': 'properties.powerState', 'type': 'str'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'str'},
        'hw_revision': {'key': 'properties.hwRevision', 'type': 'str'},
        'partner_node_id': {'key': 'properties.partnerNodeId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBareMetalInstance, self).__init__(**kwargs)
        self.system_data = None
        self.hardware_profile = kwargs.get('hardware_profile', None)
        self.storage_profile = kwargs.get('storage_profile', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.network_profile = kwargs.get('network_profile', None)
        self.azure_bare_metal_instance_id = None
        self.power_state = None
        self.proximity_placement_group = None
        self.hw_revision = None
        self.partner_node_id = kwargs.get('partner_node_id', None)
        self.provisioning_state = None


class AzureBareMetalInstancesListResult(msrest.serialization.Model):
    """The response from the List AzureBareMetal Instances operation.

    :param value: The list of Azure BareMetal instances.
    :type value: list[~bare_metal_infrastructure_client.models.AzureBareMetalInstance]
    :param next_link: The URL to get the next set of AzureBareMetal instances.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AzureBareMetalInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBareMetalInstancesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Disk(msrest.serialization.Model):
    """Specifies the disk information fo the AzureBareMetal instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The disk name.
    :type name: str
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes.
    :type disk_size_gb: int
    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        'lun': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Disk, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.lun = None


class Display(msrest.serialization.Model):
    """Detailed BareMetal operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation as shown to the user.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation as shown to the user.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Display, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~bare_metal_infrastructure_client.models.ErrorDefinition]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: The error details.
    :type error: ~bare_metal_infrastructure_client.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class HardwareProfile(msrest.serialization.Model):
    """Specifies the hardware settings for the AzureBareMetal instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hardware_type: Name of the hardware type (vendor and/or their product name). Possible
     values include: "Cisco_UCS", "HPE".
    :vartype hardware_type: str or
     ~bare_metal_infrastructure_client.models.AzureBareMetalHardwareTypeNamesEnum
    :ivar azure_bare_metal_instance_size: Specifies the AzureBareMetal instance SKU. Possible
     values include: "S72m", "S144m", "S72", "S144", "S192", "S192m", "S192xm", "S96", "S112",
     "S224", "S224m", "S224om", "S224oo", "S224oom", "S224ooo", "S384", "S384m", "S384xm",
     "S384xxm", "S448", "S448m", "S448om", "S448oo", "S448oom", "S448ooo", "S576m", "S576xm",
     "S672", "S672m", "S672om", "S672oo", "S672oom", "S672ooo", "S768", "S768m", "S768xm", "S896",
     "S896m", "S896om", "S896oo", "S896oom", "S896ooo", "S960m".
    :vartype azure_bare_metal_instance_size: str or
     ~bare_metal_infrastructure_client.models.AzureBareMetalInstanceSizeNamesEnum
    """

    _validation = {
        'hardware_type': {'readonly': True},
        'azure_bare_metal_instance_size': {'readonly': True},
    }

    _attribute_map = {
        'hardware_type': {'key': 'hardwareType', 'type': 'str'},
        'azure_bare_metal_instance_size': {'key': 'azureBareMetalInstanceSize', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.hardware_type = None
        self.azure_bare_metal_instance_size = None


class IpAddress(msrest.serialization.Model):
    """Specifies the IP address of the network interface.

    :param ip_address: Specifies the IP address of the network interface.
    :type ip_address: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpAddress, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)


class NetworkProfile(msrest.serialization.Model):
    """Specifies the network settings for the AzureBareMetal instance disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param network_interfaces: Specifies the network interfaces for the AzureBareMetal instance.
    :type network_interfaces: list[~bare_metal_infrastructure_client.models.IpAddress]
    :ivar circuit_id: Specifies the circuit id for connecting to express route.
    :vartype circuit_id: str
    """

    _validation = {
        'circuit_id': {'readonly': True},
    }

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[IpAddress]'},
        'circuit_id': {'key': 'circuitId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = kwargs.get('network_interfaces', None)
        self.circuit_id = None


class Operation(msrest.serialization.Model):
    """AzureBareMetal operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object. This name
     should match the action name that appears in RBAC / the event service.
    :vartype name: str
    :param display: Displayed AzureBareMetal operation information.
    :type display: ~bare_metal_infrastructure_client.models.Display
    :ivar is_data_action: indicates whether an operation is a data action or not.
    :vartype is_data_action: bool
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'Display'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)
        self.is_data_action = None


class OperationList(msrest.serialization.Model):
    """List of AzureBareMetal operations.

    :param value: List of AzureBareMetal operations.
    :type value: list[~bare_metal_infrastructure_client.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class OSProfile(msrest.serialization.Model):
    """Specifies the operating system settings for the AzureBareMetal instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param computer_name: Specifies the host OS name of the AzureBareMetal instance.
    :type computer_name: str
    :ivar os_type: This property allows you to specify the type of the OS.
    :vartype os_type: str
    :ivar version: Specifies version of operating system.
    :vartype version: str
    :param ssh_public_key: Specifies the SSH public key used to access the operating system.
    :type ssh_public_key: str
    """

    _validation = {
        'os_type': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'ssh_public_key': {'key': 'sshPublicKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = kwargs.get('computer_name', None)
        self.os_type = None
        self.version = None
        self.ssh_public_key = kwargs.get('ssh_public_key', None)


class Result(msrest.serialization.Model):
    """Sample result definition.

    :param sample_property: Sample property of type string.
    :type sample_property: str
    """

    _attribute_map = {
        'sample_property': {'key': 'sampleProperty', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Result, self).__init__(**kwargs)
        self.sample_property = kwargs.get('sample_property', None)


class StorageProfile(msrest.serialization.Model):
    """Specifies the storage settings for the AzureBareMetal instance disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar nfs_ip_address: IP Address to connect to storage.
    :vartype nfs_ip_address: str
    :param os_disks: Specifies information about the operating system disk used by baremetal
     instance.
    :type os_disks: list[~bare_metal_infrastructure_client.models.Disk]
    """

    _validation = {
        'nfs_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'nfs_ip_address': {'key': 'nfsIpAddress', 'type': 'str'},
        'os_disks': {'key': 'osDisks', 'type': '[Disk]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.nfs_ip_address = None
        self.os_disks = kwargs.get('os_disks', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~bare_metal_infrastructure_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~bare_metal_infrastructure_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Tags(msrest.serialization.Model):
    """Tags field of the AzureBareMetal instance.

    :param tags: A set of tags. Tags field of the AzureBareMetal instance.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Tags, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
