# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNetworkVirtualApplianceConnectionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_virtual_appliance_connections_begin_create_or_update(self, resource_group):
        response = self.client.network_virtual_appliance_connections.begin_create_or_update(
            resource_group_name=resource_group.name,
            network_virtual_appliance_name="str",
            connection_name="str",
            network_virtual_appliance_connection_parameters={
                "asn": 0,
                "bgpPeerAddress": ["str"],
                "enableInternetSecurity": bool,
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "routingConfiguration": {
                    "associatedRouteTable": {"id": "str"},
                    "inboundRouteMap": {"id": "str"},
                    "outboundRouteMap": {"id": "str"},
                    "propagatedRouteTables": {"ids": [{"id": "str"}], "labels": ["str"]},
                    "vnetRoutes": {
                        "bgpConnections": [{"id": "str"}],
                        "staticRoutes": [{"addressPrefixes": ["str"], "name": "str", "nextHopIpAddress": "str"}],
                        "staticRoutesConfig": {"propagateStaticRoutes": bool, "vnetLocalRouteOverrideCriteria": "str"},
                    },
                },
                "tunnelIdentifier": 0,
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_virtual_appliance_connections_get(self, resource_group):
        response = self.client.network_virtual_appliance_connections.get(
            resource_group_name=resource_group.name,
            network_virtual_appliance_name="str",
            connection_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_virtual_appliance_connections_begin_delete(self, resource_group):
        response = self.client.network_virtual_appliance_connections.begin_delete(
            resource_group_name=resource_group.name,
            network_virtual_appliance_name="str",
            connection_name="str",
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_virtual_appliance_connections_list(self, resource_group):
        response = self.client.network_virtual_appliance_connections.list(
            resource_group_name=resource_group.name,
            network_virtual_appliance_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
