# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .answer_span_request_dto import AnswerSpanRequestDTO


class QueryDTOAnswerSpanRequest(AnswerSpanRequestDTO):
    """To configure Answer span prediction feature.

    :param enable: Enable or Disable Answer Span prediction.
    :type enable: bool
    :param score_threshold: Minimum threshold score required to include an
     answer span.
    :type score_threshold: float
    :param top_answers_with_span: Number of Top answers to be considered for
     span prediction.
    :type top_answers_with_span: int
    """

    _validation = {
        'top_answers_with_span': {'maximum': 10, 'minimum': 1},
    }

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'score_threshold': {'key': 'scoreThreshold', 'type': 'float'},
        'top_answers_with_span': {'key': 'topAnswersWithSpan', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(QueryDTOAnswerSpanRequest, self).__init__(**kwargs)
