# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.automation.aio import AutomationClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAutomationSoftwareUpdateConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AutomationClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_create(self, resource_group):
        response = await self.client.software_update_configurations.create(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            software_update_configuration_name="str",
            parameters={
                "scheduleInfo": {
                    "advancedSchedule": {
                        "monthDays": [0],
                        "monthlyOccurrences": [{"day": "str", "occurrence": 0}],
                        "weekDays": ["str"],
                    },
                    "creationTime": "2020-02-20 00:00:00",
                    "description": "str",
                    "expiryTime": "2020-02-20 00:00:00",
                    "expiryTimeOffsetMinutes": 0.0,
                    "frequency": "str",
                    "interval": 0,
                    "isEnabled": False,
                    "lastModifiedTime": "2020-02-20 00:00:00",
                    "nextRun": "2020-02-20 00:00:00",
                    "nextRunOffsetMinutes": 0.0,
                    "startTime": "2020-02-20 00:00:00",
                    "startTimeOffsetMinutes": 0.0,
                    "timeZone": "str",
                },
                "updateConfiguration": {
                    "operatingSystem": "str",
                    "azureVirtualMachines": ["str"],
                    "duration": "1 day, 0:00:00",
                    "linux": {
                        "excludedPackageNameMasks": ["str"],
                        "includedPackageClassifications": "str",
                        "includedPackageNameMasks": ["str"],
                        "rebootSetting": "str",
                    },
                    "nonAzureComputerNames": ["str"],
                    "targets": {
                        "azureQueries": [
                            {
                                "locations": ["str"],
                                "scope": ["str"],
                                "tagSettings": {"filterOperator": "str", "tags": {"str": ["str"]}},
                            }
                        ],
                        "nonAzureQueries": [{"functionAlias": "str", "workspaceId": "str"}],
                    },
                    "windows": {
                        "excludedKbNumbers": ["str"],
                        "includedKbNumbers": ["str"],
                        "includedUpdateClassifications": "str",
                        "rebootSetting": "str",
                    },
                },
                "createdBy": "str",
                "creationTime": "2020-02-20 00:00:00",
                "error": {"code": "str", "message": "str"},
                "id": "str",
                "lastModifiedBy": "str",
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "provisioningState": "str",
                "tasks": {
                    "postTask": {"parameters": {"str": "str"}, "source": "str"},
                    "preTask": {"parameters": {"str": "str"}, "source": "str"},
                },
                "type": "str",
            },
            api_version="2019-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_name(self, resource_group):
        response = await self.client.software_update_configurations.get_by_name(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            software_update_configuration_name="str",
            api_version="2019-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.software_update_configurations.delete(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            software_update_configuration_name="str",
            api_version="2019-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = await self.client.software_update_configurations.list(
            resource_group_name=resource_group.name,
            automation_account_name="str",
            api_version="2019-06-01",
        )

        # please add some check logic here by yourself
        # ...
