
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkOCC_SelectableObject.hxx>
#include <IVtkOCC_Shape.hxx>
#include <IVtkOCC_ShapeMesher.hxx>
#include <IVtkOCC_ShapePickerAlgo.hxx>
#include <IVtkOCC_ViewerSelector.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IVtkOCC_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IVtkOCC", R"#()#");

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<IVtkOCC_SelectableObject ,opencascade::handle<IVtkOCC_SelectableObject>  , SelectMgr_SelectableObject >(m,"IVtkOCC_SelectableObject",R"#(Class with selection primitives used by OCCT selection algorithm.Class with selection primitives used by OCCT selection algorithm.Class with selection primitives used by OCCT selection algorithm.)#");
    py::class_<IVtkOCC_Shape ,opencascade::handle<IVtkOCC_Shape>  , IVtk_IShape >(m,"IVtkOCC_Shape",R"#(OCC implementation of IShape interface.OCC implementation of IShape interface.OCC implementation of IShape interface.)#");
    py::class_<IVtkOCC_ShapeMesher ,opencascade::handle<IVtkOCC_ShapeMesher>  , IVtk_IShapeMesher >(m,"IVtkOCC_ShapeMesher",R"#(OCC implementation of IMesher interface.OCC implementation of IMesher interface.OCC implementation of IMesher interface.)#");
    py::class_<IVtkOCC_ShapePickerAlgo ,opencascade::handle<IVtkOCC_ShapePickerAlgo>  >(m,"IVtkOCC_ShapePickerAlgo",R"#(OCC implementation of 3D shapes picking algorithm.OCC implementation of 3D shapes picking algorithm.OCC implementation of 3D shapes picking algorithm.)#");
    py::class_<IVtkOCC_ViewerSelector ,opencascade::handle<IVtkOCC_ViewerSelector>  , SelectMgr_ViewerSelector >(m,"IVtkOCC_ViewerSelector",R"#(Class that implements OCCT selection algorithm.Class that implements OCCT selection algorithm.)#");
    preregister_template_NCollection_List<IVtk_Polyline>(m,"IVtk_PolylineList");
    preregister_template_NCollection_DataMap<TopoDS_Shape, IVtk_MeshType, TopTools_ShapeMapHasher>(m,"IVtk_ShapeTypeMap");

};

// user-defined post-inclusion per module

// user-defined post
