/***************************************************************************
 *   Copyright (C) 2007-2014 by Vegeta                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Preferences.h"
#include "QtGain.h"

#include <QFileDialog>


Preferences::Preferences(QWidget *parent) : QDialog(parent){
    setupUi(this);
}

Preferences::~Preferences(){
}

// Various file dialogs
void Preferences::on_SelectMP3Binary_clicked(){
    QString fileName = QFileDialog::getOpenFileName(this,
                                                    tr("Please select the MP3Gain binary"),
                                                    "mp3gain",
                                                    tr("All Files (*)"));
    if (!fileName.isEmpty()) MP3GainPfad->setText(fileName);
    setIcons();
}


void Preferences::on_SelectMP4Binary_clicked(){
    QString fileName = QFileDialog::getOpenFileName(this,
                                                    tr("Please select the aacgain binary"),
                                                    "aacgain",
                                                    tr("All Files (*)"));
    if (!fileName.isEmpty()) MP4GainPfad->setText(fileName);
    setIcons();
}


void Preferences::on_SelectVorbisBinary_clicked(){
    QString fileName = QFileDialog::getOpenFileName(this,
                                                    tr("Please select the VorbisGain binary"),
                                                    "vorbisgain",
                                                    tr("All Files (*)"));
    if (!fileName.isEmpty()) VorbisGainPfad->setText(fileName);
    setIcons();
}


void Preferences::on_SelectFlacBinary_clicked(){
    QString fileName = QFileDialog::getOpenFileName(this,
                                                    tr("Please select the Metaflac binary"),
                                                    "metaflac",
                                                    tr("All Files (*)"));
    if (!fileName.isEmpty()) FlacGainPfad->setText(fileName);
    setIcons();
}



// Sets the right status icon
void Preferences::setIcons(){
    ismp3found->setPixmap(QFile::exists(MP3GainPfad->text())    ? QPixmap(":/Icons/available.png") : QPixmap(":/Icons/unavailable.png"));
    isaacfound->setPixmap(QFile::exists(MP4GainPfad->text())    ? QPixmap(":/Icons/available.png") : QPixmap(":/Icons/unavailable.png"));
    isoggfound->setPixmap(QFile::exists(VorbisGainPfad->text()) ? QPixmap(":/Icons/available.png") : QPixmap(":/Icons/unavailable.png"));
    isflacfound->setPixmap(QFile::exists(FlacGainPfad->text())  ? QPixmap(":/Icons/available.png") : QPixmap(":/Icons/unavailable.png"));
}

// Reset target volume to default
void Preferences::on_pushButton_Reset_clicked(){
    Pegel->setValue(89);
}
