% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GdObject-class.R
\docType{class}
\name{GdObject-class}
\alias{GdObject-class}
\alias{initialize,GdObject-method}
\alias{setPar,GdObject,character-method}
\alias{setPar,GdObject,list-method}
\alias{displayPars<-,GdObject,list-method}
\alias{getPar,GdObject,character-method}
\alias{getPar,GdObject,missing-method}
\alias{displayPars,GdObject,character-method}
\alias{displayPars,GdObject,missing-method}
\alias{coords,GdObject-method}
\alias{tags,GdObject-method}
\alias{subset,GdObject-method}
\alias{names,GdObject-method}
\alias{names<-,GdObject,character-method}
\alias{group}
\alias{group<-}
\alias{group,GdObject-method}
\alias{imageMap}
\alias{imageMap,GdObject-method}
\alias{imageMap<-}
\alias{imageMap<-,GdObject,ImageMapOrNULL-method}
\alias{drawAxis}
\alias{drawAxis,GdObject-method}
\alias{drawGrid}
\alias{drawGD}
\alias{gene}
\alias{gene<-}
\alias{symbol}
\alias{symbol<-}
\alias{transcript}
\alias{transcript<-}
\alias{exon}
\alias{exon<-}
\alias{feature}
\alias{feature<-}
\alias{identifier}
\alias{identifier<-}
\alias{chromosome}
\alias{chromosome,GdObject-method}
\alias{chromosome<-}
\alias{chromosome<-,GdObject-method}
\alias{position}
\alias{genome,GdObject-method}
\alias{genome<-,GdObject-method}
\alias{consolidateTrack}
\alias{consolidateTrack,GdObject-method}
\alias{stacking}
\alias{stacking<-}
\alias{stacks}
\alias{setStacks}
\alias{setStacks,GdObject-method}
\alias{setCoverage}
\title{GdObject class and methods}
\usage{
\S4method{initialize}{GdObject}(.Object, name, ...)

\S4method{setPar}{GdObject,character}(x, name, value, interactive = TRUE)

\S4method{setPar}{GdObject,list}(x, value, interactive = TRUE)

\S4method{displayPars}{GdObject,list}(x, recursive = FALSE) <- value

\S4method{getPar}{GdObject,character}(x, name, asIs = FALSE)

\S4method{getPar}{GdObject,missing}(x, hideInternal = TRUE)

\S4method{displayPars}{GdObject,character}(x, name)

\S4method{displayPars}{GdObject,missing}(x, hideInternal = TRUE)

\S4method{coords}{GdObject}(ImageMap)

\S4method{tags}{GdObject}(ImageMap)

\S4method{subset}{GdObject}(x, ...)

\S4method{names}{GdObject}(x)

\S4method{names}{GdObject,character}(x) <- value

group(GdObject, ...)

group(GdObject) <- value

\S4method{group}{GdObject}(GdObject)

imageMap(GdObject, ...)

\S4method{imageMap}{GdObject}(GdObject)

imageMap(GdObject) <- value

\S4method{imageMap}{GdObject,ImageMapOrNULL}(GdObject) <- value

drawAxis(GdObject, ...)

\S4method{drawAxis}{GdObject}(GdObject, ...)

drawGrid(GdObject, ...)

drawGD(GdObject, ...)

gene(GdObject, ...)

gene(GdObject) <- value

symbol(GdObject, ...)

symbol(GdObject) <- value

transcript(GdObject, ...)

transcript(GdObject) <- value

exon(GdObject, ...)

exon(GdObject) <- value

feature(GdObject, ...)

feature(GdObject) <- value

identifier(GdObject, ...)

identifier(GdObject) <- value

chromosome(GdObject, ...)

\S4method{chromosome}{GdObject}(GdObject)

chromosome(GdObject) <- value

\S4method{chromosome}{GdObject}(GdObject) <- value

position(GdObject, ...)

\S4method{genome}{GdObject}(x)

\S4method{genome}{GdObject}(x) <- value

consolidateTrack(GdObject, ...)

\S4method{consolidateTrack}{GdObject}(GdObject, alpha, ...)

stacking(GdObject, ...)

stacking(GdObject) <- value

stacks(GdObject, ...)

setStacks(GdObject, ...)

\S4method{setStacks}{GdObject}(GdObject, ...)

setCoverage(GdObject, ...)
}
\arguments{
\item{name}{Name of the retrieved parameter.}

\item{\dots}{Additional arguments.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{value}{Value to be set.}

\item{interactive}{\code{logical}}

\item{recursive}{\code{logical}}

\item{asIs}{\code{logical}}

\item{hideInternal}{\code{logical}}

\item{ImageMap}{Object of \code{ImageMap-class}, containing optional information
for an HTML image map.}

\item{GdObject}{Object of \code{GdObject-class}.}
}
\value{
A virtual class: No objects may be created from it.
}
\description{
The virtual parent class for all track items in the Gviz package.  This
class definition contains all the common entities that are needed for a
track to be plotted. During object instantiation for any of the sub-classes
inheriting from \code{GdObject}, this class' global initializer has to be
called in order to assure that all necessary settings are present.
}
\details{
\subsection{Display Parameters}{

The following display parameters are set for objects of class \code{GdObject}
upon instantiation, unless one or more of them have already been set by
one of the optional sub-class initializers, which always get precedence
over these global defaults. See \code{settings} for details on setting
graphical parameters for tracks.
\itemize{
\item \code{alpha=1} Numeric scalar. The transparency for all track items.
\item \code{alpha.title=NULL} Numeric scalar. The transparency for the title panel.
\item \code{background.legend="transparent"} Integer or character scalar.
The background colour for the legend.
\item \code{background.panel="transparent"} Integer or character scalar.
The background colour of the content panel.
\item \code{background.title="lightgray"} Integer or character scalar.
The background colour for the title panel.
\item \code{cex=1} Numeric scalar. The overall font expansion factor for all text
and glyphs, unless a more specific definition exists.
\item \code{cex.axis=NULL} Numeric scalar. The expansion factor for the axis
annotation. Defaults to \code{NULL}, in which case it is automatically determined
based on the available space.
\item \code{cex.title=NULL} Numeric scalar. The expansion factor for the title
panel. This effects the font size of both the title and the axis, if any.
Defaults to NULL, which means that the text size is automatically adjusted
to the available space.
\item \code{col="#0080FF"} Integer or character scalar. Default line colour setting
for all plotting elements, unless there is a more specific control defined
elsewhere.
\item \code{col.axis="white"} Integer or character scalar. The font and line colour
for the y axis, if any.
\item \code{col.border.title="white"} Integer or character scalar. The border
colour for the title panels.
\item \code{col.frame="lightgray"} Integer or character scalar. The line colour
used for the panel frame, if \code{frame==TRUE}
\item \code{col.grid="#808080"} Integer or character scalar. Default line colour
for grid lines, both when \code{type=="g"} in \code{DataTrack}s and when display
parameter \code{grid==TRUE}.
\item \code{col.line=NULL} Integer or character scalar. Default colours for plot
lines. Usually the same as the global col parameter.
\item \code{col.symbol=NULL} Integer or character scalar. Default colours for plot
symbols. Usually the same as the global col parameter.
\item \code{col.title="white"} (Aliases \code{fontcolour.title}) Integer or character
scalar. The border colour for the title panels
\item \code{collapse=TRUE} Boolean controlling whether to collapse the content of
the track to accommodate the minimum current device resolution.
See collapsing for details.
\item \code{fill="lightgray"} Integer or character scalar. Default fill colour
setting for all plotting elements, unless there is a more specific control
defined elsewhere.
\item \code{fontcolour="black"} Integer or character scalar. The font colour for
all text, unless a more specific definition exists.
\item \code{fontface=1} Integer or character scalar. The font face for all text,
unless a more specific definition exists.
\item \code{fontface.title=2} Integer or character scalar. The font face for the
title panels.
\item \code{fontfamily="sans"} Integer or character scalar. The font family for all
text, unless a more specific definition exists.
\item \code{fontfamily.title="sans"} Integer or character scalar. The font family
for the title panels.
\item \code{fontsize=12} Numeric scalar. The font size for all text, unless a more
specific definition exists.
\item \code{frame=FALSE} Boolean. Draw a frame around the track when plotting.
\item \code{grid=FALSE} Boolean, switching on/off the plotting of a grid.
\item \code{h=-1} Integer scalar. Parameter controlling the number of horizontal
grid lines, see panel.grid for details.
\item \code{lineheight=1} Numeric scalar. The font line height for all text, unless
a more specific definition exists.
\item \code{lty="solid"} Numeric scalar. Default line type setting for all plotting
elements, unless there is a more specific control defined elsewhere.
\item \code{lty.grid="solid"} Integer or character scalar. Default line type for
grid lines, both when \code{type=="g"} in \code{DataTrack}s and when display parameter
\code{grid==TRUE}.
\item \code{lwd=1} Numeric scalar. Default line width setting for all plotting
elements, unless there is a more specific control defined elsewhere.
\item \code{lwd.border.title=1} Integer scalar. The border width for the title
panels.
\item \code{lwd.grid=1} Numeric scalar. Default line width for grid lines, both
when \code{type=="g"} in \code{DataTrack}s and when display parameter \code{grid==TRUE}.
\item \code{lwd.title=1} Integer scalar. The border width for the title panels
\item \code{min.distance=1} Numeric scalar. The minimum pixel distance before
collapsing range items, only if \code{collapse==TRUE}. See collapsing for details.
\item \code{min.height=3} Numeric scalar. The minimum range height in pixels to
display. All ranges are expanded to this size in order to avoid rendering
issues. See collapsing for details.
\item \code{min.width=1} Numeric scalar. The minimum range width in pixels to
display. All ranges are expanded to this size in order to avoid rendering
issues. See collapsing for details.
\item \code{reverseStrand=FALSE} Logical scalar. Set up the plotting coordinates
in 3' -> 5' direction if \code{TRUE.} This will effectively mirror the plot
on the vertical axis.
\item \code{rotation=0} The rotation angle for all text unless a more specific
definition exists.
\item \code{rotation.title=90} (Aliases rotation.title) The rotation angle for
the text in the title panel. Even though this can be adjusted, the automatic
resizing of the title panel will currently not work, so use at own risk.
\item \code{showAxis=TRUE} Boolean controlling whether to plot a y axis (only
applies to track types where axes are implemented).
\item \code{showTitle=TRUE} Boolean controlling whether to plot a title panel.
Although this can be set individually for each track, in multi-track plots
as created by \code{plotTracks} there will still be an empty place holder in case
any of the other tracks include a title. The same holds true for axes. Note
that the the title panel background colour could be set to transparent in
order to completely hide it.
\item \code{size=1} Numeric scalar. The relative size of the track. Can be
overridden in the \code{plotTracks} function.
\item \code{v=-1} Integer scalar. Parameter controlling the number of vertical
grid lines, see panel.grid for details.
\item \code{...} additional display parameters are allowed. Those typically
take the value of a valid R colour descriptors. The parameter names will
later be matched to optional track item types as defined in the 'feature'
range attribute, and all tracks of the matched types are coloured
accordingly. See the documentation of the \code{GeneRegionTrack} and
\code{AnnotationTrack} classes as well as grouping for details.
}
}
}
\section{Functions}{
\itemize{
\item \code{initialize(GdObject)}: Initialize the object. This involves setting up a
new environment for the display parameters and filling it up with the current
settings. All arguments that have not been clobbered up by one of the
sub-class initializers are considered to be additional display parameters
and are also added to the environment. See \code{settings} for details on setting
graphical parameters for tracks.

\item \code{setPar(x = GdObject, value = character)}: set the single display parameter name to value.
Note that display parameters in the \code{GdObject-class} are pass-by-reference,
so no re-assignment to the symbol \code{obj} is necessary. See settings for
details on display parameters and customization.

\item \code{setPar(x = GdObject, value = list)}: set display parameters by the values of the named
list in value. Note that display parameters in the \code{GdObject-class} are
pass-by-reference, so no re-assignment to the symbol \code{obj} is necessary.
See settings for details on display parameters and customization.

\item \code{displayPars(x = GdObject) <- value}: set display parameters using the values of the
named list in \code{value}. See \code{settings} for details on display parameters
and customization.

\item \code{getPar(x = GdObject, name = character)}: alias for the \code{displayPars} method.
See \code{settings} for details on display parameters and customization.

\item \code{getPar(x = GdObject, name = missing)}: alias for the \code{displayPars} method.
See \code{settings} for details on display parameters and customization.

\item \code{displayPars(x = GdObject, name = character)}: list the value of the display parameter name.
See \code{settings} for details on display parameters and customization.

\item \code{displayPars(x = GdObject, name = missing)}: list the value of all available display parameters.
See \code{settings} for details on display parameters and customization.

\item \code{coords(GdObject)}: return the coordinates from the internal image map.

\item \code{tags(GdObject)}: return the tags from the internal image map.

\item \code{subset(GdObject)}: subset a \code{GdObject} by coordinates.
Most of the respective sub-classes inheriting from \code{GdObject} overwrite this
method, the default is to return the unaltered input object.

\item \code{names(GdObject)}: return the value of the \code{name} slot.

\item \code{names(x = GdObject) <- value}: set the value of the \code{name} slot.

\item \code{group()}: Generics for \code{group}.

\item \code{group(GdObject) <- value}: Generics for \verb{group<-}.

\item \code{group(GdObject)}: return grouping information for the individual
items in the track. Unless overwritten in one of the sub-classes,
this usually returns \code{NULL}.

\item \code{imageMap()}: Generics for \code{imageMap}.

\item \code{imageMap(GdObject)}: Extract the content of the \code{imageMap} slot.

\item \code{imageMap(GdObject) <- value}: Generics for \verb{imageMap<-}.

\item \code{imageMap(GdObject = GdObject) <- value}: Replace the content of the \code{imageMap} slot.

\item \code{drawAxis()}: Generics for \code{drawAxis}.

\item \code{drawAxis(GdObject)}: add a y-axis to the title panel of a track if
necessary. Unless overwritten in one of the sub-classes this usually
does not plot anything and returns \code{NULL}.

\item \code{drawGrid()}: Generics for \code{drawGrid}.

\item \code{drawGD()}: Generics for \code{drawGD}.

\item \code{gene()}: Generics for \code{gene}.

\item \code{gene(GdObject) <- value}: Generics for \verb{gene<-}.

\item \code{symbol()}: Generics for \code{symbol}.

\item \code{symbol(GdObject) <- value}: Generics for \verb{symbol<-}.

\item \code{transcript()}: Generics for \code{transcript}.

\item \code{transcript(GdObject) <- value}: Generics for \verb{transcript<-}.

\item \code{exon()}: Generics for \code{exon}.

\item \code{exon(GdObject) <- value}: Generics for \verb{exon<-}.

\item \code{feature()}: Generics for \code{feature}.

\item \code{feature(GdObject) <- value}: Generics for \verb{feature<-}.

\item \code{identifier()}: Generics for \code{identifier}.

\item \code{identifier(GdObject) <- value}: Generics for \verb{identifier<-}.

\item \code{chromosome()}: Generics for \code{chromosome}.

\item \code{chromosome(GdObject)}: return the chromosome for which the track is defined.

\item \code{chromosome(GdObject) <- value}: Generics for \code{chromosome}.

\item \code{chromosome(GdObject) <- value}: replace the value of the track's chromosome. This
has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{position()}: Generics for \code{position}.

\item \code{genome(GdObject)}: return the track's genome.

\item \code{genome(GdObject) <- value}: set the track's genome. Usually this has to be a
valid UCSC identifier, however this is not formally enforced here.

\item \code{consolidateTrack()}: Generics for \code{consolidateTrack}.

\item \code{consolidateTrack(GdObject)}: Consolidate.
Determine whether there is \code{alpha} settings or not, and add this information
as the internal display parameter \code{.__hasAlphaSupport}.

\item \code{stacking()}: Generics for \code{stacking}.

\item \code{stacking(GdObject) <- value}: Generics for \verb{stacking<-}.

\item \code{stacks()}: Generics for \code{stacks}.

\item \code{setStacks()}: Generics for ``.

\item \code{setStacks(GdObject)}: set stacks.

\item \code{setCoverage()}: Generics for ``.

}}
\section{Slots}{

\describe{
\item{\code{dp}}{Object of \code{DisplayPars-class}, the display settings controlling the
look and feel of a track. See settings for details on setting graphical
parameters for tracks.}

\item{\code{name}}{Object of class \code{character}, a human-readable name for the track
that will be used in the track's annotation panel if necessary.}

\item{\code{imageMap}}{Object of \code{ImageMap-class}, containing optional information
for an HTML image map. This will be created by the \code{drawGD} methods when the
track is plotted to a device and is usually not set by the user.}
}}

\examples{
## This is a reference class therefore we show below
## an example from AnnotationTrack:

## An empty object
AnnotationTrack()

## Construct from individual arguments
st <- c(2000000, 2070000, 2100000, 2160000)
ed <- c(2050000, 2130000, 2150000, 2170000)
str <- c("-", "+", "-", "-")
gr <- c("Group1", "Group2", "Group1", "Group3")

annTrack <- AnnotationTrack(
    start = st, end = ed, strand = str, chromosome = 7,
    genome = "hg19", feature = "test", group = gr,
    id = paste("annTrack item", 1:4),
    name = "generic annotation", stacking = "squish"
)
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(annTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(annTrack)
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
\keyword{internal}
