% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateMetadata.R
\name{validateMetadata}
\alias{validateMetadata}
\title{Validate metadata against a JSON schema}
\usage{
validateMetadata(metadata, schema = fetchMetadataSchema(), stringify = NULL)
}
\arguments{
\item{metadata}{Metadata to be checked.
This is usually an R object like a named list, but may also be a JSON-formatted string.}

\item{schema}{String containing a path to a schema.}

\item{stringify}{Logical scalar indicating whether to convert \code{metadata} to a JSON-formatted string.
Defaults to \code{TRUE} if \code{metadata} is not already a string.}
}
\value{
NULL is invisibly returned upon successful validation.
}
\description{
Validate metadata against a JSON schema for a SQLite database.
This ensures that it can be successfully inserted in the database in downstream indexing steps.
}
\examples{
metadata <- list(
    title="Fatherhood",
    description="Luke ich bin dein Vater.",
    sources=list(
       list(provider="GEO", id="GSE12345")
    ),
    taxonomy_id=list("9606"),
    genome=list("GRCm38"),
    maintainer_name="Darth Vader",
    maintainer_email="vader@empire.gov",
    bioconductor_version="3.10"
)

validateMetadata(metadata)

}
\seealso{
\code{\link{fetchMetadataSchema}}, to get the JSON schemas.

\code{\link{fetchMetadataDatabase}}, to obtain the SQLite database files.
}
\author{
Aaron Lun
}
