% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_weights}
\alias{get_weights}
\title{Get weights}
\usage{
get_weights(
  object,
  views = "all",
  factors = "all",
  abs = FALSE,
  scale = FALSE,
  as.data.frame = FALSE
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{factors}{character vector with the factor name(s) or numeric vector with the factor index(es). \cr
Default is "all".}

\item{abs}{logical indicating whether to take the absolute value of the weights.}

\item{scale}{logical indicating whether to scale all weights from -1 to 1 (or from 0 to 1 if \code{abs=TRUE}).}

\item{as.data.frame}{logical indicating whether to return a long data frame instead of a list of matrices. 
Default is \code{FALSE}.}
}
\value{
By default it returns a list where each element is a loading matrix with dimensionality (D,K), 
where D is the number of features and K is the number of factors. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE}, returns a long-formatted data frame with columns (view,feature,factor,value).
}
\description{
Extract the weights from the model.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Fetch weights in matrix format (a list, one matrix per view)
weights <- get_weights(model)

# Fetch weights for factor 1 and 2 and view 1
weights <- get_weights(model, views = 1, factors = c(1,2))

# Fetch weights in data.frame format
weights <- get_weights(model, as.data.frame = TRUE)
}
