% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\docType{data}
\name{opts_hooks}
\alias{opts_hooks}
\title{Hooks for code chunk options}
\format{An object of class \code{list} of length 6.}
\usage{
opts_hooks
}
\description{
Like \code{\link{knit_hooks}}, this object can be used to set hook functions
to manipulate chunk options.
}
\details{
For every code chunk, if the chunk option named, say, \code{FOO}, is not
\code{NULL}, and a hook function with the same name has been set via
\code{opts_hooks$set(FOO = function(options) { options })} (you can manipuate
the \code{options} argument in the function and return it), the hook function
will be called to update the chunk options.
}
\examples{
# make sure the figure width is no smaller than fig.height
opts_hooks$set(fig.width = function(options) {
    if (options$fig.width < options$fig.height) {
        options$fig.width = options$fig.height
    }
    options
})
# remove all hooks
opts_hooks$restore()
}
\references{
\url{https://yihui.org/knitr/hooks/}
}
\keyword{datasets}
