% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colnamesReplace.R
\name{colnamesReplace}
\alias{colnamesReplace}
\title{Replace column names with new names from a named vector}
\usage{
colnamesReplace(dat, newnames, oldnames = NULL, ..., lowercase = FALSE,
  verbose = FALSE)
}
\arguments{
\item{dat}{a data frame}

\item{newnames}{Can be a named vector of the form c(oldname1 =
"newname1", oldname2 = "newname") or it may be simply
c("newname1", "newname2") to correspond with the oldname
vector.}

\item{oldnames}{Optional. If supplied, must be same length as
newnames.}

\item{...}{Additional arguments that will be passed to R's
\code{gsub} function, which is used term-by-term inside this
function.}

\item{lowercase}{Default FALSE. Should all column names be
converted to lower case.}

\item{verbose}{Default FALSE. Want diagnostic output about column
name changes?}
}
\value{
a data frame
}
\description{
A convenience function to alter column names. Can be called from
code cleanup in the variable key system.
}
\examples{
set.seed(234234)
N <- 200
mydf <- data.frame(x5 = rnorm(N), x4 = rnorm(N), x3 = rnorm(N),
                   x2 = letters[sample(1:24, 200, replace = TRUE)],
                   x1 = factor(sample(c("cindy", "bobby", "marsha",
                                        "greg", "chris"), 200, replace = TRUE)),
                   x11 = 7,
                   x12 = 18,
                   x13 = 33,
                   stringsAsFactors = FALSE)
mydf2 <- colnamesReplace(mydf, newnames = c("x4" = "GLOPPY"))
mydf2 <- colnamesReplace(mydf, newnames = c("x4" = "GLOPPY", "USA" = "Interesting"), verbose = TRUE)
colnames(mydf2)
head(mydf3 <- colnamesReplace(mydf, newnames = c(x11 = "x12", x12 = "x13", x13 = "x20")))
head(mydf4 <- colnamesReplace(mydf, newnames = c(x12 = "x11", x11 = "x99", x13 = "x20")))
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
