% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_diseases.R
\name{get_similar_diseases}
\alias{get_similar_diseases}
\title{Retrieves diseases similar to an input disease and generates an \code{DataGeNET.DGN}}
\usage{
get_similar_diseases(disease, api_key = NULL, limit = 5)
}
\arguments{
\item{disease}{A disease or a list of disease identifiers (CUIs, MeSH, OMIMs...)
specific genes from DisGeNET. The genes non contained in DisGeNET will
be removed from the output.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{warnings}{By default \code{TRUE}. Change it to \code{FALSE} to not see
the warnings.}
}
\value{
An object of class \code{DataGeNET.Dis}
}
\description{
Given the disease identifier for one or multiple diseases retrieves their asssociated genes
from DisGeNET and creates an object of type \code{DataGeNET.DGN}.
}
\examples{
dis_res <- get_similar_diseases( "C0028754" )
}
