# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Services.idl.

use strict;

package Raritan::RPC::net::Services;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "net.Services:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::net::Services::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_INVALID_PARAMS => 1;

use Raritan::RPC::net::ServiceSettings;

sub getSettings($$) {
    my ($self, $servicesSettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSettings', $args);
    $$servicesSettings = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'servicesSettings'}}; $i0++) {
        $$servicesSettings->[$i0] = Raritan::RPC::net::ServiceSettings::decode($agent, $rsp->{'servicesSettings'}->[$i0]);
    }
}

use Raritan::RPC::net::ServiceSettings;

sub setSettings($$) {
    my ($self, $servicesSettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'servicesSettings'} = [];
    for (my $i0 = 0; $i0 <= $#{$servicesSettings}; $i0++) {
        $args->{'servicesSettings'}->[$i0] = Raritan::RPC::net::ServiceSettings::encode($servicesSettings->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('net.Services', 1, 0, 0, 'Raritan::RPC::net::Services');
1;
