#!/bin/bash -ex

PARENT="org.restlet.parent"

URL="http://maven.restlet.org/org/restlet/jse"
VERSION="$1"

DIR=`mktemp -d`
TAR=`mktemp`

check_file () {
    SOURCE=$1
    TARGET=$2
    TFILE=`mktemp`
    curl -s $1 > $TFILE
    sha1=`curl -s ${1}.sha1`
    echo -e "$sha1\t $TFILE" > $TFILE.sha1
    sha1sum -c $TFILE.sha1 >/dev/null
    mv $TFILE $TARGET
}

echo "Building orig.tar.gz from restlet maven source artifacts"

NAME=restlet-${VERSION}
(
    cd $DIR
    mkdir $NAME
    (
        cd $NAME
        check_file $URL/$PARENT/$VERSION/$PARENT-$VERSION.pom pom.xml
        ARTIFACTS=`grep "<module>" pom.xml | sed -e 's!.*>\(.*\)<.*!\1!g'`
        for ARTIFACT in $ARTIFACTS
        do
            if [ "$ARTIFACT" != "$PARENT" ]
            then
            JAR=`mktemp`
            (
                mkdir -p $ARTIFACT
                cd $ARTIFACT
                (
                    check_file $URL/$ARTIFACT/$VERSION/$ARTIFACT-$VERSION-sources.jar $JAR
                    mkdir -p src
                    ( 
                        cd src
                        jar -xf $JAR 
                    )
                    check_file $URL/$ARTIFACT/$VERSION/$ARTIFACT-$VERSION.pom pom.xml
                )                
            )
            fi
            rm -f $JAR
        done
    )
    # Scrub stuff which is not DFSG compliant or cruft
    find . -name "*.zip" -delete
    find . -name "*.war" -delete
    find . -name "dummy.jks" -delete
    tar -czf $TAR * 
)

mv $TAR ../restlet_${VERSION}.orig.tar.gz
rm -Rf $DIR $TAR

echo "Generated: ../restlet_${VERSION}.orig.tar.gz"
