// Copyright (C) 2008 - INRIA
// Copyright (C) 2009 - DIGITEO
// Copyright (C) 2012 - DIGITEO - Allan CORNET

mode(-1);
//setenv('DEBUG_SCILAB_DYNAMIC_LINK','YES')

function main_builder()

  TOOLBOX_NAME  = "metanet";
  TOOLBOX_TITLE = "metanet";
  toolbox_dir   = get_absolute_file_path("builder.sce");

  // Check Scilab's version
  // =============================================================================
  try
	  v = getversion("scilab");
  catch
	  error(gettext("Scilab 5.4 or more is required."));
  end

  if v(2) < 4 then
	  // new API in scilab 5.4
	  error(gettext('Scilab 5.4 or more is required.'));  
  end

  // Check modules_manager module availability
  // =============================================================================
  if ~isdef('tbx_build_loader') then
    error(msprintf(gettext('%s module not installed."), 'modules_manager'));
  end

  // Action
  // =============================================================================
  if ~with_module('xcos') then
    error(msprintf(gettext('%s module not installed."),'xcos'));
  end

  tbx_builder_macros(toolbox_dir);
  tbx_builder_src(toolbox_dir);
  tbx_builder_gateway(toolbox_dir);
  tbx_builder_help(toolbox_dir);

  if getos() == 'Windows' then 
    PATH = getenv('PATH');
    JAVA_HOME = SCI + '\java\jdk';
    JDK_PATH = SCI + '\java\jdk';
    JRE_PATH = SCI + '\java\jre';
    ANT_PATH = SCI + '\java\ant'
  
    setenv('JAVA_HOME', JAVA_HOME);
    setenv('JDK_PATH', JDK_PATH);
    setenv('JRE_PATH', JRE_PATH);
    setenv('ANT_PATH', ANT_PATH);
    setenv('PATH',ANT_PATH + '\bin;' + JDK_PATH + ';' + JRE_PATH + ';'+ PATH);
  end


  // This function creates a build.xml file for ant using Scilab javaclasspath
  function createbuildxml(pathtofile, projectname, description, libraryname)
    xmlcontents = [];
    xmlcontents($+1) = "<!-- Please do not edit -->"
    xmlcontents($+1) = "<!-- Generated by builder.sce -->"
    xmlcontents($+1) = "<project name="""+projectname+""" default=""jar"">";
    xmlcontents($+1) = "    <description>";
    xmlcontents($+1) = "    " + description;
    xmlcontents($+1) = "    </description>";
    xmlcontents($+1) = "";
    xmlcontents($+1) = "    <!-- Where the module should be created (modules/xxx/jar) -->";
    xmlcontents($+1) = "    <property name=""build.jar.dir""  value=""jar/"" />";
    xmlcontents($+1) = "    <!-- The building directory -->";
    xmlcontents($+1) = "    <property name=""build.dir"" location=""build/""/>";
    xmlcontents($+1) = "    <!-- Where builded classes will be generated -->";
    xmlcontents($+1) = "    <property name=""classes.dir"" location=""${build.dir}/classes"" />";
    xmlcontents($+1) = "";
    xmlcontents($+1) = "    <property name=""library.name"" value="""+libraryname+""" />";
    xmlcontents($+1) = ""
    xmlcontents($+1) = "    <!-- Where we can find the sources -->";
    xmlcontents($+1) = "    <property name=""src.dir""  location=""src/java/"" />";

    xmlcontents($+1) = "    <path id=""compile.classpath"">";
    jcp = javaclasspath();
    for k=1:size(jcp, 1)
      xmlcontents($+1) = "        <pathelement location="""+jcp(k)+"""/>";
    end
    xmlcontents($+1) = "    </path>";

    xmlcontents($+1) = "    <!-- Create the jar -->";
    xmlcontents($+1) = "    <target name=""jar"" description=""Build the jar file"" depends=""compile"">";
    xmlcontents($+1) = "        <jar destfile=""${build.jar.dir}/${library.name}"" basedir=""${classes.dir}"">";
    xmlcontents($+1) = "            <manifest>";
    xmlcontents($+1) = "            </manifest>";
    xmlcontents($+1) = "        </jar>";
    xmlcontents($+1) = "    </target>";
    xmlcontents($+1) = "    <!-- Compile sources -->";
    xmlcontents($+1) = "    <target name=""compile"" description=""Build sources"" depends=""init"">";
    xmlcontents($+1) = "        <javac";
    xmlcontents($+1) = "        srcdir=""${src.dir}""";
    xmlcontents($+1) = "        destdir=""${classes.dir}""";
    xmlcontents($+1) = "        classpathref=""compile.classpath""";
    xmlcontents($+1) = "        deprecation=""on""";
    xmlcontents($+1) = "        debug=""on""";
    xmlcontents($+1) = "        verbose=""off""";
    xmlcontents($+1) = "        listfiles=""on""";
    xmlcontents($+1) = "        source=""5""";
    xmlcontents($+1) = "        />";
    xmlcontents($+1) = "    </target>";
    xmlcontents($+1) = "    <target name=""init"" depends=""clean"">";
    xmlcontents($+1) = "        <mkdir dir=""${classes.dir}""/>";
    xmlcontents($+1) = "        <mkdir dir=""${build.jar.dir}""/>";
    xmlcontents($+1) = "        <!-- Create the time stamp -->";
    xmlcontents($+1) = "        <tstamp/>";
    xmlcontents($+1) = "    </target>";
    xmlcontents($+1) = "    <target name=""clean"">";
    xmlcontents($+1) = "        <delete dir=""${classes.dir}""/>";
    xmlcontents($+1) = "        <delete dir=""${build.jar.dir}""/>";
    xmlcontents($+1) = "    </target>";
    xmlcontents($+1) = "</project>";
    
    mputl(xmlcontents, pathtofile + "build.xml");
  endfunction

  // Compile Java file using ant
  if unix("ant -version") <> 0 then
    error("ant could not be found on your system.");
  end

  // load all need jars in classpath
  loadXcos();

  // Create the build.xml file
  createbuildxml(toolbox_dir, "metanet", "Build the METANET java class", "org.scilab.modules.metanet.jar");
  clear createbuildxml
  // Compile
  oldPath = pwd();
  cd(toolbox_dir);
  [rep,stat,err]=unix_g("ant");
  disp(rep);
  if stat <> 0 then
    cd(oldPath);
    error(err);
  end
  cd(oldPath);

  tbx_build_loader(TOOLBOX_NAME, toolbox_dir);
  tbx_build_cleaner(TOOLBOX_NAME, toolbox_dir);

endfunction
// =============================================================================
main_builder();
clear main_builder;
// =============================================================================
