#include "Palette.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/Palette.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

Copyright (C) 2012 - 2016 - Scilab Enterprises

This file is hereby licensed under the terms of the GNU GPL v2.0,
pursuant to article 5.3.4 of the CeCILL v.2.1.
This file was originally licensed under the terms of the CeCILL v2.1,
and continues to be available under such terms.
For more information, see the COPYING file which you should have received
along with this program.
*/

namespace org_scilab_modules_xcos_palette {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * Palette::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Palette::~Palette() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
Palette::Palette(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidloadPaljstringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidloadPaljstringjava_lang_StringID=NULL;
voidaddCategoryjobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID=NULL;
voidremovejobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidenablejobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID=NULL;
voidmovejobjectArray_java_lang_Stringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidgeneratePaletteIconjlonglongjstringjava_lang_StringID=NULL;
voidgetjobjectArray_java_lang_Stringjava_lang_StringID=NULL;


}

Palette::Palette(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidloadPaljstringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidloadPaljstringjava_lang_StringID=NULL;
voidaddCategoryjobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID=NULL;
voidremovejobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidenablejobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID=NULL;
voidmovejobjectArray_java_lang_Stringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID=NULL;
voidgeneratePaletteIconjlonglongjstringjava_lang_StringID=NULL;
voidgetjobjectArray_java_lang_Stringjava_lang_StringID=NULL;


}

// Generic methods

void Palette::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Palette");
}
}

void Palette::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Palette");
}
}
// Method(s)

void Palette::loadPal (JavaVM * jvm_, char const* name, char const* const* category, int categorySize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidloadPaljstringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "loadPal", "(Ljava/lang/String;[Ljava/lang/String;)V" ) ;
if (voidloadPaljstringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "loadPal");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray category_ = curEnv->NewObjectArray( categorySize, stringArrayClass, NULL);
if (category_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < categorySize; i++)
{
jstring TempString = curEnv->NewStringUTF( category[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( category_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidloadPaljstringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID ,name_, category_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(category_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::loadPal (JavaVM * jvm_, char const* name){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidloadPaljstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "loadPal", "(Ljava/lang/String;)V" ) ;
if (voidloadPaljstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "loadPal");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidloadPaljstringjava_lang_StringID ,name_);
                        curEnv->DeleteLocalRef(name_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::addCategory (JavaVM * jvm_, char const* const* name, int nameSize, bool visible){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidaddCategoryjobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "addCategory", "([Ljava/lang/String;Z)V" ) ;
if (voidaddCategoryjobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "addCategory");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray name_ = curEnv->NewObjectArray( nameSize, stringArrayClass, NULL);
if (name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < nameSize; i++)
{
jstring TempString = curEnv->NewStringUTF( name[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( name_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
jboolean visible_ = (static_cast<bool>(visible) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidaddCategoryjobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID ,name_, visible_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(name_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::remove (JavaVM * jvm_, char const* const* name, int nameSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidremovejobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "remove", "([Ljava/lang/String;)V" ) ;
if (voidremovejobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "remove");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray name_ = curEnv->NewObjectArray( nameSize, stringArrayClass, NULL);
if (name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < nameSize; i++)
{
jstring TempString = curEnv->NewStringUTF( name[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( name_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidremovejobjectArray_java_lang_Stringjava_lang_StringID ,name_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(name_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::enable (JavaVM * jvm_, char const* const* name, int nameSize, bool status){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidenablejobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "enable", "([Ljava/lang/String;Z)V" ) ;
if (voidenablejobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "enable");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray name_ = curEnv->NewObjectArray( nameSize, stringArrayClass, NULL);
if (name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < nameSize; i++)
{
jstring TempString = curEnv->NewStringUTF( name[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( name_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
jboolean status_ = (static_cast<bool>(status) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidenablejobjectArray_java_lang_Stringjava_lang_StringjbooleanbooleanID ,name_, status_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(name_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::move (JavaVM * jvm_, char const* const* source, int sourceSize, char const* const* target, int targetSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidmovejobjectArray_java_lang_Stringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "move", "([Ljava/lang/String;[Ljava/lang/String;)V" ) ;
if (voidmovejobjectArray_java_lang_Stringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "move");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray source_ = curEnv->NewObjectArray( sourceSize, stringArrayClass, NULL);
if (source_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < sourceSize; i++)
{
jstring TempString = curEnv->NewStringUTF( source[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( source_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}

// create java array of strings.
jobjectArray target_ = curEnv->NewObjectArray( targetSize, stringArrayClass, NULL);
if (target_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < targetSize; i++)
{
jstring TempString = curEnv->NewStringUTF( target[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( target_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidmovejobjectArray_java_lang_Stringjava_lang_StringjobjectArray_java_lang_Stringjava_lang_StringID ,source_, target_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(source_);
curEnv->DeleteLocalRef(target_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::generatePaletteIcon (JavaVM * jvm_, long long uid, char const* iconPath){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidgeneratePaletteIconjlonglongjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "generatePaletteIcon", "(JLjava/lang/String;)V" ) ;
if (voidgeneratePaletteIconjlonglongjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "generatePaletteIcon");
}

jstring iconPath_ = curEnv->NewStringUTF( iconPath );
if (iconPath != NULL && iconPath_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidgeneratePaletteIconjlonglongjstringjava_lang_StringID ,uid, iconPath_);
                        curEnv->DeleteLocalRef(iconPath_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Palette::get (JavaVM * jvm_, char const* const* path, int pathSize){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidgetjobjectArray_java_lang_Stringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "get", "([Ljava/lang/String;)V" ) ;
if (voidgetjobjectArray_java_lang_Stringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "get");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray path_ = curEnv->NewObjectArray( pathSize, stringArrayClass, NULL);
if (path_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < pathSize; i++)
{
jstring TempString = curEnv->NewStringUTF( path[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( path_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
                         curEnv->CallStaticVoidMethod(cls, voidgetjobjectArray_java_lang_Stringjava_lang_StringID ,path_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(path_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
