#version 330

layout(lines) in;
layout(triangle_strip, max_vertices = 128) out;
//layout(line_strip, max_vertices = 113) out;

const float PI = 3.14159265359f;

uniform mat3 normalMatrix;
uniform mat4 pmv;
uniform int segments = 2;
uniform float radius = 0.09f;
uniform vec3 dirx = vec3(3,0,0);
uniform vec3 diry = vec3(0,1,0);
uniform vec3 origin = vec3(0);
uniform vec3 SRorg = vec3(0);


in vec3 vPos[];
in float RightOrLeft[];

out vec3 Normal;
vec3 vert=vec3(0,0,0);
out float distance_from_start;
out float rl;
out float bondlength;
out gl_PerVertex{
  vec4 gl_Position;
};

void octaeder(vec4 mitte, float _lr, float _rad){
    vec3 cp[] = vec3[6](vec3( 0, 0, 1), vec3( 0, 0,-1), vec3( 0, 1, 0), vec3( 0,-1, 0), vec3( 1, 0, 0), vec3(-1, 0,-0));
    vec3 cn[] = vec3[6](vec3( 1,0,0), vec3(0,0, 1), vec3(0, 1,0), vec3(0,-1,0), vec3(0,0,-1), vec3(-1,0,0));
    int idx[] =int[19](0,4,3,1,-1, 0,2,4,1,-1, 0,5,2,1,-1, 0,3,5,1);
    for (int i = 0; i < idx.length(); i++){
      if (idx[i]<0){
        EndPrimitive();
        continue;
      }
      Normal = normalize(normalMatrix * cp[idx[i]]);
      vert = cp[idx[i]];
      rl = _lr;
      gl_Position = pmv * (vec4(_rad*cp[idx[i]],0) + mitte);
      EmitVertex();
    }
    EndPrimitive();

}

void cube(vec4 mitte, float _lr, float _rad){
//1, 0, 8,
  float a=inversesqrt(3.0);
  vec3 cp[] = vec3[8](vec3( a, a, a), vec3( a, a,-a), vec3( a,-a, a), vec3( a,-a,-a), vec3(-a, a, a), vec3(-a, a,-a), vec3(-a,-a, a), vec3(-a,-a,-a));
  vec3 cn[] = vec3[6](vec3( 1,0,0), vec3(0,0, 1), vec3(0, 1,0), vec3(0,-1,0), vec3(0,0,-1), vec3(-1,0,0));
  int idx[] =int[29](0,2,1,3,-1, 0,4,2,6,-1, 0,1,4,5,-1, 2,6,3,7,-1, 1,3,5,7,-1, 4,5,6,7);
  for (int i = 0; i < idx.length(); i++){
    if (idx[i]<0){
      EndPrimitive();
      continue;
    }
    Normal = normalize(normalMatrix * cn[i/5]);
    vert = cp[idx[i]];
    rl = _lr;
    gl_Position = pmv * (vec4(_rad*cp[idx[i]],0) + mitte);
    EmitVertex();
  }
  EndPrimitive();
}

void main(void){
    vec4 start = gl_in[0].gl_Position;
    vec4 end = gl_in[1].gl_Position;
    start.w = 1.0;
    end.w = 1.0;
    vec3 direction   = normalize(end.xyz - start.xyz);
    float l = length(end.xyz - start.xyz);
    vec3 lot = (abs(dot(direction, vec3(1, 0, 0))) > 0.8)?
                (abs(dot(direction, vec3(0, 1, 0))) > 0.8)?
                normalize(cross(direction, vec3(0, 0, 1))):
                normalize(cross(direction, vec3(0, 1, 0))):
                normalize(cross(direction, vec3(1, 0, 0)));
    vec3 lot2 = normalize(cross(direction,lot));
    vec3 r = vec3(0,0,0);
    float rad =  radius;
    vec3 oo=SRorg-origin;
    //if (!h_bonds) return;
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
        vert = start.xyz  + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalMatrix * r;
        bondlength = l;
        rl = RightOrLeft[0];
        distance_from_start = 0.0;
        EmitVertex();
        vert = end.xyz  + rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalMatrix * r;
        distance_from_start = 1.0;
        bondlength = l;
        rl = RightOrLeft[1];
        EmitVertex();
    }
    EndPrimitive();
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
        vert = oo + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalMatrix * r;
        bondlength = l;
        rl = 3;
        distance_from_start = 0.0;
        EmitVertex();
        vert = oo + dirx + 0.25 * rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalMatrix * r;
        distance_from_start = 1.0;
        bondlength = l;
        rl = 3;
        EmitVertex();
    }
    EndPrimitive();

    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
        vert = oo + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalMatrix * r;
        bondlength = l;
        rl = 4;
        distance_from_start = 0.0;
        EmitVertex();
        vert = oo + diry + 0.25 * rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalMatrix * r;
        distance_from_start = 1.0;
        bondlength = l;
        rl = 4;
        EmitVertex();
        }
    EndPrimitive();
    vec3 dirz= cross(dirx,diry);
    for (int i = 0; i <= 2*segments; i++){
        r = sin(PI * i / segments) * lot + cos(PI * i / segments) * lot2;
        vert = oo + rad * r;
        gl_Position = pmv* vec4(vert, 1);
        Normal = normalMatrix * r;
        bondlength = l;
        rl = 5;
        distance_from_start = 0.0;
        EmitVertex();
        vert = oo + dirz + 0.25 * rad * r;
        gl_Position = pmv* vec4(vert , 1);
        Normal = normalMatrix * r;
        distance_from_start = 1.0;
        bondlength = l;
        rl = 5;
    EmitVertex();
    }
    EndPrimitive();
    octaeder(start,RightOrLeft[0],2.5*rad);
    octaeder(end,RightOrLeft[1],2.5*rad);
}
