#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.org/sumo
# Copyright (C) 2009-2017 German Aerospace Center (DLR) and others.
# This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v2.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v20.html

# @file    rebuildConstants.py
# @author  Daniel Krajzewicz
# @author  Michael Behrisch
# @date    2009-07-24
# @version $Id$

"""
This script extracts definitions from <SUMO>/src/traci-server/TraCIConstants.h
 and builds an according constants definition python file "constants.py".
"""

from __future__ import print_function
from __future__ import absolute_import
import os
import datetime
from optparse import OptionParser

dirname = os.path.dirname(__file__)
optParser = OptionParser()
optParser.add_option("-j", "--java", action="store_true",
                     default=False, help="generate Java output")
optParser.add_option("-o", "--output", default=os.path.join(dirname, "constants.py"),
                     help="File to save constants into", metavar="FILE")
(options, args) = optParser.parse_args()


fdo = open(options.output, "w")
if options.java:
    print("/**", file=fdo)
else:
    print('"""', file=fdo)
print("""@file    %s
@author  generated by "%s"
@date    %s
@version $Id$

This script contains TraCI constant definitions from <SUMO_HOME>/src/traci-server/TraCIConstants.h.

SUMO, Simulation of Urban MObility; see http://sumo.dlr.de/
Copyright (C) 2009-2017 DLR (http://www.dlr.de/) and contributors

This file is part of SUMO.
SUMO is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.""" % (os.path.basename(options.output), os.path.basename(__file__), datetime.datetime.now()), file=fdo)

if options.java:
    print("*/\n", file=fdo)
else:
    print('"""\n', file=fdo)


def translateFile(filePath, fdo, start, item, end):
    with open(filePath) as fdi:
        started = False
        for line in fdi:
            if started:
                if line.find(end) >= 0:
                    started = False
                    if options.java:
                        fdo.write("}")
                    continue
                if options.java:
                    line = line.replace("//", "    //")
                else:
                    line = line.replace("///", "#").lstrip(" ")
                    line = line.replace("//", "# ").lstrip(" ")
                if line.find(item) >= 0:
                    if "=" in line:
                        fdo.write(line.strip().rstrip(",") + "\n")
                        continue
                    vals = line.split(" ")
                    if options.java:
                        line = "    public static final int " + \
                            vals[1] + " = " + vals[2].strip() + ";\n"
                    else:
                        line = vals[1] + " = " + vals[2]
                fdo.write(line)
            if line.find(start) >= 0:
                started = True
                if options.java:
                    fdo.write("public class TraCIConstants {")

srcDir = os.path.join(dirname, "..", "..", "src")
translateFile(os.path.join(srcDir, "traci-server", "TraCIConstants.h"),
              fdo, "#define TRACICONSTANTS_H", "#define ", "#endif")
translateFile(os.path.join(srcDir, "utils", "xml", "SUMOXMLDefinitions.h"),
              fdo, "enum LaneChangeAction {", "LCA_", "};")
fdo.close()
