#!/bin/sh
DEST_FILE="sources.cmake"

echo "# Generated by $0. Do not edit this file manually." > $DEST_FILE
echo "set(STK_SOURCES" >> $DEST_FILE
find src \
	-path 'src/bullet' -prune -o \
	-path 'src/ide' -prune -o \
	-path 'src/wiiuse' -prune -o \
	-regex ".*\.cpp" -print | sort >> $DEST_FILE
echo ")" >> $DEST_FILE

echo "set(STK_HEADERS" >> $DEST_FILE
find src \
	-path 'src/bullet' -prune -o \
	-path 'src/ide' -prune -o \
	-path 'src/wiiuse' -prune -o \
	-regex ".*\.hpp" -print | sort >> $DEST_FILE
echo ")" >> $DEST_FILE
