//
// Copyright 2019 Ettus Research, a National Instruments Brand
//
// SPDX-License-Identifier: GPL-3.0-or-later
//

#ifndef _COMMON_CONST_H
#define _COMMON_CONST_H

#define EEPROM_REV_UNRECOGNIZED -1

#define EEPROM_SIGNATURE_ADDR 0x0000
#define EEPROM_SIGNATURE_LENGTH 4

#define EEPROM_REV0_SIGNATURE 0xB2145943
#define EEPROM_REV1_OR_GREATER_SIGNATURE 0xB01A5943

#define EEPROM_REV0_VID_ADDR 0x0006
#define EEPROM_REV1_VID_ADDR 0x7F06
#define EEPROM_VID_LENGTH 2

#define VID_ETTUS_RESEARCH 0x2500
#define VID_NATIONAL_INSTRUMENTS 0x3923
#define VID_CYPRESS 0x04B4

#define EEPROM_REV0_PID_ADDR 0x0004
#define EEPROM_REV1_PID_ADDR 0x7F08
#define EEPROM_PID_LENGTH 2

#define PID_ETTUS_B200_B210 0x0020
#define PID_NI_USRP_2900 0x7813
#define PID_NI_USRP_2901 0x7814
#define PID_CYPRESS_DEFAULT 0x00F0

#define EEPROM_REV0_SERIAL_ADDR 0x04F7
#define EEPROM_REV1_SERIAL_ADDR 0x7F23
#define EEPROM_SERIAL_LENGTH 9

#define EEPROM_REV1_MAGIC_ADDR 0x7F00
#define EEPROM_MAGIC_LENGTH 2
#define EEPROM_EXPECTED_MAGIC 0xB200

#define EEPROM_REV1_REV_ADDR 0x7F02
#define EEPROM_REV_LENGTH 2
#define EEPROM_EXPECTED_REV 1

#define EEPROM_REV1_COMPAT_ADDR 0x7F04
#define EEPROM_COMPAT_LENGTH 2
#define EEPROM_EXPECTED_COMPAT 1

#endif /* _COMMON_CONST_H */
